// Copyright (c) 2001-2009 Objective Systems, Inc. (http://www.obj-sys.com) 
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available 
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//

/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).
 */

#ifndef RRLP_COMPONENTS_H
#define RRLP_COMPONENTS_H

#include <stdio.h>
#include <stdlib.h>
#include "rtkey.h"
#include "rtpersrc/asn1PerCppTypes.h"
#include "ASN1CSeqOfList.h"

/**
 * Header file for ASN.1 module RRLP-Components
 */
/**************************************************************/
/*                                                            */
/*  Accuracy                                                  */
/*                                                            */
/**************************************************************/

#define TV_Accuracy	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_Accuracy;

IMPORT_C int asn1PE_Accuracy (OSCTXT* pctxt, ASN1T_Accuracy value);

IMPORT_C int asn1PD_Accuracy (OSCTXT* pctxt, ASN1T_Accuracy* pvalue);

IMPORT_C void asn1Print_Accuracy
   (const char* name, ASN1T_Accuracy* pvalue);

/**************************************************************/
/*                                                            */
/*  AccuracyOpt                                               */
/*                                                            */
/**************************************************************/

#define TV_AccuracyOpt	(TM_UNIV|TM_CONS|16)

struct ASN1T_AccuracyOpt {
   struct {
      unsigned accuracyPresent : 1;
   } m;
   ASN1T_Accuracy accuracy;
   IMPORT_C ASN1T_AccuracyOpt ();
} ;

IMPORT_C int asn1PE_AccuracyOpt (OSCTXT* pctxt, ASN1T_AccuracyOpt* pvalue);

IMPORT_C int asn1PD_AccuracyOpt (OSCTXT* pctxt, ASN1T_AccuracyOpt* pvalue);

IMPORT_C void asn1Print_AccuracyOpt
   (const char* name, ASN1T_AccuracyOpt* pvalue);

/**************************************************************/
/*                                                            */
/*  MethodType                                                */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_MethodType_msAssisted         1
#define T_MethodType_msBased            2
#define T_MethodType_msBasedPref        3
#define T_MethodType_msAssistedPref     4

struct ASN1T_MethodType {
   int t;
   union {
      /* t = 1 */
      ASN1T_AccuracyOpt *msAssisted;
      /* t = 2 */
      ASN1T_Accuracy msBased;
      /* t = 3 */
      ASN1T_Accuracy msBasedPref;
      /* t = 4 */
      ASN1T_Accuracy msAssistedPref;
   } u;
} ;

IMPORT_C int asn1PE_MethodType (OSCTXT* pctxt, ASN1T_MethodType* pvalue);

IMPORT_C int asn1PD_MethodType (OSCTXT* pctxt, ASN1T_MethodType* pvalue);

IMPORT_C void asn1Print_MethodType
   (const char* name, ASN1T_MethodType* pvalue);

IMPORT_C void asn1Free_MethodType (OSCTXT *pctxt, ASN1T_MethodType* pvalue);

/**************************************************************/
/*                                                            */
/*  PositionMethod                                            */
/*                                                            */
/**************************************************************/

#define TV_PositionMethod	(TM_UNIV|TM_PRIM|10)

struct PositionMethod {
   enum Root {
      eotd = 0,
      gps = 1,
      gpsOrEOTD = 2
   } ;
} ;

typedef OSUINT32 ASN1T_PositionMethod;

IMPORT_C int asn1PE_PositionMethod (OSCTXT* pctxt, ASN1T_PositionMethod value);

IMPORT_C int asn1PD_PositionMethod (OSCTXT* pctxt, ASN1T_PositionMethod* pvalue);

IMPORT_C void asn1Print_PositionMethod
   (const char* name, ASN1T_PositionMethod* pvalue);

IMPORT_C const OSUTF8CHAR* ASN1T_PositionMethod_ToString (OSINT32 value);

IMPORT_C int ASN1T_PositionMethod_ToEnum (OSCTXT* pctxt,
   const OSUTF8CHAR* value, ASN1T_PositionMethod* pvalue);

/**************************************************************/
/*                                                            */
/*  MeasureResponseTime                                       */
/*                                                            */
/**************************************************************/

#define TV_MeasureResponseTime	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_MeasureResponseTime;

IMPORT_C int asn1PE_MeasureResponseTime (OSCTXT* pctxt, ASN1T_MeasureResponseTime value);

IMPORT_C int asn1PD_MeasureResponseTime (OSCTXT* pctxt, ASN1T_MeasureResponseTime* pvalue);

IMPORT_C void asn1Print_MeasureResponseTime
   (const char* name, ASN1T_MeasureResponseTime* pvalue);

/**************************************************************/
/*                                                            */
/*  UseMultipleSets                                           */
/*                                                            */
/**************************************************************/

#define TV_UseMultipleSets	(TM_UNIV|TM_PRIM|10)

struct UseMultipleSets {
   enum Root {
      multipleSets = 0,
      oneSet = 1
   } ;
} ;

typedef OSUINT32 ASN1T_UseMultipleSets;

IMPORT_C int asn1PE_UseMultipleSets (OSCTXT* pctxt, ASN1T_UseMultipleSets value);

IMPORT_C int asn1PD_UseMultipleSets (OSCTXT* pctxt, ASN1T_UseMultipleSets* pvalue);

IMPORT_C void asn1Print_UseMultipleSets
   (const char* name, ASN1T_UseMultipleSets* pvalue);

IMPORT_C const OSUTF8CHAR* ASN1T_UseMultipleSets_ToString (OSINT32 value);

IMPORT_C int ASN1T_UseMultipleSets_ToEnum (OSCTXT* pctxt,
   const OSUTF8CHAR* value, ASN1T_UseMultipleSets* pvalue);

/**************************************************************/
/*                                                            */
/*  EnvironmentCharacter                                      */
/*                                                            */
/**************************************************************/

#define TV_EnvironmentCharacter	(TM_UNIV|TM_PRIM|10)

struct EnvironmentCharacter {
   enum Root {
      badArea = 0,
      notBadArea = 1,
      mixedArea = 2
   } ;
} ;

typedef OSUINT32 ASN1T_EnvironmentCharacter;

IMPORT_C int asn1PE_EnvironmentCharacter (OSCTXT* pctxt, ASN1T_EnvironmentCharacter value);

IMPORT_C int asn1PD_EnvironmentCharacter (OSCTXT* pctxt, ASN1T_EnvironmentCharacter* pvalue);

IMPORT_C void asn1Print_EnvironmentCharacter
   (const char* name, ASN1T_EnvironmentCharacter* pvalue);

IMPORT_C const OSUTF8CHAR* ASN1T_EnvironmentCharacter_ToString (OSINT32 value);

IMPORT_C int ASN1T_EnvironmentCharacter_ToEnum (OSCTXT* pctxt,
   const OSUTF8CHAR* value, ASN1T_EnvironmentCharacter* pvalue);

/**************************************************************/
/*                                                            */
/*  PositionInstruct                                          */
/*                                                            */
/**************************************************************/

#define TV_PositionInstruct	(TM_UNIV|TM_CONS|16)

struct ASN1T_PositionInstruct {
   struct {
      unsigned environmentCharacterPresent : 1;
   } m;
   ASN1T_MethodType methodType;
   ASN1T_PositionMethod positionMethod;
   ASN1T_MeasureResponseTime measureResponseTime;
   ASN1T_UseMultipleSets useMultipleSets;
   ASN1T_EnvironmentCharacter environmentCharacter;
   IMPORT_C ASN1T_PositionInstruct ();
} ;

IMPORT_C int asn1PE_PositionInstruct (OSCTXT* pctxt, ASN1T_PositionInstruct* pvalue);

IMPORT_C int asn1PD_PositionInstruct (OSCTXT* pctxt, ASN1T_PositionInstruct* pvalue);

IMPORT_C void asn1Print_PositionInstruct
   (const char* name, ASN1T_PositionInstruct* pvalue);

IMPORT_C void asn1Free_PositionInstruct (OSCTXT *pctxt, ASN1T_PositionInstruct* pvalue);

/**************************************************************/
/*                                                            */
/*  BCCHCarrier                                               */
/*                                                            */
/**************************************************************/

#define TV_BCCHCarrier	(TM_UNIV|TM_PRIM|2)

typedef OSUINT16 ASN1T_BCCHCarrier;

IMPORT_C int asn1PE_BCCHCarrier (OSCTXT* pctxt, ASN1T_BCCHCarrier value);

IMPORT_C int asn1PD_BCCHCarrier (OSCTXT* pctxt, ASN1T_BCCHCarrier* pvalue);

IMPORT_C void asn1Print_BCCHCarrier
   (const char* name, ASN1T_BCCHCarrier* pvalue);

/**************************************************************/
/*                                                            */
/*  BSIC                                                      */
/*                                                            */
/**************************************************************/

#define TV_BSIC	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_BSIC;

IMPORT_C int asn1PE_BSIC (OSCTXT* pctxt, ASN1T_BSIC value);

IMPORT_C int asn1PD_BSIC (OSCTXT* pctxt, ASN1T_BSIC* pvalue);

IMPORT_C void asn1Print_BSIC
   (const char* name, ASN1T_BSIC* pvalue);

/**************************************************************/
/*                                                            */
/*  TimeSlotScheme                                            */
/*                                                            */
/**************************************************************/

#define TV_TimeSlotScheme	(TM_UNIV|TM_PRIM|10)

struct TimeSlotScheme {
   enum Root {
      equalLength = 0,
      variousLength = 1
   } ;
} ;

typedef OSUINT32 ASN1T_TimeSlotScheme;

IMPORT_C int asn1PE_TimeSlotScheme (OSCTXT* pctxt, ASN1T_TimeSlotScheme value);

IMPORT_C int asn1PD_TimeSlotScheme (OSCTXT* pctxt, ASN1T_TimeSlotScheme* pvalue);

IMPORT_C void asn1Print_TimeSlotScheme
   (const char* name, ASN1T_TimeSlotScheme* pvalue);

IMPORT_C const OSUTF8CHAR* ASN1T_TimeSlotScheme_ToString (OSINT32 value);

IMPORT_C int ASN1T_TimeSlotScheme_ToEnum (OSCTXT* pctxt,
   const OSUTF8CHAR* value, ASN1T_TimeSlotScheme* pvalue);

/**************************************************************/
/*                                                            */
/*  Ext_GeographicalInformation                               */
/*                                                            */
/**************************************************************/

#define TV_Ext_GeographicalInformation	(TM_UNIV|TM_PRIM|4)

struct ASN1T_Ext_GeographicalInformation {
   OSUINT32 numocts;
   OSOCTET data[20];
   // ctors
   ASN1T_Ext_GeographicalInformation () : numocts(0) {}
   ASN1T_Ext_GeographicalInformation (OSUINT32 _numocts, const OSOCTET* _data) :
      numocts (_numocts) {
      OSCRTLMEMCPY (data, _data, OSRTMIN (numocts, sizeof(data)));
   }
   ASN1T_Ext_GeographicalInformation (const char* cstring) {
      if (strlen(cstring) > 0) {
         numocts = OSRTMIN ((OSCRTLSTRLEN(cstring)+1), sizeof(data));
         OSCRTLSTRNCPY ((char*)data, cstring, sizeof(data));
      }
      else numocts = 0;
   }
   // assignment operators
   ASN1T_Ext_GeographicalInformation& operator= (const char* cstring) {
      if (strlen(cstring) > 0) {
         numocts = OSRTMIN ((OSCRTLSTRLEN(cstring)+1), sizeof(data));
         OSCRTLSTRNCPY ((char*)data, cstring, sizeof(data));
      }
      else numocts = 0;
      return *this;
   }
} ;

IMPORT_C int asn1PE_Ext_GeographicalInformation (OSCTXT* pctxt, ASN1T_Ext_GeographicalInformation* pvalue);

IMPORT_C int asn1PD_Ext_GeographicalInformation (OSCTXT* pctxt, ASN1T_Ext_GeographicalInformation* pvalue);

IMPORT_C void asn1Print_Ext_GeographicalInformation
   (const char* name, ASN1T_Ext_GeographicalInformation* pvalue);

/**************************************************************/
/*                                                            */
/*  BTSPosition                                               */
/*                                                            */
/**************************************************************/

#define TV_BTSPosition	(TM_UNIV|TM_PRIM|4)

typedef ASN1T_Ext_GeographicalInformation ASN1T_BTSPosition;

IMPORT_C int asn1PE_BTSPosition (OSCTXT* pctxt, ASN1T_BTSPosition* pvalue);

IMPORT_C int asn1PD_BTSPosition (OSCTXT* pctxt, ASN1T_BTSPosition* pvalue);

IMPORT_C void asn1Print_BTSPosition
   (const char* name, ASN1T_BTSPosition* pvalue);

/**************************************************************/
/*                                                            */
/*  ReferenceAssistData                                       */
/*                                                            */
/**************************************************************/

#define TV_ReferenceAssistData	(TM_UNIV|TM_CONS|16)

struct ASN1T_ReferenceAssistData {
   struct {
      unsigned btsPositionPresent : 1;
   } m;
   ASN1T_BCCHCarrier bcchCarrier;
   ASN1T_BSIC bsic;
   ASN1T_TimeSlotScheme timeSlotScheme;
   ASN1T_BTSPosition btsPosition;
   IMPORT_C ASN1T_ReferenceAssistData ();
} ;

IMPORT_C int asn1PE_ReferenceAssistData (OSCTXT* pctxt, ASN1T_ReferenceAssistData* pvalue);

IMPORT_C int asn1PD_ReferenceAssistData (OSCTXT* pctxt, ASN1T_ReferenceAssistData* pvalue);

IMPORT_C void asn1Print_ReferenceAssistData
   (const char* name, ASN1T_ReferenceAssistData* pvalue);

/**************************************************************/
/*                                                            */
/*  MultiFrameOffset                                          */
/*                                                            */
/**************************************************************/

#define TV_MultiFrameOffset	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_MultiFrameOffset;

IMPORT_C int asn1PE_MultiFrameOffset (OSCTXT* pctxt, ASN1T_MultiFrameOffset value);

IMPORT_C int asn1PD_MultiFrameOffset (OSCTXT* pctxt, ASN1T_MultiFrameOffset* pvalue);

IMPORT_C void asn1Print_MultiFrameOffset
   (const char* name, ASN1T_MultiFrameOffset* pvalue);

/**************************************************************/
/*                                                            */
/*  RoughRTD                                                  */
/*                                                            */
/**************************************************************/

#define TV_RoughRTD	(TM_UNIV|TM_PRIM|2)

typedef OSUINT16 ASN1T_RoughRTD;

IMPORT_C int asn1PE_RoughRTD (OSCTXT* pctxt, ASN1T_RoughRTD value);

IMPORT_C int asn1PD_RoughRTD (OSCTXT* pctxt, ASN1T_RoughRTD* pvalue);

IMPORT_C void asn1Print_RoughRTD
   (const char* name, ASN1T_RoughRTD* pvalue);

/**************************************************************/
/*                                                            */
/*  FineRTD                                                   */
/*                                                            */
/**************************************************************/

#define TV_FineRTD	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_FineRTD;

IMPORT_C int asn1PE_FineRTD (OSCTXT* pctxt, ASN1T_FineRTD value);

IMPORT_C int asn1PD_FineRTD (OSCTXT* pctxt, ASN1T_FineRTD* pvalue);

IMPORT_C void asn1Print_FineRTD
   (const char* name, ASN1T_FineRTD* pvalue);

/**************************************************************/
/*                                                            */
/*  RelDistance                                               */
/*                                                            */
/**************************************************************/

#define TV_RelDistance	(TM_UNIV|TM_PRIM|2)

typedef OSINT32 ASN1T_RelDistance;

IMPORT_C int asn1PE_RelDistance (OSCTXT* pctxt, ASN1T_RelDistance value);

IMPORT_C int asn1PD_RelDistance (OSCTXT* pctxt, ASN1T_RelDistance* pvalue);

IMPORT_C void asn1Print_RelDistance
   (const char* name, ASN1T_RelDistance* pvalue);

/**************************************************************/
/*                                                            */
/*  RelativeAlt                                               */
/*                                                            */
/**************************************************************/

#define TV_RelativeAlt	(TM_UNIV|TM_PRIM|2)

typedef OSINT16 ASN1T_RelativeAlt;

IMPORT_C int asn1PE_RelativeAlt (OSCTXT* pctxt, ASN1T_RelativeAlt value);

IMPORT_C int asn1PD_RelativeAlt (OSCTXT* pctxt, ASN1T_RelativeAlt* pvalue);

IMPORT_C void asn1Print_RelativeAlt
   (const char* name, ASN1T_RelativeAlt* pvalue);

/**************************************************************/
/*                                                            */
/*  ReferenceWGS84                                            */
/*                                                            */
/**************************************************************/

#define TV_ReferenceWGS84	(TM_UNIV|TM_CONS|16)

struct ASN1T_ReferenceWGS84 {
   struct {
      unsigned relativeAltPresent : 1;
   } m;
   ASN1T_RelDistance relativeNorth;
   ASN1T_RelDistance relativeEast;
   ASN1T_RelativeAlt relativeAlt;
   IMPORT_C ASN1T_ReferenceWGS84 ();
} ;

IMPORT_C int asn1PE_ReferenceWGS84 (OSCTXT* pctxt, ASN1T_ReferenceWGS84* pvalue);

IMPORT_C int asn1PD_ReferenceWGS84 (OSCTXT* pctxt, ASN1T_ReferenceWGS84* pvalue);

IMPORT_C void asn1Print_ReferenceWGS84
   (const char* name, ASN1T_ReferenceWGS84* pvalue);

/**************************************************************/
/*                                                            */
/*  CalcAssistanceBTS                                         */
/*                                                            */
/**************************************************************/

#define TV_CalcAssistanceBTS	(TM_UNIV|TM_CONS|16)

struct ASN1T_CalcAssistanceBTS {
   ASN1T_FineRTD fineRTD;
   ASN1T_ReferenceWGS84 referenceWGS84;
   IMPORT_C ASN1T_CalcAssistanceBTS ();
} ;

IMPORT_C int asn1PE_CalcAssistanceBTS (OSCTXT* pctxt, ASN1T_CalcAssistanceBTS* pvalue);

IMPORT_C int asn1PD_CalcAssistanceBTS (OSCTXT* pctxt, ASN1T_CalcAssistanceBTS* pvalue);

IMPORT_C void asn1Print_CalcAssistanceBTS
   (const char* name, ASN1T_CalcAssistanceBTS* pvalue);

/**************************************************************/
/*                                                            */
/*  MsrAssistBTS                                              */
/*                                                            */
/**************************************************************/

#define TV_MsrAssistBTS	(TM_UNIV|TM_CONS|16)

struct ASN1T_MsrAssistBTS {
   struct {
      unsigned calcAssistanceBTSPresent : 1;
   } m;
   ASN1T_BCCHCarrier bcchCarrier;
   ASN1T_BSIC bsic;
   ASN1T_MultiFrameOffset multiFrameOffset;
   ASN1T_TimeSlotScheme timeSlotScheme;
   ASN1T_RoughRTD roughRTD;
   ASN1T_CalcAssistanceBTS calcAssistanceBTS;
   IMPORT_C ASN1T_MsrAssistBTS ();
} ;

IMPORT_C int asn1PE_MsrAssistBTS (OSCTXT* pctxt, ASN1T_MsrAssistBTS* pvalue);

IMPORT_C int asn1PD_MsrAssistBTS (OSCTXT* pctxt, ASN1T_MsrAssistBTS* pvalue);

IMPORT_C void asn1Print_MsrAssistBTS
   (const char* name, ASN1T_MsrAssistBTS* pvalue);

/**************************************************************/
/*                                                            */
/*  SeqOfMsrAssistBTS                                         */
/*                                                            */
/**************************************************************/

#define TV_SeqOfMsrAssistBTS	(TM_UNIV|TM_CONS|16)

/* List of ASN1T_MsrAssistBTS */
typedef ASN1TSeqOfList ASN1T_SeqOfMsrAssistBTS;

class ASN1C_SeqOfMsrAssistBTS :
public ASN1CSeqOfList
{
protected:
   ASN1T_SeqOfMsrAssistBTS& msgData;
public:
   IMPORT_C ASN1C_SeqOfMsrAssistBTS (ASN1T_SeqOfMsrAssistBTS& data);
   IMPORT_C ASN1C_SeqOfMsrAssistBTS (OSRTMessageBufferIF& msgBuf
      , ASN1T_SeqOfMsrAssistBTS& data);
   ASN1C_SeqOfMsrAssistBTS (ASN1CType& ccobj, ASN1T_SeqOfMsrAssistBTS& data);
   IMPORT_C ASN1C_SeqOfMsrAssistBTS (OSRTContext &context, ASN1T_SeqOfMsrAssistBTS& data
      );
   void Append (ASN1T_MsrAssistBTS* elem);
   ASN1T_MsrAssistBTS* NewElement ();
} ;

IMPORT_C int asn1PE_SeqOfMsrAssistBTS (OSCTXT* pctxt, ASN1T_SeqOfMsrAssistBTS* pvalue);

IMPORT_C int asn1PD_SeqOfMsrAssistBTS (OSCTXT* pctxt, ASN1T_SeqOfMsrAssistBTS* pvalue);

IMPORT_C void asn1Print_SeqOfMsrAssistBTS
   (const char* name, ASN1T_SeqOfMsrAssistBTS* pvalue);

IMPORT_C void asn1Free_SeqOfMsrAssistBTS (OSCTXT *pctxt, ASN1T_SeqOfMsrAssistBTS* pvalue);

/**************************************************************/
/*                                                            */
/*  MsrAssistData                                             */
/*                                                            */
/**************************************************************/

#define TV_MsrAssistData	(TM_UNIV|TM_CONS|16)

struct ASN1T_MsrAssistData {
   ASN1T_SeqOfMsrAssistBTS msrAssistList;
   IMPORT_C ASN1T_MsrAssistData ();
} ;

IMPORT_C int asn1PE_MsrAssistData (OSCTXT* pctxt, ASN1T_MsrAssistData* pvalue);

IMPORT_C int asn1PD_MsrAssistData (OSCTXT* pctxt, ASN1T_MsrAssistData* pvalue);

IMPORT_C void asn1Print_MsrAssistData
   (const char* name, ASN1T_MsrAssistData* pvalue);

IMPORT_C void asn1Free_MsrAssistData (OSCTXT *pctxt, ASN1T_MsrAssistData* pvalue);

/**************************************************************/
/*                                                            */
/*  AssistBTSData                                             */
/*                                                            */
/**************************************************************/

#define TV_AssistBTSData	(TM_UNIV|TM_CONS|16)

struct ASN1T_AssistBTSData {
   struct {
      unsigned calcAssistanceBTSPresent : 1;
   } m;
   ASN1T_BSIC bsic;
   ASN1T_MultiFrameOffset multiFrameOffset;
   ASN1T_TimeSlotScheme timeSlotScheme;
   ASN1T_RoughRTD roughRTD;
   ASN1T_CalcAssistanceBTS calcAssistanceBTS;
   IMPORT_C ASN1T_AssistBTSData ();
} ;

IMPORT_C int asn1PE_AssistBTSData (OSCTXT* pctxt, ASN1T_AssistBTSData* pvalue);

IMPORT_C int asn1PD_AssistBTSData (OSCTXT* pctxt, ASN1T_AssistBTSData* pvalue);

IMPORT_C void asn1Print_AssistBTSData
   (const char* name, ASN1T_AssistBTSData* pvalue);

/**************************************************************/
/*                                                            */
/*  SystemInfoAssistBTS                                       */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_SystemInfoAssistBTS_notPresent 1
#define T_SystemInfoAssistBTS_present   2

struct ASN1T_SystemInfoAssistBTS {
   int t;
   union {
      /* t = 1 */
      /* t = 2 */
      ASN1T_AssistBTSData *present;
   } u;
} ;

IMPORT_C int asn1PE_SystemInfoAssistBTS (OSCTXT* pctxt, ASN1T_SystemInfoAssistBTS* pvalue);

IMPORT_C int asn1PD_SystemInfoAssistBTS (OSCTXT* pctxt, ASN1T_SystemInfoAssistBTS* pvalue);

IMPORT_C void asn1Print_SystemInfoAssistBTS
   (const char* name, ASN1T_SystemInfoAssistBTS* pvalue);

IMPORT_C void asn1Free_SystemInfoAssistBTS (OSCTXT *pctxt, ASN1T_SystemInfoAssistBTS* pvalue);

/**************************************************************/
/*                                                            */
/*  SeqOfSystemInfoAssistBTS                                  */
/*                                                            */
/**************************************************************/

#define TV_SeqOfSystemInfoAssistBTS	(TM_UNIV|TM_CONS|16)

/* List of ASN1T_SystemInfoAssistBTS */
typedef ASN1TSeqOfList ASN1T_SeqOfSystemInfoAssistBTS;

class ASN1C_SeqOfSystemInfoAssistBTS :
public ASN1CSeqOfList
{
protected:
   ASN1T_SeqOfSystemInfoAssistBTS& msgData;
public:
   IMPORT_C ASN1C_SeqOfSystemInfoAssistBTS (ASN1T_SeqOfSystemInfoAssistBTS& data);
   IMPORT_C ASN1C_SeqOfSystemInfoAssistBTS (OSRTMessageBufferIF& msgBuf
      , ASN1T_SeqOfSystemInfoAssistBTS& data);
   ASN1C_SeqOfSystemInfoAssistBTS (ASN1CType& ccobj, ASN1T_SeqOfSystemInfoAssistBTS& data);
   IMPORT_C ASN1C_SeqOfSystemInfoAssistBTS (OSRTContext &context
      , ASN1T_SeqOfSystemInfoAssistBTS& data);
   void Append (ASN1T_SystemInfoAssistBTS* elem);
   ASN1T_SystemInfoAssistBTS* NewElement ();
} ;

IMPORT_C int asn1PE_SeqOfSystemInfoAssistBTS (OSCTXT* pctxt, ASN1T_SeqOfSystemInfoAssistBTS* pvalue);

IMPORT_C int asn1PD_SeqOfSystemInfoAssistBTS (OSCTXT* pctxt, ASN1T_SeqOfSystemInfoAssistBTS* pvalue);

IMPORT_C void asn1Print_SeqOfSystemInfoAssistBTS
   (const char* name, ASN1T_SeqOfSystemInfoAssistBTS* pvalue);

IMPORT_C void asn1Free_SeqOfSystemInfoAssistBTS (OSCTXT *pctxt, ASN1T_SeqOfSystemInfoAssistBTS* pvalue);

/**************************************************************/
/*                                                            */
/*  SystemInfoAssistData                                      */
/*                                                            */
/**************************************************************/

#define TV_SystemInfoAssistData	(TM_UNIV|TM_CONS|16)

struct ASN1T_SystemInfoAssistData {
   ASN1T_SeqOfSystemInfoAssistBTS systemInfoAssistList;
   IMPORT_C ASN1T_SystemInfoAssistData ();
} ;

IMPORT_C int asn1PE_SystemInfoAssistData (OSCTXT* pctxt, ASN1T_SystemInfoAssistData* pvalue);

IMPORT_C int asn1PD_SystemInfoAssistData (OSCTXT* pctxt, ASN1T_SystemInfoAssistData* pvalue);

IMPORT_C void asn1Print_SystemInfoAssistData
   (const char* name, ASN1T_SystemInfoAssistData* pvalue);

IMPORT_C void asn1Free_SystemInfoAssistData (OSCTXT *pctxt, ASN1T_SystemInfoAssistData* pvalue);

/**************************************************************/
/*                                                            */
/*  GPSTOW23b                                                 */
/*                                                            */
/**************************************************************/

#define TV_GPSTOW23b	(TM_UNIV|TM_PRIM|2)

typedef OSUINT32 ASN1T_GPSTOW23b;

IMPORT_C int asn1PE_GPSTOW23b (OSCTXT* pctxt, ASN1T_GPSTOW23b value);

IMPORT_C int asn1PD_GPSTOW23b (OSCTXT* pctxt, ASN1T_GPSTOW23b* pvalue);

IMPORT_C void asn1Print_GPSTOW23b
   (const char* name, ASN1T_GPSTOW23b* pvalue);

/**************************************************************/
/*                                                            */
/*  GPSWeek                                                   */
/*                                                            */
/**************************************************************/

#define TV_GPSWeek	(TM_UNIV|TM_PRIM|2)

typedef OSUINT16 ASN1T_GPSWeek;

IMPORT_C int asn1PE_GPSWeek (OSCTXT* pctxt, ASN1T_GPSWeek value);

IMPORT_C int asn1PD_GPSWeek (OSCTXT* pctxt, ASN1T_GPSWeek* pvalue);

IMPORT_C void asn1Print_GPSWeek
   (const char* name, ASN1T_GPSWeek* pvalue);

/**************************************************************/
/*                                                            */
/*  GPSTime                                                   */
/*                                                            */
/**************************************************************/

#define TV_GPSTime	(TM_UNIV|TM_CONS|16)

struct ASN1T_GPSTime {
   ASN1T_GPSTOW23b gpsTOW23b;
   ASN1T_GPSWeek gpsWeek;
   IMPORT_C ASN1T_GPSTime ();
} ;

IMPORT_C int asn1PE_GPSTime (OSCTXT* pctxt, ASN1T_GPSTime* pvalue);

IMPORT_C int asn1PD_GPSTime (OSCTXT* pctxt, ASN1T_GPSTime* pvalue);

IMPORT_C void asn1Print_GPSTime
   (const char* name, ASN1T_GPSTime* pvalue);

/**************************************************************/
/*                                                            */
/*  FrameNumber                                               */
/*                                                            */
/**************************************************************/

#define TV_FrameNumber	(TM_UNIV|TM_PRIM|2)

typedef OSUINT32 ASN1T_FrameNumber;

IMPORT_C int asn1PE_FrameNumber (OSCTXT* pctxt, ASN1T_FrameNumber value);

IMPORT_C int asn1PD_FrameNumber (OSCTXT* pctxt, ASN1T_FrameNumber* pvalue);

IMPORT_C void asn1Print_FrameNumber
   (const char* name, ASN1T_FrameNumber* pvalue);

/**************************************************************/
/*                                                            */
/*  TimeSlot                                                  */
/*                                                            */
/**************************************************************/

#define TV_TimeSlot	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_TimeSlot;

IMPORT_C int asn1PE_TimeSlot (OSCTXT* pctxt, ASN1T_TimeSlot value);

IMPORT_C int asn1PD_TimeSlot (OSCTXT* pctxt, ASN1T_TimeSlot* pvalue);

IMPORT_C void asn1Print_TimeSlot
   (const char* name, ASN1T_TimeSlot* pvalue);

/**************************************************************/
/*                                                            */
/*  BitNumber                                                 */
/*                                                            */
/**************************************************************/

#define TV_BitNumber	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_BitNumber;

IMPORT_C int asn1PE_BitNumber (OSCTXT* pctxt, ASN1T_BitNumber value);

IMPORT_C int asn1PD_BitNumber (OSCTXT* pctxt, ASN1T_BitNumber* pvalue);

IMPORT_C void asn1Print_BitNumber
   (const char* name, ASN1T_BitNumber* pvalue);

/**************************************************************/
/*                                                            */
/*  GSMTime                                                   */
/*                                                            */
/**************************************************************/

#define TV_GSMTime	(TM_UNIV|TM_CONS|16)

struct ASN1T_GSMTime {
   ASN1T_BCCHCarrier bcchCarrier;
   ASN1T_BSIC bsic;
   ASN1T_FrameNumber frameNumber;
   ASN1T_TimeSlot timeSlot;
   ASN1T_BitNumber bitNumber;
   IMPORT_C ASN1T_GSMTime ();
} ;

IMPORT_C int asn1PE_GSMTime (OSCTXT* pctxt, ASN1T_GSMTime* pvalue);

IMPORT_C int asn1PD_GSMTime (OSCTXT* pctxt, ASN1T_GSMTime* pvalue);

IMPORT_C void asn1Print_GSMTime
   (const char* name, ASN1T_GSMTime* pvalue);

/**************************************************************/
/*                                                            */
/*  SatelliteID                                               */
/*                                                            */
/**************************************************************/

#define TV_SatelliteID	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_SatelliteID;

IMPORT_C int asn1PE_SatelliteID (OSCTXT* pctxt, ASN1T_SatelliteID value);

IMPORT_C int asn1PD_SatelliteID (OSCTXT* pctxt, ASN1T_SatelliteID* pvalue);

IMPORT_C void asn1Print_SatelliteID
   (const char* name, ASN1T_SatelliteID* pvalue);

/**************************************************************/
/*                                                            */
/*  TLMWord                                                   */
/*                                                            */
/**************************************************************/

#define TV_TLMWord	(TM_UNIV|TM_PRIM|2)

typedef OSUINT16 ASN1T_TLMWord;

IMPORT_C int asn1PE_TLMWord (OSCTXT* pctxt, ASN1T_TLMWord value);

IMPORT_C int asn1PD_TLMWord (OSCTXT* pctxt, ASN1T_TLMWord* pvalue);

IMPORT_C void asn1Print_TLMWord
   (const char* name, ASN1T_TLMWord* pvalue);

/**************************************************************/
/*                                                            */
/*  AntiSpoofFlag                                             */
/*                                                            */
/**************************************************************/

#define TV_AntiSpoofFlag	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_AntiSpoofFlag;

IMPORT_C int asn1PE_AntiSpoofFlag (OSCTXT* pctxt, ASN1T_AntiSpoofFlag value);

IMPORT_C int asn1PD_AntiSpoofFlag (OSCTXT* pctxt, ASN1T_AntiSpoofFlag* pvalue);

IMPORT_C void asn1Print_AntiSpoofFlag
   (const char* name, ASN1T_AntiSpoofFlag* pvalue);

/**************************************************************/
/*                                                            */
/*  AlertFlag                                                 */
/*                                                            */
/**************************************************************/

#define TV_AlertFlag	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_AlertFlag;

IMPORT_C int asn1PE_AlertFlag (OSCTXT* pctxt, ASN1T_AlertFlag value);

IMPORT_C int asn1PD_AlertFlag (OSCTXT* pctxt, ASN1T_AlertFlag* pvalue);

IMPORT_C void asn1Print_AlertFlag
   (const char* name, ASN1T_AlertFlag* pvalue);

/**************************************************************/
/*                                                            */
/*  TLMReservedBits                                           */
/*                                                            */
/**************************************************************/

#define TV_TLMReservedBits	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_TLMReservedBits;

IMPORT_C int asn1PE_TLMReservedBits (OSCTXT* pctxt, ASN1T_TLMReservedBits value);

IMPORT_C int asn1PD_TLMReservedBits (OSCTXT* pctxt, ASN1T_TLMReservedBits* pvalue);

IMPORT_C void asn1Print_TLMReservedBits
   (const char* name, ASN1T_TLMReservedBits* pvalue);

/**************************************************************/
/*                                                            */
/*  GPSTOWAssistElement                                       */
/*                                                            */
/**************************************************************/

#define TV_GPSTOWAssistElement	(TM_UNIV|TM_CONS|16)

struct ASN1T_GPSTOWAssistElement {
   ASN1T_SatelliteID satelliteID;
   ASN1T_TLMWord tlmWord;
   ASN1T_AntiSpoofFlag antiSpoof;
   ASN1T_AlertFlag alert;
   ASN1T_TLMReservedBits tlmRsvdBits;
   IMPORT_C ASN1T_GPSTOWAssistElement ();
} ;

IMPORT_C int asn1PE_GPSTOWAssistElement (OSCTXT* pctxt, ASN1T_GPSTOWAssistElement* pvalue);

IMPORT_C int asn1PD_GPSTOWAssistElement (OSCTXT* pctxt, ASN1T_GPSTOWAssistElement* pvalue);

IMPORT_C void asn1Print_GPSTOWAssistElement
   (const char* name, ASN1T_GPSTOWAssistElement* pvalue);

/**************************************************************/
/*                                                            */
/*  GPSTOWAssist                                              */
/*                                                            */
/**************************************************************/

#define TV_GPSTOWAssist	(TM_UNIV|TM_CONS|16)

/* List of ASN1T_GPSTOWAssistElement */
typedef ASN1TSeqOfList ASN1T_GPSTOWAssist;

class ASN1C_GPSTOWAssist :
public ASN1CSeqOfList
{
protected:
   ASN1T_GPSTOWAssist& msgData;
public:
   IMPORT_C ASN1C_GPSTOWAssist (ASN1T_GPSTOWAssist& data);
   IMPORT_C ASN1C_GPSTOWAssist (OSRTMessageBufferIF& msgBuf, ASN1T_GPSTOWAssist& data);
   ASN1C_GPSTOWAssist (ASN1CType& ccobj, ASN1T_GPSTOWAssist& data);
   IMPORT_C ASN1C_GPSTOWAssist (OSRTContext &context, ASN1T_GPSTOWAssist& data);
   void Append (ASN1T_GPSTOWAssistElement* elem);
   ASN1T_GPSTOWAssistElement* NewElement ();
} ;

IMPORT_C int asn1PE_GPSTOWAssist (OSCTXT* pctxt, ASN1T_GPSTOWAssist* pvalue);

IMPORT_C int asn1PD_GPSTOWAssist (OSCTXT* pctxt, ASN1T_GPSTOWAssist* pvalue);

IMPORT_C void asn1Print_GPSTOWAssist
   (const char* name, ASN1T_GPSTOWAssist* pvalue);

IMPORT_C void asn1Free_GPSTOWAssist (OSCTXT *pctxt, ASN1T_GPSTOWAssist* pvalue);

/**************************************************************/
/*                                                            */
/*  ReferenceTime                                             */
/*                                                            */
/**************************************************************/

#define TV_ReferenceTime	(TM_UNIV|TM_CONS|16)

struct ASN1T_ReferenceTime {
   struct {
      unsigned gsmTimePresent : 1;
      unsigned gpsTowAssistPresent : 1;
   } m;
   ASN1T_GPSTime gpsTime;
   ASN1T_GSMTime gsmTime;
   ASN1T_GPSTOWAssist gpsTowAssist;
   IMPORT_C ASN1T_ReferenceTime ();
} ;

IMPORT_C int asn1PE_ReferenceTime (OSCTXT* pctxt, ASN1T_ReferenceTime* pvalue);

IMPORT_C int asn1PD_ReferenceTime (OSCTXT* pctxt, ASN1T_ReferenceTime* pvalue);

IMPORT_C void asn1Print_ReferenceTime
   (const char* name, ASN1T_ReferenceTime* pvalue);

IMPORT_C void asn1Free_ReferenceTime (OSCTXT *pctxt, ASN1T_ReferenceTime* pvalue);

/**************************************************************/
/*                                                            */
/*  RefLocation                                               */
/*                                                            */
/**************************************************************/

#define TV_RefLocation	(TM_UNIV|TM_CONS|16)

struct ASN1T_RefLocation {
   ASN1T_Ext_GeographicalInformation threeDLocation;
   IMPORT_C ASN1T_RefLocation ();
} ;

IMPORT_C int asn1PE_RefLocation (OSCTXT* pctxt, ASN1T_RefLocation* pvalue);

IMPORT_C int asn1PD_RefLocation (OSCTXT* pctxt, ASN1T_RefLocation* pvalue);

IMPORT_C void asn1Print_RefLocation
   (const char* name, ASN1T_RefLocation* pvalue);

/**************************************************************/
/*                                                            */
/*  SatElement                                                */
/*                                                            */
/**************************************************************/

#define TV_SatElement	(TM_UNIV|TM_CONS|16)

struct ASN1T_SatElement {
   ASN1T_SatelliteID satelliteID;
   OSUINT8 iode;
   OSUINT8 udre;
   OSINT16 pseudoRangeCor;
   OSINT8 rangeRateCor;
   OSINT8 deltaPseudoRangeCor2;
   OSINT8 deltaRangeRateCor2;
   OSINT8 deltaPseudoRangeCor3;
   OSINT8 deltaRangeRateCor3;
   IMPORT_C ASN1T_SatElement ();
} ;

IMPORT_C int asn1PE_SatElement (OSCTXT* pctxt, ASN1T_SatElement* pvalue);

IMPORT_C int asn1PD_SatElement (OSCTXT* pctxt, ASN1T_SatElement* pvalue);

IMPORT_C void asn1Print_SatElement
   (const char* name, ASN1T_SatElement* pvalue);

/**************************************************************/
/*                                                            */
/*  SeqOfSatElement                                           */
/*                                                            */
/**************************************************************/

#define TV_SeqOfSatElement	(TM_UNIV|TM_CONS|16)

/* List of ASN1T_SatElement */
typedef ASN1TSeqOfList ASN1T_SeqOfSatElement;

class ASN1C_SeqOfSatElement :
public ASN1CSeqOfList
{
protected:
   ASN1T_SeqOfSatElement& msgData;
public:
   IMPORT_C ASN1C_SeqOfSatElement (ASN1T_SeqOfSatElement& data);
   IMPORT_C ASN1C_SeqOfSatElement (OSRTMessageBufferIF& msgBuf
      , ASN1T_SeqOfSatElement& data);
   ASN1C_SeqOfSatElement (ASN1CType& ccobj, ASN1T_SeqOfSatElement& data);
   IMPORT_C ASN1C_SeqOfSatElement (OSRTContext &context, ASN1T_SeqOfSatElement& data);
   void Append (ASN1T_SatElement* elem);
   ASN1T_SatElement* NewElement ();
} ;

IMPORT_C int asn1PE_SeqOfSatElement (OSCTXT* pctxt, ASN1T_SeqOfSatElement* pvalue);

IMPORT_C int asn1PD_SeqOfSatElement (OSCTXT* pctxt, ASN1T_SeqOfSatElement* pvalue);

IMPORT_C void asn1Print_SeqOfSatElement
   (const char* name, ASN1T_SeqOfSatElement* pvalue);

IMPORT_C void asn1Free_SeqOfSatElement (OSCTXT *pctxt, ASN1T_SeqOfSatElement* pvalue);

/**************************************************************/
/*                                                            */
/*  DGPSCorrections                                           */
/*                                                            */
/**************************************************************/

#define TV_DGPSCorrections	(TM_UNIV|TM_CONS|16)

struct ASN1T_DGPSCorrections {
   OSUINT32 gpsTOW;
   OSUINT8 status;
   ASN1T_SeqOfSatElement satList;
   IMPORT_C ASN1T_DGPSCorrections ();
} ;

IMPORT_C int asn1PE_DGPSCorrections (OSCTXT* pctxt, ASN1T_DGPSCorrections* pvalue);

IMPORT_C int asn1PD_DGPSCorrections (OSCTXT* pctxt, ASN1T_DGPSCorrections* pvalue);

IMPORT_C void asn1Print_DGPSCorrections
   (const char* name, ASN1T_DGPSCorrections* pvalue);

IMPORT_C void asn1Free_DGPSCorrections (OSCTXT *pctxt, ASN1T_DGPSCorrections* pvalue);

/**************************************************************/
/*                                                            */
/*  EphemerisSubframe1Reserved                                */
/*                                                            */
/**************************************************************/

#define TV_EphemerisSubframe1Reserved	(TM_UNIV|TM_CONS|16)

struct ASN1T_EphemerisSubframe1Reserved {
   OSUINT32 reserved1;
   OSUINT32 reserved2;
   OSUINT32 reserved3;
   OSUINT16 reserved4;
   IMPORT_C ASN1T_EphemerisSubframe1Reserved ();
} ;

IMPORT_C int asn1PE_EphemerisSubframe1Reserved (OSCTXT* pctxt, ASN1T_EphemerisSubframe1Reserved* pvalue);

IMPORT_C int asn1PD_EphemerisSubframe1Reserved (OSCTXT* pctxt, ASN1T_EphemerisSubframe1Reserved* pvalue);

IMPORT_C void asn1Print_EphemerisSubframe1Reserved
   (const char* name, ASN1T_EphemerisSubframe1Reserved* pvalue);

/**************************************************************/
/*                                                            */
/*  UncompressedEphemeris                                     */
/*                                                            */
/**************************************************************/

#define TV_UncompressedEphemeris	(TM_UNIV|TM_CONS|16)

struct ASN1T_UncompressedEphemeris {
   OSUINT8 ephemCodeOnL2;
   OSUINT8 ephemURA;
   OSUINT8 ephemSVhealth;
   OSUINT16 ephemIODC;
   OSUINT8 ephemL2Pflag;
   ASN1T_EphemerisSubframe1Reserved ephemSF1Rsvd;
   OSINT8 ephemTgd;
   OSUINT16 ephemToc;
   OSINT8 ephemAF2;
   OSINT16 ephemAF1;
   OSINT32 ephemAF0;
   OSINT16 ephemCrs;
   OSINT16 ephemDeltaN;
   OSINT32 ephemM0;
   OSINT16 ephemCuc;
   OSUINT32 ephemE;
   OSINT16 ephemCus;
   OSUINT32 ephemAPowerHalf;
   OSUINT16 ephemToe;
   OSUINT8 ephemFitFlag;
   OSUINT8 ephemAODA;
   OSINT16 ephemCic;
   OSINT32 ephemOmegaA0;
   OSINT16 ephemCis;
   OSINT32 ephemI0;
   OSINT16 ephemCrc;
   OSINT32 ephemW;
   OSINT32 ephemOmegaADot;
   OSINT16 ephemIDot;
   IMPORT_C ASN1T_UncompressedEphemeris ();
} ;

IMPORT_C int asn1PE_UncompressedEphemeris (OSCTXT* pctxt, ASN1T_UncompressedEphemeris* pvalue);

IMPORT_C int asn1PD_UncompressedEphemeris (OSCTXT* pctxt, ASN1T_UncompressedEphemeris* pvalue);

IMPORT_C void asn1Print_UncompressedEphemeris
   (const char* name, ASN1T_UncompressedEphemeris* pvalue);

/**************************************************************/
/*                                                            */
/*  SatStatus                                                 */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_SatStatus_newSatelliteAndModelUC 1
#define T_SatStatus_oldSatelliteAndModel 2
#define T_SatStatus_newNaviModelUC      3
#define T_SatStatus_extElem1            4

struct ASN1T_SatStatus {
   int t;
   union {
      /* t = 1 */
      ASN1T_UncompressedEphemeris *newSatelliteAndModelUC;
      /* t = 2 */
      /* t = 3 */
      ASN1T_UncompressedEphemeris *newNaviModelUC;
      /* t = 4 */
   } u;
} ;

IMPORT_C int asn1PE_SatStatus (OSCTXT* pctxt, ASN1T_SatStatus* pvalue);

IMPORT_C int asn1PD_SatStatus (OSCTXT* pctxt, ASN1T_SatStatus* pvalue);

IMPORT_C void asn1Print_SatStatus
   (const char* name, ASN1T_SatStatus* pvalue);

IMPORT_C void asn1Free_SatStatus (OSCTXT *pctxt, ASN1T_SatStatus* pvalue);

/**************************************************************/
/*                                                            */
/*  NavModelElement                                           */
/*                                                            */
/**************************************************************/

#define TV_NavModelElement	(TM_UNIV|TM_CONS|16)

struct ASN1T_NavModelElement {
   ASN1T_SatelliteID satelliteID;
   ASN1T_SatStatus satStatus;
   IMPORT_C ASN1T_NavModelElement ();
} ;

IMPORT_C int asn1PE_NavModelElement (OSCTXT* pctxt, ASN1T_NavModelElement* pvalue);

IMPORT_C int asn1PD_NavModelElement (OSCTXT* pctxt, ASN1T_NavModelElement* pvalue);

IMPORT_C void asn1Print_NavModelElement
   (const char* name, ASN1T_NavModelElement* pvalue);

IMPORT_C void asn1Free_NavModelElement (OSCTXT *pctxt, ASN1T_NavModelElement* pvalue);

/**************************************************************/
/*                                                            */
/*  SeqOfNavModelElement                                      */
/*                                                            */
/**************************************************************/

#define TV_SeqOfNavModelElement	(TM_UNIV|TM_CONS|16)

/* List of ASN1T_NavModelElement */
typedef ASN1TSeqOfList ASN1T_SeqOfNavModelElement;

class ASN1C_SeqOfNavModelElement :
public ASN1CSeqOfList
{
protected:
   ASN1T_SeqOfNavModelElement& msgData;
public:
   IMPORT_C ASN1C_SeqOfNavModelElement (ASN1T_SeqOfNavModelElement& data);
   IMPORT_C ASN1C_SeqOfNavModelElement (OSRTMessageBufferIF& msgBuf
      , ASN1T_SeqOfNavModelElement& data);
   ASN1C_SeqOfNavModelElement (ASN1CType& ccobj, ASN1T_SeqOfNavModelElement& data);
   IMPORT_C ASN1C_SeqOfNavModelElement (OSRTContext &context
      , ASN1T_SeqOfNavModelElement& data);
   void Append (ASN1T_NavModelElement* elem);
   ASN1T_NavModelElement* NewElement ();
} ;

IMPORT_C int asn1PE_SeqOfNavModelElement (OSCTXT* pctxt, ASN1T_SeqOfNavModelElement* pvalue);

IMPORT_C int asn1PD_SeqOfNavModelElement (OSCTXT* pctxt, ASN1T_SeqOfNavModelElement* pvalue);

IMPORT_C void asn1Print_SeqOfNavModelElement
   (const char* name, ASN1T_SeqOfNavModelElement* pvalue);

IMPORT_C void asn1Free_SeqOfNavModelElement (OSCTXT *pctxt, ASN1T_SeqOfNavModelElement* pvalue);

/**************************************************************/
/*                                                            */
/*  NavigationModelRrlp                                       */
/*                                                            */
/**************************************************************/

#define TV_NavigationModelRrlp	(TM_UNIV|TM_CONS|16)

struct ASN1T_NavigationModelRrlp {
   ASN1T_SeqOfNavModelElement navModelList;
   IMPORT_C ASN1T_NavigationModelRrlp ();
} ;

IMPORT_C int asn1PE_NavigationModelRrlp (OSCTXT* pctxt, ASN1T_NavigationModelRrlp* pvalue);

IMPORT_C int asn1PD_NavigationModelRrlp (OSCTXT* pctxt, ASN1T_NavigationModelRrlp* pvalue);

IMPORT_C void asn1Print_NavigationModelRrlp
   (const char* name, ASN1T_NavigationModelRrlp* pvalue);

IMPORT_C void asn1Free_NavigationModelRrlp (OSCTXT *pctxt, ASN1T_NavigationModelRrlp* pvalue);

/**************************************************************/
/*                                                            */
/*  IonosphericModel                                          */
/*                                                            */
/**************************************************************/

#define TV_IonosphericModel	(TM_UNIV|TM_CONS|16)

struct ASN1T_IonosphericModel {
   OSINT8 alfa0;
   OSINT8 alfa1;
   OSINT8 alfa2;
   OSINT8 alfa3;
   OSINT8 beta0;
   OSINT8 beta1;
   OSINT8 beta2;
   OSINT8 beta3;
   IMPORT_C ASN1T_IonosphericModel ();
} ;

IMPORT_C int asn1PE_IonosphericModel (OSCTXT* pctxt, ASN1T_IonosphericModel* pvalue);

IMPORT_C int asn1PD_IonosphericModel (OSCTXT* pctxt, ASN1T_IonosphericModel* pvalue);

IMPORT_C void asn1Print_IonosphericModel
   (const char* name, ASN1T_IonosphericModel* pvalue);

/**************************************************************/
/*                                                            */
/*  UTCModel                                                  */
/*                                                            */
/**************************************************************/

#define TV_UTCModel	(TM_UNIV|TM_CONS|16)

struct ASN1T_UTCModel {
   OSINT32 utcA1;
   OSINT32 utcA0;
   OSUINT8 utcTot;
   OSUINT8 utcWNt;
   OSINT8 utcDeltaTls;
   OSUINT8 utcWNlsf;
   OSINT8 utcDN;
   OSINT8 utcDeltaTlsf;
   IMPORT_C ASN1T_UTCModel ();
} ;

IMPORT_C int asn1PE_UTCModel (OSCTXT* pctxt, ASN1T_UTCModel* pvalue);

IMPORT_C int asn1PD_UTCModel (OSCTXT* pctxt, ASN1T_UTCModel* pvalue);

IMPORT_C void asn1Print_UTCModel
   (const char* name, ASN1T_UTCModel* pvalue);

/**************************************************************/
/*                                                            */
/*  AlmanacElement                                            */
/*                                                            */
/**************************************************************/

#define TV_AlmanacElement	(TM_UNIV|TM_CONS|16)

struct ASN1T_AlmanacElement {
   ASN1T_SatelliteID satelliteID;
   OSUINT16 almanacE;
   OSUINT8 alamanacToa;
   OSINT16 almanacKsii;
   OSINT16 almanacOmegaDot;
   OSUINT8 almanacSVhealth;
   OSUINT32 almanacAPowerHalf;
   OSINT32 almanacOmega0;
   OSINT32 almanacW;
   OSINT32 almanacM0;
   OSINT16 almanacAF0;
   OSINT16 almanacAF1;
   IMPORT_C ASN1T_AlmanacElement ();
} ;

IMPORT_C int asn1PE_AlmanacElement (OSCTXT* pctxt, ASN1T_AlmanacElement* pvalue);

IMPORT_C int asn1PD_AlmanacElement (OSCTXT* pctxt, ASN1T_AlmanacElement* pvalue);

IMPORT_C void asn1Print_AlmanacElement
   (const char* name, ASN1T_AlmanacElement* pvalue);

/**************************************************************/
/*                                                            */
/*  SeqOfAlmanacElement                                       */
/*                                                            */
/**************************************************************/

#define TV_SeqOfAlmanacElement	(TM_UNIV|TM_CONS|16)

/* List of ASN1T_AlmanacElement */
typedef ASN1TSeqOfList ASN1T_SeqOfAlmanacElement;

class ASN1C_SeqOfAlmanacElement :
public ASN1CSeqOfList
{
protected:
   ASN1T_SeqOfAlmanacElement& msgData;
public:
   IMPORT_C ASN1C_SeqOfAlmanacElement (ASN1T_SeqOfAlmanacElement& data);
   IMPORT_C ASN1C_SeqOfAlmanacElement (OSRTMessageBufferIF& msgBuf
      , ASN1T_SeqOfAlmanacElement& data);
   ASN1C_SeqOfAlmanacElement (ASN1CType& ccobj, ASN1T_SeqOfAlmanacElement& data);
   IMPORT_C ASN1C_SeqOfAlmanacElement (OSRTContext &context
      , ASN1T_SeqOfAlmanacElement& data);
   void Append (ASN1T_AlmanacElement* elem);
   ASN1T_AlmanacElement* NewElement ();
} ;

IMPORT_C int asn1PE_SeqOfAlmanacElement (OSCTXT* pctxt, ASN1T_SeqOfAlmanacElement* pvalue);

IMPORT_C int asn1PD_SeqOfAlmanacElement (OSCTXT* pctxt, ASN1T_SeqOfAlmanacElement* pvalue);

IMPORT_C void asn1Print_SeqOfAlmanacElement
   (const char* name, ASN1T_SeqOfAlmanacElement* pvalue);

IMPORT_C void asn1Free_SeqOfAlmanacElement (OSCTXT *pctxt, ASN1T_SeqOfAlmanacElement* pvalue);

/**************************************************************/
/*                                                            */
/*  Almanac                                                   */
/*                                                            */
/**************************************************************/

#define TV_Almanac	(TM_UNIV|TM_CONS|16)

struct ASN1T_Almanac {
   OSUINT8 alamanacWNa;
   ASN1T_SeqOfAlmanacElement almanacList;
   IMPORT_C ASN1T_Almanac ();
} ;

IMPORT_C int asn1PE_Almanac (OSCTXT* pctxt, ASN1T_Almanac* pvalue);

IMPORT_C int asn1PD_Almanac (OSCTXT* pctxt, ASN1T_Almanac* pvalue);

IMPORT_C void asn1Print_Almanac
   (const char* name, ASN1T_Almanac* pvalue);

IMPORT_C void asn1Free_Almanac (OSCTXT *pctxt, ASN1T_Almanac* pvalue);

/**************************************************************/
/*                                                            */
/*  TimeRelation                                              */
/*                                                            */
/**************************************************************/

#define TV_TimeRelation	(TM_UNIV|TM_CONS|16)

struct ASN1T_TimeRelation {
   struct {
      unsigned gsmTimePresent : 1;
   } m;
   ASN1T_GPSTOW23b gpsTOW;
   ASN1T_GSMTime gsmTime;
   IMPORT_C ASN1T_TimeRelation ();
} ;

IMPORT_C int asn1PE_TimeRelation (OSCTXT* pctxt, ASN1T_TimeRelation* pvalue);

IMPORT_C int asn1PD_TimeRelation (OSCTXT* pctxt, ASN1T_TimeRelation* pvalue);

IMPORT_C void asn1Print_TimeRelation
   (const char* name, ASN1T_TimeRelation* pvalue);

/**************************************************************/
/*                                                            */
/*  AddionalDopplerFields                                     */
/*                                                            */
/**************************************************************/

#define TV_AddionalDopplerFields	(TM_UNIV|TM_CONS|16)

struct ASN1T_AddionalDopplerFields {
   OSUINT8 doppler1;
   OSUINT8 dopplerUncertainty;
   IMPORT_C ASN1T_AddionalDopplerFields ();
} ;

IMPORT_C int asn1PE_AddionalDopplerFields (OSCTXT* pctxt, ASN1T_AddionalDopplerFields* pvalue);

IMPORT_C int asn1PD_AddionalDopplerFields (OSCTXT* pctxt, ASN1T_AddionalDopplerFields* pvalue);

IMPORT_C void asn1Print_AddionalDopplerFields
   (const char* name, ASN1T_AddionalDopplerFields* pvalue);

/**************************************************************/
/*                                                            */
/*  AddionalAngleFields                                       */
/*                                                            */
/**************************************************************/

#define TV_AddionalAngleFields	(TM_UNIV|TM_CONS|16)

struct ASN1T_AddionalAngleFields {
   OSUINT8 azimuth;
   OSUINT8 elevation;
   IMPORT_C ASN1T_AddionalAngleFields ();
} ;

IMPORT_C int asn1PE_AddionalAngleFields (OSCTXT* pctxt, ASN1T_AddionalAngleFields* pvalue);

IMPORT_C int asn1PD_AddionalAngleFields (OSCTXT* pctxt, ASN1T_AddionalAngleFields* pvalue);

IMPORT_C void asn1Print_AddionalAngleFields
   (const char* name, ASN1T_AddionalAngleFields* pvalue);

/**************************************************************/
/*                                                            */
/*  AcquisElement                                             */
/*                                                            */
/**************************************************************/

#define TV_AcquisElement	(TM_UNIV|TM_CONS|16)

struct ASN1T_AcquisElement {
   struct {
      unsigned addionalDopplerPresent : 1;
      unsigned addionalAnglePresent : 1;
   } m;
   ASN1T_SatelliteID svid;
   OSINT16 doppler0;
   ASN1T_AddionalDopplerFields addionalDoppler;
   OSUINT16 codePhase;
   OSUINT8 intCodePhase;
   OSUINT8 gpsBitNumber;
   OSUINT8 codePhaseSearchWindow;
   ASN1T_AddionalAngleFields addionalAngle;
   IMPORT_C ASN1T_AcquisElement ();
} ;

IMPORT_C int asn1PE_AcquisElement (OSCTXT* pctxt, ASN1T_AcquisElement* pvalue);

IMPORT_C int asn1PD_AcquisElement (OSCTXT* pctxt, ASN1T_AcquisElement* pvalue);

IMPORT_C void asn1Print_AcquisElement
   (const char* name, ASN1T_AcquisElement* pvalue);

/**************************************************************/
/*                                                            */
/*  SeqOfAcquisElement                                        */
/*                                                            */
/**************************************************************/

#define TV_SeqOfAcquisElement	(TM_UNIV|TM_CONS|16)

/* List of ASN1T_AcquisElement */
typedef ASN1TSeqOfList ASN1T_SeqOfAcquisElement;

class ASN1C_SeqOfAcquisElement :
public ASN1CSeqOfList
{
protected:
   ASN1T_SeqOfAcquisElement& msgData;
public:
   IMPORT_C ASN1C_SeqOfAcquisElement (ASN1T_SeqOfAcquisElement& data);
   IMPORT_C ASN1C_SeqOfAcquisElement (OSRTMessageBufferIF& msgBuf
      , ASN1T_SeqOfAcquisElement& data);
   ASN1C_SeqOfAcquisElement (ASN1CType& ccobj, ASN1T_SeqOfAcquisElement& data);
   IMPORT_C ASN1C_SeqOfAcquisElement (OSRTContext &context
      , ASN1T_SeqOfAcquisElement& data);
   void Append (ASN1T_AcquisElement* elem);
   ASN1T_AcquisElement* NewElement ();
} ;

IMPORT_C int asn1PE_SeqOfAcquisElement (OSCTXT* pctxt, ASN1T_SeqOfAcquisElement* pvalue);

IMPORT_C int asn1PD_SeqOfAcquisElement (OSCTXT* pctxt, ASN1T_SeqOfAcquisElement* pvalue);

IMPORT_C void asn1Print_SeqOfAcquisElement
   (const char* name, ASN1T_SeqOfAcquisElement* pvalue);

IMPORT_C void asn1Free_SeqOfAcquisElement (OSCTXT *pctxt, ASN1T_SeqOfAcquisElement* pvalue);

/**************************************************************/
/*                                                            */
/*  AcquisAssist                                              */
/*                                                            */
/**************************************************************/

#define TV_AcquisAssist	(TM_UNIV|TM_CONS|16)

struct ASN1T_AcquisAssist {
   ASN1T_TimeRelation timeRelation;
   ASN1T_SeqOfAcquisElement acquisList;
   IMPORT_C ASN1T_AcquisAssist ();
} ;

IMPORT_C int asn1PE_AcquisAssist (OSCTXT* pctxt, ASN1T_AcquisAssist* pvalue);

IMPORT_C int asn1PD_AcquisAssist (OSCTXT* pctxt, ASN1T_AcquisAssist* pvalue);

IMPORT_C void asn1Print_AcquisAssist
   (const char* name, ASN1T_AcquisAssist* pvalue);

IMPORT_C void asn1Free_AcquisAssist (OSCTXT *pctxt, ASN1T_AcquisAssist* pvalue);

/**************************************************************/
/*                                                            */
/*  SeqOf_BadSatelliteSet                                     */
/*                                                            */
/**************************************************************/

#define TV_SeqOf_BadSatelliteSet	(TM_UNIV|TM_CONS|16)

typedef struct ASN1T_SeqOf_BadSatelliteSet {
   OSUINT32 n;
   ASN1T_SatelliteID elem[32];
   ASN1T_SeqOf_BadSatelliteSet () : n (0) {}
} ASN1T_SeqOf_BadSatelliteSet;

IMPORT_C int asn1PE_SeqOf_BadSatelliteSet (OSCTXT* pctxt, ASN1T_SeqOf_BadSatelliteSet* pvalue);

IMPORT_C int asn1PD_SeqOf_BadSatelliteSet (OSCTXT* pctxt, ASN1T_SeqOf_BadSatelliteSet* pvalue);

IMPORT_C void asn1Print_SeqOf_BadSatelliteSet
   (const char* name, ASN1T_SeqOf_BadSatelliteSet* pvalue);

/**************************************************************/
/*                                                            */
/*  ControlHeader                                             */
/*                                                            */
/**************************************************************/

#define TV_ControlHeader	(TM_UNIV|TM_CONS|16)

struct ASN1T_ControlHeader {
   struct {
      unsigned referenceTimePresent : 1;
      unsigned refLocationPresent : 1;
      unsigned dgpsCorrectionsPresent : 1;
      unsigned navigationModelPresent : 1;
      unsigned ionosphericModelPresent : 1;
      unsigned utcModelPresent : 1;
      unsigned almanacPresent : 1;
      unsigned acquisAssistPresent : 1;
      unsigned realTimeIntegrityPresent : 1;
   } m;
   ASN1T_ReferenceTime referenceTime;
   ASN1T_RefLocation refLocation;
   ASN1T_DGPSCorrections dgpsCorrections;
   ASN1T_NavigationModelRrlp navigationModel;
   ASN1T_IonosphericModel ionosphericModel;
   ASN1T_UTCModel utcModel;
   ASN1T_Almanac almanac;
   ASN1T_AcquisAssist acquisAssist;
   ASN1T_SeqOf_BadSatelliteSet realTimeIntegrity;
   IMPORT_C ASN1T_ControlHeader ();
} ;

IMPORT_C int asn1PE_ControlHeader (OSCTXT* pctxt, ASN1T_ControlHeader* pvalue);

IMPORT_C int asn1PD_ControlHeader (OSCTXT* pctxt, ASN1T_ControlHeader* pvalue);

IMPORT_C void asn1Print_ControlHeader
   (const char* name, ASN1T_ControlHeader* pvalue);

IMPORT_C void asn1Free_ControlHeader (OSCTXT *pctxt, ASN1T_ControlHeader* pvalue);

/**************************************************************/
/*                                                            */
/*  GPS_AssistData                                            */
/*                                                            */
/**************************************************************/

#define TV_GPS_AssistData	(TM_UNIV|TM_CONS|16)

struct ASN1T_GPS_AssistData {
   ASN1T_ControlHeader controlHeader;
   IMPORT_C ASN1T_GPS_AssistData ();
} ;

IMPORT_C int asn1PE_GPS_AssistData (OSCTXT* pctxt, ASN1T_GPS_AssistData* pvalue);

IMPORT_C int asn1PD_GPS_AssistData (OSCTXT* pctxt, ASN1T_GPS_AssistData* pvalue);

IMPORT_C void asn1Print_GPS_AssistData
   (const char* name, ASN1T_GPS_AssistData* pvalue);

IMPORT_C void asn1Free_GPS_AssistData (OSCTXT *pctxt, ASN1T_GPS_AssistData* pvalue);

/**************************************************************/
/*                                                            */
/*  PrivateExtension                                          */
/*                                                            */
/**************************************************************/

#define TV_PrivateExtension	(TM_UNIV|TM_CONS|16)

struct ASN1T_PrivateExtension {
   struct {
      unsigned extTypePresent : 1;
   } m;
   ASN1TObjId extId;
   ASN1TOpenType extType;
   IMPORT_C ASN1T_PrivateExtension ();
} ;

IMPORT_C int asn1PE_PrivateExtension (OSCTXT* pctxt, ASN1T_PrivateExtension* pvalue);

IMPORT_C int asn1PD_PrivateExtension (OSCTXT* pctxt, ASN1T_PrivateExtension* pvalue);

IMPORT_C void asn1Print_PrivateExtension
   (const char* name, ASN1T_PrivateExtension* pvalue);

IMPORT_C void asn1Free_PrivateExtension (OSCTXT *pctxt, ASN1T_PrivateExtension* pvalue);

/**************************************************************/
/*                                                            */
/*  PrivateExtensionList                                      */
/*                                                            */
/**************************************************************/

#define TV_PrivateExtensionList	(TM_UNIV|TM_CONS|16)

/* List of ASN1T_PrivateExtension */
typedef ASN1TSeqOfList ASN1T_PrivateExtensionList;

class ASN1C_PrivateExtensionList :
public ASN1CSeqOfList
{
protected:
   ASN1T_PrivateExtensionList& msgData;
public:
   IMPORT_C ASN1C_PrivateExtensionList (ASN1T_PrivateExtensionList& data);
   IMPORT_C ASN1C_PrivateExtensionList (OSRTMessageBufferIF& msgBuf
      , ASN1T_PrivateExtensionList& data);
   ASN1C_PrivateExtensionList (ASN1CType& ccobj, ASN1T_PrivateExtensionList& data);
   IMPORT_C ASN1C_PrivateExtensionList (OSRTContext &context
      , ASN1T_PrivateExtensionList& data);
   void Append (ASN1T_PrivateExtension* elem);
   ASN1T_PrivateExtension* NewElement ();
} ;

IMPORT_C int asn1PE_PrivateExtensionList (OSCTXT* pctxt, ASN1T_PrivateExtensionList* pvalue);

IMPORT_C int asn1PD_PrivateExtensionList (OSCTXT* pctxt, ASN1T_PrivateExtensionList* pvalue);

IMPORT_C void asn1Print_PrivateExtensionList
   (const char* name, ASN1T_PrivateExtensionList* pvalue);

IMPORT_C void asn1Free_PrivateExtensionList (OSCTXT *pctxt, ASN1T_PrivateExtensionList* pvalue);

/**************************************************************/
/*                                                            */
/*  PCS_Extensions                                            */
/*                                                            */
/**************************************************************/

#define TV_PCS_Extensions	(TM_UNIV|TM_CONS|16)

struct ASN1T_PCS_Extensions {
   OSOCTET __dummy__;
   IMPORT_C ASN1T_PCS_Extensions ();
} ;

IMPORT_C int asn1PE_PCS_Extensions (OSCTXT* pctxt, ASN1T_PCS_Extensions* pvalue);

IMPORT_C int asn1PD_PCS_Extensions (OSCTXT* pctxt, ASN1T_PCS_Extensions* pvalue);

IMPORT_C void asn1Print_PCS_Extensions
   (const char* name, ASN1T_PCS_Extensions* pvalue);

/**************************************************************/
/*                                                            */
/*  ExtensionContainer                                        */
/*                                                            */
/**************************************************************/

#define TV_ExtensionContainer	(TM_UNIV|TM_CONS|16)

struct ASN1T_ExtensionContainer {
   struct {
      unsigned privateExtensionListPresent : 1;
      unsigned pcs_ExtensionsPresent : 1;
   } m;
   ASN1T_PrivateExtensionList privateExtensionList;
   ASN1T_PCS_Extensions pcs_Extensions;
   IMPORT_C ASN1T_ExtensionContainer ();
} ;

IMPORT_C int asn1PE_ExtensionContainer (OSCTXT* pctxt, ASN1T_ExtensionContainer* pvalue);

IMPORT_C int asn1PD_ExtensionContainer (OSCTXT* pctxt, ASN1T_ExtensionContainer* pvalue);

IMPORT_C void asn1Print_ExtensionContainer
   (const char* name, ASN1T_ExtensionContainer* pvalue);

IMPORT_C void asn1Free_ExtensionContainer (OSCTXT *pctxt, ASN1T_ExtensionContainer* pvalue);

/**************************************************************/
/*                                                            */
/*  ExpectedOTD                                               */
/*                                                            */
/**************************************************************/

#define TV_ExpectedOTD	(TM_UNIV|TM_PRIM|2)

typedef OSUINT16 ASN1T_ExpectedOTD;

IMPORT_C int asn1PE_ExpectedOTD (OSCTXT* pctxt, ASN1T_ExpectedOTD value);

IMPORT_C int asn1PD_ExpectedOTD (OSCTXT* pctxt, ASN1T_ExpectedOTD* pvalue);

IMPORT_C void asn1Print_ExpectedOTD
   (const char* name, ASN1T_ExpectedOTD* pvalue);

/**************************************************************/
/*                                                            */
/*  ExpOTDUncertainty                                         */
/*                                                            */
/**************************************************************/

#define TV_ExpOTDUncertainty	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_ExpOTDUncertainty;

IMPORT_C int asn1PE_ExpOTDUncertainty (OSCTXT* pctxt, ASN1T_ExpOTDUncertainty value);

IMPORT_C int asn1PD_ExpOTDUncertainty (OSCTXT* pctxt, ASN1T_ExpOTDUncertainty* pvalue);

IMPORT_C void asn1Print_ExpOTDUncertainty
   (const char* name, ASN1T_ExpOTDUncertainty* pvalue);

/**************************************************************/
/*                                                            */
/*  MsrAssistBTS_R98_ExpOTD                                   */
/*                                                            */
/**************************************************************/

#define TV_MsrAssistBTS_R98_ExpOTD	(TM_UNIV|TM_CONS|16)

struct ASN1T_MsrAssistBTS_R98_ExpOTD {
   ASN1T_ExpectedOTD expectedOTD;
   ASN1T_ExpOTDUncertainty expOTDUncertainty;
   IMPORT_C ASN1T_MsrAssistBTS_R98_ExpOTD ();
} ;

IMPORT_C int asn1PE_MsrAssistBTS_R98_ExpOTD (OSCTXT* pctxt, ASN1T_MsrAssistBTS_R98_ExpOTD* pvalue);

IMPORT_C int asn1PD_MsrAssistBTS_R98_ExpOTD (OSCTXT* pctxt, ASN1T_MsrAssistBTS_R98_ExpOTD* pvalue);

IMPORT_C void asn1Print_MsrAssistBTS_R98_ExpOTD
   (const char* name, ASN1T_MsrAssistBTS_R98_ExpOTD* pvalue);

/**************************************************************/
/*                                                            */
/*  SeqOfMsrAssistBTS_R98_ExpOTD                              */
/*                                                            */
/**************************************************************/

#define TV_SeqOfMsrAssistBTS_R98_ExpOTD	(TM_UNIV|TM_CONS|16)

/* List of ASN1T_MsrAssistBTS_R98_ExpOTD */
typedef ASN1TSeqOfList ASN1T_SeqOfMsrAssistBTS_R98_ExpOTD;

class ASN1C_SeqOfMsrAssistBTS_R98_ExpOTD :
public ASN1CSeqOfList
{
protected:
   ASN1T_SeqOfMsrAssistBTS_R98_ExpOTD& msgData;
public:
   IMPORT_C ASN1C_SeqOfMsrAssistBTS_R98_ExpOTD
       (ASN1T_SeqOfMsrAssistBTS_R98_ExpOTD& data);
   IMPORT_C ASN1C_SeqOfMsrAssistBTS_R98_ExpOTD (OSRTMessageBufferIF& msgBuf
      , ASN1T_SeqOfMsrAssistBTS_R98_ExpOTD& data);
   ASN1C_SeqOfMsrAssistBTS_R98_ExpOTD (ASN1CType& ccobj, ASN1T_SeqOfMsrAssistBTS_R98_ExpOTD& data);
   IMPORT_C ASN1C_SeqOfMsrAssistBTS_R98_ExpOTD (OSRTContext &context
      , ASN1T_SeqOfMsrAssistBTS_R98_ExpOTD& data);
   void Append (ASN1T_MsrAssistBTS_R98_ExpOTD* elem);
   ASN1T_MsrAssistBTS_R98_ExpOTD* NewElement ();
} ;

IMPORT_C int asn1PE_SeqOfMsrAssistBTS_R98_ExpOTD (OSCTXT* pctxt, ASN1T_SeqOfMsrAssistBTS_R98_ExpOTD* pvalue);

IMPORT_C int asn1PD_SeqOfMsrAssistBTS_R98_ExpOTD (OSCTXT* pctxt, ASN1T_SeqOfMsrAssistBTS_R98_ExpOTD* pvalue);

IMPORT_C void asn1Print_SeqOfMsrAssistBTS_R98_ExpOTD
   (const char* name, ASN1T_SeqOfMsrAssistBTS_R98_ExpOTD* pvalue);

IMPORT_C void asn1Free_SeqOfMsrAssistBTS_R98_ExpOTD (OSCTXT *pctxt, ASN1T_SeqOfMsrAssistBTS_R98_ExpOTD* pvalue);

/**************************************************************/
/*                                                            */
/*  MsrAssistData_R98_ExpOTD                                  */
/*                                                            */
/**************************************************************/

#define TV_MsrAssistData_R98_ExpOTD	(TM_UNIV|TM_CONS|16)

struct ASN1T_MsrAssistData_R98_ExpOTD {
   ASN1T_SeqOfMsrAssistBTS_R98_ExpOTD msrAssistList_R98_ExpOTD;
   IMPORT_C ASN1T_MsrAssistData_R98_ExpOTD ();
} ;

IMPORT_C int asn1PE_MsrAssistData_R98_ExpOTD (OSCTXT* pctxt, ASN1T_MsrAssistData_R98_ExpOTD* pvalue);

IMPORT_C int asn1PD_MsrAssistData_R98_ExpOTD (OSCTXT* pctxt, ASN1T_MsrAssistData_R98_ExpOTD* pvalue);

IMPORT_C void asn1Print_MsrAssistData_R98_ExpOTD
   (const char* name, ASN1T_MsrAssistData_R98_ExpOTD* pvalue);

IMPORT_C void asn1Free_MsrAssistData_R98_ExpOTD (OSCTXT *pctxt, ASN1T_MsrAssistData_R98_ExpOTD* pvalue);

/**************************************************************/
/*                                                            */
/*  AssistBTSData_R98_ExpOTD                                  */
/*                                                            */
/**************************************************************/

#define TV_AssistBTSData_R98_ExpOTD	(TM_UNIV|TM_CONS|16)

struct ASN1T_AssistBTSData_R98_ExpOTD {
   ASN1T_ExpectedOTD expectedOTD;
   ASN1T_ExpOTDUncertainty expOTDuncertainty;
   IMPORT_C ASN1T_AssistBTSData_R98_ExpOTD ();
} ;

IMPORT_C int asn1PE_AssistBTSData_R98_ExpOTD (OSCTXT* pctxt, ASN1T_AssistBTSData_R98_ExpOTD* pvalue);

IMPORT_C int asn1PD_AssistBTSData_R98_ExpOTD (OSCTXT* pctxt, ASN1T_AssistBTSData_R98_ExpOTD* pvalue);

IMPORT_C void asn1Print_AssistBTSData_R98_ExpOTD
   (const char* name, ASN1T_AssistBTSData_R98_ExpOTD* pvalue);

/**************************************************************/
/*                                                            */
/*  SystemInfoAssistBTS_R98_ExpOTD                            */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_SystemInfoAssistBTS_R98_ExpOTD_notPresent 1
#define T_SystemInfoAssistBTS_R98_ExpOTD_present 2

struct ASN1T_SystemInfoAssistBTS_R98_ExpOTD {
   int t;
   union {
      /* t = 1 */
      /* t = 2 */
      ASN1T_AssistBTSData_R98_ExpOTD *present;
   } u;
} ;

IMPORT_C int asn1PE_SystemInfoAssistBTS_R98_ExpOTD (OSCTXT* pctxt, ASN1T_SystemInfoAssistBTS_R98_ExpOTD* pvalue);

IMPORT_C int asn1PD_SystemInfoAssistBTS_R98_ExpOTD (OSCTXT* pctxt, ASN1T_SystemInfoAssistBTS_R98_ExpOTD* pvalue);

IMPORT_C void asn1Print_SystemInfoAssistBTS_R98_ExpOTD
   (const char* name, ASN1T_SystemInfoAssistBTS_R98_ExpOTD* pvalue);

IMPORT_C void asn1Free_SystemInfoAssistBTS_R98_ExpOTD (OSCTXT *pctxt, ASN1T_SystemInfoAssistBTS_R98_ExpOTD* pvalue);

/**************************************************************/
/*                                                            */
/*  SeqOfSystemInfoAssistBTS_R98_ExpOTD                       */
/*                                                            */
/**************************************************************/

#define TV_SeqOfSystemInfoAssistBTS_R98_ExpOTD	(TM_UNIV|TM_CONS|16)

/* List of ASN1T_SystemInfoAssistBTS_R98_ExpOTD */
typedef ASN1TSeqOfList ASN1T_SeqOfSystemInfoAssistBTS_R98_ExpOTD;

class ASN1C_SeqOfSystemInfoAssistBTS_R98_ExpOTD :
public ASN1CSeqOfList
{
protected:
   ASN1T_SeqOfSystemInfoAssistBTS_R98_ExpOTD& msgData;
public:
   IMPORT_C ASN1C_SeqOfSystemInfoAssistBTS_R98_ExpOTD
       (ASN1T_SeqOfSystemInfoAssistBTS_R98_ExpOTD& data);
   IMPORT_C ASN1C_SeqOfSystemInfoAssistBTS_R98_ExpOTD (OSRTMessageBufferIF& msgBuf
      , ASN1T_SeqOfSystemInfoAssistBTS_R98_ExpOTD& data);
   ASN1C_SeqOfSystemInfoAssistBTS_R98_ExpOTD (ASN1CType& ccobj, ASN1T_SeqOfSystemInfoAssistBTS_R98_ExpOTD& data);
   IMPORT_C ASN1C_SeqOfSystemInfoAssistBTS_R98_ExpOTD (OSRTContext &context
      , ASN1T_SeqOfSystemInfoAssistBTS_R98_ExpOTD& data);
   void Append (ASN1T_SystemInfoAssistBTS_R98_ExpOTD* elem);
   ASN1T_SystemInfoAssistBTS_R98_ExpOTD* NewElement ();
} ;

IMPORT_C int asn1PE_SeqOfSystemInfoAssistBTS_R98_ExpOTD (OSCTXT* pctxt, ASN1T_SeqOfSystemInfoAssistBTS_R98_ExpOTD* pvalue);

IMPORT_C int asn1PD_SeqOfSystemInfoAssistBTS_R98_ExpOTD (OSCTXT* pctxt, ASN1T_SeqOfSystemInfoAssistBTS_R98_ExpOTD* pvalue);

IMPORT_C void asn1Print_SeqOfSystemInfoAssistBTS_R98_ExpOTD
   (const char* name, ASN1T_SeqOfSystemInfoAssistBTS_R98_ExpOTD* pvalue);

IMPORT_C void asn1Free_SeqOfSystemInfoAssistBTS_R98_ExpOTD (OSCTXT *pctxt, ASN1T_SeqOfSystemInfoAssistBTS_R98_ExpOTD* pvalue);

/**************************************************************/
/*                                                            */
/*  SystemInfoAssistData_R98_ExpOTD                           */
/*                                                            */
/**************************************************************/

#define TV_SystemInfoAssistData_R98_ExpOTD	(TM_UNIV|TM_CONS|16)

struct ASN1T_SystemInfoAssistData_R98_ExpOTD {
   ASN1T_SeqOfSystemInfoAssistBTS_R98_ExpOTD systemInfoAssistListR98_ExpOTD;
   IMPORT_C ASN1T_SystemInfoAssistData_R98_ExpOTD ();
} ;

IMPORT_C int asn1PE_SystemInfoAssistData_R98_ExpOTD (OSCTXT* pctxt, ASN1T_SystemInfoAssistData_R98_ExpOTD* pvalue);

IMPORT_C int asn1PD_SystemInfoAssistData_R98_ExpOTD (OSCTXT* pctxt, ASN1T_SystemInfoAssistData_R98_ExpOTD* pvalue);

IMPORT_C void asn1Print_SystemInfoAssistData_R98_ExpOTD
   (const char* name, ASN1T_SystemInfoAssistData_R98_ExpOTD* pvalue);

IMPORT_C void asn1Free_SystemInfoAssistData_R98_ExpOTD (OSCTXT *pctxt, ASN1T_SystemInfoAssistData_R98_ExpOTD* pvalue);

/**************************************************************/
/*                                                            */
/*  Rel98_Ext_ExpOTD                                          */
/*                                                            */
/**************************************************************/

#define TV_Rel98_Ext_ExpOTD	(TM_UNIV|TM_CONS|16)

struct ASN1T_Rel98_Ext_ExpOTD {
   struct {
      unsigned msrAssistData_R98_ExpOTDPresent : 1;
      unsigned systemInfoAssistData_R98_ExpOTDPresent : 1;
   } m;
   ASN1T_MsrAssistData_R98_ExpOTD msrAssistData_R98_ExpOTD;
   ASN1T_SystemInfoAssistData_R98_ExpOTD systemInfoAssistData_R98_ExpOTD;
   IMPORT_C ASN1T_Rel98_Ext_ExpOTD ();
} ;

IMPORT_C int asn1PE_Rel98_Ext_ExpOTD (OSCTXT* pctxt, ASN1T_Rel98_Ext_ExpOTD* pvalue);

IMPORT_C int asn1PD_Rel98_Ext_ExpOTD (OSCTXT* pctxt, ASN1T_Rel98_Ext_ExpOTD* pvalue);

IMPORT_C void asn1Print_Rel98_Ext_ExpOTD
   (const char* name, ASN1T_Rel98_Ext_ExpOTD* pvalue);

IMPORT_C void asn1Free_Rel98_Ext_ExpOTD (OSCTXT *pctxt, ASN1T_Rel98_Ext_ExpOTD* pvalue);

/**************************************************************/
/*                                                            */
/*  GPSReferenceTimeUncertainty                               */
/*                                                            */
/**************************************************************/

#define TV_GPSReferenceTimeUncertainty	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_GPSReferenceTimeUncertainty;

IMPORT_C int asn1PE_GPSReferenceTimeUncertainty (OSCTXT* pctxt, ASN1T_GPSReferenceTimeUncertainty value);

IMPORT_C int asn1PD_GPSReferenceTimeUncertainty (OSCTXT* pctxt, ASN1T_GPSReferenceTimeUncertainty* pvalue);

IMPORT_C void asn1Print_GPSReferenceTimeUncertainty
   (const char* name, ASN1T_GPSReferenceTimeUncertainty* pvalue);

/**************************************************************/
/*                                                            */
/*  Rel98_MsrPosition_Req_Extension                           */
/*                                                            */
/**************************************************************/

#define TV_Rel98_MsrPosition_Req_Extension	(TM_UNIV|TM_CONS|16)

struct ASN1T_Rel98_MsrPosition_Req_Extension {
   struct {
      unsigned rel98_Ext_ExpOTDPresent : 1;
      unsigned gpsTimeAssistanceMeasurementRequestPresent : 1;
      unsigned gpsReferenceTimeUncertaintyPresent : 1;
   } m;
   ASN1T_Rel98_Ext_ExpOTD rel98_Ext_ExpOTD;
   ASN1T_GPSReferenceTimeUncertainty gpsReferenceTimeUncertainty;
   IMPORT_C ASN1T_Rel98_MsrPosition_Req_Extension ();
} ;

IMPORT_C int asn1PE_Rel98_MsrPosition_Req_Extension (OSCTXT* pctxt, ASN1T_Rel98_MsrPosition_Req_Extension* pvalue);

IMPORT_C int asn1PD_Rel98_MsrPosition_Req_Extension (OSCTXT* pctxt, ASN1T_Rel98_MsrPosition_Req_Extension* pvalue);

IMPORT_C void asn1Print_Rel98_MsrPosition_Req_Extension
   (const char* name, ASN1T_Rel98_MsrPosition_Req_Extension* pvalue);

IMPORT_C void asn1Free_Rel98_MsrPosition_Req_Extension (OSCTXT *pctxt, ASN1T_Rel98_MsrPosition_Req_Extension* pvalue);

/**************************************************************/
/*                                                            */
/*  Extended_reference                                        */
/*                                                            */
/**************************************************************/

#define TV_Extended_reference	(TM_UNIV|TM_CONS|16)

struct ASN1T_Extended_reference {
   OSUINT8 smlc_code;
   OSUINT32 transaction_ID;
   IMPORT_C ASN1T_Extended_reference ();
} ;

IMPORT_C int asn1PE_Extended_reference (OSCTXT* pctxt, ASN1T_Extended_reference* pvalue);

IMPORT_C int asn1PD_Extended_reference (OSCTXT* pctxt, ASN1T_Extended_reference* pvalue);

IMPORT_C void asn1Print_Extended_reference
   (const char* name, ASN1T_Extended_reference* pvalue);

/**************************************************************/
/*                                                            */
/*  Rel5_MsrPosition_Req_Extension                            */
/*                                                            */
/**************************************************************/

#define TV_Rel5_MsrPosition_Req_Extension	(TM_UNIV|TM_CONS|16)

struct ASN1T_Rel5_MsrPosition_Req_Extension {
   ASN1T_Extended_reference extended_reference;
   IMPORT_C ASN1T_Rel5_MsrPosition_Req_Extension ();
} ;

IMPORT_C int asn1PE_Rel5_MsrPosition_Req_Extension (OSCTXT* pctxt, ASN1T_Rel5_MsrPosition_Req_Extension* pvalue);

IMPORT_C int asn1PD_Rel5_MsrPosition_Req_Extension (OSCTXT* pctxt, ASN1T_Rel5_MsrPosition_Req_Extension* pvalue);

IMPORT_C void asn1Print_Rel5_MsrPosition_Req_Extension
   (const char* name, ASN1T_Rel5_MsrPosition_Req_Extension* pvalue);

/**************************************************************/
/*                                                            */
/*  MsrPosition_Req                                           */
/*                                                            */
/**************************************************************/

#define TV_MsrPosition_Req	(TM_UNIV|TM_CONS|16)

struct ASN1T_MsrPosition_Req {
   struct {
      unsigned referenceAssistDataPresent : 1;
      unsigned msrAssistDataPresent : 1;
      unsigned systemInfoAssistDataPresent : 1;
      unsigned gps_AssistDataPresent : 1;
      unsigned extensionContainerPresent : 1;
      unsigned rel98_MsrPosition_Req_extensionPresent : 1;
      unsigned rel5_MsrPosition_Req_extensionPresent : 1;
   } m;
   ASN1T_PositionInstruct positionInstruct;
   ASN1T_ReferenceAssistData referenceAssistData;
   ASN1T_MsrAssistData msrAssistData;
   ASN1T_SystemInfoAssistData systemInfoAssistData;
   ASN1T_GPS_AssistData gps_AssistData;
   ASN1T_ExtensionContainer extensionContainer;
   ASN1T_Rel98_MsrPosition_Req_Extension rel98_MsrPosition_Req_extension;
   ASN1T_Rel5_MsrPosition_Req_Extension rel5_MsrPosition_Req_extension;
   IMPORT_C ASN1T_MsrPosition_Req ();
} ;

IMPORT_C int asn1PE_MsrPosition_Req (OSCTXT* pctxt, ASN1T_MsrPosition_Req* pvalue);

IMPORT_C int asn1PD_MsrPosition_Req (OSCTXT* pctxt, ASN1T_MsrPosition_Req* pvalue);

IMPORT_C void asn1Print_MsrPosition_Req
   (const char* name, ASN1T_MsrPosition_Req* pvalue);

IMPORT_C void asn1Free_MsrPosition_Req (OSCTXT *pctxt, ASN1T_MsrPosition_Req* pvalue);

/**************************************************************/
/*                                                            */
/*  ReferenceRelation                                         */
/*                                                            */
/**************************************************************/

#define TV_ReferenceRelation	(TM_UNIV|TM_PRIM|10)

struct ReferenceRelation {
   enum Root {
      secondBTSThirdSet = 0,
      secondBTSSecondSet = 1,
      firstBTSFirstSet = 2
   } ;
} ;

typedef OSUINT32 ASN1T_ReferenceRelation;

IMPORT_C int asn1PE_ReferenceRelation (OSCTXT* pctxt, ASN1T_ReferenceRelation value);

IMPORT_C int asn1PD_ReferenceRelation (OSCTXT* pctxt, ASN1T_ReferenceRelation* pvalue);

IMPORT_C void asn1Print_ReferenceRelation
   (const char* name, ASN1T_ReferenceRelation* pvalue);

IMPORT_C const OSUTF8CHAR* ASN1T_ReferenceRelation_ToString (OSINT32 value);

IMPORT_C int ASN1T_ReferenceRelation_ToEnum (OSCTXT* pctxt,
   const OSUTF8CHAR* value, ASN1T_ReferenceRelation* pvalue);

/**************************************************************/
/*                                                            */
/*  MultipleSets                                              */
/*                                                            */
/**************************************************************/

#define TV_MultipleSets	(TM_UNIV|TM_CONS|16)

struct ASN1T_MultipleSets {
   struct {
      unsigned referenceRelationPresent : 1;
   } m;
   OSUINT8 nbrOfSets;
   OSUINT8 nbrOfReferenceBTSs;
   ASN1T_ReferenceRelation referenceRelation;
   IMPORT_C ASN1T_MultipleSets ();
} ;

IMPORT_C int asn1PE_MultipleSets (OSCTXT* pctxt, ASN1T_MultipleSets* pvalue);

IMPORT_C int asn1PD_MultipleSets (OSCTXT* pctxt, ASN1T_MultipleSets* pvalue);

IMPORT_C void asn1Print_MultipleSets
   (const char* name, ASN1T_MultipleSets* pvalue);

/**************************************************************/
/*                                                            */
/*  BSICAndCarrier                                            */
/*                                                            */
/**************************************************************/

#define TV_BSICAndCarrier	(TM_UNIV|TM_CONS|16)

struct ASN1T_BSICAndCarrier {
   ASN1T_BCCHCarrier carrier;
   ASN1T_BSIC bsic;
   IMPORT_C ASN1T_BSICAndCarrier ();
} ;

IMPORT_C int asn1PE_BSICAndCarrier (OSCTXT* pctxt, ASN1T_BSICAndCarrier* pvalue);

IMPORT_C int asn1PD_BSICAndCarrier (OSCTXT* pctxt, ASN1T_BSICAndCarrier* pvalue);

IMPORT_C void asn1Print_BSICAndCarrier
   (const char* name, ASN1T_BSICAndCarrier* pvalue);

/**************************************************************/
/*                                                            */
/*  CellID                                                    */
/*                                                            */
/**************************************************************/

#define TV_CellID	(TM_UNIV|TM_PRIM|2)

typedef OSUINT16 ASN1T_CellID;

IMPORT_C int asn1PE_CellID (OSCTXT* pctxt, ASN1T_CellID value);

IMPORT_C int asn1PD_CellID (OSCTXT* pctxt, ASN1T_CellID* pvalue);

IMPORT_C void asn1Print_CellID
   (const char* name, ASN1T_CellID* pvalue);

/**************************************************************/
/*                                                            */
/*  RequestIndex                                              */
/*                                                            */
/**************************************************************/

#define TV_RequestIndex	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_RequestIndex;

IMPORT_C int asn1PE_RequestIndex (OSCTXT* pctxt, ASN1T_RequestIndex value);

IMPORT_C int asn1PD_RequestIndex (OSCTXT* pctxt, ASN1T_RequestIndex* pvalue);

IMPORT_C void asn1Print_RequestIndex
   (const char* name, ASN1T_RequestIndex* pvalue);

/**************************************************************/
/*                                                            */
/*  SystemInfoIndex                                           */
/*                                                            */
/**************************************************************/

#define TV_SystemInfoIndex	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_SystemInfoIndex;

IMPORT_C int asn1PE_SystemInfoIndex (OSCTXT* pctxt, ASN1T_SystemInfoIndex value);

IMPORT_C int asn1PD_SystemInfoIndex (OSCTXT* pctxt, ASN1T_SystemInfoIndex* pvalue);

IMPORT_C void asn1Print_SystemInfoIndex
   (const char* name, ASN1T_SystemInfoIndex* pvalue);

/**************************************************************/
/*                                                            */
/*  LAC                                                       */
/*                                                            */
/**************************************************************/

#define TV_LAC	(TM_UNIV|TM_PRIM|2)

typedef OSUINT16 ASN1T_LAC;

IMPORT_C int asn1PE_LAC (OSCTXT* pctxt, ASN1T_LAC value);

IMPORT_C int asn1PD_LAC (OSCTXT* pctxt, ASN1T_LAC* pvalue);

IMPORT_C void asn1Print_LAC
   (const char* name, ASN1T_LAC* pvalue);

/**************************************************************/
/*                                                            */
/*  CellIDAndLAC                                              */
/*                                                            */
/**************************************************************/

#define TV_CellIDAndLAC	(TM_UNIV|TM_CONS|16)

struct ASN1T_CellIDAndLAC {
   ASN1T_LAC referenceLAC;
   ASN1T_CellID referenceCI;
   IMPORT_C ASN1T_CellIDAndLAC ();
} ;

IMPORT_C int asn1PE_CellIDAndLAC (OSCTXT* pctxt, ASN1T_CellIDAndLAC* pvalue);

IMPORT_C int asn1PD_CellIDAndLAC (OSCTXT* pctxt, ASN1T_CellIDAndLAC* pvalue);

IMPORT_C void asn1Print_CellIDAndLAC
   (const char* name, ASN1T_CellIDAndLAC* pvalue);

/**************************************************************/
/*                                                            */
/*  ReferenceIdentityType                                     */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_ReferenceIdentityType_bsicAndCarrier 1
#define T_ReferenceIdentityType_ci      2
#define T_ReferenceIdentityType_requestIndex 3
#define T_ReferenceIdentityType_systemInfoIndex 4
#define T_ReferenceIdentityType_ciAndLAC 5

struct ASN1T_ReferenceIdentityType {
   int t;
   union {
      /* t = 1 */
      ASN1T_BSICAndCarrier *bsicAndCarrier;
      /* t = 2 */
      ASN1T_CellID ci;
      /* t = 3 */
      ASN1T_RequestIndex requestIndex;
      /* t = 4 */
      ASN1T_SystemInfoIndex systemInfoIndex;
      /* t = 5 */
      ASN1T_CellIDAndLAC *ciAndLAC;
   } u;
} ;

IMPORT_C int asn1PE_ReferenceIdentityType (OSCTXT* pctxt, ASN1T_ReferenceIdentityType* pvalue);

IMPORT_C int asn1PD_ReferenceIdentityType (OSCTXT* pctxt, ASN1T_ReferenceIdentityType* pvalue);

IMPORT_C void asn1Print_ReferenceIdentityType
   (const char* name, ASN1T_ReferenceIdentityType* pvalue);

IMPORT_C void asn1Free_ReferenceIdentityType (OSCTXT *pctxt, ASN1T_ReferenceIdentityType* pvalue);

/**************************************************************/
/*                                                            */
/*  SeqOfReferenceIdentityType                                */
/*                                                            */
/**************************************************************/

#define TV_SeqOfReferenceIdentityType	(TM_UNIV|TM_CONS|16)

/* List of ASN1T_ReferenceIdentityType */
typedef ASN1TSeqOfList ASN1T_SeqOfReferenceIdentityType;

class ASN1C_SeqOfReferenceIdentityType :
public ASN1CSeqOfList
{
protected:
   ASN1T_SeqOfReferenceIdentityType& msgData;
public:
   IMPORT_C ASN1C_SeqOfReferenceIdentityType (ASN1T_SeqOfReferenceIdentityType& data);
   IMPORT_C ASN1C_SeqOfReferenceIdentityType (OSRTMessageBufferIF& msgBuf
      , ASN1T_SeqOfReferenceIdentityType& data);
   ASN1C_SeqOfReferenceIdentityType (ASN1CType& ccobj, ASN1T_SeqOfReferenceIdentityType& data);
   IMPORT_C ASN1C_SeqOfReferenceIdentityType (OSRTContext &context
      , ASN1T_SeqOfReferenceIdentityType& data);
   void Append (ASN1T_ReferenceIdentityType* elem);
   ASN1T_ReferenceIdentityType* NewElement ();
} ;

IMPORT_C int asn1PE_SeqOfReferenceIdentityType (OSCTXT* pctxt, ASN1T_SeqOfReferenceIdentityType* pvalue);

IMPORT_C int asn1PD_SeqOfReferenceIdentityType (OSCTXT* pctxt, ASN1T_SeqOfReferenceIdentityType* pvalue);

IMPORT_C void asn1Print_SeqOfReferenceIdentityType
   (const char* name, ASN1T_SeqOfReferenceIdentityType* pvalue);

IMPORT_C void asn1Free_SeqOfReferenceIdentityType (OSCTXT *pctxt, ASN1T_SeqOfReferenceIdentityType* pvalue);

/**************************************************************/
/*                                                            */
/*  ReferenceIdentity                                         */
/*                                                            */
/**************************************************************/

#define TV_ReferenceIdentity	(TM_UNIV|TM_CONS|16)

struct ASN1T_ReferenceIdentity {
   ASN1T_SeqOfReferenceIdentityType refBTSList;
   IMPORT_C ASN1T_ReferenceIdentity ();
} ;

IMPORT_C int asn1PE_ReferenceIdentity (OSCTXT* pctxt, ASN1T_ReferenceIdentity* pvalue);

IMPORT_C int asn1PD_ReferenceIdentity (OSCTXT* pctxt, ASN1T_ReferenceIdentity* pvalue);

IMPORT_C void asn1Print_ReferenceIdentity
   (const char* name, ASN1T_ReferenceIdentity* pvalue);

IMPORT_C void asn1Free_ReferenceIdentity (OSCTXT *pctxt, ASN1T_ReferenceIdentity* pvalue);

/**************************************************************/
/*                                                            */
/*  ModuloTimeSlot                                            */
/*                                                            */
/**************************************************************/

#define TV_ModuloTimeSlot	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_ModuloTimeSlot;

IMPORT_C int asn1PE_ModuloTimeSlot (OSCTXT* pctxt, ASN1T_ModuloTimeSlot value);

IMPORT_C int asn1PD_ModuloTimeSlot (OSCTXT* pctxt, ASN1T_ModuloTimeSlot* pvalue);

IMPORT_C void asn1Print_ModuloTimeSlot
   (const char* name, ASN1T_ModuloTimeSlot* pvalue);

/**************************************************************/
/*                                                            */
/*  RefQuality                                                */
/*                                                            */
/**************************************************************/

#define TV_RefQuality	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_RefQuality;

IMPORT_C int asn1PE_RefQuality (OSCTXT* pctxt, ASN1T_RefQuality value);

IMPORT_C int asn1PD_RefQuality (OSCTXT* pctxt, ASN1T_RefQuality* pvalue);

IMPORT_C void asn1Print_RefQuality
   (const char* name, ASN1T_RefQuality* pvalue);

/**************************************************************/
/*                                                            */
/*  NumOfMeasurements                                         */
/*                                                            */
/**************************************************************/

#define TV_NumOfMeasurements	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_NumOfMeasurements;

IMPORT_C int asn1PE_NumOfMeasurements (OSCTXT* pctxt, ASN1T_NumOfMeasurements value);

IMPORT_C int asn1PD_NumOfMeasurements (OSCTXT* pctxt, ASN1T_NumOfMeasurements* pvalue);

IMPORT_C void asn1Print_NumOfMeasurements
   (const char* name, ASN1T_NumOfMeasurements* pvalue);

/**************************************************************/
/*                                                            */
/*  TOA_MeasurementsOfRef                                     */
/*                                                            */
/**************************************************************/

#define TV_TOA_MeasurementsOfRef	(TM_UNIV|TM_CONS|16)

struct ASN1T_TOA_MeasurementsOfRef {
   ASN1T_RefQuality refQuality;
   ASN1T_NumOfMeasurements numOfMeasurements;
   IMPORT_C ASN1T_TOA_MeasurementsOfRef ();
} ;

IMPORT_C int asn1PE_TOA_MeasurementsOfRef (OSCTXT* pctxt, ASN1T_TOA_MeasurementsOfRef* pvalue);

IMPORT_C int asn1PD_TOA_MeasurementsOfRef (OSCTXT* pctxt, ASN1T_TOA_MeasurementsOfRef* pvalue);

IMPORT_C void asn1Print_TOA_MeasurementsOfRef
   (const char* name, ASN1T_TOA_MeasurementsOfRef* pvalue);

/**************************************************************/
/*                                                            */
/*  StdResolution                                             */
/*                                                            */
/**************************************************************/

#define TV_StdResolution	(TM_UNIV|TM_PRIM|2)

typedef OSUINT8 ASN1T_StdResolution;

IMPORT_C int asn1PE_StdResolution (OSCTXT* pctxt, ASN1T_StdResolution value);

IMPORT_C int asn1PD_StdResolution (OSCTXT* pctxt, ASN1T_StdResolution* pvalue);

IMPORT_C void asn1Print_StdResolution
   (const char* name, ASN1T_StdResolution* pvalue);

/**************************************************************/
/*                                                            */
/*  MultiFrameCarrier                                         */
/*                                                            */
/**************************************************************/

#define TV_MultiFrameCarrier	(TM_UNIV|TM_CONS|16)

struct ASN1T_MultiFrameCarrier {
   ASN1T_BCCHCarrier bcchCarrier;
   ASN1T_MultiFrameOffset multiFrameOffset;
   IMPORT_C ASN1T_MultiFrameCarrier ();
} ;

IMPORT_C int asn1PE_MultiFrameCarrier (OSCTXT* pctxt, ASN1T_MultiFrameCarrier* pvalue);

IMPORT_C int asn1PD_MultiFrameCarrier (OSCTXT* pctxt, ASN1T_MultiFrameCarrier* pvalue);

IMPORT_C void asn1Print_MultiFrameCarrier
   (const char* name, ASN1T_MultiFrameCarrier* pvalue);

/**************************************************************/
/*                                                            */
/*  NeighborIdentity                                          */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_NeighborIdentity_bsicAndCarrier 1
#define T_NeighborIdentity_ci           2
#define T_NeighborIdentity_multiFrameCarrier 3
#define T_NeighborIdentity_requestIndex 4
#define T_NeighborIdentity_systemInfoIndex 5
#define T_NeighborIdentity_ciAndLAC     6

struct ASN1T_NeighborIdentity {
   int t;
   union {
      /* t = 1 */
      ASN1T_BSICAndCarrier *bsicAndCarrier;
      /* t = 2 */
      ASN1T_CellID ci;
      /* t = 3 */
      ASN1T_MultiFrameCarrier *multiFrameCarrier;
      /* t = 4 */
      ASN1T_RequestIndex requestIndex;
      /* t = 5 */
      ASN1T_SystemInfoIndex systemInfoIndex;
      /* t = 6 */
      ASN1T_CellIDAndLAC *ciAndLAC;
   } u;
} ;

IMPORT_C int asn1PE_NeighborIdentity (OSCTXT* pctxt, ASN1T_NeighborIdentity* pvalue);

IMPORT_C int asn1PD_NeighborIdentity (OSCTXT* pctxt, ASN1T_NeighborIdentity* pvalue);

IMPORT_C void asn1Print_NeighborIdentity
   (const char* name, ASN1T_NeighborIdentity* pvalue);

IMPORT_C void asn1Free_NeighborIdentity (OSCTXT *pctxt, ASN1T_NeighborIdentity* pvalue);

/**************************************************************/
/*                                                            */
/*  EOTDQuality                                               */
/*                                                            */
/**************************************************************/

#define TV_EOTDQuality	(TM_UNIV|TM_CONS|16)

struct ASN1T_EOTDQuality {
   OSUINT8 nbrOfMeasurements;
   OSUINT8 stdOfEOTD;
   IMPORT_C ASN1T_EOTDQuality ();
} ;

IMPORT_C int asn1PE_EOTDQuality (OSCTXT* pctxt, ASN1T_EOTDQuality* pvalue);

IMPORT_C int asn1PD_EOTDQuality (OSCTXT* pctxt, ASN1T_EOTDQuality* pvalue);

IMPORT_C void asn1Print_EOTDQuality
   (const char* name, ASN1T_EOTDQuality* pvalue);

/**************************************************************/
/*                                                            */
/*  OTDValue                                                  */
/*                                                            */
/**************************************************************/

#define TV_OTDValue	(TM_UNIV|TM_PRIM|2)

typedef OSUINT16 ASN1T_OTDValue;

IMPORT_C int asn1PE_OTDValue (OSCTXT* pctxt, ASN1T_OTDValue value);

IMPORT_C int asn1PD_OTDValue (OSCTXT* pctxt, ASN1T_OTDValue* pvalue);

IMPORT_C void asn1Print_OTDValue
   (const char* name, ASN1T_OTDValue* pvalue);

/**************************************************************/
/*                                                            */
/*  OTD_MeasurementWithID                                     */
/*                                                            */
/**************************************************************/

#define TV_OTD_MeasurementWithID	(TM_UNIV|TM_CONS|16)

struct ASN1T_OTD_MeasurementWithID {
   ASN1T_NeighborIdentity neighborIdentity;
   ASN1T_ModuloTimeSlot nborTimeSlot;
   ASN1T_EOTDQuality eotdQuality;
   ASN1T_OTDValue otdValue;
   IMPORT_C ASN1T_OTD_MeasurementWithID ();
} ;

IMPORT_C int asn1PE_OTD_MeasurementWithID (OSCTXT* pctxt, ASN1T_OTD_MeasurementWithID* pvalue);

IMPORT_C int asn1PD_OTD_MeasurementWithID (OSCTXT* pctxt, ASN1T_OTD_MeasurementWithID* pvalue);

IMPORT_C void asn1Print_OTD_MeasurementWithID
   (const char* name, ASN1T_OTD_MeasurementWithID* pvalue);

IMPORT_C void asn1Free_OTD_MeasurementWithID (OSCTXT *pctxt, ASN1T_OTD_MeasurementWithID* pvalue);

/**************************************************************/
/*                                                            */
/*  OTD_FirstSetMsrs                                          */
/*                                                            */
/**************************************************************/

#define TV_OTD_FirstSetMsrs	(TM_UNIV|TM_CONS|16)

typedef ASN1T_OTD_MeasurementWithID ASN1T_OTD_FirstSetMsrs;

IMPORT_C int asn1PE_OTD_FirstSetMsrs (OSCTXT* pctxt, ASN1T_OTD_FirstSetMsrs* pvalue);

IMPORT_C int asn1PD_OTD_FirstSetMsrs (OSCTXT* pctxt, ASN1T_OTD_FirstSetMsrs* pvalue);

IMPORT_C void asn1Print_OTD_FirstSetMsrs
   (const char* name, ASN1T_OTD_FirstSetMsrs* pvalue);

IMPORT_C void asn1Free_OTD_FirstSetMsrs (OSCTXT *pctxt, ASN1T_OTD_FirstSetMsrs* pvalue);

/**************************************************************/
/*                                                            */
/*  SeqOfOTD_FirstSetMsrs                                     */
/*                                                            */
/**************************************************************/

#define TV_SeqOfOTD_FirstSetMsrs	(TM_UNIV|TM_CONS|16)

/* List of ASN1T_OTD_FirstSetMsrs */
typedef ASN1TSeqOfList ASN1T_SeqOfOTD_FirstSetMsrs;

class ASN1C_SeqOfOTD_FirstSetMsrs :
public ASN1CSeqOfList
{
protected:
   ASN1T_SeqOfOTD_FirstSetMsrs& msgData;
public:
   IMPORT_C ASN1C_SeqOfOTD_FirstSetMsrs (ASN1T_SeqOfOTD_FirstSetMsrs& data);
   IMPORT_C ASN1C_SeqOfOTD_FirstSetMsrs (OSRTMessageBufferIF& msgBuf
      , ASN1T_SeqOfOTD_FirstSetMsrs& data);
   ASN1C_SeqOfOTD_FirstSetMsrs (ASN1CType& ccobj, ASN1T_SeqOfOTD_FirstSetMsrs& data);
   IMPORT_C ASN1C_SeqOfOTD_FirstSetMsrs (OSRTContext &context
      , ASN1T_SeqOfOTD_FirstSetMsrs& data);
   void Append (ASN1T_OTD_FirstSetMsrs* elem);
   ASN1T_OTD_FirstSetMsrs* NewElement ();
} ;

IMPORT_C int asn1PE_SeqOfOTD_FirstSetMsrs (OSCTXT* pctxt, ASN1T_SeqOfOTD_FirstSetMsrs* pvalue);

IMPORT_C int asn1PD_SeqOfOTD_FirstSetMsrs (OSCTXT* pctxt, ASN1T_SeqOfOTD_FirstSetMsrs* pvalue);

IMPORT_C void asn1Print_SeqOfOTD_FirstSetMsrs
   (const char* name, ASN1T_SeqOfOTD_FirstSetMsrs* pvalue);

IMPORT_C void asn1Free_SeqOfOTD_FirstSetMsrs (OSCTXT *pctxt, ASN1T_SeqOfOTD_FirstSetMsrs* pvalue);

/**************************************************************/
/*                                                            */
/*  OTD_MsrElementFirst                                       */
/*                                                            */
/**************************************************************/

#define TV_OTD_MsrElementFirst	(TM_UNIV|TM_CONS|16)

struct ASN1T_OTD_MsrElementFirst {
   struct {
      unsigned toaMeasurementsOfRefPresent : 1;
      unsigned taCorrectionPresent : 1;
      unsigned otd_FirstSetMsrsPresent : 1;
   } m;
   OSUINT16 refFrameNumber;
   ASN1T_ModuloTimeSlot referenceTimeSlot;
   ASN1T_TOA_MeasurementsOfRef toaMeasurementsOfRef;
   ASN1T_StdResolution stdResolution;
   OSUINT16 taCorrection;
   ASN1T_SeqOfOTD_FirstSetMsrs otd_FirstSetMsrs;
   IMPORT_C ASN1T_OTD_MsrElementFirst ();
} ;

IMPORT_C int asn1PE_OTD_MsrElementFirst (OSCTXT* pctxt, ASN1T_OTD_MsrElementFirst* pvalue);

IMPORT_C int asn1PD_OTD_MsrElementFirst (OSCTXT* pctxt, ASN1T_OTD_MsrElementFirst* pvalue);

IMPORT_C void asn1Print_OTD_MsrElementFirst
   (const char* name, ASN1T_OTD_MsrElementFirst* pvalue);

IMPORT_C void asn1Free_OTD_MsrElementFirst (OSCTXT *pctxt, ASN1T_OTD_MsrElementFirst* pvalue);

/**************************************************************/
/*                                                            */
/*  OTD_Measurement                                           */
/*                                                            */
/**************************************************************/

#define TV_OTD_Measurement	(TM_UNIV|TM_CONS|16)

struct ASN1T_OTD_Measurement {
   ASN1T_ModuloTimeSlot nborTimeSlot;
   ASN1T_EOTDQuality eotdQuality;
   ASN1T_OTDValue otdValue;
   IMPORT_C ASN1T_OTD_Measurement ();
} ;

IMPORT_C int asn1PE_OTD_Measurement (OSCTXT* pctxt, ASN1T_OTD_Measurement* pvalue);

IMPORT_C int asn1PD_OTD_Measurement (OSCTXT* pctxt, ASN1T_OTD_Measurement* pvalue);

IMPORT_C void asn1Print_OTD_Measurement
   (const char* name, ASN1T_OTD_Measurement* pvalue);

/**************************************************************/
/*                                                            */
/*  OTD_MsrsOfOtherSets                                       */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_OTD_MsrsOfOtherSets_identityNotPresent 1
#define T_OTD_MsrsOfOtherSets_identityPresent 2

struct ASN1T_OTD_MsrsOfOtherSets {
   int t;
   union {
      /* t = 1 */
      ASN1T_OTD_Measurement *identityNotPresent;
      /* t = 2 */
      ASN1T_OTD_MeasurementWithID *identityPresent;
   } u;
} ;

IMPORT_C int asn1PE_OTD_MsrsOfOtherSets (OSCTXT* pctxt, ASN1T_OTD_MsrsOfOtherSets* pvalue);

IMPORT_C int asn1PD_OTD_MsrsOfOtherSets (OSCTXT* pctxt, ASN1T_OTD_MsrsOfOtherSets* pvalue);

IMPORT_C void asn1Print_OTD_MsrsOfOtherSets
   (const char* name, ASN1T_OTD_MsrsOfOtherSets* pvalue);

IMPORT_C void asn1Free_OTD_MsrsOfOtherSets (OSCTXT *pctxt, ASN1T_OTD_MsrsOfOtherSets* pvalue);

/**************************************************************/
/*                                                            */
/*  SeqOfOTD_MsrsOfOtherSets                                  */
/*                                                            */
/**************************************************************/

#define TV_SeqOfOTD_MsrsOfOtherSets	(TM_UNIV|TM_CONS|16)

/* List of ASN1T_OTD_MsrsOfOtherSets */
typedef ASN1TSeqOfList ASN1T_SeqOfOTD_MsrsOfOtherSets;

class ASN1C_SeqOfOTD_MsrsOfOtherSets :
public ASN1CSeqOfList
{
protected:
   ASN1T_SeqOfOTD_MsrsOfOtherSets& msgData;
public:
   IMPORT_C ASN1C_SeqOfOTD_MsrsOfOtherSets (ASN1T_SeqOfOTD_MsrsOfOtherSets& data);
   IMPORT_C ASN1C_SeqOfOTD_MsrsOfOtherSets (OSRTMessageBufferIF& msgBuf
      , ASN1T_SeqOfOTD_MsrsOfOtherSets& data);
   ASN1C_SeqOfOTD_MsrsOfOtherSets (ASN1CType& ccobj, ASN1T_SeqOfOTD_MsrsOfOtherSets& data);
   IMPORT_C ASN1C_SeqOfOTD_MsrsOfOtherSets (OSRTContext &context
      , ASN1T_SeqOfOTD_MsrsOfOtherSets& data);
   void Append (ASN1T_OTD_MsrsOfOtherSets* elem);
   ASN1T_OTD_MsrsOfOtherSets* NewElement ();
} ;

IMPORT_C int asn1PE_SeqOfOTD_MsrsOfOtherSets (OSCTXT* pctxt, ASN1T_SeqOfOTD_MsrsOfOtherSets* pvalue);

IMPORT_C int asn1PD_SeqOfOTD_MsrsOfOtherSets (OSCTXT* pctxt, ASN1T_SeqOfOTD_MsrsOfOtherSets* pvalue);

IMPORT_C void asn1Print_SeqOfOTD_MsrsOfOtherSets
   (const char* name, ASN1T_SeqOfOTD_MsrsOfOtherSets* pvalue);

IMPORT_C void asn1Free_SeqOfOTD_MsrsOfOtherSets (OSCTXT *pctxt, ASN1T_SeqOfOTD_MsrsOfOtherSets* pvalue);

/**************************************************************/
/*                                                            */
/*  OTD_MsrElementRest                                        */
/*                                                            */
/**************************************************************/

#define TV_OTD_MsrElementRest	(TM_UNIV|TM_CONS|16)

struct ASN1T_OTD_MsrElementRest {
   struct {
      unsigned toaMeasurementsOfRefPresent : 1;
      unsigned taCorrectionPresent : 1;
      unsigned otd_MsrsOfOtherSetsPresent : 1;
   } m;
   OSUINT16 refFrameNumber;
   ASN1T_ModuloTimeSlot referenceTimeSlot;
   ASN1T_TOA_MeasurementsOfRef toaMeasurementsOfRef;
   ASN1T_StdResolution stdResolution;
   OSUINT16 taCorrection;
   ASN1T_SeqOfOTD_MsrsOfOtherSets otd_MsrsOfOtherSets;
   IMPORT_C ASN1T_OTD_MsrElementRest ();
} ;

IMPORT_C int asn1PE_OTD_MsrElementRest (OSCTXT* pctxt, ASN1T_OTD_MsrElementRest* pvalue);

IMPORT_C int asn1PD_OTD_MsrElementRest (OSCTXT* pctxt, ASN1T_OTD_MsrElementRest* pvalue);

IMPORT_C void asn1Print_OTD_MsrElementRest
   (const char* name, ASN1T_OTD_MsrElementRest* pvalue);

IMPORT_C void asn1Free_OTD_MsrElementRest (OSCTXT *pctxt, ASN1T_OTD_MsrElementRest* pvalue);

/**************************************************************/
/*                                                            */
/*  SeqOfOTD_MsrElementRest                                   */
/*                                                            */
/**************************************************************/

#define TV_SeqOfOTD_MsrElementRest	(TM_UNIV|TM_CONS|16)

/* List of ASN1T_OTD_MsrElementRest */
typedef ASN1TSeqOfList ASN1T_SeqOfOTD_MsrElementRest;

class ASN1C_SeqOfOTD_MsrElementRest :
public ASN1CSeqOfList
{
protected:
   ASN1T_SeqOfOTD_MsrElementRest& msgData;
public:
   IMPORT_C ASN1C_SeqOfOTD_MsrElementRest (ASN1T_SeqOfOTD_MsrElementRest& data);
   IMPORT_C ASN1C_SeqOfOTD_MsrElementRest (OSRTMessageBufferIF& msgBuf
      , ASN1T_SeqOfOTD_MsrElementRest& data);
   ASN1C_SeqOfOTD_MsrElementRest (ASN1CType& ccobj, ASN1T_SeqOfOTD_MsrElementRest& data);
   IMPORT_C ASN1C_SeqOfOTD_MsrElementRest (OSRTContext &context
      , ASN1T_SeqOfOTD_MsrElementRest& data);
   void Append (ASN1T_OTD_MsrElementRest* elem);
   ASN1T_OTD_MsrElementRest* NewElement ();
} ;

IMPORT_C int asn1PE_SeqOfOTD_MsrElementRest (OSCTXT* pctxt, ASN1T_SeqOfOTD_MsrElementRest* pvalue);

IMPORT_C int asn1PD_SeqOfOTD_MsrElementRest (OSCTXT* pctxt, ASN1T_SeqOfOTD_MsrElementRest* pvalue);

IMPORT_C void asn1Print_SeqOfOTD_MsrElementRest
   (const char* name, ASN1T_SeqOfOTD_MsrElementRest* pvalue);

IMPORT_C void asn1Free_SeqOfOTD_MsrElementRest (OSCTXT *pctxt, ASN1T_SeqOfOTD_MsrElementRest* pvalue);

/**************************************************************/
/*                                                            */
/*  OTD_MeasureInfo                                           */
/*                                                            */
/**************************************************************/

#define TV_OTD_MeasureInfo	(TM_UNIV|TM_CONS|16)

struct ASN1T_OTD_MeasureInfo {
   struct {
      unsigned otdMsrRestSetsPresent : 1;
   } m;
   ASN1T_OTD_MsrElementFirst otdMsrFirstSets;
   ASN1T_SeqOfOTD_MsrElementRest otdMsrRestSets;
   IMPORT_C ASN1T_OTD_MeasureInfo ();
} ;

IMPORT_C int asn1PE_OTD_MeasureInfo (OSCTXT* pctxt, ASN1T_OTD_MeasureInfo* pvalue);

IMPORT_C int asn1PD_OTD_MeasureInfo (OSCTXT* pctxt, ASN1T_OTD_MeasureInfo* pvalue);

IMPORT_C void asn1Print_OTD_MeasureInfo
   (const char* name, ASN1T_OTD_MeasureInfo* pvalue);

IMPORT_C void asn1Free_OTD_MeasureInfo (OSCTXT *pctxt, ASN1T_OTD_MeasureInfo* pvalue);

/**************************************************************/
/*                                                            */
/*  FixType                                                   */
/*                                                            */
/**************************************************************/

#define TV_FixType	(TM_UNIV|TM_PRIM|2)

struct FixType {
   enum Root {
      twoDFix = 0,
      threeDFix = 1
   } ;
} ;

typedef OSUINT8 ASN1T_FixType;

IMPORT_C int asn1PE_FixType (OSCTXT* pctxt, ASN1T_FixType value);

IMPORT_C int asn1PD_FixType (OSCTXT* pctxt, ASN1T_FixType* pvalue);

IMPORT_C void asn1Print_FixType
   (const char* name, ASN1T_FixType* pvalue);

/**************************************************************/
/*                                                            */
/*  LocationInfo                                              */
/*                                                            */
/**************************************************************/

#define TV_LocationInfo	(TM_UNIV|TM_CONS|16)

struct ASN1T_LocationInfo {
   struct {
      unsigned gpsTOWPresent : 1;
   } m;
   OSUINT16 refFrame;
   OSUINT32 gpsTOW;
   ASN1T_FixType fixType;
   ASN1T_Ext_GeographicalInformation posEstimate;
   IMPORT_C ASN1T_LocationInfo ();
} ;

IMPORT_C int asn1PE_LocationInfo (OSCTXT* pctxt, ASN1T_LocationInfo* pvalue);

IMPORT_C int asn1PD_LocationInfo (OSCTXT* pctxt, ASN1T_LocationInfo* pvalue);

IMPORT_C void asn1Print_LocationInfo
   (const char* name, ASN1T_LocationInfo* pvalue);

/**************************************************************/
/*                                                            */
/*  GPSTOW24b                                                 */
/*                                                            */
/**************************************************************/

#define TV_GPSTOW24b	(TM_UNIV|TM_PRIM|2)

typedef OSUINT32 ASN1T_GPSTOW24b;

IMPORT_C int asn1PE_GPSTOW24b (OSCTXT* pctxt, ASN1T_GPSTOW24b value);

IMPORT_C int asn1PD_GPSTOW24b (OSCTXT* pctxt, ASN1T_GPSTOW24b* pvalue);

IMPORT_C void asn1Print_GPSTOW24b
   (const char* name, ASN1T_GPSTOW24b* pvalue);

/**************************************************************/
/*                                                            */
/*  MpathIndic                                                */
/*                                                            */
/**************************************************************/

#define TV_MpathIndic	(TM_UNIV|TM_PRIM|10)

struct MpathIndic {
   enum Root {
      notMeasured = 0,
      low = 1,
      medium = 2,
      high = 3
   } ;
} ;

typedef OSUINT32 ASN1T_MpathIndic;

IMPORT_C int asn1PE_MpathIndic (OSCTXT* pctxt, ASN1T_MpathIndic value);

IMPORT_C int asn1PD_MpathIndic (OSCTXT* pctxt, ASN1T_MpathIndic* pvalue);

IMPORT_C void asn1Print_MpathIndic
   (const char* name, ASN1T_MpathIndic* pvalue);

IMPORT_C const OSUTF8CHAR* ASN1T_MpathIndic_ToString (OSINT32 value);

IMPORT_C int ASN1T_MpathIndic_ToEnum (OSCTXT* pctxt,
   const OSUTF8CHAR* value, ASN1T_MpathIndic* pvalue);

/**************************************************************/
/*                                                            */
/*  GPS_MsrElement                                            */
/*                                                            */
/**************************************************************/

#define TV_GPS_MsrElement	(TM_UNIV|TM_CONS|16)

struct ASN1T_GPS_MsrElement {
   ASN1T_SatelliteID satelliteID;
   OSUINT8 cNo;
   OSINT16 doppler;
   OSUINT16 wholeChips;
   OSUINT16 fracChips;
   ASN1T_MpathIndic mpathIndic;
   OSUINT8 pseuRangeRMSErr;
   IMPORT_C ASN1T_GPS_MsrElement ();
} ;

IMPORT_C int asn1PE_GPS_MsrElement (OSCTXT* pctxt, ASN1T_GPS_MsrElement* pvalue);

IMPORT_C int asn1PD_GPS_MsrElement (OSCTXT* pctxt, ASN1T_GPS_MsrElement* pvalue);

IMPORT_C void asn1Print_GPS_MsrElement
   (const char* name, ASN1T_GPS_MsrElement* pvalue);

/**************************************************************/
/*                                                            */
/*  SeqOfGPS_MsrElement                                       */
/*                                                            */
/**************************************************************/

#define TV_SeqOfGPS_MsrElement	(TM_UNIV|TM_CONS|16)

/* List of ASN1T_GPS_MsrElement */
typedef ASN1TSeqOfList ASN1T_SeqOfGPS_MsrElement;

class ASN1C_SeqOfGPS_MsrElement :
public ASN1CSeqOfList
{
protected:
   ASN1T_SeqOfGPS_MsrElement& msgData;
public:
   IMPORT_C ASN1C_SeqOfGPS_MsrElement (ASN1T_SeqOfGPS_MsrElement& data);
   IMPORT_C ASN1C_SeqOfGPS_MsrElement (OSRTMessageBufferIF& msgBuf
      , ASN1T_SeqOfGPS_MsrElement& data);
   IMPORT_C ASN1C_SeqOfGPS_MsrElement (ASN1CType& ccobj, ASN1T_SeqOfGPS_MsrElement& data);
   IMPORT_C ASN1C_SeqOfGPS_MsrElement (OSRTContext &context
      , ASN1T_SeqOfGPS_MsrElement& data);
   IMPORT_C void Append (ASN1T_GPS_MsrElement* elem);
   IMPORT_C ASN1T_GPS_MsrElement* NewElement ();
} ;

IMPORT_C int asn1PE_SeqOfGPS_MsrElement (OSCTXT* pctxt, ASN1T_SeqOfGPS_MsrElement* pvalue);

IMPORT_C int asn1PD_SeqOfGPS_MsrElement (OSCTXT* pctxt, ASN1T_SeqOfGPS_MsrElement* pvalue);

IMPORT_C void asn1Print_SeqOfGPS_MsrElement
   (const char* name, ASN1T_SeqOfGPS_MsrElement* pvalue);

IMPORT_C void asn1Free_SeqOfGPS_MsrElement (OSCTXT *pctxt, ASN1T_SeqOfGPS_MsrElement* pvalue);

/**************************************************************/
/*                                                            */
/*  GPS_MsrSetElement                                         */
/*                                                            */
/**************************************************************/

#define TV_GPS_MsrSetElement	(TM_UNIV|TM_CONS|16)

struct ASN1T_GPS_MsrSetElement {
   struct {
      unsigned refFramePresent : 1;
   } m;
   OSUINT16 refFrame;
   ASN1T_GPSTOW24b gpsTOW;
   ASN1T_SeqOfGPS_MsrElement gps_msrList;
   IMPORT_C ASN1T_GPS_MsrSetElement ();
} ;

IMPORT_C int asn1PE_GPS_MsrSetElement (OSCTXT* pctxt, ASN1T_GPS_MsrSetElement* pvalue);

IMPORT_C int asn1PD_GPS_MsrSetElement (OSCTXT* pctxt, ASN1T_GPS_MsrSetElement* pvalue);

IMPORT_C void asn1Print_GPS_MsrSetElement
   (const char* name, ASN1T_GPS_MsrSetElement* pvalue);

IMPORT_C void asn1Free_GPS_MsrSetElement (OSCTXT *pctxt, ASN1T_GPS_MsrSetElement* pvalue);

/**************************************************************/
/*                                                            */
/*  SeqOfGPS_MsrSetElement                                    */
/*                                                            */
/**************************************************************/

#define TV_SeqOfGPS_MsrSetElement	(TM_UNIV|TM_CONS|16)

/* List of ASN1T_GPS_MsrSetElement */
typedef ASN1TSeqOfList ASN1T_SeqOfGPS_MsrSetElement;

class ASN1C_SeqOfGPS_MsrSetElement :
public ASN1CSeqOfList
{
protected:
   ASN1T_SeqOfGPS_MsrSetElement& msgData;
public:
   IMPORT_C ASN1C_SeqOfGPS_MsrSetElement (ASN1T_SeqOfGPS_MsrSetElement& data);
   IMPORT_C ASN1C_SeqOfGPS_MsrSetElement (OSRTMessageBufferIF& msgBuf
      , ASN1T_SeqOfGPS_MsrSetElement& data);
   IMPORT_C ASN1C_SeqOfGPS_MsrSetElement (ASN1CType& ccobj, ASN1T_SeqOfGPS_MsrSetElement& data);
   IMPORT_C ASN1C_SeqOfGPS_MsrSetElement (OSRTContext &context
      , ASN1T_SeqOfGPS_MsrSetElement& data);
   IMPORT_C void Append (ASN1T_GPS_MsrSetElement* elem);
   IMPORT_C ASN1T_GPS_MsrSetElement* NewElement ();
} ;

IMPORT_C int asn1PE_SeqOfGPS_MsrSetElement (OSCTXT* pctxt, ASN1T_SeqOfGPS_MsrSetElement* pvalue);

IMPORT_C int asn1PD_SeqOfGPS_MsrSetElement (OSCTXT* pctxt, ASN1T_SeqOfGPS_MsrSetElement* pvalue);

IMPORT_C void asn1Print_SeqOfGPS_MsrSetElement
   (const char* name, ASN1T_SeqOfGPS_MsrSetElement* pvalue);

IMPORT_C void asn1Free_SeqOfGPS_MsrSetElement (OSCTXT *pctxt, ASN1T_SeqOfGPS_MsrSetElement* pvalue);

/**************************************************************/
/*                                                            */
/*  GPS_MeasureInfo                                           */
/*                                                            */
/**************************************************************/

#define TV_GPS_MeasureInfo	(TM_UNIV|TM_CONS|16)

struct ASN1T_GPS_MeasureInfo {
   ASN1T_SeqOfGPS_MsrSetElement gpsMsrSetList;
   IMPORT_C ASN1T_GPS_MeasureInfo ();
} ;

IMPORT_C int asn1PE_GPS_MeasureInfo (OSCTXT* pctxt, ASN1T_GPS_MeasureInfo* pvalue);

IMPORT_C int asn1PD_GPS_MeasureInfo (OSCTXT* pctxt, ASN1T_GPS_MeasureInfo* pvalue);

IMPORT_C void asn1Print_GPS_MeasureInfo
   (const char* name, ASN1T_GPS_MeasureInfo* pvalue);

IMPORT_C void asn1Free_GPS_MeasureInfo (OSCTXT *pctxt, ASN1T_GPS_MeasureInfo* pvalue);

/**************************************************************/
/*                                                            */
/*  LocErrorReason                                            */
/*                                                            */
/**************************************************************/

#define TV_LocErrorReason	(TM_UNIV|TM_PRIM|10)

struct LocErrorReason {
   enum Root {
      unDefined = 0,
      notEnoughBTSs = 1,
      notEnoughSats = 2,
      eotdLocCalAssDataMissing = 3,
      eotdAssDataMissing = 4,
      gpsLocCalAssDataMissing = 5,
      gpsAssDataMissing = 6,
      methodNotSupported = 7,
      notProcessed = 8,
      refBTSForGPSNotServingBTS = 9,
      refBTSForEOTDNotServingBTS = 10
   } ;
} ;

typedef OSUINT32 ASN1T_LocErrorReason;

IMPORT_C int asn1PE_LocErrorReason (OSCTXT* pctxt, ASN1T_LocErrorReason value);

IMPORT_C int asn1PD_LocErrorReason (OSCTXT* pctxt, ASN1T_LocErrorReason* pvalue);

IMPORT_C void asn1Print_LocErrorReason
   (const char* name, ASN1T_LocErrorReason* pvalue);

IMPORT_C const OSUTF8CHAR* ASN1T_LocErrorReason_ToString (OSINT32 value);

IMPORT_C int ASN1T_LocErrorReason_ToEnum (OSCTXT* pctxt,
   const OSUTF8CHAR* value, ASN1T_LocErrorReason* pvalue);

/**************************************************************/
/*                                                            */
/*  GPSAssistanceData                                         */
/*                                                            */
/**************************************************************/

#define TV_GPSAssistanceData	(TM_UNIV|TM_PRIM|4)

struct ASN1T_GPSAssistanceData {
   OSUINT32 numocts;
   OSOCTET data[40];
   // ctors
   ASN1T_GPSAssistanceData () : numocts(0) {}
   ASN1T_GPSAssistanceData (OSUINT32 _numocts, const OSOCTET* _data) :
      numocts (_numocts) {
      OSCRTLMEMCPY (data, _data, OSRTMIN (numocts, sizeof(data)));
   }
   ASN1T_GPSAssistanceData (const char* cstring) {
      if (strlen(cstring) > 0) {
         numocts = OSRTMIN ((OSCRTLSTRLEN(cstring)+1), sizeof(data));
         OSCRTLSTRNCPY ((char*)data, cstring, sizeof(data));
      }
      else numocts = 0;
   }
   // assignment operators
   ASN1T_GPSAssistanceData& operator= (const char* cstring) {
      if (strlen(cstring) > 0) {
         numocts = OSRTMIN ((OSCRTLSTRLEN(cstring)+1), sizeof(data));
         OSCRTLSTRNCPY ((char*)data, cstring, sizeof(data));
      }
      else numocts = 0;
      return *this;
   }
} ;

IMPORT_C int asn1PE_GPSAssistanceData (OSCTXT* pctxt, ASN1T_GPSAssistanceData* pvalue);

IMPORT_C int asn1PD_GPSAssistanceData (OSCTXT* pctxt, ASN1T_GPSAssistanceData* pvalue);

IMPORT_C void asn1Print_GPSAssistanceData
   (const char* name, ASN1T_GPSAssistanceData* pvalue);

/**************************************************************/
/*                                                            */
/*  AdditionalAssistanceData                                  */
/*                                                            */
/**************************************************************/

#define TV_AdditionalAssistanceData	(TM_UNIV|TM_CONS|16)

struct ASN1T_AdditionalAssistanceData {
   struct {
      unsigned gpsAssistanceDataPresent : 1;
      unsigned extensionContainerPresent : 1;
   } m;
   ASN1T_GPSAssistanceData gpsAssistanceData;
   ASN1T_ExtensionContainer extensionContainer;
   IMPORT_C ASN1T_AdditionalAssistanceData ();
} ;

IMPORT_C int asn1PE_AdditionalAssistanceData (OSCTXT* pctxt, ASN1T_AdditionalAssistanceData* pvalue);

IMPORT_C int asn1PD_AdditionalAssistanceData (OSCTXT* pctxt, ASN1T_AdditionalAssistanceData* pvalue);

IMPORT_C void asn1Print_AdditionalAssistanceData
   (const char* name, ASN1T_AdditionalAssistanceData* pvalue);

IMPORT_C void asn1Free_AdditionalAssistanceData (OSCTXT *pctxt, ASN1T_AdditionalAssistanceData* pvalue);

/**************************************************************/
/*                                                            */
/*  LocationError                                             */
/*                                                            */
/**************************************************************/

#define TV_LocationError	(TM_UNIV|TM_CONS|16)

struct ASN1T_LocationError {
   struct {
      unsigned additionalAssistanceDataPresent : 1;
   } m;
   ASN1T_LocErrorReason locErrorReason;
   ASN1T_AdditionalAssistanceData additionalAssistanceData;
   IMPORT_C ASN1T_LocationError ();
} ;

IMPORT_C int asn1PE_LocationError (OSCTXT* pctxt, ASN1T_LocationError* pvalue);

IMPORT_C int asn1PD_LocationError (OSCTXT* pctxt, ASN1T_LocationError* pvalue);

IMPORT_C void asn1Print_LocationError
   (const char* name, ASN1T_LocationError* pvalue);

IMPORT_C void asn1Free_LocationError (OSCTXT *pctxt, ASN1T_LocationError* pvalue);

/**************************************************************/
/*                                                            */
/*  SeqOfOTD_FirstSetMsrs_R98_Ext                             */
/*                                                            */
/**************************************************************/

#define TV_SeqOfOTD_FirstSetMsrs_R98_Ext	(TM_UNIV|TM_CONS|16)

/* List of ASN1T_OTD_FirstSetMsrs */
typedef ASN1TSeqOfList ASN1T_SeqOfOTD_FirstSetMsrs_R98_Ext;

class ASN1C_SeqOfOTD_FirstSetMsrs_R98_Ext :
public ASN1CSeqOfList
{
protected:
   ASN1T_SeqOfOTD_FirstSetMsrs_R98_Ext& msgData;
public:
   IMPORT_C ASN1C_SeqOfOTD_FirstSetMsrs_R98_Ext
       (ASN1T_SeqOfOTD_FirstSetMsrs_R98_Ext& data);
   IMPORT_C ASN1C_SeqOfOTD_FirstSetMsrs_R98_Ext (OSRTMessageBufferIF& msgBuf
      , ASN1T_SeqOfOTD_FirstSetMsrs_R98_Ext& data);
   ASN1C_SeqOfOTD_FirstSetMsrs_R98_Ext (ASN1CType& ccobj, ASN1T_SeqOfOTD_FirstSetMsrs_R98_Ext& data);
   IMPORT_C ASN1C_SeqOfOTD_FirstSetMsrs_R98_Ext (OSRTContext &context
      , ASN1T_SeqOfOTD_FirstSetMsrs_R98_Ext& data);
   void Append (ASN1T_OTD_FirstSetMsrs* elem);
   ASN1T_OTD_FirstSetMsrs* NewElement ();
} ;

IMPORT_C int asn1PE_SeqOfOTD_FirstSetMsrs_R98_Ext (OSCTXT* pctxt, ASN1T_SeqOfOTD_FirstSetMsrs_R98_Ext* pvalue);

IMPORT_C int asn1PD_SeqOfOTD_FirstSetMsrs_R98_Ext (OSCTXT* pctxt, ASN1T_SeqOfOTD_FirstSetMsrs_R98_Ext* pvalue);

IMPORT_C void asn1Print_SeqOfOTD_FirstSetMsrs_R98_Ext
   (const char* name, ASN1T_SeqOfOTD_FirstSetMsrs_R98_Ext* pvalue);

IMPORT_C void asn1Free_SeqOfOTD_FirstSetMsrs_R98_Ext (OSCTXT *pctxt, ASN1T_SeqOfOTD_FirstSetMsrs_R98_Ext* pvalue);

/**************************************************************/
/*                                                            */
/*  OTD_MsrElementFirst_R98_Ext                               */
/*                                                            */
/**************************************************************/

#define TV_OTD_MsrElementFirst_R98_Ext	(TM_UNIV|TM_CONS|16)

struct ASN1T_OTD_MsrElementFirst_R98_Ext {
   struct {
      unsigned otd_FirstSetMsrs_R98_ExtPresent : 1;
   } m;
   ASN1T_SeqOfOTD_FirstSetMsrs_R98_Ext otd_FirstSetMsrs_R98_Ext;
   IMPORT_C ASN1T_OTD_MsrElementFirst_R98_Ext ();
} ;

IMPORT_C int asn1PE_OTD_MsrElementFirst_R98_Ext (OSCTXT* pctxt, ASN1T_OTD_MsrElementFirst_R98_Ext* pvalue);

IMPORT_C int asn1PD_OTD_MsrElementFirst_R98_Ext (OSCTXT* pctxt, ASN1T_OTD_MsrElementFirst_R98_Ext* pvalue);

IMPORT_C void asn1Print_OTD_MsrElementFirst_R98_Ext
   (const char* name, ASN1T_OTD_MsrElementFirst_R98_Ext* pvalue);

IMPORT_C void asn1Free_OTD_MsrElementFirst_R98_Ext (OSCTXT *pctxt, ASN1T_OTD_MsrElementFirst_R98_Ext* pvalue);

/**************************************************************/
/*                                                            */
/*  OTD_MeasureInfo_R98_Ext                                   */
/*                                                            */
/**************************************************************/

#define TV_OTD_MeasureInfo_R98_Ext	(TM_UNIV|TM_CONS|16)

struct ASN1T_OTD_MeasureInfo_R98_Ext {
   ASN1T_OTD_MsrElementFirst_R98_Ext otdMsrFirstSets_R98_Ext;
   IMPORT_C ASN1T_OTD_MeasureInfo_R98_Ext ();
} ;

IMPORT_C int asn1PE_OTD_MeasureInfo_R98_Ext (OSCTXT* pctxt, ASN1T_OTD_MeasureInfo_R98_Ext* pvalue);

IMPORT_C int asn1PD_OTD_MeasureInfo_R98_Ext (OSCTXT* pctxt, ASN1T_OTD_MeasureInfo_R98_Ext* pvalue);

IMPORT_C void asn1Print_OTD_MeasureInfo_R98_Ext
   (const char* name, ASN1T_OTD_MeasureInfo_R98_Ext* pvalue);

IMPORT_C void asn1Free_OTD_MeasureInfo_R98_Ext (OSCTXT *pctxt, ASN1T_OTD_MeasureInfo_R98_Ext* pvalue);

/**************************************************************/
/*                                                            */
/*  Rel_98_MsrPosition_Rsp_Extension_rel_98_Ext_MeasureInfo   */
/*                                                            */
/**************************************************************/

#define TV_Rel_98_MsrPosition_Rsp_Extension_rel_98_Ext_MeasureInfo	(TM_UNIV|TM_CONS|16)

struct ASN1T_Rel_98_MsrPosition_Rsp_Extension_rel_98_Ext_MeasureInfo {
   struct {
      unsigned otd_MeasureInfo_R98_ExtPresent : 1;
   } m;
   ASN1T_OTD_MeasureInfo_R98_Ext otd_MeasureInfo_R98_Ext;
   IMPORT_C ASN1T_Rel_98_MsrPosition_Rsp_Extension_rel_98_Ext_MeasureInfo ();
} ;

IMPORT_C int asn1PE_Rel_98_MsrPosition_Rsp_Extension_rel_98_Ext_MeasureInfo (OSCTXT* pctxt, ASN1T_Rel_98_MsrPosition_Rsp_Extension_rel_98_Ext_MeasureInfo* pvalue);

IMPORT_C int asn1PD_Rel_98_MsrPosition_Rsp_Extension_rel_98_Ext_MeasureInfo (OSCTXT* pctxt, ASN1T_Rel_98_MsrPosition_Rsp_Extension_rel_98_Ext_MeasureInfo* pvalue);

IMPORT_C void asn1Print_Rel_98_MsrPosition_Rsp_Extension_rel_98_Ext_MeasureInfo
   (const char* name, ASN1T_Rel_98_MsrPosition_Rsp_Extension_rel_98_Ext_MeasureInfo* pvalue);

IMPORT_C void asn1Free_Rel_98_MsrPosition_Rsp_Extension_rel_98_Ext_MeasureInfo (OSCTXT *pctxt, ASN1T_Rel_98_MsrPosition_Rsp_Extension_rel_98_Ext_MeasureInfo* pvalue);

/**************************************************************/
/*                                                            */
/*  GPSTimeAssistanceMeasurements                             */
/*                                                            */
/**************************************************************/

#define TV_GPSTimeAssistanceMeasurements	(TM_UNIV|TM_CONS|16)

struct ASN1T_GPSTimeAssistanceMeasurements {
   struct {
      unsigned gpsTowSubmsPresent : 1;
      unsigned deltaTowPresent : 1;
      unsigned gpsReferenceTimeUncertaintyPresent : 1;
   } m;
   OSUINT8 referenceFrameMSB;
   OSUINT16 gpsTowSubms;
   OSUINT8 deltaTow;
   ASN1T_GPSReferenceTimeUncertainty gpsReferenceTimeUncertainty;
   IMPORT_C ASN1T_GPSTimeAssistanceMeasurements ();
} ;

IMPORT_C int asn1PE_GPSTimeAssistanceMeasurements (OSCTXT* pctxt, ASN1T_GPSTimeAssistanceMeasurements* pvalue);

IMPORT_C int asn1PD_GPSTimeAssistanceMeasurements (OSCTXT* pctxt, ASN1T_GPSTimeAssistanceMeasurements* pvalue);

IMPORT_C void asn1Print_GPSTimeAssistanceMeasurements
   (const char* name, ASN1T_GPSTimeAssistanceMeasurements* pvalue);

/**************************************************************/
/*                                                            */
/*  Rel_98_MsrPosition_Rsp_Extension                          */
/*                                                            */
/**************************************************************/

#define TV_Rel_98_MsrPosition_Rsp_Extension	(TM_UNIV|TM_CONS|16)

struct ASN1T_Rel_98_MsrPosition_Rsp_Extension {
   struct {
      unsigned timeAssistanceMeasurementsPresent : 1;
   } m;
   ASN1T_Rel_98_MsrPosition_Rsp_Extension_rel_98_Ext_MeasureInfo rel_98_Ext_MeasureInfo;
   ASN1T_GPSTimeAssistanceMeasurements timeAssistanceMeasurements;
   IMPORT_C ASN1T_Rel_98_MsrPosition_Rsp_Extension ();
} ;

IMPORT_C int asn1PE_Rel_98_MsrPosition_Rsp_Extension (OSCTXT* pctxt, ASN1T_Rel_98_MsrPosition_Rsp_Extension* pvalue);

IMPORT_C int asn1PD_Rel_98_MsrPosition_Rsp_Extension (OSCTXT* pctxt, ASN1T_Rel_98_MsrPosition_Rsp_Extension* pvalue);

IMPORT_C void asn1Print_Rel_98_MsrPosition_Rsp_Extension
   (const char* name, ASN1T_Rel_98_MsrPosition_Rsp_Extension* pvalue);

IMPORT_C void asn1Free_Rel_98_MsrPosition_Rsp_Extension (OSCTXT *pctxt, ASN1T_Rel_98_MsrPosition_Rsp_Extension* pvalue);

/**************************************************************/
/*                                                            */
/*  OTD_MeasureInfo_5_Ext                                     */
/*                                                            */
/**************************************************************/

#define TV_OTD_MeasureInfo_5_Ext	(TM_UNIV|TM_CONS|16)

typedef ASN1T_SeqOfOTD_MsrElementRest ASN1T_OTD_MeasureInfo_5_Ext;

IMPORT_C int asn1PE_OTD_MeasureInfo_5_Ext (OSCTXT* pctxt, ASN1T_OTD_MeasureInfo_5_Ext* pvalue);

IMPORT_C int asn1PD_OTD_MeasureInfo_5_Ext (OSCTXT* pctxt, ASN1T_OTD_MeasureInfo_5_Ext* pvalue);

IMPORT_C void asn1Print_OTD_MeasureInfo_5_Ext
   (const char* name, ASN1T_OTD_MeasureInfo_5_Ext* pvalue);

IMPORT_C void asn1Free_OTD_MeasureInfo_5_Ext (OSCTXT *pctxt, ASN1T_OTD_MeasureInfo_5_Ext* pvalue);

/**************************************************************/
/*                                                            */
/*  UlPseudoSegInd                                            */
/*                                                            */
/**************************************************************/

#define TV_UlPseudoSegInd	(TM_UNIV|TM_PRIM|10)

struct UlPseudoSegInd {
   enum Root {
      firstOfMany = 0,
      secondOfMany = 1
   } ;
} ;

typedef OSUINT32 ASN1T_UlPseudoSegInd;

IMPORT_C int asn1PE_UlPseudoSegInd (OSCTXT* pctxt, ASN1T_UlPseudoSegInd value);

IMPORT_C int asn1PD_UlPseudoSegInd (OSCTXT* pctxt, ASN1T_UlPseudoSegInd* pvalue);

IMPORT_C void asn1Print_UlPseudoSegInd
   (const char* name, ASN1T_UlPseudoSegInd* pvalue);

IMPORT_C const OSUTF8CHAR* ASN1T_UlPseudoSegInd_ToString (OSINT32 value);

IMPORT_C int ASN1T_UlPseudoSegInd_ToEnum (OSCTXT* pctxt,
   const OSUTF8CHAR* value, ASN1T_UlPseudoSegInd* pvalue);

/**************************************************************/
/*                                                            */
/*  Rel_5_MsrPosition_Rsp_Extension                           */
/*                                                            */
/**************************************************************/

#define TV_Rel_5_MsrPosition_Rsp_Extension	(TM_UNIV|TM_CONS|16)

struct ASN1T_Rel_5_MsrPosition_Rsp_Extension {
   struct {
      unsigned extended_referencePresent : 1;
      unsigned otd_MeasureInfo_5_ExtPresent : 1;
      unsigned ulPseudoSegIndPresent : 1;
   } m;
   ASN1T_Extended_reference extended_reference;
   ASN1T_OTD_MeasureInfo_5_Ext otd_MeasureInfo_5_Ext;
   ASN1T_UlPseudoSegInd ulPseudoSegInd;
   IMPORT_C ASN1T_Rel_5_MsrPosition_Rsp_Extension ();
} ;

IMPORT_C int asn1PE_Rel_5_MsrPosition_Rsp_Extension (OSCTXT* pctxt, ASN1T_Rel_5_MsrPosition_Rsp_Extension* pvalue);

IMPORT_C int asn1PD_Rel_5_MsrPosition_Rsp_Extension (OSCTXT* pctxt, ASN1T_Rel_5_MsrPosition_Rsp_Extension* pvalue);

IMPORT_C void asn1Print_Rel_5_MsrPosition_Rsp_Extension
   (const char* name, ASN1T_Rel_5_MsrPosition_Rsp_Extension* pvalue);

IMPORT_C void asn1Free_Rel_5_MsrPosition_Rsp_Extension (OSCTXT *pctxt, ASN1T_Rel_5_MsrPosition_Rsp_Extension* pvalue);

/**************************************************************/
/*                                                            */
/*  MsrPosition_Rsp                                           */
/*                                                            */
/**************************************************************/

#define TV_MsrPosition_Rsp	(TM_UNIV|TM_CONS|16)

struct ASN1T_MsrPosition_Rsp {
   struct {
      unsigned multipleSetsPresent : 1;
      unsigned referenceIdentityPresent : 1;
      unsigned otd_MeasureInfoPresent : 1;
      unsigned locationInfoPresent : 1;
      unsigned gps_MeasureInfoPresent : 1;
      unsigned locationErrorPresent : 1;
      unsigned extensionContainerPresent : 1;
      unsigned rel_98_MsrPosition_Rsp_ExtensionPresent : 1;
      unsigned rel_5_MsrPosition_Rsp_ExtensionPresent : 1;
   } m;
   ASN1T_MultipleSets multipleSets;
   ASN1T_ReferenceIdentity referenceIdentity;
   ASN1T_OTD_MeasureInfo otd_MeasureInfo;
   ASN1T_LocationInfo locationInfo;
   ASN1T_GPS_MeasureInfo gps_MeasureInfo;
   ASN1T_LocationError locationError;
   ASN1T_ExtensionContainer extensionContainer;
   ASN1T_Rel_98_MsrPosition_Rsp_Extension rel_98_MsrPosition_Rsp_Extension;
   ASN1T_Rel_5_MsrPosition_Rsp_Extension rel_5_MsrPosition_Rsp_Extension;
   IMPORT_C ASN1T_MsrPosition_Rsp ();
} ;

IMPORT_C int asn1PE_MsrPosition_Rsp (OSCTXT* pctxt, ASN1T_MsrPosition_Rsp* pvalue);

IMPORT_C int asn1PD_MsrPosition_Rsp (OSCTXT* pctxt, ASN1T_MsrPosition_Rsp* pvalue);

IMPORT_C void asn1Print_MsrPosition_Rsp
   (const char* name, ASN1T_MsrPosition_Rsp* pvalue);

IMPORT_C void asn1Free_MsrPosition_Rsp (OSCTXT *pctxt, ASN1T_MsrPosition_Rsp* pvalue);

/**************************************************************/
/*                                                            */
/*  MoreAssDataToBeSent                                       */
/*                                                            */
/**************************************************************/

#define TV_MoreAssDataToBeSent	(TM_UNIV|TM_PRIM|10)

struct MoreAssDataToBeSent {
   enum Root {
      noMoreMessages = 0,
      moreMessagesOnTheWay = 1
   } ;
} ;

typedef OSUINT32 ASN1T_MoreAssDataToBeSent;

IMPORT_C int asn1PE_MoreAssDataToBeSent (OSCTXT* pctxt, ASN1T_MoreAssDataToBeSent value);

IMPORT_C int asn1PD_MoreAssDataToBeSent (OSCTXT* pctxt, ASN1T_MoreAssDataToBeSent* pvalue);

IMPORT_C void asn1Print_MoreAssDataToBeSent
   (const char* name, ASN1T_MoreAssDataToBeSent* pvalue);

IMPORT_C const OSUTF8CHAR* ASN1T_MoreAssDataToBeSent_ToString (OSINT32 value);

IMPORT_C int ASN1T_MoreAssDataToBeSent_ToEnum (OSCTXT* pctxt,
   const OSUTF8CHAR* value, ASN1T_MoreAssDataToBeSent* pvalue);

/**************************************************************/
/*                                                            */
/*  Rel98_AssistanceData_Extension                            */
/*                                                            */
/**************************************************************/

#define TV_Rel98_AssistanceData_Extension	(TM_UNIV|TM_CONS|16)

struct ASN1T_Rel98_AssistanceData_Extension {
   struct {
      unsigned rel98_Ext_ExpOTDPresent : 1;
      unsigned gpsTimeAssistanceMeasurementRequestPresent : 1;
      unsigned gpsReferenceTimeUncertaintyPresent : 1;
   } m;
   ASN1T_Rel98_Ext_ExpOTD rel98_Ext_ExpOTD;
   ASN1T_GPSReferenceTimeUncertainty gpsReferenceTimeUncertainty;
   IMPORT_C ASN1T_Rel98_AssistanceData_Extension ();
} ;

IMPORT_C int asn1PE_Rel98_AssistanceData_Extension (OSCTXT* pctxt, ASN1T_Rel98_AssistanceData_Extension* pvalue);

IMPORT_C int asn1PD_Rel98_AssistanceData_Extension (OSCTXT* pctxt, ASN1T_Rel98_AssistanceData_Extension* pvalue);

IMPORT_C void asn1Print_Rel98_AssistanceData_Extension
   (const char* name, ASN1T_Rel98_AssistanceData_Extension* pvalue);

IMPORT_C void asn1Free_Rel98_AssistanceData_Extension (OSCTXT *pctxt, ASN1T_Rel98_AssistanceData_Extension* pvalue);

/**************************************************************/
/*                                                            */
/*  Rel5_AssistanceData_Extension                             */
/*                                                            */
/**************************************************************/

#define TV_Rel5_AssistanceData_Extension	(TM_UNIV|TM_CONS|16)

struct ASN1T_Rel5_AssistanceData_Extension {
   ASN1T_Extended_reference extended_reference;
   IMPORT_C ASN1T_Rel5_AssistanceData_Extension ();
} ;

IMPORT_C int asn1PE_Rel5_AssistanceData_Extension (OSCTXT* pctxt, ASN1T_Rel5_AssistanceData_Extension* pvalue);

IMPORT_C int asn1PD_Rel5_AssistanceData_Extension (OSCTXT* pctxt, ASN1T_Rel5_AssistanceData_Extension* pvalue);

IMPORT_C void asn1Print_Rel5_AssistanceData_Extension
   (const char* name, ASN1T_Rel5_AssistanceData_Extension* pvalue);

/**************************************************************/
/*                                                            */
/*  AssistanceData                                            */
/*                                                            */
/**************************************************************/

#define TV_AssistanceData	(TM_UNIV|TM_CONS|16)

struct ASN1T_AssistanceData {
   struct {
      unsigned referenceAssistDataPresent : 1;
      unsigned msrAssistDataPresent : 1;
      unsigned systemInfoAssistDataPresent : 1;
      unsigned gps_AssistDataPresent : 1;
      unsigned moreAssDataToBeSentPresent : 1;
      unsigned extensionContainerPresent : 1;
      unsigned rel98_AssistanceData_ExtensionPresent : 1;
      unsigned rel5_AssistanceData_ExtensionPresent : 1;
   } m;
   ASN1T_ReferenceAssistData referenceAssistData;
   ASN1T_MsrAssistData msrAssistData;
   ASN1T_SystemInfoAssistData systemInfoAssistData;
   ASN1T_GPS_AssistData gps_AssistData;
   ASN1T_MoreAssDataToBeSent moreAssDataToBeSent;
   ASN1T_ExtensionContainer extensionContainer;
   ASN1T_Rel98_AssistanceData_Extension rel98_AssistanceData_Extension;
   ASN1T_Rel5_AssistanceData_Extension rel5_AssistanceData_Extension;
   IMPORT_C ASN1T_AssistanceData ();
} ;

IMPORT_C int asn1PE_AssistanceData (OSCTXT* pctxt, ASN1T_AssistanceData* pvalue);

IMPORT_C int asn1PD_AssistanceData (OSCTXT* pctxt, ASN1T_AssistanceData* pvalue);

IMPORT_C void asn1Print_AssistanceData
   (const char* name, ASN1T_AssistanceData* pvalue);

IMPORT_C void asn1Free_AssistanceData (OSCTXT *pctxt, ASN1T_AssistanceData* pvalue);

/**************************************************************/
/*                                                            */
/*  ErrorCodes                                                */
/*                                                            */
/**************************************************************/

#define TV_ErrorCodes	(TM_UNIV|TM_PRIM|10)

struct ErrorCodes {
   enum Root {
      unDefined = 0,
      missingComponet = 1,
      incorrectData = 2,
      missingIEorComponentElement = 3,
      messageTooShort = 4,
      unknowReferenceNumber = 5
   } ;
} ;

typedef OSUINT32 ASN1T_ErrorCodes;

IMPORT_C int asn1PE_ErrorCodes (OSCTXT* pctxt, ASN1T_ErrorCodes value);

IMPORT_C int asn1PD_ErrorCodes (OSCTXT* pctxt, ASN1T_ErrorCodes* pvalue);

IMPORT_C void asn1Print_ErrorCodes
   (const char* name, ASN1T_ErrorCodes* pvalue);

IMPORT_C const OSUTF8CHAR* ASN1T_ErrorCodes_ToString (OSINT32 value);

IMPORT_C int ASN1T_ErrorCodes_ToEnum (OSCTXT* pctxt,
   const OSUTF8CHAR* value, ASN1T_ErrorCodes* pvalue);

/**************************************************************/
/*                                                            */
/*  Rel_5_ProtocolError_Extension                             */
/*                                                            */
/**************************************************************/

#define TV_Rel_5_ProtocolError_Extension	(TM_UNIV|TM_CONS|16)

struct ASN1T_Rel_5_ProtocolError_Extension {
   struct {
      unsigned extended_referencePresent : 1;
   } m;
   ASN1T_Extended_reference extended_reference;
   IMPORT_C ASN1T_Rel_5_ProtocolError_Extension ();
} ;

IMPORT_C int asn1PE_Rel_5_ProtocolError_Extension (OSCTXT* pctxt, ASN1T_Rel_5_ProtocolError_Extension* pvalue);

IMPORT_C int asn1PD_Rel_5_ProtocolError_Extension (OSCTXT* pctxt, ASN1T_Rel_5_ProtocolError_Extension* pvalue);

IMPORT_C void asn1Print_Rel_5_ProtocolError_Extension
   (const char* name, ASN1T_Rel_5_ProtocolError_Extension* pvalue);

/**************************************************************/
/*                                                            */
/*  ProtocolError                                             */
/*                                                            */
/**************************************************************/

#define TV_ProtocolError	(TM_UNIV|TM_CONS|16)

struct ASN1T_ProtocolError {
   struct {
      unsigned extensionContainerPresent : 1;
      unsigned rel_5_ProtocolError_ExtensionPresent : 1;
   } m;
   ASN1T_ErrorCodes errorCause;
   ASN1T_ExtensionContainer extensionContainer;
   ASN1T_Rel_5_ProtocolError_Extension rel_5_ProtocolError_Extension;
   IMPORT_C ASN1T_ProtocolError ();
} ;

IMPORT_C int asn1PE_ProtocolError (OSCTXT* pctxt, ASN1T_ProtocolError* pvalue);

IMPORT_C int asn1PD_ProtocolError (OSCTXT* pctxt, ASN1T_ProtocolError* pvalue);

IMPORT_C void asn1Print_ProtocolError
   (const char* name, ASN1T_ProtocolError* pvalue);

IMPORT_C void asn1Free_ProtocolError (OSCTXT *pctxt, ASN1T_ProtocolError* pvalue);

/**************************************************************/
/*                                                            */
/*  SLR_Arg_PCS_Extensions                                    */
/*                                                            */
/**************************************************************/

#define TV_SLR_Arg_PCS_Extensions	(TM_UNIV|TM_CONS|16)

struct ASN1T_SLR_Arg_PCS_Extensions {
   struct {
      unsigned na_ESRK_RequestPresent : 1;
   } m;
   OSOCTET __dummy__;
   IMPORT_C ASN1T_SLR_Arg_PCS_Extensions ();
} ;

IMPORT_C int asn1PE_SLR_Arg_PCS_Extensions (OSCTXT* pctxt, ASN1T_SLR_Arg_PCS_Extensions* pvalue);

IMPORT_C int asn1PD_SLR_Arg_PCS_Extensions (OSCTXT* pctxt, ASN1T_SLR_Arg_PCS_Extensions* pvalue);

IMPORT_C void asn1Print_SLR_Arg_PCS_Extensions
   (const char* name, ASN1T_SLR_Arg_PCS_Extensions* pvalue);

/**************************************************************/
/*                                                            */
/*  SLR_ArgExtensionContainer                                 */
/*                                                            */
/**************************************************************/

#define TV_SLR_ArgExtensionContainer	(TM_UNIV|TM_CONS|16)

struct ASN1T_SLR_ArgExtensionContainer : public ASN1TPDU {
   struct {
      unsigned privateExtensionListPresent : 1;
      unsigned slr_Arg_PCS_ExtensionsPresent : 1;
   } m;
   ASN1T_PrivateExtensionList privateExtensionList;
   ASN1T_SLR_Arg_PCS_Extensions slr_Arg_PCS_Extensions;
   IMPORT_C ASN1T_SLR_ArgExtensionContainer ();
   IMPORT_C ~ASN1T_SLR_ArgExtensionContainer ();
} ;

class ASN1C_SLR_ArgExtensionContainer :
public ASN1CType
{
protected:
   ASN1T_SLR_ArgExtensionContainer& msgData;
public:
   IMPORT_C ASN1C_SLR_ArgExtensionContainer (ASN1T_SLR_ArgExtensionContainer& data);
   IMPORT_C ASN1C_SLR_ArgExtensionContainer (OSRTMessageBufferIF& msgBuf
      , ASN1T_SLR_ArgExtensionContainer& data);
   IMPORT_C ASN1C_SLR_ArgExtensionContainer (OSRTContext &context
      , ASN1T_SLR_ArgExtensionContainer& data);

   inline ASN1T_SLR_ArgExtensionContainer& getData () { return msgData; }
   inline const ASN1T_SLR_ArgExtensionContainer& getData () const { return msgData; }

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   IMPORT_C int EncodeTo (OSRTMessageBufferIF& msgBuf);
   IMPORT_C int DecodeFrom (OSRTMessageBufferIF& msgBuf);

   IMPORT_C void Print (const char* name);
} ;

IMPORT_C int asn1PE_SLR_ArgExtensionContainer (OSCTXT* pctxt, ASN1T_SLR_ArgExtensionContainer* pvalue);

IMPORT_C int asn1PD_SLR_ArgExtensionContainer (OSCTXT* pctxt, ASN1T_SLR_ArgExtensionContainer* pvalue);

IMPORT_C void asn1Print_SLR_ArgExtensionContainer
   (const char* name, ASN1T_SLR_ArgExtensionContainer* pvalue);

IMPORT_C void asn1Free_SLR_ArgExtensionContainer (OSCTXT *pctxt, ASN1T_SLR_ArgExtensionContainer* pvalue);

#endif
