// Copyright (c) 2001-2009 Objective Systems, Inc. (http://www.obj-sys.com) 
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available 
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//

/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).
 */
#ifndef ULP_H
#define ULP_H

#include <stdio.h>
#include <stdlib.h>
#include "rtkey.h"
#include "rtpersrc/asn1PerCppTypes.h"
#include "ULP-Components.h"
#include "SUPL-INIT.h"
#include "SUPL-START.h"
#include "SUPL-RESPONSE.h"
#include "SUPL-POS-INIT.h"
#include "SUPL-POS.h"
#include "SUPL-END.h"
#include "SUPL-AUTH-REQ.h"
#include "SUPL-AUTH-RESP.h"

/**
 * Header file for ASN.1 module ULP
 */
/**************************************************************/
/*                                                            */
/*  UlpMessage                                                */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_UlpMessage_msSUPLINIT         1
#define T_UlpMessage_msSUPLSTART        2
#define T_UlpMessage_msSUPLRESPONSE     3
#define T_UlpMessage_msSUPLPOSINIT      4
#define T_UlpMessage_msSUPLPOS          5
#define T_UlpMessage_msSUPLEND          6
#define T_UlpMessage_msSUPLAUTHREQ      7
#define T_UlpMessage_msSUPLAUTHRESP     8
#define T_UlpMessage_extElem1           9

struct ASN1T_UlpMessage {
   int t;
   union {
      /* t = 1 */
      ASN1T_SUPLINIT *msSUPLINIT;
      /* t = 2 */
      ASN1T_SUPLSTART *msSUPLSTART;
      /* t = 3 */
      ASN1T_SUPLRESPONSE *msSUPLRESPONSE;
      /* t = 4 */
      ASN1T_SUPLPOSINIT *msSUPLPOSINIT;
      /* t = 5 */
      ASN1T_SUPLPOS *msSUPLPOS;
      /* t = 6 */
      ASN1T_SUPLEND *msSUPLEND;
      /* t = 7 */
      ASN1T_SUPLAUTHREQ *msSUPLAUTHREQ;
      /* t = 8 */
      ASN1T_SUPLAUTHRESP *msSUPLAUTHRESP;
      /* t = 9 */
   } u;
} ;

IMPORT_C int asn1PE_UlpMessage (OSCTXT* pctxt, ASN1T_UlpMessage* pvalue);

IMPORT_C int asn1PD_UlpMessage (OSCTXT* pctxt, ASN1T_UlpMessage* pvalue);

EXTERN void asn1Print_UlpMessage
   (const char* name, ASN1T_UlpMessage* pvalue);

IMPORT_C void asn1Free_UlpMessage (OSCTXT *pctxt, ASN1T_UlpMessage* pvalue);

/**************************************************************/
/*                                                            */
/*  ULP_PDU                                                   */
/*                                                            */
/**************************************************************/

#define TV_ULP_PDU	(TM_UNIV|TM_CONS|16)

struct ASN1T_ULP_PDU : public ASN1TPDU {
   OSUINT16 length;
   ASN1T_Version version;
   ASN1T_SessionID sessionID;
   ASN1T_UlpMessage message;
   IMPORT_C ASN1T_ULP_PDU ();
   IMPORT_C ~ASN1T_ULP_PDU ();
} ;

class ASN1C_ULP_PDU :
public ASN1CType
{
protected:
   ASN1T_ULP_PDU& msgData;
public:
   IMPORT_C ASN1C_ULP_PDU (ASN1T_ULP_PDU& data);
   IMPORT_C ASN1C_ULP_PDU (OSRTMessageBufferIF& msgBuf, ASN1T_ULP_PDU& data);
   IMPORT_C ASN1C_ULP_PDU (OSRTContext &context, ASN1T_ULP_PDU& data);

   inline ASN1T_ULP_PDU& getData () { return msgData; }
   inline const ASN1T_ULP_PDU& getData () const { return msgData; }

   // standard encode/decode methods (defined in ASN1CType base class):
   // int Encode ();
   // int Decode ();

   // stream encode/decode methods:
   IMPORT_C int EncodeTo (OSRTMessageBufferIF& msgBuf);
   IMPORT_C int DecodeFrom (OSRTMessageBufferIF& msgBuf);

   EXTERN void Print ();
} ;

IMPORT_C int asn1PE_ULP_PDU (OSCTXT* pctxt, ASN1T_ULP_PDU* pvalue);

IMPORT_C int asn1PD_ULP_PDU (OSCTXT* pctxt, ASN1T_ULP_PDU* pvalue);

EXTERN void asn1Print_ULP_PDU
   (const char* name, ASN1T_ULP_PDU* pvalue);

IMPORT_C void asn1Free_ULP_PDU (OSCTXT *pctxt, ASN1T_ULP_PDU* pvalue);

#endif
