// Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Example CTestStep derived implementation
// 
//

/**
 @file OpenTestStep.cpp
 @internalTechnology
*/
#include "openteststep.h"
#include "te_locsrvsuitedefs.h"

COpenTestStep::~COpenTestStep()
/**
 * Destructor
 */
	{
	}

COpenTestStep::COpenTestStep()
/**
 * Constructor
 */
	{
	SetTestStepName(KOpenTestStep);
	}

TVerdict COpenTestStep::doTestStepPreambleL()
/**
 * @return - TVerdict code
 * Override of base class virtual
 */
	{
	CTe_locsrvSuiteStepBase::doTestStepPreambleL();
	SetTestStepResult(EPass);
	return TestStepResult();
	}


TVerdict COpenTestStep::doTestStepL()
/**
 * @return - TVerdict code
 * Override of base class pure virtual
 * Our implementation only gets called if the base class doTestStepPreambleL() did
 * not leave. That being the case, the current test result value will be EPass.
 */
	{
    StandardPrepareL();
    
    RPositionServer server;
    TInt err = server.Connect();
    if(err != KErrNone)
        {
        ERR_PRINTF1(KFailedConnectServer);
        SetTestStepResult(EFail);
        return TestStepResult();
        }
    
    RPositioner positioner;
    err = positioner.Open(server);
    if(err != KErrNone)
        {
        ERR_PRINTF1(KFailedOepenDefaultPSY);
        SetTestStepResult(EFail);
        return TestStepResult();
        }
    
    positioner.Close();
    server.Close();
    
    return TestStepResult();
	}



TVerdict COpenTestStep::doTestStepPostambleL()
/**
 * @return - TVerdict code
 * Override of base class virtual
 */
	{
	return TestStepResult();
	}
