// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

/**
 @file
 @internalTechnology
 
*/
#ifndef LBS_SUPL_SPOOF_SERVER_H
#define LBS_SUPL_SPOOF_SERVER_H

#include <e32base.h>

class ASN1T_ULP_PDU;
class ASN1C_ULP_PDU;
class ASN1T_PDU;
class ASN1C_PDU;
class ASN1PEREncodeBuffer;
class OSCTXT;

enum ESuplMessageType
	{
	ESuplInit,
	ESuplResponse,
	ESuplPosInit,
	ESuplPos,
	ESuplEnd,
	ESuplAuthReq,
	ESuplAuthResp
	};
	
/**
SUPL Spoof Server

Generates ASN1 encoded SUPL messages.
Decodes and checks content of ASN1 encoded SUPL messages.

Required for testing of the SUPL Protocol Controller ASN1 library.
Messages generated by the spoof server are used for testing the
decoding of received messages. Encoding of sent messages is checked
by the decode and check methods.

@internalTechnology
*/
class CSuplSpoofServer : public CBase
	{
public:
	IMPORT_C static CSuplSpoofServer* NewL();
		
public:
	virtual ~CSuplSpoofServer();
	
public:

	// encoded supl message generators
	IMPORT_C TInt GenerateSuplInitL(TPtr8& aBufPtr);
	IMPORT_C TInt GenerateSuplResponseL(TPtr8& aBufPtr);
	IMPORT_C TInt GenerateSuplPosRrlpAssistanceDataL(TPtr8& aBufPtr);
	IMPORT_C TInt GenerateSuplPosRrlpMeasurePositionRequestL(TPtr8& aBufPtr);
	IMPORT_C TInt GenerateSuplPosRrlpProtocolErrorL(TPtr8& aBufPtr);
	IMPORT_C TInt GenerateSuplEndL(TPtr8& aBufPtr);
	
	// test decoder
	IMPORT_C TInt DecodeL(const TPtrC8* aBuf);
	
private:
	/** Constructor */
	CSuplSpoofServer();
	
	/** second stage constructor */
	void ConstructL();
	
private:
	// encoded rrlp payload generators
	TInt genRrlpAssistanceDataL(TPtr8& aPayloadPtr);
	TInt genRrlpMeasurePositionRequestL(TPtr8& aPayloadPtr);
	TInt genRrlpProtocolErrorL(TPtr8& aPayloadPtr);

	// SUPL content generators
	ASN1T_ULP_PDU* genSuplCommonContent(OSCTXT *pctxt);
	ASN1T_ULP_PDU* genSuplResponseContent(OSCTXT *pctxt);
	ASN1T_ULP_PDU* genSuplPosContent(OSCTXT *pctxt, TPtr8& aPayloadPtr);
	ASN1T_ULP_PDU* genSuplEndContent(OSCTXT *pctxt);
	ASN1T_ULP_PDU* genSuplInitContent(OSCTXT *pctxt);
	
	// RRLP content generators
	ASN1T_PDU* genRrlpAssistanceDataContent(OSCTXT *pctxt);
	ASN1T_PDU* genRrlpMeasurePositionRequestContent(OSCTXT *pctxt);
	ASN1T_PDU* genRrlpProtocolErrorContent(OSCTXT *pctxt);

	// received content checkers	
	TInt CheckSuplCommonContent(ASN1T_ULP_PDU& decodeData);
	TInt CheckSuplStartContent(ASN1T_ULP_PDU& decodeData);
	TInt CheckSuplPosInitContent(ASN1T_ULP_PDU& decodeData);
	TInt CheckSuplEndContent(ASN1T_ULP_PDU& decodeData);
	TInt CheckSuplPosContent(ASN1T_ULP_PDU& decodeData);
	TInt CheckRrlpMsrPosResponseContent(ASN1T_PDU& decodeData);
	TInt CheckRrlpProtocolErrorContent(ASN1T_PDU& decodeData);
	
	// utils
	TUint CSuplSpoofServer::CovertStringToUintL(const TDesC8& aString, TUint8 aNum);

private: 
	ASN1PEREncodeBuffer* iEncodeBuffer;
    ASN1T_ULP_PDU* iData;
    ASN1C_ULP_PDU* iUlpPdu;
    
    ASN1PEREncodeBuffer* iRrlpEncodeBuffer;
    ASN1T_PDU* iRrlpData;
    ASN1C_PDU* iRrlpPdu;
	};

#endif // LBS_SUPL_SPOOF_SERVER_H

