// Copyright (c) 2001-2009 Objective Systems, Inc. (http://www.obj-sys.com) 
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available 
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//

/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).
 */
#ifndef SUPL_POS_H
#define SUPL_POS_H

#include <stdio.h>
#include <stdlib.h>
#include "rtkey.h"
#include "rtpersrc/asn1PerCppTypes.h"
#include "ULP-Components.h"

/**
 * Header file for ASN.1 module SUPL-POS
 */
/**************************************************************/
/*                                                            */
/*  PosPayLoad_tia801payload                                  */
/*                                                            */
/**************************************************************/

#define TV_PosPayLoad_tia801payload	(TM_UNIV|TM_PRIM|4)

struct ASN1T_PosPayLoad_tia801payload {
   OSUINT32 numocts;
   OSOCTET data[8192];
   // ctors
   ASN1T_PosPayLoad_tia801payload () : numocts(0) {}
   ASN1T_PosPayLoad_tia801payload (OSUINT32 _numocts, const OSOCTET* _data) :
      numocts (_numocts) {
      OSCRTLMEMCPY (data, _data, OSRTMIN (numocts, sizeof(data)));
   }
   ASN1T_PosPayLoad_tia801payload (const char* cstring) {
      if (strlen(cstring) > 0) {
         numocts = OSRTMIN ((OSCRTLSTRLEN(cstring)+1), sizeof(data));
         OSCRTLSTRNCPY ((char*)data, cstring, sizeof(data));
      }
      else numocts = 0;
   }
   // assignment operators
   ASN1T_PosPayLoad_tia801payload& operator= (const char* cstring) {
      if (strlen(cstring) > 0) {
         numocts = OSRTMIN ((OSCRTLSTRLEN(cstring)+1), sizeof(data));
         OSCRTLSTRNCPY ((char*)data, cstring, sizeof(data));
      }
      else numocts = 0;
      return *this;
   }
} ;

IMPORT_C int asn1PE_PosPayLoad_tia801payload (OSCTXT* pctxt, ASN1T_PosPayLoad_tia801payload* pvalue);

IMPORT_C int asn1PD_PosPayLoad_tia801payload (OSCTXT* pctxt, ASN1T_PosPayLoad_tia801payload* pvalue);

IMPORT_C void asn1Print_PosPayLoad_tia801payload
   (const char* name, ASN1T_PosPayLoad_tia801payload* pvalue);

/**************************************************************/
/*                                                            */
/*  PosPayLoad_rrcPayload                                     */
/*                                                            */
/**************************************************************/

#define TV_PosPayLoad_rrcPayload	(TM_UNIV|TM_PRIM|4)

struct ASN1T_PosPayLoad_rrcPayload {
   OSUINT32 numocts;
   OSOCTET data[8192];
   // ctors
   ASN1T_PosPayLoad_rrcPayload () : numocts(0) {}
   ASN1T_PosPayLoad_rrcPayload (OSUINT32 _numocts, const OSOCTET* _data) :
      numocts (_numocts) {
      OSCRTLMEMCPY (data, _data, OSRTMIN (numocts, sizeof(data)));
   }
   ASN1T_PosPayLoad_rrcPayload (const char* cstring) {
      if (strlen(cstring) > 0) {
         numocts = OSRTMIN ((OSCRTLSTRLEN(cstring)+1), sizeof(data));
         OSCRTLSTRNCPY ((char*)data, cstring, sizeof(data));
      }
      else numocts = 0;
   }
   // assignment operators
   ASN1T_PosPayLoad_rrcPayload& operator= (const char* cstring) {
      if (strlen(cstring) > 0) {
         numocts = OSRTMIN ((OSCRTLSTRLEN(cstring)+1), sizeof(data));
         OSCRTLSTRNCPY ((char*)data, cstring, sizeof(data));
      }
      else numocts = 0;
      return *this;
   }
} ;

IMPORT_C int asn1PE_PosPayLoad_rrcPayload (OSCTXT* pctxt, ASN1T_PosPayLoad_rrcPayload* pvalue);

IMPORT_C int asn1PD_PosPayLoad_rrcPayload (OSCTXT* pctxt, ASN1T_PosPayLoad_rrcPayload* pvalue);

IMPORT_C void asn1Print_PosPayLoad_rrcPayload
   (const char* name, ASN1T_PosPayLoad_rrcPayload* pvalue);

/**************************************************************/
/*                                                            */
/*  PosPayLoad_rrlpPayload                                    */
/*                                                            */
/**************************************************************/

#define TV_PosPayLoad_rrlpPayload	(TM_UNIV|TM_PRIM|4)

struct ASN1T_PosPayLoad_rrlpPayload {
   OSUINT32 numocts;
   OSOCTET data[8192];
   // ctors
   ASN1T_PosPayLoad_rrlpPayload () : numocts(0) {}
   ASN1T_PosPayLoad_rrlpPayload (OSUINT32 _numocts, const OSOCTET* _data) :
      numocts (_numocts) {
      OSCRTLMEMCPY (data, _data, OSRTMIN (numocts, sizeof(data)));
   }
   ASN1T_PosPayLoad_rrlpPayload (const char* cstring) {
      if (strlen(cstring) > 0) {
         numocts = OSRTMIN ((OSCRTLSTRLEN(cstring)+1), sizeof(data));
         OSCRTLSTRNCPY ((char*)data, cstring, sizeof(data));
      }
      else numocts = 0;
   }
   // assignment operators
   ASN1T_PosPayLoad_rrlpPayload& operator= (const char* cstring) {
      if (strlen(cstring) > 0) {
         numocts = OSRTMIN ((OSCRTLSTRLEN(cstring)+1), sizeof(data));
         OSCRTLSTRNCPY ((char*)data, cstring, sizeof(data));
      }
      else numocts = 0;
      return *this;
   }
} ;

IMPORT_C int asn1PE_PosPayLoad_rrlpPayload (OSCTXT* pctxt, ASN1T_PosPayLoad_rrlpPayload* pvalue);

IMPORT_C int asn1PD_PosPayLoad_rrlpPayload (OSCTXT* pctxt, ASN1T_PosPayLoad_rrlpPayload* pvalue);

IMPORT_C void asn1Print_PosPayLoad_rrlpPayload
   (const char* name, ASN1T_PosPayLoad_rrlpPayload* pvalue);

/**************************************************************/
/*                                                            */
/*  PosPayLoad                                                */
/*                                                            */
/**************************************************************/

/* Choice tag constants */

#define T_PosPayLoad_tia801payload      1
#define T_PosPayLoad_rrcPayload         2
#define T_PosPayLoad_rrlpPayload        3
#define T_PosPayLoad_extElem1           4

struct ASN1T_PosPayLoad {
   int t;
   union {
      /* t = 1 */
      ASN1T_PosPayLoad_tia801payload *tia801payload;
      /* t = 2 */
      ASN1T_PosPayLoad_rrcPayload *rrcPayload;
      /* t = 3 */
      ASN1T_PosPayLoad_rrlpPayload *rrlpPayload;
      /* t = 4 */
   } u;
} ;

IMPORT_C int asn1PE_PosPayLoad (OSCTXT* pctxt, ASN1T_PosPayLoad* pvalue);

IMPORT_C int asn1PD_PosPayLoad (OSCTXT* pctxt, ASN1T_PosPayLoad* pvalue);

IMPORT_C void asn1Print_PosPayLoad
   (const char* name, ASN1T_PosPayLoad* pvalue);

IMPORT_C void asn1Free_PosPayLoad (OSCTXT *pctxt, ASN1T_PosPayLoad* pvalue);

/**************************************************************/
/*                                                            */
/*  SUPLPOS                                                   */
/*                                                            */
/**************************************************************/

#define TV_SUPLPOS	(TM_UNIV|TM_CONS|16)

struct ASN1T_SUPLPOS {
   struct {
      unsigned velocityPresent : 1;
   } m;
   ASN1T_PosPayLoad posPayLoad;
   ASN1T_Velocity velocity;
   IMPORT_C ASN1T_SUPLPOS ();
} ;

IMPORT_C int asn1PE_SUPLPOS (OSCTXT* pctxt, ASN1T_SUPLPOS* pvalue);

IMPORT_C int asn1PD_SUPLPOS (OSCTXT* pctxt, ASN1T_SUPLPOS* pvalue);

IMPORT_C void asn1Print_SUPLPOS
   (const char* name, ASN1T_SUPLPOS* pvalue);

IMPORT_C void asn1Free_SUPLPOS (OSCTXT *pctxt, ASN1T_SUPLPOS* pvalue);

#endif
