/*
* Copyright (c) 2005-2010 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/

#ifndef __LBSLOCATORCLASSTYPES_H__
#define __LBSLOCATORCLASSTYPES_H__

#include <e32base.h>

/**
@file
@internalTechnology
@prototype
*/

enum TLbsLocatorClassTypes
    {
    ELbsLocatorBaseClassType   = 0x01,
    ELbsLocationClassType      = 0x02,
    ELbsMovementEventClassType = 0x04
    };

/**
 * TLbsLocatorClassTypeBase - Base class for data generated by CLbsLocator.
 * 
 * 
 */
class TLbsLocatorClassTypeBase
    {
public:
    IMPORT_C TUint32 LocatorClassType() const;

    IMPORT_C TUint LocatorClassSize() const;

protected:
    TLbsLocatorClassTypeBase();

protected:
    /** The type of the derived class */
    TUint32 iClassType;
    /** The size of the derived class */
    TUint iClassSize;
    };

#endif //__LBSLOCATORCLASSTYPES_H__
