/*
* Copyright (c) 2008 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/


#ifndef LBSCOMMONINTERNALDATATYPES_H
#define LBSCOMMONINTERNALDATATYPES_H

#include <e32std.h>


/** 
@file
@internalTechnology
@released
*/

//
// All declarations and definitions below are duplicated from lbsassistancedatabase.h
// (lbsassistancedata.dll)
//

/**
defines type for TLbsAsistanceDataGroupInt
 */
typedef TUint32 TLbsAsistanceDataGroupInt;


//
// All declarations and definitions below are duplicated from lbscommon.h
// (lbselflocate.dll)
//

class TPositionModuleInfoInt
/**
The standard class for storing information on position modules
 */
	{
public:
	/**
	 Technology types
	 */
	typedef TUint32 TTechnologyTypeInt;

	/**
	 Technology Type
	 */ 
	enum _TTechnologyTypeInt
		{
		/** Indicates that the positioning module is unaware of the technology
		used to obtain position information */
		ETechnologyUnknown	= 0,
		/** The primary positioning technology is handset based.
		For example standard GPS */
		ETechnologyTerminal	= 0x01,
		/** The primary positioning technology is network based.
		For example, E-OTD */
		ETechnologyNetwork	= 0x02,
		/** The primary positioning mechanism receives assistance in some form.
		Generally to obtain a quicker or more accurate fix */
		ETechnologyAssisted	= 0x04
		};
	};


//
// All declarations and definitions below are duplicated from the header lbsnetclasstypes
// (lbsnetprotocol.dll)
//

/**
 * Class types for TLbsNetSessionIdInt and its derived classes 
 */
enum TLbsNetSessionIdClassTypeInt
	{
	ELbsNetSessionIdUnknownClassInt = 0x00,
	ELbsNetSessionIdClassInt        = 0x01,
	ELbsNetSessionIdArrayClassInt   = 0x02,
	ELbsNetSessionIdLastClassInt    = 0xFFFFFFFF
	};

/**
 * Class types for ELbsNetPosRequestPrivacyClassInt and its derived classes 
 */
enum TLbsNetPosRequestPrivacyClassTypeInt
	{
	ELbsNetPosRequestPrivacyUnknownClassInt = 0x00,
	ELbsNetPosRequestPrivacyClassInt        = 0x01,
	ELbsNetPosRequestPrivacyLastClassInt    = 0xFFFFFFFF
	};

/**
 * Class types for TLbsNetRequestQualityInt and its derived classes 
 */
enum TLbsNetRequestQualityClassTypeInt
	{
	ELbsNetPosRequestQualityUnknownClassInt = 0x00,
	ELbsNetPosRequestQualityClassInt        = 0x01,
	ELbsNetPosRequestQualityLastClassInt    = 0xFFFFFFFF
	};

/**
 * Class types for TLbsNetPosRequestOptions and its derived classes 
 */
enum TLbsNetPosRequestOptionsClassTypeInt
	{
	ELbsNetPosRequestOptionsUnknownClassInt    = 0x00,
	ELbsNetPosRequestOptionsBaseClassInt       = 0x01,
	ELbsNetPosRequestOptionsClassInt           = 0x02,
	ELbsNetPosRequestOptionsAssistanceClassInt = 0x04,
	ELbsNetPosRequestOptionsTechnologyClassInt = 0x08,
	ELbsNetPosRequestOptionsLastClassInt       = 0xFFFFFFFF
	};

/**
 * Class types for TLbsNetPosMethodInt and its derived classes 
 */
enum TLbsNetPosMethodClassTypeInt
	{
	ELbsNetPosMethodUnknownClassInt = 0x00,
	ELbsNetPosMethodClassInt        = 0x01,
	ELbsNetPosMethodLastClassInt    = 0xFFFFFFFF
	};

/**
 * Class types for TLbsNetPosRequestMethodInt and its derived classes 
 */
enum TLbsNetPosRequestMethodClassTypeInt
	{
	ELbsNetPosRequestMethodUnknownClassInt = 0x00,
	ELbsNetPosRequestMethodClassInt        = 0x01,
	ELbsNetPosRequestMethodLastClassInt    = 0xFFFFFFFF
	};


//
// All declarations and definitions below are duplicated from the header lbsnetcommon
// (lbsnetprotocol.dll)
//

/**
GPS positioning means

This is the only means supported

@see TLbsNetPosMethod::TLbsNetPosMethod
@see TLbsNetPosMethod::PosMeans
*/
const TUid KLbsPositioningMeansGpsInt   = { 0x10282295 };
/**
The maximum number of concurrent positioning sessions

@see TLbsNetSessionIdArrayInt
*/
const TInt KLbsMaxNetSessionsInt = 10;

/**
The maximum number of supported positioning methods 
@see TLbsNetPosCapabilities::SetPosMethods
*/
const TInt KLbsMaxNetPosMethodsInt   = 10;

/**
The generic base for classes that store Lbs network related information
 */
class TLbsNetClassTypeBaseInt
	{
public:
	IMPORT_C TUint32 ClassType() const;
	IMPORT_C TUint ClassSize() const;

protected:
	IMPORT_C TLbsNetClassTypeBaseInt();

protected:
	/** The type of the derived class */
	TUint32 iClassType;
	/** The size of the derived class */
	TUint iClassSize;
	};

/**
Session Identifiers are used to uniquely identify requests either generated by,
or received by, a network protocol module.

TLbsNetSessionIdInt contains two fields - an owner and a request number. 
The owner is the UID of the component that created the request. The request
number is used to uniquely identify a request by that component. 

The request number may increment with each new request. However, this is not
guaranteed. In some instances, the request number will be derived from details
obtained by the network.

For requests generated by the network protocol module, the ECom implementation
UID should be used as the session id owner. Where, requests originate from
within the LBS subsystem, the owner will be the UID of the component that
created the request. This will normally be the Network Request Handler.

@see MLbsNetworkProtocolObserver
@see CLbsNetworkProtocolBase
*/
class TLbsNetSessionIdInt : public TLbsNetClassTypeBaseInt
	{
public:
	typedef TUint32 TSessionNum;

	IMPORT_C TLbsNetSessionIdInt();
	
	IMPORT_C TLbsNetSessionIdInt(TUid aSessionOwner, TSessionNum aSessionNum);

	IMPORT_C TUid SessionOwner() const;
	
	IMPORT_C TSessionNum SessionNum() const;

	IMPORT_C void SetSessionOwner(TUid aSessionOwner);
	
	IMPORT_C void SetSessionNum(TSessionNum aSessionNum);

	IMPORT_C void IncrSession();
	
	IMPORT_C TBool operator==(const TLbsNetSessionIdInt& aSessionId) const;
	IMPORT_C TBool operator!=(const TLbsNetSessionIdInt& aSessionId) const;
	
protected:
	TUid    iSessionOwner;
	TUint32 iSessionNum; 
	};

/**
The class encapsulates an array of @see TLbsNetSessionIdInt session ids.

@see TLbsNetSessionIdInt
@see MLbsNetworkProtocolObserver2
@see CLbsNetworkProtocolBase2
*/
class TLbsNetSessionIdArrayInt : public TLbsNetClassTypeBaseInt
	{
public:
	IMPORT_C TLbsNetSessionIdArrayInt();
	
	IMPORT_C TInt NumSessions() const;
	IMPORT_C TInt GetSession(TInt aIndex, TLbsNetSessionIdInt &aSessionId) const;
	
	IMPORT_C TInt SetSessions(const TLbsNetSessionIdInt aSessions[], TInt aNumSessions);

private:
	TInt 			    iNumSessions;
	TLbsNetSessionIdInt iSessions[KLbsMaxNetSessionsInt];
	};

/**
Privacy procedure requested by the network.

An instance of the class TLbsNetPosRequestPrivacyInt is passed to the LBS subsystem in the method
MLbsNetworkProtocolObserver::ProcessPrivacyRequest(). The class is used to indicate what advice
should be given to the user. For example, this may advise that the user is consulted over
the request or simply notified about it.

The class also specifies whether the request should be accepted or rejected. In the situation
where the user is consulted, the action is the default behaviour when the user does not respond.

For example, if the advice is set to ERequestAdviceVerify and the action is ERequestActionAllow,
this indicates that the user should be asked if they wish to accept or reject the request. 
However, if the user does not respond, the terminal should automatically accept the request.

Alternatively, the network may wish to advise the terminal that it has rejected a location
request designated for the device. In this situation the advice is set to ERequestAdviceNotify
with an action of ERequestActionReject.
	
@see MLbsNetworkProtocolObserver::ProcessPrivacyRequest
*/
class TLbsNetPosRequestPrivacyInt : public TLbsNetClassTypeBaseInt
	{
public:
	enum TLbsRequestAdviceInt
		{
				/** Not Used */
		ERequestAdviceNotUsed = 0,
				/** The LBS subsystem should notify the user that their
				location has been requested. */
		ERequestAdviceNotify,
				/** The LBS subsystem should ask the user if they wish
				to accept or reject an external request. */
		ERequestAdviceVerify,
				/** The LBS subsystem should neither notify or query the user if they wish
				to accept or reject an external request. Details of the request
				should be logged. */
		ERequestAdviceSilent,
				/** The terminal should no indication that the device's location
				is being determined by an external party. The user should neither be notified
				nor queried. In addition, no information about the request should be logged.
				This option is defined by some protocols (e.g. SUPL) but is not implemented
				by the LBS subsystem. */
		ERequestAdviceStealth
		};
		
	enum TLbsRequestActionInt
		{
				/** Not Used */
		ERequestActionNotUsed = 0,
				/** The default action for LBS subsystem should be to accept the request.
				If this value is passed in combination with ERequestAdviceVerify, it
				indicates that the user should be asked if they wish to accept or reject
				the request. However, if the user does not respond, the request should
				be allowed. */
		ERequestActionAllow,
				/** The default action for LBS subsystem should be to reject the request.
				If this value is passed in combination with ERequestAdviceVerify, it
				indicates that the user should be asked if they wish to accept or reject
				the request. However, if the user does not respond, the request should
				be rejected.
		
				If ERequestActionReject is passed in combination with ERequestAdviceNotify,
				it indicates that the user should be informed that a request has been made
				but the terminal should	automatically reject it.*/
		ERequestActionReject,
		};
	
	IMPORT_C TLbsNetPosRequestPrivacyInt();

	IMPORT_C TLbsRequestAdviceInt RequestAdvice() const;
	
	IMPORT_C TLbsRequestActionInt RequestAction() const;

	IMPORT_C void SetRequestAdvice(TLbsRequestAdviceInt aAdvice);
	
	IMPORT_C void SetRequestAction(TLbsRequestActionInt aAction);
	
protected:
	TLbsRequestActionInt iAction;
	TLbsRequestAdviceInt iAdvice;
	};

/**
The TLbsNetPosRequestQualityInt is used by the network protocol module
to specify the desired quality of a location request.
An instance of the class is passed by the protocol module when it
calls MLbsNetworkProtocolObserver::ProcessLocationRequest.

The parameters in TLbsNetPosRequestQualityInt include the desired minumum
horizontal and vertical accuracy for the requested location update.
It also enables a time limit and age of the fix to be specified.

The time limit indicates the maximum time the device should spend
calculating before it responses to network.

The maximum fix age indicates that the network will accept a previous
location calculation that is within the given time period.

It is possible to combine both the desired minimum accuracy and the
maximum time. In this situation the LBS subsystem should respond
either when the desired accuracy has been achieved or when the time
limit has been reached.

@see CLbsLocationSourceBase::RequestLocationUpdate
@see MLbsLocationSourceObserver
*/
class TLbsNetPosRequestQualityInt : public TLbsNetClassTypeBaseInt
	{
public:
	IMPORT_C TLbsNetPosRequestQualityInt();

	IMPORT_C TTimeIntervalMicroSeconds MaxFixTime() const;
	IMPORT_C TTimeIntervalMicroSeconds MaxFixAge()  const;

	IMPORT_C TReal32 MinHorizontalAccuracy() const;
	IMPORT_C TReal32 MinVerticalAccuracy()   const;

	IMPORT_C void SetMaxFixTime(TTimeIntervalMicroSeconds aTime);
	IMPORT_C void SetMaxFixAge(TTimeIntervalMicroSeconds  aTime);

	IMPORT_C void SetMinHorizontalAccuracy(TReal32 aAccuracy);
	IMPORT_C void SetMinVerticalAccuracy(TReal32 aAccuracy);

protected:
	TReal32 iMinHorizontalAccuracy;
	TReal32 iMinVerticalAccuracy;
	TTimeIntervalMicroSeconds iMaxFixTime;
	TTimeIntervalMicroSeconds iMaxFixAge;
	};

/**
This class encapsulated the common parameters for the terminal issuing
a network and a self location request.

@see TLbsNetPosRequestOptionsAssistanceInt
@see TLbsNetworkProtocolEnumInt::RequestNetworkLocation
@see TLbsNetworkProtocolEnumInt::RequestSelfLocation
*/
class TLbsNetPosRequestOptionsInt : public TLbsNetClassTypeBaseInt
	{
public:
	IMPORT_C TLbsNetPosRequestOptionsInt();

	IMPORT_C void SetNewClientConnected(TBool aNewClient);
	IMPORT_C void SetRequestQuality(const TLbsNetPosRequestQualityInt& aQuality);

	IMPORT_C TBool NewClientConnected() const;
	IMPORT_C void  GetRequestQuality(TLbsNetPosRequestQualityInt& aQuality) const;
	
protected:
	TBool iNewClient;
	TLbsNetPosRequestQualityInt iQuality;
	};

/**
This class encapsulated the parameters for the terminal issuing a self
location request.

@see TLbsNetPosRequestOptions
@see TLbsNetworkProtocolEnumInt::RequestSelfLocation
*/
class TLbsNetPosRequestOptionsAssistanceInt : public TLbsNetPosRequestOptionsInt
	{
public:

	IMPORT_C TLbsNetPosRequestOptionsAssistanceInt();

	IMPORT_C void SetDataRequestMask(TLbsAsistanceDataGroupInt aDataRequestMask);
	IMPORT_C void SetPosMode(TPositionModuleInfoInt::TTechnologyTypeInt aPosMode);

	IMPORT_C TLbsAsistanceDataGroupInt DataRequestMask() const;
	IMPORT_C TPositionModuleInfoInt::TTechnologyTypeInt PosMode() const;
		
protected:
	TLbsAsistanceDataGroupInt iDataRequestMask;
	TPositionModuleInfoInt::TTechnologyTypeInt iPosMode;
	};

/**
This class encapsulated the parameters for the terminal issuing a transmit
location request.

@see TLbsNetPosRequestOptions
@see TLbsNetworkProtocolEnumInt::RequestTransmitLocation
*/
class TLbsNetPosRequestOptionsTechnologyInt : public TLbsNetPosRequestOptionsInt
	{
public:

	IMPORT_C TLbsNetPosRequestOptionsTechnologyInt();

	IMPORT_C void SetPosMode(TPositionModuleInfoInt::TTechnologyTypeInt aPosMode);

	IMPORT_C TPositionModuleInfoInt::TTechnologyTypeInt PosMode() const;
		
protected:
	TPositionModuleInfoInt::TTechnologyTypeInt iPosMode;
	};

/**
TLbsNetPosMethod describe a positioning means (technology) and its mode of
operation. It is used to by the network to request that a particilar
method is used when calculating the current location. The class is also
used to detail the positioning capabilities of the device.

@see TLbsNetDeviceCapabilities
*/
class TLbsNetPosMethodInt : public TLbsNetClassTypeBaseInt
	{
public:
	IMPORT_C TLbsNetPosMethodInt();
	
	IMPORT_C TUid PosMeans() const;
	IMPORT_C TPositionModuleInfoInt::TTechnologyTypeInt PosMode() const;

	IMPORT_C void SetPosMethod(TUid aPosMeans, TPositionModuleInfoInt::TTechnologyTypeInt aPosMode);
	
protected: 
	TUid iPosMeans;
	TPositionModuleInfoInt::TTechnologyTypeInt iPosMode;
	};

/**
The class TLbsNetPosRequestMethod is used by the network protocol
module to specify the means and operation mode that should be used
to obtain the device's location.
An instance of the class is passed by the protocol module when it
calls MLbsNetworkProtocolObserver::ProcessLocationRequest.

The class contains a prioritised list of the positioning methods that
should be used to obtain the device's position. The first entry (index
zero) contains the preferred positioning method - for example,
terminal based GPS. The subsequent entries indicate the mechanisms
that should be used if the previous method was not available or was not
successful. Under most protocols, there will be a maximum of two
positioning methods specified.

See TLbsNetPosMethod for information on how different technology
mechanisms (e.g. GPS) and modes (e.g. terminal based) are specified.

@see TLbsNetPosMethodInt
@see MLbsLocationSourceObserver::ProcessLocationRequest
@see MLbsLocationSourceObserver::GetCurrentCapabilities
*/
class TLbsNetPosRequestMethodInt : public TLbsNetClassTypeBaseInt
	{
public:
	IMPORT_C TLbsNetPosRequestMethodInt();

	IMPORT_C TInt NumPosMethods() const;
	IMPORT_C TInt GetPosMethod(TInt aIndex, TLbsNetPosMethodInt& aPosMethod) const;
    IMPORT_C TBool GpsTimingOfCellFramesRequested() const;
    
	IMPORT_C TInt SetPosMethods(const TLbsNetPosMethodInt aPosMethods[], TInt aNumPosMethods);
    IMPORT_C void SetGpsTimingOfCellFramesRequested(TBool aRequested);

protected:
	TInt iNumPosMethods;
	TLbsNetPosMethodInt iPosMethod[KLbsMaxNetPosMethodsInt];
    TBool iGpsTimingOfCellFramesRequested;
	};

//
// All declarations and definitions below are duplicated from lbsnetprotocolbase.h
// (lbsnetprotocol.dll)
//

/**
 TLbsNetworkProtocolEnumInt duplicates enums from MLbsNetworkProtocolObserver and
 CLbsNetworkProtocolBase.
*/
class TLbsNetworkEnumInt
	{
public:
	/**
	Values of type TLbsNetProtocolService describe the processes that
	can be active or queued in network protocol module.

	A single value is supplied as a parameter in ProcessLocationRequest() to indicate
	why the location request was generated.
	
	ProcessStatusUpdate() provides a mask of TLbsNetProtocolService values to
	indicate all the various tasks being performed or queued by the protocol module.
	
	@see ProcessLocationRequest()
	@see TLbsNetProtocolServiceMask
	@see ProcessStatusUpdate()
	*/
	enum TLbsNetProtocolServiceInt
		{
			/** No service */
		EServiceNone                = 0x00,
	
			/** Indicates that the protocol module has currently a request from
			the handset to perform a network calculation of the devices position. */
		EServiceNetworkLocation		 = 0x01,
		
			/** Indicates that the protocol module has currently a request to
			perform a self location. */
		EServiceSelfLocation   		 = 0x02,
		
			/** Indicates that the protocol module has currently a MT-LR request
			by an	external party.
			This initially results in the protocol module issuing a privacy request, that
			contains the details of	the request originator, followed by a location request. */
		EServiceMobileTerminated     = 0x04,
		
			/** Indicates that the protocol module has currently a request to 
			to send the device's current position to a remote third party. */
		EServiceTransmitThirdParty   = 0x08,
		
			/** Indicates that the protocol module has currently a location request
			that was generated by the network (NI-LR). In this situation, the protocol module
			will only generate a location request. There is no preceding privacy request. */
		EServiceNetworkInduced       = 0x10,
            
            /** Indicates that the protocol module has currently a location request
            that was generated by the network (Triggered MOLR, SUPL 2.0). */
        EServiceTriggeredMolr      = 0x20   
		};

	/** The response to a privacy request.
	
	@see MLbsNetworkProtocolObserver::ProcessPrivacyRequest()
	@see RespondPrivacyRequest()
	*/
	enum TLbsPrivacyResponseInt
		{
			/** Not Used */
		EPrivacyResponseUnknown = 0,
			/** Inform the network the terminal will accept its location request */
		EPrivacyResponseAccepted,
			/** Inform the network the terminal will reject its location request */
		EPrivacyResponseRejected,
			/** Inform the protocol module it should not respond to the location request.
			This option is currently not supported */
		EPrivacyResponseIgnored
		};
	};


//
// All declarations and definitions below are duplicated from lbsloccommon.h
// (lbsloccommon.dll)
//	

class TLbsLocClassTypeBaseInt
/** Base class for classes used to store Lbs information
*/
	{
public:
	IMPORT_C TUint32 ClassType() const;
	IMPORT_C TUint ClassSize() const;

protected:
	IMPORT_C TLbsLocClassTypeBaseInt();

protected:
	/** The type of the derived class */
	TUint32 iClassType;
	/** The size of the derived class */
	TUint iClassSize;
	};


//
// All declarations and definitions below are duplicated from lbslocdatasourcegpsbase.h
// (lbslocdatasource.dll)
//	

/** Specifies the desired quality of a location request
The TLbsLocRequestQualityInt is used by the location source observer to specify
the desired quality of a location request. An instance
of the class is passed to CLbsLocationSourceGpsBase::RequestLocationUpdate().
 
The parameters in TLbsLocRequestQualityInt include the desired minimum horizontal
and vertical accuracy for the requested location update. It also enables a
maximum time to be specified. This is a time limit indicating the maximum time
the data source should take to calculate the location.
 
It is possible to combine both the desired minimum accuracy and the maximum time.
In this situation the data source module will respond either when the desired
accuracy has been reached or when the time limit has expired.
@see CLbsLocationSourceBase::RequestLocationUpdate()
@see MLbsLocationSourceObserver
 */
class TLbsLocRequestQualityInt : public TLbsLocClassTypeBaseInt
	{
public:
	/** Constructor for the TLbsLocRequestQualityInt

	@see CLbsLocationSourceGpsBase
	*/
	IMPORT_C TLbsLocRequestQualityInt();

	/** Maximum time a data source should spend calculating the current location.
	 
	 @see SetMaxFixTime
	 @return The maximum time that a data source should spend calculating  the current location.
	 */
	IMPORT_C TTimeIntervalMicroSeconds MaxFixTime() const;

	/** Desired minimum horizontal accuracy for a location update.
	@see SetMaxFixTime
	@return The desired minimum horizontal accuracy for a location update in metres.
	*/
	IMPORT_C TReal32 MinHorizontalAccuracy() const;
	
	/** Desired minimum vertical accuracy for a location update.
	@see SetMaxFixTime
	@return The desired minimum vertical accuracy for a location update in metres.
	 */
	IMPORT_C TReal32 MinVerticalAccuracy()   const;

	/** Maximum time a data source should spend calculating the current location.

	When used in conjunction with SetMinHorizontalAccuracy and/or
	SetMinVerticalAccuracy the data source will produce an update either when the
	desired accuracy has be met or when the time limit is reached.

	@see SetMaxFixTime
	@param aTime specifies the maximum time that the data source should spend
	calculating the current location.
	*/
	IMPORT_C void SetMaxFixTime(TTimeIntervalMicroSeconds aTime);

	/** Desired minimum horizontal accuracy for a location update. 

	When used in conjunction with SetMaxFixTime the data source will produce an
	update either when the desired accuracy is met or when the time limit is reached.
	@see SetMaxFixTime
	@param aAccuracy specifies the desired minimum horizontal accuracy  (in metres)
	for a location update produced by the data source. 
	 */
	IMPORT_C void SetMinHorizontalAccuracy(TReal32 aAccuracy);
	
	/** Desired minimum vertical accuracy for a location update.
	When used in conjunction with SetMaxFixTime the data source will produce an
	update either when the desired accuracy is met or when the time limit is reached.
	@see SetMaxFixTime
	@param aAccuracy specifies the desired minimum vertical accuracy (in metres) for
	a location update produced by the data source. 
	 */
	IMPORT_C void SetMinVerticalAccuracy(TReal32 aAccuracy);
protected:
	/**  Minimum horizonal accuracy */
	TReal32 iMinHorizontalAccuracy;
	/**  Minimum vertical accuracy */
	TReal32 iMinVerticalAccuracy;
	/**  Minimum time to wait for fix */
	TTimeIntervalMicroSeconds iMaxFixTime;
	};
	
#endif // LBSCOMMONINTERNALDATATYPES_H
