/*
* Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/

#include <stdio.h>
#include <stdlib.h>
#include "Colorconversion.h"

/*
******************************************************************************
Name            : Emz_VDec_gColorConv_YUVtoRGB
Description		: Converts YUV picture data to RGB data.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
				  uint8	srcImageFmt			: Specifies the color format of src data (i/p, o/p).
				  uint8	dstImageFmt			: Specifies the color format of dst data (i/p, o/p).
				  uint8 colorConvScheme		: Specifies the color conversion standard.(i/p)
Return Value    : int32
******************************************************************************
*/
int32 Emz_VDec_gColorConv_YUVtoRGB 
	 (tBaseVideoFrame *srcImage, uint8 *dstImage, tWndParam *srcWindow, 
	  tWndParam *dstWindow, uint8 srcImageFmt, uint8 dstImageFmt,
	  uint8 colorConvScheme)
{
	tWndParam	lSrcWindow, lDstWindow;

	if( (NULL == srcImage) || (NULL == srcImage->lum) || 
		(NULL == dstImage) || (srcWindow == NULL)|| (dstWindow == NULL) )
			
	{
		return E_OUT_OF_MEMORY;
	}

	if( (EYuv422Chroma2_BE != srcImageFmt) && (EYuv422Chroma2_LE != srcImageFmt)
		&& (EYuv422Chroma1_BE != srcImageFmt) && (EYuv422Chroma1_LE != srcImageFmt))
	{
		if( (NULL == srcImage->cb) || (NULL == srcImage->cr) )
		{
			return E_OUT_OF_MEMORY;
		}
	}

	lSrcWindow.xOffset		= srcWindow->xOffset;
	lSrcWindow.yOffset		= srcWindow->yOffset;
	lSrcWindow.wndWidth		= srcWindow->wndWidth;
	lSrcWindow.wndHeight	= srcWindow->wndHeight;

	lDstWindow.xOffset		= dstWindow->xOffset;
	lDstWindow.yOffset		= dstWindow->yOffset;
	lDstWindow.wndWidth		= dstWindow->wndWidth;
	lDstWindow.wndHeight	= dstWindow->wndHeight;

	lSrcWindow.xOffset		= (uint16) ((lSrcWindow.xOffset >> 1) << 1);
	lSrcWindow.yOffset		= (uint16) ((lSrcWindow.yOffset >> 1) << 1);
	lDstWindow.wndWidth		= (lDstWindow.wndWidth >> 1) << 1;
	lDstWindow.wndHeight	= (lDstWindow.wndHeight >> 1) << 1;

	switch (srcImageFmt)
	{

		case EYuv420Chroma1_Planar :

			switch (dstImageFmt)
			{

				case EBitmapColor4k_DitherOrdered :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV420Chr1toColor4k_Ordered_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV420Chr1toColor4k_Ordered_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr1toColor4k_Ordered_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr1toColor4k_Ordered_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;			
					}
				break;

				case EBitmapColor4k_DitherErrDiff :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV420Chr1toColor4k_ErrDiff_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV420Chr1toColor4k_ErrDiff_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr1toColor4k_ErrDiff_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr1toColor4k_ErrDiff_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor64k_DitherOrdered :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV420Chr1toColor64k_Ordered_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV420Chr1toColor64k_Ordered_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr1toColor64k_Ordered_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr1toColor64k_Ordered_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor64k_DitherErrDiff :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV420Chr1toColor64k_ErrDiff_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV420Chr1toColor64k_ErrDiff_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr1toColor64k_ErrDiff_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr1toColor64k_ErrDiff_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

					case EBitmapColor16M :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV420Chr1toColor16M_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV420Chr1toColor16M_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr1toColor16M_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr1toColor16M_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor16MU :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV420Chr1toColor16MU_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV420Chr1toColor16MU_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr1toColor16MU_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr1toColor16MU_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;						
					}
				break;

				default : 
					return E_FAILURE;
			}

		break;

		case EYuv420Chroma2_Planar :

			switch (dstImageFmt)
			{
				case EBitmapColor4k_DitherOrdered :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV420Chr2toColor4k_Ordered_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV420Chr2toColor4k_Ordered_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr2toColor4k_Ordered_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr2toColor4k_Ordered_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor4k_DitherErrDiff :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV420Chr2toColor4k_ErrDiff_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV420Chr2toColor4k_ErrDiff_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr2toColor4k_ErrDiff_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr2toColor4k_ErrDiff_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor64k_DitherOrdered :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV420Chr2toColor64k_Ordered_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV420Chr2toColor64k_Ordered_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr2toColor64k_Ordered_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr2toColor64k_Ordered_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor64k_DitherErrDiff :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV420Chr2toColor64k_ErrDiff_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV420Chr2toColor64k_ErrDiff_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr2toColor64k_ErrDiff_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr2toColor64k_ErrDiff_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor16M :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV420Chr2toColor16M_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV420Chr2toColor16M_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr2toColor16M_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr2toColor16M_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor16MU :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV420Chr2toColor16MU_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV420Chr2toColor16MU_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr2toColor16MU_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr2toColor16MU_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				default : 
					return E_FAILURE;
			}

		break;

		case EYuv420Chroma3_Planar :

			switch (dstImageFmt)
			{
				case EBitmapColor4k_DitherOrdered :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV420Chr3toColor4k_Ordered_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV420Chr3toColor4k_Ordered_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr3toColor4k_Ordered_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr3toColor4k_Ordered_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor4k_DitherErrDiff :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV420Chr3toColor4k_ErrDiff_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV420Chr3toColor4k_ErrDiff_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr3toColor4k_ErrDiff_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr3toColor4k_ErrDiff_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor64k_DitherOrdered :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV420Chr3toColor64k_Ordered_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV420Chr3toColor64k_Ordered_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr3toColor64k_Ordered_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr3toColor64k_Ordered_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor64k_DitherErrDiff :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV420Chr3toColor64k_ErrDiff_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV420Chr3toColor64k_ErrDiff_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr3toColor64k_ErrDiff_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr3toColor64k_ErrDiff_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor16M :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV420Chr3toColor16M_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV420Chr3toColor16M_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr3toColor16M_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr3toColor16M_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor16MU :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV420Chr3toColor16MU_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV420Chr3toColor16MU_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr3toColor16MU_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV420Chr3toColor16MU_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				default : 
					return E_FAILURE;
			}

		break;

		case EYuv422Chroma1_BE :

			switch (dstImageFmt)
			{
				case EBitmapColor4k_DitherOrdered :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV422BEChr1toColor4k_Ordered_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV422BEChr1toColor4k_Ordered_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV422BEChr1toColor4k_Ordered_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV422BEChr1toColor4k_Ordered_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor4k_DitherErrDiff :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV422BEChr1toColor4k_ErrDiff_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV422BEChr1toColor4k_ErrDiff_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV422BEChr1toColor4k_ErrDiff_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV422BEChr1toColor4k_ErrDiff_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor64k_DitherOrdered :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV422BEChr1toColor64k_Ordered_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV422BEChr1toColor64k_Ordered_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV422BEChr1toColor64k_Ordered_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV422BEChr1toColor64k_Ordered_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor64k_DitherErrDiff :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV422BEChr1toColor64k_ErrDiff_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV422BEChr1toColor64k_ErrDiff_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV422BEChr1toColor64k_ErrDiff_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV422BEChr1toColor64k_ErrDiff_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor16M :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV422BEChr1toColor16M_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV422BEChr1toColor16M_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV422BEChr1toColor16M_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV422BEChr1toColor16M_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor16MU :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV422BEChr1toColor16MU_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV422BEChr1toColor16MU_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV422BEChr1toColor16MU_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV422BEChr1toColor16MU_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				default : 
					return E_FAILURE;
			}

		break;

		case EYuv422Chroma2_BE :
		
			switch (dstImageFmt)
			{
				case EBitmapColor4k_DitherOrdered :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV422BEChr2toColor4k_Ordered_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV422BEChr2toColor4k_Ordered_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV422BEChr2toColor4k_Ordered_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV422BEChr2toColor4k_Ordered_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor4k_DitherErrDiff :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV422BEChr2toColor4k_ErrDiff_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV422BEChr2toColor4k_ErrDiff_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV422BEChr2toColor4k_ErrDiff_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV422BEChr2toColor4k_ErrDiff_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor64k_DitherOrdered :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV422BEChr2toColor64k_Ordered_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV422BEChr2toColor64k_Ordered_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV422BEChr2toColor64k_Ordered_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV422BEChr2toColor64k_Ordered_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor64k_DitherErrDiff :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV422BEChr2toColor64k_ErrDiff_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV422BEChr2toColor64k_ErrDiff_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV422BEChr2toColor64k_ErrDiff_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV422BEChr2toColor64k_ErrDiff_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor16M :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV422BEChr2toColor16M_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV422BEChr2toColor16M_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV422BEChr2toColor16M_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV422BEChr2toColor16M_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor16MU :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV422BEChr2toColor16MU_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV422BEChr2toColor16MU_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV422BEChr2toColor16MU_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV422BEChr2toColor16MU_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				default : 
					return E_FAILURE;
			}

		break;

		case EYuv422Chroma1_LE :

			switch (dstImageFmt)
			{
				case EBitmapColor4k_DitherOrdered :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV422LEChr1toColor4k_Ordered_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV422LEChr1toColor4k_Ordered_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV422LEChr1toColor4k_Ordered_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV422LEChr1toColor4k_Ordered_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor4k_DitherErrDiff :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV422LEChr1toColor4k_ErrDiff_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV422LEChr1toColor4k_ErrDiff_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV422LEChr1toColor4k_ErrDiff_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV422LEChr1toColor4k_ErrDiff_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor64k_DitherOrdered :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV422LEChr1toColor64k_Ordered_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV422LEChr1toColor64k_Ordered_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV422LEChr1toColor64k_Ordered_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV422LEChr1toColor64k_Ordered_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor64k_DitherErrDiff :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV422LEChr1toColor64k_ErrDiff_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV422LEChr1toColor64k_ErrDiff_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV422LEChr1toColor64k_ErrDiff_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV422LEChr1toColor64k_ErrDiff_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor16M :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV422LEChr1toColor16M_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV422LEChr1toColor16M_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV422LEChr1toColor16M_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV422LEChr1toColor16M_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor16MU :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV422LEChr1toColor16MU_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV422LEChr1toColor16MU_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV422LEChr1toColor16MU_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV422LEChr1toColor16MU_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				default : 
					return E_FAILURE;
			}

		break;

		case EYuv422Chroma2_LE :

			switch (dstImageFmt)
			{
				case EBitmapColor4k_DitherOrdered :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV422LEChr2toColor4k_Ordered_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV422LEChr2toColor4k_Ordered_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV422LEChr2toColor4k_Ordered_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV422LEChr2toColor4k_Ordered_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor4k_DitherErrDiff :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV422LEChr2toColor4k_ErrDiff_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV422LEChr2toColor4k_ErrDiff_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV422LEChr2toColor4k_ErrDiff_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV422LEChr2toColor4k_ErrDiff_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;					
					}
				break;

				case EBitmapColor64k_DitherOrdered :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV422LEChr2toColor64k_Ordered_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV422LEChr2toColor64k_Ordered_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV422LEChr2toColor64k_Ordered_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV422LEChr2toColor64k_Ordered_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;
					}
				break;

				case EBitmapColor64k_DitherErrDiff :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV422LEChr2toColor64k_ErrDiff_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV422LEChr2toColor64k_ErrDiff_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV422LEChr2toColor64k_ErrDiff_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV422LEChr2toColor64k_ErrDiff_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;	
					}
				break;

				case EBitmapColor16M :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV422LEChr2toColor16M_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV422LEChr2toColor16M_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV422LEChr2toColor16M_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV422LEChr2toColor16M_601_5_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;
					}
				break;

				case EBitmapColor16MU :
	
					switch (colorConvScheme)
					{
						case EB709_FULLRANGE :
							sEmz_VDec_YUV422LEChr2toColor16MU_709_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_FULLRANGE :
							sEmz_VDec_YUV422LEChr2toColor16MU_601_5_FR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;
				
						case EB709_REDUCEDRANGE :
							sEmz_VDec_YUV422LEChr2toColor16MU_709_RR 
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						case EITU601_5_REDUCEDRANGE :
							sEmz_VDec_YUV422LEChr2toColor16MU_601_5_RR
								(srcImage, dstImage, &lSrcWindow, &lDstWindow);
						break;

						default : 
							return E_FAILURE;
					}
				break;

				default : 
					return E_FAILURE;
			}

		break;

		default : 
			return E_FAILURE;		
	}

	return E_SUCCESS;
}


/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/**************** Start of Chroma2 format *******************/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/




/****** Functions for YUV420 input *******/
/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr2toColor64k_Ordered_709_FR
Description		: Converts YUV420 Chroma2 Planar to RGB565 Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr2toColor64k_Ordered_709_FR 
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

    /* This function performs YUV to RGB conversion with dithering for 16-bit 
       {5,6,5} RGB. The 2x2 dither pattern used for {R,G,B} colors is as follows:

       |  {0,3,2}  {4,0,6} |
       |  {6,1,4}  {2,2,0} | */

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCr = lCrPtr[j >> 1];
            lCb = lCbPtr[j >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)(lTemp4);

            /*Second Pixel*/
            lY1 = lLumPtr[j + 1];

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)(lTemp4);


            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)(lTemp4);

            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr2toColor64k_Ordered_601_5_FR
Description		: Converts YUV420 Chroma2 Planar to RGB565 Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr2toColor64k_Ordered_601_5_FR 
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

    /* This function performs YUV to RGB conversion with dithering for 16-bit 
       {5,6,5} RGB. The 2x2 dither pattern used for {R,G,B} colors is as follows:

       |  {0,3,2}  {4,0,6} |
       |  {6,1,4}  {2,2,0} | */

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCr = lCrPtr[j >> 1];
            lCb = lCbPtr[j >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)(lTemp4);

            /*Second Pixel*/
            lY1 = lLumPtr[j + 1];

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)(lTemp4);


            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)(lTemp4);

            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr2toColor64k_Ordered_709_RR
Description		: Converts YUV420 Chroma2 Planar to RGB565 Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr2toColor64k_Ordered_709_RR 
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

    /* This function performs YUV to RGB conversion with dithering for 16-bit 
       {5,6,5} RGB. The 2x2 dither pattern used for {R,G,B} colors is as follows:

       |  {0,3,2}  {4,0,6} |
       |  {6,1,4}  {2,2,0} | */

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCr = lCrPtr[j >> 1];
            lCb = lCbPtr[j >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)(lTemp4);

            /*Second Pixel*/
            lY1 = lLumPtr[j + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)(lTemp4);


            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)(lTemp4);

            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr2toColor64k_Ordered_601_5_RR
Description		: Converts YUV420 Chroma2 Planar to RGB565 Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr2toColor64k_Ordered_601_5_RR 
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

    /* This function performs YUV to RGB conversion with dithering for 16-bit 
       {5,6,5} RGB. The 2x2 dither pattern used for {R,G,B} colors is as follows:

       |  {0,3,2}  {4,0,6} |
       |  {6,1,4}  {2,2,0} | */

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCr = lCrPtr[j >> 1];
            lCb = lCbPtr[j >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)(lTemp4);

            /*Second Pixel*/
            lY1 = lLumPtr[j + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)(lTemp4);


            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)(lTemp4);

            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr2toColor16M_709_FR
Description		: Converts YUV420 Chroma2 Planar to RGB888 Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr2toColor16M_709_FR 
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint8  *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, extraRow, extraCol;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth * 3;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	dstXOffset *= 3;
	wndWidth   *= 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr  = dstImage + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCr = lCrPtr[j >> 1];
            lCb = lCbPtr[j >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];

            /*R component*/
            lTemp = lY1 + lTemp1;    
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[1] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
			if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

			lRGBFramePtr[2] = (uint8) lTemp;
      
            /*Second Pixel*/
            
			lY1 = lLumPtr[j + 1];

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
      
			lRGBFramePtr[3] = (uint8) lTemp; 

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[4] = (uint8) lTemp;

            
			/*B component*/
            lTemp = lY1 + lTemp3;
            
			if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[5] = (uint8) lTemp;
            
			
            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lRGBFramePtr1[0] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

            lRGBFramePtr1[1] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

            lRGBFramePtr1[2] = (uint8) lTemp;

            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lRGBFramePtr1[3] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lRGBFramePtr1[4] = (uint8) lTemp;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
                      
			lRGBFramePtr1[5] = (uint8) lTemp;

            lRGBFramePtr += 6;
            lRGBFramePtr1 += 6;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-3];
			lRGBFramePtr1++;
			*lRGBFramePtr1 = lRGBFramePtr1[-3];
			lRGBFramePtr1++;
			*lRGBFramePtr1 = lRGBFramePtr1[-3];
			lRGBFramePtr1++;

		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr  += (lLumWidth >> 1);
        lCbPtr  += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth * 3; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr2toColor16M_601_5_FR
Description		: Converts YUV420 Chroma2 Planar to RGB888 Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr2toColor16M_601_5_FR 
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint8  *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, extraRow, extraCol;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;


	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth * 3;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;
	
	dstXOffset *= 3;
	wndWidth   *= 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr  = dstImage + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCr = lCrPtr[j >> 1];
            lCb = lCbPtr[j >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];

            /*R component*/
            lTemp = lY1 + lTemp1;    
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[1] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
			if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

			lRGBFramePtr[2] = (uint8) lTemp;
      
            /*Second Pixel*/
            
			lY1 = lLumPtr[j + 1];

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
      
			lRGBFramePtr[3] = (uint8) lTemp; 

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[4] = (uint8) lTemp;

            
			/*B component*/
            lTemp = lY1 + lTemp3;
            
			if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[5] = (uint8) lTemp;
            
			
            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lRGBFramePtr1[0] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

            lRGBFramePtr1[1] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

            lRGBFramePtr1[2] = (uint8) lTemp;

            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lRGBFramePtr1[3] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lRGBFramePtr1[4] = (uint8) lTemp;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
                      
			lRGBFramePtr1[5] = (uint8) lTemp;

            lRGBFramePtr += 6;
            lRGBFramePtr1 += 6;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-3];
			lRGBFramePtr1++;
			*lRGBFramePtr1 = lRGBFramePtr1[-3];
			lRGBFramePtr1++;
			*lRGBFramePtr1 = lRGBFramePtr1[-3];
			lRGBFramePtr1++;

		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr  += (lLumWidth >> 1);
        lCbPtr  += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth * 3; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr2toColor16M_709_RR
Description		: Converts YUV420 Chroma2 Planar to RGB888 Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr2toColor16M_709_RR 
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint8  *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, extraRow, extraCol;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;


	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth * 3;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;
	
	dstXOffset *= 3;
	wndWidth   *= 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr  = dstImage + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCr = lCrPtr[j >> 1];
            lCb = lCbPtr[j >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = lY1 + lTemp1;    
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[1] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

			lRGBFramePtr[2] = (uint8) lTemp;
      
            /*Second Pixel*/
            
			lY1 = lLumPtr[j + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
      
			lRGBFramePtr[3] = (uint8) lTemp; 

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[4] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;          
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[5] = (uint8) lTemp;
            
			
            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lRGBFramePtr1[0] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

            lRGBFramePtr1[1] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

            lRGBFramePtr1[2] = (uint8) lTemp;

            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

            lRGBFramePtr1[3] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lRGBFramePtr1[4] = (uint8) lTemp;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
                      
			lRGBFramePtr1[5] = (uint8) lTemp;

            lRGBFramePtr += 6;
            lRGBFramePtr1 += 6;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-3];
			lRGBFramePtr1++;
			*lRGBFramePtr1 = lRGBFramePtr1[-3];
			lRGBFramePtr1++;
			*lRGBFramePtr1 = lRGBFramePtr1[-3];
			lRGBFramePtr1++;

		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr  += (lLumWidth >> 1);
        lCbPtr  += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth * 3; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr2toColor16M_601_5_RR
Description		: Converts YUV420 Chroma2 Planar to RGB888 Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr2toColor16M_601_5_RR 
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint8  *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, extraRow, extraCol;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;


	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth * 3;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;
	
	dstXOffset *= 3;
	wndWidth   *= 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr  = dstImage + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCr = lCrPtr[j >> 1];
            lCb = lCbPtr[j >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = lY1 + lTemp1;    
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[1] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

			lRGBFramePtr[2] = (uint8) lTemp;
      
            /*Second Pixel*/
            
			lY1 = lLumPtr[j + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
      
			lRGBFramePtr[3] = (uint8) lTemp; 

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[4] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;          
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[5] = (uint8) lTemp;
            
			
            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lRGBFramePtr1[0] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

            lRGBFramePtr1[1] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

            lRGBFramePtr1[2] = (uint8) lTemp;

            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

            lRGBFramePtr1[3] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lRGBFramePtr1[4] = (uint8) lTemp;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
                      
			lRGBFramePtr1[5] = (uint8) lTemp;

            lRGBFramePtr += 6;
            lRGBFramePtr1 += 6;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-3];
			lRGBFramePtr1++;
			*lRGBFramePtr1 = lRGBFramePtr1[-3];
			lRGBFramePtr1++;
			*lRGBFramePtr1 = lRGBFramePtr1[-3];
			lRGBFramePtr1++;

		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr  += (lLumWidth >> 1);
        lCbPtr  += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth * 3; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
	}
	return;
}


/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr2toColor4k_Ordered_709_FR
Description		: Converts YUV420 Chroma2 Planar to XRGB (4:4:4:4) Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr2toColor4k_Ordered_709_FR 
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

    /* This function performs YUV to RGB conversion with dithering for 12-bit 
       {4,4,4} RGB. The 2x2 dither pattern used for {R,G,B} colors is as follows:

       |  {0,15,5}   {10,0,15} |
       |  {15,5,10}  {5,10,0}  | */

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCr = lCrPtr[j >> 1];
            lCb = lCbPtr[j >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
          
            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;

			/*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)(lTemp4);

            /*Second Pixel*/
            lY1 = lLumPtr[j + 1];

            /*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;

			/*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)(lTemp4);


            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];

            /*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;

			/*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)(lTemp4);

            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];

            /*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr2toColor4k_Ordered_601_5_FR
Description		: Converts YUV420 Chroma2 Planar to XRGB (4:4:4:4) Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr2toColor4k_Ordered_601_5_FR 
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

    /* This function performs YUV to RGB conversion with dithering for 12-bit 
       {4,4,4} RGB. The 2x2 dither pattern used for {R,G,B} colors is as follows:

       |  {0,15,5}   {10,0,15} |
       |  {15,5,10}  {5,10,0}  | */

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCr = lCrPtr[j >> 1];
            lCb = lCbPtr[j >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
          
            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;

			/*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)(lTemp4);

            /*Second Pixel*/
            lY1 = lLumPtr[j + 1];

            /*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;

			/*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)(lTemp4);


            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];

            /*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;

			/*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)(lTemp4);

            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];

            /*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr2toColor4k_Ordered_709_RR
Description		: Converts YUV420 Chroma2 Planar to XRGB (4:4:4:4) Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr2toColor4k_Ordered_709_RR 
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

    /* This function performs YUV to RGB conversion with dithering for 12-bit 
       {4,4,4} RGB. The 2x2 dither pattern used for {R,G,B} colors is as follows:

       |  {0,15,5}   {10,0,15} |
       |  {15,5,10}  {5,10,0}  | */

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCr = lCrPtr[j >> 1];
            lCb = lCbPtr[j >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;
          
            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;

			/*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)(lTemp4);

            /*Second Pixel*/
            lY1 = lLumPtr[j + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;

			/*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)(lTemp4);


            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;

			/*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)(lTemp4);

            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr2toColor4k_Ordered_601_5_RR
Description		: Converts YUV420 Chroma2 Planar to XRGB (4:4:4:4) Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr2toColor4k_Ordered_601_5_RR 
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

    /* This function performs YUV to RGB conversion with dithering for 12-bit 
       {4,4,4} RGB. The 2x2 dither pattern used for {R,G,B} colors is as follows:

       |  {0,15,5}   {10,0,15} |
       |  {15,5,10}  {5,10,0}  | */

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCr = lCrPtr[j >> 1];
            lCb = lCbPtr[j >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;
          
            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;

			/*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)(lTemp4);

            /*Second Pixel*/
            lY1 = lLumPtr[j + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;

			/*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)(lTemp4);


            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;

			/*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)(lTemp4);

            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}


/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr2toColor16MU_709_FR
Description		: Converts YUV420 Chroma2 Planar to XRGB (8:8:8:8) Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr2toColor16MU_709_FR 
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint32 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr = (uint32*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCr = lCrPtr[j >> 1];
            lCb = lCbPtr[j >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
          
            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)(lTemp4);

            /*Second Pixel*/
            lY1 = lLumPtr[j + 1];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)(lTemp4);


            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr1[0] = (uint32)(lTemp4);

            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr1[1] = (uint32)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr2toColor16MU_601_5_FR
Description		: Converts YUV420 Chroma2 Planar to XRGB (8:8:8:8) Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr2toColor16MU_601_5_FR 
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint32 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr = (uint32*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCr = lCrPtr[j >> 1];
            lCb = lCbPtr[j >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
          
            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)(lTemp4);

            /*Second Pixel*/
            lY1 = lLumPtr[j + 1];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)(lTemp4);


            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr1[0] = (uint32)(lTemp4);

            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr1[1] = (uint32)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr2toColor16MU_709_RR
Description		: Converts YUV420 Chroma2 Planar to XRGB (8:8:8:8) Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr2toColor16MU_709_RR 
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint32 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr = (uint32*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCr = lCrPtr[j >> 1];
            lCb = lCbPtr[j >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;
          
            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)(lTemp4);

            /*Second Pixel*/
            lY1 = lLumPtr[j + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)(lTemp4);


            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr1[0] = (uint32)(lTemp4);

            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr1[1] = (uint32)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr2toColor16MU_601_5_RR
Description		: Converts YUV420 Chroma2 Planar to XRGB (8:8:8:8) Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr2toColor16MU_601_5_RR 
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint32 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr = (uint32*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCr = lCrPtr[j >> 1];
            lCb = lCbPtr[j >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;
          
            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)(lTemp4);

            /*Second Pixel*/
            lY1 = lLumPtr[j + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)(lTemp4);


            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr1[0] = (uint32)(lTemp4);

            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr1[1] = (uint32)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/**** End of YUV420 input *****/



/**** Start of YUV422BE input *****/
/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr2toColor64k_Ordered_709_FR
Description		: Converts YUV422 BE (UYVY) Chroma2 Interleaved to RGB565 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr2toColor64k_Ordered_709_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[0];
            lCr = lYuyvPtr[2];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)lTemp4;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb = lYuyvPtr[lLumWidth];
            lCr = lYuyvPtr[lLumWidth + 2];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/         
			lY1 = lYuyvPtr[lLumWidth + 1];

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)lTemp4;
            
            /*Fourth Pixel*/            
			lY1 = lYuyvPtr[lLumWidth + 3];

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr2toColor64k_Ordered_601_5_FR
Description		: Converts YUV422 BE (UYVY) Chroma2 Interleaved to RGB565 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr2toColor64k_Ordered_601_5_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[0];
            lCr = lYuyvPtr[2];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)lTemp4;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb = lYuyvPtr[lLumWidth];
            lCr = lYuyvPtr[lLumWidth + 2];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/         
			lY1 = lYuyvPtr[lLumWidth + 1];

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)lTemp4;
            
            /*Fourth Pixel*/            
			lY1 = lYuyvPtr[lLumWidth + 3];

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr2toColor64k_Ordered_709_RR
Description		: Converts YUV422 BE (UYVY) Chroma2 Interleaved to RGB565 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr2toColor64k_Ordered_709_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[0];
            lCr = lYuyvPtr[2];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)lTemp4;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb = lYuyvPtr[lLumWidth];
            lCr = lYuyvPtr[lLumWidth + 2];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/         
			lY1 = lYuyvPtr[lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)lTemp4;
            
            /*Fourth Pixel*/            
			lY1 = lYuyvPtr[lLumWidth + 3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr2toColor64k_Ordered_601_5_RR
Description		: Converts YUV422 BE (UYVY) Chroma2 Interleaved to RGB565 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr2toColor64k_Ordered_601_5_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[0];
            lCr = lYuyvPtr[2];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)lTemp4;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb = lYuyvPtr[lLumWidth];
            lCr = lYuyvPtr[lLumWidth + 2];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/         
			lY1 = lYuyvPtr[lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)lTemp4;
            
            /*Fourth Pixel*/            
			lY1 = lYuyvPtr[lLumWidth + 3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr2toColor16M_709_FR
Description		: Converts YUV422 BE (UYVY) Chroma2 Interleaved to RGB888 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr2toColor16M_709_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint8  *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, extraCol, extraRow;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;


	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth * 3;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;
	
	dstXOffset *= 3;
	wndWidth   *= 3;

    lLumWidth = (srcImage->width >> 1) << 1 ;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    lRGBFramePtr  = dstImage + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[0];
            lCr = lYuyvPtr[2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/         
			lY1 = lYuyvPtr[1];

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[1] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			
            lRGBFramePtr[2] = (uint8) lTemp;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[3] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[4] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[5] = (uint8) lTemp;

			lYuyvPtr += 4;
            lRGBFramePtr += 6;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }
	
	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth * 3; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr2toColor16M_601_5_FR
Description		: Converts YUV422 BE (UYVY) Chroma2 Interleaved to RGB888 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr2toColor16M_601_5_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint8  *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, extraCol, extraRow;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth * 3;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	dstXOffset *= 3;
	wndWidth   *= 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    lRGBFramePtr  = dstImage + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[0];
            lCr = lYuyvPtr[2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/         
			lY1 = lYuyvPtr[1];

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[1] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			
            lRGBFramePtr[2] = (uint8) lTemp;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[3] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[4] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[5] = (uint8) lTemp;

			lYuyvPtr += 4;
            lRGBFramePtr += 6;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth * 3; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr2toColor16M_709_RR
Description		: Converts YUV422 BE (UYVY) Chroma2 Interleaved to RGB888 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr2toColor16M_709_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint8  *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, extraCol, extraRow;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth * 3;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	dstXOffset *= 3;
	wndWidth   *= 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    lRGBFramePtr  = dstImage + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[0];
            lCr = lYuyvPtr[2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/         
			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[1] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			
            lRGBFramePtr[2] = (uint8) lTemp;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[3] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[4] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[5] = (uint8) lTemp;

			lYuyvPtr += 4;
            lRGBFramePtr += 6;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth * 3; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr2toColor16M_601_5_RR
Description		: Converts YUV422 BE (UYVY) Chroma2 Interleaved to RGB888 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr2toColor16M_601_5_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint8  *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, extraCol, extraRow;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth * 3;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	dstXOffset *= 3;
	wndWidth   *= 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    lRGBFramePtr  = dstImage + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[0];
            lCr = lYuyvPtr[2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/         
			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[1] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			
            lRGBFramePtr[2] = (uint8) lTemp;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[3] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[4] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[5] = (uint8) lTemp;

			lYuyvPtr += 4;
            lRGBFramePtr += 6;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth * 3; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
	}
	return;
}


/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr2toColor4k_Ordered_709_FR
Description		: Converts YUV422 BE (UYVY) Chroma2 Interleaved to XRGB (4:4:4:4) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr2toColor4k_Ordered_709_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[0];
            lCr = lYuyvPtr[2];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)lTemp4;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb = lYuyvPtr[lLumWidth];
            lCr = lYuyvPtr[lLumWidth + 2];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/         
			lY1 = lYuyvPtr[lLumWidth + 1];

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)lTemp4;
            
            /*Fourth Pixel*/            
			lY1 = lYuyvPtr[lLumWidth + 3];

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr2toColor4k_Ordered_601_5_FR
Description		: Converts YUV422 BE (UYVY) Chroma2 Interleaved to XRGB (4:4:4:4) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr2toColor4k_Ordered_601_5_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[0];
            lCr = lYuyvPtr[2];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)lTemp4;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb = lYuyvPtr[lLumWidth];
            lCr = lYuyvPtr[lLumWidth + 2];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/         
			lY1 = lYuyvPtr[lLumWidth + 1];

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)lTemp4;
            
            /*Fourth Pixel*/            
			lY1 = lYuyvPtr[lLumWidth + 3];

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr2toColor4k_Ordered_709_RR
Description		: Converts YUV422 BE (UYVY) Chroma2 Interleaved to XRGB (4:4:4:4) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr2toColor4k_Ordered_709_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[0];
            lCr = lYuyvPtr[2];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)lTemp4;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb = lYuyvPtr[lLumWidth];
            lCr = lYuyvPtr[lLumWidth + 2];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/         
			lY1 = lYuyvPtr[lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)lTemp4;
            
            /*Fourth Pixel*/            
			lY1 = lYuyvPtr[lLumWidth + 3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr2toColor4k_Ordered_601_5_RR
Description		: Converts YUV422 BE (UYVY) Chroma2 Interleaved to XRGB (4:4:4:4) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr2toColor4k_Ordered_601_5_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[0];
            lCr = lYuyvPtr[2];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)lTemp4;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb = lYuyvPtr[lLumWidth];
            lCr = lYuyvPtr[lLumWidth + 2];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/         
			lY1 = lYuyvPtr[lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)lTemp4;
            
            /*Fourth Pixel*/            
			lY1 = lYuyvPtr[lLumWidth + 3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr2toColor16MU_709_FR
Description		: Converts YUV422 BE (UYVY) Chroma2 Interleaved to XRGB (8:8:8:8) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr2toColor16MU_709_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint32 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
 
    lRGBFramePtr = (uint32*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[0];
            lCr = lYuyvPtr[2];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)lTemp4;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			 lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr2toColor16MU_601_5_FR
Description		: Converts YUV422 BE (UYVY) Chroma2 Interleaved to XRGB (8:8:8:8) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr2toColor16MU_601_5_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint32 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
 
    lRGBFramePtr = (uint32*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[0];
            lCr = lYuyvPtr[2];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)lTemp4;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			 lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr2toColor16MU_709_RR
Description		: Converts YUV422 BE (UYVY) Chroma2 Interleaved to XRGB (8:8:8:8) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr2toColor16MU_709_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint32 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
 
    lRGBFramePtr = (uint32*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[0];
            lCr = lYuyvPtr[2];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)lTemp4;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			 lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr2toColor16MU_601_5_RR
Description		: Converts YUV422 BE (UYVY) Chroma2 Interleaved to XRGB (8:8:8:8) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr2toColor16MU_601_5_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint32 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
 
    lRGBFramePtr = (uint32*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[0];
            lCr = lYuyvPtr[2];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)lTemp4;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			 lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/***** End of YUV422BE input ****/



/**** Start of YUV422LE input *****/
/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr2toColor64k_Ordered_709_FR
Description		: Converts YUV422 LE (YVYU) Chroma2 Interleaved to RGB565 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr2toColor64k_Ordered_709_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[3];
            lCr = lYuyvPtr[1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[2];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)lTemp4;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb = lYuyvPtr[lLumWidth + 3];
            lCr = lYuyvPtr[lLumWidth + 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/         
			lY1 = lYuyvPtr[lLumWidth + 2];

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)lTemp4;
            
            /*Fourth Pixel*/            
			lY1 = lYuyvPtr[lLumWidth];

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr2toColor64k_Ordered_601_5_FR
Description		: Converts YUV422 LE (YVYU) Chroma2 Interleaved to RGB565 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr2toColor64k_Ordered_601_5_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[3];
            lCr = lYuyvPtr[1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[2];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)lTemp4;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb = lYuyvPtr[lLumWidth + 3];
            lCr = lYuyvPtr[lLumWidth + 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/         
			lY1 = lYuyvPtr[lLumWidth + 2];

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)lTemp4;
            
            /*Fourth Pixel*/            
			lY1 = lYuyvPtr[lLumWidth];

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr2toColor64k_Ordered_709_RR
Description		: Converts YUV422 LE (YVYU) Chroma2 Interleaved to RGB565 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr2toColor64k_Ordered_709_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[3];
            lCr = lYuyvPtr[1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)lTemp4;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb = lYuyvPtr[lLumWidth + 3];
            lCr = lYuyvPtr[lLumWidth + 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/         
			lY1 = lYuyvPtr[lLumWidth + 2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)lTemp4;
            
            /*Fourth Pixel*/            
			lY1 = lYuyvPtr[lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr2toColor64k_Ordered_601_5_RR
Description		: Converts YUV422 LE (YVYU) Chroma2 Interleaved to RGB565 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr2toColor64k_Ordered_601_5_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[3];
            lCr = lYuyvPtr[1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)lTemp4;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb = lYuyvPtr[lLumWidth + 3];
            lCr = lYuyvPtr[lLumWidth + 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/         
			lY1 = lYuyvPtr[lLumWidth + 2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)lTemp4;
            
            /*Fourth Pixel*/            
			lY1 = lYuyvPtr[lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr2toColor16M_709_FR
Description		: Converts YUV422 LE (YVYU) Chroma2 Interleaved to RGB888 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr2toColor16M_709_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint8  *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, extraCol, extraRow;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;


	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth * 3;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;
	
	dstXOffset *= 3;
	wndWidth   *= 3;

    lLumWidth = (srcImage->width >> 1) << 1 ;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    lRGBFramePtr  = dstImage + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[3];
            lCr = lYuyvPtr[1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/         
			lY1 = lYuyvPtr[2];

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[1] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			
            lRGBFramePtr[2] = (uint8) lTemp;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[3] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[4] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[5] = (uint8) lTemp;

			lYuyvPtr += 4;
            lRGBFramePtr += 6;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }
	
	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth * 3; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr2toColor16M_601_5_FR
Description		: Converts YUV422 LE (YVYU) Chroma2 Interleaved to RGB888 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr2toColor16M_601_5_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint8  *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, extraCol, extraRow;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth * 3;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	dstXOffset *= 3;
	wndWidth   *= 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    lRGBFramePtr  = dstImage + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[3];
            lCr = lYuyvPtr[1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/         
			lY1 = lYuyvPtr[2];

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[1] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			
            lRGBFramePtr[2] = (uint8) lTemp;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[3] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[4] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[5] = (uint8) lTemp;

			lYuyvPtr += 4;
            lRGBFramePtr += 6;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth * 3; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr2toColor16M_709_RR
Description		: Converts YUV422 LE (YVYU) Chroma2 Interleaved to RGB888 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr2toColor16M_709_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint8  *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, extraCol, extraRow;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth * 3;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	dstXOffset *= 3;
	wndWidth   *= 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    lRGBFramePtr  = dstImage + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[3];
            lCr = lYuyvPtr[1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/         
			lY1 = lYuyvPtr[2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[1] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			
            lRGBFramePtr[2] = (uint8) lTemp;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[3] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[4] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[5] = (uint8) lTemp;

			lYuyvPtr += 4;
            lRGBFramePtr += 6;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth * 3; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr2toColor16M_601_5_RR
Description		: Converts YUV422 LE (YVYU) Chroma2 Interleaved to RGB888 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr2toColor16M_601_5_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint8  *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, extraCol, extraRow;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth * 3;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	dstXOffset *= 3;
	wndWidth   *= 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    lRGBFramePtr  = dstImage + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[3];
            lCr = lYuyvPtr[1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/         
			lY1 = lYuyvPtr[2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[1] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			
            lRGBFramePtr[2] = (uint8) lTemp;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[3] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[4] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[5] = (uint8) lTemp;

			lYuyvPtr += 4;
            lRGBFramePtr += 6;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth * 3; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
	}
	return;
}


/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr2toColor4k_Ordered_709_FR
Description		: Converts YUV422 LE (YVYU) Chroma2 Interleaved to XRGB (4:4:4:4) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr2toColor4k_Ordered_709_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[3];
            lCr = lYuyvPtr[1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[2];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)lTemp4;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb = lYuyvPtr[lLumWidth + 3];
            lCr = lYuyvPtr[lLumWidth + 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/         
			lY1 = lYuyvPtr[lLumWidth + 2];

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)lTemp4;
            
            /*Fourth Pixel*/            
			lY1 = lYuyvPtr[lLumWidth];

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr2toColor4k_Ordered_601_5_FR
Description		: Converts YUV422 LE (YVYU) Chroma2 Interleaved to XRGB (4:4:4:4) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr2toColor4k_Ordered_601_5_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[3];
            lCr = lYuyvPtr[1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[2];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)lTemp4;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb = lYuyvPtr[lLumWidth + 3];
            lCr = lYuyvPtr[lLumWidth + 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/         
			lY1 = lYuyvPtr[lLumWidth + 2];

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)lTemp4;
            
            /*Fourth Pixel*/            
			lY1 = lYuyvPtr[lLumWidth];

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr2toColor4k_Ordered_709_RR
Description		: Converts YUV422 LE (YVYU) Chroma2 Interleaved to XRGB (4:4:4:4) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr2toColor4k_Ordered_709_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[3];
            lCr = lYuyvPtr[1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)lTemp4;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb = lYuyvPtr[lLumWidth + 3];
            lCr = lYuyvPtr[lLumWidth + 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/         
			lY1 = lYuyvPtr[lLumWidth + 2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)lTemp4;
            
            /*Fourth Pixel*/            
			lY1 = lYuyvPtr[lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr2toColor4k_Ordered_601_5_RR
Description		: Converts YUV422 LE (YVYU) Chroma2 Interleaved to XRGB (4:4:4:4) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr2toColor4k_Ordered_601_5_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[3];
            lCr = lYuyvPtr[1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)lTemp4;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb = lYuyvPtr[lLumWidth + 3];
            lCr = lYuyvPtr[lLumWidth + 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/         
			lY1 = lYuyvPtr[lLumWidth + 2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)lTemp4;
            
            /*Fourth Pixel*/            
			lY1 = lYuyvPtr[lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr2toColor16MU_709_FR
Description		: Converts YUV422 LE (YVYU) Chroma2 Interleaved to XRGB (8:8:8:8) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr2toColor16MU_709_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint32 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
 
    lRGBFramePtr = (uint32*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[3];
            lCr = lYuyvPtr[1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[2];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)lTemp4;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			 lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr2toColor16MU_601_5_FR
Description		: Converts YUV422 LE (YVYU) Chroma2 Interleaved to XRGB (8:8:8:8) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr2toColor16MU_601_5_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint32 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
 
    lRGBFramePtr = (uint32*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[3];
            lCr = lYuyvPtr[1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[2];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)lTemp4;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			 lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr2toColor16MU_709_RR
Description		: Converts YUV422 LE (YVYU) Chroma2 Interleaved to XRGB (8:8:8:8) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr2toColor16MU_709_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint32 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
 
    lRGBFramePtr = (uint32*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[3];
            lCr = lYuyvPtr[1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)lTemp4;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			 lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr2toColor16MU_601_5_RR
Description		: Converts YUV422 LE (YVYU) Chroma2 Interleaved to XRGB (8:8:8:8) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr2toColor16MU_601_5_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint32 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
 
    lRGBFramePtr = (uint32*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < lWidth; j += 2)
        {
            lCb = lYuyvPtr[3];
            lCr = lYuyvPtr[1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)lTemp4;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
        }
		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			 lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/***** End of YUV422LE input ****/








/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr2toColor64k_ErrDiff_709_FR
Description		: Converts YUV420 Chroma2 Planar to RGB565 Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr2toColor64k_ErrDiff_709_FR 
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
	uint16 *dest1, *dest2;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
	uint8  *lBuffer;
	uint8  *src1, *src2;
	uint8  *lPtr1, *lPtr2;
    int32  lLumWidth, lWidth, lHeight, lTempWidth, lSrcWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
	int32  diff1, diff2, diff3;
    int32  i, j, k, extraRow, extraCol;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	lBuffer = (uint8*) malloc(lWidth * 3 * 3);

	lSrcWidth = lWidth * 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    dest1 = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    dest2 = dest1 + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
		lPtr1 = src1 = lBuffer;
		lPtr2 = src2 = src1 + lSrcWidth;

		for(k = 0; k < lWidth; k += 2)
		{
            lCr = lCrPtr[k >> 1];
            lCb = lCbPtr[k >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[k];

            lTemp = lY1 + lTemp1;
			*src1 = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Second Pixel*/
            lY1 = lLumPtr[k + 1];

            lTemp = lY1 + lTemp1;
			*(src1 + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));


            /*Third Pixel*/
            lY1 = lLumPtr[k + lLumWidth];

            lTemp = lY1 + lTemp1;
			*src2 = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Fourth Pixel*/
            lY1 = lLumPtr[k + lLumWidth + 1];

            lTemp = lY1 + lTemp1;
			*(src2 + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));


            lCr = lCrPtr[(k + lLumWidth) >> 1];
            lCb = lCbPtr[(k + lLumWidth) >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*Fifth Pixel*/
            lY1 = lLumPtr[k + (lLumWidth << 1)];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Sixth Pixel*/
            lY1 = lLumPtr[k + (lLumWidth << 1) + 1];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

			src1 += 6;
			src2 += 6;
		}

		src1 = lPtr1;
		src2 = lPtr2;

        for(j = 0; j < lWidth; j += 2)
        {
			/* First Pixel */
			*dest1 = (uint16) (*(src1 + 2) >> 3 |  (*(src1 + 1) >> 2) << 5 | (*src1 >> 3) << 11);
			diff1 = *src1 & 0x7;
			diff2 = *(src1 + 1) & 0x3;
			diff3 = *(src1 + 2) & 0x7;

			// diffuse the error
			sDiffuse(i,j,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			/* Second Pixel */
			*(dest1 + 1) = (uint16) (*(src1 + 5) >> 3 |  (*(src1 + 4) >> 2) << 5 | (*(src1 + 3) >> 3) << 11);
			diff1 = *(src1 + 3) & 0x7;
			diff2 = *(src1 + 4) & 0x3;
			diff3 = *(src1 + 5) & 0x7;
			// diffuse the error
			sDiffuse(i,j+1,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j+1,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j+1,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			src1  += 6;
			dest1 += 2;

			/* Third Pixel */			
			*dest2 = (uint16) (*(src2 + 2) >> 3 |  (*(src2 + 1) >> 2) << 5 | (*src2 >> 3) << 11);
			diff1 = *src2 & 0x7;
			diff2 = *(src2 + 1) & 0x3;
			diff3 = *(src2 + 2) & 0x7;
			//diffuse the error
			sDiffuse(i+1,j,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			/* Fourth Pixel */
			*(dest2 + 1) = (uint16) (*(src2 + 5) >> 3 |  (*(src2 + 4) >> 2) << 5 | (*(src2 + 3) >> 3) << 11);
			diff1 = *(src2 + 3) & 0x7;
			diff2 = *(src2 + 4) & 0x3;
			diff3 = *(src2 + 5) & 0x7;
			//diffuse the error
			sDiffuse(i+1,j+1,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j+1,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j+1,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			src2  += 6;
			dest2 += 2;			
        }
		if(extraCol)
		{
			*dest1 = dest1[-1];
			dest1++;
			*dest2 = dest2[-1];
			dest2++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr  += (lLumWidth >> 1);
        lCbPtr  += (lLumWidth >> 1);

        dest1 += ((wndWidth << 1) - lTempWidth);
		dest2 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		dest2 = dest1 - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*dest1++ = *dest2++;
			*dest1++ = *dest2++;
		}
		if(extraCol)
		{
			*dest1 = *dest2;
		}
	}

	free(lBuffer);
	return;
}


/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr2toColor64k_ErrDiff_601_5_FR
Description		: Converts YUV420 Chroma2 Planar to RGB565 Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr2toColor64k_ErrDiff_601_5_FR 
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
	uint16 *dest1, *dest2;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
	uint8  *lBuffer;
	uint8  *src1, *src2;
	uint8  *lPtr1, *lPtr2;
    int32  lLumWidth, lWidth, lHeight, lTempWidth, lSrcWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
	int32  diff1, diff2, diff3;
    int32  i, j, k, extraRow, extraCol;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	lBuffer = (uint8*) malloc(lWidth * 3 * 3);

	lSrcWidth = lWidth * 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    dest1 = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    dest2 = dest1 + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
		lPtr1 = src1 = lBuffer;
		lPtr2 = src2 = src1 + lSrcWidth;

		for(k = 0; k < lWidth; k += 2)
		{
            lCr = lCrPtr[k >> 1];
            lCb = lCbPtr[k >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[k];

            lTemp = lY1 + lTemp1;
			*src1 = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Second Pixel*/
            lY1 = lLumPtr[k + 1];

            lTemp = lY1 + lTemp1;
			*(src1 + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));


            /*Third Pixel*/
            lY1 = lLumPtr[k + lLumWidth];

            lTemp = lY1 + lTemp1;
			*src2 = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Fourth Pixel*/
            lY1 = lLumPtr[k + lLumWidth + 1];

            lTemp = lY1 + lTemp1;
			*(src2 + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));


            lCr = lCrPtr[(k + lLumWidth) >> 1];
            lCb = lCbPtr[(k + lLumWidth) >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*Fifth Pixel*/
            lY1 = lLumPtr[k + (lLumWidth << 1)];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Sixth Pixel*/
            lY1 = lLumPtr[k + (lLumWidth << 1) + 1];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

			src1 += 6;
			src2 += 6;
		}

		src1 = lPtr1;
		src2 = lPtr2;

        for(j = 0; j < lWidth; j += 2)
        {
			/* First Pixel */
			*dest1 = (uint16) (*(src1 + 2) >> 3 |  (*(src1 + 1) >> 2) << 5 | (*src1 >> 3) << 11);
			diff1 = *src1 & 0x7;
			diff2 = *(src1 + 1) & 0x3;
			diff3 = *(src1 + 2) & 0x7;

			// diffuse the error
			sDiffuse(i,j,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			/* Second Pixel */
			*(dest1 + 1) = (uint16) (*(src1 + 5) >> 3 |  (*(src1 + 4) >> 2) << 5 | (*(src1 + 3) >> 3) << 11);
			diff1 = *(src1 + 3) & 0x7;
			diff2 = *(src1 + 4) & 0x3;
			diff3 = *(src1 + 5) & 0x7;
			// diffuse the error
			sDiffuse(i,j+1,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j+1,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j+1,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			src1  += 6;
			dest1 += 2;

			/* Third Pixel */			
			*dest2 = (uint16) (*(src2 + 2) >> 3 |  (*(src2 + 1) >> 2) << 5 | (*src2 >> 3) << 11);
			diff1 = *src2 & 0x7;
			diff2 = *(src2 + 1) & 0x3;
			diff3 = *(src2 + 2) & 0x7;
			//diffuse the error
			sDiffuse(i+1,j,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			/* Fourth Pixel */
			*(dest2 + 1) = (uint16) (*(src2 + 5) >> 3 |  (*(src2 + 4) >> 2) << 5 | (*(src2 + 3) >> 3) << 11);
			diff1 = *(src2 + 3) & 0x7;
			diff2 = *(src2 + 4) & 0x3;
			diff3 = *(src2 + 5) & 0x7;
			//diffuse the error
			sDiffuse(i+1,j+1,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j+1,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j+1,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			src2  += 6;
			dest2 += 2;			
        }
		if(extraCol)
		{
			*dest1 = dest1[-1];
			dest1++;
			*dest2 = dest2[-1];
			dest2++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr  += (lLumWidth >> 1);
        lCbPtr  += (lLumWidth >> 1);

        dest1 += ((wndWidth << 1) - lTempWidth);
		dest2 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		dest2 = dest1 - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*dest1++ = *dest2++;
			*dest1++ = *dest2++;
		}
		if(extraCol)
		{
			*dest1 = *dest2;
		}
	}

	free(lBuffer);
	return;
}


/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr2toColor64k_ErrDiff_709_RR
Description		: Converts YUV420 Chroma2 Planar to RGB565 Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr2toColor64k_ErrDiff_709_RR 
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
	uint16 *dest1, *dest2;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
	uint8  *lBuffer;
	uint8  *src1, *src2;
	uint8  *lPtr1, *lPtr2;
    int32  lLumWidth, lWidth, lHeight, lTempWidth, lSrcWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
	int32  diff1, diff2, diff3;
    int32  i, j, k, extraRow, extraCol;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	lBuffer = (uint8*) malloc(lWidth * 3 * 3);

	lSrcWidth = lWidth * 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    dest1 = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    dest2 = dest1 + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
		lPtr1 = src1 = lBuffer;
		lPtr2 = src2 = src1 + lSrcWidth;

		for(k = 0; k < lWidth; k += 2)
		{
            lCr = lCrPtr[k >> 1];
            lCb = lCbPtr[k >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[k];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*src1 = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Second Pixel*/
            lY1 = lLumPtr[k + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src1 + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));


            /*Third Pixel*/
            lY1 = lLumPtr[k + lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*src2 = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Fourth Pixel*/
            lY1 = lLumPtr[k + lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lCr = lCrPtr[(k + lLumWidth) >> 1];
            lCb = lCbPtr[(k + lLumWidth) >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*Fifth Pixel*/
            lY1 = lLumPtr[k + (lLumWidth << 1)];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Sixth Pixel*/
            lY1 = lLumPtr[k + (lLumWidth << 1) + 1];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

			src1 += 6;
			src2 += 6;
		}

		src1 = lPtr1;
		src2 = lPtr2;

        for(j = 0; j < lWidth; j += 2)
        {
			/* First Pixel */
			*dest1 = (uint16) (*(src1 + 2) >> 3 |  (*(src1 + 1) >> 2) << 5 | (*src1 >> 3) << 11);
			diff1 = *src1 & 0x7;
			diff2 = *(src1 + 1) & 0x3;
			diff3 = *(src1 + 2) & 0x7;

			// diffuse the error
			sDiffuse(i,j,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			/* Second Pixel */
			*(dest1 + 1) = (uint16) (*(src1 + 5) >> 3 |  (*(src1 + 4) >> 2) << 5 | (*(src1 + 3) >> 3) << 11);
			diff1 = *(src1 + 3) & 0x7;
			diff2 = *(src1 + 4) & 0x3;
			diff3 = *(src1 + 5) & 0x7;
			// diffuse the error
			sDiffuse(i,j+1,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j+1,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j+1,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			src1  += 6;
			dest1 += 2;

			/* Third Pixel */			
			*dest2 = (uint16) (*(src2 + 2) >> 3 |  (*(src2 + 1) >> 2) << 5 | (*src2 >> 3) << 11);
			diff1 = *src2 & 0x7;
			diff2 = *(src2 + 1) & 0x3;
			diff3 = *(src2 + 2) & 0x7;
			//diffuse the error
			sDiffuse(i+1,j,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			/* Fourth Pixel */
			*(dest2 + 1) = (uint16) (*(src2 + 5) >> 3 |  (*(src2 + 4) >> 2) << 5 | (*(src2 + 3) >> 3) << 11);
			diff1 = *(src2 + 3) & 0x7;
			diff2 = *(src2 + 4) & 0x3;
			diff3 = *(src2 + 5) & 0x7;
			//diffuse the error
			sDiffuse(i+1,j+1,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j+1,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j+1,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			src2  += 6;
			dest2 += 2;			
        }
		if(extraCol)
		{
			*dest1 = dest1[-1];
			dest1++;
			*dest2 = dest2[-1];
			dest2++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr  += (lLumWidth >> 1);
        lCbPtr  += (lLumWidth >> 1);

        dest1 += ((wndWidth << 1) - lTempWidth);
		dest2 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		dest2 = dest1 - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*dest1++ = *dest2++;
			*dest1++ = *dest2++;
		}
		if(extraCol)
		{
			*dest1 = *dest2;
		}
	}

	free(lBuffer);
	return;
}


/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr2toColor64k_ErrDiff_601_5_RR
Description		: Converts YUV420 Chroma2 Planar to RGB565 Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr2toColor64k_ErrDiff_601_5_RR 
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
	uint16 *dest1, *dest2;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
	uint8  *lBuffer;
	uint8  *src1, *src2;
	uint8  *lPtr1, *lPtr2;
    int32  lLumWidth, lWidth, lHeight, lTempWidth, lSrcWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
	int32  diff1, diff2, diff3;
    int32  i, j, k, extraRow, extraCol;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	lBuffer = (uint8*) malloc(lWidth * 3 * 3);

	lSrcWidth = lWidth * 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    dest1 = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    dest2 = dest1 + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
		lPtr1 = src1 = lBuffer;
		lPtr2 = src2 = src1 + lSrcWidth;

		for(k = 0; k < lWidth; k += 2)
		{
            lCr = lCrPtr[k >> 1];
            lCb = lCbPtr[k >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[k];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*src1 = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Second Pixel*/
            lY1 = lLumPtr[k + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src1 + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));


            /*Third Pixel*/
            lY1 = lLumPtr[k + lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*src2 = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Fourth Pixel*/
            lY1 = lLumPtr[k + lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lCr = lCrPtr[(k + lLumWidth) >> 1];
            lCb = lCbPtr[(k + lLumWidth) >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*Fifth Pixel*/
            lY1 = lLumPtr[k + (lLumWidth << 1)];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Sixth Pixel*/
            lY1 = lLumPtr[k + (lLumWidth << 1) + 1];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

			src1 += 6;
			src2 += 6;
		}

		src1 = lPtr1;
		src2 = lPtr2;

        for(j = 0; j < lWidth; j += 2)
        {
			/* First Pixel */
			*dest1 = (uint16) (*(src1 + 2) >> 3 |  (*(src1 + 1) >> 2) << 5 | (*src1 >> 3) << 11);
			diff1 = *src1 & 0x7;
			diff2 = *(src1 + 1) & 0x3;
			diff3 = *(src1 + 2) & 0x7;

			// diffuse the error
			sDiffuse(i,j,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			/* Second Pixel */
			*(dest1 + 1) = (uint16) (*(src1 + 5) >> 3 |  (*(src1 + 4) >> 2) << 5 | (*(src1 + 3) >> 3) << 11);
			diff1 = *(src1 + 3) & 0x7;
			diff2 = *(src1 + 4) & 0x3;
			diff3 = *(src1 + 5) & 0x7;
			// diffuse the error
			sDiffuse(i,j+1,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j+1,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j+1,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			src1  += 6;
			dest1 += 2;

			/* Third Pixel */			
			*dest2 = (uint16) (*(src2 + 2) >> 3 |  (*(src2 + 1) >> 2) << 5 | (*src2 >> 3) << 11);
			diff1 = *src2 & 0x7;
			diff2 = *(src2 + 1) & 0x3;
			diff3 = *(src2 + 2) & 0x7;
			//diffuse the error
			sDiffuse(i+1,j,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			/* Fourth Pixel */
			*(dest2 + 1) = (uint16) (*(src2 + 5) >> 3 |  (*(src2 + 4) >> 2) << 5 | (*(src2 + 3) >> 3) << 11);
			diff1 = *(src2 + 3) & 0x7;
			diff2 = *(src2 + 4) & 0x3;
			diff3 = *(src2 + 5) & 0x7;
			//diffuse the error
			sDiffuse(i+1,j+1,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j+1,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j+1,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			src2  += 6;
			dest2 += 2;			
        }
		if(extraCol)
		{
			*dest1 = dest1[-1];
			dest1++;
			*dest2 = dest2[-1];
			dest2++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr  += (lLumWidth >> 1);
        lCbPtr  += (lLumWidth >> 1);

        dest1 += ((wndWidth << 1) - lTempWidth);
		dest2 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		dest2 = dest1 - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*dest1++ = *dest2++;
			*dest1++ = *dest2++;
		}
		if(extraCol)
		{
			*dest1 = *dest2;
		}
	}

	free(lBuffer);
	return;
}


/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr2toColor64k_ErrDiff_709_FR
Description		: Converts YUV422 BE (UYVY) Chroma2 Interleaved to RGB565 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr2toColor64k_ErrDiff_709_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *dest1, *dest2;
    uint8  *lYuyvPtr;
	uint8  *lBuffer;
	uint8  *src1, *src2;
	uint8  *lPtr1, *lPtr2;
	int32  diff1, diff2, diff3;
    int32  lLumWidth, lWidth, lHeight, lTempWidth, lSrcWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, k, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	lBuffer = (uint8*) malloc(lWidth * 3 * 3);

	lSrcWidth = lWidth * 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    dest1 = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    dest2 = dest1 + wndWidth;

   	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
		lPtr1 = src1 = lBuffer;
		lPtr2 = src2 = src1 + lSrcWidth;

		for(k = 0; k < lWidth; k += 2)
		{
            lCb = lYuyvPtr[0];
            lCr = lYuyvPtr[2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];

            lTemp = lY1 + lTemp1;
			*src1 = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Second Pixel*/
			lY1 = lYuyvPtr[3];

            lTemp = lY1 + lTemp1;
			*(src1 + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lCb = lYuyvPtr[lLumWidth];
            lCr = lYuyvPtr[lLumWidth + 2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/
            lY1 = lYuyvPtr[lLumWidth + 1];

            lTemp = lY1 + lTemp1;
			*src2 = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Fourth Pixel*/
            lY1 = lYuyvPtr[lLumWidth + 3];

            lTemp = lY1 + lTemp1;
			*(src2 + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lCb = lYuyvPtr[(lLumWidth << 1)];
            lCr = lYuyvPtr[(lLumWidth << 1) + 2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*Fifth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1) + 1];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Sixth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1) + 3];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

			lYuyvPtr += 4;
			src1 += 6;
			src2 += 6;
		}

		src1 = lPtr1;
		src2 = lPtr2;

        for(j = 0; j < lWidth; j += 2)
        {
			/* First Pixel */
			*dest1 = (uint16) (*(src1 + 2) >> 3 |  (*(src1 + 1) >> 2) << 5 | (*src1 >> 3) << 11);
			diff1 = *src1 & 0x7;
			diff2 = *(src1 + 1) & 0x3;
			diff3 = *(src1 + 2) & 0x7;

			// diffuse the error
			sDiffuse(i,j,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			/* Second Pixel */
			*(dest1 + 1) = (uint16) (*(src1 + 5) >> 3 |  (*(src1 + 4) >> 2) << 5 | (*(src1 + 3) >> 3) << 11);
			diff1 = *(src1 + 3) & 0x7;
			diff2 = *(src1 + 4) & 0x3;
			diff3 = *(src1 + 5) & 0x7;
			// diffuse the error
			sDiffuse(i,j+1,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j+1,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j+1,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			src1  += 6;
			dest1 += 2;

			/* Third Pixel */			
			*dest2 = (uint16) (*(src2 + 2) >> 3 |  (*(src2 + 1) >> 2) << 5 | (*src2 >> 3) << 11);
			diff1 = *src2 & 0x7;
			diff2 = *(src2 + 1) & 0x3;
			diff3 = *(src2 + 2) & 0x7;
			//diffuse the error
			sDiffuse(i+1,j,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			/* Fourth Pixel */
			*(dest2 + 1) = (uint16) (*(src2 + 5) >> 3 |  (*(src2 + 4) >> 2) << 5 | (*(src2 + 3) >> 3) << 11);
			diff1 = *(src2 + 3) & 0x7;
			diff2 = *(src2 + 4) & 0x3;
			diff3 = *(src2 + 5) & 0x7;
			//diffuse the error
			sDiffuse(i+1,j+1,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j+1,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j+1,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			src2  += 6;
			dest2 += 2;			
        }
		if(extraCol)
		{
			*dest1 = dest1[-1];
			 dest1++;
			*dest2 = dest2[-1];
			 dest2++;
		}

		lYuyvPtr += ((lLumWidth - lWidth) << 1);

        dest1 += ((wndWidth << 1) - lTempWidth);
		dest2 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		dest2 = dest1 - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*dest1++ = *dest2++;
			*dest1++ = *dest2++;
		}
		if(extraCol)
		{
			*dest1 = *dest2;
		}
	}

	free(lBuffer);
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr2toColor64k_ErrDiff_601_5_FR
Description		: Converts YUV422 BE (UYVY) Chroma2 Interleaved to RGB565 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr2toColor64k_ErrDiff_601_5_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *dest1, *dest2;
    uint8  *lYuyvPtr;
	uint8  *lBuffer;
	uint8  *src1, *src2;
	uint8  *lPtr1, *lPtr2;
	int32  diff1, diff2, diff3;
    int32  lLumWidth, lWidth, lHeight, lTempWidth, lSrcWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, k, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	lBuffer = (uint8*) malloc(lWidth * 3 * 3);

	lSrcWidth = lWidth * 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    dest1 = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    dest2 = dest1 + wndWidth;

   	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
		lPtr1 = src1 = lBuffer;
		lPtr2 = src2 = src1 + lSrcWidth;

		for(k = 0; k < lWidth; k += 2)
		{
            lCb = lYuyvPtr[0];
            lCr = lYuyvPtr[2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];

            lTemp = lY1 + lTemp1;
			*src1 = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Second Pixel*/
			lY1 = lYuyvPtr[3];

            lTemp = lY1 + lTemp1;
			*(src1 + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lCb = lYuyvPtr[lLumWidth];
            lCr = lYuyvPtr[lLumWidth + 2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/
            lY1 = lYuyvPtr[lLumWidth + 1];

            lTemp = lY1 + lTemp1;
			*src2 = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Fourth Pixel*/
            lY1 = lYuyvPtr[lLumWidth + 3];

            lTemp = lY1 + lTemp1;
			*(src2 + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lCb = lYuyvPtr[(lLumWidth << 1)];
            lCr = lYuyvPtr[(lLumWidth << 1) + 2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*Fifth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1) + 1];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Sixth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1) + 3];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

			lYuyvPtr += 4;
			src1 += 6;
			src2 += 6;
		}

		src1 = lPtr1;
		src2 = lPtr2;

        for(j = 0; j < lWidth; j += 2)
        {
			/* First Pixel */
			*dest1 = (uint16) (*(src1 + 2) >> 3 |  (*(src1 + 1) >> 2) << 5 | (*src1 >> 3) << 11);
			diff1 = *src1 & 0x7;
			diff2 = *(src1 + 1) & 0x3;
			diff3 = *(src1 + 2) & 0x7;

			// diffuse the error
			sDiffuse(i,j,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			/* Second Pixel */
			*(dest1 + 1) = (uint16) (*(src1 + 5) >> 3 |  (*(src1 + 4) >> 2) << 5 | (*(src1 + 3) >> 3) << 11);
			diff1 = *(src1 + 3) & 0x7;
			diff2 = *(src1 + 4) & 0x3;
			diff3 = *(src1 + 5) & 0x7;
			// diffuse the error
			sDiffuse(i,j+1,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j+1,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j+1,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			src1  += 6;
			dest1 += 2;

			/* Third Pixel */			
			*dest2 = (uint16) (*(src2 + 2) >> 3 |  (*(src2 + 1) >> 2) << 5 | (*src2 >> 3) << 11);
			diff1 = *src2 & 0x7;
			diff2 = *(src2 + 1) & 0x3;
			diff3 = *(src2 + 2) & 0x7;
			//diffuse the error
			sDiffuse(i+1,j,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			/* Fourth Pixel */
			*(dest2 + 1) = (uint16) (*(src2 + 5) >> 3 |  (*(src2 + 4) >> 2) << 5 | (*(src2 + 3) >> 3) << 11);
			diff1 = *(src2 + 3) & 0x7;
			diff2 = *(src2 + 4) & 0x3;
			diff3 = *(src2 + 5) & 0x7;
			//diffuse the error
			sDiffuse(i+1,j+1,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j+1,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j+1,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			src2  += 6;
			dest2 += 2;			
        }
		if(extraCol)
		{
			*dest1 = dest1[-1];
			 dest1++;
			*dest2 = dest2[-1];
			 dest2++;
		}

		lYuyvPtr += ((lLumWidth - lWidth) << 1);

        dest1 += ((wndWidth << 1) - lTempWidth);
		dest2 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		dest2 = dest1 - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*dest1++ = *dest2++;
			*dest1++ = *dest2++;
		}
		if(extraCol)
		{
			*dest1 = *dest2;
		}
	}

	free(lBuffer);
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr2toColor64k_ErrDiff_709_RR
Description		: Converts YUV422 BE (UYVY) Chroma2 Interleaved to RGB565 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr2toColor64k_ErrDiff_709_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *dest1, *dest2;
    uint8  *lYuyvPtr;
	uint8  *lBuffer;
	uint8  *src1, *src2;
	uint8  *lPtr1, *lPtr2;
	int32  diff1, diff2, diff3;
    int32  lLumWidth, lWidth, lHeight, lTempWidth, lSrcWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, k, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	lBuffer = (uint8*) malloc(lWidth * 3 * 3);

	lSrcWidth = lWidth * 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    dest1 = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    dest2 = dest1 + wndWidth;

   	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
		lPtr1 = src1 = lBuffer;
		lPtr2 = src2 = src1 + lSrcWidth;

		for(k = 0; k < lWidth; k += 2)
		{
            lCb = lYuyvPtr[0];
            lCr = lYuyvPtr[2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*src1 = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Second Pixel*/
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src1 + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lCb = lYuyvPtr[lLumWidth];
            lCr = lYuyvPtr[lLumWidth + 2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/
            lY1 = lYuyvPtr[lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*src2 = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Fourth Pixel*/
            lY1 = lYuyvPtr[lLumWidth + 3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lCb = lYuyvPtr[(lLumWidth << 1)];
            lCr = lYuyvPtr[(lLumWidth << 1) + 2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*Fifth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1) + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Sixth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1) + 3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

			lYuyvPtr += 4;
			src1 += 6;
			src2 += 6;
		}

		src1 = lPtr1;
		src2 = lPtr2;

        for(j = 0; j < lWidth; j += 2)
        {
			/* First Pixel */
			*dest1 = (uint16) (*(src1 + 2) >> 3 |  (*(src1 + 1) >> 2) << 5 | (*src1 >> 3) << 11);
			diff1 = *src1 & 0x7;
			diff2 = *(src1 + 1) & 0x3;
			diff3 = *(src1 + 2) & 0x7;

			// diffuse the error
			sDiffuse(i,j,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			/* Second Pixel */
			*(dest1 + 1) = (uint16) (*(src1 + 5) >> 3 |  (*(src1 + 4) >> 2) << 5 | (*(src1 + 3) >> 3) << 11);
			diff1 = *(src1 + 3) & 0x7;
			diff2 = *(src1 + 4) & 0x3;
			diff3 = *(src1 + 5) & 0x7;
			// diffuse the error
			sDiffuse(i,j+1,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j+1,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j+1,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			src1  += 6;
			dest1 += 2;

			/* Third Pixel */			
			*dest2 = (uint16) (*(src2 + 2) >> 3 |  (*(src2 + 1) >> 2) << 5 | (*src2 >> 3) << 11);
			diff1 = *src2 & 0x7;
			diff2 = *(src2 + 1) & 0x3;
			diff3 = *(src2 + 2) & 0x7;
			//diffuse the error
			sDiffuse(i+1,j,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			/* Fourth Pixel */
			*(dest2 + 1) = (uint16) (*(src2 + 5) >> 3 |  (*(src2 + 4) >> 2) << 5 | (*(src2 + 3) >> 3) << 11);
			diff1 = *(src2 + 3) & 0x7;
			diff2 = *(src2 + 4) & 0x3;
			diff3 = *(src2 + 5) & 0x7;
			//diffuse the error
			sDiffuse(i+1,j+1,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j+1,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j+1,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			src2  += 6;
			dest2 += 2;			
        }
		if(extraCol)
		{
			*dest1 = dest1[-1];
			 dest1++;
			*dest2 = dest2[-1];
			 dest2++;
		}

		lYuyvPtr += ((lLumWidth - lWidth) << 1);

        dest1 += ((wndWidth << 1) - lTempWidth);
		dest2 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		dest2 = dest1 - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*dest1++ = *dest2++;
			*dest1++ = *dest2++;
		}
		if(extraCol)
		{
			*dest1 = *dest2;
		}
	}

	free(lBuffer);
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr2toColor64k_ErrDiff_601_5_RR
Description		: Converts YUV422 BE (UYVY) Chroma2 Interleaved to RGB565 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr2toColor64k_ErrDiff_601_5_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *dest1, *dest2;
    uint8  *lYuyvPtr;
	uint8  *lBuffer;
	uint8  *src1, *src2;
	uint8  *lPtr1, *lPtr2;
	int32  diff1, diff2, diff3;
    int32  lLumWidth, lWidth, lHeight, lTempWidth, lSrcWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, k, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	lBuffer = (uint8*) malloc(lWidth * 3 * 3);

	lSrcWidth = lWidth * 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    dest1 = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    dest2 = dest1 + wndWidth;

   	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
		lPtr1 = src1 = lBuffer;
		lPtr2 = src2 = src1 + lSrcWidth;

		for(k = 0; k < lWidth; k += 2)
		{
            lCb = lYuyvPtr[0];
            lCr = lYuyvPtr[2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*src1 = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Second Pixel*/
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src1 + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lCb = lYuyvPtr[lLumWidth];
            lCr = lYuyvPtr[lLumWidth + 2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/
            lY1 = lYuyvPtr[lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*src2 = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Fourth Pixel*/
            lY1 = lYuyvPtr[lLumWidth + 3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lCb = lYuyvPtr[(lLumWidth << 1)];
            lCr = lYuyvPtr[(lLumWidth << 1) + 2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*Fifth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1) + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Sixth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1) + 3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

			lYuyvPtr += 4;
			src1 += 6;
			src2 += 6;
		}

		src1 = lPtr1;
		src2 = lPtr2;

        for(j = 0; j < lWidth; j += 2)
        {
			/* First Pixel */
			*dest1 = (uint16) (*(src1 + 2) >> 3 |  (*(src1 + 1) >> 2) << 5 | (*src1 >> 3) << 11);
			diff1 = *src1 & 0x7;
			diff2 = *(src1 + 1) & 0x3;
			diff3 = *(src1 + 2) & 0x7;

			// diffuse the error
			sDiffuse(i,j,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			/* Second Pixel */
			*(dest1 + 1) = (uint16) (*(src1 + 5) >> 3 |  (*(src1 + 4) >> 2) << 5 | (*(src1 + 3) >> 3) << 11);
			diff1 = *(src1 + 3) & 0x7;
			diff2 = *(src1 + 4) & 0x3;
			diff3 = *(src1 + 5) & 0x7;
			// diffuse the error
			sDiffuse(i,j+1,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j+1,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j+1,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			src1  += 6;
			dest1 += 2;

			/* Third Pixel */			
			*dest2 = (uint16) (*(src2 + 2) >> 3 |  (*(src2 + 1) >> 2) << 5 | (*src2 >> 3) << 11);
			diff1 = *src2 & 0x7;
			diff2 = *(src2 + 1) & 0x3;
			diff3 = *(src2 + 2) & 0x7;
			//diffuse the error
			sDiffuse(i+1,j,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			/* Fourth Pixel */
			*(dest2 + 1) = (uint16) (*(src2 + 5) >> 3 |  (*(src2 + 4) >> 2) << 5 | (*(src2 + 3) >> 3) << 11);
			diff1 = *(src2 + 3) & 0x7;
			diff2 = *(src2 + 4) & 0x3;
			diff3 = *(src2 + 5) & 0x7;
			//diffuse the error
			sDiffuse(i+1,j+1,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j+1,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j+1,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			src2  += 6;
			dest2 += 2;			
        }
		if(extraCol)
		{
			*dest1 = dest1[-1];
			 dest1++;
			*dest2 = dest2[-1];
			 dest2++;
		}

		lYuyvPtr += ((lLumWidth - lWidth) << 1);

        dest1 += ((wndWidth << 1) - lTempWidth);
		dest2 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		dest2 = dest1 - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*dest1++ = *dest2++;
			*dest1++ = *dest2++;
		}
		if(extraCol)
		{
			*dest1 = *dest2;
		}
	}

	free(lBuffer);
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr2toColor4k_ErrDiff_709_FR
Description		: Converts YUV422 LE (YVYU) Chroma2 Interleaved to XRGB (4:4:4:4) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr2toColor4k_ErrDiff_709_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *dest1, *dest2;
    uint8  *lYuyvPtr;
	uint8  *lBuffer;
	uint8  *src1, *src2;
	uint8  *lPtr1, *lPtr2;
	int32  diff1, diff2, diff3;
    int32  lLumWidth, lWidth, lHeight, lTempWidth, lSrcWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, k, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	lBuffer = (uint8*) malloc(lWidth * 3 * 3);

	lSrcWidth = lWidth * 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    dest1 = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    dest2 = dest1 + wndWidth;

   	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
		lPtr1 = src1 = lBuffer;
		lPtr2 = src2 = src1 + lSrcWidth;

		for(k = 0; k < lWidth; k += 2)
		{
            lCb = lYuyvPtr[3];
            lCr = lYuyvPtr[1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[2];

            lTemp = lY1 + lTemp1;
			*src1 = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Second Pixel*/
			lY1 = lYuyvPtr[0];

            lTemp = lY1 + lTemp1;
			*(src1 + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lCb = lYuyvPtr[lLumWidth + 3];
            lCr = lYuyvPtr[lLumWidth + 1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/
            lY1 = lYuyvPtr[lLumWidth + 2];

            lTemp = lY1 + lTemp1;
			*src2 = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Fourth Pixel*/
            lY1 = lYuyvPtr[lLumWidth];

            lTemp = lY1 + lTemp1;
			*(src2 + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lCb = lYuyvPtr[(lLumWidth << 1) + 3];
            lCr = lYuyvPtr[(lLumWidth << 1) + 1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*Fifth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1) + 2];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Sixth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1)];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

			lYuyvPtr += 4;
			src1 += 6;
			src2 += 6;
		}

		src1 = lPtr1;
		src2 = lPtr2;

        for(j = 0; j < lWidth; j += 2)
        {
			/* First Pixel */
			*dest1 = (uint16) (*(src1 + 2) >> 4 |  (*(src1 + 1) >> 4) << 4 | (*src1 >> 4) << 8);
			diff1 = *src1 & 0xf;
			diff2 = *(src1 + 1) & 0xf;
			diff3 = *(src1 + 2) & 0xf;

			// diffuse the error
			sDiffuse(i,j,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			/* Second Pixel */
			*(dest1 + 1) = (uint16) (*(src1 + 5) >> 4 |  (*(src1 + 4) >> 4) << 4 | (*(src1 + 3) >> 4) << 8);
			diff1 = *(src1 + 3) & 0xf;
			diff2 = *(src1 + 4) & 0xf;
			diff3 = *(src1 + 5) & 0xf;
			// diffuse the error
			sDiffuse(i,j+1,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j+1,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j+1,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			src1  += 6;
			dest1 += 2;

			/* Third Pixel */			
			*dest2 = (uint16) (*(src2 + 2) >> 4 |  (*(src2 + 1) >> 4) << 4 | (*src2 >> 4) << 8);
			diff1 = *src2 & 0xf;
			diff2 = *(src2 + 1) & 0xf;
			diff3 = *(src2 + 2) & 0xf;
			//diffuse the error
			sDiffuse(i+1,j,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			/* Fourth Pixel */
			*(dest2 + 1) = (uint16) (*(src2 + 5) >> 4 |  (*(src2 + 4) >> 4) << 4 | (*(src2 + 3) >> 4) << 8);
			diff1 = *(src2 + 3) & 0xf;
			diff2 = *(src2 + 4) & 0xf;
			diff3 = *(src2 + 5) & 0xf;
			//diffuse the error
			sDiffuse(i+1,j+1,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j+1,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j+1,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			src2  += 6;
			dest2 += 2;			
        }
		if(extraCol)
		{
			*dest1 = dest1[-1];
			 dest1++;
			*dest2 = dest2[-1];
			 dest2++;
		}

		lYuyvPtr += ((lLumWidth - lWidth) << 1);

        dest1 += ((wndWidth << 1) - lTempWidth);
		dest2 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		dest2 = dest1 - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*dest1++ = *dest2++;
			*dest1++ = *dest2++;
		}
		if(extraCol)
		{
			*dest1 = *dest2;
		}
	}

	free(lBuffer);
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr2toColor4k_ErrDiff_601_5_FR
Description		: Converts YUV422 LE (YVYU) Chroma2 Interleaved to XRGB (4:4:4:4) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr2toColor4k_ErrDiff_601_5_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *dest1, *dest2;
    uint8  *lYuyvPtr;
	uint8  *lBuffer;
	uint8  *src1, *src2;
	uint8  *lPtr1, *lPtr2;
	int32  diff1, diff2, diff3;
    int32  lLumWidth, lWidth, lHeight, lTempWidth, lSrcWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, k, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	lBuffer = (uint8*) malloc(lWidth * 3 * 3);

	lSrcWidth = lWidth * 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    dest1 = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    dest2 = dest1 + wndWidth;

   	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
		lPtr1 = src1 = lBuffer;
		lPtr2 = src2 = src1 + lSrcWidth;

		for(k = 0; k < lWidth; k += 2)
		{
            lCb = lYuyvPtr[3];
            lCr = lYuyvPtr[1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[2];

            lTemp = lY1 + lTemp1;
			*src1 = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Second Pixel*/
			lY1 = lYuyvPtr[0];

            lTemp = lY1 + lTemp1;
			*(src1 + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lCb = lYuyvPtr[lLumWidth + 3];
            lCr = lYuyvPtr[lLumWidth + 1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/
            lY1 = lYuyvPtr[lLumWidth + 2];

            lTemp = lY1 + lTemp1;
			*src2 = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Fourth Pixel*/
            lY1 = lYuyvPtr[lLumWidth];

            lTemp = lY1 + lTemp1;
			*(src2 + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lCb = lYuyvPtr[(lLumWidth << 1) + 3];
            lCr = lYuyvPtr[(lLumWidth << 1) + 1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*Fifth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1) + 2];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Sixth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1)];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

			lYuyvPtr += 4;
			src1 += 6;
			src2 += 6;
		}

		src1 = lPtr1;
		src2 = lPtr2;

        for(j = 0; j < lWidth; j += 2)
        {
			/* First Pixel */
			*dest1 = (uint16) (*(src1 + 2) >> 4 |  (*(src1 + 1) >> 4) << 4 | (*src1 >> 4) << 8);
			diff1 = *src1 & 0xf;
			diff2 = *(src1 + 1) & 0xf;
			diff3 = *(src1 + 2) & 0xf;

			// diffuse the error
			sDiffuse(i,j,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			/* Second Pixel */
			*(dest1 + 1) = (uint16) (*(src1 + 5) >> 4 |  (*(src1 + 4) >> 4) << 4 | (*(src1 + 3) >> 4) << 8);
			diff1 = *(src1 + 3) & 0xf;
			diff2 = *(src1 + 4) & 0xf;
			diff3 = *(src1 + 5) & 0xf;
			// diffuse the error
			sDiffuse(i,j+1,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j+1,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j+1,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			src1  += 6;
			dest1 += 2;

			/* Third Pixel */			
			*dest2 = (uint16) (*(src2 + 2) >> 4 |  (*(src2 + 1) >> 4) << 4 | (*src2 >> 4) << 8);
			diff1 = *src2 & 0xf;
			diff2 = *(src2 + 1) & 0xf;
			diff3 = *(src2 + 2) & 0xf;
			//diffuse the error
			sDiffuse(i+1,j,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			/* Fourth Pixel */
			*(dest2 + 1) = (uint16) (*(src2 + 5) >> 4 |  (*(src2 + 4) >> 4) << 4 | (*(src2 + 3) >> 4) << 8);
			diff1 = *(src2 + 3) & 0xf;
			diff2 = *(src2 + 4) & 0xf;
			diff3 = *(src2 + 5) & 0xf;
			//diffuse the error
			sDiffuse(i+1,j+1,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j+1,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j+1,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			src2  += 6;
			dest2 += 2;			
        }
		if(extraCol)
		{
			*dest1 = dest1[-1];
			 dest1++;
			*dest2 = dest2[-1];
			 dest2++;
		}

		lYuyvPtr += ((lLumWidth - lWidth) << 1);

        dest1 += ((wndWidth << 1) - lTempWidth);
		dest2 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		dest2 = dest1 - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*dest1++ = *dest2++;
			*dest1++ = *dest2++;
		}
		if(extraCol)
		{
			*dest1 = *dest2;
		}
	}

	free(lBuffer);
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr2toColor4k_ErrDiff_709_RR
Description		: Converts YUV422 LE (YVYU) Chroma2 Interleaved to XRGB (4:4:4:4) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr2toColor4k_ErrDiff_709_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *dest1, *dest2;
    uint8  *lYuyvPtr;
	uint8  *lBuffer;
	uint8  *src1, *src2;
	uint8  *lPtr1, *lPtr2;
	int32  diff1, diff2, diff3;
    int32  lLumWidth, lWidth, lHeight, lTempWidth, lSrcWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, k, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	lBuffer = (uint8*) malloc(lWidth * 3 * 3);

	lSrcWidth = lWidth * 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    dest1 = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    dest2 = dest1 + wndWidth;

   	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
		lPtr1 = src1 = lBuffer;
		lPtr2 = src2 = src1 + lSrcWidth;

		for(k = 0; k < lWidth; k += 2)
		{
            lCb = lYuyvPtr[3];
            lCr = lYuyvPtr[1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*src1 = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Second Pixel*/
			lY1 = lYuyvPtr[0];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src1 + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lCb = lYuyvPtr[lLumWidth + 3];
            lCr = lYuyvPtr[lLumWidth + 1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/
            lY1 = lYuyvPtr[lLumWidth + 2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*src2 = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Fourth Pixel*/
            lY1 = lYuyvPtr[lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lCb = lYuyvPtr[(lLumWidth << 1) + 3];
            lCr = lYuyvPtr[(lLumWidth << 1) + 1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*Fifth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1) + 2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Sixth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1)];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

			lYuyvPtr += 4;
			src1 += 6;
			src2 += 6;
		}

		src1 = lPtr1;
		src2 = lPtr2;

        for(j = 0; j < lWidth; j += 2)
        {
			/* First Pixel */
			*dest1 = (uint16) (*(src1 + 2) >> 4 |  (*(src1 + 1) >> 4) << 4 | (*src1 >> 4) << 8);
			diff1 = *src1 & 0xf;
			diff2 = *(src1 + 1) & 0xf;
			diff3 = *(src1 + 2) & 0xf;

			// diffuse the error
			sDiffuse(i,j,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			/* Second Pixel */
			*(dest1 + 1) = (uint16) (*(src1 + 5) >> 4 |  (*(src1 + 4) >> 4) << 4 | (*(src1 + 3) >> 4) << 8);
			diff1 = *(src1 + 3) & 0xf;
			diff2 = *(src1 + 4) & 0xf;
			diff3 = *(src1 + 5) & 0xf;
			// diffuse the error
			sDiffuse(i,j+1,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j+1,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j+1,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			src1  += 6;
			dest1 += 2;

			/* Third Pixel */			
			*dest2 = (uint16) (*(src2 + 2) >> 4 |  (*(src2 + 1) >> 4) << 4 | (*src2 >> 4) << 8);
			diff1 = *src2 & 0xf;
			diff2 = *(src2 + 1) & 0xf;
			diff3 = *(src2 + 2) & 0xf;
			//diffuse the error
			sDiffuse(i+1,j,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			/* Fourth Pixel */
			*(dest2 + 1) = (uint16) (*(src2 + 5) >> 4 |  (*(src2 + 4) >> 4) << 4 | (*(src2 + 3) >> 4) << 8);
			diff1 = *(src2 + 3) & 0xf;
			diff2 = *(src2 + 4) & 0xf;
			diff3 = *(src2 + 5) & 0xf;
			//diffuse the error
			sDiffuse(i+1,j+1,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j+1,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j+1,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			src2  += 6;
			dest2 += 2;			
        }
		if(extraCol)
		{
			*dest1 = dest1[-1];
			 dest1++;
			*dest2 = dest2[-1];
			 dest2++;
		}

		lYuyvPtr += ((lLumWidth - lWidth) << 1);

        dest1 += ((wndWidth << 1) - lTempWidth);
		dest2 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		dest2 = dest1 - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*dest1++ = *dest2++;
			*dest1++ = *dest2++;
		}
		if(extraCol)
		{
			*dest1 = *dest2;
		}
	}

	free(lBuffer);
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr2toColor4k_ErrDiff_601_5_RR
Description		: Converts YUV422 LE (YVYU) Chroma2 Interleaved to XRGB (4:4:4:4) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr2toColor4k_ErrDiff_601_5_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *dest1, *dest2;
    uint8  *lYuyvPtr;
	uint8  *lBuffer;
	uint8  *src1, *src2;
	uint8  *lPtr1, *lPtr2;
	int32  diff1, diff2, diff3;
    int32  lLumWidth, lWidth, lHeight, lTempWidth, lSrcWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, k, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	lBuffer = (uint8*) malloc(lWidth * 3 * 3);

	lSrcWidth = lWidth * 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    dest1 = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    dest2 = dest1 + wndWidth;

   	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
		lPtr1 = src1 = lBuffer;
		lPtr2 = src2 = src1 + lSrcWidth;

		for(k = 0; k < lWidth; k += 2)
		{
            lCb = lYuyvPtr[3];
            lCr = lYuyvPtr[1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*src1 = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Second Pixel*/
			lY1 = lYuyvPtr[0];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src1 + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lCb = lYuyvPtr[lLumWidth + 3];
            lCr = lYuyvPtr[lLumWidth + 1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/
            lY1 = lYuyvPtr[lLumWidth + 2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*src2 = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Fourth Pixel*/
            lY1 = lYuyvPtr[lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lCb = lYuyvPtr[(lLumWidth << 1) + 3];
            lCr = lYuyvPtr[(lLumWidth << 1) + 1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*Fifth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1) + 2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Sixth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1)];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

			lYuyvPtr += 4;
			src1 += 6;
			src2 += 6;
		}

		src1 = lPtr1;
		src2 = lPtr2;

        for(j = 0; j < lWidth; j += 2)
        {
			/* First Pixel */
			*dest1 = (uint16) (*(src1 + 2) >> 4 |  (*(src1 + 1) >> 4) << 4 | (*src1 >> 4) << 8);
			diff1 = *src1 & 0xf;
			diff2 = *(src1 + 1) & 0xf;
			diff3 = *(src1 + 2) & 0xf;

			// diffuse the error
			sDiffuse(i,j,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			/* Second Pixel */
			*(dest1 + 1) = (uint16) (*(src1 + 5) >> 4 |  (*(src1 + 4) >> 4) << 4 | (*(src1 + 3) >> 4) << 8);
			diff1 = *(src1 + 3) & 0xf;
			diff2 = *(src1 + 4) & 0xf;
			diff3 = *(src1 + 5) & 0xf;
			// diffuse the error
			sDiffuse(i,j+1,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j+1,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j+1,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			src1  += 6;
			dest1 += 2;

			/* Third Pixel */			
			*dest2 = (uint16) (*(src2 + 2) >> 4 |  (*(src2 + 1) >> 4) << 4 | (*src2 >> 4) << 8);
			diff1 = *src2 & 0xf;
			diff2 = *(src2 + 1) & 0xf;
			diff3 = *(src2 + 2) & 0xf;
			//diffuse the error
			sDiffuse(i+1,j,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			/* Fourth Pixel */
			*(dest2 + 1) = (uint16) (*(src2 + 5) >> 4 |  (*(src2 + 4) >> 4) << 4 | (*(src2 + 3) >> 4) << 8);
			diff1 = *(src2 + 3) & 0xf;
			diff2 = *(src2 + 4) & 0xf;
			diff3 = *(src2 + 5) & 0xf;
			//diffuse the error
			sDiffuse(i+1,j+1,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j+1,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j+1,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			src2  += 6;
			dest2 += 2;			
        }
		if(extraCol)
		{
			*dest1 = dest1[-1];
			 dest1++;
			*dest2 = dest2[-1];
			 dest2++;
		}

		lYuyvPtr += ((lLumWidth - lWidth) << 1);

        dest1 += ((wndWidth << 1) - lTempWidth);
		dest2 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		dest2 = dest1 - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*dest1++ = *dest2++;
			*dest1++ = *dest2++;
		}
		if(extraCol)
		{
			*dest1 = *dest2;
		}
	}

	free(lBuffer);
	return;
}



















































/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr2toColor4k_ErrDiff_709_FR
Description		: Converts YUV420 Chroma2 Planar to XRGB (4:4:4:4) Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr2toColor4k_ErrDiff_709_FR 
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
	uint16 *dest1, *dest2;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
	uint8  *lBuffer;
	uint8  *src1, *src2;
	uint8  *lPtr1, *lPtr2;
    int32  lLumWidth, lWidth, lHeight, lTempWidth, lSrcWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
	int32  diff1, diff2, diff3;
    int32  i, j, k, extraRow, extraCol;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	lBuffer = (uint8*) malloc(lWidth * 3 * 3);

	lSrcWidth = lWidth * 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    dest1 = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    dest2 = dest1 + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
		lPtr1 = src1 = lBuffer;
		lPtr2 = src2 = src1 + lSrcWidth;

		for(k = 0; k < lWidth; k += 2)
		{
            lCr = lCrPtr[k >> 1];
            lCb = lCbPtr[k >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[k];

            lTemp = lY1 + lTemp1;
			*src1 = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Second Pixel*/
            lY1 = lLumPtr[k + 1];

            lTemp = lY1 + lTemp1;
			*(src1 + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));


            /*Third Pixel*/
            lY1 = lLumPtr[k + lLumWidth];

            lTemp = lY1 + lTemp1;
			*src2 = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Fourth Pixel*/
            lY1 = lLumPtr[k + lLumWidth + 1];

            lTemp = lY1 + lTemp1;
			*(src2 + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));


            lCr = lCrPtr[(k + lLumWidth) >> 1];
            lCb = lCbPtr[(k + lLumWidth) >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*Fifth Pixel*/
            lY1 = lLumPtr[k + (lLumWidth << 1)];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Sixth Pixel*/
            lY1 = lLumPtr[k + (lLumWidth << 1) + 1];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

			src1 += 6;
			src2 += 6;
		}

		src1 = lPtr1;
		src2 = lPtr2;

        for(j = 0; j < lWidth; j += 2)
        {
			/* First Pixel */
			*dest1 = (uint16) (*(src1 + 2) >> 4 |  (*(src1 + 1) >> 4) << 4 | (*src1 >> 4) << 8);
			diff1 = *src1 & 0xf;
			diff2 = *(src1 + 1) & 0xf;
			diff3 = *(src1 + 2) & 0xf;

			// diffuse the error
			sDiffuse(i,j,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			/* Second Pixel */
			*(dest1 + 1) = (uint16) (*(src1 + 5) >> 4 |  (*(src1 + 4) >> 4) << 4 | (*(src1 + 3) >> 4) << 8);
			diff1 = *(src1 + 3) & 0xf;
			diff2 = *(src1 + 4) & 0xf;
			diff3 = *(src1 + 5) & 0xf;
			// diffuse the error
			sDiffuse(i,j+1,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j+1,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j+1,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			src1  += 6;
			dest1 += 2;

			/* Third Pixel */			
			*dest2 = (uint16) (*(src2 + 2) >> 4 |  (*(src2 + 1) >> 4) << 4 | (*src2 >> 4) << 8);
			diff1 = *src2 & 0xf;
			diff2 = *(src2 + 1) & 0xf;
			diff3 = *(src2 + 2) & 0xf;
			//diffuse the error
			sDiffuse(i+1,j,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			/* Fourth Pixel */
			*(dest2 + 1) = (uint16) (*(src2 + 5) >> 4 |  (*(src2 + 4) >> 4) << 4 | (*(src2 + 3) >> 4) << 8);
			diff1 = *(src2 + 3) & 0xf;
			diff2 = *(src2 + 4) & 0xf;
			diff3 = *(src2 + 5) & 0xf;
			//diffuse the error
			sDiffuse(i+1,j+1,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j+1,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j+1,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			src2  += 6;
			dest2 += 2;			
        }
		if(extraCol)
		{
			*dest1 = dest1[-1];
			dest1++;
			*dest2 = dest2[-1];
			dest2++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr  += (lLumWidth >> 1);
        lCbPtr  += (lLumWidth >> 1);

        dest1 += ((wndWidth << 1) - lTempWidth);
		dest2 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		dest2 = dest1 - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*dest1++ = *dest2++;
			*dest1++ = *dest2++;
		}
		if(extraCol)
		{
			*dest1 = *dest2;
		}
	}

	free(lBuffer);
	return;
}


/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr2toColor4k_ErrDiff_601_5_FR
Description		: Converts YUV420 Chroma2 Planar to XRGB (4:4:4:4) Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr2toColor4k_ErrDiff_601_5_FR 
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
	uint16 *dest1, *dest2;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
	uint8  *lBuffer;
	uint8  *src1, *src2;
	uint8  *lPtr1, *lPtr2;
    int32  lLumWidth, lWidth, lHeight, lTempWidth, lSrcWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
	int32  diff1, diff2, diff3;
    int32  i, j, k, extraRow, extraCol;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	lBuffer = (uint8*) malloc(lWidth * 3 * 3);

	lSrcWidth = lWidth * 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    dest1 = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    dest2 = dest1 + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
		lPtr1 = src1 = lBuffer;
		lPtr2 = src2 = src1 + lSrcWidth;

		for(k = 0; k < lWidth; k += 2)
		{
            lCr = lCrPtr[k >> 1];
            lCb = lCbPtr[k >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[k];

            lTemp = lY1 + lTemp1;
			*src1 = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Second Pixel*/
            lY1 = lLumPtr[k + 1];

            lTemp = lY1 + lTemp1;
			*(src1 + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));


            /*Third Pixel*/
            lY1 = lLumPtr[k + lLumWidth];

            lTemp = lY1 + lTemp1;
			*src2 = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Fourth Pixel*/
            lY1 = lLumPtr[k + lLumWidth + 1];

            lTemp = lY1 + lTemp1;
			*(src2 + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            
			lCr = lCrPtr[(k + lLumWidth) >> 1];
            lCb = lCbPtr[(k + lLumWidth) >> 1];
            
			lCr -= 128;
            lCb -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*Fifth Pixel*/
            lY1 = lLumPtr[k + (lLumWidth << 1)];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Sixth Pixel*/
            lY1 = lLumPtr[k + (lLumWidth << 1) + 1];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

			src1 += 6;
			src2 += 6;
		}

		src1 = lPtr1;
		src2 = lPtr2;

        for(j = 0; j < lWidth; j += 2)
        {
			/* First Pixel */
			*dest1 = (uint16) (*(src1 + 2) >> 4 |  (*(src1 + 1) >> 4) << 4 | (*src1 >> 4) << 8);
			diff1 = *src1 & 0xf;
			diff2 = *(src1 + 1) & 0xf;
			diff3 = *(src1 + 2) & 0xf;

			// diffuse the error
			sDiffuse(i,j,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			/* Second Pixel */
			*(dest1 + 1) = (uint16) (*(src1 + 5) >> 4 |  (*(src1 + 4) >> 4) << 4 | (*(src1 + 3) >> 4) << 8);
			diff1 = *(src1 + 3) & 0xf;
			diff2 = *(src1 + 4) & 0xf;
			diff3 = *(src1 + 5) & 0xf;
			// diffuse the error
			sDiffuse(i,j+1,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j+1,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j+1,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			src1  += 6;
			dest1 += 2;

			/* Third Pixel */			
			*dest2 = (uint16) (*(src2 + 2) >> 4 |  (*(src2 + 1) >> 4) << 4 | (*src2 >> 4) << 8);
			diff1 = *src2 & 0xf;
			diff2 = *(src2 + 1) & 0xf;
			diff3 = *(src2 + 2) & 0xf;
			//diffuse the error
			sDiffuse(i+1,j,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			/* Fourth Pixel */
			*(dest2 + 1) = (uint16) (*(src2 + 5) >> 4 |  (*(src2 + 4) >> 4) << 4 | (*(src2 + 3) >> 4) << 8);
			diff1 = *(src2 + 3) & 0xf;
			diff2 = *(src2 + 4) & 0xf;
			diff3 = *(src2 + 5) & 0xf;
			//diffuse the error
			sDiffuse(i+1,j+1,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j+1,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j+1,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			src2  += 6;
			dest2 += 2;			
        }
		if(extraCol)
		{
			*dest1 = dest1[-1];
			dest1++;
			*dest2 = dest2[-1];
			dest2++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr  += (lLumWidth >> 1);
        lCbPtr  += (lLumWidth >> 1);

        dest1 += ((wndWidth << 1) - lTempWidth);
		dest2 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		dest2 = dest1 - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*dest1++ = *dest2++;
			*dest1++ = *dest2++;
		}
		if(extraCol)
		{
			*dest1 = *dest2;
		}
	}

	free(lBuffer);
	return;
}


/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr2toColor4k_ErrDiff_709_RR
Description		: Converts YUV420 Chroma2 Planar to XRGB (4:4:4:4) Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr2toColor4k_ErrDiff_709_RR 
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
	uint16 *dest1, *dest2;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
	uint8  *lBuffer;
	uint8  *src1, *src2;
	uint8  *lPtr1, *lPtr2;
    int32  lLumWidth, lWidth, lHeight, lTempWidth, lSrcWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
	int32  diff1, diff2, diff3;
    int32  i, j, k, extraRow, extraCol;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	lBuffer = (uint8*) malloc(lWidth * 3 * 3);

	lSrcWidth = lWidth * 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    dest1 = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    dest2 = dest1 + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
		lPtr1 = src1 = lBuffer;
		lPtr2 = src2 = src1 + lSrcWidth;

		for(k = 0; k < lWidth; k += 2)
		{
            lCr = lCrPtr[k >> 1];
            lCb = lCbPtr[k >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[k];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*src1 = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Second Pixel*/
            lY1 = lLumPtr[k + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src1 + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));


            /*Third Pixel*/
            lY1 = lLumPtr[k + lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*src2 = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Fourth Pixel*/
            lY1 = lLumPtr[k + lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));


            lCr = lCrPtr[(k + lLumWidth) >> 1];
            lCb = lCbPtr[(k + lLumWidth) >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*Fifth Pixel*/
            lY1 = lLumPtr[k + (lLumWidth << 1)];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Sixth Pixel*/
            lY1 = lLumPtr[k + (lLumWidth << 1) + 1];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

			src1 += 6;
			src2 += 6;
		}

		src1 = lPtr1;
		src2 = lPtr2;

        for(j = 0; j < lWidth; j += 2)
        {
			/* First Pixel */
			*dest1 = (uint16) (*(src1 + 2) >> 4 |  (*(src1 + 1) >> 4) << 4 | (*src1 >> 4) << 8);
			diff1 = *src1 & 0xf;
			diff2 = *(src1 + 1) & 0xf;
			diff3 = *(src1 + 2) & 0xf;

			// diffuse the error
			sDiffuse(i,j,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			/* Second Pixel */
			*(dest1 + 1) = (uint16) (*(src1 + 5) >> 4 |  (*(src1 + 4) >> 4) << 4 | (*(src1 + 3) >> 4) << 8);
			diff1 = *(src1 + 3) & 0xf;
			diff2 = *(src1 + 4) & 0xf;
			diff3 = *(src1 + 5) & 0xf;
			// diffuse the error
			sDiffuse(i,j+1,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j+1,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j+1,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			src1  += 6;
			dest1 += 2;

			/* Third Pixel */			
			*dest2 = (uint16) (*(src2 + 2) >> 4 |  (*(src2 + 1) >> 4) << 4 | (*src2 >> 4) << 8);
			diff1 = *src2 & 0xf;
			diff2 = *(src2 + 1) & 0xf;
			diff3 = *(src2 + 2) & 0xf;
			//diffuse the error
			sDiffuse(i+1,j,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			/* Fourth Pixel */
			*(dest2 + 1) = (uint16) (*(src2 + 5) >> 4 |  (*(src2 + 4) >> 4) << 4 | (*(src2 + 3) >> 4) << 8);
			diff1 = *(src2 + 3) & 0xf;
			diff2 = *(src2 + 4) & 0xf;
			diff3 = *(src2 + 5) & 0xf;
			//diffuse the error
			sDiffuse(i+1,j+1,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j+1,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j+1,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			src2  += 6;
			dest2 += 2;			
        }
		if(extraCol)
		{
			*dest1 = dest1[-1];
			dest1++;
			*dest2 = dest2[-1];
			dest2++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr  += (lLumWidth >> 1);
        lCbPtr  += (lLumWidth >> 1);

        dest1 += ((wndWidth << 1) - lTempWidth);
		dest2 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		dest2 = dest1 - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*dest1++ = *dest2++;
			*dest1++ = *dest2++;
		}
		if(extraCol)
		{
			*dest1 = *dest2;
		}
	}

	free(lBuffer);
	return;
}


/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr2toColor4k_ErrDiff_601_5_RR
Description		: Converts YUV420 Chroma2 Planar to XRGB (4:4:4:4) Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr2toColor4k_ErrDiff_601_5_RR 
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
	uint16 *dest1, *dest2;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
	uint8  *lBuffer;
	uint8  *src1, *src2;
	uint8  *lPtr1, *lPtr2;
    int32  lLumWidth, lWidth, lHeight, lTempWidth, lSrcWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
	int32  diff1, diff2, diff3;
    int32  i, j, k, extraRow, extraCol;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	lBuffer = (uint8*) malloc(lWidth * 3 * 3);

	lSrcWidth = lWidth * 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    dest1 = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    dest2 = dest1 + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
		lPtr1 = src1 = lBuffer;
		lPtr2 = src2 = src1 + lSrcWidth;

		for(k = 0; k < lWidth; k += 2)
		{
            lCr = lCrPtr[k >> 1];
            lCb = lCbPtr[k >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[k];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*src1 = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Second Pixel*/
            lY1 = lLumPtr[k + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src1 + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));


            /*Third Pixel*/
            lY1 = lLumPtr[k + lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*src2 = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Fourth Pixel*/
            lY1 = lLumPtr[k + lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));


            lCr = lCrPtr[(k + lLumWidth) >> 1];
            lCb = lCbPtr[(k + lLumWidth) >> 1];

            lCr -= 128;
            lCb -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*Fifth Pixel*/
            lY1 = lLumPtr[k + (lLumWidth << 1)];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Sixth Pixel*/
            lY1 = lLumPtr[k + (lLumWidth << 1) + 1];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

			src1 += 6;
			src2 += 6;
		}

		src1 = lPtr1;
		src2 = lPtr2;

        for(j = 0; j < lWidth; j += 2)
        {
			/* First Pixel */
			*dest1 = (uint16) (*(src1 + 2) >> 4 |  (*(src1 + 1) >> 4) << 4 | (*src1 >> 4) << 8);
			diff1 = *src1 & 0xf;
			diff2 = *(src1 + 1) & 0xf;
			diff3 = *(src1 + 2) & 0xf;

			// diffuse the error
			sDiffuse(i,j,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			/* Second Pixel */
			*(dest1 + 1) = (uint16) (*(src1 + 5) >> 4 |  (*(src1 + 4) >> 4) << 4 | (*(src1 + 3) >> 4) << 8);
			diff1 = *(src1 + 3) & 0xf;
			diff2 = *(src1 + 4) & 0xf;
			diff3 = *(src1 + 5) & 0xf;
			// diffuse the error
			sDiffuse(i,j+1,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j+1,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j+1,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			src1  += 6;
			dest1 += 2;

			/* Third Pixel */			
			*dest2 = (uint16) (*(src2 + 2) >> 4 |  (*(src2 + 1) >> 4) << 4 | (*src2 >> 4) << 8);
			diff1 = *src2 & 0xf;
			diff2 = *(src2 + 1) & 0xf;
			diff3 = *(src2 + 2) & 0xf;
			//diffuse the error
			sDiffuse(i+1,j,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			/* Fourth Pixel */
			*(dest2 + 1) = (uint16) (*(src2 + 5) >> 4 |  (*(src2 + 4) >> 4) << 4 | (*(src2 + 3) >> 4) << 8);
			diff1 = *(src2 + 3) & 0xf;
			diff2 = *(src2 + 4) & 0xf;
			diff3 = *(src2 + 5) & 0xf;
			//diffuse the error
			sDiffuse(i+1,j+1,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j+1,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j+1,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			src2  += 6;
			dest2 += 2;			
        }
		if(extraCol)
		{
			*dest1 = dest1[-1];
			dest1++;
			*dest2 = dest2[-1];
			dest2++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr  += (lLumWidth >> 1);
        lCbPtr  += (lLumWidth >> 1);

        dest1 += ((wndWidth << 1) - lTempWidth);
		dest2 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		dest2 = dest1 - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*dest1++ = *dest2++;
			*dest1++ = *dest2++;
		}
		if(extraCol)
		{
			*dest1 = *dest2;
		}
	}

	free(lBuffer);
	return;
}


/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr2toColor4k_ErrDiff_709_FR
Description		: Converts YUV422 BE (UYVY) Chroma2 Interleaved to XRGB (4:4:4:4) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr2toColor4k_ErrDiff_709_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *dest1, *dest2;
    uint8  *lYuyvPtr;
	uint8  *lBuffer;
	uint8  *src1, *src2;
	uint8  *lPtr1, *lPtr2;
	int32  diff1, diff2, diff3;
    int32  lLumWidth, lWidth, lHeight, lTempWidth, lSrcWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, k, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	lBuffer = (uint8*) malloc(lWidth * 3 * 3);

	lSrcWidth = lWidth * 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    dest1 = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    dest2 = dest1 + wndWidth;

   	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
		lPtr1 = src1 = lBuffer;
		lPtr2 = src2 = src1 + lSrcWidth;

		for(k = 0; k < lWidth; k += 2)
		{
            lCb = lYuyvPtr[0];
            lCr = lYuyvPtr[2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];

            lTemp = lY1 + lTemp1;
			*src1 = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Second Pixel*/
			lY1 = lYuyvPtr[3];

            lTemp = lY1 + lTemp1;
			*(src1 + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lCb = lYuyvPtr[lLumWidth];
            lCr = lYuyvPtr[lLumWidth + 2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/
            lY1 = lYuyvPtr[lLumWidth + 1];

            lTemp = lY1 + lTemp1;
			*src2 = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Fourth Pixel*/
            lY1 = lYuyvPtr[lLumWidth + 3];

            lTemp = lY1 + lTemp1;
			*(src2 + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lCb = lYuyvPtr[(lLumWidth << 1)];
            lCr = lYuyvPtr[(lLumWidth << 1) + 2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*Fifth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1) + 1];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Sixth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1) + 3];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

			lYuyvPtr += 4;
			src1 += 6;
			src2 += 6;
		}

		src1 = lPtr1;
		src2 = lPtr2;

        for(j = 0; j < lWidth; j += 2)
        {
			/* First Pixel */
			*dest1 = (uint16) (*(src1 + 2) >> 4 |  (*(src1 + 1) >> 4) << 4 | (*src1 >> 4) << 8);
			diff1 = *src1 & 0xf;
			diff2 = *(src1 + 1) & 0xf;
			diff3 = *(src1 + 2) & 0xf;

			// diffuse the error
			sDiffuse(i,j,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			/* Second Pixel */
			*(dest1 + 1) = (uint16) (*(src1 + 5) >> 4 |  (*(src1 + 4) >> 4) << 4 | (*(src1 + 3) >> 4) << 8);
			diff1 = *(src1 + 3) & 0xf;
			diff2 = *(src1 + 4) & 0xf;
			diff3 = *(src1 + 5) & 0xf;
			// diffuse the error
			sDiffuse(i,j+1,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j+1,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j+1,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			src1  += 6;
			dest1 += 2;

			/* Third Pixel */			
			*dest2 = (uint16) (*(src2 + 2) >> 4 |  (*(src2 + 1) >> 4) << 4 | (*src2 >> 4) << 8);
			diff1 = *src2 & 0xf;
			diff2 = *(src2 + 1) & 0xf;
			diff3 = *(src2 + 2) & 0xf;
			//diffuse the error
			sDiffuse(i+1,j,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			/* Fourth Pixel */
			*(dest2 + 1) = (uint16) (*(src2 + 5) >> 4 |  (*(src2 + 4) >> 4) << 4 | (*(src2 + 3) >> 4) << 8);
			diff1 = *(src2 + 3) & 0xf;
			diff2 = *(src2 + 4) & 0xf;
			diff3 = *(src2 + 5) & 0xf;
			//diffuse the error
			sDiffuse(i+1,j+1,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j+1,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j+1,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			src2  += 6;
			dest2 += 2;			
        }
		if(extraCol)
		{
			*dest1 = dest1[-1];
			 dest1++;
			*dest2 = dest2[-1];
			 dest2++;
		}

		lYuyvPtr += ((lLumWidth - lWidth) << 1);

        dest1 += ((wndWidth << 1) - lTempWidth);
		dest2 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		dest2 = dest1 - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*dest1++ = *dest2++;
			*dest1++ = *dest2++;
		}
		if(extraCol)
		{
			*dest1 = *dest2;
		}
	}

	free(lBuffer);
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr2toColor4k_ErrDiff_601_5_FR
Description		: Converts YUV422 BE (UYVY) Chroma2 Interleaved to XRGB (4:4:4:4) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr2toColor4k_ErrDiff_601_5_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *dest1, *dest2;
    uint8  *lYuyvPtr;
	uint8  *lBuffer;
	uint8  *src1, *src2;
	uint8  *lPtr1, *lPtr2;
	int32  diff1, diff2, diff3;
    int32  lLumWidth, lWidth, lHeight, lTempWidth, lSrcWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, k, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	lBuffer = (uint8*) malloc(lWidth * 3 * 3);

	lSrcWidth = lWidth * 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    dest1 = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    dest2 = dest1 + wndWidth;

   	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
		lPtr1 = src1 = lBuffer;
		lPtr2 = src2 = src1 + lSrcWidth;

		for(k = 0; k < lWidth; k += 2)
		{
            lCb = lYuyvPtr[0];
            lCr = lYuyvPtr[2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];

            lTemp = lY1 + lTemp1;
			*src1 = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Second Pixel*/
			lY1 = lYuyvPtr[3];

            lTemp = lY1 + lTemp1;
			*(src1 + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lCb = lYuyvPtr[lLumWidth];
            lCr = lYuyvPtr[lLumWidth + 2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/
            lY1 = lYuyvPtr[lLumWidth + 1];

            lTemp = lY1 + lTemp1;
			*src2 = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Fourth Pixel*/
            lY1 = lYuyvPtr[lLumWidth + 3];

            lTemp = lY1 + lTemp1;
			*(src2 + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lCb = lYuyvPtr[(lLumWidth << 1)];
            lCr = lYuyvPtr[(lLumWidth << 1) + 2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*Fifth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1) + 1];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Sixth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1) + 3];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

			lYuyvPtr += 4;
			src1 += 6;
			src2 += 6;
		}

		src1 = lPtr1;
		src2 = lPtr2;

        for(j = 0; j < lWidth; j += 2)
        {
			/* First Pixel */
			*dest1 = (uint16) (*(src1 + 2) >> 4 |  (*(src1 + 1) >> 4) << 4 | (*src1 >> 4) << 8);
			diff1 = *src1 & 0xf;
			diff2 = *(src1 + 1) & 0xf;
			diff3 = *(src1 + 2) & 0xf;

			// diffuse the error
			sDiffuse(i,j,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			/* Second Pixel */
			*(dest1 + 1) = (uint16) (*(src1 + 5) >> 4 |  (*(src1 + 4) >> 4) << 4 | (*(src1 + 3) >> 4) << 8);
			diff1 = *(src1 + 3) & 0xf;
			diff2 = *(src1 + 4) & 0xf;
			diff3 = *(src1 + 5) & 0xf;
			// diffuse the error
			sDiffuse(i,j+1,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j+1,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j+1,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			src1  += 6;
			dest1 += 2;

			/* Third Pixel */			
			*dest2 = (uint16) (*(src2 + 2) >> 4 |  (*(src2 + 1) >> 4) << 4 | (*src2 >> 4) << 8);
			diff1 = *src2 & 0xf;
			diff2 = *(src2 + 1) & 0xf;
			diff3 = *(src2 + 2) & 0xf;
			//diffuse the error
			sDiffuse(i+1,j,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			/* Fourth Pixel */
			*(dest2 + 1) = (uint16) (*(src2 + 5) >> 4 |  (*(src2 + 4) >> 4) << 4 | (*(src2 + 3) >> 4) << 8);
			diff1 = *(src2 + 3) & 0xf;
			diff2 = *(src2 + 4) & 0xf;
			diff3 = *(src2 + 5) & 0xf;
			//diffuse the error
			sDiffuse(i+1,j+1,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j+1,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j+1,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			src2  += 6;
			dest2 += 2;			
        }
		if(extraCol)
		{
			*dest1 = dest1[-1];
			 dest1++;
			*dest2 = dest2[-1];
			 dest2++;
		}

		lYuyvPtr += ((lLumWidth - lWidth) << 1);

        dest1 += ((wndWidth << 1) - lTempWidth);
		dest2 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		dest2 = dest1 - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*dest1++ = *dest2++;
			*dest1++ = *dest2++;
		}
		if(extraCol)
		{
			*dest1 = *dest2;
		}
	}

	free(lBuffer);
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr2toColor4k_ErrDiff_709_RR
Description		: Converts YUV422 BE (UYVY) Chroma2 Interleaved to XRGB (4:4:4:4) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr2toColor4k_ErrDiff_709_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *dest1, *dest2;
    uint8  *lYuyvPtr;
	uint8  *lBuffer;
	uint8  *src1, *src2;
	uint8  *lPtr1, *lPtr2;
	int32  diff1, diff2, diff3;
    int32  lLumWidth, lWidth, lHeight, lTempWidth, lSrcWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, k, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	lBuffer = (uint8*) malloc(lWidth * 3 * 3);

	lSrcWidth = lWidth * 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    dest1 = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    dest2 = dest1 + wndWidth;

   	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
		lPtr1 = src1 = lBuffer;
		lPtr2 = src2 = src1 + lSrcWidth;

		for(k = 0; k < lWidth; k += 2)
		{
            lCb = lYuyvPtr[0];
            lCr = lYuyvPtr[2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*src1 = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Second Pixel*/
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src1 + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lCb = lYuyvPtr[lLumWidth];
            lCr = lYuyvPtr[lLumWidth + 2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/
            lY1 = lYuyvPtr[lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*src2 = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Fourth Pixel*/
            lY1 = lYuyvPtr[lLumWidth + 3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lCb = lYuyvPtr[(lLumWidth << 1)];
            lCr = lYuyvPtr[(lLumWidth << 1) + 2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*Fifth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1) + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Sixth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1) + 3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

			lYuyvPtr += 4;
			src1 += 6;
			src2 += 6;
		}

		src1 = lPtr1;
		src2 = lPtr2;

        for(j = 0; j < lWidth; j += 2)
        {
			/* First Pixel */
			*dest1 = (uint16) (*(src1 + 2) >> 4 |  (*(src1 + 1) >> 4) << 4 | (*src1 >> 4) << 8);
			diff1 = *src1 & 0xf;
			diff2 = *(src1 + 1) & 0xf;
			diff3 = *(src1 + 2) & 0xf;

			// diffuse the error
			sDiffuse(i,j,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			/* Second Pixel */
			*(dest1 + 1) = (uint16) (*(src1 + 5) >> 4 |  (*(src1 + 4) >> 4) << 4 | (*(src1 + 3) >> 4) << 8);
			diff1 = *(src1 + 3) & 0xf;
			diff2 = *(src1 + 4) & 0xf;
			diff3 = *(src1 + 5) & 0xf;
			// diffuse the error
			sDiffuse(i,j+1,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j+1,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j+1,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			src1  += 6;
			dest1 += 2;

			/* Third Pixel */			
			*dest2 = (uint16) (*(src2 + 2) >> 4 |  (*(src2 + 1) >> 4) << 4 | (*src2 >> 4) << 8);
			diff1 = *src2 & 0xf;
			diff2 = *(src2 + 1) & 0xf;
			diff3 = *(src2 + 2) & 0xf;
			//diffuse the error
			sDiffuse(i+1,j,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			/* Fourth Pixel */
			*(dest2 + 1) = (uint16) (*(src2 + 5) >> 4 |  (*(src2 + 4) >> 4) << 4 | (*(src2 + 3) >> 4) << 8);
			diff1 = *(src2 + 3) & 0xf;
			diff2 = *(src2 + 4) & 0xf;
			diff3 = *(src2 + 5) & 0xf;
			//diffuse the error
			sDiffuse(i+1,j+1,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j+1,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j+1,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			src2  += 6;
			dest2 += 2;			
        }
		if(extraCol)
		{
			*dest1 = dest1[-1];
			 dest1++;
			*dest2 = dest2[-1];
			 dest2++;
		}

		lYuyvPtr += ((lLumWidth - lWidth) << 1);

        dest1 += ((wndWidth << 1) - lTempWidth);
		dest2 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		dest2 = dest1 - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*dest1++ = *dest2++;
			*dest1++ = *dest2++;
		}
		if(extraCol)
		{
			*dest1 = *dest2;
		}
	}

	free(lBuffer);
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr2toColor4k_ErrDiff_601_5_RR
Description		: Converts YUV422 BE (UYVY) Chroma2 Interleaved to XRGB (4:4:4:4) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr2toColor4k_ErrDiff_601_5_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *dest1, *dest2;
    uint8  *lYuyvPtr;
	uint8  *lBuffer;
	uint8  *src1, *src2;
	uint8  *lPtr1, *lPtr2;
	int32  diff1, diff2, diff3;
    int32  lLumWidth, lWidth, lHeight, lTempWidth, lSrcWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, k, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	lBuffer = (uint8*) malloc(lWidth * 3 * 3);

	lSrcWidth = lWidth * 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    dest1 = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    dest2 = dest1 + wndWidth;

   	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
		lPtr1 = src1 = lBuffer;
		lPtr2 = src2 = src1 + lSrcWidth;

		for(k = 0; k < lWidth; k += 2)
		{
            lCb = lYuyvPtr[0];
            lCr = lYuyvPtr[2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*src1 = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Second Pixel*/
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src1 + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lCb = lYuyvPtr[lLumWidth];
            lCr = lYuyvPtr[lLumWidth + 2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/
            lY1 = lYuyvPtr[lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*src2 = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Fourth Pixel*/
            lY1 = lYuyvPtr[lLumWidth + 3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lCb = lYuyvPtr[(lLumWidth << 1)];
            lCr = lYuyvPtr[(lLumWidth << 1) + 2];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*Fifth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1) + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Sixth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1) + 3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

			lYuyvPtr += 4;
			src1 += 6;
			src2 += 6;
		}

		src1 = lPtr1;
		src2 = lPtr2;

        for(j = 0; j < lWidth; j += 2)
        {
			/* First Pixel */
			*dest1 = (uint16) (*(src1 + 2) >> 4 |  (*(src1 + 1) >> 4) << 4 | (*src1 >> 4) << 8);
			diff1 = *src1 & 0xf;
			diff2 = *(src1 + 1) & 0xf;
			diff3 = *(src1 + 2) & 0xf;

			// diffuse the error
			sDiffuse(i,j,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			/* Second Pixel */
			*(dest1 + 1) = (uint16) (*(src1 + 5) >> 4 |  (*(src1 + 4) >> 4) << 4 | (*(src1 + 3) >> 4) << 8);
			diff1 = *(src1 + 3) & 0xf;
			diff2 = *(src1 + 4) & 0xf;
			diff3 = *(src1 + 5) & 0xf;
			// diffuse the error
			sDiffuse(i,j+1,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j+1,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j+1,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			src1  += 6;
			dest1 += 2;

			/* Third Pixel */			
			*dest2 = (uint16) (*(src2 + 2) >> 4 |  (*(src2 + 1) >> 4) << 4 | (*src2 >> 4) << 8);
			diff1 = *src2 & 0xf;
			diff2 = *(src2 + 1) & 0xf;
			diff3 = *(src2 + 2) & 0xf;
			//diffuse the error
			sDiffuse(i+1,j,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			/* Fourth Pixel */
			*(dest2 + 1) = (uint16) (*(src2 + 5) >> 4 |  (*(src2 + 4) >> 4) << 4 | (*(src2 + 3) >> 4) << 8);
			diff1 = *(src2 + 3) & 0xf;
			diff2 = *(src2 + 4) & 0xf;
			diff3 = *(src2 + 5) & 0xf;
			//diffuse the error
			sDiffuse(i+1,j+1,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j+1,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j+1,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			src2  += 6;
			dest2 += 2;			
        }
		if(extraCol)
		{
			*dest1 = dest1[-1];
			 dest1++;
			*dest2 = dest2[-1];
			 dest2++;
		}

		lYuyvPtr += ((lLumWidth - lWidth) << 1);

        dest1 += ((wndWidth << 1) - lTempWidth);
		dest2 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		dest2 = dest1 - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*dest1++ = *dest2++;
			*dest1++ = *dest2++;
		}
		if(extraCol)
		{
			*dest1 = *dest2;
		}
	}

	free(lBuffer);
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr2toColor64k_ErrDiff_709_FR
Description		: Converts YUV422 LE (YVYU) Chroma2 Interleaved to RGB565 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr2toColor64k_ErrDiff_709_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *dest1, *dest2;
    uint8  *lYuyvPtr;
	uint8  *lBuffer;
	uint8  *src1, *src2;
	uint8  *lPtr1, *lPtr2;
	int32  diff1, diff2, diff3;
    int32  lLumWidth, lWidth, lHeight, lTempWidth, lSrcWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, k, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	lBuffer = (uint8*) malloc(lWidth * 3 * 3);

	lSrcWidth = lWidth * 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    dest1 = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    dest2 = dest1 + wndWidth;

   	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
		lPtr1 = src1 = lBuffer;
		lPtr2 = src2 = src1 + lSrcWidth;

		for(k = 0; k < lWidth; k += 2)
		{
            lCb = lYuyvPtr[3];
            lCr = lYuyvPtr[1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[2];

            lTemp = lY1 + lTemp1;
			*src1 = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Second Pixel*/
			lY1 = lYuyvPtr[0];

            lTemp = lY1 + lTemp1;
			*(src1 + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lCb = lYuyvPtr[lLumWidth + 3];
            lCr = lYuyvPtr[lLumWidth + 1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/
            lY1 = lYuyvPtr[lLumWidth + 2];

            lTemp = lY1 + lTemp1;
			*src2 = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Fourth Pixel*/
            lY1 = lYuyvPtr[lLumWidth];

            lTemp = lY1 + lTemp1;
			*(src2 + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lCb = lYuyvPtr[(lLumWidth << 1) + 3];
            lCr = lYuyvPtr[(lLumWidth << 1) + 1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (25801 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb) + (7670 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb) >> COLOR_CONV_PRECISION;

            /*Fifth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1) + 2];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Sixth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1)];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

			lYuyvPtr += 4;
			src1 += 6;
			src2 += 6;
		}

		src1 = lPtr1;
		src2 = lPtr2;

        for(j = 0; j < lWidth; j += 2)
        {
			/* First Pixel */
			*dest1 = (uint16) (*(src1 + 2) >> 3 |  (*(src1 + 1) >> 2) << 5 | (*src1 >> 3) << 11);
			diff1 = *src1 & 0x7;
			diff2 = *(src1 + 1) & 0x3;
			diff3 = *(src1 + 2) & 0x7;

			// diffuse the error
			sDiffuse(i,j,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			/* Second Pixel */
			*(dest1 + 1) = (uint16) (*(src1 + 5) >> 3 |  (*(src1 + 4) >> 2) << 5 | (*(src1 + 3) >> 3) << 11);
			diff1 = *(src1 + 3) & 0x7;
			diff2 = *(src1 + 4) & 0x3;
			diff3 = *(src1 + 5) & 0x7;
			// diffuse the error
			sDiffuse(i,j+1,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j+1,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j+1,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			src1  += 6;
			dest1 += 2;

			/* Third Pixel */			
			*dest2 = (uint16) (*(src2 + 2) >> 3 |  (*(src2 + 1) >> 2) << 5 | (*src2 >> 3) << 11);
			diff1 = *src2 & 0x7;
			diff2 = *(src2 + 1) & 0x3;
			diff3 = *(src2 + 2) & 0x7;
			//diffuse the error
			sDiffuse(i+1,j,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			/* Fourth Pixel */
			*(dest2 + 1) = (uint16) (*(src2 + 5) >> 3 |  (*(src2 + 4) >> 2) << 5 | (*(src2 + 3) >> 3) << 11);
			diff1 = *(src2 + 3) & 0x7;
			diff2 = *(src2 + 4) & 0x3;
			diff3 = *(src2 + 5) & 0x7;
			//diffuse the error
			sDiffuse(i+1,j+1,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j+1,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j+1,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			src2  += 6;
			dest2 += 2;			
        }
		if(extraCol)
		{
			*dest1 = dest1[-1];
			 dest1++;
			*dest2 = dest2[-1];
			 dest2++;
		}

		lYuyvPtr += ((lLumWidth - lWidth) << 1);

        dest1 += ((wndWidth << 1) - lTempWidth);
		dest2 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		dest2 = dest1 - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*dest1++ = *dest2++;
			*dest1++ = *dest2++;
		}
		if(extraCol)
		{
			*dest1 = *dest2;
		}
	}

	free(lBuffer);
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr2toColor64k_ErrDiff_601_5_FR
Description		: Converts YUV422 LE (YVYU) Chroma2 Interleaved to RGB565 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr2toColor64k_ErrDiff_601_5_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *dest1, *dest2;
    uint8  *lYuyvPtr;
	uint8  *lBuffer;
	uint8  *src1, *src2;
	uint8  *lPtr1, *lPtr2;
	int32  diff1, diff2, diff3;
    int32  lLumWidth, lWidth, lHeight, lTempWidth, lSrcWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, k, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	lBuffer = (uint8*) malloc(lWidth * 3 * 3);

	lSrcWidth = lWidth * 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    dest1 = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    dest2 = dest1 + wndWidth;

   	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
		lPtr1 = src1 = lBuffer;
		lPtr2 = src2 = src1 + lSrcWidth;

		for(k = 0; k < lWidth; k += 2)
		{
            lCb = lYuyvPtr[3];
            lCr = lYuyvPtr[1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[2];

            lTemp = lY1 + lTemp1;
			*src1 = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Second Pixel*/
			lY1 = lYuyvPtr[0];

            lTemp = lY1 + lTemp1;
			*(src1 + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lCb = lYuyvPtr[lLumWidth + 3];
            lCr = lYuyvPtr[lLumWidth + 1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/
            lY1 = lYuyvPtr[lLumWidth + 2];

            lTemp = lY1 + lTemp1;
			*src2 = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Fourth Pixel*/
            lY1 = lYuyvPtr[lLumWidth];

            lTemp = lY1 + lTemp1;
			*(src2 + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lCb = lYuyvPtr[(lLumWidth << 1) + 3];
            lCr = lYuyvPtr[(lLumWidth << 1) + 1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (22973 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb) + (11699 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb) >> COLOR_CONV_PRECISION;

            /*Fifth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1) + 2];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 1) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 2) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            /*Sixth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1)];

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth + 3) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 4) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 5) = (uint8)((lTemp > 255) ? 255 : ((lTemp < 0) ? 0 : lTemp));

			lYuyvPtr += 4;
			src1 += 6;
			src2 += 6;
		}

		src1 = lPtr1;
		src2 = lPtr2;

        for(j = 0; j < lWidth; j += 2)
        {
			/* First Pixel */
			*dest1 = (uint16) (*(src1 + 2) >> 3 |  (*(src1 + 1) >> 2) << 5 | (*src1 >> 3) << 11);
			diff1 = *src1 & 0x7;
			diff2 = *(src1 + 1) & 0x3;
			diff3 = *(src1 + 2) & 0x7;

			// diffuse the error
			sDiffuse(i,j,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			/* Second Pixel */
			*(dest1 + 1) = (uint16) (*(src1 + 5) >> 3 |  (*(src1 + 4) >> 2) << 5 | (*(src1 + 3) >> 3) << 11);
			diff1 = *(src1 + 3) & 0x7;
			diff2 = *(src1 + 4) & 0x3;
			diff3 = *(src1 + 5) & 0x7;
			// diffuse the error
			sDiffuse(i,j+1,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j+1,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j+1,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			src1  += 6;
			dest1 += 2;

			/* Third Pixel */			
			*dest2 = (uint16) (*(src2 + 2) >> 3 |  (*(src2 + 1) >> 2) << 5 | (*src2 >> 3) << 11);
			diff1 = *src2 & 0x7;
			diff2 = *(src2 + 1) & 0x3;
			diff3 = *(src2 + 2) & 0x7;
			//diffuse the error
			sDiffuse(i+1,j,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			/* Fourth Pixel */
			*(dest2 + 1) = (uint16) (*(src2 + 5) >> 3 |  (*(src2 + 4) >> 2) << 5 | (*(src2 + 3) >> 3) << 11);
			diff1 = *(src2 + 3) & 0x7;
			diff2 = *(src2 + 4) & 0x3;
			diff3 = *(src2 + 5) & 0x7;
			//diffuse the error
			sDiffuse(i+1,j+1,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j+1,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j+1,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			src2  += 6;
			dest2 += 2;			
        }
		if(extraCol)
		{
			*dest1 = dest1[-1];
			 dest1++;
			*dest2 = dest2[-1];
			 dest2++;
		}

		lYuyvPtr += ((lLumWidth - lWidth) << 1);

        dest1 += ((wndWidth << 1) - lTempWidth);
		dest2 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		dest2 = dest1 - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*dest1++ = *dest2++;
			*dest1++ = *dest2++;
		}
		if(extraCol)
		{
			*dest1 = *dest2;
		}
	}

	free(lBuffer);
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr2toColor64k_ErrDiff_709_RR
Description		: Converts YUV422 LE (YVYU) Chroma2 Interleaved to RGB565 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr2toColor64k_ErrDiff_709_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *dest1, *dest2;
    uint8  *lYuyvPtr;
	uint8  *lBuffer;
	uint8  *src1, *src2;
	uint8  *lPtr1, *lPtr2;
	int32  diff1, diff2, diff3;
    int32  lLumWidth, lWidth, lHeight, lTempWidth, lSrcWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, k, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	lBuffer = (uint8*) malloc(lWidth * 3 * 3);

	lSrcWidth = lWidth * 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    dest1 = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    dest2 = dest1 + wndWidth;

   	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
		lPtr1 = src1 = lBuffer;
		lPtr2 = src2 = src1 + lSrcWidth;

		for(k = 0; k < lWidth; k += 2)
		{
            lCb = lYuyvPtr[3];
            lCr = lYuyvPtr[1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*src1 = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Second Pixel*/
			lY1 = lYuyvPtr[0];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src1 + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lCb = lYuyvPtr[lLumWidth + 3];
            lCr = lYuyvPtr[lLumWidth + 1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/
            lY1 = lYuyvPtr[lLumWidth + 2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*src2 = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Fourth Pixel*/
            lY1 = lYuyvPtr[lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lCb = lYuyvPtr[(lLumWidth << 1) + 3];
            lCr = lYuyvPtr[(lLumWidth << 1) + 1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (29374 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb) + (8731 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb) >> COLOR_CONV_PRECISION;

            /*Fifth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1) + 2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Sixth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1)];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

			lYuyvPtr += 4;
			src1 += 6;
			src2 += 6;
		}

		src1 = lPtr1;
		src2 = lPtr2;

        for(j = 0; j < lWidth; j += 2)
        {
			/* First Pixel */
			*dest1 = (uint16) (*(src1 + 2) >> 3 |  (*(src1 + 1) >> 2) << 5 | (*src1 >> 3) << 11);
			diff1 = *src1 & 0x7;
			diff2 = *(src1 + 1) & 0x3;
			diff3 = *(src1 + 2) & 0x7;

			// diffuse the error
			sDiffuse(i,j,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			/* Second Pixel */
			*(dest1 + 1) = (uint16) (*(src1 + 5) >> 3 |  (*(src1 + 4) >> 2) << 5 | (*(src1 + 3) >> 3) << 11);
			diff1 = *(src1 + 3) & 0x7;
			diff2 = *(src1 + 4) & 0x3;
			diff3 = *(src1 + 5) & 0x7;
			// diffuse the error
			sDiffuse(i,j+1,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j+1,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j+1,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			src1  += 6;
			dest1 += 2;

			/* Third Pixel */			
			*dest2 = (uint16) (*(src2 + 2) >> 3 |  (*(src2 + 1) >> 2) << 5 | (*src2 >> 3) << 11);
			diff1 = *src2 & 0x7;
			diff2 = *(src2 + 1) & 0x3;
			diff3 = *(src2 + 2) & 0x7;
			//diffuse the error
			sDiffuse(i+1,j,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			/* Fourth Pixel */
			*(dest2 + 1) = (uint16) (*(src2 + 5) >> 3 |  (*(src2 + 4) >> 2) << 5 | (*(src2 + 3) >> 3) << 11);
			diff1 = *(src2 + 3) & 0x7;
			diff2 = *(src2 + 4) & 0x3;
			diff3 = *(src2 + 5) & 0x7;
			//diffuse the error
			sDiffuse(i+1,j+1,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j+1,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j+1,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			src2  += 6;
			dest2 += 2;			
        }
		if(extraCol)
		{
			*dest1 = dest1[-1];
			 dest1++;
			*dest2 = dest2[-1];
			 dest2++;
		}

		lYuyvPtr += ((lLumWidth - lWidth) << 1);

        dest1 += ((wndWidth << 1) - lTempWidth);
		dest2 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		dest2 = dest1 - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*dest1++ = *dest2++;
			*dest1++ = *dest2++;
		}
		if(extraCol)
		{
			*dest1 = *dest2;
		}
	}

	free(lBuffer);
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr2toColor64k_ErrDiff_601_5_RR
Description		: Converts YUV422 LE (YVYU) Chroma2 Interleaved to RGB565 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr2toColor64k_ErrDiff_601_5_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *dest1, *dest2;
    uint8  *lYuyvPtr;
	uint8  *lBuffer;
	uint8  *src1, *src2;
	uint8  *lPtr1, *lPtr2;
	int32  diff1, diff2, diff3;
    int32  lLumWidth, lWidth, lHeight, lTempWidth, lSrcWidth;
    int32  lY1, lCr, lCb;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, k, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	lBuffer = (uint8*) malloc(lWidth * 3 * 3);

	lSrcWidth = lWidth * 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    dest1 = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    dest2 = dest1 + wndWidth;

   	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
		lPtr1 = src1 = lBuffer;
		lPtr2 = src2 = src1 + lSrcWidth;

		for(k = 0; k < lWidth; k += 2)
		{
            lCb = lYuyvPtr[3];
            lCr = lYuyvPtr[1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*src1 = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Second Pixel*/
			lY1 = lYuyvPtr[0];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src1 + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src1 + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src1 + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lCb = lYuyvPtr[lLumWidth + 3];
            lCr = lYuyvPtr[lLumWidth + 1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*Third Pixel*/
            lY1 = lYuyvPtr[lLumWidth + 2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*src2 = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Fourth Pixel*/
            lY1 = lYuyvPtr[lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lCb = lYuyvPtr[(lLumWidth << 1) + 3];
            lCr = lYuyvPtr[(lLumWidth << 1) + 1];

            lCb -= 128;
            lCr -= 128;

            lTemp1 = (26748 * lCr) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb) + (13621 * lCr)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb) >> COLOR_CONV_PRECISION;

            /*Fifth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1) + 2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 1) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 2) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            /*Sixth Pixel*/
            lY1 = lYuyvPtr[(lLumWidth << 1)];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            lTemp = lY1 + lTemp1;
			*(src2 + lSrcWidth + 3) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 - lTemp2;
            *(src2 + lSrcWidth + 4) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

            lTemp = lY1 + lTemp3;
			*(src2 + lSrcWidth + 5) = (uint8)((lTemp > 235) ? 235 : ((lTemp < 16) ? 16 : lTemp));

			lYuyvPtr += 4;
			src1 += 6;
			src2 += 6;
		}

		src1 = lPtr1;
		src2 = lPtr2;

        for(j = 0; j < lWidth; j += 2)
        {
			/* First Pixel */
			*dest1 = (uint16) (*(src1 + 2) >> 3 |  (*(src1 + 1) >> 2) << 5 | (*src1 >> 3) << 11);
			diff1 = *src1 & 0x7;
			diff2 = *(src1 + 1) & 0x3;
			diff3 = *(src1 + 2) & 0x7;

			// diffuse the error
			sDiffuse(i,j,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			/* Second Pixel */
			*(dest1 + 1) = (uint16) (*(src1 + 5) >> 3 |  (*(src1 + 4) >> 2) << 5 | (*(src1 + 3) >> 3) << 11);
			diff1 = *(src1 + 3) & 0x7;
			diff2 = *(src1 + 4) & 0x3;
			diff3 = *(src1 + 5) & 0x7;
			// diffuse the error
			sDiffuse(i,j+1,diff1,lWidth,lHeight,lPtr1,lSrcWidth, 3);     //r
			sDiffuse(i,j+1,diff2,lWidth,lHeight,lPtr1 + 1,lSrcWidth, 3); //g
			sDiffuse(i,j+1,diff3,lWidth,lHeight,lPtr1 + 2,lSrcWidth, 3); //b

			src1  += 6;
			dest1 += 2;

			/* Third Pixel */			
			*dest2 = (uint16) (*(src2 + 2) >> 3 |  (*(src2 + 1) >> 2) << 5 | (*src2 >> 3) << 11);
			diff1 = *src2 & 0x7;
			diff2 = *(src2 + 1) & 0x3;
			diff3 = *(src2 + 2) & 0x7;
			//diffuse the error
			sDiffuse(i+1,j,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			/* Fourth Pixel */
			*(dest2 + 1) = (uint16) (*(src2 + 5) >> 3 |  (*(src2 + 4) >> 2) << 5 | (*(src2 + 3) >> 3) << 11);
			diff1 = *(src2 + 3) & 0x7;
			diff2 = *(src2 + 4) & 0x3;
			diff3 = *(src2 + 5) & 0x7;
			//diffuse the error
			sDiffuse(i+1,j+1,diff1,lWidth,lHeight,lPtr2,lSrcWidth, 3);     //r
			sDiffuse(i+1,j+1,diff2,lWidth,lHeight,lPtr2 + 1,lSrcWidth, 3); //g
			sDiffuse(i+1,j+1,diff3,lWidth,lHeight,lPtr2 + 2,lSrcWidth, 3); //b

			src2  += 6;
			dest2 += 2;			
        }
		if(extraCol)
		{
			*dest1 = dest1[-1];
			 dest1++;
			*dest2 = dest2[-1];
			 dest2++;
		}

		lYuyvPtr += ((lLumWidth - lWidth) << 1);

        dest1 += ((wndWidth << 1) - lTempWidth);
		dest2 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		dest2 = dest1 - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*dest1++ = *dest2++;
			*dest1++ = *dest2++;
		}
		if(extraCol)
		{
			*dest1 = *dest2;
		}
	}

	free(lBuffer);
	return;
}


/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/**************** End of Chroma2 format *********************/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/







/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/**************** Start of Chroma1 format *******************/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/


/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr1toColor64k_Ordered_709_FR
Description		: Converts YUV420 Chroma1 Planar to RGB565 Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr1toColor64k_Ordered_709_FR
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

    /* This function performs YUV to RGB conversion with dithering for 16-bit 
       {5,6,5} RGB. The 2x2 dither pattern used for {R,G,B} colors is as follows:

       |  {0,3,2}  {4,0,6} |
       |  {6,1,4}  {2,2,0} | */

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCr1 = lCrPtr[j >> 1];
            lCb1 = lCbPtr[j >> 1];
			
			lCr2 = lCrPtr[(j >> 1) + 1];
			lCb2 = lCbPtr[(j >> 1) + 1];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)(lTemp4);

            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)(lTemp4);


            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (25801 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb2) + (7670 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb2) >> COLOR_CONV_PRECISION;

            /*Second Pixel*/
            lY1 = lLumPtr[j + 1];

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)(lTemp4);


            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }

        lCr1 = lCrPtr[j >> 1];
        lCb1 = lCbPtr[j >> 1];
		
        lCr1 -= 128;
        lCb1 -= 128;

        lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
        lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
        lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;

        /*First Pixel*/
        lY1 = lLumPtr[j];

		/*B component*/
        lTemp = lY1 + lTemp3;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 3);

        /*G component*/
        lTemp = lY1 - lTemp2 + 3;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 2) << 5;
            
        /*R component*/
        lTemp = lY1 + lTemp1 + 2;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 3) << 11;

        lRGBFramePtr[0] = (uint16)(lTemp4);

        /*Third Pixel*/
        lY1 = lLumPtr[j + lLumWidth];

		/*B component*/
        lTemp = lY1 + lTemp3 + 6;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 3);

        /*G component*/
        lTemp = lY1 - lTemp2 + 1;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 2) << 5;
            
        /*R component*/
        lTemp = lY1 + lTemp1 + 4;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 3) << 11;

        lRGBFramePtr1[0] = (uint16)(lTemp4);


        /*Second Pixel*/
        lY1 = lLumPtr[j + 1];

		/*B component*/
        lTemp = lY1 + lTemp3 + 4;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 3);

        /*G component*/
        lTemp = lY1 - lTemp2;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 2) << 5;
            
        /*R component*/
        lTemp = lY1 + lTemp1 + 6;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 3) << 11;

        lRGBFramePtr[1] = (uint16)(lTemp4);


        /*Fourth Pixel*/
        lY1 = lLumPtr[j + lLumWidth + 1];

		/*B component*/
        lTemp = lY1 + lTemp3 + 2;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 3);

        /*G component*/
        lTemp = lY1 - lTemp2 + 2;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 2) << 5;
            
        /*R component*/
        lTemp = lY1 + lTemp1;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 3) << 11;

        lRGBFramePtr1[1] = (uint16)(lTemp4);

        lRGBFramePtr += 2;
		lRGBFramePtr1 += 2;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr1toColor64k_Ordered_601_5_FR
Description		: Converts YUV420 Chroma1 Planar to RGB565 Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr1toColor64k_Ordered_601_5_FR
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

    /* This function performs YUV to RGB conversion with dithering for 16-bit 
       {5,6,5} RGB. The 2x2 dither pattern used for {R,G,B} colors is as follows:

       |  {0,3,2}  {4,0,6} |
       |  {6,1,4}  {2,2,0} | */

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCr1 = lCrPtr[j >> 1];
            lCb1 = lCbPtr[j >> 1];
			
			lCr2 = lCrPtr[(j >> 1) + 1];
			lCb2 = lCbPtr[(j >> 1) + 1];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)(lTemp4);

            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)(lTemp4);


            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (22973 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb2) + (11699 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb2) >> COLOR_CONV_PRECISION;

            /*Second Pixel*/
            lY1 = lLumPtr[j + 1];

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)(lTemp4);


            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }

        lCr1 = lCrPtr[j >> 1];
        lCb1 = lCbPtr[j >> 1];
		
        lCr1 -= 128;
        lCb1 -= 128;

        lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
        lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
        lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;

        /*First Pixel*/
        lY1 = lLumPtr[j];

		/*B component*/
        lTemp = lY1 + lTemp3;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 3);

        /*G component*/
        lTemp = lY1 - lTemp2 + 3;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 2) << 5;
            
        /*R component*/
        lTemp = lY1 + lTemp1 + 2;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 3) << 11;

        lRGBFramePtr[0] = (uint16)(lTemp4);

        /*Third Pixel*/
        lY1 = lLumPtr[j + lLumWidth];

		/*B component*/
        lTemp = lY1 + lTemp3 + 6;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 3);

        /*G component*/
        lTemp = lY1 - lTemp2 + 1;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 2) << 5;
            
        /*R component*/
        lTemp = lY1 + lTemp1 + 4;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 3) << 11;

        lRGBFramePtr1[0] = (uint16)(lTemp4);


        /*Second Pixel*/
        lY1 = lLumPtr[j + 1];

		/*B component*/
        lTemp = lY1 + lTemp3 + 4;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 3);

        /*G component*/
        lTemp = lY1 - lTemp2;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 2) << 5;
            
        /*R component*/
        lTemp = lY1 + lTemp1 + 6;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 3) << 11;

        lRGBFramePtr[1] = (uint16)(lTemp4);


        /*Fourth Pixel*/
        lY1 = lLumPtr[j + lLumWidth + 1];

		/*B component*/
        lTemp = lY1 + lTemp3 + 2;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 3);

        /*G component*/
        lTemp = lY1 - lTemp2 + 2;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 2) << 5;
            
        /*R component*/
        lTemp = lY1 + lTemp1;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 3) << 11;

        lRGBFramePtr1[1] = (uint16)(lTemp4);

        lRGBFramePtr += 2;
		lRGBFramePtr1 += 2;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr1toColor64k_Ordered_709_RR
Description		: Converts YUV420 Chroma1 Planar to RGB565 Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr1toColor64k_Ordered_709_RR
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

    /* This function performs YUV to RGB conversion with dithering for 16-bit 
       {5,6,5} RGB. The 2x2 dither pattern used for {R,G,B} colors is as follows:

       |  {0,3,2}  {4,0,6} |
       |  {6,1,4}  {2,2,0} | */

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCr1 = lCrPtr[j >> 1];
            lCb1 = lCbPtr[j >> 1];
			
			lCr2 = lCrPtr[(j >> 1) + 1];
			lCb2 = lCbPtr[(j >> 1) + 1];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)(lTemp4);

            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)(lTemp4);


            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (29374 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb2) + (8731 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb2) >> COLOR_CONV_PRECISION;

            /*Second Pixel*/
            lY1 = lLumPtr[j + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)(lTemp4);


            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }

        lCr1 = lCrPtr[j >> 1];
        lCb1 = lCbPtr[j >> 1];
		
        lCr1 -= 128;
        lCb1 -= 128;

        lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
        lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
        lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;

        /*First Pixel*/
        lY1 = lLumPtr[j];
		lY1 -= 16;
		lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

		/*B component*/
        lTemp = lY1 + lTemp3;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 3);

        /*G component*/
        lTemp = lY1 - lTemp2 + 3;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 2) << 5;
            
        /*R component*/
        lTemp = lY1 + lTemp1 + 2;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 3) << 11;

        lRGBFramePtr[0] = (uint16)(lTemp4);

        /*Third Pixel*/
        lY1 = lLumPtr[j + lLumWidth];
		lY1 -= 16;
		lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

		/*B component*/
        lTemp = lY1 + lTemp3 + 6;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 3);

        /*G component*/
        lTemp = lY1 - lTemp2 + 1;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 2) << 5;
            
        /*R component*/
        lTemp = lY1 + lTemp1 + 4;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 3) << 11;

        lRGBFramePtr1[0] = (uint16)(lTemp4);


        /*Second Pixel*/
        lY1 = lLumPtr[j + 1];
		lY1 -= 16;
		lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

		/*B component*/
        lTemp = lY1 + lTemp3 + 4;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 3);

        /*G component*/
        lTemp = lY1 - lTemp2;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 2) << 5;
            
        /*R component*/
        lTemp = lY1 + lTemp1 + 6;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 3) << 11;

        lRGBFramePtr[1] = (uint16)(lTemp4);


        /*Fourth Pixel*/
        lY1 = lLumPtr[j + lLumWidth + 1];
		lY1 -= 16;
		lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

		/*B component*/
        lTemp = lY1 + lTemp3 + 2;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 3);

        /*G component*/
        lTemp = lY1 - lTemp2 + 2;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 2) << 5;
            
        /*R component*/
        lTemp = lY1 + lTemp1;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 3) << 11;

        lRGBFramePtr1[1] = (uint16)(lTemp4);

        lRGBFramePtr += 2;
		lRGBFramePtr1 += 2;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr1toColor64k_Ordered_601_5_RR
Description		: Converts YUV420 Chroma1 Planar to RGB565 Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr1toColor64k_Ordered_601_5_RR
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

    /* This function performs YUV to RGB conversion with dithering for 16-bit 
       {5,6,5} RGB. The 2x2 dither pattern used for {R,G,B} colors is as follows:

       |  {0,3,2}  {4,0,6} |
       |  {6,1,4}  {2,2,0} | */

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCr1 = lCrPtr[j >> 1];
            lCb1 = lCbPtr[j >> 1];
			
			lCr2 = lCrPtr[(j >> 1) + 1];
			lCb2 = lCbPtr[(j >> 1) + 1];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)(lTemp4);

            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)(lTemp4);


            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (26748 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb2) + (13621 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb2) >> COLOR_CONV_PRECISION;

            /*Second Pixel*/
            lY1 = lLumPtr[j + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)(lTemp4);


            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }

        lCr1 = lCrPtr[j >> 1];
        lCb1 = lCbPtr[j >> 1];
		
        lCr1 -= 128;
        lCb1 -= 128;

        lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
        lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
        lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;

        /*First Pixel*/
        lY1 = lLumPtr[j];
		lY1 -= 16;
		lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

		/*B component*/
        lTemp = lY1 + lTemp3;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 3);

        /*G component*/
        lTemp = lY1 - lTemp2 + 3;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 2) << 5;
            
        /*R component*/
        lTemp = lY1 + lTemp1 + 2;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 3) << 11;

        lRGBFramePtr[0] = (uint16)(lTemp4);

        /*Third Pixel*/
        lY1 = lLumPtr[j + lLumWidth];
		lY1 -= 16;
		lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

		/*B component*/
        lTemp = lY1 + lTemp3 + 6;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 3);

        /*G component*/
        lTemp = lY1 - lTemp2 + 1;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 2) << 5;
            
        /*R component*/
        lTemp = lY1 + lTemp1 + 4;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 3) << 11;

        lRGBFramePtr1[0] = (uint16)(lTemp4);


        /*Second Pixel*/
        lY1 = lLumPtr[j + 1];
		lY1 -= 16;
		lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

		/*B component*/
        lTemp = lY1 + lTemp3 + 4;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 3);

        /*G component*/
        lTemp = lY1 - lTemp2;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 2) << 5;
            
        /*R component*/
        lTemp = lY1 + lTemp1 + 6;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 3) << 11;

        lRGBFramePtr[1] = (uint16)(lTemp4);


        /*Fourth Pixel*/
        lY1 = lLumPtr[j + lLumWidth + 1];
		lY1 -= 16;
		lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

		/*B component*/
        lTemp = lY1 + lTemp3 + 2;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 3);

        /*G component*/
        lTemp = lY1 - lTemp2 + 2;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 2) << 5;
            
        /*R component*/
        lTemp = lY1 + lTemp1;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 3) << 11;

        lRGBFramePtr1[1] = (uint16)(lTemp4);

        lRGBFramePtr += 2;
		lRGBFramePtr1 += 2;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}



/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr1toColor16M_709_FR
Description		: Converts YUV420 Chroma1 Planar to RGB888 Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr1toColor16M_709_FR
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint8 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth * 3;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	dstXOffset *= 3;
	wndWidth   *= 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr  = dstImage + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCr1 = lCrPtr[j >> 1];
            lCb1 = lCbPtr[j >> 1];
			
			lCr2 = lCrPtr[(j >> 1) + 1];
			lCb2 = lCbPtr[(j >> 1) + 1];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];

            /*R component*/
            lTemp = lY1 + lTemp1;    
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[1] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
			if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

			lRGBFramePtr[2] = (uint8) lTemp;

            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];

            /*R component*/
            lTemp = lY1 + lTemp1;    
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[0] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[1] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
			if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

			lRGBFramePtr1[2] = (uint8) lTemp;


            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (25801 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb2) + (7670 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb2) >> COLOR_CONV_PRECISION;

            /*Second Pixel*/
            lY1 = lLumPtr[j + 1];

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
      
			lRGBFramePtr[3] = (uint8) lTemp; 

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[4] = (uint8) lTemp;
           
			/*B component*/
            lTemp = lY1 + lTemp3;
            
			if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[5] = (uint8) lTemp;


            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
      
			lRGBFramePtr1[3] = (uint8) lTemp; 

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[4] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
            
			if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[5] = (uint8) lTemp;

            lRGBFramePtr += 6;
			lRGBFramePtr1 += 6;
        }

			lCr1 = lCrPtr[j >> 1];
			lCb1 = lCbPtr[j >> 1];
		
			lCr1 -= 128;
			lCb1 -= 128;

			lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
			lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
			lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;

			/*First Pixel*/
			lY1 = lLumPtr[j];

            /*R component*/
            lTemp = lY1 + lTemp1;    
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[1] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
			if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

			lRGBFramePtr[2] = (uint8) lTemp;

			/*Third Pixel*/
			lY1 = lLumPtr[j + lLumWidth];

            /*R component*/
            lTemp = lY1 + lTemp1;    
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[0] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[1] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
			if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

			lRGBFramePtr1[2] = (uint8) lTemp;


			/*Second Pixel*/
			lY1 = lLumPtr[j + 1];

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
      
			lRGBFramePtr[3] = (uint8) lTemp; 

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[4] = (uint8) lTemp;
           
			/*B component*/
            lTemp = lY1 + lTemp3;
            
			if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[5] = (uint8) lTemp;


			/*Fourth Pixel*/
			lY1 = lLumPtr[j + lLumWidth + 1];

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
      
			lRGBFramePtr1[3] = (uint8) lTemp; 

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[4] = (uint8) lTemp;
           
			/*B component*/
            lTemp = lY1 + lTemp3;
            
			if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[5] = (uint8) lTemp;

			lRGBFramePtr += 6;
			lRGBFramePtr1 += 6;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-3];
			lRGBFramePtr1++;
			*lRGBFramePtr1 = lRGBFramePtr1[-3];
			lRGBFramePtr1++;
			*lRGBFramePtr1 = lRGBFramePtr1[-3];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth * 3; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr1toColor16M_601_5_FR
Description		: Converts YUV420 Chroma1 Planar to RGB888 Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr1toColor16M_601_5_FR
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint8 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth * 3;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	dstXOffset *= 3;
	wndWidth   *= 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr  = dstImage + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCr1 = lCrPtr[j >> 1];
            lCb1 = lCbPtr[j >> 1];
			
			lCr2 = lCrPtr[(j >> 1) + 1];
			lCb2 = lCbPtr[(j >> 1) + 1];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];

            /*R component*/
            lTemp = lY1 + lTemp1;    
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[1] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
			if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

			lRGBFramePtr[2] = (uint8) lTemp;

            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];

            /*R component*/
            lTemp = lY1 + lTemp1;    
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[0] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[1] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
			if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

			lRGBFramePtr1[2] = (uint8) lTemp;


            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (22973 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb2) + (11699 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb2) >> COLOR_CONV_PRECISION;

            /*Second Pixel*/
            lY1 = lLumPtr[j + 1];

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
      
			lRGBFramePtr[3] = (uint8) lTemp; 

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[4] = (uint8) lTemp;
           
			/*B component*/
            lTemp = lY1 + lTemp3;
            
			if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[5] = (uint8) lTemp;


            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
      
			lRGBFramePtr1[3] = (uint8) lTemp; 

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[4] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
            
			if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[5] = (uint8) lTemp;

            lRGBFramePtr += 6;
			lRGBFramePtr1 += 6;
        }

			lCr1 = lCrPtr[j >> 1];
			lCb1 = lCbPtr[j >> 1];
		
			lCr1 -= 128;
			lCb1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;

			/*First Pixel*/
			lY1 = lLumPtr[j];

            /*R component*/
            lTemp = lY1 + lTemp1;    
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[1] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
			if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

			lRGBFramePtr[2] = (uint8) lTemp;

			/*Third Pixel*/
			lY1 = lLumPtr[j + lLumWidth];

            /*R component*/
            lTemp = lY1 + lTemp1;    
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[0] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[1] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
			if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

			lRGBFramePtr1[2] = (uint8) lTemp;


			/*Second Pixel*/
			lY1 = lLumPtr[j + 1];

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
      
			lRGBFramePtr[3] = (uint8) lTemp; 

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[4] = (uint8) lTemp;
           
			/*B component*/
            lTemp = lY1 + lTemp3;
            
			if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[5] = (uint8) lTemp;


			/*Fourth Pixel*/
			lY1 = lLumPtr[j + lLumWidth + 1];

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
      
			lRGBFramePtr1[3] = (uint8) lTemp; 

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[4] = (uint8) lTemp;
           
			/*B component*/
            lTemp = lY1 + lTemp3;
            
			if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[5] = (uint8) lTemp;

			lRGBFramePtr += 6;
			lRGBFramePtr1 += 6;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-3];
			lRGBFramePtr1++;
			*lRGBFramePtr1 = lRGBFramePtr1[-3];
			lRGBFramePtr1++;
			*lRGBFramePtr1 = lRGBFramePtr1[-3];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth * 3; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr1toColor16M_709_RR
Description		: Converts YUV420 Chroma1 Planar to RGB888 Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr1toColor16M_709_RR
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint8 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth * 3;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	dstXOffset *= 3;
	wndWidth   *= 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr  = dstImage + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCr1 = lCrPtr[j >> 1];
            lCb1 = lCbPtr[j >> 1];
			
			lCr2 = lCrPtr[(j >> 1) + 1];
			lCb2 = lCbPtr[(j >> 1) + 1];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = lY1 + lTemp1;    
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[1] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

			lRGBFramePtr[2] = (uint8) lTemp;

            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = lY1 + lTemp1;    
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[0] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[1] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

			lRGBFramePtr1[2] = (uint8) lTemp;


            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (29374 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb2) + (8731 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb2) >> COLOR_CONV_PRECISION;

            /*Second Pixel*/
            lY1 = lLumPtr[j + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
      
			lRGBFramePtr[3] = (uint8) lTemp; 

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[4] = (uint8) lTemp;
           
			/*B component*/
            lTemp = lY1 + lTemp3;
            
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[5] = (uint8) lTemp;


            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
      
			lRGBFramePtr1[3] = (uint8) lTemp; 

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[4] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
            
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[5] = (uint8) lTemp;

            lRGBFramePtr += 6;
			lRGBFramePtr1 += 6;
        }

			lCr1 = lCrPtr[j >> 1];
			lCb1 = lCbPtr[j >> 1];
		
			lCr1 -= 128;
			lCb1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;

			/*First Pixel*/
			lY1 = lLumPtr[j];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = lY1 + lTemp1;    
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[1] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

			lRGBFramePtr[2] = (uint8) lTemp;

			/*Third Pixel*/
			lY1 = lLumPtr[j + lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = lY1 + lTemp1;    
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[0] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[1] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

			lRGBFramePtr1[2] = (uint8) lTemp;


			/*Second Pixel*/
			lY1 = lLumPtr[j + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
      
			lRGBFramePtr[3] = (uint8) lTemp; 

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[4] = (uint8) lTemp;
           
			/*B component*/
            lTemp = lY1 + lTemp3;
            
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[5] = (uint8) lTemp;


			/*Fourth Pixel*/
			lY1 = lLumPtr[j + lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
      
			lRGBFramePtr1[3] = (uint8) lTemp; 

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[4] = (uint8) lTemp;
           
			/*B component*/
            lTemp = lY1 + lTemp3;
            
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[5] = (uint8) lTemp;

			lRGBFramePtr += 6;
			lRGBFramePtr1 += 6;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-3];
			lRGBFramePtr1++;
			*lRGBFramePtr1 = lRGBFramePtr1[-3];
			lRGBFramePtr1++;
			*lRGBFramePtr1 = lRGBFramePtr1[-3];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth * 3; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr1toColor16M_601_5_RR
Description		: Converts YUV420 Chroma1 Planar to RGB888 Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr1toColor16M_601_5_RR
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint8 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth * 3;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

	dstXOffset *= 3;
	wndWidth   *= 3;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr  = dstImage + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCr1 = lCrPtr[j >> 1];
            lCb1 = lCbPtr[j >> 1];
			
			lCr2 = lCrPtr[(j >> 1) + 1];
			lCb2 = lCbPtr[(j >> 1) + 1];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = lY1 + lTemp1;    
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[1] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

			lRGBFramePtr[2] = (uint8) lTemp;

            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = lY1 + lTemp1;    
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[0] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[1] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

			lRGBFramePtr1[2] = (uint8) lTemp;


            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (26748 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb2) + (13621 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb2) >> COLOR_CONV_PRECISION;

            /*Second Pixel*/
            lY1 = lLumPtr[j + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
      
			lRGBFramePtr[3] = (uint8) lTemp; 

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[4] = (uint8) lTemp;
           
			/*B component*/
            lTemp = lY1 + lTemp3;
            
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[5] = (uint8) lTemp;


            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
      
			lRGBFramePtr1[3] = (uint8) lTemp; 

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[4] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
            
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[5] = (uint8) lTemp;

            lRGBFramePtr += 6;
			lRGBFramePtr1 += 6;
        }

			lCr1 = lCrPtr[j >> 1];
			lCb1 = lCbPtr[j >> 1];
		
			lCr1 -= 128;
			lCb1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;

			/*First Pixel*/
			lY1 = lLumPtr[j];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = lY1 + lTemp1;    
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[1] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

			lRGBFramePtr[2] = (uint8) lTemp;

			/*Third Pixel*/
			lY1 = lLumPtr[j + lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = lY1 + lTemp1;    
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[0] = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[1] = (uint8) lTemp;
            
			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;

			lRGBFramePtr1[2] = (uint8) lTemp;


			/*Second Pixel*/
			lY1 = lLumPtr[j + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
      
			lRGBFramePtr[3] = (uint8) lTemp; 

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[4] = (uint8) lTemp;
           
			/*B component*/
            lTemp = lY1 + lTemp3;
            
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr[5] = (uint8) lTemp;


			/*Fourth Pixel*/
			lY1 = lLumPtr[j + lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
      
			lRGBFramePtr1[3] = (uint8) lTemp; 

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[4] = (uint8) lTemp;
           
			/*B component*/
            lTemp = lY1 + lTemp3;
            
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            
			lRGBFramePtr1[5] = (uint8) lTemp;

			lRGBFramePtr += 6;
			lRGBFramePtr1 += 6;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-3];
			lRGBFramePtr1++;
			*lRGBFramePtr1 = lRGBFramePtr1[-3];
			lRGBFramePtr1++;
			*lRGBFramePtr1 = lRGBFramePtr1[-3];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth * 3; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
	}
	return;
}


/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr1toColor4k_Ordered_709_FR
Description		: Converts YUV420 Chroma1 Planar to XRGB (4:4:4:4) Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr1toColor4k_Ordered_709_FR
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

    /* This function performs YUV to RGB conversion with dithering for 12-bit 
       {4,4,4} RGB. The 2x2 dither pattern used for {R,G,B} colors is as follows:

       |  {0,15,5}   {10,0,15} |
       |  {15,5,10}  {5,10,0}  | */

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCr1 = lCrPtr[j >> 1];
            lCb1 = lCbPtr[j >> 1];
			
			lCr2 = lCrPtr[(j >> 1) + 1];
			lCb2 = lCbPtr[(j >> 1) + 1];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)(lTemp4);

            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)(lTemp4);


            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (25801 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb2) + (7670 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb2) >> COLOR_CONV_PRECISION;

            /*Second Pixel*/
            lY1 = lLumPtr[j + 1];

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)(lTemp4);


            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }

        lCr1 = lCrPtr[j >> 1];
        lCb1 = lCbPtr[j >> 1];
		
        lCr1 -= 128;
        lCb1 -= 128;

        lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
        lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
        lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;

        /*First Pixel*/
        lY1 = lLumPtr[j];

		/*B component*/
        lTemp = lY1 + lTemp3;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 4);

        /*G component*/
        lTemp = lY1 - lTemp2 + 15;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 4;
            
        /*R component*/
        lTemp = lY1 + lTemp1 + 5;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 8;

        lRGBFramePtr[0] = (uint16)(lTemp4);

        /*Third Pixel*/
        lY1 = lLumPtr[j + lLumWidth];

		/*B component*/
        lTemp = lY1 + lTemp3 + 15;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 4);

        /*G component*/
        lTemp = lY1 - lTemp2 + 5;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 4;
            
        /*R component*/
        lTemp = lY1 + lTemp1 + 10;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 8;

        lRGBFramePtr1[0] = (uint16)(lTemp4);


        /*Second Pixel*/
        lY1 = lLumPtr[j + 1];

		/*B component*/
        lTemp = lY1 + lTemp3 + 10;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 4);

        /*G component*/
        lTemp = lY1 - lTemp2;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 4;
            
        /*R component*/
        lTemp = lY1 + lTemp1 + 15;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 8;

        lRGBFramePtr[1] = (uint16)(lTemp4);


        /*Fourth Pixel*/
        lY1 = lLumPtr[j + lLumWidth + 1];

		/*B component*/
        lTemp = lY1 + lTemp3 + 5;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 4);

        /*G component*/
        lTemp = lY1 - lTemp2 + 10;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 4;
            
        /*R component*/
        lTemp = lY1 + lTemp1;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 8;

        lRGBFramePtr1[1] = (uint16)(lTemp4);

        lRGBFramePtr += 2;
		lRGBFramePtr1 += 2;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr1toColor4k_Ordered_601_5_FR
Description		: Converts YUV420 Chroma1 Planar to XRGB (4:4:4:4) Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr1toColor4k_Ordered_601_5_FR
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

    /* This function performs YUV to RGB conversion with dithering for 12-bit 
       {4,4,4} RGB. The 2x2 dither pattern used for {R,G,B} colors is as follows:

       |  {0,15,5}   {10,0,15} |
       |  {15,5,10}  {5,10,0}  | */

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCr1 = lCrPtr[j >> 1];
            lCb1 = lCbPtr[j >> 1];
			
			lCr2 = lCrPtr[(j >> 1) + 1];
			lCb2 = lCbPtr[(j >> 1) + 1];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)(lTemp4);

            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)(lTemp4);


            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (22973 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb2) + (11699 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb2) >> COLOR_CONV_PRECISION;

            /*Second Pixel*/
            lY1 = lLumPtr[j + 1];

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)(lTemp4);


            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }

        lCr1 = lCrPtr[j >> 1];
        lCb1 = lCbPtr[j >> 1];
		
        lCr1 -= 128;
        lCb1 -= 128;

        lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
        lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
        lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;

        /*First Pixel*/
        lY1 = lLumPtr[j];

		/*B component*/
        lTemp = lY1 + lTemp3;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 4);

        /*G component*/
        lTemp = lY1 - lTemp2 + 15;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 4;
            
        /*R component*/
        lTemp = lY1 + lTemp1 + 5;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 8;

        lRGBFramePtr[0] = (uint16)(lTemp4);

        /*Third Pixel*/
        lY1 = lLumPtr[j + lLumWidth];

		/*B component*/
        lTemp = lY1 + lTemp3 + 15;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 4);

        /*G component*/
        lTemp = lY1 - lTemp2 + 5;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 4;
            
        /*R component*/
        lTemp = lY1 + lTemp1 + 10;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 8;

        lRGBFramePtr1[0] = (uint16)(lTemp4);


        /*Second Pixel*/
        lY1 = lLumPtr[j + 1];

		/*B component*/
        lTemp = lY1 + lTemp3 + 10;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 4);

        /*G component*/
        lTemp = lY1 - lTemp2;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 4;
            
        /*R component*/
        lTemp = lY1 + lTemp1 + 15;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 8;

        lRGBFramePtr[1] = (uint16)(lTemp4);


        /*Fourth Pixel*/
        lY1 = lLumPtr[j + lLumWidth + 1];

		/*B component*/
        lTemp = lY1 + lTemp3 + 5;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 4);

        /*G component*/
        lTemp = lY1 - lTemp2 + 10;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 4;
            
        /*R component*/
        lTemp = lY1 + lTemp1;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 8;

        lRGBFramePtr1[1] = (uint16)(lTemp4);

        lRGBFramePtr += 2;
		lRGBFramePtr1 += 2;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr1toColor4k_Ordered_709_RR
Description		: Converts YUV420 Chroma1 Planar to XRGB (4:4:4:4) Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr1toColor4k_Ordered_709_RR
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

    /* This function performs YUV to RGB conversion with dithering for 12-bit 
       {4,4,4} RGB. The 2x2 dither pattern used for {R,G,B} colors is as follows:

       |  {0,15,5}   {10,0,15} |
       |  {15,5,10}  {5,10,0}  | */

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCr1 = lCrPtr[j >> 1];
            lCb1 = lCbPtr[j >> 1];
			
			lCr2 = lCrPtr[(j >> 1) + 1];
			lCb2 = lCbPtr[(j >> 1) + 1];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)(lTemp4);

            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)(lTemp4);


            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (29374 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb2) + (8731 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb2) >> COLOR_CONV_PRECISION;

            /*Second Pixel*/
            lY1 = lLumPtr[j + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)(lTemp4);


            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }

        lCr1 = lCrPtr[j >> 1];
        lCb1 = lCbPtr[j >> 1];
		
        lCr1 -= 128;
        lCb1 -= 128;

        lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
        lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
        lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;

        /*First Pixel*/
        lY1 = lLumPtr[j];
		lY1 -= 16;
		lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

		/*B component*/
        lTemp = lY1 + lTemp3;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 4);

        /*G component*/
        lTemp = lY1 - lTemp2 + 15;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 4;
            
        /*R component*/
        lTemp = lY1 + lTemp1 + 5;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 8;

        lRGBFramePtr[0] = (uint16)(lTemp4);

        /*Third Pixel*/
        lY1 = lLumPtr[j + lLumWidth];
		lY1 -= 16;
		lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

		/*B component*/
        lTemp = lY1 + lTemp3 + 15;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 4);

        /*G component*/
        lTemp = lY1 - lTemp2 + 5;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 4;
            
        /*R component*/
        lTemp = lY1 + lTemp1 + 10;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 8;

        lRGBFramePtr1[0] = (uint16)(lTemp4);


        /*Second Pixel*/
        lY1 = lLumPtr[j + 1];
		lY1 -= 16;
		lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

		/*B component*/
        lTemp = lY1 + lTemp3 + 10;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 4);

        /*G component*/
        lTemp = lY1 - lTemp2;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 4;
            
        /*R component*/
        lTemp = lY1 + lTemp1 + 15;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 8;

        lRGBFramePtr[1] = (uint16)(lTemp4);


        /*Fourth Pixel*/
        lY1 = lLumPtr[j + lLumWidth + 1];
		lY1 -= 16;
		lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

		/*B component*/
        lTemp = lY1 + lTemp3 + 5;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 4);

        /*G component*/
        lTemp = lY1 - lTemp2 + 10;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 4;
            
        /*R component*/
        lTemp = lY1 + lTemp1;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 8;

        lRGBFramePtr1[1] = (uint16)(lTemp4);

        lRGBFramePtr += 2;
		lRGBFramePtr1 += 2;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr1toColor4k_Ordered_601_5_RR
Description		: Converts YUV420 Chroma1 Planar to XRGB (4:4:4:4) Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr1toColor4k_Ordered_601_5_RR
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

    /* This function performs YUV to RGB conversion with dithering for 12-bit 
       {4,4,4} RGB. The 2x2 dither pattern used for {R,G,B} colors is as follows:

       |  {0,15,5}   {10,0,15} |
       |  {15,5,10}  {5,10,0}  | */

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCr1 = lCrPtr[j >> 1];
            lCb1 = lCbPtr[j >> 1];
			
			lCr2 = lCrPtr[(j >> 1) + 1];
			lCb2 = lCbPtr[(j >> 1) + 1];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)(lTemp4);

            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)(lTemp4);


            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (26748 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb2) + (13621 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb2) >> COLOR_CONV_PRECISION;

            /*Second Pixel*/
            lY1 = lLumPtr[j + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)(lTemp4);


            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }

        lCr1 = lCrPtr[j >> 1];
        lCb1 = lCbPtr[j >> 1];
		
        lCr1 -= 128;
        lCb1 -= 128;

        lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
        lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
        lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;

        /*First Pixel*/
        lY1 = lLumPtr[j];
		lY1 -= 16;
		lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

		/*B component*/
        lTemp = lY1 + lTemp3;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 4);

        /*G component*/
        lTemp = lY1 - lTemp2 + 15;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 4;
            
        /*R component*/
        lTemp = lY1 + lTemp1 + 5;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 8;

        lRGBFramePtr[0] = (uint16)(lTemp4);

        /*Third Pixel*/
        lY1 = lLumPtr[j + lLumWidth];
		lY1 -= 16;
		lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

		/*B component*/
        lTemp = lY1 + lTemp3 + 15;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 4);

        /*G component*/
        lTemp = lY1 - lTemp2 + 5;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 4;
            
        /*R component*/
        lTemp = lY1 + lTemp1 + 10;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 8;

        lRGBFramePtr1[0] = (uint16)(lTemp4);


        /*Second Pixel*/
        lY1 = lLumPtr[j + 1];
		lY1 -= 16;
		lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

		/*B component*/
        lTemp = lY1 + lTemp3 + 10;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 4);

        /*G component*/
        lTemp = lY1 - lTemp2;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 4;
            
        /*R component*/
        lTemp = lY1 + lTemp1 + 15;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 8;

        lRGBFramePtr[1] = (uint16)(lTemp4);


        /*Fourth Pixel*/
        lY1 = lLumPtr[j + lLumWidth + 1];
		lY1 -= 16;
		lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

		/*B component*/
        lTemp = lY1 + lTemp3 + 5;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 = (lTemp >> 4);

        /*G component*/
        lTemp = lY1 - lTemp2 + 10;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 4;
            
        /*R component*/
        lTemp = lY1 + lTemp1;
        if (lTemp < 0)
            lTemp = 0;
        if (lTemp > 255)
            lTemp = 255;
        lTemp4 |= (lTemp >> 4) << 8;

        lRGBFramePtr1[1] = (uint16)(lTemp4);

        lRGBFramePtr += 2;
		lRGBFramePtr1 += 2;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}


/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr1toColor16MU_709_FR
Description		: Converts YUV420 Chroma2 Planar to XRGB (8:8:8:8) Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr1toColor16MU_709_FR 
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint32 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr = (uint32*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCr1 = lCrPtr[j >> 1];
            lCb1 = lCbPtr[j >> 1];
			
			lCr2 = lCrPtr[(j >> 1) + 1];
			lCb2 = lCbPtr[(j >> 1) + 1];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
          
            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)(lTemp4);


            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr1[0] = (uint32)(lTemp4);


            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (25801 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb2) + (7670 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb2) >> COLOR_CONV_PRECISION;
            
			/*Second Pixel*/
            lY1 = lLumPtr[j + 1];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)(lTemp4);

            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr1[1] = (uint32)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }

            lCr1 = lCrPtr[j >> 1];
            lCb1 = lCbPtr[j >> 1];
			
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
          
            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)(lTemp4);


            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr1[0] = (uint32)(lTemp4);

			/*Second Pixel*/
            lY1 = lLumPtr[j + 1];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)(lTemp4);

            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr1[1] = (uint32)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;

		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr1toColor16MU_601_5_FR
Description		: Converts YUV420 Chroma2 Planar to XRGB (8:8:8:8) Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr1toColor16MU_601_5_FR 
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint32 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr = (uint32*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCr1 = lCrPtr[j >> 1];
            lCb1 = lCbPtr[j >> 1];
			
			lCr2 = lCrPtr[(j >> 1) + 1];
			lCb2 = lCbPtr[(j >> 1) + 1];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
          
            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)(lTemp4);


            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr1[0] = (uint32)(lTemp4);


            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (22973 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb2) + (11699 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb2) >> COLOR_CONV_PRECISION;
            
			/*Second Pixel*/
            lY1 = lLumPtr[j + 1];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)(lTemp4);

            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr1[1] = (uint32)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }

            lCr1 = lCrPtr[j >> 1];
            lCb1 = lCbPtr[j >> 1];
			
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
          
            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)(lTemp4);


            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr1[0] = (uint32)(lTemp4);

			/*Second Pixel*/
            lY1 = lLumPtr[j + 1];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)(lTemp4);

            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr1[1] = (uint32)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;

		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr1toColor16MU_709_RR
Description		: Converts YUV420 Chroma2 Planar to XRGB (8:8:8:8) Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr1toColor16MU_709_RR 
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint32 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr = (uint32*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCr1 = lCrPtr[j >> 1];
            lCb1 = lCbPtr[j >> 1];
			
			lCr2 = lCrPtr[(j >> 1) + 1];
			lCb2 = lCbPtr[(j >> 1) + 1];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;
          
            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)(lTemp4);


            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr1[0] = (uint32)(lTemp4);


            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (29374 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb2) + (8731 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb2) >> COLOR_CONV_PRECISION;
            
			/*Second Pixel*/
            lY1 = lLumPtr[j + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)(lTemp4);

            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr1[1] = (uint32)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }

            lCr1 = lCrPtr[j >> 1];
            lCb1 = lCbPtr[j >> 1];
			
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;
          
            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)(lTemp4);


            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr1[0] = (uint32)(lTemp4);

			/*Second Pixel*/
            lY1 = lLumPtr[j + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)(lTemp4);

            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr1[1] = (uint32)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;

		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV420Chr1toColor16MU_601_5_RR
Description		: Converts YUV420 Chroma2 Planar to XRGB (8:8:8:8) Interleaved format
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV420Chr1toColor16MU_601_5_RR 
		(tBaseVideoFrame* srcImage, uint8* dstImage, 
		 tWndParam* srcWindow,  tWndParam* dstWindow)
{
    uint32 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lLumPtr, *lCrPtr, *lCbPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraRow, extraCol;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lLumPtr = srcImage->lum + (srcYOffset * lLumWidth) + srcXOffset;
    lCbPtr = srcImage->cb + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);
    lCrPtr = srcImage->cr + (((srcYOffset * (lLumWidth >> 1)) + srcXOffset) >> 1);

    lRGBFramePtr = (uint32*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCr1 = lCrPtr[j >> 1];
            lCb1 = lCbPtr[j >> 1];
			
			lCr2 = lCrPtr[(j >> 1) + 1];
			lCb2 = lCbPtr[(j >> 1) + 1];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;
          
            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)(lTemp4);


            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr1[0] = (uint32)(lTemp4);


            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (26748 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb2) + (13621 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb2) >> COLOR_CONV_PRECISION;
            
			/*Second Pixel*/
            lY1 = lLumPtr[j + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)(lTemp4);

            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr1[1] = (uint32)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }

            lCr1 = lCrPtr[j >> 1];
            lCb1 = lCbPtr[j >> 1];
			
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
            lY1 = lLumPtr[j];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;
          
            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)(lTemp4);


            /*Third Pixel*/
            lY1 = lLumPtr[j + lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr1[0] = (uint32)(lTemp4);

			/*Second Pixel*/
            lY1 = lLumPtr[j + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)(lTemp4);

            /*Fourth Pixel*/
            lY1 = lLumPtr[j + lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr1[1] = (uint32)(lTemp4);

            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;

		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}

        lLumPtr += (lLumWidth << 1);
        lCrPtr += (lLumWidth >> 1);
        lCbPtr += (lLumWidth >> 1);

        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
		lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}



/************** End of YUV420 input *************/

/************** Start of YUV422BE input ********/

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr1toColor64k_Ordered_709_FR
Description		: Converts YUV422 BE (UYVY) Chroma1 Interleaved to RGB565 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr1toColor64k_Ordered_709_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

			lCb2 = lYuyvPtr[4];
			lCr2 = lYuyvPtr[6];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*First Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;

			lY1 = lYuyvPtr[1];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (25801 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb2) + (7670 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb2) >> COLOR_CONV_PRECISION;
                       
			lY1 = lYuyvPtr[3];

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth];
            lCr1 = lYuyvPtr[lLumWidth + 2];

			lCb2 = lYuyvPtr[lLumWidth + 4];
			lCr2 = lYuyvPtr[lLumWidth + 6];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*Third Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;
         
			lY1 = lYuyvPtr[lLumWidth + 1];

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (25801 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb2) + (7670 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb2) >> COLOR_CONV_PRECISION;
                        
			lY1 = lYuyvPtr[lLumWidth + 3];

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }


            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;

			/*First Pixel*/
			lY1 = lYuyvPtr[1];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
			lY1 = lYuyvPtr[3];

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth];
            lCr1 = lYuyvPtr[lLumWidth + 2];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;
         
			/*Third Pixel*/
			lY1 = lYuyvPtr[lLumWidth + 1];

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
			lY1 = lYuyvPtr[lLumWidth + 3];

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr1toColor64k_Ordered_601_5_FR
Description		: Converts YUV422 BE (UYVY) Chroma1 Interleaved to RGB565 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr1toColor64k_Ordered_601_5_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

			lCb2 = lYuyvPtr[4];
			lCr2 = lYuyvPtr[6];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*First Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;

			lY1 = lYuyvPtr[1];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (22973 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb2) + (11699 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb2) >> COLOR_CONV_PRECISION;
                       
			lY1 = lYuyvPtr[3];

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth];
            lCr1 = lYuyvPtr[lLumWidth + 2];

			lCb2 = lYuyvPtr[lLumWidth + 4];
			lCr2 = lYuyvPtr[lLumWidth + 6];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*Third Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;
         
			lY1 = lYuyvPtr[lLumWidth + 1];

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (22973 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb2) + (11699 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb2) >> COLOR_CONV_PRECISION;
                        
			lY1 = lYuyvPtr[lLumWidth + 3];

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }


            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;

			/*First Pixel*/
			lY1 = lYuyvPtr[1];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
			lY1 = lYuyvPtr[3];

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth];
            lCr1 = lYuyvPtr[lLumWidth + 2];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;
         
			/*Third Pixel*/
			lY1 = lYuyvPtr[lLumWidth + 1];

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
			lY1 = lYuyvPtr[lLumWidth + 3];

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr1toColor64k_Ordered_709_RR
Description		: Converts YUV422 BE (UYVY) Chroma1 Interleaved to RGB565 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr1toColor64k_Ordered_709_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

			lCb2 = lYuyvPtr[4];
			lCr2 = lYuyvPtr[6];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*First Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;

			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (29374 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb2) + (8731 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb2) >> COLOR_CONV_PRECISION;
                       
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth];
            lCr1 = lYuyvPtr[lLumWidth + 2];

			lCb2 = lYuyvPtr[lLumWidth + 4];
			lCr2 = lYuyvPtr[lLumWidth + 6];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*Third Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;
         
			lY1 = lYuyvPtr[lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (29374 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb2) + (8731 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb2) >> COLOR_CONV_PRECISION;
                        
			lY1 = lYuyvPtr[lLumWidth + 3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }


            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;

			/*First Pixel*/
			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth];
            lCr1 = lYuyvPtr[lLumWidth + 2];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;
         
			/*Third Pixel*/
			lY1 = lYuyvPtr[lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
			lY1 = lYuyvPtr[lLumWidth + 3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr1toColor64k_Ordered_601_5_RR
Description		: Converts YUV422 BE (UYVY) Chroma1 Interleaved to RGB565 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr1toColor64k_Ordered_601_5_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

			lCb2 = lYuyvPtr[4];
			lCr2 = lYuyvPtr[6];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*First Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;

			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (26748 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb2) + (13621 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb2) >> COLOR_CONV_PRECISION;
                       
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth];
            lCr1 = lYuyvPtr[lLumWidth + 2];

			lCb2 = lYuyvPtr[lLumWidth + 4];
			lCr2 = lYuyvPtr[lLumWidth + 6];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*Third Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;
         
			lY1 = lYuyvPtr[lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (26748 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb2) + (13621 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb2) >> COLOR_CONV_PRECISION;
                        
			lY1 = lYuyvPtr[lLumWidth + 3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }


            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;

			/*First Pixel*/
			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth];
            lCr1 = lYuyvPtr[lLumWidth + 2];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;
         
			/*Third Pixel*/
			lY1 = lYuyvPtr[lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
			lY1 = lYuyvPtr[lLumWidth + 3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}


/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr1toColor16M_709_FR
Description		: Converts YUV422 BE (UYVY) Chroma1 Interleaved to RGB888 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr1toColor16M_709_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint8  *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, extraCol, extraRow;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;


	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth * 3;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;
	
	dstXOffset *= 3;
	wndWidth   *= 3;

    lLumWidth = (srcImage->width >> 1) << 1 ;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    lRGBFramePtr  = dstImage + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

			lCb2 = lYuyvPtr[4];
			lCr2 = lYuyvPtr[6];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCb1 -= 128;
            lCr1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/         
			lY1 = lYuyvPtr[1];

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[1] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			
            lRGBFramePtr[2] = (uint8) lTemp;

            lCb2 -= 128;
            lCr2 -= 128;

            lTemp1 = (25801 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb2) + (7670 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb2) >> COLOR_CONV_PRECISION;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[3] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[4] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[5] = (uint8) lTemp;

			lYuyvPtr += 4;
            lRGBFramePtr += 6;
        }

            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

            lCb1 -= 128;
            lCr1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/         
			lY1 = lYuyvPtr[1];

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[1] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			
            lRGBFramePtr[2] = (uint8) lTemp;

            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[3] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[4] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[5] = (uint8) lTemp;

			lYuyvPtr += 4;
            lRGBFramePtr += 6;

		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }
	
	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth * 3; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr1toColor16M_601_5_FR
Description		: Converts YUV422 BE (UYVY) Chroma1 Interleaved to RGB888 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr1toColor16M_601_5_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint8  *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, extraCol, extraRow;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;


	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth * 3;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;
	
	dstXOffset *= 3;
	wndWidth   *= 3;

    lLumWidth = (srcImage->width >> 1) << 1 ;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    lRGBFramePtr  = dstImage + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

			lCb2 = lYuyvPtr[4];
			lCr2 = lYuyvPtr[6];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCb1 -= 128;
            lCr1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/         
			lY1 = lYuyvPtr[1];

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[1] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			
            lRGBFramePtr[2] = (uint8) lTemp;

            lCb2 -= 128;
            lCr2 -= 128;

            lTemp1 = (22973 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb2) + (11699 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb2) >> COLOR_CONV_PRECISION;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[3] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[4] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[5] = (uint8) lTemp;

			lYuyvPtr += 4;
            lRGBFramePtr += 6;
        }

            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

            lCb1 -= 128;
            lCr1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/         
			lY1 = lYuyvPtr[1];

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[1] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			
            lRGBFramePtr[2] = (uint8) lTemp;

            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[3] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[4] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[5] = (uint8) lTemp;

			lYuyvPtr += 4;
            lRGBFramePtr += 6;

		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }
	
	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth * 3; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr1toColor16M_709_RR
Description		: Converts YUV422 BE (UYVY) Chroma1 Interleaved to RGB888 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr1toColor16M_709_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint8  *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, extraCol, extraRow;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;


	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth * 3;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;
	
	dstXOffset *= 3;
	wndWidth   *= 3;

    lLumWidth = (srcImage->width >> 1) << 1 ;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    lRGBFramePtr  = dstImage + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

			lCb2 = lYuyvPtr[4];
			lCr2 = lYuyvPtr[6];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCb1 -= 128;
            lCr1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/         
			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[1] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			
            lRGBFramePtr[2] = (uint8) lTemp;

            lCb2 -= 128;
            lCr2 -= 128;

            lTemp1 = (29374 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb2) + (8731 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb2) >> COLOR_CONV_PRECISION;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[3] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[4] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[5] = (uint8) lTemp;

			lYuyvPtr += 4;
            lRGBFramePtr += 6;
        }

            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

            lCb1 -= 128;
            lCr1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/         
			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[1] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			
            lRGBFramePtr[2] = (uint8) lTemp;

            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[3] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[4] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[5] = (uint8) lTemp;

			lYuyvPtr += 4;
            lRGBFramePtr += 6;

		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }
	
	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth * 3; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr1toColor16M_601_5_RR
Description		: Converts YUV422 BE (UYVY) Chroma1 Interleaved to RGB888 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr1toColor16M_601_5_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint8  *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, extraCol, extraRow;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;


	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth * 3;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;
	
	dstXOffset *= 3;
	wndWidth   *= 3;

    lLumWidth = (srcImage->width >> 1) << 1 ;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    lRGBFramePtr  = dstImage + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

			lCb2 = lYuyvPtr[4];
			lCr2 = lYuyvPtr[6];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCb1 -= 128;
            lCr1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/         
			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[1] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			
            lRGBFramePtr[2] = (uint8) lTemp;

            lCb2 -= 128;
            lCr2 -= 128;

            lTemp1 = (26748 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb2) + (13621 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb2) >> COLOR_CONV_PRECISION;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[3] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[4] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[5] = (uint8) lTemp;

			lYuyvPtr += 4;
            lRGBFramePtr += 6;
        }

            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

            lCb1 -= 128;
            lCr1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/         
			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[1] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			
            lRGBFramePtr[2] = (uint8) lTemp;

            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[3] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[4] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[5] = (uint8) lTemp;

			lYuyvPtr += 4;
            lRGBFramePtr += 6;

		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }
	
	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth * 3; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
	}
	return;
}


/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr1toColor4k_Ordered_709_FR
Description		: Converts YUV422 BE (UYVY) Chroma1 Interleaved to XRGB (4:4:4:4) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr1toColor4k_Ordered_709_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

			lCb2 = lYuyvPtr[4];
			lCr2 = lYuyvPtr[6];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*First Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;

			lY1 = lYuyvPtr[1];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (25801 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb2) + (7670 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb2) >> COLOR_CONV_PRECISION;
                       
			lY1 = lYuyvPtr[3];

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth];
            lCr1 = lYuyvPtr[lLumWidth + 2];

			lCb2 = lYuyvPtr[lLumWidth + 4];
			lCr2 = lYuyvPtr[lLumWidth + 6];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*Third Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;
         
			lY1 = lYuyvPtr[lLumWidth + 1];

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (25801 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb2) + (7670 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb2) >> COLOR_CONV_PRECISION;
                        
			lY1 = lYuyvPtr[lLumWidth + 3];

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }


            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;

			/*First Pixel*/
			lY1 = lYuyvPtr[1];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
			lY1 = lYuyvPtr[3];

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth];
            lCr1 = lYuyvPtr[lLumWidth + 2];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;
         
			/*Third Pixel*/
			lY1 = lYuyvPtr[lLumWidth + 1];

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
			lY1 = lYuyvPtr[lLumWidth + 3];

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr1toColor4k_Ordered_601_5_FR
Description		: Converts YUV422 BE (UYVY) Chroma1 Interleaved to XRGB (4:4:4:4) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr1toColor4k_Ordered_601_5_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

			lCb2 = lYuyvPtr[4];
			lCr2 = lYuyvPtr[6];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*First Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;

			lY1 = lYuyvPtr[1];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (22973 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb2) + (11699 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb2) >> COLOR_CONV_PRECISION;
                       
			lY1 = lYuyvPtr[3];

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth];
            lCr1 = lYuyvPtr[lLumWidth + 2];

			lCb2 = lYuyvPtr[lLumWidth + 4];
			lCr2 = lYuyvPtr[lLumWidth + 6];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*Third Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;
         
			lY1 = lYuyvPtr[lLumWidth + 1];

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (22973 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb2) + (11699 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb2) >> COLOR_CONV_PRECISION;
                        
			lY1 = lYuyvPtr[lLumWidth + 3];

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }


            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;

			/*First Pixel*/
			lY1 = lYuyvPtr[1];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
			lY1 = lYuyvPtr[3];

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth];
            lCr1 = lYuyvPtr[lLumWidth + 2];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;
         
			/*Third Pixel*/
			lY1 = lYuyvPtr[lLumWidth + 1];

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
			lY1 = lYuyvPtr[lLumWidth + 3];

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr1toColor4k_Ordered_709_RR
Description		: Converts YUV422 BE (UYVY) Chroma1 Interleaved to XRGB (4:4:4:4) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr1toColor4k_Ordered_709_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

			lCb2 = lYuyvPtr[4];
			lCr2 = lYuyvPtr[6];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*First Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;

			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (29374 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb2) + (8731 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb2) >> COLOR_CONV_PRECISION;
                       
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth];
            lCr1 = lYuyvPtr[lLumWidth + 2];

			lCb2 = lYuyvPtr[lLumWidth + 4];
			lCr2 = lYuyvPtr[lLumWidth + 6];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*Third Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;
         
			lY1 = lYuyvPtr[lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (29374 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb2) + (8731 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb2) >> COLOR_CONV_PRECISION;
                        
			lY1 = lYuyvPtr[lLumWidth + 3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }


            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;

			/*First Pixel*/
			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth];
            lCr1 = lYuyvPtr[lLumWidth + 2];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;
         
			/*Third Pixel*/
			lY1 = lYuyvPtr[lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
			lY1 = lYuyvPtr[lLumWidth + 3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr1toColor4k_Ordered_601_5_RR
Description		: Converts YUV422 BE (UYVY) Chroma1 Interleaved to XRGB (4:4:4:4) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr1toColor4k_Ordered_601_5_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

			lCb2 = lYuyvPtr[4];
			lCr2 = lYuyvPtr[6];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*First Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;

			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (26748 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb2) + (13621 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb2) >> COLOR_CONV_PRECISION;
                       
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth];
            lCr1 = lYuyvPtr[lLumWidth + 2];

			lCb2 = lYuyvPtr[lLumWidth + 4];
			lCr2 = lYuyvPtr[lLumWidth + 6];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*Third Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;
         
			lY1 = lYuyvPtr[lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (26748 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb2) + (13621 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb2) >> COLOR_CONV_PRECISION;
                        
			lY1 = lYuyvPtr[lLumWidth + 3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }


            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;

			/*First Pixel*/
			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth];
            lCr1 = lYuyvPtr[lLumWidth + 2];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;
         
			/*Third Pixel*/
			lY1 = lYuyvPtr[lLumWidth + 1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
			lY1 = lYuyvPtr[lLumWidth + 3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}


/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr1toColor16MU_709_FR
Description		: Converts YUV422 BE (UYVY) Chroma1 Interleaved to XRGB (8:8:8:8) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr1toColor16MU_709_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint32 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
 
    lRGBFramePtr = (uint32*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

			lCb2 = lYuyvPtr[4];
			lCr2 = lYuyvPtr[6];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)lTemp4;

            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (25801 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb2) + (7670 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb2) >> COLOR_CONV_PRECISION;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
        }

            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)lTemp4;

            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;

		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			 lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr1toColor16MU_601_5_FR
Description		: Converts YUV422 BE (UYVY) Chroma1 Interleaved to XRGB (8:8:8:8) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr1toColor16MU_601_5_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint32 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
 
    lRGBFramePtr = (uint32*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

			lCb2 = lYuyvPtr[4];
			lCr2 = lYuyvPtr[6];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)lTemp4;

            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (22973 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb2) + (11699 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb2) >> COLOR_CONV_PRECISION;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
        }

            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)lTemp4;

            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;

		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			 lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr1toColor16MU_709_RR
Description		: Converts YUV422 BE (UYVY) Chroma1 Interleaved to XRGB (8:8:8:8) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr1toColor16MU_709_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint32 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
 
    lRGBFramePtr = (uint32*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

			lCb2 = lYuyvPtr[4];
			lCr2 = lYuyvPtr[6];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)lTemp4;

            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (29374 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb2) + (8731 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb2) >> COLOR_CONV_PRECISION;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
        }

            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)lTemp4;

            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;

		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			 lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422BEChr1toColor16MU_601_5_RR
Description		: Converts YUV422 BE (UYVY) Chroma1 Interleaved to XRGB (8:8:8:8) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422BEChr1toColor16MU_601_5_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint32 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
 
    lRGBFramePtr = (uint32*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

			lCb2 = lYuyvPtr[4];
			lCr2 = lYuyvPtr[6];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)lTemp4;

            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (26748 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb2) + (13621 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb2) >> COLOR_CONV_PRECISION;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
        }

            lCb1 = lYuyvPtr[0];
            lCr1 = lYuyvPtr[2];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[1];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)lTemp4;

            /*Second Pixel*/            
			lY1 = lYuyvPtr[3];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;

		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			 lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/************** End of YUV422BE input *******************/





/************** Start of YUV422LE input ********/

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr1toColor64k_Ordered_709_FR
Description		: Converts YUV422 LE (YVYU) Chroma1 Interleaved to RGB565 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr1toColor64k_Ordered_709_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

			lCb2 = lYuyvPtr[7];
			lCr2 = lYuyvPtr[5];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*First Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;

			lY1 = lYuyvPtr[2];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (25801 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb2) + (7670 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb2) >> COLOR_CONV_PRECISION;
                       
			lY1 = lYuyvPtr[0];

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth + 3];
            lCr1 = lYuyvPtr[lLumWidth + 1];

			lCb2 = lYuyvPtr[lLumWidth + 7];
			lCr2 = lYuyvPtr[lLumWidth + 5];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*Third Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;
         
			lY1 = lYuyvPtr[lLumWidth + 2];

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (25801 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb2) + (7670 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb2) >> COLOR_CONV_PRECISION;
                        
			lY1 = lYuyvPtr[lLumWidth];

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }


            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;

			/*First Pixel*/
			lY1 = lYuyvPtr[2];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
			lY1 = lYuyvPtr[0];

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth + 3];
            lCr1 = lYuyvPtr[lLumWidth + 1];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;
         
			/*Third Pixel*/
			lY1 = lYuyvPtr[lLumWidth + 2];

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
			lY1 = lYuyvPtr[lLumWidth];

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr1toColor64k_Ordered_601_5_FR
Description		: Converts YUV422 LE (YVYU) Chroma1 Interleaved to RGB565 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr1toColor64k_Ordered_601_5_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

			lCb2 = lYuyvPtr[7];
			lCr2 = lYuyvPtr[5];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*First Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;

			lY1 = lYuyvPtr[2];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (22973 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb2) + (11699 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb2) >> COLOR_CONV_PRECISION;
                       
			lY1 = lYuyvPtr[0];

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth + 3];
            lCr1 = lYuyvPtr[lLumWidth + 1];

			lCb2 = lYuyvPtr[lLumWidth + 7];
			lCr2 = lYuyvPtr[lLumWidth + 5];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*Third Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;
         
			lY1 = lYuyvPtr[lLumWidth + 2];

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (22973 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb2) + (11699 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb2) >> COLOR_CONV_PRECISION;
                        
			lY1 = lYuyvPtr[lLumWidth];

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }


            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;

			/*First Pixel*/
			lY1 = lYuyvPtr[2];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
			lY1 = lYuyvPtr[0];

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth + 3];
            lCr1 = lYuyvPtr[lLumWidth + 1];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;
         
			/*Third Pixel*/
			lY1 = lYuyvPtr[lLumWidth + 2];

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
			lY1 = lYuyvPtr[lLumWidth];

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr1toColor64k_Ordered_709_RR
Description		: Converts YUV422 LE (YVYU) Chroma1 Interleaved to RGB565 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr1toColor64k_Ordered_709_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

			lCb2 = lYuyvPtr[7];
			lCr2 = lYuyvPtr[5];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*First Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;

			lY1 = lYuyvPtr[2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (29374 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb2) + (8731 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb2) >> COLOR_CONV_PRECISION;
                       
			lY1 = lYuyvPtr[0];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth + 3];
            lCr1 = lYuyvPtr[lLumWidth + 1];

			lCb2 = lYuyvPtr[lLumWidth + 7];
			lCr2 = lYuyvPtr[lLumWidth + 5];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*Third Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;
         
			lY1 = lYuyvPtr[lLumWidth + 2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (29374 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb2) + (8731 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb2) >> COLOR_CONV_PRECISION;
                        
			lY1 = lYuyvPtr[lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }


            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;

			/*First Pixel*/
			lY1 = lYuyvPtr[2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
			lY1 = lYuyvPtr[0];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth + 3];
            lCr1 = lYuyvPtr[lLumWidth + 1];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;
         
			/*Third Pixel*/
			lY1 = lYuyvPtr[lLumWidth + 2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
			lY1 = lYuyvPtr[lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr1toColor64k_Ordered_601_5_RR
Description		: Converts YUV422 LE (YVYU) Chroma1 Interleaved to RGB565 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr1toColor64k_Ordered_601_5_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

			lCb2 = lYuyvPtr[7];
			lCr2 = lYuyvPtr[5];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*First Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;

			lY1 = lYuyvPtr[2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (26748 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb2) + (13621 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb2) >> COLOR_CONV_PRECISION;
                       
			lY1 = lYuyvPtr[0];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth + 3];
            lCr1 = lYuyvPtr[lLumWidth + 1];

			lCb2 = lYuyvPtr[lLumWidth + 7];
			lCr2 = lYuyvPtr[lLumWidth + 5];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*Third Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;
         
			lY1 = lYuyvPtr[lLumWidth + 2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (26748 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb2) + (13621 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb2) >> COLOR_CONV_PRECISION;
                        
			lY1 = lYuyvPtr[lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }


            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;

			/*First Pixel*/
			lY1 = lYuyvPtr[2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
			lY1 = lYuyvPtr[0];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth + 3];
            lCr1 = lYuyvPtr[lLumWidth + 1];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;
         
			/*Third Pixel*/
			lY1 = lYuyvPtr[lLumWidth + 2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 6;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 4;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
			lY1 = lYuyvPtr[lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 3);

            /*G component*/
            lTemp = lY1 - lTemp2 + 2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 2) << 5;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 3) << 11;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}


/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr1toColor16M_709_FR
Description		: Converts YUV422 LE (YVYU) Chroma1 Interleaved to RGB888 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr1toColor16M_709_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint8  *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, extraCol, extraRow;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;


	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth * 3;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;
	
	dstXOffset *= 3;
	wndWidth   *= 3;

    lLumWidth = (srcImage->width >> 1) << 1 ;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    lRGBFramePtr  = dstImage + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

			lCb2 = lYuyvPtr[7];
			lCr2 = lYuyvPtr[5];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCb1 -= 128;
            lCr1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/         
			lY1 = lYuyvPtr[2];

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[1] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			
            lRGBFramePtr[2] = (uint8) lTemp;

            lCb2 -= 128;
            lCr2 -= 128;

            lTemp1 = (25801 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb2) + (7670 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb2) >> COLOR_CONV_PRECISION;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[3] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[4] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[5] = (uint8) lTemp;

			lYuyvPtr += 4;
            lRGBFramePtr += 6;
        }

            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

            lCb1 -= 128;
            lCr1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/         
			lY1 = lYuyvPtr[2];

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[1] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			
            lRGBFramePtr[2] = (uint8) lTemp;

            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[3] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[4] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[5] = (uint8) lTemp;

			lYuyvPtr += 4;
            lRGBFramePtr += 6;

		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }
	
	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth * 3; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr1toColor16M_601_5_FR
Description		: Converts YUV422 LE (YVYU) Chroma1 Interleaved to RGB888 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr1toColor16M_601_5_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint8  *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, extraCol, extraRow;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;


	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth * 3;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;
	
	dstXOffset *= 3;
	wndWidth   *= 3;

    lLumWidth = (srcImage->width >> 1) << 1 ;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    lRGBFramePtr  = dstImage + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

			lCb2 = lYuyvPtr[7];
			lCr2 = lYuyvPtr[5];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCb1 -= 128;
            lCr1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/         
			lY1 = lYuyvPtr[2];

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[1] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			
            lRGBFramePtr[2] = (uint8) lTemp;

            lCb2 -= 128;
            lCr2 -= 128;

            lTemp1 = (22973 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb2) + (11699 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb2) >> COLOR_CONV_PRECISION;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[3] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[4] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[5] = (uint8) lTemp;

			lYuyvPtr += 4;
            lRGBFramePtr += 6;
        }

            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

            lCb1 -= 128;
            lCr1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/         
			lY1 = lYuyvPtr[2];

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[1] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			
            lRGBFramePtr[2] = (uint8) lTemp;

            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[3] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[4] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[5] = (uint8) lTemp;

			lYuyvPtr += 4;
            lRGBFramePtr += 6;

		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }
	
	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth * 3; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr1toColor16M_709_RR
Description		: Converts YUV422 LE (YVYU) Chroma1 Interleaved to RGB888 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr1toColor16M_709_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint8  *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, extraCol, extraRow;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;


	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth * 3;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;
	
	dstXOffset *= 3;
	wndWidth   *= 3;

    lLumWidth = (srcImage->width >> 1) << 1 ;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    lRGBFramePtr  = dstImage + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

			lCb2 = lYuyvPtr[7];
			lCr2 = lYuyvPtr[5];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCb1 -= 128;
            lCr1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/         
			lY1 = lYuyvPtr[2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[1] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			
            lRGBFramePtr[2] = (uint8) lTemp;

            lCb2 -= 128;
            lCr2 -= 128;

            lTemp1 = (29374 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb2) + (8731 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb2) >> COLOR_CONV_PRECISION;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[3] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[4] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[5] = (uint8) lTemp;

			lYuyvPtr += 4;
            lRGBFramePtr += 6;
        }

            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

            lCb1 -= 128;
            lCr1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/         
			lY1 = lYuyvPtr[2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[1] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			
            lRGBFramePtr[2] = (uint8) lTemp;

            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[3] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[4] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[5] = (uint8) lTemp;

			lYuyvPtr += 4;
            lRGBFramePtr += 6;

		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }
	
	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth * 3; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr1toColor16M_601_5_RR
Description		: Converts YUV422 LE (YVYU) Chroma1 Interleaved to RGB888 Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr1toColor16M_601_5_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint8  *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3;
    int32  i, j, extraCol, extraRow;
	int32  srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		   cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;


	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth * 3;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;
	
	dstXOffset *= 3;
	wndWidth   *= 3;

    lLumWidth = (srcImage->width >> 1) << 1 ;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);

    lRGBFramePtr  = dstImage + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

			lCb2 = lYuyvPtr[7];
			lCr2 = lYuyvPtr[5];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCb1 -= 128;
            lCr1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/         
			lY1 = lYuyvPtr[2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[1] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			
            lRGBFramePtr[2] = (uint8) lTemp;

            lCb2 -= 128;
            lCr2 -= 128;

            lTemp1 = (26748 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb2) + (13621 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb2) >> COLOR_CONV_PRECISION;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[3] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[4] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[5] = (uint8) lTemp;

			lYuyvPtr += 4;
            lRGBFramePtr += 6;
        }

            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

            lCb1 -= 128;
            lCr1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/         
			lY1 = lYuyvPtr[2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[0] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[1] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			
            lRGBFramePtr[2] = (uint8) lTemp;

            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

            /*R component*/
            lTemp = (lY1 + lTemp1);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
            lRGBFramePtr[3] = (uint8) lTemp;

            /*G component*/
            lTemp = (lY1 - lTemp2);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[4] = (uint8) lTemp;

            /*B component*/
            lTemp = (lY1 + lTemp3);
			if (lTemp < 0)
            	lTemp = 0;
            if (lTemp > 255)
            	lTemp = 255;
			lRGBFramePtr[5] = (uint8) lTemp;

			lYuyvPtr += 4;
            lRGBFramePtr += 6;

		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;

			*lRGBFramePtr = lRGBFramePtr[-3];
			lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }
	
	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth * 3; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
	}
	return;
}


/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr1toColor4k_Ordered_709_FR
Description		: Converts YUV422 LE (YVYU) Chroma1 Interleaved to XRGB (4:4:4:4) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr1toColor4k_Ordered_709_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

			lCb2 = lYuyvPtr[7];
			lCr2 = lYuyvPtr[5];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*First Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;

			lY1 = lYuyvPtr[2];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (25801 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb2) + (7670 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb2) >> COLOR_CONV_PRECISION;
                       
			lY1 = lYuyvPtr[0];

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth + 3];
            lCr1 = lYuyvPtr[lLumWidth + 1];

			lCb2 = lYuyvPtr[lLumWidth + 7];
			lCr2 = lYuyvPtr[lLumWidth + 5];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*Third Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;
         
			lY1 = lYuyvPtr[lLumWidth + 2];

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (25801 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb2) + (7670 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb2) >> COLOR_CONV_PRECISION;
                        
			lY1 = lYuyvPtr[lLumWidth];

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }


            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;

			/*First Pixel*/
			lY1 = lYuyvPtr[2];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
			lY1 = lYuyvPtr[0];

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth + 3];
            lCr1 = lYuyvPtr[lLumWidth + 1];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;
         
			/*Third Pixel*/
			lY1 = lYuyvPtr[lLumWidth + 2];

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
			lY1 = lYuyvPtr[lLumWidth];

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr1toColor4k_Ordered_601_5_FR
Description		: Converts YUV422 LE (YVYU) Chroma1 Interleaved to XRGB (4:4:4:4) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr1toColor4k_Ordered_601_5_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

			lCb2 = lYuyvPtr[7];
			lCr2 = lYuyvPtr[5];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*First Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;

			lY1 = lYuyvPtr[2];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (22973 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb2) + (11699 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb2) >> COLOR_CONV_PRECISION;
                       
			lY1 = lYuyvPtr[0];

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth + 3];
            lCr1 = lYuyvPtr[lLumWidth + 1];

			lCb2 = lYuyvPtr[lLumWidth + 7];
			lCr2 = lYuyvPtr[lLumWidth + 5];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*Third Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;
         
			lY1 = lYuyvPtr[lLumWidth + 2];

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (22973 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb2) + (11699 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb2) >> COLOR_CONV_PRECISION;
                        
			lY1 = lYuyvPtr[lLumWidth];

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }


            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;

			/*First Pixel*/
			lY1 = lYuyvPtr[2];

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
			lY1 = lYuyvPtr[0];

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth + 3];
            lCr1 = lYuyvPtr[lLumWidth + 1];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;
         
			/*Third Pixel*/
			lY1 = lYuyvPtr[lLumWidth + 2];

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
			lY1 = lYuyvPtr[lLumWidth];

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr1toColor4k_Ordered_709_RR
Description		: Converts YUV422 LE (YVYU) Chroma1 Interleaved to XRGB (4:4:4:4) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr1toColor4k_Ordered_709_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

			lCb2 = lYuyvPtr[7];
			lCr2 = lYuyvPtr[5];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*First Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;

			lY1 = lYuyvPtr[2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (29374 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb2) + (8731 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb2) >> COLOR_CONV_PRECISION;
                       
			lY1 = lYuyvPtr[0];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth + 3];
            lCr1 = lYuyvPtr[lLumWidth + 1];

			lCb2 = lYuyvPtr[lLumWidth + 7];
			lCr2 = lYuyvPtr[lLumWidth + 5];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*Third Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;
         
			lY1 = lYuyvPtr[lLumWidth + 2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (29374 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb2) + (8731 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb2) >> COLOR_CONV_PRECISION;
                        
			lY1 = lYuyvPtr[lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }


            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;

			/*First Pixel*/
			lY1 = lYuyvPtr[2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
			lY1 = lYuyvPtr[0];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth + 3];
            lCr1 = lYuyvPtr[lLumWidth + 1];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (29374 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3494 * lCb1) + (8731 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (34603 * lCb1) >> COLOR_CONV_PRECISION;
         
			/*Third Pixel*/
			lY1 = lYuyvPtr[lLumWidth + 2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
			lY1 = lYuyvPtr[lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr1toColor4k_Ordered_601_5_RR
Description		: Converts YUV422 LE (YVYU) Chroma1 Interleaved to XRGB (4:4:4:4) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr1toColor4k_Ordered_601_5_RR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint16 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
   
	lRGBFramePtr = (uint16*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;
    lRGBFramePtr1 = lRGBFramePtr + wndWidth;

	lLumWidth <<= 1;

    for(i = 0; i < lHeight; i += 2)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

			lCb2 = lYuyvPtr[7];
			lCr2 = lYuyvPtr[5];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*First Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;

			lY1 = lYuyvPtr[2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (26748 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb2) + (13621 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb2) >> COLOR_CONV_PRECISION;
                       
			lY1 = lYuyvPtr[0];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth + 3];
            lCr1 = lYuyvPtr[lLumWidth + 1];

			lCb2 = lYuyvPtr[lLumWidth + 7];
			lCr2 = lYuyvPtr[lLumWidth + 5];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

			/*Third Pixel*/
            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;
         
			lY1 = lYuyvPtr[lLumWidth + 2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (26748 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb2) + (13621 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb2) >> COLOR_CONV_PRECISION;
                        
			lY1 = lYuyvPtr[lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;
        }


            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;

			/*First Pixel*/
			lY1 = lYuyvPtr[2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[0] = (uint16)lTemp4;

			/*Second Pixel*/
			lY1 = lYuyvPtr[0];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr[1] = (uint16)lTemp4;


            lCb1 = lYuyvPtr[lLumWidth + 3];
            lCr1 = lYuyvPtr[lLumWidth + 1];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (26748 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((6563 * lCb1) + (13621 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (33802 * lCb1) >> COLOR_CONV_PRECISION;
         
			/*Third Pixel*/
			lY1 = lYuyvPtr[lLumWidth + 2];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 15;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[0] = (uint16)lTemp4;

			/*Fourth Pixel*/
			lY1 = lYuyvPtr[lLumWidth];
			lY1 -= 16;
			lY1 = (lY1 * 19075) >> COLOR_CONV_PRECISION;

			/*B component*/
            lTemp = lY1 + lTemp3 + 5;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (lTemp >> 4);

            /*G component*/
            lTemp = lY1 - lTemp2 + 10;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 4;
            
            /*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= (lTemp >> 4) << 8;

            lRGBFramePtr1[1] = (uint16)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
			lRGBFramePtr1 += 2;


		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			lRGBFramePtr++;
			*lRGBFramePtr1 = lRGBFramePtr1[-1];
			lRGBFramePtr1++;
		}
		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += ((wndWidth << 1) - lTempWidth);
        lRGBFramePtr1 += ((wndWidth << 1) - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}


/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr1toColor16MU_709_FR
Description		: Converts YUV422 LE (YVYU) Chroma1 Interleaved to XRGB (8:8:8:8) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr1toColor16MU_709_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint32 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
 
    lRGBFramePtr = (uint32*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

			lCb2 = lYuyvPtr[7];
			lCr2 = lYuyvPtr[5];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[2];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)lTemp4;

            lCr2 -= 128;
            lCb2 -= 128;

            lTemp1 = (25801 * lCr2) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb2) + (7670 * lCr2)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb2) >> COLOR_CONV_PRECISION;
            
            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;
        }

            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (25801 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((3072 * lCb1) + (7670 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (30397 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[2];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[0] = (uint32)lTemp4;

            /*Second Pixel*/            
			lY1 = lYuyvPtr[0];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R component*/
            lTemp = lY1 + lTemp1;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 16;

            lRGBFramePtr[1] = (uint32)lTemp4;

			lYuyvPtr += 4;
            lRGBFramePtr += 2;

		if(extraCol)
		{
			*lRGBFramePtr = lRGBFramePtr[-1];
			 lRGBFramePtr++;
		}

		lYuyvPtr +=  ((lLumWidth - lWidth) << 1);
        lRGBFramePtr  += (wndWidth - lTempWidth);
    }

	if(extraRow)
	{
		lRGBFramePtr1 = lRGBFramePtr - wndWidth;
		for(j = 0; j < lWidth; j += 2)
		{
			*lRGBFramePtr++ = *lRGBFramePtr1++;
			*lRGBFramePtr++ = *lRGBFramePtr1++;
		}
		if(extraCol)
		{
			*lRGBFramePtr = *lRGBFramePtr1;
		}
	}
	return;
}

/*
******************************************************************************
Name            : sEmz_VDec_YUV422LEChr1toColor16MU_601_5_FR
Description		: Converts YUV422 LE (YVYU) Chroma1 Interleaved to XRGB (8:8:8:8) Interleaved format.
Parameter       : tBaseVideoFrame *srcImage	: Pointer to the source frame (i/p),
                  uint8 *dstImage			: Pointer to rgb data (o/p).
				  tWndParam *srcWindow		: Pointer to structure containing source window
											  parameters like xOffset,yOffset,cropWidth,
											  cropHeight. (i/p)
				  tWndParam *dstWindow		: Pointer to structure containing destination window
											  parameters like xOffset,yOffset,windWidth,
										      windHeight. (i/p)
Return Value    : void
******************************************************************************
*/

void sEmz_VDec_YUV422LEChr1toColor16MU_601_5_FR
		(tBaseVideoFrame *srcImage, uint8* dstImage,
		 tWndParam* srcWindow, tWndParam* dstWindow)
{
    uint32 *lRGBFramePtr, *lRGBFramePtr1;
    uint8  *lYuyvPtr;
    int32  lLumWidth, lWidth, lHeight, lTempWidth;
    int32  lY1, lCr1, lCb1, lCr2, lCb2;
    int32  lTemp, lTemp1, lTemp2, lTemp3, lTemp4;
    int32  i, j, extraCol, extraRow;
	int32 srcXOffset,srcYOffset,dstXOffset,dstYOffset,
		  cropWidth,cropHeight,wndWidth,wndHeight;

	srcXOffset = srcWindow->xOffset;
	srcYOffset = srcWindow->yOffset;
	cropWidth  = srcWindow->wndWidth;
	cropHeight = srcWindow->wndHeight;

	dstXOffset = dstWindow->xOffset;
	dstYOffset = dstWindow->yOffset;
	wndWidth   = dstWindow->wndWidth;
	wndHeight  = dstWindow->wndHeight;

	if ((srcImage->width - srcXOffset) >= cropWidth)
	{
		lWidth = cropWidth;
	}
	else
	{
		lWidth = srcImage->width - srcXOffset;
	}

	if ((srcImage->height - srcYOffset) >= cropHeight)
	{
		lHeight = cropHeight;
	}
	else
	{
		lHeight = srcImage->height - srcYOffset;
	}

	if (lWidth > (wndWidth - dstXOffset))
	{
		lWidth = wndWidth - dstXOffset;
	}

	if (lHeight > (wndHeight - dstYOffset))
	{
		lHeight = wndHeight - dstYOffset;
	}

	extraCol = lWidth & 0x01;
	extraRow = lHeight & 0x01;

	lTempWidth = lWidth;
	lWidth = (lWidth >> 1) << 1;
	lHeight = (lHeight >> 1) << 1;

    lLumWidth = (srcImage->width >> 1) << 1;
    lYuyvPtr  = srcImage->lum + (srcYOffset * (lLumWidth << 1)) + (srcXOffset << 1);
 
    lRGBFramePtr = (uint32*)(dstImage) + (dstYOffset * wndWidth) + dstXOffset;

    for(i = 0; i < lHeight; i++)
    {
        for(j = 0; j < (lWidth - 2); j += 2)
        {
            lCb1 = lYuyvPtr[3];
            lCr1 = lYuyvPtr[1];

			lCb2 = lYuyvPtr[7];
			lCr2 = lYuyvPtr[5];

			lCr2 = (lCr1 + lCr2) >> 1;
			lCb2 = (lCb1 + lCb2) >> 1;

            lCr1 -= 128;
            lCb1 -= 128;

            lTemp1 = (22973 * lCr1) >> COLOR_CONV_PRECISION;
            lTemp2 = ((5637 * lCb1) + (11699 * lCr1)) >> COLOR_CONV_PRECISION;
            lTemp3 = (29032 * lCb1) >> COLOR_CONV_PRECISION;

            /*First Pixel*/
			lY1 = lYuyvPtr[2];

            /*B component*/
            lTemp = lY1 + lTemp3;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 = (uint8) lTemp;

            /*G component*/
            lTemp = lY1 - lTemp2;
            if (lTemp < 0)
                lTemp = 0;
            if (lTemp > 255)
                lTemp = 255;
            lTemp4 |= lTemp << 8;

			/*R co