// Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Part of the MVS Application for TechView
//


#ifndef MVSAPPUI_H
#define MVSAPPUI_H


#include <mda/common/controller.h>
#include <flogger.h>
#include <techview/eikdialg.h>

#include "MVSApp.h"
#include "MVSAppView.h"
#include "audioplayagent.h"
#include "audiorecordagent.h"
#include "videoplayagent.h"
#include "videorecordagent.h"
#include "SettingsManager.h"

const TInt KMaxExtensionSize = 16;
const TInt KMaxDisplayLabelSize = 32;
const TInt KMaxDollarPaddingBufferSize = 256;
const TInt KErrorTextLength = 80;

//forward declariotions.
//The volume dialog class, used to increase/decrease volume.
class CMVSVolumeDialog;
//The balance dialog class, used to set the balance to right/left/centre. 
class CMVSBalanceDialog;
//The repeats dialog class, used to set the number of times a clip has to be played back, along with the delay between the playback.
class CMVSRepeatDialog;
//The Controller selction dialog class, used to select the format and the controller,before recording.
class CMVSSelectPluginsDialog;
//The SaveAs dialog class, used to input the file name in which the recorded data would be stored.
class CMVSSaveAsDialog;
//The MetaInfo Editing dialog class, used to edit the Metadata info for a clip.
class CMVSEditMetaInfoDialog;
//The audio controller settings dialog class, used to set controller specific features like bitrates,samplerates,channels etc.
class CMVSConfigAudioFormatDialog;
//The system info dialog class,used to display a list of all the supported controllers and codecs by the system.
class CMVSSystemInfoDialog;
//The video Setting dialog class, used to set the video playing/recording properties such as Rotation and Cropping.
class CMVSVideoSettingDialog;
//The audio Setting dialog class, used to set the audio playing properties such as priority preferences,repeats etc.
class CMVSAudioSettingDialog;
//The Play Window dialog class, used to set the play window for a audio clip, specifying the start and end position.
class CMVSSetPlayWindowDialog;
//The crop window setting class, used to set the cropping position for a recorded clip.
class CMVSCropDialog;
//The video controller settings dialog class, used to set controller specific features like framerates,framsize,codecs etc.
class CMVSConfigVideoFormatDialog;
//The timer class, used to refresh the timer in the app periodically,while playing/recording a clip.
class CMVSViewTicker;
//The MetaInfo viewing dialog class, used to view the Metadata info of a clip.
class CMVSViewMetaInfoDialog;
//The class provides the interface to set the video output screen.
class CMVSMultipleScreenDialog;
//This class used to register the application for AP&R
class CMVSResourceNotifyDialog;

class CMVSVideoControl;

//The main class that links to all the dialog windows in the application. This class implements the HandleCommandL() 
//function that handles any input generated by the user on the UI,and calls the respective dialouge.It acts as an interface
//between all the dialouges and the user.Also this class is responsible for processing the commands and linking with
//the agents to the UI.
class CMVSAppUi : public CEikAppUi, MMVSClientObserver
	{
public:
    void ConstructL();
    ~CMVSAppUi();
    CMVSAppUi();
    void SetRepeats(TInt aNoRepeats, TTimeIntervalMicroSeconds aDelay);
    void SetBalanceL(TInt aBalance);
    void SetVolumeL(TInt aVolume, TTimeIntervalMicroSeconds aRamp);
    //for audio aMediaType = 0; for video aMediaType = 1;
	TInt GetExtensionListL(CDesCArrayFlat* aExtArray,TBool aMediaType);
	//for audio aMediaType = 0; for video aMediaType = 1;
	TInt GetPluginListL(TInt8 aExtIdx,CDesCArrayFlat* aExtArray,CDesCArrayFlat* aPluginArray,TBool aMediaType);
	void SetMetaDataL(RPointerArray<CMMFMetaDataEntry> aMetaArray);
    void GetMetaDataL(RPointerArray<CMMFMetaDataEntry>& aMetaArray);
    void SelectedPluginIdx(TInt aIdx);
	void SelectedExtension(TDesC16& aDes);
	void GetSupportedBitRatesL(RArray <TUint>& aBitRateArray); 
	void GetSupportedSampleRatesArrayL(RArray<TUint>& aSampleRatesArray);
	void GetSupportedNoChannelsArrayL(RArray<TUint>& aNoChannelsArray);
	void GetSupportedCodecsArrayL(RArray<TFourCC>& aCodecsArray);
	void SelectedMedia(TBool aMediaType);
	void SetSampleRateL(TUint aSampleRate);
    void SetChannelsL(TUint aNumberOfChannels);
    void SetBitRateL(TUint aBitRate);
    void SetCodecsL(TFourCC aDataType);
    void GetSupportedFrameRatesL(RArray <TReal32>& aFrameRateArray);
	void GetSupportedFrameSizeArrayL(RArray <TSize>& aFrameRateArray);
	TInt GetSystemInfoL(CDesCArrayFlat* aPluginArray);
	void SetVideoFrameRateL(TReal32 aFrameRate);
	void SetVideoFrameSizeL(TSize aFrameSize);
	void SetAudioEnabledL(TBool aAudioEnabled);
	void SetRotationL(TVideoRotation aRotation);
	
 	void SetScaleFactorL(TReal32 aScaleWidth,TReal32 aScaleHeight,TBool aAntiAliasFiltering);
 	void GetScaleFactorL(TReal32& aScaleWidth, TReal32& aScaleHeight, TBool& aAntiAliasFiltering);

 	void SetCropRegionL(const TRect& aCropRegion);
 	void GetCropRegionL(TRect& aCropRegion);
 	
 	void SetVideoExtent(const TRect& aVideoExtent);
 	void SetWindowClippingRect(const TRect& aWindowClipRect);
 	void SetOverlayTextL(const TDesC& aOverlayText); 	
    const TDesC& OverlayText() const;	
    
    void SetAutoScaleL(TAutoScaleType aAutoScaleType, TInt aHorizPos, TInt aVertPos);
    void GetAutoScale(TAutoScaleType& aScaleType, TInt& aHorizPos, TInt& aVertPos);
 	
	void GetSupportedVideoTypesL(CDesC8ArrayFlat& aMimeArray); 
 	void SetVideoTypeL(const TDesC8 &aType);
 	void SetPriorityL(TInt aPriority, TMdaPriorityPreference aPriorityPreference);
    void SetCropL(TTimeIntervalMicroSeconds aCropStart,TBool aCropFromBeginning);
    TBool SetPlayWindow(TTimeIntervalMicroSeconds aStart,TTimeIntervalMicroSeconds aEnd);
    void WriteAudioDataL(CMVSConfigAudioFormatDialog* apAudioFormat,
				  	 const TUid& aUid);
	void WriteVideoDataL(CMVSConfigVideoFormatDialog* apVideoFormatDlg,
					 const TUid& aUid);
	void UpdatePositionViewL();
	void InternalizeL(RReadStream& aStream);
	void ExternalizeL(RWriteStream& aStream);
	void SetPosition(TTimeIntervalMicroSeconds& aPos);
	void SetMaxFileSize(TInt& aVal);
	void SetOutputScreen(TInt aScreenNumber);
	void RegisterForNotification(TBool aRegisterd);
	void SetPip(TBool aPip);
	void SetCrp(TBool aCrp);
private:
	inline void FileOpenL();
	inline void FileOpenForRecordL();
    void FileClose();
    TTimeIntervalMicroSeconds GetCropStart() const;
    TTimeIntervalMicroSeconds GetCropEnd() const;
    void InitializeMetaArrayL();
	TReal32 GetVideoFrameRateL();
	void SaveAsDialogL();
	void DetermineFinalFNameL();
 	TVideoRotation GetRotationL();
	void LogErrors(TInt aError);
	void Reset();
    void HandleCommandL(TInt aCommand); //Handles command invocations
	void BuildDollarDesFromArrayL(TDes& aDollarDes);
    void PopulateInfoWindowDataL(TMVSState aState);
    //from MMVSClientObserver
    void UpdateStateChange(TMVSState aState, TInt aError);
    void MvsResourceNotification(const TDesC8& aNotificationData);
    //Dynamically alter the availability of controls in the menu by
    // 'dimming' and 'undimming' them.
    void DynInitMenuPaneL(TInt aResourceId, CEikMenuPane* aMenuPane); //Menu set-up
    void UpdateDisplayL(TMVSState aState);
    void ConvertTimeToDes(TTimeIntervalMicroSeconds aPosition,
                                        TDes& aDes);
    TPoint DrawBorders(const TSize& aSize) const;
    void StopViewFinder();
   
   	void PrepareVideoControlsL();

private:
    //The view
    CMVSAppView* iAppView; //The application view
    CMVSVolumeDialog* iVolumeDialog;
    CMVSBalanceDialog* iBalanceDialog;
    CMVSRepeatDialog* iRepeatDialog;
    CMVSSelectPluginsDialog* iSelectPluginsDialog;
    CDesCArrayFlat* iPluginArray; //Array of supported plugins
    CDesCArrayFlat* iExtArray; //Array of supported Extensions
    CDesCArrayFlat* iCodecArray;//Array of supported Codecs
    CMVSSaveAsDialog* iSaveAsDialog;
   // CMVSSetPriorityDialog* iSetAudioPriorityDialog;
    CMVSEditMetaInfoDialog* iEditMetaInfoDialog;
    CMVSViewMetaInfoDialog* iViewMetaInfoDialog;
    CMVSConfigAudioFormatDialog* iConfigFormatDialog;
    CMVSConfigVideoFormatDialog* iVideoFormatDialog; 
    CMVSSystemInfoDialog* iSystemInfo;
    CMVSVideoSettingDialog* iVideoSetting;
    CMVSAudioSettingDialog* iAudioSetting;
    CMVSSetPlayWindowDialog* iSetPlayWindow;
    TFileName iSrcFName;
    TFileName iRecFName;
    RPointerArray<CMMFMetaDataEntry> iMetaArray;
    CMMFMetaDataEntry* iMetaTitle;
    CMMFMetaDataEntry* iMetaAuthor;
    CMMFMetaDataEntry* iMetaCopyright;
    CMMFMetaDataEntry* iMetaRevision;
    CMMFMetaDataEntry* iMetaCategory;
    CMMFMetaDataEntry* iMetaComments;
    //MVSClient
    CDesCArrayFlat* iPluginNames;
    CMVSAudioPlayAgent* iAudioPlayAgent;
    CMVSAudioRecordAgent* iAudioRecordAgent;
    CMVSVideoPlayAgent* iVideoPlayAgent;
    CMVSVideoRecordAgent* iVideoRecordAgent;
    CMVSControllerPluginInfo* iPluginInfo;
    CMVSCropDialog* iCropDialog;
    CMVSViewTicker* iViewTicker;
    CMVSMultipleScreenDialog* iSetScreen;
    CMVSResourceNotifyDialog* iRegisterForNotification;
    CSettingsManager* iSettingManager;
    RArray<TUid> iUidArray;
 	RArray<TUid> iAudioUidArray;
 	RArray<TUid> iAudioPlayUidArray;
 	RArray<TUid> iVideoUidArray;
 	TInt iSelectedPluginIdx;		 
 	TInt iPluginsCnt;
 	TBool iMediaType;
 	TUid iControllerUid;
 	TBuf<KMaxExtensionSize> iControllerExt;
 	TInt iRec;	 
  	TInt iVolumeOrGain;
    TTimeIntervalMicroSeconds iRamp;
    TInt iMaxVolume;
    TInt iBalance;
    TMVSMode iMode;
    TInt iPriority;
    TMdaPriorityPreference iPriorityPreference;
   	TInt iNoRepeats;
   	TTimeIntervalMicroSeconds iStart;
   	TTimeIntervalMicroSeconds iEnd;
   	TTimeIntervalMicroSeconds iCropStart;
   	TTimeIntervalMicroSeconds iCropEnd;
   	TTimeIntervalMicroSeconds iCropPosition;
   	TTimeIntervalMicroSeconds iClipLength;
   	TBool iCropFromBeginning;
   	TFileName iDestFilename;
   	TTimeIntervalMicroSeconds iRepeatDelay;
    TBuf<KMaxDisplayLabelSize> iDisplayState;
    TFileName iDisplayFName;
    TBuf<KMaxDisplayLabelSize> iDisplayTime;
    CDesCArrayFlat iMainWindowText;
    TBuf<KMaxDollarPaddingBufferSize> iDollarDes;
    TTimeIntervalMicroSeconds iTimeElapsed;
    TReal32 iVideoFrameRate;
    TVideoRotation iVideoRotation;
    TUint iBitRate;
    TUint iSampleRate;
    TUint iChannels;
    TVideoRotation iRotation;
    TSize iFrameSize;
    TBool iFileReplace;
    TTimeIntervalMicroSeconds iDuration;
 	TBool iAutoplay;
 	TBool iOpeningForRecord;
 	TMVSState iState;
 	RFileLogger iLogger;
 	RFs iLogs;
 	CEikButtonGroupContainer* iButtons;
 	TBool iProceed;
 	TBool iRecordLimitSet;
 	TInt iMaxFileBuffer;
	TInt iScreenNumber;
 	TBool iRegistered;
 	TBool iAlreadyRegistered;
 	TBool iAudioEnabled;
    TRect iVideoExtent;
    TRect iWindowClipRect;
    RBuf  iOverlayText;
    TAutoScaleType iAutoScaleType;
    TInt iAutoScaleHorizPos; 
    TInt iAutoScaleVertPos;
  
	TBool iPip;
	TBool iCrp;
	TBool iVideoExtentSet;
	TBool iWindowClipRectSet;

	CMVSVideoControl* iVideoCtl;
	// Controls displaying video, window owning
	RPointerArray<CMVSVideoControl> iVideoCtls;

	TBool iDisplayAdded;
 	};
 
#endif  MVSAPPUI_H
