// Copyright (c) 2002-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Reference scanlines produced by the PNG encoder, in a variety of formats
// 
//

#ifndef __PNGREFSCANLINES_H__
#define __PNGREFSCANLINES_H__

// Reference scanlines
// 1 bit greyscale (mono) type 0
const TUint8 KSubCodecRef_1bit_t0[] = { 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
										0xFF, 0xFA, 0x2F, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA,
										0xA8, 0x2A, 0xAA, 0xAB, 0xFF, 0xFF, 0xFF, 0xFF,
										0xFF, 0x80 };
const TInt KSubCodecRef_1bit_t0_Length = 26;

// 1 bit greyscale (mono) type 3
const TUint8 KSubCodecRef_1bit_t3[] = { 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
										0xFF, 0xF8, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
										0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF,
										0xFF, 0xFF };
const TInt KSubCodecRef_1bit_t3_Length = 26;

// 2 bit greyscale type 0
const TUint8 KSubCodecRef_2bit_t0[] = { 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
										0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
										0xFF, 0xFF, 0x94, 0x05, 0x6A, 0x55, 0x55, 0x55,
										0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x45,
										0x50, 0x15, 0x55, 0x44, 0x55, 0x55, 0x5A, 0xBF,
										0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
										0xFF, 0xFF };
const TInt KSubCodecRef_2bit_t0_Length = 50;

// 2 bit greyscale type 3
const TUint8 KSubCodecRef_2bit_t3[] = { 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
										0xFB, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
										0xBF, 0xFF, 0x95, 0x55, 0x6A, 0x55, 0x55, 0x55,
										0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
										0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x5A, 0xAF,
										0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF,
										0xFF, 0xFF };
const TInt KSubCodecRef_2bit_t3_Length = 50;

// 4 bit grayscale type 0
const TUint8 KSubCodecRef_4bit_t0[] = { 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
										0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
										0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
										0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
										0xFF, 0xFF, 0xFF, 0xE1, 0x1C, 0x0C, 0x11, 0xDE,
										0xEE, 0xD1, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
										0x11, 0x11, 0x11, 0x1D, 0x1B, 0xD1, 0x11, 0x11,
										0x11, 0x1D, 0xBD, 0xB1, 0x11, 0x1C, 0x11, 0x11,
										0x0C, 0x01, 0x11, 0x11, 0x11, 0x1C, 0x1C, 0x11,
										0x11, 0x11, 0x11, 0x11, 0xEE, 0xEF, 0xFF, 0xFF,
										0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
										0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
										0xFF, 0xFF };
const TInt KSubCodecRef_4bit_t0_Length = 98;

// 4 bit colour type 3
const TUint8 KSubCodecRef_4bit_t3[] = { 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
										0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
										0xEF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF,
										0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF,
										0xFF, 0xFF, 0xFF, 0xE1, 0x11, 0x11, 0x11, 0x1E,
										0xEE, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
										0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
										0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
										0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
										0x11, 0x11, 0x11, 0x11, 0xEE, 0xEE, 0xFF, 0xFF,
										0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
										0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
										0xFF, 0xFF };
const TInt KSubCodecRef_4bit_t3_Length = 98;

// 8 bit grayscale type 0
const TUint8 KSubCodecRef_8bit_t0[] = { 0x00, 0xEE, 0xEE, 0xDD, 0xDD, 0xDD, 0xEE, 0xDD,
										0xEE, 0xEE, 0xDD, 0xEE, 0xDD, 0xEE, 0xEE, 0xDD,
										0xEE, 0xDD, 0xEE, 0xDD, 0xEE, 0xDD, 0xDD, 0xDD,
										0xEE, 0xDD, 0xEE, 0xDD, 0xEE, 0xDD, 0xEE, 0xC5,
										0xDD, 0xDD, 0xEE, 0xEE, 0xDD, 0xEE, 0xC5, 0xDD,
										0xDD, 0xDD, 0xD2, 0xEE, 0xEE, 0xDD, 0xEE, 0xDD,
										0xF2, 0xDD, 0xDD, 0xEE, 0xDD, 0xEE, 0xEE, 0xDD,
										0xEE, 0xDD, 0xDD, 0xEE, 0xDD, 0xC5, 0xDD, 0xEE,
										0xDD, 0xEE, 0xDD, 0xEE, 0xEE, 0xBF, 0x55, 0x55,
										0x39, 0x33, 0x39, 0x66, 0x44, 0x59, 0x88, 0xAA,
										0x88, 0x59, 0x55, 0x6C, 0x77, 0x6C, 0x66, 0x6C,
										0x77, 0x6C, 0x6C, 0x6C, 0x66, 0x66, 0x66, 0x66,
										0x77, 0x77, 0x66, 0x6C, 0x66, 0x66, 0x59, 0x66,
										0x46, 0x59, 0x6C, 0x66, 0x66, 0x55, 0x55, 0x6C,
										0x55, 0x55, 0x59, 0x46, 0x59, 0x46, 0x55, 0x44,
										0x44, 0x44, 0x39, 0x44, 0x44, 0x44, 0x44, 0x33,
										0x39, 0x33, 0x44, 0x44, 0x44, 0x44, 0x44, 0x55,
										0x44, 0x55, 0x39, 0x44, 0x39, 0x55, 0x44, 0x44,
										0x55, 0x55, 0x44, 0x55, 0x66, 0x66, 0x66, 0x8C,
										0x88, 0x9F, 0xCC, 0xF2, 0xDD, 0xD2, 0xDD, 0xDD,
										0xEE, 0xDD, 0xEE, 0xC5, 0xEE, 0xDD, 0xF2, 0xDD,
										0xEE, 0xDD, 0xDD, 0xEE, 0xDD, 0xEE, 0xDD, 0xEE,
										0xDD, 0xD2, 0xEE, 0xC5, 0xDD, 0xDD, 0xF2, 0xDD,
										0xD2, 0xDD, 0xDD, 0xEE, 0xDD, 0xEE, 0xDD, 0xEE,
										0xDD, 0xEE };
const TInt KSubCodecRef_8bit_t0_Length = 194;

// 8 bit colour type 2
const TUint8 KSubCodecRef_8bit_t2[] = { 0x00, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xDD,
										0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
										0xEE, 0xEE, 0xEE, 0xDD, 0xDD, 0xDD, 0xEE, 0xEE,
										0xEE, 0xEE, 0xEE, 0xEE, 0xDD, 0xDD, 0xDD, 0xEE,
										0xEE, 0xEE, 0xDD, 0xDD, 0xDD, 0xEE, 0xEE, 0xEE,
										0xEE, 0xEE, 0xEE, 0xDD, 0xDD, 0xDD, 0xEE, 0xEE,
										0xEE, 0xDD, 0xDD, 0xDD, 0xEE, 0xEE, 0xEE, 0xDD,
										0xDD, 0xDD, 0xEE, 0xEE, 0xEE, 0xDD, 0xDD, 0xDD,
										0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xEE, 0xEE,
										0xEE, 0xDD, 0xDD, 0xDD, 0xEE, 0xEE, 0xEE, 0xDD,
										0xDD, 0xDD, 0xEE, 0xEE, 0xEE, 0xDD, 0xDD, 0xDD,
										0xEE, 0xEE, 0xEE, 0x99, 0xCC, 0xFF, 0xDD, 0xDD,
										0xDD, 0xDD, 0xDD, 0xDD, 0xEE, 0xEE, 0xEE, 0xEE,
										0xEE, 0xEE, 0xDD, 0xDD, 0xDD, 0xEE, 0xEE, 0xEE,
										0x99, 0xCC, 0xFF, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
										0xDD, 0xDD, 0xDD, 0xDD, 0xCC, 0xCC, 0xFF, 0xEE,
										0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xDD, 0xDD, 0xDD,
										0xEE, 0xEE, 0xEE, 0xDD, 0xDD, 0xDD, 0xCC, 0xFF,
										0xFF, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xEE,
										0xEE, 0xEE, 0xDD, 0xDD, 0xDD, 0xEE, 0xEE, 0xEE,
										0xEE, 0xEE, 0xEE, 0xDD, 0xDD, 0xDD, 0xEE, 0xEE,
										0xEE, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xEE,
										0xEE, 0xEE, 0xDD, 0xDD, 0xDD, 0x99, 0xCC, 0xFF,
										0xDD, 0xDD, 0xDD, 0xEE, 0xEE, 0xEE, 0xDD, 0xDD,
										0xDD, 0xEE, 0xEE, 0xEE, 0xDD, 0xDD, 0xDD, 0xEE,
										0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x99, 0xCC, 0xCC,
										0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x33, 0x33,
										0x66, 0x33, 0x33, 0x33, 0x33, 0x33, 0x66, 0x66,
										0x66, 0x66, 0x44, 0x44, 0x44, 0x33, 0x66, 0x66,
										0x88, 0x88, 0x88, 0xAA, 0xAA, 0xAA, 0x88, 0x88,
										0x88, 0x33, 0x66, 0x66, 0x55, 0x55, 0x55, 0x66,
										0x66, 0x99, 0x77, 0x77, 0x77, 0x66, 0x66, 0x99,
										0x66, 0x66, 0x66, 0x66, 0x66, 0x99, 0x77, 0x77,
										0x77, 0x66, 0x66, 0x99, 0x66, 0x66, 0x99, 0x66,
										0x66, 0x99, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
										0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x77, 0x77,
										0x77, 0x77, 0x77, 0x77, 0x66, 0x66, 0x66, 0x66,
										0x66, 0x99, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
										0x33, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x33,
										0x66, 0x33, 0x66, 0x66, 0x66, 0x66, 0x99, 0x66,
										0x66, 0x66, 0x66, 0x66, 0x66, 0x55, 0x55, 0x55,
										0x55, 0x55, 0x55, 0x66, 0x66, 0x99, 0x55, 0x55,
										0x55, 0x55, 0x55, 0x55, 0x33, 0x66, 0x66, 0x66,
										0x33, 0x66, 0x33, 0x66, 0x66, 0x66, 0x33, 0x66,
										0x55, 0x55, 0x55, 0x44, 0x44, 0x44, 0x44, 0x44,
										0x44, 0x44, 0x44, 0x44, 0x33, 0x33, 0x66, 0x44,
										0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
										0x44, 0x44, 0x44, 0x33, 0x33, 0x33, 0x33, 0x33,
										0x66, 0x33, 0x33, 0x33, 0x44, 0x44, 0x44, 0x44,
										0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
										0x44, 0x44, 0x44, 0x55, 0x55, 0x55, 0x44, 0x44,
										0x44, 0x55, 0x55, 0x55, 0x33, 0x33, 0x66, 0x44,
										0x44, 0x44, 0x33, 0x33, 0x66, 0x55, 0x55, 0x55,
										0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x55, 0x55,
										0x55, 0x55, 0x55, 0x55, 0x44, 0x44, 0x44, 0x55,
										0x55, 0x55, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
										0x66, 0x66, 0x66, 0x66, 0x99, 0x99, 0x88, 0x88,
										0x88, 0x99, 0x99, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC,
										0xFF, 0xFF, 0xDD, 0xDD, 0xDD, 0xCC, 0xCC, 0xFF,
										0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xEE, 0xEE,
										0xEE, 0xDD, 0xDD, 0xDD, 0xEE, 0xEE, 0xEE, 0x99,
										0xCC, 0xFF, 0xEE, 0xEE, 0xEE, 0xDD, 0xDD, 0xDD,
										0xCC, 0xFF, 0xFF, 0xDD, 0xDD, 0xDD, 0xEE, 0xEE,
										0xEE, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xEE,
										0xEE, 0xEE, 0xDD, 0xDD, 0xDD, 0xEE, 0xEE, 0xEE,
										0xDD, 0xDD, 0xDD, 0xEE, 0xEE, 0xEE, 0xDD, 0xDD,
										0xDD, 0xCC, 0xCC, 0xFF, 0xEE, 0xEE, 0xEE, 0x99,
										0xCC, 0xFF, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
										0xCC, 0xFF, 0xFF, 0xDD, 0xDD, 0xDD, 0xCC, 0xCC,
										0xFF, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xEE,
										0xEE, 0xEE, 0xDD, 0xDD, 0xDD, 0xEE, 0xEE, 0xEE,
										0xDD, 0xDD, 0xDD, 0xEE, 0xEE, 0xEE, 0xDD, 0xDD,
										0xDD, 0xEE, 0xEE, 0xEE, 0x50, 0x06, 0x00, 0x00,
										0x00, 0x00, 0x00, 0x00 };
const TInt KSubCodecRef_8bit_t2_Length = 580;

const TUint8 KSubCodecRef_8bit_t3[] = { 0x00, 0x93, 0x93, 0x92, 0x92, 0x92, 0x93, 0x92,
										0x93, 0x93, 0x92, 0x93, 0x92, 0x93, 0x93, 0x92,
										0x93, 0x92, 0x93, 0x92, 0x93, 0x92, 0x92, 0x92,
										0x93, 0x92, 0x93, 0x92, 0x93, 0x92, 0x93, 0xF7,
										0x92, 0x92, 0x93, 0x93, 0x92, 0x93, 0xF7, 0x92,
										0x92, 0x92, 0xF8, 0x93, 0x93, 0x92, 0x93, 0x92,
										0xFE, 0x92, 0x92, 0x93, 0x92, 0x93, 0x93, 0x92,
										0x93, 0x92, 0x92, 0x93, 0x92, 0xF7, 0x92, 0x93,
										0x92, 0x93, 0x92, 0x93, 0x93, 0xD3, 0x6F, 0x6F,
										0x4F, 0x2B, 0x4F, 0x56, 0x6E, 0x55, 0x8F, 0x90,
										0x8F, 0x55, 0x6F, 0xA2, 0x70, 0xA2, 0x56, 0xA2,
										0x70, 0xA2, 0xA2, 0xA2, 0x56, 0x56, 0x56, 0x56,
										0x70, 0x70, 0x56, 0xA2, 0x56, 0x56, 0x55, 0x56,
										0x50, 0x55, 0xA2, 0x56, 0x56, 0x6F, 0x6F, 0xA2,
										0x6F, 0x6F, 0x55, 0x50, 0x55, 0x50, 0x6F, 0x6E,
										0x6E, 0x6E, 0x4F, 0x6E, 0x6E, 0x6E, 0x6E, 0x2B,
										0x4F, 0x2B, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6F,
										0x6E, 0x6F, 0x4F, 0x6E, 0x4F, 0x6F, 0x6E, 0x6E,
										0x6F, 0x6F, 0x6E, 0x6F, 0x56, 0x56, 0x56, 0xA8,
										0x8F, 0xCD, 0xD4, 0xFE, 0x92, 0xF8, 0x92, 0x92,
										0x93, 0x92, 0x93, 0xF7, 0x93, 0x92, 0xFE, 0x92,
										0x93, 0x92, 0x92, 0x93, 0x92, 0x93, 0x92, 0x93,
										0x92, 0xF8, 0x93, 0xF7, 0x92, 0x92, 0xFE, 0x92,
										0xF8, 0x92, 0x92, 0x93, 0x92, 0x93, 0x92, 0x93,
										0x92, 0x93 };
const TInt KSubCodecRef_8bit_t3_Length = 194;

#endif // __PNGREFSCANLINES_H__
