// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#ifndef SURFACEEVENTHANDLER_H
#define SURFACEEVENTHANDLER_H

#include <mmf/common/mmfvideo.h>

class TSurfaceId;

/**
Clients intending to use window-less graphics surfaces need to handle graphics surface specific events
generated by the MultiMedia Framework (MMF). The MMMFSurfaceEventHandler interface allows client to receive
these graphics surface specific events. A client intending to use the CVideoPlayerUtility2::AddDisplayL API
must implement this interface.

@see CVideoPlayerUtility2

@publishedPartner
@prototype
*/

class MMMFSurfaceEventHandler
	{
public:
	/**
	MmsehSurfaceCreated is called when a graphics surface has been created on an added display. 
	Clients will only be notified of surfaces created on displays that they have added. 
	MMF still owns the graphics surface and can request the surface to be released by the client. 
	Before this method is called by CVideoPlayerUtility2 the graphics surface is registered with
	the Window Server.

	@see TVideoAspectRatio

	@param aDisplayId Display id the surface was created on.
	@param aId surface Id of graphics surface created.
	@param aCropRect Crop rectangle. The crop rectangle is the area of graphics surface containing viewable video. 
	@param aAspectRatio Aspect ratio of video.
	*/

	virtual void MmsehSurfaceCreated(TInt aDisplayId, const TSurfaceId& aId, const TRect& aCropRect, TVideoAspectRatio aAspectRatio) = 0;

	/**
	MmsehSurfaceParametersChanged is called when either crop rectangle or aspect ratio of the surface changes.

	@param aId Surface id of graphics surface with changed parameters.
	@param aCropRect New crop rectangle, this may be identical to previous value. The crop rectangle is the area of graphics surface containing viewable video.
	@param aAspectRatio New aspect ratio of video, this may be identical to previous value.
	*/
	virtual void MmsehSurfaceParametersChanged(const TSurfaceId& aId, const TRect& aCropRect, TVideoAspectRatio aAspectRatio) = 0;

	/**
	MmsehSurfaceRemoved is called when the MultiMedia Framework indicates that the surface is to be removed.
	Clients should stop using the graphics surface identified by aId before returning from the callback. 
	Further, clients should be prepared to receive a MmsehSurfaceCreated callback event with a new graphics
	surface to use.

	@param aId Surface id of graphics surface to be removed.
	*/

	virtual void MmsehRemoveSurface(const TSurfaceId& aId) = 0;
	};

#endif // SURFACEEVENTHANDLER_H

