// Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Part of the MVS Application for TechView
//

#ifndef MVSSETPLAYWINDOWDIALOG_H
#define MVSSETPLAYWINDOWDIALOG_H

#include <techview/eikdialg.h>

class CMVSAppUi;//Forward Declaration

class CMVSSetPlayWindowDialog : public CEikDialog
	{
public:
    static void SetupDialogLD(TTimeIntervalMicroSeconds aStart,
                              TTimeIntervalMicroSeconds aEnd,
                              TTimeIntervalMicroSeconds aMaxDuration, CMVSAppUi* aAppUi);
    void PreLayoutDynInitL(); //seeds dialog controls

public:
	TTimeIntervalMicroSeconds iStart; //the Ramp
    TTimeIntervalMicroSeconds iEnd; //the clip length
    TTimeIntervalMicroSeconds iMaxDuration; 
    CMVSAppUi* iAppUi;
private:
	CMVSSetPlayWindowDialog(TTimeIntervalMicroSeconds aStart,
                   TTimeIntervalMicroSeconds aEnd,
                   TTimeIntervalMicroSeconds aMaxDuration, CMVSAppUi* aAudioAppUi);
    TBool OkToExitL(TInt aButtonId); //handles button presses for this dialog
	TKeyResponse OfferKeyEventL(const TKeyEvent& aKeyEvent, TEventCode aType);
    };

#endif MVSSETPLAYWINDOWDIALOG_H
