// Copyright (c) 1997-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Agent (agt) APIs.
// This file contains the APIs required to implement a basic agent for Symbian OS.  APIs for more advanced agents can be found in the header files referenced below.
// 
//

/**
 @file NIFAGT.H
 @sa CAgentSMBase.h
 @sa CAgentBase.h
 @publishedPartner
 @deprecated since v9.5. Use MCPRs/CPRs/SCPRs instead of agents.
*/

#if !defined(__NIFAGT_H__)
#define __NIFAGT_H__

#ifndef __NIFMAN_H__
#include <nifman.h>
#endif

#ifndef __NIFPRVAR_H__
#include <comms-infras/nifprvar.h>
#endif

#include <comms-infras/connectionsettings.h>
#include <cdbstore.h>




// Agent classes

class CNifAgentBase;
class CAgentAdapter;

class CNifAgentFactory : public CNifFactory
/**
 * The factory object used to create new instances of a agent.
 * An agent is packaged in a dll - nifman will call this class to create new instances of a agent.
 * @ingroup Agent
 *
 * @publishedPartner
 * @deprecated since v9.5. Use MCPRs/CPRs/SCPRs instead of agents.
 */
	{
friend class CAgentAdapter;

protected:
	/**
	 * Create a new instance of the agent specified by aName
	 * @param aName The name of the agent to be created
	 * @returns A pointer to a new instance of the agent
	 */
	virtual CNifAgentBase *NewAgentL(const TDesC& aName) = 0;

	/**
	 * Retrieve information about an agent
	 * @param aInfo On return, contains information about the agent
	 * @param aIndex An index into CNifAgentBase-derived objects in the agent, starting from 0.  It is up to the agent how it assigns indices to objects.
	 * @returns KErrNone, if successful; or one of the standard Symbian OS error codes
	 */
	virtual TInt Info(TNifAgentInfo& aInfo, TInt aIndex) const = 0;

	};

class MNifAgentNotify
/**
 * Interface from the agent to Nifman
 * @ingroup Nifman
 * @publishedPartner
 * @deprecated since v9.5. Use MCPRs/CPRs/SCPRs instead of agents.
 */
	{
public:
	/**
	 * Callback to indicate that the agent has finished its connection phase, and is ready to pass control to the nif
	 * @param aStatus The error code generated by this phase of connection startup
	 */
	virtual void ConnectComplete(TInt aStatus) = 0;

	/**
	 * Callback to indicate that the agent has performed the requested reconnection
	 * @note Obviously, this is only used in situations where the agent has received a request to reconnect
	 * @param aStatus The error code, if any, from the reconnection attempt
	 */
	virtual void ReconnectComplete(TInt aStatus) = 0;

	/**
	 * Indication that the agent has finished authenticating
	 * @param aStatus The error code, if any, from the reconnection attempt
	 */
	virtual void AuthenticateComplete(TInt aStatus) = 0;

	/**
	 * Callback from the agent to indicate that it has successfully started the connection
	 * @note This call will cause nifman to load and bind the nif
	 * @note This does not mean that the connection is ready for use by the nif yet - the nif is handed control after ConnectComplete()
	 */
	virtual void ServiceStarted() = 0;

	/**
	 *
	 */
	virtual void ServiceClosed() = 0;

	/**
	 *
	 */
	virtual void DisconnectComplete() = 0;

	/**
	 * Progress notification from an agent for a connection
	 * @param aStage The progress stage that has been reached
	 * @param aError Any errors that have occured
	 * @since v5.0
	 */
	virtual void AgentProgress(TInt aStage, TInt aError) = 0;

	/**
	 * Progress notification from an agent for a subconnection
	 * @note This function will not be called until agents support starting subconnections
	 * @param aSubConnectionUniqueId The subconnection to which this notification refers
	 * @param aStage The progress stage that has been reached
	 * @param aError Any errors that have occured
	 * @since v7.0s
	 */
	virtual void AgentProgress(TSubConnectionUniqueId aSubConnectionUniqueId, TInt aStage, TInt aError) = 0;

	/**
	 * Notification of an event from the nif
	 * @param aEvent The type of event that occured
	 * @param aInfo Any data associated with the event
 	 * @returns KErrNone if successful, otherwise one of the system-wide error codes
	 * @note SC with previous releases broken in v6.1 when first argument changed type
	 * @since
	 */
	virtual TInt Notification(TAgentToNifEventType aEvent, TAny* aInfo = NULL) = 0;

	/**
	 *
	 * @note Needs to be called by the agent when it gets an incoming call so that agent can wait for an incoming and do an outgoing at the same time, i.e. it waits for the incoming without NifMan's knowledge
	 * @since v6.1
	 */
	virtual TInt IncomingConnectionReceived() = 0;

	/**
	 * Indication that some parameter relating to a subconnection has changed in the agent eg. new subconnection opened, QoS changed
	 * @param aEventType The type of the event
 	 * @param aEvent The event which has occured
 	 * @param aEventData Any arguments or additional data to do with the event; the interpretation of this depends on the event
 	 * @param aSource An appropriate identifier of the source of the event - this will be used when one receiver is receiving events from many producers
 	 * @since v7.0s
	 */
	virtual void AgentEvent(TNetworkAdaptorEventType aEventType, TUint aEvent, const TDesC8& aEventData, TAny* aSource=0)=0;
	};

class MAgentSessionNotify
/**
 * Interface from agents to CNifSession
 * @ingroup Nifman
 * @publishedPartner
 * @deprecated since v9.5. Use MCPRs/CPRs/SCPRs instead of agents.
 * @note This used to be the interface used by both CNifAgentRef and the agent to communicate with CNifSession
 * @note It has now been altered so only the agent uses it, for ServiceChangeNotification(); ProgressNotification() has now been moved to the MNifSessionNotify interface
 * @note Agents should not have been calling ProgressNotification() anyway, they should call MNifAgentNotify::AgentProgress()
 */
	{
public:
	/**
	 *
	 */
	virtual void ServiceChangeNotification(TUint32 aId, const TDesC& aType) = 0;
	};

class MNifAgentExtendedManagementInterface
/**
 * Interface for extended RConnection functionality
 * Intended for derivation by agents wishing to support extended connection management functionality
 * @see Corresponding MNifIfExtendedManagementInterface for nifs wishing to support extended connection management functionality
 * @publishedPartner
 * @deprecated since v9.5. Use MCPRs/CPRs/SCPRs instead of agents.
 * @note Augments CNifAgentBase, which provides basic connection management functionality
 * @note To support this interface, clients must accept a Control(KCOLAgent, KCOGetAgentEMIPtr, TPckg<MNifIfExtendedManagementInterface*>) and return a pointer to a class that implements this interface
 * @note Until the APIs are correctly defined to support agents that start subconnetions, this class should also be derived in the nif
 */
	{
public:
	/**
	Find out the type of this connection (eg. CSD, GPRS, CDMA, Ethernet, some more specific subtype)

	@param aConnectionType On return, contains the type of the connection
	@return KErrNone, or one of the system-wide error codes
	*/
	virtual TInt GetInterfaceType(TConnectionType& aConnectionType)=0;

	/**
	Discover how many subconnections exist on an interface

	@note All interfaces must support at least one subconnection
	@param aCount On return, contains the number of subconnections that currently exist on this interface
	@return KErrNone, or one of the system-wide error codes
	*/
	virtual TInt EnumerateSubConnections(TUint& aCount)=0;

	/**
	Get information about a subconnection with no prior knowledge of the unique id of any subconnetion

	@note aSubConnectionInfo should contain a class derived from TSubConnectionInfo;
	the class should be suitable for type of interface being queried,
	however it is up to the interface to check this.
	@note The type of the class can be determined by checking the iConnectionType member
	@note Unique IDs for subconnections are on a per-nif basis.
	It is the responsibility of the nif or agent to generate these IDs and
	to ensure they are unique across the connection
	@param aIndex A number between one and the total number of subconnections
	returned by EnumerateSubConnections()
	@param aSubConnectionInfo Should contain a class derived from TSubConnectionInfo and
	suitable for the type of the interface being queried; on return,
	contains the class with all its members filled in
	@return KErrNone, or one of the system-wide error codes; in particular
	KErrArgument if the class type is unsuitable
	*/
	virtual TInt GetSubConnectionInfo(TUint aIndex, TDes8& aSubConnectionInfo)=0;

	/**
	Get information about the subconnection with the supplied unique ID

	@note aSubConnectionInfo should contain a class derived from TSubConnectionInfo;
	the class should be suitable for type of interface being queried,
	however it is up to the interface to check this.
	@note The type of the class can be determined by checking the iConnectionType member
	@param aSubConnectionInfo Should contain a class derived from
	TSubConnectionInfo and suitable for the type of the interface being queried,
	and with the iSubConnectionUniqueId member set to the appropriate unique ID
	@return KErrNone, or one of the system-wide error codes; in particular
	KErrArgument if the class type is unsuitable
	*/
	virtual TInt GetSubConnectionInfo(TDes8& aSubConnectionInfo)=0;
	};

class CNifAgentBase : public CBase
	/**
	 * Base class for agents.
	 * All agents derive from this base class; either directly or via another class that offers additional functionality.
	 * @sa CAgentBase; CStateMachineAgentBase (for v6.1 agx porting)
	 * @ingroup Agent
	 *
	 * @publishedPartner
	 * @deprecated since v9.5. Use MCPRs/CPRs/SCPRs instead of agents.
	 */
	{
friend class CNifAgentRef;
friend class CNifAgentRef2;
friend class CAgentAdapter;

public:
	/**
	 *
	 */
	IMPORT_C CNifAgentBase();

	/**
	 * @deprecated
	 * This version of the Control(TUint, TUint, TDes8&) function is now deprecated. DO NOT Override
	 * Use the version of CNifAgentBase::Control(TUint, TUint, TDes8&, RProcess) that takes four parameters
	 */
	IMPORT_C virtual TInt Control(TUint aOptionLevel, TUint aOptionName, TDes8& aOption);

	/**
	 *
	 */
	virtual void Info(TNifAgentInfo& aInfo) const = 0;

	/**
	 *
	 */
	virtual void Connect(TAgentConnectType aType) = 0;

	/**
	 *
	 */
	virtual void Connect(TAgentConnectType aType, CStoreableOverrideSettings* aOverrideSettings) = 0;

	/**
	 *
	 */
	virtual void CancelConnect() = 0;

	/**
	 *
	 */
	virtual void Reconnect() = 0;

	/**
	 *
	 */
	virtual void CancelReconnect() = 0;

	/**
	 *
	 */
	virtual void Authenticate(TDes& aUsername, TDes& aPassword) = 0;

	/**
	 *
	 */
	virtual void CancelAuthenticate() = 0;

	/**
	 *
	 */
	virtual void Disconnect(TInt aReason) = 0;

	/**
	 * Return any excess data was received during connection setup
	 * @param aBuffer On return, the buffer contains the excess data from the agent
	 * @returns KErrNone, if successful; otherwise, one of the standard Symbian OS error codes
	 */
	virtual TInt GetExcessData(TDes8& aBuffer) = 0;

	/**
	 * Notification of an event from the nif
	 * @param aEvent The type of event that occured
	 * @param aInfo Any data associated with the event
 	 * @returns KErrNone if successful, otherwise one of the system-wide error codes
 	 * @since v6.1
	 */
	virtual TInt Notification(TNifToAgentEventType aEvent, TAny* aInfo) = 0;

	/**
	 *
	 */
	virtual TInt IncomingConnectionReceived() = 0;

	/**
	 *
	 */
	virtual void GetLastError(TInt& aError) = 0;

	/**
	 *
	 */
	virtual TBool IsActive() const = 0;

	/**
	 *
	 */
	virtual TBool IsReconnect() const = 0;

	/**
	 *
	 */
	virtual void SetConnectionSettingsL(const TConnectionSettings& aSettings) = 0;

	/**
	 *
	 */
	virtual TConnectionSettings& ConnectionSettingsL() = 0;

	/**
	 *
	 */
	virtual void SetOverridesL(CStoreableOverrideSettings* aOverrideSettings) = 0;

	/**
	 *
	 */
	virtual CStoreableOverrideSettings* OverridesL() = 0;

	/**
	 *
	 */
	virtual void RequestNotificationOfServiceChangeL(MAgentSessionNotify* aSession) = 0;

	/**
	 *
	 */
	virtual void CancelRequestNotificationOfServiceChange(MAgentSessionNotify* aSession) = 0;


	/**
	 *
	 */
	IMPORT_C virtual TInt Control(TUint aOptionLevel, TUint aOptionName, TDes8& aOption, const RProcess& aProcess);

	/**
	 * Read an integer field from the connection settings provider
	 * @param aField The name of the field to read
	 * @param aValue On return, contains the value of the field read
	 * @param aMessage For capability checking
	 * @returns KErrNone, if successful; otherwise one of the standard Symbian OS error codes
	 */
	IMPORT_C TInt ReadInt(const TDesC& aField, TUint32& aValue,const RMessagePtr2* aMessage);
	IMPORT_C TInt ReadInt(const TDesC& aField, TUint32& aValue );

	/**
	 * Write an integer field to the connection settings provider
	 * @param aField The name of the field to which to write
	 * @param aValue The value to be written to the field
	 * @param aMessage For capability checking
	 * @returns KErrNone, if successful; otherwise one of the standard Symbian OS error codes
	 */
	IMPORT_C TInt WriteInt(const TDesC& aField, TUint32 aValue,const RMessagePtr2* aMessage);
	IMPORT_C TInt WriteInt(const TDesC& aField, TUint32 aValue );

	/**
	 * Read a descriptor field from the connection settings provider
	 * @param aField The name of the field to read
	 * @param aValue On return, contains the value of the field read
	 * @param aMessage For capability checking
	 * @returns KErrNone, if successful; otherwise one of the standard Symbian OS error codes
	 */
	IMPORT_C TInt ReadDes(const TDesC& aField, TDes8& aValue,const RMessagePtr2* aMessage);
	IMPORT_C TInt ReadDes(const TDesC& aField, TDes8& aValue );

	/**
	 * Write a descriptor field to the connection settings provider
	 * @param aField The name of the field to which to write
	 * @param aValue The value to be written to the field
	 * @param aMessage For capability checking
	 * @returns KErrNone, if successful; otherwise one of the standard Symbian OS error codes
	 */
	IMPORT_C TInt WriteDes(const TDesC& aField, const TDesC8& aValue,const RMessagePtr2* aMessage);
	IMPORT_C TInt WriteDes(const TDesC& aField, const TDesC8& aValue );

	/**
	 * Read a descriptor field from the connection settings provider
	 * @param aField The name of the field to read
	 * @param aValue On return, contains the value of the field read
	 * @param aMessage For capability checking
	 * @returns KErrNone, if successful; otherwise one of the standard Symbian OS error codes
	 */
	IMPORT_C TInt ReadDes(const TDesC& aField, TDes16& aValue,const RMessagePtr2* aMessage);
	IMPORT_C TInt ReadDes(const TDesC& aField, TDes16& aValue );

	/**
	 * Write a descriptor field to the connection settings provider
	 * @param aField The name of the field to which to write
	 * @param aValue The value to be written to the field
	 * @param aMessage For capability checking
	 * @returns KErrNone, if successful; otherwise one of the standard Symbian OS error codes
	 */
	IMPORT_C TInt WriteDes(const TDesC& aField, const TDesC16& aValue,const RMessagePtr2* aMessage);
	IMPORT_C TInt WriteDes(const TDesC& aField, const TDesC16& aValue );
	/**
	 * Read an boolean field from the connection settings provider
	 * @param aField The name of the field to read
	 * @param aValue On return, contains the value of the field read
	 * @param aMessage For capability checking
	 * @returns KErrNone, if successful; otherwise one of the standard Symbian OS error codes
	 */
	IMPORT_C TInt ReadBool(const TDesC& aField, TBool& aValue,const RMessagePtr2* aMessage);
	IMPORT_C TInt ReadBool(const TDesC& aField, TBool& aValue );
	/**
	 * Write an boolean field to the connection settings provider
	 * @param aField The name of the field to which to write
	 * @param aValue The value to be written to the field
	 * @param aMessage For capability checking
	 * @returns KErrNone, if successful; otherwise one of the standard Symbian OS error codes
	 */
	IMPORT_C TInt WriteBool(const TDesC& aField, TBool aValue,const RMessagePtr2* aMessage);
	IMPORT_C TInt WriteBool(const TDesC& aField, TBool aValue );

	/**
	 * Read a descriptor field of unknown size from the connection settings provider
	 * @param aField The name of the field to read
	 * @param aMessage For capability checking
	 * @returns The value of the field read
	 * @since v7.0s
	 */
	IMPORT_C HBufC* ReadLongDesLC(const TDesC& aField, const RMessagePtr2* aMessage);
	IMPORT_C HBufC* ReadLongDesLC(const TDesC& aField );

	/**
	 * Check that a client has the required capabilities to read a field
	 * @param aField  The field to check
	 * @param aMessage Message containing client capabilites
	 * @returns one of the system-wide error codes
	 */
	IMPORT_C TInt CheckReadCapability( const TDesC& aField, const RMessagePtr2* aMessage );
	/**
	 * Check that a client has the required capabilities to write a field
	 * @param aField  The field to check
	 * @param aMessage Message containing client capabilites
	 * @returns one of the system-wide error codes
	 */
	IMPORT_C TInt CheckWriteCapability( const TDesC& aField, const RMessagePtr2* aMessage );


protected:

	/**
	 * Read an integer field from the connection settings provider
	 * @param aField The name of the field to read
	 * @param aValue On return, contains the value of the field read
	 * @returns KErrNone, if successful; otherwise one of the standard Symbian OS error codes
	 */
	virtual TInt DoReadInt(const TDesC& aField, TUint32& aValue,const RMessagePtr2* aMessage) = 0;

	/**
	 * Write an integer field to the connection settings provider
	 * @param aField The name of the field to which to write
	 * @param aValue The value to be written to the field
	 * @returns KErrNone, if successful; otherwise one of the standard Symbian OS error codes
	 */
	virtual TInt DoWriteInt(const TDesC& aField, TUint32 aValue,const RMessagePtr2* aMessage) = 0;

	/**
	 * Read a 8-bit descriptor field from the connection settings provider
	 * @param aField The name of the field to read
	 * @param aValue On return, contains the value of the field read
	 * @returns KErrNone, if successful; otherwise one of the standard Symbian OS error codes
	 */
	virtual TInt DoReadDes(const TDesC& aField, TDes8& aValue,const RMessagePtr2* aMessage) = 0;

	/**
	 * Read a 16-bit descriptor field from the connection settings provider
	 * @param aField The name of the field to read
	 * @param aValue On return, contains the value of the field read
	 * @returns KErrNone, if successful; otherwise one of the standard Symbian OS error codes
	 */
	virtual TInt DoWriteDes(const TDesC& aField, const TDesC8& aValue,const RMessagePtr2* aMessage) = 0;

	/**
	 * Write an 8-bit descriptor field to the connection settings provider
	 * @param aField The name of the field to which to write
	 * @param aValue The value to be written to the field
	 * @returns KErrNone, if successful; otherwise one of the standard Symbian OS error codes
	 */
	virtual TInt DoReadDes(const TDesC& aField, TDes16& aValue,const RMessagePtr2* aMessage) = 0;

	/**
	 * Write an 16-bit descriptor field to the connection settings provider
	 * @param aField The name of the field to which to write
	 * @param aValue The value to be written to the field
	 * @returns KErrNone, if successful; otherwise one of the standard Symbian OS error codes
	 */
	virtual TInt DoWriteDes(const TDesC& aField, const TDesC16& aValue,const RMessagePtr2* aMessage) = 0;

	/**
	 * Read an boolean field from the connection settings provider
	 * @param aField The name of the field to read
	 * @param aValue On return, contains the value of the field read
	 * @returns KErrNone, if successful; otherwise one of the standard Symbian OS error codes
	 */
	virtual TInt DoReadBool(const TDesC& aField, TBool& aValue,const RMessagePtr2* aMessage) = 0;

	/**
	 * Write an boolean field to the connection settings provider
	 * @param aField The name of the field to which to write
	 * @param aValue The value to be written to the field
	 * @returns KErrNone, if successful; otherwise one of the standard Symbian OS error codes
	 */
	virtual TInt DoWriteBool(const TDesC& aField, TBool aValue,const RMessagePtr2* aMessage) = 0;

	/**
	 * Read a 16-bit descriptor field of unknown size from the connection settings provider
	 * @param aField The name of the field to read
	 * @returns The value of the field read
	 * @since v7.0s
	 */
	virtual HBufC* DoReadLongDesLC(const TDesC& aField,const RMessagePtr2* aMessage) = 0;

	/**
	 * Check that a client has the required capabilties to read a field
	 * @param aField the name of the field to read
	 * @param aMessage Message containing the capabilities of the client
	 * @returns KErrNone, if the client has the required capabilites, otherwise one of the standard Symbian OS error codes
	 */
	IMPORT_C virtual TInt DoCheckReadCapability( const TDesC& aField, const RMessagePtr2* aMessage );
	/**
	 * Check that a client has the required capabilties to write a field
	 * @param aField the name of the field to write
	 * @param aMessage Message containing the capabilities of the client
	 * @returns KErrNone, if the client has the required capabilites, otherwise one of the standard Symbian OS error codes
	 */
	IMPORT_C virtual TInt DoCheckWriteCapability( const TDesC& aField, const RMessagePtr2* aMessage );

	private:
	/**
	 * Check that a client has the required capabilties
	 * @param aOptionLevel
	 * @param aOptionName
	 * @param aOption
	 * @param aMessage
	 * @returns KErrNone, if the client has the required capabilites, otherwise one of the standard Symbian OS error codes
	 */
	TBool CheckControlPolicy(TUint aLevel, TUint aOption, const RProcess& aProcess);
	
#ifdef SYMBIAN_ADAPTIVE_TCP_RECEIVE_WINDOW
	public:
	/**
	 * Get the bearer information from the agent. The function has to be overridden
	 * by the agent implementaion, if agent want to return the bearer specific information
	 * to the Agent CPR. Otherwise, a default bearer value will returned.
	 */
	IMPORT_C  virtual TUint32 GetBearerInfo() const ;
#endif //SYMBIAN_ADAPTIVE_TCP_RECEIVE_WINDOW


protected:
	MNifAgentNotify* iNotify;	//< Pointer for the interface to nifman

	};

#ifndef SYMBIAN_ENABLE_SPLIT_HEADERS
#include <comms-infras/nifagt_internal.h>
#endif

#endif
