// Copyright (c) 1997-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Interface Manager Standard Variable Names
// 
//

/**
 @file NIFPRVAR.H
*/

#ifndef __NIFPRVAR_H__
#define __NIFPRVAR_H__

#include <nifvar.h>

/**
@publishedPartner
@released
@since v7.0s
*/
const TInt KVendorSpecificNotificationStart = 1000;


/**
Notification types from Nif to Agent
@publishedPartner
@rleased
*/
enum TNifToAgentEventType
	{
	ENifToAgentEventTypePPPCallbackGranted	= 1,
	ENifToAgentEventTypeQueryIsDialIn	= 2,
	ENifToAgentEventTypeLinkLayerDown	= 3,
	ENifToAgentEventTsyConfig           = 4,
	ENifToAgentEventTsyConnectionSpeed  = 5,	
	ENifToAgentEventVendorSpecific = KVendorSpecificNotificationStart
	};

/**
Notifications from agent to Nif
@publishedPartner
@rleased
*/
enum TAgentToNifEventType
	{
	EAgentToNifEventTypeModifyInitialTimer,		//< for GPRS context activation
	EAgentToNifEventTypeDisableTimers,			//< for GPRS suspension
	EAgentToNifEventTypeEnableTimers,			//< for GPRS resumption
	EAgentToNifEventTypeGetDataTransfer,
	EAgentToNifEventTypeDisableConnection,
	EAgentToNifEventTsyConfig,
	EAgentToNifEventTsyConnectionSpeed,
	EAgentToNifEventVendorSpecific = KVendorSpecificNotificationStart
	};

/**
 * For the RConnection sub-connection functions - a value to indicate that the call refers to the entire connection, not a specific subconnection
 * @publishedPartner
 * @released
 */
const TUint KNifEntireConnectionSubConnectionId = 0;
	
/**
Events generated by network adaptors (nifs/agents)
@note Should eventually migrate all events (Notifications, MNifEvents) to this mechanism

@publishedPartner
@released
*/
enum TNetworkAdaptorEventType
	{
	/** @note Subconnection events should only be generated if it acceptable
	for them to be passed to clients of the RConnection API
	*/
	ESubConnectionEvent,
	EEtelEvent,
	EAgentOriginatedConnectionCommand, //< To allow agents to perform operations such as Stop()
	};

enum TEtelEvents
	{
	ECurrentNetworkChangeEvent
	};

#ifndef SYMBIAN_ENABLE_SPLIT_HEADERS
#include <comms-infras/nifprvar_internal.h>
#endif

#endif
