export Path:=Z:\epoc32\gcc$(PBUILDPID)\bin;$(Path)
export PATH:=$(Path)

# prevent MAKEFLAGS variable from upsetting calls to NMAKE
unexport MAKEFLAGS

ERASE = @erase 2>>nul


ifdef EFREEZE_ALLOW_REMOVE
REMOVEMACRO := EFREEZE_ALLOW_REMOVE=-remove
endif


CLEAN : CLEANHELLOWORLD

CLEANMAKEFILE : CLEANMAKEFILEHELLOWORLD

CLEANALL : CLEANALLHELLOWORLD

FINAL : FINALHELLOWORLD

FREEZE : FREEZEHELLOWORLD

LIBRARY : LIBRARYHELLOWORLD

MAKEFILE : MAKEFILEHELLOWORLD

RESOURCE : RESOURCEHELLOWORLD

SAVESPACE : SAVESPACEHELLOWORLD

TARGET : TARGETHELLOWORLD

LISTING : LISTINGHELLOWORLD

WHATMAKEFILE : WHATMAKEFILEHELLOWORLD

WHAT : WHATHELLOWORLD

CHECKSOURCE : CHECKSOURCE_GENERIC CHECKSOURCEHELLOWORLD

CHECKSOURCE_GENERIC :
	@perl -S checksource.pl --preprocess -- -DARMCC -DEPOC32 -DMARM -DEABI -DARMCC_2 -DARMCC_2_2 -DGENERIC_MARM -DMARM_ARMV5 -include Z:\EPOC32\include\feature_settings.hrh -I . -I Z:\EPOC32\include Z:\HelloWorld\group\BLD.INF
	@perl -S checksource.pl --metadata "\HelloWorld\group\BLD.INF" "PRJ_MMPFILES MMP" "HelloWorld.mmp" 15 1
	@rem


TIDY :
	@echo Nothing to do


ROMFILE : STARTROMFILE ROMFILEHELLOWORLD

STARTROMFILE :
	@perl -S emkdir.pl "\epoc32\rom\HelloWorld\group"
	@echo // \epoc32\rom\HelloWorld\group\ARMV5.IBY > \epoc32\rom\HelloWorld\group\ARMV5.IBY
	@echo // >> \epoc32\rom\HelloWorld\group\ARMV5.IBY


MAKEFILEHELLOWORLD_FILES= \
	"\EPOC32\BUILD\HelloWorld\group\HELLOWORLD\ARMV5\HELLOWORLD.ARMV5"

MAKEFILEHELLOWORLD :
	perl -S makmake.pl $(NO_DEPENDENCIES) -D \HelloWorld\group\HELLOWORLD ARMV5  $(ABLD_FLAGS) $(ABLD_COMPWRAP_FLAG)

CLEANMAKEFILEHELLOWORLD :
	-$(ERASE) $(MAKEFILEHELLOWORLD_FILES)

WHATMAKEFILEHELLOWORLD :
	@echo $(MAKEFILEHELLOWORLD_FILES)

TARGETHELLOWORLD :
	$(MAKE) $(VERBOSE) $(KEEPGOING) -r -f "\EPOC32\BUILD\HelloWorld\group\HELLOWORLD\ARMV5\HELLOWORLD.ARMV5" $(CFG)

SAVESPACEHELLOWORLD :
	$(MAKE) $(VERBOSE) $(KEEPGOING) -r -f "\EPOC32\BUILD\HelloWorld\group\HELLOWORLD\ARMV5\HELLOWORLD.ARMV5" $(CFG) CLEANBUILD$(CFG)

LISTINGHELLOWORLD :
	$(MAKE) $(VERBOSE) $(KEEPGOING) -r -f "\EPOC32\BUILD\HelloWorld\group\HELLOWORLD\ARMV5\HELLOWORLD.ARMV5" MAKEWORK$(CFG) LISTING$(CFG)$(SOURCE)

FINALHELLOWORLD :
	@rem do nothing

CLEANALLHELLOWORLD :
	perl -S ermdir.pl \EPOC32\BUILD\HelloWorld\group\HELLOWORLD\ARMV5\

CLEANHELLOWORLD :
	$(MAKE) $(VERBOSE) $(KEEPGOING) -r -f "\EPOC32\BUILD\HelloWorld\group\HELLOWORLD\ARMV5\HELLOWORLD.ARMV5" CLEAN$(CFG)

RESOURCEHELLOWORLD :
	$(MAKE) $(VERBOSE) $(KEEPGOING) -r -f "\EPOC32\BUILD\HelloWorld\group\HELLOWORLD\ARMV5\HELLOWORLD.ARMV5" RESOURCE$(CFG)

LIBRARYHELLOWORLD :
	$(MAKE) $(VERBOSE) $(KEEPGOING) -r -f "\EPOC32\BUILD\HelloWorld\group\HELLOWORLD\ARMV5\HELLOWORLD.ARMV5" LIBRARY

FREEZEHELLOWORLD :
	$(MAKE) $(VERBOSE) $(KEEPGOING) -r -f "\EPOC32\BUILD\HelloWorld\group\HELLOWORLD\ARMV5\HELLOWORLD.ARMV5" FREEZE $(REMOVEMACRO)

WHATHELLOWORLD :
	@$(MAKE) $(VERBOSE) $(KEEPGOING) -r -s -f "\EPOC32\BUILD\HelloWorld\group\HELLOWORLD\ARMV5\HELLOWORLD.ARMV5" WHAT$(CFG)

CHECKSOURCEHELLOWORLD :
	@$(MAKE) $(VERBOSE) $(KEEPGOING) -r -s -f "\EPOC32\BUILD\HelloWorld\group\HELLOWORLD\ARMV5\HELLOWORLD.ARMV5" CHECKSOURCE
	@$(MAKE) $(VERBOSE) $(KEEPGOING) -r -s -f "\EPOC32\BUILD\HelloWorld\group\HELLOWORLD\ARMV5\HELLOWORLD.ARMV5" CHECKSOURCE$(CFG)

ROMFILEHELLOWORLD :
	@$(MAKE) $(VERBOSE) $(KEEPGOING) -r -f "\EPOC32\BUILD\HelloWorld\group\HELLOWORLD\ARMV5\HELLOWORLD.ARMV5" ROMFILE >> \epoc32\rom\HelloWorld\group\ARMV5.IBY


