/*
* Copyright (c) 1997-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
* FUNCTION
* <<tmpfile>>---create a temporary file
* INDEX
* tmpfile
* INDEX
* _tmpfile_r
* ANSI_SYNOPSIS
* #include <stdio.h>
* FILE *tmpfile(void);
* FILE *_tmpfile_r(void *<[reent]>);
* TRAD_SYNOPSIS
* #include <stdio.h>
* FILE *tmpfile();
* FILE *_tmpfile_r(<[reent]>)
* char *<[reent]>;
* Create a temporary file (a file which will be deleted automatically),
* using a name generated by <<tmpnam>>.  The temporary file is opened with
* the mode <<"wb+">>, permitting you to read and write anywhere in it
* as a binary file (without any data transformations the host system may
* perform for text files).
* The alternate function <<_tmpfile_r>> is a reentrant version.  The
* argument <[reent]> is a pointer to a reentrancy structure.
* RETURNS
* <<tmpfile>> normally returns a pointer to the temporary file.  If no
* temporary file could be created, the result is NULL, and <<errno>>
* records the reason for failure.
* PORTABILITY
* Both ANSI C and the System V Interface Definition (Issue 2) require
* <<tmpfile>>.
* Supporting OS subroutines required: <<close>>, <<fstat>>, <<getpid>>,
* <<isatty>>, <<lseek>>, <<open>>, <<read>>, <<sbrk>>, <<write>>.
* <<tmpfile>> also requires the global pointer <<environ>>.
* 
*
*/



#include <stdio_r.h>

/**
Open a temporary file.
Creates a temporary binary file for update.
The filename is unique to avoid any conflict with existing files.
@return  file pointer (stream) to the temporary file created.
If the file can not be created a NULL pointer is returned.
*/
EXPORT_C FILE *tmpfile (void)
	{
	return _tmpfile_r (_REENT);
	}

/**
Open a temporary file.
Creates a temporary binary file for update. 
The filename is unique to avoid any conflict with existing files.
@return FILE
*/
EXPORT_C FILE *_tmpfile_r (struct _reent *r)
	{
	return _wfopen_r(r, (wchar_t*)L"TMP:", (wchar_t*)L"wb+");
	}
