/*
* Copyright (c) 1997-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
* FUNCTION
* <<gmtime>>---convert time to UTC traditional form
* INDEX
* gmtime
* ANSI_SYNOPSIS
* #include <time.h>
* struct tm *gmtime(const time_t *<[clock]>);
* struct tm *gmtime_r(const time_t *<[clock]>, struct tm *<[res]>);
* TRAD_SYNOPSIS
* #include <time.h>
* struct tm *gmtime(<[clock]>)
* const time_t *<[clock]>;
* struct tm *gmtime_r(<[clock]>, <[res]>)
* const time_t *<[clock]>;
* struct tm *<[res]>;
* <<gmtime>> assumes the time at <[clock]> represents a local time.
* <<gmtime>> converts it to UTC (Universal Coordinated Time, also known in some
* countries as GMT, Greenwich Mean time), then converts the
* representation from the arithmetic representation to
* the traditional representation defined by <<struct tm>>.
* <<gmtime>> constructs the traditional time representation in static
* storage; each call to <<gmtime>> or <<localtime>> will overwrite the
* information generated by previous calls to either function.
* RETURNS
* A pointer to the traditional time representation (<<struct tm>>).
* PORTABILITY
* ANSI C requires <<gmtime>>.
* <<gmtime>> requires no supporting OS subroutines.
* 
*
*/



#include <sys/reent.h>
#include <time.h>

#ifndef _REENT_ONLY

/**
Convert time_t value to tm structure as UTC time.
Converts timer to tm structure adjusting to 
UTC (formerly known as GMT) timezone.  
@return A pointer to a tm structure.
This structure is statically allocated and shared by gmtime,
localtime and ctime functions. 
Each time one of these functions is called the content of
the structure is overwritten.
@param tim_p pointer to a time_t value, 
usually returned by time function.
*/
EXPORT_C struct tm *
gmtime (const time_t * tim_p)
{
  return gmtime_r (tim_p, &(_REENT->_struct_tm));
}

#endif
