//  (C) Copyright John Maddock 2005.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
/*
 *  Portions copyright (c) 2006-2007 Nokia Corporation.  All rights reserved.
*/

#include <boost/test/included/test_exec_monitor.hpp>
#include <boost/test/floating_point_comparison.hpp>
#include <boost/math/special_functions/log1p.hpp>
#include <boost/math/special_functions/expm1.hpp>

#include <cmath>

#ifdef BOOST_NO_STDC_NAMESPACE
namespace std{ using ::sqrt; using ::exp; }
#endif

//
// These test values were generated at 256-bit precision with NTL,
// we'll use these as a comparison for our own algorithms:
//
long double data[][3] = {
   { 0.7071067811865475244008443621048490392848L, 0.5347999967395703705239932642507040249904L, 1.028114981647472451108126112746351175174L, }, 
   { -0.7071067811865475244008443621048490392848L, -1.227947177299515679941225385708880593066L, -0.5069313086047602121540426193848225247642L, }, 
   { 0.5L, 0.405465108108164381978013115464349136572L, 0.6487212707001281468486507878141635716538L, }, 
   { -0.5L, -0.6931471805599453094172321214581765680755L, -0.3934693402873665763962004650088195465581L, }, 
   { 0.3535533905932737622004221810524245196424L, 0.3027332756136080026565008168738916532429L, 0.4241190194809816004138284781974755046316L, }, 
   { -0.3535533905932737622004221810524245196424L, -0.4362646682381306258028444378052416278323L, -0.2978114986734404037618125202537819364955L, }, 
   { 0.25L, 0.2231435513142097557662950903098345033746L, 0.2840254166877414840734205680624364583363L, }, 
   { -0.25L, -0.2876820724517809274392190059938274315035L, -0.2211992169285951317548297330216793527032L, }, 
   { 0.1767766952966368811002110905262122598212L, 0.1627790866561079067978577664745092478057L, 0.1933645794479495947956947190066751660075L, }, 
   { -0.1767766952966368811002110905262122598212L, -0.1945277849706882079548540492230348777333L, -0.1620331144212442112773768997051282549751L, }, 
   { 0.125L, 0.1177830356563834545387941094705217050685L, 0.1331484530668263168290072278117938725655L, }, 
   { -0.125L, -0.1335313926245226231463436209313499745894L, -0.117503097415404597135107856770949263778L, }, 
   { 0.0883883476483184405501055452631061299106L, 0.08469802192359444824992033285217108168932L, 0.09241227540153062617063135584671815396877L, }, 
   { -0.0883883476483184405501055452631061299106L, -0.09254119938462034112310437534311466334391L, -0.08459468781377732889540834505145255847266L, }, 
   { 0.0625L, 0.0606246218164348425806061320404202632862L, 0.06449445891785942956339059464288967310073L, }, 
   { -0.0625L, -0.06453852113757117167292391568399292812891L, -0.06058693718652421388028917537769491547532L, }, 
   { 0.0441941738241592202750527726315530649553L, 0.0432454624194302551610854640871481968471L, 0.04518528280947901327000081260336002430674L, }, 
   { -0.0441941738241592202750527726315530649553L, -0.04520049725523360571871295632901500898476L, -0.04323183989734343213613354147207468639883L, }, 
   { 0.03125L, 0.0307716586667536883710282075967721640917L, 0.0317434074991026709387478152815071441945L, }, 
   { -0.03125L, -0.03174869831458030115699628274852562992756L, -0.03076676552365591815189080675364721639527L, }, 
   { 0.02209708691207961013752638631577653247765L, 0.02185648424813694627588486704954425304883L, 0.02234303578078870447841893477675632033383L, }, 
   { -0.02209708691207961013752638631577653247765L, -0.02234488474624582074086983060944116403229L, -0.02185473466225040063461756538971286083712L, }, 
   { 0.015625L, 0.01550418653596525415085404604244683587787L, 0.01574770858668574745853507208235174890672L, }, 
   { -0.015625L, -0.01574835696813916860754951146082826952093L, -0.01550356299459159401301117030297963029214L, }, 
   { 0.01104854345603980506876319315788826623883L, 0.01098795417351052684893633616419361769653L, 0.01110980401773807767277088699717081730887L, }, 
   { -0.01104854345603980506876319315788826623883L, -0.01111003193719750909051920695450559324905L, -0.0109877324634695920927755509825266486829L, }, 
   { 0.0078125L, 0.007782140442054948947462900061136763678126L, 0.007843097206447977693453559760123579193392L, }, 
   { -0.0078125L, -0.007843177461025892873184042490943581654592L, -0.00778206173975648789406277388638216992911L, }, 
   { 0.005524271728019902534381596578944133119413L, 0.005509068902949034570040757911345564446908L, 0.005539558653829430569890102084787436958606L, }, 
   { -0.005524271728019902534381596578944133119413L, -0.00553958694674479599776921231398085523465L, -0.005509040998094137069364339639027839483272L, }, 
   { 0.00390625L, 0.003898640415657323013937343095842907010724L, 0.003913889338347573443609603903460281898814L, }, 
   { -0.00390625L, -0.003913899321136329092317783643572664842706L, -0.003898630529882509937135338054830955713597L, }, 
   { 0.002762135864009951267190798289472066559706L, 0.002758328176699244507992500461404507081665L, 0.002765954075939611809020032526494603236975L, }, 
   { -0.002762135864009951267190798289472066559706L, -0.002765957600334472995309858879390478447378L, -0.002758324676557722165983108723111282889863L, }, 
   { 0.001953125L, 0.00195122013126174943967404953184153850035L, 0.001955033591002812046518898047477215867356L, }, 
   { -0.001953125L, -0.001955034835803350557627492241866812137664L, -0.001951218892524527289957340917326404744062L, }, 
   { 0.001381067932004975633595399144736033279853L, 0.001380115134839422362840066413196608682497L, 0.001382022045502678201141870910789095246896L, }, 
   { -0.001381067932004975633595399144736033279853L, -0.001382022485291226579353866252268409285565L, -0.001380114696566700781276188886360328730002L, }, 
   { 0.0009765625L, 0.0009760859730554588959608249080171866726118L, 0.0009770394924165352428452926116065064658516L, }, 
   { -0.0009765625L, -0.000977039647826612785968075151753465835865L, -0.0009760858180243377652882103896705696807979L, }, 
   { 0.0006905339660024878167976995723680166399266L, 0.0006902956571239922163465924178424595489941L, 0.0006907724394697735895620855250217767118257L, }, 
   { -0.0006905339660024878167976995723680166399266L, -0.0006907724943958822152082937884673220890625L, -0.0006902956022926226579739822473659270196051L, }, 
   { 0.00048828125L, 0.0004881620795013511885370496926454098503177L, 0.0004884004786944731261736238071633537881055L, }, 
   { -0.00048828125L, -0.0004884004981088744649849635598969109834608L, -0.0004881620601106346120642438969970786650047L, }, 
   { 0.0003452669830012439083988497861840083199633L, 0.0003452073920725940347605594851408457654352L, 0.0003453265945064500836804861194113777618491L, }, 
   { -0.0003452669830012439083988497861840083199633L, -0.0003453266013692502439328491689895266497932L, -0.0003452073852157150645328468804957180492811L, }, 
   { 0.000244140625L, 0.0002441108275273627091604790858234536994612L, 0.0002441704297478549370052339241357737575196L, }, 
   { -0.000244140625L, -0.0002441704321739144566954654183814336430665L, -0.0002441108251027834869064123317332192226443L, }, 
   { 0.0001726334915006219541994248930920041599816L, 0.0001726185920541657488047052564217192486562L, 0.0001726483935193326386701093624723297495011L, }, 
   { -0.0001726334915006219541994248930920041599816L, -0.0001726483943769975333358785791023362275292L, -0.0001726185911968709284892274915373687749247L, }, 
   { 0.0001220703125L, 0.0001220628625256773716230553671622032006662L, 0.0001220777633837710765035196704053169651876L, }, 
   { -0.0001220703125L, -0.0001220777636869822415828707903119755525239L, -0.0001220628622225587251301833935672790920603L, }, 
   { 0.8631674575031097709971244654600207999082e-4L, 0.8631302067436859538170634567406786112601e-4L, 0.8632047114779673053115205017424336944456e-4L, }, 
   { -0.8631674575031097709971244654600207999082e-4L, -0.8632047125499327478558483802377432851254e-4L, -0.8631302056719518077375662982669623892259e-4L, }, 
   { 0.6103515625e-4L, 0.6103329368063852491315878964896399244278e-4L, 0.610370189330454217791205985471093033817e-4L, }, 
   { -0.6103515625e-4L, -0.6103701897094392572114242980681797646601e-4L, -0.6103329364274580338274063706796778431152e-4L, }, 
   { 0.4315837287515548854985622327300103999541e-4L, 0.4315744157937625036775176424278410274829e-4L, 0.4315930421112837090401086653281340081162e-4L, }, 
   { -0.4315837287515548854985622327300103999541e-4L, -0.4315930422452721604826114516606004744788e-4L, -0.4315744156597885082640026911399617719788e-4L, }, 
   { 0.30517578125e-4L, 0.3051711247318637856906951416899468124305e-4L, 0.3051804379102429545128481254124317032922e-4L, }, 
   { -0.30517578125e-4L, -0.3051804379576142772845440263529078774196e-4L, -0.3051711246844960769262435293040988383306e-4L, }, 
   { 0.2157918643757774427492811163650051999771e-4L, 0.2157895361028356677465179910857365631679e-4L, 0.2157941926989617246887680913732626816569e-4L, }, 
   { -0.2157918643757774427492811163650051999771e-4L, -0.2157941927157098293412689381708235824685e-4L, -0.2157895360860884665958278826510182396057e-4L, }, 
   { 0.152587890625e-4L, 0.1525867264836239740575732513488881988266e-4L, 0.1525890547841394814004262248066173018701e-4L, }, 
   { -0.152587890625e-4L, -0.152589054790060783804405477297578319824e-4L, -0.1525867264777028975290466417266610381266e-4L, }, 
   { 0.1078959321878887213746405581825025999885e-4L, 0.1078953501154664660426995857578938351957e-4L, 0.1078965142665913183071896911252005879737e-4L, }, 
   { -0.1078959321878887213746405581825025999885e-4L, -0.1078965142686848031534799026109936625941e-4L, -0.1078953501133730376652725297740371278837e-4L, }, 
   { 0.762939453125e-5L, 0.7629365427567572155885296849132278805619e-5L, 0.7629423635154471743184330338220061308624e-5L, }, 
   { -0.762939453125e-5L, -0.7629423635228487317358417985971365713551e-5L, -0.7629365427493557993432788023738794879446e-5L, }, 
   { 0.5394796609394436068732027909125129999427e-5L, 0.5394782057531543905412357533557238337288e-5L, 0.5394811161335832678521641682790705055058e-5L, }, 
   { -0.5394796609394436068732027909125129999427e-5L, -0.5394811161362001062632444450174708967681e-5L, -0.5394782057505375874231949463613865956897e-5L, }, 
   { 0.3814697265625e-5L, 0.3814689989685889480711784976833932293351e-5L, 0.3814704541591866050787712890332329861816e-5L, }, 
   { -0.3814697265625e-5L, -0.3814704541601117953442710025273637313909e-5L, -0.3814689989676637666289386515234179775918e-5L, }, 
   { 0.2697398304697218034366013954562564999713e-5L, 0.2697394666724952981329383449389929775742e-5L, 0.2697401942679296154240372969560137048828e-5L, }, 
   { -0.2697398304697218034366013954562564999713e-5L, -0.2697401942682567191225066371527710701254e-5L, -0.2697394666721681966402839715630419488434e-5L, }, 
   { 0.19073486328125e-5L, 0.1907346813825409415469442511204082252649e-5L, 0.1907350451803060028725247653539392997757e-5L, }, 
   { -0.19073486328125e-5L, -0.1907350451804216513799839071800603067824e-5L, -0.1907346813824252935909388509978972352794e-5L, }, 
   { 0.1348699152348609017183006977281282499857e-5L, 0.1348698242854724999916487141692522749195e-5L, 0.134870006184371966849355726468816803105e-5L, }, 
   { -0.1348699152348609017183006977281282499857e-5L, -0.1348700061844128547427324196878709275963e-5L, -0.134869824285431612236135456375901708795e-5L, }, 
   { 0.95367431640625e-6L, 0.9536738616591882339084155149633361436031e-6L, 0.9536747711537454467882495568742836518855e-6L, }, 
   { -0.95367431640625e-6L, -0.953674771153890007250243736279163253167e-6L, -0.9536738616590436737910799241224667558785e-6L, }, 
   { 0.6743495761743045085915034886406412499283e-6L, 0.6743493488007312848688574744255030867349e-6L, 0.6743498035480310616127355457459842044318e-6L, }, 
   { -0.6743495761743045085915034886406412499283e-6L, -0.6743498035480821714363740085141941426098e-6L, -0.6743493488006801751313836587982646166511e-6L, }, 
   { 0.476837158203125e-6L, 0.476837044516323418443461751960488410315e-6L, 0.4768372718899807916543919475044056566776e-6L, }, 
   { -0.476837158203125e-6L, -0.4768372718899988617013706248625400684693e-6L, -0.476837044516305348418024236387592979885e-6L, }, 
   { 0.3371747880871522542957517443203206249642e-6L, 0.3371747312437461709296447293515154324249e-6L, 0.3371748449305775038268746571498812558228e-6L, }, 
   { -0.3371747880871522542957517443203206249642e-6L, -0.3371748449305838925521368172669692634241e-6L, -0.3371747312437397822097678596807366844562e-6L, }, 
   { 0.2384185791015625e-6L, 0.2384185506798575871042367946772990434454e-6L, 0.2384186075232741891586680785801190380695e-6L, }, 
   { -0.2384185791015625e-6L, -0.2384186075232764479138672515011331430966e-6L, -0.2384185506798553283503839443678621926131e-6L, }, 
   { 0.1685873940435761271478758721601603124821e-6L, 0.168587379832723009126312584887843306015e-6L, 0.168587408254431640940234436906404041751e-6L, }, 
   { -0.1685873940435761271478758721601603124821e-6L, -0.1685874082544324395307239165162871748373e-6L, -0.1685873798327222105361596859308544788882e-6L, }, 
   { 0.11920928955078125e-6L, 0.1192092824453544570875791570625307160609e-6L, 0.1192092966562088899453260246612120070545e-6L, }, 
   { -0.11920928955078125e-6L, -0.1192092966562091722896838486808843580911e-6L, -0.1192092824453541747433054782060819405655e-6L, }, 
   { 0.8429369702178806357393793608008015624104e-7L, 0.8429369346907458442100468226515995161268e-7L, 0.8429370057450184219823111772198430837325e-7L, }, 
   { -0.8429369702178806357393793608008015624104e-7L, -0.8429370057450194202203178452536969989128e-7L, -0.8429369346907448459722505175258045386137e-7L, }, 
   { 0.59604644775390625e-7L, 0.5960464299903385618582531773708049930377e-7L, 0.5960464655174749969329045951426788010322e-7L, }, 
   { -0.59604644775390625e-7L, -0.5960464655174753498633255797994360530379e-7L, -0.5960464299903382089278847834410624753006e-7L, }, 
   { 0.4214684851089403178696896804004007812052e-7L, 0.4214684762271563704279048400454781112143e-7L, 0.4214684939907246396506810043790990273791e-7L, }, 
   { -0.4214684851089403178696896804004007812052e-7L, -0.4214684939907247644304252640416892209222e-7L, -0.4214684762271562456481737280646416012198e-7L, }, 
   { 0.298023223876953125e-7L, 0.2980232194360611147319705384762092811637e-7L, 0.2980232283178452676169258265480484667506e-7L, }, 
   { -0.298023223876953125e-7L, -0.2980232283178453117332268061697887309516e-7L, -0.2980232194360610706156728457749074378475e-7L, }, 
   { 0.2107342425544701589348448402002003906026e-7L, 0.2107342403340241408794656877702442158955e-7L, 0.2107342447749162237826252139481573399431e-7L, }, 
   { -0.2107342425544701589348448402002003906026e-7L, -0.2107342447749162393800928355409024145238e-7L, -0.2107342403340241252819988879076087465356e-7L, }, 
   { 0.1490116119384765625e-7L, 0.1490116108282535489039181703572223587795e-7L, 0.1490116130486995926396939779870689685877e-7L, }, 
   { -0.1490116119384765625e-7L, -0.1490116130486995981542314977235185765273e-7L, -0.1490116108282535433893808560533001521451e-7L, }, 
   { 0.1053671212772350794674224201001001953013e-7L, 0.105367120722123571054210921755326087386e-7L, 0.1053671218323465937296840967886895134902e-7L, }, 
   { -0.1053671212772350794674224201001001953013e-7L, -0.1053671218323465956793675238087159758683e-7L, -0.1053671207221235691045275460934314753341e-7L, }, 
   { 0.7450580596923828125e-8L, 0.7450580569168252647234521144541847613178e-8L, 0.7450580624679403809560631351738427758694e-8L, }, 
   { -0.7450580596923828125e-8L, -0.7450580624679403878492349706467386527508e-8L, -0.7450580569168252578302804073766185102522e-8L, }, 
   { 0.5268356063861753973371121005005009765065e-8L, 0.5268356049983966214298749090640627494123e-8L, 0.5268356077739541805556620309161241660075e-8L, }, 
   { -0.5268356063861753973371121005005009765065e-8L, -0.5268356077739541829927662986417408073841e-8L, -0.5268356049983966189927706734372785144896e-8L, }, 
   { 0.37252902984619140625e-8L, 0.3725290291523020175825701002392130168065e-8L, 0.372529030540080797502369309976644431307e-8L, }, 
   { -0.37252902984619140625e-8L, -0.3725290305400807983640157853984023238563e-8L, -0.3725290291523020167209236328421632258708e-8L, }, 
   { 0.2634178031930876986685560502502504882532e-8L, 0.2634178028461430040824706930832094693594e-8L, 0.2634178035400323941685555007927781322226e-8L, }, 
   { -0.2634178031930876986685560502502504882532e-8L, -0.2634178035400323944731935332553916924003e-8L, -0.2634178028461430037778326626267729345852e-8L, }, 
   { 0.186264514923095703125e-8L, 0.1862645147496233557427309081102319554965e-8L, 0.1862645150965680508303865184175223522918e-8L, }, 
   { -0.186264514923095703125e-8L, -0.1862645150965680509380923275944699593959e-8L, -0.1862645147496233556350250994348286047433e-8L, }, 
   { 0.1317089015965438493342780251251252441266e-8L, 0.1317089015098076756115971781941786429449e-8L, 0.1317089016832800231711981337907007052389e-8L, }, 
   { -0.1317089015965438493342780251251252441266e-8L, -0.1317089016832800232092778877858343679894e-8L, -0.1317089015098076755735174243244310442822e-8L, }, 
   { 0.931322574615478515625e-9L, 0.9313225741817976469000627485243784799078e-9L, 0.9313225750491593847538340347920469844993e-9L, }, 
   { -0.931322574615478515625e-9L, -0.9313225750491593848884662961064989128669e-9L, -0.9313225741817976467654304875233917117595e-9L, }, 
   { 0.6585445079827192466713901256256262206331e-9L, 0.6585445077658788122694886236082174630276e-9L, 0.6585445081995596812160907048505041981019e-9L, }, 
   { -0.6585445079827192466713901256256262206331e-9L, -0.6585445081995596812636903973052381314413e-9L, -0.658544507765878812221888931231849819743e-9L, }, 
   { 0.4656612873077392578125e-9L, 0.4656612871993190405976076218769296134401e-9L, 0.465661287416159475077879476047419355854e-9L, }, 
   { -0.4656612873077392578125e-9L, -0.4656612874161594750947085087019300606305e-9L, -0.4656612871993190405807785892420104811773e-9L, }, 
   { 0.3292722539913596233356950628128131103166e-9L, 0.3292722539371495147233197642133894314689e-9L, 0.329272254045569731965920246065619388209e-9L, }, 
   { -0.3292722539913596233356950628128131103166e-9L, -0.32927225404556973197187020762001218331e-9L, -0.3292722539371495147173698026638945294963e-9L, }, 
   { 0.23283064365386962890625e-9L, 0.232830643626764574598319647310257725638e-9L, 0.2328306436809746832204912399308981321644e-9L, }, 
   { -0.23283064365386962890625e-9L, -0.23283064368097468322259486901209973362e-9L, -0.2328306436267645745962160182302805974645e-9L, }, 
   { 0.1646361269956798116678475314064065551583e-9L, 0.1646361269821272845132662163691156862891e-9L, 0.1646361270092323388246600820255233080682e-9L, }, 
   { -0.1646361269956798116678475314064065551583e-9L, -0.1646361270092323388254038272196693482955e-9L, -0.1646361269821272845125224711752757643824e-9L, }, 
   { 0.116415321826934814453125e-9L, 0.1164153218201585508756165045575548434501e-9L, 0.1164153218337110780314223563476279035653e-9L, }, 
   { -0.116415321826934814453125e-9L, -0.1164153218337110780316853099827398389571e-9L, -0.1164153218201585508753535509225194376384e-9L, }, 
   { 0.8231806349783990583392376570320327757914e-10L, 0.8231806349445177404509250064541675340615e-10L, 0.8231806350122803762303393520872760345474e-10L, }, 
   { -0.8231806349783990583392376570320327757914e-10L, -0.8231806350122803762312690335798629228563e-10L, -0.8231806349445177404499953249617719697029e-10L, }, 
   { 0.582076609134674072265625e-10L, 0.5820766091177334133211963773062890278984e-10L, 0.5820766091516147312110396988252133213646e-10L, }, 
   { -0.582076609134674072265625e-10L, -0.5820766091516147312113683908690793251107e-10L, -0.5820766091177334133208676852624708551399e-10L, }, 
   { 0.4115903174891995291696188285160163878957e-10L, 0.4115903174807291996973082454984487948242e-10L, 0.4115903174976698586422780420932622119689e-10L, }, 
   { -0.4115903174891995291696188285160163878957e-10L, -0.4115903174976698586423942522798295941341e-10L, -0.4115903174807291996971920353118933704059e-10L, }, 
   { 0.2910383045673370361328125e-10L, 0.2910383045631018713966231713156171158976e-10L, 0.2910383045715722008691250882008221724786e-10L, }, 
   { -0.2910383045673370361328125e-10L, -0.2910383045715722008691661747063039282285e-10L, -0.2910383045631018713965820848101383495845e-10L, }, 
   { 0.2057951587445997645848094142580081939479e-10L, 0.2057951587424821822167027159569772901036e-10L, 0.2057951587467173469529596913789992503469e-10L, }, 
   { -0.2057951587445997645848094142580081939479e-10L, -0.205795158746717346952974217652319799438e-10L, -0.2057951587424821822166881896836574883717e-10L, }, 
   { 0.14551915228366851806640625e-10L, 0.1455191522826097268823486462025345500282e-10L, 0.1455191522847273092504792612370204544388e-10L, }, 
   { -0.14551915228366851806640625e-10L, -0.1455191522847273092504843970502055804876e-10L, -0.1455191522826097268823435103893496108191e-10L, }, 
   { 0.1028975793722998822924047071290040969739e-10L, 0.1028975793717704867003744009854164112379e-10L, 0.1028975793728292778844404606250868251343e-10L, }, 
   { -0.1028975793722998822924047071290040969739e-10L, -0.1028975793728292778844422764092518704157e-10L, -0.1028975793717704867003725852012514126664e-10L, }, 
   { 0.72759576141834259033203125e-11L, 0.7275957614156956123718744009733740036928e-11L, 0.7275957614209895682922073583260698102783e-11L, }, 
   { -0.72759576141834259033203125e-11L, -0.7275957614209895682922137780925511594519e-11L, -0.7275957614156956123718679812068927712941e-11L, }, 
   { 0.5144878968614994114620235356450204848696e-11L, 0.5144878968601759224819432308256387682622e-11L, 0.5144878968628229004421106496550210191044e-11L, }, 
   { -0.5144878968614994114620235356450204848696e-11L, -0.5144878968628229004421129193852273111093e-11L, -0.514487896860175922481940961095432505451e-11L, }, 
   { 0.363797880709171295166015625e-11L, 0.3637978807085095506759748078017231913638e-11L, 0.3637978807098330396560588496107072890318e-11L, }, 
   { -0.363797880709171295166015625e-11L, -0.3637978807098330396560596520815174540293e-11L, -0.3637978807085095506759740053309130336648e-11L, }, 
   { 0.2572439484307497057310117678225102424348e-11L, 0.2572439484304188334859911241851132472152e-11L, 0.2572439484310805779760332626087345907701e-11L, }, 
   { -0.2572439484307497057310117678225102424348e-11L, -0.2572439484310805779760335463250103763584e-11L, -0.2572439484304188334859908404688374634515e-11L, }, 
   { 0.1818989403545856475830078125e-11L, 0.181898940354420211460497407582728258325e-11L, 0.1818989403547510837055185183438255519526e-11L, }, 
   { -0.1818989403545856475830078125e-11L, -0.1818989403547510837055186186526768223492e-11L, -0.1818989403544202114604973072738769883845e-11L, }, 
   { 0.1286219742153748528655058839112551212174e-11L, 0.1286219742152921348042506520728369264488e-11L, 0.1286219742154575709267612221432767351825e-11L, }, 
   { -0.1286219742153748528655058839112551212174e-11L, -0.128621974215457570926761257607811208324e-11L, -0.1286219742152921348042506166083024534213e-11L, }, 
   { 0.9094947017729282379150390625e-12L, 0.9094947017725146476087627994346924709042e-12L, 0.9094947017733418282213157017234997920852e-12L, }, 
   { -0.9094947017729282379150390625e-12L, -0.9094947017733418282213158271095638799384e-12L, -0.9094947017725146476087626740486283833361e-12L, }, 
   { 0.643109871076874264327529419556275606087e-12L, 0.6431098710766674691743912512988939365825e-12L, 0.6431098710770810594806677208056615496228e-12L, }, 
   { -0.643109871076874264327529419556275606087e-12L, -0.6431098710770810594806677651363296410141e-12L, -0.6431098710766674691743912069682258452625e-12L, }, 
   { 0.45474735088646411895751953125e-12L, 0.4547473508863607213809504341371570958305e-12L, 0.4547473508865675165340886753826169370521e-12L, }, 
   { -0.45474735088646411895751953125e-12L, -0.4547473508865675165340886910558749480249e-12L, -0.4547473508863607213809504184638990848755e-12L, }, 
   { 0.3215549355384371321637647097781378030435e-12L, 0.3215549355383854333754801566311253628365e-12L, 0.3215549355384888309520492795491507775067e-12L, }, 
   { -0.3215549355384371321637647097781378030435e-12L, -0.3215549355384888309520492850904842889284e-12L, -0.3215549355383854333754801510897918514193e-12L, }, 
   { 0.227373675443232059478759765625e-12L, 0.2273736754432062100846174874284747712187e-12L, 0.2273736754432579088729020496989969828922e-12L, }, 
   { -0.227373675443232059478759765625e-12L, -0.2273736754432579088729020516581542342633e-12L, -0.2273736754432062100846174854693175198487e-12L, }, 
   { 0.1607774677692185660818823548890689015218e-12L, 0.1607774677692056413848112152169824136156e-12L, 0.16077746776923149077895349663915545621e-12L, }, 
   { -0.1607774677692185660818823548890689015218e-12L, -0.1607774677692314907789534973318221451376e-12L, -0.1607774677692056413848112145243157246883e-12L, }, 
   { 0.1136868377216160297393798828125e-12L, 0.1136868377216095673908443127735793799622e-12L, 0.1136868377216224920879154535861045893017e-12L, }, 
   { -0.1136868377216160297393798828125e-12L, -0.1136868377216224920879154538309992457231e-12L, -0.1136868377216095673908443125286847235409e-12L, }, 
   { 0.8038873388460928304094117744453445076088e-13L, 0.8038873388460605186667339235334615655252e-13L, 0.8038873388461251421520896279547275331701e-13L, }, 
   { -0.8038873388460928304094117744453445076088e-13L, -0.8038873388461251421520896288205608943295e-13L, -0.803887338846060518666733922667628204366e-13L, }, 
   { 0.5684341886080801486968994140625e-13L, 0.5684341886080639928255604883529618088522e-13L, 0.5684341886080963045682383406903931527277e-13L, }, 
   { -0.5684341886080801486968994140625e-13L, -0.5684341886080963045682383409965114732543e-13L, -0.5684341886080639928255604880468434883256e-13L, }, 
   { 0.4019436694230464152047058872226722538044e-13L, 0.4019436694230383372690364242782431779937e-13L, 0.4019436694230544931403753504917888400498e-13L, }, 
   { -0.4019436694230464152047058872226722538044e-13L, -0.4019436694230544931403753506000180101947e-13L, -0.4019436694230383372690364241700140078488e-13L, }, 
   { 0.28421709430404007434844970703125e-13L, 0.2842170943040360353806149755273358720814e-13L, 0.2842170943040441133162844386499584981161e-13L, }, 
   { -0.28421709430404007434844970703125e-13L, -0.2842170943040441133162844386882232881819e-13L, -0.2842170943040360353806149754890710820156e-13L, }, 
   { 0.2009718347115232076023529436113361269022e-13L, 0.2009718347115211881184355778481715654133e-13L, 0.2009718347115252270862703094150866271954e-13L, }, 
   { -0.2009718347115232076023529436113361269022e-13L, -0.2009718347115252270862703094286152734636e-13L, -0.2009718347115211881184355778346429191452e-13L, }, 
   { 0.142108547152020037174224853515625e-13L, 0.1421085471520190274322661706300802705039e-13L, 0.1421085471520210469161835364155190257708e-13L, }, 
   { -0.142108547152020037174224853515625e-13L, -0.142108547152021046916183536420302124529e-13L, -0.1421085471520190274322661706252971717457e-13L, }, 
   { 0.1004859173557616038011764718056680634511e-13L, 0.1004859173557610989301971303614947615118e-13L, 0.1004859173557621086721558132549146077409e-13L, }, 
   { -0.1004859173557616038011764718056680634511e-13L, -0.1004859173557621086721558132566056885244e-13L, -0.1004859173557610989301971303598036807283e-13L, }, 
   { 0.710542735760100185871124267578125e-14L, 0.7105427357600976615162275603523054293642e-14L, 0.7105427357601027102260209748218811909792e-14L, }, 
   { -0.710542735760100185871124267578125e-14L, -0.710542735760102710226020974827860064427e-14L, -0.7105427357600976615162275603463265559164e-14L, }, 
   { 0.5024295867788080190058823590283403172555e-14L, 0.5024295867788067568284340054136793604486e-14L, 0.5024295867788092811833307126493428270006e-14L, }, 
   { -0.5024295867788080190058823590283403172555e-14L, -0.50242958677880928118333071265145667798e-14L, -0.5024295867788067568284340054115655094692e-14L, }, 
   { 0.3552713678800500929355621337890625e-14L, 0.3552713678800494618468379569811128889791e-14L, 0.3552713678800507240242863105992541885638e-14L, }, 
   { -0.3552713678800500929355621337890625e-14L, -0.3552713678800507240242863106000015477448e-14L, -0.3552713678800494618468379569803655297981e-14L, }, 
   { 0.2512147933894040095029411795141701586277e-14L, 0.2512147933894036939585790911099764566812e-14L, 0.2512147933894043250473032679191565546916e-14L, }, 
   { -0.2512147933894040095029411795141701586277e-14L, -0.251214793389404325047303267919420786064e-14L, -0.2512147933894036939585790911097122253087e-14L, }, 
   { 0.17763568394002504646778106689453125e-14L, 0.1776356839400248886956000226923570074495e-14L, 0.1776356839400252042399621110969857522433e-14L, }, 
   { -0.17763568394002504646778106689453125e-14L, -0.177635683940025204239962111097079172141e-14L, -0.1776356839400248886956000226922635875519e-14L, }, 
   { 0.1256073966947020047514705897570850793139e-14L, 0.1256073966947019258653800676559705959841e-14L, 0.1256073966947020836375611118582986494083e-14L, }, 
   { -0.1256073966947020047514705897570850793139e-14L, -0.1256073966947020836375611118583316783298e-14L, -0.1256073966947019258653800676559375670626e-14L, }, 
   { 0.88817841970012523233890533447265625e-15L, 0.8881784197001248379084527239669870938798e-15L, 0.8881784197001256267693579449786757307363e-15L, }, 
   { -0.88817841970012523233890533447265625e-15L, -0.8881784197001256267693579449787925056083e-15L, -0.8881784197001248379084527239668703190077e-15L, }, 
   { 0.6280369834735100237573529487854253965694e-15L, 0.6280369834735098265421266435325566159411e-15L, 0.6280369834735102209725792540384180356535e-15L, }, 
   { -0.6280369834735100237573529487854253965694e-15L, -0.6280369834735102209725792540384593218054e-15L, -0.6280369834735098265421266435325153297892e-15L, }, 
   { 0.444089209850062616169452667236328125e-15L, 0.4440892098500625175618395146098816422519e-15L, 0.4440892098500627147770658198628183983251e-15L, }, 
   { -0.444089209850062616169452667236328125e-15L, -0.4440892098500627147770658198628329951841e-15L, -0.4440892098500625175618395146098670453929e-15L, }, 
   { 0.3140184917367550118786764743927126982847e-15L, 0.3140184917367549625748698980794851815896e-15L, 0.3140184917367550611824830507059556972867e-15L, }, 
   { -0.3140184917367550118786764743927126982847e-15L, -0.3140184917367550611824830507059608580557e-15L, -0.3140184917367549625748698980794800208206e-15L, }, 
   { 0.2220446049250313080847263336181640625e-15L, 0.2220446049250312834328230454615487925982e-15L, 0.2220446049250313327366296217747848062239e-15L, }, 
   { -0.2220446049250313080847263336181640625e-15L, -0.2220446049250313327366296217747866308313e-15L, -0.2220446049250312834328230454615469679909e-15L, }, 
   { 0.1570092458683775059393382371963563491423e-15L, 0.1570092458683774936133865931180481797763e-15L, 0.1570092458683775182652898812746664537967e-15L, }, 
   { -0.1570092458683775059393382371963563491423e-15L, -0.1570092458683775182652898812746670988928e-15L, -0.1570092458683774936133865931180475346802e-15L, }, 
   { 0.11102230246251565404236316680908203125e-15L, 0.1110223024625156478793873447699277576227e-15L, 0.1110223024625156602053389888482369891051e-15L, }, 
   { -0.11102230246251565404236316680908203125e-15L, -0.111022302462515660205338988848237217181e-15L, -0.1110223024625156478793873447699275295468e-15L, }, 
   { 0.7850462293418875296966911859817817457117e-16L, 0.7850462293418874988818120757860097095564e-16L, 0.7850462293418875605115702961775562009775e-16L, }, 
   { -0.7850462293418875296966911859817817457117e-16L, -0.7850462293418875605115702961775570073477e-16L, -0.7850462293418874988818120757860089031862e-16L, }, 
   { 0.55511151231257827021181583404541015625e-16L, 0.555111512312578254804376278947523901992e-16L, 0.5551115123125782856192553891432972657927e-16L, }, 
   { -0.55511151231257827021181583404541015625e-16L, -0.5551115123125782856192553891432975508876e-16L, -0.5551115123125782548043762789475236168971e-16L, }, 
   { 0.3925231146709437648483455929908908728559e-16L, 0.3925231146709437571446258154419476622245e-16L, 0.392523114670943772552065370539834385876e-16L, }, 
   { -0.3925231146709437648483455929908908728559e-16L, -0.3925231146709437725520653705398344866723e-16L, -0.3925231146709437571446258154419475614282e-16L, }, 
   { 0.277555756156289135105907917022705078125e-16L, 0.2775557561562891312540480282482334432868e-16L, 0.2775557561562891389577678057971768198738e-16L, }, 
   { -0.277555756156289135105907917022705078125e-16L, -0.2775557561562891389577678057971768555107e-16L, -0.2775557561562891312540480282482334076499e-16L, }, 
   { 0.1962615573354718824241727964954454364279e-16L, 0.196261557335471880498242852108209608571e-16L, 0.1962615573354718843501027408826813020834e-16L, }, 
   { -0.1962615573354718824241727964954454364279e-16L, -0.196261557335471884350102740882681314683e-16L, -0.1962615573354718804982428521082095959715e-16L, }, 
   { 0.1387778780781445675529539585113525390625e-16L, 0.1387778780781445665899889863177346214437e-16L, 0.1387778780781445685159189307049704700451e-16L, }, 
   { -0.1387778780781445675529539585113525390625e-16L, -0.1387778780781445685159189307049704744997e-16L, -0.1387778780781445665899889863177346169891e-16L, }, 
   { 0.9813077866773594121208639824772271821396e-17L, 0.9813077866773594073060391215091375809985e-17L, 0.981307786677359416935688843445316830529e-17L, }, 
   { -0.9813077866773594121208639824772271821396e-17L, -0.9813077866773594169356888434453168462784e-17L, -0.9813077866773594073060391215091375652491e-17L, }, 
   { 0.6938893903907228377647697925567626953125e-17L, 0.693889390390722835357357362072717890129e-17L, 0.6938893903907228401721822230408075172007e-17L, }, 
   { -0.6938893903907228377647697925567626953125e-17L, -0.693889390390722840172182223040807522769e-17L, -0.6938893903907228353573573620727178845608e-17L, }, 
   { 0.4906538933386797060604319912386135910698e-17L, 0.4906538933386797048567257759965911868472e-17L, 0.4906538933386797072641382064806360011985e-17L, }, 
   { -0.4906538933386797060604319912386135910698e-17L, -0.4906538933386797072641382064806360031672e-17L, -0.4906538933386797048567257759965911848785e-17L, }, 
   { 0.3469446951953614188823848962783813476563e-17L, 0.3469446951953614182805317886573701449683e-17L, 0.3469446951953614194842380038993925524323e-17L, }, 
   { -0.3469446951953614188823848962783813476563e-17L, -0.3469446951953614194842380038993925531283e-17L, -0.3469446951953614182805317886573701442723e-17L, }, 
   { 0.2453269466693398530302159956193067955349e-17L, 0.2453269466693398527292894418088011939871e-17L, 0.245326946669339853331142549429812397821e-17L, }, 
   { -0.2453269466693398530302159956193067955349e-17L, -0.2453269466693398533311425494298123980671e-17L, -0.245326946669339852729289441808801193741e-17L, }, 
   { 0.1734723475976807094411924481391906738281e-17L, 0.1734723475976807092907291712339378729821e-17L, 0.1734723475976807095916557250444434749351e-17L, }, 
   { -0.1734723475976807094411924481391906738281e-17L, -0.1734723475976807095916557250444434750221e-17L, -0.1734723475976807092907291712339378728951e-17L, }, 
   { 0.1226634733346699265151079978096533977675e-17L, 0.122663473334669926439876359357026997319e-17L, 0.1226634733346699265903396362622797983082e-17L, }, 
   { -0.1226634733346699265151079978096533977675e-17L, -0.122663473334669926590339636262279798339e-17L, -0.1226634733346699264398763593570269972882e-17L, }, 
   { 0.8673617379884035472059622406959533691406e-18L, 0.8673617379884035468298040484328213668081e-18L, 0.8673617379884035475821204329590853717994e-18L, }, 
   { -0.8673617379884035472059622406959533691406e-18L, -0.8673617379884035475821204329590853719081e-18L, -0.8673617379884035468298040484328213666994e-18L, }, 
   { 0.6133173666733496325755399890482669888373e-18L, 0.6133173666733496323874608929167009876392e-18L, 0.6133173666733496327636190851798329901507e-18L, }, 
   { -0.6133173666733496325755399890482669888373e-18L, -0.6133173666733496327636190851798329901892e-18L, -0.6133173666733496323874608929167009876007e-18L, }, 
   { 0.4336808689942017736029811203479766845703e-18L, 0.43368086899420177350894157228219368396e-18L, 0.4336808689942017736970206684137596852214e-18L, }, 
   { -0.4336808689942017736029811203479766845703e-18L, -0.433680868994201773697020668413759685235e-18L, -0.4336808689942017735089415722821936839464e-18L, }, 
   { 0.3066586833366748162877699945241334944186e-18L, 0.3066586833366748162407502204912419941095e-18L, 0.3066586833366748163347897685570249947422e-18L, }, 
   { -0.3066586833366748162877699945241334944186e-18L, -0.306658683336674816334789768557024994747e-18L, -0.3066586833366748162407502204912419941047e-18L, }, 
   { 0.2168404344971008868014905601739883422852e-18L, 0.2168404344971008867779806731575425921292e-18L, 0.2168404344971008868250004471904340924462e-18L, }, 
   { -0.2168404344971008868014905601739883422852e-18L, -0.2168404344971008868250004471904340924479e-18L, -0.2168404344971008867779806731575425921275e-18L, }, 
   { 0.1533293416683374081438849972620667472093e-18L, 0.1533293416683374081321300537538438721308e-18L, 0.1533293416683374081556399407702896222896e-18L, }, 
   { -0.1533293416683374081438849972620667472093e-18L, -0.1533293416683374081556399407702896222902e-18L, -0.1533293416683374081321300537538438721302e-18L, }, 
   { 0.1084202172485504434007452800869941711426e-18L, 0.1084202172485504433948678083328827336032e-18L, 0.1084202172485504434066227518411056086826e-18L, }, 
   { -0.1084202172485504434007452800869941711426e-18L, -0.1084202172485504434066227518411056086828e-18L, -0.1084202172485504433948678083328827336029e-18L, }, 
   { 0.7666467083416870407194249863103337360466e-19L, 0.7666467083416870406900376275397765483489e-19L, 0.7666467083416870407488123450808909237466e-19L, }, 
   { -0.7666467083416870407194249863103337360466e-19L, -0.7666467083416870407488123450808909237473e-19L, -0.7666467083416870406900376275397765483481e-19L, }, 
   { 0.5421010862427522170037264004349708557129e-19L, 0.5421010862427522169890327210496922618638e-19L, 0.5421010862427522170184200798202494495628e-19L, }, 
   { -0.5421010862427522170037264004349708557129e-19L, -0.542101086242752217018420079820249449563e-19L, -0.5421010862427522169890327210496922618635e-19L, }, 
   { 0.3833233541708435203597124931551668680233e-19L, 0.3833233541708435203523656534625275710987e-19L, 0.3833233541708435203670593328478061649482e-19L, }, 
   { -0.3833233541708435203597124931551668680233e-19L, -0.3833233541708435203670593328478061649483e-19L, -0.3833233541708435203523656534625275710986e-19L, }, 
   { 0.2710505431213761085018632002174854278564e-19L, 0.2710505431213761084981897803711657793941e-19L, 0.2710505431213761085055366200638050763189e-19L, }, 
   { -0.2710505431213761085018632002174854278564e-19L, -0.2710505431213761085055366200638050763189e-19L, -0.2710505431213761084981897803711657793941e-19L, }, 
   { 0.1916616770854217601798562465775834340116e-19L, 0.1916616770854217601780195366544236097805e-19L, 0.1916616770854217601816929565007432582429e-19L, }, 
   { -0.1916616770854217601798562465775834340116e-19L, -0.1916616770854217601816929565007432582429e-19L, -0.1916616770854217601780195366544236097805e-19L, }, 
   { 0.1355252715606880542509316001087427139282e-19L, 0.1355252715606880542500132451471628018126e-19L, 0.1355252715606880542518499550703226260438e-19L, }, 
   { -0.1355252715606880542509316001087427139282e-19L, -0.1355252715606880542518499550703226260438e-19L, -0.1355252715606880542500132451471628018126e-19L, }, 
   { 0.9583083854271088008992812328879171700582e-20L, 0.9583083854271088008946894580800176094803e-20L, 0.9583083854271088009038730076958167306363e-20L, }, 
   { -0.9583083854271088008992812328879171700582e-20L, -0.9583083854271088009038730076958167306363e-20L, -0.9583083854271088008946894580800176094803e-20L, }, 
   { 0.6776263578034402712546580005437135696411e-20L, 0.6776263578034402712523621131397637893521e-20L, 0.6776263578034402712569538879476633499301e-20L, }, 
   { -0.6776263578034402712546580005437135696411e-20L, -0.6776263578034402712569538879476633499301e-20L, -0.6776263578034402712523621131397637893521e-20L, }, 
   { 0.4791541927135544004496406164439585850291e-20L, 0.4791541927135544004484926727419836948846e-20L, 0.4791541927135544004507885601459334751736e-20L, }, 
   { -0.4791541927135544004496406164439585850291e-20L, -0.4791541927135544004507885601459334751736e-20L, -0.4791541927135544004484926727419836948846e-20L, }, 
   { 0.3388131789017201356273290002718567848206e-20L, 0.3388131789017201356267550284208693397483e-20L, 0.3388131789017201356279029721228442298928e-20L, }, 
   { -0.3388131789017201356273290002718567848206e-20L, -0.3388131789017201356279029721228442298928e-20L, -0.3388131789017201356267550284208693397483e-20L, }, 
   { 0.2395770963567772002248203082219792925146e-20L, 0.2395770963567772002245333222964855699784e-20L, 0.2395770963567772002251072941474730150507e-20L, }, 
   { -0.2395770963567772002248203082219792925146e-20L, -0.2395770963567772002251072941474730150507e-20L, -0.2395770963567772002245333222964855699784e-20L, }, 
   { 0.1694065894508600678136645001359283924103e-20L, 0.1694065894508600678135210071731815311422e-20L, 0.1694065894508600678138079930986752536783e-20L, }, 
   { -0.1694065894508600678136645001359283924103e-20L, -0.1694065894508600678138079930986752536783e-20L, -0.1694065894508600678135210071731815311422e-20L, }, 
   { 0.1197885481783886001124101541109896462573e-20L, 0.1197885481783886001123384076296162156232e-20L, 0.1197885481783886001124819005923630768913e-20L, }, 
   { -0.1197885481783886001124101541109896462573e-20L, -0.1197885481783886001124819005923630768913e-20L, -0.1197885481783886001123384076296162156232e-20L, }, 
   { 0.8470329472543003390683225006796419620514e-21L, 0.8470329472543003390679637682727748088812e-21L, 0.8470329472543003390686812330865091152215e-21L, }, 
   { -0.8470329472543003390683225006796419620514e-21L, -0.8470329472543003390686812330865091152215e-21L, -0.8470329472543003390679637682727748088812e-21L, }, 
   { 0.5989427408919430005620507705549482312864e-21L, 0.5989427408919430005618714043515146547013e-21L, 0.5989427408919430005622301367583818078715e-21L, }, 
   { -0.5989427408919430005620507705549482312864e-21L, -0.5989427408919430005622301367583818078715e-21L, -0.5989427408919430005618714043515146547013e-21L, }, 
   { 0.4235164736271501695341612503398209810257e-21L, 0.4235164736271501695340715672381041927332e-21L, 0.4235164736271501695342509334415377693182e-21L, }, 
   { -0.4235164736271501695341612503398209810257e-21L, -0.4235164736271501695342509334415377693182e-21L, -0.4235164736271501695340715672381041927332e-21L, }, 
   { 0.2994713704459715002810253852774741156432e-21L, 0.2994713704459715002809805437266157214969e-21L, 0.2994713704459715002810702268283325097895e-21L, }, 
   { -0.2994713704459715002810253852774741156432e-21L, -0.2994713704459715002810702268283325097895e-21L, -0.2994713704459715002809805437266157214969e-21L, }, 
   { 0.2117582368135750847670806251699104905128e-21L, 0.2117582368135750847670582043944812934397e-21L, 0.211758236813575084767103045945339687586e-21L, }, 
   { -0.2117582368135750847670806251699104905128e-21L, -0.211758236813575084767103045945339687586e-21L, -0.2117582368135750847670582043944812934397e-21L, }, 
   { 0.1497356852229857501405126926387370578216e-21L, 0.149735685222985750140501482251022459285e-21L, 0.1497356852229857501405239030264516563582e-21L, }, 
   { -0.1497356852229857501405126926387370578216e-21L, -0.1497356852229857501405239030264516563582e-21L, -0.149735685222985750140501482251022459285e-21L, }, 
   { 0.1058791184067875423835403125849552452564e-21L, 0.1058791184067875423835347073910979459881e-21L, 0.1058791184067875423835459177788125445247e-21L, }, 
   { -0.1058791184067875423835403125849552452564e-21L, -0.1058791184067875423835459177788125445247e-21L, -0.1058791184067875423835347073910979459881e-21L, }, 
   { 0.748678426114928750702563463193685289108e-22L, 0.7486784261149287507025354372243987927666e-22L, 0.7486784261149287507025914891629717854494e-22L, }, 
   { -0.748678426114928750702563463193685289108e-22L, -0.7486784261149287507025914891629717854494e-22L, -0.7486784261149287507025354372243987927666e-22L, }, 
   { 0.5293955920339377119177015629247762262821e-22L, 0.5293955920339377119176875499401329781114e-22L, 0.5293955920339377119177155759094194744528e-22L, }, 
   { -0.5293955920339377119177015629247762262821e-22L, -0.5293955920339377119177155759094194744528e-22L, -0.5293955920339377119176875499401329781114e-22L, }, 
   { 0.374339213057464375351281731596842644554e-22L, 0.3743392130574643753512747251045210204686e-22L, 0.3743392130574643753512887380891642686394e-22L, }, 
   { -0.374339213057464375351281731596842644554e-22L, -0.3743392130574643753512887380891642686394e-22L, -0.3743392130574643753512747251045210204686e-22L, }, 
   { 0.2646977960169688559588507814623881131411e-22L, 0.2646977960169688559588472782162273010984e-22L, 0.2646977960169688559588542847085489251837e-22L, }, 
   { -0.2646977960169688559588507814623881131411e-22L, -0.2646977960169688559588542847085489251837e-22L, -0.2646977960169688559588472782162273010984e-22L, }, 
   { 0.187169606528732187675640865798421322277e-22L, 0.1871696065287321876756391141753409162557e-22L, 0.1871696065287321876756426174215017282983e-22L, }, 
   { -0.187169606528732187675640865798421322277e-22L, -0.1871696065287321876756426174215017282983e-22L, -0.1871696065287321876756391141753409162557e-22L, }, 
   { 0.1323488980084844279794253907311940565705e-22L, 0.1323488980084844279794245149196538535599e-22L, 0.1323488980084844279794262665427342595812e-22L, }, 
   { -0.1323488980084844279794253907311940565705e-22L, -0.1323488980084844279794262665427342595812e-22L, -0.1323488980084844279794245149196538535599e-22L, }, 
   { 0.935848032643660938378204328992106611385e-23L, 0.9358480326436609383781999499344055963317e-23L, 0.9358480326436609383782087080498076264383e-23L, }, 
   { -0.935848032643660938378204328992106611385e-23L, -0.9358480326436609383782087080498076264383e-23L, -0.9358480326436609383781999499344055963317e-23L, }, 
   { 0.6617444900424221398971269536559702828526e-23L, 0.661744490042422139897124764127119775326e-23L, 0.6617444900424221398971291431848207903793e-23L, }, 
   { -0.6617444900424221398971269536559702828526e-23L, -0.6617444900424221398971291431848207903793e-23L, -0.661744490042422139897124764127119775326e-23L, }, 
   { 0.4679240163218304691891021644960533056925e-23L, 0.4679240163218304691891010697316280519292e-23L, 0.4679240163218304691891032592604785594558e-23L, }, 
   { -0.4679240163218304691891021644960533056925e-23L, -0.4679240163218304691891032592604785594558e-23L, -0.4679240163218304691891010697316280519292e-23L, }, 
   { 0.3308722450212110699485634768279851414263e-23L, 0.3308722450212110699485629294457725145447e-23L, 0.330872245021211069948564024210197768308e-23L, }, 
   { -0.3308722450212110699485634768279851414263e-23L, -0.330872245021211069948564024210197768308e-23L, -0.3308722450212110699485629294457725145447e-23L, }, 
   { 0.2339620081609152345945510822480266528463e-23L, 0.2339620081609152345945508085569203394054e-23L, 0.2339620081609152345945513559391329662871e-23L, }, 
   { -0.2339620081609152345945510822480266528463e-23L, -0.2339620081609152345945513559391329662871e-23L, -0.2339620081609152345945508085569203394054e-23L, }, 
   { 0.1654361225106055349742817384139925707132e-23L, 0.1654361225106055349742816015684394139927e-23L, 0.1654361225106055349742818752595457274336e-23L, }, 
   { -0.1654361225106055349742817384139925707132e-23L, -0.1654361225106055349742818752595457274336e-23L, -0.1654361225106055349742816015684394139927e-23L, }, 
   { 0.1169810040804576172972755411240133264231e-23L, 0.1169810040804576172972754727012367480629e-23L, 0.1169810040804576172972756095467899047833e-23L, }, 
   { -0.1169810040804576172972755411240133264231e-23L, -0.1169810040804576172972756095467899047833e-23L, -0.1169810040804576172972754727012367480629e-23L, }, 
   { 0.8271806125530276748714086920699628535658e-24L, 0.8271806125530276748714083499560799617648e-24L, 0.8271806125530276748714090341838457453669e-24L, }, 
   { -0.8271806125530276748714086920699628535658e-24L, -0.8271806125530276748714090341838457453669e-24L, -0.8271806125530276748714083499560799617648e-24L, }, 
   { 0.5849050204022880864863777056200666321156e-24L, 0.5849050204022880864863775345631251862151e-24L, 0.5849050204022880864863778766770080780161e-24L, }, 
   { -0.5849050204022880864863777056200666321156e-24L, -0.5849050204022880864863778766770080780161e-24L, -0.5849050204022880864863775345631251862151e-24L, }, 
   { 0.4135903062765138374357043460349814267829e-24L, 0.4135903062765138374357042605065107038326e-24L, 0.4135903062765138374357044315634521497332e-24L, }, 
   { -0.4135903062765138374357043460349814267829e-24L, -0.4135903062765138374357044315634521497332e-24L, -0.4135903062765138374357042605065107038326e-24L, }, 
   { 0.2924525102011440432431888528100333160578e-24L, 0.2924525102011440432431888100457979545827e-24L, 0.2924525102011440432431888955742686775329e-24L, }, 
   { -0.2924525102011440432431888528100333160578e-24L, -0.2924525102011440432431888955742686775329e-24L, -0.2924525102011440432431888100457979545827e-24L, }, 
   { 0.2067951531382569187178521730174907133915e-24L, 0.2067951531382569187178521516353730326539e-24L, 0.206795153138256918717852194399608394129e-24L, }, 
   { -0.2067951531382569187178521730174907133915e-24L, -0.206795153138256918717852194399608394129e-24L, -0.2067951531382569187178521516353730326539e-24L, }, 
   { 0.1462262551005720216215944264050166580289e-24L, 0.1462262551005720216215944157139578176601e-24L, 0.1462262551005720216215944370960754983977e-24L, }, 
   { -0.1462262551005720216215944264050166580289e-24L, -0.1462262551005720216215944370960754983977e-24L, -0.1462262551005720216215944157139578176601e-24L, }, 
   { 0.1033975765691284593589260865087453566957e-24L, 0.1033975765691284593589260811632159365113e-24L, 0.1033975765691284593589260918542747768801e-24L, }, 
   { -0.1033975765691284593589260865087453566957e-24L, -0.1033975765691284593589260918542747768801e-24L, -0.1033975765691284593589260811632159365113e-24L, }, 
   { 0.7311312755028601081079721320250832901445e-25L, 0.7311312755028601081079721052974361892226e-25L, 0.7311312755028601081079721587527303910665e-25L, }, 
   { -0.7311312755028601081079721320250832901445e-25L, -0.7311312755028601081079721587527303910665e-25L, -0.7311312755028601081079721052974361892226e-25L, }, 
   { 0.5169878828456422967946304325437267834786e-25L, 0.5169878828456422967946304191799032330177e-25L, 0.5169878828456422967946304459075503339396e-25L, }, 
   { -0.5169878828456422967946304325437267834786e-25L, -0.5169878828456422967946304459075503339396e-25L, -0.5169878828456422967946304191799032330177e-25L, }, 
   { 0.3655656377514300540539860660125416450723e-25L, 0.3655656377514300540539860593306298698418e-25L, 0.3655656377514300540539860726944534203028e-25L, }, 
   { -0.3655656377514300540539860660125416450723e-25L, -0.3655656377514300540539860726944534203028e-25L, -0.3655656377514300540539860593306298698418e-25L, }, 
   { 0.2584939414228211483973152162718633917393e-25L, 0.2584939414228211483973152129309075041241e-25L, 0.2584939414228211483973152196128192793546e-25L, }, 
   { -0.2584939414228211483973152162718633917393e-25L, -0.2584939414228211483973152196128192793546e-25L, -0.2584939414228211483973152129309075041241e-25L, }, 
   { 0.1827828188757150270269930330062708225361e-25L, 0.1827828188757150270269930313357928787285e-25L, 0.1827828188757150270269930346767487663438e-25L, }, 
   { -0.1827828188757150270269930330062708225361e-25L, -0.1827828188757150270269930346767487663438e-25L, -0.1827828188757150270269930313357928787285e-25L, }, 
   { 0.1292469707114105741986576081359316958697e-25L, 0.1292469707114105741986576073006927239658e-25L, 0.1292469707114105741986576089711706677735e-25L, }, 
   { -0.1292469707114105741986576081359316958697e-25L, -0.1292469707114105741986576089711706677735e-25L, -0.1292469707114105741986576073006927239658e-25L, }, 
   { 0.9139140943785751351349651650313541126807e-26L, 0.9139140943785751351349651608551592531616e-26L, 0.9139140943785751351349651692075489721997e-26L, }, 
   { -0.9139140943785751351349651650313541126807e-26L, -0.9139140943785751351349651692075489721997e-26L, -0.9139140943785751351349651608551592531616e-26L, }, 
   { 0.6462348535570528709932880406796584793483e-26L, 0.6462348535570528709932880385915610495888e-26L, 0.6462348535570528709932880427677559091078e-26L, }, 
   { -0.6462348535570528709932880406796584793483e-26L, -0.6462348535570528709932880427677559091078e-26L, -0.6462348535570528709932880385915610495888e-26L, }, 
   { 0.4569570471892875675674825825156770563403e-26L, 0.4569570471892875675674825814716283414606e-26L, 0.4569570471892875675674825835597257712201e-26L, }, 
   { -0.4569570471892875675674825825156770563403e-26L, -0.4569570471892875675674825835597257712201e-26L, -0.4569570471892875675674825814716283414606e-26L, }, 
   { 0.3231174267785264354966440203398292396741e-26L, 0.3231174267785264354966440198178048822343e-26L, 0.323117426778526435496644020861853597114e-26L, }, 
   { -0.3231174267785264354966440203398292396741e-26L, -0.323117426778526435496644020861853597114e-26L, -0.3231174267785264354966440198178048822343e-26L, }, 
   { 0.2284785235946437837837412912578385281702e-26L, 0.2284785235946437837837412909968263494502e-26L, 0.2284785235946437837837412915188507068901e-26L, }, 
   { -0.2284785235946437837837412912578385281702e-26L, -0.2284785235946437837837412915188507068901e-26L, -0.2284785235946437837837412909968263494502e-26L, }, 
   { 0.1615587133892632177483220101699146198371e-26L, 0.1615587133892632177483220100394085304771e-26L, 0.161558713389263217748322010300420709197e-26L, }, 
   { -0.1615587133892632177483220101699146198371e-26L, -0.161558713389263217748322010300420709197e-26L, -0.1615587133892632177483220100394085304771e-26L, }, 
   { 0.1142392617973218918918706456289192640851e-26L, 0.1142392617973218918918706455636662194051e-26L, 0.1142392617973218918918706456941723087651e-26L, }, 
   { -0.1142392617973218918918706456289192640851e-26L, -0.1142392617973218918918706456941723087651e-26L, -0.1142392617973218918918706455636662194051e-26L, }, 
   { 0.8077935669463160887416100508495730991854e-27L, 0.8077935669463160887416100505233078757854e-27L, 0.8077935669463160887416100511758383225853e-27L, }, 
   { -0.8077935669463160887416100508495730991854e-27L, -0.8077935669463160887416100511758383225853e-27L, -0.8077935669463160887416100505233078757854e-27L, }, 
   { 0.5711963089866094594593532281445963204254e-27L, 0.5711963089866094594593532279814637087255e-27L, 0.5711963089866094594593532283077289321254e-27L, }, 
   { -0.5711963089866094594593532281445963204254e-27L, -0.5711963089866094594593532283077289321254e-27L, -0.5711963089866094594593532279814637087255e-27L, }, 
   { 0.4038967834731580443708050254247865495927e-27L, 0.4038967834731580443708050253432202437427e-27L, 0.4038967834731580443708050255063528554427e-27L, }, 
   { -0.4038967834731580443708050254247865495927e-27L, -0.4038967834731580443708050255063528554427e-27L, -0.4038967834731580443708050253432202437427e-27L, }, 
   { 0.2855981544933047297296766140722981602127e-27L, 0.2855981544933047297296766140315150072877e-27L, 0.2855981544933047297296766141130813131377e-27L, }, 
   { -0.2855981544933047297296766140722981602127e-27L, -0.2855981544933047297296766141130813131377e-27L, -0.2855981544933047297296766140315150072877e-27L, }, 
   { 0.2019483917365790221854025127123932747963e-27L, 0.2019483917365790221854025126920016983338e-27L, 0.2019483917365790221854025127327848512588e-27L, }, 
   { -0.2019483917365790221854025127123932747963e-27L, -0.2019483917365790221854025127327848512588e-27L, -0.2019483917365790221854025126920016983338e-27L, }, 
   { 0.1427990772466523648648383070361490801064e-27L, 0.1427990772466523648648383070259532918751e-27L, 0.1427990772466523648648383070463448683376e-27L, }, 
   { -0.1427990772466523648648383070361490801064e-27L, -0.1427990772466523648648383070463448683376e-27L, -0.1427990772466523648648383070259532918751e-27L, }, 
   { 0.1009741958682895110927012563561966373982e-27L, 0.1009741958682895110927012563510987432825e-27L, 0.1009741958682895110927012563612945315138e-27L, }, 
   { -0.1009741958682895110927012563561966373982e-27L, -0.1009741958682895110927012563612945315138e-27L, -0.1009741958682895110927012563510987432825e-27L, }, 
   { 0.7139953862332618243241915351807454005318e-28L, 0.7139953862332618243241915351552559299537e-28L, 0.7139953862332618243241915352062348711099e-28L, }, 
   { -0.7139953862332618243241915351807454005318e-28L, -0.7139953862332618243241915352062348711099e-28L, -0.7139953862332618243241915351552559299537e-28L, }, 
   { 0.5048709793414475554635062817809831869909e-28L, 0.5048709793414475554635062817682384517018e-28L, 0.5048709793414475554635062817937279222799e-28L, }, 
   { -0.5048709793414475554635062817809831869909e-28L, -0.5048709793414475554635062817937279222799e-28L, -0.5048709793414475554635062817682384517018e-28L, }, 
   { 0.3569976931166309121620957675903727002659e-28L, 0.3569976931166309121620957675840003326214e-28L, 0.3569976931166309121620957675967450679104e-28L, }, 
   { -0.3569976931166309121620957675903727002659e-28L, -0.3569976931166309121620957675967450679104e-28L, -0.3569976931166309121620957675840003326214e-28L, }, 
   { 0.2524354896707237777317531408904915934954e-28L, 0.2524354896707237777317531408873054096732e-28L, 0.2524354896707237777317531408936777773177e-28L, }, 
   { -0.2524354896707237777317531408904915934954e-28L, -0.2524354896707237777317531408936777773177e-28L, -0.2524354896707237777317531408873054096732e-28L, }, 
   { 0.1784988465583154560810478837951863501329e-28L, 0.1784988465583154560810478837935932582218e-28L, 0.1784988465583154560810478837967794420441e-28L, }, 
   { -0.1784988465583154560810478837951863501329e-28L, -0.1784988465583154560810478837967794420441e-28L, -0.1784988465583154560810478837935932582218e-28L, }, 
   { 0.1262177448353618888658765704452457967477e-28L, 0.1262177448353618888658765704444492507921e-28L, 0.1262177448353618888658765704460423427033e-28L, }, 
   { -0.1262177448353618888658765704452457967477e-28L, -0.1262177448353618888658765704460423427033e-28L, -0.1262177448353618888658765704444492507921e-28L, }, 
   { 0.8924942327915772804052394189759317506647e-29L, 0.8924942327915772804052394189719490208869e-29L, 0.8924942327915772804052394189799144804425e-29L, }, 
   { -0.8924942327915772804052394189759317506647e-29L, -0.8924942327915772804052394189799144804425e-29L, -0.8924942327915772804052394189719490208869e-29L, }, 
   { 0.6310887241768094443293828522262289837386e-29L, 0.6310887241768094443293828522242376188496e-29L, 0.6310887241768094443293828522282203486275e-29L, }, 
   { -0.6310887241768094443293828522262289837386e-29L, -0.6310887241768094443293828522282203486275e-29L, -0.6310887241768094443293828522242376188496e-29L, }, 
   { 0.4462471163957886402026197094879658753324e-29L, 0.4462471163957886402026197094869701928879e-29L, 0.4462471163957886402026197094889615577768e-29L, }, 
   { -0.4462471163957886402026197094879658753324e-29L, -0.4462471163957886402026197094889615577768e-29L, -0.4462471163957886402026197094869701928879e-29L, }, 
   { 0.3155443620884047221646914261131144918693e-29L, 0.3155443620884047221646914261126166506471e-29L, 0.3155443620884047221646914261136123330915e-29L, }, 
   { -0.3155443620884047221646914261131144918693e-29L, -0.3155443620884047221646914261136123330915e-29L, -0.3155443620884047221646914261126166506471e-29L, }, 
   { 0.2231235581978943201013098547439829376662e-29L, 0.2231235581978943201013098547437340170551e-29L, 0.2231235581978943201013098547442318582773e-29L, }, 
   { -0.2231235581978943201013098547439829376662e-29L, -0.2231235581978943201013098547442318582773e-29L, -0.2231235581978943201013098547437340170551e-29L, }, 
   { 0.1577721810442023610823457130565572459346e-29L, 0.1577721810442023610823457130564327856291e-29L, 0.1577721810442023610823457130566817062402e-29L, }, 
   { -0.1577721810442023610823457130565572459346e-29L, -0.1577721810442023610823457130566817062402e-29L, -0.1577721810442023610823457130564327856291e-29L, }, 
   { 0.1115617790989471600506549273719914688331e-29L, 0.1115617790989471600506549273719292386803e-29L, 0.1115617790989471600506549273720536989859e-29L, }, 
   { -0.1115617790989471600506549273719914688331e-29L, -0.1115617790989471600506549273720536989859e-29L, -0.1115617790989471600506549273719292386803e-29L, }, 
   { 0.7888609052210118054117285652827862296732e-30L, 0.7888609052210118054117285652824750789093e-30L, 0.7888609052210118054117285652830973804371e-30L, }, 
   { -0.7888609052210118054117285652827862296732e-30L, -0.7888609052210118054117285652830973804371e-30L, -0.7888609052210118054117285652824750789093e-30L, }, 
   { 0.5578088954947358002532746368599573441654e-30L, 0.5578088954947358002532746368598017687835e-30L, 0.5578088954947358002532746368601129195474e-30L, }, 
   { -0.5578088954947358002532746368599573441654e-30L, -0.5578088954947358002532746368601129195474e-30L, -0.5578088954947358002532746368598017687835e-30L, }, 
   { 0.3944304526105059027058642826413931148366e-30L, 0.3944304526105059027058642826413153271456e-30L, 0.3944304526105059027058642826414709025276e-30L, }, 
   { -0.3944304526105059027058642826413931148366e-30L, -0.3944304526105059027058642826414709025276e-30L, -0.3944304526105059027058642826413153271456e-30L, }, 
   { 0.2789044477473679001266373184299786720827e-30L, 0.2789044477473679001266373184299397782372e-30L, 0.2789044477473679001266373184300175659282e-30L, }, 
   { -0.2789044477473679001266373184299786720827e-30L, -0.2789044477473679001266373184300175659282e-30L, -0.2789044477473679001266373184299397782372e-30L, }, 
   { 0.1972152263052529513529321413206965574183e-30L, 0.1972152263052529513529321413206771104956e-30L, 0.197215226305252951352932141320716004341e-30L, }, 
   { -0.1972152263052529513529321413206965574183e-30L, -0.197215226305252951352932141320716004341e-30L, -0.1972152263052529513529321413206771104956e-30L, }, 
   { 0.1394522238736839500633186592149893360414e-30L, 0.13945222387368395006331865921497961258e-30L, 0.1394522238736839500633186592149990595027e-30L, }, 
   { -0.1394522238736839500633186592149893360414e-30L, -0.1394522238736839500633186592149990595027e-30L, -0.13945222387368395006331865921497961258e-30L, }, 
   { 0.9860761315262647567646607066034827870915e-31L, 0.9860761315262647567646607066034341697846e-31L, 0.9860761315262647567646607066035314043984e-31L, }, 
   { -0.9860761315262647567646607066034827870915e-31L, -0.9860761315262647567646607066035314043984e-31L, -0.9860761315262647567646607066034341697846e-31L, }, 
   { 0.6972611193684197503165932960749466802068e-31L, 0.6972611193684197503165932960749223715534e-31L, 0.6972611193684197503165932960749709888602e-31L, }, 
   { -0.6972611193684197503165932960749466802068e-31L, -0.6972611193684197503165932960749709888602e-31L, -0.6972611193684197503165932960749223715534e-31L, }, 
   { 0.4930380657631323783823303533017413935458e-31L, 0.493038065763132378382330353301729239219e-31L, 0.4930380657631323783823303533017535478725e-31L, }, 
   { -0.4930380657631323783823303533017413935458e-31L, -0.4930380657631323783823303533017535478725e-31L, -0.493038065763132378382330353301729239219e-31L, }, 
   { 0.3486305596842098751582966480374733401034e-31L, 0.34863055968420987515829664803746726294e-31L, 0.3486305596842098751582966480374794172668e-31L, }, 
   { -0.3486305596842098751582966480374733401034e-31L, -0.3486305596842098751582966480374794172668e-31L, -0.34863055968420987515829664803746726294e-31L, }, 
   { 0.2465190328815661891911651766508706967729e-31L, 0.2465190328815661891911651766508676581912e-31L, 0.2465190328815661891911651766508737353546e-31L, }, 
   { -0.2465190328815661891911651766508706967729e-31L, -0.2465190328815661891911651766508737353546e-31L, -0.2465190328815661891911651766508676581912e-31L, }, 
   { 0.1743152798421049375791483240187366700517e-31L, 0.1743152798421049375791483240187351507609e-31L, 0.1743152798421049375791483240187381893425e-31L, }, 
   { -0.1743152798421049375791483240187366700517e-31L, -0.1743152798421049375791483240187381893425e-31L, -0.1743152798421049375791483240187351507609e-31L, }, 
   { 0.1232595164407830945955825883254353483864e-31L, 0.123259516440783094595582588325434588741e-31L, 0.1232595164407830945955825883254361080319e-31L, }, 
   { -0.1232595164407830945955825883254353483864e-31L, -0.1232595164407830945955825883254361080319e-31L, -0.123259516440783094595582588325434588741e-31L, }, 
   { 0.8715763992105246878957416200936833502585e-32L, 0.8715763992105246878957416200936795520314e-32L, 0.8715763992105246878957416200936871484856e-32L, }, 
   { -0.8715763992105246878957416200936833502585e-32L, -0.8715763992105246878957416200936871484856e-32L, -0.8715763992105246878957416200936795520314e-32L, }, 
   { 0.6162975822039154729779129416271767419322e-32L, 0.6162975822039154729779129416271748428186e-32L, 0.6162975822039154729779129416271786410457e-32L, }, 
   { -0.6162975822039154729779129416271767419322e-32L, -0.6162975822039154729779129416271786410457e-32L, -0.6162975822039154729779129416271748428186e-32L, }, 
   { 0.4357881996052623439478708100468416751293e-32L, 0.4357881996052623439478708100468407255725e-32L, 0.435788199605262343947870810046842624686e-32L, }, 
   { -0.4357881996052623439478708100468416751293e-32L, -0.435788199605262343947870810046842624686e-32L, -0.4357881996052623439478708100468407255725e-32L, }, 
   { 0.3081487911019577364889564708135883709661e-32L, 0.3081487911019577364889564708135878961877e-32L, 0.3081487911019577364889564708135888457445e-32L, }, 
   { -0.3081487911019577364889564708135883709661e-32L, -0.3081487911019577364889564708135888457445e-32L, -0.3081487911019577364889564708135878961877e-32L, }, 
   { 0.2178940998026311719739354050234208375646e-32L, 0.2178940998026311719739354050234206001754e-32L, 0.2178940998026311719739354050234210749538e-32L, }, 
   { -0.2178940998026311719739354050234208375646e-32L, -0.2178940998026311719739354050234210749538e-32L, -0.2178940998026311719739354050234206001754e-32L, }, 
   { 0.154074395550978868244478235406794185483e-32L, 0.1540743955509788682444782354067940667885e-32L, 0.1540743955509788682444782354067943041776e-32L, }, 
   { -0.154074395550978868244478235406794185483e-32L, -0.1540743955509788682444782354067943041776e-32L, -0.1540743955509788682444782354067940667885e-32L, }, 
   { 0.1089470499013155859869677025117104187823e-32L, 0.108947049901315585986967702511710359435e-32L, 0.1089470499013155859869677025117104781296e-32L, }, 
   { -0.1089470499013155859869677025117104187823e-32L, -0.1089470499013155859869677025117104781296e-32L, -0.108947049901315585986967702511710359435e-32L, }, 
   { 0.7703719777548943412223911770339709274152e-33L, 0.7703719777548943412223911770339706306787e-33L, 0.7703719777548943412223911770339712241517e-33L, }, 
   { -0.7703719777548943412223911770339709274152e-33L, -0.7703719777548943412223911770339712241517e-33L, -0.7703719777548943412223911770339706306787e-33L, }, 
   { 0.5447352495065779299348385125585520939116e-33L, 0.5447352495065779299348385125585519455433e-33L, 0.5447352495065779299348385125585522422798e-33L, }, 
   { -0.5447352495065779299348385125585520939116e-33L, -0.5447352495065779299348385125585522422798e-33L, -0.5447352495065779299348385125585519455433e-33L, }, 
   { 0.3851859888774471706111955885169854637076e-33L, 0.3851859888774471706111955885169853895235e-33L, 0.3851859888774471706111955885169855378917e-33L, }, 
   { -0.3851859888774471706111955885169854637076e-33L, -0.3851859888774471706111955885169855378917e-33L, -0.3851859888774471706111955885169853895235e-33L, }, 
   { 0.2723676247532889649674192562792760469558e-33L, 0.2723676247532889649674192562792760098637e-33L, 0.2723676247532889649674192562792760840478e-33L, }, 
   { -0.2723676247532889649674192562792760469558e-33L, -0.2723676247532889649674192562792760840478e-33L, -0.2723676247532889649674192562792760098637e-33L, }, 
   { 0.1925929944387235853055977942584927318538e-33L, 0.1925929944387235853055977942584927133078e-33L, 0.1925929944387235853055977942584927503998e-33L, }, 
   { -0.1925929944387235853055977942584927318538e-33L, -0.1925929944387235853055977942584927503998e-33L, -0.1925929944387235853055977942584927133078e-33L, }, 
   { 0.1361838123766444824837096281396380234779e-33L, 0.1361838123766444824837096281396380142049e-33L, 0.1361838123766444824837096281396380327509e-33L, }, 
   { -0.1361838123766444824837096281396380234779e-33L, -0.1361838123766444824837096281396380327509e-33L, -0.1361838123766444824837096281396380142049e-33L, }, 
   { 0.9629649721936179265279889712924636592691e-34L, 0.962964972193617926527988971292463612904e-34L, 0.9629649721936179265279889712924637056341e-34L, }, 
   { -0.9629649721936179265279889712924636592691e-34L, -0.9629649721936179265279889712924637056341e-34L, -0.962964972193617926527988971292463612904e-34L, }, 
   { 0.6809190618832224124185481406981901173895e-34L, 0.6809190618832224124185481406981900942069e-34L, 0.680919061883222412418548140698190140572e-34L, }, 
   { -0.6809190618832224124185481406981901173895e-34L, -0.680919061883222412418548140698190140572e-34L, -0.6809190618832224124185481406981900942069e-34L, }, 
   { 0.4814824860968089632639944856462318296345e-34L, 0.4814824860968089632639944856462318180433e-34L, 0.4814824860968089632639944856462318412258e-34L, }, 
   { -0.4814824860968089632639944856462318296345e-34L, -0.4814824860968089632639944856462318412258e-34L, -0.4814824860968089632639944856462318180433e-34L, }, 
   { 0.3404595309416112062092740703490950586947e-34L, 0.3404595309416112062092740703490950528991e-34L, 0.3404595309416112062092740703490950644904e-34L, }, 
   { -0.3404595309416112062092740703490950586947e-34L, -0.3404595309416112062092740703490950644904e-34L, -0.3404595309416112062092740703490950528991e-34L, }, 
   { 0.2407412430484044816319972428231159148173e-34L, 0.2407412430484044816319972428231159119194e-34L, 0.2407412430484044816319972428231159177151e-34L, }, 
   { -0.2407412430484044816319972428231159148173e-34L, -0.2407412430484044816319972428231159177151e-34L, -0.2407412430484044816319972428231159119194e-34L, }, 
   { 0.1702297654708056031046370351745475293474e-34L, 0.1702297654708056031046370351745475278985e-34L, 0.1702297654708056031046370351745475307963e-34L, }, 
   { -0.1702297654708056031046370351745475293474e-34L, -0.1702297654708056031046370351745475307963e-34L, -0.1702297654708056031046370351745475278985e-34L, }, 
   { 0.1203706215242022408159986214115579574086e-34L, 0.1203706215242022408159986214115579566842e-34L, 0.1203706215242022408159986214115579581331e-34L, }, 
   { -0.1203706215242022408159986214115579574086e-34L, -0.1203706215242022408159986214115579581331e-34L, -0.1203706215242022408159986214115579566842e-34L, }, 
   { 0.8511488273540280155231851758727376467368e-35L, 0.8511488273540280155231851758727376431146e-35L, 0.8511488273540280155231851758727376503591e-35L, }, 
   { -0.8511488273540280155231851758727376467368e-35L, -0.8511488273540280155231851758727376503591e-35L, -0.8511488273540280155231851758727376431146e-35L, }, 
   { 0.6018531076210112040799931070577897870432e-35L, 0.601853107621011204079993107057789785232e-35L, 0.6018531076210112040799931070577897888543e-35L, }, 
   { -0.6018531076210112040799931070577897870432e-35L, -0.6018531076210112040799931070577897888543e-35L, -0.601853107621011204079993107057789785232e-35L, }, 
   { 0.4255744136770140077615925879363688233684e-35L, 0.4255744136770140077615925879363688224628e-35L, 0.425574413677014007761592587936368824274e-35L, }, 
   { -0.4255744136770140077615925879363688233684e-35L, -0.425574413677014007761592587936368824274e-35L, -0.4255744136770140077615925879363688224628e-35L, }, 
   { 0.3009265538105056020399965535288948935216e-35L, 0.3009265538105056020399965535288948930688e-35L, 0.3009265538105056020399965535288948939744e-35L, }, 
   { -0.3009265538105056020399965535288948935216e-35L, -0.3009265538105056020399965535288948939744e-35L, -0.3009265538105056020399965535288948930688e-35L, }, 
   { 0.2127872068385070038807962939681844116842e-35L, 0.2127872068385070038807962939681844114578e-35L, 0.2127872068385070038807962939681844119106e-35L, }, 
   { -0.2127872068385070038807962939681844116842e-35L, -0.2127872068385070038807962939681844119106e-35L, -0.2127872068385070038807962939681844114578e-35L, }, 
   { 0.1504632769052528010199982767644474467608e-35L, 0.1504632769052528010199982767644474466476e-35L, 0.150463276905252801019998276764447446874e-35L, }, 
   { -0.1504632769052528010199982767644474467608e-35L, -0.150463276905252801019998276764447446874e-35L, -0.1504632769052528010199982767644474466476e-35L, }, 
   { 0.1063936034192535019403981469840922058421e-35L, 0.1063936034192535019403981469840922057855e-35L, 0.1063936034192535019403981469840922058987e-35L, }, 
   { -0.1063936034192535019403981469840922058421e-35L, -0.1063936034192535019403981469840922058987e-35L, -0.1063936034192535019403981469840922057855e-35L, }, 
   { 0.7523163845262640050999913838222372338039e-36L, 0.752316384526264005099991383822237233521e-36L, 0.7523163845262640050999913838222372340869e-36L, }, 
   { -0.7523163845262640050999913838222372338039e-36L, -0.7523163845262640050999913838222372340869e-36L, -0.752316384526264005099991383822237233521e-36L, }, 
   { 0.5319680170962675097019907349204610292105e-36L, 0.531968017096267509701990734920461029069e-36L, 0.531968017096267509701990734920461029352e-36L, }, 
   { -0.5319680170962675097019907349204610292105e-36L, -0.531968017096267509701990734920461029352e-36L, -0.531968017096267509701990734920461029069e-36L, }, 
   { 0.376158192263132002549995691911118616902e-36L, 0.3761581922631320025499956919111186168312e-36L, 0.3761581922631320025499956919111186169727e-36L, }, 
   { -0.376158192263132002549995691911118616902e-36L, -0.3761581922631320025499956919111186169727e-36L, -0.3761581922631320025499956919111186168312e-36L, }, 
   { 0.2659840085481337548509953674602305146053e-36L, 0.2659840085481337548509953674602305145699e-36L, 0.2659840085481337548509953674602305146406e-36L, }, 
   { -0.2659840085481337548509953674602305146053e-36L, -0.2659840085481337548509953674602305146406e-36L, -0.2659840085481337548509953674602305145699e-36L, }, 
   { 0.188079096131566001274997845955559308451e-36L, 0.1880790961315660012749978459555593084333e-36L, 0.1880790961315660012749978459555593084687e-36L, }, 
   { -0.188079096131566001274997845955559308451e-36L, -0.1880790961315660012749978459555593084687e-36L, -0.1880790961315660012749978459555593084333e-36L, }, 
   { 0.1329920042740668774254976837301152573026e-36L, 0.1329920042740668774254976837301152572938e-36L, 0.1329920042740668774254976837301152573115e-36L, }, 
   { -0.1329920042740668774254976837301152573026e-36L, -0.1329920042740668774254976837301152573115e-36L, -0.1329920042740668774254976837301152572938e-36L, }, 
   { 0.9403954806578300063749892297777965422549e-37L, 0.9403954806578300063749892297777965422107e-37L, 0.9403954806578300063749892297777965422991e-37L, }, 
   { -0.9403954806578300063749892297777965422549e-37L, -0.9403954806578300063749892297777965422991e-37L, -0.9403954806578300063749892297777965422107e-37L, }, 
   { 0.6649600213703343871274884186505762865131e-37L, 0.664960021370334387127488418650576286491e-37L, 0.6649600213703343871274884186505762865353e-37L, }, 
   { -0.6649600213703343871274884186505762865131e-37L, -0.6649600213703343871274884186505762865353e-37L, -0.664960021370334387127488418650576286491e-37L, }, 
   { 0.4701977403289150031874946148888982711275e-37L, 0.4701977403289150031874946148888982711164e-37L, 0.4701977403289150031874946148888982711385e-37L, }, 
   { -0.4701977403289150031874946148888982711275e-37L, -0.4701977403289150031874946148888982711385e-37L, -0.4701977403289150031874946148888982711164e-37L, }, 
   { 0.3324800106851671935637442093252881432566e-37L, 0.332480010685167193563744209325288143251e-37L, 0.3324800106851671935637442093252881432621e-37L, }, 
   { -0.3324800106851671935637442093252881432566e-37L, -0.3324800106851671935637442093252881432621e-37L, -0.332480010685167193563744209325288143251e-37L, }, 
   { 0.2350988701644575015937473074444491355637e-37L, 0.235098870164457501593747307444449135561e-37L, 0.2350988701644575015937473074444491355665e-37L, }, 
   { -0.2350988701644575015937473074444491355637e-37L, -0.2350988701644575015937473074444491355665e-37L, -0.235098870164457501593747307444449135561e-37L, }, 
   { 0.1662400053425835967818721046626440716283e-37L, 0.1662400053425835967818721046626440716269e-37L, 0.1662400053425835967818721046626440716297e-37L, }, 
   { -0.1662400053425835967818721046626440716283e-37L, -0.1662400053425835967818721046626440716297e-37L, -0.1662400053425835967818721046626440716269e-37L, }, 
   { 0.1175494350822287507968736537222245677819e-37L, 0.1175494350822287507968736537222245677812e-37L, 0.1175494350822287507968736537222245677826e-37L, }, 
   { -0.1175494350822287507968736537222245677819e-37L, -0.1175494350822287507968736537222245677826e-37L, -0.1175494350822287507968736537222245677812e-37L, }, 
   { 0.8312000267129179839093605233132203581414e-38L, 0.831200026712917983909360523313220358138e-38L, 0.8312000267129179839093605233132203581449e-38L, }, 
   { -0.8312000267129179839093605233132203581414e-38L, -0.8312000267129179839093605233132203581449e-38L, -0.831200026712917983909360523313220358138e-38L, }, 
   { 0.5877471754111437539843682686111228389093e-38L, 0.5877471754111437539843682686111228389076e-38L, 0.5877471754111437539843682686111228389111e-38L, }, 
   { -0.5877471754111437539843682686111228389093e-38L, -0.5877471754111437539843682686111228389111e-38L, -0.5877471754111437539843682686111228389076e-38L, }, 
   { 0.4156000133564589919546802616566101790707e-38L, 0.4156000133564589919546802616566101790699e-38L, 0.4156000133564589919546802616566101790716e-38L, }, 
   { -0.4156000133564589919546802616566101790707e-38L, -0.4156000133564589919546802616566101790716e-38L, -0.4156000133564589919546802616566101790699e-38L, }, 
   { 0.2938735877055718769921841343055614194547e-38L, 0.2938735877055718769921841343055614194542e-38L, 0.2938735877055718769921841343055614194551e-38L, }, 
   { -0.2938735877055718769921841343055614194547e-38L, -0.2938735877055718769921841343055614194551e-38L, -0.2938735877055718769921841343055614194542e-38L, }, 
};

template <class T>
void test(T)
{
   static const T two = 2;
   //
   // Fudge factor is 3 epsilon, should be less than that, but some 
   // platforms have poor long double support (some of the test values
   // actually test the accuracy of std::log and std::exp, and it's 
   // usually these, rather than our series expansion that fails otherwise).
   // 
   static const T factor = std::pow(two, 1-std::numeric_limits<T>::digits) * 300;
   for(unsigned i = 0; i < sizeof(data)/sizeof(data[0]); ++i)
   {
      T input_value = static_cast<T>(data[i][0]);
      T expected_log1p = static_cast<T>(data[i][1]);
      T expected_expm1 = static_cast<T>(data[i][2]);
      BOOST_CHECK_CLOSE(boost::math::log1p(input_value), expected_log1p, factor);
      BOOST_CHECK_CLOSE(boost::math::expm1(input_value), expected_expm1, factor);
      BOOST_CHECK_CLOSE(boost::math::expm1(-input_value), -boost::math::expm1(input_value)/static_cast<T>(std::exp(input_value)), 2*factor);
   }   
   //
   // C99 Appendix F special cases:
   static const T zero = 0;
   static const T m_one = -1;
   BOOST_CHECK_EQUAL(boost::math::log1p(zero), zero);
   BOOST_CHECK_EQUAL(boost::math::log1p(-zero), zero);
   BOOST_CHECK_EQUAL(boost::math::expm1(zero), zero);
   if(std::numeric_limits<T>::has_infinity)
   {
      #ifndef __SYMBIAN32__ 
      BOOST_CHECK_EQUAL(boost::math::log1p(m_one), -std::numeric_limits<T>::infinity());
      BOOST_CHECK_EQUAL(boost::math::expm1(-std::numeric_limits<T>::infinity()), m_one);
      #endif
      BOOST_CHECK_EQUAL(boost::math::expm1(std::numeric_limits<T>::infinity()), std::numeric_limits<T>::infinity());
   }
}


int test_main(int, char* [])
{
   std::cout << "Running float tests" << std::endl;
   test(float(0));
   std::cout << "Running double tests" << std::endl;
   test(double(0));

#ifndef __SYMBIAN32__    //long double not supported
   //
   // The long double version of these tests fails on some platforms
   // due to poor std lib support (not enough digits returned from 
   // std::log and std::exp):
   //
#if !defined(__CYGWIN__) && !defined(__FreeBSD__) && !(defined(__GNUC__) && defined(__sun))
   std::cout << "Running long double tests" << std::endl;
   test((long double)(0));
#else
   std::cout << "<note>The long double tests have been disabled on this platform "
      "either because the long double overloads of the usual math functions are "
      "not available at all, or because they are too inaccurate for these tests "
      "to pass.</note>" << std::cout;
#endif
#endif
   return 0;
}
