/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/

#include "liboil/liboil.h"
#include <liboil/globals.h>

#include <stdio.h>
#include <stdlib.h>

#define LOG_FILE "c:\\logs\\testapps_oil_resample_linear_u8.txt"
#include "std_log_result.h"
#define LOG_FILENAME_LINE __FILE__, __LINE__

void create_xml(int result)
{
    if(result)
        assert_failed = 1;
    
    testResultXml("testapps_oil_resample_linear_u8");
    close_log_file();
}
#define TEST_ARRAY_SIZE 24

int main()
{
    int ref=0,ref1=0;
    uint8_t src[] = {0x00, 0x00, 0xFF, 0xFF, 0x0F, 0xFF, 0xF0, 0x0F, 0xFF, 0xAA, 0xAB, 0x45, 0x1A, 0x8A, 0xBC, 0x0C, 0xDD, 0x09, 0x19, 0x72, 0xBF, 0xB6, 0x70, 0x45};
    uint8_t dest[TEST_ARRAY_SIZE];
    uint8_t res_linux_1000[] = {0,0,0xFF,0xFF,0xF,0xFF,0xF0,0xF,0xFF,0xAA,0xAB,0x45,0x1A,0x8A,0xBC,0xC,0xDD,0x9,0x19,0x72,0xBF,0xB6,0x70,0x0,0x0,0xFF,0xFE,0xF,0xFE,0xEF,0xF,0xFE,0xAA,0xAA,0x44,0x1A,0x8A,0xBB,0xC,0xDC,0x9,0x19,0x72,0xBE,0xB5,0x6F,0x0,0x76,0xFF,0x8F,0x7E,0xF8,0x87,0x7E,0xD7,0xAA,0x7B,0x31,0x4E,0xA1,0x6A,0x6D,0x7A,0x10,0x42,0x95,0xBA,0x95,0x5C,0x0,0x9F,0xFF,0x69,0xA5,0xF5,0x63,0xA5,0xC9,0xAA,0x6B,0x2A,0x60,0xA9,0x4E,0x8E,0x58,0x13,0x50,0xA2,0xB9,0x8A,0x55,0x0,0xFD,0xFF,0x10,0xFD,0xF0,0x10,0xFD,0xAA,0xAA,0x45,0x1A,0x89,0xBB,0xD,0xDB,0xA,0x18,0x71,0xBE,0xB6,0x70,0x45,0x0,0xFE,0xFF,0xF,0xFE,0xF0,0xF,0xFE,0xAA,0xAA,0x45,0x1A,0x89,0xBB,0xC,0xDC,0x9,0x18,0x71,0xBE,0xB6,0x70,0x45};
    uint8_t res_linux_2000[] = {0,0xFF,0xF,0xF0,0xFF,0xAB,0x1A,0xBC,0xDD,0x19,0xBF,0x0,0xFF,0xF,0xEF,0xFE,0xAA,0x1A,0xBB,0xDC,0x19,0xBE,0x0,0xFF,0x7E,0x87,0xD7,0x7B,0x4E,0x6A,0x7A,0x42,0xBA,0x0,0xFF,0xA5,0x63,0xC9,0x6B,0x60,0x4E,0x58,0x50,0xB9,0x0,0xFF,0xFD,0x10,0xAA,0x45,0x89,0xD,0xA,0x71,0xB6,0x0,0xFF,0xFE,0xF,0xAA,0x45,0x89,0xC,0x9,0x71,0xb6};
    uint8_t res_linux_4000[] = {0,0xF,0xFF,0x1A,0xDD,0x0,0xF,0xFE,0x1A,0xDc,0x0,0x7E,0xD7,0x4E,0x7A,0x0,0xA5,0xc9,0x60,0x58,0x0,0xFD,0xAA,0x89,0xA,0x0,0xFE,0xAA,0x89,0x9};
    uint32_t mul[] = { 0x00000000,
              0x00000100, 
              0x00007700,
              0x0000A000,
              0x0000FE00,
              0x0000FF00,
            };
    uint32_t inc[] = { 0x00010000, TEST_ARRAY_SIZE-1,
              0x00020000, TEST_ARRAY_SIZE/2 - 1,
              0x00040000, TEST_ARRAY_SIZE/4 - 1,
            };
    uint32_t i,j,k;
    uint32_t in[2];


    oil_init();
    for (j=0; j<(sizeof(inc)/sizeof(uint32_t)); j=j+2){
        in[1] = inc[j];
        std_log(LOG_FILENAME_LINE,"For in[1]=%10x\n", inc[j]);
        ref1=0;
        for (i=0; i<(sizeof(mul)/sizeof(uint32_t)); i++){
            in[0] = mul[i];
            oil_resample_linear_u8(dest, src, (int)inc[j+1], in);
            for (k=0; k<inc[j+1]; k++)
            {
            std_log(LOG_FILENAME_LINE,"k=%d\tdest[k]=%10x\tin[0]=%10x\tmul[i]=%10x\n", k, dest[k], in[0], mul[i]);
                if(!ref)
                {
                    if(dest[k]!=res_linux_1000[ref1])
                    {
                    std_log(LOG_FILENAME_LINE,"Failed case at %d,%d \n",dest[k],res_linux_1000[ref1]);
                    assert_failed=1;
                    }
                }
                else if(ref==1)
                {
                    if(dest[k]!=res_linux_2000[ref1])
                    {
                    std_log(LOG_FILENAME_LINE,"Failed case at %d,%d \n",dest[k],res_linux_2000[ref1]);                 
                    assert_failed=1;
                    }
                }
                else
                {
                    if(dest[k]!=res_linux_4000[ref1])
                    {
                    std_log(LOG_FILENAME_LINE,"Failed case at %d,%d \n",dest[k],res_linux_4000[ref1]);
                    assert_failed=1;
                    }
                }
                        ref1++;
            }
        }
        ref++;
    }
    if(assert_failed)
          std_log(LOG_FILENAME_LINE,"Test Fail");
    else
          std_log(LOG_FILENAME_LINE,"Test Successful");
    create_xml(0);
    return 0;
}
