/*
 * Portions Copyright (c) 2008 Nokia Corporation and/or its subsidiary(-ies). All rights reserved.
 *
 * Copyright (c) 1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */
#include "stlport_prefix.h"

#ifndef _STLP_NO_MBSTATE_T

#include <locale>
#include <algorithm>

_STLP_BEGIN_NAMESPACE

//----------------------------------------------------------------------
// codecvt<char, char, mbstate_t>

_STLP_DECLSPEC codecvt<char, char, mbstate_t>::~codecvt() {}

_STLP_DECLSPEC int codecvt<char, char, mbstate_t>::do_length(const mbstate_t&,
                                              const  char* from,
                                              const  char* end,
                                              size_t mx) const
{ return (int)(min) ( __STATIC_CAST(size_t, (end - from)), mx); }

_STLP_DECLSPEC int codecvt<char, char, mbstate_t>::do_max_length() const _STLP_NOTHROW
{ return 1; }

_STLP_DECLSPEC bool
codecvt<char, char, mbstate_t>::do_always_noconv() const _STLP_NOTHROW
{ return true; }

_STLP_DECLSPEC int
codecvt<char, char, mbstate_t>::do_encoding() const _STLP_NOTHROW
{ return 1; }

_STLP_DECLSPEC codecvt_base::result
codecvt<char, char, mbstate_t>::do_unshift(mbstate_t& /* __state */,
                                           char*      __to,
                                           char*      /* __to_limit */,
                                           char*&     __to_next) const
{ __to_next = __to; return noconv; }

_STLP_DECLSPEC codecvt_base::result
codecvt<char, char, mbstate_t>::do_in (mbstate_t&   /* __state */ ,
                                       const char*  __from,
                                       const char*  /* __from_end */,
                                       const char*& __from_next,
                                       char*        __to,
                                       char*        /* __to_end */,
                                       char*&       __to_next) const
{ __from_next = __from; __to_next   = __to; return noconv; }

_STLP_DECLSPEC codecvt_base::result
codecvt<char, char, mbstate_t>::do_out(mbstate_t&   /* __state */,
                                       const char*  __from,
                                       const char*  /* __from_end */,
                                       const char*& __from_next,
                                       char*        __to,
                                       char*        /* __to_limit */,
                                       char*&       __to_next) const
{ __from_next = __from; __to_next   = __to; return noconv; }


#if !defined (_STLP_NO_WCHAR_T)
//----------------------------------------------------------------------
// codecvt<wchar_t, char, mbstate_t>

_STLP_DECLSPEC codecvt<wchar_t, char, mbstate_t>::~codecvt() {}


_STLP_DECLSPEC codecvt<wchar_t, char, mbstate_t>::result
codecvt<wchar_t, char, mbstate_t>::do_out(state_type&         /* state */,
                                          const intern_type*  from,
                                          const intern_type*  from_end,
                                          const intern_type*& from_next,
                                          extern_type*        to,
                                          extern_type*        to_limit,
                                          extern_type*&       to_next) const {
  ptrdiff_t len = (min) (from_end - from, to_limit - to);
  copy(from, from + len, to);
  from_next = from + len;
  to_next   = to   + len;
  return ok;
}

_STLP_DECLSPEC codecvt<wchar_t, char, mbstate_t>::result
codecvt<wchar_t, char, mbstate_t>::do_in (state_type&       /* state */,
                                          const extern_type*  from,
                                          const extern_type*  from_end,
                                          const extern_type*& from_next,
                                          intern_type*        to,
                                          intern_type*        to_limit,
                                          intern_type*&       to_next) const {
  ptrdiff_t len = (min) (from_end - from, to_limit - to);
  copy(__REINTERPRET_CAST(const unsigned char*, from),
       __REINTERPRET_CAST(const unsigned char*, from) + len, to);
  from_next = from + len;
  to_next   = to   + len;
  return ok;
}

_STLP_DECLSPEC codecvt<wchar_t, char, mbstate_t>::result
codecvt<wchar_t, char, mbstate_t>::do_unshift(state_type&   /* state */,
                                              extern_type*  to,
                                              extern_type*  ,
                                              extern_type*& to_next) const {
  to_next = to;
  return noconv;
}

_STLP_DECLSPEC int codecvt<wchar_t, char, mbstate_t>::do_encoding() const _STLP_NOTHROW
#ifdef SYMBIAN_OE_ENHANCED_LOCALE_SUPPORT
{
	int __ret = 0;
    if (MB_CUR_MAX == 1)
      __ret = 1;
    return __ret;
 }
#else
{ return 1; }
#endif

_STLP_DECLSPEC bool codecvt<wchar_t, char, mbstate_t>::do_always_noconv() const _STLP_NOTHROW
{ return true; }

_STLP_DECLSPEC int codecvt<wchar_t, char, mbstate_t>::do_length(const  state_type&,
                                                 const  extern_type* from,
                                                 const  extern_type* end,
                                                 size_t mx) const
{ return (int)(min) ((size_t) (end - from), mx); }

_STLP_DECLSPEC int codecvt<wchar_t, char, mbstate_t>::do_max_length() const _STLP_NOTHROW
{ return 1; }
#endif /* wchar_t */

_STLP_END_NAMESPACE

#endif /* _STLP_NO_MBSTATE_T */

// Local Variables:
// mode:C++
// End:

