/*
 * LIBOIL - Library of Optimized Inner Loops
 * Copyright (c) 2003,2004 David A. Schleef <ds@schleef.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
//Portions Copyright (c)  2008-2009 Nokia Corporation and/or its subsidiary(-ies). All rights reserved. 

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <liboilfunction.h>
#include "liboil/simdpack/simdpack.h"
#include <math.h>

/**
 * oil_diffsquaresum_f32:
 * @d_1:
 * @src1:
 * @sstr1:
 * @src2:
 * @sstr2:
 * @n:
 *
 * Calculates the sum of squared differences between @src1 and @src2
 * and places the result in @d_1.
 */
OIL_DEFINE_CLASS (diffsquaresum_f32,
    "float *d_1, float *src1, int sstr1, float *src2, int sstr2, int n");

static void
diffsquaresum_f32_ref(float *dest, float *src1, int sstr1, float *src2,
    int sstr2, int n)
{
	double sum = 0;
	double errsum = 0;
	double tmp;
	double x;
	int i;

	for(i=0;i<n;i++){
		x = OIL_GET(src1, i*sstr1, float) -
                  OIL_GET(src2, i*sstr2, float);
		x = x*x;
		tmp = sum;
		sum += x;
		errsum += (tmp - sum) + x;
	}

	*dest = sum + errsum;
}

OIL_DEFINE_IMPL_REF (diffsquaresum_f32_ref, diffsquaresum_f32);




#ifdef	__SYMBIAN32__
 
OilFunctionClass* __oil_function_class_diffsquaresum_f32() {
		return &_oil_function_class_diffsquaresum_f32;
}
#endif



#ifdef	__SYMBIAN32__
 
OilFunctionImpl* __oil_function_impl_diffsquaresum_f32_ref() {
		return &_oil_function_impl_diffsquaresum_f32_ref;
}
#endif



#ifdef	__SYMBIAN32__
 
EXPORT_C void** _oil_function_class_ptr_diffsquaresum_f32 ()	{
	oil_function_class_ptr_diffsquaresum_f32 = __oil_function_class_diffsquaresum_f32();
	return &oil_function_class_ptr_diffsquaresum_f32->func;
	}
#endif

