/* libgplugin_a.c - test plugin for testgmodule
 * Copyright (C) 1998 Tim Janik
 * Portion Copyright  2008-09 Nokia Corporation and/or its subsidiary(-ies). All rights reserved.
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GLib Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GLib Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GLib at ftp://ftp.gtk.org/pub/gtk/. 
 */

#undef G_DISABLE_ASSERT
#undef G_LOG_DOMAIN

#include	<gmodule.h>
#include	<stdlib.h>

#ifdef __SYMBIAN32__
G_MODULE_EXPORT gchar* gplugin_a_state = NULL;
#else
G_MODULE_EXPORT gchar* gplugin_a_state;
#endif

G_MODULE_EXPORT void
gplugin_a_func (void)
{
  gplugin_a_state = "Hello world";
}

G_MODULE_EXPORT void
gplugin_clash_func (void)
{
  gplugin_a_state = "plugin clash";
}

G_MODULE_EXPORT void
g_clash_func (void)
{
  gplugin_a_state = "global clash";
}

G_MODULE_EXPORT void
gplugin_say_boo_func (void)
{
  gplugin_a_state = "BOOH";
}

G_MODULE_EXPORT void
gplugin_a_module_func (GModule *module)
{
  void *f = NULL;

  if (!g_module_symbol (module, "gplugin_say_boo_func", &f ))
    {
      g_print ("error: %s\n", g_module_error ());
      exit (1);
    }

  ((void(*)(void)) f) ();
}
