

/***************************************************************************
 *
 * find.first.cpp - test exercising 25.1.4 [lib.alg.find.first.of]
 *
 * $Id: 25.find.first.cpp 354672 2005-12-07 02:42:13Z sebor $
 *
 ***************************************************************************
 *
 * Copyright (c) 1994-2005 Quovadx,  Inc., acting through its  Rogue Wave
 * Software division. Licensed under the Apache License, Version 2.0 (the
 * "License");  you may  not use this file except  in compliance with the
 * License.    You    may   obtain   a   copy   of    the   License    at
 * http://www.apache.org/licenses/LICENSE-2.0.    Unless   required    by
 * applicable law  or agreed to  in writing,  software  distributed under
 * the License is distributed on an "AS IS" BASIS,  WITHOUT WARRANTIES OR
 * CONDITIONS OF  ANY KIND, either  express or implied.  See  the License
 * for the specific language governing permissions  and limitations under
 * the License.
 * 
 **************************************************************************/

#include <algorithm>    // for find_first_of
#include <cstring>      // for size_t, strlen()

#include <alg_test.h>   
#include <driver.h>     // for rw_test
#include"std_log_result.h"
#define LOG_FILENAME_LINE __FILE__, __LINE__
int failures=0;

/**************************************************************************/

_RWSTD_NAMESPACE (std) { 

#ifndef _RWSTD_NO_EXPLICIT_INSTANTIATION

template
FwdIter<eq_comp<base<> > >
find_first_of (FwdIter<eq_comp<base<> > >, FwdIter<eq_comp<base<> > >, 
               FwdIter<eq_comp<base<> > >, FwdIter<eq_comp<base<> > >);

template
FwdIter<eq_comp<base<> > >
find_first_of (FwdIter<eq_comp<base<> > >, FwdIter<eq_comp<base<> > >, 
               FwdIter<eq_comp<base<> > >, FwdIter<eq_comp<base<> > >, 
               binary_predicate<eq_comp<base<> > >);

#endif // _RWSTD_NO_EXPLICIT_INSTANTIATION

}   // namespace std

/**************************************************************************/

template <class T, class U>
struct EqualityPredicate
{
    static std::size_t funcalls_;

    // dummy arguments provided to prevent the class
    // from being default constructible
    EqualityPredicate (T* /* dummy */, U* /* dummy */) {
        funcalls_ = 0;
    }

    // return a type other than bool but one that is implicitly
    // convertible to bool to detect incorrect assumptions
    class ConvertibleToBool {
        bool result_;
    public:
        ConvertibleToBool (bool res): result_ (res) { /* empty */ }
        operator bool() const { return result_; }
    };

    ConvertibleToBool operator() (const T &x, const U &y) /* non-const */ {
        ++funcalls_;
        return x == y;
    }
};

template <class T, class U>
std::size_t EqualityPredicate<T, U>::funcalls_;

/**************************************************************************/

// used to initialize an array of objects of type T
static const char *tinit_begin;

int tinit ()
{
    typedef unsigned char UChar;

    return UChar (*tinit_begin++);
}


// exercises std::find_end()
template <class ForwardIterator1, class ForwardIterator2,
          class Predicate, class T>
void do_test (int               line,     // line number of test case
              const char       *src,      // source sequence
              const char       *fseq,     // sequence to be found
              std::size_t       resoff,   // offset of result
              ForwardIterator1 &dummy_iter1,
              ForwardIterator2 &dummy_iter2,
              const T*,
              const Predicate  *pred)
{
    static const char* const it1name = type_name (dummy_iter1, (T*)0);
    static const char* const it2name = type_name (dummy_iter2, (T*)0);
    static const char* const pname   = pred ? "Predicate" : "operator==";

    #ifdef __SYMBIAN32__
    const std::size_t nsrc  = strlen (src);
    const std::size_t nfseq = strlen (fseq);
    #else
    const std::size_t nsrc  = std::strlen (src);
    const std::size_t nfseq = std::strlen (fseq);
    #endif //__SYMBIAN32__
    
    if (std::size_t (-1) == resoff)
        resoff = nsrc;

    // have the T default ctor initialize objects from `src'
    tinit_begin = src;
    //T::gen_     = tinit;
        gen_     = tinit;

    T* const tsrc = new T [nsrc];

    T* const src_begin = tsrc;
    T* const src_end = tsrc + nsrc;

    // have the T default ctor initialize sequence to be found
    tinit_begin = fseq;

    T* const tfseq = new T [nfseq];

    T* const fseq_begin = tfseq;
    T* const fseq_end   = tfseq + nfseq;

    // create iterators
    const ForwardIterator1 first1 =
        make_iter (src_begin, src_begin, src_end, dummy_iter1);

    const ForwardIterator1 last1 =
        make_iter (src_end, src_begin, src_end, dummy_iter1);

    const ForwardIterator2 first2 =
        make_iter (fseq_begin, fseq_begin, fseq_end, dummy_iter2);

    const ForwardIterator2 last2 =
        make_iter (fseq_end, fseq_begin, fseq_end, dummy_iter2);

    // compute the number of invocations of the operator==()
    //std::size_t last_n_op_assign = T::n_total_op_assign_;
     std::size_t last_n_op_assign = n_total_op_assign_;

    const Predicate fun((T*)0, (T*)0);   // dummy arguments

    const ForwardIterator1 res = pred ? 
          std::find_first_of (first1, last1, first2, last2, fun)
        : std::find_first_of (first1, last1, first2, last2);
    
    // silence a bogus EDG eccp remark #550-D:
    // variable "res" was set but never used
    _RWSTD_UNUSED (res);
      
      if(!(res.cur_ == first1.cur_ + resoff))
      {
        failures++;
       std_log(LOG_FILENAME_LINE,"Reason : Failing ");        
       }
  
    if (!rw_assert (res.cur_ == first1.cur_ + resoff, 0, line, 
                    "line %d: find_first_of<%s, %s>(it = \"%s\", \"%s\")"
                    " == (it + %zu), got (it + %td)",
                    __LINE__, it1name, it2name, src, fseq,
                    resoff, res.cur_ - first1.cur_)) {
        delete[] tsrc;
        delete[] tfseq;
        return;
    }

 /*   const std::size_t npreds = pred ?
        fun.funcalls_ : T::n_total_op_assign_ - last_n_op_assign;
 */
     const std::size_t npreds = pred ?
        fun.funcalls_ : n_total_op_assign_ - last_n_op_assign;

   if(!(npreds <= nfseq * nsrc))
      {
        failures++;
       std_log(LOG_FILENAME_LINE,"Reason : Failing ");        
       }

  
    rw_assert (npreds <= nfseq * nsrc, 0, line, 
               "line %d: find_first_of<%s, %s>(it = \"%s\", \"%s\")"
               "%s invoked %zu times, expected no more than %td",
               __LINE__, it1name, it2name, src, fseq, pname, 
               npreds, nfseq * nsrc);

    delete[] tsrc;
    delete[] tfseq;
}

/**************************************************************************/

template <class ForwardIterator1, class ForwardIterator2,
          class Predicate, class T>
void run_tests (const ForwardIterator1 &dummy_iter1, 
                const ForwardIterator2 &dummy_iter2,
                const T*,
                const Predicate        *pred)
{
    static const char* const it1name = type_name (dummy_iter1, (T*)0);
    static const char* const it2name = type_name (dummy_iter2, (T*)0);

    rw_info (0, 0, 0, 
             "%s std::find_first_of (%1$s, %1$s, %s, %2$s%{?}, %s%{;})", 
             it1name, it2name, 0 != pred, "Predicate");
    
#define TEST(src, fnd, off_res)                         \
    do_test (__LINE__, src, fnd, std::size_t (off_res), \
             dummy_iter1, dummy_iter2, (X*)0, pred)

    //    +------------------ subject sequence
    //    |                 +--- sequence to be found
    //    |                 |   
    //    |                 |      +-- offset of returned iterator,
    //    |                 |      |   -1 denotes the end of sequence
    //    v                 v      v
    TEST ("abcdefghijk",    "a",   0);
      if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("abcdefghijk",    "b",   1);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }
    TEST ("abcdefghijk",    "c",   2);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("abcdefghijk",    "d",   3);
     if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("abcdefghijk",    "e",   4);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("abcdefghijk",    "f",   5);

  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }
    TEST ("abcdefghijk",    "g",   6);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("abcdefghijk",    "h",   7);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("abcdefghijk",    "i",   8);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("abcdefghijk",    "j",   9);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("abcdefghijk",    "k",  10);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("aabcdefghijk",   "a",   0);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("abbcdefghijk",   "b",   1);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("abccdefghijk",   "c",   2);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("abcddefghijk",   "d",   3);

  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }
    TEST ("abcdeefghijk",   "e",   4);

  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }
    TEST ("abcdeffghijk",   "f",   5);

  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }
    TEST ("abcdefgghijk",   "g",   6);

  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }
    TEST ("abcdefghhijk",   "h",   7);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }


    TEST ("abcdefghijjk",   "i",   8);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("abcdefghijjk",   "j",   9);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }
    TEST ("abcdefghijkk",   "k",  10);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("bbcdefghijk",   "ab",   0);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("accdefghijk",   "bc",   1);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("abddefghijk",   "cd",   2);

  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }
    TEST ("abceefghijk",   "de",   3);

  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }
    TEST ("abcdffghijk",   "ef",   4);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("abcdegghijk",   "fg",   5);

  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }
    TEST ("abcdefhhijk",   "gh",   6);

  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }
    TEST ("abcdefgiijk",   "hi",   7);
    if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("abcdefghjjk",   "ij",   8);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("abcdefghikk",   "jk",   9);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("bbcdefghijk",    "a",  -1);

  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }
    TEST ("accdefghijk",    "b",  -1);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("abddefghijk",    "c",  -1);

  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }
    TEST ("abceefghijk",    "d",  -1);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("abcdffghijk",    "e",  -1);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("abcdegghijk",    "f",  -1);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("abcdefhhijk",    "g",  -1);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("abcdefgiijk",    "h",  -1);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("abcdefghjjk",    "i",  -1);

  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }
    TEST ("abcdefghikk",    "j",  -1);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("",               "a",  -1);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

    TEST ("abcdefghijk",    "",   -1);
  if(failures)
       {
        std_log(LOG_FILENAME_LINE,"Reason: Failing");
      }

}


/**************************************************************************/

/* extern */ int rw_opt_no_fwd_iter;     // --no-ForwardIterator
/* extern */ int rw_opt_no_bidir_iter;   // --no-BidirectionalIterator
/* extern */ int rw_opt_no_rnd_iter;     // --no-RandomAccessIterator
/* extern */ int rw_opt_no_predicate;    // --no-Predicate


template <class ForwardIterator, class Predicate, class T>
void run_test (const ForwardIterator &dummy, T*, Predicate* pred)
{
    if (rw_opt_no_fwd_iter) {
        rw_note (0, __FILE__, __LINE__, "ForwardIterator test disabled");
    }
    else {
        run_tests (dummy, FwdIter<T>(), (T*)0, pred);
    }

    if (rw_opt_no_bidir_iter) {
        rw_note (0, __FILE__, __LINE__, "BidirectionalIterator test disabled");
    }
    else {
        run_tests (dummy, BidirIter<T>(), (T*)0, pred);
    }

    if (rw_opt_no_rnd_iter) {
        rw_note (0, __FILE__, __LINE__, "RandomAccessIterator test disabled");
    }
    else {
        run_tests (dummy, RandomAccessIter<T>(), (T*)0, pred);
    }
}

/**************************************************************************/

static void
run_test (bool test_predicate)
{
    rw_info (0, 0, 0, 
             "template <class %s, class %s> "
             "%1$s std::find_first_of (%1$s, %1$s, %2$s, %2$s%{?}, %s%{;})",
             "ForwardIterator1", "ForwardIterator2", 
             0 != test_predicate, "Predicate");

    const EqualityPredicate<X, X>* const pred = test_predicate ?
        (EqualityPredicate<X, X>*)1 : (EqualityPredicate<X, X>*)0;

    if (rw_opt_no_fwd_iter) {
        rw_note (0, __FILE__, __LINE__, "ForwardIterator test disabled");
    }
    else {       
        run_test (FwdIter<X>(), (X*)0, pred);
    }

    if (rw_opt_no_bidir_iter) {
        rw_note (0, __FILE__, __LINE__, "BidirectionalIterator test disabled");
    }
    else {
        run_test (BidirIter<X>(), (X*)0, pred);
    }

    if (rw_opt_no_rnd_iter) {
        rw_note (0, __FILE__, __LINE__, "RandomAccessIterator test disabled");
    }
    else {
        run_test (RandomAccessIter<X>(), (X*)0, pred);
    }
}

/**************************************************************************/

static int
run_test (int, char*[])
{
    run_test (false);

    if (rw_opt_no_predicate) {
        rw_note (0, __FILE__, __LINE__, "Predicate test disabled");
    }
    else {
        run_test (true);
    }
                
    return 0;
}

/**************************************************************************/

int main (int argc, char *argv[])
{
     std_log(LOG_FILENAME_LINE,"[Test Case for find_first]");

    #ifndef __SYMBIAN32__
    return rw_test (argc, argv, __FILE__,
                    "lib.alg.find.first.of",
                    0 /* no comment */, run_test,                    
                    "|-no-ForwardIterator#"
                    "|-no-BidirectionalIterator#"
                    "|-no-RandomAccessIterator#"
                    "|-no-Predicate#",
                    &rw_opt_no_fwd_iter,
                    &rw_opt_no_bidir_iter,
                    &rw_opt_no_rnd_iter,
                    &rw_opt_no_predicate);
   #else
     rw_test (argc, argv, __FILE__,
                    "lib.alg.find.first.of",
                    0 /* no comment */, run_test,                    
                    "|-no-ForwardIterator#"
                    "|-no-BidirectionalIterator#"
                    "|-no-RandomAccessIterator#"
                    "|-no-Predicate#",
                    &rw_opt_no_fwd_iter,
                    &rw_opt_no_bidir_iter,
                    &rw_opt_no_rnd_iter,
                    &rw_opt_no_predicate);
if(failures)
      {
           assert_failed = true;
       std_log(LOG_FILENAME_LINE,"Result: Failed");
      }
     else
      {

       std_log(LOG_FILENAME_LINE,"Result: Passed");
      }
  
   std_log(LOG_FILENAME_LINE,"[End Test Case]");  
   
   testResultXml("25_find_first");
    close_log_file();
 #endif
}
