/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>
#line 51 "parse.y"

#include "sqliteInt.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token eOperator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 243
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 59
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  struct LikeOp yy30;
  Select* yy91;
  IdList* yy232;
  struct {int value; int mask;} yy319;
  ExprList* yy322;
  int yy328;
  struct TrigEvent yy378;
  struct LimitVal yy388;
  Expr* yy418;
  SrcList* yy439;
  TriggerStep* yy451;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 578
#define YYNRULE 303
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
#ifdef __cplusplus
static YYMINORTYPE yyzerominor;
#else
static const YYMINORTYPE yyzerominor;
#endif

/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   288,  882,  118,  577,    2,  169,  412,  412,   62,   62,
 /*    10 */    62,   62,  205,   64,   64,   64,   64,   65,   65,   66,
 /*    20 */    66,   66,   67,  207,  385,  382,  419,  425,   69,   64,
 /*    30 */    64,   64,   64,   65,   65,   66,   66,   66,   67,  207,
 /*    40 */   445,  443,  317,  165,   61,   60,  293,  429,  430,  426,
 /*    50 */   426,   63,   63,   62,   62,   62,   62,  251,   64,   64,
 /*    60 */    64,   64,   65,   65,   66,   66,   66,   67,  207,  288,
 /*    70 */   485,  412,  412,  207,  414,   83,   68,  456,   70,  151,
 /*    80 */    64,   64,   64,   64,   65,   65,   66,   66,   66,   67,
 /*    90 */   207,   68,  299,   70,  151,  419,  425,  441,  209,   59,
 /*   100 */    65,   65,   66,   66,   66,   67,  207,  416,  416,  416,
 /*   110 */   484,  569,  288,   61,   60,  293,  429,  430,  426,  426,
 /*   120 */    63,   63,   62,   62,   62,   62,  311,   64,   64,   64,
 /*   130 */    64,   65,   65,   66,   66,   66,   67,  207,  419,  425,
 /*   140 */    95,   66,   66,   66,   67,  207,  390,  263,  408,   35,
 /*   150 */    57,   22,  472,  172,  404,  412,   61,   60,  293,  429,
 /*   160 */   430,  426,  426,   63,   63,   62,   62,   62,   62,  162,
 /*   170 */    64,   64,   64,   64,   65,   65,   66,   66,   66,   67,
 /*   180 */   207,  288,  578,  385,  382,  567,  109,  409,  264,  445,
 /*   190 */   403,  325,  307,  387,  486,  311,  336,  204,  514,  173,
 /*   200 */   157,  441,  209,  566,  197,  334,  230,  419,  425,  146,
 /*   210 */   147,  391,  392,   68,  295,   70,  151,  408,   42,  485,
 /*   220 */   412,  563,  564,  414,  288,   61,   60,  293,  429,  430,
 /*   230 */   426,  426,   63,   63,   62,   62,   62,   62,  409,   64,
 /*   240 */    64,   64,   64,   65,   65,   66,   66,   66,   67,  207,
 /*   250 */   419,  425,  402,  517,  527,  263,  416,  416,  416,  211,
 /*   260 */   545,  514,  612,  374,  520,  377,  208,  288,   61,   60,
 /*   270 */   293,  429,  430,  426,  426,   63,   63,   62,   62,   62,
 /*   280 */    62,  567,   64,   64,   64,   64,   65,   65,   66,   66,
 /*   290 */    66,   67,  207,  419,  425,  519,  379,  296,  544,  566,
 /*   300 */   565,  229,  468,  285,  529,   21,  443,  518,  165,   67,
 /*   310 */   207,   61,   60,  293,  429,  430,  426,  426,   63,   63,
 /*   320 */    62,   62,   62,   62,  468,   64,   64,   64,   64,   65,
 /*   330 */    65,   66,   66,   66,   67,  207,  526,  501,  237,  450,
 /*   340 */    78,  213,  288,  525,  296,  519,  480,  381,  369,  269,
 /*   350 */   268,  451,  390,  205,  401,   21,  322,  149,  311,  205,
 /*   360 */   463,  562,  208,  241,  452,  219,  321,  368,  419,  425,
 /*   370 */   156,  161,  114,  243,  339,  248,  340,  174,  148,  528,
 /*   380 */   408,   36,  330,   81,  252,  238,   61,   60,  293,  429,
 /*   390 */   430,  426,  426,   63,   63,   62,   62,   62,   62,    5,
 /*   400 */    64,   64,   64,   64,   65,   65,   66,   66,   66,   67,
 /*   410 */   207,  288,  219,  489,  490,  483,  390,  391,  392,  114,
 /*   420 */   243,  339,  248,  340,  174,  180,  311,  155,  341,  344,
 /*   430 */   345,  252,  519,  236,  152,  384,    2,  419,  425,  346,
 /*   440 */   180,  574,   21,  341,  344,  345,  206,  390,  408,   35,
 /*   450 */   225,  468,  463,   56,  346,   61,   60,  293,  429,  430,
 /*   460 */   426,  426,   63,   63,   62,   62,   62,   62,  409,   64,
 /*   470 */    64,   64,   64,   65,   65,   66,   66,   66,   67,  207,
 /*   480 */   288,  391,  392,  180,  500,  487,  341,  344,  345,  312,
 /*   490 */   476,  325,  337,  311,  405,  311,  324,  346,  542,  490,
 /*   500 */   420,  421,  441,  150,  168,  157,  419,  425,   68,  544,
 /*   510 */    70,  151,  391,  392,  389,  408,   42,  408,   28,  407,
 /*   520 */   198,  423,  424,  406,   61,   60,  293,  429,  430,  426,
 /*   530 */   426,   63,   63,   62,   62,   62,   62,  409,   64,   64,
 /*   540 */    64,   64,   65,   65,   66,   66,   66,   67,  207,  288,
 /*   550 */   422,  311,  450,  255,  409,  349,  327,  212,  311,  369,
 /*   560 */   269,  268,  115,  479,  451,  311,  393,  394,  395,  433,
 /*   570 */   205,  415,  191,  408,   50,  419,  425,  452,  472,  491,
 /*   580 */   408,   50,  175,  539,  535,  356,  535,  408,   35,  492,
 /*   590 */   294,  436,  437,   61,   60,  293,  429,  430,  426,  426,
 /*   600 */    63,   63,   62,   62,   62,   62,  409,   64,   64,   64,
 /*   610 */    64,   65,   65,   66,   66,   66,   67,  207,  288,  442,
 /*   620 */   304,  251,    1,   94,   10,  537,  390,  305,  390,  536,
 /*   630 */   329,  367,  316,  436,  437,  472,  169,  290,  412,  407,
 /*   640 */   357,  358,  252,  406,  419,  425,  439,  439,   18,  314,
 /*   650 */   323,  432,  432,  370,  208,  314,  220,  432,  432,  541,
 /*   660 */   272,  288,   61,   60,  293,  429,  430,  426,  426,   63,
 /*   670 */    63,   62,   62,   62,   62,  390,   64,   64,   64,   64,
 /*   680 */    65,   65,   66,   66,   66,   67,  207,  419,  425,  446,
 /*   690 */   454,  391,  392,  391,  392,  462,  208,  303,  275,  817,
 /*   700 */   273,  291,  191,  412,  288,   61,   60,  293,  429,  430,
 /*   710 */   426,  426,   63,   63,   62,   62,   62,   62,  366,   64,
 /*   720 */    64,   64,   64,   65,   65,   66,   66,   66,   67,  207,
 /*   730 */   419,  425,  478,  175,  333,  314,  409,  432,  432,  458,
 /*   740 */   391,  392,  176,  177,  178,  195,  459,  288,   61,   71,
 /*   750 */   293,  429,  430,  426,  426,   63,   63,   62,   62,   62,
 /*   760 */    62,  367,   64,   64,   64,   64,   65,   65,   66,   66,
 /*   770 */    66,   67,  207,  419,  425,  314,  359,  432,  432,  409,
 /*   780 */   274,  362,  467,  363,  221,  257,  251,  251,  290,  251,
 /*   790 */   288,  503,   60,  293,  429,  430,  426,  426,   63,   63,
 /*   800 */    62,   62,   62,   62,  335,   64,   64,   64,   64,   65,
 /*   810 */    65,   66,   66,   66,   67,  207,  419,  425,  390,  471,
 /*   820 */   390,  300,  301,  261,  302,  259,  408,    3,   77,  153,
 /*   830 */    79,  263,  366,  332,  182,  473,  293,  429,  430,  426,
 /*   840 */   426,   63,   63,   62,   62,   62,   62,  311,   64,   64,
 /*   850 */    64,   64,   65,   65,   66,   66,   66,   67,  207,   73,
 /*   860 */   318,  179,    4,  409,  263,  311,  292,  263,  409,  408,
 /*   870 */    29,  311,  552,  311,  315,   73,  318,  311,    4,  508,
 /*   880 */   311,  509,  292,  391,  392,  391,  392,  408,   24,  185,
 /*   890 */   315,  320,  263,  408,   33,  408,   54,  311,  224,  408,
 /*   900 */    53,  445,  408,   99,  311,  554,  311,  320,  555,  464,
 /*   910 */    20,  465,  142,  249,  263,  193,  502,  445,  311,  408,
 /*   920 */    97,   76,   75,  409,  263,  506,  408,  102,  408,  103,
 /*   930 */    74,  309,  310,  556,  313,  414,  498,   76,   75,  477,
 /*   940 */   408,  108,  376,  188,  311,  507,   74,  309,  310,   73,
 /*   950 */   318,  414,    4,  205,  311,  222,  292,  311,  495,  496,
 /*   960 */   311,  205,  263,  244,  315,  223,  408,  110,  416,  416,
 /*   970 */   416,  417,  418,   12,  245,  375,  408,   17,  250,  408,
 /*   980 */   100,  320,  408,   34,  416,  416,  416,  417,  418,   12,
 /*   990 */   461,  445,  434,  159,   23,  311,  521,  298,  226,  227,
 /*  1000 */   228,  105,  256,  278,  311,  470,  311,  170,  311,  258,
 /*  1010 */   427,   76,   75,  260,  202,   85,  280,  408,   98,  353,
 /*  1020 */    74,  309,  310,  281,  311,  414,  408,   25,  408,   55,
 /*  1030 */   408,  111,  311,  262,  311,  200,  510,  544,  179,  505,
 /*  1040 */   504,  199,  311,  231,  201,  311,  408,  112,  311,  254,
 /*  1050 */   311,  179,  311,  267,  408,  113,  408,   26,  416,  416,
 /*  1060 */   416,  417,  418,   12,  408,   37,  399,  408,   38,  311,
 /*  1070 */   408,   27,  408,   39,  408,   40,  348,  311,  179,  311,
 /*  1080 */   540,  145,  179,  548,  311,  170,  311,  372,  277,  268,
 /*  1090 */   311,  408,   41,  289,  549,  311,   92,  311,  205,  408,
 /*  1100 */    43,  408,   44,  311,  361,  311,  408,   45,  408,   30,
 /*  1110 */    19,  364,  408,   31,  559,  311,   92,  408,   46,  408,
 /*  1120 */    47,  311,  365,  378,  270,  408,   48,  408,   49,  311,
 /*  1130 */   271,  311,  561,  144,  279,  282,  438,  408,   32,  283,
 /*  1140 */   573,  413,  440,  408,   11,  319,  160,  501,  457,  239,
 /*  1150 */   460,  408,   51,  408,   52,  512,  547,  515,  276,    8,
 /*  1160 */   558,  388,  246,  511,  373,  396,  397,  513,  398,    7,
 /*  1170 */   343,   85,  308,  232,  328,   58,  233,   84,   80,  326,
 /*  1180 */   167,  455,  210,  119,   86,  338,  331,  410,  297,  494,
 /*  1190 */   498,  122,  488,  217,  493,  234,  247,  235,  286,  411,
 /*  1200 */   497,  350,  287,  499,  522,  516,  523,  240,  524,  469,
 /*  1210 */   242,  183,  475,  354,   89,  530,  184,  117,  352,  186,
 /*  1220 */   543,  130,  192,  187,  532,  189,  140,  371,  360,  131,
 /*  1230 */   216,  132,  133,  218,  550,  557,  134,  136,  306,  570,
 /*  1240 */   575,  571,  265,  572,  533,  386,  400,  613,  215,  139,
 /*  1250 */    93,   96,  107,  104,  614,  101,  163,  164,  428,  431,
 /*  1260 */    72,  447,  435,  444,  141,  154,    6,  448,  466,  449,
 /*  1270 */   166,  453,   14,  120,   82,   13,  171,  474,  121,  158,
 /*  1280 */   481,  482,  214,   87,  342,  123,  124,  116,  253,   88,
 /*  1290 */   125,  181,  245,  351,  143,  531,  126,  170,  355,  266,
 /*  1300 */   347,  190,  128,    9,  127,  546,  129,   90,  534,   15,
 /*  1310 */   538,  194,  196,  551,  553,  137,  138,  106,  135,   16,
 /*  1320 */   560,  568,  284,  203,  383,  883,  380,  576,  883,  883,
 /*  1330 */   883,   91,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    16,  140,  141,  142,  143,   21,   23,   23,   69,   70,
 /*    10 */    71,   72,  110,   74,   75,   76,   77,   78,   79,   80,
 /*    20 */    81,   82,   83,   84,    1,    2,   42,   43,   73,   74,
 /*    30 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*    40 */    58,  162,  163,  164,   60,   61,   62,   63,   64,   65,
 /*    50 */    66,   67,   68,   69,   70,   71,   72,  148,   74,   75,
 /*    60 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*    70 */    88,   88,   88,   84,   92,   22,  219,  220,  221,  222,
 /*    80 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*    90 */    84,  219,  183,  221,  222,   42,   43,   78,   79,   46,
 /*   100 */    78,   79,   80,   81,   82,   83,   84,  125,  126,  127,
 /*   110 */   170,  239,   16,   60,   61,   62,   63,   64,   65,   66,
 /*   120 */    67,   68,   69,   70,   71,   72,  148,   74,   75,   76,
 /*   130 */    77,   78,   79,   80,   81,   82,   83,   84,   42,   43,
 /*   140 */    44,   80,   81,   82,   83,   84,   23,  148,  170,  171,
 /*   150 */    19,   19,  148,  156,   23,   23,   60,   61,   62,   63,
 /*   160 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   19,
 /*   170 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   180 */    84,   16,    0,    1,    2,  148,   21,  190,  189,   58,
 /*   190 */   169,  213,  144,  145,  170,  148,  218,  149,  177,  202,
 /*   200 */   203,   78,   79,  166,  156,  208,  191,   42,   43,   78,
 /*   210 */    79,   88,   89,  219,  210,  221,  222,  170,  171,   88,
 /*   220 */    88,   98,   99,   92,   16,   60,   61,   62,   63,   64,
 /*   230 */    65,   66,   67,   68,   69,   70,   71,   72,  190,   74,
 /*   240 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   250 */    42,   43,  168,  169,  182,  148,  125,  126,  127,  212,
 /*   260 */    11,  177,  112,  215,  182,  228,  229,   16,   60,   61,
 /*   270 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   280 */    72,  148,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   290 */    82,   83,   84,   42,   43,  148,  189,   16,   49,  166,
 /*   300 */   167,  154,  162,  159,  157,  158,  162,  163,  164,   83,
 /*   310 */    84,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   320 */    69,   70,   71,   72,  162,   74,   75,   76,   77,   78,
 /*   330 */    79,   80,   81,   82,   83,   84,  177,  178,  148,   12,
 /*   340 */   132,  201,   16,  184,   16,  148,   20,  240,   99,  100,
 /*   350 */   101,   24,   23,  110,  157,  158,  187,   22,  148,  110,
 /*   360 */    22,  228,  229,  201,   37,   84,   39,  124,   42,   43,
 /*   370 */   148,   90,   91,   92,   93,   94,   95,   96,  181,  182,
 /*   380 */   170,  171,  148,  132,  103,  148,   60,   61,   62,   63,
 /*   390 */    64,   65,   66,   67,   68,   69,   70,   71,   72,  192,
 /*   400 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   410 */    84,   16,   84,  186,  187,   20,   23,   88,   89,   91,
 /*   420 */    92,   93,   94,   95,   96,   90,  148,   89,   93,   94,
 /*   430 */    95,  103,  148,  223,  156,  142,  143,   42,   43,  104,
 /*   440 */    90,  157,  158,   93,   94,   95,  193,   23,  170,  171,
 /*   450 */   146,  162,  114,  200,  104,   60,   61,   62,   63,   64,
 /*   460 */    65,   66,   67,   68,   69,   70,   71,   72,  190,   74,
 /*   470 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   480 */    16,   88,   89,   90,   20,  161,   93,   94,   95,  148,
 /*   490 */   201,  213,   80,  148,  170,  148,  218,  104,  186,  187,
 /*   500 */    42,   43,   78,  156,  202,  203,   42,   43,  219,   49,
 /*   510 */   221,  222,   88,   89,  148,  170,  171,  170,  171,  107,
 /*   520 */   156,   63,   64,  111,   60,   61,   62,   63,   64,   65,
 /*   530 */    66,   67,   68,   69,   70,   71,   72,  190,   74,   75,
 /*   540 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*   550 */    92,  148,   12,   20,  190,   16,  211,  212,  148,   99,
 /*   560 */   100,  101,  148,   20,   24,  148,    7,    8,    9,   20,
 /*   570 */   110,  148,  156,  170,  171,   42,   43,   37,  148,   39,
 /*   580 */   170,  171,   43,   18,   99,  100,  101,  170,  171,   49,
 /*   590 */   165,  166,  167,   60,   61,   62,   63,   64,   65,   66,
 /*   600 */    67,   68,   69,   70,   71,   72,  190,   74,   75,   76,
 /*   610 */    77,   78,   79,   80,   81,   82,   83,   84,   16,  162,
 /*   620 */   217,  148,   19,   21,   19,   25,   23,  217,   23,   29,
 /*   630 */   213,  215,  165,  166,  167,  148,   21,   98,   23,  107,
 /*   640 */   210,   41,  103,  111,   42,   43,  125,  126,  232,  106,
 /*   650 */   148,  108,  109,  237,  229,  106,  183,  108,  109,   94,
 /*   660 */    14,   16,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   670 */    68,   69,   70,   71,   72,   23,   74,   75,   76,   77,
 /*   680 */    78,   79,   80,   81,   82,   83,   84,   42,   43,   20,
 /*   690 */   148,   88,   89,   88,   89,  204,  229,  210,   52,  134,
 /*   700 */    54,  151,  156,   88,   16,   60,   61,   62,   63,   64,
 /*   710 */    65,   66,   67,   68,   69,   70,   71,   72,  148,   74,
 /*   720 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   730 */    42,   43,   80,   43,   16,  106,  190,  108,  109,   27,
 /*   740 */    88,   89,   99,  100,  101,  156,   34,   16,   60,   61,
 /*   750 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   760 */    72,  215,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   770 */    82,   83,   84,   42,   43,  106,  226,  108,  109,  190,
 /*   780 */   134,  231,  148,  237,  214,   14,  148,  148,   98,  148,
 /*   790 */    16,  179,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   800 */    69,   70,   71,   72,  148,   74,   75,   76,   77,   78,
 /*   810 */    79,   80,   81,   82,   83,   84,   42,   43,   23,  148,
 /*   820 */    23,  183,  183,   52,  183,   54,  170,  171,  131,  156,
 /*   830 */   133,  148,  148,  115,  156,  148,   62,   63,   64,   65,
 /*   840 */    66,   67,   68,   69,   70,   71,   72,  148,   74,   75,
 /*   850 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*   860 */    17,   22,   19,  190,  148,  148,   23,  148,  190,  170,
 /*   870 */   171,  148,  189,  148,   31,   16,   17,  148,   19,  179,
 /*   880 */   148,  179,   23,   88,   89,   88,   89,  170,  171,  156,
 /*   890 */    31,   48,  148,  170,  171,  170,  171,  148,  214,  170,
 /*   900 */   171,   58,  170,  171,  148,  189,  148,   48,  189,  114,
 /*   910 */    19,  114,   21,  148,  148,   22,  148,   58,  148,  170,
 /*   920 */   171,   78,   79,  190,  148,   30,  170,  171,  170,  171,
 /*   930 */    87,   88,   89,  189,   16,   92,   97,   78,   79,   80,
 /*   940 */   170,  171,   91,  233,  148,   50,   87,   88,   89,   16,
 /*   950 */    17,   92,   19,  110,  148,  189,   23,  148,    7,    8,
 /*   960 */   148,  110,  148,   92,   31,  189,  170,  171,  125,  126,
 /*   970 */   127,  128,  129,  130,  103,  124,  170,  171,  148,  170,
 /*   980 */   171,   48,  170,  171,  125,  126,  127,  128,  129,  130,
 /*   990 */    22,   58,   20,    5,   22,  148,  148,  102,   10,   11,
 /*  1000 */    12,   13,  148,  189,  148,   20,  148,   22,  148,  148,
 /*  1010 */    92,   78,   79,  148,   26,  122,   28,  170,  171,  234,
 /*  1020 */    87,   88,   89,   35,  148,   92,  170,  171,  170,  171,
 /*  1030 */   170,  171,  148,  148,  148,   47,   20,   49,   22,   91,
 /*  1040 */    92,   53,  148,  194,   56,  148,  170,  171,  148,   20,
 /*  1050 */   148,   22,  148,  148,  170,  171,  170,  171,  125,  126,
 /*  1060 */   127,  128,  129,  130,  170,  171,  150,  170,  171,  148,
 /*  1070 */   170,  171,  170,  171,  170,  171,   20,  148,   22,  148,
 /*  1080 */    20,  113,   22,   20,  148,   22,  148,   99,  100,  101,
 /*  1090 */   148,  170,  171,  105,   20,  148,   22,  148,  110,  170,
 /*  1100 */   171,  170,  171,  148,  148,  148,  170,  171,  170,  171,
 /*  1110 */    19,  148,  170,  171,   20,  148,   22,  170,  171,  170,
 /*  1120 */   171,  148,  148,  135,  148,  170,  171,  170,  171,  148,
 /*  1130 */   148,  148,  148,  192,  148,  148,  230,  170,  171,  148,
 /*  1140 */   148,  162,  230,  170,  171,  225,    6,  178,  173,  205,
 /*  1150 */   173,  170,  171,  170,  171,  162,  195,  162,  205,   68,
 /*  1160 */   195,  147,  173,  173,  205,  147,  147,  173,  147,   22,
 /*  1170 */   174,  122,  155,  195,  119,  121,  196,  120,  131,  118,
 /*  1180 */   112,  153,  224,  153,   98,   98,  117,  190,   40,  180,
 /*  1190 */    97,   19,  172,   84,  172,  197,  172,  198,  175,  199,
 /*  1200 */   174,   15,  175,  172,  172,  180,  172,  206,  172,  207,
 /*  1210 */   206,  152,  207,   38,  131,  153,  152,   60,  153,  152,
 /*  1220 */   185,   19,  185,  153,  153,  152,  216,   15,  153,  188,
 /*  1230 */   227,  188,  188,  227,  195,  195,  188,  185,  153,   33,
 /*  1240 */   138,  153,  235,  153,  236,    1,   20,  112,  176,  216,
 /*  1250 */   238,  238,  241,  176,  112,  160,  112,  112,   92,  107,
 /*  1260 */    19,   11,   20,   20,   19,   19,  116,   20,  114,   20,
 /*  1270 */    22,   20,  116,   19,   22,   22,  116,  115,   20,  112,
 /*  1280 */    20,   20,   44,   19,   44,   19,   19,   32,   20,   19,
 /*  1290 */    19,   96,  103,   16,   21,   17,   98,   22,   36,  134,
 /*  1300 */    44,   98,   19,    5,   45,    1,  102,   68,   51,   19,
 /*  1310 */    45,  123,  113,    1,   17,  102,  123,   14,  113,   19,
 /*  1320 */   124,   20,  137,  136,    3,  242,   57,    4,  242,  242,
 /*  1330 */   242,   68,
};
#define YY_SHIFT_USE_DFLT (-99)
#define YY_SHIFT_MAX 383
static const short yy_shift_ofst[] = {
 /*     0 */    23,  843,  988,  -16,  843,  933,  933,  393,  123,  460,
 /*    10 */   -98,   96,  933,  933,  933,  933,  933,  -45,  249,  424,
 /*    20 */   329,  -17,   19,   19,   53,  165,  208,  251,  326,  395,
 /*    30 */   464,  533,  602,  645,  688,  645,  645,  645,  645,  645,
 /*    40 */   645,  645,  645,  645,  645,  645,  645,  645,  645,  645,
 /*    50 */   645,  645,  645,  731,  774,  774,  859,  933,  933,  933,
 /*    60 */   933,  933,  933,  933,  933,  933,  933,  933,  933,  933,
 /*    70 */   933,  933,  933,  933,  933,  933,  933,  933,  933,  933,
 /*    80 */   933,  933,  933,  933,  933,  933,  933,  933,  933,  933,
 /*    90 */   933,  933,  933,  933,  933,  933,  933,  -61,  -61,    6,
 /*   100 */     6,  281,   22,   61,  539,  565,  329,  329,  226,  -17,
 /*   110 */   -11,  -99,  -99,  -99,  131,  328,  540,  540,  182,  615,
 /*   120 */   329,  615,  329,  329,  329,  329,  329,  329,  329,  329,
 /*   130 */   329,  329,  329,  329,  329,  329,  329,  329,  329,  851,
 /*   140 */   243,  -98,  -98,  -98,  -99,  -99,  -18,  -18,  335,  350,
 /*   150 */   543,  603,  549,  669,  327,  795,  797,  605,  652,  559,
 /*   160 */   329,  329,  412,  329,  329,  132,  329,  329,  338,  329,
 /*   170 */   329,  329,  629,  338,  329,  329,  895,  895,  895,  329,
 /*   180 */   329,  329,  629,  329,  329,  629,  329,  600,  485,  329,
 /*   190 */   329,  629,  329,  329,  329,  629,  329,  629,  629,  329,
 /*   200 */   329,  329,  329,  329,  891,  532,  968,  -17,  521,  521,
 /*   210 */   697,  712,  712,  718,  712,  690,  712,  -17,  712,  -17,
 /*   220 */   839,  893,  718,  718,  893, 1140, 1140, 1140, 1140, 1147,
 /*   230 */   -98, 1049, 1055, 1057, 1061, 1054, 1047, 1068, 1068, 1086,
 /*   240 */  1069, 1086, 1069, 1087, 1087, 1148, 1087, 1093, 1087, 1172,
 /*   250 */  1109, 1109, 1148, 1087, 1087, 1087, 1172, 1186, 1068, 1186,
 /*   260 */  1068, 1186, 1068, 1068, 1175, 1083, 1186, 1068, 1157, 1157,
 /*   270 */  1202, 1049, 1212, 1212, 1212, 1212, 1049, 1157, 1202, 1068,
 /*   280 */  1206, 1206, 1068, 1068, 1102,  -99,  -99,  -99,  458,  646,
 /*   290 */   643,  771,  150,  918,  972,  985,  871,  951,  948, 1016,
 /*   300 */  1029, 1056, 1060, 1063, 1074, 1094, 1091, 1244, 1226, 1135,
 /*   310 */  1142, 1144, 1145, 1166, 1152, 1241, 1242, 1243, 1245, 1250,
 /*   320 */  1246, 1247, 1248, 1249, 1251, 1252, 1150, 1253, 1156, 1252,
 /*   330 */  1154, 1254, 1160, 1162, 1258, 1167, 1260, 1261, 1255, 1238,
 /*   340 */  1264, 1240, 1266, 1268, 1267, 1270, 1256, 1271, 1195, 1189,
 /*   350 */  1277, 1278, 1273, 1198, 1262, 1257, 1259, 1275, 1265, 1165,
 /*   360 */  1203, 1283, 1298, 1304, 1204, 1239, 1263, 1188, 1290, 1199,
 /*   370 */  1312, 1297, 1205, 1213, 1193, 1300, 1196, 1301, 1303, 1269,
 /*   380 */  1187, 1185, 1321, 1323,
};
#define YY_REDUCE_USE_DFLT (-144)
#define YY_REDUCE_MAX 287
static const short yy_reduce_ofst[] = {
 /*     0 */  -139,  278,   48,  289,  347,  -22,  345,  197,  133,  416,
 /*    10 */    -3, -128,  210,   47,  417,  403,  410, -143,  546,   37,
 /*    20 */   147,  144,  425,  467,   -6,   -6,   -6,   -6,   -6,   -6,
 /*    30 */    -6,   -6,   -6,   -6,   -6,   -6,   -6,   -6,   -6,   -6,
 /*    40 */    -6,   -6,   -6,   -6,   -6,   -6,   -6,   -6,   -6,   -6,
 /*    50 */    -6,   -6,   -6,   -6,   -6,   -6,  656,  699,  717,  723,
 /*    60 */   725,  729,  732,  749,  756,  758,  770,  796,  806,  809,
 /*    70 */   812,  847,  856,  858,  860,  876,  884,  886,  894,  897,
 /*    80 */   900,  902,  904,  921,  929,  931,  936,  938,  942,  947,
 /*    90 */   949,  955,  957,  967,  973,  981,  983,   -6,   -6,   -6,
 /*   100 */    -6,   84,   -6,   -6,  159,  550,  107,  284,   -6, -121,
 /*   110 */    -6,   -6,   -6,   -6,  324,   21,  227,  312,  293,  140,
 /*   120 */     4,  162,  -91,  473,  638,  639,   -1,  430,  641,  570,
 /*   130 */   487,  683,  716,  719,  744,  766,  776,  684,  814,  364,
 /*   140 */   589,  673,  678,  733,  253,  302,  -60,   24,   72,   82,
 /*   150 */    15,  190,   15,   15,  169,  222,  234,  237,  341,  304,
 /*   160 */   366,  414,  207,  341,  423,  457,  502,  542,  491,  634,
 /*   170 */   671,  687,   15,  491,  765,  768,  612,  700,  702,  830,
 /*   180 */   848,  854,   15,  861,  865,   15,  885,  710,  785,  905,
 /*   190 */   956,   15,  963,  974,  976,   15,  982,   15,   15,  984,
 /*   200 */   986,  987,  991,  992,  916,  941,  849,  979,  906,  912,
 /*   210 */   920,  975,  977,  944,  989,  969,  990,  993,  994,  995,
 /*   220 */   996,  961,  953,  959,  965, 1014, 1018, 1019, 1021, 1017,
 /*   230 */   997,  978,  980,  998,  999, 1000,  958, 1028, 1030, 1001,
 /*   240 */  1002, 1004, 1005, 1020, 1022, 1009, 1024, 1026, 1031, 1023,
 /*   250 */  1003, 1006, 1025, 1032, 1034, 1036, 1027, 1059, 1062, 1064,
 /*   260 */  1065, 1067, 1070, 1071, 1007, 1008, 1073, 1075, 1035, 1037,
 /*   270 */  1010, 1039, 1041, 1043, 1044, 1048, 1040, 1052, 1033, 1085,
 /*   280 */  1012, 1013, 1088, 1090, 1011, 1095, 1072, 1077,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   583,  812,  881,  699,  881,  812,  881,  881,  839,  881,
 /*    10 */   703,  868,  810,  881,  881,  881,  881,  784,  881,  839,
 /*    20 */   881,  615,  839,  839,  735,  881,  881,  881,  881,  881,
 /*    30 */   881,  881,  881,  736,  881,  814,  809,  805,  807,  806,
 /*    40 */   813,  737,  726,  733,  740,  715,  852,  742,  743,  749,
 /*    50 */   750,  869,  867,  772,  771,  790,  881,  881,  881,  881,
 /*    60 */   881,  881,  881,  881,  881,  881,  881,  881,  881,  881,
 /*    70 */   881,  881,  881,  881,  881,  881,  881,  881,  881,  881,
 /*    80 */   881,  881,  881,  881,  881,  881,  881,  881,  881,  881,
 /*    90 */   881,  881,  881,  881,  881,  881,  881,  774,  796,  773,
 /*   100 */   783,  608,  775,  776,  668,  603,  881,  881,  777,  881,
 /*   110 */   778,  791,  792,  793,  881,  881,  881,  881,  583,  699,
 /*   120 */   881,  699,  881,  881,  881,  881,  881,  881,  881,  881,
 /*   130 */   881,  881,  881,  881,  881,  881,  881,  881,  881,  881,
 /*   140 */   881,  881,  881,  881,  693,  703,  881,  881,  659,  881,
 /*   150 */   881,  881,  881,  881,  881,  881,  881,  881,  881,  591,
 /*   160 */   589,  881,  691,  881,  881,  617,  881,  881,  701,  881,
 /*   170 */   881,  881,  706,  707,  881,  881,  881,  881,  881,  881,
 /*   180 */   881,  881,  605,  881,  881,  680,  881,  845,  881,  881,
 /*   190 */   881,  859,  881,  881,  881,  857,  881,  682,  745,  825,
 /*   200 */   881,  872,  874,  881,  881,  691,  700,  881,  881,  881,
 /*   210 */   808,  729,  729,  717,  729,  638,  729,  881,  729,  881,
 /*   220 */   641,  739,  717,  717,  739,  588,  588,  588,  588,  658,
 /*   230 */   881,  739,  730,  732,  722,  734,  881,  708,  708,  716,
 /*   240 */   721,  716,  721,  670,  670,  655,  670,  641,  670,  818,
 /*   250 */   822,  822,  655,  670,  670,  670,  818,  600,  708,  600,
 /*   260 */   708,  600,  708,  708,  849,  851,  600,  708,  672,  672,
 /*   270 */   751,  739,  679,  679,  679,  679,  739,  672,  751,  708,
 /*   280 */   871,  871,  708,  708,  879,  625,  643,  643,  881,  881,
 /*   290 */   881,  881,  758,  881,  881,  881,  881,  881,  881,  881,
 /*   300 */   881,  881,  881,  881,  881,  881,  832,  881,  881,  763,
 /*   310 */   759,  881,  760,  881,  685,  881,  881,  881,  881,  881,
 /*   320 */   881,  881,  881,  881,  881,  811,  881,  723,  881,  731,
 /*   330 */   881,  881,  881,  881,  881,  881,  881,  881,  881,  881,
 /*   340 */   881,  881,  881,  881,  881,  881,  881,  881,  881,  881,
 /*   350 */   881,  881,  881,  881,  881,  881,  847,  848,  881,  881,
 /*   360 */   881,  881,  881,  881,  881,  881,  881,  881,  881,  881,
 /*   370 */   881,  881,  881,  881,  881,  881,  881,  881,  881,  878,
 /*   380 */   881,  881,  584,  881,  579,  581,  582,  586,  587,  590,
 /*   390 */   612,  613,  614,  592,  593,  594,  595,  596,  597,  598,
 /*   400 */   604,  606,  624,  626,  610,  628,  689,  690,  755,  683,
 /*   410 */   684,  688,  611,  766,  757,  761,  762,  764,  765,  779,
 /*   420 */   780,  782,  788,  795,  798,  781,  786,  787,  789,  794,
 /*   430 */   797,  686,  687,  801,  618,  619,  622,  623,  835,  837,
 /*   440 */   836,  838,  621,  620,  767,  770,  803,  804,  860,  861,
 /*   450 */   862,  863,  864,  799,  709,  802,  785,  724,  727,  728,
 /*   460 */   725,  692,  702,  711,  712,  713,  714,  697,  698,  704,
 /*   470 */   720,  753,  754,  718,  719,  705,  694,  695,  696,  800,
 /*   480 */   756,  768,  769,  629,  630,  763,  631,  632,  633,  671,
 /*   490 */   674,  675,  676,  634,  653,  656,  657,  635,  642,  636,
 /*   500 */   637,  644,  645,  646,  649,  650,  651,  652,  647,  648,
 /*   510 */   819,  820,  823,  821,  639,  640,  654,  627,  616,  609,
 /*   520 */   660,  663,  664,  665,  666,  667,  669,  661,  662,  607,
 /*   530 */   599,  601,  710,  841,  850,  846,  842,  843,  844,  602,
 /*   540 */   815,  816,  673,  747,  748,  840,  853,  855,  752,  856,
 /*   550 */   858,  854,  677,  678,  681,  824,  865,  738,  741,  744,
 /*   560 */   746,  826,  827,  828,  829,  830,  833,  834,  831,  866,
 /*   570 */   870,  873,  875,  876,  877,  880,  585,  580,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      QUERY => ID */
   23,  /*       PLAN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   23,  /*   DEFERRED => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*         IF => ID */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*    ANALYZE => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*       CAST => ID */
   23,  /*   CONFLICT => ID */
   23,  /*   DATABASE => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*     IGNORE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*    LIKE_KW => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
   23,  /*    VIRTUAL => ID */
   23,  /*    REINDEX => ID */
   23,  /*     RENAME => ID */
   23,  /*   CTIME_KW => ID */
    0,  /*        ANY => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*    INDEXED => nothing */
    0,  /*         BY => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*      ALTER => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "EXPLAIN",       "QUERY",       
  "PLAN",          "BEGIN",         "TRANSACTION",   "DEFERRED",    
  "IMMEDIATE",     "EXCLUSIVE",     "COMMIT",        "END",         
  "ROLLBACK",      "CREATE",        "TABLE",         "IF",          
  "NOT",           "EXISTS",        "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ANALYZE",       "ASC",         
  "ATTACH",        "BEFORE",        "CASCADE",       "CAST",        
  "CONFLICT",      "DATABASE",      "DESC",          "DETACH",      
  "EACH",          "FAIL",          "FOR",           "IGNORE",      
  "INITIALLY",     "INSTEAD",       "LIKE_KW",       "MATCH",       
  "KEY",           "OF",            "OFFSET",        "PRAGMA",      
  "RAISE",         "REPLACE",       "RESTRICT",      "ROW",         
  "TRIGGER",       "VACUUM",        "VIEW",          "VIRTUAL",     
  "REINDEX",       "RENAME",        "CTIME_KW",      "ANY",         
  "OR",            "AND",           "IS",            "BETWEEN",     
  "IN",            "ISNULL",        "NOTNULL",       "NE",          
  "EQ",            "GT",            "LE",            "LT",          
  "GE",            "ESCAPE",        "BITAND",        "BITOR",       
  "LSHIFT",        "RSHIFT",        "PLUS",          "MINUS",       
  "STAR",          "SLASH",         "REM",           "CONCAT",      
  "COLLATE",       "UMINUS",        "UPLUS",         "BITNOT",      
  "STRING",        "JOIN_KW",       "CONSTRAINT",    "DEFAULT",     
  "NULL",          "PRIMARY",       "UNIQUE",        "CHECK",       
  "REFERENCES",    "AUTOINCR",      "ON",            "DELETE",      
  "UPDATE",        "INSERT",        "SET",           "DEFERRABLE",  
  "FOREIGN",       "DROP",          "UNION",         "ALL",         
  "EXCEPT",        "INTERSECT",     "SELECT",        "DISTINCT",    
  "DOT",           "FROM",          "JOIN",          "INDEXED",     
  "BY",            "USING",         "ORDER",         "GROUP",       
  "HAVING",        "LIMIT",         "WHERE",         "INTO",        
  "VALUES",        "INTEGER",       "FLOAT",         "BLOB",        
  "REGISTER",      "VARIABLE",      "CASE",          "WHEN",        
  "THEN",          "ELSE",          "INDEX",         "ALTER",       
  "TO",            "ADD",           "COLUMNKW",      "error",       
  "input",         "cmdlist",       "ecmd",          "explain",     
  "cmdx",          "cmd",           "transtype",     "trans_opt",   
  "nm",            "create_table",  "create_table_args",  "temp",        
  "ifnotexists",   "dbnm",          "columnlist",    "conslist_opt",
  "select",        "column",        "columnid",      "type",        
  "carglist",      "id",            "ids",           "typetoken",   
  "typename",      "signed",        "plus_num",      "minus_num",   
  "carg",          "ccons",         "term",          "expr",        
  "onconf",        "sortorder",     "autoinc",       "idxlist_opt", 
  "refargs",       "defer_subclause",  "refarg",        "refact",      
  "init_deferred_pred_opt",  "conslist",      "tcons",         "idxlist",     
  "defer_subclause_opt",  "orconf",        "resolvetype",   "raisetype",   
  "ifexists",      "fullname",      "oneselect",     "multiselect_op",
  "distinct",      "selcollist",    "from",          "where_opt",   
  "groupby_opt",   "having_opt",    "orderby_opt",   "limit_opt",   
  "sclp",          "as",            "seltablist",    "stl_prefix",  
  "joinop",        "indexed_opt",   "on_opt",        "using_opt",   
  "seltablist_paren",  "joinop2",       "inscollist",    "sortlist",    
  "sortitem",      "nexprlist",     "setlist",       "insert_cmd",  
  "inscollist_opt",  "itemlist",      "exprlist",      "likeop",      
  "escape",        "between_op",    "in_op",         "case_operand",
  "case_exprlist",  "case_else",     "uniqueflag",    "collate",     
  "nmnum",         "plus_opt",      "number",        "trigger_decl",
  "trigger_cmd_list",  "trigger_time",  "trigger_event",  "foreach_clause",
  "when_clause",   "trigger_cmd",   "database_kw_opt",  "key_opt",     
  "add_column_fullname",  "kwcolumn_opt",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "ecmd ::= SEMI",
 /*   4 */ "ecmd ::= explain cmdx SEMI",
 /*   5 */ "explain ::=",
 /*   6 */ "explain ::= EXPLAIN",
 /*   7 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   8 */ "cmdx ::= cmd",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "cmd ::= create_table create_table_args",
 /*  21 */ "create_table ::= CREATE temp TABLE ifnotexists nm dbnm",
 /*  22 */ "ifnotexists ::=",
 /*  23 */ "ifnotexists ::= IF NOT EXISTS",
 /*  24 */ "temp ::= TEMP",
 /*  25 */ "temp ::=",
 /*  26 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  27 */ "create_table_args ::= AS select",
 /*  28 */ "columnlist ::= columnlist COMMA column",
 /*  29 */ "columnlist ::= column",
 /*  30 */ "column ::= columnid type carglist",
 /*  31 */ "columnid ::= nm",
 /*  32 */ "id ::= ID",
 /*  33 */ "ids ::= ID|STRING",
 /*  34 */ "nm ::= ID",
 /*  35 */ "nm ::= STRING",
 /*  36 */ "nm ::= JOIN_KW",
 /*  37 */ "type ::=",
 /*  38 */ "type ::= typetoken",
 /*  39 */ "typetoken ::= typename",
 /*  40 */ "typetoken ::= typename LP signed RP",
 /*  41 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  42 */ "typename ::= ids",
 /*  43 */ "typename ::= typename ids",
 /*  44 */ "signed ::= plus_num",
 /*  45 */ "signed ::= minus_num",
 /*  46 */ "carglist ::= carglist carg",
 /*  47 */ "carglist ::=",
 /*  48 */ "carg ::= CONSTRAINT nm ccons",
 /*  49 */ "carg ::= ccons",
 /*  50 */ "ccons ::= DEFAULT term",
 /*  51 */ "ccons ::= DEFAULT LP expr RP",
 /*  52 */ "ccons ::= DEFAULT PLUS term",
 /*  53 */ "ccons ::= DEFAULT MINUS term",
 /*  54 */ "ccons ::= DEFAULT id",
 /*  55 */ "ccons ::= NULL onconf",
 /*  56 */ "ccons ::= NOT NULL onconf",
 /*  57 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  58 */ "ccons ::= UNIQUE onconf",
 /*  59 */ "ccons ::= CHECK LP expr RP",
 /*  60 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  61 */ "ccons ::= defer_subclause",
 /*  62 */ "ccons ::= COLLATE ids",
 /*  63 */ "autoinc ::=",
 /*  64 */ "autoinc ::= AUTOINCR",
 /*  65 */ "refargs ::=",
 /*  66 */ "refargs ::= refargs refarg",
 /*  67 */ "refarg ::= MATCH nm",
 /*  68 */ "refarg ::= ON DELETE refact",
 /*  69 */ "refarg ::= ON UPDATE refact",
 /*  70 */ "refarg ::= ON INSERT refact",
 /*  71 */ "refact ::= SET NULL",
 /*  72 */ "refact ::= SET DEFAULT",
 /*  73 */ "refact ::= CASCADE",
 /*  74 */ "refact ::= RESTRICT",
 /*  75 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  76 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  77 */ "init_deferred_pred_opt ::=",
 /*  78 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  79 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  80 */ "conslist_opt ::=",
 /*  81 */ "conslist_opt ::= COMMA conslist",
 /*  82 */ "conslist ::= conslist COMMA tcons",
 /*  83 */ "conslist ::= conslist tcons",
 /*  84 */ "conslist ::= tcons",
 /*  85 */ "tcons ::= CONSTRAINT nm",
 /*  86 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  87 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  88 */ "tcons ::= CHECK LP expr RP onconf",
 /*  89 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  90 */ "defer_subclause_opt ::=",
 /*  91 */ "defer_subclause_opt ::= defer_subclause",
 /*  92 */ "onconf ::=",
 /*  93 */ "onconf ::= ON CONFLICT resolvetype",
 /*  94 */ "orconf ::=",
 /*  95 */ "orconf ::= OR resolvetype",
 /*  96 */ "resolvetype ::= raisetype",
 /*  97 */ "resolvetype ::= IGNORE",
 /*  98 */ "resolvetype ::= REPLACE",
 /*  99 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 100 */ "ifexists ::= IF EXISTS",
 /* 101 */ "ifexists ::=",
 /* 102 */ "cmd ::= CREATE temp VIEW ifnotexists nm dbnm AS select",
 /* 103 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 104 */ "cmd ::= select",
 /* 105 */ "select ::= oneselect",
 /* 106 */ "select ::= select multiselect_op oneselect",
 /* 107 */ "multiselect_op ::= UNION",
 /* 108 */ "multiselect_op ::= UNION ALL",
 /* 109 */ "multiselect_op ::= EXCEPT|INTERSECT",
 /* 110 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 111 */ "distinct ::= DISTINCT",
 /* 112 */ "distinct ::= ALL",
 /* 113 */ "distinct ::=",
 /* 114 */ "sclp ::= selcollist COMMA",
 /* 115 */ "sclp ::=",
 /* 116 */ "selcollist ::= sclp expr as",
 /* 117 */ "selcollist ::= sclp STAR",
 /* 118 */ "selcollist ::= sclp nm DOT STAR",
 /* 119 */ "as ::= AS nm",
 /* 120 */ "as ::= ids",
 /* 121 */ "as ::=",
 /* 122 */ "from ::=",
 /* 123 */ "from ::= FROM seltablist",
 /* 124 */ "stl_prefix ::= seltablist joinop",
 /* 125 */ "stl_prefix ::=",
 /* 126 */ "seltablist ::= stl_prefix nm dbnm as indexed_opt on_opt using_opt",
 /* 127 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 128 */ "seltablist_paren ::= select",
 /* 129 */ "seltablist_paren ::= seltablist",
 /* 130 */ "dbnm ::=",
 /* 131 */ "dbnm ::= DOT nm",
 /* 132 */ "fullname ::= nm dbnm",
 /* 133 */ "joinop ::= COMMA|JOIN",
 /* 134 */ "joinop ::= JOIN_KW JOIN",
 /* 135 */ "joinop ::= JOIN_KW nm JOIN",
 /* 136 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 137 */ "on_opt ::= ON expr",
 /* 138 */ "on_opt ::=",
 /* 139 */ "indexed_opt ::=",
 /* 140 */ "indexed_opt ::= INDEXED BY nm",
 /* 141 */ "indexed_opt ::= NOT INDEXED",
 /* 142 */ "using_opt ::= USING LP inscollist RP",
 /* 143 */ "using_opt ::=",
 /* 144 */ "orderby_opt ::=",
 /* 145 */ "orderby_opt ::= ORDER BY sortlist",
 /* 146 */ "sortlist ::= sortlist COMMA sortitem sortorder",
 /* 147 */ "sortlist ::= sortitem sortorder",
 /* 148 */ "sortitem ::= expr",
 /* 149 */ "sortorder ::= ASC",
 /* 150 */ "sortorder ::= DESC",
 /* 151 */ "sortorder ::=",
 /* 152 */ "groupby_opt ::=",
 /* 153 */ "groupby_opt ::= GROUP BY nexprlist",
 /* 154 */ "having_opt ::=",
 /* 155 */ "having_opt ::= HAVING expr",
 /* 156 */ "limit_opt ::=",
 /* 157 */ "limit_opt ::= LIMIT expr",
 /* 158 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 159 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 160 */ "cmd ::= DELETE FROM fullname indexed_opt where_opt",
 /* 161 */ "where_opt ::=",
 /* 162 */ "where_opt ::= WHERE expr",
 /* 163 */ "cmd ::= UPDATE orconf fullname indexed_opt SET setlist where_opt",
 /* 164 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 165 */ "setlist ::= nm EQ expr",
 /* 166 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 167 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 168 */ "cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES",
 /* 169 */ "insert_cmd ::= INSERT orconf",
 /* 170 */ "insert_cmd ::= REPLACE",
 /* 171 */ "itemlist ::= itemlist COMMA expr",
 /* 172 */ "itemlist ::= expr",
 /* 173 */ "inscollist_opt ::=",
 /* 174 */ "inscollist_opt ::= LP inscollist RP",
 /* 175 */ "inscollist ::= inscollist COMMA nm",
 /* 176 */ "inscollist ::= nm",
 /* 177 */ "expr ::= term",
 /* 178 */ "expr ::= LP expr RP",
 /* 179 */ "term ::= NULL",
 /* 180 */ "expr ::= ID",
 /* 181 */ "expr ::= JOIN_KW",
 /* 182 */ "expr ::= nm DOT nm",
 /* 183 */ "expr ::= nm DOT nm DOT nm",
 /* 184 */ "term ::= INTEGER|FLOAT|BLOB",
 /* 185 */ "term ::= STRING",
 /* 186 */ "expr ::= REGISTER",
 /* 187 */ "expr ::= VARIABLE",
 /* 188 */ "expr ::= expr COLLATE ids",
 /* 189 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 190 */ "expr ::= ID LP distinct exprlist RP",
 /* 191 */ "expr ::= ID LP STAR RP",
 /* 192 */ "term ::= CTIME_KW",
 /* 193 */ "expr ::= expr AND expr",
 /* 194 */ "expr ::= expr OR expr",
 /* 195 */ "expr ::= expr LT|GT|GE|LE expr",
 /* 196 */ "expr ::= expr EQ|NE expr",
 /* 197 */ "expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 198 */ "expr ::= expr PLUS|MINUS expr",
 /* 199 */ "expr ::= expr STAR|SLASH|REM expr",
 /* 200 */ "expr ::= expr CONCAT expr",
 /* 201 */ "likeop ::= LIKE_KW",
 /* 202 */ "likeop ::= NOT LIKE_KW",
 /* 203 */ "likeop ::= MATCH",
 /* 204 */ "likeop ::= NOT MATCH",
 /* 205 */ "escape ::= ESCAPE expr",
 /* 206 */ "escape ::=",
 /* 207 */ "expr ::= expr likeop expr escape",
 /* 208 */ "expr ::= expr ISNULL|NOTNULL",
 /* 209 */ "expr ::= expr IS NULL",
 /* 210 */ "expr ::= expr NOT NULL",
 /* 211 */ "expr ::= expr IS NOT NULL",
 /* 212 */ "expr ::= NOT expr",
 /* 213 */ "expr ::= BITNOT expr",
 /* 214 */ "expr ::= MINUS expr",
 /* 215 */ "expr ::= PLUS expr",
 /* 216 */ "between_op ::= BETWEEN",
 /* 217 */ "between_op ::= NOT BETWEEN",
 /* 218 */ "expr ::= expr between_op expr AND expr",
 /* 219 */ "in_op ::= IN",
 /* 220 */ "in_op ::= NOT IN",
 /* 221 */ "expr ::= expr in_op LP exprlist RP",
 /* 222 */ "expr ::= LP select RP",
 /* 223 */ "expr ::= expr in_op LP select RP",
 /* 224 */ "expr ::= expr in_op nm dbnm",
 /* 225 */ "expr ::= EXISTS LP select RP",
 /* 226 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 227 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 228 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 229 */ "case_else ::= ELSE expr",
 /* 230 */ "case_else ::=",
 /* 231 */ "case_operand ::= expr",
 /* 232 */ "case_operand ::=",
 /* 233 */ "exprlist ::= nexprlist",
 /* 234 */ "exprlist ::=",
 /* 235 */ "nexprlist ::= nexprlist COMMA expr",
 /* 236 */ "nexprlist ::= expr",
 /* 237 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP",
 /* 238 */ "uniqueflag ::= UNIQUE",
 /* 239 */ "uniqueflag ::=",
 /* 240 */ "idxlist_opt ::=",
 /* 241 */ "idxlist_opt ::= LP idxlist RP",
 /* 242 */ "idxlist ::= idxlist COMMA nm collate sortorder",
 /* 243 */ "idxlist ::= nm collate sortorder",
 /* 244 */ "collate ::=",
 /* 245 */ "collate ::= COLLATE ids",
 /* 246 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 247 */ "cmd ::= VACUUM",
 /* 248 */ "cmd ::= VACUUM nm",
 /* 249 */ "cmd ::= PRAGMA nm dbnm EQ nmnum",
 /* 250 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 251 */ "cmd ::= PRAGMA nm dbnm EQ DELETE",
 /* 252 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 253 */ "cmd ::= PRAGMA nm dbnm LP nmnum RP",
 /* 254 */ "cmd ::= PRAGMA nm dbnm",
 /* 255 */ "nmnum ::= plus_num",
 /* 256 */ "nmnum ::= nm",
 /* 257 */ "plus_num ::= plus_opt number",
 /* 258 */ "minus_num ::= MINUS number",
 /* 259 */ "number ::= INTEGER|FLOAT",
 /* 260 */ "plus_opt ::= PLUS",
 /* 261 */ "plus_opt ::=",
 /* 262 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 263 */ "trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 264 */ "trigger_time ::= BEFORE",
 /* 265 */ "trigger_time ::= AFTER",
 /* 266 */ "trigger_time ::= INSTEAD OF",
 /* 267 */ "trigger_time ::=",
 /* 268 */ "trigger_event ::= DELETE|INSERT",
 /* 269 */ "trigger_event ::= UPDATE",
 /* 270 */ "trigger_event ::= UPDATE OF inscollist",
 /* 271 */ "foreach_clause ::=",
 /* 272 */ "foreach_clause ::= FOR EACH ROW",
 /* 273 */ "when_clause ::=",
 /* 274 */ "when_clause ::= WHEN expr",
 /* 275 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 276 */ "trigger_cmd_list ::= trigger_cmd SEMI",
 /* 277 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 278 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 279 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 280 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 281 */ "trigger_cmd ::= select",
 /* 282 */ "expr ::= RAISE LP IGNORE RP",
 /* 283 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 284 */ "raisetype ::= ROLLBACK",
 /* 285 */ "raisetype ::= ABORT",
 /* 286 */ "raisetype ::= FAIL",
 /* 287 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 288 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 289 */ "cmd ::= DETACH database_kw_opt expr",
 /* 290 */ "key_opt ::=",
 /* 291 */ "key_opt ::= KEY expr",
 /* 292 */ "database_kw_opt ::= DATABASE",
 /* 293 */ "database_kw_opt ::=",
 /* 294 */ "cmd ::= REINDEX",
 /* 295 */ "cmd ::= REINDEX nm dbnm",
 /* 296 */ "cmd ::= ANALYZE",
 /* 297 */ "cmd ::= ANALYZE nm dbnm",
 /* 298 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 299 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 300 */ "add_column_fullname ::= fullname",
 /* 301 */ "kwcolumn_opt ::=",
 /* 302 */ "kwcolumn_opt ::= COLUMNKW",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  sqlite3ParserARG_FETCH;
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 156: /* select */
    case 190: /* oneselect */
    case 208: /* seltablist_paren */
{
#line 369 "parse.y"
sqlite3SelectDelete(pParse->db, (yypminor->yy91));
#line 1279 "parse.c"
}
      break;
    case 170: /* term */
    case 171: /* expr */
    case 195: /* where_opt */
    case 197: /* having_opt */
    case 206: /* on_opt */
    case 212: /* sortitem */
    case 220: /* escape */
    case 223: /* case_operand */
    case 225: /* case_else */
    case 236: /* when_clause */
    case 239: /* key_opt */
{
#line 669 "parse.y"
sqlite3ExprDelete(pParse->db, (yypminor->yy418));
#line 1296 "parse.c"
}
      break;
    case 175: /* idxlist_opt */
    case 183: /* idxlist */
    case 193: /* selcollist */
    case 196: /* groupby_opt */
    case 198: /* orderby_opt */
    case 200: /* sclp */
    case 211: /* sortlist */
    case 213: /* nexprlist */
    case 214: /* setlist */
    case 217: /* itemlist */
    case 218: /* exprlist */
    case 224: /* case_exprlist */
{
#line 927 "parse.y"
sqlite3ExprListDelete(pParse->db, (yypminor->yy322));
#line 1314 "parse.c"
}
      break;
    case 189: /* fullname */
    case 194: /* from */
    case 202: /* seltablist */
    case 203: /* stl_prefix */
{
#line 487 "parse.y"
sqlite3SrcListDelete(pParse->db, (yypminor->yy439));
#line 1324 "parse.c"
}
      break;
    case 207: /* using_opt */
    case 210: /* inscollist */
    case 216: /* inscollist_opt */
{
#line 519 "parse.y"
sqlite3IdListDelete(pParse->db, (yypminor->yy232));
#line 1333 "parse.c"
}
      break;
    case 232: /* trigger_cmd_list */
    case 237: /* trigger_cmd */
{
#line 1031 "parse.y"
sqlite3DeleteTriggerStep(pParse->db, (yypminor->yy451));
#line 1341 "parse.c"
}
      break;
    case 234: /* trigger_event */
{
#line 1017 "parse.y"
sqlite3IdListDelete(pParse->db, (yypminor->yy378).b);
#line 1348 "parse.c"
}
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int sqlite3ParserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      int iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_MAX ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_MAX );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_SZ_ACTTAB );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   sqlite3ParserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
#line 39 "parse.y"

  sqlite3ErrorMsg(pParse, "parser stack overflow");
  pParse->parseError = 1;
#line 1526 "parse.c"
   sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 140, 1 },
  { 141, 2 },
  { 141, 1 },
  { 142, 1 },
  { 142, 3 },
  { 143, 0 },
  { 143, 1 },
  { 143, 3 },
  { 144, 1 },
  { 145, 3 },
  { 147, 0 },
  { 147, 1 },
  { 147, 2 },
  { 146, 0 },
  { 146, 1 },
  { 146, 1 },
  { 146, 1 },
  { 145, 2 },
  { 145, 2 },
  { 145, 2 },
  { 145, 2 },
  { 149, 6 },
  { 152, 0 },
  { 152, 3 },
  { 151, 1 },
  { 151, 0 },
  { 150, 4 },
  { 150, 2 },
  { 154, 3 },
  { 154, 1 },
  { 157, 3 },
  { 158, 1 },
  { 161, 1 },
  { 162, 1 },
  { 148, 1 },
  { 148, 1 },
  { 148, 1 },
  { 159, 0 },
  { 159, 1 },
  { 163, 1 },
  { 163, 4 },
  { 163, 6 },
  { 164, 1 },
  { 164, 2 },
  { 165, 1 },
  { 165, 1 },
  { 160, 2 },
  { 160, 0 },
  { 168, 3 },
  { 168, 1 },
  { 169, 2 },
  { 169, 4 },
  { 169, 3 },
  { 169, 3 },
  { 169, 2 },
  { 169, 2 },
  { 169, 3 },
  { 169, 5 },
  { 169, 2 },
  { 169, 4 },
  { 169, 4 },
  { 169, 1 },
  { 169, 2 },
  { 174, 0 },
  { 174, 1 },
  { 176, 0 },
  { 176, 2 },
  { 178, 2 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 179, 2 },
  { 179, 2 },
  { 179, 1 },
  { 179, 1 },
  { 177, 3 },
  { 177, 2 },
  { 180, 0 },
  { 180, 2 },
  { 180, 2 },
  { 155, 0 },
  { 155, 2 },
  { 181, 3 },
  { 181, 2 },
  { 181, 1 },
  { 182, 2 },
  { 182, 7 },
  { 182, 5 },
  { 182, 5 },
  { 182, 10 },
  { 184, 0 },
  { 184, 1 },
  { 172, 0 },
  { 172, 3 },
  { 185, 0 },
  { 185, 2 },
  { 186, 1 },
  { 186, 1 },
  { 186, 1 },
  { 145, 4 },
  { 188, 2 },
  { 188, 0 },
  { 145, 8 },
  { 145, 4 },
  { 145, 1 },
  { 156, 1 },
  { 156, 3 },
  { 191, 1 },
  { 191, 2 },
  { 191, 1 },
  { 190, 9 },
  { 192, 1 },
  { 192, 1 },
  { 192, 0 },
  { 200, 2 },
  { 200, 0 },
  { 193, 3 },
  { 193, 2 },
  { 193, 4 },
  { 201, 2 },
  { 201, 1 },
  { 201, 0 },
  { 194, 0 },
  { 194, 2 },
  { 203, 2 },
  { 203, 0 },
  { 202, 7 },
  { 202, 7 },
  { 208, 1 },
  { 208, 1 },
  { 153, 0 },
  { 153, 2 },
  { 189, 2 },
  { 204, 1 },
  { 204, 2 },
  { 204, 3 },
  { 204, 4 },
  { 206, 2 },
  { 206, 0 },
  { 205, 0 },
  { 205, 3 },
  { 205, 2 },
  { 207, 4 },
  { 207, 0 },
  { 198, 0 },
  { 198, 3 },
  { 211, 4 },
  { 211, 2 },
  { 212, 1 },
  { 173, 1 },
  { 173, 1 },
  { 173, 0 },
  { 196, 0 },
  { 196, 3 },
  { 197, 0 },
  { 197, 2 },
  { 199, 0 },
  { 199, 2 },
  { 199, 4 },
  { 199, 4 },
  { 145, 5 },
  { 195, 0 },
  { 195, 2 },
  { 145, 7 },
  { 214, 5 },
  { 214, 3 },
  { 145, 8 },
  { 145, 5 },
  { 145, 6 },
  { 215, 2 },
  { 215, 1 },
  { 217, 3 },
  { 217, 1 },
  { 216, 0 },
  { 216, 3 },
  { 210, 3 },
  { 210, 1 },
  { 171, 1 },
  { 171, 3 },
  { 170, 1 },
  { 171, 1 },
  { 171, 1 },
  { 171, 3 },
  { 171, 5 },
  { 170, 1 },
  { 170, 1 },
  { 171, 1 },
  { 171, 1 },
  { 171, 3 },
  { 171, 6 },
  { 171, 5 },
  { 171, 4 },
  { 170, 1 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 219, 1 },
  { 219, 2 },
  { 219, 1 },
  { 219, 2 },
  { 220, 2 },
  { 220, 0 },
  { 171, 4 },
  { 171, 2 },
  { 171, 3 },
  { 171, 3 },
  { 171, 4 },
  { 171, 2 },
  { 171, 2 },
  { 171, 2 },
  { 171, 2 },
  { 221, 1 },
  { 221, 2 },
  { 171, 5 },
  { 222, 1 },
  { 222, 2 },
  { 171, 5 },
  { 171, 3 },
  { 171, 5 },
  { 171, 4 },
  { 171, 4 },
  { 171, 5 },
  { 224, 5 },
  { 224, 4 },
  { 225, 2 },
  { 225, 0 },
  { 223, 1 },
  { 223, 0 },
  { 218, 1 },
  { 218, 0 },
  { 213, 3 },
  { 213, 1 },
  { 145, 11 },
  { 226, 1 },
  { 226, 0 },
  { 175, 0 },
  { 175, 3 },
  { 183, 5 },
  { 183, 3 },
  { 227, 0 },
  { 227, 2 },
  { 145, 4 },
  { 145, 1 },
  { 145, 2 },
  { 145, 5 },
  { 145, 5 },
  { 145, 5 },
  { 145, 5 },
  { 145, 6 },
  { 145, 3 },
  { 228, 1 },
  { 228, 1 },
  { 166, 2 },
  { 167, 2 },
  { 230, 1 },
  { 229, 1 },
  { 229, 0 },
  { 145, 5 },
  { 231, 11 },
  { 233, 1 },
  { 233, 1 },
  { 233, 2 },
  { 233, 0 },
  { 234, 1 },
  { 234, 1 },
  { 234, 3 },
  { 235, 0 },
  { 235, 3 },
  { 236, 0 },
  { 236, 2 },
  { 232, 3 },
  { 232, 2 },
  { 237, 6 },
  { 237, 8 },
  { 237, 5 },
  { 237, 4 },
  { 237, 1 },
  { 171, 4 },
  { 171, 6 },
  { 187, 1 },
  { 187, 1 },
  { 187, 1 },
  { 145, 4 },
  { 145, 6 },
  { 145, 3 },
  { 239, 0 },
  { 239, 2 },
  { 238, 1 },
  { 238, 0 },
  { 145, 1 },
  { 145, 3 },
  { 145, 1 },
  { 145, 3 },
  { 145, 6 },
  { 145, 6 },
  { 240, 1 },
  { 241, 0 },
  { 241, 1 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0: /* input ::= cmdlist */
      case 1: /* cmdlist ::= cmdlist ecmd */
      case 2: /* cmdlist ::= ecmd */
      case 3: /* ecmd ::= SEMI */
      case 4: /* ecmd ::= explain cmdx SEMI */
      case 10: /* trans_opt ::= */
      case 11: /* trans_opt ::= TRANSACTION */
      case 12: /* trans_opt ::= TRANSACTION nm */
      case 20: /* cmd ::= create_table create_table_args */
      case 28: /* columnlist ::= columnlist COMMA column */
      case 29: /* columnlist ::= column */
      case 37: /* type ::= */
      case 44: /* signed ::= plus_num */
      case 45: /* signed ::= minus_num */
      case 46: /* carglist ::= carglist carg */
      case 47: /* carglist ::= */
      case 48: /* carg ::= CONSTRAINT nm ccons */
      case 49: /* carg ::= ccons */
      case 55: /* ccons ::= NULL onconf */
      case 82: /* conslist ::= conslist COMMA tcons */
      case 83: /* conslist ::= conslist tcons */
      case 84: /* conslist ::= tcons */
      case 85: /* tcons ::= CONSTRAINT nm */
      case 260: /* plus_opt ::= PLUS */
      case 261: /* plus_opt ::= */
      case 271: /* foreach_clause ::= */
      case 272: /* foreach_clause ::= FOR EACH ROW */
      case 292: /* database_kw_opt ::= DATABASE */
      case 293: /* database_kw_opt ::= */
      case 301: /* kwcolumn_opt ::= */
      case 302: /* kwcolumn_opt ::= COLUMNKW */
#line 91 "parse.y"
{
}
#line 1974 "parse.c"
        break;
      case 5: /* explain ::= */
#line 96 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1979 "parse.c"
        break;
      case 6: /* explain ::= EXPLAIN */
#line 98 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1984 "parse.c"
        break;
      case 7: /* explain ::= EXPLAIN QUERY PLAN */
#line 99 "parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 1989 "parse.c"
        break;
      case 8: /* cmdx ::= cmd */
#line 101 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1994 "parse.c"
        break;
      case 9: /* cmd ::= BEGIN transtype trans_opt */
#line 106 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy328);}
#line 1999 "parse.c"
        break;
      case 13: /* transtype ::= */
#line 111 "parse.y"
{yygotominor.yy328 = TK_DEFERRED;}
#line 2004 "parse.c"
        break;
      case 14: /* transtype ::= DEFERRED */
      case 15: /* transtype ::= IMMEDIATE */
      case 16: /* transtype ::= EXCLUSIVE */
      case 107: /* multiselect_op ::= UNION */
      case 109: /* multiselect_op ::= EXCEPT|INTERSECT */
#line 112 "parse.y"
{yygotominor.yy328 = yymsp[0].major;}
#line 2013 "parse.c"
        break;
      case 17: /* cmd ::= COMMIT trans_opt */
      case 18: /* cmd ::= END trans_opt */
#line 115 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 2019 "parse.c"
        break;
      case 19: /* cmd ::= ROLLBACK trans_opt */
#line 117 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 2024 "parse.c"
        break;
      case 21: /* create_table ::= CREATE temp TABLE ifnotexists nm dbnm */
#line 122 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0,yymsp[-4].minor.yy328,0,0,yymsp[-2].minor.yy328);
}
#line 2031 "parse.c"
        break;
      case 22: /* ifnotexists ::= */
      case 25: /* temp ::= */
      case 63: /* autoinc ::= */
      case 77: /* init_deferred_pred_opt ::= */
      case 79: /* init_deferred_pred_opt ::= INITIALLY IMMEDIATE */
      case 90: /* defer_subclause_opt ::= */
      case 101: /* ifexists ::= */
      case 112: /* distinct ::= ALL */
      case 113: /* distinct ::= */
      case 216: /* between_op ::= BETWEEN */
      case 219: /* in_op ::= IN */
#line 126 "parse.y"
{yygotominor.yy328 = 0;}
#line 2046 "parse.c"
        break;
      case 23: /* ifnotexists ::= IF NOT EXISTS */
      case 24: /* temp ::= TEMP */
      case 64: /* autoinc ::= AUTOINCR */
      case 78: /* init_deferred_pred_opt ::= INITIALLY DEFERRED */
      case 100: /* ifexists ::= IF EXISTS */
      case 111: /* distinct ::= DISTINCT */
      case 217: /* between_op ::= NOT BETWEEN */
      case 220: /* in_op ::= NOT IN */
#line 127 "parse.y"
{yygotominor.yy328 = 1;}
#line 2058 "parse.c"
        break;
      case 26: /* create_table_args ::= LP columnlist conslist_opt RP */
#line 133 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0,0);
}
#line 2065 "parse.c"
        break;
      case 27: /* create_table_args ::= AS select */
#line 136 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy91);
  sqlite3SelectDelete(pParse->db, yymsp[0].minor.yy91);
}
#line 2073 "parse.c"
        break;
      case 30: /* column ::= columnid type carglist */
#line 148 "parse.y"
{
  yygotominor.yy0.z = yymsp[-2].minor.yy0.z;
  yygotominor.yy0.n = (pParse->sLastToken.z-yymsp[-2].minor.yy0.z) + pParse->sLastToken.n;
}
#line 2081 "parse.c"
        break;
      case 31: /* columnid ::= nm */
#line 152 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy0);
  yygotominor.yy0 = yymsp[0].minor.yy0;
}
#line 2089 "parse.c"
        break;
      case 32: /* id ::= ID */
      case 33: /* ids ::= ID|STRING */
      case 34: /* nm ::= ID */
      case 35: /* nm ::= STRING */
      case 36: /* nm ::= JOIN_KW */
      case 39: /* typetoken ::= typename */
      case 42: /* typename ::= ids */
      case 119: /* as ::= AS nm */
      case 120: /* as ::= ids */
      case 131: /* dbnm ::= DOT nm */
      case 140: /* indexed_opt ::= INDEXED BY nm */
      case 245: /* collate ::= COLLATE ids */
      case 255: /* nmnum ::= plus_num */
      case 256: /* nmnum ::= nm */
      case 257: /* plus_num ::= plus_opt number */
      case 258: /* minus_num ::= MINUS number */
      case 259: /* number ::= INTEGER|FLOAT */
#line 162 "parse.y"
{yygotominor.yy0 = yymsp[0].minor.yy0;}
#line 2110 "parse.c"
        break;
      case 38: /* type ::= typetoken */
#line 223 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy0);}
#line 2115 "parse.c"
        break;
      case 40: /* typetoken ::= typename LP signed RP */
#line 225 "parse.y"
{
  yygotominor.yy0.z = yymsp[-3].minor.yy0.z;
  yygotominor.yy0.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy0.z;
}
#line 2123 "parse.c"
        break;
      case 41: /* typetoken ::= typename LP signed COMMA signed RP */
#line 229 "parse.y"
{
  yygotominor.yy0.z = yymsp[-5].minor.yy0.z;
  yygotominor.yy0.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy0.z;
}
#line 2131 "parse.c"
        break;
      case 43: /* typename ::= typename ids */
#line 235 "parse.y"
{yygotominor.yy0.z=yymsp[-1].minor.yy0.z; yygotominor.yy0.n=yymsp[0].minor.yy0.n+(yymsp[0].minor.yy0.z-yymsp[-1].minor.yy0.z);}
#line 2136 "parse.c"
        break;
      case 50: /* ccons ::= DEFAULT term */
      case 52: /* ccons ::= DEFAULT PLUS term */
#line 246 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy418);}
#line 2142 "parse.c"
        break;
      case 51: /* ccons ::= DEFAULT LP expr RP */
#line 247 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy418);}
#line 2147 "parse.c"
        break;
      case 53: /* ccons ::= DEFAULT MINUS term */
#line 249 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_UMINUS, yymsp[0].minor.yy418, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2155 "parse.c"
        break;
      case 54: /* ccons ::= DEFAULT id */
#line 253 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_STRING, 0, 0, &yymsp[0].minor.yy0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2163 "parse.c"
        break;
      case 56: /* ccons ::= NOT NULL onconf */
#line 262 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy328);}
#line 2168 "parse.c"
        break;
      case 57: /* ccons ::= PRIMARY KEY sortorder onconf autoinc */
#line 264 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy328,yymsp[0].minor.yy328,yymsp[-2].minor.yy328);}
#line 2173 "parse.c"
        break;
      case 58: /* ccons ::= UNIQUE onconf */
#line 265 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy328,0,0,0,0);}
#line 2178 "parse.c"
        break;
      case 59: /* ccons ::= CHECK LP expr RP */
#line 266 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-1].minor.yy418);}
#line 2183 "parse.c"
        break;
      case 60: /* ccons ::= REFERENCES nm idxlist_opt refargs */
#line 268 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy0,yymsp[-1].minor.yy322,yymsp[0].minor.yy328);}
#line 2188 "parse.c"
        break;
      case 61: /* ccons ::= defer_subclause */
#line 269 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy328);}
#line 2193 "parse.c"
        break;
      case 62: /* ccons ::= COLLATE ids */
#line 270 "parse.y"
{sqlite3AddCollateType(pParse, &yymsp[0].minor.yy0);}
#line 2198 "parse.c"
        break;
      case 65: /* refargs ::= */
#line 283 "parse.y"
{ yygotominor.yy328 = OE_Restrict * 0x010101; }
#line 2203 "parse.c"
        break;
      case 66: /* refargs ::= refargs refarg */
#line 284 "parse.y"
{ yygotominor.yy328 = (yymsp[-1].minor.yy328 & ~yymsp[0].minor.yy319.mask) | yymsp[0].minor.yy319.value; }
#line 2208 "parse.c"
        break;
      case 67: /* refarg ::= MATCH nm */
#line 286 "parse.y"
{ yygotominor.yy319.value = 0;     yygotominor.yy319.mask = 0x000000; }
#line 2213 "parse.c"
        break;
      case 68: /* refarg ::= ON DELETE refact */
#line 287 "parse.y"
{ yygotominor.yy319.value = yymsp[0].minor.yy328;     yygotominor.yy319.mask = 0x0000ff; }
#line 2218 "parse.c"
        break;
      case 69: /* refarg ::= ON UPDATE refact */
#line 288 "parse.y"
{ yygotominor.yy319.value = yymsp[0].minor.yy328<<8;  yygotominor.yy319.mask = 0x00ff00; }
#line 2223 "parse.c"
        break;
      case 70: /* refarg ::= ON INSERT refact */
#line 289 "parse.y"
{ yygotominor.yy319.value = yymsp[0].minor.yy328<<16; yygotominor.yy319.mask = 0xff0000; }
#line 2228 "parse.c"
        break;
      case 71: /* refact ::= SET NULL */
#line 291 "parse.y"
{ yygotominor.yy328 = OE_SetNull; }
#line 2233 "parse.c"
        break;
      case 72: /* refact ::= SET DEFAULT */
#line 292 "parse.y"
{ yygotominor.yy328 = OE_SetDflt; }
#line 2238 "parse.c"
        break;
      case 73: /* refact ::= CASCADE */
#line 293 "parse.y"
{ yygotominor.yy328 = OE_Cascade; }
#line 2243 "parse.c"
        break;
      case 74: /* refact ::= RESTRICT */
#line 294 "parse.y"
{ yygotominor.yy328 = OE_Restrict; }
#line 2248 "parse.c"
        break;
      case 75: /* defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt */
      case 76: /* defer_subclause ::= DEFERRABLE init_deferred_pred_opt */
      case 91: /* defer_subclause_opt ::= defer_subclause */
      case 93: /* onconf ::= ON CONFLICT resolvetype */
      case 95: /* orconf ::= OR resolvetype */
      case 96: /* resolvetype ::= raisetype */
      case 169: /* insert_cmd ::= INSERT orconf */
#line 296 "parse.y"
{yygotominor.yy328 = yymsp[0].minor.yy328;}
#line 2259 "parse.c"
        break;
      case 80: /* conslist_opt ::= */
#line 306 "parse.y"
{yygotominor.yy0.n = 0; yygotominor.yy0.z = 0;}
#line 2264 "parse.c"
        break;
      case 81: /* conslist_opt ::= COMMA conslist */
#line 307 "parse.y"
{yygotominor.yy0 = yymsp[-1].minor.yy0;}
#line 2269 "parse.c"
        break;
      case 86: /* tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf */
#line 313 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy322,yymsp[0].minor.yy328,yymsp[-2].minor.yy328,0);}
#line 2274 "parse.c"
        break;
      case 87: /* tcons ::= UNIQUE LP idxlist RP onconf */
#line 315 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy322,yymsp[0].minor.yy328,0,0,0,0);}
#line 2279 "parse.c"
        break;
      case 88: /* tcons ::= CHECK LP expr RP onconf */
#line 316 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-2].minor.yy418);}
#line 2284 "parse.c"
        break;
      case 89: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt */
#line 318 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy322, &yymsp[-3].minor.yy0, yymsp[-2].minor.yy322, yymsp[-1].minor.yy328);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy328);
}
#line 2292 "parse.c"
        break;
      case 92: /* onconf ::= */
      case 94: /* orconf ::= */
#line 332 "parse.y"
{yygotominor.yy328 = OE_Default;}
#line 2298 "parse.c"
        break;
      case 97: /* resolvetype ::= IGNORE */
#line 337 "parse.y"
{yygotominor.yy328 = OE_Ignore;}
#line 2303 "parse.c"
        break;
      case 98: /* resolvetype ::= REPLACE */
      case 170: /* insert_cmd ::= REPLACE */
#line 338 "parse.y"
{yygotominor.yy328 = OE_Replace;}
#line 2309 "parse.c"
        break;
      case 99: /* cmd ::= DROP TABLE ifexists fullname */
#line 342 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy439, 0, yymsp[-1].minor.yy328);
}
#line 2316 "parse.c"
        break;
      case 102: /* cmd ::= CREATE temp VIEW ifnotexists nm dbnm AS select */
#line 352 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-7].minor.yy0, &yymsp[-3].minor.yy0, &yymsp[-2].minor.yy0, yymsp[0].minor.yy91, yymsp[-6].minor.yy328, yymsp[-4].minor.yy328);
}
#line 2323 "parse.c"
        break;
      case 103: /* cmd ::= DROP VIEW ifexists fullname */
#line 355 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy439, 1, yymsp[-1].minor.yy328);
}
#line 2330 "parse.c"
        break;
      case 104: /* cmd ::= select */
#line 362 "parse.y"
{
  SelectDest dest = {SRT_Output, 0, 0, 0, 0};
  sqlite3Select(pParse, yymsp[0].minor.yy91, &dest);
  sqlite3SelectDelete(pParse->db, yymsp[0].minor.yy91);
}
#line 2339 "parse.c"
        break;
      case 105: /* select ::= oneselect */
      case 128: /* seltablist_paren ::= select */
#line 373 "parse.y"
{yygotominor.yy91 = yymsp[0].minor.yy91;}
#line 2345 "parse.c"
        break;
      case 106: /* select ::= select multiselect_op oneselect */
#line 375 "parse.y"
{
  if( yymsp[0].minor.yy91 ){
    yymsp[0].minor.yy91->op = yymsp[-1].minor.yy328;
    yymsp[0].minor.yy91->pPrior = yymsp[-2].minor.yy91;
  }else{
    sqlite3SelectDelete(pParse->db, yymsp[-2].minor.yy91);
  }
  yygotominor.yy91 = yymsp[0].minor.yy91;
}
#line 2358 "parse.c"
        break;
      case 108: /* multiselect_op ::= UNION ALL */
#line 386 "parse.y"
{yygotominor.yy328 = TK_ALL;}
#line 2363 "parse.c"
        break;
      case 110: /* oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
#line 390 "parse.y"
{
  yygotominor.yy91 = sqlite3SelectNew(pParse,yymsp[-6].minor.yy322,yymsp[-5].minor.yy439,yymsp[-4].minor.yy418,yymsp[-3].minor.yy322,yymsp[-2].minor.yy418,yymsp[-1].minor.yy322,yymsp[-7].minor.yy328,yymsp[0].minor.yy388.pLimit,yymsp[0].minor.yy388.pOffset);
}
#line 2370 "parse.c"
        break;
      case 114: /* sclp ::= selcollist COMMA */
      case 241: /* idxlist_opt ::= LP idxlist RP */
#line 411 "parse.y"
{yygotominor.yy322 = yymsp[-1].minor.yy322;}
#line 2376 "parse.c"
        break;
      case 115: /* sclp ::= */
      case 144: /* orderby_opt ::= */
      case 152: /* groupby_opt ::= */
      case 234: /* exprlist ::= */
      case 240: /* idxlist_opt ::= */
#line 412 "parse.y"
{yygotominor.yy322 = 0;}
#line 2385 "parse.c"
        break;
      case 116: /* selcollist ::= sclp expr as */
#line 413 "parse.y"
{
   yygotominor.yy322 = sqlite3ExprListAppend(pParse,yymsp[-2].minor.yy322,yymsp[-1].minor.yy418,yymsp[0].minor.yy0.n?&yymsp[0].minor.yy0:0);
}
#line 2392 "parse.c"
        break;
      case 117: /* selcollist ::= sclp STAR */
#line 416 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_ALL, 0, 0, 0);
  yygotominor.yy322 = sqlite3ExprListAppend(pParse, yymsp[-1].minor.yy322, p, 0);
}
#line 2400 "parse.c"
        break;
      case 118: /* selcollist ::= sclp nm DOT STAR */
#line 420 "parse.y"
{
  Expr *pRight = sqlite3PExpr(pParse, TK_ALL, 0, 0, &yymsp[0].minor.yy0);
  Expr *pLeft = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy0);
  Expr *pDot = sqlite3PExpr(pParse, TK_DOT, pLeft, pRight, 0);
  yygotominor.yy322 = sqlite3ExprListAppend(pParse,yymsp[-3].minor.yy322, pDot, 0);
}
#line 2410 "parse.c"
        break;
      case 121: /* as ::= */
#line 433 "parse.y"
{yygotominor.yy0.n = 0;}
#line 2415 "parse.c"
        break;
      case 122: /* from ::= */
#line 445 "parse.y"
{yygotominor.yy439 = sqlite3DbMallocZero(pParse->db, sizeof(*yygotominor.yy439));}
#line 2420 "parse.c"
        break;
      case 123: /* from ::= FROM seltablist */
#line 446 "parse.y"
{
  yygotominor.yy439 = yymsp[0].minor.yy439;
  sqlite3SrcListShiftJoinType(yygotominor.yy439);
}
#line 2428 "parse.c"
        break;
      case 124: /* stl_prefix ::= seltablist joinop */
#line 454 "parse.y"
{
   yygotominor.yy439 = yymsp[-1].minor.yy439;
   if( yygotominor.yy439 && yygotominor.yy439->nSrc>0 ) yygotominor.yy439->a[yygotominor.yy439->nSrc-1].jointype = yymsp[0].minor.yy328;
}
#line 2436 "parse.c"
        break;
      case 125: /* stl_prefix ::= */
#line 458 "parse.y"
{yygotominor.yy439 = 0;}
#line 2441 "parse.c"
        break;
      case 126: /* seltablist ::= stl_prefix nm dbnm as indexed_opt on_opt using_opt */
#line 459 "parse.y"
{
  yygotominor.yy439 = sqlite3SrcListAppendFromTerm(pParse,yymsp[-6].minor.yy439,&yymsp[-5].minor.yy0,&yymsp[-4].minor.yy0,&yymsp[-3].minor.yy0,0,yymsp[-1].minor.yy418,yymsp[0].minor.yy232);
  sqlite3SrcListIndexedBy(pParse, yygotominor.yy439, &yymsp[-2].minor.yy0);
}
#line 2449 "parse.c"
        break;
      case 127: /* seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt */
#line 465 "parse.y"
{
    yygotominor.yy439 = sqlite3SrcListAppendFromTerm(pParse,yymsp[-6].minor.yy439,0,0,&yymsp[-2].minor.yy0,yymsp[-4].minor.yy91,yymsp[-1].minor.yy418,yymsp[0].minor.yy232);
  }
#line 2456 "parse.c"
        break;
      case 129: /* seltablist_paren ::= seltablist */
#line 476 "parse.y"
{
     sqlite3SrcListShiftJoinType(yymsp[0].minor.yy439);
     yygotominor.yy91 = sqlite3SelectNew(pParse,0,yymsp[0].minor.yy439,0,0,0,0,0,0,0);
  }
#line 2464 "parse.c"
        break;
      case 130: /* dbnm ::= */
      case 139: /* indexed_opt ::= */
#line 483 "parse.y"
{yygotominor.yy0.z=0; yygotominor.yy0.n=0;}
#line 2470 "parse.c"
        break;
      case 132: /* fullname ::= nm dbnm */
#line 488 "parse.y"
{yygotominor.yy439 = sqlite3SrcListAppend(pParse->db,0,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0);}
#line 2475 "parse.c"
        break;
      case 133: /* joinop ::= COMMA|JOIN */
#line 492 "parse.y"
{ yygotominor.yy328 = JT_INNER; }
#line 2480 "parse.c"
        break;
      case 134: /* joinop ::= JOIN_KW JOIN */
#line 493 "parse.y"
{ yygotominor.yy328 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2485 "parse.c"
        break;
      case 135: /* joinop ::= JOIN_KW nm JOIN */
#line 494 "parse.y"
{ yygotominor.yy328 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy0,0); }
#line 2490 "parse.c"
        break;
      case 136: /* joinop ::= JOIN_KW nm nm JOIN */
#line 496 "parse.y"
{ yygotominor.yy328 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy0); }
#line 2495 "parse.c"
        break;
      case 137: /* on_opt ::= ON expr */
      case 148: /* sortitem ::= expr */
      case 155: /* having_opt ::= HAVING expr */
      case 162: /* where_opt ::= WHERE expr */
      case 177: /* expr ::= term */
      case 205: /* escape ::= ESCAPE expr */
      case 229: /* case_else ::= ELSE expr */
      case 231: /* case_operand ::= expr */
#line 500 "parse.y"
{yygotominor.yy418 = yymsp[0].minor.yy418;}
#line 2507 "parse.c"
        break;
      case 138: /* on_opt ::= */
      case 154: /* having_opt ::= */
      case 161: /* where_opt ::= */
      case 206: /* escape ::= */
      case 230: /* case_else ::= */
      case 232: /* case_operand ::= */
#line 501 "parse.y"
{yygotominor.yy418 = 0;}
#line 2517 "parse.c"
        break;
      case 141: /* indexed_opt ::= NOT INDEXED */
#line 516 "parse.y"
{yygotominor.yy0.z=0; yygotominor.yy0.n=1;}
#line 2522 "parse.c"
        break;
      case 142: /* using_opt ::= USING LP inscollist RP */
      case 174: /* inscollist_opt ::= LP inscollist RP */
#line 520 "parse.y"
{yygotominor.yy232 = yymsp[-1].minor.yy232;}
#line 2528 "parse.c"
        break;
      case 143: /* using_opt ::= */
      case 173: /* inscollist_opt ::= */
#line 521 "parse.y"
{yygotominor.yy232 = 0;}
#line 2534 "parse.c"
        break;
      case 145: /* orderby_opt ::= ORDER BY sortlist */
      case 153: /* groupby_opt ::= GROUP BY nexprlist */
      case 233: /* exprlist ::= nexprlist */
#line 532 "parse.y"
{yygotominor.yy322 = yymsp[0].minor.yy322;}
#line 2541 "parse.c"
        break;
      case 146: /* sortlist ::= sortlist COMMA sortitem sortorder */
#line 533 "parse.y"
{
  yygotominor.yy322 = sqlite3ExprListAppend(pParse,yymsp[-3].minor.yy322,yymsp[-1].minor.yy418,0);
  if( yygotominor.yy322 ) yygotominor.yy322->a[yygotominor.yy322->nExpr-1].sortOrder = yymsp[0].minor.yy328;
}
#line 2549 "parse.c"
        break;
      case 147: /* sortlist ::= sortitem sortorder */
#line 537 "parse.y"
{
  yygotominor.yy322 = sqlite3ExprListAppend(pParse,0,yymsp[-1].minor.yy418,0);
  if( yygotominor.yy322 && yygotominor.yy322->a ) yygotominor.yy322->a[0].sortOrder = yymsp[0].minor.yy328;
}
#line 2557 "parse.c"
        break;
      case 149: /* sortorder ::= ASC */
      case 151: /* sortorder ::= */
#line 545 "parse.y"
{yygotominor.yy328 = SQLITE_SO_ASC;}
#line 2563 "parse.c"
        break;
      case 150: /* sortorder ::= DESC */
#line 546 "parse.y"
{yygotominor.yy328 = SQLITE_SO_DESC;}
#line 2568 "parse.c"
        break;
      case 156: /* limit_opt ::= */
#line 572 "parse.y"
{yygotominor.yy388.pLimit = 0; yygotominor.yy388.pOffset = 0;}
#line 2573 "parse.c"
        break;
      case 157: /* limit_opt ::= LIMIT expr */
#line 573 "parse.y"
{yygotominor.yy388.pLimit = yymsp[0].minor.yy418; yygotominor.yy388.pOffset = 0;}
#line 2578 "parse.c"
        break;
      case 158: /* limit_opt ::= LIMIT expr OFFSET expr */
#line 575 "parse.y"
{yygotominor.yy388.pLimit = yymsp[-2].minor.yy418; yygotominor.yy388.pOffset = yymsp[0].minor.yy418;}
#line 2583 "parse.c"
        break;
      case 159: /* limit_opt ::= LIMIT expr COMMA expr */
#line 577 "parse.y"
{yygotominor.yy388.pOffset = yymsp[-2].minor.yy418; yygotominor.yy388.pLimit = yymsp[0].minor.yy418;}
#line 2588 "parse.c"
        break;
      case 160: /* cmd ::= DELETE FROM fullname indexed_opt where_opt */
#line 590 "parse.y"
{
  sqlite3SrcListIndexedBy(pParse, yymsp[-2].minor.yy439, &yymsp[-1].minor.yy0);
  sqlite3DeleteFrom(pParse,yymsp[-2].minor.yy439,yymsp[0].minor.yy418);
}
#line 2596 "parse.c"
        break;
      case 163: /* cmd ::= UPDATE orconf fullname indexed_opt SET setlist where_opt */
#line 613 "parse.y"
{
  sqlite3SrcListIndexedBy(pParse, yymsp[-4].minor.yy439, &yymsp[-3].minor.yy0);
  sqlite3ExprListCheckLength(pParse,yymsp[-1].minor.yy322,"set list"); 
  sqlite3Update(pParse,yymsp[-4].minor.yy439,yymsp[-1].minor.yy322,yymsp[0].minor.yy418,yymsp[-5].minor.yy328);
}
#line 2605 "parse.c"
        break;
      case 164: /* setlist ::= setlist COMMA nm EQ expr */
#line 624 "parse.y"
{yygotominor.yy322 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy322,yymsp[0].minor.yy418,&yymsp[-2].minor.yy0);}
#line 2610 "parse.c"
        break;
      case 165: /* setlist ::= nm EQ expr */
#line 626 "parse.y"
{yygotominor.yy322 = sqlite3ExprListAppend(pParse,0,yymsp[0].minor.yy418,&yymsp[-2].minor.yy0);}
#line 2615 "parse.c"
        break;
      case 166: /* cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP */
#line 632 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy439, yymsp[-1].minor.yy322, 0, yymsp[-4].minor.yy232, yymsp[-7].minor.yy328);}
#line 2620 "parse.c"
        break;
      case 167: /* cmd ::= insert_cmd INTO fullname inscollist_opt select */
#line 634 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy439, 0, yymsp[0].minor.yy91, yymsp[-1].minor.yy232, yymsp[-4].minor.yy328);}
#line 2625 "parse.c"
        break;
      case 168: /* cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES */
#line 636 "parse.y"
{sqlite3Insert(pParse, yymsp[-3].minor.yy439, 0, 0, yymsp[-2].minor.yy232, yymsp[-5].minor.yy328);}
#line 2630 "parse.c"
        break;
      case 171: /* itemlist ::= itemlist COMMA expr */
      case 235: /* nexprlist ::= nexprlist COMMA expr */
#line 647 "parse.y"
{yygotominor.yy322 = sqlite3ExprListAppend(pParse,yymsp[-2].minor.yy322,yymsp[0].minor.yy418,0);}
#line 2636 "parse.c"
        break;
      case 172: /* itemlist ::= expr */
      case 236: /* nexprlist ::= expr */
#line 649 "parse.y"
{yygotominor.yy322 = sqlite3ExprListAppend(pParse,0,yymsp[0].minor.yy418,0);}
#line 2642 "parse.c"
        break;
      case 175: /* inscollist ::= inscollist COMMA nm */
#line 659 "parse.y"
{yygotominor.yy232 = sqlite3IdListAppend(pParse->db,yymsp[-2].minor.yy232,&yymsp[0].minor.yy0);}
#line 2647 "parse.c"
        break;
      case 176: /* inscollist ::= nm */
#line 661 "parse.y"
{yygotominor.yy232 = sqlite3IdListAppend(pParse->db,0,&yymsp[0].minor.yy0);}
#line 2652 "parse.c"
        break;
      case 178: /* expr ::= LP expr RP */
#line 672 "parse.y"
{yygotominor.yy418 = yymsp[-1].minor.yy418; sqlite3ExprSpan(yygotominor.yy418,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2657 "parse.c"
        break;
      case 179: /* term ::= NULL */
      case 184: /* term ::= INTEGER|FLOAT|BLOB */
      case 185: /* term ::= STRING */
#line 673 "parse.y"
{yygotominor.yy418 = sqlite3PExpr(pParse, yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2664 "parse.c"
        break;
      case 180: /* expr ::= ID */
      case 181: /* expr ::= JOIN_KW */
#line 674 "parse.y"
{yygotominor.yy418 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2670 "parse.c"
        break;
      case 182: /* expr ::= nm DOT nm */
#line 676 "parse.y"
{
  Expr *temp1 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy0);
  Expr *temp2 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);
  yygotominor.yy418 = sqlite3PExpr(pParse, TK_DOT, temp1, temp2, 0);
}
#line 2679 "parse.c"
        break;
      case 183: /* expr ::= nm DOT nm DOT nm */
#line 681 "parse.y"
{
  Expr *temp1 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-4].minor.yy0);
  Expr *temp2 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy0);
  Expr *temp3 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);
  Expr *temp4 = sqlite3PExpr(pParse, TK_DOT, temp2, temp3, 0);
  yygotominor.yy418 = sqlite3PExpr(pParse, TK_DOT, temp1, temp4, 0);
}
#line 2690 "parse.c"
        break;
      case 186: /* expr ::= REGISTER */
#line 690 "parse.y"
{yygotominor.yy418 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2695 "parse.c"
        break;
      case 187: /* expr ::= VARIABLE */
#line 691 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy418 = sqlite3PExpr(pParse, TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2704 "parse.c"
        break;
      case 188: /* expr ::= expr COLLATE ids */
#line 696 "parse.y"
{
  yygotominor.yy418 = sqlite3ExprSetColl(pParse, yymsp[-2].minor.yy418, &yymsp[0].minor.yy0);
}
#line 2711 "parse.c"
        break;
      case 189: /* expr ::= CAST LP expr AS typetoken RP */
#line 700 "parse.y"
{
  yygotominor.yy418 = sqlite3PExpr(pParse, TK_CAST, yymsp[-3].minor.yy418, 0, &yymsp[-1].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy418,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2719 "parse.c"
        break;
      case 190: /* expr ::= ID LP distinct exprlist RP */
#line 705 "parse.y"
{
  if( yymsp[-1].minor.yy322 && yymsp[-1].minor.yy322->nExpr>SQLITE_MAX_FUNCTION_ARG ){
    sqlite3ErrorMsg(pParse, "too many arguments on function %T", &yymsp[-4].minor.yy0);
  }
  yygotominor.yy418 = sqlite3ExprFunction(pParse, yymsp[-1].minor.yy322, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy418,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy328 && yygotominor.yy418 ){
    yygotominor.yy418->flags |= EP_Distinct;
  }
}
#line 2733 "parse.c"
        break;
      case 191: /* expr ::= ID LP STAR RP */
#line 715 "parse.y"
{
  yygotominor.yy418 = sqlite3ExprFunction(pParse, 0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy418,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2741 "parse.c"
        break;
      case 192: /* term ::= CTIME_KW */
#line 719 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy418 = sqlite3ExprFunction(pParse, 0,&yymsp[0].minor.yy0);
  if( yygotominor.yy418 ){
    yygotominor.yy418->op = TK_CONST_FUNC;  
    yygotominor.yy418->span = yymsp[0].minor.yy0;
  }
}
#line 2754 "parse.c"
        break;
      case 193: /* expr ::= expr AND expr */
      case 194: /* expr ::= expr OR expr */
      case 195: /* expr ::= expr LT|GT|GE|LE expr */
      case 196: /* expr ::= expr EQ|NE expr */
      case 197: /* expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr */
      case 198: /* expr ::= expr PLUS|MINUS expr */
      case 199: /* expr ::= expr STAR|SLASH|REM expr */
      case 200: /* expr ::= expr CONCAT expr */
#line 728 "parse.y"
{yygotominor.yy418 = sqlite3PExpr(pParse,yymsp[-1].major,yymsp[-2].minor.yy418,yymsp[0].minor.yy418,0);}
#line 2766 "parse.c"
        break;
      case 201: /* likeop ::= LIKE_KW */
      case 203: /* likeop ::= MATCH */
#line 740 "parse.y"
{yygotominor.yy30.eOperator = yymsp[0].minor.yy0; yygotominor.yy30.not = 0;}
#line 2772 "parse.c"
        break;
      case 202: /* likeop ::= NOT LIKE_KW */
      case 204: /* likeop ::= NOT MATCH */
#line 741 "parse.y"
{yygotominor.yy30.eOperator = yymsp[0].minor.yy0; yygotominor.yy30.not = 1;}
#line 2778 "parse.c"
        break;
      case 207: /* expr ::= expr likeop expr escape */
#line 748 "parse.y"
{
  ExprList *pList;
  pList = sqlite3ExprListAppend(pParse,0, yymsp[-1].minor.yy418, 0);
  pList = sqlite3ExprListAppend(pParse,pList, yymsp[-3].minor.yy418, 0);
  if( yymsp[0].minor.yy418 ){
    pList = sqlite3ExprListAppend(pParse,pList, yymsp[0].minor.yy418, 0);
  }
  yygotominor.yy418 = sqlite3ExprFunction(pParse, pList, &yymsp[-2].minor.yy30.eOperator);
  if( yymsp[-2].minor.yy30.not ) yygotominor.yy418 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy418, 0, 0);
  sqlite3ExprSpan(yygotominor.yy418, &yymsp[-3].minor.yy418->span, &yymsp[-1].minor.yy418->span);
  if( yygotominor.yy418 ) yygotominor.yy418->flags |= EP_InfixFunc;
}
#line 2794 "parse.c"
        break;
      case 208: /* expr ::= expr ISNULL|NOTNULL */
#line 761 "parse.y"
{
  yygotominor.yy418 = sqlite3PExpr(pParse, yymsp[0].major, yymsp[-1].minor.yy418, 0, 0);
  sqlite3ExprSpan(yygotominor.yy418,&yymsp[-1].minor.yy418->span,&yymsp[0].minor.yy0);
}
#line 2802 "parse.c"
        break;
      case 209: /* expr ::= expr IS NULL */
#line 765 "parse.y"
{
  yygotominor.yy418 = sqlite3PExpr(pParse, TK_ISNULL, yymsp[-2].minor.yy418, 0, 0);
  sqlite3ExprSpan(yygotominor.yy418,&yymsp[-2].minor.yy418->span,&yymsp[0].minor.yy0);
}
#line 2810 "parse.c"
        break;
      case 210: /* expr ::= expr NOT NULL */
#line 769 "parse.y"
{
  yygotominor.yy418 = sqlite3PExpr(pParse, TK_NOTNULL, yymsp[-2].minor.yy418, 0, 0);
  sqlite3ExprSpan(yygotominor.yy418,&yymsp[-2].minor.yy418->span,&yymsp[0].minor.yy0);
}
#line 2818 "parse.c"
        break;
      case 211: /* expr ::= expr IS NOT NULL */
#line 773 "parse.y"
{
  yygotominor.yy418 = sqlite3PExpr(pParse, TK_NOTNULL, yymsp[-3].minor.yy418, 0, 0);
  sqlite3ExprSpan(yygotominor.yy418,&yymsp[-3].minor.yy418->span,&yymsp[0].minor.yy0);
}
#line 2826 "parse.c"
        break;
      case 212: /* expr ::= NOT expr */
      case 213: /* expr ::= BITNOT expr */
#line 777 "parse.y"
{
  yygotominor.yy418 = sqlite3PExpr(pParse, yymsp[-1].major, yymsp[0].minor.yy418, 0, 0);
  sqlite3ExprSpan(yygotominor.yy418,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy418->span);
}
#line 2835 "parse.c"
        break;
      case 214: /* expr ::= MINUS expr */
#line 785 "parse.y"
{
  yygotominor.yy418 = sqlite3PExpr(pParse, TK_UMINUS, yymsp[0].minor.yy418, 0, 0);
  sqlite3ExprSpan(yygotominor.yy418,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy418->span);
}
#line 2843 "parse.c"
        break;
      case 215: /* expr ::= PLUS expr */
#line 789 "parse.y"
{
  yygotominor.yy418 = sqlite3PExpr(pParse, TK_UPLUS, yymsp[0].minor.yy418, 0, 0);
  sqlite3ExprSpan(yygotominor.yy418,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy418->span);
}
#line 2851 "parse.c"
        break;
      case 218: /* expr ::= expr between_op expr AND expr */
#line 796 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(pParse,0, yymsp[-2].minor.yy418, 0);
  pList = sqlite3ExprListAppend(pParse,pList, yymsp[0].minor.yy418, 0);
  yygotominor.yy418 = sqlite3PExpr(pParse, TK_BETWEEN, yymsp[-4].minor.yy418, 0, 0);
  if( yygotominor.yy418 ){
    yygotominor.yy418->pList = pList;
  }else{
    sqlite3ExprListDelete(pParse->db, pList);
  } 
  if( yymsp[-3].minor.yy328 ) yygotominor.yy418 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy418, 0, 0);
  sqlite3ExprSpan(yygotominor.yy418,&yymsp[-4].minor.yy418->span,&yymsp[0].minor.yy418->span);
}
#line 2867 "parse.c"
        break;
      case 221: /* expr ::= expr in_op LP exprlist RP */
#line 812 "parse.y"
{
    yygotominor.yy418 = sqlite3PExpr(pParse, TK_IN, yymsp[-4].minor.yy418, 0, 0);
    if( yygotominor.yy418 ){
      yygotominor.yy418->pList = yymsp[-1].minor.yy322;
      sqlite3ExprSetHeight(pParse, yygotominor.yy418);
    }else{
      sqlite3ExprListDelete(pParse->db, yymsp[-1].minor.yy322);
    }
    if( yymsp[-3].minor.yy328 ) yygotominor.yy418 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy418, 0, 0);
    sqlite3ExprSpan(yygotominor.yy418,&yymsp[-4].minor.yy418->span,&yymsp[0].minor.yy0);
  }
#line 2882 "parse.c"
        break;
      case 222: /* expr ::= LP select RP */
#line 823 "parse.y"
{
    yygotominor.yy418 = sqlite3PExpr(pParse, TK_SELECT, 0, 0, 0);
    if( yygotominor.yy418 ){
      yygotominor.yy418->pSelect = yymsp[-1].minor.yy91;
      sqlite3ExprSetHeight(pParse, yygotominor.yy418);
    }else{
      sqlite3SelectDelete(pParse->db, yymsp[-1].minor.yy91);
    }
    sqlite3ExprSpan(yygotominor.yy418,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2896 "parse.c"
        break;
      case 223: /* expr ::= expr in_op LP select RP */
#line 833 "parse.y"
{
    yygotominor.yy418 = sqlite3PExpr(pParse, TK_IN, yymsp[-4].minor.yy418, 0, 0);
    if( yygotominor.yy418 ){
      yygotominor.yy418->pSelect = yymsp[-1].minor.yy91;
      sqlite3ExprSetHeight(pParse, yygotominor.yy418);
    }else{
      sqlite3SelectDelete(pParse->db, yymsp[-1].minor.yy91);
    }
    if( yymsp[-3].minor.yy328 ) yygotominor.yy418 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy418, 0, 0);
    sqlite3ExprSpan(yygotominor.yy418,&yymsp[-4].minor.yy418->span,&yymsp[0].minor.yy0);
  }
#line 2911 "parse.c"
        break;
      case 224: /* expr ::= expr in_op nm dbnm */
#line 844 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(pParse->db, 0,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0);
    yygotominor.yy418 = sqlite3PExpr(pParse, TK_IN, yymsp[-3].minor.yy418, 0, 0);
    if( yygotominor.yy418 ){
      yygotominor.yy418->pSelect = sqlite3SelectNew(pParse, 0,pSrc,0,0,0,0,0,0,0);
      sqlite3ExprSetHeight(pParse, yygotominor.yy418);
    }else{
      sqlite3SrcListDelete(pParse->db, pSrc);
    }
    if( yymsp[-2].minor.yy328 ) yygotominor.yy418 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy418, 0, 0);
    sqlite3ExprSpan(yygotominor.yy418,&yymsp[-3].minor.yy418->span,yymsp[0].minor.yy0.z?&yymsp[0].minor.yy0:&yymsp[-1].minor.yy0);
  }
#line 2927 "parse.c"
        break;
      case 225: /* expr ::= EXISTS LP select RP */
#line 856 "parse.y"
{
    Expr *p = yygotominor.yy418 = sqlite3PExpr(pParse, TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy91;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
      sqlite3ExprSetHeight(pParse, yygotominor.yy418);
    }else{
      sqlite3SelectDelete(pParse->db, yymsp[-1].minor.yy91);
    }
  }
#line 2941 "parse.c"
        break;
      case 226: /* expr ::= CASE case_operand case_exprlist case_else END */
#line 869 "parse.y"
{
  yygotominor.yy418 = sqlite3PExpr(pParse, TK_CASE, yymsp[-3].minor.yy418, yymsp[-1].minor.yy418, 0);
  if( yygotominor.yy418 ){
    yygotominor.yy418->pList = yymsp[-2].minor.yy322;
    sqlite3ExprSetHeight(pParse, yygotominor.yy418);
  }else{
    sqlite3ExprListDelete(pParse->db, yymsp[-2].minor.yy322);
  }
  sqlite3ExprSpan(yygotominor.yy418, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2955 "parse.c"
        break;
      case 227: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
#line 881 "parse.y"
{
  yygotominor.yy322 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy322, yymsp[-2].minor.yy418, 0);
  yygotominor.yy322 = sqlite3ExprListAppend(pParse,yygotominor.yy322, yymsp[0].minor.yy418, 0);
}
#line 2963 "parse.c"
        break;
      case 228: /* case_exprlist ::= WHEN expr THEN expr */
#line 885 "parse.y"
{
  yygotominor.yy322 = sqlite3ExprListAppend(pParse,0, yymsp[-2].minor.yy418, 0);
  yygotominor.yy322 = sqlite3ExprListAppend(pParse,yygotominor.yy322, yymsp[0].minor.yy418, 0);
}
#line 2971 "parse.c"
        break;
      case 237: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP */
#line 914 "parse.y"
{
  sqlite3CreateIndex(pParse, &yymsp[-6].minor.yy0, &yymsp[-5].minor.yy0, 
                     sqlite3SrcListAppend(pParse->db,0,&yymsp[-3].minor.yy0,0), yymsp[-1].minor.yy322, yymsp[-9].minor.yy328,
                      &yymsp[-10].minor.yy0, &yymsp[0].minor.yy0, SQLITE_SO_ASC, yymsp[-7].minor.yy328);
}
#line 2980 "parse.c"
        break;
      case 238: /* uniqueflag ::= UNIQUE */
      case 285: /* raisetype ::= ABORT */
#line 921 "parse.y"
{yygotominor.yy328 = OE_Abort;}
#line 2986 "parse.c"
        break;
      case 239: /* uniqueflag ::= */
#line 922 "parse.y"
{yygotominor.yy328 = OE_None;}
#line 2991 "parse.c"
        break;
      case 242: /* idxlist ::= idxlist COMMA nm collate sortorder */
#line 931 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy0.n>0 ){
    p = sqlite3PExpr(pParse, TK_COLUMN, 0, 0, 0);
    sqlite3ExprSetColl(pParse, p, &yymsp[-1].minor.yy0);
  }
  yygotominor.yy322 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy322, p, &yymsp[-2].minor.yy0);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy322, "index");
  if( yygotominor.yy322 ) yygotominor.yy322->a[yygotominor.yy322->nExpr-1].sortOrder = yymsp[0].minor.yy328;
}
#line 3005 "parse.c"
        break;
      case 243: /* idxlist ::= nm collate sortorder */
#line 941 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy0.n>0 ){
    p = sqlite3PExpr(pParse, TK_COLUMN, 0, 0, 0);
    sqlite3ExprSetColl(pParse, p, &yymsp[-1].minor.yy0);
  }
  yygotominor.yy322 = sqlite3ExprListAppend(pParse,0, p, &yymsp[-2].minor.yy0);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy322, "index");
  if( yygotominor.yy322 ) yygotominor.yy322->a[yygotominor.yy322->nExpr-1].sortOrder = yymsp[0].minor.yy328;
}
#line 3019 "parse.c"
        break;
      case 244: /* collate ::= */
#line 953 "parse.y"
{yygotominor.yy0.z = 0; yygotominor.yy0.n = 0;}
#line 3024 "parse.c"
        break;
      case 246: /* cmd ::= DROP INDEX ifexists fullname */
#line 959 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy439, yymsp[-1].minor.yy328);}
#line 3029 "parse.c"
        break;
      case 247: /* cmd ::= VACUUM */
      case 248: /* cmd ::= VACUUM nm */
#line 965 "parse.y"
{sqlite3Vacuum(pParse);}
#line 3035 "parse.c"
        break;
      case 249: /* cmd ::= PRAGMA nm dbnm EQ nmnum */
      case 250: /* cmd ::= PRAGMA nm dbnm EQ ON */
      case 251: /* cmd ::= PRAGMA nm dbnm EQ DELETE */
#line 974 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0,0);}
#line 3042 "parse.c"
        break;
      case 252: /* cmd ::= PRAGMA nm dbnm EQ minus_num */
#line 977 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0,1);
}
#line 3049 "parse.c"
        break;
      case 253: /* cmd ::= PRAGMA nm dbnm LP nmnum RP */
#line 980 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy0,&yymsp[-3].minor.yy0,&yymsp[-1].minor.yy0,0);}
#line 3054 "parse.c"
        break;
      case 254: /* cmd ::= PRAGMA nm dbnm */
#line 981 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0,0,0);}
#line 3059 "parse.c"
        break;
      case 262: /* cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END */
#line 996 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy0.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy0.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy451, &all);
}
#line 3069 "parse.c"
        break;
      case 263: /* trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause */
#line 1005 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy0, &yymsp[-6].minor.yy0, yymsp[-5].minor.yy328, yymsp[-4].minor.yy378.a, yymsp[-4].minor.yy378.b, yymsp[-2].minor.yy439, yymsp[0].minor.yy418, yymsp[-10].minor.yy328, yymsp[-8].minor.yy328);
  yygotominor.yy0 = (yymsp[-6].minor.yy0.n==0?yymsp[-7].minor.yy0:yymsp[-6].minor.yy0);
}
#line 3077 "parse.c"
        break;
      case 264: /* trigger_time ::= BEFORE */
      case 267: /* trigger_time ::= */
#line 1011 "parse.y"
{ yygotominor.yy328 = TK_BEFORE; }
#line 3083 "parse.c"
        break;
      case 265: /* trigger_time ::= AFTER */
#line 1012 "parse.y"
{ yygotominor.yy328 = TK_AFTER;  }
#line 3088 "parse.c"
        break;
      case 266: /* trigger_time ::= INSTEAD OF */
#line 1013 "parse.y"
{ yygotominor.yy328 = TK_INSTEAD;}
#line 3093 "parse.c"
        break;
      case 268: /* trigger_event ::= DELETE|INSERT */
      case 269: /* trigger_event ::= UPDATE */
#line 1018 "parse.y"
{yygotominor.yy378.a = yymsp[0].major; yygotominor.yy378.b = 0;}
#line 3099 "parse.c"
        break;
      case 270: /* trigger_event ::= UPDATE OF inscollist */
#line 1020 "parse.y"
{yygotominor.yy378.a = TK_UPDATE; yygotominor.yy378.b = yymsp[0].minor.yy232;}
#line 3104 "parse.c"
        break;
      case 273: /* when_clause ::= */
      case 290: /* key_opt ::= */
#line 1027 "parse.y"
{ yygotominor.yy418 = 0; }
#line 3110 "parse.c"
        break;
      case 274: /* when_clause ::= WHEN expr */
      case 291: /* key_opt ::= KEY expr */
#line 1028 "parse.y"
{ yygotominor.yy418 = yymsp[0].minor.yy418; }
#line 3116 "parse.c"
        break;
      case 275: /* trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI */
#line 1032 "parse.y"
{
/*
  if( yymsp[-2].minor.yy451 ){
    yymsp[-2].minor.yy451->pLast->pNext = yymsp[-1].minor.yy451;
  }else{
    yymsp[-2].minor.yy451 = yymsp[-1].minor.yy451;
  }
*/
  assert( yymsp[-2].minor.yy451!=0 );
  yymsp[-2].minor.yy451->pLast->pNext = yymsp[-1].minor.yy451;
  yymsp[-2].minor.yy451->pLast = yymsp[-1].minor.yy451;
  yygotominor.yy451 = yymsp[-2].minor.yy451;
}
#line 3133 "parse.c"
        break;
      case 276: /* trigger_cmd_list ::= trigger_cmd SEMI */
#line 1045 "parse.y"
{ 
  /* if( yymsp[-1].minor.yy451 ) */
  assert( yymsp[-1].minor.yy451!=0 );
  yymsp[-1].minor.yy451->pLast = yymsp[-1].minor.yy451;
  yygotominor.yy451 = yymsp[-1].minor.yy451;
}
#line 3143 "parse.c"
        break;
      case 277: /* trigger_cmd ::= UPDATE orconf nm SET setlist where_opt */
#line 1056 "parse.y"
{ yygotominor.yy451 = sqlite3TriggerUpdateStep(pParse->db, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy322, yymsp[0].minor.yy418, yymsp[-4].minor.yy328); }
#line 3148 "parse.c"
        break;
      case 278: /* trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP */
#line 1061 "parse.y"
{yygotominor.yy451 = sqlite3TriggerInsertStep(pParse->db, &yymsp[-5].minor.yy0, yymsp[-4].minor.yy232, yymsp[-1].minor.yy322, 0, yymsp[-7].minor.yy328);}
#line 3153 "parse.c"
        break;
      case 279: /* trigger_cmd ::= insert_cmd INTO nm inscollist_opt select */
#line 1064 "parse.y"
{yygotominor.yy451 = sqlite3TriggerInsertStep(pParse->db, &yymsp[-2].minor.yy0, yymsp[-1].minor.yy232, 0, yymsp[0].minor.yy91, yymsp[-4].minor.yy328);}
#line 3158 "parse.c"
        break;
      case 280: /* trigger_cmd ::= DELETE FROM nm where_opt */
#line 1068 "parse.y"
{yygotominor.yy451 = sqlite3TriggerDeleteStep(pParse->db, &yymsp[-1].minor.yy0, yymsp[0].minor.yy418);}
#line 3163 "parse.c"
        break;
      case 281: /* trigger_cmd ::= select */
#line 1071 "parse.y"
{yygotominor.yy451 = sqlite3TriggerSelectStep(pParse->db, yymsp[0].minor.yy91); }
#line 3168 "parse.c"
        break;
      case 282: /* expr ::= RAISE LP IGNORE RP */
#line 1074 "parse.y"
{
  yygotominor.yy418 = sqlite3PExpr(pParse, TK_RAISE, 0, 0, 0); 
  if( yygotominor.yy418 ){
    yygotominor.yy418->iColumn = OE_Ignore;
    sqlite3ExprSpan(yygotominor.yy418, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3179 "parse.c"
        break;
      case 283: /* expr ::= RAISE LP raisetype COMMA nm RP */
#line 1081 "parse.y"
{
  yygotominor.yy418 = sqlite3PExpr(pParse, TK_RAISE, 0, 0, &yymsp[-1].minor.yy0); 
  if( yygotominor.yy418 ) {
    yygotominor.yy418->iColumn = yymsp[-3].minor.yy328;
    sqlite3ExprSpan(yygotominor.yy418, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3190 "parse.c"
        break;
      case 284: /* raisetype ::= ROLLBACK */
#line 1091 "parse.y"
{yygotominor.yy328 = OE_Rollback;}
#line 3195 "parse.c"
        break;
      case 286: /* raisetype ::= FAIL */
#line 1093 "parse.y"
{yygotominor.yy328 = OE_Fail;}
#line 3200 "parse.c"
        break;
      case 287: /* cmd ::= DROP TRIGGER ifexists fullname */
#line 1098 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy439,yymsp[-1].minor.yy328);
}
#line 3207 "parse.c"
        break;
      case 288: /* cmd ::= ATTACH database_kw_opt expr AS expr key_opt */
#line 1105 "parse.y"
{
  sqlite3Attach(pParse, yymsp[-3].minor.yy418, yymsp[-1].minor.yy418, yymsp[0].minor.yy418);
}
#line 3214 "parse.c"
        break;
      case 289: /* cmd ::= DETACH database_kw_opt expr */
#line 1108 "parse.y"
{
  sqlite3Detach(pParse, yymsp[0].minor.yy418);
}
#line 3221 "parse.c"
        break;
      case 294: /* cmd ::= REINDEX */
#line 1123 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3226 "parse.c"
        break;
      case 295: /* cmd ::= REINDEX nm dbnm */
#line 1124 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0);}
#line 3231 "parse.c"
        break;
      case 296: /* cmd ::= ANALYZE */
#line 1129 "parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3236 "parse.c"
        break;
      case 297: /* cmd ::= ANALYZE nm dbnm */
#line 1130 "parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0);}
#line 3241 "parse.c"
        break;
      case 298: /* cmd ::= ALTER TABLE fullname RENAME TO nm */
#line 1135 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy439,&yymsp[0].minor.yy0);
}
#line 3248 "parse.c"
        break;
      case 299: /* cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column */
#line 1138 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy0);
}
#line 3255 "parse.c"
        break;
      case 300: /* add_column_fullname ::= fullname */
#line 1141 "parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy439);
}
#line 3262 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "parse.y"

  assert( TOKEN.z[0] );  /* The tokenizer always gives us a token */
  sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
  pParse->parseError = 1;
#line 3327 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      assert( !yyendofinput );  /* Impossible to shift the $ token */
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
