/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>
#line 51 "parse.y"

#include "sqliteInt.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token eOperator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 241
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 59
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  Expr* yy2;
  struct {int value; int mask;} yy47;
  SrcList* yy67;
  ExprList* yy82;
  struct TrigEvent yy210;
  IdList* yy240;
  struct LimitVal yy244;
  TriggerStep* yy347;
  int yy412;
  struct LikeOp yy438;
  Select* yy459;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 570
#define YYNRULE 300
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
#ifdef __cplusplus
static YYMINORTYPE yyzerominor;
#else
static const YYMINORTYPE yyzerominor;
#endif

/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   284,  871,  118,  569,    2,  169,  406,  406,   62,   62,
 /*    10 */    62,   62,  204,   64,   64,   64,   64,   65,   65,   66,
 /*    20 */    66,   66,   67,  206,  379,  376,  413,  419,   69,   64,
 /*    30 */    64,   64,   64,   65,   65,   66,   66,   66,   67,  206,
 /*    40 */   435,  208,  384,  439,   61,   60,  289,  423,  424,  420,
 /*    50 */   420,   63,   63,   62,   62,   62,   62,  259,   64,   64,
 /*    60 */    64,   64,   65,   65,   66,   66,   66,   67,  206,  284,
 /*    70 */   401,  406,  406,  477,  400,   83,   68,  408,   70,  151,
 /*    80 */    64,   64,   64,   64,   65,   65,   66,   66,   66,   67,
 /*    90 */   206,   68,  450,   70,  151,  413,  419,  435,  260,   59,
 /*   100 */    65,   65,   66,   66,   66,   67,  206,  385,  386,  410,
 /*   110 */   410,  410,  284,   61,   60,  289,  423,  424,  420,  420,
 /*   120 */    63,   63,   62,   62,   62,   62,  307,   64,   64,   64,
 /*   130 */    64,   65,   65,   66,   66,   66,   67,  206,  413,  419,
 /*   140 */    95,   66,   66,   66,   67,  206,  384,  206,  402,   35,
 /*   150 */    57,  174,  384,  519,  398,  462,   61,   60,  289,  423,
 /*   160 */   424,  420,  420,   63,   63,   62,   62,   62,   62,  171,
 /*   170 */    64,   64,   64,   64,   65,   65,   66,   66,   66,   67,
 /*   180 */   206,  284,  437,  313,  165,   68,  109,   70,  151,  439,
 /*   190 */   321,  307,  303,  381,  235,  330,  192,  203,  290,  430,
 /*   200 */   431,  435,  208,  403,  196,  561,  286,  413,  419,  146,
 /*   210 */   147,  385,  386,  402,   42,  172,  157,  385,  386,  477,
 /*   220 */   328,  555,  556,  408,  284,   61,   60,  289,  423,  424,
 /*   230 */   420,  420,   63,   63,   62,   62,   62,   62,  403,   64,
 /*   240 */    64,   64,   64,   65,   65,   66,   66,   66,   67,  206,
 /*   250 */   413,  419,  476,  323,  211,  410,  410,  410,   67,  206,
 /*   260 */   281,  207,  368,  437,  510,  165,  478,  284,   61,   60,
 /*   270 */   289,  423,  424,  420,  420,   63,   63,   62,   62,   62,
 /*   280 */    62,  384,   64,   64,   64,   64,   65,   65,   66,   66,
 /*   290 */    66,   67,  206,  413,  419,   85,  292,  511,  462,  396,
 /*   300 */   509,  479,  169,  225,  406,  253,  521,   21,  506,   19,
 /*   310 */   399,   61,   60,  289,  423,  424,  420,  420,   63,   63,
 /*   320 */    62,   62,   62,   62,  259,   64,   64,   64,   64,   65,
 /*   330 */    65,   66,   66,   66,   67,  206,  466,  468,  307,   78,
 /*   340 */   284,  397,  292,  257,  472,  255,  385,  386,  179,  506,
 /*   350 */   384,  335,  338,  339,   68,  149,   70,  151,    8,  559,
 /*   360 */   402,   36,  340,  559,  217,  544,  413,  419,  512,  406,
 /*   370 */   161,  114,  239,  333,  244,  334,  173,  558,  557,  481,
 /*   380 */   482,  558,   81,  248,   61,   60,  289,  423,  424,  420,
 /*   390 */   420,   63,   63,   62,   62,   62,   62,  291,   64,   64,
 /*   400 */    64,   64,   65,   65,   66,   66,   66,   67,  206,  284,
 /*   410 */   217,  537,  232,  475,  162,  385,  386,  114,  239,  333,
 /*   420 */   244,  334,  173,  179,  307,  226,  335,  338,  339,  248,
 /*   430 */   414,  415,  152,  536,  318,  413,  419,  340,  554,  207,
 /*   440 */   233,  458,  371,  207,  534,  482,  402,   35,  462,  536,
 /*   450 */   156,  417,  418,   61,   60,  289,  423,  424,  420,  420,
 /*   460 */    63,   63,   62,   62,   62,   62,  403,   64,   64,   64,
 /*   470 */    64,   65,   65,   66,   66,   66,   67,  206,  284,  471,
 /*   480 */   416,  511,  492,  363,  265,  264,  307,  237,  321,  360,
 /*   490 */   395,   21,  179,  320,  204,  335,  338,  339,  384,  363,
 /*   500 */   265,  264,  378,    2,  413,  419,  340,  604,  402,   42,
 /*   510 */   204,  511,  518,  493,  148,  520,  312,  430,  431,  517,
 /*   520 */   566,   21,   61,   60,  289,  423,  424,  420,  420,   63,
 /*   530 */    63,   62,   62,   62,   62,  197,   64,   64,   64,   64,
 /*   540 */    65,   65,   66,   66,   66,   67,  206,  284,  307,  210,
 /*   550 */   444,  251,  427,  360,  219,  470,  150,  343,  307,  440,
 /*   560 */   307,  326,  445,  385,  386,  310,  307,  426,  426,  403,
 /*   570 */   402,   28,  287,  413,  419,  446,  234,  483,  259,  207,
 /*   580 */   402,   35,  402,   50,  174,  433,  433,  484,  402,   50,
 /*   590 */   403,   61,   60,  289,  423,  424,  420,  420,   63,   63,
 /*   600 */    62,   62,   62,   62,  308,   64,   64,   64,   64,   65,
 /*   610 */    65,   66,   66,   66,   67,  206,  284,  268,  220,  546,
 /*   620 */     1,   94,  325,   10,  384,  444,  466,  384,  300,  205,
 /*   630 */   310,  329,  426,  426,  301,  221,   56,  445,  310,  286,
 /*   640 */   426,  426,  413,  419,  248,  310,  353,  426,  426,  452,
 /*   650 */   446,  356,  317,  402,    3,  271,  453,  269,  531,  284,
 /*   660 */    61,   60,  289,  423,  424,  420,  420,   63,   63,   62,
 /*   670 */    62,   62,   62,  307,   64,   64,   64,   64,   65,   65,
 /*   680 */    66,   66,   66,   67,  206,  413,  419,  351,  455,  385,
 /*   690 */   386,  259,  385,  386,  383,  402,   29,  570,  379,  376,
 /*   700 */   115,  190,  284,   61,   60,  289,  423,  424,  420,  420,
 /*   710 */    63,   63,   62,   62,   62,   62,  307,   64,   64,   64,
 /*   720 */    64,   65,   65,   66,   66,   66,   67,  206,  413,  419,
 /*   730 */   204,   20,  373,  142,  533,  403,  270,  409,  402,   24,
 /*   740 */   387,  388,  389,  362,  190,  284,   61,   71,  289,  423,
 /*   750 */   424,  420,  420,   63,   63,   62,   62,   62,   62,  361,
 /*   760 */    64,   64,   64,   64,   65,   65,   66,   66,   66,   67,
 /*   770 */   206,  413,  419,  806,  168,  157,   18,    5,  403,  145,
 /*   780 */   436,  364,  375,  527,  350,  527,  487,  488,  284,  194,
 /*   790 */    60,  289,  423,  424,  420,  420,   63,   63,   62,   62,
 /*   800 */    62,   62,  361,   64,   64,   64,   64,   65,   65,   66,
 /*   810 */    66,   66,   67,  206,  413,  419,  384,  529,  175,  176,
 /*   820 */   177,  528,  319,  403,  357,  259,   22,  247,  259,  448,
 /*   830 */   406,  153,  247,  352,  289,  423,  424,  420,  420,   63,
 /*   840 */    63,   62,   62,   62,   62,  181,   64,   64,   64,   64,
 /*   850 */    65,   65,   66,   66,   66,   67,  206,   73,  314,  178,
 /*   860 */     4,  307,  295,  307,  288,  403,  547,  218,  307,  548,
 /*   870 */   307,  247,  311,   73,  314,  307,    4,  247,  461,  403,
 /*   880 */   288,  385,  386,  402,   33,  402,   54,  307,  311,  316,
 /*   890 */   402,   53,  402,   99,  307,  406,  247,  402,   97,  439,
 /*   900 */   307,  498,  307,  466,  307,  316,  296,  459,  456,  402,
 /*   910 */   102,  428,  297,   23,  309,  439,  402,  103,  307,   76,
 /*   920 */    75,  499,  402,  108,  402,  110,  402,   17,   74,  305,
 /*   930 */   306,  298,  331,  408,  490,   76,   75,  469,  307,  370,
 /*   940 */   402,  100,  497,  496,   74,  305,  306,   73,  314,  408,
 /*   950 */     4,  204,  307,  184,  288,  307,  465,  245,  204,  401,
 /*   960 */   402,   34,  311,  400,  299,  410,  410,  410,  411,  412,
 /*   970 */    12,  369,  307,  294,  402,   98,  494,  402,   25,  316,
 /*   980 */   495,  410,  410,  410,  411,  412,   12,  403,  393,  439,
 /*   990 */   421,  159,  240,  500,  402,   55,  222,  223,  224,  105,
 /*  1000 */   259,  501,  307,  241,  187,  307,  259,  246,  307,   76,
 /*  1010 */    75,   77,  201,   79,  276,  513,  252,  457,   74,  305,
 /*  1020 */   306,  277,  307,  408,  402,  111,  254,  402,  112,  307,
 /*  1030 */   402,  113,  464,  199,  170,  536,  256,  259,  347,  198,
 /*  1040 */   307,  272,  200,  258,  402,   26,  307,  367,  307,  263,
 /*  1050 */   307,  402,   37,  307,  355,  410,  410,  410,  411,  412,
 /*  1060 */    12,  358,  402,   38,  359,  502,  307,  178,  402,   27,
 /*  1070 */   402,   39,  402,   40,  266,  402,   41,  307,  274,  267,
 /*  1080 */   250,  307,  178,  307,  155,  366,  273,  264,  402,   43,
 /*  1090 */   553,  285,  307,  342,  307,  178,  204,  275,  278,  402,
 /*  1100 */    44,  279,  307,  402,   45,  402,   30,  565,  307,  457,
 /*  1110 */   307,  144,  432,  307,  402,   31,  402,   46,  307,  227,
 /*  1120 */   372,  532,  307,  178,  402,   47,  307,  540,  407,  170,
 /*  1130 */   402,   48,  402,   49,  315,  402,   32,  541,  434,   92,
 /*  1140 */   402,   11,  451,  504,  402,   51,  454,  539,  402,   52,
 /*  1150 */   551,  507,   92,  242,  493,  503,  505,  160,  337,  550,
 /*  1160 */   382,  390,  391,  392,    7,  304,  228,  404,   85,  324,
 /*  1170 */   322,  229,   84,   80,  209,   58,  230,  167,  449,  119,
 /*  1180 */    86,  327,  332,  293,  231,  486,  405,  490,  122,  480,
 /*  1190 */   485,  243,  215,  236,  489,  491,  463,  238,  214,  467,
 /*  1200 */   514,  508,  282,  515,  516,  283,  344,  182,  348,  522,
 /*  1210 */   183,   89,  117,  346,  185,  130,  186,  216,  535,  524,
 /*  1220 */   188,  191,  354,  140,  542,  365,  131,  132,  133,  261,
 /*  1230 */   549,  525,  136,  134,  562,  302,   93,  139,   96,  563,
 /*  1240 */   564,  567,  107,  213,  101,  380,  104,  394,  605,  606,
 /*  1250 */   163,  164,  422,  425,   72,  166,  429,  438,  141,  441,
 /*  1260 */   154,    6,  442,  443,   14,  447,  158,  460,   82,   13,
 /*  1270 */   120,  180,  121,  473,  474,  212,   87,  123,  336,  249,
 /*  1280 */   124,  116,   88,  125,  341,  241,  345,  143,  523,  526,
 /*  1290 */   126,  349,  262,  189,  170,  127,  128,    9,  538,  129,
 /*  1300 */    90,  530,  193,   15,  543,  545,  195,  135,  137,  138,
 /*  1310 */    16,  552,  106,  560,  202,  377,  872,  280,  568,  374,
 /*  1320 */   872,  872,  872,  872,  872,  872,  872,  872,   91,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    16,  139,  140,  141,  142,   21,   23,   23,   69,   70,
 /*    10 */    71,   72,  110,   74,   75,   76,   77,   78,   79,   80,
 /*    20 */    81,   82,   83,   84,    1,    2,   42,   43,   73,   74,
 /*    30 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*    40 */    78,   79,   23,   58,   60,   61,   62,   63,   64,   65,
 /*    50 */    66,   67,   68,   69,   70,   71,   72,  147,   74,   75,
 /*    60 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*    70 */   107,   88,   88,   88,  111,   22,  217,   92,  219,  220,
 /*    80 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*    90 */    84,  217,  218,  219,  220,   42,   43,   78,  188,   46,
 /*   100 */    78,   79,   80,   81,   82,   83,   84,   88,   89,  124,
 /*   110 */   125,  126,   16,   60,   61,   62,   63,   64,   65,   66,
 /*   120 */    67,   68,   69,   70,   71,   72,  147,   74,   75,   76,
 /*   130 */    77,   78,   79,   80,   81,   82,   83,   84,   42,   43,
 /*   140 */    44,   80,   81,   82,   83,   84,   23,   84,  169,  170,
 /*   150 */    19,   43,   23,  181,   23,  161,   60,   61,   62,   63,
 /*   160 */    64,   65,   66,   67,   68,   69,   70,   71,   72,  155,
 /*   170 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   180 */    84,   16,  161,  162,  163,  217,   21,  219,  220,   58,
 /*   190 */   211,  147,  143,  144,  200,  216,   22,  148,  164,  165,
 /*   200 */   166,   78,   79,  189,  155,  237,   98,   42,   43,   78,
 /*   210 */    79,   88,   89,  169,  170,  201,  202,   88,   89,   88,
 /*   220 */   206,   98,   99,   92,   16,   60,   61,   62,   63,   64,
 /*   230 */    65,   66,   67,   68,   69,   70,   71,   72,  189,   74,
 /*   240 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   250 */    42,   43,  169,  209,  210,  124,  125,  126,   83,   84,
 /*   260 */   158,  227,  213,  161,  162,  163,  169,   16,   60,   61,
 /*   270 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   280 */    72,   23,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   290 */    82,   83,   84,   42,   43,  121,   16,  147,  161,  167,
 /*   300 */   168,  160,   21,  153,   23,   14,  156,  157,  176,   19,
 /*   310 */   169,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   320 */    69,   70,   71,   72,  147,   74,   75,   76,   77,   78,
 /*   330 */    79,   80,   81,   82,   83,   84,  147,  200,  147,  131,
 /*   340 */    16,  168,   16,   52,   20,   54,   88,   89,   90,  176,
 /*   350 */    23,   93,   94,   95,  217,   22,  219,  220,   68,  147,
 /*   360 */   169,  170,  104,  147,   84,  188,   42,   43,  181,   88,
 /*   370 */    90,   91,   92,   93,   94,   95,   96,  165,  166,  185,
 /*   380 */   186,  165,  131,  103,   60,   61,   62,   63,   64,   65,
 /*   390 */    66,   67,   68,   69,   70,   71,   72,  208,   74,   75,
 /*   400 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*   410 */    84,   11,  221,   20,   19,   88,   89,   91,   92,   93,
 /*   420 */    94,   95,   96,   90,  147,  190,   93,   94,   95,  103,
 /*   430 */    42,   43,  155,   49,  186,   42,   43,  104,  226,  227,
 /*   440 */   147,  114,  226,  227,  185,  186,  169,  170,  161,   49,
 /*   450 */   147,   63,   64,   60,   61,   62,   63,   64,   65,   66,
 /*   460 */    67,   68,   69,   70,   71,   72,  189,   74,   75,   76,
 /*   470 */    77,   78,   79,   80,   81,   82,   83,   84,   16,   20,
 /*   480 */    92,  147,   20,   99,  100,  101,  147,  200,  211,  147,
 /*   490 */   156,  157,   90,  216,  110,   93,   94,   95,   23,   99,
 /*   500 */   100,  101,  141,  142,   42,   43,  104,  112,  169,  170,
 /*   510 */   110,  147,  176,  177,  180,  181,  164,  165,  166,  183,
 /*   520 */   156,  157,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   530 */    68,   69,   70,   71,   72,  155,   74,   75,   76,   77,
 /*   540 */    78,   79,   80,   81,   82,   83,   84,   16,  147,  210,
 /*   550 */    12,   20,   20,  147,  212,   80,  155,   16,  147,   20,
 /*   560 */   147,  147,   24,   88,   89,  106,  147,  108,  109,  189,
 /*   570 */   169,  170,  150,   42,   43,   37,  147,   39,  147,  227,
 /*   580 */   169,  170,  169,  170,   43,  124,  125,   49,  169,  170,
 /*   590 */   189,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   600 */    69,   70,   71,   72,  147,   74,   75,   76,   77,   78,
 /*   610 */    79,   80,   81,   82,   83,   84,   16,   14,  212,  188,
 /*   620 */    19,   21,  211,   19,   23,   12,  147,   23,  215,  192,
 /*   630 */   106,  147,  108,  109,  215,  145,  199,   24,  106,   98,
 /*   640 */   108,  109,   42,   43,  103,  106,  224,  108,  109,   27,
 /*   650 */    37,  229,   39,  169,  170,   52,   34,   54,   18,   16,
 /*   660 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   670 */    70,   71,   72,  147,   74,   75,   76,   77,   78,   79,
 /*   680 */    80,   81,   82,   83,   84,   42,   43,  208,   22,   88,
 /*   690 */    89,  147,   88,   89,  147,  169,  170,    0,    1,    2,
 /*   700 */   147,  155,   16,   60,   61,   62,   63,   64,   65,   66,
 /*   710 */    67,   68,   69,   70,   71,   72,  147,   74,   75,   76,
 /*   720 */    77,   78,   79,   80,   81,   82,   83,   84,   42,   43,
 /*   730 */   110,   19,  188,   21,   94,  189,  133,  147,  169,  170,
 /*   740 */     7,    8,    9,  123,  155,   16,   60,   61,   62,   63,
 /*   750 */    64,   65,   66,   67,   68,   69,   70,   71,   72,  213,
 /*   760 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   770 */    84,   42,   43,  133,  201,  202,  230,  191,  189,  113,
 /*   780 */   161,  235,  238,   99,  100,  101,    7,    8,   16,  155,
 /*   790 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   800 */    71,   72,  213,   74,   75,   76,   77,   78,   79,   80,
 /*   810 */    81,   82,   83,   84,   42,   43,   23,   25,   99,  100,
 /*   820 */   101,   29,  147,  189,  235,  147,   19,  147,  147,  147,
 /*   830 */    23,  155,  147,   41,   62,   63,   64,   65,   66,   67,
 /*   840 */    68,   69,   70,   71,   72,  155,   74,   75,   76,   77,
 /*   850 */    78,   79,   80,   81,   82,   83,   84,   16,   17,   22,
 /*   860 */    19,  147,  182,  147,   23,  189,  188,  182,  147,  188,
 /*   870 */   147,  147,   31,   16,   17,  147,   19,  147,  147,  189,
 /*   880 */    23,   88,   89,  169,  170,  169,  170,  147,   31,   48,
 /*   890 */   169,  170,  169,  170,  147,   88,  147,  169,  170,   58,
 /*   900 */   147,   30,  147,  147,  147,   48,  182,  114,  203,  169,
 /*   910 */   170,   20,  182,   22,   16,   58,  169,  170,  147,   78,
 /*   920 */    79,   50,  169,  170,  169,  170,  169,  170,   87,   88,
 /*   930 */    89,  182,   80,   92,   97,   78,   79,   80,  147,   91,
 /*   940 */   169,  170,   91,   92,   87,   88,   89,   16,   17,   92,
 /*   950 */    19,  110,  147,  155,   23,  147,  147,  147,  110,  107,
 /*   960 */   169,  170,   31,  111,  208,  124,  125,  126,  127,  128,
 /*   970 */   129,  123,  147,  102,  169,  170,  147,  169,  170,   48,
 /*   980 */   178,  124,  125,  126,  127,  128,  129,  189,  149,   58,
 /*   990 */    92,    5,   92,  178,  169,  170,   10,   11,   12,   13,
 /*  1000 */   147,  178,  147,  103,  231,  147,  147,  147,  147,   78,
 /*  1010 */    79,  130,   26,  132,   28,  147,  147,   22,   87,   88,
 /*  1020 */    89,   35,  147,   92,  169,  170,  147,  169,  170,  147,
 /*  1030 */   169,  170,   20,   47,   22,   49,  147,  147,  232,   53,
 /*  1040 */   147,  188,   56,  147,  169,  170,  147,  188,  147,  147,
 /*  1050 */   147,  169,  170,  147,  147,  124,  125,  126,  127,  128,
 /*  1060 */   129,  147,  169,  170,  147,   20,  147,   22,  169,  170,
 /*  1070 */   169,  170,  169,  170,  147,  169,  170,  147,  188,  147,
 /*  1080 */    20,  147,   22,  147,   89,   99,  100,  101,  169,  170,
 /*  1090 */   147,  105,  147,   20,  147,   22,  110,  147,  147,  169,
 /*  1100 */   170,  147,  147,  169,  170,  169,  170,  147,  147,  114,
 /*  1110 */   147,  191,  228,  147,  169,  170,  169,  170,  147,  193,
 /*  1120 */   134,   20,  147,   22,  169,  170,  147,   20,  161,   22,
 /*  1130 */   169,  170,  169,  170,  223,  169,  170,   20,  228,   22,
 /*  1140 */   169,  170,  172,  161,  169,  170,  172,  194,  169,  170,
 /*  1150 */    20,  161,   22,  172,  177,  172,  172,    6,  173,  194,
 /*  1160 */   146,  146,  146,  146,   22,  154,  194,  189,  121,  118,
 /*  1170 */   116,  195,  119,  130,  222,  120,  196,  112,  152,  152,
 /*  1180 */    98,  115,   98,   40,  197,  179,  198,   97,   19,  171,
 /*  1190 */   171,  171,   84,  204,  173,  171,  205,  204,  225,  205,
 /*  1200 */   171,  179,  174,  171,  171,  174,   15,  151,   38,  152,
 /*  1210 */   151,  130,   60,  152,  151,   19,  152,  225,  184,  152,
 /*  1220 */   151,  184,  152,  214,  194,   15,  187,  187,  187,  233,
 /*  1230 */   194,  234,  184,  187,   33,  152,  236,  214,  236,  152,
 /*  1240 */   152,  137,  239,  175,  159,    1,  175,   20,  112,  112,
 /*  1250 */   112,  112,   92,  107,   19,   22,   20,   20,   19,   11,
 /*  1260 */    19,  117,   20,   20,  117,   20,  112,  114,   22,   22,
 /*  1270 */    19,   96,   20,   20,   20,   44,   19,   19,   44,   20,
 /*  1280 */    19,   32,   19,   19,   44,  103,   16,   21,   17,   51,
 /*  1290 */    98,   36,  133,   98,   22,   45,   19,    5,    1,  102,
 /*  1300 */    68,   45,  122,   19,    1,   17,  113,  113,  102,  122,
 /*  1310 */    19,  123,   14,   20,  135,    3,  240,  136,    4,   57,
 /*  1320 */   240,  240,  240,  240,  240,  240,  240,  240,   68,
};
#define YY_SHIFT_USE_DFLT (-99)
#define YY_SHIFT_MAX 377
static const short yy_shift_ofst[] = {
 /*     0 */    23,  841,  986,  -16,  841,  931,  931,  258,  123,  384,
 /*    10 */   -98,   96,  931,  931,  931,  931,  931,  -45,  400,   19,
 /*    20 */   129,  -17,  -38,  -38,   53,  165,  208,  251,  324,  393,
 /*    30 */   462,  531,  600,  643,  686,  643,  643,  643,  643,  643,
 /*    40 */   643,  643,  643,  643,  643,  643,  643,  643,  643,  643,
 /*    50 */   643,  643,  643,  729,  772,  772,  857,  931,  931,  931,
 /*    60 */   931,  931,  931,  931,  931,  931,  931,  931,  931,  931,
 /*    70 */   931,  931,  931,  931,  931,  931,  931,  931,  931,  931,
 /*    80 */   931,  931,  931,  931,  931,  931,  931,  931,  931,  931,
 /*    90 */   931,  931,  931,  931,  931,  931,  931,  -61,  -61,    6,
 /*   100 */     6,  280,   22,   61,  541,  640,  129,  129,  175,  -17,
 /*   110 */    63,  -99,  -99,  -99,  131,  326,  538,  538,  697,  281,
 /*   120 */   129,  281,  129,  129,  129,  129,  129,  129,  129,  129,
 /*   130 */   129,  129,  129,  129,  129,  129,  129,  129,  129,  848,
 /*   140 */   620,  -98,  -98,  -98,  -99,  -99,  -15,  -15,  333,  402,
 /*   150 */   459,  601,  532,  539,  613,  327,  793,  604,  475,  733,
 /*   160 */   129,  129,  852,  129,  129,  807,  129,  129,  995,  129,
 /*   170 */   129,  524,  995,  129,  129,  871,  871,  871,  129,  129,
 /*   180 */   129,  524,  129,  129,  524,  129,  792,  684,  129,  129,
 /*   190 */   524,  129,  129,  129,  524,  129,  524,  524,  129,  129,
 /*   200 */   129,  129,  129,  712,  -37,  666,  -17,  461,  461,  881,
 /*   210 */   622,  622,  622,  108,  622,  -17,  622,  -17,  837,  174,
 /*   220 */   174, 1151, 1151, 1151, 1151, 1142,  -98, 1047, 1051, 1053,
 /*   230 */  1054, 1055, 1043, 1065, 1065, 1082, 1066, 1082, 1066, 1084,
 /*   240 */  1084, 1143, 1084, 1090, 1084, 1169, 1108, 1108, 1143, 1084,
 /*   250 */  1084, 1084, 1169, 1191, 1065, 1191, 1065, 1191, 1065, 1065,
 /*   260 */  1170, 1081, 1191, 1065, 1152, 1152, 1196, 1047, 1210, 1210,
 /*   270 */  1210, 1210, 1047, 1152, 1196, 1065, 1201, 1201, 1065, 1065,
 /*   280 */  1104,  -99,  -99,  -99,  388,  603,  719,  291,  395,  898,
 /*   290 */   891, 1012,  900,  779,  851, 1045, 1060, 1073, 1101, 1107,
 /*   300 */  1117, 1130,  290, 1244, 1227, 1136, 1137, 1138, 1139, 1160,
 /*   310 */  1146, 1235, 1236, 1237, 1239, 1248, 1241, 1242, 1233, 1243,
 /*   320 */  1245, 1246, 1144, 1247, 1147, 1246, 1153, 1251, 1252, 1154,
 /*   330 */  1253, 1254, 1249, 1231, 1257, 1234, 1258, 1259, 1261, 1263,
 /*   340 */  1240, 1264, 1175, 1182, 1270, 1271, 1266, 1192, 1255, 1238,
 /*   350 */  1250, 1272, 1256, 1159, 1195, 1277, 1292, 1297, 1197, 1232,
 /*   360 */  1260, 1180, 1284, 1193, 1303, 1288, 1194, 1206, 1187, 1291,
 /*   370 */  1188, 1293, 1298, 1262, 1179, 1181, 1312, 1314,
};
#define YY_REDUCE_USE_DFLT (-142)
#define YY_REDUCE_MAX 283
static const short yy_reduce_ofst[] = {
 /*     0 */  -138,  277,   49,  137,  401,  -21,   44,  334,  212,  546,
 /*    10 */    14,  -32,  191,  339,  411,  413,  419, -126,  589,  216,
 /*    20 */   150,  102,   34,  352, -141, -141, -141, -141, -141, -141,
 /*    30 */  -141, -141, -141, -141, -141, -141, -141, -141, -141, -141,
 /*    40 */  -141, -141, -141, -141, -141, -141, -141, -141, -141, -141,
 /*    50 */  -141, -141, -141, -141, -141, -141,  484,  526,  569,  714,
 /*    60 */   716,  721,  723,  728,  740,  747,  753,  755,  757,  771,
 /*    70 */   791,  805,  808,  825,  855,  858,  861,  875,  882,  893,
 /*    80 */   899,  901,  903,  906,  919,  930,  934,  936,  945,  947,
 /*    90 */   955,  961,  963,  966,  971,  975,  979, -141, -141, -141,
 /*   100 */  -141,  132, -141, -141,  336,  422,  544,  364, -141,   21,
 /*   110 */  -141, -141, -141, -141,  141,  173,  194,  259,  361,   -6,
 /*   120 */   189,  287,  680,  685,  724,  730,  -90,  479,  749,  342,
 /*   130 */   756,  177,  431,  678,  681,  853,  859,  406,  890,  380,
 /*   140 */   634,  676,  690,  798,  437,  573,   83,   97,  -28,  187,
 /*   150 */   235,  293,  235,  235,  248,  303,  414,  429,  457,  490,
 /*   160 */   547,  553,  586,  457,  590,  619,  675,  682,  705,  731,
 /*   170 */   809,  235,  705,  810,  829,  802,  815,  823,  860,  868,
 /*   180 */   869,  235,  879,  889,  235,  896,  773,  806,  902,  907,
 /*   190 */   235,  914,  917,  927,  235,  932,  235,  235,  943,  950,
 /*   200 */   951,  954,  960,  839,  920,  926,  967,  884,  910,  911,
 /*   210 */   970,  974,  981,  977,  983,  982,  984,  990,  985,  953,
 /*   220 */   965, 1014, 1015, 1016, 1017, 1011,  978,  972,  976,  980,
 /*   230 */   987,  988,  952, 1026, 1027,  989,  991,  993,  994, 1018,
 /*   240 */  1019, 1006, 1020, 1021, 1024, 1028,  973,  992, 1022, 1029,
 /*   250 */  1032, 1033, 1031, 1056, 1057, 1059, 1061, 1063, 1064, 1067,
 /*   260 */   996,  997, 1069, 1070, 1034, 1037, 1009, 1030, 1039, 1040,
 /*   270 */  1041, 1046, 1036, 1048, 1023, 1083, 1000, 1002, 1087, 1088,
 /*   280 */  1003, 1085, 1068, 1071,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   575,  801,  870,  691,  870,  801,  870,  870,  828,  870,
 /*    10 */   695,  857,  799,  870,  870,  870,  870,  773,  870,  828,
 /*    20 */   870,  607,  828,  828,  724,  870,  870,  870,  870,  870,
 /*    30 */   870,  870,  870,  725,  870,  803,  798,  794,  796,  795,
 /*    40 */   802,  726,  715,  722,  729,  707,  841,  731,  732,  738,
 /*    50 */   739,  858,  856,  761,  760,  779,  870,  870,  870,  870,
 /*    60 */   870,  870,  870,  870,  870,  870,  870,  870,  870,  870,
 /*    70 */   870,  870,  870,  870,  870,  870,  870,  870,  870,  870,
 /*    80 */   870,  870,  870,  870,  870,  870,  870,  870,  870,  870,
 /*    90 */   870,  870,  870,  870,  870,  870,  870,  763,  785,  762,
 /*   100 */   772,  600,  764,  765,  660,  595,  870,  870,  766,  870,
 /*   110 */   767,  780,  781,  782,  870,  870,  870,  870,  575,  691,
 /*   120 */   870,  691,  870,  870,  870,  870,  870,  870,  870,  870,
 /*   130 */   870,  870,  870,  870,  870,  870,  870,  870,  870,  870,
 /*   140 */   870,  870,  870,  870,  685,  695,  870,  870,  651,  870,
 /*   150 */   870,  870,  870,  870,  870,  870,  870,  870,  870,  583,
 /*   160 */   581,  870,  683,  870,  870,  609,  870,  870,  693,  870,
 /*   170 */   870,  698,  699,  870,  870,  870,  870,  870,  870,  870,
 /*   180 */   870,  597,  870,  870,  672,  870,  834,  870,  870,  870,
 /*   190 */   848,  870,  870,  870,  846,  870,  674,  734,  814,  870,
 /*   200 */   861,  863,  870,  870,  683,  692,  870,  870,  870,  797,
 /*   210 */   718,  718,  718,  630,  718,  870,  718,  870,  633,  728,
 /*   220 */   728,  580,  580,  580,  580,  650,  870,  728,  719,  721,
 /*   230 */   711,  723,  870,  700,  700,  708,  710,  708,  710,  662,
 /*   240 */   662,  647,  662,  633,  662,  807,  811,  811,  647,  662,
 /*   250 */   662,  662,  807,  592,  700,  592,  700,  592,  700,  700,
 /*   260 */   838,  840,  592,  700,  664,  664,  740,  728,  671,  671,
 /*   270 */   671,  671,  728,  664,  740,  700,  860,  860,  700,  700,
 /*   280 */   868,  617,  635,  635,  870,  870,  870,  870,  747,  870,
 /*   290 */   870,  870,  870,  870,  870,  870,  870,  870,  870,  870,
 /*   300 */   870,  870,  821,  870,  870,  752,  748,  870,  749,  870,
 /*   310 */   677,  870,  870,  870,  870,  870,  870,  870,  870,  870,
 /*   320 */   870,  800,  870,  712,  870,  720,  870,  870,  870,  870,
 /*   330 */   870,  870,  870,  870,  870,  870,  870,  870,  870,  870,
 /*   340 */   870,  870,  870,  870,  870,  870,  870,  870,  870,  870,
 /*   350 */   836,  837,  870,  870,  870,  870,  870,  870,  870,  870,
 /*   360 */   870,  870,  870,  870,  870,  870,  870,  870,  870,  870,
 /*   370 */   870,  870,  870,  867,  870,  870,  576,  870,  571,  573,
 /*   380 */   574,  578,  579,  582,  604,  605,  606,  584,  585,  586,
 /*   390 */   587,  588,  589,  590,  596,  598,  616,  618,  602,  620,
 /*   400 */   681,  682,  744,  675,  676,  680,  603,  755,  746,  750,
 /*   410 */   751,  753,  754,  768,  769,  771,  777,  784,  787,  770,
 /*   420 */   775,  776,  778,  783,  786,  678,  679,  790,  610,  611,
 /*   430 */   614,  615,  824,  826,  825,  827,  613,  612,  756,  759,
 /*   440 */   792,  793,  849,  850,  851,  852,  853,  788,  701,  791,
 /*   450 */   774,  713,  716,  717,  714,  684,  694,  703,  704,  705,
 /*   460 */   706,  689,  690,  696,  709,  742,  743,  697,  686,  687,
 /*   470 */   688,  789,  745,  757,  758,  621,  622,  752,  623,  624,
 /*   480 */   625,  663,  666,  667,  668,  626,  645,  648,  649,  627,
 /*   490 */   634,  628,  629,  636,  637,  638,  641,  642,  643,  644,
 /*   500 */   639,  640,  808,  809,  812,  810,  631,  632,  646,  619,
 /*   510 */   608,  601,  652,  655,  656,  657,  658,  659,  661,  653,
 /*   520 */   654,  599,  591,  593,  702,  830,  839,  835,  831,  832,
 /*   530 */   833,  594,  804,  805,  665,  736,  737,  829,  842,  844,
 /*   540 */   741,  845,  847,  843,  669,  670,  673,  813,  854,  727,
 /*   550 */   730,  733,  735,  815,  816,  817,  818,  819,  822,  823,
 /*   560 */   820,  855,  859,  862,  864,  865,  866,  869,  577,  572,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      QUERY => ID */
   23,  /*       PLAN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   23,  /*   DEFERRED => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*         IF => ID */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*    ANALYZE => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*       CAST => ID */
   23,  /*   CONFLICT => ID */
   23,  /*   DATABASE => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*     IGNORE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*    LIKE_KW => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
   23,  /*    VIRTUAL => ID */
   23,  /*    REINDEX => ID */
   23,  /*     RENAME => ID */
   23,  /*   CTIME_KW => ID */
    0,  /*        ANY => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*      ALTER => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "EXPLAIN",       "QUERY",       
  "PLAN",          "BEGIN",         "TRANSACTION",   "DEFERRED",    
  "IMMEDIATE",     "EXCLUSIVE",     "COMMIT",        "END",         
  "ROLLBACK",      "CREATE",        "TABLE",         "IF",          
  "NOT",           "EXISTS",        "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ANALYZE",       "ASC",         
  "ATTACH",        "BEFORE",        "CASCADE",       "CAST",        
  "CONFLICT",      "DATABASE",      "DESC",          "DETACH",      
  "EACH",          "FAIL",          "FOR",           "IGNORE",      
  "INITIALLY",     "INSTEAD",       "LIKE_KW",       "MATCH",       
  "KEY",           "OF",            "OFFSET",        "PRAGMA",      
  "RAISE",         "REPLACE",       "RESTRICT",      "ROW",         
  "TRIGGER",       "VACUUM",        "VIEW",          "VIRTUAL",     
  "REINDEX",       "RENAME",        "CTIME_KW",      "ANY",         
  "OR",            "AND",           "IS",            "BETWEEN",     
  "IN",            "ISNULL",        "NOTNULL",       "NE",          
  "EQ",            "GT",            "LE",            "LT",          
  "GE",            "ESCAPE",        "BITAND",        "BITOR",       
  "LSHIFT",        "RSHIFT",        "PLUS",          "MINUS",       
  "STAR",          "SLASH",         "REM",           "CONCAT",      
  "COLLATE",       "UMINUS",        "UPLUS",         "BITNOT",      
  "STRING",        "JOIN_KW",       "CONSTRAINT",    "DEFAULT",     
  "NULL",          "PRIMARY",       "UNIQUE",        "CHECK",       
  "REFERENCES",    "AUTOINCR",      "ON",            "DELETE",      
  "UPDATE",        "INSERT",        "SET",           "DEFERRABLE",  
  "FOREIGN",       "DROP",          "UNION",         "ALL",         
  "EXCEPT",        "INTERSECT",     "SELECT",        "DISTINCT",    
  "DOT",           "FROM",          "JOIN",          "USING",       
  "ORDER",         "BY",            "GROUP",         "HAVING",      
  "LIMIT",         "WHERE",         "INTO",          "VALUES",      
  "INTEGER",       "FLOAT",         "BLOB",          "REGISTER",    
  "VARIABLE",      "CASE",          "WHEN",          "THEN",        
  "ELSE",          "INDEX",         "ALTER",         "TO",          
  "ADD",           "COLUMNKW",      "error",         "input",       
  "cmdlist",       "ecmd",          "explain",       "cmdx",        
  "cmd",           "transtype",     "trans_opt",     "nm",          
  "create_table",  "create_table_args",  "temp",          "ifnotexists", 
  "dbnm",          "columnlist",    "conslist_opt",  "select",      
  "column",        "columnid",      "type",          "carglist",    
  "id",            "ids",           "typetoken",     "typename",    
  "signed",        "plus_num",      "minus_num",     "carg",        
  "ccons",         "term",          "expr",          "onconf",      
  "sortorder",     "autoinc",       "idxlist_opt",   "refargs",     
  "defer_subclause",  "refarg",        "refact",        "init_deferred_pred_opt",
  "conslist",      "tcons",         "idxlist",       "defer_subclause_opt",
  "orconf",        "resolvetype",   "raisetype",     "ifexists",    
  "fullname",      "oneselect",     "multiselect_op",  "distinct",    
  "selcollist",    "from",          "where_opt",     "groupby_opt", 
  "having_opt",    "orderby_opt",   "limit_opt",     "sclp",        
  "as",            "seltablist",    "stl_prefix",    "joinop",      
  "on_opt",        "using_opt",     "seltablist_paren",  "joinop2",     
  "inscollist",    "sortlist",      "sortitem",      "nexprlist",   
  "setlist",       "insert_cmd",    "inscollist_opt",  "itemlist",    
  "exprlist",      "likeop",        "escape",        "between_op",  
  "in_op",         "case_operand",  "case_exprlist",  "case_else",   
  "uniqueflag",    "collate",       "nmnum",         "plus_opt",    
  "number",        "trigger_decl",  "trigger_cmd_list",  "trigger_time",
  "trigger_event",  "foreach_clause",  "when_clause",   "trigger_cmd", 
  "database_kw_opt",  "key_opt",       "add_column_fullname",  "kwcolumn_opt",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "ecmd ::= SEMI",
 /*   4 */ "ecmd ::= explain cmdx SEMI",
 /*   5 */ "explain ::=",
 /*   6 */ "explain ::= EXPLAIN",
 /*   7 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   8 */ "cmdx ::= cmd",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "cmd ::= create_table create_table_args",
 /*  21 */ "create_table ::= CREATE temp TABLE ifnotexists nm dbnm",
 /*  22 */ "ifnotexists ::=",
 /*  23 */ "ifnotexists ::= IF NOT EXISTS",
 /*  24 */ "temp ::= TEMP",
 /*  25 */ "temp ::=",
 /*  26 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  27 */ "create_table_args ::= AS select",
 /*  28 */ "columnlist ::= columnlist COMMA column",
 /*  29 */ "columnlist ::= column",
 /*  30 */ "column ::= columnid type carglist",
 /*  31 */ "columnid ::= nm",
 /*  32 */ "id ::= ID",
 /*  33 */ "ids ::= ID|STRING",
 /*  34 */ "nm ::= ID",
 /*  35 */ "nm ::= STRING",
 /*  36 */ "nm ::= JOIN_KW",
 /*  37 */ "type ::=",
 /*  38 */ "type ::= typetoken",
 /*  39 */ "typetoken ::= typename",
 /*  40 */ "typetoken ::= typename LP signed RP",
 /*  41 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  42 */ "typename ::= ids",
 /*  43 */ "typename ::= typename ids",
 /*  44 */ "signed ::= plus_num",
 /*  45 */ "signed ::= minus_num",
 /*  46 */ "carglist ::= carglist carg",
 /*  47 */ "carglist ::=",
 /*  48 */ "carg ::= CONSTRAINT nm ccons",
 /*  49 */ "carg ::= ccons",
 /*  50 */ "ccons ::= DEFAULT term",
 /*  51 */ "ccons ::= DEFAULT LP expr RP",
 /*  52 */ "ccons ::= DEFAULT PLUS term",
 /*  53 */ "ccons ::= DEFAULT MINUS term",
 /*  54 */ "ccons ::= DEFAULT id",
 /*  55 */ "ccons ::= NULL onconf",
 /*  56 */ "ccons ::= NOT NULL onconf",
 /*  57 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  58 */ "ccons ::= UNIQUE onconf",
 /*  59 */ "ccons ::= CHECK LP expr RP",
 /*  60 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  61 */ "ccons ::= defer_subclause",
 /*  62 */ "ccons ::= COLLATE ids",
 /*  63 */ "autoinc ::=",
 /*  64 */ "autoinc ::= AUTOINCR",
 /*  65 */ "refargs ::=",
 /*  66 */ "refargs ::= refargs refarg",
 /*  67 */ "refarg ::= MATCH nm",
 /*  68 */ "refarg ::= ON DELETE refact",
 /*  69 */ "refarg ::= ON UPDATE refact",
 /*  70 */ "refarg ::= ON INSERT refact",
 /*  71 */ "refact ::= SET NULL",
 /*  72 */ "refact ::= SET DEFAULT",
 /*  73 */ "refact ::= CASCADE",
 /*  74 */ "refact ::= RESTRICT",
 /*  75 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  76 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  77 */ "init_deferred_pred_opt ::=",
 /*  78 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  79 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  80 */ "conslist_opt ::=",
 /*  81 */ "conslist_opt ::= COMMA conslist",
 /*  82 */ "conslist ::= conslist COMMA tcons",
 /*  83 */ "conslist ::= conslist tcons",
 /*  84 */ "conslist ::= tcons",
 /*  85 */ "tcons ::= CONSTRAINT nm",
 /*  86 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  87 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  88 */ "tcons ::= CHECK LP expr RP onconf",
 /*  89 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  90 */ "defer_subclause_opt ::=",
 /*  91 */ "defer_subclause_opt ::= defer_subclause",
 /*  92 */ "onconf ::=",
 /*  93 */ "onconf ::= ON CONFLICT resolvetype",
 /*  94 */ "orconf ::=",
 /*  95 */ "orconf ::= OR resolvetype",
 /*  96 */ "resolvetype ::= raisetype",
 /*  97 */ "resolvetype ::= IGNORE",
 /*  98 */ "resolvetype ::= REPLACE",
 /*  99 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 100 */ "ifexists ::= IF EXISTS",
 /* 101 */ "ifexists ::=",
 /* 102 */ "cmd ::= CREATE temp VIEW ifnotexists nm dbnm AS select",
 /* 103 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 104 */ "cmd ::= select",
 /* 105 */ "select ::= oneselect",
 /* 106 */ "select ::= select multiselect_op oneselect",
 /* 107 */ "multiselect_op ::= UNION",
 /* 108 */ "multiselect_op ::= UNION ALL",
 /* 109 */ "multiselect_op ::= EXCEPT|INTERSECT",
 /* 110 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 111 */ "distinct ::= DISTINCT",
 /* 112 */ "distinct ::= ALL",
 /* 113 */ "distinct ::=",
 /* 114 */ "sclp ::= selcollist COMMA",
 /* 115 */ "sclp ::=",
 /* 116 */ "selcollist ::= sclp expr as",
 /* 117 */ "selcollist ::= sclp STAR",
 /* 118 */ "selcollist ::= sclp nm DOT STAR",
 /* 119 */ "as ::= AS nm",
 /* 120 */ "as ::= ids",
 /* 121 */ "as ::=",
 /* 122 */ "from ::=",
 /* 123 */ "from ::= FROM seltablist",
 /* 124 */ "stl_prefix ::= seltablist joinop",
 /* 125 */ "stl_prefix ::=",
 /* 126 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 127 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 128 */ "seltablist_paren ::= select",
 /* 129 */ "seltablist_paren ::= seltablist",
 /* 130 */ "dbnm ::=",
 /* 131 */ "dbnm ::= DOT nm",
 /* 132 */ "fullname ::= nm dbnm",
 /* 133 */ "joinop ::= COMMA|JOIN",
 /* 134 */ "joinop ::= JOIN_KW JOIN",
 /* 135 */ "joinop ::= JOIN_KW nm JOIN",
 /* 136 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 137 */ "on_opt ::= ON expr",
 /* 138 */ "on_opt ::=",
 /* 139 */ "using_opt ::= USING LP inscollist RP",
 /* 140 */ "using_opt ::=",
 /* 141 */ "orderby_opt ::=",
 /* 142 */ "orderby_opt ::= ORDER BY sortlist",
 /* 143 */ "sortlist ::= sortlist COMMA sortitem sortorder",
 /* 144 */ "sortlist ::= sortitem sortorder",
 /* 145 */ "sortitem ::= expr",
 /* 146 */ "sortorder ::= ASC",
 /* 147 */ "sortorder ::= DESC",
 /* 148 */ "sortorder ::=",
 /* 149 */ "groupby_opt ::=",
 /* 150 */ "groupby_opt ::= GROUP BY nexprlist",
 /* 151 */ "having_opt ::=",
 /* 152 */ "having_opt ::= HAVING expr",
 /* 153 */ "limit_opt ::=",
 /* 154 */ "limit_opt ::= LIMIT expr",
 /* 155 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 156 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 157 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 158 */ "where_opt ::=",
 /* 159 */ "where_opt ::= WHERE expr",
 /* 160 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 161 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 162 */ "setlist ::= nm EQ expr",
 /* 163 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 164 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 165 */ "cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES",
 /* 166 */ "insert_cmd ::= INSERT orconf",
 /* 167 */ "insert_cmd ::= REPLACE",
 /* 168 */ "itemlist ::= itemlist COMMA expr",
 /* 169 */ "itemlist ::= expr",
 /* 170 */ "inscollist_opt ::=",
 /* 171 */ "inscollist_opt ::= LP inscollist RP",
 /* 172 */ "inscollist ::= inscollist COMMA nm",
 /* 173 */ "inscollist ::= nm",
 /* 174 */ "expr ::= term",
 /* 175 */ "expr ::= LP expr RP",
 /* 176 */ "term ::= NULL",
 /* 177 */ "expr ::= ID",
 /* 178 */ "expr ::= JOIN_KW",
 /* 179 */ "expr ::= nm DOT nm",
 /* 180 */ "expr ::= nm DOT nm DOT nm",
 /* 181 */ "term ::= INTEGER|FLOAT|BLOB",
 /* 182 */ "term ::= STRING",
 /* 183 */ "expr ::= REGISTER",
 /* 184 */ "expr ::= VARIABLE",
 /* 185 */ "expr ::= expr COLLATE ids",
 /* 186 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 187 */ "expr ::= ID LP distinct exprlist RP",
 /* 188 */ "expr ::= ID LP STAR RP",
 /* 189 */ "term ::= CTIME_KW",
 /* 190 */ "expr ::= expr AND expr",
 /* 191 */ "expr ::= expr OR expr",
 /* 192 */ "expr ::= expr LT|GT|GE|LE expr",
 /* 193 */ "expr ::= expr EQ|NE expr",
 /* 194 */ "expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 195 */ "expr ::= expr PLUS|MINUS expr",
 /* 196 */ "expr ::= expr STAR|SLASH|REM expr",
 /* 197 */ "expr ::= expr CONCAT expr",
 /* 198 */ "likeop ::= LIKE_KW",
 /* 199 */ "likeop ::= NOT LIKE_KW",
 /* 200 */ "likeop ::= MATCH",
 /* 201 */ "likeop ::= NOT MATCH",
 /* 202 */ "escape ::= ESCAPE expr",
 /* 203 */ "escape ::=",
 /* 204 */ "expr ::= expr likeop expr escape",
 /* 205 */ "expr ::= expr ISNULL|NOTNULL",
 /* 206 */ "expr ::= expr IS NULL",
 /* 207 */ "expr ::= expr NOT NULL",
 /* 208 */ "expr ::= expr IS NOT NULL",
 /* 209 */ "expr ::= NOT expr",
 /* 210 */ "expr ::= BITNOT expr",
 /* 211 */ "expr ::= MINUS expr",
 /* 212 */ "expr ::= PLUS expr",
 /* 213 */ "between_op ::= BETWEEN",
 /* 214 */ "between_op ::= NOT BETWEEN",
 /* 215 */ "expr ::= expr between_op expr AND expr",
 /* 216 */ "in_op ::= IN",
 /* 217 */ "in_op ::= NOT IN",
 /* 218 */ "expr ::= expr in_op LP exprlist RP",
 /* 219 */ "expr ::= LP select RP",
 /* 220 */ "expr ::= expr in_op LP select RP",
 /* 221 */ "expr ::= expr in_op nm dbnm",
 /* 222 */ "expr ::= EXISTS LP select RP",
 /* 223 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 224 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 225 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 226 */ "case_else ::= ELSE expr",
 /* 227 */ "case_else ::=",
 /* 228 */ "case_operand ::= expr",
 /* 229 */ "case_operand ::=",
 /* 230 */ "exprlist ::= nexprlist",
 /* 231 */ "exprlist ::=",
 /* 232 */ "nexprlist ::= nexprlist COMMA expr",
 /* 233 */ "nexprlist ::= expr",
 /* 234 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP",
 /* 235 */ "uniqueflag ::= UNIQUE",
 /* 236 */ "uniqueflag ::=",
 /* 237 */ "idxlist_opt ::=",
 /* 238 */ "idxlist_opt ::= LP idxlist RP",
 /* 239 */ "idxlist ::= idxlist COMMA nm collate sortorder",
 /* 240 */ "idxlist ::= nm collate sortorder",
 /* 241 */ "collate ::=",
 /* 242 */ "collate ::= COLLATE ids",
 /* 243 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 244 */ "cmd ::= VACUUM",
 /* 245 */ "cmd ::= VACUUM nm",
 /* 246 */ "cmd ::= PRAGMA nm dbnm EQ nmnum",
 /* 247 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 248 */ "cmd ::= PRAGMA nm dbnm EQ DELETE",
 /* 249 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 250 */ "cmd ::= PRAGMA nm dbnm LP nmnum RP",
 /* 251 */ "cmd ::= PRAGMA nm dbnm",
 /* 252 */ "nmnum ::= plus_num",
 /* 253 */ "nmnum ::= nm",
 /* 254 */ "plus_num ::= plus_opt number",
 /* 255 */ "minus_num ::= MINUS number",
 /* 256 */ "number ::= INTEGER|FLOAT",
 /* 257 */ "plus_opt ::= PLUS",
 /* 258 */ "plus_opt ::=",
 /* 259 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 260 */ "trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 261 */ "trigger_time ::= BEFORE",
 /* 262 */ "trigger_time ::= AFTER",
 /* 263 */ "trigger_time ::= INSTEAD OF",
 /* 264 */ "trigger_time ::=",
 /* 265 */ "trigger_event ::= DELETE|INSERT",
 /* 266 */ "trigger_event ::= UPDATE",
 /* 267 */ "trigger_event ::= UPDATE OF inscollist",
 /* 268 */ "foreach_clause ::=",
 /* 269 */ "foreach_clause ::= FOR EACH ROW",
 /* 270 */ "when_clause ::=",
 /* 271 */ "when_clause ::= WHEN expr",
 /* 272 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 273 */ "trigger_cmd_list ::= trigger_cmd SEMI",
 /* 274 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 275 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 276 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 277 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 278 */ "trigger_cmd ::= select",
 /* 279 */ "expr ::= RAISE LP IGNORE RP",
 /* 280 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 281 */ "raisetype ::= ROLLBACK",
 /* 282 */ "raisetype ::= ABORT",
 /* 283 */ "raisetype ::= FAIL",
 /* 284 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 285 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 286 */ "cmd ::= DETACH database_kw_opt expr",
 /* 287 */ "key_opt ::=",
 /* 288 */ "key_opt ::= KEY expr",
 /* 289 */ "database_kw_opt ::= DATABASE",
 /* 290 */ "database_kw_opt ::=",
 /* 291 */ "cmd ::= REINDEX",
 /* 292 */ "cmd ::= REINDEX nm dbnm",
 /* 293 */ "cmd ::= ANALYZE",
 /* 294 */ "cmd ::= ANALYZE nm dbnm",
 /* 295 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 296 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 297 */ "add_column_fullname ::= fullname",
 /* 298 */ "kwcolumn_opt ::=",
 /* 299 */ "kwcolumn_opt ::= COLUMNKW",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  sqlite3ParserARG_FETCH;
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 155: /* select */
    case 189: /* oneselect */
    case 206: /* seltablist_paren */
{
#line 369 "parse.y"
sqlite3SelectDelete(pParse->db, (yypminor->yy459));
#line 1270 "parse.c"
}
      break;
    case 169: /* term */
    case 170: /* expr */
    case 194: /* where_opt */
    case 196: /* having_opt */
    case 204: /* on_opt */
    case 210: /* sortitem */
    case 218: /* escape */
    case 221: /* case_operand */
    case 223: /* case_else */
    case 234: /* when_clause */
    case 237: /* key_opt */
{
#line 629 "parse.y"
sqlite3ExprDelete(pParse->db, (yypminor->yy2));
#line 1287 "parse.c"
}
      break;
    case 174: /* idxlist_opt */
    case 182: /* idxlist */
    case 192: /* selcollist */
    case 195: /* groupby_opt */
    case 197: /* orderby_opt */
    case 199: /* sclp */
    case 209: /* sortlist */
    case 211: /* nexprlist */
    case 212: /* setlist */
    case 215: /* itemlist */
    case 216: /* exprlist */
    case 222: /* case_exprlist */
{
#line 887 "parse.y"
sqlite3ExprListDelete(pParse->db, (yypminor->yy82));
#line 1305 "parse.c"
}
      break;
    case 188: /* fullname */
    case 193: /* from */
    case 201: /* seltablist */
    case 202: /* stl_prefix */
{
#line 486 "parse.y"
sqlite3SrcListDelete(pParse->db, (yypminor->yy67));
#line 1315 "parse.c"
}
      break;
    case 205: /* using_opt */
    case 208: /* inscollist */
    case 214: /* inscollist_opt */
{
#line 503 "parse.y"
sqlite3IdListDelete(pParse->db, (yypminor->yy240));
#line 1324 "parse.c"
}
      break;
    case 230: /* trigger_cmd_list */
    case 235: /* trigger_cmd */
{
#line 991 "parse.y"
sqlite3DeleteTriggerStep(pParse->db, (yypminor->yy347));
#line 1332 "parse.c"
}
      break;
    case 232: /* trigger_event */
{
#line 977 "parse.y"
sqlite3IdListDelete(pParse->db, (yypminor->yy210).b);
#line 1339 "parse.c"
}
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int sqlite3ParserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      int iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_MAX ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_MAX );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_SZ_ACTTAB );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   sqlite3ParserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
#line 39 "parse.y"

  sqlite3ErrorMsg(pParse, "parser stack overflow");
  pParse->parseError = 1;
#line 1517 "parse.c"
   sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 139, 1 },
  { 140, 2 },
  { 140, 1 },
  { 141, 1 },
  { 141, 3 },
  { 142, 0 },
  { 142, 1 },
  { 142, 3 },
  { 143, 1 },
  { 144, 3 },
  { 146, 0 },
  { 146, 1 },
  { 146, 2 },
  { 145, 0 },
  { 145, 1 },
  { 145, 1 },
  { 145, 1 },
  { 144, 2 },
  { 144, 2 },
  { 144, 2 },
  { 144, 2 },
  { 148, 6 },
  { 151, 0 },
  { 151, 3 },
  { 150, 1 },
  { 150, 0 },
  { 149, 4 },
  { 149, 2 },
  { 153, 3 },
  { 153, 1 },
  { 156, 3 },
  { 157, 1 },
  { 160, 1 },
  { 161, 1 },
  { 147, 1 },
  { 147, 1 },
  { 147, 1 },
  { 158, 0 },
  { 158, 1 },
  { 162, 1 },
  { 162, 4 },
  { 162, 6 },
  { 163, 1 },
  { 163, 2 },
  { 164, 1 },
  { 164, 1 },
  { 159, 2 },
  { 159, 0 },
  { 167, 3 },
  { 167, 1 },
  { 168, 2 },
  { 168, 4 },
  { 168, 3 },
  { 168, 3 },
  { 168, 2 },
  { 168, 2 },
  { 168, 3 },
  { 168, 5 },
  { 168, 2 },
  { 168, 4 },
  { 168, 4 },
  { 168, 1 },
  { 168, 2 },
  { 173, 0 },
  { 173, 1 },
  { 175, 0 },
  { 175, 2 },
  { 177, 2 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 178, 2 },
  { 178, 2 },
  { 178, 1 },
  { 178, 1 },
  { 176, 3 },
  { 176, 2 },
  { 179, 0 },
  { 179, 2 },
  { 179, 2 },
  { 154, 0 },
  { 154, 2 },
  { 180, 3 },
  { 180, 2 },
  { 180, 1 },
  { 181, 2 },
  { 181, 7 },
  { 181, 5 },
  { 181, 5 },
  { 181, 10 },
  { 183, 0 },
  { 183, 1 },
  { 171, 0 },
  { 171, 3 },
  { 184, 0 },
  { 184, 2 },
  { 185, 1 },
  { 185, 1 },
  { 185, 1 },
  { 144, 4 },
  { 187, 2 },
  { 187, 0 },
  { 144, 8 },
  { 144, 4 },
  { 144, 1 },
  { 155, 1 },
  { 155, 3 },
  { 190, 1 },
  { 190, 2 },
  { 190, 1 },
  { 189, 9 },
  { 191, 1 },
  { 191, 1 },
  { 191, 0 },
  { 199, 2 },
  { 199, 0 },
  { 192, 3 },
  { 192, 2 },
  { 192, 4 },
  { 200, 2 },
  { 200, 1 },
  { 200, 0 },
  { 193, 0 },
  { 193, 2 },
  { 202, 2 },
  { 202, 0 },
  { 201, 6 },
  { 201, 7 },
  { 206, 1 },
  { 206, 1 },
  { 152, 0 },
  { 152, 2 },
  { 188, 2 },
  { 203, 1 },
  { 203, 2 },
  { 203, 3 },
  { 203, 4 },
  { 204, 2 },
  { 204, 0 },
  { 205, 4 },
  { 205, 0 },
  { 197, 0 },
  { 197, 3 },
  { 209, 4 },
  { 209, 2 },
  { 210, 1 },
  { 172, 1 },
  { 172, 1 },
  { 172, 0 },
  { 195, 0 },
  { 195, 3 },
  { 196, 0 },
  { 196, 2 },
  { 198, 0 },
  { 198, 2 },
  { 198, 4 },
  { 198, 4 },
  { 144, 4 },
  { 194, 0 },
  { 194, 2 },
  { 144, 6 },
  { 212, 5 },
  { 212, 3 },
  { 144, 8 },
  { 144, 5 },
  { 144, 6 },
  { 213, 2 },
  { 213, 1 },
  { 215, 3 },
  { 215, 1 },
  { 214, 0 },
  { 214, 3 },
  { 208, 3 },
  { 208, 1 },
  { 170, 1 },
  { 170, 3 },
  { 169, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 3 },
  { 170, 5 },
  { 169, 1 },
  { 169, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 3 },
  { 170, 6 },
  { 170, 5 },
  { 170, 4 },
  { 169, 1 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 217, 1 },
  { 217, 2 },
  { 217, 1 },
  { 217, 2 },
  { 218, 2 },
  { 218, 0 },
  { 170, 4 },
  { 170, 2 },
  { 170, 3 },
  { 170, 3 },
  { 170, 4 },
  { 170, 2 },
  { 170, 2 },
  { 170, 2 },
  { 170, 2 },
  { 219, 1 },
  { 219, 2 },
  { 170, 5 },
  { 220, 1 },
  { 220, 2 },
  { 170, 5 },
  { 170, 3 },
  { 170, 5 },
  { 170, 4 },
  { 170, 4 },
  { 170, 5 },
  { 222, 5 },
  { 222, 4 },
  { 223, 2 },
  { 223, 0 },
  { 221, 1 },
  { 221, 0 },
  { 216, 1 },
  { 216, 0 },
  { 211, 3 },
  { 211, 1 },
  { 144, 11 },
  { 224, 1 },
  { 224, 0 },
  { 174, 0 },
  { 174, 3 },
  { 182, 5 },
  { 182, 3 },
  { 225, 0 },
  { 225, 2 },
  { 144, 4 },
  { 144, 1 },
  { 144, 2 },
  { 144, 5 },
  { 144, 5 },
  { 144, 5 },
  { 144, 5 },
  { 144, 6 },
  { 144, 3 },
  { 226, 1 },
  { 226, 1 },
  { 165, 2 },
  { 166, 2 },
  { 228, 1 },
  { 227, 1 },
  { 227, 0 },
  { 144, 5 },
  { 229, 11 },
  { 231, 1 },
  { 231, 1 },
  { 231, 2 },
  { 231, 0 },
  { 232, 1 },
  { 232, 1 },
  { 232, 3 },
  { 233, 0 },
  { 233, 3 },
  { 234, 0 },
  { 234, 2 },
  { 230, 3 },
  { 230, 2 },
  { 235, 6 },
  { 235, 8 },
  { 235, 5 },
  { 235, 4 },
  { 235, 1 },
  { 170, 4 },
  { 170, 6 },
  { 186, 1 },
  { 186, 1 },
  { 186, 1 },
  { 144, 4 },
  { 144, 6 },
  { 144, 3 },
  { 237, 0 },
  { 237, 2 },
  { 236, 1 },
  { 236, 0 },
  { 144, 1 },
  { 144, 3 },
  { 144, 1 },
  { 144, 3 },
  { 144, 6 },
  { 144, 6 },
  { 238, 1 },
  { 239, 0 },
  { 239, 1 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0: /* input ::= cmdlist */
      case 1: /* cmdlist ::= cmdlist ecmd */
      case 2: /* cmdlist ::= ecmd */
      case 3: /* ecmd ::= SEMI */
      case 4: /* ecmd ::= explain cmdx SEMI */
      case 10: /* trans_opt ::= */
      case 11: /* trans_opt ::= TRANSACTION */
      case 12: /* trans_opt ::= TRANSACTION nm */
      case 20: /* cmd ::= create_table create_table_args */
      case 28: /* columnlist ::= columnlist COMMA column */
      case 29: /* columnlist ::= column */
      case 37: /* type ::= */
      case 44: /* signed ::= plus_num */
      case 45: /* signed ::= minus_num */
      case 46: /* carglist ::= carglist carg */
      case 47: /* carglist ::= */
      case 48: /* carg ::= CONSTRAINT nm ccons */
      case 49: /* carg ::= ccons */
      case 55: /* ccons ::= NULL onconf */
      case 82: /* conslist ::= conslist COMMA tcons */
      case 83: /* conslist ::= conslist tcons */
      case 84: /* conslist ::= tcons */
      case 85: /* tcons ::= CONSTRAINT nm */
      case 257: /* plus_opt ::= PLUS */
      case 258: /* plus_opt ::= */
      case 268: /* foreach_clause ::= */
      case 269: /* foreach_clause ::= FOR EACH ROW */
      case 289: /* database_kw_opt ::= DATABASE */
      case 290: /* database_kw_opt ::= */
      case 298: /* kwcolumn_opt ::= */
      case 299: /* kwcolumn_opt ::= COLUMNKW */
#line 91 "parse.y"
{
}
#line 1962 "parse.c"
        break;
      case 5: /* explain ::= */
#line 96 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1967 "parse.c"
        break;
      case 6: /* explain ::= EXPLAIN */
#line 98 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1972 "parse.c"
        break;
      case 7: /* explain ::= EXPLAIN QUERY PLAN */
#line 99 "parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 1977 "parse.c"
        break;
      case 8: /* cmdx ::= cmd */
#line 101 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1982 "parse.c"
        break;
      case 9: /* cmd ::= BEGIN transtype trans_opt */
#line 106 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy412);}
#line 1987 "parse.c"
        break;
      case 13: /* transtype ::= */
#line 111 "parse.y"
{yygotominor.yy412 = TK_DEFERRED;}
#line 1992 "parse.c"
        break;
      case 14: /* transtype ::= DEFERRED */
      case 15: /* transtype ::= IMMEDIATE */
      case 16: /* transtype ::= EXCLUSIVE */
      case 107: /* multiselect_op ::= UNION */
      case 109: /* multiselect_op ::= EXCEPT|INTERSECT */
#line 112 "parse.y"
{yygotominor.yy412 = yymsp[0].major;}
#line 2001 "parse.c"
        break;
      case 17: /* cmd ::= COMMIT trans_opt */
      case 18: /* cmd ::= END trans_opt */
#line 115 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 2007 "parse.c"
        break;
      case 19: /* cmd ::= ROLLBACK trans_opt */
#line 117 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 2012 "parse.c"
        break;
      case 21: /* create_table ::= CREATE temp TABLE ifnotexists nm dbnm */
#line 122 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0,yymsp[-4].minor.yy412,0,0,yymsp[-2].minor.yy412);
}
#line 2019 "parse.c"
        break;
      case 22: /* ifnotexists ::= */
      case 25: /* temp ::= */
      case 63: /* autoinc ::= */
      case 77: /* init_deferred_pred_opt ::= */
      case 79: /* init_deferred_pred_opt ::= INITIALLY IMMEDIATE */
      case 90: /* defer_subclause_opt ::= */
      case 101: /* ifexists ::= */
      case 112: /* distinct ::= ALL */
      case 113: /* distinct ::= */
      case 213: /* between_op ::= BETWEEN */
      case 216: /* in_op ::= IN */
#line 126 "parse.y"
{yygotominor.yy412 = 0;}
#line 2034 "parse.c"
        break;
      case 23: /* ifnotexists ::= IF NOT EXISTS */
      case 24: /* temp ::= TEMP */
      case 64: /* autoinc ::= AUTOINCR */
      case 78: /* init_deferred_pred_opt ::= INITIALLY DEFERRED */
      case 100: /* ifexists ::= IF EXISTS */
      case 111: /* distinct ::= DISTINCT */
      case 214: /* between_op ::= NOT BETWEEN */
      case 217: /* in_op ::= NOT IN */
#line 127 "parse.y"
{yygotominor.yy412 = 1;}
#line 2046 "parse.c"
        break;
      case 26: /* create_table_args ::= LP columnlist conslist_opt RP */
#line 133 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0,0);
}
#line 2053 "parse.c"
        break;
      case 27: /* create_table_args ::= AS select */
#line 136 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy459);
  sqlite3SelectDelete(pParse->db, yymsp[0].minor.yy459);
}
#line 2061 "parse.c"
        break;
      case 30: /* column ::= columnid type carglist */
#line 148 "parse.y"
{
  yygotominor.yy0.z = yymsp[-2].minor.yy0.z;
  yygotominor.yy0.n = (pParse->sLastToken.z-yymsp[-2].minor.yy0.z) + pParse->sLastToken.n;
}
#line 2069 "parse.c"
        break;
      case 31: /* columnid ::= nm */
#line 152 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy0);
  yygotominor.yy0 = yymsp[0].minor.yy0;
}
#line 2077 "parse.c"
        break;
      case 32: /* id ::= ID */
      case 33: /* ids ::= ID|STRING */
      case 34: /* nm ::= ID */
      case 35: /* nm ::= STRING */
      case 36: /* nm ::= JOIN_KW */
      case 39: /* typetoken ::= typename */
      case 42: /* typename ::= ids */
      case 119: /* as ::= AS nm */
      case 120: /* as ::= ids */
      case 131: /* dbnm ::= DOT nm */
      case 242: /* collate ::= COLLATE ids */
      case 252: /* nmnum ::= plus_num */
      case 253: /* nmnum ::= nm */
      case 254: /* plus_num ::= plus_opt number */
      case 255: /* minus_num ::= MINUS number */
      case 256: /* number ::= INTEGER|FLOAT */
#line 162 "parse.y"
{yygotominor.yy0 = yymsp[0].minor.yy0;}
#line 2097 "parse.c"
        break;
      case 38: /* type ::= typetoken */
#line 223 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy0);}
#line 2102 "parse.c"
        break;
      case 40: /* typetoken ::= typename LP signed RP */
#line 225 "parse.y"
{
  yygotominor.yy0.z = yymsp[-3].minor.yy0.z;
  yygotominor.yy0.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy0.z;
}
#line 2110 "parse.c"
        break;
      case 41: /* typetoken ::= typename LP signed COMMA signed RP */
#line 229 "parse.y"
{
  yygotominor.yy0.z = yymsp[-5].minor.yy0.z;
  yygotominor.yy0.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy0.z;
}
#line 2118 "parse.c"
        break;
      case 43: /* typename ::= typename ids */
#line 235 "parse.y"
{yygotominor.yy0.z=yymsp[-1].minor.yy0.z; yygotominor.yy0.n=yymsp[0].minor.yy0.n+(yymsp[0].minor.yy0.z-yymsp[-1].minor.yy0.z);}
#line 2123 "parse.c"
        break;
      case 50: /* ccons ::= DEFAULT term */
      case 52: /* ccons ::= DEFAULT PLUS term */
#line 246 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy2);}
#line 2129 "parse.c"
        break;
      case 51: /* ccons ::= DEFAULT LP expr RP */
#line 247 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy2);}
#line 2134 "parse.c"
        break;
      case 53: /* ccons ::= DEFAULT MINUS term */
#line 249 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_UMINUS, yymsp[0].minor.yy2, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2142 "parse.c"
        break;
      case 54: /* ccons ::= DEFAULT id */
#line 253 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_STRING, 0, 0, &yymsp[0].minor.yy0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2150 "parse.c"
        break;
      case 56: /* ccons ::= NOT NULL onconf */
#line 262 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy412);}
#line 2155 "parse.c"
        break;
      case 57: /* ccons ::= PRIMARY KEY sortorder onconf autoinc */
#line 264 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy412,yymsp[0].minor.yy412,yymsp[-2].minor.yy412);}
#line 2160 "parse.c"
        break;
      case 58: /* ccons ::= UNIQUE onconf */
#line 265 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy412,0,0,0,0);}
#line 2165 "parse.c"
        break;
      case 59: /* ccons ::= CHECK LP expr RP */
#line 266 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-1].minor.yy2);}
#line 2170 "parse.c"
        break;
      case 60: /* ccons ::= REFERENCES nm idxlist_opt refargs */
#line 268 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy0,yymsp[-1].minor.yy82,yymsp[0].minor.yy412);}
#line 2175 "parse.c"
        break;
      case 61: /* ccons ::= defer_subclause */
#line 269 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy412);}
#line 2180 "parse.c"
        break;
      case 62: /* ccons ::= COLLATE ids */
#line 270 "parse.y"
{sqlite3AddCollateType(pParse, &yymsp[0].minor.yy0);}
#line 2185 "parse.c"
        break;
      case 65: /* refargs ::= */
#line 283 "parse.y"
{ yygotominor.yy412 = OE_Restrict * 0x010101; }
#line 2190 "parse.c"
        break;
      case 66: /* refargs ::= refargs refarg */
#line 284 "parse.y"
{ yygotominor.yy412 = (yymsp[-1].minor.yy412 & yymsp[0].minor.yy47.mask) | yymsp[0].minor.yy47.value; }
#line 2195 "parse.c"
        break;
      case 67: /* refarg ::= MATCH nm */
#line 286 "parse.y"
{ yygotominor.yy47.value = 0;     yygotominor.yy47.mask = 0x000000; }
#line 2200 "parse.c"
        break;
      case 68: /* refarg ::= ON DELETE refact */
#line 287 "parse.y"
{ yygotominor.yy47.value = yymsp[0].minor.yy412;     yygotominor.yy47.mask = 0x0000ff; }
#line 2205 "parse.c"
        break;
      case 69: /* refarg ::= ON UPDATE refact */
#line 288 "parse.y"
{ yygotominor.yy47.value = yymsp[0].minor.yy412<<8;  yygotominor.yy47.mask = 0x00ff00; }
#line 2210 "parse.c"
        break;
      case 70: /* refarg ::= ON INSERT refact */
#line 289 "parse.y"
{ yygotominor.yy47.value = yymsp[0].minor.yy412<<16; yygotominor.yy47.mask = 0xff0000; }
#line 2215 "parse.c"
        break;
      case 71: /* refact ::= SET NULL */
#line 291 "parse.y"
{ yygotominor.yy412 = OE_SetNull; }
#line 2220 "parse.c"
        break;
      case 72: /* refact ::= SET DEFAULT */
#line 292 "parse.y"
{ yygotominor.yy412 = OE_SetDflt; }
#line 2225 "parse.c"
        break;
      case 73: /* refact ::= CASCADE */
#line 293 "parse.y"
{ yygotominor.yy412 = OE_Cascade; }
#line 2230 "parse.c"
        break;
      case 74: /* refact ::= RESTRICT */
#line 294 "parse.y"
{ yygotominor.yy412 = OE_Restrict; }
#line 2235 "parse.c"
        break;
      case 75: /* defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt */
      case 76: /* defer_subclause ::= DEFERRABLE init_deferred_pred_opt */
      case 91: /* defer_subclause_opt ::= defer_subclause */
      case 93: /* onconf ::= ON CONFLICT resolvetype */
      case 95: /* orconf ::= OR resolvetype */
      case 96: /* resolvetype ::= raisetype */
      case 166: /* insert_cmd ::= INSERT orconf */
#line 296 "parse.y"
{yygotominor.yy412 = yymsp[0].minor.yy412;}
#line 2246 "parse.c"
        break;
      case 80: /* conslist_opt ::= */
#line 306 "parse.y"
{yygotominor.yy0.n = 0; yygotominor.yy0.z = 0;}
#line 2251 "parse.c"
        break;
      case 81: /* conslist_opt ::= COMMA conslist */
#line 307 "parse.y"
{yygotominor.yy0 = yymsp[-1].minor.yy0;}
#line 2256 "parse.c"
        break;
      case 86: /* tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf */
#line 313 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy82,yymsp[0].minor.yy412,yymsp[-2].minor.yy412,0);}
#line 2261 "parse.c"
        break;
      case 87: /* tcons ::= UNIQUE LP idxlist RP onconf */
#line 315 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy82,yymsp[0].minor.yy412,0,0,0,0);}
#line 2266 "parse.c"
        break;
      case 88: /* tcons ::= CHECK LP expr RP onconf */
#line 316 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-2].minor.yy2);}
#line 2271 "parse.c"
        break;
      case 89: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt */
#line 318 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy82, &yymsp[-3].minor.yy0, yymsp[-2].minor.yy82, yymsp[-1].minor.yy412);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy412);
}
#line 2279 "parse.c"
        break;
      case 92: /* onconf ::= */
      case 94: /* orconf ::= */
#line 332 "parse.y"
{yygotominor.yy412 = OE_Default;}
#line 2285 "parse.c"
        break;
      case 97: /* resolvetype ::= IGNORE */
#line 337 "parse.y"
{yygotominor.yy412 = OE_Ignore;}
#line 2290 "parse.c"
        break;
      case 98: /* resolvetype ::= REPLACE */
      case 167: /* insert_cmd ::= REPLACE */
#line 338 "parse.y"
{yygotominor.yy412 = OE_Replace;}
#line 2296 "parse.c"
        break;
      case 99: /* cmd ::= DROP TABLE ifexists fullname */
#line 342 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy67, 0, yymsp[-1].minor.yy412);
}
#line 2303 "parse.c"
        break;
      case 102: /* cmd ::= CREATE temp VIEW ifnotexists nm dbnm AS select */
#line 352 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-7].minor.yy0, &yymsp[-3].minor.yy0, &yymsp[-2].minor.yy0, yymsp[0].minor.yy459, yymsp[-6].minor.yy412, yymsp[-4].minor.yy412);
}
#line 2310 "parse.c"
        break;
      case 103: /* cmd ::= DROP VIEW ifexists fullname */
#line 355 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy67, 1, yymsp[-1].minor.yy412);
}
#line 2317 "parse.c"
        break;
      case 104: /* cmd ::= select */
#line 362 "parse.y"
{
  SelectDest dest = {SRT_Output, 0, 0, 0, 0};
  sqlite3Select(pParse, yymsp[0].minor.yy459, &dest);
  sqlite3SelectDelete(pParse->db, yymsp[0].minor.yy459);
}
#line 2326 "parse.c"
        break;
      case 105: /* select ::= oneselect */
      case 128: /* seltablist_paren ::= select */
#line 373 "parse.y"
{yygotominor.yy459 = yymsp[0].minor.yy459;}
#line 2332 "parse.c"
        break;
      case 106: /* select ::= select multiselect_op oneselect */
#line 375 "parse.y"
{
  if( yymsp[0].minor.yy459 ){
    yymsp[0].minor.yy459->op = yymsp[-1].minor.yy412;
    yymsp[0].minor.yy459->pPrior = yymsp[-2].minor.yy459;
  }else{
    sqlite3SelectDelete(pParse->db, yymsp[-2].minor.yy459);
  }
  yygotominor.yy459 = yymsp[0].minor.yy459;
}
#line 2345 "parse.c"
        break;
      case 108: /* multiselect_op ::= UNION ALL */
#line 386 "parse.y"
{yygotominor.yy412 = TK_ALL;}
#line 2350 "parse.c"
        break;
      case 110: /* oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
#line 390 "parse.y"
{
  yygotominor.yy459 = sqlite3SelectNew(pParse,yymsp[-6].minor.yy82,yymsp[-5].minor.yy67,yymsp[-4].minor.yy2,yymsp[-3].minor.yy82,yymsp[-2].minor.yy2,yymsp[-1].minor.yy82,yymsp[-7].minor.yy412,yymsp[0].minor.yy244.pLimit,yymsp[0].minor.yy244.pOffset);
}
#line 2357 "parse.c"
        break;
      case 114: /* sclp ::= selcollist COMMA */
      case 238: /* idxlist_opt ::= LP idxlist RP */
#line 411 "parse.y"
{yygotominor.yy82 = yymsp[-1].minor.yy82;}
#line 2363 "parse.c"
        break;
      case 115: /* sclp ::= */
      case 141: /* orderby_opt ::= */
      case 149: /* groupby_opt ::= */
      case 231: /* exprlist ::= */
      case 237: /* idxlist_opt ::= */
#line 412 "parse.y"
{yygotominor.yy82 = 0;}
#line 2372 "parse.c"
        break;
      case 116: /* selcollist ::= sclp expr as */
#line 413 "parse.y"
{
   yygotominor.yy82 = sqlite3ExprListAppend(pParse,yymsp[-2].minor.yy82,yymsp[-1].minor.yy2,yymsp[0].minor.yy0.n?&yymsp[0].minor.yy0:0);
}
#line 2379 "parse.c"
        break;
      case 117: /* selcollist ::= sclp STAR */
#line 416 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_ALL, 0, 0, 0);
  yygotominor.yy82 = sqlite3ExprListAppend(pParse, yymsp[-1].minor.yy82, p, 0);
}
#line 2387 "parse.c"
        break;
      case 118: /* selcollist ::= sclp nm DOT STAR */
#line 420 "parse.y"
{
  Expr *pRight = sqlite3PExpr(pParse, TK_ALL, 0, 0, &yymsp[0].minor.yy0);
  Expr *pLeft = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy0);
  Expr *pDot = sqlite3PExpr(pParse, TK_DOT, pLeft, pRight, 0);
  yygotominor.yy82 = sqlite3ExprListAppend(pParse,yymsp[-3].minor.yy82, pDot, 0);
}
#line 2397 "parse.c"
        break;
      case 121: /* as ::= */
#line 433 "parse.y"
{yygotominor.yy0.n = 0;}
#line 2402 "parse.c"
        break;
      case 122: /* from ::= */
#line 445 "parse.y"
{yygotominor.yy67 = sqlite3DbMallocZero(pParse->db, sizeof(*yygotominor.yy67));}
#line 2407 "parse.c"
        break;
      case 123: /* from ::= FROM seltablist */
#line 446 "parse.y"
{
  yygotominor.yy67 = yymsp[0].minor.yy67;
  sqlite3SrcListShiftJoinType(yygotominor.yy67);
}
#line 2415 "parse.c"
        break;
      case 124: /* stl_prefix ::= seltablist joinop */
#line 454 "parse.y"
{
   yygotominor.yy67 = yymsp[-1].minor.yy67;
   if( yygotominor.yy67 && yygotominor.yy67->nSrc>0 ) yygotominor.yy67->a[yygotominor.yy67->nSrc-1].jointype = yymsp[0].minor.yy412;
}
#line 2423 "parse.c"
        break;
      case 125: /* stl_prefix ::= */
#line 458 "parse.y"
{yygotominor.yy67 = 0;}
#line 2428 "parse.c"
        break;
      case 126: /* seltablist ::= stl_prefix nm dbnm as on_opt using_opt */
#line 459 "parse.y"
{
  yygotominor.yy67 = sqlite3SrcListAppendFromTerm(pParse,yymsp[-5].minor.yy67,&yymsp[-4].minor.yy0,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,0,yymsp[-1].minor.yy2,yymsp[0].minor.yy240);
}
#line 2435 "parse.c"
        break;
      case 127: /* seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt */
#line 464 "parse.y"
{
    yygotominor.yy67 = sqlite3SrcListAppendFromTerm(pParse,yymsp[-6].minor.yy67,0,0,&yymsp[-2].minor.yy0,yymsp[-4].minor.yy459,yymsp[-1].minor.yy2,yymsp[0].minor.yy240);
  }
#line 2442 "parse.c"
        break;
      case 129: /* seltablist_paren ::= seltablist */
#line 475 "parse.y"
{
     sqlite3SrcListShiftJoinType(yymsp[0].minor.yy67);
     yygotominor.yy459 = sqlite3SelectNew(pParse,0,yymsp[0].minor.yy67,0,0,0,0,0,0,0);
  }
#line 2450 "parse.c"
        break;
      case 130: /* dbnm ::= */
#line 482 "parse.y"
{yygotominor.yy0.z=0; yygotominor.yy0.n=0;}
#line 2455 "parse.c"
        break;
      case 132: /* fullname ::= nm dbnm */
#line 487 "parse.y"
{yygotominor.yy67 = sqlite3SrcListAppend(pParse->db,0,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0);}
#line 2460 "parse.c"
        break;
      case 133: /* joinop ::= COMMA|JOIN */
#line 491 "parse.y"
{ yygotominor.yy412 = JT_INNER; }
#line 2465 "parse.c"
        break;
      case 134: /* joinop ::= JOIN_KW JOIN */
#line 492 "parse.y"
{ yygotominor.yy412 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2470 "parse.c"
        break;
      case 135: /* joinop ::= JOIN_KW nm JOIN */
#line 493 "parse.y"
{ yygotominor.yy412 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy0,0); }
#line 2475 "parse.c"
        break;
      case 136: /* joinop ::= JOIN_KW nm nm JOIN */
#line 495 "parse.y"
{ yygotominor.yy412 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy0); }
#line 2480 "parse.c"
        break;
      case 137: /* on_opt ::= ON expr */
      case 145: /* sortitem ::= expr */
      case 152: /* having_opt ::= HAVING expr */
      case 159: /* where_opt ::= WHERE expr */
      case 174: /* expr ::= term */
      case 202: /* escape ::= ESCAPE expr */
      case 226: /* case_else ::= ELSE expr */
      case 228: /* case_operand ::= expr */
#line 499 "parse.y"
{yygotominor.yy2 = yymsp[0].minor.yy2;}
#line 2492 "parse.c"
        break;
      case 138: /* on_opt ::= */
      case 151: /* having_opt ::= */
      case 158: /* where_opt ::= */
      case 203: /* escape ::= */
      case 227: /* case_else ::= */
      case 229: /* case_operand ::= */
#line 500 "parse.y"
{yygotominor.yy2 = 0;}
#line 2502 "parse.c"
        break;
      case 139: /* using_opt ::= USING LP inscollist RP */
      case 171: /* inscollist_opt ::= LP inscollist RP */
#line 504 "parse.y"
{yygotominor.yy240 = yymsp[-1].minor.yy240;}
#line 2508 "parse.c"
        break;
      case 140: /* using_opt ::= */
      case 170: /* inscollist_opt ::= */
#line 505 "parse.y"
{yygotominor.yy240 = 0;}
#line 2514 "parse.c"
        break;
      case 142: /* orderby_opt ::= ORDER BY sortlist */
      case 150: /* groupby_opt ::= GROUP BY nexprlist */
      case 230: /* exprlist ::= nexprlist */
#line 516 "parse.y"
{yygotominor.yy82 = yymsp[0].minor.yy82;}
#line 2521 "parse.c"
        break;
      case 143: /* sortlist ::= sortlist COMMA sortitem sortorder */
#line 517 "parse.y"
{
  yygotominor.yy82 = sqlite3ExprListAppend(pParse,yymsp[-3].minor.yy82,yymsp[-1].minor.yy2,0);
  if( yygotominor.yy82 ) yygotominor.yy82->a[yygotominor.yy82->nExpr-1].sortOrder = yymsp[0].minor.yy412;
}
#line 2529 "parse.c"
        break;
      case 144: /* sortlist ::= sortitem sortorder */
#line 521 "parse.y"
{
  yygotominor.yy82 = sqlite3ExprListAppend(pParse,0,yymsp[-1].minor.yy2,0);
  if( yygotominor.yy82 && yygotominor.yy82->a ) yygotominor.yy82->a[0].sortOrder = yymsp[0].minor.yy412;
}
#line 2537 "parse.c"
        break;
      case 146: /* sortorder ::= ASC */
      case 148: /* sortorder ::= */
#line 529 "parse.y"
{yygotominor.yy412 = SQLITE_SO_ASC;}
#line 2543 "parse.c"
        break;
      case 147: /* sortorder ::= DESC */
#line 530 "parse.y"
{yygotominor.yy412 = SQLITE_SO_DESC;}
#line 2548 "parse.c"
        break;
      case 153: /* limit_opt ::= */
#line 556 "parse.y"
{yygotominor.yy244.pLimit = 0; yygotominor.yy244.pOffset = 0;}
#line 2553 "parse.c"
        break;
      case 154: /* limit_opt ::= LIMIT expr */
#line 557 "parse.y"
{yygotominor.yy244.pLimit = yymsp[0].minor.yy2; yygotominor.yy244.pOffset = 0;}
#line 2558 "parse.c"
        break;
      case 155: /* limit_opt ::= LIMIT expr OFFSET expr */
#line 559 "parse.y"
{yygotominor.yy244.pLimit = yymsp[-2].minor.yy2; yygotominor.yy244.pOffset = yymsp[0].minor.yy2;}
#line 2563 "parse.c"
        break;
      case 156: /* limit_opt ::= LIMIT expr COMMA expr */
#line 561 "parse.y"
{yygotominor.yy244.pOffset = yymsp[-2].minor.yy2; yygotominor.yy244.pLimit = yymsp[0].minor.yy2;}
#line 2568 "parse.c"
        break;
      case 157: /* cmd ::= DELETE FROM fullname where_opt */
#line 565 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy67,yymsp[0].minor.yy2);}
#line 2573 "parse.c"
        break;
      case 160: /* cmd ::= UPDATE orconf fullname SET setlist where_opt */
#line 575 "parse.y"
{
  sqlite3ExprListCheckLength(pParse,yymsp[-1].minor.yy82,"set list"); 
  sqlite3Update(pParse,yymsp[-3].minor.yy67,yymsp[-1].minor.yy82,yymsp[0].minor.yy2,yymsp[-4].minor.yy412);
}
#line 2581 "parse.c"
        break;
      case 161: /* setlist ::= setlist COMMA nm EQ expr */
#line 584 "parse.y"
{yygotominor.yy82 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy82,yymsp[0].minor.yy2,&yymsp[-2].minor.yy0);}
#line 2586 "parse.c"
        break;
      case 162: /* setlist ::= nm EQ expr */
#line 586 "parse.y"
{yygotominor.yy82 = sqlite3ExprListAppend(pParse,0,yymsp[0].minor.yy2,&yymsp[-2].minor.yy0);}
#line 2591 "parse.c"
        break;
      case 163: /* cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP */
#line 592 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy67, yymsp[-1].minor.yy82, 0, yymsp[-4].minor.yy240, yymsp[-7].minor.yy412);}
#line 2596 "parse.c"
        break;
      case 164: /* cmd ::= insert_cmd INTO fullname inscollist_opt select */
#line 594 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy67, 0, yymsp[0].minor.yy459, yymsp[-1].minor.yy240, yymsp[-4].minor.yy412);}
#line 2601 "parse.c"
        break;
      case 165: /* cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES */
#line 596 "parse.y"
{sqlite3Insert(pParse, yymsp[-3].minor.yy67, 0, 0, yymsp[-2].minor.yy240, yymsp[-5].minor.yy412);}
#line 2606 "parse.c"
        break;
      case 168: /* itemlist ::= itemlist COMMA expr */
      case 232: /* nexprlist ::= nexprlist COMMA expr */
#line 607 "parse.y"
{yygotominor.yy82 = sqlite3ExprListAppend(pParse,yymsp[-2].minor.yy82,yymsp[0].minor.yy2,0);}
#line 2612 "parse.c"
        break;
      case 169: /* itemlist ::= expr */
      case 233: /* nexprlist ::= expr */
#line 609 "parse.y"
{yygotominor.yy82 = sqlite3ExprListAppend(pParse,0,yymsp[0].minor.yy2,0);}
#line 2618 "parse.c"
        break;
      case 172: /* inscollist ::= inscollist COMMA nm */
#line 619 "parse.y"
{yygotominor.yy240 = sqlite3IdListAppend(pParse->db,yymsp[-2].minor.yy240,&yymsp[0].minor.yy0);}
#line 2623 "parse.c"
        break;
      case 173: /* inscollist ::= nm */
#line 621 "parse.y"
{yygotominor.yy240 = sqlite3IdListAppend(pParse->db,0,&yymsp[0].minor.yy0);}
#line 2628 "parse.c"
        break;
      case 175: /* expr ::= LP expr RP */
#line 632 "parse.y"
{yygotominor.yy2 = yymsp[-1].minor.yy2; sqlite3ExprSpan(yygotominor.yy2,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2633 "parse.c"
        break;
      case 176: /* term ::= NULL */
      case 181: /* term ::= INTEGER|FLOAT|BLOB */
      case 182: /* term ::= STRING */
#line 633 "parse.y"
{yygotominor.yy2 = sqlite3PExpr(pParse, yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2640 "parse.c"
        break;
      case 177: /* expr ::= ID */
      case 178: /* expr ::= JOIN_KW */
#line 634 "parse.y"
{yygotominor.yy2 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2646 "parse.c"
        break;
      case 179: /* expr ::= nm DOT nm */
#line 636 "parse.y"
{
  Expr *temp1 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy0);
  Expr *temp2 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);
  yygotominor.yy2 = sqlite3PExpr(pParse, TK_DOT, temp1, temp2, 0);
}
#line 2655 "parse.c"
        break;
      case 180: /* expr ::= nm DOT nm DOT nm */
#line 641 "parse.y"
{
  Expr *temp1 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-4].minor.yy0);
  Expr *temp2 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy0);
  Expr *temp3 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);
  Expr *temp4 = sqlite3PExpr(pParse, TK_DOT, temp2, temp3, 0);
  yygotominor.yy2 = sqlite3PExpr(pParse, TK_DOT, temp1, temp4, 0);
}
#line 2666 "parse.c"
        break;
      case 183: /* expr ::= REGISTER */
#line 650 "parse.y"
{yygotominor.yy2 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2671 "parse.c"
        break;
      case 184: /* expr ::= VARIABLE */
#line 651 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy2 = sqlite3PExpr(pParse, TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2680 "parse.c"
        break;
      case 185: /* expr ::= expr COLLATE ids */
#line 656 "parse.y"
{
  yygotominor.yy2 = sqlite3ExprSetColl(pParse, yymsp[-2].minor.yy2, &yymsp[0].minor.yy0);
}
#line 2687 "parse.c"
        break;
      case 186: /* expr ::= CAST LP expr AS typetoken RP */
#line 660 "parse.y"
{
  yygotominor.yy2 = sqlite3PExpr(pParse, TK_CAST, yymsp[-3].minor.yy2, 0, &yymsp[-1].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2695 "parse.c"
        break;
      case 187: /* expr ::= ID LP distinct exprlist RP */
#line 665 "parse.y"
{
  if( yymsp[-1].minor.yy82 && yymsp[-1].minor.yy82->nExpr>SQLITE_MAX_FUNCTION_ARG ){
    sqlite3ErrorMsg(pParse, "too many arguments on function %T", &yymsp[-4].minor.yy0);
  }
  yygotominor.yy2 = sqlite3ExprFunction(pParse, yymsp[-1].minor.yy82, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy412 && yygotominor.yy2 ){
    yygotominor.yy2->flags |= EP_Distinct;
  }
}
#line 2709 "parse.c"
        break;
      case 188: /* expr ::= ID LP STAR RP */
#line 675 "parse.y"
{
  yygotominor.yy2 = sqlite3ExprFunction(pParse, 0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2717 "parse.c"
        break;
      case 189: /* term ::= CTIME_KW */
#line 679 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy2 = sqlite3ExprFunction(pParse, 0,&yymsp[0].minor.yy0);
  if( yygotominor.yy2 ){
    yygotominor.yy2->op = TK_CONST_FUNC;  
    yygotominor.yy2->span = yymsp[0].minor.yy0;
  }
}
#line 2730 "parse.c"
        break;
      case 190: /* expr ::= expr AND expr */
      case 191: /* expr ::= expr OR expr */
      case 192: /* expr ::= expr LT|GT|GE|LE expr */
      case 193: /* expr ::= expr EQ|NE expr */
      case 194: /* expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr */
      case 195: /* expr ::= expr PLUS|MINUS expr */
      case 196: /* expr ::= expr STAR|SLASH|REM expr */
      case 197: /* expr ::= expr CONCAT expr */
#line 688 "parse.y"
{yygotominor.yy2 = sqlite3PExpr(pParse,yymsp[-1].major,yymsp[-2].minor.yy2,yymsp[0].minor.yy2,0);}
#line 2742 "parse.c"
        break;
      case 198: /* likeop ::= LIKE_KW */
      case 200: /* likeop ::= MATCH */
#line 700 "parse.y"
{yygotominor.yy438.eOperator = yymsp[0].minor.yy0; yygotominor.yy438.not = 0;}
#line 2748 "parse.c"
        break;
      case 199: /* likeop ::= NOT LIKE_KW */
      case 201: /* likeop ::= NOT MATCH */
#line 701 "parse.y"
{yygotominor.yy438.eOperator = yymsp[0].minor.yy0; yygotominor.yy438.not = 1;}
#line 2754 "parse.c"
        break;
      case 204: /* expr ::= expr likeop expr escape */
#line 708 "parse.y"
{
  ExprList *pList;
  pList = sqlite3ExprListAppend(pParse,0, yymsp[-1].minor.yy2, 0);
  pList = sqlite3ExprListAppend(pParse,pList, yymsp[-3].minor.yy2, 0);
  if( yymsp[0].minor.yy2 ){
    pList = sqlite3ExprListAppend(pParse,pList, yymsp[0].minor.yy2, 0);
  }
  yygotominor.yy2 = sqlite3ExprFunction(pParse, pList, &yymsp[-2].minor.yy438.eOperator);
  if( yymsp[-2].minor.yy438.not ) yygotominor.yy2 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2, &yymsp[-3].minor.yy2->span, &yymsp[-1].minor.yy2->span);
  if( yygotominor.yy2 ) yygotominor.yy2->flags |= EP_InfixFunc;
}
#line 2770 "parse.c"
        break;
      case 205: /* expr ::= expr ISNULL|NOTNULL */
#line 721 "parse.y"
{
  yygotominor.yy2 = sqlite3PExpr(pParse, yymsp[0].major, yymsp[-1].minor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-1].minor.yy2->span,&yymsp[0].minor.yy0);
}
#line 2778 "parse.c"
        break;
      case 206: /* expr ::= expr IS NULL */
#line 725 "parse.y"
{
  yygotominor.yy2 = sqlite3PExpr(pParse, TK_ISNULL, yymsp[-2].minor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-2].minor.yy2->span,&yymsp[0].minor.yy0);
}
#line 2786 "parse.c"
        break;
      case 207: /* expr ::= expr NOT NULL */
#line 729 "parse.y"
{
  yygotominor.yy2 = sqlite3PExpr(pParse, TK_NOTNULL, yymsp[-2].minor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-2].minor.yy2->span,&yymsp[0].minor.yy0);
}
#line 2794 "parse.c"
        break;
      case 208: /* expr ::= expr IS NOT NULL */
#line 733 "parse.y"
{
  yygotominor.yy2 = sqlite3PExpr(pParse, TK_NOTNULL, yymsp[-3].minor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-3].minor.yy2->span,&yymsp[0].minor.yy0);
}
#line 2802 "parse.c"
        break;
      case 209: /* expr ::= NOT expr */
      case 210: /* expr ::= BITNOT expr */
#line 737 "parse.y"
{
  yygotominor.yy2 = sqlite3PExpr(pParse, yymsp[-1].major, yymsp[0].minor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy2->span);
}
#line 2811 "parse.c"
        break;
      case 211: /* expr ::= MINUS expr */
#line 745 "parse.y"
{
  yygotominor.yy2 = sqlite3PExpr(pParse, TK_UMINUS, yymsp[0].minor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy2->span);
}
#line 2819 "parse.c"
        break;
      case 212: /* expr ::= PLUS expr */
#line 749 "parse.y"
{
  yygotominor.yy2 = sqlite3PExpr(pParse, TK_UPLUS, yymsp[0].minor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy2->span);
}
#line 2827 "parse.c"
        break;
      case 215: /* expr ::= expr between_op expr AND expr */
#line 756 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(pParse,0, yymsp[-2].minor.yy2, 0);
  pList = sqlite3ExprListAppend(pParse,pList, yymsp[0].minor.yy2, 0);
  yygotominor.yy2 = sqlite3PExpr(pParse, TK_BETWEEN, yymsp[-4].minor.yy2, 0, 0);
  if( yygotominor.yy2 ){
    yygotominor.yy2->pList = pList;
  }else{
    sqlite3ExprListDelete(pParse->db, pList);
  } 
  if( yymsp[-3].minor.yy412 ) yygotominor.yy2 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-4].minor.yy2->span,&yymsp[0].minor.yy2->span);
}
#line 2843 "parse.c"
        break;
      case 218: /* expr ::= expr in_op LP exprlist RP */
#line 772 "parse.y"
{
    yygotominor.yy2 = sqlite3PExpr(pParse, TK_IN, yymsp[-4].minor.yy2, 0, 0);
    if( yygotominor.yy2 ){
      yygotominor.yy2->pList = yymsp[-1].minor.yy82;
      sqlite3ExprSetHeight(pParse, yygotominor.yy2);
    }else{
      sqlite3ExprListDelete(pParse->db, yymsp[-1].minor.yy82);
    }
    if( yymsp[-3].minor.yy412 ) yygotominor.yy2 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy2, 0, 0);
    sqlite3ExprSpan(yygotominor.yy2,&yymsp[-4].minor.yy2->span,&yymsp[0].minor.yy0);
  }
#line 2858 "parse.c"
        break;
      case 219: /* expr ::= LP select RP */
#line 783 "parse.y"
{
    yygotominor.yy2 = sqlite3PExpr(pParse, TK_SELECT, 0, 0, 0);
    if( yygotominor.yy2 ){
      yygotominor.yy2->pSelect = yymsp[-1].minor.yy459;
      sqlite3ExprSetHeight(pParse, yygotominor.yy2);
    }else{
      sqlite3SelectDelete(pParse->db, yymsp[-1].minor.yy459);
    }
    sqlite3ExprSpan(yygotominor.yy2,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2872 "parse.c"
        break;
      case 220: /* expr ::= expr in_op LP select RP */
#line 793 "parse.y"
{
    yygotominor.yy2 = sqlite3PExpr(pParse, TK_IN, yymsp[-4].minor.yy2, 0, 0);
    if( yygotominor.yy2 ){
      yygotominor.yy2->pSelect = yymsp[-1].minor.yy459;
      sqlite3ExprSetHeight(pParse, yygotominor.yy2);
    }else{
      sqlite3SelectDelete(pParse->db, yymsp[-1].minor.yy459);
    }
    if( yymsp[-3].minor.yy412 ) yygotominor.yy2 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy2, 0, 0);
    sqlite3ExprSpan(yygotominor.yy2,&yymsp[-4].minor.yy2->span,&yymsp[0].minor.yy0);
  }
#line 2887 "parse.c"
        break;
      case 221: /* expr ::= expr in_op nm dbnm */
#line 804 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(pParse->db, 0,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0);
    yygotominor.yy2 = sqlite3PExpr(pParse, TK_IN, yymsp[-3].minor.yy2, 0, 0);
    if( yygotominor.yy2 ){
      yygotominor.yy2->pSelect = sqlite3SelectNew(pParse, 0,pSrc,0,0,0,0,0,0,0);
      sqlite3ExprSetHeight(pParse, yygotominor.yy2);
    }else{
      sqlite3SrcListDelete(pParse->db, pSrc);
    }
    if( yymsp[-2].minor.yy412 ) yygotominor.yy2 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy2, 0, 0);
    sqlite3ExprSpan(yygotominor.yy2,&yymsp[-3].minor.yy2->span,yymsp[0].minor.yy0.z?&yymsp[0].minor.yy0:&yymsp[-1].minor.yy0);
  }
#line 2903 "parse.c"
        break;
      case 222: /* expr ::= EXISTS LP select RP */
#line 816 "parse.y"
{
    Expr *p = yygotominor.yy2 = sqlite3PExpr(pParse, TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy459;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
      sqlite3ExprSetHeight(pParse, yygotominor.yy2);
    }else{
      sqlite3SelectDelete(pParse->db, yymsp[-1].minor.yy459);
    }
  }
#line 2917 "parse.c"
        break;
      case 223: /* expr ::= CASE case_operand case_exprlist case_else END */
#line 829 "parse.y"
{
  yygotominor.yy2 = sqlite3PExpr(pParse, TK_CASE, yymsp[-3].minor.yy2, yymsp[-1].minor.yy2, 0);
  if( yygotominor.yy2 ){
    yygotominor.yy2->pList = yymsp[-2].minor.yy82;
    sqlite3ExprSetHeight(pParse, yygotominor.yy2);
  }else{
    sqlite3ExprListDelete(pParse->db, yymsp[-2].minor.yy82);
  }
  sqlite3ExprSpan(yygotominor.yy2, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2931 "parse.c"
        break;
      case 224: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
#line 841 "parse.y"
{
  yygotominor.yy82 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy82, yymsp[-2].minor.yy2, 0);
  yygotominor.yy82 = sqlite3ExprListAppend(pParse,yygotominor.yy82, yymsp[0].minor.yy2, 0);
}
#line 2939 "parse.c"
        break;
      case 225: /* case_exprlist ::= WHEN expr THEN expr */
#line 845 "parse.y"
{
  yygotominor.yy82 = sqlite3ExprListAppend(pParse,0, yymsp[-2].minor.yy2, 0);
  yygotominor.yy82 = sqlite3ExprListAppend(pParse,yygotominor.yy82, yymsp[0].minor.yy2, 0);
}
#line 2947 "parse.c"
        break;
      case 234: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP */
#line 874 "parse.y"
{
  sqlite3CreateIndex(pParse, &yymsp[-6].minor.yy0, &yymsp[-5].minor.yy0, 
                     sqlite3SrcListAppend(pParse->db,0,&yymsp[-3].minor.yy0,0), yymsp[-1].minor.yy82, yymsp[-9].minor.yy412,
                      &yymsp[-10].minor.yy0, &yymsp[0].minor.yy0, SQLITE_SO_ASC, yymsp[-7].minor.yy412);
}
#line 2956 "parse.c"
        break;
      case 235: /* uniqueflag ::= UNIQUE */
      case 282: /* raisetype ::= ABORT */
#line 881 "parse.y"
{yygotominor.yy412 = OE_Abort;}
#line 2962 "parse.c"
        break;
      case 236: /* uniqueflag ::= */
#line 882 "parse.y"
{yygotominor.yy412 = OE_None;}
#line 2967 "parse.c"
        break;
      case 239: /* idxlist ::= idxlist COMMA nm collate sortorder */
#line 891 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy0.n>0 ){
    p = sqlite3PExpr(pParse, TK_COLUMN, 0, 0, 0);
    sqlite3ExprSetColl(pParse, p, &yymsp[-1].minor.yy0);
  }
  yygotominor.yy82 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy82, p, &yymsp[-2].minor.yy0);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy82, "index");
  if( yygotominor.yy82 ) yygotominor.yy82->a[yygotominor.yy82->nExpr-1].sortOrder = yymsp[0].minor.yy412;
}
#line 2981 "parse.c"
        break;
      case 240: /* idxlist ::= nm collate sortorder */
#line 901 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy0.n>0 ){
    p = sqlite3PExpr(pParse, TK_COLUMN, 0, 0, 0);
    sqlite3ExprSetColl(pParse, p, &yymsp[-1].minor.yy0);
  }
  yygotominor.yy82 = sqlite3ExprListAppend(pParse,0, p, &yymsp[-2].minor.yy0);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy82, "index");
  if( yygotominor.yy82 ) yygotominor.yy82->a[yygotominor.yy82->nExpr-1].sortOrder = yymsp[0].minor.yy412;
}
#line 2995 "parse.c"
        break;
      case 241: /* collate ::= */
#line 913 "parse.y"
{yygotominor.yy0.z = 0; yygotominor.yy0.n = 0;}
#line 3000 "parse.c"
        break;
      case 243: /* cmd ::= DROP INDEX ifexists fullname */
#line 919 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy67, yymsp[-1].minor.yy412);}
#line 3005 "parse.c"
        break;
      case 244: /* cmd ::= VACUUM */
      case 245: /* cmd ::= VACUUM nm */
#line 925 "parse.y"
{sqlite3Vacuum(pParse);}
#line 3011 "parse.c"
        break;
      case 246: /* cmd ::= PRAGMA nm dbnm EQ nmnum */
      case 247: /* cmd ::= PRAGMA nm dbnm EQ ON */
      case 248: /* cmd ::= PRAGMA nm dbnm EQ DELETE */
#line 934 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0,0);}
#line 3018 "parse.c"
        break;
      case 249: /* cmd ::= PRAGMA nm dbnm EQ minus_num */
#line 937 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0,1);
}
#line 3025 "parse.c"
        break;
      case 250: /* cmd ::= PRAGMA nm dbnm LP nmnum RP */
#line 940 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy0,&yymsp[-3].minor.yy0,&yymsp[-1].minor.yy0,0);}
#line 3030 "parse.c"
        break;
      case 251: /* cmd ::= PRAGMA nm dbnm */
#line 941 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0,0,0);}
#line 3035 "parse.c"
        break;
      case 259: /* cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END */
#line 956 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy0.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy0.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy347, &all);
}
#line 3045 "parse.c"
        break;
      case 260: /* trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause */
#line 965 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy0, &yymsp[-6].minor.yy0, yymsp[-5].minor.yy412, yymsp[-4].minor.yy210.a, yymsp[-4].minor.yy210.b, yymsp[-2].minor.yy67, yymsp[0].minor.yy2, yymsp[-10].minor.yy412, yymsp[-8].minor.yy412);
  yygotominor.yy0 = (yymsp[-6].minor.yy0.n==0?yymsp[-7].minor.yy0:yymsp[-6].minor.yy0);
}
#line 3053 "parse.c"
        break;
      case 261: /* trigger_time ::= BEFORE */
      case 264: /* trigger_time ::= */
#line 971 "parse.y"
{ yygotominor.yy412 = TK_BEFORE; }
#line 3059 "parse.c"
        break;
      case 262: /* trigger_time ::= AFTER */
#line 972 "parse.y"
{ yygotominor.yy412 = TK_AFTER;  }
#line 3064 "parse.c"
        break;
      case 263: /* trigger_time ::= INSTEAD OF */
#line 973 "parse.y"
{ yygotominor.yy412 = TK_INSTEAD;}
#line 3069 "parse.c"
        break;
      case 265: /* trigger_event ::= DELETE|INSERT */
      case 266: /* trigger_event ::= UPDATE */
#line 978 "parse.y"
{yygotominor.yy210.a = yymsp[0].major; yygotominor.yy210.b = 0;}
#line 3075 "parse.c"
        break;
      case 267: /* trigger_event ::= UPDATE OF inscollist */
#line 980 "parse.y"
{yygotominor.yy210.a = TK_UPDATE; yygotominor.yy210.b = yymsp[0].minor.yy240;}
#line 3080 "parse.c"
        break;
      case 270: /* when_clause ::= */
      case 287: /* key_opt ::= */
#line 987 "parse.y"
{ yygotominor.yy2 = 0; }
#line 3086 "parse.c"
        break;
      case 271: /* when_clause ::= WHEN expr */
      case 288: /* key_opt ::= KEY expr */
#line 988 "parse.y"
{ yygotominor.yy2 = yymsp[0].minor.yy2; }
#line 3092 "parse.c"
        break;
      case 272: /* trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI */
#line 992 "parse.y"
{
/*
  if( yymsp[-2].minor.yy347 ){
    yymsp[-2].minor.yy347->pLast->pNext = yymsp[-1].minor.yy347;
  }else{
    yymsp[-2].minor.yy347 = yymsp[-1].minor.yy347;
  }
*/
  assert( yymsp[-2].minor.yy347!=0 );
  yymsp[-2].minor.yy347->pLast->pNext = yymsp[-1].minor.yy347;
  yymsp[-2].minor.yy347->pLast = yymsp[-1].minor.yy347;
  yygotominor.yy347 = yymsp[-2].minor.yy347;
}
#line 3109 "parse.c"
        break;
      case 273: /* trigger_cmd_list ::= trigger_cmd SEMI */
#line 1005 "parse.y"
{ 
  /* if( yymsp[-1].minor.yy347 ) */
  assert( yymsp[-1].minor.yy347!=0 );
  yymsp[-1].minor.yy347->pLast = yymsp[-1].minor.yy347;
  yygotominor.yy347 = yymsp[-1].minor.yy347;
}
#line 3119 "parse.c"
        break;
      case 274: /* trigger_cmd ::= UPDATE orconf nm SET setlist where_opt */
#line 1016 "parse.y"
{ yygotominor.yy347 = sqlite3TriggerUpdateStep(pParse->db, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy82, yymsp[0].minor.yy2, yymsp[-4].minor.yy412); }
#line 3124 "parse.c"
        break;
      case 275: /* trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP */
#line 1021 "parse.y"
{yygotominor.yy347 = sqlite3TriggerInsertStep(pParse->db, &yymsp[-5].minor.yy0, yymsp[-4].minor.yy240, yymsp[-1].minor.yy82, 0, yymsp[-7].minor.yy412);}
#line 3129 "parse.c"
        break;
      case 276: /* trigger_cmd ::= insert_cmd INTO nm inscollist_opt select */
#line 1024 "parse.y"
{yygotominor.yy347 = sqlite3TriggerInsertStep(pParse->db, &yymsp[-2].minor.yy0, yymsp[-1].minor.yy240, 0, yymsp[0].minor.yy459, yymsp[-4].minor.yy412);}
#line 3134 "parse.c"
        break;
      case 277: /* trigger_cmd ::= DELETE FROM nm where_opt */
#line 1028 "parse.y"
{yygotominor.yy347 = sqlite3TriggerDeleteStep(pParse->db, &yymsp[-1].minor.yy0, yymsp[0].minor.yy2);}
#line 3139 "parse.c"
        break;
      case 278: /* trigger_cmd ::= select */
#line 1031 "parse.y"
{yygotominor.yy347 = sqlite3TriggerSelectStep(pParse->db, yymsp[0].minor.yy459); }
#line 3144 "parse.c"
        break;
      case 279: /* expr ::= RAISE LP IGNORE RP */
#line 1034 "parse.y"
{
  yygotominor.yy2 = sqlite3PExpr(pParse, TK_RAISE, 0, 0, 0); 
  if( yygotominor.yy2 ){
    yygotominor.yy2->iColumn = OE_Ignore;
    sqlite3ExprSpan(yygotominor.yy2, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3155 "parse.c"
        break;
      case 280: /* expr ::= RAISE LP raisetype COMMA nm RP */
#line 1041 "parse.y"
{
  yygotominor.yy2 = sqlite3PExpr(pParse, TK_RAISE, 0, 0, &yymsp[-1].minor.yy0); 
  if( yygotominor.yy2 ) {
    yygotominor.yy2->iColumn = yymsp[-3].minor.yy412;
    sqlite3ExprSpan(yygotominor.yy2, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3166 "parse.c"
        break;
      case 281: /* raisetype ::= ROLLBACK */
#line 1051 "parse.y"
{yygotominor.yy412 = OE_Rollback;}
#line 3171 "parse.c"
        break;
      case 283: /* raisetype ::= FAIL */
#line 1053 "parse.y"
{yygotominor.yy412 = OE_Fail;}
#line 3176 "parse.c"
        break;
      case 284: /* cmd ::= DROP TRIGGER ifexists fullname */
#line 1058 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy67,yymsp[-1].minor.yy412);
}
#line 3183 "parse.c"
        break;
      case 285: /* cmd ::= ATTACH database_kw_opt expr AS expr key_opt */
#line 1065 "parse.y"
{
  sqlite3Attach(pParse, yymsp[-3].minor.yy2, yymsp[-1].minor.yy2, yymsp[0].minor.yy2);
}
#line 3190 "parse.c"
        break;
      case 286: /* cmd ::= DETACH database_kw_opt expr */
#line 1068 "parse.y"
{
  sqlite3Detach(pParse, yymsp[0].minor.yy2);
}
#line 3197 "parse.c"
        break;
      case 291: /* cmd ::= REINDEX */
#line 1083 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3202 "parse.c"
        break;
      case 292: /* cmd ::= REINDEX nm dbnm */
#line 1084 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0);}
#line 3207 "parse.c"
        break;
      case 293: /* cmd ::= ANALYZE */
#line 1089 "parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3212 "parse.c"
        break;
      case 294: /* cmd ::= ANALYZE nm dbnm */
#line 1090 "parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0);}
#line 3217 "parse.c"
        break;
      case 295: /* cmd ::= ALTER TABLE fullname RENAME TO nm */
#line 1095 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy67,&yymsp[0].minor.yy0);
}
#line 3224 "parse.c"
        break;
      case 296: /* cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column */
#line 1098 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy0);
}
#line 3231 "parse.c"
        break;
      case 297: /* add_column_fullname ::= fullname */
#line 1101 "parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy67);
}
#line 3238 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "parse.y"

  assert( TOKEN.z[0] );  /* The tokenizer always gives us a token */
  sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
  pParse->parseError = 1;
#line 3303 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      assert( !yyendofinput );  /* Impossible to shift the $ token */
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
