// Copyright (c) 2003-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Provides test messages and other constants for test cases.


#include <e32base.h>
#include <e32des8.h>

#if (!defined __TEST_MESSAGE_H__)
#define __TEST_MESSAGE_H__


// General test messages
_LIT(KTestMessage,"This is the test message");
_LIT8(KTestMessage8,"This is the test message");
_LIT8(KLogFillerMessage8,"Log filler message");
_LIT8(KTestEndMessage8,"This is the test end message");

_LIT8(KFirstTestMessage,"This is the test message before file modification"); //test descriptor
_LIT8(KSecondTestMessage,"This is the test message after file modification"); //Second test decriptor


_LIT8(KTestTooLongMessage8,"This is the long message This is the long message This is the long message This is the long messageThis is the long messageThis is the long messageThis is the long messageThis is the long messageThis is the long messageThis is the long messageThis is the long messageThis is "); ///< KLogBufferSize is only 200 chars and this is over 250.
_LIT16(KTestTooLongMessage16,"This is the long message This is the long message This is the long message This is the long messageThis is the long messageThis is the long messageThis is the long messageThis is the long messageThis is the long messageThis is the long messageThis is the long messageThis is "); ///< KLogBufferSize is only 200 chars and this is over 250.


_LIT(KTestMessageOne,"The value of x is ");
_LIT(KTestMessageTwo,"The value of x is :");

_LIT16(KTestMessageOneParam16,"The value of x is %d");
_LIT8(KTestMessageOneParam8,"The value of x is %d");
_LIT16(KTestTooLongMessageOneParam16,"This is the long message This is the long message This is the long message This is the long message %d This is the long messageThis is the long messageThis is the long messageThis is the long messageThis is the long messageThis is the long messageThis is the long messageThis is "); ///< KLogBufferSize is only 200 chars and this is over 250.
_LIT8(KTestTooLongMessageOneParam8,"This is the long message This is the long message This is the long message This is the long message %d This is the long messageThis is the long messageThis is the long messageThis is the long messageThis is the long messageThis is the long messageThis is the long messageThis is "); ///< KLogBufferSize is only 200 chars and this is over 250.



_LIT8(KEightSpaces8,"        ");

_LIT8(KTestMessageWithEscapeChars8,"Th\tis\a is t\ahe tes\at me\as\rs\nage");   // includes several bells and a tab. LF, CR
_LIT8(K2ndTestMessageWithEscapeChars8,"Thi\xffs is t\x1bhe tes\0t me\xffssa\xffge");   // includes several char 255s and a null,esc

// Parameter values for Test messages (where applicable)
const TInt KTestMessageOneParamValue = 39;
const TInt KTestTooLongMessageOneParamValue = 6879;



// General test expected messages (where they differ from test messages or are system-provided)
_LIT8(KTestTooLongExpectedMessage,"This is the long message This is the long message This is the long message This is the long messageThis is the long messageThis is the long messageThis is the long messageThis is the long messageThis ");  ///< first 200 chars of KTestTooLongMessage16.

_LIT8(KTestMessageOneParamExpected,"The value of x is 39");
_LIT8(KTestTooLongMessageOneParamExpected,"This is the long message This is the long message This is the long message This is the long message 6879 This is the long messageThis is the long messageThis is the long messageThis is the long messag"); ///< first 200 chars of KTestTooLongMessageOneParam16.

_LIT8(KSampleTimeLine,"#Time = xx:xx:xx");
_LIT8(KErrIniProblemMessage,"There is a problem with the ini file");
_LIT8(KErrOOM, "#Logs may be lost out of memory!!");
_LIT8(KMessageIniHasChanged,"#Ini file changes detected and noted.");
_LIT8(KTestMessageAsHex8,"0000 : 54 68 69 73 20 69 73 20 74 68 65 20 74 65 73 74  This is the test");


// Test Messages for HEX output
_LIT8(KHexTestHeader,"Test Header"); //8 bit test header descriptor
_LIT8(KHexTestMargin,"           ");// 8 bit test margin descriptor



// Expected Date Test Messages
_LIT8(KDateChangeMessage,"Date is now");	



// Tag combinations

_LIT8(KStdSubsysTag8,"Subsystem");
_LIT8(KStdCompTag8,"Component");

_LIT16(KStdSubsysTag16,"Subsystem");
_LIT16(KStdCompTag16,"Component");

//                         1234567890123456
_LIT16(KSubsysTag16char16,"Subsystem0123456");  // 16 chars long, unicode
_LIT16(KCompTag16char16,  "Component0123456");  // 16 chars long, unicode

_LIT8(KSubsysTag16char8, "Subsystem0123456");  // 16 chars long, 8-bit
_LIT8(KCompTag16char8,   "Component0123456");  // 16 chars long, 8-bit

_LIT16(KSubsysTag17char16,"Subsystem01234567");  // 17 chars long, unicode
_LIT16(KCompTag17char16,  "Component01234567");  // 17 chars long, unicode

_LIT8(KSubsysTag17char8, "Subsystem01234567");  // 17 chars long, 8-bit
_LIT8(KCompTag17char8,   "Component01234567");  // 17 chars long, 8-bit

_LIT8(KSubsysTag66char8, "Subsystem01234567----------+-+-+-+-+-1234567890%$0xa3\\\"!^&*()<>?,./@~'#");
_LIT8(KCompTag66char8,   "Component01234567----------+-+-+-+-+-1234567890%$0xa3\\\"!^&*()<>?,./@~'#");


_LIT16(KSubsysTag66char16, "Subsystem01234567----------+-+-+-+-+-1234567890%$0xa3\\\"!^&*()<>?,./@~'#");
_LIT16(KCompTag66char16,   "Component01234567----------+-+-+-+-+-1234567890%$0xa3\\\"!^&*()<>?,./@~'#");


_LIT8(KCompTagWithSpaceChars8,"Comp onent");		
_LIT16(KCompTagWithSpaceChars16,"Comp onent");		

_LIT8(KSubsysTagWithPunctuationChars8,"Sub-+/sy'stem");  
_LIT8(KCompTagWithPunctuationChars8,"Co*mpo<>");		

_LIT16(KSubsysTagWithPunctuationChars16,"Sub-+/sy'stem");  
_LIT16(KCompTagWithPunctuationChars16,"Co*mpo<>");		

_LIT8(KSubsysTagWithEscapeChars8,"Subsys\a\t\0tem");  // includes bell, tab and null
_LIT8(KCompTagWithEscapeChars8,"Compo\r\n\x1b\xffnent");		// includes CR, LF, ESC, and char 255

// Ini extra inputs

_LIT8(KDefaultIniFileSettings, "\r\nLOG subsystem component");
_LIT8(KTagTestsIniFileSettings, "\r\nLOG subsystem component\r\nLOG subsystem0123456 component0123456\r\nLOG subsystem01234567 component01234567\r\nLOG subsystem0123456789 component0123456789\r\nLOG subsystem0123456789012345678901234567890 component0123456789012345678901234567890\r\n");
_LIT8(KSyncTestsIniFileSettings, "\r\nSynchronous\r\nLOG subsystem component");
_LIT8(KIniFileChangeIniFileSettings,"\r\nLOG esock esock.txt\r\nLOG networking\r\n");

// Full Ini configs
_LIT8(KIniConfigWithFileAndDebugPort, "MEDIA FILE\r\nWin32Debug\r\nLOG subsystem component");
_LIT8(KIniConfigWithSerialAndDebugPort, "MEDIA SERIAL::1\r\nWin32Debug\r\nLOG subsystem component");

// String size constants
// All these are for 8-bit strings since they are used only when checking flogger output.
const TInt KTestMessageSize = 30;

#define LOGMARGINTEMPLATE			_S8("SubsystemTComponentTaTxT")
const TInt KMarginTemplateSize = sizeof(LOGMARGINTEMPLATE) - 1;

// Binary Data, lengths and data
const TInt K2KilobytesOfDataSize = 2048;

// (For the curious, this data actually comes from a fax raster font, but flattened to 1 dimension)
// followed by some data from K1KilobyteOfData. The data is 128 lines by 16 bytes.
const TUint8 K2KilobytesOfData [K2KilobytesOfDataSize] =
   
     {
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 32 
     0x00,0x00,0x18,0x3c,0x3c,0x3c,0x18,0x18,0x18,0x00,0x18,0x18,0x00,0x00,0x00,0x00 , // '!' 
     0x00,0x66,0x66,0x66,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 , // '"' 
     0x00,0x00,0x00,0x6c,0x6c,0xfe,0x6c,0x6c,0x6c,0xfe,0x6c,0x6c,0x00,0x00,0x00,0x00 , // '#' 
     0x18,0x18,0x7c,0xc6,0xc2,0xc0,0x7c,0x06,0x06,0x86,0xc6,0x7c,0x18,0x18,0x00,0x00 , // '$' 
     0x00,0x00,0x00,0x00,0xc2,0xc6,0x0c,0x18,0x30,0x60,0xc6,0x86,0x00,0x00,0x00,0x00 , // '%' 
     0x00,0x00,0x38,0x6c,0x6c,0x38,0x76,0xdc,0xcc,0xcc,0xcc,0x76,0x00,0x00,0x00,0x00 , // '&' 
     0x00,0x30,0x30,0x30,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 , // ''' 
     0x00,0x00,0x0c,0x18,0x30,0x30,0x30,0x30,0x30,0x30,0x18,0x0c,0x00,0x00,0x00,0x00 , // '(' 
     0x00,0x00,0x30,0x18,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x18,0x30,0x00,0x00,0x00,0x00 , // ')' 
     0x00,0x00,0x00,0x00,0x00,0x66,0x3c,0xff,0x3c,0x66,0x00,0x00,0x00,0x00,0x00,0x00 , // '*' 
     0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x7e,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00 , // '+' 
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x18,0x30,0x00,0x00,0x00 , // ',' 
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 , // '-' 
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00 , // '.' 
     0x00,0x00,0x00,0x00,0x02,0x06,0x0c,0x18,0x30,0x60,0xc0,0x80,0x00,0x00,0x00,0x00 , // '/' 
     0x00,0x00,0x3c,0x66,0xc3,0xc3,0xdb,0xdb,0xc3,0xc3,0x66,0x3c,0x00,0x00,0x00,0x00 , // '0' 
     0x00,0x00,0x18,0x38,0x78,0x18,0x18,0x18,0x18,0x18,0x18,0x7e,0x00,0x00,0x00,0x00 , // '1' 
     0x00,0x00,0x7c,0xc6,0x06,0x0c,0x18,0x30,0x60,0xc0,0xc6,0xfe,0x00,0x00,0x00,0x00 , // '2' 
     0x00,0x00,0x7c,0xc6,0x06,0x06,0x3c,0x06,0x06,0x06,0xc6,0x7c,0x00,0x00,0x00,0x00 , // '3' 
     0x00,0x00,0x0c,0x1c,0x3c,0x6c,0xcc,0xfe,0x0c,0x0c,0x0c,0x1e,0x00,0x00,0x00,0x00 , // '4' 
     0x00,0x00,0xfe,0xc0,0xc0,0xc0,0xfc,0x06,0x06,0x06,0xc6,0x7c,0x00,0x00,0x00,0x00 , // '5' 
     0x00,0x00,0x38,0x60,0xc0,0xc0,0xfc,0xc6,0xc6,0xc6,0xc6,0x7c,0x00,0x00,0x00,0x00 , // '6' 
     0x00,0x00,0xfe,0xc6,0x06,0x06,0x0c,0x18,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00 , // '7' 
     0x00,0x00,0x7c,0xc6,0xc6,0xc6,0x7c,0xc6,0xc6,0xc6,0xc6,0x7c,0x00,0x00,0x00,0x00 , // '8' 
     0x00,0x00,0x7c,0xc6,0xc6,0xc6,0x7e,0x06,0x06,0x06,0x0c,0x78,0x00,0x00,0x00,0x00 , // '9' 
     0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00 , // ':' 
     0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x18,0x18,0x30,0x00,0x00,0x00,0x00 , // ';' 
     0x00,0x00,0x00,0x06,0x0c,0x18,0x30,0x60,0x30,0x18,0x0c,0x06,0x00,0x00,0x00,0x00 , // '<' 
     0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00 , // '=' 
     0x00,0x00,0x00,0x60,0x30,0x18,0x0c,0x06,0x0c,0x18,0x30,0x60,0x00,0x00,0x00,0x00 , // '>' 
     0x00,0x00,0x7c,0xc6,0xc6,0x0c,0x18,0x18,0x18,0x00,0x18,0x18,0x00,0x00,0x00,0x00 , // '?' 
     0x00,0x00,0x00,0x7c,0xc6,0xc6,0xde,0xde,0xde,0xdc,0xc0,0x7c,0x00,0x00,0x00,0x00 , // '@' 
     0x00,0x00,0x10,0x38,0x6c,0xc6,0xc6,0xfe,0xc6,0xc6,0xc6,0xc6,0x00,0x00,0x00,0x00 , // 'A' 
     0x00,0x00,0xfc,0x66,0x66,0x66,0x7c,0x66,0x66,0x66,0x66,0xfc,0x00,0x00,0x00,0x00 , // 'B' 
     0x00,0x00,0x3c,0x66,0xc2,0xc0,0xc0,0xc0,0xc0,0xc2,0x66,0x3c,0x00,0x00,0x00,0x00 , // 'C' 
     0x00,0x00,0xf8,0x6c,0x66,0x66,0x66,0x66,0x66,0x66,0x6c,0xf8,0x00,0x00,0x00,0x00 , // 'D' 
     0x00,0x00,0xfe,0x66,0x62,0x68,0x78,0x68,0x60,0x62,0x66,0xfe,0x00,0x00,0x00,0x00 , // 'E' 
     0x00,0x00,0xfe,0x66,0x62,0x68,0x78,0x68,0x60,0x60,0x60,0xf0,0x00,0x00,0x00,0x00 , // 'F' 
     0x00,0x00,0x3c,0x66,0xc2,0xc0,0xc0,0xde,0xc6,0xc6,0x66,0x3a,0x00,0x00,0x00,0x00 , // 'G' 
     0x00,0x00,0xc6,0xc6,0xc6,0xc6,0xfe,0xc6,0xc6,0xc6,0xc6,0xc6,0x00,0x00,0x00,0x00 , // 'H' 
     0x00,0x00,0x3c,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3c,0x00,0x00,0x00,0x00 , // 'I' 
     0x00,0x00,0x1e,0x0c,0x0c,0x0c,0x0c,0x0c,0xcc,0xcc,0xcc,0x78,0x00,0x00,0x00,0x00 , // 'J' 
     0x00,0x00,0xe6,0x66,0x66,0x6c,0x78,0x78,0x6c,0x66,0x66,0xe6,0x00,0x00,0x00,0x00 , // 'K' 
     0x00,0x00,0xf0,0x60,0x60,0x60,0x60,0x60,0x60,0x62,0x66,0xfe,0x00,0x00,0x00,0x00 , // 'L' 
     0x00,0x00,0xc3,0xe7,0xff,0xff,0xdb,0xc3,0xc3,0xc3,0xc3,0xc3,0x00,0x00,0x00,0x00 , // 'M' 
     0x00,0x00,0xc6,0xe6,0xf6,0xfe,0xde,0xce,0xc6,0xc6,0xc6,0xc6,0x00,0x00,0x00,0x00 , // 'N' 
     0x00,0x00,0x7c,0xc6,0xc6,0xc6,0xc6,0xc6,0xc6,0xc6,0xc6,0x7c,0x00,0x00,0x00,0x00 , // 'O' 
     0x00,0x00,0xfc,0x66,0x66,0x66,0x7c,0x60,0x60,0x60,0x60,0xf0,0x00,0x00,0x00,0x00 , // 'P' 
     0x00,0x00,0x7c,0xc6,0xc6,0xc6,0xc6,0xc6,0xc6,0xd6,0xde,0x7c,0x0c,0x0e,0x00,0x00 , // 'Q' 
     0x00,0x00,0xfc,0x66,0x66,0x66,0x7c,0x6c,0x66,0x66,0x66,0xe6,0x00,0x00,0x00,0x00 , // 'R' 
     0x00,0x00,0x7c,0xc6,0xc6,0x60,0x38,0x0c,0x06,0xc6,0xc6,0x7c,0x00,0x00,0x00,0x00 , // 'S' 
     0x00,0x00,0xff,0xdb,0x99,0x18,0x18,0x18,0x18,0x18,0x18,0x3c,0x00,0x00,0x00,0x00 , // 'T' 
     0x00,0x00,0xc6,0xc6,0xc6,0xc6,0xc6,0xc6,0xc6,0xc6,0xc6,0x7c,0x00,0x00,0x00,0x00 , // 'U' 
     0x00,0x00,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0x66,0x3c,0x18,0x00,0x00,0x00,0x00 , // 'V' 
     0x00,0x00,0xc3,0xc3,0xc3,0xc3,0xc3,0xdb,0xdb,0xff,0x66,0x66,0x00,0x00,0x00,0x00 , // 'W' 
     0x00,0x00,0xc3,0xc3,0x66,0x3c,0x18,0x18,0x3c,0x66,0xc3,0xc3,0x00,0x00,0x00,0x00 , // 'X' 
     0x00,0x00,0xc3,0xc3,0xc3,0x66,0x3c,0x18,0x18,0x18,0x18,0x3c,0x00,0x00,0x00,0x00 , // 'Y' 
     0x00,0x00,0xff,0xc3,0x86,0x0c,0x18,0x30,0x60,0xc1,0xc3,0xff,0x00,0x00,0x00,0x00 , // 'Z' 
     0x00,0x00,0x3c,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3c,0x00,0x00,0x00,0x00 , // '[' 
     0x00,0x00,0x00,0x80,0xc0,0xe0,0x70,0x38,0x1c,0x0e,0x06,0x02,0x00,0x00,0x00,0x00 , // '\' 
     0x00,0x00,0x3c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x3c,0x00,0x00,0x00,0x00 , // ']' 
     0x10,0x38,0x6c,0xc6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 , // '^' 
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x00,0x00 , // '_' 
     0x30,0x30,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 , // '`' 
     0x00,0x00,0x00,0x00,0x00,0x78,0x0c,0x0c,0x7c,0xcc,0xcc,0x76,0x00,0x00,0x00,0x00 , // 'a' 
     0x00,0x00,0xe0,0x60,0x60,0x78,0x6c,0x66,0x66,0x66,0x66,0x7c,0x00,0x00,0x00,0x00 , // 'b' 
     0x00,0x00,0x00,0x00,0x00,0x7c,0xc6,0xc0,0xc0,0xc0,0xc6,0x7c,0x00,0x00,0x00,0x00 , // 'c' 
     0x00,0x00,0x1c,0x0c,0x0c,0x3c,0x6c,0xcc,0xcc,0xcc,0xcc,0x76,0x00,0x00,0x00,0x00 , // 'd' 
     0x00,0x00,0x00,0x00,0x00,0x7c,0xc6,0xc6,0xfc,0xc0,0xc2,0x7e,0x00,0x00,0x00,0x00 , // 'e' 
     0x00,0x00,0x38,0x6c,0x64,0x60,0xf0,0x60,0x60,0x60,0x60,0xf0,0x00,0x00,0x00,0x00 , // 'f' 
     0x00,0x00,0x00,0x00,0x00,0x76,0xcc,0xcc,0xcc,0xcc,0xcc,0x7c,0x0c,0xcc,0x78,0x00 , // 'g' 
     0x00,0x00,0xe0,0x60,0x60,0x6c,0x76,0x66,0x66,0x66,0x66,0xe6,0x00,0x00,0x00,0x00 , // 'h' 
     0x00,0x00,0x18,0x18,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3c,0x00,0x00,0x00,0x00 , // 'i' 
     0x00,0x00,0x06,0x06,0x00,0x0e,0x06,0x06,0x06,0x06,0x06,0x06,0x66,0x66,0x3c,0x00 , // 'j' 
     0x00,0x00,0xe0,0x60,0x60,0x66,0x6c,0x78,0x78,0x6c,0x66,0xe6,0x00,0x00,0x00,0x00 , // 'k' 
     0x00,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3c,0x00,0x00,0x00,0x00 , // 'l' 
     0x00,0x00,0x00,0x00,0x00,0xe6,0xff,0xdb,0xdb,0xdb,0xdb,0xdb,0x00,0x00,0x00,0x00 , // 'm' 
     0x00,0x00,0x00,0x00,0x00,0xdc,0x66,0x66,0x66,0x66,0x66,0x66,0x00,0x00,0x00,0x00 , // 'n' 
     0x00,0x00,0x00,0x00,0x00,0x7c,0xc6,0xc6,0xc6,0xc6,0xc6,0x7c,0x00,0x00,0x00,0x00 , // 'o' 
     0x00,0x00,0x00,0x00,0x00,0xdc,0x66,0x66,0x66,0x66,0x66,0x7c,0x60,0x60,0xf0,0x00 , // 'p' 
     0x00,0x00,0x00,0x00,0x00,0x76,0xcc,0xcc,0xcc,0xcc,0xcc,0x7c,0x0c,0x0c,0x1e,0x00 , // 'q' 
     0x00,0x00,0x00,0x00,0x00,0xdc,0x76,0x66,0x60,0x60,0x60,0xf0,0x00,0x00,0x00,0x00 , // 'r' 
     0x00,0x00,0x00,0x00,0x00,0x7c,0xc6,0x60,0x38,0x0c,0xc6,0x7c,0x00,0x00,0x00,0x00 , // 's' 
     0x00,0x00,0x10,0x30,0x30,0xfc,0x30,0x30,0x30,0x30,0x36,0x1c,0x00,0x00,0x00,0x00 , // 't' 
     0x00,0x00,0x00,0x00,0x00,0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0x76,0x00,0x00,0x00,0x00 , // 'u' 
     0x00,0x00,0x00,0x00,0x00,0xc3,0xc3,0xc3,0xc3,0x66,0x3c,0x18,0x00,0x00,0x00,0x00 , // 'v' 
     0x00,0x00,0x00,0x00,0x00,0xc3,0xc3,0xc3,0xdb,0xdb,0xff,0x66,0x00,0x00,0x00,0x00 , // 'w' 
     0x00,0x00,0x00,0x00,0x00,0xc3,0x66,0x3c,0x18,0x3c,0x66,0xc3,0x00,0x00,0x00,0x00 , // 'x' 
     0x00,0x00,0x00,0x00,0x00,0xc6,0xc6,0xc6,0xc6,0xc6,0xc6,0x7e,0x06,0x0c,0xf8,0x00 , // 'y' 
     0x00,0x00,0x00,0x00,0x00,0xfe,0xcc,0x18,0x30,0x60,0xc6,0xfe,0x00,0x00,0x00,0x00 , // 'z' 
     0x00,0x00,0x0e,0x18,0x18,0x18,0x70,0x18,0x18,0x18,0x18,0x0e,0x00,0x00,0x00,0x00 , // ' ' 
     0x00,0x00,0x18,0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,0x00 , // '|' 
     0x00,0x00,0x70,0x18,0x18,0x18,0x0e,0x18,0x18,0x18,0x18,0x70,0x00,0x00,0x00,0x00 , // ' ' 
     0x00,0x00,0x76,0xdc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 , // '~' 
     0x00,0x00,0x00,0x00,0x10,0x38,0x6c,0xc6,0xc6,0xc6,0xfe,0x00,0x00,0x00,0x00,0x00 ,  // 128 
     0x00,0x00,0x00,0x00,0x10,0x38,0x6c,0xc6,0xc6,0xc6,0xfe,0x00,0x00,0x00,0x00,0x00 ,
     0x00,0x00,0x00,0x00,0x10,0x38,0x6c,0xc6,0xc6,0xc6,0xfe,0x00,0x00,0x00,0x00,0x00 ,
     0x00,0x00,0x00,0x00,0x10,0x38,0x6c,0xc6,0xc6,0xc6,0xfe,0x00,0x00,0x00,0x00,0x00 ,
     0x00,0x00,0x00,0x00,0x10,0x38,0x6c,0xc6,0xc6,0xc6,0xfe,0x00,0x00,0x00,0x00,0x00 ,
     0x00,0x00,0x00,0x00,0x10,0x38,0x6c,0xc6,0xc6,0xc6,0xfe,0x00,0x00,0x00,0x00,0x00 ,
     0x00,0x00,0x00,0x00,0x10,0x38,0x6c,0xc6,0xc6,0xc6,0xfe,0x00,0x00,0x00,0x00,0x00 ,
     0x00,0x00,0x00,0x00,0x10,0x38,0x6c,0xc6,0xc6,0xc6,0xfe,0x00,0x00,0x00,0x00,0x00 ,
     0xFF,0x75,0x0C,0xFF,0x75,0x08,0x8D,0x4D,0xE4,0xE8,0x43,0x06,0x00,0x00,0x8D,0x4D,
     0xE4,0xE8,0xC1,0xF9,0xFF,0xFF,0x8D,0x4D,0xE4,0xE8,0x71,0xF8,0xFF,0xFF,0xEB,0x00,
     0x8D,0x65,0xFC,0x5B,0x5D,0xC3,0x55,0x89,0xE5,0x83,0xEC,0x08,0xB8,0xCC,0xCC,0xCC,
     0xCC,0x89,0x04,0x24,0x89,0x44,0x24,0x04,0x8D,0x55,0x10,0x83,0xC2,0x04,0x89,0x55,
     0xFC,0x8D,0x45,0xFC,0x50,0xFF,0x75,0x10,0xFF,0x75,0x0C,0xFF,0x75,0x08,0xE8,0x2A,
     0x07,0x00,0x00,0x83,0xC4,0x10,0xC9,0xC3,0x55,0x89,0xE5,0xFF,0x75,0x14,0xFF,0x75,
     0x10,0xFF,0x75,0x0C,0xFF,0x75,0x08,0xE8,0x11,0x07,0x00,0x00,0x83,0xC4,0x10,0xC9,
     0xC3,0x55,0x89,0xE5,0x83,0xEC,0x30,0x57,0xB8,0xCC,0xCC,0xCC,0xCC,0x8D,0x7C,0x24,
     0x04,0xB9,0x0C,0x00,0x00,0x00,0xF3,0xAB,0x5F,0x6A,0x10,0x8D,0x4D,0xD0,0xE8,0xF1,
     0x59,0x00,0x00,0xFF,0x75,0x0C,0x8D,0x45,0xD0,0x50,0xE8,0xEB,0x59,0x00,0x00,0x59,
     0xE8,0x50,0xE8,0xD3,0x59,0x00,0x00,0x59,0x59,0xFF,0x75,0x14,0x8D,0x45,0xD0,0x50,
     0x8D,0x45,0xE8,0x50,0xE8,0xAC,0xFD,0xFF,0xFF,0x83,0xC4,0x0C,0xC9,0xC3,0x55,0x89,
     0xE5,0x83,0xEC,0x38,0x57,0xB8,0xCC,0xCC,0xCC,0xCC,0x8D,0x7C,0x24,0x04,0xB9,0x0E,
     0x00,0x00,0x00,0xF3,0xAB,0x5F,0xBA,0x00,0x00,0x00,0x00,0x89,0x55,0x10,0x8D,0x55,
     0x14,0x83,0xC2,0x04,0x89,0x55,0xCC,0x6A,0x10,0x8D,0x4D,0xD0,0xE8,0x83,0x59,0x00,
     0x00,0xFF,0x75,0x0C,0x8D,0x45,0xD0,0x50,0xE8,0x7D,0x59,0x00,0x00,0x59,0x59,0x6A,
     0x10,0x8D,0x4D,0xE8,0xE8,0x6B,0x59,0x00,0x00,0xFF,0x75,0x08,0x8D,0x45,0xE8,0x50,
     0xE8,0x65,0x59,0x00,0x00,0x59,0x59,0x8D,0x45,0xCC,0x50,0xFF,0x75,0x14,0x8D,0x45,
     0xD0,0x50,0x8D,0x45,0xE8,0x50,0xE8,0x70,0x05,0x00,0x00,0x83,0xC4,0x10,0xC9,0xC3,
     0x55,0x89,0xE5,0x83,0xEC,0x30,0x57,0xB8,0xCC,0xCC,0xCC,0xCC,0x8D,0x7C,0x24,0x04,
     0xB9,0x0C,0x00,0x00,0x00,0xF3,0xAB,0x5F,0x6A,0x10,0x8D,0x4D,0xD0,0xE8,0x22,0x59,
     0x00,0x00,0xFF,0x75,0x0C,0x8D,0x45,0xD0,0x50,0xE8,0x1C,0x59,0x00,0x00,0x59,0x59,
     0x6A,0x10,0x8D,0x4D,0xE8,0xE8,0x0A,0x59,0x00,0x00,0xFF,0x75,0x08,0x8D,0x45,0xE8,
     0x50,0xE8,0x04,0x59,0x00,0x00,0x59,0x59,0xFF,0x75,0x18,0xFF,0x75,0x14,0x8D,0x45,
     0xD0,0x50,0x8D,0x45,0xE8,0x50,0xE8,0x10,0x05,0x00,0x00,0x83,0xC4,0x10,0xC9,0xC3
     };
  
  

const TInt K1KilobyteOfDataSize = 1000;

// This data has 256 byte section listing every character from 00 to FF, but not in order, at the end.
// The rest of the data is a dump of a section of the Flogger.DLL. 62.5 lines by 16 bytes.
const TUint8 K1KilobyteOfData [K1KilobyteOfDataSize] =
	{
  0xFF,0x75,0x0C,0xFF,0x75,0x08,0x8D,0x4D,0xE4,0xE8,0x43,0x06,0x00,0x00,0x8D,0x4D,
  0xE4,0xE8,0xC1,0xF9,0xFF,0xFF,0x8D,0x4D,0xE4,0xE8,0x71,0xF8,0xFF,0xFF,0xEB,0x00,
  0x8D,0x65,0xFC,0x5B,0x5D,0xC3,0x55,0x89,0xE5,0x83,0xEC,0x08,0xB8,0xCC,0xCC,0xCC,
  0xCC,0x89,0x04,0x24,0x89,0x44,0x24,0x04,0x8D,0x55,0x10,0x83,0xC2,0x04,0x89,0x55,
  0xFC,0x8D,0x45,0xFC,0x50,0xFF,0x75,0x10,0xFF,0x75,0x0C,0xFF,0x75,0x08,0xE8,0x2A,
  0x07,0x00,0x00,0x83,0xC4,0x10,0xC9,0xC3,0x55,0x89,0xE5,0xFF,0x75,0x14,0xFF,0x75,
  0x10,0xFF,0x75,0x0C,0xFF,0x75,0x08,0xE8,0x11,0x07,0x00,0x00,0x83,0xC4,0x10,0xC9,
  0xC3,0x55,0x89,0xE5,0x83,0xEC,0x30,0x57,0xB8,0xCC,0xCC,0xCC,0xCC,0x8D,0x7C,0x24,
  0x04,0xB9,0x0C,0x00,0x00,0x00,0xF3,0xAB,0x5F,0x6A,0x10,0x8D,0x4D,0xD0,0xE8,0xF1,
  0x59,0x00,0x00,0xFF,0x75,0x0C,0x8D,0x45,0xD0,0x50,0xE8,0xEB,0x59,0x00,0x00,0x59,
  0xE8,0x50,0xE8,0xD3,0x59,0x00,0x00,0x59,0x59,0xFF,0x75,0x14,0x8D,0x45,0xD0,0x50,
  0x8D,0x45,0xE8,0x50,0xE8,0xAC,0xFD,0xFF,0xFF,0x83,0xC4,0x0C,0xC9,0xC3,0x55,0x89,
  0xE5,0x83,0xEC,0x38,0x57,0xB8,0xCC,0xCC,0xCC,0xCC,0x8D,0x7C,0x24,0x04,0xB9,0x0E,
  0x00,0x00,0x00,0xF3,0xAB,0x5F,0xBA,0x00,0x00,0x00,0x00,0x89,0x55,0x10,0x8D,0x55,
  0x14,0x83,0xC2,0x04,0x89,0x55,0xCC,0x6A,0x10,0x8D,0x4D,0xD0,0xE8,0x83,0x59,0x00,
  0x00,0xFF,0x75,0x0C,0x8D,0x45,0xD0,0x50,0xE8,0x7D,0x59,0x00,0x00,0x59,0x59,0x6A,
  0x10,0x8D,0x4D,0xE8,0xE8,0x6B,0x59,0x00,0x00,0xFF,0x75,0x08,0x8D,0x45,0xE8,0x50,
  0xE8,0x65,0x59,0x00,0x00,0x59,0x59,0x8D,0x45,0xCC,0x50,0xFF,0x75,0x14,0x8D,0x45,
  0xD0,0x50,0x8D,0x45,0xE8,0x50,0xE8,0x70,0x05,0x00,0x00,0x83,0xC4,0x10,0xC9,0xC3,
  0x55,0x89,0xE5,0x83,0xEC,0x30,0x57,0xB8,0xCC,0xCC,0xCC,0xCC,0x8D,0x7C,0x24,0x04,
  0xB9,0x0C,0x00,0x00,0x00,0xF3,0xAB,0x5F,0x6A,0x10,0x8D,0x4D,0xD0,0xE8,0x22,0x59,
  0x00,0x00,0xFF,0x75,0x0C,0x8D,0x45,0xD0,0x50,0xE8,0x1C,0x59,0x00,0x00,0x59,0x59,
  0x6A,0x10,0x8D,0x4D,0xE8,0xE8,0x0A,0x59,0x00,0x00,0xFF,0x75,0x08,0x8D,0x45,0xE8,
  0x50,0xE8,0x04,0x59,0x00,0x00,0x59,0x59,0xFF,0x75,0x18,0xFF,0x75,0x14,0x8D,0x45,
  0xD0,0x50,0x8D,0x45,0xE8,0x50,0xE8,0x10,0x05,0x00,0x00,0x83,0xC4,0x10,0xC9,0xC3,
  0x55,0x89,0xE5,0x83,0xEC,0x30,0x57,0xB8,0xCC,0xCC,0xCC,0xCC,0x8D,0x7C,0x24,0x04,
  0xB9,0x0C,0x00,0x00,0x00,0xF3,0xAB,0x5F,0x6A,0x10,0x8D,0x4D,0xD0,0xE8,0xC2,0x58,
  0x00,0x00,0xFF,0x75,0x0C,0x8D,0x45,0xD0,0x50,0xE8,0xBC,0x58,0x00,0x00,0x59,0x59,
  0x6A,0x10,0x8D,0x4D,0xE8,0xE8,0xAA,0x58,0x00,0x00,0xFF,0x75,0x08,0x8D,0x45,0xE8,
  0x50,0xE8,0xA4,0x58,0x00,0x00,0x59,0x59,0xFF,0x75,0x14,0x8D,0x45,0xD0,0x50,0x8D,
  0x45,0xE8,0x50,0xE8,0x9E,0xFD,0xFF,0xFF,0x83,0xC4,0x0C,0xC9,0xC3,0x55,0x89,0xE5,
  0x83,0xEC,0x38,0x57,0xB8,0xCC,0xCC,0xCC,0xCC,0x8D,0x7C,0x24,0x04,0xB9,0x0E,0x00,
  0x00,0x00,0xF3,0xAB,0x5F,0xBA,0x00,0x00,0x00,0x00,0x89,0x55,0x10,0x8D,0x55,0x14,
  0x83,0xC2,0x04,0x89,0x55,0xCC,0x6A,0x10,0x8D,0x4D,0xD0,0xE8,0x54,0x58,0x00,0x00,
  0xFF,0x75,0x0C,0x8D,0x45,0xD0,0x50,0xE8,0x4E,0x58,0x00,0x00,0x59,0x59,0x6A,0x10,
  0x8D,0x4D,0xE8,0xE8,0x3C,0x58,0x00,0x00,0xFF,0x75,0x08,0x8D,0x45,0xE8,0x50,0xE8,
  0x36,0x58,0x00,0x00,0x59,0x59,0x8D,0x45,0xCC,0x50,0xFF,0x75,0x14,0x8D,0x45,0xD0,
  0x50,0x8D,0x45,0xE8,0x50,0xE8,0x13,0x05,0x00,0x00,0x83,0xC4,0x10,0xC9,0xC3,0x55,
  0x89,0xE5,0x83,0xEC,0x30,0x57,0xB8,0xCC,0xCC,0xCC,0xCC,0x8D,0x7C,0x24,0x04,0xB9,
  0x0C,0x00,0x00,0x00,0xF3,0xAB,0x5F,0x6A,0x10,0x8D,0x4D,0xD0,0xE8,0xF3,0x57,0x00,
  0x00,0xFF,0x75,0x0C,0x8D,0x45,0xD0,0x50,0xE8,0xED,0x57,0x00,0x00,0x59,0x59,0x6A,
  0x10,0x8D,0x4D,0xE8,0xE8,0xDB,0x57,0x00,0x00,0xFF,0x75,0x08,0x8D,0x45,0xE8,0x50,
  0xE8,0xD5,0x57,0x00,0x00,0x59,0x59,0xFF,0x75,0x18,0xFF,0x75,0x14,0x8D,0x45,0xD0,
  0x50,0x8D,0x45,0xE8,0x50,0xE8,0xB3,0x04,0x00,0x00,0x83,0xC4,0x10,0xC9,0xC3,0x55,
  0x89,0xE5,0x83,0xEC,0x08,0xB8,0xCC,0xCC,0xCC,0xCC,0x89,0x04,0x24,0x89,0x44,0x24,
  0x04,0x89,0x4D,0xFC,0x8B,0x45,0xFC,0x83,0x78,0x04,0x00,0x74,0x22,0x8B,0x45,0xFC,
  0x00,0x80,0x40,0xC0,0x20,0xA0,0x60,0xE0,0x10,0x90,0x50,0xD0,0x30,0xB0,0x70,0xF0,  // start of listing of every character
  0x08,0x88,0x48,0xC8,0x28,0xA8,0x68,0xE8,0x18,0x98,0x58,0xD8,0x38,0xB8,0x78,0xF8,
  0x04,0x84,0x44,0xC4,0x24,0xA4,0x64,0xE4,0x14,0x94,0x54,0xD4,0x34,0xB4,0x74,0xF4,
  0x0C,0x8C,0x4C,0xCC,0x2C,0xAC,0x6C,0xEC,0x1C,0x9C,0x5C,0xDC,0x3C,0xBC,0x7C,0xFC,
  0x02,0x82,0x42,0xC2,0x22,0xA2,0x62,0xE2,0x12,0x92,0x52,0xD2,0x32,0xB2,0x72,0xF2,
  0x0A,0x8A,0x4A,0xCA,0x2A,0xAA,0x6A,0xEA,0x1A,0x9A,0x5A,0xDA,0x3A,0xBA,0x7A,0xFA,
  0x06,0x86,0x46,0xC6,0x26,0xA6,0x66,0xE6,0x16,0x96,0x56,0xD6,0x36,0xB6,0x76,0xF6,
  0x0E,0x8E,0x4E,0xCE,0x2E,0xAE,0x6E,0xEE,0x1E,0x9E,0x5E,0xDE,0x3E,0xBE,0x7E,0xFE,
  0x01,0x81,0x41,0xC1,0x21,0xA1,0x61,0xE1,0x11,0x91,0x51,0xD1,0x31,0xB1,0x71,0xF1,
  0x09,0x89,0x49,0xC9,0x29,0xA9,0x69,0xE9,0x19,0x99,0x59,0xD9,0x39,0xB9,0x79,0xF9,
  0x05,0x85,0x45,0xC5,0x25,0xA5,0x65,0xE5,0x15,0x95,0x55,0xD5,0x35,0xB5,0x75,0xF5,
  0x0D,0x8D,0x4D,0xCD,0x2D,0xAD,0x6D,0xED,0x1D,0x9D,0x5D,0xDD,0x3D,0xBD,0x7D,0xFD,
  0x03,0x83,0x43,0xC3,0x23,0xA3,0x63,0xE3,0x13,0x93,0x53,0xD3,0x33,0xB3,0x73,0xF3,
  0x0B,0x8B,0x4B,0xCB,0x2B,0xAB,0x6B,0xEB,0x1B,0x9B,0x5B,0xDB,0x3B,0xBB,0x7B,0xFB,
  0x07,0x87,0x47,0xC7,0x27,0xA7,0x67,0xE7,0x17,0x97,0x57,0xD7,0x37,0xB7,0x77,0xF7,
  0x0F,0x8F,0x4F,0xCF,0x2F,0xAF,0x6F,0xEF,0x1F,0x9F,0x5F,0xDF,0x3F,0xBF,0x7F,0xFF,
  0x0F,0x8F,0x4F,0xCF,0x2F,0xAF,0x6F,0xEF
   } ;





#endif //__TEST_MESSAGE_H__
