// Copyright (c) 2004-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of the License "Symbian Foundation License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#include <e32cons.h>
#include <bacline.h>

#include "keytool_utils.h"
#include "keytool_view_imp.h"
#include "keytool_commands.h"
#include "certtool_controller.h"
#include "keytoolfileview.h"


// Boiler plate 
_LIT(KShortName, "Symbian OS CertTool");
_LIT(KName, "Symbian OS CertStore Manipulation Tool");
_LIT(KCopyright, "Copyright (c) 2004-2007 Symbian Software Ltd.  All rights reserved.");

_LIT(KNewLine, "\n");

_LIT(KDone, "Press any key to continue... \n");

// CertTool command line parameters
_LIT(KList, "-list");
_LIT(KListShort, "-l");

_LIT(KListStores, "-liststores");
_LIT(KListStoresShort, "-ls");

_LIT(KImport, "-import");
_LIT(KImportShort, "-i");

_LIT(KPrivate, "-private");


_LIT(KSetApps, "-setapps");
_LIT(KSetAppsShort, "-s");

_LIT(KAddApps, "-addapps");
_LIT(KAddAppsShort, "-a");

_LIT(KApps, "-apps");

_LIT(KRemoveApps, "-removeapps");

_LIT(KRemove, "-remove");
_LIT(KRemoveShort, "-r");

// remove private key also while removing the certificate
// which is applicable iff the key is imported using the certool -private option

_LIT(KRemoveKeyAlso, "-rka");

_LIT(KStore, "-store");

_LIT(KHelp, "-help");
_LIT(KHelpShort, "-h");

// Command parameters
_LIT(KLabel, "-label");

_LIT(KDetails, "-details");
_LIT(KDetailsShort, "-d");

_LIT(KOwnerType, "-owner");
_LIT(KOwnerTypeShort, "-o");

_LIT(KPageWise, "-page");
_LIT(KPageWiseShort, "-p");

_LIT(KUids, "-uids");

const TInt KMaxArgs = 10;

/**
 * Displays tool name and copyright informations.
 */
LOCAL_D void BoilerPlateL(CConsoleBase* console) 
	{
	console->Printf(KNewLine);
	console->Printf(KName);
	console->Printf(KNewLine);	
	console->Printf(KCopyright);
	console->Printf(KNewLine);
	console->Printf(KNewLine);	
	}

LOCAL_D TBool VerifyCommand(const TDesC& aCommand, TInt& aCmdNum, TInt& aCmdCount)
	{
	if ((aCmdNum != -1) && (aCommand[0] == '-'))
		{
		aCmdNum = CertToolDefController::KUsageCommand;
		aCmdCount = KMaxArgs;
		return 1;
		}
	if (aCommand.CompareF(KList) == 0 || aCommand.Compare(KListShort) == 0)
		{
		aCmdNum = CertToolDefController::KListCommand;
		}
	else if (aCommand.CompareF(KListStores) == 0 || aCommand.Compare(KListStoresShort) == 0)
		{
		aCmdNum = CertToolDefController::KListStoresCommand;
		}
	else if	(aCommand.CompareF(KImport) == 0 || aCommand.Compare(KImportShort) == 0)
		{
		aCmdNum = CertToolDefController::KImportCommand;
		}
	else if	(aCommand.CompareF(KRemove) == 0 || aCommand.Compare(KRemoveShort) == 0)
		{
		aCmdNum = CertToolDefController::KRemoveCommand;
		}
	else if	(aCommand.CompareF(KSetApps) == 0 || aCommand.Compare(KSetAppsShort) == 0)
		{
		aCmdNum = CertToolDefController::KSetAppsCommand;
		}
	else if	(aCommand.CompareF(KAddApps) == 0 || aCommand.Compare(KAddAppsShort) == 0)
		{
		aCmdNum = CertToolDefController::KAddAppsCommand;
		}
	else if	(aCommand.CompareF(KRemoveApps) == 0 )
		{
		aCmdNum = CertToolDefController::KRemoveAppsCommand;
		}
	else	
		{
		return 0;
		}

	return 1;
	}
	
/**
 * Parses the command line and given control to the handler to deal with the request.
 */
LOCAL_D void DoMainL() 
	{
	TBool interactiveMode = ETrue;
	
	RFs fs;
	User::LeaveIfError(fs.Connect());
	CleanupClosePushL(fs);
	
	CConsoleBase* console = Console::NewL(KShortName, TSize(KConsFullScreen, KConsFullScreen));
	CleanupStack::PushL(console);
	CCommandLineArguments* cmdArgs = CCommandLineArguments::NewLC();
	TInt cmdArgsCount = cmdArgs->Count();
	
	RFile file;
	// command: certtool inputfile outputfile
	if (cmdArgsCount == 3)
		{
		if (KeyToolUtils::DoesFileExistsL(fs,cmdArgs->Arg(1)))
		  	{
		  	interactiveMode = EFalse;
		  	TInt error = file.Open(fs, cmdArgs->Arg(1), EFileRead|EFileShareAny);
		  	file.Close();
		  	TInt error1 = file.Replace(fs, cmdArgs->Arg(2), EFileWrite|EFileShareExclusive);
		  	CleanupClosePushL(file);
		  	// If the input file doesn't exist or not able to create outputfile
		  	// switch to Interactive mode
		  	if (error != KErrNone || error1 != KErrNone)
		   		{
			   	CleanupStack::PopAndDestroy(&file);
			   	interactiveMode = ETrue;
			  	}	
				
			}
		}
		
	CKeytoolConsoleView* view = CKeytoolConsoleView::NewLC(*console);
	CCertToolController* controller = CCertToolController::NewLC(*view);
	CArrayFixFlat<TPtrC>* args = new (ELeave) CArrayFixFlat<TPtrC> (10);
	CleanupStack::PushL(args);
	CKeytoolFileView* view1 = NULL;

	TInt cmdCount = 0;
	if (interactiveMode)
		{
		KeyToolUtils::SetConsole(console);
		BoilerPlateL(console);
		for (TInt i = 0; i < cmdArgsCount; i++)
			{
			args->AppendL(cmdArgs->Arg(i));
			}
		// In Interactive mode by default we can execute 1 command only.
		cmdCount = 1;
		}
	else
		{
		CleanupStack::PopAndDestroy(3, view); // args, controller, view
		KeyToolUtils::SetFile(&file);
		view1 = CKeytoolFileView::NewLC(cmdArgs->Arg(1));
		cmdCount = view1->SplitFileInputToArrayL();
		}	
	
	for (TInt j = 0; j < cmdCount; j++)
		{
		if (!interactiveMode)
			{
			controller = CCertToolController::NewLC(*view1);
			args = view1->ReadArrayArgumentsLC(j);
			}

		CKeyToolParameters* params = CKeyToolParameters::NewLC();
		
		TInt command = -1; 
		TInt i = -1;
		
		TInt argsCount = args->Count();
		while (i < (argsCount-1))
		 	{
		 	i++;
			if ((args->At(i).CompareF(KDetails)==0)|| (args->At(i).Compare(KDetailsShort)==0))
				{
				params->iIsDetailed = ETrue;
				continue;
				}
	
			if (args->At(i).CompareF(KPageWise)==0 || (args->At(i).Compare(KPageWiseShort)==0))
				{
				i++;
				params->iPageWise = ETrue;
				continue;
				}

			if (args->At(i).Compare(KRemoveKeyAlso)==0)
				{
				params->iRemoveKey = ETrue;
				continue;
				}

			if (args->At(i).CompareF(KApps)==0)
				{
				i++;
				RArray<TUid> apps;
				TInt k = 0;
				for (k = i; k < argsCount; k++)
					{				
					if (args->At(k).Find(_L("-")) == KErrNotFound)
						{
						TUint uid;
						if (args->At(k).CompareF(KSWInstall)==0)
							{
							uid = swinstalluid;
							}
						else
							{
							if (args->At(k).CompareF(KSWInstallOCSP)==0)
								{
								uid = swinstallocspuid;
								}
							else
								{
								if (args->At(k).CompareF(KMidletInstall)==0)
									{
									uid = midletinstalluid;
									}
								else
									{
									if (args->At(k).CompareF(KTls)==0)
										{
										uid = tlsuid;
										}
									else
										{
										// no more valid apps, break cycle
										break;
										}
									}
								}
							}
						apps.Append(TUid::Uid(uid));						
						}
					else 
						{
						// We parsed all UIDs, break the cycle and go on!
						break;
						}
					}
				i = k-1;
				params->iUIDs = apps; // We pass on ownership
				params->iIsDetailed = ETrue;
				continue;			
				}
		
			if (args->At(i).CompareF(KUids)==0)
				{
				i++;
				RArray<TUid> uids;
				TInt k = 0;
				for (k = i; k < argsCount; k++)
					{				
					if (args->At(k).Left(2) == _L("0x"))
						{
						TLex lex(args->At(k).Mid(2));		
						TUint uid =0;
						TInt err = lex.Val(uid, EHex);
						if (err == KErrNone)
							{
							params->iUIDs.Append(TUid::Uid(uid));						
							}			 
						}
					else 
						{
						// We parsed all UIDs, break the cycle and go on!
						break;
						}
					}
				i = k-1;
				params->iIsDetailed = ETrue;
				continue;			
				}
			
			TDesC& cmd = args->At(i);
			if (cmd.CompareF(KLabel) == 0 || 
			    cmd.CompareF(KPrivate) == 0 || cmd.CompareF(KStore) == 0 ||
			    cmd.CompareF(KOwnerType) == 0 || cmd.Compare(KOwnerTypeShort) == 0 ||
			    cmd.CompareF(KHelp) == 0 || cmd.Compare(KHelpShort) == 0 )
				{
				i++;
				if (i >= argsCount || args->At(i)[0] == '-')
					{
					i = argsCount;
					command = CertToolDefController::KUsageCommand;
					}
				else if (cmd.CompareF(KHelp) == 0 || cmd.Compare(KHelpShort) == 0)
					{
					params->iDefault = args->At(i).AllocL();
					i = argsCount;	
					}
				else if (cmd.CompareF(KLabel) == 0)
					{
					params->iLabel = args->At(i).AllocL();
					}
				else if (cmd.CompareF(KPrivate) == 0)
					{
					params->iPrivate = args->At(i).AllocL();
					}
				else if (cmd.CompareF(KStore) == 0)
					{
					TLex parser(args->At(i));
					TInt err = parser.Val(params->iCertstoreIndex);
					params->iIsDetailed = ETrue;
					}
				else if (cmd.CompareF(KOwnerType) == 0 || cmd.Compare(KOwnerTypeShort) == 0)
					{
					params->iIsDetailed = ETrue;
					params->iOwnerType = args->At(i).AllocL();
					}
				else
					{
					// no action required	
					}
				continue;
				}
	
			if (VerifyCommand(args->At(i), command, i))
				{
				continue;
				}

				
			if (i!=0) 
				{
				if (args->At(i)[0] == '-')
					{
					i = argsCount;
					command = CertToolDefController::KUsageCommand;
					continue;
					}
				delete params->iDefault;
				params->iDefault = NULL;
				params->iDefault = args->At(i).AllocL();
				params->iIsDetailed = ETrue;			
				}
		 	} 
		 
		 
		if (command != -1)
			{
			TRAP_IGNORE(controller->HandleCommandL(command, params));
			}
		else 
			{
			controller->HandleCommandL(CertToolDefController::KUsageCommand, params);		
			}
		CleanupStack::PopAndDestroy(3, controller); // params, args, controller
		}
	if (interactiveMode)
		{
		CleanupStack::PopAndDestroy(view);
		// We are done!
		console->Printf(KNewLine);
		console->Printf(KDone);
		console->Getch();	
		}
	else
		{
		CleanupStack::PopAndDestroy(2, &file); //view1 and file
		}
	CleanupStack::PopAndDestroy(3, &fs); //cmdArgs, console, fs
	}
	

GLDEF_C TInt E32Main()         // main function called by E32
   	{
	__UHEAP_MARK;
	CTrapCleanup* cleanup=CTrapCleanup::New(); 
	
	TRAP_IGNORE(DoMainL());
	
	delete cleanup; 
	__UHEAP_MARKEND;
	return 0; 
   	}
