/*
* Copyright (c) 2006-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
* Random generator interface
*
*/


/**
 @file
 @publishedPartner
 @released
*/

#ifndef __CRYPTOAPI_RANDOMPLUGIN_H__
#define __CRYPTOAPI_RANDOMPLUGIN_H__

#include <cryptospi/cryptoplugin.h>

namespace CryptoSpi
	{
	/**
	A cryptographically secure pseudo-random number generator (CSPRNG)
	Generates random numbers derived from entropy obtained from another
	source, usually a hardware random number generator or if unavailable,
	from a combination variety of unpredictable system variables, added
	to an entropy pool which is used for seeding. This might include
	keypresses generated by a user, hardware interrupts, etc.
	*/
	class MRandom : public MPlugin
	    {
	    public:
	        /**
	        Generate enough random bytes to fill the supplied descriptor
	        If there is not enough entropy available, or another error
	        occurs (e.g. out of memory) then this method may leave.
	        @param aDest The returned generated random bytes
	        */
	        virtual void GenerateRandomBytesL(TDes8& aDest) = 0;
	    };


	class MAsyncRandom : public MPlugin
	    {
	    public:
	        /**
	        Generate enough random bytes to fill the supplied descriptor
	        If there is not enough entropy available, or another error
	        occurs (e.g. out of memory) then this method may leave.
	        @param aDest The returned generated random bytes
	        */
	        virtual void GenerateRandomBytesL(TDes8& aDest, TRequestStatus& aStatus) = 0;

	        /**
	        Cancel an outstanding request
	        */
	        virtual void Cancel() = 0;
	    };
	
	}

#endif  // __CRYPTOAPI_RANDOMPLUGIN_H__
