/*
* Copyright (c) 2006-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
* Random generator interface
*
*/


/**
 @file
 @publishedPartner
 @released
*/

#ifndef __CRYPTOAPI_RANDOMPLUGIN_H__
#define __CRYPTOAPI_RANDOMPLUGIN_H__

#include <cryptospi/cryptoplugin.h>

namespace CryptoSpi
	{
	/**
	A pseudo-random number generator (PRNG).
	Generates random numbers derived from entropy obtained from another
	source, usually a hardware random number generator or if unavailable,
	from a combination variety of unpredictable system variables, added
	to an entropy pool which is used for seeding. This might include
	keypresses generated by a user, hardware interrupts, etc.
	*/
	class MRandom : public MPlugin
	    {
	    public:
	        /**
	         * Implementations of this method should fill the passed
	         * buffer with the generated pseudo-random data up to the
	         * current length, discarding any current contents. The 
	         * implementations should leave with KErrNotSecure when 
	         * the generated random data is not secure enough. 
	         *
	         * @param aDest The buffer to fill with random data
	         * @leave KErrNotSecure Random data generated is not 
	         *        secure enough for crytographic operations
	         *        otherwise, leaves with any other system wide error code.
	         *
	         */
	        virtual void GenerateRandomBytesL(TDes8& aDest) = 0;
	    };


	class MAsyncRandom : public MPlugin
	    {
	    public:
	        /**
	         * Implementations of this method should fill the passed
	         * buffer with the generated pseudo-random data up to the
	         * current length, discarding any current contents. The 
	         * implementations should leave with KErrNotSecure when 
	         * the generated random data is not secure enough. 
	         *
	         * @param aDest The buffer to fill with random data
	         * @param aStatus The argument to carry the asynchonous request completion
	         *        status to notify the client when buffer is filled with random data.  
	         * @leave KErrNotSecure Random data generated is not 
	         *        secure enough for crytographic operations
	         *        otherwise, leaves with any other system wide error code.
	         *
	         */
	        virtual void GenerateRandomBytesL(TDes8& aDest, TRequestStatus& aStatus) = 0;

	        /**
	        Cancel an outstanding request
	        */
	        virtual void Cancel() = 0;
	    };
	
	}

#endif  // __CRYPTOAPI_RANDOMPLUGIN_H__
