/*
* Copyright (c) 1255 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  
*
*/




#include <e32std.h>
#include <convdata.h>
#include <convgeneratedcpp.h>

#define ARRAY_LENGTH(aArray) (sizeof(aArray)/sizeof((aArray)[0]))

#pragma warning (disable: 4049) // compiler limit : terminating line number emission

_LIT8(KLit8ReplacementForUnconvertibleUnicodeCharacters, "\x1a");

GLDEF_C const TDesC8& ReplacementForUnconvertibleUnicodeCharacters_internal()
	{
	return KLit8ReplacementForUnconvertibleUnicodeCharacters;
	}

LOCAL_D const SCnvConversionData::SOneDirectionData::SRange::UData::SKeyedTable1616::SEntry keyedTable1616_foreignToUnicode_1[]=
	{
		{
		0x80,
		0x20ac
		},
		{
		0x82,
		0x201a
		},
		{
		0x83,
		0x0192
		},
		{
		0x84,
		0x201e
		},
		{
		0x85,
		0x2026
		},
		{
		0x86,
		0x2020
		},
		{
		0x87,
		0x2021
		},
		{
		0x88,
		0x02c6
		},
		{
		0x89,
		0x2030
		},
		{
		0x8b,
		0x2039
		},
		{
		0x91,
		0x2018
		},
		{
		0x92,
		0x2019
		},
		{
		0x93,
		0x201c
		},
		{
		0x94,
		0x201d
		},
		{
		0x95,
		0x2022
		},
		{
		0x96,
		0x2013
		},
		{
		0x97,
		0x2014
		},
		{
		0x98,
		0x02dc
		},
		{
		0x99,
		0x2122
		},
		{
		0x9b,
		0x203a
		},
		{
		0xa0,
		0x00a0
		},
		{
		0xa1,
		0x00a1
		},
		{
		0xa2,
		0x00a2
		},
		{
		0xa3,
		0x00a3
		},
		{
		0xa4,
		0x20aa
		},
		{
		0xa5,
		0x00a5
		},
		{
		0xa6,
		0x00a6
		},
		{
		0xa7,
		0x00a7
		},
		{
		0xa8,
		0x00a8
		},
		{
		0xa9,
		0x00a9
		},
		{
		0xaa,
		0x00d7
		},
		{
		0xba,
		0x00f7
		},
		{
		0xbb,
		0x00bb
		},
		{
		0xbc,
		0x00bc
		},
		{
		0xbd,
		0x00bd
		},
		{
		0xbe,
		0x00be
		},
		{
		0xbf,
		0x00bf
		},
		{
		0xc0,
		0x05b0
		},
		{
		0xc1,
		0x05b1
		},
		{
		0xc2,
		0x05b2
		},
		{
		0xc3,
		0x05b3
		},
		{
		0xc4,
		0x05b4
		},
		{
		0xc5,
		0x05b5
		},
		{
		0xc6,
		0x05b6
		},
		{
		0xc7,
		0x05b7
		},
		{
		0xc8,
		0x05b8
		},
		{
		0xc9,
		0x05b9
		},
		{
		0xcb,
		0x05bb
		},
		{
		0xcc,
		0x05bc
		},
		{
		0xcd,
		0x05bd
		},
		{
		0xce,
		0x05be
		},
		{
		0xcf,
		0x05bf
		},
		{
		0xd0,
		0x05c0
		},
		{
		0xd1,
		0x05c1
		},
		{
		0xd2,
		0x05c2
		},
		{
		0xd3,
		0x05c3
		},
		{
		0xd4,
		0x05f0
		},
		{
		0xd5,
		0x05f1
		},
		{
		0xd6,
		0x05f2
		},
		{
		0xd7,
		0x05f3
		},
		{
		0xd8,
		0x05f4
		},
		{
		0xfd,
		0x200e
		},
		{
		0xfe,
		0x200f
		}
	};

LOCAL_D const SCnvConversionData::SOneDirectionData::SRange::UData::SKeyedTable1616::SEntry keyedTable1616_unicodeToForeign_1[]=
	{
		{
		0x00a0,
		0xa0
		},
		{
		0x00a1,
		0xa1
		},
		{
		0x00a2,
		0xa2
		},
		{
		0x00a3,
		0xa3
		},
		{
		0x00a5,
		0xa5
		},
		{
		0x00a6,
		0xa6
		},
		{
		0x00a7,
		0xa7
		},
		{
		0x00a8,
		0xa8
		},
		{
		0x00a9,
		0xa9
		},
		{
		0x00bb,
		0xbb
		},
		{
		0x00bc,
		0xbc
		},
		{
		0x00bd,
		0xbd
		},
		{
		0x00be,
		0xbe
		},
		{
		0x00bf,
		0xbf
		},
		{
		0x00d7,
		0xaa
		},
		{
		0x00f7,
		0xba
		},
		{
		0x0192,
		0x83
		},
		{
		0x02c6,
		0x88
		},
		{
		0x02dc,
		0x98
		},
		{
		0x05f0,
		0xd4
		},
		{
		0x05f1,
		0xd5
		},
		{
		0x05f2,
		0xd6
		},
		{
		0x05f3,
		0xd7
		},
		{
		0x05f4,
		0xd8
		},
		{
		0x200e,
		0xfd
		},
		{
		0x200f,
		0xfe
		},
		{
		0x2013,
		0x96
		},
		{
		0x2014,
		0x97
		},
		{
		0x2018,
		0x91
		},
		{
		0x2019,
		0x92
		},
		{
		0x201a,
		0x82
		},
		{
		0x201c,
		0x93
		},
		{
		0x201d,
		0x94
		},
		{
		0x201e,
		0x84
		},
		{
		0x2020,
		0x86
		},
		{
		0x2021,
		0x87
		},
		{
		0x2022,
		0x95
		},
		{
		0x2026,
		0x85
		},
		{
		0x2030,
		0x89
		},
		{
		0x2039,
		0x8b
		},
		{
		0x203a,
		0x9b
		},
		{
		0x20aa,
		0xa4
		},
		{
		0x20ac,
		0x80
		},
		{
		0x2122,
		0x99
		}
	};

LOCAL_D const SCnvConversionData::SVariableByteData::SRange foreignVariableByteDataRanges[]=
	{
		{
		0x00,
		0xfe,
		0,
		0
		}
	};

LOCAL_D const SCnvConversionData::SOneDirectionData::SRange foreignToUnicodeDataRanges[]=
	{
		{
		0x00,
		0x7f,
		SCnvConversionData::SOneDirectionData::SRange::EDirect,
		0,
		0,
			{
			0,
			0
			}
		},
		{
		0xab,
		0xb9,
		SCnvConversionData::SOneDirectionData::SRange::EDirect,
		0,
		0,
			{
			0,
			0
			}
		},
		{
		0xe0,
		0xfa,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, 1264),
			0
			}
		},
		{
		0x80,
		0xfe,
		SCnvConversionData::SOneDirectionData::SRange::EKeyedTable1616,
		0,
		0,
			{
			STATIC_CAST(TUint, ARRAY_LENGTH(keyedTable1616_foreignToUnicode_1)),
			REINTERPRET_CAST(TUint, CONST_CAST( SCnvConversionData::SOneDirectionData::SRange::UData::SKeyedTable1616::SEntry*, keyedTable1616_foreignToUnicode_1))
			}
		}
	};

LOCAL_D const SCnvConversionData::SOneDirectionData::SRange unicodeToForeignDataRanges[]=
	{
		{
		0x0000,
		0x007f,
		SCnvConversionData::SOneDirectionData::SRange::EDirect,
		1,
		0,
			{
			0,
			0
			}
		},
		{
		0x00ab,
		0x00b9,
		SCnvConversionData::SOneDirectionData::SRange::EDirect,
		1,
		0,
			{
			0,
			0
			}
		},
		{
		0x05b0,
		0x05b9,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		1,
		0,
			{
			STATIC_CAST(TUint, -1264),
			0
			}
		},
		{
		0x05bb,
		0x05c3,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		1,
		0,
			{
			STATIC_CAST(TUint, -1264),
			0
			}
		},
		{
		0x05d0,
		0x05ea,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		1,
		0,
			{
			STATIC_CAST(TUint, -1264),
			0
			}
		},
		{
		0x00a0,
		0x2122,
		SCnvConversionData::SOneDirectionData::SRange::EKeyedTable1616,
		1,
		0,
			{
			STATIC_CAST(TUint, ARRAY_LENGTH(keyedTable1616_unicodeToForeign_1)),
			REINTERPRET_CAST(TUint, CONST_CAST( SCnvConversionData::SOneDirectionData::SRange::UData::SKeyedTable1616::SEntry*, keyedTable1616_unicodeToForeign_1))
			}
		}
	};

GLDEF_D const SCnvConversionData conversionData=
	{
	SCnvConversionData::EFixedBigEndian,
		{
		ARRAY_LENGTH(foreignVariableByteDataRanges),
		foreignVariableByteDataRanges
		},
		{
		ARRAY_LENGTH(foreignToUnicodeDataRanges),
		foreignToUnicodeDataRanges
		},
		{
		ARRAY_LENGTH(unicodeToForeignDataRanges),
		unicodeToForeignDataRanges
		},
	NULL,
	NULL
	};

