/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/


#include <e32std.h>
#include <convdata.h>
#include <convgeneratedcpp.h>

#define ARRAY_LENGTH(aArray) (sizeof(aArray)/sizeof((aArray)[0]))

#pragma warning (disable: 4049) // compiler limit : terminating line number emission

_LIT8(KLit8ReplacementForUnconvertibleUnicodeCharacters, "\xa1\x48");

GLDEF_C const TDesC8& ReplacementForUnconvertibleUnicodeCharacters_internal()
	{
	return KLit8ReplacementForUnconvertibleUnicodeCharacters;
	}

LOCAL_D const SCnvConversionData::SOneDirectionData::SRange::UData::SKeyedTable1616::SEntry keyedTable1616_foreignToUnicode_1[]=
	{
		{
		0xa1c4,
		0xff3f
		},
		{
		0xa2cc,
		0x5341
		},
		{
		0xa2cd,
		0x5344
		},
		{
		0xa2ce,
		0x5345
		},
		{
		0xa340,
		0xff57
		},
		{
		0xa341,
		0xff58
		},
		{
		0xa342,
		0xff59
		},
		{
		0xa343,
		0xff5a
		},
		{
		0xa3bb,
		0x02d9
		},
		{
		0xa3bc,
		0x02c9
		},
		{
		0xa3bd,
		0x02ca
		},
		{
		0xa3be,
		0x02c7
		},
		{
		0xa3bf,
		0x02cb
		},
		{
		0xc6a1,
		0x30fe
		},
		{
		0xc6a2,
		0x309d
		},
		{
		0xc6a3,
		0x309e
		},
		{
		0xc6a4,
		0x3005
		},
		{
		0xc7b1,
		0x0414
		},
		{
		0xc7b2,
		0x0415
		},
		{
		0xc7b3,
		0x0401
		},
		{
		0xc7ce,
		0x0451
		}
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_1[]=
	{
	0x3000,
	0xff0c,
	0x3001,
	0x3002,
	0xff0e,
	0x2022,
	0xff1b,
	0xff1a,
	0xff1f,
	0xff01,
	0xfe30,
	0x2026,
	0x2025,
	0xfe50,
	0xff64,
	0xfe52,
	0x00b7,
	0xfe54,
	0xfe55,
	0xfe56,
	0xfe57,
	0xff5c,
	0x2013,
	0xfe31,
	0x2014,
	0xfe33,
	0xff3f,
	0xfe34,
	0xfe4f,
	0xff08,
	0xff09,
	0xfe35,
	0xfe36,
	0xff5b,
	0xff5d,
	0xfe37,
	0xfe38,
	0x3014,
	0x3015,
	0xfe39,
	0xfe3a,
	0x3010,
	0x3011,
	0xfe3b,
	0xfe3c,
	0x300a,
	0x300b,
	0xfe3d,
	0xfe3e,
	0x3008,
	0x3009,
	0xfe3f,
	0xfe40,
	0x300c,
	0x300d,
	0xfe41,
	0xfe42,
	0x300e,
	0x300f,
	0xfe43,
	0xfe44,
	0xfe59,
	0xfe5a
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_2[]=
	{
	0xfe5b,
	0xfe5c,
	0xfe5d,
	0xfe5e,
	0x2018,
	0x2019,
	0x201c,
	0x201d,
	0x301d,
	0x301e,
	0x2035,
	0x2032,
	0xff03,
	0xff06,
	0xff0a,
	0x203b,
	0x00a7,
	0x3003,
	0x25cb,
	0x25cf,
	0x25b3,
	0x25b2,
	0x25ce,
	0x2606,
	0x2605,
	0x25c7,
	0x25c6,
	0x25a1,
	0x25a0,
	0x25bd,
	0x25bc,
	0x32a3,
	0x2105,
	0x203e
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_3[]=
	{
	0xfe49,
	0xfe4a,
	0xfe4d,
	0xfe4e,
	0xfe4b,
	0xfe4c,
	0xfe5f,
	0xfe60,
	0xfe61,
	0xff0b,
	0xff0d,
	0x00d7,
	0x00f7,
	0x00b1,
	0x221a,
	0xff1c,
	0xff1e,
	0xff1d,
	0x2266,
	0x2267,
	0x2260,
	0x221e,
	0x2252,
	0x2261,
	0xfe62,
	0xfe63,
	0xfe64,
	0xfe65,
	0xfe66,
	0x223c,
	0x2229,
	0x222a,
	0x22a5,
	0x2220,
	0x221f,
	0x22bf,
	0x33d2,
	0x33d1,
	0x222b,
	0x222e,
	0x2235,
	0x2234,
	0x2640,
	0x2642,
	0x2641,
	0x2609,
	0x2191,
	0x2193,
	0x2190,
	0x2192,
	0x2196,
	0x2197,
	0x2199,
	0x2198,
	0x2225,
	0x2223,
	0x2571
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_4[]=
	{
	0x2572,
	0xff0f,
	0xff3c,
	0xff04,
	0x00a5,
	0x3012,
	0x00a2,
	0x00a3,
	0xff05,
	0xff20,
	0x2103,
	0x2109,
	0xfe69,
	0xfe6a,
	0xfe6b,
	0x33d5,
	0x339c,
	0x339d,
	0x339e,
	0x33ce,
	0x33a1,
	0x338e,
	0x338f,
	0x33c4,
	0x00b0,
	0x5159,
	0x515b,
	0x515e,
	0x515d,
	0x5161,
	0x5163,
	0x55e7,
	0x74e9,
	0x7cce,
	0x2581,
	0x2582,
	0x2583,
	0x2584,
	0x2585,
	0x2586,
	0x2587,
	0x2588,
	0x258f,
	0x258e,
	0x258d,
	0x258c,
	0x258b,
	0x258a,
	0x2589,
	0x253c,
	0x2534,
	0x252c,
	0x2524,
	0x251c,
	0x2594,
	0x2500,
	0x2502,
	0x2595,
	0x250c,
	0x2510,
	0x2514,
	0x2518,
	0x256d
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_5[]=
	{
	0x256e,
	0x2570,
	0x256f,
	0x2550,
	0x255e,
	0x256a,
	0x2561,
	0x25e2,
	0x25e3,
	0x25e5,
	0x25e4,
	0x2571,
	0x2572,
	0x2573
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_6[]=
	{
	0x4e00,
	0x4e59,
	0x4e01,
	0x4e03,
	0x4e43,
	0x4e5d,
	0x4e86,
	0x4e8c,
	0x4eba,
	0x513f,
	0x5165,
	0x516b,
	0x51e0,
	0x5200,
	0x5201,
	0x529b,
	0x5315,
	0x5341,
	0x535c,
	0x53c8,
	0x4e09,
	0x4e0b,
	0x4e08,
	0x4e0a,
	0x4e2b,
	0x4e38,
	0x51e1,
	0x4e45,
	0x4e48,
	0x4e5f,
	0x4e5e,
	0x4e8e,
	0x4ea1,
	0x5140,
	0x5203,
	0x52fa,
	0x5343,
	0x53c9,
	0x53e3,
	0x571f,
	0x58eb,
	0x5915,
	0x5927,
	0x5973,
	0x5b50,
	0x5b51,
	0x5b53,
	0x5bf8,
	0x5c0f,
	0x5c22,
	0x5c38,
	0x5c71,
	0x5ddd,
	0x5de5,
	0x5df1,
	0x5df2,
	0x5df3,
	0x5dfe,
	0x5e72,
	0x5efe,
	0x5f0b,
	0x5f13,
	0x624d
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_7[]=
	{
	0x4e11,
	0x4e10,
	0x4e0d,
	0x4e2d,
	0x4e30,
	0x4e39,
	0x4e4b,
	0x5c39,
	0x4e88,
	0x4e91,
	0x4e95,
	0x4e92,
	0x4e94,
	0x4ea2,
	0x4ec1,
	0x4ec0,
	0x4ec3,
	0x4ec6,
	0x4ec7,
	0x4ecd,
	0x4eca,
	0x4ecb,
	0x4ec4,
	0x5143,
	0x5141,
	0x5167,
	0x516d,
	0x516e,
	0x516c,
	0x5197,
	0x51f6,
	0x5206,
	0x5207,
	0x5208,
	0x52fb,
	0x52fe,
	0x52ff,
	0x5316,
	0x5339,
	0x5348,
	0x5347,
	0x5345,
	0x535e,
	0x5384,
	0x53cb,
	0x53ca,
	0x53cd,
	0x58ec,
	0x5929,
	0x592b,
	0x592a,
	0x592d,
	0x5b54,
	0x5c11,
	0x5c24,
	0x5c3a,
	0x5c6f,
	0x5df4,
	0x5e7b,
	0x5eff,
	0x5f14,
	0x5f15,
	0x5fc3,
	0x6208,
	0x6236,
	0x624b,
	0x624e,
	0x652f,
	0x6587,
	0x6597,
	0x65a4,
	0x65b9,
	0x65e5,
	0x66f0,
	0x6708,
	0x6728,
	0x6b20,
	0x6b62,
	0x6b79,
	0x6bcb,
	0x6bd4,
	0x6bdb,
	0x6c0f,
	0x6c34,
	0x706b,
	0x722a,
	0x7236,
	0x723b,
	0x7247,
	0x7259,
	0x725b,
	0x72ac,
	0x738b,
	0x4e19
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_8[]=
	{
	0x4e16,
	0x4e15,
	0x4e14,
	0x4e18,
	0x4e3b,
	0x4e4d,
	0x4e4f,
	0x4e4e,
	0x4ee5,
	0x4ed8,
	0x4ed4,
	0x4ed5,
	0x4ed6,
	0x4ed7,
	0x4ee3,
	0x4ee4,
	0x4ed9,
	0x4ede,
	0x5145,
	0x5144,
	0x5189,
	0x518a,
	0x51ac,
	0x51f9,
	0x51fa,
	0x51f8,
	0x520a,
	0x52a0,
	0x529f,
	0x5305,
	0x5306,
	0x5317,
	0x531d,
	0x4edf,
	0x534a,
	0x5349,
	0x5361,
	0x5360,
	0x536f,
	0x536e,
	0x53bb,
	0x53ef,
	0x53e4,
	0x53f3,
	0x53ec,
	0x53ee,
	0x53e9,
	0x53e8,
	0x53fc,
	0x53f8,
	0x53f5,
	0x53eb,
	0x53e6,
	0x53ea,
	0x53f2,
	0x53f1,
	0x53f0,
	0x53e5,
	0x53ed,
	0x53fb,
	0x56db,
	0x56da,
	0x5916
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_9[]=
	{
	0x592e,
	0x5931,
	0x5974,
	0x5976,
	0x5b55,
	0x5b83,
	0x5c3c,
	0x5de8,
	0x5de7,
	0x5de6,
	0x5e02,
	0x5e03,
	0x5e73,
	0x5e7c,
	0x5f01,
	0x5f18,
	0x5f17,
	0x5fc5,
	0x620a,
	0x6253,
	0x6254,
	0x6252,
	0x6251,
	0x65a5,
	0x65e6,
	0x672e,
	0x672c,
	0x672a,
	0x672b,
	0x672d,
	0x6b63,
	0x6bcd,
	0x6c11,
	0x6c10,
	0x6c38,
	0x6c41,
	0x6c40,
	0x6c3e,
	0x72af,
	0x7384,
	0x7389,
	0x74dc,
	0x74e6,
	0x7518,
	0x751f,
	0x7528,
	0x7529,
	0x7530,
	0x7531,
	0x7532,
	0x7533,
	0x758b,
	0x767d,
	0x76ae,
	0x76bf,
	0x76ee,
	0x77db,
	0x77e2,
	0x77f3,
	0x793a,
	0x79be,
	0x7a74,
	0x7acb,
	0x4e1e,
	0x4e1f,
	0x4e52,
	0x4e53,
	0x4e69,
	0x4e99,
	0x4ea4,
	0x4ea6,
	0x4ea5,
	0x4eff,
	0x4f09,
	0x4f19,
	0x4f0a,
	0x4f15,
	0x4f0d,
	0x4f10,
	0x4f11,
	0x4f0f,
	0x4ef2,
	0x4ef6,
	0x4efb,
	0x4ef0,
	0x4ef3,
	0x4efd,
	0x4f01,
	0x4f0b,
	0x5149,
	0x5147,
	0x5146,
	0x5148,
	0x5168
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_10[]=
	{
	0x5171,
	0x518d,
	0x51b0,
	0x5217,
	0x5211,
	0x5212,
	0x520e,
	0x5216,
	0x52a3,
	0x5308,
	0x5321,
	0x5320,
	0x5370,
	0x5371,
	0x5409,
	0x540f,
	0x540c,
	0x540a,
	0x5410,
	0x5401,
	0x540b,
	0x5404,
	0x5411,
	0x540d,
	0x5408,
	0x5403,
	0x540e,
	0x5406,
	0x5412,
	0x56e0,
	0x56de,
	0x56dd,
	0x5733,
	0x5730,
	0x5728,
	0x572d,
	0x572c,
	0x572f,
	0x5729,
	0x5919,
	0x591a,
	0x5937,
	0x5938,
	0x5984,
	0x5978,
	0x5983,
	0x597d,
	0x5979,
	0x5982,
	0x5981,
	0x5b57,
	0x5b58,
	0x5b87,
	0x5b88,
	0x5b85,
	0x5b89,
	0x5bfa,
	0x5c16,
	0x5c79,
	0x5dde,
	0x5e06,
	0x5e76,
	0x5e74
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_11[]=
	{
	0x5f0f,
	0x5f1b,
	0x5fd9,
	0x5fd6,
	0x620e,
	0x620c,
	0x620d,
	0x6210,
	0x6263,
	0x625b,
	0x6258,
	0x6536,
	0x65e9,
	0x65e8,
	0x65ec,
	0x65ed,
	0x66f2,
	0x66f3,
	0x6709,
	0x673d,
	0x6734,
	0x6731,
	0x6735,
	0x6b21,
	0x6b64,
	0x6b7b,
	0x6c16,
	0x6c5d,
	0x6c57,
	0x6c59,
	0x6c5f,
	0x6c60,
	0x6c50,
	0x6c55,
	0x6c61,
	0x6c5b,
	0x6c4d,
	0x6c4e,
	0x7070,
	0x725f,
	0x725d,
	0x767e,
	0x7af9,
	0x7c73,
	0x7cf8,
	0x7f36,
	0x7f8a,
	0x7fbd,
	0x8001,
	0x8003,
	0x800c,
	0x8012,
	0x8033,
	0x807f,
	0x8089,
	0x808b,
	0x808c,
	0x81e3,
	0x81ea,
	0x81f3,
	0x81fc,
	0x820c,
	0x821b,
	0x821f,
	0x826e,
	0x8272,
	0x827e,
	0x866b,
	0x8840,
	0x884c,
	0x8863,
	0x897f,
	0x9621,
	0x4e32,
	0x4ea8,
	0x4f4d,
	0x4f4f,
	0x4f47,
	0x4f57,
	0x4f5e,
	0x4f34,
	0x4f5b,
	0x4f55,
	0x4f30,
	0x4f50,
	0x4f51,
	0x4f3d,
	0x4f3a,
	0x4f38,
	0x4f43,
	0x4f54,
	0x4f3c,
	0x4f46,
	0x4f63
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_12[]=
	{
	0x4f5c,
	0x4f60,
	0x4f2f,
	0x4f4e,
	0x4f36,
	0x4f59,
	0x4f5d,
	0x4f48,
	0x4f5a,
	0x514c,
	0x514b,
	0x514d,
	0x5175,
	0x51b6,
	0x51b7,
	0x5225,
	0x5224,
	0x5229,
	0x522a,
	0x5228,
	0x52ab,
	0x52a9,
	0x52aa,
	0x52ac,
	0x5323,
	0x5373,
	0x5375,
	0x541d,
	0x542d,
	0x541e,
	0x543e,
	0x5426,
	0x544e,
	0x5427,
	0x5446,
	0x5443,
	0x5433,
	0x5448,
	0x5442,
	0x541b,
	0x5429,
	0x544a,
	0x5439,
	0x543b,
	0x5438,
	0x542e,
	0x5435,
	0x5436,
	0x5420,
	0x543c,
	0x5440,
	0x5431,
	0x542b,
	0x541f,
	0x542c,
	0x56ea,
	0x56f0,
	0x56e4,
	0x56eb,
	0x574a,
	0x5751,
	0x5740,
	0x574d
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_13[]=
	{
	0x5747,
	0x574e,
	0x573e,
	0x5750,
	0x574f,
	0x573b,
	0x58ef,
	0x593e,
	0x599d,
	0x5992,
	0x59a8,
	0x599e,
	0x59a3,
	0x5999,
	0x5996,
	0x598d,
	0x59a4,
	0x5993,
	0x598a,
	0x59a5,
	0x5b5d,
	0x5b5c,
	0x5b5a,
	0x5b5b,
	0x5b8c,
	0x5b8b,
	0x5b8f,
	0x5c2c,
	0x5c40,
	0x5c41,
	0x5c3f,
	0x5c3e,
	0x5c90,
	0x5c91,
	0x5c94,
	0x5c8c,
	0x5deb,
	0x5e0c,
	0x5e8f,
	0x5e87,
	0x5e8a,
	0x5ef7,
	0x5f04,
	0x5f1f,
	0x5f64,
	0x5f62,
	0x5f77,
	0x5f79,
	0x5fd8,
	0x5fcc,
	0x5fd7,
	0x5fcd,
	0x5ff1,
	0x5feb,
	0x5ff8,
	0x5fea,
	0x6212,
	0x6211,
	0x6284,
	0x6297,
	0x6296,
	0x6280,
	0x6276,
	0x6289,
	0x626d,
	0x628a,
	0x627c,
	0x627e,
	0x6279,
	0x6273,
	0x6292,
	0x626f,
	0x6298,
	0x626e,
	0x6295,
	0x6293,
	0x6291,
	0x6286,
	0x6539,
	0x653b,
	0x6538,
	0x65f1,
	0x66f4,
	0x675f,
	0x674e,
	0x674f,
	0x6750,
	0x6751,
	0x675c,
	0x6756,
	0x675e,
	0x6749,
	0x6746,
	0x6760
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_14[]=
	{
	0x6753,
	0x6757,
	0x6b65,
	0x6bcf,
	0x6c42,
	0x6c5e,
	0x6c99,
	0x6c81,
	0x6c88,
	0x6c89,
	0x6c85,
	0x6c9b,
	0x6c6a,
	0x6c7a,
	0x6c90,
	0x6c70,
	0x6c8c,
	0x6c68,
	0x6c96,
	0x6c92,
	0x6c7d,
	0x6c83,
	0x6c72,
	0x6c7e,
	0x6c74,
	0x6c86,
	0x6c76,
	0x6c8d,
	0x6c94,
	0x6c98,
	0x6c82,
	0x7076,
	0x707c,
	0x707d,
	0x7078,
	0x7262,
	0x7261,
	0x7260,
	0x72c4,
	0x72c2,
	0x7396,
	0x752c,
	0x752b,
	0x7537,
	0x7538,
	0x7682,
	0x76ef,
	0x77e3,
	0x79c1,
	0x79c0,
	0x79bf,
	0x7a76,
	0x7cfb,
	0x7f55,
	0x8096,
	0x8093,
	0x809d,
	0x8098,
	0x809b,
	0x809a,
	0x80b2,
	0x826f,
	0x8292
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_15[]=
	{
	0x828b,
	0x828d,
	0x898b,
	0x89d2,
	0x8a00,
	0x8c37,
	0x8c46,
	0x8c55,
	0x8c9d,
	0x8d64,
	0x8d70,
	0x8db3,
	0x8eab,
	0x8eca,
	0x8f9b,
	0x8fb0,
	0x8fc2,
	0x8fc6,
	0x8fc5,
	0x8fc4,
	0x5de1,
	0x9091,
	0x90a2,
	0x90aa,
	0x90a6,
	0x90a3,
	0x9149,
	0x91c6,
	0x91cc,
	0x9632,
	0x962e,
	0x9631,
	0x962a,
	0x962c,
	0x4e26,
	0x4e56,
	0x4e73,
	0x4e8b,
	0x4e9b,
	0x4e9e,
	0x4eab,
	0x4eac,
	0x4f6f,
	0x4f9d,
	0x4f8d,
	0x4f73,
	0x4f7f,
	0x4f6c,
	0x4f9b,
	0x4f8b,
	0x4f86,
	0x4f83,
	0x4f70,
	0x4f75,
	0x4f88,
	0x4f69,
	0x4f7b,
	0x4f96,
	0x4f7e,
	0x4f8f,
	0x4f91,
	0x4f7a,
	0x5154,
	0x5152,
	0x5155,
	0x5169,
	0x5177,
	0x5176,
	0x5178,
	0x51bd,
	0x51fd,
	0x523b,
	0x5238,
	0x5237,
	0x523a,
	0x5230,
	0x522e,
	0x5236,
	0x5241,
	0x52be,
	0x52bb,
	0x5352,
	0x5354,
	0x5353,
	0x5351,
	0x5366,
	0x5377,
	0x5378,
	0x5379,
	0x53d6,
	0x53d4,
	0x53d7,
	0x5473,
	0x5475
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_16[]=
	{
	0x5496,
	0x5478,
	0x5495,
	0x5480,
	0x547b,
	0x5477,
	0x5484,
	0x5492,
	0x5486,
	0x547c,
	0x5490,
	0x5471,
	0x5476,
	0x548c,
	0x549a,
	0x5462,
	0x5468,
	0x548b,
	0x547d,
	0x548e,
	0x56fa,
	0x5783,
	0x5777,
	0x576a,
	0x5769,
	0x5761,
	0x5766,
	0x5764,
	0x577c,
	0x591c,
	0x5949,
	0x5947,
	0x5948,
	0x5944,
	0x5954,
	0x59be,
	0x59bb,
	0x59d4,
	0x59b9,
	0x59ae,
	0x59d1,
	0x59c6,
	0x59d0,
	0x59cd,
	0x59cb,
	0x59d3,
	0x59ca,
	0x59af,
	0x59b3,
	0x59d2,
	0x59c5,
	0x5b5f,
	0x5b64,
	0x5b63,
	0x5b97,
	0x5b9a,
	0x5b98,
	0x5b9c,
	0x5b99,
	0x5b9b,
	0x5c1a,
	0x5c48,
	0x5c45
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_17[]=
	{
	0x5c46,
	0x5cb7,
	0x5ca1,
	0x5cb8,
	0x5ca9,
	0x5cab,
	0x5cb1,
	0x5cb3,
	0x5e18,
	0x5e1a,
	0x5e16,
	0x5e15,
	0x5e1b,
	0x5e11,
	0x5e78,
	0x5e9a,
	0x5e97,
	0x5e9c,
	0x5e95,
	0x5e96,
	0x5ef6,
	0x5f26,
	0x5f27,
	0x5f29,
	0x5f80,
	0x5f81,
	0x5f7f,
	0x5f7c,
	0x5fdd,
	0x5fe0,
	0x5ffd,
	0x5ff5,
	0x5fff,
	0x600f,
	0x6014,
	0x602f,
	0x6035,
	0x6016,
	0x602a,
	0x6015,
	0x6021,
	0x6027,
	0x6029,
	0x602b,
	0x601b,
	0x6216,
	0x6215,
	0x623f,
	0x623e,
	0x6240,
	0x627f,
	0x62c9,
	0x62cc,
	0x62c4,
	0x62bf,
	0x62c2,
	0x62b9,
	0x62d2,
	0x62db,
	0x62ab,
	0x62d3,
	0x62d4,
	0x62cb,
	0x62c8,
	0x62a8,
	0x62bd,
	0x62bc,
	0x62d0,
	0x62d9,
	0x62c7,
	0x62cd,
	0x62b5,
	0x62da,
	0x62b1,
	0x62d8,
	0x62d6,
	0x62d7,
	0x62c6,
	0x62ac,
	0x62ce,
	0x653e,
	0x65a7,
	0x65bc,
	0x65fa,
	0x6614,
	0x6613,
	0x660c,
	0x6606,
	0x6602,
	0x660e,
	0x6600,
	0x660f,
	0x6615,
	0x660a
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_18[]=
	{
	0x6607,
	0x670d,
	0x670b,
	0x676d,
	0x678b,
	0x6795,
	0x6771,
	0x679c,
	0x6773,
	0x6777,
	0x6787,
	0x679d,
	0x6797,
	0x676f,
	0x6770,
	0x677f,
	0x6789,
	0x677e,
	0x6790,
	0x6775,
	0x679a,
	0x6793,
	0x677c,
	0x676a,
	0x6772,
	0x6b23,
	0x6b66,
	0x6b67,
	0x6b7f,
	0x6c13,
	0x6c1b,
	0x6ce3,
	0x6ce8,
	0x6cf3,
	0x6cb1,
	0x6ccc,
	0x6ce5,
	0x6cb3,
	0x6cbd,
	0x6cbe,
	0x6cbc,
	0x6ce2,
	0x6cab,
	0x6cd5,
	0x6cd3,
	0x6cb8,
	0x6cc4,
	0x6cb9,
	0x6cc1,
	0x6cae,
	0x6cd7,
	0x6cc5,
	0x6cf1,
	0x6cbf,
	0x6cbb,
	0x6ce1,
	0x6cdb,
	0x6cca,
	0x6cac,
	0x6cef,
	0x6cdc,
	0x6cd6,
	0x6ce0
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_19[]=
	{
	0x7095,
	0x708e,
	0x7092,
	0x708a,
	0x7099,
	0x722c,
	0x722d,
	0x7238,
	0x7248,
	0x7267,
	0x7269,
	0x72c0,
	0x72ce,
	0x72d9,
	0x72d7,
	0x72d0,
	0x73a9,
	0x73a8,
	0x739f,
	0x73ab,
	0x73a5,
	0x753d,
	0x759d,
	0x7599,
	0x759a,
	0x7684,
	0x76c2,
	0x76f2,
	0x76f4,
	0x77e5,
	0x77fd,
	0x793e,
	0x7940,
	0x7941,
	0x79c9,
	0x79c8,
	0x7a7a,
	0x7a79,
	0x7afa,
	0x7cfe,
	0x7f54,
	0x7f8c,
	0x7f8b,
	0x8005,
	0x80ba,
	0x80a5,
	0x80a2,
	0x80b1,
	0x80a1,
	0x80ab,
	0x80a9,
	0x80b4,
	0x80aa,
	0x80af,
	0x81e5,
	0x81fe,
	0x820d,
	0x82b3,
	0x829d,
	0x8299,
	0x82ad,
	0x82bd,
	0x829f,
	0x82b9,
	0x82b1,
	0x82ac,
	0x82a5,
	0x82af,
	0x82b8,
	0x82a3,
	0x82b0,
	0x82be,
	0x82b7,
	0x864e,
	0x8671,
	0x521d,
	0x8868,
	0x8ecb,
	0x8fce,
	0x8fd4,
	0x8fd1,
	0x90b5,
	0x90b8,
	0x90b1,
	0x90b6,
	0x91c7,
	0x91d1,
	0x9577,
	0x9580,
	0x961c,
	0x9640,
	0x963f,
	0x963b,
	0x9644
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_20[]=
	{
	0x9642,
	0x96b9,
	0x96e8,
	0x9752,
	0x975e,
	0x4e9f,
	0x4ead,
	0x4eae,
	0x4fe1,
	0x4fb5,
	0x4faf,
	0x4fbf,
	0x4fe0,
	0x4fd1,
	0x4fcf,
	0x4fdd,
	0x4fc3,
	0x4fb6,
	0x4fd8,
	0x4fdf,
	0x4fca,
	0x4fd7,
	0x4fae,
	0x4fd0,
	0x4fc4,
	0x4fc2,
	0x4fda,
	0x4fce,
	0x4fde,
	0x4fb7,
	0x5157,
	0x5192,
	0x5191,
	0x51a0,
	0x524e,
	0x5243,
	0x524a,
	0x524d,
	0x524c,
	0x524b,
	0x5247,
	0x52c7,
	0x52c9,
	0x52c3,
	0x52c1,
	0x530d,
	0x5357,
	0x537b,
	0x539a,
	0x53db,
	0x54ac,
	0x54c0,
	0x54a8,
	0x54ce,
	0x54c9,
	0x54b8,
	0x54a6,
	0x54b3,
	0x54c7,
	0x54c2,
	0x54bd,
	0x54aa,
	0x54c1
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_21[]=
	{
	0x54c4,
	0x54c8,
	0x54af,
	0x54ab,
	0x54b1,
	0x54bb,
	0x54a9,
	0x54a7,
	0x54bf,
	0x56ff,
	0x5782,
	0x578b,
	0x57a0,
	0x57a3,
	0x57a2,
	0x57ce,
	0x57ae,
	0x5793,
	0x5955,
	0x5951,
	0x594f,
	0x594e,
	0x5950,
	0x59dc,
	0x59d8,
	0x59ff,
	0x59e3,
	0x59e8,
	0x5a03,
	0x59e5,
	0x59ea,
	0x59da,
	0x59e6,
	0x5a01,
	0x59fb,
	0x5b69,
	0x5ba3,
	0x5ba6,
	0x5ba4,
	0x5ba2,
	0x5ba5,
	0x5c01,
	0x5c4e,
	0x5c4f,
	0x5c4d,
	0x5c4b,
	0x5cd9,
	0x5cd2,
	0x5df7,
	0x5e1d,
	0x5e25,
	0x5e1f,
	0x5e7d,
	0x5ea0,
	0x5ea6,
	0x5efa,
	0x5f08,
	0x5f2d,
	0x5f65,
	0x5f88,
	0x5f85,
	0x5f8a,
	0x5f8b,
	0x5f87,
	0x5f8c,
	0x5f89,
	0x6012,
	0x601d,
	0x6020,
	0x6025,
	0x600e,
	0x6028,
	0x604d,
	0x6070,
	0x6068,
	0x6062,
	0x6046,
	0x6043,
	0x606c,
	0x606b,
	0x606a,
	0x6064,
	0x6241,
	0x62dc,
	0x6316,
	0x6309,
	0x62fc,
	0x62ed,
	0x6301,
	0x62ee,
	0x62fd,
	0x6307,
	0x62f1,
	0x62f7
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_22[]=
	{
	0x62ef,
	0x62ec,
	0x62fe,
	0x62f4,
	0x6311,
	0x6302,
	0x653f,
	0x6545,
	0x65ab,
	0x65bd,
	0x65e2,
	0x6625,
	0x662d,
	0x6620,
	0x6627,
	0x662f,
	0x661f,
	0x6628,
	0x6631,
	0x6624,
	0x66f7,
	0x67ff,
	0x67d3,
	0x67f1,
	0x67d4,
	0x67d0,
	0x67ec,
	0x67b6,
	0x67af,
	0x67f5,
	0x67e9,
	0x67ef,
	0x67c4,
	0x67d1,
	0x67b4,
	0x67da,
	0x67e5,
	0x67b8,
	0x67cf,
	0x67de,
	0x67f3,
	0x67b0,
	0x67d9,
	0x67e2,
	0x67dd,
	0x67d2,
	0x6b6a,
	0x6b83,
	0x6b86,
	0x6bb5,
	0x6bd2,
	0x6bd7,
	0x6c1f,
	0x6cc9,
	0x6d0b,
	0x6d32,
	0x6d2a,
	0x6d41,
	0x6d25,
	0x6d0c,
	0x6d31,
	0x6d1e,
	0x6d17
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_23[]=
	{
	0x6d3b,
	0x6d3d,
	0x6d3e,
	0x6d36,
	0x6d1b,
	0x6cf5,
	0x6d39,
	0x6d27,
	0x6d38,
	0x6d29,
	0x6d2e,
	0x6d35,
	0x6d0e,
	0x6d2b,
	0x70ab,
	0x70ba,
	0x70b3,
	0x70ac,
	0x70af,
	0x70ad,
	0x70b8,
	0x70ae,
	0x70a4,
	0x7230,
	0x7272,
	0x726f,
	0x7274,
	0x72e9,
	0x72e0,
	0x72e1,
	0x73b7,
	0x73ca,
	0x73bb,
	0x73b2,
	0x73cd,
	0x73c0,
	0x73b3,
	0x751a,
	0x752d,
	0x754f,
	0x754c,
	0x754e,
	0x754b,
	0x75ab,
	0x75a4,
	0x75a5,
	0x75a2,
	0x75a3,
	0x7678,
	0x7686,
	0x7687,
	0x7688,
	0x76c8,
	0x76c6,
	0x76c3,
	0x76c5,
	0x7701,
	0x76f9,
	0x76f8,
	0x7709,
	0x770b,
	0x76fe,
	0x76fc,
	0x7707,
	0x77dc,
	0x7802,
	0x7814,
	0x780c,
	0x780d,
	0x7946,
	0x7949,
	0x7948,
	0x7947,
	0x79b9,
	0x79ba,
	0x79d1,
	0x79d2,
	0x79cb,
	0x7a7f,
	0x7a81,
	0x7aff,
	0x7afd,
	0x7c7d,
	0x7d02,
	0x7d05,
	0x7d00,
	0x7d09,
	0x7d07,
	0x7d04,
	0x7d06,
	0x7f38,
	0x7f8e,
	0x7fbf,
	0x8004
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_24[]=
	{
	0x8010,
	0x800d,
	0x8011,
	0x8036,
	0x80d6,
	0x80e5,
	0x80da,
	0x80c3,
	0x80c4,
	0x80cc,
	0x80e1,
	0x80db,
	0x80ce,
	0x80de,
	0x80e4,
	0x80dd,
	0x81f4,
	0x8222,
	0x82e7,
	0x8303,
	0x8305,
	0x82e3,
	0x82db,
	0x82e6,
	0x8304,
	0x82e5,
	0x8302,
	0x8309,
	0x82d2,
	0x82d7,
	0x82f1,
	0x8301,
	0x82dc,
	0x82d4,
	0x82d1,
	0x82de,
	0x82d3,
	0x82df,
	0x82ef,
	0x8306,
	0x8650,
	0x8679,
	0x867b,
	0x867a,
	0x884d,
	0x886b,
	0x8981,
	0x89d4,
	0x8a08,
	0x8a02,
	0x8a03,
	0x8c9e,
	0x8ca0,
	0x8d74,
	0x8d73,
	0x8db4,
	0x8ecd,
	0x8ecc,
	0x8ff0,
	0x8fe6,
	0x8fe2,
	0x8fea,
	0x8fe5
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_25[]=
	{
	0x8fed,
	0x8feb,
	0x8fe4,
	0x8fe8,
	0x90ca,
	0x90ce,
	0x90c1,
	0x90c3,
	0x914b,
	0x914a,
	0x91cd,
	0x9582,
	0x9650,
	0x964b,
	0x964c,
	0x964d,
	0x9762,
	0x9769,
	0x97cb,
	0x97ed,
	0x97f3,
	0x9801,
	0x98a8,
	0x98db,
	0x98df,
	0x9996,
	0x9999,
	0x4e58,
	0x4eb3,
	0x500c,
	0x500d,
	0x5023,
	0x4fef,
	0x5026,
	0x5025,
	0x4ff8,
	0x5029,
	0x5016,
	0x5006,
	0x503c,
	0x501f,
	0x501a,
	0x5012,
	0x5011,
	0x4ffa,
	0x5000,
	0x5014,
	0x5028,
	0x4ff1,
	0x5021,
	0x500b,
	0x5019,
	0x5018,
	0x4ff3,
	0x4fee,
	0x502d,
	0x502a,
	0x4ffe,
	0x502b,
	0x5009,
	0x517c,
	0x51a4,
	0x51a5,
	0x51a2,
	0x51cd,
	0x51cc,
	0x51c6,
	0x51cb,
	0x5256,
	0x525c,
	0x5254,
	0x525b,
	0x525d,
	0x532a,
	0x537f,
	0x539f,
	0x539d,
	0x53df,
	0x54e8,
	0x5510,
	0x5501,
	0x5537,
	0x54fc,
	0x54e5,
	0x54f2,
	0x5506,
	0x54fa,
	0x5514,
	0x54e9,
	0x54ed,
	0x54e1,
	0x5509,
	0x54ee,
	0x54ea
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_26[]=
	{
	0x54e6,
	0x5527,
	0x5507,
	0x54fd,
	0x550f,
	0x5703,
	0x5704,
	0x57c2,
	0x57d4,
	0x57cb,
	0x57c3,
	0x5809,
	0x590f,
	0x5957,
	0x5958,
	0x595a,
	0x5a11,
	0x5a18,
	0x5a1c,
	0x5a1f,
	0x5a1b,
	0x5a13,
	0x59ec,
	0x5a20,
	0x5a23,
	0x5a29,
	0x5a25,
	0x5a0c,
	0x5a09,
	0x5b6b,
	0x5c58,
	0x5bb0,
	0x5bb3,
	0x5bb6,
	0x5bb4,
	0x5bae,
	0x5bb5,
	0x5bb9,
	0x5bb8,
	0x5c04,
	0x5c51,
	0x5c55,
	0x5c50,
	0x5ced,
	0x5cfd,
	0x5cfb,
	0x5cea,
	0x5ce8,
	0x5cf0,
	0x5cf6,
	0x5d01,
	0x5cf4,
	0x5dee,
	0x5e2d,
	0x5e2b,
	0x5eab,
	0x5ead,
	0x5ea7,
	0x5f31,
	0x5f92,
	0x5f91,
	0x5f90,
	0x6059
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_27[]=
	{
	0x6063,
	0x6065,
	0x6050,
	0x6055,
	0x606d,
	0x6069,
	0x606f,
	0x6084,
	0x609f,
	0x609a,
	0x608d,
	0x6094,
	0x608c,
	0x6085,
	0x6096,
	0x6247,
	0x62f3,
	0x6308,
	0x62ff,
	0x634e,
	0x633e,
	0x632f,
	0x6355,
	0x6342,
	0x6346,
	0x634f,
	0x6349,
	0x633a,
	0x6350,
	0x633d,
	0x632a,
	0x632b,
	0x6328,
	0x634d,
	0x634c,
	0x6548,
	0x6549,
	0x6599,
	0x65c1,
	0x65c5,
	0x6642,
	0x6649,
	0x664f,
	0x6643,
	0x6652,
	0x664c,
	0x6645,
	0x6641,
	0x66f8,
	0x6714,
	0x6715,
	0x6717,
	0x6821,
	0x6838,
	0x6848,
	0x6846,
	0x6853,
	0x6839,
	0x6842,
	0x6854,
	0x6829,
	0x68b3,
	0x6817,
	0x684c,
	0x6851,
	0x683d,
	0x67f4,
	0x6850,
	0x6840,
	0x683c,
	0x6843,
	0x682a,
	0x6845,
	0x6813,
	0x6818,
	0x6841,
	0x6b8a,
	0x6b89,
	0x6bb7,
	0x6c23,
	0x6c27,
	0x6c28,
	0x6c26,
	0x6c24,
	0x6cf0,
	0x6d6a,
	0x6d95,
	0x6d88,
	0x6d87,
	0x6d66,
	0x6d78,
	0x6d77,
	0x6d59,
	0x6d93
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_28[]=
	{
	0x6d6c,
	0x6d89,
	0x6d6e,
	0x6d5a,
	0x6d74,
	0x6d69,
	0x6d8c,
	0x6d8a,
	0x6d79,
	0x6d85,
	0x6d65,
	0x6d94,
	0x70ca,
	0x70d8,
	0x70e4,
	0x70d9,
	0x70c8,
	0x70cf,
	0x7239,
	0x7279,
	0x72fc,
	0x72f9,
	0x72fd,
	0x72f8,
	0x72f7,
	0x7386,
	0x73ed,
	0x7409,
	0x73ee,
	0x73e0,
	0x73ea,
	0x73de,
	0x7554,
	0x755d,
	0x755c,
	0x755a,
	0x7559,
	0x75be,
	0x75c5,
	0x75c7,
	0x75b2,
	0x75b3,
	0x75bd,
	0x75bc,
	0x75b9,
	0x75c2,
	0x75b8,
	0x768b,
	0x76b0,
	0x76ca,
	0x76cd,
	0x76ce,
	0x7729,
	0x771f,
	0x7720,
	0x7728,
	0x77e9,
	0x7830,
	0x7827,
	0x7838,
	0x781d,
	0x7834,
	0x7837
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_29[]=
	{
	0x7825,
	0x782d,
	0x7820,
	0x781f,
	0x7832,
	0x7955,
	0x7950,
	0x7960,
	0x795f,
	0x7956,
	0x795e,
	0x795d,
	0x7957,
	0x795a,
	0x79e4,
	0x79e3,
	0x79e7,
	0x79df,
	0x79e6,
	0x79e9,
	0x79d8,
	0x7a84,
	0x7a88,
	0x7ad9,
	0x7b06,
	0x7b11,
	0x7c89,
	0x7d21,
	0x7d17,
	0x7d0b,
	0x7d0a,
	0x7d20,
	0x7d22,
	0x7d14,
	0x7d10,
	0x7d15,
	0x7d1a,
	0x7d1c,
	0x7d0d,
	0x7d19,
	0x7d1b,
	0x7f3a,
	0x7f5f,
	0x7f94,
	0x7fc5,
	0x7fc1,
	0x8006,
	0x8018,
	0x8015,
	0x8019,
	0x8017,
	0x803d,
	0x803f,
	0x80f1,
	0x8102,
	0x80f0,
	0x8105,
	0x80ed,
	0x80f4,
	0x8106,
	0x80f8,
	0x80f3,
	0x8108,
	0x80fd,
	0x810a,
	0x80fc,
	0x80ef,
	0x81ed,
	0x81ec,
	0x8200,
	0x8210,
	0x822a,
	0x822b,
	0x8228,
	0x822c,
	0x82bb,
	0x832b,
	0x8352,
	0x8354,
	0x834a,
	0x8338,
	0x8350,
	0x8349,
	0x8335,
	0x8334,
	0x834f,
	0x8332,
	0x8339,
	0x8336,
	0x8317,
	0x8340,
	0x8331,
	0x8328,
	0x8343
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_30[]=
	{
	0x8654,
	0x868a,
	0x86aa,
	0x8693,
	0x86a4,
	0x86a9,
	0x868c,
	0x86a3,
	0x869c,
	0x8870,
	0x8877,
	0x8881,
	0x8882,
	0x887d,
	0x8879,
	0x8a18,
	0x8a10,
	0x8a0e,
	0x8a0c,
	0x8a15,
	0x8a0a,
	0x8a17,
	0x8a13,
	0x8a16,
	0x8a0f,
	0x8a11,
	0x8c48,
	0x8c7a,
	0x8c79,
	0x8ca1,
	0x8ca2,
	0x8d77,
	0x8eac,
	0x8ed2,
	0x8ed4,
	0x8ecf,
	0x8fb1,
	0x9001,
	0x9006,
	0x8ff7,
	0x9000,
	0x8ffa,
	0x8ff4,
	0x9003,
	0x8ffd,
	0x9005,
	0x8ff8,
	0x9095,
	0x90e1,
	0x90dd,
	0x90e2,
	0x9152,
	0x914d,
	0x914c,
	0x91d8,
	0x91dd,
	0x91d7,
	0x91dc,
	0x91d9,
	0x9583,
	0x9662,
	0x9663,
	0x9661
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_31[]=
	{
	0x965b,
	0x965d,
	0x9664,
	0x9658,
	0x965e,
	0x96bb,
	0x98e2,
	0x99ac,
	0x9aa8,
	0x9ad8,
	0x9b25,
	0x9b32,
	0x9b3c,
	0x4e7e,
	0x507a,
	0x507d,
	0x505c,
	0x5047,
	0x5043,
	0x504c,
	0x505a,
	0x5049,
	0x5065,
	0x5076,
	0x504e,
	0x5055,
	0x5075,
	0x5074,
	0x5077,
	0x504f,
	0x500f,
	0x506f,
	0x506d,
	0x515c,
	0x5195,
	0x51f0,
	0x526a,
	0x526f,
	0x52d2,
	0x52d9,
	0x52d8,
	0x52d5,
	0x5310,
	0x530f,
	0x5319,
	0x533f,
	0x5340,
	0x533e,
	0x53c3,
	0x66fc,
	0x5546,
	0x556a,
	0x5566,
	0x5544,
	0x555e,
	0x5561,
	0x5543,
	0x554a,
	0x5531,
	0x5556,
	0x554f,
	0x5555,
	0x552f,
	0x5564,
	0x5538,
	0x552e,
	0x555c,
	0x552c,
	0x5563,
	0x5533,
	0x5541,
	0x5557,
	0x5708,
	0x570b,
	0x5709,
	0x57df,
	0x5805,
	0x580a,
	0x5806,
	0x57e0,
	0x57e4,
	0x57fa,
	0x5802,
	0x5835,
	0x57f7,
	0x57f9,
	0x5920,
	0x5962,
	0x5a36,
	0x5a41,
	0x5a49,
	0x5a66,
	0x5a6a,
	0x5a40
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_32[]=
	{
	0x5a3c,
	0x5a62,
	0x5a5a,
	0x5a46,
	0x5a4a,
	0x5b70,
	0x5bc7,
	0x5bc5,
	0x5bc4,
	0x5bc2,
	0x5bbf,
	0x5bc6,
	0x5c09,
	0x5c08,
	0x5c07,
	0x5c60,
	0x5c5c,
	0x5c5d,
	0x5d07,
	0x5d06,
	0x5d0e,
	0x5d1b,
	0x5d16,
	0x5d22,
	0x5d11,
	0x5d29,
	0x5d14,
	0x5d19,
	0x5d24,
	0x5d27,
	0x5d17,
	0x5de2,
	0x5e38,
	0x5e36,
	0x5e33,
	0x5e37,
	0x5eb7,
	0x5eb8,
	0x5eb6,
	0x5eb5,
	0x5ebe,
	0x5f35,
	0x5f37,
	0x5f57,
	0x5f6c,
	0x5f69,
	0x5f6b,
	0x5f97,
	0x5f99,
	0x5f9e,
	0x5f98,
	0x5fa1,
	0x5fa0,
	0x5f9c,
	0x607f,
	0x60a3,
	0x6089,
	0x60a0,
	0x60a8,
	0x60cb,
	0x60b4,
	0x60e6,
	0x60bd
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_33[]=
	{
	0x60c5,
	0x60bb,
	0x60b5,
	0x60dc,
	0x60bc,
	0x60d8,
	0x60d5,
	0x60c6,
	0x60df,
	0x60b8,
	0x60da,
	0x60c7,
	0x621a,
	0x621b,
	0x6248,
	0x63a0,
	0x63a7,
	0x6372,
	0x6396,
	0x63a2,
	0x63a5,
	0x6377,
	0x6367,
	0x6398,
	0x63aa,
	0x6371,
	0x63a9,
	0x6389,
	0x6383,
	0x639b,
	0x636b,
	0x63a8,
	0x6384,
	0x6388,
	0x6399,
	0x63a1,
	0x63ac,
	0x6392,
	0x638f,
	0x6380,
	0x637b,
	0x6369,
	0x6368,
	0x637a,
	0x655d,
	0x6556,
	0x6551,
	0x6559,
	0x6557,
	0x555f,
	0x654f,
	0x6558,
	0x6555,
	0x6554,
	0x659c,
	0x659b,
	0x65ac,
	0x65cf,
	0x65cb,
	0x65cc,
	0x65ce,
	0x665d,
	0x665a,
	0x6664,
	0x6668,
	0x6666,
	0x665e,
	0x66f9,
	0x52d7,
	0x671b,
	0x6881,
	0x68af,
	0x68a2,
	0x6893,
	0x68b5,
	0x687f,
	0x6876,
	0x68b1,
	0x68a7,
	0x6897,
	0x68b0,
	0x6883,
	0x68c4,
	0x68ad,
	0x6886,
	0x6885,
	0x6894,
	0x689d,
	0x68a8,
	0x689f,
	0x68a1,
	0x6882,
	0x6b32,
	0x6bba
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_34[]=
	{
	0x6beb,
	0x6bec,
	0x6c2b,
	0x6d8e,
	0x6dbc,
	0x6df3,
	0x6dd9,
	0x6db2,
	0x6de1,
	0x6dcc,
	0x6de4,
	0x6dfb,
	0x6dfa,
	0x6e05,
	0x6dc7,
	0x6dcb,
	0x6daf,
	0x6dd1,
	0x6dae,
	0x6dde,
	0x6df9,
	0x6db8,
	0x6df7,
	0x6df5,
	0x6dc5,
	0x6dd2,
	0x6e1a,
	0x6db5,
	0x6dda,
	0x6deb,
	0x6dd8,
	0x6dea,
	0x6df1,
	0x6dee,
	0x6de8,
	0x6dc6,
	0x6dc4,
	0x6daa,
	0x6dec,
	0x6dbf,
	0x6de6,
	0x70f9,
	0x7109,
	0x710a,
	0x70fd,
	0x70ef,
	0x723d,
	0x727d,
	0x7281,
	0x731c,
	0x731b,
	0x7316,
	0x7313,
	0x7319,
	0x7387,
	0x7405,
	0x740a,
	0x7403,
	0x7406,
	0x73fe,
	0x740d,
	0x74e0,
	0x74f6
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_35[]=
	{
	0x74f7,
	0x751c,
	0x7522,
	0x7565,
	0x7566,
	0x7562,
	0x7570,
	0x758f,
	0x75d4,
	0x75d5,
	0x75b5,
	0x75ca,
	0x75cd,
	0x768e,
	0x76d4,
	0x76d2,
	0x76db,
	0x7737,
	0x773e,
	0x773c,
	0x7736,
	0x7738,
	0x773a,
	0x786b,
	0x7843,
	0x784e,
	0x7965,
	0x7968,
	0x796d,
	0x79fb,
	0x7a92,
	0x7a95,
	0x7b20,
	0x7b28,
	0x7b1b,
	0x7b2c,
	0x7b26,
	0x7b19,
	0x7b1e,
	0x7b2e,
	0x7c92,
	0x7c97,
	0x7c95,
	0x7d46,
	0x7d43,
	0x7d71,
	0x7d2e,
	0x7d39,
	0x7d3c,
	0x7d40,
	0x7d30,
	0x7d33,
	0x7d44,
	0x7d2f,
	0x7d42,
	0x7d32,
	0x7d31,
	0x7f3d,
	0x7f9e,
	0x7f9a,
	0x7fcc,
	0x7fce,
	0x7fd2,
	0x801c,
	0x804a,
	0x8046,
	0x812f,
	0x8116,
	0x8123,
	0x812b,
	0x8129,
	0x8130,
	0x8124,
	0x8202,
	0x8235,
	0x8237,
	0x8236,
	0x8239,
	0x838e,
	0x839e,
	0x8398,
	0x8378,
	0x83a2,
	0x8396,
	0x83bd,
	0x83ab,
	0x8392,
	0x838a,
	0x8393,
	0x8389,
	0x83a0,
	0x8377,
	0x837b,
	0x837c
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_36[]=
	{
	0x8386,
	0x83a7,
	0x8655,
	0x5f6a,
	0x86c7,
	0x86c0,
	0x86b6,
	0x86c4,
	0x86b5,
	0x86c6,
	0x86cb,
	0x86b1,
	0x86af,
	0x86c9,
	0x8853,
	0x889e,
	0x8888,
	0x88ab,
	0x8892,
	0x8896,
	0x888d,
	0x888b,
	0x8993,
	0x898f,
	0x8a2a,
	0x8a1d,
	0x8a23,
	0x8a25,
	0x8a31,
	0x8a2d,
	0x8a1f,
	0x8a1b,
	0x8a22,
	0x8c49,
	0x8c5a,
	0x8ca9,
	0x8cac,
	0x8cab,
	0x8ca8,
	0x8caa,
	0x8ca7,
	0x8d67,
	0x8d66,
	0x8dbe,
	0x8dba,
	0x8edb,
	0x8edf,
	0x9019,
	0x900d,
	0x901a,
	0x9017,
	0x9023,
	0x901f,
	0x901d,
	0x9010,
	0x9015,
	0x901e,
	0x9020,
	0x900f,
	0x9022,
	0x9016,
	0x901b,
	0x9014
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_37[]=
	{
	0x90e8,
	0x90ed,
	0x90fd,
	0x9157,
	0x91ce,
	0x91f5,
	0x91e6,
	0x91e3,
	0x91e7,
	0x91ed,
	0x91e9,
	0x9589,
	0x966a,
	0x9675,
	0x9673,
	0x9678,
	0x9670,
	0x9674,
	0x9676,
	0x9677,
	0x966c,
	0x96c0,
	0x96ea,
	0x96e9,
	0x7ae0,
	0x7adf,
	0x9802,
	0x9803,
	0x9b5a,
	0x9ce5,
	0x9e75,
	0x9e7f,
	0x9ea5,
	0x9ebb,
	0x50a2,
	0x508d,
	0x5085,
	0x5099,
	0x5091,
	0x5080,
	0x5096,
	0x5098,
	0x509a,
	0x6700,
	0x51f1,
	0x5272,
	0x5274,
	0x5275,
	0x5269,
	0x52de,
	0x52dd,
	0x52db,
	0x535a,
	0x53a5,
	0x557b,
	0x5580,
	0x55a7,
	0x557c,
	0x558a,
	0x559d,
	0x5598,
	0x5582,
	0x559c,
	0x55aa,
	0x5594,
	0x5587,
	0x558b,
	0x5583,
	0x55b3,
	0x55ae,
	0x559f,
	0x553e,
	0x55b2,
	0x559a,
	0x55bb,
	0x55ac,
	0x55b1,
	0x557e,
	0x5589,
	0x55ab,
	0x5599,
	0x570d,
	0x582f,
	0x582a,
	0x5834,
	0x5824,
	0x5830,
	0x5831,
	0x5821,
	0x581d,
	0x5820,
	0x58f9,
	0x58fa,
	0x5960
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_38[]=
	{
	0x5a77,
	0x5a9a,
	0x5a7f,
	0x5a92,
	0x5a9b,
	0x5aa7,
	0x5b73,
	0x5b71,
	0x5bd2,
	0x5bcc,
	0x5bd3,
	0x5bd0,
	0x5c0a,
	0x5c0b,
	0x5c31,
	0x5d4c,
	0x5d50,
	0x5d34,
	0x5d47,
	0x5dfd,
	0x5e45,
	0x5e3d,
	0x5e40,
	0x5e43,
	0x5e7e,
	0x5eca,
	0x5ec1,
	0x5ec2,
	0x5ec4,
	0x5f3c,
	0x5f6d,
	0x5fa9,
	0x5faa,
	0x5fa8,
	0x60d1,
	0x60e1,
	0x60b2,
	0x60b6,
	0x60e0,
	0x611c,
	0x6123,
	0x60fa,
	0x6115,
	0x60f0,
	0x60fb,
	0x60f4,
	0x6168,
	0x60f1,
	0x610e,
	0x60f6,
	0x6109,
	0x6100,
	0x6112,
	0x621f,
	0x6249,
	0x63a3,
	0x638c,
	0x63cf,
	0x63c0,
	0x63e9,
	0x63c9,
	0x63c6,
	0x63cd
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_39[]=
	{
	0x63d2,
	0x63e3,
	0x63d0,
	0x63e1,
	0x63d6,
	0x63ed,
	0x63ee,
	0x6376,
	0x63f4,
	0x63ea,
	0x63db,
	0x6452,
	0x63da,
	0x63f9,
	0x655e,
	0x6566,
	0x6562,
	0x6563,
	0x6591,
	0x6590,
	0x65af,
	0x666e,
	0x6670,
	0x6674,
	0x6676,
	0x666f,
	0x6691,
	0x667a,
	0x667e,
	0x6677,
	0x66fe,
	0x66ff,
	0x671f,
	0x671d,
	0x68fa,
	0x68d5,
	0x68e0,
	0x68d8,
	0x68d7,
	0x6905,
	0x68df,
	0x68f5,
	0x68ee,
	0x68e7,
	0x68f9,
	0x68d2,
	0x68f2,
	0x68e3,
	0x68cb,
	0x68cd,
	0x690d,
	0x6912,
	0x690e,
	0x68c9,
	0x68da,
	0x696e,
	0x68fb,
	0x6b3e,
	0x6b3a,
	0x6b3d,
	0x6b98,
	0x6b96,
	0x6bbc,
	0x6bef,
	0x6c2e,
	0x6c2f,
	0x6c2c,
	0x6e2f,
	0x6e38,
	0x6e54,
	0x6e21,
	0x6e32,
	0x6e67,
	0x6e4a,
	0x6e20,
	0x6e25,
	0x6e23,
	0x6e1b,
	0x6e5b,
	0x6e58,
	0x6e24,
	0x6e56,
	0x6e6e,
	0x6e2d,
	0x6e26,
	0x6e6f,
	0x6e34,
	0x6e4d,
	0x6e3a,
	0x6e2c,
	0x6e43,
	0x6e1d,
	0x6e3e,
	0x6ecb
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_40[]=
	{
	0x6e89,
	0x6e19,
	0x6e4e,
	0x6e63,
	0x6e44,
	0x6e72,
	0x6e69,
	0x6e5f,
	0x7119,
	0x711a,
	0x7126,
	0x7130,
	0x7121,
	0x7136,
	0x716e,
	0x711c,
	0x724c,
	0x7284,
	0x7280,
	0x7336,
	0x7325,
	0x7334,
	0x7329,
	0x743a,
	0x742a,
	0x7433,
	0x7422,
	0x7425,
	0x7435,
	0x7436,
	0x7434,
	0x742f,
	0x741b,
	0x7426,
	0x7428,
	0x7525,
	0x7526,
	0x756b,
	0x756a,
	0x75e2,
	0x75db,
	0x75e3,
	0x75d9,
	0x75d8,
	0x75de,
	0x75e0,
	0x767b,
	0x767c,
	0x7696,
	0x7693,
	0x76b4,
	0x76dc,
	0x774f,
	0x77ed,
	0x785d,
	0x786c,
	0x786f,
	0x7a0d,
	0x7a08,
	0x7a0b,
	0x7a05,
	0x7a00,
	0x7a98
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_41[]=
	{
	0x7a97,
	0x7a96,
	0x7ae5,
	0x7ae3,
	0x7b49,
	0x7b56,
	0x7b46,
	0x7b50,
	0x7b52,
	0x7b54,
	0x7b4d,
	0x7b4b,
	0x7b4f,
	0x7b51,
	0x7c9f,
	0x7ca5,
	0x7d5e,
	0x7d50,
	0x7d68,
	0x7d55,
	0x7d2b,
	0x7d6e,
	0x7d72,
	0x7d61,
	0x7d66,
	0x7d62,
	0x7d70,
	0x7d73,
	0x5584,
	0x7fd4,
	0x7fd5,
	0x800b,
	0x8052,
	0x8085,
	0x8155,
	0x8154,
	0x814b,
	0x8151,
	0x814e,
	0x8139,
	0x8146,
	0x813e,
	0x814c,
	0x8153,
	0x8174,
	0x8212,
	0x821c,
	0x83e9,
	0x8403,
	0x83f8,
	0x840d,
	0x83e0,
	0x83c5,
	0x840b,
	0x83c1,
	0x83ef,
	0x83f1,
	0x83f4,
	0x8457,
	0x840a,
	0x83f0,
	0x840c,
	0x83cc,
	0x83fd,
	0x83f2,
	0x83ca,
	0x8438,
	0x840e,
	0x8404,
	0x83dc,
	0x8407,
	0x83d4,
	0x83df,
	0x865b,
	0x86df,
	0x86d9,
	0x86ed,
	0x86d4,
	0x86db,
	0x86e4,
	0x86d0,
	0x86de,
	0x8857,
	0x88c1,
	0x88c2,
	0x88b1,
	0x8983,
	0x8996,
	0x8a3b,
	0x8a60,
	0x8a55,
	0x8a5e,
	0x8a3c,
	0x8a41
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_42[]=
	{
	0x8a54,
	0x8a5b,
	0x8a50,
	0x8a46,
	0x8a34,
	0x8a3a,
	0x8a36,
	0x8a56,
	0x8c61,
	0x8c82,
	0x8caf,
	0x8cbc,
	0x8cb3,
	0x8cbd,
	0x8cc1,
	0x8cbb,
	0x8cc0,
	0x8cb4,
	0x8cb7,
	0x8cb6,
	0x8cbf,
	0x8cb8,
	0x8d8a,
	0x8d85,
	0x8d81,
	0x8dce,
	0x8ddd,
	0x8dcb,
	0x8dda,
	0x8dd1,
	0x8dcc,
	0x8ddb,
	0x8dc6,
	0x8efb,
	0x8ef8,
	0x8efc,
	0x8f9c,
	0x902e,
	0x9035,
	0x9031,
	0x9038,
	0x9032,
	0x9036,
	0x9102,
	0x90f5,
	0x9109,
	0x90fe,
	0x9163,
	0x9165,
	0x91cf,
	0x9214,
	0x9215,
	0x9223,
	0x9209,
	0x921e,
	0x920d,
	0x9210,
	0x9207,
	0x9211,
	0x9594,
	0x958f,
	0x958b,
	0x9591
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_43[]=
	{
	0x9593,
	0x9592,
	0x958e,
	0x968a,
	0x968e,
	0x968b,
	0x967d,
	0x9685,
	0x9686,
	0x968d,
	0x9672,
	0x9684,
	0x96c1,
	0x96c5,
	0x96c4,
	0x96c6,
	0x96c7,
	0x96ef,
	0x96f2,
	0x97cc,
	0x9805,
	0x9806,
	0x9808,
	0x98e7,
	0x98ea,
	0x98ef,
	0x98e9,
	0x98f2,
	0x98ed,
	0x99ae,
	0x99ad,
	0x9ec3,
	0x9ecd,
	0x9ed1,
	0x4e82,
	0x50ad,
	0x50b5,
	0x50b2,
	0x50b3,
	0x50c5,
	0x50be,
	0x50ac,
	0x50b7,
	0x50bb,
	0x50af,
	0x50c7,
	0x527f,
	0x5277,
	0x527d,
	0x52df,
	0x52e6,
	0x52e4,
	0x52e2,
	0x52e3,
	0x532f,
	0x55df,
	0x55e8,
	0x55d3,
	0x55e6,
	0x55ce,
	0x55dc,
	0x55c7,
	0x55d1,
	0x55e3,
	0x55e4,
	0x55ef,
	0x55da,
	0x55e1,
	0x55c5,
	0x55c6,
	0x55e5,
	0x55c9,
	0x5712,
	0x5713,
	0x585e,
	0x5851,
	0x5858,
	0x5857,
	0x585a,
	0x5854,
	0x586b,
	0x584c,
	0x586d,
	0x584a,
	0x5862,
	0x5852,
	0x584b,
	0x5967,
	0x5ac1,
	0x5ac9,
	0x5acc,
	0x5abe,
	0x5abd,
	0x5abc
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_44[]=
	{
	0x5ab3,
	0x5ac2,
	0x5ab2,
	0x5d69,
	0x5d6f,
	0x5e4c,
	0x5e79,
	0x5ec9,
	0x5ec8,
	0x5f12,
	0x5f59,
	0x5fac,
	0x5fae,
	0x611a,
	0x610f,
	0x6148,
	0x611f,
	0x60f3,
	0x611b,
	0x60f9,
	0x6101,
	0x6108,
	0x614e,
	0x614c,
	0x6144,
	0x614d,
	0x613e,
	0x6134,
	0x6127,
	0x610d,
	0x6106,
	0x6137,
	0x6221,
	0x6222,
	0x6413,
	0x643e,
	0x641e,
	0x642a,
	0x642d,
	0x643d,
	0x642c,
	0x640f,
	0x641c,
	0x6414,
	0x640d,
	0x6436,
	0x6416,
	0x6417,
	0x6406,
	0x656c,
	0x659f,
	0x65b0,
	0x6697,
	0x6689,
	0x6687,
	0x6688,
	0x6696,
	0x6684,
	0x6698,
	0x668d,
	0x6703,
	0x6994,
	0x696d
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_45[]=
	{
	0x695a,
	0x6977,
	0x6960,
	0x6954,
	0x6975,
	0x6930,
	0x6982,
	0x694a,
	0x6968,
	0x696b,
	0x695e,
	0x6953,
	0x6979,
	0x6986,
	0x695d,
	0x6963,
	0x695b,
	0x6b47,
	0x6b72,
	0x6bc0,
	0x6bbf,
	0x6bd3,
	0x6bfd,
	0x6ea2,
	0x6eaf,
	0x6ed3,
	0x6eb6,
	0x6ec2,
	0x6e90,
	0x6e9d,
	0x6ec7,
	0x6ec5,
	0x6ea5,
	0x6e98,
	0x6ebc,
	0x6eba,
	0x6eab,
	0x6ed1,
	0x6e96,
	0x6e9c,
	0x6ec4,
	0x6ed4,
	0x6eaa,
	0x6ea7,
	0x6eb4,
	0x714e,
	0x7159,
	0x7169,
	0x7164,
	0x7149,
	0x7167,
	0x715c,
	0x716c,
	0x7166,
	0x714c,
	0x7165,
	0x715e,
	0x7146,
	0x7168,
	0x7156,
	0x723a,
	0x7252,
	0x7337,
	0x7345,
	0x733f,
	0x733e,
	0x746f,
	0x745a,
	0x7455,
	0x745f,
	0x745e,
	0x7441,
	0x743f,
	0x7459,
	0x745b,
	0x745c,
	0x7576,
	0x7578,
	0x7600,
	0x75f0,
	0x7601,
	0x75f2,
	0x75f1,
	0x75fa,
	0x75ff,
	0x75f4,
	0x75f3,
	0x76de,
	0x76df,
	0x775b,
	0x776b,
	0x7766,
	0x775e,
	0x7763
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_46[]=
	{
	0x7779,
	0x776a,
	0x776c,
	0x775c,
	0x7765,
	0x7768,
	0x7762,
	0x77ee,
	0x788e,
	0x78b0,
	0x7897,
	0x7898,
	0x788c,
	0x7889,
	0x787c,
	0x7891,
	0x7893,
	0x787f,
	0x797a,
	0x797f,
	0x7981,
	0x842c,
	0x79bd,
	0x7a1c,
	0x7a1a,
	0x7a20,
	0x7a14,
	0x7a1f,
	0x7a1e,
	0x7a9f,
	0x7aa0,
	0x7b77,
	0x7bc0,
	0x7b60,
	0x7b6e,
	0x7b67,
	0x7cb1,
	0x7cb3,
	0x7cb5,
	0x7d93,
	0x7d79,
	0x7d91,
	0x7d81,
	0x7d8f,
	0x7d5b,
	0x7f6e,
	0x7f69,
	0x7f6a,
	0x7f72,
	0x7fa9,
	0x7fa8,
	0x7fa4,
	0x8056,
	0x8058,
	0x8086,
	0x8084,
	0x8171,
	0x8170,
	0x8178,
	0x8165,
	0x816e,
	0x8173,
	0x816b
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_47[]=
	{
	0x8179,
	0x817a,
	0x8166,
	0x8205,
	0x8247,
	0x8482,
	0x8477,
	0x843d,
	0x8431,
	0x8475,
	0x8466,
	0x846b,
	0x8449,
	0x846c,
	0x845b,
	0x843c,
	0x8435,
	0x8461,
	0x8463,
	0x8469,
	0x846d,
	0x8446,
	0x865e,
	0x865c,
	0x865f,
	0x86f9,
	0x8713,
	0x8708,
	0x8707,
	0x8700,
	0x86fe,
	0x86fb,
	0x8702,
	0x8703,
	0x8706,
	0x870a,
	0x8859,
	0x88df,
	0x88d4,
	0x88d9,
	0x88dc,
	0x88d8,
	0x88dd,
	0x88e1,
	0x88ca,
	0x88d5,
	0x88d2,
	0x899c,
	0x89e3,
	0x8a6b,
	0x8a72,
	0x8a73,
	0x8a66,
	0x8a69,
	0x8a70,
	0x8a87,
	0x8a7c,
	0x8a63,
	0x8aa0,
	0x8a71,
	0x8a85,
	0x8a6d,
	0x8a62,
	0x8a6e,
	0x8a6c,
	0x8a79,
	0x8a7b,
	0x8a3e,
	0x8a68,
	0x8c62,
	0x8c8a,
	0x8c89,
	0x8cca,
	0x8cc7,
	0x8cc8,
	0x8cc4,
	0x8cb2,
	0x8cc3,
	0x8cc2,
	0x8cc5,
	0x8de1,
	0x8ddf,
	0x8de8,
	0x8def,
	0x8df3,
	0x8dfa,
	0x8dea,
	0x8de4,
	0x8de6,
	0x8eb2,
	0x8f03,
	0x8f09,
	0x8efe,
	0x8f0a
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_48[]=
	{
	0x8f9f,
	0x8fb2,
	0x904b,
	0x904a,
	0x9053,
	0x9042,
	0x9054,
	0x903c,
	0x9055,
	0x9050,
	0x9047,
	0x904f,
	0x904e,
	0x904d,
	0x9051,
	0x903e,
	0x9041,
	0x9112,
	0x9117,
	0x916c,
	0x916a,
	0x9169,
	0x91c9,
	0x9237,
	0x9257,
	0x9238,
	0x923d,
	0x9240,
	0x923e,
	0x925b,
	0x924b,
	0x9264,
	0x9251,
	0x9234,
	0x9249,
	0x924d,
	0x9245,
	0x9239,
	0x923f,
	0x925a,
	0x9598,
	0x9698,
	0x9694,
	0x9695,
	0x96cd,
	0x96cb,
	0x96c9,
	0x96ca,
	0x96f7,
	0x96fb,
	0x96f9,
	0x96f6,
	0x9756,
	0x9774,
	0x9776,
	0x9810,
	0x9811,
	0x9813,
	0x980a,
	0x9812,
	0x980c,
	0x98fc,
	0x98f4
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_49[]=
	{
	0x98fd,
	0x98fe,
	0x99b3,
	0x99b1,
	0x99b4,
	0x9ae1,
	0x9ce9,
	0x9e82,
	0x9f0e,
	0x9f13,
	0x9f20,
	0x50e7,
	0x50ee,
	0x50e5,
	0x50d6,
	0x50ed,
	0x50da,
	0x50d5,
	0x50cf,
	0x50d1,
	0x50f1,
	0x50ce,
	0x50e9,
	0x5162,
	0x51f3,
	0x5283,
	0x5282,
	0x5331,
	0x53ad,
	0x55fe,
	0x5600,
	0x561b,
	0x5617,
	0x55fd,
	0x5614,
	0x5606,
	0x5609,
	0x560d,
	0x560e,
	0x55f7,
	0x5616,
	0x561f,
	0x5608,
	0x5610,
	0x55f6,
	0x5718,
	0x5716,
	0x5875,
	0x587e,
	0x5883,
	0x5893,
	0x588a,
	0x5879,
	0x5885,
	0x587d,
	0x58fd,
	0x5925,
	0x5922,
	0x5924,
	0x596a,
	0x5969,
	0x5ae1,
	0x5ae6,
	0x5ae9,
	0x5ad7,
	0x5ad6,
	0x5ad8,
	0x5ae3,
	0x5b75,
	0x5bde,
	0x5be7,
	0x5be1,
	0x5be5,
	0x5be6,
	0x5be8,
	0x5be2,
	0x5be4,
	0x5bdf,
	0x5c0d,
	0x5c62,
	0x5d84,
	0x5d87,
	0x5e5b,
	0x5e63,
	0x5e55,
	0x5e57,
	0x5e54,
	0x5ed3,
	0x5ed6,
	0x5f0a,
	0x5f46,
	0x5f70,
	0x5fb9,
	0x6147
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_50[]=
	{
	0x613f,
	0x614b,
	0x6177,
	0x6162,
	0x6163,
	0x615f,
	0x615a,
	0x6158,
	0x6175,
	0x622a,
	0x6487,
	0x6458,
	0x6454,
	0x64a4,
	0x6478,
	0x645f,
	0x647a,
	0x6451,
	0x6467,
	0x6434,
	0x646d,
	0x647b,
	0x6572,
	0x65a1,
	0x65d7,
	0x65d6,
	0x66a2,
	0x66a8,
	0x669d,
	0x699c,
	0x69a8,
	0x6995,
	0x69c1,
	0x69ae,
	0x69d3,
	0x69cb,
	0x699b,
	0x69b7,
	0x69bb,
	0x69ab,
	0x69b4,
	0x69d0,
	0x69cd,
	0x69ad,
	0x69cc,
	0x69a6,
	0x69c3,
	0x69a3,
	0x6b49,
	0x6b4c,
	0x6c33,
	0x6f33,
	0x6f14,
	0x6efe,
	0x6f13,
	0x6ef4,
	0x6f29,
	0x6f3e,
	0x6f20,
	0x6f2c,
	0x6f0f,
	0x6f02,
	0x6f22
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_51[]=
	{
	0x6eff,
	0x6eef,
	0x6f06,
	0x6f31,
	0x6f38,
	0x6f32,
	0x6f23,
	0x6f15,
	0x6f2b,
	0x6f2f,
	0x6f88,
	0x6f2a,
	0x6eec,
	0x6f01,
	0x6ef2,
	0x6ecc,
	0x6ef7,
	0x7194,
	0x7199,
	0x717d,
	0x718a,
	0x7184,
	0x7192,
	0x723e,
	0x7292,
	0x7296,
	0x7344,
	0x7350,
	0x7464,
	0x7463,
	0x746a,
	0x7470,
	0x746d,
	0x7504,
	0x7591,
	0x7627,
	0x760d,
	0x760b,
	0x7609,
	0x7613,
	0x76e1,
	0x76e3,
	0x7784,
	0x777d,
	0x777f,
	0x7761,
	0x78c1,
	0x789f,
	0x78a7,
	0x78b3,
	0x78a9,
	0x78a3,
	0x798e,
	0x798f,
	0x798d,
	0x7a2e,
	0x7a31,
	0x7aaa,
	0x7aa9,
	0x7aed,
	0x7aef,
	0x7ba1,
	0x7b95,
	0x7b8b,
	0x7b75,
	0x7b97,
	0x7b9d,
	0x7b94,
	0x7b8f,
	0x7bb8,
	0x7b87,
	0x7b84,
	0x7cb9,
	0x7cbd,
	0x7cbe,
	0x7dbb,
	0x7db0,
	0x7d9c,
	0x7dbd,
	0x7dbe,
	0x7da0,
	0x7dca,
	0x7db4,
	0x7db2,
	0x7db1,
	0x7dba,
	0x7da2,
	0x7dbf,
	0x7db5,
	0x7db8,
	0x7dad,
	0x7dd2,
	0x7dc7,
	0x7dac
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_52[]=
	{
	0x7f70,
	0x7fe0,
	0x7fe1,
	0x7fdf,
	0x805e,
	0x805a,
	0x8087,
	0x8150,
	0x8180,
	0x818f,
	0x8188,
	0x818a,
	0x817f,
	0x8182,
	0x81e7,
	0x81fa,
	0x8207,
	0x8214,
	0x821e,
	0x824b,
	0x84c9,
	0x84bf,
	0x84c6,
	0x84c4,
	0x8499,
	0x849e,
	0x84b2,
	0x849c,
	0x84cb,
	0x84b8,
	0x84c0,
	0x84d3,
	0x8490,
	0x84bc,
	0x84d1,
	0x84ca,
	0x873f,
	0x871c,
	0x873b,
	0x8722,
	0x8725,
	0x8734,
	0x8718,
	0x8755,
	0x8737,
	0x8729,
	0x88f3,
	0x8902,
	0x88f4,
	0x88f9,
	0x88f8,
	0x88fd,
	0x88e8,
	0x891a,
	0x88ef,
	0x8aa6,
	0x8a8c,
	0x8a9e,
	0x8aa3,
	0x8a8d,
	0x8aa1,
	0x8a93,
	0x8aa4
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_53[]=
	{
	0x8aaa,
	0x8aa5,
	0x8aa8,
	0x8a98,
	0x8a91,
	0x8a9a,
	0x8aa7,
	0x8c6a,
	0x8c8d,
	0x8c8c,
	0x8cd3,
	0x8cd1,
	0x8cd2,
	0x8d6b,
	0x8d99,
	0x8d95,
	0x8dfc,
	0x8f14,
	0x8f12,
	0x8f15,
	0x8f13,
	0x8fa3,
	0x9060,
	0x9058,
	0x905c,
	0x9063,
	0x9059,
	0x905e,
	0x9062,
	0x905d,
	0x905b,
	0x9119,
	0x9118,
	0x911e,
	0x9175,
	0x9178,
	0x9177,
	0x9174,
	0x9278,
	0x9280,
	0x9285,
	0x9298,
	0x9296,
	0x927b,
	0x9293,
	0x929c,
	0x92a8,
	0x927c,
	0x9291,
	0x95a1,
	0x95a8,
	0x95a9,
	0x95a3,
	0x95a5,
	0x95a4,
	0x9699,
	0x969c,
	0x969b,
	0x96cc,
	0x96d2,
	0x9700,
	0x977c,
	0x9785,
	0x97f6,
	0x9817,
	0x9818,
	0x98af,
	0x98b1,
	0x9903,
	0x9905,
	0x990c,
	0x9909,
	0x99c1,
	0x9aaf,
	0x9ab0,
	0x9ae6,
	0x9b41,
	0x9b42,
	0x9cf4,
	0x9cf6,
	0x9cf3,
	0x9ebc,
	0x9f3b,
	0x9f4a,
	0x5104,
	0x5100,
	0x50fb,
	0x50f5,
	0x50f9,
	0x5102,
	0x5108,
	0x5109,
	0x5105,
	0x51dc
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_54[]=
	{
	0x5287,
	0x5288,
	0x5289,
	0x528d,
	0x528a,
	0x52f0,
	0x53b2,
	0x562e,
	0x563b,
	0x5639,
	0x5632,
	0x563f,
	0x5634,
	0x5629,
	0x5653,
	0x564e,
	0x5657,
	0x5674,
	0x5636,
	0x562f,
	0x5630,
	0x5880,
	0x589f,
	0x589e,
	0x58b3,
	0x589c,
	0x58ae,
	0x58a9,
	0x58a6,
	0x596d,
	0x5b09,
	0x5afb,
	0x5b0b,
	0x5af5,
	0x5b0c,
	0x5b08,
	0x5bee,
	0x5bec,
	0x5be9,
	0x5beb,
	0x5c64,
	0x5c65,
	0x5d9d,
	0x5d94,
	0x5e62,
	0x5e5f,
	0x5e61,
	0x5ee2,
	0x5eda,
	0x5edf,
	0x5edd,
	0x5ee3,
	0x5ee0,
	0x5f48,
	0x5f71,
	0x5fb7,
	0x5fb5,
	0x6176,
	0x6167,
	0x616e,
	0x615d,
	0x6155,
	0x6182
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_55[]=
	{
	0x617c,
	0x6170,
	0x616b,
	0x617e,
	0x61a7,
	0x6190,
	0x61ab,
	0x618e,
	0x61ac,
	0x619a,
	0x61a4,
	0x6194,
	0x61ae,
	0x622e,
	0x6469,
	0x646f,
	0x6479,
	0x649e,
	0x64b2,
	0x6488,
	0x6490,
	0x64b0,
	0x64a5,
	0x6493,
	0x6495,
	0x64a9,
	0x6492,
	0x64ae,
	0x64ad,
	0x64ab,
	0x649a,
	0x64ac,
	0x6499,
	0x64a2,
	0x64b3,
	0x6575,
	0x6577,
	0x6578,
	0x66ae,
	0x66ab,
	0x66b4,
	0x66b1,
	0x6a23,
	0x6a1f,
	0x69e8,
	0x6a01,
	0x6a1e,
	0x6a19,
	0x69fd,
	0x6a21,
	0x6a13,
	0x6a0a,
	0x69f3,
	0x6a02,
	0x6a05,
	0x69ed,
	0x6a11,
	0x6b50,
	0x6b4e,
	0x6ba4,
	0x6bc5,
	0x6bc6,
	0x6f3f,
	0x6f7c,
	0x6f84,
	0x6f51,
	0x6f66,
	0x6f54,
	0x6f86,
	0x6f6d,
	0x6f5b,
	0x6f78,
	0x6f6e,
	0x6f8e,
	0x6f7a,
	0x6f70,
	0x6f64,
	0x6f97,
	0x6f58,
	0x6ed5,
	0x6f6f,
	0x6f60,
	0x6f5f,
	0x719f,
	0x71ac,
	0x71b1,
	0x71a8,
	0x7256,
	0x729b,
	0x734e,
	0x7357,
	0x7469,
	0x748b,
	0x7483
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_56[]=
	{
	0x747e,
	0x7480,
	0x757f,
	0x7620,
	0x7629,
	0x761f,
	0x7624,
	0x7626,
	0x7621,
	0x7622,
	0x769a,
	0x76ba,
	0x76e4,
	0x778e,
	0x7787,
	0x778c,
	0x7791,
	0x778b,
	0x78cb,
	0x78c5,
	0x78ba,
	0x78ca,
	0x78be,
	0x78d5,
	0x78bc,
	0x78d0,
	0x7a3f,
	0x7a3c,
	0x7a40,
	0x7a3d,
	0x7a37,
	0x7a3b,
	0x7aaf,
	0x7aae,
	0x7bad,
	0x7bb1,
	0x7bc4,
	0x7bb4,
	0x7bc6,
	0x7bc7,
	0x7bc1,
	0x7ba0,
	0x7bcc,
	0x7cca,
	0x7de0,
	0x7df4,
	0x7def,
	0x7dfb,
	0x7dd8,
	0x7dec,
	0x7ddd,
	0x7de8,
	0x7de3,
	0x7dda,
	0x7dde,
	0x7de9,
	0x7d9e,
	0x7dd9,
	0x7df2,
	0x7df9,
	0x7f75,
	0x7f77,
	0x7faf
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_57[]=
	{
	0x7fe9,
	0x8026,
	0x819b,
	0x819c,
	0x819d,
	0x81a0,
	0x819a,
	0x8198,
	0x8517,
	0x853d,
	0x851a,
	0x84ee,
	0x852c,
	0x852d,
	0x8513,
	0x8511,
	0x8523,
	0x8521,
	0x8514,
	0x84ec,
	0x8525,
	0x84ff,
	0x8506,
	0x8782,
	0x8774,
	0x8776,
	0x8760,
	0x8766,
	0x8778,
	0x8768,
	0x8759,
	0x8757,
	0x874c,
	0x8753,
	0x885b,
	0x885d,
	0x8910,
	0x8907,
	0x8912,
	0x8913,
	0x8915,
	0x890a,
	0x8abc,
	0x8ad2,
	0x8ac7,
	0x8ac4,
	0x8a95,
	0x8acb,
	0x8af8,
	0x8ab2,
	0x8ac9,
	0x8ac2,
	0x8abf,
	0x8ab0,
	0x8ad6,
	0x8acd,
	0x8ab6,
	0x8ab9,
	0x8adb,
	0x8c4c,
	0x8c4e,
	0x8c6c,
	0x8ce0,
	0x8cde,
	0x8ce6,
	0x8ce4,
	0x8cec,
	0x8ced,
	0x8ce2,
	0x8ce3,
	0x8cdc,
	0x8cea,
	0x8ce1,
	0x8d6d,
	0x8d9f,
	0x8da3,
	0x8e2b,
	0x8e10,
	0x8e1d,
	0x8e22,
	0x8e0f,
	0x8e29,
	0x8e1f,
	0x8e21,
	0x8e1e,
	0x8eba,
	0x8f1d,
	0x8f1b,
	0x8f1f,
	0x8f29,
	0x8f26,
	0x8f2a,
	0x8f1c,
	0x8f1e
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_58[]=
	{
	0x8f25,
	0x9069,
	0x906e,
	0x9068,
	0x906d,
	0x9077,
	0x9130,
	0x912d,
	0x9127,
	0x9131,
	0x9187,
	0x9189,
	0x918b,
	0x9183,
	0x92c5,
	0x92bb,
	0x92b7,
	0x92ea,
	0x92ac,
	0x92e4,
	0x92c1,
	0x92b3,
	0x92bc,
	0x92d2,
	0x92c7,
	0x92f0,
	0x92b2,
	0x95ad,
	0x95b1,
	0x9704,
	0x9706,
	0x9707,
	0x9709,
	0x9760,
	0x978d,
	0x978b,
	0x978f,
	0x9821,
	0x982b,
	0x981c,
	0x98b3,
	0x990a,
	0x9913,
	0x9912,
	0x9918,
	0x99dd,
	0x99d0,
	0x99df,
	0x99db,
	0x99d1,
	0x99d5,
	0x99d2,
	0x99d9,
	0x9ab7,
	0x9aee,
	0x9aef,
	0x9b27,
	0x9b45,
	0x9b44,
	0x9b77,
	0x9b6f,
	0x9d06,
	0x9d09
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_59[]=
	{
	0x9d03,
	0x9ea9,
	0x9ebe,
	0x9ece,
	0x58a8,
	0x9f52,
	0x5112,
	0x5118,
	0x5114,
	0x5110,
	0x5115,
	0x5180,
	0x51aa,
	0x51dd,
	0x5291,
	0x5293,
	0x52f3,
	0x5659,
	0x566b,
	0x5679,
	0x5669,
	0x5664,
	0x5678,
	0x566a,
	0x5668,
	0x5665,
	0x5671,
	0x566f,
	0x566c,
	0x5662,
	0x5676,
	0x58c1,
	0x58be,
	0x58c7,
	0x58c5,
	0x596e,
	0x5b1d,
	0x5b34,
	0x5b78,
	0x5bf0,
	0x5c0e,
	0x5f4a,
	0x61b2,
	0x6191,
	0x61a9,
	0x618a,
	0x61cd,
	0x61b6,
	0x61be,
	0x61ca,
	0x61c8,
	0x6230,
	0x64c5,
	0x64c1,
	0x64cb,
	0x64bb,
	0x64bc,
	0x64da,
	0x64c4,
	0x64c7,
	0x64c2,
	0x64cd,
	0x64bf,
	0x64d2,
	0x64d4,
	0x64be,
	0x6574,
	0x66c6,
	0x66c9,
	0x66b9,
	0x66c4,
	0x66c7,
	0x66b8,
	0x6a3d,
	0x6a38,
	0x6a3a,
	0x6a59,
	0x6a6b,
	0x6a58,
	0x6a39,
	0x6a44,
	0x6a62,
	0x6a61,
	0x6a4b,
	0x6a47,
	0x6a35,
	0x6a5f,
	0x6a48,
	0x6b59,
	0x6b77,
	0x6c05,
	0x6fc2,
	0x6fb1,
	0x6fa1
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_60[]=
	{
	0x6fc3,
	0x6fa4,
	0x6fc1,
	0x6fa7,
	0x6fb3,
	0x6fc0,
	0x6fb9,
	0x6fb6,
	0x6fa6,
	0x6fa0,
	0x6fb4,
	0x71be,
	0x71c9,
	0x71d0,
	0x71d2,
	0x71c8,
	0x71d5,
	0x71b9,
	0x71ce,
	0x71d9,
	0x71dc,
	0x71c3,
	0x71c4,
	0x7368,
	0x749c,
	0x74a3,
	0x7498,
	0x749f,
	0x749e,
	0x74e2,
	0x750c,
	0x750d,
	0x7634,
	0x7638,
	0x763a,
	0x76e7,
	0x76e5,
	0x77a0,
	0x779e,
	0x779f,
	0x77a5,
	0x78e8,
	0x78da,
	0x78ec,
	0x78e7,
	0x79a6,
	0x7a4d,
	0x7a4e,
	0x7a46,
	0x7a4c,
	0x7a4b,
	0x7aba,
	0x7bd9,
	0x7c11,
	0x7bc9,
	0x7be4,
	0x7bdb,
	0x7be1,
	0x7be9,
	0x7be6,
	0x7cd5,
	0x7cd6,
	0x7e0a
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_61[]=
	{
	0x7e11,
	0x7e08,
	0x7e1b,
	0x7e23,
	0x7e1e,
	0x7e1d,
	0x7e09,
	0x7e10,
	0x7f79,
	0x7fb2,
	0x7ff0,
	0x7ff1,
	0x7fee,
	0x8028,
	0x81b3,
	0x81a9,
	0x81a8,
	0x81fb,
	0x8208,
	0x8258,
	0x8259,
	0x854a,
	0x8559,
	0x8548,
	0x8568,
	0x8569,
	0x8543,
	0x8549,
	0x856d,
	0x856a,
	0x855e,
	0x8783,
	0x879f,
	0x879e,
	0x87a2,
	0x878d,
	0x8861,
	0x892a,
	0x8932,
	0x8925,
	0x892b,
	0x8921,
	0x89aa,
	0x89a6,
	0x8ae6,
	0x8afa,
	0x8aeb,
	0x8af1,
	0x8b00,
	0x8adc,
	0x8ae7,
	0x8aee,
	0x8afe,
	0x8b01,
	0x8b02,
	0x8af7,
	0x8aed,
	0x8af3,
	0x8af6,
	0x8afc,
	0x8c6b,
	0x8c6d,
	0x8c93,
	0x8cf4,
	0x8e44,
	0x8e31,
	0x8e34,
	0x8e42,
	0x8e39,
	0x8e35,
	0x8f3b,
	0x8f2f,
	0x8f38,
	0x8f33,
	0x8fa8,
	0x8fa6,
	0x9075,
	0x9074,
	0x9078,
	0x9072,
	0x907c,
	0x907a,
	0x9134,
	0x9192,
	0x9320,
	0x9336,
	0x92f8,
	0x9333,
	0x932f,
	0x9322,
	0x92fc,
	0x932b,
	0x9304,
	0x931a
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_62[]=
	{
	0x9310,
	0x9326,
	0x9321,
	0x9315,
	0x932e,
	0x9319,
	0x95bb,
	0x96a7,
	0x96a8,
	0x96aa,
	0x96d5,
	0x970e,
	0x9711,
	0x9716,
	0x970d,
	0x9713,
	0x970f,
	0x975b,
	0x975c,
	0x9766,
	0x9798,
	0x9830,
	0x9838,
	0x983b,
	0x9837,
	0x982d,
	0x9839,
	0x9824,
	0x9910,
	0x9928,
	0x991e,
	0x991b,
	0x9921,
	0x991a,
	0x99ed,
	0x99e2,
	0x99f1,
	0x9ab8,
	0x9abc,
	0x9afb,
	0x9aed,
	0x9b28,
	0x9b91,
	0x9d15,
	0x9d23,
	0x9d26,
	0x9d28,
	0x9d12,
	0x9d1b,
	0x9ed8,
	0x9ed4,
	0x9f8d,
	0x9f9c,
	0x512a,
	0x511f,
	0x5121,
	0x5132,
	0x52f5,
	0x568e,
	0x5680,
	0x5690,
	0x5685,
	0x5687
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_63[]=
	{
	0x568f,
	0x58d5,
	0x58d3,
	0x58d1,
	0x58ce,
	0x5b30,
	0x5b2a,
	0x5b24,
	0x5b7a,
	0x5c37,
	0x5c68,
	0x5dbc,
	0x5dba,
	0x5dbd,
	0x5db8,
	0x5e6b,
	0x5f4c,
	0x5fbd,
	0x61c9,
	0x61c2,
	0x61c7,
	0x61e6,
	0x61cb,
	0x6232,
	0x6234,
	0x64ce,
	0x64ca,
	0x64d8,
	0x64e0,
	0x64f0,
	0x64e6,
	0x64ec,
	0x64f1,
	0x64e2,
	0x64ed,
	0x6582,
	0x6583,
	0x66d9,
	0x66d6,
	0x6a80,
	0x6a94,
	0x6a84,
	0x6aa2,
	0x6a9c,
	0x6adb,
	0x6aa3,
	0x6a7e,
	0x6a97,
	0x6a90,
	0x6aa0,
	0x6b5c,
	0x6bae,
	0x6bda,
	0x6c08,
	0x6fd8,
	0x6ff1,
	0x6fdf,
	0x6fe0,
	0x6fdb,
	0x6fe4,
	0x6feb,
	0x6fef,
	0x6f80,
	0x6fec,
	0x6fe1,
	0x6fe9,
	0x6fd5,
	0x6fee,
	0x6ff0,
	0x71e7,
	0x71df,
	0x71ee,
	0x71e6,
	0x71e5,
	0x71ed,
	0x71ec,
	0x71f4,
	0x71e0,
	0x7235,
	0x7246,
	0x7370,
	0x7372,
	0x74a9,
	0x74b0,
	0x74a6,
	0x74a8,
	0x7646,
	0x7642,
	0x764c,
	0x76ea,
	0x77b3,
	0x77aa,
	0x77b0,
	0x77ac
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_64[]=
	{
	0x77a7,
	0x77ad,
	0x77ef,
	0x78f7,
	0x78fa,
	0x78f4,
	0x78ef,
	0x7901,
	0x79a7,
	0x79aa,
	0x7a57,
	0x7abf,
	0x7c07,
	0x7c0d,
	0x7bfe,
	0x7bf7,
	0x7c0c,
	0x7be0,
	0x7ce0,
	0x7cdc,
	0x7cde,
	0x7ce2,
	0x7cdf,
	0x7cd9,
	0x7cdd,
	0x7e2e,
	0x7e3e,
	0x7e46,
	0x7e37,
	0x7e32,
	0x7e43,
	0x7e2b,
	0x7e3d,
	0x7e31,
	0x7e45,
	0x7e41,
	0x7e34,
	0x7e39,
	0x7e48,
	0x7e35,
	0x7e3f,
	0x7e2f,
	0x7f44,
	0x7ff3,
	0x7ffc,
	0x8071,
	0x8072,
	0x8070,
	0x806f,
	0x8073,
	0x81c6,
	0x81c3,
	0x81ba,
	0x81c2,
	0x81c0,
	0x81bf,
	0x81bd,
	0x81c9,
	0x81be,
	0x81e8,
	0x8209,
	0x8271,
	0x85aa
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_65[]=
	{
	0x8584,
	0x857e,
	0x859c,
	0x8591,
	0x8594,
	0x85af,
	0x859b,
	0x8587,
	0x85a8,
	0x858a,
	0x8667,
	0x87c0,
	0x87d1,
	0x87b3,
	0x87d2,
	0x87c6,
	0x87ab,
	0x87bb,
	0x87ba,
	0x87c8,
	0x87cb,
	0x893b,
	0x8936,
	0x8944,
	0x8938,
	0x893d,
	0x89ac,
	0x8b0e,
	0x8b17,
	0x8b19,
	0x8b1b,
	0x8b0a,
	0x8b20,
	0x8b1d,
	0x8b04,
	0x8b10,
	0x8c41,
	0x8c3f,
	0x8c73,
	0x8cfa,
	0x8cfd,
	0x8cfc,
	0x8cf8,
	0x8cfb,
	0x8da8,
	0x8e49,
	0x8e4b,
	0x8e48,
	0x8e4a,
	0x8f44,
	0x8f3e,
	0x8f42,
	0x8f45,
	0x8f3f,
	0x907f,
	0x907d,
	0x9084,
	0x9081,
	0x9082,
	0x9080,
	0x9139,
	0x91a3,
	0x919e,
	0x919c,
	0x934d,
	0x9382,
	0x9328,
	0x9375,
	0x934a,
	0x9365,
	0x934b,
	0x9318,
	0x937e,
	0x936c,
	0x935b,
	0x9370,
	0x935a,
	0x9354,
	0x95ca,
	0x95cb,
	0x95cc,
	0x95c8,
	0x95c6,
	0x96b1,
	0x96b8,
	0x96d6,
	0x971c,
	0x971e,
	0x97a0,
	0x97d3,
	0x9846,
	0x98b6,
	0x9935,
	0x9a01
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_66[]=
	{
	0x99ff,
	0x9bae,
	0x9bab,
	0x9baa,
	0x9bad,
	0x9d3b,
	0x9d3f,
	0x9e8b,
	0x9ecf,
	0x9ede,
	0x9edc,
	0x9edd,
	0x9edb,
	0x9f3e,
	0x9f4b,
	0x53e2,
	0x5695,
	0x56ae,
	0x58d9,
	0x58d8,
	0x5b38,
	0x5f5d,
	0x61e3,
	0x6233,
	0x64f4,
	0x64f2,
	0x64fe,
	0x6506,
	0x64fa,
	0x64fb,
	0x64f7,
	0x65b7,
	0x66dc,
	0x6726,
	0x6ab3,
	0x6aac,
	0x6ac3,
	0x6abb,
	0x6ab8,
	0x6ac2,
	0x6aae,
	0x6aaf,
	0x6b5f,
	0x6b78,
	0x6baf,
	0x7009,
	0x700b,
	0x6ffe,
	0x7006,
	0x6ffa,
	0x7011,
	0x700f,
	0x71fb,
	0x71fc,
	0x71fe,
	0x71f8,
	0x7377,
	0x7375,
	0x74a7,
	0x74bf,
	0x7515,
	0x7656,
	0x7658
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_67[]=
	{
	0x7652,
	0x77bd,
	0x77bf,
	0x77bb,
	0x77bc,
	0x790e,
	0x79ae,
	0x7a61,
	0x7a62,
	0x7a60,
	0x7ac4,
	0x7ac5,
	0x7c2b,
	0x7c27,
	0x7c2a,
	0x7c1e,
	0x7c23,
	0x7c21,
	0x7ce7,
	0x7e54,
	0x7e55,
	0x7e5e,
	0x7e5a,
	0x7e61,
	0x7e52,
	0x7e59,
	0x7f48,
	0x7ff9,
	0x7ffb,
	0x8077,
	0x8076,
	0x81cd,
	0x81cf,
	0x820a,
	0x85cf,
	0x85a9,
	0x85cd,
	0x85d0,
	0x85c9,
	0x85b0,
	0x85ba,
	0x85b9,
	0x85a6,
	0x87ef,
	0x87ec,
	0x87f2,
	0x87e0,
	0x8986,
	0x89b2,
	0x89f4,
	0x8b28,
	0x8b39,
	0x8b2c,
	0x8b2b,
	0x8c50,
	0x8d05,
	0x8e59,
	0x8e63,
	0x8e66,
	0x8e64,
	0x8e5f,
	0x8e55,
	0x8ec0,
	0x8f49,
	0x8f4d,
	0x9087,
	0x9083,
	0x9088,
	0x91ab,
	0x91ac,
	0x91d0,
	0x9394,
	0x938a,
	0x9396,
	0x93a2,
	0x93b3,
	0x93ae,
	0x93ac,
	0x93b0,
	0x9398,
	0x939a,
	0x9397,
	0x95d4,
	0x95d6,
	0x95d0,
	0x95d5,
	0x96e2,
	0x96dc,
	0x96d9,
	0x96db,
	0x96de,
	0x9724,
	0x97a3,
	0x97a6
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_68[]=
	{
	0x97ad,
	0x97f9,
	0x984d,
	0x984f,
	0x984c,
	0x984e,
	0x9853,
	0x98ba,
	0x993e,
	0x993f,
	0x993d,
	0x992e,
	0x99a5,
	0x9a0e,
	0x9ac1,
	0x9b03,
	0x9b06,
	0x9b4f,
	0x9b4e,
	0x9b4d,
	0x9bca,
	0x9bc9,
	0x9bfd,
	0x9bc8,
	0x9bc0,
	0x9d51,
	0x9d5d,
	0x9d60,
	0x9ee0,
	0x9f15,
	0x9f2c,
	0x5133,
	0x56a5,
	0x58de,
	0x58df,
	0x58e2,
	0x5bf5,
	0x9f90,
	0x5eec,
	0x61f2,
	0x61f7,
	0x61f6,
	0x61f5,
	0x6500,
	0x650f,
	0x66e0,
	0x66dd,
	0x6ae5,
	0x6add,
	0x6ada,
	0x6ad3,
	0x701b,
	0x701f,
	0x7028,
	0x701a,
	0x701d,
	0x7015,
	0x7018,
	0x7206,
	0x720d,
	0x7258,
	0x72a2,
	0x7378
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_69[]=
	{
	0x737a,
	0x74bd,
	0x74ca,
	0x74e3,
	0x7587,
	0x7586,
	0x765f,
	0x7661,
	0x77c7,
	0x7919,
	0x79b1,
	0x7a6b,
	0x7a69,
	0x7c3e,
	0x7c3f,
	0x7c38,
	0x7c3d,
	0x7c37,
	0x7c40,
	0x7e6b,
	0x7e6d,
	0x7e79,
	0x7e69,
	0x7e6a,
	0x7f85,
	0x7e73,
	0x7fb6,
	0x7fb9,
	0x7fb8,
	0x81d8,
	0x85e9,
	0x85dd,
	0x85ea,
	0x85d5,
	0x85e4,
	0x85e5,
	0x85f7,
	0x87fb,
	0x8805,
	0x880d,
	0x87f9,
	0x87fe,
	0x8960,
	0x895f,
	0x8956,
	0x895e,
	0x8b41,
	0x8b5c,
	0x8b58,
	0x8b49,
	0x8b5a,
	0x8b4e,
	0x8b4f,
	0x8b46,
	0x8b59,
	0x8d08,
	0x8d0a,
	0x8e7c,
	0x8e72,
	0x8e87,
	0x8e76,
	0x8e6c,
	0x8e7a,
	0x8e74,
	0x8f54,
	0x8f4e,
	0x8fad,
	0x908a,
	0x908b,
	0x91b1,
	0x91ae,
	0x93e1,
	0x93d1,
	0x93df,
	0x93c3,
	0x93c8,
	0x93dc,
	0x93dd,
	0x93d6,
	0x93e2,
	0x93cd,
	0x93d8,
	0x93e4,
	0x93d7,
	0x93e8,
	0x95dc,
	0x96b4,
	0x96e3,
	0x972a,
	0x9727,
	0x9761,
	0x97dc,
	0x97fb,
	0x985e
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_70[]=
	{
	0x9858,
	0x985b,
	0x98bc,
	0x9945,
	0x9949,
	0x9a16,
	0x9a19,
	0x9b0d,
	0x9be8,
	0x9be7,
	0x9bd6,
	0x9bdb,
	0x9d89,
	0x9d61,
	0x9d72,
	0x9d6a,
	0x9d6c,
	0x9e92,
	0x9e97,
	0x9e93,
	0x9eb4,
	0x52f8,
	0x56a8,
	0x56b7,
	0x56b6,
	0x56b4,
	0x56bc,
	0x58e4,
	0x5b40,
	0x5b43,
	0x5b7d,
	0x5bf6,
	0x5dc9,
	0x61f8,
	0x61fa,
	0x6518,
	0x6514,
	0x6519,
	0x66e6,
	0x6727,
	0x6aec,
	0x703e,
	0x7030,
	0x7032,
	0x7210,
	0x737b,
	0x74cf,
	0x7662,
	0x7665,
	0x7926,
	0x792a,
	0x792c,
	0x792b,
	0x7ac7,
	0x7af6,
	0x7c4c,
	0x7c43,
	0x7c4d,
	0x7cef,
	0x7cf0,
	0x8fae,
	0x7e7d,
	0x7e7c
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_71[]=
	{
	0x7e82,
	0x7f4c,
	0x8000,
	0x81da,
	0x8266,
	0x85fb,
	0x85f9,
	0x8611,
	0x85fa,
	0x8606,
	0x860b,
	0x8607,
	0x860a,
	0x8814,
	0x8815,
	0x8964,
	0x89ba,
	0x89f8,
	0x8b70,
	0x8b6c,
	0x8b66,
	0x8b6f,
	0x8b5f,
	0x8b6b,
	0x8d0f,
	0x8d0d,
	0x8e89,
	0x8e81,
	0x8e85,
	0x8e82,
	0x91b4,
	0x91cb,
	0x9418,
	0x9403,
	0x93fd,
	0x95e1,
	0x9730,
	0x98c4,
	0x9952,
	0x9951,
	0x99a8,
	0x9a2b,
	0x9a30,
	0x9a37,
	0x9a35,
	0x9c13,
	0x9c0d,
	0x9e79,
	0x9eb5,
	0x9ee8,
	0x9f2f,
	0x9f5f,
	0x9f63,
	0x9f61,
	0x5137,
	0x5138,
	0x56c1,
	0x56c0,
	0x56c2,
	0x5914,
	0x5c6c,
	0x5dcd,
	0x61fc,
	0x61fe,
	0x651d,
	0x651c,
	0x6595,
	0x66e9,
	0x6afb,
	0x6b04,
	0x6afa,
	0x6bb2,
	0x704c,
	0x721b,
	0x72a7,
	0x74d6,
	0x74d4,
	0x7669,
	0x77d3,
	0x7c50,
	0x7e8f,
	0x7e8c,
	0x7fbc,
	0x8617,
	0x862d,
	0x861a,
	0x8823,
	0x8822,
	0x8821,
	0x881f,
	0x896a,
	0x896c,
	0x89bd,
	0x8b74
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_72[]=
	{
	0x8b77,
	0x8b7d,
	0x8d13,
	0x8e8a,
	0x8e8d,
	0x8e8b,
	0x8f5f,
	0x8faf,
	0x91ba,
	0x942e,
	0x9433,
	0x9435,
	0x943a,
	0x9438,
	0x9432,
	0x942b,
	0x95e2,
	0x9738,
	0x9739,
	0x9732,
	0x97ff,
	0x9867,
	0x9865,
	0x9957,
	0x9a45,
	0x9a43,
	0x9a40,
	0x9a3e,
	0x9acf,
	0x9b54,
	0x9b51,
	0x9c2d,
	0x9c25,
	0x9daf,
	0x9db4,
	0x9dc2,
	0x9db8,
	0x9e9d,
	0x9eef,
	0x9f19,
	0x9f5c,
	0x9f66,
	0x9f67,
	0x513c,
	0x513b,
	0x56c8,
	0x56ca,
	0x56c9,
	0x5b7f,
	0x5dd4,
	0x5dd2,
	0x5f4e,
	0x61ff,
	0x6524,
	0x6b0a,
	0x6b61,
	0x7051,
	0x7058,
	0x7380,
	0x74e4,
	0x758a,
	0x766e,
	0x766c
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_73[]=
	{
	0x79b3,
	0x7c60,
	0x7c5f,
	0x807e,
	0x807d,
	0x81df,
	0x8972,
	0x896f,
	0x89fc,
	0x8b80,
	0x8d16,
	0x8d17,
	0x8e91,
	0x8e93,
	0x8f61,
	0x9148,
	0x9444,
	0x9451,
	0x9452,
	0x973d,
	0x973e,
	0x97c3,
	0x97c1,
	0x986b,
	0x9955,
	0x9a55,
	0x9a4d,
	0x9ad2,
	0x9b1a,
	0x9c49,
	0x9c31,
	0x9c3e,
	0x9c3b,
	0x9dd3,
	0x9dd7,
	0x9f34,
	0x9f6c,
	0x9f6a,
	0x9f94,
	0x56cc,
	0x5dd6,
	0x6200,
	0x6523,
	0x652b,
	0x652a,
	0x66ec,
	0x6b10,
	0x74da,
	0x7aca,
	0x7c64,
	0x7c63,
	0x7c65,
	0x7e93,
	0x7e96,
	0x7e94,
	0x81e2,
	0x8638,
	0x863f,
	0x8831,
	0x8b8a,
	0x9090,
	0x908f,
	0x9463,
	0x9460,
	0x9464,
	0x9768,
	0x986f,
	0x995c,
	0x9a5a,
	0x9a5b,
	0x9a57,
	0x9ad3,
	0x9ad4,
	0x9ad1,
	0x9c54,
	0x9c57,
	0x9c56,
	0x9de5,
	0x9e9f,
	0x9ef4,
	0x56d1,
	0x58e9,
	0x652c,
	0x705e,
	0x7671,
	0x7672,
	0x77d7,
	0x7f50,
	0x7f88,
	0x8836,
	0x8839,
	0x8862,
	0x8b93,
	0x8b92
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_74[]=
	{
	0x8b96,
	0x8277,
	0x8d1b,
	0x91c0,
	0x946a,
	0x9742,
	0x9748,
	0x9744,
	0x97c6,
	0x9870,
	0x9a5f,
	0x9b22,
	0x9b58,
	0x9c5f,
	0x9df9,
	0x9dfa,
	0x9e7c,
	0x9e7d,
	0x9f07,
	0x9f77,
	0x9f72,
	0x5ef3,
	0x6b16,
	0x7063,
	0x7c6c,
	0x7c6e,
	0x883b,
	0x89c0,
	0x8ea1,
	0x91c1,
	0x9472,
	0x9470,
	0x9871,
	0x995e,
	0x9ad6,
	0x9b23,
	0x9ecc,
	0x7064,
	0x77da,
	0x8b9a,
	0x9477,
	0x97c9,
	0x9a62,
	0x9a65,
	0x7e9c,
	0x8b9c,
	0x8eaa,
	0x91c5,
	0x947d,
	0x947e,
	0x947c,
	0x9c77,
	0x9c78,
	0x9ef7,
	0x8c54,
	0x947f,
	0x9e1a,
	0x7228,
	0x9a6a,
	0x9b31,
	0x9e1b,
	0x9e1e,
	0x7c72
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_75[]=
	{
	0x4e42,
	0x4e5c,
	0x51f5,
	0x531a,
	0x5382,
	0x4e07,
	0x4e0c,
	0x4e47,
	0x4e8d,
	0x56d7,
	0xfa0c,
	0x5c6e,
	0x5f73,
	0x4e0f,
	0x5187,
	0x4e0e,
	0x4e2e,
	0x4e93,
	0x4ec2,
	0x4ec9,
	0x4ec8,
	0x5198,
	0x52fc,
	0x536c,
	0x53b9,
	0x5720,
	0x5903,
	0x592c,
	0x5c10,
	0x5dff,
	0x65e1,
	0x6bb3,
	0x6bcc,
	0x6c14,
	0x723f,
	0x4e31,
	0x4e3c,
	0x4ee8,
	0x4edc,
	0x4ee9,
	0x4ee1,
	0x4edd,
	0x4eda,
	0x520c,
	0x531c,
	0x534c,
	0x5722,
	0x5723,
	0x5917,
	0x592f,
	0x5b81,
	0x5b84,
	0x5c12,
	0x5c3b,
	0x5c74,
	0x5c73,
	0x5e04,
	0x5e80,
	0x5e82,
	0x5fc9,
	0x6209,
	0x6250,
	0x6c15
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_76[]=
	{
	0x6c36,
	0x6c43,
	0x6c3f,
	0x6c3b,
	0x72ae,
	0x72b0,
	0x738a,
	0x79b8,
	0x808a,
	0x961e,
	0x4f0e,
	0x4f18,
	0x4f2c,
	0x4ef5,
	0x4f14,
	0x4ef1,
	0x4f00,
	0x4ef7,
	0x4f08,
	0x4f1d,
	0x4f02,
	0x4f05,
	0x4f22,
	0x4f13,
	0x4f04,
	0x4ef4,
	0x4f12,
	0x51b1,
	0x5213,
	0x5209,
	0x5210,
	0x52a6,
	0x5322,
	0x531f,
	0x534d,
	0x538a,
	0x5407,
	0x56e1,
	0x56df,
	0x572e,
	0x572a,
	0x5734,
	0x593c,
	0x5980,
	0x597c,
	0x5985,
	0x597b,
	0x597e,
	0x5977,
	0x597f,
	0x5b56,
	0x5c15,
	0x5c25,
	0x5c7c,
	0x5c7a,
	0x5c7b,
	0x5c7e,
	0x5ddf,
	0x5e75,
	0x5e84,
	0x5f02,
	0x5f1a,
	0x5f74,
	0x5fd5,
	0x5fd4,
	0x5fcf,
	0x625c,
	0x625e,
	0x6264,
	0x6261,
	0x6266,
	0x6262,
	0x6259,
	0x6260,
	0x625a,
	0x6265,
	0x65ef,
	0x65ee,
	0x673e,
	0x6739,
	0x6738,
	0x673b,
	0x673a,
	0x673f,
	0x673c,
	0x6733,
	0x6c18,
	0x6c46,
	0x6c52,
	0x6c5c,
	0x6c4f,
	0x6c4a,
	0x6c54,
	0x6c4b
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_77[]=
	{
	0x6c4c,
	0x7071,
	0x725e,
	0x72b4,
	0x72b5,
	0x738e,
	0x752a,
	0x767f,
	0x7a75,
	0x7f51,
	0x8278,
	0x827c,
	0x8280,
	0x827d,
	0x827f,
	0x864d,
	0x897e,
	0x9099,
	0x9097,
	0x9098,
	0x909b,
	0x9094,
	0x9622,
	0x9624,
	0x9620,
	0x9623,
	0x4f56,
	0x4f3b,
	0x4f62,
	0x4f49,
	0x4f53,
	0x4f64,
	0x4f3e,
	0x4f67,
	0x4f52,
	0x4f5f,
	0x4f41,
	0x4f58,
	0x4f2d,
	0x4f33,
	0x4f3f,
	0x4f61,
	0x518f,
	0x51b9,
	0x521c,
	0x521e,
	0x5221,
	0x52ad,
	0x52ae,
	0x5309,
	0x5363,
	0x5372,
	0x538e,
	0x538f,
	0x5430,
	0x5437,
	0x542a,
	0x5454,
	0x5445,
	0x5419,
	0x541c,
	0x5425,
	0x5418
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_78[]=
	{
	0x543d,
	0x544f,
	0x5441,
	0x5428,
	0x5424,
	0x5447,
	0x56ee,
	0x56e7,
	0x56e5,
	0x5741,
	0x5745,
	0x574c,
	0x5749,
	0x574b,
	0x5752,
	0x5906,
	0x5940,
	0x59a6,
	0x5998,
	0x59a0,
	0x5997,
	0x598e,
	0x59a2,
	0x5990,
	0x598f,
	0x59a7,
	0x59a1,
	0x5b8e,
	0x5b92,
	0x5c28,
	0x5c2a,
	0x5c8d,
	0x5c8f,
	0x5c88,
	0x5c8b,
	0x5c89,
	0x5c92,
	0x5c8a,
	0x5c86,
	0x5c93,
	0x5c95,
	0x5de0,
	0x5e0a,
	0x5e0e,
	0x5e8b,
	0x5e89,
	0x5e8c,
	0x5e88,
	0x5e8d,
	0x5f05,
	0x5f1d,
	0x5f78,
	0x5f76,
	0x5fd2,
	0x5fd1,
	0x5fd0,
	0x5fed,
	0x5fe8,
	0x5fee,
	0x5ff3,
	0x5fe1,
	0x5fe4,
	0x5fe3,
	0x5ffa,
	0x5fef,
	0x5ff7,
	0x5ffb,
	0x6000,
	0x5ff4,
	0x623a,
	0x6283,
	0x628c,
	0x628e,
	0x628f,
	0x6294,
	0x6287,
	0x6271,
	0x627b,
	0x627a,
	0x6270,
	0x6281,
	0x6288,
	0x6277,
	0x627d,
	0x6272,
	0x6274,
	0x6537,
	0x65f0,
	0x65f4,
	0x65f3,
	0x65f2,
	0x65f5,
	0x6745,
	0x6747
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_79[]=
	{
	0x6759,
	0x6755,
	0x674c,
	0x6748,
	0x675d,
	0x674d,
	0x675a,
	0x674b,
	0x6bd0,
	0x6c19,
	0x6c1a,
	0x6c78,
	0x6c67,
	0x6c6b,
	0x6c84,
	0x6c8b,
	0x6c8f,
	0x6c71,
	0x6c6f,
	0x6c69,
	0x6c9a,
	0x6c6d,
	0x6c87,
	0x6c95,
	0x6c9c,
	0x6c66,
	0x6c73,
	0x6c65,
	0x6c7b,
	0x6c8e,
	0x7074,
	0x707a,
	0x7263,
	0x72bf,
	0x72bd,
	0x72c3,
	0x72c6,
	0x72c1,
	0x72ba,
	0x72c5,
	0x7395,
	0x7397,
	0x7393,
	0x7394,
	0x7392,
	0x753a,
	0x7539,
	0x7594,
	0x7595,
	0x7681,
	0x793d,
	0x8034,
	0x8095,
	0x8099,
	0x8090,
	0x8092,
	0x809c,
	0x8290,
	0x828f,
	0x8285,
	0x828e,
	0x8291,
	0x8293
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_80[]=
	{
	0x828a,
	0x8283,
	0x8284,
	0x8c78,
	0x8fc9,
	0x8fbf,
	0x909f,
	0x90a1,
	0x90a5,
	0x909e,
	0x90a7,
	0x90a0,
	0x9630,
	0x9628,
	0x962f,
	0x962d,
	0x4e33,
	0x4f98,
	0x4f7c,
	0x4f85,
	0x4f7d,
	0x4f80,
	0x4f87,
	0x4f76,
	0x4f74,
	0x4f89,
	0x4f84,
	0x4f77,
	0x4f4c,
	0x4f97,
	0x4f6a,
	0x4f9a,
	0x4f79,
	0x4f81,
	0x4f78,
	0x4f90,
	0x4f9c,
	0x4f94,
	0x4f9e,
	0x4f92,
	0x4f82,
	0x4f95,
	0x4f6b,
	0x4f6e,
	0x519e,
	0x51bc,
	0x51be,
	0x5235,
	0x5232,
	0x5233,
	0x5246,
	0x5231,
	0x52bc,
	0x530a,
	0x530b,
	0x533c,
	0x5392,
	0x5394,
	0x5487,
	0x547f,
	0x5481,
	0x5491,
	0x5482,
	0x5488,
	0x546b,
	0x547a,
	0x547e,
	0x5465,
	0x546c,
	0x5474,
	0x5466,
	0x548d,
	0x546f,
	0x5461,
	0x5460,
	0x5498,
	0x5463,
	0x5467,
	0x5464,
	0x56f7,
	0x56f9,
	0x576f,
	0x5772,
	0x576d,
	0x576b,
	0x5771,
	0x5770,
	0x5776,
	0x5780,
	0x5775,
	0x577b,
	0x5773,
	0x5774,
	0x5762
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_81[]=
	{
	0x5768,
	0x577d,
	0x590c,
	0x5945,
	0x59b5,
	0x59ba,
	0x59cf,
	0x59ce,
	0x59b2,
	0x59cc,
	0x59c1,
	0x59b6,
	0x59bc,
	0x59c3,
	0x59d6,
	0x59b1,
	0x59bd,
	0x59c0,
	0x59c8,
	0x59b4,
	0x59c7,
	0x5b62,
	0x5b65,
	0x5b93,
	0x5b95,
	0x5c44,
	0x5c47,
	0x5cae,
	0x5ca4,
	0x5ca0,
	0x5cb5,
	0x5caf,
	0x5ca8,
	0x5cac,
	0x5c9f,
	0x5ca3,
	0x5cad,
	0x5ca2,
	0x5caa,
	0x5ca7,
	0x5c9d,
	0x5ca5,
	0x5cb6,
	0x5cb0,
	0x5ca6,
	0x5e17,
	0x5e14,
	0x5e19,
	0x5f28,
	0x5f22,
	0x5f23,
	0x5f24,
	0x5f54,
	0x5f82,
	0x5f7e,
	0x5f7d,
	0x5fde,
	0x5fe5,
	0x602d,
	0x6026,
	0x6019,
	0x6032,
	0x600b
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_82[]=
	{
	0x6034,
	0x600a,
	0x6017,
	0x6033,
	0x601a,
	0x601e,
	0x602c,
	0x6022,
	0x600d,
	0x6010,
	0x602e,
	0x6013,
	0x6011,
	0x600c,
	0x6009,
	0x601c,
	0x6214,
	0x623d,
	0x62ad,
	0x62b4,
	0x62d1,
	0x62be,
	0x62aa,
	0x62b6,
	0x62ca,
	0x62ae,
	0x62b3,
	0x62af,
	0x62bb,
	0x62a9,
	0x62b0,
	0x62b8,
	0x653d,
	0x65a8,
	0x65bb,
	0x6609,
	0x65fc,
	0x6604,
	0x6612,
	0x6608,
	0x65fb,
	0x6603,
	0x660b,
	0x660d,
	0x6605,
	0x65fd,
	0x6611,
	0x6610,
	0x66f6,
	0x670a,
	0x6785,
	0x676c,
	0x678e,
	0x6792,
	0x6776,
	0x677b,
	0x6798,
	0x6786,
	0x6784,
	0x6774,
	0x678d,
	0x678c,
	0x677a,
	0x679f,
	0x6791,
	0x6799,
	0x6783,
	0x677d,
	0x6781,
	0x6778,
	0x6779,
	0x6794,
	0x6b25,
	0x6b80,
	0x6b7e,
	0x6bde,
	0x6c1d,
	0x6c93,
	0x6cec,
	0x6ceb,
	0x6cee,
	0x6cd9,
	0x6cb6,
	0x6cd4,
	0x6cad,
	0x6ce7,
	0x6cb7,
	0x6cd0,
	0x6cc2,
	0x6cba,
	0x6cc3,
	0x6cc6,
	0x6ced,
	0x6cf2
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_83[]=
	{
	0x6cd2,
	0x6cdd,
	0x6cb4,
	0x6c8a,
	0x6c9d,
	0x6c80,
	0x6cde,
	0x6cc0,
	0x6d30,
	0x6ccd,
	0x6cc7,
	0x6cb0,
	0x6cf9,
	0x6ccf,
	0x6ce9,
	0x6cd1,
	0x7094,
	0x7098,
	0x7085,
	0x7093,
	0x7086,
	0x7084,
	0x7091,
	0x7096,
	0x7082,
	0x709a,
	0x7083,
	0x726a,
	0x72d6,
	0x72cb,
	0x72d8,
	0x72c9,
	0x72dc,
	0x72d2,
	0x72d4,
	0x72da,
	0x72cc,
	0x72d1,
	0x73a4,
	0x73a1,
	0x73ad,
	0x73a6,
	0x73a2,
	0x73a0,
	0x73ac,
	0x739d,
	0x74dd,
	0x74e8,
	0x753f,
	0x7540,
	0x753e,
	0x758c,
	0x7598,
	0x76af,
	0x76f3,
	0x76f1,
	0x76f0,
	0x76f5,
	0x77f8,
	0x77fc,
	0x77f9,
	0x77fb,
	0x77fa
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_84[]=
	{
	0x77f7,
	0x7942,
	0x793f,
	0x79c5,
	0x7a78,
	0x7a7b,
	0x7afb,
	0x7c75,
	0x7cfd,
	0x8035,
	0x808f,
	0x80ae,
	0x80a3,
	0x80b8,
	0x80b5,
	0x80ad,
	0x8220,
	0x82a0,
	0x82c0,
	0x82ab,
	0x829a,
	0x8298,
	0x829b,
	0x82b5,
	0x82a7,
	0x82ae,
	0x82bc,
	0x829e,
	0x82ba,
	0x82b4,
	0x82a8,
	0x82a1,
	0x82a9,
	0x82c2,
	0x82a4,
	0x82c3,
	0x82b6,
	0x82a2,
	0x8670,
	0x866f,
	0x866d,
	0x866e,
	0x8c56,
	0x8fd2,
	0x8fcb,
	0x8fd3,
	0x8fcd,
	0x8fd6,
	0x8fd5,
	0x8fd7,
	0x90b2,
	0x90b4,
	0x90af,
	0x90b3,
	0x90b0,
	0x9639,
	0x963d,
	0x963c,
	0x963a,
	0x9643,
	0x4fcd,
	0x4fc5,
	0x4fd3,
	0x4fb2,
	0x4fc9,
	0x4fcb,
	0x4fc1,
	0x4fd4,
	0x4fdc,
	0x4fd9,
	0x4fbb,
	0x4fb3,
	0x4fdb,
	0x4fc7,
	0x4fd6,
	0x4fba,
	0x4fc0,
	0x4fb9,
	0x4fec,
	0x5244,
	0x5249,
	0x52c0,
	0x52c2,
	0x533d,
	0x537c,
	0x5397,
	0x5396,
	0x5399,
	0x5398,
	0x54ba,
	0x54a1,
	0x54ad,
	0x54a5,
	0x54cf
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_85[]=
	{
	0x54c3,
	0x830d,
	0x54b7,
	0x54ae,
	0x54d6,
	0x54b6,
	0x54c5,
	0x54c6,
	0x54a0,
	0x5470,
	0x54bc,
	0x54a2,
	0x54be,
	0x5472,
	0x54de,
	0x54b0,
	0x57b5,
	0x579e,
	0x579f,
	0x57a4,
	0x578c,
	0x5797,
	0x579d,
	0x579b,
	0x5794,
	0x5798,
	0x578f,
	0x5799,
	0x57a5,
	0x579a,
	0x5795,
	0x58f4,
	0x590d,
	0x5953,
	0x59e1,
	0x59de,
	0x59ee,
	0x5a00,
	0x59f1,
	0x59dd,
	0x59fa,
	0x59fd,
	0x59fc,
	0x59f6,
	0x59e4,
	0x59f2,
	0x59f7,
	0x59db,
	0x59e9,
	0x59f3,
	0x59f5,
	0x59e0,
	0x59fe,
	0x59f4,
	0x59ed,
	0x5ba8,
	0x5c4c,
	0x5cd0,
	0x5cd8,
	0x5ccc,
	0x5cd7,
	0x5ccb,
	0x5cdb
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_86[]=
	{
	0x5cde,
	0x5cda,
	0x5cc9,
	0x5cc7,
	0x5cca,
	0x5cd6,
	0x5cd3,
	0x5cd4,
	0x5ccf,
	0x5cc8,
	0x5cc6,
	0x5cce,
	0x5cdf,
	0x5cf8,
	0x5df9,
	0x5e21,
	0x5e22,
	0x5e23,
	0x5e20,
	0x5e24,
	0x5eb0,
	0x5ea4,
	0x5ea2,
	0x5e9b,
	0x5ea3,
	0x5ea5,
	0x5f07,
	0x5f2e,
	0x5f56,
	0x5f86,
	0x6037,
	0x6039,
	0x6054,
	0x6072,
	0x605e,
	0x6045,
	0x6053,
	0x6047,
	0x6049,
	0x605b,
	0x604c,
	0x6040,
	0x6042,
	0x605f,
	0x6024,
	0x6044,
	0x6058,
	0x6066,
	0x606e,
	0x6242,
	0x6243,
	0x62cf,
	0x630d,
	0x630b,
	0x62f5,
	0x630e,
	0x6303,
	0x62eb,
	0x62f9,
	0x630f,
	0x630c,
	0x62f8,
	0x62f6,
	0x6300,
	0x6313,
	0x6314,
	0x62fa,
	0x6315,
	0x62fb,
	0x62f0,
	0x6541,
	0x6543,
	0x65aa,
	0x65bf,
	0x6636,
	0x6621,
	0x6632,
	0x6635,
	0x661c,
	0x6626,
	0x6622,
	0x6633,
	0x662b,
	0x663a,
	0x661d,
	0x6634,
	0x6639,
	0x662e,
	0x670f,
	0x6710,
	0x67c1,
	0x67f2,
	0x67c8,
	0x67ba
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_87[]=
	{
	0x67dc,
	0x67bb,
	0x67f8,
	0x67d8,
	0x67c0,
	0x67b7,
	0x67c5,
	0x67eb,
	0x67e4,
	0x67df,
	0x67b5,
	0x67cd,
	0x67b3,
	0x67f7,
	0x67f6,
	0x67ee,
	0x67e3,
	0x67c2,
	0x67b9,
	0x67ce,
	0x67e7,
	0x67f0,
	0x67b2,
	0x67fc,
	0x67c6,
	0x67ed,
	0x67cc,
	0x67ae,
	0x67e6,
	0x67db,
	0x67fa,
	0x67c9,
	0x67ca,
	0x67c3,
	0x67ea,
	0x67cb,
	0x6b28,
	0x6b82,
	0x6b84,
	0x6bb6,
	0x6bd6,
	0x6bd8,
	0x6be0,
	0x6c20,
	0x6c21,
	0x6d28,
	0x6d34,
	0x6d2d,
	0x6d1f,
	0x6d3c,
	0x6d3f,
	0x6d12,
	0x6d0a,
	0x6cda,
	0x6d33,
	0x6d04,
	0x6d19,
	0x6d3a,
	0x6d1a,
	0x6d11,
	0x6d00,
	0x6d1d,
	0x6d42
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_88[]=
	{
	0x6d01,
	0x6d18,
	0x6d37,
	0x6d03,
	0x6d0f,
	0x6d40,
	0x6d07,
	0x6d20,
	0x6d2c,
	0x6d08,
	0x6d22,
	0x6d09,
	0x6d10,
	0x70b7,
	0x709f,
	0x70be,
	0x70b1,
	0x70b0,
	0x70a1,
	0x70b4,
	0x70b5,
	0x70a9,
	0x7241,
	0x7249,
	0x724a,
	0x726c,
	0x7270,
	0x7273,
	0x726e,
	0x72ca,
	0x72e4,
	0x72e8,
	0x72eb,
	0x72df,
	0x72ea,
	0x72e6,
	0x72e3,
	0x7385,
	0x73cc,
	0x73c2,
	0x73c8,
	0x73c5,
	0x73b9,
	0x73b6,
	0x73b5,
	0x73b4,
	0x73eb,
	0x73bf,
	0x73c7,
	0x73be,
	0x73c3,
	0x73c6,
	0x73b8,
	0x73cb,
	0x74ec,
	0x74ee,
	0x752e,
	0x7547,
	0x7548,
	0x75a7,
	0x75aa,
	0x7679,
	0x76c4,
	0x7708,
	0x7703,
	0x7704,
	0x7705,
	0x770a,
	0x76f7,
	0x76fb,
	0x76fa,
	0x77e7,
	0x77e8,
	0x7806,
	0x7811,
	0x7812,
	0x7805,
	0x7810,
	0x780f,
	0x780e,
	0x7809,
	0x7803,
	0x7813,
	0x794a,
	0x794c,
	0x794b,
	0x7945,
	0x7944,
	0x79d5,
	0x79cd,
	0x79cf,
	0x79d6,
	0x79ce,
	0x7a80
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_89[]=
	{
	0x7a7e,
	0x7ad1,
	0x7b00,
	0x7b01,
	0x7c7a,
	0x7c78,
	0x7c79,
	0x7c7f,
	0x7c80,
	0x7c81,
	0x7d03,
	0x7d08,
	0x7d01,
	0x7f58,
	0x7f91,
	0x7f8d,
	0x7fbe,
	0x8007,
	0x800e,
	0x800f,
	0x8014,
	0x8037,
	0x80d8,
	0x80c7,
	0x80e0,
	0x80d1,
	0x80c8,
	0x80c2,
	0x80d0,
	0x80c5,
	0x80e3,
	0x80d9,
	0x80dc,
	0x80ca,
	0x80d5,
	0x80c9,
	0x80cf,
	0x80d7,
	0x80e6,
	0x80cd,
	0x81ff,
	0x8221,
	0x8294,
	0x82d9,
	0x82fe,
	0x82f9,
	0x8307,
	0x82e8,
	0x8300,
	0x82d5,
	0x833a,
	0x82eb,
	0x82d6,
	0x82f4,
	0x82ec,
	0x82e1,
	0x82f2,
	0x82f5,
	0x830c,
	0x82fb,
	0x82f6,
	0x82f0,
	0x82ea
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_90[]=
	{
	0x82e4,
	0x82e0,
	0x82fa,
	0x82f3,
	0x82ed,
	0x8677,
	0x8674,
	0x867c,
	0x8673,
	0x8841,
	0x884e,
	0x8867,
	0x886a,
	0x8869,
	0x89d3,
	0x8a04,
	0x8a07,
	0x8d72,
	0x8fe3,
	0x8fe1,
	0x8fee,
	0x8fe0,
	0x90f1,
	0x90bd,
	0x90bf,
	0x90d5,
	0x90c5,
	0x90be,
	0x90c7,
	0x90cb,
	0x90c8,
	0x91d4,
	0x91d3,
	0x9654,
	0x964f,
	0x9651,
	0x9653,
	0x964a,
	0x964e,
	0x501e,
	0x5005,
	0x5007,
	0x5013,
	0x5022,
	0x5030,
	0x501b,
	0x4ff5,
	0x4ff4,
	0x5033,
	0x5037,
	0x502c,
	0x4ff6,
	0x4ff7,
	0x5017,
	0x501c,
	0x5020,
	0x5027,
	0x5035,
	0x502f,
	0x5031,
	0x500e,
	0x515a,
	0x5194,
	0x5193,
	0x51ca,
	0x51c4,
	0x51c5,
	0x51c8,
	0x51ce,
	0x5261,
	0x525a,
	0x5252,
	0x525e,
	0x525f,
	0x5255,
	0x5262,
	0x52cd,
	0x530e,
	0x539e,
	0x5526,
	0x54e2,
	0x5517,
	0x5512,
	0x54e7,
	0x54f3,
	0x54e4,
	0x551a,
	0x54ff,
	0x5504,
	0x5508,
	0x54eb,
	0x5511,
	0x5505,
	0x54f1
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_91[]=
	{
	0x550a,
	0x54fb,
	0x54f7,
	0x54f8,
	0x54e0,
	0x550e,
	0x5503,
	0x550b,
	0x5701,
	0x5702,
	0x57cc,
	0x5832,
	0x57d5,
	0x57d2,
	0x57ba,
	0x57c6,
	0x57bd,
	0x57bc,
	0x57b8,
	0x57b6,
	0x57bf,
	0x57c7,
	0x57d0,
	0x57b9,
	0x57c1,
	0x590e,
	0x594a,
	0x5a19,
	0x5a16,
	0x5a2d,
	0x5a2e,
	0x5a15,
	0x5a0f,
	0x5a17,
	0x5a0a,
	0x5a1e,
	0x5a33,
	0x5b6c,
	0x5ba7,
	0x5bad,
	0x5bac,
	0x5c03,
	0x5c56,
	0x5c54,
	0x5cec,
	0x5cff,
	0x5cee,
	0x5cf1,
	0x5cf7,
	0x5d00,
	0x5cf9,
	0x5e29,
	0x5e28,
	0x5ea8,
	0x5eae,
	0x5eaa,
	0x5eac,
	0x5f33,
	0x5f30,
	0x5f67,
	0x605d,
	0x605a,
	0x6067
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_92[]=
	{
	0x6041,
	0x60a2,
	0x6088,
	0x6080,
	0x6092,
	0x6081,
	0x609d,
	0x6083,
	0x6095,
	0x609b,
	0x6097,
	0x6087,
	0x609c,
	0x608e,
	0x6219,
	0x6246,
	0x62f2,
	0x6310,
	0x6356,
	0x632c,
	0x6344,
	0x6345,
	0x6336,
	0x6343,
	0x63e4,
	0x6339,
	0x634b,
	0x634a,
	0x633c,
	0x6329,
	0x6341,
	0x6334,
	0x6358,
	0x6354,
	0x6359,
	0x632d,
	0x6347,
	0x6333,
	0x635a,
	0x6351,
	0x6338,
	0x6357,
	0x6340,
	0x6348,
	0x654a,
	0x6546,
	0x65c6,
	0x65c3,
	0x65c4,
	0x65c2,
	0x664a,
	0x665f,
	0x6647,
	0x6651,
	0x6712,
	0x6713,
	0x681f,
	0x681a,
	0x6849,
	0x6832,
	0x6833,
	0x683b,
	0x684b,
	0x684f,
	0x6816,
	0x6831,
	0x681c,
	0x6835,
	0x682b,
	0x682d,
	0x682f,
	0x684e,
	0x6844,
	0x6834,
	0x681d,
	0x6812,
	0x6814,
	0x6826,
	0x6828,
	0x682e,
	0x684d,
	0x683a,
	0x6825,
	0x6820,
	0x6b2c,
	0x6b2f,
	0x6b2d,
	0x6b31,
	0x6b34,
	0x6b6d,
	0x8082,
	0x6b88,
	0x6be6,
	0x6be4
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_93[]=
	{
	0x6be8,
	0x6be3,
	0x6be2,
	0x6be7,
	0x6c25,
	0x6d7a,
	0x6d63,
	0x6d64,
	0x6d76,
	0x6d0d,
	0x6d61,
	0x6d92,
	0x6d58,
	0x6d62,
	0x6d6d,
	0x6d6f,
	0x6d91,
	0x6d8d,
	0x6def,
	0x6d7f,
	0x6d86,
	0x6d5e,
	0x6d67,
	0x6d60,
	0x6d97,
	0x6d70,
	0x6d7c,
	0x6d5f,
	0x6d82,
	0x6d98,
	0x6d2f,
	0x6d68,
	0x6d8b,
	0x6d7e,
	0x6d80,
	0x6d84,
	0x6d16,
	0x6d83,
	0x6d7b,
	0x6d7d,
	0x6d75,
	0x6d90,
	0x70dc,
	0x70d3,
	0x70d1,
	0x70dd,
	0x70cb,
	0x7f39,
	0x70e2,
	0x70d7,
	0x70d2,
	0x70de,
	0x70e0,
	0x70d4,
	0x70cd,
	0x70c5,
	0x70c6,
	0x70c7,
	0x70da,
	0x70ce,
	0x70e1,
	0x7242,
	0x7278
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_94[]=
	{
	0x7277,
	0x7276,
	0x7300,
	0x72fa,
	0x72f4,
	0x72fe,
	0x72f6,
	0x72f3,
	0x72fb,
	0x7301,
	0x73d3,
	0x73d9,
	0x73e5,
	0x73d6,
	0x73bc,
	0x73e7,
	0x73e3,
	0x73e9,
	0x73dc,
	0x73d2,
	0x73db,
	0x73d4,
	0x73dd,
	0x73da,
	0x73d7,
	0x73d8,
	0x73e8,
	0x74de,
	0x74df,
	0x74f4,
	0x74f5,
	0x7521,
	0x755b,
	0x755f,
	0x75b0,
	0x75c1,
	0x75bb,
	0x75c4,
	0x75c0,
	0x75bf,
	0x75b6,
	0x75ba,
	0x768a,
	0x76c9,
	0x771d,
	0x771b,
	0x7710,
	0x7713,
	0x7712,
	0x7723,
	0x7711,
	0x7715,
	0x7719,
	0x771a,
	0x7722,
	0x7727,
	0x7823,
	0x782c,
	0x7822,
	0x7835,
	0x782f,
	0x7828,
	0x782e,
	0x782b,
	0x7821,
	0x7829,
	0x7833,
	0x782a,
	0x7831,
	0x7954,
	0x795b,
	0x794f,
	0x795c,
	0x7953,
	0x7952,
	0x7951,
	0x79eb,
	0x79ec,
	0x79e0,
	0x79ee,
	0x79ed,
	0x79ea,
	0x79dc,
	0x79de,
	0x79dd,
	0x7a86,
	0x7a89,
	0x7a85,
	0x7a8b,
	0x7a8c,
	0x7a8a,
	0x7a87,
	0x7ad8,
	0x7b10
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_95[]=
	{
	0x7b04,
	0x7b13,
	0x7b05,
	0x7b0f,
	0x7b08,
	0x7b0a,
	0x7b0e,
	0x7b09,
	0x7b12,
	0x7c84,
	0x7c91,
	0x7c8a,
	0x7c8c,
	0x7c88,
	0x7c8d,
	0x7c85,
	0x7d1e,
	0x7d1d,
	0x7d11,
	0x7d0e,
	0x7d18,
	0x7d16,
	0x7d13,
	0x7d1f,
	0x7d12,
	0x7d0f,
	0x7d0c,
	0x7f5c,
	0x7f61,
	0x7f5e,
	0x7f60,
	0x7f5d,
	0x7f5b,
	0x7f96,
	0x7f92,
	0x7fc3,
	0x7fc2,
	0x7fc0,
	0x8016,
	0x803e,
	0x8039,
	0x80fa,
	0x80f2,
	0x80f9,
	0x80f5,
	0x8101,
	0x80fb,
	0x8100,
	0x8201,
	0x822f,
	0x8225,
	0x8333,
	0x832d,
	0x8344,
	0x8319,
	0x8351,
	0x8325,
	0x8356,
	0x833f,
	0x8341,
	0x8326,
	0x831c,
	0x8322
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_96[]=
	{
	0x8342,
	0x834e,
	0x831b,
	0x832a,
	0x8308,
	0x833c,
	0x834d,
	0x8316,
	0x8324,
	0x8320,
	0x8337,
	0x832f,
	0x8329,
	0x8347,
	0x8345,
	0x834c,
	0x8353,
	0x831e,
	0x832c,
	0x834b,
	0x8327,
	0x8348,
	0x8653,
	0x8652,
	0x86a2,
	0x86a8,
	0x8696,
	0x868d,
	0x8691,
	0x869e,
	0x8687,
	0x8697,
	0x8686,
	0x868b,
	0x869a,
	0x8685,
	0x86a5,
	0x8699,
	0x86a1,
	0x86a7,
	0x8695,
	0x8698,
	0x868e,
	0x869d,
	0x8690,
	0x8694,
	0x8843,
	0x8844,
	0x886d,
	0x8875,
	0x8876,
	0x8872,
	0x8880,
	0x8871,
	0x887f,
	0x886f,
	0x8883,
	0x887e,
	0x8874,
	0x887c,
	0x8a12,
	0x8c47,
	0x8c57,
	0x8c7b,
	0x8ca4,
	0x8ca3,
	0x8d76,
	0x8d78,
	0x8db5,
	0x8db7,
	0x8db6,
	0x8ed1,
	0x8ed3,
	0x8ffe,
	0x8ff5,
	0x9002,
	0x8fff,
	0x8ffb,
	0x9004,
	0x8ffc,
	0x8ff6,
	0x90d6,
	0x90e0,
	0x90d9,
	0x90da,
	0x90e3,
	0x90df,
	0x90e5,
	0x90d8,
	0x90db,
	0x90d7,
	0x90dc,
	0x90e4,
	0x9150
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_97[]=
	{
	0x914e,
	0x914f,
	0x91d5,
	0x91e2,
	0x91da,
	0x965c,
	0x965f,
	0x96bc,
	0x98e3,
	0x9adf,
	0x9b2f,
	0x4e7f,
	0x5070,
	0x506a,
	0x5061,
	0x505e,
	0x5060,
	0x5053,
	0x504b,
	0x505d,
	0x5072,
	0x5048,
	0x504d,
	0x5041,
	0x505b,
	0x504a,
	0x5062,
	0x5015,
	0x5045,
	0x505f,
	0x5069,
	0x506b,
	0x5063,
	0x5064,
	0x5046,
	0x5040,
	0x506e,
	0x5073,
	0x5057,
	0x5051,
	0x51d0,
	0x526b,
	0x526d,
	0x526c,
	0x526e,
	0x52d6,
	0x52d3,
	0x532d,
	0x539c,
	0x5575,
	0x5576,
	0x553c,
	0x554d,
	0x5550,
	0x5534,
	0x552a,
	0x5551,
	0x5562,
	0x5536,
	0x5535,
	0x5530,
	0x5552,
	0x5545
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_98[]=
	{
	0x550c,
	0x5532,
	0x5565,
	0x554e,
	0x5539,
	0x5548,
	0x552d,
	0x553b,
	0x5540,
	0x554b,
	0x570a,
	0x5707,
	0x57fb,
	0x5814,
	0x57e2,
	0x57f6,
	0x57dc,
	0x57f4,
	0x5800,
	0x57ed,
	0x57fd,
	0x5808,
	0x57f8,
	0x580b,
	0x57f3,
	0x57cf,
	0x5807,
	0x57ee,
	0x57e3,
	0x57f2,
	0x57e5,
	0x57ec,
	0x57e1,
	0x580e,
	0x57fc,
	0x5810,
	0x57e7,
	0x5801,
	0x580c,
	0x57f1,
	0x57e9,
	0x57f0,
	0x580d,
	0x5804,
	0x595c,
	0x5a60,
	0x5a58,
	0x5a55,
	0x5a67,
	0x5a5e,
	0x5a38,
	0x5a35,
	0x5a6d,
	0x5a50,
	0x5a5f,
	0x5a65,
	0x5a6c,
	0x5a53,
	0x5a64,
	0x5a57,
	0x5a43,
	0x5a5d,
	0x5a52,
	0x5a44,
	0x5a5b,
	0x5a48,
	0x5a8e,
	0x5a3e,
	0x5a4d,
	0x5a39,
	0x5a4c,
	0x5a70,
	0x5a69,
	0x5a47,
	0x5a51,
	0x5a56,
	0x5a42,
	0x5a5c,
	0x5b72,
	0x5b6e,
	0x5bc1,
	0x5bc0,
	0x5c59,
	0x5d1e,
	0x5d0b,
	0x5d1d,
	0x5d1a,
	0x5d20,
	0x5d0c,
	0x5d28,
	0x5d0d,
	0x5d26,
	0x5d25,
	0x5d0f
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_99[]=
	{
	0x5d30,
	0x5d12,
	0x5d23,
	0x5d1f,
	0x5d2e,
	0x5e3e,
	0x5e34,
	0x5eb1,
	0x5eb4,
	0x5eb9,
	0x5eb2,
	0x5eb3,
	0x5f36,
	0x5f38,
	0x5f9b,
	0x5f96,
	0x5f9f,
	0x608a,
	0x6090,
	0x6086,
	0x60be,
	0x60b0,
	0x60ba,
	0x60d3,
	0x60d4,
	0x60cf,
	0x60e4,
	0x60d9,
	0x60dd,
	0x60c8,
	0x60b1,
	0x60db,
	0x60b7,
	0x60ca,
	0x60bf,
	0x60c3,
	0x60cd,
	0x60c0,
	0x6332,
	0x6365,
	0x638a,
	0x6382,
	0x637d,
	0x63bd,
	0x639e,
	0x63ad,
	0x639d,
	0x6397,
	0x63ab,
	0x638e,
	0x636f,
	0x6387,
	0x6390,
	0x636e,
	0x63af,
	0x6375,
	0x639c,
	0x636d,
	0x63ae,
	0x637c,
	0x63a4,
	0x633b,
	0x639f
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_100[]=
	{
	0x6378,
	0x6385,
	0x6381,
	0x6391,
	0x638d,
	0x6370,
	0x6553,
	0x65cd,
	0x6665,
	0x6661,
	0x665b,
	0x6659,
	0x665c,
	0x6662,
	0x6718,
	0x6879,
	0x6887,
	0x6890,
	0x689c,
	0x686d,
	0x686e,
	0x68ae,
	0x68ab,
	0x6956,
	0x686f,
	0x68a3,
	0x68ac,
	0x68a9,
	0x6875,
	0x6874,
	0x68b2,
	0x688f,
	0x6877,
	0x6892,
	0x687c,
	0x686b,
	0x6872,
	0x68aa,
	0x6880,
	0x6871,
	0x687e,
	0x689b,
	0x6896,
	0x688b,
	0x68a0,
	0x6889,
	0x68a4,
	0x6878,
	0x687b,
	0x6891,
	0x688c,
	0x688a,
	0x687d,
	0x6b36,
	0x6b33,
	0x6b37,
	0x6b38,
	0x6b91,
	0x6b8f,
	0x6b8d,
	0x6b8e,
	0x6b8c,
	0x6c2a,
	0x6dc0,
	0x6dab,
	0x6db4,
	0x6db3,
	0x6e74,
	0x6dac,
	0x6de9,
	0x6de2,
	0x6db7,
	0x6df6,
	0x6dd4,
	0x6e00,
	0x6dc8,
	0x6de0,
	0x6ddf,
	0x6dd6,
	0x6dbe,
	0x6de5,
	0x6ddc,
	0x6ddd,
	0x6ddb,
	0x6df4,
	0x6dca,
	0x6dbd,
	0x6ded,
	0x6df0,
	0x6dba,
	0x6dd5,
	0x6dc2,
	0x6dcf,
	0x6dc9
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_101[]=
	{
	0x6dd0,
	0x6df2,
	0x6dd3,
	0x6dfd,
	0x6dd7,
	0x6dcd,
	0x6de3,
	0x6dbb,
	0x70fa,
	0x710d,
	0x70f7,
	0x7117,
	0x70f4,
	0x710c,
	0x70f0,
	0x7104,
	0x70f3,
	0x7110,
	0x70fc,
	0x70ff,
	0x7106,
	0x7113,
	0x7100,
	0x70f8,
	0x70f6,
	0x710b,
	0x7102,
	0x710e,
	0x727e,
	0x727b,
	0x727c,
	0x727f,
	0x731d,
	0x7317,
	0x7307,
	0x7311,
	0x7318,
	0x730a,
	0x7308,
	0x72ff,
	0x730f,
	0x731e,
	0x7388,
	0x73f6,
	0x73f8,
	0x73f5,
	0x7404,
	0x7401,
	0x73fd,
	0x7407,
	0x7400,
	0x73fa,
	0x73fc,
	0x73ff,
	0x740c,
	0x740b,
	0x73f4,
	0x7408,
	0x7564,
	0x7563,
	0x75ce,
	0x75d2,
	0x75cf
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_102[]=
	{
	0x75cb,
	0x75cc,
	0x75d1,
	0x75d0,
	0x768f,
	0x7689,
	0x76d3,
	0x7739,
	0x772f,
	0x772d,
	0x7731,
	0x7732,
	0x7734,
	0x7733,
	0x773d,
	0x7725,
	0x773b,
	0x7735,
	0x7848,
	0x7852,
	0x7849,
	0x784d,
	0x784a,
	0x784c,
	0x7826,
	0x7845,
	0x7850,
	0x7964,
	0x7967,
	0x7969,
	0x796a,
	0x7963,
	0x796b,
	0x7961,
	0x79bb,
	0x79fa,
	0x79f8,
	0x79f6,
	0x79f7,
	0x7a8f,
	0x7a94,
	0x7a90,
	0x7b35,
	0x7b47,
	0x7b34,
	0x7b25,
	0x7b30,
	0x7b22,
	0x7b24,
	0x7b33,
	0x7b18,
	0x7b2a,
	0x7b1d,
	0x7b31,
	0x7b2b,
	0x7b2d,
	0x7b2f,
	0x7b32,
	0x7b38,
	0x7b1a,
	0x7b23,
	0x7c94,
	0x7c98,
	0x7c96,
	0x7ca3,
	0x7d35,
	0x7d3d,
	0x7d38,
	0x7d36,
	0x7d3a,
	0x7d45,
	0x7d2c,
	0x7d29,
	0x7d41,
	0x7d47,
	0x7d3e,
	0x7d3f,
	0x7d4a,
	0x7d3b,
	0x7d28,
	0x7f63,
	0x7f95,
	0x7f9c,
	0x7f9d,
	0x7f9b,
	0x7fca,
	0x7fcb,
	0x7fcd,
	0x7fd0,
	0x7fd1,
	0x7fc7,
	0x7fcf,
	0x7fc9,
	0x801f
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_103[]=
	{
	0x801e,
	0x801b,
	0x8047,
	0x8043,
	0x8048,
	0x8118,
	0x8125,
	0x8119,
	0x811b,
	0x812d,
	0x811f,
	0x812c,
	0x811e,
	0x8121,
	0x8115,
	0x8127,
	0x811d,
	0x8122,
	0x8211,
	0x8238,
	0x8233,
	0x823a,
	0x8234,
	0x8232,
	0x8274,
	0x8390,
	0x83a3,
	0x83a8,
	0x838d,
	0x837a,
	0x8373,
	0x83a4,
	0x8374,
	0x838f,
	0x8381,
	0x8395,
	0x8399,
	0x8375,
	0x8394,
	0x83a9,
	0x837d,
	0x8383,
	0x838c,
	0x839d,
	0x839b,
	0x83aa,
	0x838b,
	0x837e,
	0x83a5,
	0x83af,
	0x8388,
	0x8397,
	0x83b0,
	0x837f,
	0x83a6,
	0x8387,
	0x83ae,
	0x8376,
	0x839a,
	0x8659,
	0x8656,
	0x86bf,
	0x86b7
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_104[]=
	{
	0x86c2,
	0x86c1,
	0x86c5,
	0x86ba,
	0x86b0,
	0x86c8,
	0x86b9,
	0x86b3,
	0x86b8,
	0x86cc,
	0x86b4,
	0x86bb,
	0x86bc,
	0x86c3,
	0x86bd,
	0x86be,
	0x8852,
	0x8889,
	0x8895,
	0x88a8,
	0x88a2,
	0x88aa,
	0x889a,
	0x8891,
	0x88a1,
	0x889f,
	0x8898,
	0x88a7,
	0x8899,
	0x889b,
	0x8897,
	0x88a4,
	0x88ac,
	0x888c,
	0x8893,
	0x888e,
	0x8982,
	0x89d6,
	0x89d9,
	0x89d5,
	0x8a30,
	0x8a27,
	0x8a2c,
	0x8a1e,
	0x8c39,
	0x8c3b,
	0x8c5c,
	0x8c5d,
	0x8c7d,
	0x8ca5,
	0x8d7d,
	0x8d7b,
	0x8d79,
	0x8dbc,
	0x8dc2,
	0x8db9,
	0x8dbf,
	0x8dc1,
	0x8ed8,
	0x8ede,
	0x8edd,
	0x8edc,
	0x8ed7,
	0x8ee0,
	0x8ee1,
	0x9024,
	0x900b,
	0x9011,
	0x901c,
	0x900c,
	0x9021,
	0x90ef,
	0x90ea,
	0x90f0,
	0x90f4,
	0x90f2,
	0x90f3,
	0x90d4,
	0x90eb,
	0x90ec,
	0x90e9,
	0x9156,
	0x9158,
	0x915a,
	0x9153,
	0x9155,
	0x91ec,
	0x91f4,
	0x91f1,
	0x91f3,
	0x91f8,
	0x91e4,
	0x91f9,
	0x91ea
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_105[]=
	{
	0x91eb,
	0x91f7,
	0x91e8,
	0x91ee,
	0x957a,
	0x9586,
	0x9588,
	0x967c,
	0x966d,
	0x966b,
	0x9671,
	0x966f,
	0x96bf,
	0x976a,
	0x9804,
	0x98e5,
	0x9997,
	0x509b,
	0x5095,
	0x5094,
	0x509e,
	0x508b,
	0x50a3,
	0x5083,
	0x508c,
	0x508e,
	0x509d,
	0x5068,
	0x509c,
	0x5092,
	0x5082,
	0x5087,
	0x515f,
	0x51d4,
	0x5312,
	0x5311,
	0x53a4,
	0x53a7,
	0x5591,
	0x55a8,
	0x55a5,
	0x55ad,
	0x5577,
	0x5645,
	0x55a2,
	0x5593,
	0x5588,
	0x558f,
	0x55b5,
	0x5581,
	0x55a3,
	0x5592,
	0x55a4,
	0x557d,
	0x558c,
	0x55a6,
	0x557f,
	0x5595,
	0x55a1,
	0x558e,
	0x570c,
	0x5829,
	0x5837
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_106[]=
	{
	0x5819,
	0x581e,
	0x5827,
	0x5823,
	0x5828,
	0x57f5,
	0x5848,
	0x5825,
	0x581c,
	0x581b,
	0x5833,
	0x583f,
	0x5836,
	0x582e,
	0x5839,
	0x5838,
	0x582d,
	0x582c,
	0x583b,
	0x5961,
	0x5aaf,
	0x5a94,
	0x5a9f,
	0x5a7a,
	0x5aa2,
	0x5a9e,
	0x5a78,
	0x5aa6,
	0x5a7c,
	0x5aa5,
	0x5aac,
	0x5a95,
	0x5aae,
	0x5a37,
	0x5a84,
	0x5a8a,
	0x5a97,
	0x5a83,
	0x5a8b,
	0x5aa9,
	0x5a7b,
	0x5a7d,
	0x5a8c,
	0x5a9c,
	0x5a8f,
	0x5a93,
	0x5a9d,
	0x5bea,
	0x5bcd,
	0x5bcb,
	0x5bd4,
	0x5bd1,
	0x5bca,
	0x5bce,
	0x5c0c,
	0x5c30,
	0x5d37,
	0x5d43,
	0x5d6b,
	0x5d41,
	0x5d4b,
	0x5d3f,
	0x5d35,
	0x5d51,
	0x5d4e,
	0x5d55,
	0x5d33,
	0x5d3a,
	0x5d52,
	0x5d3d,
	0x5d31,
	0x5d59,
	0x5d42,
	0x5d39,
	0x5d49,
	0x5d38,
	0x5d3c,
	0x5d32,
	0x5d36,
	0x5d40,
	0x5d45,
	0x5e44,
	0x5e41,
	0x5f58,
	0x5fa6,
	0x5fa5,
	0x5fab,
	0x60c9,
	0x60b9,
	0x60cc,
	0x60e2,
	0x60ce,
	0x60c4,
	0x6114
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_107[]=
	{
	0x60f2,
	0x610a,
	0x6116,
	0x6105,
	0x60f5,
	0x6113,
	0x60f8,
	0x60fc,
	0x60fe,
	0x60c1,
	0x6103,
	0x6118,
	0x611d,
	0x6110,
	0x60ff,
	0x6104,
	0x610b,
	0x624a,
	0x6394,
	0x63b1,
	0x63b0,
	0x63ce,
	0x63e5,
	0x63e8,
	0x63ef,
	0x63c3,
	0x649d,
	0x63f3,
	0x63ca,
	0x63e0,
	0x63f6,
	0x63d5,
	0x63f2,
	0x63f5,
	0x6461,
	0x63df,
	0x63be,
	0x63dd,
	0x63dc,
	0x63c4,
	0x63d8,
	0x63d3,
	0x63c2,
	0x63c7,
	0x63cc,
	0x63cb,
	0x63c8,
	0x63f0,
	0x63d7,
	0x63d9,
	0x6532,
	0x6567,
	0x656a,
	0x6564,
	0x655c,
	0x6568,
	0x6565,
	0x658c,
	0x659d,
	0x659e,
	0x65ae,
	0x65d0,
	0x65d2
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_108[]=
	{
	0x667c,
	0x666c,
	0x667b,
	0x6680,
	0x6671,
	0x6679,
	0x666a,
	0x6672,
	0x6701,
	0x690c,
	0x68d3,
	0x6904,
	0x68dc,
	0x692a,
	0x68ec,
	0x68ea,
	0x68f1,
	0x690f,
	0x68d6,
	0x68f7,
	0x68eb,
	0x68e4,
	0x68f6,
	0x6913,
	0x6910,
	0x68f3,
	0x68e1,
	0x6907,
	0x68cc,
	0x6908,
	0x6970,
	0x68b4,
	0x6911,
	0x68ef,
	0x68c6,
	0x6914,
	0x68f8,
	0x68d0,
	0x68fd,
	0x68fc,
	0x68e8,
	0x690b,
	0x690a,
	0x6917,
	0x68ce,
	0x68c8,
	0x68dd,
	0x68de,
	0x68e6,
	0x68f4,
	0x68d1,
	0x6906,
	0x68d4,
	0x68e9,
	0x6915,
	0x6925,
	0x68c7,
	0x6b39,
	0x6b3b,
	0x6b3f,
	0x6b3c,
	0x6b94,
	0x6b97,
	0x6b99,
	0x6b95,
	0x6bbd,
	0x6bf0,
	0x6bf2,
	0x6bf3,
	0x6c30,
	0x6dfc,
	0x6e46,
	0x6e47,
	0x6e1f,
	0x6e49,
	0x6e88,
	0x6e3c,
	0x6e3d,
	0x6e45,
	0x6e62,
	0x6e2b,
	0x6e3f,
	0x6e41,
	0x6e5d,
	0x6e73,
	0x6e1c,
	0x6e33,
	0x6e4b,
	0x6e40,
	0x6e51,
	0x6e3b,
	0x6e03,
	0x6e2e,
	0x6e5e
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_109[]=
	{
	0x6e68,
	0x6e5c,
	0x6e61,
	0x6e31,
	0x6e28,
	0x6e60,
	0x6e71,
	0x6e6b,
	0x6e39,
	0x6e22,
	0x6e30,
	0x6e53,
	0x6e65,
	0x6e27,
	0x6e78,
	0x6e64,
	0x6e77,
	0x6e55,
	0x6e79,
	0x6e52,
	0x6e66,
	0x6e35,
	0x6e36,
	0x6e5a,
	0x7120,
	0x711e,
	0x712f,
	0x70fb,
	0x712e,
	0x7131,
	0x7123,
	0x7125,
	0x7122,
	0x7132,
	0x711f,
	0x7128,
	0x713a,
	0x711b,
	0x724b,
	0x725a,
	0x7288,
	0x7289,
	0x7286,
	0x7285,
	0x728b,
	0x7312,
	0x730b,
	0x7330,
	0x7322,
	0x7331,
	0x7333,
	0x7327,
	0x7332,
	0x732d,
	0x7326,
	0x7323,
	0x7335,
	0x730c,
	0x742e,
	0x742c,
	0x7430,
	0x742b,
	0x7416
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_110[]=
	{
	0x741a,
	0x7421,
	0x742d,
	0x7431,
	0x7424,
	0x7423,
	0x741d,
	0x7429,
	0x7420,
	0x7432,
	0x74fb,
	0x752f,
	0x756f,
	0x756c,
	0x75e7,
	0x75da,
	0x75e1,
	0x75e6,
	0x75dd,
	0x75df,
	0x75e4,
	0x75d7,
	0x7695,
	0x7692,
	0x76da,
	0x7746,
	0x7747,
	0x7744,
	0x774d,
	0x7745,
	0x774a,
	0x774e,
	0x774b,
	0x774c,
	0x77de,
	0x77ec,
	0x7860,
	0x7864,
	0x7865,
	0x785c,
	0x786d,
	0x7871,
	0x786a,
	0x786e,
	0x7870,
	0x7869,
	0x7868,
	0x785e,
	0x7862,
	0x7974,
	0x7973,
	0x7972,
	0x7970,
	0x7a02,
	0x7a0a,
	0x7a03,
	0x7a0c,
	0x7a04,
	0x7a99,
	0x7ae6,
	0x7ae4,
	0x7b4a,
	0x7b3b,
	0x7b44,
	0x7b48,
	0x7b4c,
	0x7b4e,
	0x7b40,
	0x7b58,
	0x7b45,
	0x7ca2,
	0x7c9e,
	0x7ca8,
	0x7ca1,
	0x7d58,
	0x7d6f,
	0x7d63,
	0x7d53,
	0x7d56,
	0x7d67,
	0x7d6a,
	0x7d4f,
	0x7d6d,
	0x7d5c,
	0x7d6b,
	0x7d52,
	0x7d54,
	0x7d69,
	0x7d51,
	0x7d5f,
	0x7d4e,
	0x7f3e,
	0x7f3f,
	0x7f65
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_111[]=
	{
	0x7f66,
	0x7fa2,
	0x7fa0,
	0x7fa1,
	0x7fd7,
	0x8051,
	0x804f,
	0x8050,
	0x80fe,
	0x80d4,
	0x8143,
	0x814a,
	0x8152,
	0x814f,
	0x8147,
	0x813d,
	0x814d,
	0x813a,
	0x81e6,
	0x81ee,
	0x81f7,
	0x81f8,
	0x81f9,
	0x8204,
	0x823c,
	0x823d,
	0x823f,
	0x8275,
	0x833b,
	0x83cf,
	0x83f9,
	0x8423,
	0x83c0,
	0x83e8,
	0x8412,
	0x83e7,
	0x83e4,
	0x83fc,
	0x83f6,
	0x8410,
	0x83c6,
	0x83c8,
	0x83eb,
	0x83e3,
	0x83bf,
	0x8401,
	0x83dd,
	0x83e5,
	0x83d8,
	0x83ff,
	0x83e1,
	0x83cb,
	0x83ce,
	0x83d6,
	0x83f5,
	0x83c9,
	0x8409,
	0x840f,
	0x83de,
	0x8411,
	0x8406,
	0x83c2,
	0x83f3
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_112[]=
	{
	0x83d5,
	0x83fa,
	0x83c7,
	0x83d1,
	0x83ea,
	0x8413,
	0x83c3,
	0x83ec,
	0x83ee,
	0x83c4,
	0x83fb,
	0x83d7,
	0x83e2,
	0x841b,
	0x83db,
	0x83fe,
	0x86d8,
	0x86e2,
	0x86e6,
	0x86d3,
	0x86e3,
	0x86da,
	0x86ea,
	0x86dd,
	0x86eb,
	0x86dc,
	0x86ec,
	0x86e9,
	0x86d7,
	0x86e8,
	0x86d1,
	0x8848,
	0x8856,
	0x8855,
	0x88ba,
	0x88d7,
	0x88b9,
	0x88b8,
	0x88c0,
	0x88be,
	0x88b6,
	0x88bc,
	0x88b7,
	0x88bd,
	0x88b2,
	0x8901,
	0x88c9,
	0x8995,
	0x8998,
	0x8997,
	0x89dd,
	0x89da,
	0x89db,
	0x8a4e,
	0x8a4d,
	0x8a39,
	0x8a59,
	0x8a40,
	0x8a57,
	0x8a58,
	0x8a44,
	0x8a45,
	0x8a52,
	0x8a48,
	0x8a51,
	0x8a4a,
	0x8a4c,
	0x8a4f,
	0x8c5f,
	0x8c81,
	0x8c80,
	0x8cba,
	0x8cbe,
	0x8cb0,
	0x8cb9,
	0x8cb5,
	0x8d84,
	0x8d80,
	0x8d89,
	0x8dd8,
	0x8dd3,
	0x8dcd,
	0x8dc7,
	0x8dd6,
	0x8ddc,
	0x8dcf,
	0x8dd5,
	0x8dd9,
	0x8dc8,
	0x8dd7,
	0x8dc5,
	0x8eef,
	0x8ef7,
	0x8efa
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_113[]=
	{
	0x8ef9,
	0x8ee6,
	0x8eee,
	0x8ee5,
	0x8ef5,
	0x8ee7,
	0x8ee8,
	0x8ef6,
	0x8eeb,
	0x8ef1,
	0x8eec,
	0x8ef4,
	0x8ee9,
	0x902d,
	0x9034,
	0x902f,
	0x9106,
	0x912c,
	0x9104,
	0x90ff,
	0x90fc,
	0x9108,
	0x90f9,
	0x90fb,
	0x9101,
	0x9100,
	0x9107,
	0x9105,
	0x9103,
	0x9161,
	0x9164,
	0x915f,
	0x9162,
	0x9160,
	0x9201,
	0x920a,
	0x9225,
	0x9203,
	0x921a,
	0x9226,
	0x920f,
	0x920c,
	0x9200,
	0x9212,
	0x91ff,
	0x91fd,
	0x9206,
	0x9204,
	0x9227,
	0x9202,
	0x921c,
	0x9224,
	0x9219,
	0x9217,
	0x9205,
	0x9216,
	0x957b,
	0x958d,
	0x958c,
	0x9590,
	0x9687,
	0x967e,
	0x9688
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_114[]=
	{
	0x9689,
	0x9683,
	0x9680,
	0x96c2,
	0x96c8,
	0x96c3,
	0x96f1,
	0x96f0,
	0x976c,
	0x9770,
	0x976e,
	0x9807,
	0x98a9,
	0x98eb,
	0x9ce6,
	0x9ef9,
	0x4e83,
	0x4e84,
	0x4eb6,
	0x50bd,
	0x50bf,
	0x50c6,
	0x50ae,
	0x50c4,
	0x50ca,
	0x50b4,
	0x50c8,
	0x50c2,
	0x50b0,
	0x50c1,
	0x50ba,
	0x50b1,
	0x50cb,
	0x50c9,
	0x50b6,
	0x50b8,
	0x51d7,
	0x527a,
	0x5278,
	0x527b,
	0x527c,
	0x55c3,
	0x55db,
	0x55cc,
	0x55d0,
	0x55cb,
	0x55ca,
	0x55dd,
	0x55c0,
	0x55d4,
	0x55c4,
	0x55e9,
	0x55bf,
	0x55d2,
	0x558d,
	0x55cf,
	0x55d5,
	0x55e2,
	0x55d6,
	0x55c8,
	0x55f2,
	0x55cd,
	0x55d9,
	0x55c2,
	0x5714,
	0x5853,
	0x5868,
	0x5864,
	0x584f,
	0x584d,
	0x5849,
	0x586f,
	0x5855,
	0x584e,
	0x585d,
	0x5859,
	0x5865,
	0x585b,
	0x583d,
	0x5863,
	0x5871,
	0x58fc,
	0x5ac7,
	0x5ac4,
	0x5acb,
	0x5aba,
	0x5ab8,
	0x5ab1,
	0x5ab5,
	0x5ab0,
	0x5abf,
	0x5ac8,
	0x5abb,
	0x5ac6
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_115[]=
	{
	0x5ab7,
	0x5ac0,
	0x5aca,
	0x5ab4,
	0x5ab6,
	0x5acd,
	0x5ab9,
	0x5a90,
	0x5bd6,
	0x5bd8,
	0x5bd9,
	0x5c1f,
	0x5c33,
	0x5d71,
	0x5d63,
	0x5d4a,
	0x5d65,
	0x5d72,
	0x5d6c,
	0x5d5e,
	0x5d68,
	0x5d67,
	0x5d62,
	0x5df0,
	0x5e4f,
	0x5e4e,
	0x5e4a,
	0x5e4d,
	0x5e4b,
	0x5ec5,
	0x5ecc,
	0x5ec6,
	0x5ecb,
	0x5ec7,
	0x5f40,
	0x5faf,
	0x5fad,
	0x60f7,
	0x6149,
	0x614a,
	0x612b,
	0x6145,
	0x6136,
	0x6132,
	0x612e,
	0x6146,
	0x612f,
	0x614f,
	0x6129,
	0x6140,
	0x6220,
	0x9168,
	0x6223,
	0x6225,
	0x6224,
	0x63c5,
	0x63f1,
	0x63eb,
	0x6410,
	0x6412,
	0x6409,
	0x6420,
	0x6424
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_116[]=
	{
	0x6433,
	0x6443,
	0x641f,
	0x6415,
	0x6418,
	0x6439,
	0x6437,
	0x6422,
	0x6423,
	0x640c,
	0x6426,
	0x6430,
	0x6428,
	0x6441,
	0x6435,
	0x642f,
	0x640a,
	0x641a,
	0x6440,
	0x6425,
	0x6427,
	0x640b,
	0x63e7,
	0x641b,
	0x642e,
	0x6421,
	0x640e,
	0x656f,
	0x6592,
	0x65d3,
	0x6686,
	0x668c,
	0x6695,
	0x6690,
	0x668b,
	0x668a,
	0x6699,
	0x6694,
	0x6678,
	0x6720,
	0x6966,
	0x695f,
	0x6938,
	0x694e,
	0x6962,
	0x6971,
	0x693f,
	0x6945,
	0x696a,
	0x6939,
	0x6942,
	0x6957,
	0x6959,
	0x697a,
	0x6948,
	0x6949,
	0x6935,
	0x696c,
	0x6933,
	0x693d,
	0x6965,
	0x68f0,
	0x6978,
	0x6934,
	0x6969,
	0x6940,
	0x696f,
	0x6944,
	0x6976,
	0x6958,
	0x6941,
	0x6974,
	0x694c,
	0x693b,
	0x694b,
	0x6937,
	0x695c,
	0x694f,
	0x6951,
	0x6932,
	0x6952,
	0x692f,
	0x697b,
	0x693c,
	0x6b46,
	0x6b45,
	0x6b43,
	0x6b42,
	0x6b48,
	0x6b41,
	0x6b9b,
	0xfa0d,
	0x6bfb,
	0x6bfc
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_117[]=
	{
	0x6bf9,
	0x6bf7,
	0x6bf8,
	0x6e9b,
	0x6ed6,
	0x6ec8,
	0x6e8f,
	0x6ec0,
	0x6e9f,
	0x6e93,
	0x6e94,
	0x6ea0,
	0x6eb1,
	0x6eb9,
	0x6ec6,
	0x6ed2,
	0x6ebd,
	0x6ec1,
	0x6e9e,
	0x6ec9,
	0x6eb7,
	0x6eb0,
	0x6ecd,
	0x6ea6,
	0x6ecf,
	0x6eb2,
	0x6ebe,
	0x6ec3,
	0x6edc,
	0x6ed8,
	0x6e99,
	0x6e92,
	0x6e8e,
	0x6e8d,
	0x6ea4,
	0x6ea1,
	0x6ebf,
	0x6eb3,
	0x6ed0,
	0x6eca,
	0x6e97,
	0x6eae,
	0x6ea3,
	0x7147,
	0x7154,
	0x7152,
	0x7163,
	0x7160,
	0x7141,
	0x715d,
	0x7162,
	0x7172,
	0x7178,
	0x716a,
	0x7161,
	0x7142,
	0x7158,
	0x7143,
	0x714b,
	0x7170,
	0x715f,
	0x7150,
	0x7153
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_118[]=
	{
	0x7144,
	0x714d,
	0x715a,
	0x724f,
	0x728d,
	0x728c,
	0x7291,
	0x7290,
	0x728e,
	0x733c,
	0x7342,
	0x733b,
	0x733a,
	0x7340,
	0x734a,
	0x7349,
	0x7444,
	0x744a,
	0x744b,
	0x7452,
	0x7451,
	0x7457,
	0x7440,
	0x744f,
	0x7450,
	0x744e,
	0x7442,
	0x7446,
	0x744d,
	0x7454,
	0x74e1,
	0x74ff,
	0x74fe,
	0x74fd,
	0x751d,
	0x7579,
	0x7577,
	0x6983,
	0x75ef,
	0x760f,
	0x7603,
	0x75f7,
	0x75fe,
	0x75fc,
	0x75f9,
	0x75f8,
	0x7610,
	0x75fb,
	0x75f6,
	0x75ed,
	0x75f5,
	0x75fd,
	0x7699,
	0x76b5,
	0x76dd,
	0x7755,
	0x775f,
	0x7760,
	0x7752,
	0x7756,
	0x775a,
	0x7769,
	0x7767,
	0x7754,
	0x7759,
	0x776d,
	0x77e0,
	0x7887,
	0x789a,
	0x7894,
	0x788f,
	0x7884,
	0x7895,
	0x7885,
	0x7886,
	0x78a1,
	0x7883,
	0x7879,
	0x7899,
	0x7880,
	0x7896,
	0x787b,
	0x797c,
	0x7982,
	0x797d,
	0x7979,
	0x7a11,
	0x7a18,
	0x7a19,
	0x7a12,
	0x7a17,
	0x7a15,
	0x7a22,
	0x7a13
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_119[]=
	{
	0x7a1b,
	0x7a10,
	0x7aa3,
	0x7aa2,
	0x7a9e,
	0x7aeb,
	0x7b66,
	0x7b64,
	0x7b6d,
	0x7b74,
	0x7b69,
	0x7b72,
	0x7b65,
	0x7b73,
	0x7b71,
	0x7b70,
	0x7b61,
	0x7b78,
	0x7b76,
	0x7b63,
	0x7cb2,
	0x7cb4,
	0x7caf,
	0x7d88,
	0x7d86,
	0x7d80,
	0x7d8d,
	0x7d7f,
	0x7d85,
	0x7d7a,
	0x7d8e,
	0x7d7b,
	0x7d83,
	0x7d7c,
	0x7d8c,
	0x7d94,
	0x7d84,
	0x7d7d,
	0x7d92,
	0x7f6d,
	0x7f6b,
	0x7f67,
	0x7f68,
	0x7f6c,
	0x7fa6,
	0x7fa5,
	0x7fa7,
	0x7fdb,
	0x7fdc,
	0x8021,
	0x8164,
	0x8160,
	0x8177,
	0x815c,
	0x8169,
	0x815b,
	0x8162,
	0x8172,
	0x6721,
	0x815e,
	0x8176,
	0x8167,
	0x816f
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_120[]=
	{
	0x8144,
	0x8161,
	0x821d,
	0x8249,
	0x8244,
	0x8240,
	0x8242,
	0x8245,
	0x84f1,
	0x843f,
	0x8456,
	0x8476,
	0x8479,
	0x848f,
	0x848d,
	0x8465,
	0x8451,
	0x8440,
	0x8486,
	0x8467,
	0x8430,
	0x844d,
	0x847d,
	0x845a,
	0x8459,
	0x8474,
	0x8473,
	0x845d,
	0x8507,
	0x845e,
	0x8437,
	0x843a,
	0x8434,
	0x847a,
	0x8443,
	0x8478,
	0x8432,
	0x8445,
	0x8429,
	0x83d9,
	0x844b,
	0x842f,
	0x8442,
	0x842d,
	0x845f,
	0x8470,
	0x8439,
	0x844e,
	0x844c,
	0x8452,
	0x846f,
	0x84c5,
	0x848e,
	0x843b,
	0x8447,
	0x8436,
	0x8433,
	0x8468,
	0x847e,
	0x8444,
	0x842b,
	0x8460,
	0x8454,
	0x846e,
	0x8450,
	0x870b,
	0x8704,
	0x86f7,
	0x870c,
	0x86fa,
	0x86d6,
	0x86f5,
	0x874d,
	0x86f8,
	0x870e,
	0x8709,
	0x8701,
	0x86f6,
	0x870d,
	0x8705,
	0x88d6,
	0x88cb,
	0x88cd,
	0x88ce,
	0x88de,
	0x88db,
	0x88da,
	0x88cc,
	0x88d0,
	0x8985,
	0x899b,
	0x89df,
	0x89e5,
	0x89e4
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_121[]=
	{
	0x89e1,
	0x89e0,
	0x89e2,
	0x89dc,
	0x89e6,
	0x8a76,
	0x8a86,
	0x8a7f,
	0x8a61,
	0x8a3f,
	0x8a77,
	0x8a82,
	0x8a84,
	0x8a75,
	0x8a83,
	0x8a81,
	0x8a74,
	0x8a7a,
	0x8c3c,
	0x8c4b,
	0x8c4a,
	0x8c65,
	0x8c64,
	0x8c66,
	0x8c86,
	0x8c84,
	0x8c85,
	0x8ccc,
	0x8d68,
	0x8d69,
	0x8d91,
	0x8d8c,
	0x8d8e,
	0x8d8f,
	0x8d8d,
	0x8d93,
	0x8d94,
	0x8d90,
	0x8d92,
	0x8df0,
	0x8de0,
	0x8dec,
	0x8df1,
	0x8dee,
	0x8dd0,
	0x8de9,
	0x8de3,
	0x8de2,
	0x8de7,
	0x8df2,
	0x8deb,
	0x8df4,
	0x8f06,
	0x8eff,
	0x8f01,
	0x8f00,
	0x8f05,
	0x8f07,
	0x8f08,
	0x8f02,
	0x8f0b,
	0x9052,
	0x903f
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_122[]=
	{
	0x9044,
	0x9049,
	0x903d,
	0x9110,
	0x910d,
	0x910f,
	0x9111,
	0x9116,
	0x9114,
	0x910b,
	0x910e,
	0x916e,
	0x916f,
	0x9248,
	0x9252,
	0x9230,
	0x923a,
	0x9266,
	0x9233,
	0x9265,
	0x925e,
	0x9283,
	0x922e,
	0x924a,
	0x9246,
	0x926d,
	0x926c,
	0x924f,
	0x9260,
	0x9267,
	0x926f,
	0x9236,
	0x9261,
	0x9270,
	0x9231,
	0x9254,
	0x9263,
	0x9250,
	0x9272,
	0x924e,
	0x9253,
	0x924c,
	0x9256,
	0x9232,
	0x959f,
	0x959c,
	0x959e,
	0x959b,
	0x9692,
	0x9693,
	0x9691,
	0x9697,
	0x96ce,
	0x96fa,
	0x96fd,
	0x96f8,
	0x96f5,
	0x9773,
	0x9777,
	0x9778,
	0x9772,
	0x980f,
	0x980d,
	0x980e,
	0x98ac,
	0x98f6,
	0x98f9,
	0x99af,
	0x99b2,
	0x99b0,
	0x99b5,
	0x9aad,
	0x9aab,
	0x9b5b,
	0x9cea,
	0x9ced,
	0x9ce7,
	0x9e80,
	0x9efd,
	0x50e6,
	0x50d4,
	0x50d7,
	0x50e8,
	0x50f3,
	0x50db,
	0x50ea,
	0x50dd,
	0x50e4,
	0x50d3,
	0x50ec,
	0x50f0,
	0x50ef,
	0x50e3,
	0x50e0
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_123[]=
	{
	0x51d8,
	0x5280,
	0x5281,
	0x52e9,
	0x52eb,
	0x5330,
	0x53ac,
	0x5627,
	0x5615,
	0x560c,
	0x5612,
	0x55fc,
	0x560f,
	0x561c,
	0x5601,
	0x5613,
	0x5602,
	0x55fa,
	0x561d,
	0x5604,
	0x55ff,
	0x55f9,
	0x5889,
	0x587c,
	0x5890,
	0x5898,
	0x5886,
	0x5881,
	0x587f,
	0x5874,
	0x588b,
	0x587a,
	0x5887,
	0x5891,
	0x588e,
	0x5876,
	0x5882,
	0x5888,
	0x587b,
	0x5894,
	0x588f,
	0x58fe,
	0x596b,
	0x5adc,
	0x5aee,
	0x5ae5,
	0x5ad5,
	0x5aea,
	0x5ada,
	0x5aed,
	0x5aeb,
	0x5af3,
	0x5ae2,
	0x5ae0,
	0x5adb,
	0x5aec,
	0x5ade,
	0x5add,
	0x5ad9,
	0x5ae8,
	0x5adf,
	0x5b77,
	0x5be0
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_124[]=
	{
	0x5be3,
	0x5c63,
	0x5d82,
	0x5d80,
	0x5d7d,
	0x5d86,
	0x5d7a,
	0x5d81,
	0x5d77,
	0x5d8a,
	0x5d89,
	0x5d88,
	0x5d7e,
	0x5d7c,
	0x5d8d,
	0x5d79,
	0x5d7f,
	0x5e58,
	0x5e59,
	0x5e53,
	0x5ed8,
	0x5ed1,
	0x5ed7,
	0x5ece,
	0x5edc,
	0x5ed5,
	0x5ed9,
	0x5ed2,
	0x5ed4,
	0x5f44,
	0x5f43,
	0x5f6f,
	0x5fb6,
	0x612c,
	0x6128,
	0x6141,
	0x615e,
	0x6171,
	0x6173,
	0x6152,
	0x6153,
	0x6172,
	0x616c,
	0x6180,
	0x6174,
	0x6154,
	0x617a,
	0x615b,
	0x6165,
	0x613b,
	0x616a,
	0x6161,
	0x6156,
	0x6229,
	0x6227,
	0x622b,
	0x642b,
	0x644d,
	0x645b,
	0x645d,
	0x6474,
	0x6476,
	0x6472,
	0x6473,
	0x647d,
	0x6475,
	0x6466,
	0x64a6,
	0x644e,
	0x6482,
	0x645e,
	0x645c,
	0x644b,
	0x6453,
	0x6460,
	0x6450,
	0x647f,
	0x643f,
	0x646c,
	0x646b,
	0x6459,
	0x6465,
	0x6477,
	0x6573,
	0x65a0,
	0x66a1,
	0x66a0,
	0x669f,
	0x6705,
	0x6704,
	0x6722,
	0x69b1,
	0x69b6,
	0x69c9
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_125[]=
	{
	0x69a0,
	0x69ce,
	0x6996,
	0x69b0,
	0x69ac,
	0x69bc,
	0x6991,
	0x6999,
	0x698e,
	0x69a7,
	0x698d,
	0x69a9,
	0x69be,
	0x69af,
	0x69bf,
	0x69c4,
	0x69bd,
	0x69a4,
	0x69d4,
	0x69b9,
	0x69ca,
	0x699a,
	0x69cf,
	0x69b3,
	0x6993,
	0x69aa,
	0x69a1,
	0x699e,
	0x69d9,
	0x6997,
	0x6990,
	0x69c2,
	0x69b5,
	0x69a5,
	0x69c6,
	0x6b4a,
	0x6b4d,
	0x6b4b,
	0x6b9e,
	0x6b9f,
	0x6ba0,
	0x6bc3,
	0x6bc4,
	0x6bfe,
	0x6ece,
	0x6ef5,
	0x6ef1,
	0x6f03,
	0x6f25,
	0x6ef8,
	0x6f37,
	0x6efb,
	0x6f2e,
	0x6f09,
	0x6f4e,
	0x6f19,
	0x6f1a,
	0x6f27,
	0x6f18,
	0x6f3b,
	0x6f12,
	0x6eed,
	0x6f0a
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_126[]=
	{
	0x6f36,
	0x6f73,
	0x6ef9,
	0x6eee,
	0x6f2d,
	0x6f40,
	0x6f30,
	0x6f3c,
	0x6f35,
	0x6eeb,
	0x6f07,
	0x6f0e,
	0x6f43,
	0x6f05,
	0x6efd,
	0x6ef6,
	0x6f39,
	0x6f1c,
	0x6efc,
	0x6f3a,
	0x6f1f,
	0x6f0d,
	0x6f1e,
	0x6f08,
	0x6f21,
	0x7187,
	0x7190,
	0x7189,
	0x7180,
	0x7185,
	0x7182,
	0x718f,
	0x717b,
	0x7186,
	0x7181,
	0x7197,
	0x7244,
	0x7253,
	0x7297,
	0x7295,
	0x7293,
	0x7343,
	0x734d,
	0x7351,
	0x734c,
	0x7462,
	0x7473,
	0x7471,
	0x7475,
	0x7472,
	0x7467,
	0x746e,
	0x7500,
	0x7502,
	0x7503,
	0x757d,
	0x7590,
	0x7616,
	0x7608,
	0x760c,
	0x7615,
	0x7611,
	0x760a,
	0x7614,
	0x76b8,
	0x7781,
	0x777c,
	0x7785,
	0x7782,
	0x776e,
	0x7780,
	0x776f,
	0x777e,
	0x7783,
	0x78b2,
	0x78aa,
	0x78b4,
	0x78ad,
	0x78a8,
	0x787e,
	0x78ab,
	0x789e,
	0x78a5,
	0x78a0,
	0x78ac,
	0x78a2,
	0x78a4,
	0x7998,
	0x798a,
	0x798b,
	0x7996,
	0x7995,
	0x7994,
	0x7993
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_127[]=
	{
	0x7997,
	0x7988,
	0x7992,
	0x7990,
	0x7a2b,
	0x7a4a,
	0x7a30,
	0x7a2f,
	0x7a28,
	0x7a26,
	0x7aa8,
	0x7aab,
	0x7aac,
	0x7aee,
	0x7b88,
	0x7b9c,
	0x7b8a,
	0x7b91,
	0x7b90,
	0x7b96,
	0x7b8d,
	0x7b8c,
	0x7b9b,
	0x7b8e,
	0x7b85,
	0x7b98,
	0x5284,
	0x7b99,
	0x7ba4,
	0x7b82,
	0x7cbb,
	0x7cbf,
	0x7cbc,
	0x7cba,
	0x7da7,
	0x7db7,
	0x7dc2,
	0x7da3,
	0x7daa,
	0x7dc1,
	0x7dc0,
	0x7dc5,
	0x7d9d,
	0x7dce,
	0x7dc4,
	0x7dc6,
	0x7dcb,
	0x7dcc,
	0x7daf,
	0x7db9,
	0x7d96,
	0x7dbc,
	0x7d9f,
	0x7da6,
	0x7dae,
	0x7da9,
	0x7da1,
	0x7dc9,
	0x7f73,
	0x7fe2,
	0x7fe3,
	0x7fe5,
	0x7fde
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_128[]=
	{
	0x8024,
	0x805d,
	0x805c,
	0x8189,
	0x8186,
	0x8183,
	0x8187,
	0x818d,
	0x818c,
	0x818b,
	0x8215,
	0x8497,
	0x84a4,
	0x84a1,
	0x849f,
	0x84ba,
	0x84ce,
	0x84c2,
	0x84ac,
	0x84ae,
	0x84ab,
	0x84b9,
	0x84b4,
	0x84c1,
	0x84cd,
	0x84aa,
	0x849a,
	0x84b1,
	0x84d0,
	0x849d,
	0x84a7,
	0x84bb,
	0x84a2,
	0x8494,
	0x84c7,
	0x84cc,
	0x849b,
	0x84a9,
	0x84af,
	0x84a8,
	0x84d6,
	0x8498,
	0x84b6,
	0x84cf,
	0x84a0,
	0x84d7,
	0x84d4,
	0x84d2,
	0x84db,
	0x84b0,
	0x8491,
	0x8661,
	0x8733,
	0x8723,
	0x8728,
	0x876b,
	0x8740,
	0x872e,
	0x871e,
	0x8721,
	0x8719,
	0x871b,
	0x8743,
	0x872c,
	0x8741,
	0x873e,
	0x8746,
	0x8720,
	0x8732,
	0x872a,
	0x872d,
	0x873c,
	0x8712,
	0x873a,
	0x8731,
	0x8735,
	0x8742,
	0x8726,
	0x8727,
	0x8738,
	0x8724,
	0x871a,
	0x8730,
	0x8711,
	0x88f7,
	0x88e7,
	0x88f1,
	0x88f2,
	0x88fa,
	0x88fe,
	0x88ee,
	0x88fc,
	0x88f6,
	0x88fb
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_129[]=
	{
	0x88f0,
	0x88ec,
	0x88eb,
	0x899d,
	0x89a1,
	0x899f,
	0x899e,
	0x89e9,
	0x89eb,
	0x89e8,
	0x8aab,
	0x8a99,
	0x8a8b,
	0x8a92,
	0x8a8f,
	0x8a96,
	0x8c3d,
	0x8c68,
	0x8c69,
	0x8cd5,
	0x8ccf,
	0x8cd7,
	0x8d96,
	0x8e09,
	0x8e02,
	0x8dff,
	0x8e0d,
	0x8dfd,
	0x8e0a,
	0x8e03,
	0x8e07,
	0x8e06,
	0x8e05,
	0x8dfe,
	0x8e00,
	0x8e04,
	0x8f10,
	0x8f11,
	0x8f0e,
	0x8f0d,
	0x9123,
	0x911c,
	0x9120,
	0x9122,
	0x911f,
	0x911d,
	0x911a,
	0x9124,
	0x9121,
	0x911b,
	0x917a,
	0x9172,
	0x9179,
	0x9173,
	0x92a5,
	0x92a4,
	0x9276,
	0x929b,
	0x927a,
	0x92a0,
	0x9294,
	0x92aa,
	0x928d
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_130[]=
	{
	0x92a6,
	0x929a,
	0x92ab,
	0x9279,
	0x9297,
	0x927f,
	0x92a3,
	0x92ee,
	0x928e,
	0x9282,
	0x9295,
	0x92a2,
	0x927d,
	0x9288,
	0x92a1,
	0x928a,
	0x9286,
	0x928c,
	0x9299,
	0x92a7,
	0x927e,
	0x9287,
	0x92a9,
	0x929d,
	0x928b,
	0x922d,
	0x969e,
	0x96a1,
	0x96ff,
	0x9758,
	0x977d,
	0x977a,
	0x977e,
	0x9783,
	0x9780,
	0x9782,
	0x977b,
	0x9784,
	0x9781,
	0x977f,
	0x97ce,
	0x97cd,
	0x9816,
	0x98ad,
	0x98ae,
	0x9902,
	0x9900,
	0x9907,
	0x999d,
	0x999c,
	0x99c3,
	0x99b9,
	0x99bb,
	0x99ba,
	0x99c2,
	0x99bd,
	0x99c7,
	0x9ab1,
	0x9ae3,
	0x9ae7,
	0x9b3e,
	0x9b3f,
	0x9b60,
	0x9b61,
	0x9b5f,
	0x9cf1,
	0x9cf2,
	0x9cf5,
	0x9ea7,
	0x50ff,
	0x5103,
	0x5130,
	0x50f8,
	0x5106,
	0x5107,
	0x50f6,
	0x50fe,
	0x510b,
	0x510c,
	0x50fd,
	0x510a,
	0x528b,
	0x528c,
	0x52f1,
	0x52ef,
	0x5648,
	0x5642,
	0x564c,
	0x5635,
	0x5641,
	0x564a,
	0x5649,
	0x5646,
	0x5658
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_131[]=
	{
	0x565a,
	0x5640,
	0x5633,
	0x563d,
	0x562c,
	0x563e,
	0x5638,
	0x562a,
	0x563a,
	0x571a,
	0x58ab,
	0x589d,
	0x58b1,
	0x58a0,
	0x58a3,
	0x58af,
	0x58ac,
	0x58a5,
	0x58a1,
	0x58ff,
	0x5aff,
	0x5af4,
	0x5afd,
	0x5af7,
	0x5af6,
	0x5b03,
	0x5af8,
	0x5b02,
	0x5af9,
	0x5b01,
	0x5b07,
	0x5b05,
	0x5b0f,
	0x5c67,
	0x5d99,
	0x5d97,
	0x5d9f,
	0x5d92,
	0x5da2,
	0x5d93,
	0x5d95,
	0x5da0,
	0x5d9c,
	0x5da1,
	0x5d9a,
	0x5d9e,
	0x5e69,
	0x5e5d,
	0x5e60,
	0x5e5c,
	0x7df3,
	0x5edb,
	0x5ede,
	0x5ee1,
	0x5f49,
	0x5fb2,
	0x618b,
	0x6183,
	0x6179,
	0x61b1,
	0x61b0,
	0x61a2,
	0x6189
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_132[]=
	{
	0x619b,
	0x6193,
	0x61af,
	0x61ad,
	0x619f,
	0x6192,
	0x61aa,
	0x61a1,
	0x618d,
	0x6166,
	0x61b3,
	0x622d,
	0x646e,
	0x6470,
	0x6496,
	0x64a0,
	0x6485,
	0x6497,
	0x649c,
	0x648f,
	0x648b,
	0x648a,
	0x648c,
	0x64a3,
	0x649f,
	0x6468,
	0x64b1,
	0x6498,
	0x6576,
	0x657a,
	0x6579,
	0x657b,
	0x65b2,
	0x65b3,
	0x66b5,
	0x66b0,
	0x66a9,
	0x66b2,
	0x66b7,
	0x66aa,
	0x66af,
	0x6a00,
	0x6a06,
	0x6a17,
	0x69e5,
	0x69f8,
	0x6a15,
	0x69f1,
	0x69e4,
	0x6a20,
	0x69ff,
	0x69ec,
	0x69e2,
	0x6a1b,
	0x6a1d,
	0x69fe,
	0x6a27,
	0x69f2,
	0x69ee,
	0x6a14,
	0x69f7,
	0x69e7,
	0x6a40,
	0x6a08,
	0x69e6,
	0x69fb,
	0x6a0d,
	0x69fc,
	0x69eb,
	0x6a09,
	0x6a04,
	0x6a18,
	0x6a25,
	0x6a0f,
	0x69f6,
	0x6a26,
	0x6a07,
	0x69f4,
	0x6a16,
	0x6b51,
	0x6ba5,
	0x6ba3,
	0x6ba2,
	0x6ba6,
	0x6c01,
	0x6c00,
	0x6bff,
	0x6c02,
	0x6f41,
	0x6f26,
	0x6f7e,
	0x6f87,
	0x6fc6,
	0x6f92
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_133[]=
	{
	0x6f8d,
	0x6f89,
	0x6f8c,
	0x6f62,
	0x6f4f,
	0x6f85,
	0x6f5a,
	0x6f96,
	0x6f76,
	0x6f6c,
	0x6f82,
	0x6f55,
	0x6f72,
	0x6f52,
	0x6f50,
	0x6f57,
	0x6f94,
	0x6f93,
	0x6f5d,
	0x6f00,
	0x6f61,
	0x6f6b,
	0x6f7d,
	0x6f67,
	0x6f90,
	0x6f53,
	0x6f8b,
	0x6f69,
	0x6f7f,
	0x6f95,
	0x6f63,
	0x6f77,
	0x6f6a,
	0x6f7b,
	0x71b2,
	0x71af,
	0x719b,
	0x71b0,
	0x71a0,
	0x719a,
	0x71a9,
	0x71b5,
	0x719d,
	0x71a5,
	0x719e,
	0x71a4,
	0x71a1,
	0x71aa,
	0x719c,
	0x71a7,
	0x71b3,
	0x7298,
	0x729a,
	0x7358,
	0x7352,
	0x735e,
	0x735f,
	0x7360,
	0x735d,
	0x735b,
	0x7361,
	0x735a,
	0x7359
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_134[]=
	{
	0x7362,
	0x7487,
	0x7489,
	0x748a,
	0x7486,
	0x7481,
	0x747d,
	0x7485,
	0x7488,
	0x747c,
	0x7479,
	0x7508,
	0x7507,
	0x757e,
	0x7625,
	0x761e,
	0x7619,
	0x761d,
	0x761c,
	0x7623,
	0x761a,
	0x7628,
	0x761b,
	0x769c,
	0x769d,
	0x769e,
	0x769b,
	0x778d,
	0x778f,
	0x7789,
	0x7788,
	0x78cd,
	0x78bb,
	0x78cf,
	0x78cc,
	0x78d1,
	0x78ce,
	0x78d4,
	0x78c8,
	0x78c3,
	0x78c4,
	0x78c9,
	0x799a,
	0x79a1,
	0x79a0,
	0x799c,
	0x79a2,
	0x799b,
	0x6b76,
	0x7a39,
	0x7ab2,
	0x7ab4,
	0x7ab3,
	0x7bb7,
	0x7bcb,
	0x7bbe,
	0x7bac,
	0x7bce,
	0x7baf,
	0x7bb9,
	0x7bca,
	0x7bb5,
	0x7cc5,
	0x7cc8,
	0x7ccc,
	0x7ccb,
	0x7df7,
	0x7ddb,
	0x7dea,
	0x7de7,
	0x7dd7,
	0x7de1,
	0x7e03,
	0x7dfa,
	0x7de6,
	0x7df6,
	0x7df1,
	0x7df0,
	0x7dee,
	0x7ddf,
	0x7f76,
	0x7fac,
	0x7fb0,
	0x7fad,
	0x7fed,
	0x7feb,
	0x7fea,
	0x7fec,
	0x7fe6,
	0x7fe8,
	0x8064,
	0x8067,
	0x81a3,
	0x819f
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_135[]=
	{
	0x819e,
	0x8195,
	0x81a2,
	0x8199,
	0x8197,
	0x8216,
	0x824f,
	0x8253,
	0x8252,
	0x8250,
	0x824e,
	0x8251,
	0x8524,
	0x853b,
	0x850f,
	0x8500,
	0x8529,
	0x850e,
	0x8509,
	0x850d,
	0x851f,
	0x850a,
	0x8527,
	0x851c,
	0x84fb,
	0x852b,
	0x84fa,
	0x8508,
	0x850c,
	0x84f4,
	0x852a,
	0x84f2,
	0x8515,
	0x84f7,
	0x84eb,
	0x84f3,
	0x84fc,
	0x8512,
	0x84ea,
	0x84e9,
	0x8516,
	0x84fe,
	0x8528,
	0x851d,
	0x852e,
	0x8502,
	0x84fd,
	0x851e,
	0x84f6,
	0x8531,
	0x8526,
	0x84e7,
	0x84e8,
	0x84f0,
	0x84ef,
	0x84f9,
	0x8518,
	0x8520,
	0x8530,
	0x850b,
	0x8519,
	0x852f,
	0x8662
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_136[]=
	{
	0x8756,
	0x8763,
	0x8764,
	0x8777,
	0x87e1,
	0x8773,
	0x8758,
	0x8754,
	0x875b,
	0x8752,
	0x8761,
	0x875a,
	0x8751,
	0x875e,
	0x876d,
	0x876a,
	0x8750,
	0x874e,
	0x875f,
	0x875d,
	0x876f,
	0x876c,
	0x877a,
	0x876e,
	0x875c,
	0x8765,
	0x874f,
	0x877b,
	0x8775,
	0x8762,
	0x8767,
	0x8769,
	0x885a,
	0x8905,
	0x890c,
	0x8914,
	0x890b,
	0x8917,
	0x8918,
	0x8919,
	0x8906,
	0x8916,
	0x8911,
	0x890e,
	0x8909,
	0x89a2,
	0x89a4,
	0x89a3,
	0x89ed,
	0x89f0,
	0x89ec,
	0x8acf,
	0x8ac6,
	0x8ab8,
	0x8ad3,
	0x8ad1,
	0x8ad4,
	0x8ad5,
	0x8abb,
	0x8ad7,
	0x8abe,
	0x8ac0,
	0x8ac5,
	0x8ad8,
	0x8ac3,
	0x8aba,
	0x8abd,
	0x8ad9,
	0x8c3e,
	0x8c4d,
	0x8c8f,
	0x8ce5,
	0x8cdf,
	0x8cd9,
	0x8ce8,
	0x8cda,
	0x8cdd,
	0x8ce7,
	0x8da0,
	0x8d9c,
	0x8da1,
	0x8d9b,
	0x8e20,
	0x8e23,
	0x8e25,
	0x8e24,
	0x8e2e,
	0x8e15,
	0x8e1b,
	0x8e16,
	0x8e11,
	0x8e19,
	0x8e26,
	0x8e27
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_137[]=
	{
	0x8e14,
	0x8e12,
	0x8e18,
	0x8e13,
	0x8e1c,
	0x8e17,
	0x8e1a,
	0x8f2c,
	0x8f24,
	0x8f18,
	0x8f1a,
	0x8f20,
	0x8f23,
	0x8f16,
	0x8f17,
	0x9073,
	0x9070,
	0x906f,
	0x9067,
	0x906b,
	0x912f,
	0x912b,
	0x9129,
	0x912a,
	0x9132,
	0x9126,
	0x912e,
	0x9185,
	0x9186,
	0x918a,
	0x9181,
	0x9182,
	0x9184,
	0x9180,
	0x92d0,
	0x92c3,
	0x92c4,
	0x92c0,
	0x92d9,
	0x92b6,
	0x92cf,
	0x92f1,
	0x92df,
	0x92d8,
	0x92e9,
	0x92d7,
	0x92dd,
	0x92cc,
	0x92ef,
	0x92c2,
	0x92e8,
	0x92ca,
	0x92c8,
	0x92ce,
	0x92e6,
	0x92cd,
	0x92d5,
	0x92c9,
	0x92e0,
	0x92de,
	0x92e7,
	0x92d1,
	0x92d3
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_138[]=
	{
	0x92b5,
	0x92e1,
	0x92c6,
	0x92b4,
	0x957c,
	0x95ac,
	0x95ab,
	0x95ae,
	0x95b0,
	0x96a4,
	0x96a2,
	0x96d3,
	0x9705,
	0x9708,
	0x9702,
	0x975a,
	0x978a,
	0x978e,
	0x9788,
	0x97d0,
	0x97cf,
	0x981e,
	0x981d,
	0x9826,
	0x9829,
	0x9828,
	0x9820,
	0x981b,
	0x9827,
	0x98b2,
	0x9908,
	0x98fa,
	0x9911,
	0x9914,
	0x9916,
	0x9917,
	0x9915,
	0x99dc,
	0x99cd,
	0x99cf,
	0x99d3,
	0x99d4,
	0x99ce,
	0x99c9,
	0x99d6,
	0x99d8,
	0x99cb,
	0x99d7,
	0x99cc,
	0x9ab3,
	0x9aec,
	0x9aeb,
	0x9af3,
	0x9af2,
	0x9af1,
	0x9b46,
	0x9b43,
	0x9b67,
	0x9b74,
	0x9b71,
	0x9b66,
	0x9b76,
	0x9b75,
	0x9b70,
	0x9b68,
	0x9b64,
	0x9b6c,
	0x9cfc,
	0x9cfa,
	0x9cfd,
	0x9cff,
	0x9cf7,
	0x9d07,
	0x9d00,
	0x9cf9,
	0x9cfb,
	0x9d08,
	0x9d05,
	0x9d04,
	0x9e83,
	0x9ed3,
	0x9f0f,
	0x9f10,
	0x511c,
	0x5113,
	0x5117,
	0x511a,
	0x5111,
	0x51de,
	0x5334,
	0x53e1,
	0x5670,
	0x5660,
	0x566e
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_139[]=
	{
	0x5673,
	0x5666,
	0x5663,
	0x566d,
	0x5672,
	0x565e,
	0x5677,
	0x571c,
	0x571b,
	0x58c8,
	0x58bd,
	0x58c9,
	0x58bf,
	0x58ba,
	0x58c2,
	0x58bc,
	0x58c6,
	0x5b17,
	0x5b19,
	0x5b1b,
	0x5b21,
	0x5b14,
	0x5b13,
	0x5b10,
	0x5b16,
	0x5b28,
	0x5b1a,
	0x5b20,
	0x5b1e,
	0x5bef,
	0x5dac,
	0x5db1,
	0x5da9,
	0x5da7,
	0x5db5,
	0x5db0,
	0x5dae,
	0x5daa,
	0x5da8,
	0x5db2,
	0x5dad,
	0x5daf,
	0x5db4,
	0x5e67,
	0x5e68,
	0x5e66,
	0x5e6f,
	0x5ee9,
	0x5ee7,
	0x5ee6,
	0x5ee8,
	0x5ee5,
	0x5f4b,
	0x5fbc,
	0x619d,
	0x61a8,
	0x6196,
	0x61c5,
	0x61b4,
	0x61c6,
	0x61c1,
	0x61cc,
	0x61ba
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_140[]=
	{
	0x61bf,
	0x61b8,
	0x618c,
	0x64d7,
	0x64d6,
	0x64d0,
	0x64cf,
	0x64c9,
	0x64bd,
	0x6489,
	0x64c3,
	0x64db,
	0x64f3,
	0x64d9,
	0x6533,
	0x657f,
	0x657c,
	0x65a2,
	0x66c8,
	0x66be,
	0x66c0,
	0x66ca,
	0x66cb,
	0x66cf,
	0x66bd,
	0x66bb,
	0x66ba,
	0x66cc,
	0x6723,
	0x6a34,
	0x6a66,
	0x6a49,
	0x6a67,
	0x6a32,
	0x6a68,
	0x6a3e,
	0x6a5d,
	0x6a6d,
	0x6a76,
	0x6a5b,
	0x6a51,
	0x6a28,
	0x6a5a,
	0x6a3b,
	0x6a3f,
	0x6a41,
	0x6a6a,
	0x6a64,
	0x6a50,
	0x6a4f,
	0x6a54,
	0x6a6f,
	0x6a69,
	0x6a60,
	0x6a3c,
	0x6a5e,
	0x6a56,
	0x6a55,
	0x6a4d,
	0x6a4e,
	0x6a46,
	0x6b55,
	0x6b54,
	0x6b56,
	0x6ba7,
	0x6baa,
	0x6bab,
	0x6bc8,
	0x6bc7,
	0x6c04,
	0x6c03,
	0x6c06,
	0x6fad,
	0x6fcb,
	0x6fa3,
	0x6fc7,
	0x6fbc,
	0x6fce,
	0x6fc8,
	0x6f5e,
	0x6fc4,
	0x6fbd,
	0x6f9e,
	0x6fca,
	0x6fa8,
	0x7004,
	0x6fa5,
	0x6fae,
	0x6fba,
	0x6fac,
	0x6faa,
	0x6fcf,
	0x6fbf,
	0x6fb8
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_141[]=
	{
	0x6fa2,
	0x6fc9,
	0x6fab,
	0x6fcd,
	0x6faf,
	0x6fb2,
	0x6fb0,
	0x71c5,
	0x71c2,
	0x71bf,
	0x71b8,
	0x71d6,
	0x71c0,
	0x71c1,
	0x71cb,
	0x71d4,
	0x71ca,
	0x71c7,
	0x71cf,
	0x71bd,
	0x71d8,
	0x71bc,
	0x71c6,
	0x71da,
	0x71db,
	0x729d,
	0x729e,
	0x7369,
	0x7366,
	0x7367,
	0x736c,
	0x7365,
	0x736b,
	0x736a,
	0x747f,
	0x749a,
	0x74a0,
	0x7494,
	0x7492,
	0x7495,
	0x74a1,
	0x750b,
	0x7580,
	0x762f,
	0x762d,
	0x7631,
	0x763d,
	0x7633,
	0x763c,
	0x7635,
	0x7632,
	0x7630,
	0x76bb,
	0x76e6,
	0x779a,
	0x779d,
	0x77a1,
	0x779c,
	0x779b,
	0x77a2,
	0x77a3,
	0x7795,
	0x7799
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_142[]=
	{
	0x7797,
	0x78dd,
	0x78e9,
	0x78e5,
	0x78ea,
	0x78de,
	0x78e3,
	0x78db,
	0x78e1,
	0x78e2,
	0x78ed,
	0x78df,
	0x78e0,
	0x79a4,
	0x7a44,
	0x7a48,
	0x7a47,
	0x7ab6,
	0x7ab8,
	0x7ab5,
	0x7ab1,
	0x7ab7,
	0x7bde,
	0x7be3,
	0x7be7,
	0x7bdd,
	0x7bd5,
	0x7be5,
	0x7bda,
	0x7be8,
	0x7bf9,
	0x7bd4,
	0x7bea,
	0x7be2,
	0x7bdc,
	0x7beb,
	0x7bd8,
	0x7bdf,
	0x7cd2,
	0x7cd4,
	0x7cd7,
	0x7cd0,
	0x7cd1,
	0x7e12,
	0x7e21,
	0x7e17,
	0x7e0c,
	0x7e1f,
	0x7e20,
	0x7e13,
	0x7e0e,
	0x7e1c,
	0x7e15,
	0x7e1a,
	0x7e22,
	0x7e0b,
	0x7e0f,
	0x7e16,
	0x7e0d,
	0x7e14,
	0x7e25,
	0x7e24,
	0x7f43,
	0x7f7b,
	0x7f7c,
	0x7f7a,
	0x7fb1,
	0x7fef,
	0x802a,
	0x8029,
	0x806c,
	0x81b1,
	0x81a6,
	0x81ae,
	0x81b9,
	0x81b5,
	0x81ab,
	0x81b0,
	0x81ac,
	0x81b4,
	0x81b2,
	0x81b7,
	0x81a7,
	0x81f2,
	0x8255,
	0x8256,
	0x8257,
	0x8556,
	0x8545,
	0x856b,
	0x854d,
	0x8553,
	0x8561,
	0x8558
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_143[]=
	{
	0x8540,
	0x8546,
	0x8564,
	0x8541,
	0x8562,
	0x8544,
	0x8551,
	0x8547,
	0x8563,
	0x853e,
	0x855b,
	0x8571,
	0x854e,
	0x856e,
	0x8575,
	0x8555,
	0x8567,
	0x8560,
	0x858c,
	0x8566,
	0x855d,
	0x8554,
	0x8565,
	0x856c,
	0x8663,
	0x8665,
	0x8664,
	0x879b,
	0x878f,
	0x8797,
	0x8793,
	0x8792,
	0x8788,
	0x8781,
	0x8796,
	0x8798,
	0x8779,
	0x8787,
	0x87a3,
	0x8785,
	0x8790,
	0x8791,
	0x879d,
	0x8784,
	0x8794,
	0x879c,
	0x879a,
	0x8789,
	0x891e,
	0x8926,
	0x8930,
	0x892d,
	0x892e,
	0x8927,
	0x8931,
	0x8922,
	0x8929,
	0x8923,
	0x892f,
	0x892c,
	0x891f,
	0x89f1,
	0x8ae0
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_144[]=
	{
	0x8ae2,
	0x8af2,
	0x8af4,
	0x8af5,
	0x8add,
	0x8b14,
	0x8ae4,
	0x8adf,
	0x8af0,
	0x8ac8,
	0x8ade,
	0x8ae1,
	0x8ae8,
	0x8aff,
	0x8aef,
	0x8afb,
	0x8c91,
	0x8c92,
	0x8c90,
	0x8cf5,
	0x8cee,
	0x8cf1,
	0x8cf0,
	0x8cf3,
	0x8d6c,
	0x8d6e,
	0x8da5,
	0x8da7,
	0x8e33,
	0x8e3e,
	0x8e38,
	0x8e40,
	0x8e45,
	0x8e36,
	0x8e3c,
	0x8e3d,
	0x8e41,
	0x8e30,
	0x8e3f,
	0x8ebd,
	0x8f36,
	0x8f2e,
	0x8f35,
	0x8f32,
	0x8f39,
	0x8f37,
	0x8f34,
	0x9076,
	0x9079,
	0x907b,
	0x9086,
	0x90fa,
	0x9133,
	0x9135,
	0x9136,
	0x9193,
	0x9190,
	0x9191,
	0x918d,
	0x918f,
	0x9327,
	0x931e,
	0x9308,
	0x931f,
	0x9306,
	0x930f,
	0x937a,
	0x9338,
	0x933c,
	0x931b,
	0x9323,
	0x9312,
	0x9301,
	0x9346,
	0x932d,
	0x930e,
	0x930d,
	0x92cb,
	0x931d,
	0x92fa,
	0x9325,
	0x9313,
	0x92f9,
	0x92f7,
	0x9334,
	0x9302,
	0x9324,
	0x92ff,
	0x9329,
	0x9339,
	0x9335,
	0x932a,
	0x9314,
	0x930c
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_145[]=
	{
	0x930b,
	0x92fe,
	0x9309,
	0x9300,
	0x92fb,
	0x9316,
	0x95bc,
	0x95cd,
	0x95be,
	0x95b9,
	0x95ba,
	0x95b6,
	0x95bf,
	0x95b5,
	0x95bd,
	0x96a9,
	0x96d4,
	0x970b,
	0x9712,
	0x9710,
	0x9799,
	0x9797,
	0x9794,
	0x97f0,
	0x97f8,
	0x9835,
	0x982f,
	0x9832,
	0x9924,
	0x991f,
	0x9927,
	0x9929,
	0x999e,
	0x99ee,
	0x99ec,
	0x99e5,
	0x99e4,
	0x99f0,
	0x99e3,
	0x99ea,
	0x99e9,
	0x99e7,
	0x9ab9,
	0x9abf,
	0x9ab4,
	0x9abb,
	0x9af6,
	0x9afa,
	0x9af9,
	0x9af7,
	0x9b33,
	0x9b80,
	0x9b85,
	0x9b87,
	0x9b7c,
	0x9b7e,
	0x9b7b,
	0x9b82,
	0x9b93,
	0x9b92,
	0x9b90,
	0x9b7a,
	0x9b95
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_146[]=
	{
	0x9b7d,
	0x9b88,
	0x9d25,
	0x9d17,
	0x9d20,
	0x9d1e,
	0x9d14,
	0x9d29,
	0x9d1d,
	0x9d18,
	0x9d22,
	0x9d10,
	0x9d19,
	0x9d1f,
	0x9e88,
	0x9e86,
	0x9e87,
	0x9eae,
	0x9ead,
	0x9ed5,
	0x9ed6,
	0x9efa,
	0x9f12,
	0x9f3d,
	0x5126,
	0x5125,
	0x5122,
	0x5124,
	0x5120,
	0x5129,
	0x52f4,
	0x5693,
	0x568c,
	0x568d,
	0x5686,
	0x5684,
	0x5683,
	0x567e,
	0x5682,
	0x567f,
	0x5681,
	0x58d6,
	0x58d4,
	0x58cf,
	0x58d2,
	0x5b2d,
	0x5b25,
	0x5b32,
	0x5b23,
	0x5b2c,
	0x5b27,
	0x5b26,
	0x5b2f,
	0x5b2e,
	0x5b7b,
	0x5bf1,
	0x5bf2,
	0x5db7,
	0x5e6c,
	0x5e6a,
	0x5fbe,
	0x5fbb,
	0x61c3,
	0x61b5,
	0x61bc,
	0x61e7,
	0x61e0,
	0x61e5,
	0x61e4,
	0x61e8,
	0x61de,
	0x64ef,
	0x64e9,
	0x64e3,
	0x64eb,
	0x64e4,
	0x64e8,
	0x6581,
	0x6580,
	0x65b6,
	0x65da,
	0x66d2,
	0x6a8d,
	0x6a96,
	0x6a81,
	0x6aa5,
	0x6a89,
	0x6a9f,
	0x6a9b,
	0x6aa1,
	0x6a9e,
	0x6a87,
	0x6a93,
	0x6a8e
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_147[]=
	{
	0x6a95,
	0x6a83,
	0x6aa8,
	0x6aa4,
	0x6a91,
	0x6a7f,
	0x6aa6,
	0x6a9a,
	0x6a85,
	0x6a8c,
	0x6a92,
	0x6b5b,
	0x6bad,
	0x6c09,
	0x6fcc,
	0x6fa9,
	0x6ff4,
	0x6fd4,
	0x6fe3,
	0x6fdc,
	0x6fed,
	0x6fe7,
	0x6fe6,
	0x6fde,
	0x6ff2,
	0x6fdd,
	0x6fe2,
	0x6fe8,
	0x71e1,
	0x71f1,
	0x71e8,
	0x71f2,
	0x71e4,
	0x71f0,
	0x71e2,
	0x7373,
	0x736e,
	0x736f,
	0x7497,
	0x74b2,
	0x74ab,
	0x7490,
	0x74aa,
	0x74ad,
	0x74b1,
	0x74a5,
	0x74af,
	0x7510,
	0x7511,
	0x7512,
	0x750f,
	0x7584,
	0x7643,
	0x7648,
	0x7649,
	0x7647,
	0x76a4,
	0x76e9,
	0x77b5,
	0x77ab,
	0x77b2,
	0x77b7,
	0x77b6
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_148[]=
	{
	0x77b4,
	0x77b1,
	0x77a8,
	0x77f0,
	0x78f3,
	0x78fd,
	0x7902,
	0x78fb,
	0x78fc,
	0x78f2,
	0x7905,
	0x78f9,
	0x78fe,
	0x7904,
	0x79ab,
	0x79a8,
	0x7a5c,
	0x7a5b,
	0x7a56,
	0x7a58,
	0x7a54,
	0x7a5a,
	0x7abe,
	0x7ac0,
	0x7ac1,
	0x7c05,
	0x7c0f,
	0x7bf2,
	0x7c00,
	0x7bff,
	0x7bfb,
	0x7c0e,
	0x7bf4,
	0x7c0b,
	0x7bf3,
	0x7c02,
	0x7c09,
	0x7c03,
	0x7c01,
	0x7bf8,
	0x7bfd,
	0x7c06,
	0x7bf0,
	0x7bf1,
	0x7c10,
	0x7c0a,
	0x7ce8,
	0x7e2d,
	0x7e3c,
	0x7e42,
	0x7e33,
	0x9848,
	0x7e38,
	0x7e2a,
	0x7e49,
	0x7e40,
	0x7e47,
	0x7e29,
	0x7e4c,
	0x7e30,
	0x7e3b,
	0x7e36,
	0x7e44,
	0x7e3a,
	0x7f45,
	0x7f7f,
	0x7f7e,
	0x7f7d,
	0x7ff4,
	0x7ff2,
	0x802c,
	0x81bb,
	0x81c4,
	0x81cc,
	0x81ca,
	0x81c5,
	0x81c7,
	0x81bc,
	0x81e9,
	0x825b,
	0x825a,
	0x825c,
	0x8583,
	0x8580,
	0x858f,
	0x85a7,
	0x8595,
	0x85a0,
	0x858b,
	0x85a3,
	0x857b,
	0x85a4,
	0x859a,
	0x859e
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_149[]=
	{
	0x8577,
	0x857c,
	0x8589,
	0x85a1,
	0x857a,
	0x8578,
	0x8557,
	0x858e,
	0x8596,
	0x8586,
	0x858d,
	0x8599,
	0x859d,
	0x8581,
	0x85a2,
	0x8582,
	0x8588,
	0x8585,
	0x8579,
	0x8576,
	0x8598,
	0x8590,
	0x859f,
	0x8668,
	0x87be,
	0x87aa,
	0x87ad,
	0x87c5,
	0x87b0,
	0x87ac,
	0x87b9,
	0x87b5,
	0x87bc,
	0x87ae,
	0x87c9,
	0x87c3,
	0x87c2,
	0x87cc,
	0x87b7,
	0x87af,
	0x87c4,
	0x87ca,
	0x87b4,
	0x87b6,
	0x87bf,
	0x87b8,
	0x87bd,
	0x87de,
	0x87b2,
	0x8935,
	0x8933,
	0x893c,
	0x893e,
	0x8941,
	0x8952,
	0x8937,
	0x8942,
	0x89ad,
	0x89af,
	0x89ae,
	0x89f2,
	0x89f3,
	0x8b1e
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_150[]=
	{
	0x8b18,
	0x8b16,
	0x8b11,
	0x8b05,
	0x8b0b,
	0x8b22,
	0x8b0f,
	0x8b12,
	0x8b15,
	0x8b07,
	0x8b0d,
	0x8b08,
	0x8b06,
	0x8b1c,
	0x8b13,
	0x8b1a,
	0x8c4f,
	0x8c70,
	0x8c72,
	0x8c71,
	0x8c6f,
	0x8c95,
	0x8c94,
	0x8cf9,
	0x8d6f,
	0x8e4e,
	0x8e4d,
	0x8e53,
	0x8e50,
	0x8e4c,
	0x8e47,
	0x8f43,
	0x8f40,
	0x9085,
	0x907e,
	0x9138,
	0x919a,
	0x91a2,
	0x919b,
	0x9199,
	0x919f,
	0x91a1,
	0x919d,
	0x91a0,
	0x93a1,
	0x9383,
	0x93af,
	0x9364,
	0x9356,
	0x9347,
	0x937c,
	0x9358,
	0x935c,
	0x9376,
	0x9349,
	0x9350,
	0x9351,
	0x9360,
	0x936d,
	0x938f,
	0x934c,
	0x936a,
	0x9379,
	0x9357,
	0x9355,
	0x9352,
	0x934f,
	0x9371,
	0x9377,
	0x937b,
	0x9361,
	0x935e,
	0x9363,
	0x9367,
	0x9380,
	0x934e,
	0x9359,
	0x95c7,
	0x95c0,
	0x95c9,
	0x95c3,
	0x95c5,
	0x95b7,
	0x96ae,
	0x96b0,
	0x96ac,
	0x9720,
	0x971f,
	0x9718,
	0x971d,
	0x9719,
	0x979a,
	0x97a1,
	0x979c
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_151[]=
	{
	0x979e,
	0x979d,
	0x97d5,
	0x97d4,
	0x97f1,
	0x9841,
	0x9844,
	0x984a,
	0x9849,
	0x9845,
	0x9843,
	0x9925,
	0x992b,
	0x992c,
	0x992a,
	0x9933,
	0x9932,
	0x992f,
	0x992d,
	0x9931,
	0x9930,
	0x9998,
	0x99a3,
	0x99a1,
	0x9a02,
	0x99fa,
	0x99f4,
	0x99f7,
	0x99f9,
	0x99f8,
	0x99f6,
	0x99fb,
	0x99fd,
	0x99fe,
	0x99fc,
	0x9a03,
	0x9abe,
	0x9afe,
	0x9afd,
	0x9b01,
	0x9afc,
	0x9b48,
	0x9b9a,
	0x9ba8,
	0x9b9e,
	0x9b9b,
	0x9ba6,
	0x9ba1,
	0x9ba5,
	0x9ba4,
	0x9b86,
	0x9ba2,
	0x9ba0,
	0x9baf,
	0x9d33,
	0x9d41,
	0x9d67,
	0x9d36,
	0x9d2e,
	0x9d2f,
	0x9d31,
	0x9d38,
	0x9d30
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_152[]=
	{
	0x9d45,
	0x9d42,
	0x9d43,
	0x9d3e,
	0x9d37,
	0x9d40,
	0x9d3d,
	0x7ff5,
	0x9d2d,
	0x9e8a,
	0x9e89,
	0x9e8d,
	0x9eb0,
	0x9ec8,
	0x9eda,
	0x9efb,
	0x9eff,
	0x9f24,
	0x9f23,
	0x9f22,
	0x9f54,
	0x9fa0,
	0x5131,
	0x512d,
	0x512e,
	0x5698,
	0x569c,
	0x5697,
	0x569a,
	0x569d,
	0x5699,
	0x5970,
	0x5b3c,
	0x5c69,
	0x5c6a,
	0x5dc0,
	0x5e6d,
	0x5e6e,
	0x61d8,
	0x61df,
	0x61ed,
	0x61ee,
	0x61f1,
	0x61ea,
	0x61f0,
	0x61eb,
	0x61d6,
	0x61e9,
	0x64ff,
	0x6504,
	0x64fd,
	0x64f8,
	0x6501,
	0x6503,
	0x64fc,
	0x6594,
	0x65db,
	0x66da,
	0x66db,
	0x66d8,
	0x6ac5,
	0x6ab9,
	0x6abd,
	0x6ae1,
	0x6ac6,
	0x6aba,
	0x6ab6,
	0x6ab7,
	0x6ac7,
	0x6ab4,
	0x6aad,
	0x6b5e,
	0x6bc9,
	0x6c0b,
	0x7007,
	0x700c,
	0x700d,
	0x7001,
	0x7005,
	0x7014,
	0x700e,
	0x6fff,
	0x7000,
	0x6ffb,
	0x7026,
	0x6ffc,
	0x6ff7,
	0x700a,
	0x7201,
	0x71ff,
	0x71f9,
	0x7203,
	0x71fd,
	0x7376
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_153[]=
	{
	0x74b8,
	0x74c0,
	0x74b5,
	0x74c1,
	0x74be,
	0x74b6,
	0x74bb,
	0x74c2,
	0x7514,
	0x7513,
	0x765c,
	0x7664,
	0x7659,
	0x7650,
	0x7653,
	0x7657,
	0x765a,
	0x76a6,
	0x76bd,
	0x76ec,
	0x77c2,
	0x77ba,
	0x78ff,
	0x790c,
	0x7913,
	0x7914,
	0x7909,
	0x7910,
	0x7912,
	0x7911,
	0x79ad,
	0x79ac,
	0x7a5f,
	0x7c1c,
	0x7c29,
	0x7c19,
	0x7c20,
	0x7c1f,
	0x7c2d,
	0x7c1d,
	0x7c26,
	0x7c28,
	0x7c22,
	0x7c25,
	0x7c30,
	0x7e5c,
	0x7e50,
	0x7e56,
	0x7e63,
	0x7e58,
	0x7e62,
	0x7e5f,
	0x7e51,
	0x7e60,
	0x7e57,
	0x7e53,
	0x7fb5,
	0x7fb3,
	0x7ff7,
	0x7ff8,
	0x8075,
	0x81d1,
	0x81d2
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_154[]=
	{
	0x81d0,
	0x825f,
	0x825e,
	0x85b4,
	0x85c6,
	0x85c0,
	0x85c3,
	0x85c2,
	0x85b3,
	0x85b5,
	0x85bd,
	0x85c7,
	0x85c4,
	0x85bf,
	0x85cb,
	0x85ce,
	0x85c8,
	0x85c5,
	0x85b1,
	0x85b6,
	0x85d2,
	0x8624,
	0x85b8,
	0x85b7,
	0x85be,
	0x8669,
	0x87e7,
	0x87e6,
	0x87e2,
	0x87db,
	0x87eb,
	0x87ea,
	0x87e5,
	0x87df,
	0x87f3,
	0x87e4,
	0x87d4,
	0x87dc,
	0x87d3,
	0x87ed,
	0x87d8,
	0x87e3,
	0x87a4,
	0x87d7,
	0x87d9,
	0x8801,
	0x87f4,
	0x87e8,
	0x87dd,
	0x8953,
	0x894b,
	0x894f,
	0x894c,
	0x8946,
	0x8950,
	0x8951,
	0x8949,
	0x8b2a,
	0x8b27,
	0x8b23,
	0x8b33,
	0x8b30,
	0x8b35,
	0x8b47,
	0x8b2f,
	0x8b3c,
	0x8b3e,
	0x8b31,
	0x8b25,
	0x8b37,
	0x8b26,
	0x8b36,
	0x8b2e,
	0x8b24,
	0x8b3b,
	0x8b3d,
	0x8b3a,
	0x8c42,
	0x8c75,
	0x8c99,
	0x8c98,
	0x8c97,
	0x8cfe,
	0x8d04,
	0x8d02,
	0x8d00,
	0x8e5c,
	0x8e62,
	0x8e60,
	0x8e57,
	0x8e56,
	0x8e5e,
	0x8e65,
	0x8e67
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_155[]=
	{
	0x8e5b,
	0x8e5a,
	0x8e61,
	0x8e5d,
	0x8e69,
	0x8e54,
	0x8f46,
	0x8f47,
	0x8f48,
	0x8f4b,
	0x9128,
	0x913a,
	0x913b,
	0x913e,
	0x91a8,
	0x91a5,
	0x91a7,
	0x91af,
	0x91aa,
	0x93b5,
	0x938c,
	0x9392,
	0x93b7,
	0x939b,
	0x939d,
	0x9389,
	0x93a7,
	0x938e,
	0x93aa,
	0x939e,
	0x93a6,
	0x9395,
	0x9388,
	0x9399,
	0x939f,
	0x938d,
	0x93b1,
	0x9391,
	0x93b2,
	0x93a4,
	0x93a8,
	0x93b4,
	0x93a3,
	0x93a5,
	0x95d2,
	0x95d3,
	0x95d1,
	0x96b3,
	0x96d7,
	0x96da,
	0x5dc2,
	0x96df,
	0x96d8,
	0x96dd,
	0x9723,
	0x9722,
	0x9725,
	0x97ac,
	0x97ae,
	0x97a8,
	0x97ab,
	0x97a4,
	0x97aa
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_156[]=
	{
	0x97a2,
	0x97a5,
	0x97d7,
	0x97d9,
	0x97d6,
	0x97d8,
	0x97fa,
	0x9850,
	0x9851,
	0x9852,
	0x98b8,
	0x9941,
	0x993c,
	0x993a,
	0x9a0f,
	0x9a0b,
	0x9a09,
	0x9a0d,
	0x9a04,
	0x9a11,
	0x9a0a,
	0x9a05,
	0x9a07,
	0x9a06,
	0x9ac0,
	0x9adc,
	0x9b08,
	0x9b04,
	0x9b05,
	0x9b29,
	0x9b35,
	0x9b4a,
	0x9b4c,
	0x9b4b,
	0x9bc7,
	0x9bc6,
	0x9bc3,
	0x9bbf,
	0x9bc1,
	0x9bb5,
	0x9bb8,
	0x9bd3,
	0x9bb6,
	0x9bc4,
	0x9bb9,
	0x9bbd,
	0x9d5c,
	0x9d53,
	0x9d4f,
	0x9d4a,
	0x9d5b,
	0x9d4b,
	0x9d59,
	0x9d56,
	0x9d4c,
	0x9d57,
	0x9d52,
	0x9d54,
	0x9d5f,
	0x9d58,
	0x9d5a,
	0x9e8e,
	0x9e8c,
	0x9edf,
	0x9f01,
	0x9f00,
	0x9f16,
	0x9f25,
	0x9f2b,
	0x9f2a,
	0x9f29,
	0x9f28,
	0x9f4c,
	0x9f55,
	0x5134,
	0x5135,
	0x5296,
	0x52f7,
	0x53b4,
	0x56ab,
	0x56ad,
	0x56a6,
	0x56a7,
	0x56aa,
	0x56ac,
	0x58da,
	0x58dd,
	0x58db,
	0x5912,
	0x5b3d,
	0x5b3e,
	0x5b3f,
	0x5dc3,
	0x5e70
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_157[]=
	{
	0x5fbf,
	0x61fb,
	0x6507,
	0x6510,
	0x650d,
	0x6509,
	0x650c,
	0x650e,
	0x6584,
	0x65de,
	0x65dd,
	0x66de,
	0x6ae7,
	0x6ae0,
	0x6acc,
	0x6ad1,
	0x6ad9,
	0x6acb,
	0x6adf,
	0x6adc,
	0x6ad0,
	0x6aeb,
	0x6acf,
	0x6acd,
	0x6ade,
	0x6b60,
	0x6bb0,
	0x6c0c,
	0x7019,
	0x7027,
	0x7020,
	0x7016,
	0x702b,
	0x7021,
	0x7022,
	0x7023,
	0x7029,
	0x7017,
	0x7024,
	0x701c,
	0x702a,
	0x720c,
	0x720a,
	0x7207,
	0x7202,
	0x7205,
	0x72a5,
	0x72a6,
	0x72a4,
	0x72a3,
	0x72a1,
	0x74cb,
	0x74c5,
	0x74b7,
	0x74c3,
	0x7516,
	0x7660,
	0x77c9,
	0x77ca,
	0x77c4,
	0x77f1,
	0x791d,
	0x791b
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_158[]=
	{
	0x7921,
	0x791c,
	0x7917,
	0x791e,
	0x79b0,
	0x7a67,
	0x7a68,
	0x7c33,
	0x7c3c,
	0x7c39,
	0x7c2c,
	0x7c3b,
	0x7cec,
	0x7cea,
	0x7e76,
	0x7e75,
	0x7e78,
	0x7e70,
	0x7e77,
	0x7e6f,
	0x7e7a,
	0x7e72,
	0x7e74,
	0x7e68,
	0x7f4b,
	0x7f4a,
	0x7f83,
	0x7f86,
	0x7fb7,
	0x7ffd,
	0x7ffe,
	0x8078,
	0x81d7,
	0x81d5,
	0x8264,
	0x8261,
	0x8263,
	0x85eb,
	0x85f1,
	0x85ed,
	0x85d9,
	0x85e1,
	0x85e8,
	0x85da,
	0x85d7,
	0x85ec,
	0x85f2,
	0x85f8,
	0x85d8,
	0x85df,
	0x85e3,
	0x85dc,
	0x85d1,
	0x85f0,
	0x85e6,
	0x85ef,
	0x85de,
	0x85e2,
	0x8800,
	0x87fa,
	0x8803,
	0x87f6,
	0x87f7,
	0x8809,
	0x880c,
	0x880b,
	0x8806,
	0x87fc,
	0x8808,
	0x87ff,
	0x880a,
	0x8802,
	0x8962,
	0x895a,
	0x895b,
	0x8957,
	0x8961,
	0x895c,
	0x8958,
	0x895d,
	0x8959,
	0x8988,
	0x89b7,
	0x89b6,
	0x89f6,
	0x8b50,
	0x8b48,
	0x8b4a,
	0x8b40,
	0x8b53,
	0x8b56,
	0x8b54,
	0x8b4b,
	0x8b55
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_159[]=
	{
	0x8b51,
	0x8b42,
	0x8b52,
	0x8b57,
	0x8c43,
	0x8c77,
	0x8c76,
	0x8c9a,
	0x8d06,
	0x8d07,
	0x8d09,
	0x8dac,
	0x8daa,
	0x8dad,
	0x8dab,
	0x8e6d,
	0x8e78,
	0x8e73,
	0x8e6a,
	0x8e6f,
	0x8e7b,
	0x8ec2,
	0x8f52,
	0x8f51,
	0x8f4f,
	0x8f50,
	0x8f53,
	0x8fb4,
	0x9140,
	0x913f,
	0x91b0,
	0x91ad,
	0x93de,
	0x93c7,
	0x93cf,
	0x93c2,
	0x93da,
	0x93d0,
	0x93f9,
	0x93ec,
	0x93cc,
	0x93d9,
	0x93a9,
	0x93e6,
	0x93ca,
	0x93d4,
	0x93ee,
	0x93e3,
	0x93d5,
	0x93c4,
	0x93ce,
	0x93c0,
	0x93d2,
	0x93e7,
	0x957d,
	0x95da,
	0x95db,
	0x96e1,
	0x9729,
	0x972b,
	0x972c,
	0x9728,
	0x9726
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_160[]=
	{
	0x97b3,
	0x97b7,
	0x97b6,
	0x97dd,
	0x97de,
	0x97df,
	0x985c,
	0x9859,
	0x985d,
	0x9857,
	0x98bf,
	0x98bd,
	0x98bb,
	0x98be,
	0x9948,
	0x9947,
	0x9943,
	0x99a6,
	0x99a7,
	0x9a1a,
	0x9a15,
	0x9a25,
	0x9a1d,
	0x9a24,
	0x9a1b,
	0x9a22,
	0x9a20,
	0x9a27,
	0x9a23,
	0x9a1e,
	0x9a1c,
	0x9a14,
	0x9ac2,
	0x9b0b,
	0x9b0a,
	0x9b0e,
	0x9b0c,
	0x9b37,
	0x9bea,
	0x9beb,
	0x9be0,
	0x9bde,
	0x9be4,
	0x9be6,
	0x9be2,
	0x9bf0,
	0x9bd4,
	0x9bd7,
	0x9bec,
	0x9bdc,
	0x9bd9,
	0x9be5,
	0x9bd5,
	0x9be1,
	0x9bda,
	0x9d77,
	0x9d81,
	0x9d8a,
	0x9d84,
	0x9d88,
	0x9d71,
	0x9d80,
	0x9d78,
	0x9d86,
	0x9d8b,
	0x9d8c,
	0x9d7d,
	0x9d6b,
	0x9d74,
	0x9d75,
	0x9d70,
	0x9d69,
	0x9d85,
	0x9d73,
	0x9d7b,
	0x9d82,
	0x9d6f,
	0x9d79,
	0x9d7f,
	0x9d87,
	0x9d68,
	0x9e94,
	0x9e91,
	0x9ec0,
	0x9efc,
	0x9f2d,
	0x9f40,
	0x9f41,
	0x9f4d,
	0x9f56,
	0x9f57,
	0x9f58,
	0x5337,
	0x56b2
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_161[]=
	{
	0x56b5,
	0x56b3,
	0x58e3,
	0x5b45,
	0x5dc6,
	0x5dc7,
	0x5eee,
	0x5eef,
	0x5fc0,
	0x5fc1,
	0x61f9,
	0x6517,
	0x6516,
	0x6515,
	0x6513,
	0x65df,
	0x66e8,
	0x66e3,
	0x66e4,
	0x6af3,
	0x6af0,
	0x6aea,
	0x6ae8,
	0x6af9,
	0x6af1,
	0x6aee,
	0x6aef,
	0x703c,
	0x7035,
	0x702f,
	0x7037,
	0x7034,
	0x7031,
	0x7042,
	0x7038,
	0x703f,
	0x703a,
	0x7039,
	0x7040,
	0x703b,
	0x7033,
	0x7041,
	0x7213,
	0x7214,
	0x72a8,
	0x737d,
	0x737c,
	0x74ba,
	0x76ab,
	0x76aa,
	0x76be,
	0x76ed,
	0x77cc,
	0x77ce,
	0x77cf,
	0x77cd,
	0x77f2,
	0x7925,
	0x7923,
	0x7927,
	0x7928,
	0x7924,
	0x7929
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_162[]=
	{
	0x79b2,
	0x7a6e,
	0x7a6c,
	0x7a6d,
	0x7af7,
	0x7c49,
	0x7c48,
	0x7c4a,
	0x7c47,
	0x7c45,
	0x7cee,
	0x7e7b,
	0x7e7e,
	0x7e81,
	0x7e80,
	0x7fba,
	0x7fff,
	0x8079,
	0x81db,
	0x81d9,
	0x820b,
	0x8268,
	0x8269,
	0x8622,
	0x85ff,
	0x8601,
	0x85fe,
	0x861b,
	0x8600,
	0x85f6,
	0x8604,
	0x8609,
	0x8605,
	0x860c,
	0x85fd,
	0x8819,
	0x8810,
	0x8811,
	0x8817,
	0x8813,
	0x8816,
	0x8963,
	0x8966,
	0x89b9,
	0x89f7,
	0x8b60,
	0x8b6a,
	0x8b5d,
	0x8b68,
	0x8b63,
	0x8b65,
	0x8b67,
	0x8b6d,
	0x8dae,
	0x8e86,
	0x8e88,
	0x8e84,
	0x8f59,
	0x8f56,
	0x8f57,
	0x8f55,
	0x8f58,
	0x8f5a,
	0x908d,
	0x9143,
	0x9141,
	0x91b7,
	0x91b5,
	0x91b2,
	0x91b3,
	0x940b,
	0x9413,
	0x93fb,
	0x9420,
	0x940f,
	0x9414,
	0x93fe,
	0x9415,
	0x9410,
	0x9428,
	0x9419,
	0x940d,
	0x93f5,
	0x9400,
	0x93f7,
	0x9407,
	0x940e,
	0x9416,
	0x9412,
	0x93fa,
	0x9409,
	0x93f8,
	0x940a,
	0x93ff
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_163[]=
	{
	0x93fc,
	0x940c,
	0x93f6,
	0x9411,
	0x9406,
	0x95de,
	0x95e0,
	0x95df,
	0x972e,
	0x972f,
	0x97b9,
	0x97bb,
	0x97fd,
	0x97fe,
	0x9860,
	0x9862,
	0x9863,
	0x985f,
	0x98c1,
	0x98c2,
	0x9950,
	0x994e,
	0x9959,
	0x994c,
	0x994b,
	0x9953,
	0x9a32,
	0x9a34,
	0x9a31,
	0x9a2c,
	0x9a2a,
	0x9a36,
	0x9a29,
	0x9a2e,
	0x9a38,
	0x9a2d,
	0x9ac7,
	0x9aca,
	0x9ac6,
	0x9b10,
	0x9b12,
	0x9b11,
	0x9c0b,
	0x9c08,
	0x9bf7,
	0x9c05,
	0x9c12,
	0x9bf8,
	0x9c40,
	0x9c07,
	0x9c0e,
	0x9c06,
	0x9c17,
	0x9c14,
	0x9c09,
	0x9d9f,
	0x9d99,
	0x9da4,
	0x9d9d,
	0x9d92,
	0x9d98,
	0x9d90,
	0x9d9b
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_164[]=
	{
	0x9da0,
	0x9d94,
	0x9d9c,
	0x9daa,
	0x9d97,
	0x9da1,
	0x9d9a,
	0x9da2,
	0x9da8,
	0x9d9e,
	0x9da3,
	0x9dbf,
	0x9da9,
	0x9d96,
	0x9da6,
	0x9da7,
	0x9e99,
	0x9e9b,
	0x9e9a,
	0x9ee5,
	0x9ee4,
	0x9ee7,
	0x9ee6,
	0x9f30,
	0x9f2e,
	0x9f5b,
	0x9f60,
	0x9f5e,
	0x9f5d,
	0x9f59,
	0x9f91,
	0x513a,
	0x5139,
	0x5298,
	0x5297,
	0x56c3,
	0x56bd,
	0x56be,
	0x5b48,
	0x5b47,
	0x5dcb,
	0x5dcf,
	0x5ef1,
	0x61fd,
	0x651b,
	0x6b02,
	0x6afc,
	0x6b03,
	0x6af8,
	0x6b00,
	0x7043,
	0x7044,
	0x704a,
	0x7048,
	0x7049,
	0x7045,
	0x7046,
	0x721d,
	0x721a,
	0x7219,
	0x737e,
	0x7517,
	0x766a,
	0x77d0,
	0x792d,
	0x7931,
	0x792f,
	0x7c54,
	0x7c53,
	0x7cf2,
	0x7e8a,
	0x7e87,
	0x7e88,
	0x7e8b,
	0x7e86,
	0x7e8d,
	0x7f4d,
	0x7fbb,
	0x8030,
	0x81dd,
	0x8618,
	0x862a,
	0x8626,
	0x861f,
	0x8623,
	0x861c,
	0x8619,
	0x8627,
	0x862e,
	0x8621,
	0x8620,
	0x8629,
	0x861e,
	0x8625
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_165[]=
	{
	0x8829,
	0x881d,
	0x881b,
	0x8820,
	0x8824,
	0x881c,
	0x882b,
	0x884a,
	0x896d,
	0x8969,
	0x896e,
	0x896b,
	0x89fa,
	0x8b79,
	0x8b78,
	0x8b45,
	0x8b7a,
	0x8b7b,
	0x8d10,
	0x8d14,
	0x8daf,
	0x8e8e,
	0x8e8c,
	0x8f5e,
	0x8f5b,
	0x8f5d,
	0x9146,
	0x9144,
	0x9145,
	0x91b9,
	0x943f,
	0x943b,
	0x9436,
	0x9429,
	0x943d,
	0x943c,
	0x9430,
	0x9439,
	0x942a,
	0x9437,
	0x942c,
	0x9440,
	0x9431,
	0x95e5,
	0x95e4,
	0x95e3,
	0x9735,
	0x973a,
	0x97bf,
	0x97e1,
	0x9864,
	0x98c9,
	0x98c6,
	0x98c0,
	0x9958,
	0x9956,
	0x9a39,
	0x9a3d,
	0x9a46,
	0x9a44,
	0x9a42,
	0x9a41,
	0x9a3a
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_166[]=
	{
	0x9a3f,
	0x9acd,
	0x9b15,
	0x9b17,
	0x9b18,
	0x9b16,
	0x9b3a,
	0x9b52,
	0x9c2b,
	0x9c1d,
	0x9c1c,
	0x9c2c,
	0x9c23,
	0x9c28,
	0x9c29,
	0x9c24,
	0x9c21,
	0x9db7,
	0x9db6,
	0x9dbc,
	0x9dc1,
	0x9dc7,
	0x9dca,
	0x9dcf,
	0x9dbe,
	0x9dc5,
	0x9dc3,
	0x9dbb,
	0x9db5,
	0x9dce,
	0x9db9,
	0x9dba,
	0x9dac,
	0x9dc8,
	0x9db1,
	0x9dad,
	0x9dcc,
	0x9db3,
	0x9dcd,
	0x9db2,
	0x9e7a,
	0x9e9c,
	0x9eeb,
	0x9eee,
	0x9eed,
	0x9f1b,
	0x9f18,
	0x9f1a,
	0x9f31,
	0x9f4e,
	0x9f65,
	0x9f64,
	0x9f92,
	0x4eb9,
	0x56c6,
	0x56c5,
	0x56cb,
	0x5971,
	0x5b4b,
	0x5b4c,
	0x5dd5,
	0x5dd1,
	0x5ef2,
	0x6521,
	0x6520,
	0x6526,
	0x6522,
	0x6b0b,
	0x6b08,
	0x6b09,
	0x6c0d,
	0x7055,
	0x7056,
	0x7057,
	0x7052,
	0x721e,
	0x721f,
	0x72a9,
	0x737f,
	0x74d8,
	0x74d5,
	0x74d9,
	0x74d7,
	0x766d,
	0x76ad,
	0x7935,
	0x79b4,
	0x7a70,
	0x7a71,
	0x7c57,
	0x7c5c,
	0x7c59,
	0x7c5b,
	0x7c5a
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_167[]=
	{
	0x7cf4,
	0x7cf1,
	0x7e91,
	0x7f4f,
	0x7f87,
	0x81de,
	0x826b,
	0x8634,
	0x8635,
	0x8633,
	0x862c,
	0x8632,
	0x8636,
	0x882c,
	0x8828,
	0x8826,
	0x882a,
	0x8825,
	0x8971,
	0x89bf,
	0x89be,
	0x89fb,
	0x8b7e,
	0x8b84,
	0x8b82,
	0x8b86,
	0x8b85,
	0x8b7f,
	0x8d15,
	0x8e95,
	0x8e94,
	0x8e9a,
	0x8e92,
	0x8e90,
	0x8e96,
	0x8e97,
	0x8f60,
	0x8f62,
	0x9147,
	0x944c,
	0x9450,
	0x944a,
	0x944b,
	0x944f,
	0x9447,
	0x9445,
	0x9448,
	0x9449,
	0x9446,
	0x973f,
	0x97e3,
	0x986a,
	0x9869,
	0x98cb,
	0x9954,
	0x995b,
	0x9a4e,
	0x9a53,
	0x9a54,
	0x9a4c,
	0x9a4f,
	0x9a48,
	0x9a4a
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_168[]=
	{
	0x9a49,
	0x9a52,
	0x9a50,
	0x9ad0,
	0x9b19,
	0x9b2b,
	0x9b3b,
	0x9b56,
	0x9b55,
	0x9c46,
	0x9c48,
	0x9c3f,
	0x9c44,
	0x9c39,
	0x9c33,
	0x9c41,
	0x9c3c,
	0x9c37,
	0x9c34,
	0x9c32,
	0x9c3d,
	0x9c36,
	0x9ddb,
	0x9dd2,
	0x9dde,
	0x9dda,
	0x9dcb,
	0x9dd0,
	0x9ddc,
	0x9dd1,
	0x9ddf,
	0x9de9,
	0x9dd9,
	0x9dd8,
	0x9dd6,
	0x9df5,
	0x9dd5,
	0x9ddd,
	0x9eb6,
	0x9ef0,
	0x9f35,
	0x9f33,
	0x9f32,
	0x9f42,
	0x9f6b,
	0x9f95,
	0x9fa2,
	0x513d,
	0x5299,
	0x58e8,
	0x58e7,
	0x5972,
	0x5b4d,
	0x5dd8,
	0x882f,
	0x5f4f,
	0x6201,
	0x6203,
	0x6204,
	0x6529,
	0x6525,
	0x6596,
	0x66eb,
	0x6b11,
	0x6b12,
	0x6b0f,
	0x6bca,
	0x705b,
	0x705a,
	0x7222,
	0x7382,
	0x7381,
	0x7383,
	0x7670,
	0x77d4,
	0x7c67,
	0x7c66,
	0x7e95,
	0x826c,
	0x863a,
	0x8640,
	0x8639,
	0x863c,
	0x8631,
	0x863b,
	0x863e,
	0x8830,
	0x8832,
	0x882e,
	0x8833,
	0x8976,
	0x8974,
	0x8973,
	0x89fe
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_169[]=
	{
	0x8b8c,
	0x8b8e,
	0x8b8b,
	0x8b88,
	0x8c45,
	0x8d19,
	0x8e98,
	0x8f64,
	0x8f63,
	0x91bc,
	0x9462,
	0x9455,
	0x945d,
	0x9457,
	0x945e,
	0x97c4,
	0x97c5,
	0x9800,
	0x9a56,
	0x9a59,
	0x9b1e,
	0x9b1f,
	0x9b20,
	0x9c52,
	0x9c58,
	0x9c50,
	0x9c4a,
	0x9c4d,
	0x9c4b,
	0x9c55,
	0x9c59,
	0x9c4c,
	0x9c4e,
	0x9dfb,
	0x9df7,
	0x9def,
	0x9de3,
	0x9deb,
	0x9df8,
	0x9de4,
	0x9df6,
	0x9de1,
	0x9dee,
	0x9de6,
	0x9df2,
	0x9df0,
	0x9de2,
	0x9dec,
	0x9df4,
	0x9df3,
	0x9de8,
	0x9ded,
	0x9ec2,
	0x9ed0,
	0x9ef2,
	0x9ef3,
	0x9f06,
	0x9f1c,
	0x9f38,
	0x9f37,
	0x9f36,
	0x9f43,
	0x9f4f
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_170[]=
	{
	0x9f71,
	0x9f70,
	0x9f6e,
	0x9f6f,
	0x56d3,
	0x56cd,
	0x5b4e,
	0x5c6d,
	0x652d,
	0x66ed,
	0x66ee,
	0x6b13,
	0x705f,
	0x7061,
	0x705d,
	0x7060,
	0x7223,
	0x74db,
	0x74e5,
	0x77d5,
	0x7938,
	0x79b7,
	0x79b6,
	0x7c6a,
	0x7e97,
	0x7f89,
	0x826d,
	0x8643,
	0x8838,
	0x8837,
	0x8835,
	0x884b,
	0x8b94,
	0x8b95,
	0x8e9e,
	0x8e9f,
	0x8ea0,
	0x8e9d,
	0x91be,
	0x91bd,
	0x91c2,
	0x946b,
	0x9468,
	0x9469,
	0x96e5,
	0x9746,
	0x9743,
	0x9747,
	0x97c7,
	0x97e5,
	0x9a5e,
	0x9ad5,
	0x9b59,
	0x9c63,
	0x9c67,
	0x9c66,
	0x9c62,
	0x9c5e,
	0x9c60,
	0x9e02,
	0x9dfe,
	0x9e07,
	0x9e03,
	0x9e06,
	0x9e05,
	0x9e00,
	0x9e01,
	0x9e09,
	0x9dff,
	0x9dfd,
	0x9e04,
	0x9ea0,
	0x9f1e,
	0x9f46,
	0x9f74,
	0x9f75,
	0x9f76,
	0x56d4,
	0x652e,
	0x65b8,
	0x6b18,
	0x6b19,
	0x6b17,
	0x6b1a,
	0x7062,
	0x7226,
	0x72aa,
	0x77d8,
	0x77d9,
	0x7939,
	0x7c69,
	0x7c6b,
	0x7cf6,
	0x7e9a
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_171[]=
	{
	0x7e98,
	0x7e9b,
	0x7e99,
	0x81e0,
	0x81e1,
	0x8646,
	0x8647,
	0x8648,
	0x8979,
	0x897a,
	0x897c,
	0x897b,
	0x89ff,
	0x8b98,
	0x8b99,
	0x8ea5,
	0x8ea4,
	0x8ea3,
	0x946e,
	0x946d,
	0x946f,
	0x9471,
	0x9473,
	0x9749,
	0x9872,
	0x995f,
	0x9c68,
	0x9c6e,
	0x9c6d,
	0x9e0b,
	0x9e0d,
	0x9e10,
	0x9e0f,
	0x9e12,
	0x9e11,
	0x9ea1,
	0x9ef5,
	0x9f09,
	0x9f47,
	0x9f78,
	0x9f7b,
	0x9f7a,
	0x9f79,
	0x571e,
	0x7066,
	0x7c6f,
	0x883c,
	0x8db2,
	0x8ea6,
	0x91c3,
	0x9474,
	0x9478,
	0x9476,
	0x9475,
	0x9a60,
	0x9c74,
	0x9c73,
	0x9c71,
	0x9c75,
	0x9e14,
	0x9e13,
	0x9ef6,
	0x9f0a
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_172[]=
	{
	0x9fa4,
	0x7068,
	0x7065,
	0x7cf7,
	0x866a,
	0x883e,
	0x883d,
	0x883f,
	0x8b9e,
	0x8c9c,
	0x8ea9,
	0x8ec9,
	0x974b,
	0x9873,
	0x9874,
	0x98cc,
	0x9961,
	0x99ab,
	0x9a64,
	0x9a66,
	0x9a67,
	0x9b24,
	0x9e15,
	0x9e17,
	0x9f48,
	0x6207,
	0x6b1e,
	0x7227,
	0x864c,
	0x8ea8,
	0x9482,
	0x9480,
	0x9481,
	0x9a69,
	0x9a68,
	0x9b2e,
	0x9e19,
	0x7229,
	0x864b,
	0x8b9f,
	0x9483,
	0x9c79,
	0x9eb7,
	0x7675,
	0x9a6b,
	0x9c7a,
	0x9e1d,
	0x7069,
	0x706a,
	0x9ea4,
	0x9f7e,
	0x9f49,
	0x9f98
	};

LOCAL_D const SCnvConversionData::SOneDirectionData::SRange::UData::SKeyedTable16OfIndexedTables16::SKeyedEntry keyedTables16OfIndexedTables16_keyedEntries_foreignToUnicode_1[]=
	{
		{
		0xa140,
		0xa17e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_1
		},
		{
		0xa1a1,
		0xa1c2,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_2
		},
		{
		0xa1c6,
		0xa1fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_3
		},
		{
		0xa240,
		0xa27e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_4
		},
		{
		0xa2a1,
		0xa2ae,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_5
		},
		{
		0xa440,
		0xa47e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_6
		},
		{
		0xa4a1,
		0xa4fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_7
		},
		{
		0xa540,
		0xa57e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_8
		},
		{
		0xa5a1,
		0xa5fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_9
		},
		{
		0xa640,
		0xa67e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_10
		},
		{
		0xa6a1,
		0xa6fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_11
		},
		{
		0xa740,
		0xa77e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_12
		},
		{
		0xa7a1,
		0xa7fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_13
		},
		{
		0xa840,
		0xa87e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_14
		},
		{
		0xa8a1,
		0xa8fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_15
		},
		{
		0xa940,
		0xa97e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_16
		},
		{
		0xa9a1,
		0xa9fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_17
		},
		{
		0xaa40,
		0xaa7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_18
		},
		{
		0xaaa1,
		0xaafe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_19
		},
		{
		0xab40,
		0xab7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_20
		},
		{
		0xaba1,
		0xabfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_21
		},
		{
		0xac40,
		0xac7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_22
		},
		{
		0xaca1,
		0xacfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_23
		},
		{
		0xad40,
		0xad7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_24
		},
		{
		0xada1,
		0xadfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_25
		},
		{
		0xae40,
		0xae7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_26
		},
		{
		0xaea1,
		0xaefe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_27
		},
		{
		0xaf40,
		0xaf7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_28
		},
		{
		0xafa1,
		0xaffe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_29
		},
		{
		0xb040,
		0xb07e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_30
		},
		{
		0xb0a1,
		0xb0fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_31
		},
		{
		0xb140,
		0xb17e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_32
		},
		{
		0xb1a1,
		0xb1fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_33
		},
		{
		0xb240,
		0xb27e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_34
		},
		{
		0xb2a1,
		0xb2fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_35
		},
		{
		0xb340,
		0xb37e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_36
		},
		{
		0xb3a1,
		0xb3fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_37
		},
		{
		0xb440,
		0xb47e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_38
		},
		{
		0xb4a1,
		0xb4fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_39
		},
		{
		0xb540,
		0xb57e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_40
		},
		{
		0xb5a1,
		0xb5fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_41
		},
		{
		0xb640,
		0xb67e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_42
		},
		{
		0xb6a1,
		0xb6fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_43
		},
		{
		0xb740,
		0xb77e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_44
		},
		{
		0xb7a1,
		0xb7fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_45
		},
		{
		0xb840,
		0xb87e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_46
		},
		{
		0xb8a1,
		0xb8fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_47
		},
		{
		0xb940,
		0xb97e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_48
		},
		{
		0xb9a1,
		0xb9fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_49
		},
		{
		0xba40,
		0xba7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_50
		},
		{
		0xbaa1,
		0xbafe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_51
		},
		{
		0xbb40,
		0xbb7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_52
		},
		{
		0xbba1,
		0xbbfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_53
		},
		{
		0xbc40,
		0xbc7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_54
		},
		{
		0xbca1,
		0xbcfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_55
		},
		{
		0xbd40,
		0xbd7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_56
		},
		{
		0xbda1,
		0xbdfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_57
		},
		{
		0xbe40,
		0xbe7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_58
		},
		{
		0xbea1,
		0xbefe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_59
		},
		{
		0xbf40,
		0xbf7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_60
		},
		{
		0xbfa1,
		0xbffe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_61
		},
		{
		0xc040,
		0xc07e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_62
		},
		{
		0xc0a1,
		0xc0fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_63
		},
		{
		0xc140,
		0xc17e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_64
		},
		{
		0xc1a1,
		0xc1fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_65
		},
		{
		0xc240,
		0xc27e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_66
		},
		{
		0xc2a1,
		0xc2fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_67
		},
		{
		0xc340,
		0xc37e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_68
		},
		{
		0xc3a1,
		0xc3fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_69
		},
		{
		0xc440,
		0xc47e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_70
		},
		{
		0xc4a1,
		0xc4fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_71
		},
		{
		0xc540,
		0xc57e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_72
		},
		{
		0xc5a1,
		0xc5fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_73
		},
		{
		0xc640,
		0xc67e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_74
		},
		{
		0xc940,
		0xc97e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_75
		},
		{
		0xc9a1,
		0xc9fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_76
		},
		{
		0xca40,
		0xca7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_77
		},
		{
		0xcaa1,
		0xcafe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_78
		},
		{
		0xcb40,
		0xcb7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_79
		},
		{
		0xcba1,
		0xcbfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_80
		},
		{
		0xcc40,
		0xcc7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_81
		},
		{
		0xcca1,
		0xccfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_82
		},
		{
		0xcd40,
		0xcd7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_83
		},
		{
		0xcda1,
		0xcdfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_84
		},
		{
		0xce40,
		0xce7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_85
		},
		{
		0xcea1,
		0xcefe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_86
		},
		{
		0xcf40,
		0xcf7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_87
		},
		{
		0xcfa1,
		0xcffe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_88
		},
		{
		0xd040,
		0xd07e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_89
		},
		{
		0xd0a1,
		0xd0fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_90
		},
		{
		0xd140,
		0xd17e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_91
		},
		{
		0xd1a1,
		0xd1fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_92
		},
		{
		0xd240,
		0xd27e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_93
		},
		{
		0xd2a1,
		0xd2fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_94
		},
		{
		0xd340,
		0xd37e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_95
		},
		{
		0xd3a1,
		0xd3fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_96
		},
		{
		0xd440,
		0xd47e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_97
		},
		{
		0xd4a1,
		0xd4fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_98
		},
		{
		0xd540,
		0xd57e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_99
		},
		{
		0xd5a1,
		0xd5fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_100
		},
		{
		0xd640,
		0xd67e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_101
		},
		{
		0xd6a1,
		0xd6fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_102
		},
		{
		0xd740,
		0xd77e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_103
		},
		{
		0xd7a1,
		0xd7fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_104
		},
		{
		0xd840,
		0xd87e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_105
		},
		{
		0xd8a1,
		0xd8fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_106
		},
		{
		0xd940,
		0xd97e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_107
		},
		{
		0xd9a1,
		0xd9fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_108
		},
		{
		0xda40,
		0xda7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_109
		},
		{
		0xdaa1,
		0xdafe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_110
		},
		{
		0xdb40,
		0xdb7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_111
		},
		{
		0xdba1,
		0xdbfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_112
		},
		{
		0xdc40,
		0xdc7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_113
		},
		{
		0xdca1,
		0xdcfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_114
		},
		{
		0xdd40,
		0xdd7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_115
		},
		{
		0xdda1,
		0xddfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_116
		},
		{
		0xde40,
		0xde7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_117
		},
		{
		0xdea1,
		0xdefe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_118
		},
		{
		0xdf40,
		0xdf7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_119
		},
		{
		0xdfa1,
		0xdffe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_120
		},
		{
		0xe040,
		0xe07e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_121
		},
		{
		0xe0a1,
		0xe0fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_122
		},
		{
		0xe140,
		0xe17e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_123
		},
		{
		0xe1a1,
		0xe1fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_124
		},
		{
		0xe240,
		0xe27e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_125
		},
		{
		0xe2a1,
		0xe2fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_126
		},
		{
		0xe340,
		0xe37e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_127
		},
		{
		0xe3a1,
		0xe3fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_128
		},
		{
		0xe440,
		0xe47e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_129
		},
		{
		0xe4a1,
		0xe4fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_130
		},
		{
		0xe540,
		0xe57e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_131
		},
		{
		0xe5a1,
		0xe5fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_132
		},
		{
		0xe640,
		0xe67e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_133
		},
		{
		0xe6a1,
		0xe6fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_134
		},
		{
		0xe740,
		0xe77e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_135
		},
		{
		0xe7a1,
		0xe7fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_136
		},
		{
		0xe840,
		0xe87e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_137
		},
		{
		0xe8a1,
		0xe8fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_138
		},
		{
		0xe940,
		0xe97e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_139
		},
		{
		0xe9a1,
		0xe9fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_140
		},
		{
		0xea40,
		0xea7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_141
		},
		{
		0xeaa1,
		0xeafe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_142
		},
		{
		0xeb40,
		0xeb7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_143
		},
		{
		0xeba1,
		0xebfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_144
		},
		{
		0xec40,
		0xec7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_145
		},
		{
		0xeca1,
		0xecfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_146
		},
		{
		0xed40,
		0xed7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_147
		},
		{
		0xeda1,
		0xedfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_148
		},
		{
		0xee40,
		0xee7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_149
		},
		{
		0xeea1,
		0xeefe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_150
		},
		{
		0xef40,
		0xef7e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_151
		},
		{
		0xefa1,
		0xeffe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_152
		},
		{
		0xf040,
		0xf07e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_153
		},
		{
		0xf0a1,
		0xf0fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_154
		},
		{
		0xf140,
		0xf17e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_155
		},
		{
		0xf1a1,
		0xf1fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_156
		},
		{
		0xf240,
		0xf27e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_157
		},
		{
		0xf2a1,
		0xf2fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_158
		},
		{
		0xf340,
		0xf37e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_159
		},
		{
		0xf3a1,
		0xf3fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_160
		},
		{
		0xf440,
		0xf47e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_161
		},
		{
		0xf4a1,
		0xf4fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_162
		},
		{
		0xf540,
		0xf57e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_163
		},
		{
		0xf5a1,
		0xf5fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_164
		},
		{
		0xf640,
		0xf67e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_165
		},
		{
		0xf6a1,
		0xf6fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_166
		},
		{
		0xf740,
		0xf77e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_167
		},
		{
		0xf7a1,
		0xf7fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_168
		},
		{
		0xf840,
		0xf87e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_169
		},
		{
		0xf8a1,
		0xf8fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_170
		},
		{
		0xf940,
		0xf97e,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_171
		},
		{
		0xf9a1,
		0xf9d5,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_172
		}
	};

LOCAL_D const SCnvConversionData::SOneDirectionData::SRange::UData::SKeyedTable1616::SEntry keyedTable1616_unicodeToForeign_1[]=
	{
		{
		0x00a2,
		0xa246
		},
		{
		0x00a3,
		0xa247
		},
		{
		0x00a5,
		0xa244
		},
		{
		0x00a7,
		0xa1b1
		},
		{
		0x00b0,
		0xa258
		},
		{
		0x00b1,
		0xa1d3
		},
		{
		0x00b7,
		0xa150
		},
		{
		0x00d7,
		0xa1d1
		},
		{
		0x00f7,
		0xa1d2
		},
		{
		0x02c7,
		0xa3be
		},
		{
		0x02c9,
		0xa3bc
		},
		{
		0x02ca,
		0xa3bd
		},
		{
		0x02cb,
		0xa3bf
		},
		{
		0x02d9,
		0xa3bb
		},
		{
		0x0401,
		0xc7b3
		},
		{
		0x0414,
		0xc7b1
		},
		{
		0x0415,
		0xc7b2
		},
		{
		0x0451,
		0xc7ce
		},
		{
		0x2013,
		0xa156
		},
		{
		0x2014,
		0xa158
		},
		{
		0x2018,
		0xa1a5
		},
		{
		0x2019,
		0xa1a6
		},
		{
		0x201c,
		0xa1a7
		},
		{
		0x201d,
		0xa1a8
		},
		{
		0x2022,
		0xa145
		},
		{
		0x2025,
		0xa14c
		},
		{
		0x2026,
		0xa14b
		},
		{
		0x2032,
		0xa1ac
		},
		{
		0x2035,
		0xa1ab
		},
		{
		0x203b,
		0xa1b0
		},
		{
		0x203e,
		0xa1c2
		},
		{
		0x2103,
		0xa24a
		},
		{
		0x2105,
		0xa1c1
		},
		{
		0x2109,
		0xa24b
		},
		{
		0x2190,
		0xa1f6
		},
		{
		0x2191,
		0xa1f4
		},
		{
		0x2192,
		0xa1f7
		},
		{
		0x2193,
		0xa1f5
		},
		{
		0x2196,
		0xa1f8
		},
		{
		0x2197,
		0xa1f9
		},
		{
		0x2198,
		0xa1fb
		},
		{
		0x2199,
		0xa1fa
		},
		{
		0x221a,
		0xa1d4
		},
		{
		0x221e,
		0xa1db
		},
		{
		0x221f,
		0xa1e8
		},
		{
		0x2220,
		0xa1e7
		},
		{
		0x2223,
		0xa1fd
		},
		{
		0x2225,
		0xa1fc
		},
		{
		0x2229,
		0xa1e4
		},
		{
		0x222a,
		0xa1e5
		},
		{
		0x222b,
		0xa1ec
		},
		{
		0x222e,
		0xa1ed
		},
		{
		0x2234,
		0xa1ef
		},
		{
		0x2235,
		0xa1ee
		},
		{
		0x223c,
		0xa1e3
		},
		{
		0x2252,
		0xa1dc
		},
		{
		0x2260,
		0xa1da
		},
		{
		0x2261,
		0xa1dd
		},
		{
		0x2266,
		0xa1d8
		},
		{
		0x2267,
		0xa1d9
		},
		{
		0x22a5,
		0xa1e6
		},
		{
		0x22bf,
		0xa1e9
		},
		{
		0x2500,
		0xa277
		},
		{
		0x2502,
		0xa278
		},
		{
		0x250c,
		0xa27a
		},
		{
		0x2510,
		0xa27b
		},
		{
		0x2514,
		0xa27c
		},
		{
		0x2518,
		0xa27d
		},
		{
		0x251c,
		0xa275
		},
		{
		0x2524,
		0xa274
		},
		{
		0x252c,
		0xa273
		},
		{
		0x2534,
		0xa272
		},
		{
		0x253c,
		0xa271
		},
		{
		0x2550,
		0xa2a4
		},
		{
		0x255e,
		0xa2a5
		},
		{
		0x2561,
		0xa2a7
		},
		{
		0x256a,
		0xa2a6
		},
		{
		0x256d,
		0xa27e
		},
		{
		0x256e,
		0xa2a1
		},
		{
		0x256f,
		0xa2a3
		},
		{
		0x2570,
		0xa2a2
		},
		{
		0x2571,
		0xa2ac
		},
		{
		0x2572,
		0xa2ad
		},
		{
		0x2573,
		0xa2ae
		},
		{
		0x2589,
		0xa270
		},
		{
		0x258a,
		0xa26f
		},
		{
		0x258b,
		0xa26e
		},
		{
		0x258c,
		0xa26d
		},
		{
		0x258d,
		0xa26c
		},
		{
		0x258e,
		0xa26b
		},
		{
		0x258f,
		0xa26a
		},
		{
		0x2594,
		0xa276
		},
		{
		0x2595,
		0xa279
		},
		{
		0x25a0,
		0xa1bd
		},
		{
		0x25a1,
		0xa1bc
		},
		{
		0x25b2,
		0xa1b6
		},
		{
		0x25b3,
		0xa1b5
		},
		{
		0x25bc,
		0xa1bf
		},
		{
		0x25bd,
		0xa1be
		},
		{
		0x25c6,
		0xa1bb
		},
		{
		0x25c7,
		0xa1ba
		},
		{
		0x25cb,
		0xa1b3
		},
		{
		0x25ce,
		0xa1b7
		},
		{
		0x25cf,
		0xa1b4
		},
		{
		0x25e2,
		0xa2a8
		},
		{
		0x25e3,
		0xa2a9
		},
		{
		0x25e4,
		0xa2ab
		},
		{
		0x25e5,
		0xa2aa
		},
		{
		0x2605,
		0xa1b9
		},
		{
		0x2606,
		0xa1b8
		},
		{
		0x2609,
		0xa1f3
		},
		{
		0x2640,
		0xa1f0
		},
		{
		0x2641,
		0xa1f2
		},
		{
		0x2642,
		0xa1f1
		},
		{
		0x3000,
		0xa140
		},
		{
		0x3001,
		0xa142
		},
		{
		0x3002,
		0xa143
		},
		{
		0x3003,
		0xa1b2
		},
		{
		0x3005,
		0xc6a4
		},
		{
		0x3008,
		0xa171
		},
		{
		0x3009,
		0xa172
		},
		{
		0x300a,
		0xa16d
		},
		{
		0x300b,
		0xa16e
		},
		{
		0x300c,
		0xa175
		},
		{
		0x300d,
		0xa176
		},
		{
		0x300e,
		0xa179
		},
		{
		0x300f,
		0xa17a
		},
		{
		0x3010,
		0xa169
		},
		{
		0x3011,
		0xa16a
		},
		{
		0x3012,
		0xa245
		},
		{
		0x3014,
		0xa165
		},
		{
		0x3015,
		0xa166
		},
		{
		0x301d,
		0xa1a9
		},
		{
		0x301e,
		0xa1aa
		},
		{
		0x309d,
		0xc6a2
		},
		{
		0x309e,
		0xc6a3
		},
		{
		0x30fe,
		0xc6a1
		},
		{
		0x32a3,
		0xa1c0
		},
		{
		0x338e,
		0xa255
		},
		{
		0x338f,
		0xa256
		},
		{
		0x339c,
		0xa250
		},
		{
		0x339d,
		0xa251
		},
		{
		0x339e,
		0xa252
		},
		{
		0x33a1,
		0xa254
		},
		{
		0x33c4,
		0xa257
		},
		{
		0x33ce,
		0xa253
		},
		{
		0x33d1,
		0xa1eb
		},
		{
		0x33d2,
		0xa1ea
		},
		{
		0x33d5,
		0xa24f
		},
		{
		0x4e00,
		0xa440
		},
		{
		0x4e01,
		0xa442
		},
		{
		0x4e03,
		0xa443
		},
		{
		0x4e07,
		0xc945
		},
		{
		0x4e08,
		0xa456
		},
		{
		0x4e09,
		0xa454
		},
		{
		0x4e0a,
		0xa457
		},
		{
		0x4e0b,
		0xa455
		},
		{
		0x4e0c,
		0xc946
		},
		{
		0x4e0d,
		0xa4a3
		},
		{
		0x4e0e,
		0xc94f
		},
		{
		0x4e0f,
		0xc94d
		},
		{
		0x4e10,
		0xa4a2
		},
		{
		0x4e11,
		0xa4a1
		},
		{
		0x4e14,
		0xa542
		},
		{
		0x4e15,
		0xa541
		},
		{
		0x4e16,
		0xa540
		},
		{
		0x4e18,
		0xa543
		},
		{
		0x4e19,
		0xa4fe
		},
		{
		0x4e1e,
		0xa5e0
		},
		{
		0x4e1f,
		0xa5e1
		},
		{
		0x4e26,
		0xa8c3
		},
		{
		0x4e2b,
		0xa458
		},
		{
		0x4e2d,
		0xa4a4
		},
		{
		0x4e2e,
		0xc950
		},
		{
		0x4e30,
		0xa4a5
		},
		{
		0x4e31,
		0xc963
		},
		{
		0x4e32,
		0xa6ea
		},
		{
		0x4e33,
		0xcbb1
		},
		{
		0x4e38,
		0xa459
		},
		{
		0x4e39,
		0xa4a6
		},
		{
		0x4e3b,
		0xa544
		},
		{
		0x4e3c,
		0xc964
		},
		{
		0x4e42,
		0xc940
		},
		{
		0x4e43,
		0xa444
		},
		{
		0x4e45,
		0xa45b
		},
		{
		0x4e47,
		0xc947
		},
		{
		0x4e48,
		0xa45c
		},
		{
		0x4e4b,
		0xa4a7
		},
		{
		0x4e4d,
		0xa545
		},
		{
		0x4e4e,
		0xa547
		},
		{
		0x4e4f,
		0xa546
		},
		{
		0x4e52,
		0xa5e2
		},
		{
		0x4e53,
		0xa5e3
		},
		{
		0x4e56,
		0xa8c4
		},
		{
		0x4e58,
		0xadbc
		},
		{
		0x4e59,
		0xa441
		},
		{
		0x4e5c,
		0xc941
		},
		{
		0x4e5d,
		0xa445
		},
		{
		0x4e5e,
		0xa45e
		},
		{
		0x4e5f,
		0xa45d
		},
		{
		0x4e69,
		0xa5e4
		},
		{
		0x4e73,
		0xa8c5
		},
		{
		0x4e7e,
		0xb0ae
		},
		{
		0x4e7f,
		0xd44b
		},
		{
		0x4e82,
		0xb6c3
		},
		{
		0x4e83,
		0xdcb1
		},
		{
		0x4e84,
		0xdcb2
		},
		{
		0x4e86,
		0xa446
		},
		{
		0x4e88,
		0xa4a9
		},
		{
		0x4e8b,
		0xa8c6
		},
		{
		0x4e8c,
		0xa447
		},
		{
		0x4e8d,
		0xc948
		},
		{
		0x4e8e,
		0xa45f
		},
		{
		0x4e91,
		0xa4aa
		},
		{
		0x4e92,
		0xa4ac
		},
		{
		0x4e93,
		0xc951
		},
		{
		0x4e94,
		0xa4ad
		},
		{
		0x4e95,
		0xa4ab
		},
		{
		0x4e99,
		0xa5e5
		},
		{
		0x4e9b,
		0xa8c7
		},
		{
		0x4e9e,
		0xa8c8
		},
		{
		0x4e9f,
		0xab45
		},
		{
		0x4ea1,
		0xa460
		},
		{
		0x4ea2,
		0xa4ae
		},
		{
		0x4ea4,
		0xa5e6
		},
		{
		0x4ea5,
		0xa5e8
		},
		{
		0x4ea6,
		0xa5e7
		},
		{
		0x4ea8,
		0xa6eb
		},
		{
		0x4eab,
		0xa8c9
		},
		{
		0x4eac,
		0xa8ca
		},
		{
		0x4ead,
		0xab46
		},
		{
		0x4eae,
		0xab47
		},
		{
		0x4eb3,
		0xadbd
		},
		{
		0x4eb6,
		0xdcb3
		},
		{
		0x4eb9,
		0xf6d6
		},
		{
		0x4eba,
		0xa448
		},
		{
		0x4ec0,
		0xa4b0
		},
		{
		0x4ec1,
		0xa4af
		},
		{
		0x4ec2,
		0xc952
		},
		{
		0x4ec3,
		0xa4b1
		},
		{
		0x4ec4,
		0xa4b7
		},
		{
		0x4ec6,
		0xa4b2
		},
		{
		0x4ec7,
		0xa4b3
		},
		{
		0x4ec8,
		0xc954
		},
		{
		0x4ec9,
		0xc953
		},
		{
		0x4eca,
		0xa4b5
		},
		{
		0x4ecb,
		0xa4b6
		},
		{
		0x4ecd,
		0xa4b4
		},
		{
		0x4ed4,
		0xa54a
		},
		{
		0x4ed5,
		0xa54b
		},
		{
		0x4ed6,
		0xa54c
		},
		{
		0x4ed7,
		0xa54d
		},
		{
		0x4ed8,
		0xa549
		},
		{
		0x4ed9,
		0xa550
		},
		{
		0x4eda,
		0xc96a
		},
		{
		0x4edc,
		0xc966
		},
		{
		0x4edd,
		0xc969
		},
		{
		0x4ede,
		0xa551
		},
		{
		0x4edf,
		0xa561
		},
		{
		0x4ee1,
		0xc968
		},
		{
		0x4ee3,
		0xa54e
		},
		{
		0x4ee4,
		0xa54f
		},
		{
		0x4ee5,
		0xa548
		},
		{
		0x4ee8,
		0xc965
		},
		{
		0x4ee9,
		0xc967
		},
		{
		0x4ef0,
		0xa5f5
		},
		{
		0x4ef1,
		0xc9b0
		},
		{
		0x4ef2,
		0xa5f2
		},
		{
		0x4ef3,
		0xa5f6
		},
		{
		0x4ef4,
		0xc9ba
		},
		{
		0x4ef5,
		0xc9ae
		},
		{
		0x4ef6,
		0xa5f3
		},
		{
		0x4ef7,
		0xc9b2
		},
		{
		0x4efb,
		0xa5f4
		},
		{
		0x4efd,
		0xa5f7
		},
		{
		0x4eff,
		0xa5e9
		},
		{
		0x4f00,
		0xc9b1
		},
		{
		0x4f01,
		0xa5f8
		},
		{
		0x4f02,
		0xc9b5
		},
		{
		0x4f04,
		0xc9b9
		},
		{
		0x4f05,
		0xc9b6
		},
		{
		0x4f08,
		0xc9b3
		},
		{
		0x4f09,
		0xa5ea
		},
		{
		0x4f0a,
		0xa5ec
		},
		{
		0x4f0b,
		0xa5f9
		},
		{
		0x4f0d,
		0xa5ee
		},
		{
		0x4f0e,
		0xc9ab
		},
		{
		0x4f0f,
		0xa5f1
		},
		{
		0x4f10,
		0xa5ef
		},
		{
		0x4f11,
		0xa5f0
		},
		{
		0x4f12,
		0xc9bb
		},
		{
		0x4f13,
		0xc9b8
		},
		{
		0x4f14,
		0xc9af
		},
		{
		0x4f15,
		0xa5ed
		},
		{
		0x4f18,
		0xc9ac
		},
		{
		0x4f19,
		0xa5eb
		},
		{
		0x4f1d,
		0xc9b4
		},
		{
		0x4f22,
		0xc9b7
		},
		{
		0x4f2c,
		0xc9ad
		},
		{
		0x4f2d,
		0xca66
		},
		{
		0x4f2f,
		0xa742
		},
		{
		0x4f30,
		0xa6f4
		},
		{
		0x4f33,
		0xca67
		},
		{
		0x4f34,
		0xa6f1
		},
		{
		0x4f36,
		0xa744
		},
		{
		0x4f38,
		0xa6f9
		},
		{
		0x4f3a,
		0xa6f8
		},
		{
		0x4f3b,
		0xca5b
		},
		{
		0x4f3c,
		0xa6fc
		},
		{
		0x4f3d,
		0xa6f7
		},
		{
		0x4f3e,
		0xca60
		},
		{
		0x4f3f,
		0xca68
		},
		{
		0x4f41,
		0xca64
		},
		{
		0x4f43,
		0xa6fa
		},
		{
		0x4f46,
		0xa6fd
		},
		{
		0x4f47,
		0xa6ee
		},
		{
		0x4f48,
		0xa747
		},
		{
		0x4f49,
		0xca5d
		},
		{
		0x4f4c,
		0xcbbd
		},
		{
		0x4f4d,
		0xa6ec
		},
		{
		0x4f4e,
		0xa743
		},
		{
		0x4f4f,
		0xa6ed
		},
		{
		0x4f50,
		0xa6f5
		},
		{
		0x4f51,
		0xa6f6
		},
		{
		0x4f52,
		0xca62
		},
		{
		0x4f53,
		0xca5e
		},
		{
		0x4f54,
		0xa6fb
		},
		{
		0x4f55,
		0xa6f3
		},
		{
		0x4f56,
		0xca5a
		},
		{
		0x4f57,
		0xa6ef
		},
		{
		0x4f58,
		0xca65
		},
		{
		0x4f59,
		0xa745
		},
		{
		0x4f5a,
		0xa748
		},
		{
		0x4f5b,
		0xa6f2
		},
		{
		0x4f5c,
		0xa740
		},
		{
		0x4f5d,
		0xa746
		},
		{
		0x4f5e,
		0xa6f0
		},
		{
		0x4f5f,
		0xca63
		},
		{
		0x4f60,
		0xa741
		},
		{
		0x4f61,
		0xca69
		},
		{
		0x4f62,
		0xca5c
		},
		{
		0x4f63,
		0xa6fe
		},
		{
		0x4f64,
		0xca5f
		},
		{
		0x4f67,
		0xca61
		},
		{
		0x4f69,
		0xa8d8
		},
		{
		0x4f6a,
		0xcbbf
		},
		{
		0x4f6b,
		0xcbcb
		},
		{
		0x4f6c,
		0xa8d0
		},
		{
		0x4f6e,
		0xcbcc
		},
		{
		0x4f6f,
		0xa8cb
		},
		{
		0x4f70,
		0xa8d5
		},
		{
		0x4f73,
		0xa8ce
		},
		{
		0x4f74,
		0xcbb9
		},
		{
		0x4f75,
		0xa8d6
		},
		{
		0x4f76,
		0xcbb8
		},
		{
		0x4f77,
		0xcbbc
		},
		{
		0x4f78,
		0xcbc3
		},
		{
		0x4f79,
		0xcbc1
		},
		{
		0x4f7a,
		0xa8de
		},
		{
		0x4f7b,
		0xa8d9
		},
		{
		0x4f7c,
		0xcbb3
		},
		{
		0x4f7d,
		0xcbb5
		},
		{
		0x4f7e,
		0xa8db
		},
		{
		0x4f7f,
		0xa8cf
		},
		{
		0x4f80,
		0xcbb6
		},
		{
		0x4f81,
		0xcbc2
		},
		{
		0x4f82,
		0xcbc9
		},
		{
		0x4f83,
		0xa8d4
		},
		{
		0x4f84,
		0xcbbb
		},
		{
		0x4f85,
		0xcbb4
		},
		{
		0x4f86,
		0xa8d3
		},
		{
		0x4f87,
		0xcbb7
		},
		{
		0x4f88,
		0xa8d7
		},
		{
		0x4f89,
		0xcbba
		},
		{
		0x4f8b,
		0xa8d2
		},
		{
		0x4f8d,
		0xa8cd
		},
		{
		0x4f8f,
		0xa8dc
		},
		{
		0x4f90,
		0xcbc4
		},
		{
		0x4f91,
		0xa8dd
		},
		{
		0x4f92,
		0xcbc8
		},
		{
		0x4f94,
		0xcbc6
		},
		{
		0x4f95,
		0xcbca
		},
		{
		0x4f96,
		0xa8da
		},
		{
		0x4f97,
		0xcbbe
		},
		{
		0x4f98,
		0xcbb2
		},
		{
		0x4f9a,
		0xcbc0
		},
		{
		0x4f9b,
		0xa8d1
		},
		{
		0x4f9c,
		0xcbc5
		},
		{
		0x4f9d,
		0xa8cc
		},
		{
		0x4f9e,
		0xcbc7
		},
		{
		0x4fae,
		0xab56
		},
		{
		0x4faf,
		0xab4a
		},
		{
		0x4fb2,
		0xcde0
		},
		{
		0x4fb3,
		0xcde8
		},
		{
		0x4fb5,
		0xab49
		},
		{
		0x4fb6,
		0xab51
		},
		{
		0x4fb7,
		0xab5d
		},
		{
		0x4fb9,
		0xcdee
		},
		{
		0x4fba,
		0xcdec
		},
		{
		0x4fbb,
		0xcde7
		},
		{
		0x4fbf,
		0xab4b
		},
		{
		0x4fc0,
		0xcded
		},
		{
		0x4fc1,
		0xcde3
		},
		{
		0x4fc2,
		0xab59
		},
		{
		0x4fc3,
		0xab50
		},
		{
		0x4fc4,
		0xab58
		},
		{
		0x4fc5,
		0xcdde
		},
		{
		0x4fc7,
		0xcdea
		},
		{
		0x4fc9,
		0xcde1
		},
		{
		0x4fca,
		0xab54
		},
		{
		0x4fcb,
		0xcde2
		},
		{
		0x4fcd,
		0xcddd
		},
		{
		0x4fce,
		0xab5b
		},
		{
		0x4fcf,
		0xab4e
		},
		{
		0x4fd0,
		0xab57
		},
		{
		0x4fd1,
		0xab4d
		},
		{
		0x4fd3,
		0xcddf
		},
		{
		0x4fd4,
		0xcde4
		},
		{
		0x4fd6,
		0xcdeb
		},
		{
		0x4fd7,
		0xab55
		},
		{
		0x4fd8,
		0xab52
		},
		{
		0x4fd9,
		0xcde6
		},
		{
		0x4fda,
		0xab5a
		},
		{
		0x4fdb,
		0xcde9
		},
		{
		0x4fdc,
		0xcde5
		},
		{
		0x4fdd,
		0xab4f
		},
		{
		0x4fde,
		0xab5c
		},
		{
		0x4fdf,
		0xab53
		},
		{
		0x4fe0,
		0xab4c
		},
		{
		0x4fe1,
		0xab48
		},
		{
		0x4fec,
		0xcdef
		},
		{
		0x4fee,
		0xadd7
		},
		{
		0x4fef,
		0xadc1
		},
		{
		0x4ff1,
		0xadd1
		},
		{
		0x4ff3,
		0xadd6
		},
		{
		0x4ff4,
		0xd0d0
		},
		{
		0x4ff5,
		0xd0cf
		},
		{
		0x4ff6,
		0xd0d4
		},
		{
		0x4ff7,
		0xd0d5
		},
		{
		0x4ff8,
		0xadc4
		},
		{
		0x4ffa,
		0xadcd
		},
		{
		0x4ffe,
		0xadda
		},
		{
		0x5000,
		0xadce
		},
		{
		0x5005,
		0xd0c9
		},
		{
		0x5006,
		0xadc7
		},
		{
		0x5007,
		0xd0ca
		},
		{
		0x5009,
		0xaddc
		},
		{
		0x500b,
		0xadd3
		},
		{
		0x500c,
		0xadbe
		},
		{
		0x500d,
		0xadbf
		},
		{
		0x500e,
		0xd0dd
		},
		{
		0x500f,
		0xb0bf
		},
		{
		0x5011,
		0xadcc
		},
		{
		0x5012,
		0xadcb
		},
		{
		0x5013,
		0xd0cb
		},
		{
		0x5014,
		0xadcf
		},
		{
		0x5015,
		0xd45b
		},
		{
		0x5016,
		0xadc6
		},
		{
		0x5017,
		0xd0d6
		},
		{
		0x5018,
		0xadd5
		},
		{
		0x5019,
		0xadd4
		},
		{
		0x501a,
		0xadca
		},
		{
		0x501b,
		0xd0ce
		},
		{
		0x501c,
		0xd0d7
		},
		{
		0x501e,
		0xd0c8
		},
		{
		0x501f,
		0xadc9
		},
		{
		0x5020,
		0xd0d8
		},
		{
		0x5021,
		0xadd2
		},
		{
		0x5022,
		0xd0cc
		},
		{
		0x5023,
		0xadc0
		},
		{
		0x5025,
		0xadc3
		},
		{
		0x5026,
		0xadc2
		},
		{
		0x5027,
		0xd0d9
		},
		{
		0x5028,
		0xadd0
		},
		{
		0x5029,
		0xadc5
		},
		{
		0x502a,
		0xadd9
		},
		{
		0x502b,
		0xaddb
		},
		{
		0x502c,
		0xd0d3
		},
		{
		0x502d,
		0xadd8
		},
		{
		0x502f,
		0xd0db
		},
		{
		0x5030,
		0xd0cd
		},
		{
		0x5031,
		0xd0dc
		},
		{
		0x5033,
		0xd0d1
		},
		{
		0x5035,
		0xd0da
		},
		{
		0x5037,
		0xd0d2
		},
		{
		0x503c,
		0xadc8
		},
		{
		0x5040,
		0xd463
		},
		{
		0x5041,
		0xd457
		},
		{
		0x5043,
		0xb0b3
		},
		{
		0x5045,
		0xd45c
		},
		{
		0x5046,
		0xd462
		},
		{
		0x5047,
		0xb0b2
		},
		{
		0x5048,
		0xd455
		},
		{
		0x5049,
		0xb0b6
		},
		{
		0x504a,
		0xd459
		},
		{
		0x504b,
		0xd452
		},
		{
		0x504c,
		0xb0b4
		},
		{
		0x504d,
		0xd456
		},
		{
		0x504e,
		0xb0b9
		},
		{
		0x504f,
		0xb0be
		},
		{
		0x5051,
		0xd467
		},
		{
		0x5053,
		0xd451
		},
		{
		0x5055,
		0xb0ba
		},
		{
		0x5057,
		0xd466
		},
		{
		0x505a,
		0xb0b5
		},
		{
		0x505b,
		0xd458
		},
		{
		0x505c,
		0xb0b1
		},
		{
		0x505d,
		0xd453
		},
		{
		0x505e,
		0xd44f
		},
		{
		0x505f,
		0xd45d
		},
		{
		0x5060,
		0xd450
		},
		{
		0x5061,
		0xd44e
		},
		{
		0x5062,
		0xd45a
		},
		{
		0x5063,
		0xd460
		},
		{
		0x5064,
		0xd461
		},
		{
		0x5065,
		0xb0b7
		},
		{
		0x5068,
		0xd85b
		},
		{
		0x5069,
		0xd45e
		},
		{
		0x506a,
		0xd44d
		},
		{
		0x506b,
		0xd45f
		},
		{
		0x506d,
		0xb0c1
		},
		{
		0x506e,
		0xd464
		},
		{
		0x506f,
		0xb0c0
		},
		{
		0x5070,
		0xd44c
		},
		{
		0x5072,
		0xd454
		},
		{
		0x5073,
		0xd465
		},
		{
		0x5074,
		0xb0bc
		},
		{
		0x5075,
		0xb0bb
		},
		{
		0x5076,
		0xb0b8
		},
		{
		0x5077,
		0xb0bd
		},
		{
		0x507a,
		0xb0af
		},
		{
		0x507d,
		0xb0b0
		},
		{
		0x5080,
		0xb3c8
		},
		{
		0x5082,
		0xd85e
		},
		{
		0x5083,
		0xd857
		},
		{
		0x5085,
		0xb3c5
		},
		{
		0x5087,
		0xd85f
		},
		{
		0x508b,
		0xd855
		},
		{
		0x508c,
		0xd858
		},
		{
		0x508d,
		0xb3c4
		},
		{
		0x508e,
		0xd859
		},
		{
		0x5091,
		0xb3c7
		},
		{
		0x5092,
		0xd85d
		},
		{
		0x5094,
		0xd853
		},
		{
		0x5095,
		0xd852
		},
		{
		0x5096,
		0xb3c9
		},
		{
		0x5098,
		0xb3ca
		},
		{
		0x5099,
		0xb3c6
		},
		{
		0x509a,
		0xb3cb
		},
		{
		0x509b,
		0xd851
		},
		{
		0x509c,
		0xd85c
		},
		{
		0x509d,
		0xd85a
		},
		{
		0x509e,
		0xd854
		},
		{
		0x50a2,
		0xb3c3
		},
		{
		0x50a3,
		0xd856
		},
		{
		0x50ac,
		0xb6ca
		},
		{
		0x50ad,
		0xb6c4
		},
		{
		0x50ae,
		0xdcb7
		},
		{
		0x50af,
		0xb6cd
		},
		{
		0x50b0,
		0xdcbd
		},
		{
		0x50b1,
		0xdcc0
		},
		{
		0x50b2,
		0xb6c6
		},
		{
		0x50b3,
		0xb6c7
		},
		{
		0x50b4,
		0xdcba
		},
		{
		0x50b5,
		0xb6c5
		},
		{
		0x50b6,
		0xdcc3
		},
		{
		0x50b7,
		0xb6cb
		},
		{
		0x50b8,
		0xdcc4
		},
		{
		0x50ba,
		0xdcbf
		},
		{
		0x50bb,
		0xb6cc
		},
		{
		0x50bd,
		0xdcb4
		},
		{
		0x50be,
		0xb6c9
		},
		{
		0x50bf,
		0xdcb5
		},
		{
		0x50c1,
		0xdcbe
		},
		{
		0x50c2,
		0xdcbc
		},
		{
		0x50c4,
		0xdcb8
		},
		{
		0x50c5,
		0xb6c8
		},
		{
		0x50c6,
		0xdcb6
		},
		{
		0x50c7,
		0xb6ce
		},
		{
		0x50c8,
		0xdcbb
		},
		{
		0x50c9,
		0xdcc2
		},
		{
		0x50ca,
		0xdcb9
		},
		{
		0x50cb,
		0xdcc1
		},
		{
		0x50ce,
		0xb9b6
		},
		{
		0x50cf,
		0xb9b3
		},
		{
		0x50d1,
		0xb9b4
		},
		{
		0x50d3,
		0xe0f9
		},
		{
		0x50d4,
		0xe0f1
		},
		{
		0x50d5,
		0xb9b2
		},
		{
		0x50d6,
		0xb9af
		},
		{
		0x50d7,
		0xe0f2
		},
		{
		0x50da,
		0xb9b1
		},
		{
		0x50db,
		0xe0f5
		},
		{
		0x50dd,
		0xe0f7
		},
		{
		0x50e0,
		0xe0fe
		},
		{
		0x50e3,
		0xe0fd
		},
		{
		0x50e4,
		0xe0f8
		},
		{
		0x50e5,
		0xb9ae
		},
		{
		0x50e6,
		0xe0f0
		},
		{
		0x50e7,
		0xb9ac
		},
		{
		0x50e8,
		0xe0f3
		},
		{
		0x50e9,
		0xb9b7
		},
		{
		0x50ea,
		0xe0f6
		},
		{
		0x50ec,
		0xe0fa
		},
		{
		0x50ed,
		0xb9b0
		},
		{
		0x50ee,
		0xb9ad
		},
		{
		0x50ef,
		0xe0fc
		},
		{
		0x50f0,
		0xe0fb
		},
		{
		0x50f1,
		0xb9b5
		},
		{
		0x50f3,
		0xe0f4
		},
		{
		0x50f5,
		0xbbf8
		},
		{
		0x50f6,
		0xe4ec
		},
		{
		0x50f8,
		0xe4e9
		},
		{
		0x50f9,
		0xbbf9
		},
		{
		0x50fb,
		0xbbf7
		},
		{
		0x50fd,
		0xe4f0
		},
		{
		0x50fe,
		0xe4ed
		},
		{
		0x50ff,
		0xe4e6
		},
		{
		0x5100,
		0xbbf6
		},
		{
		0x5102,
		0xbbfa
		},
		{
		0x5103,
		0xe4e7
		},
		{
		0x5104,
		0xbbf5
		},
		{
		0x5105,
		0xbbfd
		},
		{
		0x5106,
		0xe4ea
		},
		{
		0x5107,
		0xe4eb
		},
		{
		0x5108,
		0xbbfb
		},
		{
		0x5109,
		0xbbfc
		},
		{
		0x510a,
		0xe4f1
		},
		{
		0x510b,
		0xe4ee
		},
		{
		0x510c,
		0xe4ef
		},
		{
		0x5110,
		0xbeaa
		},
		{
		0x5111,
		0xe8f8
		},
		{
		0x5112,
		0xbea7
		},
		{
		0x5113,
		0xe8f5
		},
		{
		0x5114,
		0xbea9
		},
		{
		0x5115,
		0xbeab
		},
		{
		0x5117,
		0xe8f6
		},
		{
		0x5118,
		0xbea8
		},
		{
		0x511a,
		0xe8f7
		},
		{
		0x511c,
		0xe8f4
		},
		{
		0x511f,
		0xc076
		},
		{
		0x5120,
		0xecbd
		},
		{
		0x5121,
		0xc077
		},
		{
		0x5122,
		0xecbb
		},
		{
		0x5124,
		0xecbc
		},
		{
		0x5125,
		0xecba
		},
		{
		0x5126,
		0xecb9
		},
		{
		0x5129,
		0xecbe
		},
		{
		0x512a,
		0xc075
		},
		{
		0x512d,
		0xefb8
		},
		{
		0x512e,
		0xefb9
		},
		{
		0x5130,
		0xe4e8
		},
		{
		0x5131,
		0xefb7
		},
		{
		0x5132,
		0xc078
		},
		{
		0x5133,
		0xc35f
		},
		{
		0x5134,
		0xf1eb
		},
		{
		0x5135,
		0xf1ec
		},
		{
		0x5137,
		0xc4d7
		},
		{
		0x5138,
		0xc4d8
		},
		{
		0x5139,
		0xf5c1
		},
		{
		0x513a,
		0xf5c0
		},
		{
		0x513b,
		0xc56c
		},
		{
		0x513c,
		0xc56b
		},
		{
		0x513d,
		0xf7d0
		},
		{
		0x513f,
		0xa449
		},
		{
		0x5140,
		0xa461
		},
		{
		0x5141,
		0xa4b9
		},
		{
		0x5143,
		0xa4b8
		},
		{
		0x5144,
		0xa553
		},
		{
		0x5145,
		0xa552
		},
		{
		0x5146,
		0xa5fc
		},
		{
		0x5147,
		0xa5fb
		},
		{
		0x5148,
		0xa5fd
		},
		{
		0x5149,
		0xa5fa
		},
		{
		0x514b,
		0xa74a
		},
		{
		0x514c,
		0xa749
		},
		{
		0x514d,
		0xa74b
		},
		{
		0x5152,
		0xa8e0
		},
		{
		0x5154,
		0xa8df
		},
		{
		0x5155,
		0xa8e1
		},
		{
		0x5157,
		0xab5e
		},
		{
		0x5159,
		0xa259
		},
		{
		0x515a,
		0xd0de
		},
		{
		0x515b,
		0xa25a
		},
		{
		0x515c,
		0xb0c2
		},
		{
		0x515d,
		0xa25c
		},
		{
		0x515e,
		0xa25b
		},
		{
		0x515f,
		0xd860
		},
		{
		0x5161,
		0xa25d
		},
		{
		0x5162,
		0xb9b8
		},
		{
		0x5163,
		0xa25e
		},
		{
		0x5165,
		0xa44a
		},
		{
		0x5167,
		0xa4ba
		},
		{
		0x5168,
		0xa5fe
		},
		{
		0x5169,
		0xa8e2
		},
		{
		0x516b,
		0xa44b
		},
		{
		0x516c,
		0xa4bd
		},
		{
		0x516d,
		0xa4bb
		},
		{
		0x516e,
		0xa4bc
		},
		{
		0x5171,
		0xa640
		},
		{
		0x5175,
		0xa74c
		},
		{
		0x5176,
		0xa8e4
		},
		{
		0x5177,
		0xa8e3
		},
		{
		0x5178,
		0xa8e5
		},
		{
		0x517c,
		0xaddd
		},
		{
		0x5180,
		0xbeac
		},
		{
		0x5187,
		0xc94e
		},
		{
		0x5189,
		0xa554
		},
		{
		0x518a,
		0xa555
		},
		{
		0x518d,
		0xa641
		},
		{
		0x518f,
		0xca6a
		},
		{
		0x5191,
		0xab60
		},
		{
		0x5192,
		0xab5f
		},
		{
		0x5193,
		0xd0e0
		},
		{
		0x5194,
		0xd0df
		},
		{
		0x5195,
		0xb0c3
		},
		{
		0x5197,
		0xa4be
		},
		{
		0x5198,
		0xc955
		},
		{
		0x519e,
		0xcbcd
		},
		{
		0x51a0,
		0xab61
		},
		{
		0x51a2,
		0xade0
		},
		{
		0x51a4,
		0xadde
		},
		{
		0x51a5,
		0xaddf
		},
		{
		0x51aa,
		0xbead
		},
		{
		0x51ac,
		0xa556
		},
		{
		0x51b0,
		0xa642
		},
		{
		0x51b1,
		0xc9bc
		},
		{
		0x51b6,
		0xa74d
		},
		{
		0x51b7,
		0xa74e
		},
		{
		0x51b9,
		0xca6b
		},
		{
		0x51bc,
		0xcbce
		},
		{
		0x51bd,
		0xa8e6
		},
		{
		0x51be,
		0xcbcf
		},
		{
		0x51c4,
		0xd0e2
		},
		{
		0x51c5,
		0xd0e3
		},
		{
		0x51c6,
		0xade3
		},
		{
		0x51c8,
		0xd0e4
		},
		{
		0x51ca,
		0xd0e1
		},
		{
		0x51cb,
		0xade4
		},
		{
		0x51cc,
		0xade2
		},
		{
		0x51cd,
		0xade1
		},
		{
		0x51ce,
		0xd0e5
		},
		{
		0x51d0,
		0xd468
		},
		{
		0x51d4,
		0xd861
		},
		{
		0x51d7,
		0xdcc5
		},
		{
		0x51d8,
		0xe140
		},
		{
		0x51dc,
		0xbbfe
		},
		{
		0x51dd,
		0xbeae
		},
		{
		0x51de,
		0xe8f9
		},
		{
		0x51e0,
		0xa44c
		},
		{
		0x51e1,
		0xa45a
		},
		{
		0x51f0,
		0xb0c4
		},
		{
		0x51f1,
		0xb3cd
		},
		{
		0x51f3,
		0xb9b9
		},
		{
		0x51f5,
		0xc942
		},
		{
		0x51f6,
		0xa4bf
		},
		{
		0x51f8,
		0xa559
		},
		{
		0x51f9,
		0xa557
		},
		{
		0x51fa,
		0xa558
		},
		{
		0x51fd,
		0xa8e7
		},
		{
		0x5200,
		0xa44d
		},
		{
		0x5201,
		0xa44e
		},
		{
		0x5203,
		0xa462
		},
		{
		0x5206,
		0xa4c0
		},
		{
		0x5207,
		0xa4c1
		},
		{
		0x5208,
		0xa4c2
		},
		{
		0x5209,
		0xc9be
		},
		{
		0x520a,
		0xa55a
		},
		{
		0x520c,
		0xc96b
		},
		{
		0x520e,
		0xa646
		},
		{
		0x5210,
		0xc9bf
		},
		{
		0x5211,
		0xa644
		},
		{
		0x5212,
		0xa645
		},
		{
		0x5213,
		0xc9bd
		},
		{
		0x5216,
		0xa647
		},
		{
		0x5217,
		0xa643
		},
		{
		0x521c,
		0xca6c
		},
		{
		0x521d,
		0xaaec
		},
		{
		0x521e,
		0xca6d
		},
		{
		0x5221,
		0xca6e
		},
		{
		0x5224,
		0xa750
		},
		{
		0x5225,
		0xa74f
		},
		{
		0x5228,
		0xa753
		},
		{
		0x5229,
		0xa751
		},
		{
		0x522a,
		0xa752
		},
		{
		0x522e,
		0xa8ed
		},
		{
		0x5230,
		0xa8ec
		},
		{
		0x5231,
		0xcbd4
		},
		{
		0x5232,
		0xcbd1
		},
		{
		0x5233,
		0xcbd2
		},
		{
		0x5235,
		0xcbd0
		},
		{
		0x5236,
		0xa8ee
		},
		{
		0x5237,
		0xa8ea
		},
		{
		0x5238,
		0xa8e9
		},
		{
		0x523a,
		0xa8eb
		},
		{
		0x523b,
		0xa8e8
		},
		{
		0x5241,
		0xa8ef
		},
		{
		0x5243,
		0xab63
		},
		{
		0x5244,
		0xcdf0
		},
		{
		0x5246,
		0xcbd3
		},
		{
		0x5247,
		0xab68
		},
		{
		0x5249,
		0xcdf1
		},
		{
		0x524a,
		0xab64
		},
		{
		0x524b,
		0xab67
		},
		{
		0x524c,
		0xab66
		},
		{
		0x524d,
		0xab65
		},
		{
		0x524e,
		0xab62
		},
		{
		0x5252,
		0xd0e8
		},
		{
		0x5254,
		0xade7
		},
		{
		0x5255,
		0xd0eb
		},
		{
		0x5256,
		0xade5
		},
		{
		0x525a,
		0xd0e7
		},
		{
		0x525b,
		0xade8
		},
		{
		0x525c,
		0xade6
		},
		{
		0x525d,
		0xade9
		},
		{
		0x525e,
		0xd0e9
		},
		{
		0x525f,
		0xd0ea
		},
		{
		0x5261,
		0xd0e6
		},
		{
		0x5262,
		0xd0ec
		},
		{
		0x5269,
		0xb3d1
		},
		{
		0x526a,
		0xb0c5
		},
		{
		0x526b,
		0xd469
		},
		{
		0x526c,
		0xd46b
		},
		{
		0x526d,
		0xd46a
		},
		{
		0x526e,
		0xd46c
		},
		{
		0x526f,
		0xb0c6
		},
		{
		0x5272,
		0xb3ce
		},
		{
		0x5274,
		0xb3cf
		},
		{
		0x5275,
		0xb3d0
		},
		{
		0x5277,
		0xb6d0
		},
		{
		0x5278,
		0xdcc7
		},
		{
		0x527a,
		0xdcc6
		},
		{
		0x527b,
		0xdcc8
		},
		{
		0x527c,
		0xdcc9
		},
		{
		0x527d,
		0xb6d1
		},
		{
		0x527f,
		0xb6cf
		},
		{
		0x5280,
		0xe141
		},
		{
		0x5281,
		0xe142
		},
		{
		0x5282,
		0xb9bb
		},
		{
		0x5283,
		0xb9ba
		},
		{
		0x5284,
		0xe35a
		},
		{
		0x5287,
		0xbc40
		},
		{
		0x5288,
		0xbc41
		},
		{
		0x5289,
		0xbc42
		},
		{
		0x528a,
		0xbc44
		},
		{
		0x528b,
		0xe4f2
		},
		{
		0x528c,
		0xe4f3
		},
		{
		0x528d,
		0xbc43
		},
		{
		0x5291,
		0xbeaf
		},
		{
		0x5293,
		0xbeb0
		},
		{
		0x5296,
		0xf1ed
		},
		{
		0x5297,
		0xf5c3
		},
		{
		0x5298,
		0xf5c2
		},
		{
		0x5299,
		0xf7d1
		},
		{
		0x529b,
		0xa44f
		},
		{
		0x529f,
		0xa55c
		},
		{
		0x52a0,
		0xa55b
		},
		{
		0x52a3,
		0xa648
		},
		{
		0x52a6,
		0xc9c0
		},
		{
		0x52a9,
		0xa755
		},
		{
		0x52aa,
		0xa756
		},
		{
		0x52ab,
		0xa754
		},
		{
		0x52ac,
		0xa757
		},
		{
		0x52ad,
		0xca6f
		},
		{
		0x52ae,
		0xca70
		},
		{
		0x52bb,
		0xa8f1
		},
		{
		0x52bc,
		0xcbd5
		},
		{
		0x52be,
		0xa8f0
		},
		{
		0x52c0,
		0xcdf2
		},
		{
		0x52c1,
		0xab6c
		},
		{
		0x52c2,
		0xcdf3
		},
		{
		0x52c3,
		0xab6b
		},
		{
		0x52c7,
		0xab69
		},
		{
		0x52c9,
		0xab6a
		},
		{
		0x52cd,
		0xd0ed
		},
		{
		0x52d2,
		0xb0c7
		},
		{
		0x52d3,
		0xd46e
		},
		{
		0x52d5,
		0xb0ca
		},
		{
		0x52d6,
		0xd46d
		},
		{
		0x52d7,
		0xb1e5
		},
		{
		0x52d8,
		0xb0c9
		},
		{
		0x52d9,
		0xb0c8
		},
		{
		0x52db,
		0xb3d4
		},
		{
		0x52dd,
		0xb3d3
		},
		{
		0x52de,
		0xb3d2
		},
		{
		0x52df,
		0xb6d2
		},
		{
		0x52e2,
		0xb6d5
		},
		{
		0x52e3,
		0xb6d6
		},
		{
		0x52e4,
		0xb6d4
		},
		{
		0x52e6,
		0xb6d3
		},
		{
		0x52e9,
		0xe143
		},
		{
		0x52eb,
		0xe144
		},
		{
		0x52ef,
		0xe4f5
		},
		{
		0x52f0,
		0xbc45
		},
		{
		0x52f1,
		0xe4f4
		},
		{
		0x52f3,
		0xbeb1
		},
		{
		0x52f4,
		0xecbf
		},
		{
		0x52f5,
		0xc079
		},
		{
		0x52f7,
		0xf1ee
		},
		{
		0x52f8,
		0xc455
		},
		{
		0x52fa,
		0xa463
		},
		{
		0x52fb,
		0xa4c3
		},
		{
		0x52fc,
		0xc956
		},
		{
		0x52fe,
		0xa4c4
		},
		{
		0x52ff,
		0xa4c5
		},
		{
		0x5305,
		0xa55d
		},
		{
		0x5306,
		0xa55e
		},
		{
		0x5308,
		0xa649
		},
		{
		0x5309,
		0xca71
		},
		{
		0x530a,
		0xcbd6
		},
		{
		0x530b,
		0xcbd7
		},
		{
		0x530d,
		0xab6d
		},
		{
		0x530e,
		0xd0ee
		},
		{
		0x530f,
		0xb0cc
		},
		{
		0x5310,
		0xb0cb
		},
		{
		0x5311,
		0xd863
		},
		{
		0x5312,
		0xd862
		},
		{
		0x5315,
		0xa450
		},
		{
		0x5316,
		0xa4c6
		},
		{
		0x5317,
		0xa55f
		},
		{
		0x5319,
		0xb0cd
		},
		{
		0x531a,
		0xc943
		},
		{
		0x531c,
		0xc96c
		},
		{
		0x531d,
		0xa560
		},
		{
		0x531f,
		0xc9c2
		},
		{
		0x5320,
		0xa64b
		},
		{
		0x5321,
		0xa64a
		},
		{
		0x5322,
		0xc9c1
		},
		{
		0x5323,
		0xa758
		},
		{
		0x532a,
		0xadea
		},
		{
		0x532d,
		0xd46f
		},
		{
		0x532f,
		0xb6d7
		},
		{
		0x5330,
		0xe145
		},
		{
		0x5331,
		0xb9bc
		},
		{
		0x5334,
		0xe8fa
		},
		{
		0x5337,
		0xf3fd
		},
		{
		0x5339,
		0xa4c7
		},
		{
		0x533c,
		0xcbd8
		},
		{
		0x533d,
		0xcdf4
		},
		{
		0x533e,
		0xb0d0
		},
		{
		0x533f,
		0xb0ce
		},
		{
		0x5340,
		0xb0cf
		},
		{
		0x5341,
		0xa451
		},
		{
		0x5343,
		0xa464
		},
		{
		0x5344,
		0xa2cd
		},
		{
		0x5345,
		0xa4ca
		},
		{
		0x5347,
		0xa4c9
		},
		{
		0x5348,
		0xa4c8
		},
		{
		0x5349,
		0xa563
		},
		{
		0x534a,
		0xa562
		},
		{
		0x534c,
		0xc96d
		},
		{
		0x534d,
		0xc9c3
		},
		{
		0x5351,
		0xa8f5
		},
		{
		0x5352,
		0xa8f2
		},
		{
		0x5353,
		0xa8f4
		},
		{
		0x5354,
		0xa8f3
		},
		{
		0x5357,
		0xab6e
		},
		{
		0x535a,
		0xb3d5
		},
		{
		0x535c,
		0xa452
		},
		{
		0x535e,
		0xa4cb
		},
		{
		0x5360,
		0xa565
		},
		{
		0x5361,
		0xa564
		},
		{
		0x5363,
		0xca72
		},
		{
		0x5366,
		0xa8f6
		},
		{
		0x536c,
		0xc957
		},
		{
		0x536e,
		0xa567
		},
		{
		0x536f,
		0xa566
		},
		{
		0x5370,
		0xa64c
		},
		{
		0x5371,
		0xa64d
		},
		{
		0x5372,
		0xca73
		},
		{
		0x5373,
		0xa759
		},
		{
		0x5375,
		0xa75a
		},
		{
		0x5377,
		0xa8f7
		},
		{
		0x5378,
		0xa8f8
		},
		{
		0x5379,
		0xa8f9
		},
		{
		0x537b,
		0xab6f
		},
		{
		0x537c,
		0xcdf5
		},
		{
		0x537f,
		0xadeb
		},
		{
		0x5382,
		0xc944
		},
		{
		0x5384,
		0xa4cc
		},
		{
		0x538a,
		0xc9c4
		},
		{
		0x538e,
		0xca74
		},
		{
		0x538f,
		0xca75
		},
		{
		0x5392,
		0xcbd9
		},
		{
		0x5394,
		0xcbda
		},
		{
		0x5396,
		0xcdf7
		},
		{
		0x5397,
		0xcdf6
		},
		{
		0x5398,
		0xcdf9
		},
		{
		0x5399,
		0xcdf8
		},
		{
		0x539a,
		0xab70
		},
		{
		0x539c,
		0xd470
		},
		{
		0x539d,
		0xaded
		},
		{
		0x539e,
		0xd0ef
		},
		{
		0x539f,
		0xadec
		},
		{
		0x53a4,
		0xd864
		},
		{
		0x53a5,
		0xb3d6
		},
		{
		0x53a7,
		0xd865
		},
		{
		0x53ac,
		0xe146
		},
		{
		0x53ad,
		0xb9bd
		},
		{
		0x53b2,
		0xbc46
		},
		{
		0x53b4,
		0xf1ef
		},
		{
		0x53b9,
		0xc958
		},
		{
		0x53bb,
		0xa568
		},
		{
		0x53c3,
		0xb0d1
		},
		{
		0x53c8,
		0xa453
		},
		{
		0x53c9,
		0xa465
		},
		{
		0x53ca,
		0xa4ce
		},
		{
		0x53cb,
		0xa4cd
		},
		{
		0x53cd,
		0xa4cf
		},
		{
		0x53d4,
		0xa8fb
		},
		{
		0x53d6,
		0xa8fa
		},
		{
		0x53d7,
		0xa8fc
		},
		{
		0x53db,
		0xab71
		},
		{
		0x53df,
		0xadee
		},
		{
		0x53e1,
		0xe8fb
		},
		{
		0x53e2,
		0xc24f
		},
		{
		0x53e3,
		0xa466
		},
		{
		0x53e4,
		0xa56a
		},
		{
		0x53e5,
		0xa579
		},
		{
		0x53e6,
		0xa574
		},
		{
		0x53e8,
		0xa56f
		},
		{
		0x53e9,
		0xa56e
		},
		{
		0x53ea,
		0xa575
		},
		{
		0x53eb,
		0xa573
		},
		{
		0x53ec,
		0xa56c
		},
		{
		0x53ed,
		0xa57a
		},
		{
		0x53ee,
		0xa56d
		},
		{
		0x53ef,
		0xa569
		},
		{
		0x53f0,
		0xa578
		},
		{
		0x53f1,
		0xa577
		},
		{
		0x53f2,
		0xa576
		},
		{
		0x53f3,
		0xa56b
		},
		{
		0x53f5,
		0xa572
		},
		{
		0x53f8,
		0xa571
		},
		{
		0x53fb,
		0xa57b
		},
		{
		0x53fc,
		0xa570
		},
		{
		0x5401,
		0xa653
		},
		{
		0x5403,
		0xa659
		},
		{
		0x5404,
		0xa655
		},
		{
		0x5406,
		0xa65b
		},
		{
		0x5407,
		0xc9c5
		},
		{
		0x5408,
		0xa658
		},
		{
		0x5409,
		0xa64e
		},
		{
		0x540a,
		0xa651
		},
		{
		0x540b,
		0xa654
		},
		{
		0x540c,
		0xa650
		},
		{
		0x540d,
		0xa657
		},
		{
		0x540e,
		0xa65a
		},
		{
		0x540f,
		0xa64f
		},
		{
		0x5410,
		0xa652
		},
		{
		0x5411,
		0xa656
		},
		{
		0x5412,
		0xa65c
		},
		{
		0x5418,
		0xca7e
		},
		{
		0x5419,
		0xca7b
		},
		{
		0x541b,
		0xa767
		},
		{
		0x541c,
		0xca7c
		},
		{
		0x541d,
		0xa75b
		},
		{
		0x541e,
		0xa75d
		},
		{
		0x541f,
		0xa775
		},
		{
		0x5420,
		0xa770
		},
		{
		0x5424,
		0xcaa5
		},
		{
		0x5425,
		0xca7d
		},
		{
		0x5426,
		0xa75f
		},
		{
		0x5427,
		0xa761
		},
		{
		0x5428,
		0xcaa4
		},
		{
		0x5429,
		0xa768
		},
		{
		0x542a,
		0xca78
		},
		{
		0x542b,
		0xa774
		},
		{
		0x542c,
		0xa776
		},
		{
		0x542d,
		0xa75c
		},
		{
		0x542e,
		0xa76d
		},
		{
		0x5430,
		0xca76
		},
		{
		0x5431,
		0xa773
		},
		{
		0x5433,
		0xa764
		},
		{
		0x5435,
		0xa76e
		},
		{
		0x5436,
		0xa76f
		},
		{
		0x5437,
		0xca77
		},
		{
		0x5438,
		0xa76c
		},
		{
		0x5439,
		0xa76a
		},
		{
		0x543b,
		0xa76b
		},
		{
		0x543c,
		0xa771
		},
		{
		0x543d,
		0xcaa1
		},
		{
		0x543e,
		0xa75e
		},
		{
		0x5440,
		0xa772
		},
		{
		0x5441,
		0xcaa3
		},
		{
		0x5442,
		0xa766
		},
		{
		0x5443,
		0xa763
		},
		{
		0x5445,
		0xca7a
		},
		{
		0x5446,
		0xa762
		},
		{
		0x5447,
		0xcaa6
		},
		{
		0x5448,
		0xa765
		},
		{
		0x544a,
		0xa769
		},
		{
		0x544e,
		0xa760
		},
		{
		0x544f,
		0xcaa2
		},
		{
		0x5454,
		0xca79
		},
		{
		0x5460,
		0xcbeb
		},
		{
		0x5461,
		0xcbea
		},
		{
		0x5462,
		0xa94f
		},
		{
		0x5463,
		0xcbed
		},
		{
		0x5464,
		0xcbef
		},
		{
		0x5465,
		0xcbe4
		},
		{
		0x5466,
		0xcbe7
		},
		{
		0x5467,
		0xcbee
		},
		{
		0x5468,
		0xa950
		},
		{
		0x546b,
		0xcbe1
		},
		{
		0x546c,
		0xcbe5
		},
		{
		0x546f,
		0xcbe9
		},
		{
		0x5470,
		0xce49
		},
		{
		0x5471,
		0xa94b
		},
		{
		0x5472,
		0xce4d
		},
		{
		0x5473,
		0xa8fd
		},
		{
		0x5474,
		0xcbe6
		},
		{
		0x5475,
		0xa8fe
		},
		{
		0x5476,
		0xa94c
		},
		{
		0x5477,
		0xa945
		},
		{
		0x5478,
		0xa941
		},
		{
		0x547a,
		0xcbe2
		},
		{
		0x547b,
		0xa944
		},
		{
		0x547c,
		0xa949
		},
		{
		0x547d,
		0xa952
		},
		{
		0x547e,
		0xcbe3
		},
		{
		0x547f,
		0xcbdc
		},
		{
		0x5480,
		0xa943
		},
		{
		0x5481,
		0xcbdd
		},
		{
		0x5482,
		0xcbdf
		},
		{
		0x5484,
		0xa946
		},
		{
		0x5486,
		0xa948
		},
		{
		0x5487,
		0xcbdb
		},
		{
		0x5488,
		0xcbe0
		},
		{
		0x548b,
		0xa951
		},
		{
		0x548c,
		0xa94d
		},
		{
		0x548d,
		0xcbe8
		},
		{
		0x548e,
		0xa953
		},
		{
		0x5490,
		0xa94a
		},
		{
		0x5491,
		0xcbde
		},
		{
		0x5492,
		0xa947
		},
		{
		0x5495,
		0xa942
		},
		{
		0x5496,
		0xa940
		},
		{
		0x5498,
		0xcbec
		},
		{
		0x549a,
		0xa94e
		},
		{
		0x54a0,
		0xce48
		},
		{
		0x54a1,
		0xcdfb
		},
		{
		0x54a2,
		0xce4b
		},
		{
		0x54a5,
		0xcdfd
		},
		{
		0x54a6,
		0xab78
		},
		{
		0x54a7,
		0xaba8
		},
		{
		0x54a8,
		0xab74
		},
		{
		0x54a9,
		0xaba7
		},
		{
		0x54aa,
		0xab7d
		},
		{
		0x54ab,
		0xaba4
		},
		{
		0x54ac,
		0xab72
		},
		{
		0x54ad,
		0xcdfc
		},
		{
		0x54ae,
		0xce43
		},
		{
		0x54af,
		0xaba3
		},
		{
		0x54b0,
		0xce4f
		},
		{
		0x54b1,
		0xaba5
		},
		{
		0x54b3,
		0xab79
		},
		{
		0x54b6,
		0xce45
		},
		{
		0x54b7,
		0xce42
		},
		{
		0x54b8,
		0xab77
		},
		{
		0x54ba,
		0xcdfa
		},
		{
		0x54bb,
		0xaba6
		},
		{
		0x54bc,
		0xce4a
		},
		{
		0x54bd,
		0xab7c
		},
		{
		0x54be,
		0xce4c
		},
		{
		0x54bf,
		0xaba9
		},
		{
		0x54c0,
		0xab73
		},
		{
		0x54c1,
		0xab7e
		},
		{
		0x54c2,
		0xab7b
		},
		{
		0x54c3,
		0xce40
		},
		{
		0x54c4,
		0xaba1
		},
		{
		0x54c5,
		0xce46
		},
		{
		0x54c6,
		0xce47
		},
		{
		0x54c7,
		0xab7a
		},
		{
		0x54c8,
		0xaba2
		},
		{
		0x54c9,
		0xab76
		},
		{
		0x54ce,
		0xab75
		},
		{
		0x54cf,
		0xcdfe
		},
		{
		0x54d6,
		0xce44
		},
		{
		0x54de,
		0xce4e
		},
		{
		0x54e0,
		0xd144
		},
		{
		0x54e1,
		0xadfb
		},
		{
		0x54e2,
		0xd0f1
		},
		{
		0x54e4,
		0xd0f6
		},
		{
		0x54e5,
		0xadf4
		},
		{
		0x54e6,
		0xae40
		},
		{
		0x54e7,
		0xd0f4
		},
		{
		0x54e8,
		0xadef
		},
		{
		0x54e9,
		0xadf9
		},
		{
		0x54ea,
		0xadfe
		},
		{
		0x54eb,
		0xd0fb
		},
		{
		0x54ed,
		0xadfa
		},
		{
		0x54ee,
		0xadfd
		},
		{
		0x54f1,
		0xd0fe
		},
		{
		0x54f2,
		0xadf5
		},
		{
		0x54f3,
		0xd0f5
		},
		{
		0x54f7,
		0xd142
		},
		{
		0x54f8,
		0xd143
		},
		{
		0x54fa,
		0xadf7
		},
		{
		0x54fb,
		0xd141
		},
		{
		0x54fc,
		0xadf3
		},
		{
		0x54fd,
		0xae43
		},
		{
		0x54ff,
		0xd0f8
		},
		{
		0x5501,
		0xadf1
		},
		{
		0x5503,
		0xd146
		},
		{
		0x5504,
		0xd0f9
		},
		{
		0x5505,
		0xd0fd
		},
		{
		0x5506,
		0xadf6
		},
		{
		0x5507,
		0xae42
		},
		{
		0x5508,
		0xd0fa
		},
		{
		0x5509,
		0xadfc
		},
		{
		0x550a,
		0xd140
		},
		{
		0x550b,
		0xd147
		},
		{
		0x550c,
		0xd4a1
		},
		{
		0x550e,
		0xd145
		},
		{
		0x550f,
		0xae44
		},
		{
		0x5510,
		0xadf0
		},
		{
		0x5511,
		0xd0fc
		},
		{
		0x5512,
		0xd0f3
		},
		{
		0x5514,
		0xadf8
		},
		{
		0x5517,
		0xd0f2
		},
		{
		0x551a,
		0xd0f7
		},
		{
		0x5526,
		0xd0f0
		},
		{
		0x5527,
		0xae41
		},
		{
		0x552a,
		0xd477
		},
		{
		0x552c,
		0xb0e4
		},
		{
		0x552d,
		0xd4a7
		},
		{
		0x552e,
		0xb0e2
		},
		{
		0x552f,
		0xb0df
		},
		{
		0x5530,
		0xd47c
		},
		{
		0x5531,
		0xb0db
		},
		{
		0x5532,
		0xd4a2
		},
		{
		0x5533,
		0xb0e6
		},
		{
		0x5534,
		0xd476
		},
		{
		0x5535,
		0xd47b
		},
		{
		0x5536,
		0xd47a
		},
		{
		0x5537,
		0xadf2
		},
		{
		0x5538,
		0xb0e1
		},
		{
		0x5539,
		0xd4a5
		},
		{
		0x553b,
		0xd4a8
		},
		{
		0x553c,
		0xd473
		},
		{
		0x553e,
		0xb3e8
		},
		{
		0x5540,
		0xd4a9
		},
		{
		0x5541,
		0xb0e7
		},
		{
		0x5543,
		0xb0d9
		},
		{
		0x5544,
		0xb0d6
		},
		{
		0x5545,
		0xd47e
		},
		{
		0x5546,
		0xb0d3
		},
		{
		0x5548,
		0xd4a6
		},
		{
		0x554a,
		0xb0da
		},
		{
		0x554b,
		0xd4aa
		},
		{
		0x554d,
		0xd474
		},
		{
		0x554e,
		0xd4a4
		},
		{
		0x554f,
		0xb0dd
		},
		{
		0x5550,
		0xd475
		},
		{
		0x5551,
		0xd478
		},
		{
		0x5552,
		0xd47d
		},
		{
		0x5555,
		0xb0de
		},
		{
		0x5556,
		0xb0dc
		},
		{
		0x5557,
		0xb0e8
		},
		{
		0x555c,
		0xb0e3
		},
		{
		0x555e,
		0xb0d7
		},
		{
		0x555f,
		0xb1d2
		},
		{
		0x5561,
		0xb0d8
		},
		{
		0x5562,
		0xd479
		},
		{
		0x5563,
		0xb0e5
		},
		{
		0x5564,
		0xb0e0
		},
		{
		0x5565,
		0xd4a3
		},
		{
		0x5566,
		0xb0d5
		},
		{
		0x556a,
		0xb0d4
		},
		{
		0x5575,
		0xd471
		},
		{
		0x5576,
		0xd472
		},
		{
		0x5577,
		0xd86a
		},
		{
		0x557b,
		0xb3d7
		},
		{
		0x557c,
		0xb3da
		},
		{
		0x557d,
		0xd875
		},
		{
		0x557e,
		0xb3ee
		},
		{
		0x557f,
		0xd878
		},
		{
		0x5580,
		0xb3d8
		},
		{
		0x5581,
		0xd871
		},
		{
		0x5582,
		0xb3de
		},
		{
		0x5583,
		0xb3e4
		},
		{
		0x5584,
		0xb5bd
		},
		{
		0x5587,
		0xb3e2
		},
		{
		0x5588,
		0xd86e
		},
		{
		0x5589,
		0xb3ef
		},
		{
		0x558a,
		0xb3db
		},
		{
		0x558b,
		0xb3e3
		},
		{
		0x558c,
		0xd876
		},
		{
		0x558d,
		0xdcd7
		},
		{
		0x558e,
		0xd87b
		},
		{
		0x558f,
		0xd86f
		},
		{
		0x5591,
		0xd866
		},
		{
		0x5592,
		0xd873
		},
		{
		0x5593,
		0xd86d
		},
		{
		0x5594,
		0xb3e1
		},
		{
		0x5595,
		0xd879
		},
		{
		0x5598,
		0xb3dd
		},
		{
		0x5599,
		0xb3f1
		},
		{
		0x559a,
		0xb3ea
		},
		{
		0x559c,
		0xb3df
		},
		{
		0x559d,
		0xb3dc
		},
		{
		0x559f,
		0xb3e7
		},
		{
		0x55a1,
		0xd87a
		},
		{
		0x55a2,
		0xd86c
		},
		{
		0x55a3,
		0xd872
		},
		{
		0x55a4,
		0xd874
		},
		{
		0x55a5,
		0xd868
		},
		{
		0x55a6,
		0xd877
		},
		{
		0x55a7,
		0xb3d9
		},
		{
		0x55a8,
		0xd867
		},
		{
		0x55aa,
		0xb3e0
		},
		{
		0x55ab,
		0xb3f0
		},
		{
		0x55ac,
		0xb3ec
		},
		{
		0x55ad,
		0xd869
		},
		{
		0x55ae,
		0xb3e6
		},
		{
		0x55b1,
		0xb3ed
		},
		{
		0x55b2,
		0xb3e9
		},
		{
		0x55b3,
		0xb3e5
		},
		{
		0x55b5,
		0xd870
		},
		{
		0x55bb,
		0xb3eb
		},
		{
		0x55bf,
		0xdcd5
		},
		{
		0x55c0,
		0xdcd1
		},
		{
		0x55c2,
		0xdce0
		},
		{
		0x55c3,
		0xdcca
		},
		{
		0x55c4,
		0xdcd3
		},
		{
		0x55c5,
		0xb6e5
		},
		{
		0x55c6,
		0xb6e6
		},
		{
		0x55c7,
		0xb6de
		},
		{
		0x55c8,
		0xdcdc
		},
		{
		0x55c9,
		0xb6e8
		},
		{
		0x55ca,
		0xdccf
		},
		{
		0x55cb,
		0xdcce
		},
		{
		0x55cc,
		0xdccc
		},
		{
		0x55cd,
		0xdcde
		},
		{
		0x55ce,
		0xb6dc
		},
		{
		0x55cf,
		0xdcd8
		},
		{
		0x55d0,
		0xdccd
		},
		{
		0x55d1,
		0xb6df
		},
		{
		0x55d2,
		0xdcd6
		},
		{
		0x55d3,
		0xb6da
		},
		{
		0x55d4,
		0xdcd2
		},
		{
		0x55d5,
		0xdcd9
		},
		{
		0x55d6,
		0xdcdb
		},
		{
		0x55d9,
		0xdcdf
		},
		{
		0x55da,
		0xb6e3
		},
		{
		0x55db,
		0xdccb
		},
		{
		0x55dc,
		0xb6dd
		},
		{
		0x55dd,
		0xdcd0
		},
		{
		0x55df,
		0xb6d8
		},
		{
		0x55e1,
		0xb6e4
		},
		{
		0x55e2,
		0xdcda
		},
		{
		0x55e3,
		0xb6e0
		},
		{
		0x55e4,
		0xb6e1
		},
		{
		0x55e5,
		0xb6e7
		},
		{
		0x55e6,
		0xb6db
		},
		{
		0x55e7,
		0xa25f
		},
		{
		0x55e8,
		0xb6d9
		},
		{
		0x55e9,
		0xdcd4
		},
		{
		0x55ef,
		0xb6e2
		},
		{
		0x55f2,
		0xdcdd
		},
		{
		0x55f6,
		0xb9cd
		},
		{
		0x55f7,
		0xb9c8
		},
		{
		0x55f9,
		0xe155
		},
		{
		0x55fa,
		0xe151
		},
		{
		0x55fc,
		0xe14b
		},
		{
		0x55fd,
		0xb9c2
		},
		{
		0x55fe,
		0xb9be
		},
		{
		0x55ff,
		0xe154
		},
		{
		0x5600,
		0xb9bf
		},
		{
		0x5601,
		0xe14e
		},
		{
		0x5602,
		0xe150
		},
		{
		0x5604,
		0xe153
		},
		{
		0x5606,
		0xb9c4
		},
		{
		0x5608,
		0xb9cb
		},
		{
		0x5609,
		0xb9c5
		},
		{
		0x560c,
		0xe149
		},
		{
		0x560d,
		0xb9c6
		},
		{
		0x560e,
		0xb9c7
		},
		{
		0x560f,
		0xe14c
		},
		{
		0x5610,
		0xb9cc
		},
		{
		0x5612,
		0xe14a
		},
		{
		0x5613,
		0xe14f
		},
		{
		0x5614,
		0xb9c3
		},
		{
		0x5615,
		0xe148
		},
		{
		0x5616,
		0xb9c9
		},
		{
		0x5617,
		0xb9c1
		},
		{
		0x561b,
		0xb9c0
		},
		{
		0x561c,
		0xe14d
		},
		{
		0x561d,
		0xe152
		},
		{
		0x561f,
		0xb9ca
		},
		{
		0x5627,
		0xe147
		},
		{
		0x5629,
		0xbc4d
		},
		{
		0x562a,
		0xe547
		},
		{
		0x562c,
		0xe544
		},
		{
		0x562e,
		0xbc47
		},
		{
		0x562f,
		0xbc53
		},
		{
		0x5630,
		0xbc54
		},
		{
		0x5632,
		0xbc4a
		},
		{
		0x5633,
		0xe542
		},
		{
		0x5634,
		0xbc4c
		},
		{
		0x5635,
		0xe4f9
		},
		{
		0x5636,
		0xbc52
		},
		{
		0x5638,
		0xe546
		},
		{
		0x5639,
		0xbc49
		},
		{
		0x563a,
		0xe548
		},
		{
		0x563b,
		0xbc48
		},
		{
		0x563d,
		0xe543
		},
		{
		0x563e,
		0xe545
		},
		{
		0x563f,
		0xbc4b
		},
		{
		0x5640,
		0xe541
		},
		{
		0x5641,
		0xe4fa
		},
		{
		0x5642,
		0xe4f7
		},
		{
		0x5645,
		0xd86b
		},
		{
		0x5646,
		0xe4fd
		},
		{
		0x5648,
		0xe4f6
		},
		{
		0x5649,
		0xe4fc
		},
		{
		0x564a,
		0xe4fb
		},
		{
		0x564c,
		0xe4f8
		},
		{
		0x564e,
		0xbc4f
		},
		{
		0x5653,
		0xbc4e
		},
		{
		0x5657,
		0xbc50
		},
		{
		0x5658,
		0xe4fe
		},
		{
		0x5659,
		0xbeb2
		},
		{
		0x565a,
		0xe540
		},
		{
		0x565e,
		0xe945
		},
		{
		0x5660,
		0xe8fd
		},
		{
		0x5662,
		0xbebe
		},
		{
		0x5663,
		0xe942
		},
		{
		0x5664,
		0xbeb6
		},
		{
		0x5665,
		0xbeba
		},
		{
		0x5666,
		0xe941
		},
		{
		0x5668,
		0xbeb9
		},
		{
		0x5669,
		0xbeb5
		},
		{
		0x566a,
		0xbeb8
		},
		{
		0x566b,
		0xbeb3
		},
		{
		0x566c,
		0xbebd
		},
		{
		0x566d,
		0xe943
		},
		{
		0x566e,
		0xe8fe
		},
		{
		0x566f,
		0xbebc
		},
		{
		0x5670,
		0xe8fc
		},
		{
		0x5671,
		0xbebb
		},
		{
		0x5672,
		0xe944
		},
		{
		0x5673,
		0xe940
		},
		{
		0x5674,
		0xbc51
		},
		{
		0x5676,
		0xbebf
		},
		{
		0x5677,
		0xe946
		},
		{
		0x5678,
		0xbeb7
		},
		{
		0x5679,
		0xbeb4
		},
		{
		0x567e,
		0xecc6
		},
		{
		0x567f,
		0xecc8
		},
		{
		0x5680,
		0xc07b
		},
		{
		0x5681,
		0xecc9
		},
		{
		0x5682,
		0xecc7
		},
		{
		0x5683,
		0xecc5
		},
		{
		0x5684,
		0xecc4
		},
		{
		0x5685,
		0xc07d
		},
		{
		0x5686,
		0xecc3
		},
		{
		0x5687,
		0xc07e
		},
		{
		0x568c,
		0xecc1
		},
		{
		0x568d,
		0xecc2
		},
		{
		0x568e,
		0xc07a
		},
		{
		0x568f,
		0xc0a1
		},
		{
		0x5690,
		0xc07c
		},
		{
		0x5693,
		0xecc0
		},
		{
		0x5695,
		0xc250
		},
		{
		0x5697,
		0xefbc
		},
		{
		0x5698,
		0xefba
		},
		{
		0x5699,
		0xefbf
		},
		{
		0x569a,
		0xefbd
		},
		{
		0x569c,
		0xefbb
		},
		{
		0x569d,
		0xefbe
		},
		{
		0x56a5,
		0xc360
		},
		{
		0x56a6,
		0xf1f2
		},
		{
		0x56a7,
		0xf1f3
		},
		{
		0x56a8,
		0xc456
		},
		{
		0x56aa,
		0xf1f4
		},
		{
		0x56ab,
		0xf1f0
		},
		{
		0x56ac,
		0xf1f5
		},
		{
		0x56ad,
		0xf1f1
		},
		{
		0x56ae,
		0xc251
		},
		{
		0x56b2,
		0xf3fe
		},
		{
		0x56b3,
		0xf441
		},
		{
		0x56b4,
		0xc459
		},
		{
		0x56b5,
		0xf440
		},
		{
		0x56b6,
		0xc458
		},
		{
		0x56b7,
		0xc457
		},
		{
		0x56bc,
		0xc45a
		},
		{
		0x56bd,
		0xf5c5
		},
		{
		0x56be,
		0xf5c6
		},
		{
		0x56c0,
		0xc4da
		},
		{
		0x56c1,
		0xc4d9
		},
		{
		0x56c2,
		0xc4db
		},
		{
		0x56c3,
		0xf5c4
		},
		{
		0x56c5,
		0xf6d8
		},
		{
		0x56c6,
		0xf6d7
		},
		{
		0x56c8,
		0xc56d
		},
		{
		0x56c9,
		0xc56f
		},
		{
		0x56ca,
		0xc56e
		},
		{
		0x56cb,
		0xf6d9
		},
		{
		0x56cc,
		0xc5c8
		},
		{
		0x56cd,
		0xf8a6
		},
		{
		0x56d1,
		0xc5f1
		},
		{
		0x56d3,
		0xf8a5
		},
		{
		0x56d4,
		0xf8ee
		},
		{
		0x56d7,
		0xc949
		},
		{
		0x56da,
		0xa57d
		},
		{
		0x56db,
		0xa57c
		},
		{
		0x56dd,
		0xa65f
		},
		{
		0x56de,
		0xa65e
		},
		{
		0x56df,
		0xc9c7
		},
		{
		0x56e0,
		0xa65d
		},
		{
		0x56e1,
		0xc9c6
		},
		{
		0x56e4,
		0xa779
		},
		{
		0x56e5,
		0xcaa9
		},
		{
		0x56e7,
		0xcaa8
		},
		{
		0x56ea,
		0xa777
		},
		{
		0x56eb,
		0xa77a
		},
		{
		0x56ee,
		0xcaa7
		},
		{
		0x56f0,
		0xa778
		},
		{
		0x56f7,
		0xcbf0
		},
		{
		0x56f9,
		0xcbf1
		},
		{
		0x56fa,
		0xa954
		},
		{
		0x56ff,
		0xabaa
		},
		{
		0x5701,
		0xd148
		},
		{
		0x5702,
		0xd149
		},
		{
		0x5703,
		0xae45
		},
		{
		0x5704,
		0xae46
		},
		{
		0x5707,
		0xd4ac
		},
		{
		0x5708,
		0xb0e9
		},
		{
		0x5709,
		0xb0eb
		},
		{
		0x570a,
		0xd4ab
		},
		{
		0x570b,
		0xb0ea
		},
		{
		0x570c,
		0xd87c
		},
		{
		0x570d,
		0xb3f2
		},
		{
		0x5712,
		0xb6e9
		},
		{
		0x5713,
		0xb6ea
		},
		{
		0x5714,
		0xdce1
		},
		{
		0x5716,
		0xb9cf
		},
		{
		0x5718,
		0xb9ce
		},
		{
		0x571a,
		0xe549
		},
		{
		0x571b,
		0xe948
		},
		{
		0x571c,
		0xe947
		},
		{
		0x571e,
		0xf96b
		},
		{
		0x571f,
		0xa467
		},
		{
		0x5720,
		0xc959
		},
		{
		0x5722,
		0xc96e
		},
		{
		0x5723,
		0xc96f
		},
		{
		0x5728,
		0xa662
		},
		{
		0x5729,
		0xa666
		},
		{
		0x572a,
		0xc9c9
		},
		{
		0x572c,
		0xa664
		},
		{
		0x572d,
		0xa663
		},
		{
		0x572e,
		0xc9c8
		},
		{
		0x572f,
		0xa665
		},
		{
		0x5730,
		0xa661
		},
		{
		0x5733,
		0xa660
		},
		{
		0x5734,
		0xc9ca
		},
		{
		0x573b,
		0xa7a6
		},
		{
		0x573e,
		0xa7a3
		},
		{
		0x5740,
		0xa77d
		},
		{
		0x5741,
		0xcaaa
		},
		{
		0x5745,
		0xcaab
		},
		{
		0x5747,
		0xa7a1
		},
		{
		0x5749,
		0xcaad
		},
		{
		0x574a,
		0xa77b
		},
		{
		0x574b,
		0xcaae
		},
		{
		0x574c,
		0xcaac
		},
		{
		0x574d,
		0xa77e
		},
		{
		0x574e,
		0xa7a2
		},
		{
		0x574f,
		0xa7a5
		},
		{
		0x5750,
		0xa7a4
		},
		{
		0x5751,
		0xa77c
		},
		{
		0x5752,
		0xcaaf
		},
		{
		0x5761,
		0xa959
		},
		{
		0x5762,
		0xcbfe
		},
		{
		0x5764,
		0xa95b
		},
		{
		0x5766,
		0xa95a
		},
		{
		0x5768,
		0xcc40
		},
		{
		0x5769,
		0xa958
		},
		{
		0x576a,
		0xa957
		},
		{
		0x576b,
		0xcbf5
		},
		{
		0x576d,
		0xcbf4
		},
		{
		0x576f,
		0xcbf2
		},
		{
		0x5770,
		0xcbf7
		},
		{
		0x5771,
		0xcbf6
		},
		{
		0x5772,
		0xcbf3
		},
		{
		0x5773,
		0xcbfc
		},
		{
		0x5774,
		0xcbfd
		},
		{
		0x5775,
		0xcbfa
		},
		{
		0x5776,
		0xcbf8
		},
		{
		0x5777,
		0xa956
		},
		{
		0x577b,
		0xcbfb
		},
		{
		0x577c,
		0xa95c
		},
		{
		0x577d,
		0xcc41
		},
		{
		0x5780,
		0xcbf9
		},
		{
		0x5782,
		0xabab
		},
		{
		0x5783,
		0xa955
		},
		{
		0x578b,
		0xabac
		},
		{
		0x578c,
		0xce54
		},
		{
		0x578f,
		0xce5a
		},
		{
		0x5793,
		0xabb2
		},
		{
		0x5794,
		0xce58
		},
		{
		0x5795,
		0xce5e
		},
		{
		0x5797,
		0xce55
		},
		{
		0x5798,
		0xce59
		},
		{
		0x5799,
		0xce5b
		},
		{
		0x579a,
		0xce5d
		},
		{
		0x579b,
		0xce57
		},
		{
		0x579d,
		0xce56
		},
		{
		0x579e,
		0xce51
		},
		{
		0x579f,
		0xce52
		},
		{
		0x57a0,
		0xabad
		},
		{
		0x57a2,
		0xabaf
		},
		{
		0x57a3,
		0xabae
		},
		{
		0x57a4,
		0xce53
		},
		{
		0x57a5,
		0xce5c
		},
		{
		0x57ae,
		0xabb1
		},
		{
		0x57b5,
		0xce50
		},
		{
		0x57b6,
		0xd153
		},
		{
		0x57b8,
		0xd152
		},
		{
		0x57b9,
		0xd157
		},
		{
		0x57ba,
		0xd14e
		},
		{
		0x57bc,
		0xd151
		},
		{
		0x57bd,
		0xd150
		},
		{
		0x57bf,
		0xd154
		},
		{
		0x57c1,
		0xd158
		},
		{
		0x57c2,
		0xae47
		},
		{
		0x57c3,
		0xae4a
		},
		{
		0x57c6,
		0xd14f
		},
		{
		0x57c7,
		0xd155
		},
		{
		0x57cb,
		0xae49
		},
		{
		0x57cc,
		0xd14a
		},
		{
		0x57ce,
		0xabb0
		},
		{
		0x57cf,
		0xd4ba
		},
		{
		0x57d0,
		0xd156
		},
		{
		0x57d2,
		0xd14d
		},
		{
		0x57d4,
		0xae48
		},
		{
		0x57d5,
		0xd14c
		},
		{
		0x57dc,
		0xd4b1
		},
		{
		0x57df,
		0xb0ec
		},
		{
		0x57e0,
		0xb0f0
		},
		{
		0x57e1,
		0xd4c1
		},
		{
		0x57e2,
		0xd4af
		},
		{
		0x57e3,
		0xd4bd
		},
		{
		0x57e4,
		0xb0f1
		},
		{
		0x57e5,
		0xd4bf
		},
		{
		0x57e7,
		0xd4c5
		},
		{
		0x57e9,
		0xd4c9
		},
		{
		0x57ec,
		0xd4c0
		},
		{
		0x57ed,
		0xd4b4
		},
		{
		0x57ee,
		0xd4bc
		},
		{
		0x57f0,
		0xd4ca
		},
		{
		0x57f1,
		0xd4c8
		},
		{
		0x57f2,
		0xd4be
		},
		{
		0x57f3,
		0xd4b9
		},
		{
		0x57f4,
		0xd4b2
		},
		{
		0x57f5,
		0xd8a6
		},
		{
		0x57f6,
		0xd4b0
		},
		{
		0x57f7,
		0xb0f5
		},
		{
		0x57f8,
		0xd4b7
		},
		{
		0x57f9,
		0xb0f6
		},
		{
		0x57fa,
		0xb0f2
		},
		{
		0x57fb,
		0xd4ad
		},
		{
		0x57fc,
		0xd4c3
		},
		{
		0x57fd,
		0xd4b5
		},
		{
		0x5800,
		0xd4b3
		},
		{
		0x5801,
		0xd4c6
		},
		{
		0x5802,
		0xb0f3
		},
		{
		0x5804,
		0xd4cc
		},
		{
		0x5805,
		0xb0ed
		},
		{
		0x5806,
		0xb0ef
		},
		{
		0x5807,
		0xd4bb
		},
		{
		0x5808,
		0xd4b6
		},
		{
		0x5809,
		0xae4b
		},
		{
		0x580a,
		0xb0ee
		},
		{
		0x580b,
		0xd4b8
		},
		{
		0x580c,
		0xd4c7
		},
		{
		0x580d,
		0xd4cb
		},
		{
		0x580e,
		0xd4c2
		},
		{
		0x5810,
		0xd4c4
		},
		{
		0x5814,
		0xd4ae
		},
		{
		0x5819,
		0xd8a1
		},
		{
		0x581b,
		0xd8aa
		},
		{
		0x581c,
		0xd8a9
		},
		{
		0x581d,
		0xb3fa
		},
		{
		0x581e,
		0xd8a2
		},
		{
		0x5820,
		0xb3fb
		},
		{
		0x5821,
		0xb3f9
		},
		{
		0x5823,
		0xd8a4
		},
		{
		0x5824,
		0xb3f6
		},
		{
		0x5825,
		0xd8a8
		},
		{
		0x5827,
		0xd8a3
		},
		{
		0x5828,
		0xd8a5
		},
		{
		0x5829,
		0xd87d
		},
		{
		0x582a,
		0xb3f4
		},
		{
		0x582c,
		0xd8b2
		},
		{
		0x582d,
		0xd8b1
		},
		{
		0x582e,
		0xd8ae
		},
		{
		0x582f,
		0xb3f3
		},
		{
		0x5830,
		0xb3f7
		},
		{
		0x5831,
		0xb3f8
		},
		{
		0x5832,
		0xd14b
		},
		{
		0x5833,
		0xd8ab
		},
		{
		0x5834,
		0xb3f5
		},
		{
		0x5835,
		0xb0f4
		},
		{
		0x5836,
		0xd8ad
		},
		{
		0x5837,
		0xd87e
		},
		{
		0x5838,
		0xd8b0
		},
		{
		0x5839,
		0xd8af
		},
		{
		0x583b,
		0xd8b3
		},
		{
		0x583d,
		0xdcef
		},
		{
		0x583f,
		0xd8ac
		},
		{
		0x5848,
		0xd8a7
		},
		{
		0x5849,
		0xdce7
		},
		{
		0x584a,
		0xb6f4
		},
		{
		0x584b,
		0xb6f7
		},
		{
		0x584c,
		0xb6f2
		},
		{
		0x584d,
		0xdce6
		},
		{
		0x584e,
		0xdcea
		},
		{
		0x584f,
		0xdce5
		},
		{
		0x5851,
		0xb6ec
		},
		{
		0x5852,
		0xb6f6
		},
		{
		0x5853,
		0xdce2
		},
		{
		0x5854,
		0xb6f0
		},
		{
		0x5855,
		0xdce9
		},
		{
		0x5857,
		0xb6ee
		},
		{
		0x5858,
		0xb6ed
		},
		{
		0x5859,
		0xdcec
		},
		{
		0x585a,
		0xb6ef
		},
		{
		0x585b,
		0xdcee
		},
		{
		0x585d,
		0xdceb
		},
		{
		0x585e,
		0xb6eb
		},
		{
		0x5862,
		0xb6f5
		},
		{
		0x5863,
		0xdcf0
		},
		{
		0x5864,
		0xdce4
		},
		{
		0x5865,
		0xdced
		},
		{
		0x5868,
		0xdce3
		},
		{
		0x586b,
		0xb6f1
		},
		{
		0x586d,
		0xb6f3
		},
		{
		0x586f,
		0xdce8
		},
		{
		0x5871,
		0xdcf1
		},
		{
		0x5874,
		0xe15d
		},
		{
		0x5875,
		0xb9d0
		},
		{
		0x5876,
		0xe163
		},
		{
		0x5879,
		0xb9d5
		},
		{
		0x587a,
		0xe15f
		},
		{
		0x587b,
		0xe166
		},
		{
		0x587c,
		0xe157
		},
		{
		0x587d,
		0xb9d7
		},
		{
		0x587e,
		0xb9d1
		},
		{
		0x587f,
		0xe15c
		},
		{
		0x5880,
		0xbc55
		},
		{
		0x5881,
		0xe15b
		},
		{
		0x5882,
		0xe164
		},
		{
		0x5883,
		0xb9d2
		},
		{
		0x5885,
		0xb9d6
		},
		{
		0x5886,
		0xe15a
		},
		{
		0x5887,
		0xe160
		},
		{
		0x5888,
		0xe165
		},
		{
		0x5889,
		0xe156
		},
		{
		0x588a,
		0xb9d4
		},
		{
		0x588b,
		0xe15e
		},
		{
		0x588e,
		0xe162
		},
		{
		0x588f,
		0xe168
		},
		{
		0x5890,
		0xe158
		},
		{
		0x5891,
		0xe161
		},
		{
		0x5893,
		0xb9d3
		},
		{
		0x5894,
		0xe167
		},
		{
		0x5898,
		0xe159
		},
		{
		0x589c,
		0xbc59
		},
		{
		0x589d,
		0xe54b
		},
		{
		0x589e,
		0xbc57
		},
		{
		0x589f,
		0xbc56
		},
		{
		0x58a0,
		0xe54d
		},
		{
		0x58a1,
		0xe552
		},
		{
		0x58a3,
		0xe54e
		},
		{
		0x58a5,
		0xe551
		},
		{
		0x58a6,
		0xbc5c
		},
		{
		0x58a8,
		0xbea5
		},
		{
		0x58a9,
		0xbc5b
		},
		{
		0x58ab,
		0xe54a
		},
		{
		0x58ac,
		0xe550
		},
		{
		0x58ae,
		0xbc5a
		},
		{
		0x58af,
		0xe54f
		},
		{
		0x58b1,
		0xe54c
		},
		{
		0x58b3,
		0xbc58
		},
		{
		0x58ba,
		0xe94d
		},
		{
		0x58bc,
		0xe94f
		},
		{
		0x58bd,
		0xe94a
		},
		{
		0x58be,
		0xbec1
		},
		{
		0x58bf,
		0xe94c
		},
		{
		0x58c1,
		0xbec0
		},
		{
		0x58c2,
		0xe94e
		},
		{
		0x58c5,
		0xbec3
		},
		{
		0x58c6,
		0xe950
		},
		{
		0x58c7,
		0xbec2
		},
		{
		0x58c8,
		0xe949
		},
		{
		0x58c9,
		0xe94b
		},
		{
		0x58ce,
		0xc0a5
		},
		{
		0x58cf,
		0xeccc
		},
		{
		0x58d1,
		0xc0a4
		},
		{
		0x58d2,
		0xeccd
		},
		{
		0x58d3,
		0xc0a3
		},
		{
		0x58d4,
		0xeccb
		},
		{
		0x58d5,
		0xc0a2
		},
		{
		0x58d6,
		0xecca
		},
		{
		0x58d8,
		0xc253
		},
		{
		0x58d9,
		0xc252
		},
		{
		0x58da,
		0xf1f6
		},
		{
		0x58db,
		0xf1f8
		},
		{
		0x58dd,
		0xf1f7
		},
		{
		0x58de,
		0xc361
		},
		{
		0x58df,
		0xc362
		},
		{
		0x58e2,
		0xc363
		},
		{
		0x58e3,
		0xf442
		},
		{
		0x58e4,
		0xc45b
		},
		{
		0x58e7,
		0xf7d3
		},
		{
		0x58e8,
		0xf7d2
		},
		{
		0x58e9,
		0xc5f2
		},
		{
		0x58eb,
		0xa468
		},
		{
		0x58ec,
		0xa4d0
		},
		{
		0x58ef,
		0xa7a7
		},
		{
		0x58f4,
		0xce5f
		},
		{
		0x58f9,
		0xb3fc
		},
		{
		0x58fa,
		0xb3fd
		},
		{
		0x58fc,
		0xdcf2
		},
		{
		0x58fd,
		0xb9d8
		},
		{
		0x58fe,
		0xe169
		},
		{
		0x58ff,
		0xe553
		},
		{
		0x5903,
		0xc95a
		},
		{
		0x5906,
		0xcab0
		},
		{
		0x590c,
		0xcc42
		},
		{
		0x590d,
		0xce60
		},
		{
		0x590e,
		0xd159
		},
		{
		0x590f,
		0xae4c
		},
		{
		0x5912,
		0xf1f9
		},
		{
		0x5914,
		0xc4dc
		},
		{
		0x5915,
		0xa469
		},
		{
		0x5916,
		0xa57e
		},
		{
		0x5917,
		0xc970
		},
		{
		0x5919,
		0xa667
		},
		{
		0x591a,
		0xa668
		},
		{
		0x591c,
		0xa95d
		},
		{
		0x5920,
		0xb0f7
		},
		{
		0x5922,
		0xb9da
		},
		{
		0x5924,
		0xb9db
		},
		{
		0x5925,
		0xb9d9
		},
		{
		0x5927,
		0xa46a
		},
		{
		0x5929,
		0xa4d1
		},
		{
		0x592a,
		0xa4d3
		},
		{
		0x592b,
		0xa4d2
		},
		{
		0x592c,
		0xc95b
		},
		{
		0x592d,
		0xa4d4
		},
		{
		0x592e,
		0xa5a1
		},
		{
		0x592f,
		0xc971
		},
		{
		0x5931,
		0xa5a2
		},
		{
		0x5937,
		0xa669
		},
		{
		0x5938,
		0xa66a
		},
		{
		0x593c,
		0xc9cb
		},
		{
		0x593e,
		0xa7a8
		},
		{
		0x5940,
		0xcab1
		},
		{
		0x5944,
		0xa961
		},
		{
		0x5945,
		0xcc43
		},
		{
		0x5947,
		0xa95f
		},
		{
		0x5948,
		0xa960
		},
		{
		0x5949,
		0xa95e
		},
		{
		0x594a,
		0xd15a
		},
		{
		0x594e,
		0xabb6
		},
		{
		0x594f,
		0xabb5
		},
		{
		0x5950,
		0xabb7
		},
		{
		0x5951,
		0xabb4
		},
		{
		0x5953,
		0xce61
		},
		{
		0x5954,
		0xa962
		},
		{
		0x5955,
		0xabb3
		},
		{
		0x5957,
		0xae4d
		},
		{
		0x5958,
		0xae4e
		},
		{
		0x595a,
		0xae4f
		},
		{
		0x595c,
		0xd4cd
		},
		{
		0x5960,
		0xb3fe
		},
		{
		0x5961,
		0xd8b4
		},
		{
		0x5962,
		0xb0f8
		},
		{
		0x5967,
		0xb6f8
		},
		{
		0x5969,
		0xb9dd
		},
		{
		0x596a,
		0xb9dc
		},
		{
		0x596b,
		0xe16a
		},
		{
		0x596d,
		0xbc5d
		},
		{
		0x596e,
		0xbec4
		},
		{
		0x5970,
		0xefc0
		},
		{
		0x5971,
		0xf6da
		},
		{
		0x5972,
		0xf7d4
		},
		{
		0x5973,
		0xa46b
		},
		{
		0x5974,
		0xa5a3
		},
		{
		0x5976,
		0xa5a4
		},
		{
		0x5977,
		0xc9d1
		},
		{
		0x5978,
		0xa66c
		},
		{
		0x5979,
		0xa66f
		},
		{
		0x597b,
		0xc9cf
		},
		{
		0x597c,
		0xc9cd
		},
		{
		0x597d,
		0xa66e
		},
		{
		0x597e,
		0xc9d0
		},
		{
		0x597f,
		0xc9d2
		},
		{
		0x5980,
		0xc9cc
		},
		{
		0x5981,
		0xa671
		},
		{
		0x5982,
		0xa670
		},
		{
		0x5983,
		0xa66d
		},
		{
		0x5984,
		0xa66b
		},
		{
		0x5985,
		0xc9ce
		},
		{
		0x598a,
		0xa7b3
		},
		{
		0x598d,
		0xa7b0
		},
		{
		0x598e,
		0xcab6
		},
		{
		0x598f,
		0xcab9
		},
		{
		0x5990,
		0xcab8
		},
		{
		0x5992,
		0xa7aa
		},
		{
		0x5993,
		0xa7b2
		},
		{
		0x5996,
		0xa7af
		},
		{
		0x5997,
		0xcab5
		},
		{
		0x5998,
		0xcab3
		},
		{
		0x5999,
		0xa7ae
		},
		{
		0x599d,
		0xa7a9
		},
		{
		0x599e,
		0xa7ac
		},
		{
		0x59a0,
		0xcab4
		},
		{
		0x59a1,
		0xcabb
		},
		{
		0x59a2,
		0xcab7
		},
		{
		0x59a3,
		0xa7ad
		},
		{
		0x59a4,
		0xa7b1
		},
		{
		0x59a5,
		0xa7b4
		},
		{
		0x59a6,
		0xcab2
		},
		{
		0x59a7,
		0xcaba
		},
		{
		0x59a8,
		0xa7ab
		},
		{
		0x59ae,
		0xa967
		},
		{
		0x59af,
		0xa96f
		},
		{
		0x59b1,
		0xcc4f
		},
		{
		0x59b2,
		0xcc48
		},
		{
		0x59b3,
		0xa970
		},
		{
		0x59b4,
		0xcc53
		},
		{
		0x59b5,
		0xcc44
		},
		{
		0x59b6,
		0xcc4b
		},
		{
		0x59b9,
		0xa966
		},
		{
		0x59ba,
		0xcc45
		},
		{
		0x59bb,
		0xa964
		},
		{
		0x59bc,
		0xcc4c
		},
		{
		0x59bd,
		0xcc50
		},
		{
		0x59be,
		0xa963
		},
		{
		0x59c0,
		0xcc51
		},
		{
		0x59c1,
		0xcc4a
		},
		{
		0x59c3,
		0xcc4d
		},
		{
		0x59c5,
		0xa972
		},
		{
		0x59c6,
		0xa969
		},
		{
		0x59c7,
		0xcc54
		},
		{
		0x59c8,
		0xcc52
		},
		{
		0x59ca,
		0xa96e
		},
		{
		0x59cb,
		0xa96c
		},
		{
		0x59cc,
		0xcc49
		},
		{
		0x59cd,
		0xa96b
		},
		{
		0x59ce,
		0xcc47
		},
		{
		0x59cf,
		0xcc46
		},
		{
		0x59d0,
		0xa96a
		},
		{
		0x59d1,
		0xa968
		},
		{
		0x59d2,
		0xa971
		},
		{
		0x59d3,
		0xa96d
		},
		{
		0x59d4,
		0xa965
		},
		{
		0x59d6,
		0xcc4e
		},
		{
		0x59d8,
		0xabb9
		},
		{
		0x59da,
		0xabc0
		},
		{
		0x59db,
		0xce6f
		},
		{
		0x59dc,
		0xabb8
		},
		{
		0x59dd,
		0xce67
		},
		{
		0x59de,
		0xce63
		},
		{
		0x59e0,
		0xce73
		},
		{
		0x59e1,
		0xce62
		},
		{
		0x59e3,
		0xabbb
		},
		{
		0x59e4,
		0xce6c
		},
		{
		0x59e5,
		0xabbe
		},
		{
		0x59e6,
		0xabc1
		},
		{
		0x59e8,
		0xabbc
		},
		{
		0x59e9,
		0xce70
		},
		{
		0x59ea,
		0xabbf
		},
		{
		0x59ec,
		0xae56
		},
		{
		0x59ed,
		0xce76
		},
		{
		0x59ee,
		0xce64
		},
		{
		0x59f1,
		0xce66
		},
		{
		0x59f2,
		0xce6d
		},
		{
		0x59f3,
		0xce71
		},
		{
		0x59f4,
		0xce75
		},
		{
		0x59f5,
		0xce72
		},
		{
		0x59f6,
		0xce6b
		},
		{
		0x59f7,
		0xce6e
		},
		{
		0x59fa,
		0xce68
		},
		{
		0x59fb,
		0xabc3
		},
		{
		0x59fc,
		0xce6a
		},
		{
		0x59fd,
		0xce69
		},
		{
		0x59fe,
		0xce74
		},
		{
		0x59ff,
		0xabba
		},
		{
		0x5a00,
		0xce65
		},
		{
		0x5a01,
		0xabc2
		},
		{
		0x5a03,
		0xabbd
		},
		{
		0x5a09,
		0xae5c
		},
		{
		0x5a0a,
		0xd162
		},
		{
		0x5a0c,
		0xae5b
		},
		{
		0x5a0f,
		0xd160
		},
		{
		0x5a11,
		0xae50
		},
		{
		0x5a13,
		0xae55
		},
		{
		0x5a15,
		0xd15f
		},
		{
		0x5a16,
		0xd15c
		},
		{
		0x5a17,
		0xd161
		},
		{
		0x5a18,
		0xae51
		},
		{
		0x5a19,
		0xd15b
		},
		{
		0x5a1b,
		0xae54
		},
		{
		0x5a1c,
		0xae52
		},
		{
		0x5a1e,
		0xd163
		},
		{
		0x5a1f,
		0xae53
		},
		{
		0x5a20,
		0xae57
		},
		{
		0x5a23,
		0xae58
		},
		{
		0x5a25,
		0xae5a
		},
		{
		0x5a29,
		0xae59
		},
		{
		0x5a2d,
		0xd15d
		},
		{
		0x5a2e,
		0xd15e
		},
		{
		0x5a33,
		0xd164
		},
		{
		0x5a35,
		0xd4d4
		},
		{
		0x5a36,
		0xb0f9
		},
		{
		0x5a37,
		0xd8c2
		},
		{
		0x5a38,
		0xd4d3
		},
		{
		0x5a39,
		0xd4e6
		},
		{
		0x5a3c,
		0xb140
		},
		{
		0x5a3e,
		0xd4e4
		},
		{
		0x5a40,
		0xb0fe
		},
		{
		0x5a41,
		0xb0fa
		},
		{
		0x5a42,
		0xd4ed
		},
		{
		0x5a43,
		0xd4dd
		},
		{
		0x5a44,
		0xd4e0
		},
		{
		0x5a46,
		0xb143
		},
		{
		0x5a47,
		0xd4ea
		},
		{
		0x5a48,
		0xd4e2
		},
		{
		0x5a49,
		0xb0fb
		},
		{
		0x5a4a,
		0xb144
		},
		{
		0x5a4c,
		0xd4e7
		},
		{
		0x5a4d,
		0xd4e5
		},
		{
		0x5a50,
		0xd4d6
		},
		{
		0x5a51,
		0xd4eb
		},
		{
		0x5a52,
		0xd4df
		},
		{
		0x5a53,
		0xd4da
		},
		{
		0x5a55,
		0xd4d0
		},
		{
		0x5a56,
		0xd4ec
		},
		{
		0x5a57,
		0xd4dc
		},
		{
		0x5a58,
		0xd4cf
		},
		{
		0x5a5a,
		0xb142
		},
		{
		0x5a5b,
		0xd4e1
		},
		{
		0x5a5c,
		0xd4ee
		},
		{
		0x5a5d,
		0xd4de
		},
		{
		0x5a5e,
		0xd4d2
		},
		{
		0x5a5f,
		0xd4d7
		},
		{
		0x5a60,
		0xd4ce
		},
		{
		0x5a62,
		0xb141
		},
		{
		0x5a64,
		0xd4db
		},
		{
		0x5a65,
		0xd4d8
		},
		{
		0x5a66,
		0xb0fc
		},
		{
		0x5a67,
		0xd4d1
		},
		{
		0x5a69,
		0xd4e9
		},
		{
		0x5a6a,
		0xb0fd
		},
		{
		0x5a6c,
		0xd4d9
		},
		{
		0x5a6d,
		0xd4d5
		},
		{
		0x5a70,
		0xd4e8
		},
		{
		0x5a77,
		0xb440
		},
		{
		0x5a78,
		0xd8bb
		},
		{
		0x5a7a,
		0xd8b8
		},
		{
		0x5a7b,
		0xd8c9
		},
		{
		0x5a7c,
		0xd8bd
		},
		{
		0x5a7d,
		0xd8ca
		},
		{
		0x5a7f,
		0xb442
		},
		{
		0x5a83,
		0xd8c6
		},
		{
		0x5a84,
		0xd8c3
		},
		{
		0x5a8a,
		0xd8c4
		},
		{
		0x5a8b,
		0xd8c7
		},
		{
		0x5a8c,
		0xd8cb
		},
		{
		0x5a8e,
		0xd4e3
		},
		{
		0x5a8f,
		0xd8cd
		},
		{
		0x5a90,
		0xdd47
		},
		{
		0x5a92,
		0xb443
		},
		{
		0x5a93,
		0xd8ce
		},
		{
		0x5a94,
		0xd8b6
		},
		{
		0x5a95,
		0xd8c0
		},
		{
		0x5a97,
		0xd8c5
		},
		{
		0x5a9a,
		0xb441
		},
		{
		0x5a9b,
		0xb444
		},
		{
		0x5a9c,
		0xd8cc
		},
		{
		0x5a9d,
		0xd8cf
		},
		{
		0x5a9e,
		0xd8ba
		},
		{
		0x5a9f,
		0xd8b7
		},
		{
		0x5aa2,
		0xd8b9
		},
		{
		0x5aa5,
		0xd8be
		},
		{
		0x5aa6,
		0xd8bc
		},
		{
		0x5aa7,
		0xb445
		},
		{
		0x5aa9,
		0xd8c8
		},
		{
		0x5aac,
		0xd8bf
		},
		{
		0x5aae,
		0xd8c1
		},
		{
		0x5aaf,
		0xd8b5
		},
		{
		0x5ab0,
		0xdcfa
		},
		{
		0x5ab1,
		0xdcf8
		},
		{
		0x5ab2,
		0xb742
		},
		{
		0x5ab3,
		0xb740
		},
		{
		0x5ab4,
		0xdd43
		},
		{
		0x5ab5,
		0xdcf9
		},
		{
		0x5ab6,
		0xdd44
		},
		{
		0x5ab7,
		0xdd40
		},
		{
		0x5ab8,
		0xdcf7
		},
		{
		0x5ab9,
		0xdd46
		},
		{
		0x5aba,
		0xdcf6
		},
		{
		0x5abb,
		0xdcfd
		},
		{
		0x5abc,
		0xb6fe
		},
		{
		0x5abd,
		0xb6fd
		},
		{
		0x5abe,
		0xb6fc
		},
		{
		0x5abf,
		0xdcfb
		},
		{
		0x5ac0,
		0xdd41
		},
		{
		0x5ac1,
		0xb6f9
		},
		{
		0x5ac2,
		0xb741
		},
		{
		0x5ac4,
		0xdcf4
		},
		{
		0x5ac6,
		0xdcfe
		},
		{
		0x5ac7,
		0xdcf3
		},
		{
		0x5ac8,
		0xdcfc
		},
		{
		0x5ac9,
		0xb6fa
		},
		{
		0x5aca,
		0xdd42
		},
		{
		0x5acb,
		0xdcf5
		},
		{
		0x5acc,
		0xb6fb
		},
		{
		0x5acd,
		0xdd45
		},
		{
		0x5ad5,
		0xe16e
		},
		{
		0x5ad6,
		0xb9e2
		},
		{
		0x5ad7,
		0xb9e1
		},
		{
		0x5ad8,
		0xb9e3
		},
		{
		0x5ad9,
		0xe17a
		},
		{
		0x5ada,
		0xe170
		},
		{
		0x5adb,
		0xe176
		},
		{
		0x5adc,
		0xe16b
		},
		{
		0x5add,
		0xe179
		},
		{
		0x5ade,
		0xe178
		},
		{
		0x5adf,
		0xe17c
		},
		{
		0x5ae0,
		0xe175
		},
		{
		0x5ae1,
		0xb9de
		},
		{
		0x5ae2,
		0xe174
		},
		{
		0x5ae3,
		0xb9e4
		},
		{
		0x5ae5,
		0xe16d
		},
		{
		0x5ae6,
		0xb9df
		},
		{
		0x5ae8,
		0xe17b
		},
		{
		0x5ae9,
		0xb9e0
		},
		{
		0x5aea,
		0xe16f
		},
		{
		0x5aeb,
		0xe172
		},
		{
		0x5aec,
		0xe177
		},
		{
		0x5aed,
		0xe171
		},
		{
		0x5aee,
		0xe16c
		},
		{
		0x5af3,
		0xe173
		},
		{
		0x5af4,
		0xe555
		},
		{
		0x5af5,
		0xbc61
		},
		{
		0x5af6,
		0xe558
		},
		{
		0x5af7,
		0xe557
		},
		{
		0x5af8,
		0xe55a
		},
		{
		0x5af9,
		0xe55c
		},
		{
		0x5afb,
		0xbc5f
		},
		{
		0x5afd,
		0xe556
		},
		{
		0x5aff,
		0xe554
		},
		{
		0x5b01,
		0xe55d
		},
		{
		0x5b02,
		0xe55b
		},
		{
		0x5b03,
		0xe559
		},
		{
		0x5b05,
		0xe55f
		},
		{
		0x5b07,
		0xe55e
		},
		{
		0x5b08,
		0xbc63
		},
		{
		0x5b09,
		0xbc5e
		},
		{
		0x5b0b,
		0xbc60
		},
		{
		0x5b0c,
		0xbc62
		},
		{
		0x5b0f,
		0xe560
		},
		{
		0x5b10,
		0xe957
		},
		{
		0x5b13,
		0xe956
		},
		{
		0x5b14,
		0xe955
		},
		{
		0x5b16,
		0xe958
		},
		{
		0x5b17,
		0xe951
		},
		{
		0x5b19,
		0xe952
		},
		{
		0x5b1a,
		0xe95a
		},
		{
		0x5b1b,
		0xe953
		},
		{
		0x5b1d,
		0xbec5
		},
		{
		0x5b1e,
		0xe95c
		},
		{
		0x5b20,
		0xe95b
		},
		{
		0x5b21,
		0xe954
		},
		{
		0x5b23,
		0xecd1
		},
		{
		0x5b24,
		0xc0a8
		},
		{
		0x5b25,
		0xeccf
		},
		{
		0x5b26,
		0xecd4
		},
		{
		0x5b27,
		0xecd3
		},
		{
		0x5b28,
		0xe959
		},
		{
		0x5b2a,
		0xc0a7
		},
		{
		0x5b2c,
		0xecd2
		},
		{
		0x5b2d,
		0xecce
		},
		{
		0x5b2e,
		0xecd6
		},
		{
		0x5b2f,
		0xecd5
		},
		{
		0x5b30,
		0xc0a6
		},
		{
		0x5b32,
		0xecd0
		},
		{
		0x5b34,
		0xbec6
		},
		{
		0x5b38,
		0xc254
		},
		{
		0x5b3c,
		0xefc1
		},
		{
		0x5b3d,
		0xf1fa
		},
		{
		0x5b3e,
		0xf1fb
		},
		{
		0x5b3f,
		0xf1fc
		},
		{
		0x5b40,
		0xc45c
		},
		{
		0x5b43,
		0xc45d
		},
		{
		0x5b45,
		0xf443
		},
		{
		0x5b47,
		0xf5c8
		},
		{
		0x5b48,
		0xf5c7
		},
		{
		0x5b4b,
		0xf6db
		},
		{
		0x5b4c,
		0xf6dc
		},
		{
		0x5b4d,
		0xf7d5
		},
		{
		0x5b4e,
		0xf8a7
		},
		{
		0x5b50,
		0xa46c
		},
		{
		0x5b51,
		0xa46d
		},
		{
		0x5b53,
		0xa46e
		},
		{
		0x5b54,
		0xa4d5
		},
		{
		0x5b55,
		0xa5a5
		},
		{
		0x5b56,
		0xc9d3
		},
		{
		0x5b57,
		0xa672
		},
		{
		0x5b58,
		0xa673
		},
		{
		0x5b5a,
		0xa7b7
		},
		{
		0x5b5b,
		0xa7b8
		},
		{
		0x5b5c,
		0xa7b6
		},
		{
		0x5b5d,
		0xa7b5
		},
		{
		0x5b5f,
		0xa973
		},
		{
		0x5b62,
		0xcc55
		},
		{
		0x5b63,
		0xa975
		},
		{
		0x5b64,
		0xa974
		},
		{
		0x5b65,
		0xcc56
		},
		{
		0x5b69,
		0xabc4
		},
		{
		0x5b6b,
		0xae5d
		},
		{
		0x5b6c,
		0xd165
		},
		{
		0x5b6e,
		0xd4f0
		},
		{
		0x5b70,
		0xb145
		},
		{
		0x5b71,
		0xb447
		},
		{
		0x5b72,
		0xd4ef
		},
		{
		0x5b73,
		0xb446
		},
		{
		0x5b75,
		0xb9e5
		},
		{
		0x5b77,
		0xe17d
		},
		{
		0x5b78,
		0xbec7
		},
		{
		0x5b7a,
		0xc0a9
		},
		{
		0x5b7b,
		0xecd7
		},
		{
		0x5b7d,
		0xc45e
		},
		{
		0x5b7f,
		0xc570
		},
		{
		0x5b81,
		0xc972
		},
		{
		0x5b83,
		0xa5a6
		},
		{
		0x5b84,
		0xc973
		},
		{
		0x5b85,
		0xa676
		},
		{
		0x5b87,
		0xa674
		},
		{
		0x5b88,
		0xa675
		},
		{
		0x5b89,
		0xa677
		},
		{
		0x5b8b,
		0xa7ba
		},
		{
		0x5b8c,
		0xa7b9
		},
		{
		0x5b8e,
		0xcabc
		},
		{
		0x5b8f,
		0xa7bb
		},
		{
		0x5b92,
		0xcabd
		},
		{
		0x5b93,
		0xcc57
		},
		{
		0x5b95,
		0xcc58
		},
		{
		0x5b97,
		0xa976
		},
		{
		0x5b98,
		0xa978
		},
		{
		0x5b99,
		0xa97a
		},
		{
		0x5b9a,
		0xa977
		},
		{
		0x5b9b,
		0xa97b
		},
		{
		0x5b9c,
		0xa979
		},
		{
		0x5ba2,
		0xabc8
		},
		{
		0x5ba3,
		0xabc5
		},
		{
		0x5ba4,
		0xabc7
		},
		{
		0x5ba5,
		0xabc9
		},
		{
		0x5ba6,
		0xabc6
		},
		{
		0x5ba7,
		0xd166
		},
		{
		0x5ba8,
		0xce77
		},
		{
		0x5bac,
		0xd168
		},
		{
		0x5bad,
		0xd167
		},
		{
		0x5bae,
		0xae63
		},
		{
		0x5bb0,
		0xae5f
		},
		{
		0x5bb3,
		0xae60
		},
		{
		0x5bb4,
		0xae62
		},
		{
		0x5bb5,
		0xae64
		},
		{
		0x5bb6,
		0xae61
		},
		{
		0x5bb8,
		0xae66
		},
		{
		0x5bb9,
		0xae65
		},
		{
		0x5bbf,
		0xb14a
		},
		{
		0x5bc0,
		0xd4f2
		},
		{
		0x5bc1,
		0xd4f1
		},
		{
		0x5bc2,
		0xb149
		},
		{
		0x5bc4,
		0xb148
		},
		{
		0x5bc5,
		0xb147
		},
		{
		0x5bc6,
		0xb14b
		},
		{
		0x5bc7,
		0xb146
		},
		{
		0x5bca,
		0xd8d5
		},
		{
		0x5bcb,
		0xd8d2
		},
		{
		0x5bcc,
		0xb449
		},
		{
		0x5bcd,
		0xd8d1
		},
		{
		0x5bce,
		0xd8d6
		},
		{
		0x5bd0,
		0xb44b
		},
		{
		0x5bd1,
		0xd8d4
		},
		{
		0x5bd2,
		0xb448
		},
		{
		0x5bd3,
		0xb44a
		},
		{
		0x5bd4,
		0xd8d3
		},
		{
		0x5bd6,
		0xdd48
		},
		{
		0x5bd8,
		0xdd49
		},
		{
		0x5bd9,
		0xdd4a
		},
		{
		0x5bde,
		0xb9e6
		},
		{
		0x5bdf,
		0xb9ee
		},
		{
		0x5be0,
		0xe17e
		},
		{
		0x5be1,
		0xb9e8
		},
		{
		0x5be2,
		0xb9ec
		},
		{
		0x5be3,
		0xe1a1
		},
		{
		0x5be4,
		0xb9ed
		},
		{
		0x5be5,
		0xb9e9
		},
		{
		0x5be6,
		0xb9ea
		},
		{
		0x5be7,
		0xb9e7
		},
		{
		0x5be8,
		0xb9eb
		},
		{
		0x5be9,
		0xbc66
		},
		{
		0x5bea,
		0xd8d0
		},
		{
		0x5beb,
		0xbc67
		},
		{
		0x5bec,
		0xbc65
		},
		{
		0x5bee,
		0xbc64
		},
		{
		0x5bef,
		0xe95d
		},
		{
		0x5bf0,
		0xbec8
		},
		{
		0x5bf1,
		0xecd8
		},
		{
		0x5bf2,
		0xecd9
		},
		{
		0x5bf5,
		0xc364
		},
		{
		0x5bf6,
		0xc45f
		},
		{
		0x5bf8,
		0xa46f
		},
		{
		0x5bfa,
		0xa678
		},
		{
		0x5c01,
		0xabca
		},
		{
		0x5c03,
		0xd169
		},
		{
		0x5c04,
		0xae67
		},
		{
		0x5c07,
		0xb14e
		},
		{
		0x5c08,
		0xb14d
		},
		{
		0x5c09,
		0xb14c
		},
		{
		0x5c0a,
		0xb44c
		},
		{
		0x5c0b,
		0xb44d
		},
		{
		0x5c0c,
		0xd8d7
		},
		{
		0x5c0d,
		0xb9ef
		},
		{
		0x5c0e,
		0xbec9
		},
		{
		0x5c0f,
		0xa470
		},
		{
		0x5c10,
		0xc95c
		},
		{
		0x5c11,
		0xa4d6
		},
		{
		0x5c12,
		0xc974
		},
		{
		0x5c15,
		0xc9d4
		},
		{
		0x5c16,
		0xa679
		},
		{
		0x5c1a,
		0xa97c
		},
		{
		0x5c1f,
		0xdd4b
		},
		{
		0x5c22,
		0xa471
		},
		{
		0x5c24,
		0xa4d7
		},
		{
		0x5c25,
		0xc9d5
		},
		{
		0x5c28,
		0xcabe
		},
		{
		0x5c2a,
		0xcabf
		},
		{
		0x5c2c,
		0xa7bc
		},
		{
		0x5c30,
		0xd8d8
		},
		{
		0x5c31,
		0xb44e
		},
		{
		0x5c33,
		0xdd4c
		},
		{
		0x5c37,
		0xc0aa
		},
		{
		0x5c38,
		0xa472
		},
		{
		0x5c39,
		0xa4a8
		},
		{
		0x5c3a,
		0xa4d8
		},
		{
		0x5c3b,
		0xc975
		},
		{
		0x5c3c,
		0xa5a7
		},
		{
		0x5c3e,
		0xa7c0
		},
		{
		0x5c3f,
		0xa7bf
		},
		{
		0x5c40,
		0xa7bd
		},
		{
		0x5c41,
		0xa7be
		},
		{
		0x5c44,
		0xcc59
		},
		{
		0x5c45,
		0xa97e
		},
		{
		0x5c46,
		0xa9a1
		},
		{
		0x5c47,
		0xcc5a
		},
		{
		0x5c48,
		0xa97d
		},
		{
		0x5c4b,
		0xabce
		},
		{
		0x5c4c,
		0xce78
		},
		{
		0x5c4d,
		0xabcd
		},
		{
		0x5c4e,
		0xabcb
		},
		{
		0x5c4f,
		0xabcc
		},
		{
		0x5c50,
		0xae6a
		},
		{
		0x5c51,
		0xae68
		},
		{
		0x5c54,
		0xd16b
		},
		{
		0x5c55,
		0xae69
		},
		{
		0x5c56,
		0xd16a
		},
		{
		0x5c58,
		0xae5e
		},
		{
		0x5c59,
		0xd4f3
		},
		{
		0x5c5c,
		0xb150
		},
		{
		0x5c5d,
		0xb151
		},
		{
		0x5c60,
		0xb14f
		},
		{
		0x5c62,
		0xb9f0
		},
		{
		0x5c63,
		0xe1a2
		},
		{
		0x5c64,
		0xbc68
		},
		{
		0x5c65,
		0xbc69
		},
		{
		0x5c67,
		0xe561
		},
		{
		0x5c68,
		0xc0ab
		},
		{
		0x5c69,
		0xefc2
		},
		{
		0x5c6a,
		0xefc3
		},
		{
		0x5c6c,
		0xc4dd
		},
		{
		0x5c6d,
		0xf8a8
		},
		{
		0x5c6e,
		0xc94b
		},
		{
		0x5c6f,
		0xa4d9
		},
		{
		0x5c71,
		0xa473
		},
		{
		0x5c73,
		0xc977
		},
		{
		0x5c74,
		0xc976
		},
		{
		0x5c79,
		0xa67a
		},
		{
		0x5c7a,
		0xc9d7
		},
		{
		0x5c7b,
		0xc9d8
		},
		{
		0x5c7c,
		0xc9d6
		},
		{
		0x5c7e,
		0xc9d9
		},
		{
		0x5c86,
		0xcac7
		},
		{
		0x5c88,
		0xcac2
		},
		{
		0x5c89,
		0xcac4
		},
		{
		0x5c8a,
		0xcac6
		},
		{
		0x5c8b,
		0xcac3
		},
		{
		0x5c8c,
		0xa7c4
		},
		{
		0x5c8d,
		0xcac0
		},
		{
		0x5c8f,
		0xcac1
		},
		{
		0x5c90,
		0xa7c1
		},
		{
		0x5c91,
		0xa7c2
		},
		{
		0x5c92,
		0xcac5
		},
		{
		0x5c93,
		0xcac8
		},
		{
		0x5c94,
		0xa7c3
		},
		{
		0x5c95,
		0xcac9
		},
		{
		0x5c9d,
		0xcc68
		},
		{
		0x5c9f,
		0xcc62
		},
		{
		0x5ca0,
		0xcc5d
		},
		{
		0x5ca1,
		0xa9a3
		},
		{
		0x5ca2,
		0xcc65
		},
		{
		0x5ca3,
		0xcc63
		},
		{
		0x5ca4,
		0xcc5c
		},
		{
		0x5ca5,
		0xcc69
		},
		{
		0x5ca6,
		0xcc6c
		},
		{
		0x5ca7,
		0xcc67
		},
		{
		0x5ca8,
		0xcc60
		},
		{
		0x5ca9,
		0xa9a5
		},
		{
		0x5caa,
		0xcc66
		},
		{
		0x5cab,
		0xa9a6
		},
		{
		0x5cac,
		0xcc61
		},
		{
		0x5cad,
		0xcc64
		},
		{
		0x5cae,
		0xcc5b
		},
		{
		0x5caf,
		0xcc5f
		},
		{
		0x5cb0,
		0xcc6b
		},
		{
		0x5cb1,
		0xa9a7
		},
		{
		0x5cb3,
		0xa9a8
		},
		{
		0x5cb5,
		0xcc5e
		},
		{
		0x5cb6,
		0xcc6a
		},
		{
		0x5cb7,
		0xa9a2
		},
		{
		0x5cb8,
		0xa9a4
		},
		{
		0x5cc6,
		0xceab
		},
		{
		0x5cc7,
		0xcea4
		},
		{
		0x5cc8,
		0xceaa
		},
		{
		0x5cc9,
		0xcea3
		},
		{
		0x5cca,
		0xcea5
		},
		{
		0x5ccb,
		0xce7d
		},
		{
		0x5ccc,
		0xce7b
		},
		{
		0x5cce,
		0xceac
		},
		{
		0x5ccf,
		0xcea9
		},
		{
		0x5cd0,
		0xce79
		},
		{
		0x5cd2,
		0xabd0
		},
		{
		0x5cd3,
		0xcea7
		},
		{
		0x5cd4,
		0xcea8
		},
		{
		0x5cd6,
		0xcea6
		},
		{
		0x5cd7,
		0xce7c
		},
		{
		0x5cd8,
		0xce7a
		},
		{
		0x5cd9,
		0xabcf
		},
		{
		0x5cda,
		0xcea2
		},
		{
		0x5cdb,
		0xce7e
		},
		{
		0x5cde,
		0xcea1
		},
		{
		0x5cdf,
		0xcead
		},
		{
		0x5ce8,
		0xae6f
		},
		{
		0x5cea,
		0xae6e
		},
		{
		0x5cec,
		0xd16c
		},
		{
		0x5ced,
		0xae6b
		},
		{
		0x5cee,
		0xd16e
		},
		{
		0x5cf0,
		0xae70
		},
		{
		0x5cf1,
		0xd16f
		},
		{
		0x5cf4,
		0xae73
		},
		{
		0x5cf6,
		0xae71
		},
		{
		0x5cf7,
		0xd170
		},
		{
		0x5cf8,
		0xceae
		},
		{
		0x5cf9,
		0xd172
		},
		{
		0x5cfb,
		0xae6d
		},
		{
		0x5cfd,
		0xae6c
		},
		{
		0x5cff,
		0xd16d
		},
		{
		0x5d00,
		0xd171
		},
		{
		0x5d01,
		0xae72
		},
		{
		0x5d06,
		0xb153
		},
		{
		0x5d07,
		0xb152
		},
		{
		0x5d0b,
		0xd4f5
		},
		{
		0x5d0c,
		0xd4f9
		},
		{
		0x5d0d,
		0xd4fb
		},
		{
		0x5d0e,
		0xb154
		},
		{
		0x5d0f,
		0xd4fe
		},
		{
		0x5d11,
		0xb158
		},
		{
		0x5d12,
		0xd541
		},
		{
		0x5d14,
		0xb15a
		},
		{
		0x5d16,
		0xb156
		},
		{
		0x5d17,
		0xb15e
		},
		{
		0x5d19,
		0xb15b
		},
		{
		0x5d1a,
		0xd4f7
		},
		{
		0x5d1b,
		0xb155
		},
		{
		0x5d1d,
		0xd4f6
		},
		{
		0x5d1e,
		0xd4f4
		},
		{
		0x5d1f,
		0xd543
		},
		{
		0x5d20,
		0xd4f8
		},
		{
		0x5d22,
		0xb157
		},
		{
		0x5d23,
		0xd542
		},
		{
		0x5d24,
		0xb15c
		},
		{
		0x5d25,
		0xd4fd
		},
		{
		0x5d26,
		0xd4fc
		},
		{
		0x5d27,
		0xb15d
		},
		{
		0x5d28,
		0xd4fa
		},
		{
		0x5d29,
		0xb159
		},
		{
		0x5d2e,
		0xd544
		},
		{
		0x5d30,
		0xd540
		},
		{
		0x5d31,
		0xd8e7
		},
		{
		0x5d32,
		0xd8ee
		},
		{
		0x5d33,
		0xd8e3
		},
		{
		0x5d34,
		0xb451
		},
		{
		0x5d35,
		0xd8df
		},
		{
		0x5d36,
		0xd8ef
		},
		{
		0x5d37,
		0xd8d9
		},
		{
		0x5d38,
		0xd8ec
		},
		{
		0x5d39,
		0xd8ea
		},
		{
		0x5d3a,
		0xd8e4
		},
		{
		0x5d3c,
		0xd8ed
		},
		{
		0x5d3d,
		0xd8e6
		},
		{
		0x5d3f,
		0xd8de
		},
		{
		0x5d40,
		0xd8f0
		},
		{
		0x5d41,
		0xd8dc
		},
		{
		0x5d42,
		0xd8e9
		},
		{
		0x5d43,
		0xd8da
		},
		{
		0x5d45,
		0xd8f1
		},
		{
		0x5d47,
		0xb452
		},
		{
		0x5d49,
		0xd8eb
		},
		{
		0x5d4a,
		0xdd4f
		},
		{
		0x5d4b,
		0xd8dd
		},
		{
		0x5d4c,
		0xb44f
		},
		{
		0x5d4e,
		0xd8e1
		},
		{
		0x5d50,
		0xb450
		},
		{
		0x5d51,
		0xd8e0
		},
		{
		0x5d52,
		0xd8e5
		},
		{
		0x5d55,
		0xd8e2
		},
		{
		0x5d59,
		0xd8e8
		},
		{
		0x5d5e,
		0xdd53
		},
		{
		0x5d62,
		0xdd56
		},
		{
		0x5d63,
		0xdd4e
		},
		{
		0x5d65,
		0xdd50
		},
		{
		0x5d67,
		0xdd55
		},
		{
		0x5d68,
		0xdd54
		},
		{
		0x5d69,
		0xb743
		},
		{
		0x5d6b,
		0xd8db
		},
		{
		0x5d6c,
		0xdd52
		},
		{
		0x5d6f,
		0xb744
		},
		{
		0x5d71,
		0xdd4d
		},
		{
		0x5d72,
		0xdd51
		},
		{
		0x5d77,
		0xe1a9
		},
		{
		0x5d79,
		0xe1b0
		},
		{
		0x5d7a,
		0xe1a7
		},
		{
		0x5d7c,
		0xe1ae
		},
		{
		0x5d7d,
		0xe1a5
		},
		{
		0x5d7e,
		0xe1ad
		},
		{
		0x5d7f,
		0xe1b1
		},
		{
		0x5d80,
		0xe1a4
		},
		{
		0x5d81,
		0xe1a8
		},
		{
		0x5d82,
		0xe1a3
		},
		{
		0x5d84,
		0xb9f1
		},
		{
		0x5d86,
		0xe1a6
		},
		{
		0x5d87,
		0xb9f2
		},
		{
		0x5d88,
		0xe1ac
		},
		{
		0x5d89,
		0xe1ab
		},
		{
		0x5d8a,
		0xe1aa
		},
		{
		0x5d8d,
		0xe1af
		},
		{
		0x5d92,
		0xe565
		},
		{
		0x5d93,
		0xe567
		},
		{
		0x5d94,
		0xbc6b
		},
		{
		0x5d95,
		0xe568
		},
		{
		0x5d97,
		0xe563
		},
		{
		0x5d99,
		0xe562
		},
		{
		0x5d9a,
		0xe56c
		},
		{
		0x5d9c,
		0xe56a
		},
		{
		0x5d9d,
		0xbc6a
		},
		{
		0x5d9e,
		0xe56d
		},
		{
		0x5d9f,
		0xe564
		},
		{
		0x5da0,
		0xe569
		},
		{
		0x5da1,
		0xe56b
		},
		{
		0x5da2,
		0xe566
		},
		{
		0x5da7,
		0xe961
		},
		{
		0x5da8,
		0xe966
		},
		{
		0x5da9,
		0xe960
		},
		{
		0x5daa,
		0xe965
		},
		{
		0x5dac,
		0xe95e
		},
		{
		0x5dad,
		0xe968
		},
		{
		0x5dae,
		0xe964
		},
		{
		0x5daf,
		0xe969
		},
		{
		0x5db0,
		0xe963
		},
		{
		0x5db1,
		0xe95f
		},
		{
		0x5db2,
		0xe967
		},
		{
		0x5db4,
		0xe96a
		},
		{
		0x5db5,
		0xe962
		},
		{
		0x5db7,
		0xecda
		},
		{
		0x5db8,
		0xc0af
		},
		{
		0x5dba,
		0xc0ad
		},
		{
		0x5dbc,
		0xc0ac
		},
		{
		0x5dbd,
		0xc0ae
		},
		{
		0x5dc0,
		0xefc4
		},
		{
		0x5dc2,
		0xf172
		},
		{
		0x5dc3,
		0xf1fd
		},
		{
		0x5dc6,
		0xf444
		},
		{
		0x5dc7,
		0xf445
		},
		{
		0x5dc9,
		0xc460
		},
		{
		0x5dcb,
		0xf5c9
		},
		{
		0x5dcd,
		0xc4de
		},
		{
		0x5dcf,
		0xf5ca
		},
		{
		0x5dd1,
		0xf6de
		},
		{
		0x5dd2,
		0xc572
		},
		{
		0x5dd4,
		0xc571
		},
		{
		0x5dd5,
		0xf6dd
		},
		{
		0x5dd6,
		0xc5c9
		},
		{
		0x5dd8,
		0xf7d6
		},
		{
		0x5ddd,
		0xa474
		},
		{
		0x5dde,
		0xa67b
		},
		{
		0x5ddf,
		0xc9da
		},
		{
		0x5de0,
		0xcaca
		},
		{
		0x5de1,
		0xa8b5
		},
		{
		0x5de2,
		0xb15f
		},
		{
		0x5de5,
		0xa475
		},
		{
		0x5de6,
		0xa5aa
		},
		{
		0x5de7,
		0xa5a9
		},
		{
		0x5de8,
		0xa5a8
		},
		{
		0x5deb,
		0xa7c5
		},
		{
		0x5dee,
		0xae74
		},
		{
		0x5df0,
		0xdd57
		},
		{
		0x5df1,
		0xa476
		},
		{
		0x5df2,
		0xa477
		},
		{
		0x5df3,
		0xa478
		},
		{
		0x5df4,
		0xa4da
		},
		{
		0x5df7,
		0xabd1
		},
		{
		0x5df9,
		0xceaf
		},
		{
		0x5dfd,
		0xb453
		},
		{
		0x5dfe,
		0xa479
		},
		{
		0x5dff,
		0xc95d
		},
		{
		0x5e02,
		0xa5ab
		},
		{
		0x5e03,
		0xa5ac
		},
		{
		0x5e04,
		0xc978
		},
		{
		0x5e06,
		0xa67c
		},
		{
		0x5e0a,
		0xcacb
		},
		{
		0x5e0c,
		0xa7c6
		},
		{
		0x5e0e,
		0xcacc
		},
		{
		0x5e11,
		0xa9ae
		},
		{
		0x5e14,
		0xcc6e
		},
		{
		0x5e15,
		0xa9ac
		},
		{
		0x5e16,
		0xa9ab
		},
		{
		0x5e17,
		0xcc6d
		},
		{
		0x5e18,
		0xa9a9
		},
		{
		0x5e19,
		0xcc6f
		},
		{
		0x5e1a,
		0xa9aa
		},
		{
		0x5e1b,
		0xa9ad
		},
		{
		0x5e1d,
		0xabd2
		},
		{
		0x5e1f,
		0xabd4
		},
		{
		0x5e20,
		0xceb3
		},
		{
		0x5e21,
		0xceb0
		},
		{
		0x5e22,
		0xceb1
		},
		{
		0x5e23,
		0xceb2
		},
		{
		0x5e24,
		0xceb4
		},
		{
		0x5e25,
		0xabd3
		},
		{
		0x5e28,
		0xd174
		},
		{
		0x5e29,
		0xd173
		},
		{
		0x5e2b,
		0xae76
		},
		{
		0x5e2d,
		0xae75
		},
		{
		0x5e33,
		0xb162
		},
		{
		0x5e34,
		0xd546
		},
		{
		0x5e36,
		0xb161
		},
		{
		0x5e37,
		0xb163
		},
		{
		0x5e38,
		0xb160
		},
		{
		0x5e3d,
		0xb455
		},
		{
		0x5e3e,
		0xd545
		},
		{
		0x5e40,
		0xb456
		},
		{
		0x5e41,
		0xd8f3
		},
		{
		0x5e43,
		0xb457
		},
		{
		0x5e44,
		0xd8f2
		},
		{
		0x5e45,
		0xb454
		},
		{
		0x5e4a,
		0xdd5a
		},
		{
		0x5e4b,
		0xdd5c
		},
		{
		0x5e4c,
		0xb745
		},
		{
		0x5e4d,
		0xdd5b
		},
		{
		0x5e4e,
		0xdd59
		},
		{
		0x5e4f,
		0xdd58
		},
		{
		0x5e53,
		0xe1b4
		},
		{
		0x5e54,
		0xb9f7
		},
		{
		0x5e55,
		0xb9f5
		},
		{
		0x5e57,
		0xb9f6
		},
		{
		0x5e58,
		0xe1b2
		},
		{
		0x5e59,
		0xe1b3
		},
		{
		0x5e5b,
		0xb9f3
		},
		{
		0x5e5c,
		0xe571
		},
		{
		0x5e5d,
		0xe56f
		},
		{
		0x5e5f,
		0xbc6d
		},
		{
		0x5e60,
		0xe570
		},
		{
		0x5e61,
		0xbc6e
		},
		{
		0x5e62,
		0xbc6c
		},
		{
		0x5e63,
		0xb9f4
		},
		{
		0x5e66,
		0xe96d
		},
		{
		0x5e67,
		0xe96b
		},
		{
		0x5e68,
		0xe96c
		},
		{
		0x5e69,
		0xe56e
		},
		{
		0x5e6a,
		0xecdc
		},
		{
		0x5e6b,
		0xc0b0
		},
		{
		0x5e6c,
		0xecdb
		},
		{
		0x5e6d,
		0xefc5
		},
		{
		0x5e6e,
		0xefc6
		},
		{
		0x5e6f,
		0xe96e
		},
		{
		0x5e70,
		0xf1fe
		},
		{
		0x5e72,
		0xa47a
		},
		{
		0x5e73,
		0xa5ad
		},
		{
		0x5e74,
		0xa67e
		},
		{
		0x5e75,
		0xc9db
		},
		{
		0x5e76,
		0xa67d
		},
		{
		0x5e78,
		0xa9af
		},
		{
		0x5e79,
		0xb746
		},
		{
		0x5e7b,
		0xa4db
		},
		{
		0x5e7c,
		0xa5ae
		},
		{
		0x5e7d,
		0xabd5
		},
		{
		0x5e7e,
		0xb458
		},
		{
		0x5e80,
		0xc979
		},
		{
		0x5e82,
		0xc97a
		},
		{
		0x5e84,
		0xc9dc
		},
		{
		0x5e87,
		0xa7c8
		},
		{
		0x5e88,
		0xcad0
		},
		{
		0x5e89,
		0xcace
		},
		{
		0x5e8a,
		0xa7c9
		},
		{
		0x5e8b,
		0xcacd
		},
		{
		0x5e8c,
		0xcacf
		},
		{
		0x5e8d,
		0xcad1
		},
		{
		0x5e8f,
		0xa7c7
		},
		{
		0x5e95,
		0xa9b3
		},
		{
		0x5e96,
		0xa9b4
		},
		{
		0x5e97,
		0xa9b1
		},
		{
		0x5e9a,
		0xa9b0
		},
		{
		0x5e9b,
		0xceb8
		},
		{
		0x5e9c,
		0xa9b2
		},
		{
		0x5ea0,
		0xabd6
		},
		{
		0x5ea2,
		0xceb7
		},
		{
		0x5ea3,
		0xceb9
		},
		{
		0x5ea4,
		0xceb6
		},
		{
		0x5ea5,
		0xceba
		},
		{
		0x5ea6,
		0xabd7
		},
		{
		0x5ea7,
		0xae79
		},
		{
		0x5ea8,
		0xd175
		},
		{
		0x5eaa,
		0xd177
		},
		{
		0x5eab,
		0xae77
		},
		{
		0x5eac,
		0xd178
		},
		{
		0x5ead,
		0xae78
		},
		{
		0x5eae,
		0xd176
		},
		{
		0x5eb0,
		0xceb5
		},
		{
		0x5eb1,
		0xd547
		},
		{
		0x5eb2,
		0xd54a
		},
		{
		0x5eb3,
		0xd54b
		},
		{
		0x5eb4,
		0xd548
		},
		{
		0x5eb5,
		0xb167
		},
		{
		0x5eb6,
		0xb166
		},
		{
		0x5eb7,
		0xb164
		},
		{
		0x5eb8,
		0xb165
		},
		{
		0x5eb9,
		0xd549
		},
		{
		0x5ebe,
		0xb168
		},
		{
		0x5ec1,
		0xb45a
		},
		{
		0x5ec2,
		0xb45b
		},
		{
		0x5ec4,
		0xb45c
		},
		{
		0x5ec5,
		0xdd5d
		},
		{
		0x5ec6,
		0xdd5f
		},
		{
		0x5ec7,
		0xdd61
		},
		{
		0x5ec8,
		0xb748
		},
		{
		0x5ec9,
		0xb747
		},
		{
		0x5eca,
		0xb459
		},
		{
		0x5ecb,
		0xdd60
		},
		{
		0x5ecc,
		0xdd5e
		},
		{
		0x5ece,
		0xe1b8
		},
		{
		0x5ed1,
		0xe1b6
		},
		{
		0x5ed2,
		0xe1bc
		},
		{
		0x5ed3,
		0xb9f8
		},
		{
		0x5ed4,
		0xe1bd
		},
		{
		0x5ed5,
		0xe1ba
		},
		{
		0x5ed6,
		0xb9f9
		},
		{
		0x5ed7,
		0xe1b7
		},
		{
		0x5ed8,
		0xe1b5
		},
		{
		0x5ed9,
		0xe1bb
		},
		{
		0x5eda,
		0xbc70
		},
		{
		0x5edb,
		0xe573
		},
		{
		0x5edc,
		0xe1b9
		},
		{
		0x5edd,
		0xbc72
		},
		{
		0x5ede,
		0xe574
		},
		{
		0x5edf,
		0xbc71
		},
		{
		0x5ee0,
		0xbc74
		},
		{
		0x5ee1,
		0xe575
		},
		{
		0x5ee2,
		0xbc6f
		},
		{
		0x5ee3,
		0xbc73
		},
		{
		0x5ee5,
		0xe973
		},
		{
		0x5ee6,
		0xe971
		},
		{
		0x5ee7,
		0xe970
		},
		{
		0x5ee8,
		0xe972
		},
		{
		0x5ee9,
		0xe96f
		},
		{
		0x5eec,
		0xc366
		},
		{
		0x5eee,
		0xf446
		},
		{
		0x5eef,
		0xf447
		},
		{
		0x5ef1,
		0xf5cb
		},
		{
		0x5ef2,
		0xf6df
		},
		{
		0x5ef3,
		0xc655
		},
		{
		0x5ef6,
		0xa9b5
		},
		{
		0x5ef7,
		0xa7ca
		},
		{
		0x5efa,
		0xabd8
		},
		{
		0x5efe,
		0xa47b
		},
		{
		0x5eff,
		0xa4dc
		},
		{
		0x5f01,
		0xa5af
		},
		{
		0x5f02,
		0xc9dd
		},
		{
		0x5f04,
		0xa7cb
		},
		{
		0x5f05,
		0xcad2
		},
		{
		0x5f07,
		0xcebb
		},
		{
		0x5f08,
		0xabd9
		},
		{
		0x5f0a,
		0xb9fa
		},
		{
		0x5f0b,
		0xa47c
		},
		{
		0x5f0f,
		0xa6a1
		},
		{
		0x5f12,
		0xb749
		},
		{
		0x5f13,
		0xa47d
		},
		{
		0x5f14,
		0xa4dd
		},
		{
		0x5f15,
		0xa4de
		},
		{
		0x5f17,
		0xa5b1
		},
		{
		0x5f18,
		0xa5b0
		},
		{
		0x5f1a,
		0xc9de
		},
		{
		0x5f1b,
		0xa6a2
		},
		{
		0x5f1d,
		0xcad3
		},
		{
		0x5f1f,
		0xa7cc
		},
		{
		0x5f22,
		0xcc71
		},
		{
		0x5f23,
		0xcc72
		},
		{
		0x5f24,
		0xcc73
		},
		{
		0x5f26,
		0xa9b6
		},
		{
		0x5f27,
		0xa9b7
		},
		{
		0x5f28,
		0xcc70
		},
		{
		0x5f29,
		0xa9b8
		},
		{
		0x5f2d,
		0xabda
		},
		{
		0x5f2e,
		0xcebc
		},
		{
		0x5f30,
		0xd17a
		},
		{
		0x5f31,
		0xae7a
		},
		{
		0x5f33,
		0xd179
		},
		{
		0x5f35,
		0xb169
		},
		{
		0x5f36,
		0xd54c
		},
		{
		0x5f37,
		0xb16a
		},
		{
		0x5f38,
		0xd54d
		},
		{
		0x5f3c,
		0xb45d
		},
		{
		0x5f40,
		0xdd62
		},
		{
		0x5f43,
		0xe1bf
		},
		{
		0x5f44,
		0xe1be
		},
		{
		0x5f46,
		0xb9fb
		},
		{
		0x5f48,
		0xbc75
		},
		{
		0x5f49,
		0xe576
		},
		{
		0x5f4a,
		0xbeca
		},
		{
		0x5f4b,
		0xe974
		},
		{
		0x5f4c,
		0xc0b1
		},
		{
		0x5f4e,
		0xc573
		},
		{
		0x5f4f,
		0xf7d8
		},
		{
		0x5f54,
		0xcc74
		},
		{
		0x5f56,
		0xcebd
		},
		{
		0x5f57,
		0xb16b
		},
		{
		0x5f58,
		0xd8f4
		},
		{
		0x5f59,
		0xb74a
		},
		{
		0x5f5d,
		0xc255
		},
		{
		0x5f62,
		0xa7ce
		},
		{
		0x5f64,
		0xa7cd
		},
		{
		0x5f65,
		0xabdb
		},
		{
		0x5f67,
		0xd17b
		},
		{
		0x5f69,
		0xb16d
		},
		{
		0x5f6a,
		0xb343
		},
		{
		0x5f6b,
		0xb16e
		},
		{
		0x5f6c,
		0xb16c
		},
		{
		0x5f6d,
		0xb45e
		},
		{
		0x5f6f,
		0xe1c0
		},
		{
		0x5f70,
		0xb9fc
		},
		{
		0x5f71,
		0xbc76
		},
		{
		0x5f73,
		0xc94c
		},
		{
		0x5f74,
		0xc9df
		},
		{
		0x5f76,
		0xcad5
		},
		{
		0x5f77,
		0xa7cf
		},
		{
		0x5f78,
		0xcad4
		},
		{
		0x5f79,
		0xa7d0
		},
		{
		0x5f7c,
		0xa9bc
		},
		{
		0x5f7d,
		0xcc77
		},
		{
		0x5f7e,
		0xcc76
		},
		{
		0x5f7f,
		0xa9bb
		},
		{
		0x5f80,
		0xa9b9
		},
		{
		0x5f81,
		0xa9ba
		},
		{
		0x5f82,
		0xcc75
		},
		{
		0x5f85,
		0xabdd
		},
		{
		0x5f86,
		0xcebe
		},
		{
		0x5f87,
		0xabe0
		},
		{
		0x5f88,
		0xabdc
		},
		{
		0x5f89,
		0xabe2
		},
		{
		0x5f8a,
		0xabde
		},
		{
		0x5f8b,
		0xabdf
		},
		{
		0x5f8c,
		0xabe1
		},
		{
		0x5f90,
		0xae7d
		},
		{
		0x5f91,
		0xae7c
		},
		{
		0x5f92,
		0xae7b
		},
		{
		0x5f96,
		0xd54f
		},
		{
		0x5f97,
		0xb16f
		},
		{
		0x5f98,
		0xb172
		},
		{
		0x5f99,
		0xb170
		},
		{
		0x5f9b,
		0xd54e
		},
		{
		0x5f9c,
		0xb175
		},
		{
		0x5f9e,
		0xb171
		},
		{
		0x5f9f,
		0xd550
		},
		{
		0x5fa0,
		0xb174
		},
		{
		0x5fa1,
		0xb173
		},
		{
		0x5fa5,
		0xd8f6
		},
		{
		0x5fa6,
		0xd8f5
		},
		{
		0x5fa8,
		0xb461
		},
		{
		0x5fa9,
		0xb45f
		},
		{
		0x5faa,
		0xb460
		},
		{
		0x5fab,
		0xd8f7
		},
		{
		0x5fac,
		0xb74b
		},
		{
		0x5fad,
		0xdd64
		},
		{
		0x5fae,
		0xb74c
		},
		{
		0x5faf,
		0xdd63
		},
		{
		0x5fb2,
		0xe577
		},
		{
		0x5fb5,
		0xbc78
		},
		{
		0x5fb6,
		0xe1c1
		},
		{
		0x5fb7,
		0xbc77
		},
		{
		0x5fb9,
		0xb9fd
		},
		{
		0x5fbb,
		0xecde
		},
		{
		0x5fbc,
		0xe975
		},
		{
		0x5fbd,
		0xc0b2
		},
		{
		0x5fbe,
		0xecdd
		},
		{
		0x5fbf,
		0xf240
		},
		{
		0x5fc0,
		0xf448
		},
		{
		0x5fc1,
		0xf449
		},
		{
		0x5fc3,
		0xa4df
		},
		{
		0x5fc5,
		0xa5b2
		},
		{
		0x5fc9,
		0xc97b
		},
		{
		0x5fcc,
		0xa7d2
		},
		{
		0x5fcd,
		0xa7d4
		},
		{
		0x5fcf,
		0xc9e2
		},
		{
		0x5fd0,
		0xcad8
		},
		{
		0x5fd1,
		0xcad7
		},
		{
		0x5fd2,
		0xcad6
		},
		{
		0x5fd4,
		0xc9e1
		},
		{
		0x5fd5,
		0xc9e0
		},
		{
		0x5fd6,
		0xa6a4
		},
		{
		0x5fd7,
		0xa7d3
		},
		{
		0x5fd8,
		0xa7d1
		},
		{
		0x5fd9,
		0xa6a3
		},
		{
		0x5fdd,
		0xa9bd
		},
		{
		0x5fde,
		0xcc78
		},
		{
		0x5fe0,
		0xa9be
		},
		{
		0x5fe1,
		0xcadd
		},
		{
		0x5fe3,
		0xcadf
		},
		{
		0x5fe4,
		0xcade
		},
		{
		0x5fe5,
		0xcc79
		},
		{
		0x5fe8,
		0xcada
		},
		{
		0x5fea,
		0xa7d8
		},
		{
		0x5feb,
		0xa7d6
		},
		{
		0x5fed,
		0xcad9
		},
		{
		0x5fee,
		0xcadb
		},
		{
		0x5fef,
		0xcae1
		},
		{
		0x5ff1,
		0xa7d5
		},
		{
		0x5ff3,
		0xcadc
		},
		{
		0x5ff4,
		0xcae5
		},
		{
		0x5ff5,
		0xa9c0
		},
		{
		0x5ff7,
		0xcae2
		},
		{
		0x5ff8,
		0xa7d7
		},
		{
		0x5ffa,
		0xcae0
		},
		{
		0x5ffb,
		0xcae3
		},
		{
		0x5ffd,
		0xa9bf
		},
		{
		0x5fff,
		0xa9c1
		},
		{
		0x6000,
		0xcae4
		},
		{
		0x6009,
		0xccaf
		},
		{
		0x600a,
		0xcca2
		},
		{
		0x600b,
		0xcc7e
		},
		{
		0x600c,
		0xccae
		},
		{
		0x600d,
		0xcca9
		},
		{
		0x600e,
		0xabe7
		},
		{
		0x600f,
		0xa9c2
		},
		{
		0x6010,
		0xccaa
		},
		{
		0x6011,
		0xccad
		},
		{
		0x6012,
		0xabe3
		},
		{
		0x6013,
		0xccac
		},
		{
		0x6014,
		0xa9c3
		},
		{
		0x6015,
		0xa9c8
		},
		{
		0x6016,
		0xa9c6
		},
		{
		0x6017,
		0xcca3
		},
		{
		0x6019,
		0xcc7c
		},
		{
		0x601a,
		0xcca5
		},
		{
		0x601b,
		0xa9cd
		},
		{
		0x601c,
		0xccb0
		},
		{
		0x601d,
		0xabe4
		},
		{
		0x601e,
		0xcca6
		},
		{
		0x6020,
		0xabe5
		},
		{
		0x6021,
		0xa9c9
		},
		{
		0x6022,
		0xcca8
		},
		{
		0x6024,
		0xcecd
		},
		{
		0x6025,
		0xabe6
		},
		{
		0x6026,
		0xcc7b
		},
		{
		0x6027,
		0xa9ca
		},
		{
		0x6028,
		0xabe8
		},
		{
		0x6029,
		0xa9cb
		},
		{
		0x602a,
		0xa9c7
		},
		{
		0x602b,
		0xa9cc
		},
		{
		0x602c,
		0xcca7
		},
		{
		0x602d,
		0xcc7a
		},
		{
		0x602e,
		0xccab
		},
		{
		0x602f,
		0xa9c4
		},
		{
		0x6032,
		0xcc7d
		},
		{
		0x6033,
		0xcca4
		},
		{
		0x6034,
		0xcca1
		},
		{
		0x6035,
		0xa9c5
		},
		{
		0x6037,
		0xcebf
		},
		{
		0x6039,
		0xcec0
		},
		{
		0x6040,
		0xceca
		},
		{
		0x6041,
		0xd1a1
		},
		{
		0x6042,
		0xcecb
		},
		{
		0x6043,
		0xabee
		},
		{
		0x6044,
		0xcece
		},
		{
		0x6045,
		0xcec4
		},
		{
		0x6046,
		0xabed
		},
		{
		0x6047,
		0xcec6
		},
		{
		0x6049,
		0xcec7
		},
		{
		0x604c,
		0xcec9
		},
		{
		0x604d,
		0xabe9
		},
		{
		0x6050,
		0xaea3
		},
		{
		0x6053,
		0xcec5
		},
		{
		0x6054,
		0xcec1
		},
		{
		0x6055,
		0xaea4
		},
		{
		0x6058,
		0xcecf
		},
		{
		0x6059,
		0xae7e
		},
		{
		0x605a,
		0xd17d
		},
		{
		0x605b,
		0xcec8
		},
		{
		0x605d,
		0xd17c
		},
		{
		0x605e,
		0xcec3
		},
		{
		0x605f,
		0xcecc
		},
		{
		0x6062,
		0xabec
		},
		{
		0x6063,
		0xaea1
		},
		{
		0x6064,
		0xabf2
		},
		{
		0x6065,
		0xaea2
		},
		{
		0x6066,
		0xced0
		},
		{
		0x6067,
		0xd17e
		},
		{
		0x6068,
		0xabeb
		},
		{
		0x6069,
		0xaea6
		},
		{
		0x606a,
		0xabf1
		},
		{
		0x606b,
		0xabf0
		},
		{
		0x606c,
		0xabef
		},
		{
		0x606d,
		0xaea5
		},
		{
		0x606e,
		0xced1
		},
		{
		0x606f,
		0xaea7
		},
		{
		0x6070,
		0xabea
		},
		{
		0x6072,
		0xcec2
		},
		{
		0x607f,
		0xb176
		},
		{
		0x6080,
		0xd1a4
		},
		{
		0x6081,
		0xd1a6
		},
		{
		0x6083,
		0xd1a8
		},
		{
		0x6084,
		0xaea8
		},
		{
		0x6085,
		0xaeae
		},
		{
		0x6086,
		0xd553
		},
		{
		0x6087,
		0xd1ac
		},
		{
		0x6088,
		0xd1a3
		},
		{
		0x6089,
		0xb178
		},
		{
		0x608a,
		0xd551
		},
		{
		0x608c,
		0xaead
		},
		{
		0x608d,
		0xaeab
		},
		{
		0x608e,
		0xd1ae
		},
		{
		0x6090,
		0xd552
		},
		{
		0x6092,
		0xd1a5
		},
		{
		0x6094,
		0xaeac
		},
		{
		0x6095,
		0xd1a9
		},
		{
		0x6096,
		0xaeaf
		},
		{
		0x6097,
		0xd1ab
		},
		{
		0x609a,
		0xaeaa
		},
		{
		0x609b,
		0xd1aa
		},
		{
		0x609c,
		0xd1ad
		},
		{
		0x609d,
		0xd1a7
		},
		{
		0x609f,
		0xaea9
		},
		{
		0x60a0,
		0xb179
		},
		{
		0x60a2,
		0xd1a2
		},
		{
		0x60a3,
		0xb177
		},
		{
		0x60a8,
		0xb17a
		},
		{
		0x60b0,
		0xd555
		},
		{
		0x60b1,
		0xd55e
		},
		{
		0x60b2,
		0xb464
		},
		{
		0x60b4,
		0xb17c
		},
		{
		0x60b5,
		0xb1a3
		},
		{
		0x60b6,
		0xb465
		},
		{
		0x60b7,
		0xd560
		},
		{
		0x60b8,
		0xb1aa
		},
		{
		0x60b9,
		0xd8f9
		},
		{
		0x60ba,
		0xd556
		},
		{
		0x60bb,
		0xb1a2
		},
		{
		0x60bc,
		0xb1a5
		},
		{
		0x60bd,
		0xb17e
		},
		{
		0x60be,
		0xd554
		},
		{
		0x60bf,
		0xd562
		},
		{
		0x60c0,
		0xd565
		},
		{
		0x60c1,
		0xd949
		},
		{
		0x60c3,
		0xd563
		},
		{
		0x60c4,
		0xd8fd
		},
		{
		0x60c5,
		0xb1a1
		},
		{
		0x60c6,
		0xb1a8
		},
		{
		0x60c7,
		0xb1ac
		},
		{
		0x60c8,
		0xd55d
		},
		{
		0x60c9,
		0xd8f8
		},
		{
		0x60ca,
		0xd561
		},
		{
		0x60cb,
		0xb17b
		},
		{
		0x60cc,
		0xd8fa
		},
		{
		0x60cd,
		0xd564
		},
		{
		0x60ce,
		0xd8fc
		},
		{
		0x60cf,
		0xd559
		},
		{
		0x60d1,
		0xb462
		},
		{
		0x60d3,
		0xd557
		},
		{
		0x60d4,
		0xd558
		},
		{
		0x60d5,
		0xb1a7
		},
		{
		0x60d8,
		0xb1a6
		},
		{
		0x60d9,
		0xd55b
		},
		{
		0x60da,
		0xb1ab
		},
		{
		0x60db,
		0xd55f
		},
		{
		0x60dc,
		0xb1a4
		},
		{
		0x60dd,
		0xd55c
		},
		{
		0x60df,
		0xb1a9
		},
		{
		0x60e0,
		0xb466
		},
		{
		0x60e1,
		0xb463
		},
		{
		0x60e2,
		0xd8fb
		},
		{
		0x60e4,
		0xd55a
		},
		{
		0x60e6,
		0xb17d
		},
		{
		0x60f0,
		0xb46b
		},
		{
		0x60f1,
		0xb46f
		},
		{
		0x60f2,
		0xd940
		},
		{
		0x60f3,
		0xb751
		},
		{
		0x60f4,
		0xb46d
		},
		{
		0x60f5,
		0xd944
		},
		{
		0x60f6,
		0xb471
		},
		{
		0x60f7,
		0xdd65
		},
		{
		0x60f8,
		0xd946
		},
		{
		0x60f9,
		0xb753
		},
		{
		0x60fa,
		0xb469
		},
		{
		0x60fb,
		0xb46c
		},
		{
		0x60fc,
		0xd947
		},
		{
		0x60fe,
		0xd948
		},
		{
		0x60ff,
		0xd94e
		},
		{
		0x6100,
		0xb473
		},
		{
		0x6101,
		0xb754
		},
		{
		0x6103,
		0xd94a
		},
		{
		0x6104,
		0xd94f
		},
		{
		0x6105,
		0xd943
		},
		{
		0x6106,
		0xb75e
		},
		{
		0x6108,
		0xb755
		},
		{
		0x6109,
		0xb472
		},
		{
		0x610a,
		0xd941
		},
		{
		0x610b,
		0xd950
		},
		{
		0x610d,
		0xb75d
		},
		{
		0x610e,
		0xb470
		},
		{
		0x610f,
		0xb74e
		},
		{
		0x6110,
		0xd94d
		},
		{
		0x6112,
		0xb474
		},
		{
		0x6113,
		0xd945
		},
		{
		0x6114,
		0xd8fe
		},
		{
		0x6115,
		0xb46a
		},
		{
		0x6116,
		0xd942
		},
		{
		0x6118,
		0xd94b
		},
		{
		0x611a,
		0xb74d
		},
		{
		0x611b,
		0xb752
		},
		{
		0x611c,
		0xb467
		},
		{
		0x611d,
		0xd94c
		},
		{
		0x611f,
		0xb750
		},
		{
		0x6123,
		0xb468
		},
		{
		0x6127,
		0xb75c
		},
		{
		0x6128,
		0xe1c3
		},
		{
		0x6129,
		0xdd70
		},
		{
		0x612b,
		0xdd68
		},
		{
		0x612c,
		0xe1c2
		},
		{
		0x612e,
		0xdd6c
		},
		{
		0x612f,
		0xdd6e
		},
		{
		0x6132,
		0xdd6b
		},
		{
		0x6134,
		0xb75b
		},
		{
		0x6136,
		0xdd6a
		},
		{
		0x6137,
		0xb75f
		},
		{
		0x613b,
		0xe1d2
		},
		{
		0x613e,
		0xb75a
		},
		{
		0x613f,
		0xba40
		},
		{
		0x6140,
		0xdd71
		},
		{
		0x6141,
		0xe1c4
		},
		{
		0x6144,
		0xb758
		},
		{
		0x6145,
		0xdd69
		},
		{
		0x6146,
		0xdd6d
		},
		{
		0x6147,
		0xb9fe
		},
		{
		0x6148,
		0xb74f
		},
		{
		0x6149,
		0xdd66
		},
		{
		0x614a,
		0xdd67
		},
		{
		0x614b,
		0xba41
		},
		{
		0x614c,
		0xb757
		},
		{
		0x614d,
		0xb759
		},
		{
		0x614e,
		0xb756
		},
		{
		0x614f,
		0xdd6f
		},
		{
		0x6152,
		0xe1c8
		},
		{
		0x6153,
		0xe1c9
		},
		{
		0x6154,
		0xe1ce
		},
		{
		0x6155,
		0xbc7d
		},
		{
		0x6156,
		0xe1d5
		},
		{
		0x6158,
		0xba47
		},
		{
		0x615a,
		0xba46
		},
		{
		0x615b,
		0xe1d0
		},
		{
		0x615d,
		0xbc7c
		},
		{
		0x615e,
		0xe1c5
		},
		{
		0x615f,
		0xba45
		},
		{
		0x6161,
		0xe1d4
		},
		{
		0x6162,
		0xba43
		},
		{
		0x6163,
		0xba44
		},
		{
		0x6165,
		0xe1d1
		},
		{
		0x6166,
		0xe5aa
		},
		{
		0x6167,
		0xbc7a
		},
		{
		0x6168,
		0xb46e
		},
		{
		0x616a,
		0xe1d3
		},
		{
		0x616b,
		0xbca3
		},
		{
		0x616c,
		0xe1cb
		},
		{
		0x616e,
		0xbc7b
		},
		{
		0x6170,
		0xbca2
		},
		{
		0x6171,
		0xe1c6
		},
		{
		0x6172,
		0xe1ca
		},
		{
		0x6173,
		0xe1c7
		},
		{
		0x6174,
		0xe1cd
		},
		{
		0x6175,
		0xba48
		},
		{
		0x6176,
		0xbc79
		},
		{
		0x6177,
		0xba42
		},
		{
		0x6179,
		0xe57a
		},
		{
		0x617a,
		0xe1cf
		},
		{
		0x617c,
		0xbca1
		},
		{
		0x617e,
		0xbca4
		},
		{
		0x6180,
		0xe1cc
		},
		{
		0x6182,
		0xbc7e
		},
		{
		0x6183,
		0xe579
		},
		{
		0x6189,
		0xe57e
		},
		{
		0x618a,
		0xbece
		},
		{
		0x618b,
		0xe578
		},
		{
		0x618c,
		0xe9a3
		},
		{
		0x618d,
		0xe5a9
		},
		{
		0x618e,
		0xbca8
		},
		{
		0x6190,
		0xbca6
		},
		{
		0x6191,
		0xbecc
		},
		{
		0x6192,
		0xe5a6
		},
		{
		0x6193,
		0xe5a2
		},
		{
		0x6194,
		0xbcac
		},
		{
		0x6196,
		0xe978
		},
		{
		0x619a,
		0xbcaa
		},
		{
		0x619b,
		0xe5a1
		},
		{
		0x619d,
		0xe976
		},
		{
		0x619f,
		0xe5a5
		},
		{
		0x61a1,
		0xe5a8
		},
		{
		0x61a2,
		0xe57d
		},
		{
		0x61a4,
		0xbcab
		},
		{
		0x61a7,
		0xbca5
		},
		{
		0x61a8,
		0xe977
		},
		{
		0x61a9,
		0xbecd
		},
		{
		0x61aa,
		0xe5a7
		},
		{
		0x61ab,
		0xbca7
		},
		{
		0x61ac,
		0xbca9
		},
		{
		0x61ad,
		0xe5a4
		},
		{
		0x61ae,
		0xbcad
		},
		{
		0x61af,
		0xe5a3
		},
		{
		0x61b0,
		0xe57c
		},
		{
		0x61b1,
		0xe57b
		},
		{
		0x61b2,
		0xbecb
		},
		{
		0x61b3,
		0xe5ab
		},
		{
		0x61b4,
		0xe97a
		},
		{
		0x61b5,
		0xece0
		},
		{
		0x61b6,
		0xbed0
		},
		{
		0x61b8,
		0xe9a2
		},
		{
		0x61ba,
		0xe97e
		},
		{
		0x61bc,
		0xece1
		},
		{
		0x61be,
		0xbed1
		},
		{
		0x61bf,
		0xe9a1
		},
		{
		0x61c1,
		0xe97c
		},
		{
		0x61c2,
		0xc0b4
		},
		{
		0x61c3,
		0xecdf
		},
		{
		0x61c5,
		0xe979
		},
		{
		0x61c6,
		0xe97b
		},
		{
		0x61c7,
		0xc0b5
		},
		{
		0x61c8,
		0xbed3
		},
		{
		0x61c9,
		0xc0b3
		},
		{
		0x61ca,
		0xbed2
		},
		{
		0x61cb,
		0xc0b7
		},
		{
		0x61cc,
		0xe97d
		},
		{
		0x61cd,
		0xbecf
		},
		{
		0x61d6,
		0xefcf
		},
		{
		0x61d8,
		0xefc7
		},
		{
		0x61de,
		0xece7
		},
		{
		0x61df,
		0xefc8
		},
		{
		0x61e0,
		0xece3
		},
		{
		0x61e3,
		0xc256
		},
		{
		0x61e4,
		0xece5
		},
		{
		0x61e5,
		0xece4
		},
		{
		0x61e6,
		0xc0b6
		},
		{
		0x61e7,
		0xece2
		},
		{
		0x61e8,
		0xece6
		},
		{
		0x61e9,
		0xefd0
		},
		{
		0x61ea,
		0xefcc
		},
		{
		0x61eb,
		0xefce
		},
		{
		0x61ed,
		0xefc9
		},
		{
		0x61ee,
		0xefca
		},
		{
		0x61f0,
		0xefcd
		},
		{
		0x61f1,
		0xefcb
		},
		{
		0x61f2,
		0xc367
		},
		{
		0x61f5,
		0xc36a
		},
		{
		0x61f6,
		0xc369
		},
		{
		0x61f7,
		0xc368
		},
		{
		0x61f8,
		0xc461
		},
		{
		0x61f9,
		0xf44a
		},
		{
		0x61fa,
		0xc462
		},
		{
		0x61fb,
		0xf241
		},
		{
		0x61fc,
		0xc4df
		},
		{
		0x61fd,
		0xf5cc
		},
		{
		0x61fe,
		0xc4e0
		},
		{
		0x61ff,
		0xc574
		},
		{
		0x6200,
		0xc5ca
		},
		{
		0x6201,
		0xf7d9
		},
		{
		0x6203,
		0xf7da
		},
		{
		0x6204,
		0xf7db
		},
		{
		0x6207,
		0xf9ba
		},
		{
		0x6208,
		0xa4e0
		},
		{
		0x6209,
		0xc97c
		},
		{
		0x620a,
		0xa5b3
		},
		{
		0x620c,
		0xa6a6
		},
		{
		0x620d,
		0xa6a7
		},
		{
		0x620e,
		0xa6a5
		},
		{
		0x6210,
		0xa6a8
		},
		{
		0x6211,
		0xa7da
		},
		{
		0x6212,
		0xa7d9
		},
		{
		0x6214,
		0xccb1
		},
		{
		0x6215,
		0xa9cf
		},
		{
		0x6216,
		0xa9ce
		},
		{
		0x6219,
		0xd1af
		},
		{
		0x621a,
		0xb1ad
		},
		{
		0x621b,
		0xb1ae
		},
		{
		0x621f,
		0xb475
		},
		{
		0x6220,
		0xdd72
		},
		{
		0x6221,
		0xb760
		},
		{
		0x6222,
		0xb761
		},
		{
		0x6223,
		0xdd74
		},
		{
		0x6224,
		0xdd76
		},
		{
		0x6225,
		0xdd75
		},
		{
		0x6227,
		0xe1d7
		},
		{
		0x6229,
		0xe1d6
		},
		{
		0x622a,
		0xba49
		},
		{
		0x622b,
		0xe1d8
		},
		{
		0x622d,
		0xe5ac
		},
		{
		0x622e,
		0xbcae
		},
		{
		0x6230,
		0xbed4
		},
		{
		0x6232,
		0xc0b8
		},
		{
		0x6233,
		0xc257
		},
		{
		0x6234,
		0xc0b9
		},
		{
		0x6236,
		0xa4e1
		},
		{
		0x623a,
		0xcae6
		},
		{
		0x623d,
		0xccb2
		},
		{
		0x623e,
		0xa9d1
		},
		{
		0x623f,
		0xa9d0
		},
		{
		0x6240,
		0xa9d2
		},
		{
		0x6241,
		0xabf3
		},
		{
		0x6242,
		0xced2
		},
		{
		0x6243,
		0xced3
		},
		{
		0x6246,
		0xd1b0
		},
		{
		0x6247,
		0xaeb0
		},
		{
		0x6248,
		0xb1af
		},
		{
		0x6249,
		0xb476
		},
		{
		0x624a,
		0xd951
		},
		{
		0x624b,
		0xa4e2
		},
		{
		0x624d,
		0xa47e
		},
		{
		0x624e,
		0xa4e3
		},
		{
		0x6250,
		0xc97d
		},
		{
		0x6251,
		0xa5b7
		},
		{
		0x6252,
		0xa5b6
		},
		{
		0x6253,
		0xa5b4
		},
		{
		0x6254,
		0xa5b5
		},
		{
		0x6258,
		0xa6ab
		},
		{
		0x6259,
		0xc9e9
		},
		{
		0x625a,
		0xc9eb
		},
		{
		0x625b,
		0xa6aa
		},
		{
		0x625c,
		0xc9e3
		},
		{
		0x625e,
		0xc9e4
		},
		{
		0x6260,
		0xc9ea
		},
		{
		0x6261,
		0xc9e6
		},
		{
		0x6262,
		0xc9e8
		},
		{
		0x6263,
		0xa6a9
		},
		{
		0x6264,
		0xc9e5
		},
		{
		0x6265,
		0xc9ec
		},
		{
		0x6266,
		0xc9e7
		},
		{
		0x626d,
		0xa7e1
		},
		{
		0x626e,
		0xa7ea
		},
		{
		0x626f,
		0xa7e8
		},
		{
		0x6270,
		0xcaf0
		},
		{
		0x6271,
		0xcaed
		},
		{
		0x6272,
		0xcaf5
		},
		{
		0x6273,
		0xa7e6
		},
		{
		0x6274,
		0xcaf6
		},
		{
		0x6276,
		0xa7df
		},
		{
		0x6277,
		0xcaf3
		},
		{
		0x6279,
		0xa7e5
		},
		{
		0x627a,
		0xcaef
		},
		{
		0x627b,
		0xcaee
		},
		{
		0x627c,
		0xa7e3
		},
		{
		0x627d,
		0xcaf4
		},
		{
		0x627e,
		0xa7e4
		},
		{
		0x627f,
		0xa9d3
		},
		{
		0x6280,
		0xa7de
		},
		{
		0x6281,
		0xcaf1
		},
		{
		0x6283,
		0xcae7
		},
		{
		0x6284,
		0xa7db
		},
		{
		0x6286,
		0xa7ee
		},
		{
		0x6287,
		0xcaec
		},
		{
		0x6288,
		0xcaf2
		},
		{
		0x6289,
		0xa7e0
		},
		{
		0x628a,
		0xa7e2
		},
		{
		0x628c,
		0xcae8
		},
		{
		0x628e,
		0xcae9
		},
		{
		0x628f,
		0xcaea
		},
		{
		0x6291,
		0xa7ed
		},
		{
		0x6292,
		0xa7e7
		},
		{
		0x6293,
		0xa7ec
		},
		{
		0x6294,
		0xcaeb
		},
		{
		0x6295,
		0xa7eb
		},
		{
		0x6296,
		0xa7dd
		},
		{
		0x6297,
		0xa7dc
		},
		{
		0x6298,
		0xa7e9
		},
		{
		0x62a8,
		0xa9e1
		},
		{
		0x62a9,
		0xccbe
		},
		{
		0x62aa,
		0xccb7
		},
		{
		0x62ab,
		0xa9dc
		},
		{
		0x62ac,
		0xa9ef
		},
		{
		0x62ad,
		0xccb3
		},
		{
		0x62ae,
		0xccba
		},
		{
		0x62af,
		0xccbc
		},
		{
		0x62b0,
		0xccbf
		},
		{
		0x62b1,
		0xa9ea
		},
		{
		0x62b3,
		0xccbb
		},
		{
		0x62b4,
		0xccb4
		},
		{
		0x62b5,
		0xa9e8
		},
		{
		0x62b6,
		0xccb8
		},
		{
		0x62b8,
		0xccc0
		},
		{
		0x62b9,
		0xa9d9
		},
		{
		0x62bb,
		0xccbd
		},
		{
		0x62bc,
		0xa9e3
		},
		{
		0x62bd,
		0xa9e2
		},
		{
		0x62be,
		0xccb6
		},
		{
		0x62bf,
		0xa9d7
		},
		{
		0x62c2,
		0xa9d8
		},
		{
		0x62c4,
		0xa9d6
		},
		{
		0x62c6,
		0xa9ee
		},
		{
		0x62c7,
		0xa9e6
		},
		{
		0x62c8,
		0xa9e0
		},
		{
		0x62c9,
		0xa9d4
		},
		{
		0x62ca,
		0xccb9
		},
		{
		0x62cb,
		0xa9df
		},
		{
		0x62cc,
		0xa9d5
		},
		{
		0x62cd,
		0xa9e7
		},
		{
		0x62ce,
		0xa9f0
		},
		{
		0x62cf,
		0xced4
		},
		{
		0x62d0,
		0xa9e4
		},
		{
		0x62d1,
		0xccb5
		},
		{
		0x62d2,
		0xa9da
		},
		{
		0x62d3,
		0xa9dd
		},
		{
		0x62d4,
		0xa9de
		},
		{
		0x62d6,
		0xa9ec
		},
		{
		0x62d7,
		0xa9ed
		},
		{
		0x62d8,
		0xa9eb
		},
		{
		0x62d9,
		0xa9e5
		},
		{
		0x62da,
		0xa9e9
		},
		{
		0x62db,
		0xa9db
		},
		{
		0x62dc,
		0xabf4
		},
		{
		0x62eb,
		0xceda
		},
		{
		0x62ec,
		0xac41
		},
		{
		0x62ed,
		0xabf8
		},
		{
		0x62ee,
		0xabfa
		},
		{
		0x62ef,
		0xac40
		},
		{
		0x62f0,
		0xcee6
		},
		{
		0x62f1,
		0xabfd
		},
		{
		0x62f2,
		0xd1b1
		},
		{
		0x62f3,
		0xaeb1
		},
		{
		0x62f4,
		0xac43
		},
		{
		0x62f5,
		0xced7
		},
		{
		0x62f6,
		0xcedf
		},
		{
		0x62f7,
		0xabfe
		},
		{
		0x62f8,
		0xcede
		},
		{
		0x62f9,
		0xcedb
		},
		{
		0x62fa,
		0xcee3
		},
		{
		0x62fb,
		0xcee5
		},
		{
		0x62fc,
		0xabf7
		},
		{
		0x62fd,
		0xabfb
		},
		{
		0x62fe,
		0xac42
		},
		{
		0x62ff,
		0xaeb3
		},
		{
		0x6300,
		0xcee0
		},
		{
		0x6301,
		0xabf9
		},
		{
		0x6302,
		0xac45
		},
		{
		0x6303,
		0xced9
		},
		{
		0x6307,
		0xabfc
		},
		{
		0x6308,
		0xaeb2
		},
		{
		0x6309,
		0xabf6
		},
		{
		0x630b,
		0xced6
		},
		{
		0x630c,
		0xcedd
		},
		{
		0x630d,
		0xced5
		},
		{
		0x630e,
		0xced8
		},
		{
		0x630f,
		0xcedc
		},
		{
		0x6310,
		0xd1b2
		},
		{
		0x6311,
		0xac44
		},
		{
		0x6313,
		0xcee1
		},
		{
		0x6314,
		0xcee2
		},
		{
		0x6315,
		0xcee4
		},
		{
		0x6316,
		0xabf5
		},
		{
		0x6328,
		0xaec1
		},
		{
		0x6329,
		0xd1be
		},
		{
		0x632a,
		0xaebf
		},
		{
		0x632b,
		0xaec0
		},
		{
		0x632c,
		0xd1b4
		},
		{
		0x632d,
		0xd1c4
		},
		{
		0x632f,
		0xaeb6
		},
		{
		0x6332,
		0xd566
		},
		{
		0x6333,
		0xd1c6
		},
		{
		0x6334,
		0xd1c0
		},
		{
		0x6336,
		0xd1b7
		},
		{
		0x6338,
		0xd1c9
		},
		{
		0x6339,
		0xd1ba
		},
		{
		0x633a,
		0xaebc
		},
		{
		0x633b,
		0xd57d
		},
		{
		0x633c,
		0xd1bd
		},
		{
		0x633d,
		0xaebe
		},
		{
		0x633e,
		0xaeb5
		},
		{
		0x6340,
		0xd1cb
		},
		{
		0x6341,
		0xd1bf
		},
		{
		0x6342,
		0xaeb8
		},
		{
		0x6343,
		0xd1b8
		},
		{
		0x6344,
		0xd1b5
		},
		{
		0x6345,
		0xd1b6
		},
		{
		0x6346,
		0xaeb9
		},
		{
		0x6347,
		0xd1c5
		},
		{
		0x6348,
		0xd1cc
		},
		{
		0x6349,
		0xaebb
		},
		{
		0x634a,
		0xd1bc
		},
		{
		0x634b,
		0xd1bb
		},
		{
		0x634c,
		0xaec3
		},
		{
		0x634d,
		0xaec2
		},
		{
		0x634e,
		0xaeb4
		},
		{
		0x634f,
		0xaeba
		},
		{
		0x6350,
		0xaebd
		},
		{
		0x6351,
		0xd1c8
		},
		{
		0x6354,
		0xd1c2
		},
		{
		0x6355,
		0xaeb7
		},
		{
		0x6356,
		0xd1b3
		},
		{
		0x6357,
		0xd1ca
		},
		{
		0x6358,
		0xd1c1
		},
		{
		0x6359,
		0xd1c3
		},
		{
		0x635a,
		0xd1c7
		},
		{
		0x6365,
		0xd567
		},
		{
		0x6367,
		0xb1b7
		},
		{
		0x6368,
		0xb1cb
		},
		{
		0x6369,
		0xb1ca
		},
		{
		0x636b,
		0xb1bf
		},
		{
		0x636d,
		0xd579
		},
		{
		0x636e,
		0xd575
		},
		{
		0x636f,
		0xd572
		},
		{
		0x6370,
		0xd5a6
		},
		{
		0x6371,
		0xb1ba
		},
		{
		0x6372,
		0xb1b2
		},
		{
		0x6375,
		0xd577
		},
		{
		0x6376,
		0xb4a8
		},
		{
		0x6377,
		0xb1b6
		},
		{
		0x6378,
		0xd5a1
		},
		{
		0x637a,
		0xb1cc
		},
		{
		0x637b,
		0xb1c9
		},
		{
		0x637c,
		0xd57b
		},
		{
		0x637d,
		0xd56a
		},
		{
		0x6380,
		0xb1c8
		},
		{
		0x6381,
		0xd5a3
		},
		{
		0x6382,
		0xd569
		},
		{
		0x6383,
		0xb1bd
		},
		{
		0x6384,
		0xb1c1
		},
		{
		0x6385,
		0xd5a2
		},
		{
		0x6387,
		0xd573
		},
		{
		0x6388,
		0xb1c2
		},
		{
		0x6389,
		0xb1bc
		},
		{
		0x638a,
		0xd568
		},
		{
		0x638c,
		0xb478
		},
		{
		0x638d,
		0xd5a5
		},
		{
		0x638e,
		0xd571
		},
		{
		0x638f,
		0xb1c7
		},
		{
		0x6390,
		0xd574
		},
		{
		0x6391,
		0xd5a4
		},
		{
		0x6392,
		0xb1c6
		},
		{
		0x6394,
		0xd952
		},
		{
		0x6396,
		0xb1b3
		},
		{
		0x6397,
		0xd56f
		},
		{
		0x6398,
		0xb1b8
		},
		{
		0x6399,
		0xb1c3
		},
		{
		0x639b,
		0xb1be
		},
		{
		0x639c,
		0xd578
		},
		{
		0x639d,
		0xd56e
		},
		{
		0x639e,
		0xd56c
		},
		{
		0x639f,
		0xd57e
		},
		{
		0x63a0,
		0xb1b0
		},
		{
		0x63a1,
		0xb1c4
		},
		{
		0x63a2,
		0xb1b4
		},
		{
		0x63a3,
		0xb477
		},
		{
		0x63a4,
		0xd57c
		},
		{
		0x63a5,
		0xb1b5
		},
		{
		0x63a7,
		0xb1b1
		},
		{
		0x63a8,
		0xb1c0
		},
		{
		0x63a9,
		0xb1bb
		},
		{
		0x63aa,
		0xb1b9
		},
		{
		0x63ab,
		0xd570
		},
		{
		0x63ac,
		0xb1c5
		},
		{
		0x63ad,
		0xd56d
		},
		{
		0x63ae,
		0xd57a
		},
		{
		0x63af,
		0xd576
		},
		{
		0x63b0,
		0xd954
		},
		{
		0x63b1,
		0xd953
		},
		{
		0x63bd,
		0xd56b
		},
		{
		0x63be,
		0xd964
		},
		{
		0x63c0,
		0xb47a
		},
		{
		0x63c2,
		0xd96a
		},
		{
		0x63c3,
		0xd959
		},
		{
		0x63c4,
		0xd967
		},
		{
		0x63c5,
		0xdd77
		},
		{
		0x63c6,
		0xb47d
		},
		{
		0x63c7,
		0xd96b
		},
		{
		0x63c8,
		0xd96e
		},
		{
		0x63c9,
		0xb47c
		},
		{
		0x63ca,
		0xd95c
		},
		{
		0x63cb,
		0xd96d
		},
		{
		0x63cc,
		0xd96c
		},
		{
		0x63cd,
		0xb47e
		},
		{
		0x63ce,
		0xd955
		},
		{
		0x63cf,
		0xb479
		},
		{
		0x63d0,
		0xb4a3
		},
		{
		0x63d2,
		0xb4a1
		},
		{
		0x63d3,
		0xd969
		},
		{
		0x63d5,
		0xd95f
		},
		{
		0x63d6,
		0xb4a5
		},
		{
		0x63d7,
		0xd970
		},
		{
		0x63d8,
		0xd968
		},
		{
		0x63d9,
		0xd971
		},
		{
		0x63da,
		0xb4ad
		},
		{
		0x63db,
		0xb4ab
		},
		{
		0x63dc,
		0xd966
		},
		{
		0x63dd,
		0xd965
		},
		{
		0x63df,
		0xd963
		},
		{
		0x63e0,
		0xd95d
		},
		{
		0x63e1,
		0xb4a4
		},
		{
		0x63e3,
		0xb4a2
		},
		{
		0x63e4,
		0xd1b9
		},
		{
		0x63e5,
		0xd956
		},
		{
		0x63e7,
		0xddb7
		},
		{
		0x63e8,
		0xd957
		},
		{
		0x63e9,
		0xb47b
		},
		{
		0x63ea,
		0xb4aa
		},
		{
		0x63eb,
		0xdd79
		},
		{
		0x63ed,
		0xb4a6
		},
		{
		0x63ee,
		0xb4a7
		},
		{
		0x63ef,
		0xd958
		},
		{
		0x63f0,
		0xd96f
		},
		{
		0x63f1,
		0xdd78
		},
		{
		0x63f2,
		0xd960
		},
		{
		0x63f3,
		0xd95b
		},
		{
		0x63f4,
		0xb4a9
		},
		{
		0x63f5,
		0xd961
		},
		{
		0x63f6,
		0xd95e
		},
		{
		0x63f9,
		0xb4ae
		},
		{
		0x6406,
		0xb770
		},
		{
		0x6409,
		0xdd7c
		},
		{
		0x640a,
		0xddb1
		},
		{
		0x640b,
		0xddb6
		},
		{
		0x640c,
		0xddaa
		},
		{
		0x640d,
		0xb76c
		},
		{
		0x640e,
		0xddbb
		},
		{
		0x640f,
		0xb769
		},
		{
		0x6410,
		0xdd7a
		},
		{
		0x6412,
		0xdd7b
		},
		{
		0x6413,
		0xb762
		},
		{
		0x6414,
		0xb76b
		},
		{
		0x6415,
		0xdda4
		},
		{
		0x6416,
		0xb76e
		},
		{
		0x6417,
		0xb76f
		},
		{
		0x6418,
		0xdda5
		},
		{
		0x641a,
		0xddb2
		},
		{
		0x641b,
		0xddb8
		},
		{
		0x641c,
		0xb76a
		},
		{
		0x641e,
		0xb764
		},
		{
		0x641f,
		0xdda3
		},
		{
		0x6420,
		0xdd7d
		},
		{
		0x6421,
		0xddba
		},
		{
		0x6422,
		0xdda8
		},
		{
		0x6423,
		0xdda9
		},
		{
		0x6424,
		0xdd7e
		},
		{
		0x6425,
		0xddb4
		},
		{
		0x6426,
		0xddab
		},
		{
		0x6427,
		0xddb5
		},
		{
		0x6428,
		0xddad
		},
		{
		0x642a,
		0xb765
		},
		{
		0x642b,
		0xe1d9
		},
		{
		0x642c,
		0xb768
		},
		{
		0x642d,
		0xb766
		},
		{
		0x642e,
		0xddb9
		},
		{
		0x642f,
		0xddb0
		},
		{
		0x6430,
		0xddac
		},
		{
		0x6433,
		0xdda1
		},
		{
		0x6434,
		0xba53
		},
		{
		0x6435,
		0xddaf
		},
		{
		0x6436,
		0xb76d
		},
		{
		0x6437,
		0xdda7
		},
		{
		0x6439,
		0xdda6
		},
		{
		0x643d,
		0xb767
		},
		{
		0x643e,
		0xb763
		},
		{
		0x643f,
		0xe1ee
		},
		{
		0x6440,
		0xddb3
		},
		{
		0x6441,
		0xddae
		},
		{
		0x6443,
		0xdda2
		},
		{
		0x644b,
		0xe1e9
		},
		{
		0x644d,
		0xe1da
		},
		{
		0x644e,
		0xe1e5
		},
		{
		0x6450,
		0xe1ec
		},
		{
		0x6451,
		0xba51
		},
		{
		0x6452,
		0xb4ac
		},
		{
		0x6453,
		0xe1ea
		},
		{
		0x6454,
		0xba4c
		},
		{
		0x6458,
		0xba4b
		},
		{
		0x6459,
		0xe1f1
		},
		{
		0x645b,
		0xe1db
		},
		{
		0x645c,
		0xe1e8
		},
		{
		0x645d,
		0xe1dc
		},
		{
		0x645e,
		0xe1e7
		},
		{
		0x645f,
		0xba4f
		},
		{
		0x6460,
		0xe1eb
		},
		{
		0x6461,
		0xd962
		},
		{
		0x6465,
		0xe1f2
		},
		{
		0x6466,
		0xe1e3
		},
		{
		0x6467,
		0xba52
		},
		{
		0x6468,
		0xe5ba
		},
		{
		0x6469,
		0xbcaf
		},
		{
		0x646b,
		0xe1f0
		},
		{
		0x646c,
		0xe1ef
		},
		{
		0x646d,
		0xba54
		},
		{
		0x646e,
		0xe5ad
		},
		{
		0x646f,
		0xbcb0
		},
		{
		0x6470,
		0xe5ae
		},
		{
		0x6472,
		0xe1df
		},
		{
		0x6473,
		0xe1e0
		},
		{
		0x6474,
		0xe1dd
		},
		{
		0x6475,
		0xe1e2
		},
		{
		0x6476,
		0xe1de
		},
		{
		0x6477,
		0xe1f3
		},
		{
		0x6478,
		0xba4e
		},
		{
		0x6479,
		0xbcb1
		},
		{
		0x647a,
		0xba50
		},
		{
		0x647b,
		0xba55
		},
		{
		0x647d,
		0xe1e1
		},
		{
		0x647f,
		0xe1ed
		},
		{
		0x6482,
		0xe1e6
		},
		{
		0x6485,
		0xe5b1
		},
		{
		0x6487,
		0xba4a
		},
		{
		0x6488,
		0xbcb4
		},
		{
		0x6489,
		0xe9aa
		},
		{
		0x648a,
		0xe5b6
		},
		{
		0x648b,
		0xe5b5
		},
		{
		0x648c,
		0xe5b7
		},
		{
		0x648f,
		0xe5b4
		},
		{
		0x6490,
		0xbcb5
		},
		{
		0x6492,
		0xbcbb
		},
		{
		0x6493,
		0xbcb8
		},
		{
		0x6495,
		0xbcb9
		},
		{
		0x6496,
		0xe5af
		},
		{
		0x6497,
		0xe5b2
		},
		{
		0x6498,
		0xe5bc
		},
		{
		0x6499,
		0xbcc1
		},
		{
		0x649a,
		0xbcbf
		},
		{
		0x649c,
		0xe5b3
		},
		{
		0x649d,
		0xd95a
		},
		{
		0x649e,
		0xbcb2
		},
		{
		0x649f,
		0xe5b9
		},
		{
		0x64a0,
		0xe5b0
		},
		{
		0x64a2,
		0xbcc2
		},
		{
		0x64a3,
		0xe5b8
		},
		{
		0x64a4,
		0xba4d
		},
		{
		0x64a5,
		0xbcb7
		},
		{
		0x64a6,
		0xe1e4
		},
		{
		0x64a9,
		0xbcba
		},
		{
		0x64ab,
		0xbcbe
		},
		{
		0x64ac,
		0xbcc0
		},
		{
		0x64ad,
		0xbcbd
		},
		{
		0x64ae,
		0xbcbc
		},
		{
		0x64b0,
		0xbcb6
		},
		{
		0x64b1,
		0xe5bb
		},
		{
		0x64b2,
		0xbcb3
		},
		{
		0x64b3,
		0xbcc3
		},
		{
		0x64bb,
		0xbed8
		},
		{
		0x64bc,
		0xbed9
		},
		{
		0x64bd,
		0xe9a9
		},
		{
		0x64be,
		0xbee2
		},
		{
		0x64bf,
		0xbedf
		},
		{
		0x64c1,
		0xbed6
		},
		{
		0x64c2,
		0xbedd
		},
		{
		0x64c3,
		0xe9ab
		},
		{
		0x64c4,
		0xbedb
		},
		{
		0x64c5,
		0xbed5
		},
		{
		0x64c7,
		0xbedc
		},
		{
		0x64c9,
		0xe9a8
		},
		{
		0x64ca,
		0xc0bb
		},
		{
		0x64cb,
		0xbed7
		},
		{
		0x64cd,
		0xbede
		},
		{
		0x64ce,
		0xc0ba
		},
		{
		0x64cf,
		0xe9a7
		},
		{
		0x64d0,
		0xe9a6
		},
		{
		0x64d2,
		0xbee0
		},
		{
		0x64d4,
		0xbee1
		},
		{
		0x64d6,
		0xe9a5
		},
		{
		0x64d7,
		0xe9a4
		},
		{
		0x64d8,
		0xc0bc
		},
		{
		0x64d9,
		0xe9ae
		},
		{
		0x64da,
		0xbeda
		},
		{
		0x64db,
		0xe9ac
		},
		{
		0x64e0,
		0xc0bd
		},
		{
		0x64e2,
		0xc0c2
		},
		{
		0x64e3,
		0xecea
		},
		{
		0x64e4,
		0xecec
		},
		{
		0x64e6,
		0xc0bf
		},
		{
		0x64e8,
		0xeced
		},
		{
		0x64e9,
		0xece9
		},
		{
		0x64eb,
		0xeceb
		},
		{
		0x64ec,
		0xc0c0
		},
		{
		0x64ed,
		0xc0c3
		},
		{
		0x64ef,
		0xece8
		},
		{
		0x64f0,
		0xc0be
		},
		{
		0x64f1,
		0xc0c1
		},
		{
		0x64f2,
		0xc259
		},
		{
		0x64f3,
		0xe9ad
		},
		{
		0x64f4,
		0xc258
		},
		{
		0x64f7,
		0xc25e
		},
		{
		0x64f8,
		0xefd4
		},
		{
		0x64fa,
		0xc25c
		},
		{
		0x64fb,
		0xc25d
		},
		{
		0x64fc,
		0xefd7
		},
		{
		0x64fd,
		0xefd3
		},
		{
		0x64fe,
		0xc25a
		},
		{
		0x64ff,
		0xefd1
		},
		{
		0x6500,
		0xc36b
		},
		{
		0x6501,
		0xefd5
		},
		{
		0x6503,
		0xefd6
		},
		{
		0x6504,
		0xefd2
		},
		{
		0x6506,
		0xc25b
		},
		{
		0x6507,
		0xf242
		},
		{
		0x6509,
		0xf245
		},
		{
		0x650c,
		0xf246
		},
		{
		0x650d,
		0xf244
		},
		{
		0x650e,
		0xf247
		},
		{
		0x650f,
		0xc36c
		},
		{
		0x6510,
		0xf243
		},
		{
		0x6513,
		0xf44e
		},
		{
		0x6514,
		0xc464
		},
		{
		0x6515,
		0xf44d
		},
		{
		0x6516,
		0xf44c
		},
		{
		0x6517,
		0xf44b
		},
		{
		0x6518,
		0xc463
		},
		{
		0x6519,
		0xc465
		},
		{
		0x651b,
		0xf5cd
		},
		{
		0x651c,
		0xc4e2
		},
		{
		0x651d,
		0xc4e1
		},
		{
		0x6520,
		0xf6e1
		},
		{
		0x6521,
		0xf6e0
		},
		{
		0x6522,
		0xf6e3
		},
		{
		0x6523,
		0xc5cb
		},
		{
		0x6524,
		0xc575
		},
		{
		0x6525,
		0xf7dd
		},
		{
		0x6526,
		0xf6e2
		},
		{
		0x6529,
		0xf7dc
		},
		{
		0x652a,
		0xc5cd
		},
		{
		0x652b,
		0xc5cc
		},
		{
		0x652c,
		0xc5f3
		},
		{
		0x652d,
		0xf8a9
		},
		{
		0x652e,
		0xf8ef
		},
		{
		0x652f,
		0xa4e4
		},
		{
		0x6532,
		0xd972
		},
		{
		0x6533,
		0xe9af
		},
		{
		0x6536,
		0xa6ac
		},
		{
		0x6537,
		0xcaf7
		},
		{
		0x6538,
		0xa7f1
		},
		{
		0x6539,
		0xa7ef
		},
		{
		0x653b,
		0xa7f0
		},
		{
		0x653d,
		0xccc1
		},
		{
		0x653e,
		0xa9f1
		},
		{
		0x653f,
		0xac46
		},
		{
		0x6541,
		0xcee7
		},
		{
		0x6543,
		0xcee8
		},
		{
		0x6545,
		0xac47
		},
		{
		0x6546,
		0xd1ce
		},
		{
		0x6548,
		0xaec4
		},
		{
		0x6549,
		0xaec5
		},
		{
		0x654a,
		0xd1cd
		},
		{
		0x654f,
		0xb1d3
		},
		{
		0x6551,
		0xb1cf
		},
		{
		0x6553,
		0xd5a7
		},
		{
		0x6554,
		0xb1d6
		},
		{
		0x6555,
		0xb1d5
		},
		{
		0x6556,
		0xb1ce
		},
		{
		0x6557,
		0xb1d1
		},
		{
		0x6558,
		0xb1d4
		},
		{
		0x6559,
		0xb1d0
		},
		{
		0x655c,
		0xd976
		},
		{
		0x655d,
		0xb1cd
		},
		{
		0x655e,
		0xb4af
		},
		{
		0x6562,
		0xb4b1
		},
		{
		0x6563,
		0xb4b2
		},
		{
		0x6564,
		0xd975
		},
		{
		0x6565,
		0xd978
		},
		{
		0x6566,
		0xb4b0
		},
		{
		0x6567,
		0xd973
		},
		{
		0x6568,
		0xd977
		},
		{
		0x656a,
		0xd974
		},
		{
		0x656c,
		0xb771
		},
		{
		0x656f,
		0xddbc
		},
		{
		0x6572,
		0xba56
		},
		{
		0x6573,
		0xe1f4
		},
		{
		0x6574,
		0xbee3
		},
		{
		0x6575,
		0xbcc4
		},
		{
		0x6576,
		0xe5bd
		},
		{
		0x6577,
		0xbcc5
		},
		{
		0x6578,
		0xbcc6
		},
		{
		0x6579,
		0xe5bf
		},
		{
		0x657a,
		0xe5be
		},
		{
		0x657b,
		0xe5c0
		},
		{
		0x657c,
		0xe9b1
		},
		{
		0x657f,
		0xe9b0
		},
		{
		0x6580,
		0xecef
		},
		{
		0x6581,
		0xecee
		},
		{
		0x6582,
		0xc0c4
		},
		{
		0x6583,
		0xc0c5
		},
		{
		0x6584,
		0xf248
		},
		{
		0x6587,
		0xa4e5
		},
		{
		0x658c,
		0xd979
		},
		{
		0x6590,
		0xb4b4
		},
		{
		0x6591,
		0xb4b3
		},
		{
		0x6592,
		0xddbd
		},
		{
		0x6594,
		0xefd8
		},
		{
		0x6595,
		0xc4e3
		},
		{
		0x6596,
		0xf7de
		},
		{
		0x6597,
		0xa4e6
		},
		{
		0x6599,
		0xaec6
		},
		{
		0x659b,
		0xb1d8
		},
		{
		0x659c,
		0xb1d7
		},
		{
		0x659d,
		0xd97a
		},
		{
		0x659e,
		0xd97b
		},
		{
		0x659f,
		0xb772
		},
		{
		0x65a0,
		0xe1f5
		},
		{
		0x65a1,
		0xba57
		},
		{
		0x65a2,
		0xe9b2
		},
		{
		0x65a4,
		0xa4e7
		},
		{
		0x65a5,
		0xa5b8
		},
		{
		0x65a7,
		0xa9f2
		},
		{
		0x65a8,
		0xccc2
		},
		{
		0x65aa,
		0xcee9
		},
		{
		0x65ab,
		0xac48
		},
		{
		0x65ac,
		0xb1d9
		},
		{
		0x65ae,
		0xd97c
		},
		{
		0x65af,
		0xb4b5
		},
		{
		0x65b0,
		0xb773
		},
		{
		0x65b2,
		0xe5c1
		},
		{
		0x65b3,
		0xe5c2
		},
		{
		0x65b6,
		0xecf0
		},
		{
		0x65b7,
		0xc25f
		},
		{
		0x65b8,
		0xf8f0
		},
		{
		0x65b9,
		0xa4e8
		},
		{
		0x65bb,
		0xccc3
		},
		{
		0x65bc,
		0xa9f3
		},
		{
		0x65bd,
		0xac49
		},
		{
		0x65bf,
		0xceea
		},
		{
		0x65c1,
		0xaec7
		},
		{
		0x65c2,
		0xd1d2
		},
		{
		0x65c3,
		0xd1d0
		},
		{
		0x65c4,
		0xd1d1
		},
		{
		0x65c5,
		0xaec8
		},
		{
		0x65c6,
		0xd1cf
		},
		{
		0x65cb,
		0xb1db
		},
		{
		0x65cc,
		0xb1dc
		},
		{
		0x65cd,
		0xd5a8
		},
		{
		0x65ce,
		0xb1dd
		},
		{
		0x65cf,
		0xb1da
		},
		{
		0x65d0,
		0xd97d
		},
		{
		0x65d2,
		0xd97e
		},
		{
		0x65d3,
		0xddbe
		},
		{
		0x65d6,
		0xba59
		},
		{
		0x65d7,
		0xba58
		},
		{
		0x65da,
		0xecf1
		},
		{
		0x65db,
		0xefd9
		},
		{
		0x65dd,
		0xf24a
		},
		{
		0x65de,
		0xf249
		},
		{
		0x65df,
		0xf44f
		},
		{
		0x65e1,
		0xc95e
		},
		{
		0x65e2,
		0xac4a
		},
		{
		0x65e5,
		0xa4e9
		},
		{
		0x65e6,
		0xa5b9
		},
		{
		0x65e8,
		0xa6ae
		},
		{
		0x65e9,
		0xa6ad
		},
		{
		0x65ec,
		0xa6af
		},
		{
		0x65ed,
		0xa6b0
		},
		{
		0x65ee,
		0xc9ee
		},
		{
		0x65ef,
		0xc9ed
		},
		{
		0x65f0,
		0xcaf8
		},
		{
		0x65f1,
		0xa7f2
		},
		{
		0x65f2,
		0xcafb
		},
		{
		0x65f3,
		0xcafa
		},
		{
		0x65f4,
		0xcaf9
		},
		{
		0x65f5,
		0xcafc
		},
		{
		0x65fa,
		0xa9f4
		},
		{
		0x65fb,
		0xccc9
		},
		{
		0x65fc,
		0xccc5
		},
		{
		0x65fd,
		0xccce
		},
		{
		0x6600,
		0xa9fb
		},
		{
		0x6602,
		0xa9f9
		},
		{
		0x6603,
		0xccca
		},
		{
		0x6604,
		0xccc6
		},
		{
		0x6605,
		0xcccd
		},
		{
		0x6606,
		0xa9f8
		},
		{
		0x6607,
		0xaa40
		},
		{
		0x6608,
		0xccc8
		},
		{
		0x6609,
		0xccc4
		},
		{
		0x660a,
		0xa9fe
		},
		{
		0x660b,
		0xcccb
		},
		{
		0x660c,
		0xa9f7
		},
		{
		0x660d,
		0xcccc
		},
		{
		0x660e,
		0xa9fa
		},
		{
		0x660f,
		0xa9fc
		},
		{
		0x6610,
		0xccd0
		},
		{
		0x6611,
		0xcccf
		},
		{
		0x6612,
		0xccc7
		},
		{
		0x6613,
		0xa9f6
		},
		{
		0x6614,
		0xa9f5
		},
		{
		0x6615,
		0xa9fd
		},
		{
		0x661c,
		0xceef
		},
		{
		0x661d,
		0xcef5
		},
		{
		0x661f,
		0xac50
		},
		{
		0x6620,
		0xac4d
		},
		{
		0x6621,
		0xceec
		},
		{
		0x6622,
		0xcef1
		},
		{
		0x6624,
		0xac53
		},
		{
		0x6625,
		0xac4b
		},
		{
		0x6626,
		0xcef0
		},
		{
		0x6627,
		0xac4e
		},
		{
		0x6628,
		0xac51
		},
		{
		0x662b,
		0xcef3
		},
		{
		0x662d,
		0xac4c
		},
		{
		0x662e,
		0xcef8
		},
		{
		0x662f,
		0xac4f
		},
		{
		0x6631,
		0xac52
		},
		{
		0x6632,
		0xceed
		},
		{
		0x6633,
		0xcef2
		},
		{
		0x6634,
		0xcef6
		},
		{
		0x6635,
		0xceee
		},
		{
		0x6636,
		0xceeb
		},
		{
		0x6639,
		0xcef7
		},
		{
		0x663a,
		0xcef4
		},
		{
		0x6641,
		0xaed0
		},
		{
		0x6642,
		0xaec9
		},
		{
		0x6643,
		0xaecc
		},
		{
		0x6645,
		0xaecf
		},
		{
		0x6647,
		0xd1d5
		},
		{
		0x6649,
		0xaeca
		},
		{
		0x664a,
		0xd1d3
		},
		{
		0x664c,
		0xaece
		},
		{
		0x664f,
		0xaecb
		},
		{
		0x6651,
		0xd1d6
		},
		{
		0x6652,
		0xaecd
		},
		{
		0x6659,
		0xd5ac
		},
		{
		0x665a,
		0xb1df
		},
		{
		0x665b,
		0xd5ab
		},
		{
		0x665c,
		0xd5ad
		},
		{
		0x665d,
		0xb1de
		},
		{
		0x665e,
		0xb1e3
		},
		{
		0x665f,
		0xd1d4
		},
		{
		0x6661,
		0xd5aa
		},
		{
		0x6662,
		0xd5ae
		},
		{
		0x6664,
		0xb1e0
		},
		{
		0x6665,
		0xd5a9
		},
		{
		0x6666,
		0xb1e2
		},
		{
		0x6668,
		0xb1e1
		},
		{
		0x666a,
		0xd9a7
		},
		{
		0x666c,
		0xd9a2
		},
		{
		0x666e,
		0xb4b6
		},
		{
		0x666f,
		0xb4ba
		},
		{
		0x6670,
		0xb4b7
		},
		{
		0x6671,
		0xd9a5
		},
		{
		0x6672,
		0xd9a8
		},
		{
		0x6674,
		0xb4b8
		},
		{
		0x6676,
		0xb4b9
		},
		{
		0x6677,
		0xb4be
		},
		{
		0x6678,
		0xddc7
		},
		{
		0x6679,
		0xd9a6
		},
		{
		0x667a,
		0xb4bc
		},
		{
		0x667b,
		0xd9a3
		},
		{
		0x667c,
		0xd9a1
		},
		{
		0x667e,
		0xb4bd
		},
		{
		0x6680,
		0xd9a4
		},
		{
		0x6684,
		0xb779
		},
		{
		0x6686,
		0xddbf
		},
		{
		0x6687,
		0xb776
		},
		{
		0x6688,
		0xb777
		},
		{
		0x6689,
		0xb775
		},
		{
		0x668a,
		0xddc4
		},
		{
		0x668b,
		0xddc3
		},
		{
		0x668c,
		0xddc0
		},
		{
		0x668d,
		0xb77b
		},
		{
		0x6690,
		0xddc2
		},
		{
		0x6691,
		0xb4bb
		},
		{
		0x6694,
		0xddc6
		},
		{
		0x6695,
		0xddc1
		},
		{
		0x6696,
		0xb778
		},
		{
		0x6697,
		0xb774
		},
		{
		0x6698,
		0xb77a
		},
		{
		0x6699,
		0xddc5
		},
		{
		0x669d,
		0xba5c
		},
		{
		0x669f,
		0xe1f8
		},
		{
		0x66a0,
		0xe1f7
		},
		{
		0x66a1,
		0xe1f6
		},
		{
		0x66a2,
		0xba5a
		},
		{
		0x66a8,
		0xba5b
		},
		{
		0x66a9,
		0xe5c5
		},
		{
		0x66aa,
		0xe5c8
		},
		{
		0x66ab,
		0xbcc8
		},
		{
		0x66ae,
		0xbcc7
		},
		{
		0x66af,
		0xe5c9
		},
		{
		0x66b0,
		0xe5c4
		},
		{
		0x66b1,
		0xbcca
		},
		{
		0x66b2,
		0xe5c6
		},
		{
		0x66b4,
		0xbcc9
		},
		{
		0x66b5,
		0xe5c3
		},
		{
		0x66b7,
		0xe5c7
		},
		{
		0x66b8,
		0xbee9
		},
		{
		0x66b9,
		0xbee6
		},
		{
		0x66ba,
		0xe9bb
		},
		{
		0x66bb,
		0xe9ba
		},
		{
		0x66bd,
		0xe9b9
		},
		{
		0x66be,
		0xe9b4
		},
		{
		0x66c0,
		0xe9b5
		},
		{
		0x66c4,
		0xbee7
		},
		{
		0x66c6,
		0xbee4
		},
		{
		0x66c7,
		0xbee8
		},
		{
		0x66c8,
		0xe9b3
		},
		{
		0x66c9,
		0xbee5
		},
		{
		0x66ca,
		0xe9b6
		},
		{
		0x66cb,
		0xe9b7
		},
		{
		0x66cc,
		0xe9bc
		},
		{
		0x66cf,
		0xe9b8
		},
		{
		0x66d2,
		0xecf2
		},
		{
		0x66d6,
		0xc0c7
		},
		{
		0x66d8,
		0xefdc
		},
		{
		0x66d9,
		0xc0c6
		},
		{
		0x66da,
		0xefda
		},
		{
		0x66db,
		0xefdb
		},
		{
		0x66dc,
		0xc260
		},
		{
		0x66dd,
		0xc36e
		},
		{
		0x66de,
		0xf24b
		},
		{
		0x66e0,
		0xc36d
		},
		{
		0x66e3,
		0xf451
		},
		{
		0x66e4,
		0xf452
		},
		{
		0x66e6,
		0xc466
		},
		{
		0x66e8,
		0xf450
		},
		{
		0x66e9,
		0xc4e4
		},
		{
		0x66eb,
		0xf7df
		},
		{
		0x66ec,
		0xc5ce
		},
		{
		0x66ed,
		0xf8aa
		},
		{
		0x66ee,
		0xf8ab
		},
		{
		0x66f0,
		0xa4ea
		},
		{
		0x66f2,
		0xa6b1
		},
		{
		0x66f3,
		0xa6b2
		},
		{
		0x66f4,
		0xa7f3
		},
		{
		0x66f6,
		0xccd1
		},
		{
		0x66f7,
		0xac54
		},
		{
		0x66f8,
		0xaed1
		},
		{
		0x66f9,
		0xb1e4
		},
		{
		0x66fc,
		0xb0d2
		},
		{
		0x66fe,
		0xb4bf
		},
		{
		0x66ff,
		0xb4c0
		},
		{
		0x6700,
		0xb3cc
		},
		{
		0x6701,
		0xd9a9
		},
		{
		0x6703,
		0xb77c
		},
		{
		0x6704,
		0xe1fa
		},
		{
		0x6705,
		0xe1f9
		},
		{
		0x6708,
		0xa4eb
		},
		{
		0x6709,
		0xa6b3
		},
		{
		0x670a,
		0xccd2
		},
		{
		0x670b,
		0xaa42
		},
		{
		0x670d,
		0xaa41
		},
		{
		0x670f,
		0xcef9
		},
		{
		0x6710,
		0xcefa
		},
		{
		0x6712,
		0xd1d7
		},
		{
		0x6713,
		0xd1d8
		},
		{
		0x6714,
		0xaed2
		},
		{
		0x6715,
		0xaed3
		},
		{
		0x6717,
		0xaed4
		},
		{
		0x6718,
		0xd5af
		},
		{
		0x671b,
		0xb1e6
		},
		{
		0x671d,
		0xb4c2
		},
		{
		0x671f,
		0xb4c1
		},
		{
		0x6720,
		0xddc8
		},
		{
		0x6721,
		0xdf7a
		},
		{
		0x6722,
		0xe1fb
		},
		{
		0x6723,
		0xe9bd
		},
		{
		0x6726,
		0xc261
		},
		{
		0x6727,
		0xc467
		},
		{
		0x6728,
		0xa4ec
		},
		{
		0x672a,
		0xa5bc
		},
		{
		0x672b,
		0xa5bd
		},
		{
		0x672c,
		0xa5bb
		},
		{
		0x672d,
		0xa5be
		},
		{
		0x672e,
		0xa5ba
		},
		{
		0x6731,
		0xa6b6
		},
		{
		0x6733,
		0xc9f6
		},
		{
		0x6734,
		0xa6b5
		},
		{
		0x6735,
		0xa6b7
		},
		{
		0x6738,
		0xc9f1
		},
		{
		0x6739,
		0xc9f0
		},
		{
		0x673a,
		0xc9f3
		},
		{
		0x673b,
		0xc9f2
		},
		{
		0x673c,
		0xc9f5
		},
		{
		0x673d,
		0xa6b4
		},
		{
		0x673e,
		0xc9ef
		},
		{
		0x673f,
		0xc9f4
		},
		{
		0x6745,
		0xcafd
		},
		{
		0x6746,
		0xa7fd
		},
		{
		0x6747,
		0xcafe
		},
		{
		0x6748,
		0xcb43
		},
		{
		0x6749,
		0xa7fc
		},
		{
		0x674b,
		0xcb47
		},
		{
		0x674c,
		0xcb42
		},
		{
		0x674d,
		0xcb45
		},
		{
		0x674e,
		0xa7f5
		},
		{
		0x674f,
		0xa7f6
		},
		{
		0x6750,
		0xa7f7
		},
		{
		0x6751,
		0xa7f8
		},
		{
		0x6753,
		0xa840
		},
		{
		0x6755,
		0xcb41
		},
		{
		0x6756,
		0xa7fa
		},
		{
		0x6757,
		0xa841
		},
		{
		0x6759,
		0xcb40
		},
		{
		0x675a,
		0xcb46
		},
		{
		0x675c,
		0xa7f9
		},
		{
		0x675d,
		0xcb44
		},
		{
		0x675e,
		0xa7fb
		},
		{
		0x675f,
		0xa7f4
		},
		{
		0x6760,
		0xa7fe
		},
		{
		0x676a,
		0xaa57
		},
		{
		0x676c,
		0xccd4
		},
		{
		0x676d,
		0xaa43
		},
		{
		0x676f,
		0xaa4d
		},
		{
		0x6770,
		0xaa4e
		},
		{
		0x6771,
		0xaa46
		},
		{
		0x6772,
		0xaa58
		},
		{
		0x6773,
		0xaa48
		},
		{
		0x6774,
		0xccdc
		},
		{
		0x6775,
		0xaa53
		},
		{
		0x6776,
		0xccd7
		},
		{
		0x6777,
		0xaa49
		},
		{
		0x6778,
		0xcce6
		},
		{
		0x6779,
		0xcce7
		},
		{
		0x677a,
		0xccdf
		},
		{
		0x677b,
		0xccd8
		},
		{
		0x677c,
		0xaa56
		},
		{
		0x677d,
		0xcce4
		},
		{
		0x677e,
		0xaa51
		},
		{
		0x677f,
		0xaa4f
		},
		{
		0x6781,
		0xcce5
		},
		{
		0x6783,
		0xcce3
		},
		{
		0x6784,
		0xccdb
		},
		{
		0x6785,
		0xccd3
		},
		{
		0x6786,
		0xccda
		},
		{
		0x6787,
		0xaa4a
		},
		{
		0x6789,
		0xaa50
		},
		{
		0x678b,
		0xaa44
		},
		{
		0x678c,
		0xccde
		},
		{
		0x678d,
		0xccdd
		},
		{
		0x678e,
		0xccd5
		},
		{
		0x6790,
		0xaa52
		},
		{
		0x6791,
		0xcce1
		},
		{
		0x6792,
		0xccd6
		},
		{
		0x6793,
		0xaa55
		},
		{
		0x6794,
		0xcce8
		},
		{
		0x6795,
		0xaa45
		},
		{
		0x6797,
		0xaa4c
		},
		{
		0x6798,
		0xccd9
		},
		{
		0x6799,
		0xcce2
		},
		{
		0x679a,
		0xaa54
		},
		{
		0x679c,
		0xaa47
		},
		{
		0x679d,
		0xaa4b
		},
		{
		0x679f,
		0xcce0
		},
		{
		0x67ae,
		0xcf5b
		},
		{
		0x67af,
		0xac5c
		},
		{
		0x67b0,
		0xac69
		},
		{
		0x67b2,
		0xcf56
		},
		{
		0x67b3,
		0xcf4c
		},
		{
		0x67b4,
		0xac62
		},
		{
		0x67b5,
		0xcf4a
		},
		{
		0x67b6,
		0xac5b
		},
		{
		0x67b7,
		0xcf45
		},
		{
		0x67b8,
		0xac65
		},
		{
		0x67b9,
		0xcf52
		},
		{
		0x67ba,
		0xcefe
		},
		{
		0x67bb,
		0xcf41
		},
		{
		0x67c0,
		0xcf44
		},
		{
		0x67c1,
		0xcefb
		},
		{
		0x67c2,
		0xcf51
		},
		{
		0x67c3,
		0xcf61
		},
		{
		0x67c4,
		0xac60
		},
		{
		0x67c5,
		0xcf46
		},
		{
		0x67c6,
		0xcf58
		},
		{
		0x67c8,
		0xcefd
		},
		{
		0x67c9,
		0xcf5f
		},
		{
		0x67ca,
		0xcf60
		},
		{
		0x67cb,
		0xcf63
		},
		{
		0x67cc,
		0xcf5a
		},
		{
		0x67cd,
		0xcf4b
		},
		{
		0x67ce,
		0xcf53
		},
		{
		0x67cf,
		0xac66
		},
		{
		0x67d0,
		0xac59
		},
		{
		0x67d1,
		0xac61
		},
		{
		0x67d2,
		0xac6d
		},
		{
		0x67d3,
		0xac56
		},
		{
		0x67d4,
		0xac58
		},
		{
		0x67d8,
		0xcf43
		},
		{
		0x67d9,
		0xac6a
		},
		{
		0x67da,
		0xac63
		},
		{
		0x67db,
		0xcf5d
		},
		{
		0x67dc,
		0xcf40
		},
		{
		0x67dd,
		0xac6c
		},
		{
		0x67de,
		0xac67
		},
		{
		0x67df,
		0xcf49
		},
		{
		0x67e2,
		0xac6b
		},
		{
		0x67e3,
		0xcf50
		},
		{
		0x67e4,
		0xcf48
		},
		{
		0x67e5,
		0xac64
		},
		{
		0x67e6,
		0xcf5c
		},
		{
		0x67e7,
		0xcf54
		},
		{
		0x67e9,
		0xac5e
		},
		{
		0x67ea,
		0xcf62
		},
		{
		0x67eb,
		0xcf47
		},
		{
		0x67ec,
		0xac5a
		},
		{
		0x67ed,
		0xcf59
		},
		{
		0x67ee,
		0xcf4f
		},
		{
		0x67ef,
		0xac5f
		},
		{
		0x67f0,
		0xcf55
		},
		{
		0x67f1,
		0xac57
		},
		{
		0x67f2,
		0xcefc
		},
		{
		0x67f3,
		0xac68
		},
		{
		0x67f4,
		0xaee3
		},
		{
		0x67f5,
		0xac5d
		},
		{
		0x67f6,
		0xcf4e
		},
		{
		0x67f7,
		0xcf4d
		},
		{
		0x67f8,
		0xcf42
		},
		{
		0x67fa,
		0xcf5e
		},
		{
		0x67fc,
		0xcf57
		},
		{
		0x67ff,
		0xac55
		},
		{
		0x6812,
		0xd1ec
		},
		{
		0x6813,
		0xaeea
		},
		{
		0x6814,
		0xd1ed
		},
		{
		0x6816,
		0xd1e1
		},
		{
		0x6817,
		0xaedf
		},
		{
		0x6818,
		0xaeeb
		},
		{
		0x681a,
		0xd1da
		},
		{
		0x681c,
		0xd1e3
		},
		{
		0x681d,
		0xd1eb
		},
		{
		0x681f,
		0xd1d9
		},
		{
		0x6820,
		0xd1f4
		},
		{
		0x6821,
		0xaed5
		},
		{
		0x6825,
		0xd1f3
		},
		{
		0x6826,
		0xd1ee
		},
		{
		0x6828,
		0xd1ef
		},
		{
		0x6829,
		0xaedd
		},
		{
		0x682a,
		0xaee8
		},
		{
		0x682b,
		0xd1e5
		},
		{
		0x682d,
		0xd1e6
		},
		{
		0x682e,
		0xd1f0
		},
		{
		0x682f,
		0xd1e7
		},
		{
		0x6831,
		0xd1e2
		},
		{
		0x6832,
		0xd1dc
		},
		{
		0x6833,
		0xd1dd
		},
		{
		0x6834,
		0xd1ea
		},
		{
		0x6835,
		0xd1e4
		},
		{
		0x6838,
		0xaed6
		},
		{
		0x6839,
		0xaeda
		},
		{
		0x683a,
		0xd1f2
		},
		{
		0x683b,
		0xd1de
		},
		{
		0x683c,
		0xaee6
		},
		{
		0x683d,
		0xaee2
		},
		{
		0x6840,
		0xaee5
		},
		{
		0x6841,
		0xaeec
		},
		{
		0x6842,
		0xaedb
		},
		{
		0x6843,
		0xaee7
		},
		{
		0x6844,
		0xd1e9
		},
		{
		0x6845,
		0xaee9
		},
		{
		0x6846,
		0xaed8
		},
		{
		0x6848,
		0xaed7
		},
		{
		0x6849,
		0xd1db
		},
		{
		0x684b,
		0xd1df
		},
		{
		0x684c,
		0xaee0
		},
		{
		0x684d,
		0xd1f1
		},
		{
		0x684e,
		0xd1e8
		},
		{
		0x684f,
		0xd1e0
		},
		{
		0x6850,
		0xaee4
		},
		{
		0x6851,
		0xaee1
		},
		{
		0x6853,
		0xaed9
		},
		{
		0x6854,
		0xaedc
		},
		{
		0x686b,
		0xd5c4
		},
		{
		0x686d,
		0xd5b4
		},
		{
		0x686e,
		0xd5b5
		},
		{
		0x686f,
		0xd5b9
		},
		{
		0x6871,
		0xd5c8
		},
		{
		0x6872,
		0xd5c5
		},
		{
		0x6874,
		0xd5be
		},
		{
		0x6875,
		0xd5bd
		},
		{
		0x6876,
		0xb1ed
		},
		{
		0x6877,
		0xd5c1
		},
		{
		0x6878,
		0xd5d0
		},
		{
		0x6879,
		0xd5b0
		},
		{
		0x687b,
		0xd5d1
		},
		{
		0x687c,
		0xd5c3
		},
		{
		0x687d,
		0xd5d5
		},
		{
		0x687e,
		0xd5c9
		},
		{
		0x687f,
		0xb1ec
		},
		{
		0x6880,
		0xd5c7
		},
		{
		0x6881,
		0xb1e7
		},
		{
		0x6882,
		0xb1fc
		},
		{
		0x6883,
		0xb1f2
		},
		{
		0x6885,
		0xb1f6
		},
		{
		0x6886,
		0xb1f5
		},
		{
		0x6887,
		0xd5b1
		},
		{
		0x6889,
		0xd5ce
		},
		{
		0x688a,
		0xd5d4
		},
		{
		0x688b,
		0xd5cc
		},
		{
		0x688c,
		0xd5d3
		},
		{
		0x688f,
		0xd5c0
		},
		{
		0x6890,
		0xd5b2
		},
		{
		0x6891,
		0xd5d2
		},
		{
		0x6892,
		0xd5c2
		},
		{
		0x6893,
		0xb1ea
		},
		{
		0x6894,
		0xb1f7
		},
		{
		0x6896,
		0xd5cb
		},
		{
		0x6897,
		0xb1f0
		},
		{
		0x689b,
		0xd5ca
		},
		{
		0x689c,
		0xd5b3
		},
		{
		0x689d,
		0xb1f8
		},
		{
		0x689f,
		0xb1fa
		},
		{
		0x68a0,
		0xd5cd
		},
		{
		0x68a1,
		0xb1fb
		},
		{
		0x68a2,
		0xb1e9
		},
		{
		0x68a3,
		0xd5ba
		},
		{
		0x68a4,
		0xd5cf
		},
		{
		0x68a7,
		0xb1ef
		},
		{
		0x68a8,
		0xb1f9
		},
		{
		0x68a9,
		0xd5bc
		},
		{
		0x68aa,
		0xd5c6
		},
		{
		0x68ab,
		0xd5b7
		},
		{
		0x68ac,
		0xd5bb
		},
		{
		0x68ad,
		0xb1f4
		},
		{
		0x68ae,
		0xd5b6
		},
		{
		0x68af,
		0xb1e8
		},
		{
		0x68b0,
		0xb1f1
		},
		{
		0x68b1,
		0xb1ee
		},
		{
		0x68b2,
		0xd5bf
		},
		{
		0x68b3,
		0xaede
		},
		{
		0x68b4,
		0xd9c0
		},
		{
		0x68b5,
		0xb1eb
		},
		{
		0x68c4,
		0xb1f3
		},
		{
		0x68c6,
		0xd9c3
		},
		{
		0x68c7,
		0xd9d9
		},
		{
		0x68c8,
		0xd9ce
		},
		{
		0x68c9,
		0xb4d6
		},
		{
		0x68cb,
		0xb4d1
		},
		{
		0x68cc,
		0xd9bd
		},
		{
		0x68cd,
		0xb4d2
		},
		{
		0x68ce,
		0xd9cd
		},
		{
		0x68d0,
		0xd9c6
		},
		{
		0x68d1,
		0xd9d3
		},
		{
		0x68d2,
		0xb4ce
		},
		{
		0x68d3,
		0xd9ab
		},
		{
		0x68d4,
		0xd9d5
		},
		{
		0x68d5,
		0xb4c4
		},
		{
		0x68d6,
		0xd9b3
		},
		{
		0x68d7,
		0xb4c7
		},
		{
		0x68d8,
		0xb4c6
		},
		{
		0x68da,
		0xb4d7
		},
		{
		0x68dc,
		0xd9ad
		},
		{
		0x68dd,
		0xd9cf
		},
		{
		0x68de,
		0xd9d0
		},
		{
		0x68df,
		0xb4c9
		},
		{
		0x68e0,
		0xb4c5
		},
		{
		0x68e1,
		0xd9bb
		},
		{
		0x68e3,
		0xb4d0
		},
		{
		0x68e4,
		0xd9b6
		},
		{
		0x68e6,
		0xd9d1
		},
		{
		0x68e7,
		0xb4cc
		},
		{
		0x68e8,
		0xd9c9
		},
		{
		0x68e9,
		0xd9d6
		},
		{
		0x68ea,
		0xd9b0
		},
		{
		0x68eb,
		0xd9b5
		},
		{
		0x68ec,
		0xd9af
		},
		{
		0x68ee,
		0xb4cb
		},
		{
		0x68ef,
		0xd9c2
		},
		{
		0x68f0,
		0xddde
		},
		{
		0x68f1,
		0xd9b1
		},
		{
		0x68f2,
		0xb4cf
		},
		{
		0x68f3,
		0xd9ba
		},
		{
		0x68f4,
		0xd9d2
		},
		{
		0x68f5,
		0xb4ca
		},
		{
		0x68f6,
		0xd9b7
		},
		{
		0x68f7,
		0xd9b4
		},
		{
		0x68f8,
		0xd9c5
		},
		{
		0x68f9,
		0xb4cd
		},
		{
		0x68fa,
		0xb4c3
		},
		{
		0x68fb,
		0xb4d9
		},
		{
		0x68fc,
		0xd9c8
		},
		{
		0x68fd,
		0xd9c7
		},
		{
		0x6904,
		0xd9ac
		},
		{
		0x6905,
		0xb4c8
		},
		{
		0x6906,
		0xd9d4
		},
		{
		0x6907,
		0xd9bc
		},
		{
		0x6908,
		0xd9be
		},
		{
		0x690a,
		0xd9cb
		},
		{
		0x690b,
		0xd9ca
		},
		{
		0x690c,
		0xd9aa
		},
		{
		0x690d,
		0xb4d3
		},
		{
		0x690e,
		0xb4d5
		},
		{
		0x690f,
		0xd9b2
		},
		{
		0x6910,
		0xd9b9
		},
		{
		0x6911,
		0xd9c1
		},
		{
		0x6912,
		0xb4d4
		},
		{
		0x6913,
		0xd9b8
		},
		{
		0x6914,
		0xd9c4
		},
		{
		0x6915,
		0xd9d7
		},
		{
		0x6917,
		0xd9cc
		},
		{
		0x6925,
		0xd9d8
		},
		{
		0x692a,
		0xd9ae
		},
		{
		0x692f,
		0xddf2
		},
		{
		0x6930,
		0xb7a6
		},
		{
		0x6932,
		0xddf0
		},
		{
		0x6933,
		0xdddb
		},
		{
		0x6934,
		0xdde0
		},
		{
		0x6935,
		0xddd9
		},
		{
		0x6937,
		0xddec
		},
		{
		0x6938,
		0xddcb
		},
		{
		0x6939,
		0xddd2
		},
		{
		0x693b,
		0xddea
		},
		{
		0x693c,
		0xddf4
		},
		{
		0x693d,
		0xdddc
		},
		{
		0x693f,
		0xddcf
		},
		{
		0x6940,
		0xdde2
		},
		{
		0x6941,
		0xdde7
		},
		{
		0x6942,
		0xddd3
		},
		{
		0x6944,
		0xdde4
		},
		{
		0x6945,
		0xddd0
		},
		{
		0x6948,
		0xddd7
		},
		{
		0x6949,
		0xddd8
		},
		{
		0x694a,
		0xb7a8
		},
		{
		0x694b,
		0xddeb
		},
		{
		0x694c,
		0xdde9
		},
		{
		0x694e,
		0xddcc
		},
		{
		0x694f,
		0xddee
		},
		{
		0x6951,
		0xddef
		},
		{
		0x6952,
		0xddf1
		},
		{
		0x6953,
		0xb7ac
		},
		{
		0x6954,
		0xb7a4
		},
		{
		0x6956,
		0xd5b8
		},
		{
		0x6957,
		0xddd4
		},
		{
		0x6958,
		0xdde6
		},
		{
		0x6959,
		0xddd5
		},
		{
		0x695a,
		0xb7a1
		},
		{
		0x695b,
		0xb7b1
		},
		{
		0x695c,
		0xdded
		},
		{
		0x695d,
		0xb7af
		},
		{
		0x695e,
		0xb7ab
		},
		{
		0x695f,
		0xddca
		},
		{
		0x6960,
		0xb7a3
		},
		{
		0x6962,
		0xddcd
		},
		{
		0x6963,
		0xb7b0
		},
		{
		0x6965,
		0xdddd
		},
		{
		0x6966,
		0xddc9
		},
		{
		0x6968,
		0xb7a9
		},
		{
		0x6969,
		0xdde1
		},
		{
		0x696a,
		0xddd1
		},
		{
		0x696b,
		0xb7aa
		},
		{
		0x696c,
		0xddda
		},
		{
		0x696d,
		0xb77e
		},
		{
		0x696e,
		0xb4d8
		},
		{
		0x696f,
		0xdde3
		},
		{
		0x6970,
		0xd9bf
		},
		{
		0x6971,
		0xddce
		},
		{
		0x6974,
		0xdde8
		},
		{
		0x6975,
		0xb7a5
		},
		{
		0x6976,
		0xdde5
		},
		{
		0x6977,
		0xb7a2
		},
		{
		0x6978,
		0xdddf
		},
		{
		0x6979,
		0xb7ad
		},
		{
		0x697a,
		0xddd6
		},
		{
		0x697b,
		0xddf3
		},
		{
		0x6982,
		0xb7a7
		},
		{
		0x6983,
		0xdec6
		},
		{
		0x6986,
		0xb7ae
		},
		{
		0x698d,
		0xe24a
		},
		{
		0x698e,
		0xe248
		},
		{
		0x6990,
		0xe25e
		},
		{
		0x6991,
		0xe246
		},
		{
		0x6993,
		0xe258
		},
		{
		0x6994,
		0xb77d
		},
		{
		0x6995,
		0xba5f
		},
		{
		0x6996,
		0xe242
		},
		{
		0x6997,
		0xe25d
		},
		{
		0x6999,
		0xe247
		},
		{
		0x699a,
		0xe255
		},
		{
		0x699b,
		0xba64
		},
		{
		0x699c,
		0xba5d
		},
		{
		0x699e,
		0xe25b
		},
		{
		0x69a0,
		0xe240
		},
		{
		0x69a1,
		0xe25a
		},
		{
		0x69a3,
		0xba6f
		},
		{
		0x69a4,
		0xe251
		},
		{
		0x69a5,
		0xe261
		},
		{
		0x69a6,
		0xba6d
		},
		{
		0x69a7,
		0xe249
		},
		{
		0x69a8,
		0xba5e
		},
		{
		0x69a9,
		0xe24b
		},
		{
		0x69aa,
		0xe259
		},
		{
		0x69ab,
		0xba67
		},
		{
		0x69ac,
		0xe244
		},
		{
		0x69ad,
		0xba6b
		},
		{
		0x69ae,
		0xba61
		},
		{
		0x69af,
		0xe24d
		},
		{
		0x69b0,
		0xe243
		},
		{
		0x69b1,
		0xe1fc
		},
		{
		0x69b3,
		0xe257
		},
		{
		0x69b4,
		0xba68
		},
		{
		0x69b5,
		0xe260
		},
		{
		0x69b6,
		0xe1fd
		},
		{
		0x69b7,
		0xba65
		},
		{
		0x69b9,
		0xe253
		},
		{
		0x69bb,
		0xba66
		},
		{
		0x69bc,
		0xe245
		},
		{
		0x69bd,
		0xe250
		},
		{
		0x69be,
		0xe24c
		},
		{
		0x69bf,
		0xe24e
		},
		{
		0x69c1,
		0xba60
		},
		{
		0x69c2,
		0xe25f
		},
		{
		0x69c3,
		0xba6e
		},
		{
		0x69c4,
		0xe24f
		},
		{
		0x69c6,
		0xe262
		},
		{
		0x69c9,
		0xe1fe
		},
		{
		0x69ca,
		0xe254
		},
		{
		0x69cb,
		0xba63
		},
		{
		0x69cc,
		0xba6c
		},
		{
		0x69cd,
		0xba6a
		},
		{
		0x69ce,
		0xe241
		},
		{
		0x69cf,
		0xe256
		},
		{
		0x69d0,
		0xba69
		},
		{
		0x69d3,
		0xba62
		},
		{
		0x69d4,
		0xe252
		},
		{
		0x69d9,
		0xe25c
		},
		{
		0x69e2,
		0xe5d5
		},
		{
		0x69e4,
		0xe5d1
		},
		{
		0x69e5,
		0xe5cd
		},
		{
		0x69e6,
		0xe5e1
		},
		{
		0x69e7,
		0xe5de
		},
		{
		0x69e8,
		0xbccd
		},
		{
		0x69eb,
		0xe5e5
		},
		{
		0x69ec,
		0xe5d4
		},
		{
		0x69ed,
		0xbcd8
		},
		{
		0x69ee,
		0xe5db
		},
		{
		0x69f1,
		0xe5d0
		},
		{
		0x69f2,
		0xe5da
		},
		{
		0x69f3,
		0xbcd5
		},
		{
		0x69f4,
		0xe5ee
		},
		{
		0x69f6,
		0xe5eb
		},
		{
		0x69f7,
		0xe5dd
		},
		{
		0x69f8,
		0xe5ce
		},
		{
		0x69fb,
		0xe5e2
		},
		{
		0x69fc,
		0xe5e4
		},
		{
		0x69fd,
		0xbcd1
		},
		{
		0x69fe,
		0xe5d8
		},
		{
		0x69ff,
		0xe5d3
		},
		{
		0x6a00,
		0xe5ca
		},
		{
		0x6a01,
		0xbcce
		},
		{
		0x6a02,
		0xbcd6
		},
		{
		0x6a04,
		0xe5e7
		},
		{
		0x6a05,
		0xbcd7
		},
		{
		0x6a06,
		0xe5cb
		},
		{
		0x6a07,
		0xe5ed
		},
		{
		0x6a08,
		0xe5e0
		},
		{
		0x6a09,
		0xe5e6
		},
		{
		0x6a0a,
		0xbcd4
		},
		{
		0x6a0d,
		0xe5e3
		},
		{
		0x6a0f,
		0xe5ea
		},
		{
		0x6a11,
		0xbcd9
		},
		{
		0x6a13,
		0xbcd3
		},
		{
		0x6a14,
		0xe5dc
		},
		{
		0x6a15,
		0xe5cf
		},
		{
		0x6a16,
		0xe5ef
		},
		{
		0x6a17,
		0xe5cc
		},
		{
		0x6a18,
		0xe5e8
		},
		{
		0x6a19,
		0xbcd0
		},
		{
		0x6a1b,
		0xe5d6
		},
		{
		0x6a1d,
		0xe5d7
		},
		{
		0x6a1e,
		0xbccf
		},
		{
		0x6a1f,
		0xbccc
		},
		{
		0x6a20,
		0xe5d2
		},
		{
		0x6a21,
		0xbcd2
		},
		{
		0x6a23,
		0xbccb
		},
		{
		0x6a25,
		0xe5e9
		},
		{
		0x6a26,
		0xe5ec
		},
		{
		0x6a27,
		0xe5d9
		},
		{
		0x6a28,
		0xe9ca
		},
		{
		0x6a32,
		0xe9c2
		},
		{
		0x6a34,
		0xe9be
		},
		{
		0x6a35,
		0xbef6
		},
		{
		0x6a38,
		0xbeeb
		},
		{
		0x6a39,
		0xbef0
		},
		{
		0x6a3a,
		0xbeec
		},
		{
		0x6a3b,
		0xe9cc
		},
		{
		0x6a3c,
		0xe9d7
		},
		{
		0x6a3d,
		0xbeea
		},
		{
		0x6a3e,
		0xe9c4
		},
		{
		0x6a3f,
		0xe9cd
		},
		{
		0x6a40,
		0xe5df
		},
		{
		0x6a41,
		0xe9ce
		},
		{
		0x6a44,
		0xbef1
		},
		{
		0x6a46,
		0xe9dd
		},
		{
		0x6a47,
		0xbef5
		},
		{
		0x6a48,
		0xbef8
		},
		{
		0x6a49,
		0xe9c0
		},
		{
		0x6a4b,
		0xbef4
		},
		{
		0x6a4d,
		0xe9db
		},
		{
		0x6a4e,
		0xe9dc
		},
		{
		0x6a4f,
		0xe9d2
		},
		{
		0x6a50,
		0xe9d1
		},
		{
		0x6a51,
		0xe9c9
		},
		{
		0x6a54,
		0xe9d3
		},
		{
		0x6a55,
		0xe9da
		},
		{
		0x6a56,
		0xe9d9
		},
		{
		0x6a58,
		0xbeef
		},
		{
		0x6a59,
		0xbeed
		},
		{
		0x6a5a,
		0xe9cb
		},
		{
		0x6a5b,
		0xe9c8
		},
		{
		0x6a5d,
		0xe9c5
		},
		{
		0x6a5e,
		0xe9d8
		},
		{
		0x6a5f,
		0xbef7
		},
		{
		0x6a60,
		0xe9d6
		},
		{
		0x6a61,
		0xbef3
		},
		{
		0x6a62,
		0xbef2
		},
		{
		0x6a64,
		0xe9d0
		},
		{
		0x6a66,
		0xe9bf
		},
		{
		0x6a67,
		0xe9c1
		},
		{
		0x6a68,
		0xe9c3
		},
		{
		0x6a69,
		0xe9d5
		},
		{
		0x6a6a,
		0xe9cf
		},
		{
		0x6a6b,
		0xbeee
		},
		{
		0x6a6d,
		0xe9c6
		},
		{
		0x6a6f,
		0xe9d4
		},
		{
		0x6a76,
		0xe9c7
		},
		{
		0x6a7e,
		0xc0cf
		},
		{
		0x6a7f,
		0xed45
		},
		{
		0x6a80,
		0xc0c8
		},
		{
		0x6a81,
		0xecf5
		},
		{
		0x6a83,
		0xed41
		},
		{
		0x6a84,
		0xc0ca
		},
		{
		0x6a85,
		0xed48
		},
		{
		0x6a87,
		0xecfc
		},
		{
		0x6a89,
		0xecf7
		},
		{
		0x6a8c,
		0xed49
		},
		{
		0x6a8d,
		0xecf3
		},
		{
		0x6a8e,
		0xecfe
		},
		{
		0x6a90,
		0xc0d1
		},
		{
		0x6a91,
		0xed44
		},
		{
		0x6a92,
		0xed4a
		},
		{
		0x6a93,
		0xecfd
		},
		{
		0x6a94,
		0xc0c9
		},
		{
		0x6a95,
		0xed40
		},
		{
		0x6a96,
		0xecf4
		},
		{
		0x6a97,
		0xc0d0
		},
		{
		0x6a9a,
		0xed47
		},
		{
		0x6a9b,
		0xecf9
		},
		{
		0x6a9c,
		0xc0cc
		},
		{
		0x6a9e,
		0xecfb
		},
		{
		0x6a9f,
		0xecf8
		},
		{
		0x6aa0,
		0xc0d2
		},
		{
		0x6aa1,
		0xecfa
		},
		{
		0x6aa2,
		0xc0cb
		},
		{
		0x6aa3,
		0xc0ce
		},
		{
		0x6aa4,
		0xed43
		},
		{
		0x6aa5,
		0xecf6
		},
		{
		0x6aa6,
		0xed46
		},
		{
		0x6aa8,
		0xed42
		},
		{
		0x6aac,
		0xc263
		},
		{
		0x6aad,
		0xefe7
		},
		{
		0x6aae,
		0xc268
		},
		{
		0x6aaf,
		0xc269
		},
		{
		0x6ab3,
		0xc262
		},
		{
		0x6ab4,
		0xefe6
		},
		{
		0x6ab6,
		0xefe3
		},
		{
		0x6ab7,
		0xefe4
		},
		{
		0x6ab8,
		0xc266
		},
		{
		0x6ab9,
		0xefde
		},
		{
		0x6aba,
		0xefe2
		},
		{
		0x6abb,
		0xc265
		},
		{
		0x6abd,
		0xefdf
		},
		{
		0x6ac2,
		0xc267
		},
		{
		0x6ac3,
		0xc264
		},
		{
		0x6ac5,
		0xefdd
		},
		{
		0x6ac6,
		0xefe1
		},
		{
		0x6ac7,
		0xefe5
		},
		{
		0x6acb,
		0xf251
		},
		{
		0x6acc,
		0xf24e
		},
		{
		0x6acd,
		0xf257
		},
		{
		0x6acf,
		0xf256
		},
		{
		0x6ad0,
		0xf254
		},
		{
		0x6ad1,
		0xf24f
		},
		{
		0x6ad3,
		0xc372
		},
		{
		0x6ad9,
		0xf250
		},
		{
		0x6ada,
		0xc371
		},
		{
		0x6adb,
		0xc0cd
		},
		{
		0x6adc,
		0xf253
		},
		{
		0x6add,
		0xc370
		},
		{
		0x6ade,
		0xf258
		},
		{
		0x6adf,
		0xf252
		},
		{
		0x6ae0,
		0xf24d
		},
		{
		0x6ae1,
		0xefe0
		},
		{
		0x6ae5,
		0xc36f
		},
		{
		0x6ae7,
		0xf24c
		},
		{
		0x6ae8,
		0xf456
		},
		{
		0x6aea,
		0xf455
		},
		{
		0x6aeb,
		0xf255
		},
		{
		0x6aec,
		0xc468
		},
		{
		0x6aee,
		0xf459
		},
		{
		0x6aef,
		0xf45a
		},
		{
		0x6af0,
		0xf454
		},
		{
		0x6af1,
		0xf458
		},
		{
		0x6af3,
		0xf453
		},
		{
		0x6af8,
		0xf5d1
		},
		{
		0x6af9,
		0xf457
		},
		{
		0x6afa,
		0xc4e7
		},
		{
		0x6afb,
		0xc4e5
		},
		{
		0x6afc,
		0xf5cf
		},
		{
		0x6b00,
		0xf5d2
		},
		{
		0x6b02,
		0xf5ce
		},
		{
		0x6b03,
		0xf5d0
		},
		{
		0x6b04,
		0xc4e6
		},
		{
		0x6b08,
		0xf6e5
		},
		{
		0x6b09,
		0xf6e6
		},
		{
		0x6b0a,
		0xc576
		},
		{
		0x6b0b,
		0xf6e4
		},
		{
		0x6b0f,
		0xf7e2
		},
		{
		0x6b10,
		0xc5cf
		},
		{
		0x6b11,
		0xf7e0
		},
		{
		0x6b12,
		0xf7e1
		},
		{
		0x6b13,
		0xf8ac
		},
		{
		0x6b16,
		0xc656
		},
		{
		0x6b17,
		0xf8f3
		},
		{
		0x6b18,
		0xf8f1
		},
		{
		0x6b19,
		0xf8f2
		},
		{
		0x6b1a,
		0xf8f4
		},
		{
		0x6b1e,
		0xf9bb
		},
		{
		0x6b20,
		0xa4ed
		},
		{
		0x6b21,
		0xa6b8
		},
		{
		0x6b23,
		0xaa59
		},
		{
		0x6b25,
		0xcce9
		},
		{
		0x6b28,
		0xcf64
		},
		{
		0x6b2c,
		0xd1f5
		},
		{
		0x6b2d,
		0xd1f7
		},
		{
		0x6b2f,
		0xd1f6
		},
		{
		0x6b31,
		0xd1f8
		},
		{
		0x6b32,
		0xb1fd
		},
		{
		0x6b33,
		0xd5d7
		},
		{
		0x6b34,
		0xd1f9
		},
		{
		0x6b36,
		0xd5d6
		},
		{
		0x6b37,
		0xd5d8
		},
		{
		0x6b38,
		0xd5d9
		},
		{
		0x6b39,
		0xd9da
		},
		{
		0x6b3a,
		0xb4db
		},
		{
		0x6b3b,
		0xd9db
		},
		{
		0x6b3c,
		0xd9dd
		},
		{
		0x6b3d,
		0xb4dc
		},
		{
		0x6b3e,
		0xb4da
		},
		{
		0x6b3f,
		0xd9dc
		},
		{
		0x6b41,
		0xddfa
		},
		{
		0x6b42,
		0xddf8
		},
		{
		0x6b43,
		0xddf7
		},
		{
		0x6b45,
		0xddf6
		},
		{
		0x6b46,
		0xddf5
		},
		{
		0x6b47,
		0xb7b2
		},
		{
		0x6b48,
		0xddf9
		},
		{
		0x6b49,
		0xba70
		},
		{
		0x6b4a,
		0xe263
		},
		{
		0x6b4b,
		0xe265
		},
		{
		0x6b4c,
		0xba71
		},
		{
		0x6b4d,
		0xe264
		},
		{
		0x6b4e,
		0xbcdb
		},
		{
		0x6b50,
		0xbcda
		},
		{
		0x6b51,
		0xe5f0
		},
		{
		0x6b54,
		0xe9df
		},
		{
		0x6b55,
		0xe9de
		},
		{
		0x6b56,
		0xe9e0
		},
		{
		0x6b59,
		0xbef9
		},
		{
		0x6b5b,
		0xed4b
		},
		{
		0x6b5c,
		0xc0d3
		},
		{
		0x6b5e,
		0xefe8
		},
		{
		0x6b5f,
		0xc26a
		},
		{
		0x6b60,
		0xf259
		},
		{
		0x6b61,
		0xc577
		},
		{
		0x6b62,
		0xa4ee
		},
		{
		0x6b63,
		0xa5bf
		},
		{
		0x6b64,
		0xa6b9
		},
		{
		0x6b65,
		0xa842
		},
		{
		0x6b66,
		0xaa5a
		},
		{
		0x6b67,
		0xaa5b
		},
		{
		0x6b6a,
		0xac6e
		},
		{
		0x6b6d,
		0xd1fa
		},
		{
		0x6b72,
		0xb7b3
		},
		{
		0x6b76,
		0xe6d1
		},
		{
		0x6b77,
		0xbefa
		},
		{
		0x6b78,
		0xc26b
		},
		{
		0x6b79,
		0xa4ef
		},
		{
		0x6b7b,
		0xa6ba
		},
		{
		0x6b7e,
		0xcceb
		},
		{
		0x6b7f,
		0xaa5c
		},
		{
		0x6b80,
		0xccea
		},
		{
		0x6b82,
		0xcf65
		},
		{
		0x6b83,
		0xac6f
		},
		{
		0x6b84,
		0xcf66
		},
		{
		0x6b86,
		0xac70
		},
		{
		0x6b88,
		0xd1fc
		},
		{
		0x6b89,
		0xaeee
		},
		{
		0x6b8a,
		0xaeed
		},
		{
		0x6b8c,
		0xd5de
		},
		{
		0x6b8d,
		0xd5dc
		},
		{
		0x6b8e,
		0xd5dd
		},
		{
		0x6b8f,
		0xd5db
		},
		{
		0x6b91,
		0xd5da
		},
		{
		0x6b94,
		0xd9de
		},
		{
		0x6b95,
		0xd9e1
		},
		{
		0x6b96,
		0xb4de
		},
		{
		0x6b97,
		0xd9df
		},
		{
		0x6b98,
		0xb4dd
		},
		{
		0x6b99,
		0xd9e0
		},
		{
		0x6b9b,
		0xddfb
		},
		{
		0x6b9e,
		0xe266
		},
		{
		0x6b9f,
		0xe267
		},
		{
		0x6ba0,
		0xe268
		},
		{
		0x6ba2,
		0xe5f3
		},
		{
		0x6ba3,
		0xe5f2
		},
		{
		0x6ba4,
		0xbcdc
		},
		{
		0x6ba5,
		0xe5f1
		},
		{
		0x6ba6,
		0xe5f4
		},
		{
		0x6ba7,
		0xe9e1
		},
		{
		0x6baa,
		0xe9e2
		},
		{
		0x6bab,
		0xe9e3
		},
		{
		0x6bad,
		0xed4c
		},
		{
		0x6bae,
		0xc0d4
		},
		{
		0x6baf,
		0xc26c
		},
		{
		0x6bb0,
		0xf25a
		},
		{
		0x6bb2,
		0xc4e8
		},
		{
		0x6bb3,
		0xc95f
		},
		{
		0x6bb5,
		0xac71
		},
		{
		0x6bb6,
		0xcf67
		},
		{
		0x6bb7,
		0xaeef
		},
		{
		0x6bba,
		0xb1fe
		},
		{
		0x6bbc,
		0xb4df
		},
		{
		0x6bbd,
		0xd9e2
		},
		{
		0x6bbf,
		0xb7b5
		},
		{
		0x6bc0,
		0xb7b4
		},
		{
		0x6bc3,
		0xe269
		},
		{
		0x6bc4,
		0xe26a
		},
		{
		0x6bc5,
		0xbcdd
		},
		{
		0x6bc6,
		0xbcde
		},
		{
		0x6bc7,
		0xe9e5
		},
		{
		0x6bc8,
		0xe9e4
		},
		{
		0x6bc9,
		0xefe9
		},
		{
		0x6bca,
		0xf7e3
		},
		{
		0x6bcb,
		0xa4f0
		},
		{
		0x6bcc,
		0xc960
		},
		{
		0x6bcd,
		0xa5c0
		},
		{
		0x6bcf,
		0xa843
		},
		{
		0x6bd0,
		0xcb48
		},
		{
		0x6bd2,
		0xac72
		},
		{
		0x6bd3,
		0xb7b6
		},
		{
		0x6bd4,
		0xa4f1
		},
		{
		0x6bd6,
		0xcf68
		},
		{
		0x6bd7,
		0xac73
		},
		{
		0x6bd8,
		0xcf69
		},
		{
		0x6bda,
		0xc0d5
		},
		{
		0x6bdb,
		0xa4f2
		},
		{
		0x6bde,
		0xccec
		},
		{
		0x6be0,
		0xcf6a
		},
		{
		0x6be2,
		0xd242
		},
		{
		0x6be3,
		0xd241
		},
		{
		0x6be4,
		0xd1fe
		},
		{
		0x6be6,
		0xd1fd
		},
		{
		0x6be7,
		0xd243
		},
		{
		0x6be8,
		0xd240
		},
		{
		0x6beb,
		0xb240
		},
		{
		0x6bec,
		0xb241
		},
		{
		0x6bef,
		0xb4e0
		},
		{
		0x6bf0,
		0xd9e3
		},
		{
		0x6bf2,
		0xd9e4
		},
		{
		0x6bf3,
		0xd9e5
		},
		{
		0x6bf7,
		0xde41
		},
		{
		0x6bf8,
		0xde42
		},
		{
		0x6bf9,
		0xde40
		},
		{
		0x6bfb,
		0xddfd
		},
		{
		0x6bfc,
		0xddfe
		},
		{
		0x6bfd,
		0xb7b7
		},
		{
		0x6bfe,
		0xe26b
		},
		{
		0x6bff,
		0xe5f7
		},
		{
		0x6c00,
		0xe5f6
		},
		{
		0x6c01,
		0xe5f5
		},
		{
		0x6c02,
		0xe5f8
		},
		{
		0x6c03,
		0xe9e7
		},
		{
		0x6c04,
		0xe9e6
		},
		{
		0x6c05,
		0xbefb
		},
		{
		0x6c06,
		0xe9e8
		},
		{
		0x6c08,
		0xc0d6
		},
		{
		0x6c09,
		0xed4d
		},
		{
		0x6c0b,
		0xefea
		},
		{
		0x6c0c,
		0xf25b
		},
		{
		0x6c0d,
		0xf6e7
		},
		{
		0x6c0f,
		0xa4f3
		},
		{
		0x6c10,
		0xa5c2
		},
		{
		0x6c11,
		0xa5c1
		},
		{
		0x6c13,
		0xaa5d
		},
		{
		0x6c14,
		0xc961
		},
		{
		0x6c15,
		0xc97e
		},
		{
		0x6c16,
		0xa6bb
		},
		{
		0x6c18,
		0xc9f7
		},
		{
		0x6c19,
		0xcb49
		},
		{
		0x6c1a,
		0xcb4a
		},
		{
		0x6c1b,
		0xaa5e
		},
		{
		0x6c1d,
		0xcced
		},
		{
		0x6c1f,
		0xac74
		},
		{
		0x6c20,
		0xcf6b
		},
		{
		0x6c21,
		0xcf6c
		},
		{
		0x6c23,
		0xaef0
		},
		{
		0x6c24,
		0xaef4
		},
		{
		0x6c25,
		0xd244
		},
		{
		0x6c26,
		0xaef3
		},
		{
		0x6c27,
		0xaef1
		},
		{
		0x6c28,
		0xaef2
		},
		{
		0x6c2a,
		0xd5df
		},
		{
		0x6c2b,
		0xb242
		},
		{
		0x6c2c,
		0xb4e3
		},
		{
		0x6c2e,
		0xb4e1
		},
		{
		0x6c2f,
		0xb4e2
		},
		{
		0x6c30,
		0xd9e6
		},
		{
		0x6c33,
		0xba72
		},
		{
		0x6c34,
		0xa4f4
		},
		{
		0x6c36,
		0xc9a1
		},
		{
		0x6c38,
		0xa5c3
		},
		{
		0x6c3b,
		0xc9a4
		},
		{
		0x6c3e,
		0xa5c6
		},
		{
		0x6c3f,
		0xc9a3
		},
		{
		0x6c40,
		0xa5c5
		},
		{
		0x6c41,
		0xa5c4
		},
		{
		0x6c42,
		0xa844
		},
		{
		0x6c43,
		0xc9a2
		},
		{
		0x6c46,
		0xc9f8
		},
		{
		0x6c4a,
		0xc9fc
		},
		{
		0x6c4b,
		0xc9fe
		},
		{
		0x6c4c,
		0xca40
		},
		{
		0x6c4d,
		0xa6c5
		},
		{
		0x6c4e,
		0xa6c6
		},
		{
		0x6c4f,
		0xc9fb
		},
		{
		0x6c50,
		0xa6c1
		},
		{
		0x6c52,
		0xc9f9
		},
		{
		0x6c54,
		0xc9fd
		},
		{
		0x6c55,
		0xa6c2
		},
		{
		0x6c57,
		0xa6bd
		},
		{
		0x6c59,
		0xa6be
		},
		{
		0x6c5b,
		0xa6c4
		},
		{
		0x6c5c,
		0xc9fa
		},
		{
		0x6c5d,
		0xa6bc
		},
		{
		0x6c5e,
		0xa845
		},
		{
		0x6c5f,
		0xa6bf
		},
		{
		0x6c60,
		0xa6c0
		},
		{
		0x6c61,
		0xa6c3
		},
		{
		0x6c65,
		0xcb5b
		},
		{
		0x6c66,
		0xcb59
		},
		{
		0x6c67,
		0xcb4c
		},
		{
		0x6c68,
		0xa851
		},
		{
		0x6c69,
		0xcb53
		},
		{
		0x6c6a,
		0xa84c
		},
		{
		0x6c6b,
		0xcb4d
		},
		{
		0x6c6d,
		0xcb55
		},
		{
		0x6c6f,
		0xcb52
		},
		{
		0x6c70,
		0xa84f
		},
		{
		0x6c71,
		0xcb51
		},
		{
		0x6c72,
		0xa856
		},
		{
		0x6c73,
		0xcb5a
		},
		{
		0x6c74,
		0xa858
		},
		{
		0x6c76,
		0xa85a
		},
		{
		0x6c78,
		0xcb4b
		},
		{
		0x6c7a,
		0xa84d
		},
		{
		0x6c7b,
		0xcb5c
		},
		{
		0x6c7d,
		0xa854
		},
		{
		0x6c7e,
		0xa857
		},
		{
		0x6c80,
		0xcd45
		},
		{
		0x6c81,
		0xa847
		},
		{
		0x6c82,
		0xa85e
		},
		{
		0x6c83,
		0xa855
		},
		{
		0x6c84,
		0xcb4e
		},
		{
		0x6c85,
		0xa84a
		},
		{
		0x6c86,
		0xa859
		},
		{
		0x6c87,
		0xcb56
		},
		{
		0x6c88,
		0xa848
		},
		{
		0x6c89,
		0xa849
		},
		{
		0x6c8a,
		0xcd43
		},
		{
		0x6c8b,
		0xcb4f
		},
		{
		0x6c8c,
		0xa850
		},
		{
		0x6c8d,
		0xa85b
		},
		{
		0x6c8e,
		0xcb5d
		},
		{
		0x6c8f,
		0xcb50
		},
		{
		0x6c90,
		0xa84e
		},
		{
		0x6c92,
		0xa853
		},
		{
		0x6c93,
		0xccee
		},
		{
		0x6c94,
		0xa85c
		},
		{
		0x6c95,
		0xcb57
		},
		{
		0x6c96,
		0xa852
		},
		{
		0x6c98,
		0xa85d
		},
		{
		0x6c99,
		0xa846
		},
		{
		0x6c9a,
		0xcb54
		},
		{
		0x6c9b,
		0xa84b
		},
		{
		0x6c9c,
		0xcb58
		},
		{
		0x6c9d,
		0xcd44
		},
		{
		0x6cab,
		0xaa6a
		},
		{
		0x6cac,
		0xaa7a
		},
		{
		0x6cad,
		0xccf5
		},
		{
		0x6cae,
		0xaa71
		},
		{
		0x6cb0,
		0xcd4b
		},
		{
		0x6cb1,
		0xaa62
		},
		{
		0x6cb3,
		0xaa65
		},
		{
		0x6cb4,
		0xcd42
		},
		{
		0x6cb6,
		0xccf3
		},
		{
		0x6cb7,
		0xccf7
		},
		{
		0x6cb8,
		0xaa6d
		},
		{
		0x6cb9,
		0xaa6f
		},
		{
		0x6cba,
		0xccfa
		},
		{
		0x6cbb,
		0xaa76
		},
		{
		0x6cbc,
		0xaa68
		},
		{
		0x6cbd,
		0xaa66
		},
		{
		0x6cbe,
		0xaa67
		},
		{
		0x6cbf,
		0xaa75
		},
		{
		0x6cc0,
		0xcd47
		},
		{
		0x6cc1,
		0xaa70
		},
		{
		0x6cc2,
		0xccf9
		},
		{
		0x6cc3,
		0xccfb
		},
		{
		0x6cc4,
		0xaa6e
		},
		{
		0x6cc5,
		0xaa73
		},
		{
		0x6cc6,
		0xccfc
		},
		{
		0x6cc7,
		0xcd4a
		},
		{
		0x6cc9,
		0xac75
		},
		{
		0x6cca,
		0xaa79
		},
		{
		0x6ccc,
		0xaa63
		},
		{
		0x6ccd,
		0xcd49
		},
		{
		0x6ccf,
		0xcd4d
		},
		{
		0x6cd0,
		0xccf8
		},
		{
		0x6cd1,
		0xcd4f
		},
		{
		0x6cd2,
		0xcd40
		},
		{
		0x6cd3,
		0xaa6c
		},
		{
		0x6cd4,
		0xccf4
		},
		{
		0x6cd5,
		0xaa6b
		},
		{
		0x6cd6,
		0xaa7d
		},
		{
		0x6cd7,
		0xaa72
		},
		{
		0x6cd9,
		0xccf2
		},
		{
		0x6cda,
		0xcf75
		},
		{
		0x6cdb,
		0xaa78
		},
		{
		0x6cdc,
		0xaa7c
		},
		{
		0x6cdd,
		0xcd41
		},
		{
		0x6cde,
		0xcd46
		},
		{
		0x6ce0,
		0xaa7e
		},
		{
		0x6ce1,
		0xaa77
		},
		{
		0x6ce2,
		0xaa69
		},
		{
		0x6ce3,
		0xaa5f
		},
		{
		0x6ce5,
		0xaa64
		},
		{
		0x6ce7,
		0xccf6
		},
		{
		0x6ce8,
		0xaa60
		},
		{
		0x6ce9,
		0xcd4e
		},
		{
		0x6ceb,
		0xccf0
		},
		{
		0x6cec,
		0xccef
		},
		{
		0x6ced,
		0xccfd
		},
		{
		0x6cee,
		0xccf1
		},
		{
		0x6cef,
		0xaa7b
		},
		{
		0x6cf0,
		0xaef5
		},
		{
		0x6cf1,
		0xaa74
		},
		{
		0x6cf2,
		0xccfe
		},
		{
		0x6cf3,
		0xaa61
		},
		{
		0x6cf5,
		0xaca6
		},
		{
		0x6cf9,
		0xcd4c
		},
		{
		0x6d00,
		0xcf7c
		},
		{
		0x6d01,
		0xcfa1
		},
		{
		0x6d03,
		0xcfa4
		},
		{
		0x6d04,
		0xcf77
		},
		{
		0x6d07,
		0xcfa7
		},
		{
		0x6d08,
		0xcfaa
		},
		{
		0x6d09,
		0xcfac
		},
		{
		0x6d0a,
		0xcf74
		},
		{
		0x6d0b,
		0xac76
		},
		{
		0x6d0c,
		0xac7b
		},
		{
		0x6d0d,
		0xd249
		},
		{
		0x6d0e,
		0xacad
		},
		{
		0x6d0f,
		0xcfa5
		},
		{
		0x6d10,
		0xcfad
		},
		{
		0x6d11,
		0xcf7b
		},
		{
		0x6d12,
		0xcf73
		},
		{
		0x6d16,
		0xd264
		},
		{
		0x6d17,
		0xac7e
		},
		{
		0x6d18,
		0xcfa2
		},
		{
		0x6d19,
		0xcf78
		},
		{
		0x6d1a,
		0xcf7a
		},
		{
		0x6d1b,
		0xaca5
		},
		{
		0x6d1d,
		0xcf7d
		},
		{
		0x6d1e,
		0xac7d
		},
		{
		0x6d1f,
		0xcf70
		},
		{
		0x6d20,
		0xcfa8
		},
		{
		0x6d22,
		0xcfab
		},
		{
		0x6d25,
		0xac7a
		},
		{
		0x6d27,
		0xaca8
		},
		{
		0x6d28,
		0xcf6d
		},
		{
		0x6d29,
		0xacaa
		},
		{
		0x6d2a,
		0xac78
		},
		{
		0x6d2b,
		0xacae
		},
		{
		0x6d2c,
		0xcfa9
		},
		{
		0x6d2d,
		0xcf6f
		},
		{
		0x6d2e,
		0xacab
		},
		{
		0x6d2f,
		0xd25e
		},
		{
		0x6d30,
		0xcd48
		},
		{
		0x6d31,
		0xac7c
		},
		{
		0x6d32,
		0xac77
		},
		{
		0x6d33,
		0xcf76
		},
		{
		0x6d34,
		0xcf6e
		},
		{
		0x6d35,
		0xacac
		},
		{
		0x6d36,
		0xaca4
		},
		{
		0x6d37,
		0xcfa3
		},
		{
		0x6d38,
		0xaca9
		},
		{
		0x6d39,
		0xaca7
		},
		{
		0x6d3a,
		0xcf79
		},
		{
		0x6d3b,
		0xaca1
		},
		{
		0x6d3c,
		0xcf71
		},
		{
		0x6d3d,
		0xaca2
		},
		{
		0x6d3e,
		0xaca3
		},
		{
		0x6d3f,
		0xcf72
		},
		{
		0x6d40,
		0xcfa6
		},
		{
		0x6d41,
		0xac79
		},
		{
		0x6d42,
		0xcf7e
		},
		{
		0x6d58,
		0xd24c
		},
		{
		0x6d59,
		0xaefd
		},
		{
		0x6d5a,
		0xaf43
		},
		{
		0x6d5e,
		0xd255
		},
		{
		0x6d5f,
		0xd25b
		},
		{
		0x6d60,
		0xd257
		},
		{
		0x6d61,
		0xd24a
		},
		{
		0x6d62,
		0xd24d
		},
		{
		0x6d63,
		0xd246
		},
		{
		0x6d64,
		0xd247
		},
		{
		0x6d65,
		0xaf4a
		},
		{
		0x6d66,
		0xaefa
		},
		{
		0x6d67,
		0xd256
		},
		{
		0x6d68,
		0xd25f
		},
		{
		0x6d69,
		0xaf45
		},
		{
		0x6d6a,
		0xaef6
		},
		{
		0x6d6c,
		0xaf40
		},
		{
		0x6d6d,
		0xd24e
		},
		{
		0x6d6e,
		0xaf42
		},
		{
		0x6d6f,
		0xd24f
		},
		{
		0x6d70,
		0xd259
		},
		{
		0x6d74,
		0xaf44
		},
		{
		0x6d75,
		0xd268
		},
		{
		0x6d76,
		0xd248
		},
		{
		0x6d77,
		0xaefc
		},
		{
		0x6d78,
		0xaefb
		},
		{
		0x6d79,
		0xaf48
		},
		{
		0x6d7a,
		0xd245
		},
		{
		0x6d7b,
		0xd266
		},
		{
		0x6d7c,
		0xd25a
		},
		{
		0x6d7d,
		0xd267
		},
		{
		0x6d7e,
		0xd261
		},
		{
		0x6d7f,
		0xd253
		},
		{
		0x6d80,
		0xd262
		},
		{
		0x6d82,
		0xd25c
		},
		{
		0x6d83,
		0xd265
		},
		{
		0x6d84,
		0xd263
		},
		{
		0x6d85,
		0xaf49
		},
		{
		0x6d86,
		0xd254
		},
		{
		0x6d87,
		0xaef9
		},
		{
		0x6d88,
		0xaef8
		},
		{
		0x6d89,
		0xaf41
		},
		{
		0x6d8a,
		0xaf47
		},
		{
		0x6d8b,
		0xd260
		},
		{
		0x6d8c,
		0xaf46
		},
		{
		0x6d8d,
		0xd251
		},
		{
		0x6d8e,
		0xb243
		},
		{
		0x6d90,
		0xd269
		},
		{
		0x6d91,
		0xd250
		},
		{
		0x6d92,
		0xd24b
		},
		{
		0x6d93,
		0xaefe
		},
		{
		0x6d94,
		0xaf4b
		},
		{
		0x6d95,
		0xaef7
		},
		{
		0x6d97,
		0xd258
		},
		{
		0x6d98,
		0xd25d
		},
		{
		0x6daa,
		0xb265
		},
		{
		0x6dab,
		0xd5e1
		},
		{
		0x6dac,
		0xd5e5
		},
		{
		0x6dae,
		0xb252
		},
		{
		0x6daf,
		0xb250
		},
		{
		0x6db2,
		0xb247
		},
		{
		0x6db3,
		0xd5e3
		},
		{
		0x6db4,
		0xd5e2
		},
		{
		0x6db5,
		0xb25b
		},
		{
		0x6db7,
		0xd5e8
		},
		{
		0x6db8,
		0xb255
		},
		{
		0x6dba,
		0xd5fa
		},
		{
		0x6dbb,
		0xd647
		},
		{
		0x6dbc,
		0xb244
		},
		{
		0x6dbd,
		0xd5f7
		},
		{
		0x6dbe,
		0xd5f0
		},
		{
		0x6dbf,
		0xb267
		},
		{
		0x6dc0,
		0xd5e0
		},
		{
		0x6dc2,
		0xd5fc
		},
		{
		0x6dc4,
		0xb264
		},
		{
		0x6dc5,
		0xb258
		},
		{
		0x6dc6,
		0xb263
		},
		{
		0x6dc7,
		0xb24e
		},
		{
		0x6dc8,
		0xd5ec
		},
		{
		0x6dc9,
		0xd5fe
		},
		{
		0x6dca,
		0xd5f6
		},
		{
		0x6dcb,
		0xb24f
		},
		{
		0x6dcc,
		0xb249
		},
		{
		0x6dcd,
		0xd645
		},
		{
		0x6dcf,
		0xd5fd
		},
		{
		0x6dd0,
		0xd640
		},
		{
		0x6dd1,
		0xb251
		},
		{
		0x6dd2,
		0xb259
		},
		{
		0x6dd3,
		0xd642
		},
		{
		0x6dd4,
		0xd5ea
		},
		{
		0x6dd5,
		0xd5fb
		},
		{
		0x6dd6,
		0xd5ef
		},
		{
		0x6dd7,
		0xd644
		},
		{
		0x6dd8,
		0xb25e
		},
		{
		0x6dd9,
		0xb246
		},
		{
		0x6dda,
		0xb25c
		},
		{
		0x6ddb,
		0xd5f4
		},
		{
		0x6ddc,
		0xd5f2
		},
		{
		0x6ddd,
		0xd5f3
		},
		{
		0x6dde,
		0xb253
		},
		{
		0x6ddf,
		0xd5ee
		},
		{
		0x6de0,
		0xd5ed
		},
		{
		0x6de1,
		0xb248
		},
		{
		0x6de2,
		0xd5e7
		},
		{
		0x6de3,
		0xd646
		},
		{
		0x6de4,
		0xb24a
		},
		{
		0x6de5,
		0xd5f1
		},
		{
		0x6de6,
		0xb268
		},
		{
		0x6de8,
		0xb262
		},
		{
		0x6de9,
		0xd5e6
		},
		{
		0x6dea,
		0xb25f
		},
		{
		0x6deb,
		0xb25d
		},
		{
		0x6dec,
		0xb266
		},
		{
		0x6ded,
		0xd5f8
		},
		{
		0x6dee,
		0xb261
		},
		{
		0x6def,
		0xd252
		},
		{
		0x6df0,
		0xd5f9
		},
		{
		0x6df1,
		0xb260
		},
		{
		0x6df2,
		0xd641
		},
		{
		0x6df3,
		0xb245
		},
		{
		0x6df4,
		0xd5f5
		},
		{
		0x6df5,
		0xb257
		},
		{
		0x6df6,
		0xd5e9
		},
		{
		0x6df7,
		0xb256
		},
		{
		0x6df9,
		0xb254
		},
		{
		0x6dfa,
		0xb24c
		},
		{
		0x6dfb,
		0xb24b
		},
		{
		0x6dfc,
		0xd9e7
		},
		{
		0x6dfd,
		0xd643
		},
		{
		0x6e00,
		0xd5eb
		},
		{
		0x6e03,
		0xd9fc
		},
		{
		0x6e05,
		0xb24d
		},
		{
		0x6e19,
		0xb541
		},
		{
		0x6e1a,
		0xb25a
		},
		{
		0x6e1b,
		0xb4ee
		},
		{
		0x6e1c,
		0xd9f6
		},
		{
		0x6e1d,
		0xb4fc
		},
		{
		0x6e1f,
		0xd9ea
		},
		{
		0x6e20,
		0xb4eb
		},
		{
		0x6e21,
		0xb4e7
		},
		{
		0x6e22,
		0xda49
		},
		{
		0x6e23,
		0xb4ed
		},
		{
		0x6e24,
		0xb4f1
		},
		{
		0x6e25,
		0xb4ec
		},
		{
		0x6e26,
		0xb4f5
		},
		{
		0x6e27,
		0xda4d
		},
		{
		0x6e28,
		0xda44
		},
		{
		0x6e2b,
		0xd9f1
		},
		{
		0x6e2c,
		0xb4fa
		},
		{
		0x6e2d,
		0xb4f4
		},
		{
		0x6e2e,
		0xd9fd
		},
		{
		0x6e2f,
		0xb4e4
		},
		{
		0x6e30,
		0xda4a
		},
		{
		0x6e31,
		0xda43
		},
		{
		0x6e32,
		0xb4e8
		},
		{
		0x6e33,
		0xd9f7
		},
		{
		0x6e34,
		0xb4f7
		},
		{
		0x6e35,
		0xda55
		},
		{
		0x6e36,
		0xda56
		},
		{
		0x6e38,
		0xb4e5
		},
		{
		0x6e39,
		0xda48
		},
		{
		0x6e3a,
		0xb4f9
		},
		{
		0x6e3b,
		0xd9fb
		},
		{
		0x6e3c,
		0xd9ed
		},
		{
		0x6e3d,
		0xd9ee
		},
		{
		0x6e3e,
		0xb4fd
		},
		{
		0x6e3f,
		0xd9f2
		},
		{
		0x6e40,
		0xd9f9
		},
		{
		0x6e41,
		0xd9f3
		},
		{
		0x6e43,
		0xb4fb
		},
		{
		0x6e44,
		0xb544
		},
		{
		0x6e45,
		0xd9ef
		},
		{
		0x6e46,
		0xd9e8
		},
		{
		0x6e47,
		0xd9e9
		},
		{
		0x6e49,
		0xd9eb
		},
		{
		0x6e4a,
		0xb4ea
		},
		{
		0x6e4b,
		0xd9f8
		},
		{
		0x6e4d,
		0xb4f8
		},
		{
		0x6e4e,
		0xb542
		},
		{
		0x6e51,
		0xd9fa
		},
		{
		0x6e52,
		0xda53
		},
		{
		0x6e53,
		0xda4b
		},
		{
		0x6e54,
		0xb4e6
		},
		{
		0x6e55,
		0xda51
		},
		{
		0x6e56,
		0xb4f2
		},
		{
		0x6e58,
		0xb4f0
		},
		{
		0x6e5a,
		0xda57
		},
		{
		0x6e5b,
		0xb4ef
		},
		{
		0x6e5c,
		0xda41
		},
		{
		0x6e5d,
		0xd9f4
		},
		{
		0x6e5e,
		0xd9fe
		},
		{
		0x6e5f,
		0xb547
		},
		{
		0x6e60,
		0xda45
		},
		{
		0x6e61,
		0xda42
		},
		{
		0x6e62,
		0xd9f0
		},
		{
		0x6e63,
		0xb543
		},
		{
		0x6e64,
		0xda4f
		},
		{
		0x6e65,
		0xda4c
		},
		{
		0x6e66,
		0xda54
		},
		{
		0x6e67,
		0xb4e9
		},
		{
		0x6e68,
		0xda40
		},
		{
		0x6e69,
		0xb546
		},
		{
		0x6e6b,
		0xda47
		},
		{
		0x6e6e,
		0xb4f3
		},
		{
		0x6e6f,
		0xb4f6
		},
		{
		0x6e71,
		0xda46
		},
		{
		0x6e72,
		0xb545
		},
		{
		0x6e73,
		0xd9f5
		},
		{
		0x6e74,
		0xd5e4
		},
		{
		0x6e77,
		0xda50
		},
		{
		0x6e78,
		0xda4e
		},
		{
		0x6e79,
		0xda52
		},
		{
		0x6e88,
		0xd9ec
		},
		{
		0x6e89,
		0xb540
		},
		{
		0x6e8d,
		0xde61
		},
		{
		0x6e8e,
		0xde60
		},
		{
		0x6e8f,
		0xde46
		},
		{
		0x6e90,
		0xb7bd
		},
		{
		0x6e92,
		0xde5f
		},
		{
		0x6e93,
		0xde49
		},
		{
		0x6e94,
		0xde4a
		},
		{
		0x6e96,
		0xb7c7
		},
		{
		0x6e97,
		0xde68
		},
		{
		0x6e98,
		0xb7c2
		},
		{
		0x6e99,
		0xde5e
		},
		{
		0x6e9b,
		0xde43
		},
		{
		0x6e9c,
		0xb7c8
		},
		{
		0x6e9d,
		0xb7be
		},
		{
		0x6e9e,
		0xde52
		},
		{
		0x6e9f,
		0xde48
		},
		{
		0x6ea0,
		0xde4b
		},
		{
		0x6ea1,
		0xde63
		},
		{
		0x6ea2,
		0xb7b8
		},
		{
		0x6ea3,
		0xde6a
		},
		{
		0x6ea4,
		0xde62
		},
		{
		0x6ea5,
		0xb7c1
		},
		{
		0x6ea6,
		0xde57
		},
		{
		0x6ea7,
		0xb7cc
		},
		{
		0x6eaa,
		0xb7cb
		},
		{
		0x6eab,
		0xb7c5
		},
		{
		0x6eae,
		0xde69
		},
		{
		0x6eaf,
		0xb7b9
		},
		{
		0x6eb0,
		0xde55
		},
		{
		0x6eb1,
		0xde4c
		},
		{
		0x6eb2,
		0xde59
		},
		{
		0x6eb3,
		0xde65
		},
		{
		0x6eb4,
		0xb7cd
		},
		{
		0x6eb6,
		0xb7bb
		},
		{
		0x6eb7,
		0xde54
		},
		{
		0x6eb9,
		0xde4d
		},
		{
		0x6eba,
		0xb7c4
		},
		{
		0x6ebc,
		0xb7c3
		},
		{
		0x6ebd,
		0xde50
		},
		{
		0x6ebe,
		0xde5a
		},
		{
		0x6ebf,
		0xde64
		},
		{
		0x6ec0,
		0xde47
		},
		{
		0x6ec1,
		0xde51
		},
		{
		0x6ec2,
		0xb7bc
		},
		{
		0x6ec3,
		0xde5b
		},
		{
		0x6ec4,
		0xb7c9
		},
		{
		0x6ec5,
		0xb7c0
		},
		{
		0x6ec6,
		0xde4e
		},
		{
		0x6ec7,
		0xb7bf
		},
		{
		0x6ec8,
		0xde45
		},
		{
		0x6ec9,
		0xde53
		},
		{
		0x6eca,
		0xde67
		},
		{
		0x6ecb,
		0xb4fe
		},
		{
		0x6ecc,
		0xbab0
		},
		{
		0x6ecd,
		0xde56
		},
		{
		0x6ece,
		0xe26c
		},
		{
		0x6ecf,
		0xde58
		},
		{
		0x6ed0,
		0xde66
		},
		{
		0x6ed1,
		0xb7c6
		},
		{
		0x6ed2,
		0xde4f
		},
		{
		0x6ed3,
		0xb7ba
		},
		{
		0x6ed4,
		0xb7ca
		},
		{
		0x6ed5,
		0xbcf0
		},
		{
		0x6ed6,
		0xde44
		},
		{
		0x6ed8,
		0xde5d
		},
		{
		0x6edc,
		0xde5c
		},
		{
		0x6eeb,
		0xe2aa
		},
		{
		0x6eec,
		0xbaad
		},
		{
		0x6eed,
		0xe27d
		},
		{
		0x6eee,
		0xe2a4
		},
		{
		0x6eef,
		0xbaa2
		},
		{
		0x6ef1,
		0xe26e
		},
		{
		0x6ef2,
		0xbaaf
		},
		{
		0x6ef4,
		0xba77
		},
		{
		0x6ef5,
		0xe26d
		},
		{
		0x6ef6,
		0xe2b0
		},
		{
		0x6ef7,
		0xbab1
		},
		{
		0x6ef8,
		0xe271
		},
		{
		0x6ef9,
		0xe2a3
		},
		{
		0x6efb,
		0xe273
		},
		{
		0x6efc,
		0xe2b3
		},
		{
		0x6efd,
		0xe2af
		},
		{
		0x6efe,
		0xba75
		},
		{
		0x6eff,
		0xbaa1
		},
		{
		0x6f00,
		0xe653
		},
		{
		0x6f01,
		0xbaae
		},
		{
		0x6f02,
		0xba7d
		},
		{
		0x6f03,
		0xe26f
		},
		{
		0x6f05,
		0xe2ae
		},
		{
		0x6f06,
		0xbaa3
		},
		{
		0x6f07,
		0xe2ab
		},
		{
		0x6f08,
		0xe2b8
		},
		{
		0x6f09,
		0xe275
		},
		{
		0x6f0a,
		0xe27e
		},
		{
		0x6f0d,
		0xe2b6
		},
		{
		0x6f0e,
		0xe2ac
		},
		{
		0x6f0f,
		0xba7c
		},
		{
		0x6f12,
		0xe27c
		},
		{
		0x6f13,
		0xba76
		},
		{
		0x6f14,
		0xba74
		},
		{
		0x6f15,
		0xbaa8
		},
		{
		0x6f18,
		0xe27a
		},
		{
		0x6f19,
		0xe277
		},
		{
		0x6f1a,
		0xe278
		},
		{
		0x6f1c,
		0xe2b2
		},
		{
		0x6f1e,
		0xe2b7
		},
		{
		0x6f1f,
		0xe2b5
		},
		{
		0x6f20,
		0xba7a
		},
		{
		0x6f21,
		0xe2b9
		},
		{
		0x6f22,
		0xba7e
		},
		{
		0x6f23,
		0xbaa7
		},
		{
		0x6f25,
		0xe270
		},
		{
		0x6f26,
		0xe5fa
		},
		{
		0x6f27,
		0xe279
		},
		{
		0x6f29,
		0xba78
		},
		{
		0x6f2a,
		0xbaac
		},
		{
		0x6f2b,
		0xbaa9
		},
		{
		0x6f2c,
		0xba7b
		},
		{
		0x6f2d,
		0xe2a5
		},
		{
		0x6f2e,
		0xe274
		},
		{
		0x6f2f,
		0xbaaa
		},
		{
		0x6f30,
		0xe2a7
		},
		{
		0x6f31,
		0xbaa4
		},
		{
		0x6f32,
		0xbaa6
		},
		{
		0x6f33,
		0xba73
		},
		{
		0x6f35,
		0xe2a9
		},
		{
		0x6f36,
		0xe2a1
		},
		{
		0x6f37,
		0xe272
		},
		{
		0x6f38,
		0xbaa5
		},
		{
		0x6f39,
		0xe2b1
		},
		{
		0x6f3a,
		0xe2b4
		},
		{
		0x6f3b,
		0xe27b
		},
		{
		0x6f3c,
		0xe2a8
		},
		{
		0x6f3e,
		0xba79
		},
		{
		0x6f3f,
		0xbcdf
		},
		{
		0x6f40,
		0xe2a6
		},
		{
		0x6f41,
		0xe5f9
		},
		{
		0x6f43,
		0xe2ad
		},
		{
		0x6f4e,
		0xe276
		},
		{
		0x6f4f,
		0xe644
		},
		{
		0x6f50,
		0xe64e
		},
		{
		0x6f51,
		0xbce2
		},
		{
		0x6f52,
		0xe64d
		},
		{
		0x6f53,
		0xe659
		},
		{
		0x6f54,
		0xbce4
		},
		{
		0x6f55,
		0xe64b
		},
		{
		0x6f57,
		0xe64f
		},
		{
		0x6f58,
		0xbcef
		},
		{
		0x6f5a,
		0xe646
		},
		{
		0x6f5b,
		0xbce7
		},
		{
		0x6f5d,
		0xe652
		},
		{
		0x6f5e,
		0xe9f0
		},
		{
		0x6f5f,
		0xbcf3
		},
		{
		0x6f60,
		0xbcf2
		},
		{
		0x6f61,
		0xe654
		},
		{
		0x6f62,
		0xe643
		},
		{
		0x6f63,
		0xe65e
		},
		{
		0x6f64,
		0xbced
		},
		{
		0x6f66,
		0xbce3
		},
		{
		0x6f67,
		0xe657
		},
		{
		0x6f69,
		0xe65b
		},
		{
		0x6f6a,
		0xe660
		},
		{
		0x6f6b,
		0xe655
		},
		{
		0x6f6c,
		0xe649
		},
		{
		0x6f6d,
		0xbce6
		},
		{
		0x6f6e,
		0xbce9
		},
		{
		0x6f6f,
		0xbcf1
		},
		{
		0x6f70,
		0xbcec
		},
		{
		0x6f72,
		0xe64c
		},
		{
		0x6f73,
		0xe2a2
		},
		{
		0x6f76,
		0xe648
		},
		{
		0x6f77,
		0xe65f
		},
		{
		0x6f78,
		0xbce8
		},
		{
		0x6f7a,
		0xbceb
		},
		{
		0x6f7b,
		0xe661
		},
		{
		0x6f7c,
		0xbce0
		},
		{
		0x6f7d,
		0xe656
		},
		{
		0x6f7e,
		0xe5fb
		},
		{
		0x6f7f,
		0xe65c
		},
		{
		0x6f80,
		0xc0df
		},
		{
		0x6f82,
		0xe64a
		},
		{
		0x6f84,
		0xbce1
		},
		{
		0x6f85,
		0xe645
		},
		{
		0x6f86,
		0xbce5
		},
		{
		0x6f87,
		0xe5fc
		},
		{
		0x6f88,
		0xbaab
		},
		{
		0x6f89,
		0xe641
		},
		{
		0x6f8b,
		0xe65a
		},
		{
		0x6f8c,
		0xe642
		},
		{
		0x6f8d,
		0xe640
		},
		{
		0x6f8e,
		0xbcea
		},
		{
		0x6f90,
		0xe658
		},
		{
		0x6f92,
		0xe5fe
		},
		{
		0x6f93,
		0xe651
		},
		{
		0x6f94,
		0xe650
		},
		{
		0x6f95,
		0xe65d
		},
		{
		0x6f96,
		0xe647
		},
		{
		0x6f97,
		0xbcee
		},
		{
		0x6f9e,
		0xe9f3
		},
		{
		0x6fa0,
		0xbf49
		},
		{
		0x6fa1,
		0xbefe
		},
		{
		0x6fa2,
		0xea40
		},
		{
		0x6fa3,
		0xe9eb
		},
		{
		0x6fa4,
		0xbf41
		},
		{
		0x6fa5,
		0xe9f7
		},
		{
		0x6fa6,
		0xbf48
		},
		{
		0x6fa7,
		0xbf43
		},
		{
		0x6fa8,
		0xe9f5
		},
		{
		0x6fa9,
		0xed4f
		},
		{
		0x6faa,
		0xe9fb
		},
		{
		0x6fab,
		0xea42
		},
		{
		0x6fac,
		0xe9fa
		},
		{
		0x6fad,
		0xe9e9
		},
		{
		0x6fae,
		0xe9f8
		},
		{
		0x6faf,
		0xea44
		},
		{
		0x6fb0,
		0xea46
		},
		{
		0x6fb1,
		0xbefd
		},
		{
		0x6fb2,
		0xea45
		},
		{
		0x6fb3,
		0xbf44
		},
		{
		0x6fb4,
		0xbf4a
		},
		{
		0x6fb6,
		0xbf47
		},
		{
		0x6fb8,
		0xe9fe
		},
		{
		0x6fb9,
		0xbf46
		},
		{
		0x6fba,
		0xe9f9
		},
		{
		0x6fbc,
		0xe9ed
		},
		{
		0x6fbd,
		0xe9f2
		},
		{
		0x6fbf,
		0xe9fd
		},
		{
		0x6fc0,
		0xbf45
		},
		{
		0x6fc1,
		0xbf42
		},
		{
		0x6fc2,
		0xbefc
		},
		{
		0x6fc3,
		0xbf40
		},
		{
		0x6fc4,
		0xe9f1
		},
		{
		0x6fc6,
		0xe5fd
		},
		{
		0x6fc7,
		0xe9ec
		},
		{
		0x6fc8,
		0xe9ef
		},
		{
		0x6fc9,
		0xea41
		},
		{
		0x6fca,
		0xe9f4
		},
		{
		0x6fcb,
		0xe9ea
		},
		{
		0x6fcc,
		0xed4e
		},
		{
		0x6fcd,
		0xea43
		},
		{
		0x6fce,
		0xe9ee
		},
		{
		0x6fcf,
		0xe9fc
		},
		{
		0x6fd4,
		0xed51
		},
		{
		0x6fd5,
		0xc0e3
		},
		{
		0x6fd8,
		0xc0d7
		},
		{
		0x6fdb,
		0xc0db
		},
		{
		0x6fdc,
		0xed53
		},
		{
		0x6fdd,
		0xed59
		},
		{
		0x6fde,
		0xed57
		},
		{
		0x6fdf,
		0xc0d9
		},
		{
		0x6fe0,
		0xc0da
		},
		{
		0x6fe1,
		0xc0e1
		},
		{
		0x6fe2,
		0xed5a
		},
		{
		0x6fe3,
		0xed52
		},
		{
		0x6fe4,
		0xc0dc
		},
		{
		0x6fe6,
		0xed56
		},
		{
		0x6fe7,
		0xed55
		},
		{
		0x6fe8,
		0xed5b
		},
		{
		0x6fe9,
		0xc0e2
		},
		{
		0x6feb,
		0xc0dd
		},
		{
		0x6fec,
		0xc0e0
		},
		{
		0x6fed,
		0xed54
		},
		{
		0x6fee,
		0xc0e4
		},
		{
		0x6fef,
		0xc0de
		},
		{
		0x6ff0,
		0xc0e5
		},
		{
		0x6ff1,
		0xc0d8
		},
		{
		0x6ff2,
		0xed58
		},
		{
		0x6ff4,
		0xed50
		},
		{
		0x6ff7,
		0xeff7
		},
		{
		0x6ffa,
		0xc271
		},
		{
		0x6ffb,
		0xeff4
		},
		{
		0x6ffc,
		0xeff6
		},
		{
		0x6ffe,
		0xc26f
		},
		{
		0x6fff,
		0xeff2
		},
		{
		0x7000,
		0xeff3
		},
		{
		0x7001,
		0xefee
		},
		{
		0x7004,
		0xe9f6
		},
		{
		0x7005,
		0xefef
		},
		{
		0x7006,
		0xc270
		},
		{
		0x7007,
		0xefeb
		},
		{
		0x7009,
		0xc26d
		},
		{
		0x700a,
		0xeff8
		},
		{
		0x700b,
		0xc26e
		},
		{
		0x700c,
		0xefec
		},
		{
		0x700d,
		0xefed
		},
		{
		0x700e,
		0xeff1
		},
		{
		0x700f,
		0xc273
		},
		{
		0x7011,
		0xc272
		},
		{
		0x7014,
		0xeff0
		},
		{
		0x7015,
		0xc378
		},
		{
		0x7016,
		0xf25f
		},
		{
		0x7017,
		0xf265
		},
		{
		0x7018,
		0xc379
		},
		{
		0x7019,
		0xf25c
		},
		{
		0x701a,
		0xc376
		},
		{
		0x701b,
		0xc373
		},
		{
		0x701c,
		0xf267
		},
		{
		0x701d,
		0xc377
		},
		{
		0x701f,
		0xc374
		},
		{
		0x7020,
		0xf25e
		},
		{
		0x7021,
		0xf261
		},
		{
		0x7022,
		0xf262
		},
		{
		0x7023,
		0xf263
		},
		{
		0x7024,
		0xf266
		},
		{
		0x7026,
		0xeff5
		},
		{
		0x7027,
		0xf25d
		},
		{
		0x7028,
		0xc375
		},
		{
		0x7029,
		0xf264
		},
		{
		0x702a,
		0xf268
		},
		{
		0x702b,
		0xf260
		},
		{
		0x702f,
		0xf45d
		},
		{
		0x7030,
		0xc46a
		},
		{
		0x7031,
		0xf460
		},
		{
		0x7032,
		0xc46b
		},
		{
		0x7033,
		0xf468
		},
		{
		0x7034,
		0xf45f
		},
		{
		0x7035,
		0xf45c
		},
		{
		0x7037,
		0xf45e
		},
		{
		0x7038,
		0xf462
		},
		{
		0x7039,
		0xf465
		},
		{
		0x703a,
		0xf464
		},
		{
		0x703b,
		0xf467
		},
		{
		0x703c,
		0xf45b
		},
		{
		0x703e,
		0xc469
		},
		{
		0x703f,
		0xf463
		},
		{
		0x7040,
		0xf466
		},
		{
		0x7041,
		0xf469
		},
		{
		0x7042,
		0xf461
		},
		{
		0x7043,
		0xf5d3
		},
		{
		0x7044,
		0xf5d4
		},
		{
		0x7045,
		0xf5d8
		},
		{
		0x7046,
		0xf5d9
		},
		{
		0x7048,
		0xf5d6
		},
		{
		0x7049,
		0xf5d7
		},
		{
		0x704a,
		0xf5d5
		},
		{
		0x704c,
		0xc4e9
		},
		{
		0x7051,
		0xc578
		},
		{
		0x7052,
		0xf6eb
		},
		{
		0x7055,
		0xf6e8
		},
		{
		0x7056,
		0xf6e9
		},
		{
		0x7057,
		0xf6ea
		},
		{
		0x7058,
		0xc579
		},
		{
		0x705a,
		0xf7e5
		},
		{
		0x705b,
		0xf7e4
		},
		{
		0x705d,
		0xf8af
		},
		{
		0x705e,
		0xc5f4
		},
		{
		0x705f,
		0xf8ad
		},
		{
		0x7060,
		0xf8b0
		},
		{
		0x7061,
		0xf8ae
		},
		{
		0x7062,
		0xf8f5
		},
		{
		0x7063,
		0xc657
		},
		{
		0x7064,
		0xc665
		},
		{
		0x7065,
		0xf9a3
		},
		{
		0x7066,
		0xf96c
		},
		{
		0x7068,
		0xf9a2
		},
		{
		0x7069,
		0xf9d0
		},
		{
		0x706a,
		0xf9d1
		},
		{
		0x706b,
		0xa4f5
		},
		{
		0x7070,
		0xa6c7
		},
		{
		0x7071,
		0xca41
		},
		{
		0x7074,
		0xcb5e
		},
		{
		0x7076,
		0xa85f
		},
		{
		0x7078,
		0xa862
		},
		{
		0x707a,
		0xcb5f
		},
		{
		0x707c,
		0xa860
		},
		{
		0x707d,
		0xa861
		},
		{
		0x7082,
		0xcd58
		},
		{
		0x7083,
		0xcd5a
		},
		{
		0x7084,
		0xcd55
		},
		{
		0x7085,
		0xcd52
		},
		{
		0x7086,
		0xcd54
		},
		{
		0x708a,
		0xaaa4
		},
		{
		0x708e,
		0xaaa2
		},
		{
		0x7091,
		0xcd56
		},
		{
		0x7092,
		0xaaa3
		},
		{
		0x7093,
		0xcd53
		},
		{
		0x7094,
		0xcd50
		},
		{
		0x7095,
		0xaaa1
		},
		{
		0x7096,
		0xcd57
		},
		{
		0x7098,
		0xcd51
		},
		{
		0x7099,
		0xaaa5
		},
		{
		0x709a,
		0xcd59
		},
		{
		0x709f,
		0xcfaf
		},
		{
		0x70a1,
		0xcfb3
		},
		{
		0x70a4,
		0xacb7
		},
		{
		0x70a9,
		0xcfb6
		},
		{
		0x70ab,
		0xacaf
		},
		{
		0x70ac,
		0xacb2
		},
		{
		0x70ad,
		0xacb4
		},
		{
		0x70ae,
		0xacb6
		},
		{
		0x70af,
		0xacb3
		},
		{
		0x70b0,
		0xcfb2
		},
		{
		0x70b1,
		0xcfb1
		},
		{
		0x70b3,
		0xacb1
		},
		{
		0x70b4,
		0xcfb4
		},
		{
		0x70b5,
		0xcfb5
		},
		{
		0x70b7,
		0xcfae
		},
		{
		0x70b8,
		0xacb5
		},
		{
		0x70ba,
		0xacb0
		},
		{
		0x70be,
		0xcfb0
		},
		{
		0x70c5,
		0xd277
		},
		{
		0x70c6,
		0xd278
		},
		{
		0x70c7,
		0xd279
		},
		{
		0x70c8,
		0xaf50
		},
		{
		0x70ca,
		0xaf4c
		},
		{
		0x70cb,
		0xd26e
		},
		{
		0x70cd,
		0xd276
		},
		{
		0x70ce,
		0xd27b
		},
		{
		0x70cf,
		0xaf51
		},
		{
		0x70d1,
		0xd26c
		},
		{
		0x70d2,
		0xd272
		},
		{
		0x70d3,
		0xd26b
		},
		{
		0x70d4,
		0xd275
		},
		{
		0x70d7,
		0xd271
		},
		{
		0x70d8,
		0xaf4d
		},
		{
		0x70d9,
		0xaf4f
		},
		{
		0x70da,
		0xd27a
		},
		{
		0x70dc,
		0xd26a
		},
		{
		0x70dd,
		0xd26d
		},
		{
		0x70de,
		0xd273
		},
		{
		0x70e0,
		0xd274
		},
		{
		0x70e1,
		0xd27c
		},
		{
		0x70e2,
		0xd270
		},
		{
		0x70e4,
		0xaf4e
		},
		{
		0x70ef,
		0xb26d
		},
		{
		0x70f0,
		0xd64e
		},
		{
		0x70f3,
		0xd650
		},
		{
		0x70f4,
		0xd64c
		},
		{
		0x70f6,
		0xd658
		},
		{
		0x70f7,
		0xd64a
		},
		{
		0x70f8,
		0xd657
		},
		{
		0x70f9,
		0xb269
		},
		{
		0x70fa,
		0xd648
		},
		{
		0x70fb,
		0xda5b
		},
		{
		0x70fc,
		0xd652
		},
		{
		0x70fd,
		0xb26c
		},
		{
		0x70ff,
		0xd653
		},
		{
		0x7100,
		0xd656
		},
		{
		0x7102,
		0xd65a
		},
		{
		0x7104,
		0xd64f
		},
		{
		0x7106,
		0xd654
		},
		{
		0x7109,
		0xb26a
		},
		{
		0x710a,
		0xb26b
		},
		{
		0x710b,
		0xd659
		},
		{
		0x710c,
		0xd64d
		},
		{
		0x710d,
		0xd649
		},
		{
		0x710e,
		0xd65b
		},
		{
		0x7110,
		0xd651
		},
		{
		0x7113,
		0xd655
		},
		{
		0x7117,
		0xd64b
		},
		{
		0x7119,
		0xb548
		},
		{
		0x711a,
		0xb549
		},
		{
		0x711b,
		0xda65
		},
		{
		0x711c,
		0xb54f
		},
		{
		0x711e,
		0xda59
		},
		{
		0x711f,
		0xda62
		},
		{
		0x7120,
		0xda58
		},
		{
		0x7121,
		0xb54c
		},
		{
		0x7122,
		0xda60
		},
		{
		0x7123,
		0xda5e
		},
		{
		0x7125,
		0xda5f
		},
		{
		0x7126,
		0xb54a
		},
		{
		0x7128,
		0xda63
		},
		{
		0x712e,
		0xda5c
		},
		{
		0x712f,
		0xda5a
		},
		{
		0x7130,
		0xb54b
		},
		{
		0x7131,
		0xda5d
		},
		{
		0x7132,
		0xda61
		},
		{
		0x7136,
		0xb54d
		},
		{
		0x713a,
		0xda64
		},
		{
		0x7141,
		0xde70
		},
		{
		0x7142,
		0xde77
		},
		{
		0x7143,
		0xde79
		},
		{
		0x7144,
		0xdea1
		},
		{
		0x7146,
		0xb7da
		},
		{
		0x7147,
		0xde6b
		},
		{
		0x7149,
		0xb7d2
		},
		{
		0x714b,
		0xde7a
		},
		{
		0x714c,
		0xb7d7
		},
		{
		0x714d,
		0xdea2
		},
		{
		0x714e,
		0xb7ce
		},
		{
		0x7150,
		0xde7d
		},
		{
		0x7152,
		0xde6d
		},
		{
		0x7153,
		0xde7e
		},
		{
		0x7154,
		0xde6c
		},
		{
		0x7156,
		0xb7dc
		},
		{
		0x7158,
		0xde78
		},
		{
		0x7159,
		0xb7cf
		},
		{
		0x715a,
		0xdea3
		},
		{
		0x715c,
		0xb7d4
		},
		{
		0x715d,
		0xde71
		},
		{
		0x715e,
		0xb7d9
		},
		{
		0x715f,
		0xde7c
		},
		{
		0x7160,
		0xde6f
		},
		{
		0x7161,
		0xde76
		},
		{
		0x7162,
		0xde72
		},
		{
		0x7163,
		0xde6e
		},
		{
		0x7164,
		0xb7d1
		},
		{
		0x7165,
		0xb7d8
		},
		{
		0x7166,
		0xb7d6
		},
		{
		0x7167,
		0xb7d3
		},
		{
		0x7168,
		0xb7db
		},
		{
		0x7169,
		0xb7d0
		},
		{
		0x716a,
		0xde75
		},
		{
		0x716c,
		0xb7d5
		},
		{
		0x716e,
		0xb54e
		},
		{
		0x7170,
		0xde7b
		},
		{
		0x7172,
		0xde73
		},
		{
		0x7178,
		0xde74
		},
		{
		0x717b,
		0xe2c1
		},
		{
		0x717d,
		0xbab4
		},
		{
		0x7180,
		0xe2bd
		},
		{
		0x7181,
		0xe2c3
		},
		{
		0x7182,
		0xe2bf
		},
		{
		0x7184,
		0xbab6
		},
		{
		0x7185,
		0xe2be
		},
		{
		0x7186,
		0xe2c2
		},
		{
		0x7187,
		0xe2ba
		},
		{
		0x7189,
		0xe2bc
		},
		{
		0x718a,
		0xbab5
		},
		{
		0x718f,
		0xe2c0
		},
		{
		0x7190,
		0xe2bb
		},
		{
		0x7192,
		0xbab7
		},
		{
		0x7194,
		0xbab2
		},
		{
		0x7197,
		0xe2c4
		},
		{
		0x7199,
		0xbab3
		},
		{
		0x719a,
		0xe667
		},
		{
		0x719b,
		0xe664
		},
		{
		0x719c,
		0xe670
		},
		{
		0x719d,
		0xe66a
		},
		{
		0x719e,
		0xe66c
		},
		{
		0x719f,
		0xbcf4
		},
		{
		0x71a0,
		0xe666
		},
		{
		0x71a1,
		0xe66e
		},
		{
		0x71a4,
		0xe66d
		},
		{
		0x71a5,
		0xe66b
		},
		{
		0x71a7,
		0xe671
		},
		{
		0x71a8,
		0xbcf7
		},
		{
		0x71a9,
		0xe668
		},
		{
		0x71aa,
		0xe66f
		},
		{
		0x71ac,
		0xbcf5
		},
		{
		0x71af,
		0xe663
		},
		{
		0x71b0,
		0xe665
		},
		{
		0x71b1,
		0xbcf6
		},
		{
		0x71b2,
		0xe662
		},
		{
		0x71b3,
		0xe672
		},
		{
		0x71b5,
		0xe669
		},
		{
		0x71b8,
		0xea4a
		},
		{
		0x71b9,
		0xbf51
		},
		{
		0x71bc,
		0xea55
		},
		{
		0x71bd,
		0xea53
		},
		{
		0x71be,
		0xbf4b
		},
		{
		0x71bf,
		0xea49
		},
		{
		0x71c0,
		0xea4c
		},
		{
		0x71c1,
		0xea4d
		},
		{
		0x71c2,
		0xea48
		},
		{
		0x71c3,
		0xbf55
		},
		{
		0x71c4,
		0xbf56
		},
		{
		0x71c5,
		0xea47
		},
		{
		0x71c6,
		0xea56
		},
		{
		0x71c7,
		0xea51
		},
		{
		0x71c8,
		0xbf4f
		},
		{
		0x71c9,
		0xbf4c
		},
		{
		0x71ca,
		0xea50
		},
		{
		0x71cb,
		0xea4e
		},
		{
		0x71ce,
		0xbf52
		},
		{
		0x71cf,
		0xea52
		},
		{
		0x71d0,
		0xbf4d
		},
		{
		0x71d2,
		0xbf4e
		},
		{
		0x71d4,
		0xea4f
		},
		{
		0x71d5,
		0xbf50
		},
		{
		0x71d6,
		0xea4b
		},
		{
		0x71d8,
		0xea54
		},
		{
		0x71d9,
		0xbf53
		},
		{
		0x71da,
		0xea57
		},
		{
		0x71db,
		0xea58
		},
		{
		0x71dc,
		0xbf54
		},
		{
		0x71df,
		0xc0e7
		},
		{
		0x71e0,
		0xc0ee
		},
		{
		0x71e1,
		0xed5c
		},
		{
		0x71e2,
		0xed62
		},
		{
		0x71e4,
		0xed60
		},
		{
		0x71e5,
		0xc0ea
		},
		{
		0x71e6,
		0xc0e9
		},
		{
		0x71e7,
		0xc0e6
		},
		{
		0x71e8,
		0xed5e
		},
		{
		0x71ec,
		0xc0ec
		},
		{
		0x71ed,
		0xc0eb
		},
		{
		0x71ee,
		0xc0e8
		},
		{
		0x71f0,
		0xed61
		},
		{
		0x71f1,
		0xed5d
		},
		{
		0x71f2,
		0xed5f
		},
		{
		0x71f4,
		0xc0ed
		},
		{
		0x71f8,
		0xc277
		},
		{
		0x71f9,
		0xeffb
		},
		{
		0x71fb,
		0xc274
		},
		{
		0x71fc,
		0xc275
		},
		{
		0x71fd,
		0xeffd
		},
		{
		0x71fe,
		0xc276
		},
		{
		0x71ff,
		0xeffa
		},
		{
		0x7201,
		0xeff9
		},
		{
		0x7202,
		0xf26c
		},
		{
		0x7203,
		0xeffc
		},
		{
		0x7205,
		0xf26d
		},
		{
		0x7206,
		0xc37a
		},
		{
		0x7207,
		0xf26b
		},
		{
		0x720a,
		0xf26a
		},
		{
		0x720c,
		0xf269
		},
		{
		0x720d,
		0xc37b
		},
		{
		0x7210,
		0xc46c
		},
		{
		0x7213,
		0xf46a
		},
		{
		0x7214,
		0xf46b
		},
		{
		0x7219,
		0xf5dc
		},
		{
		0x721a,
		0xf5db
		},
		{
		0x721b,
		0xc4ea
		},
		{
		0x721d,
		0xf5da
		},
		{
		0x721e,
		0xf6ec
		},
		{
		0x721f,
		0xf6ed
		},
		{
		0x7222,
		0xf7e6
		},
		{
		0x7223,
		0xf8b1
		},
		{
		0x7226,
		0xf8f6
		},
		{
		0x7227,
		0xf9bc
		},
		{
		0x7228,
		0xc679
		},
		{
		0x7229,
		0xf9c6
		},
		{
		0x722a,
		0xa4f6
		},
		{
		0x722c,
		0xaaa6
		},
		{
		0x722d,
		0xaaa7
		},
		{
		0x7230,
		0xacb8
		},
		{
		0x7235,
		0xc0ef
		},
		{
		0x7236,
		0xa4f7
		},
		{
		0x7238,
		0xaaa8
		},
		{
		0x7239,
		0xaf52
		},
		{
		0x723a,
		0xb7dd
		},
		{
		0x723b,
		0xa4f8
		},
		{
		0x723d,
		0xb26e
		},
		{
		0x723e,
		0xbab8
		},
		{
		0x723f,
		0xc962
		},
		{
		0x7241,
		0xcfb7
		},
		{
		0x7242,
		0xd27d
		},
		{
		0x7244,
		0xe2c5
		},
		{
		0x7246,
		0xc0f0
		},
		{
		0x7247,
		0xa4f9
		},
		{
		0x7248,
		0xaaa9
		},
		{
		0x7249,
		0xcfb8
		},
		{
		0x724a,
		0xcfb9
		},
		{
		0x724b,
		0xda66
		},
		{
		0x724c,
		0xb550
		},
		{
		0x724f,
		0xdea4
		},
		{
		0x7252,
		0xb7de
		},
		{
		0x7253,
		0xe2c6
		},
		{
		0x7256,
		0xbcf8
		},
		{
		0x7258,
		0xc37c
		},
		{
		0x7259,
		0xa4fa
		},
		{
		0x725a,
		0xda67
		},
		{
		0x725b,
		0xa4fb
		},
		{
		0x725d,
		0xa6c9
		},
		{
		0x725e,
		0xca42
		},
		{
		0x725f,
		0xa6c8
		},
		{
		0x7260,
		0xa865
		},
		{
		0x7261,
		0xa864
		},
		{
		0x7262,
		0xa863
		},
		{
		0x7263,
		0xcb60
		},
		{
		0x7267,
		0xaaaa
		},
		{
		0x7269,
		0xaaab
		},
		{
		0x726a,
		0xcd5b
		},
		{
		0x726c,
		0xcfba
		},
		{
		0x726e,
		0xcfbd
		},
		{
		0x726f,
		0xacba
		},
		{
		0x7270,
		0xcfbb
		},
		{
		0x7272,
		0xacb9
		},
		{
		0x7273,
		0xcfbc
		},
		{
		0x7274,
		0xacbb
		},
		{
		0x7276,
		0xd2a2
		},
		{
		0x7277,
		0xd2a1
		},
		{
		0x7278,
		0xd27e
		},
		{
		0x7279,
		0xaf53
		},
		{
		0x727b,
		0xd65d
		},
		{
		0x727c,
		0xd65e
		},
		{
		0x727d,
		0xb26f
		},
		{
		0x727e,
		0xd65c
		},
		{
		0x727f,
		0xd65f
		},
		{
		0x7280,
		0xb552
		},
		{
		0x7281,
		0xb270
		},
		{
		0x7284,
		0xb551
		},
		{
		0x7285,
		0xda6b
		},
		{
		0x7286,
		0xda6a
		},
		{
		0x7288,
		0xda68
		},
		{
		0x7289,
		0xda69
		},
		{
		0x728b,
		0xda6c
		},
		{
		0x728c,
		0xdea6
		},
		{
		0x728d,
		0xdea5
		},
		{
		0x728e,
		0xdea9
		},
		{
		0x7290,
		0xdea8
		},
		{
		0x7291,
		0xdea7
		},
		{
		0x7292,
		0xbab9
		},
		{
		0x7293,
		0xe2c9
		},
		{
		0x7295,
		0xe2c8
		},
		{
		0x7296,
		0xbaba
		},
		{
		0x7297,
		0xe2c7
		},
		{
		0x7298,
		0xe673
		},
		{
		0x729a,
		0xe674
		},
		{
		0x729b,
		0xbcf9
		},
		{
		0x729d,
		0xea59
		},
		{
		0x729e,
		0xea5a
		},
		{
		0x72a1,
		0xf272
		},
		{
		0x72a2,
		0xc37d
		},
		{
		0x72a3,
		0xf271
		},
		{
		0x72a4,
		0xf270
		},
		{
		0x72a5,
		0xf26e
		},
		{
		0x72a6,
		0xf26f
		},
		{
		0x72a7,
		0xc4eb
		},
		{
		0x72a8,
		0xf46c
		},
		{
		0x72a9,
		0xf6ee
		},
		{
		0x72aa,
		0xf8f7
		},
		{
		0x72ac,
		0xa4fc
		},
		{
		0x72ae,
		0xc9a5
		},
		{
		0x72af,
		0xa5c7
		},
		{
		0x72b0,
		0xc9a6
		},
		{
		0x72b4,
		0xca43
		},
		{
		0x72b5,
		0xca44
		},
		{
		0x72ba,
		0xcb66
		},
		{
		0x72bd,
		0xcb62
		},
		{
		0x72bf,
		0xcb61
		},
		{
		0x72c0,
		0xaaac
		},
		{
		0x72c1,
		0xcb65
		},
		{
		0x72c2,
		0xa867
		},
		{
		0x72c3,
		0xcb63
		},
		{
		0x72c4,
		0xa866
		},
		{
		0x72c5,
		0xcb67
		},
		{
		0x72c6,
		0xcb64
		},
		{
		0x72c9,
		0xcd5f
		},
		{
		0x72ca,
		0xcfbe
		},
		{
		0x72cb,
		0xcd5d
		},
		{
		0x72cc,
		0xcd64
		},
		{
		0x72ce,
		0xaaad
		},
		{
		0x72d0,
		0xaab0
		},
		{
		0x72d1,
		0xcd65
		},
		{
		0x72d2,
		0xcd61
		},
		{
		0x72d4,
		0xcd62
		},
		{
		0x72d6,
		0xcd5c
		},
		{
		0x72d7,
		0xaaaf
		},
		{
		0x72d8,
		0xcd5e
		},
		{
		0x72d9,
		0xaaae
		},
		{
		0x72da,
		0xcd63
		},
		{
		0x72dc,
		0xcd60
		},
		{
		0x72df,
		0xcfc2
		},
		{
		0x72e0,
		0xacbd
		},
		{
		0x72e1,
		0xacbe
		},
		{
		0x72e3,
		0xcfc5
		},
		{
		0x72e4,
		0xcfbf
		},
		{
		0x72e6,
		0xcfc4
		},
		{
		0x72e8,
		0xcfc0
		},
		{
		0x72e9,
		0xacbc
		},
		{
		0x72ea,
		0xcfc3
		},
		{
		0x72eb,
		0xcfc1
		},
		{
		0x72f3,
		0xd2a8
		},
		{
		0x72f4,
		0xd2a5
		},
		{
		0x72f6,
		0xd2a7
		},
		{
		0x72f7,
		0xaf58
		},
		{
		0x72f8,
		0xaf57
		},
		{
		0x72f9,
		0xaf55
		},
		{
		0x72fa,
		0xd2a4
		},
		{
		0x72fb,
		0xd2a9
		},
		{
		0x72fc,
		0xaf54
		},
		{
		0x72fd,
		0xaf56
		},
		{
		0x72fe,
		0xd2a6
		},
		{
		0x72ff,
		0xd667
		},
		{
		0x7300,
		0xd2a3
		},
		{
		0x7301,
		0xd2aa
		},
		{
		0x7307,
		0xd662
		},
		{
		0x7308,
		0xd666
		},
		{
		0x730a,
		0xd665
		},
		{
		0x730b,
		0xda6e
		},
		{
		0x730c,
		0xda79
		},
		{
		0x730f,
		0xd668
		},
		{
		0x7311,
		0xd663
		},
		{
		0x7312,
		0xda6d
		},
		{
		0x7313,
		0xb274
		},
		{
		0x7316,
		0xb273
		},
		{
		0x7317,
		0xd661
		},
		{
		0x7318,
		0xd664
		},
		{
		0x7319,
		0xb275
		},
		{
		0x731b,
		0xb272
		},
		{
		0x731c,
		0xb271
		},
		{
		0x731d,
		0xd660
		},
		{
		0x731e,
		0xd669
		},
		{
		0x7322,
		0xda70
		},
		{
		0x7323,
		0xda77
		},
		{
		0x7325,
		0xb554
		},
		{
		0x7326,
		0xda76
		},
		{
		0x7327,
		0xda73
		},
		{
		0x7329,
		0xb556
		},
		{
		0x732d,
		0xda75
		},
		{
		0x7330,
		0xda6f
		},
		{
		0x7331,
		0xda71
		},
		{
		0x7332,
		0xda74
		},
		{
		0x7333,
		0xda72
		},
		{
		0x7334,
		0xb555
		},
		{
		0x7335,
		0xda78
		},
		{
		0x7336,
		0xb553
		},
		{
		0x7337,
		0xb7df
		},
		{
		0x733a,
		0xdead
		},
		{
		0x733b,
		0xdeac
		},
		{
		0x733c,
		0xdeaa
		},
		{
		0x733e,
		0xb7e2
		},
		{
		0x733f,
		0xb7e1
		},
		{
		0x7340,
		0xdeae
		},
		{
		0x7342,
		0xdeab
		},
		{
		0x7343,
		0xe2ca
		},
		{
		0x7344,
		0xbabb
		},
		{
		0x7345,
		0xb7e0
		},
		{
		0x7349,
		0xdeb0
		},
		{
		0x734a,
		0xdeaf
		},
		{
		0x734c,
		0xe2cd
		},
		{
		0x734d,
		0xe2cb
		},
		{
		0x734e,
		0xbcfa
		},
		{
		0x7350,
		0xbabc
		},
		{
		0x7351,
		0xe2cc
		},
		{
		0x7352,
		0xe676
		},
		{
		0x7357,
		0xbcfb
		},
		{
		0x7358,
		0xe675
		},
		{
		0x7359,
		0xe67e
		},
		{
		0x735a,
		0xe67d
		},
		{
		0x735b,
		0xe67b
		},
		{
		0x735d,
		0xe67a
		},
		{
		0x735e,
		0xe677
		},
		{
		0x735f,
		0xe678
		},
		{
		0x7360,
		0xe679
		},
		{
		0x7361,
		0xe67c
		},
		{
		0x7362,
		0xe6a1
		},
		{
		0x7365,
		0xea5f
		},
		{
		0x7366,
		0xea5c
		},
		{
		0x7367,
		0xea5d
		},
		{
		0x7368,
		0xbf57
		},
		{
		0x7369,
		0xea5b
		},
		{
		0x736a,
		0xea61
		},
		{
		0x736b,
		0xea60
		},
		{
		0x736c,
		0xea5e
		},
		{
		0x736e,
		0xed64
		},
		{
		0x736f,
		0xed65
		},
		{
		0x7370,
		0xc0f1
		},
		{
		0x7372,
		0xc0f2
		},
		{
		0x7373,
		0xed63
		},
		{
		0x7375,
		0xc279
		},
		{
		0x7376,
		0xeffe
		},
		{
		0x7377,
		0xc278
		},
		{
		0x7378,
		0xc37e
		},
		{
		0x737a,
		0xc3a1
		},
		{
		0x737b,
		0xc46d
		},
		{
		0x737c,
		0xf46e
		},
		{
		0x737d,
		0xf46d
		},
		{
		0x737e,
		0xf5dd
		},
		{
		0x737f,
		0xf6ef
		},
		{
		0x7380,
		0xc57a
		},
		{
		0x7381,
		0xf7e8
		},
		{
		0x7382,
		0xf7e7
		},
		{
		0x7383,
		0xf7e9
		},
		{
		0x7384,
		0xa5c8
		},
		{
		0x7385,
		0xcfc6
		},
		{
		0x7386,
		0xaf59
		},
		{
		0x7387,
		0xb276
		},
		{
		0x7388,
		0xd66a
		},
		{
		0x7389,
		0xa5c9
		},
		{
		0x738a,
		0xc9a7
		},
		{
		0x738b,
		0xa4fd
		},
		{
		0x738e,
		0xca45
		},
		{
		0x7392,
		0xcb6c
		},
		{
		0x7393,
		0xcb6a
		},
		{
		0x7394,
		0xcb6b
		},
		{
		0x7395,
		0xcb68
		},
		{
		0x7396,
		0xa868
		},
		{
		0x7397,
		0xcb69
		},
		{
		0x739d,
		0xcd6d
		},
		{
		0x739f,
		0xaab3
		},
		{
		0x73a0,
		0xcd6b
		},
		{
		0x73a1,
		0xcd67
		},
		{
		0x73a2,
		0xcd6a
		},
		{
		0x73a4,
		0xcd66
		},
		{
		0x73a5,
		0xaab5
		},
		{
		0x73a6,
		0xcd69
		},
		{
		0x73a8,
		0xaab2
		},
		{
		0x73a9,
		0xaab1
		},
		{
		0x73ab,
		0xaab4
		},
		{
		0x73ac,
		0xcd6c
		},
		{
		0x73ad,
		0xcd68
		},
		{
		0x73b2,
		0xacc2
		},
		{
		0x73b3,
		0xacc5
		},
		{
		0x73b4,
		0xcfce
		},
		{
		0x73b5,
		0xcfcd
		},
		{
		0x73b6,
		0xcfcc
		},
		{
		0x73b7,
		0xacbf
		},
		{
		0x73b8,
		0xcfd5
		},
		{
		0x73b9,
		0xcfcb
		},
		{
		0x73bb,
		0xacc1
		},
		{
		0x73bc,
		0xd2af
		},
		{
		0x73be,
		0xcfd2
		},
		{
		0x73bf,
		0xcfd0
		},
		{
		0x73c0,
		0xacc4
		},
		{
		0x73c2,
		0xcfc8
		},
		{
		0x73c3,
		0xcfd3
		},
		{
		0x73c5,
		0xcfca
		},
		{
		0x73c6,
		0xcfd4
		},
		{
		0x73c7,
		0xcfd1
		},
		{
		0x73c8,
		0xcfc9
		},
		{
		0x73ca,
		0xacc0
		},
		{
		0x73cb,
		0xcfd6
		},
		{
		0x73cc,
		0xcfc7
		},
		{
		0x73cd,
		0xacc3
		},
		{
		0x73d2,
		0xd2b4
		},
		{
		0x73d3,
		0xd2ab
		},
		{
		0x73d4,
		0xd2b6
		},
		{
		0x73d6,
		0xd2ae
		},
		{
		0x73d7,
		0xd2b9
		},
		{
		0x73d8,
		0xd2ba
		},
		{
		0x73d9,
		0xd2ac
		},
		{
		0x73da,
		0xd2b8
		},
		{
		0x73db,
		0xd2b5
		},
		{
		0x73dc,
		0xd2b3
		},
		{
		0x73dd,
		0xd2b7
		},
		{
		0x73de,
		0xaf5f
		},
		{
		0x73e0,
		0xaf5d
		},
		{
		0x73e3,
		0xd2b1
		},
		{
		0x73e5,
		0xd2ad
		},
		{
		0x73e7,
		0xd2b0
		},
		{
		0x73e8,
		0xd2bb
		},
		{
		0x73e9,
		0xd2b2
		},
		{
		0x73ea,
		0xaf5e
		},
		{
		0x73eb,
		0xcfcf
		},
		{
		0x73ed,
		0xaf5a
		},
		{
		0x73ee,
		0xaf5c
		},
		{
		0x73f4,
		0xd678
		},
		{
		0x73f5,
		0xd66d
		},
		{
		0x73f6,
		0xd66b
		},
		{
		0x73f8,
		0xd66c
		},
		{
		0x73fa,
		0xd673
		},
		{
		0x73fc,
		0xd674
		},
		{
		0x73fd,
		0xd670
		},
		{
		0x73fe,
		0xb27b
		},
		{
		0x73ff,
		0xd675
		},
		{
		0x7400,
		0xd672
		},
		{
		0x7401,
		0xd66f
		},
		{
		0x7403,
		0xb279
		},
		{
		0x7404,
		0xd66e
		},
		{
		0x7405,
		0xb277
		},
		{
		0x7406,
		0xb27a
		},
		{
		0x7407,
		0xd671
		},
		{
		0x7408,
		0xd679
		},
		{
		0x7409,
		0xaf5b
		},
		{
		0x740a,
		0xb278
		},
		{
		0x740b,
		0xd677
		},
		{
		0x740c,
		0xd676
		},
		{
		0x740d,
		0xb27c
		},
		{
		0x7416,
		0xda7e
		},
		{
		0x741a,
		0xdaa1
		},
		{
		0x741b,
		0xb560
		},
		{
		0x741d,
		0xdaa7
		},
		{
		0x7420,
		0xdaa9
		},
		{
		0x7421,
		0xdaa2
		},
		{
		0x7422,
		0xb55a
		},
		{
		0x7423,
		0xdaa6
		},
		{
		0x7424,
		0xdaa5
		},
		{
		0x7425,
		0xb55b
		},
		{
		0x7426,
		0xb561
		},
		{
		0x7428,
		0xb562
		},
		{
		0x7429,
		0xdaa8
		},
		{
		0x742a,
		0xb558
		},
		{
		0x742b,
		0xda7d
		},
		{
		0x742c,
		0xda7b
		},
		{
		0x742d,
		0xdaa3
		},
		{
		0x742e,
		0xda7a
		},
		{
		0x742f,
		0xb55f
		},
		{
		0x7430,
		0xda7c
		},
		{
		0x7431,
		0xdaa4
		},
		{
		0x7432,
		0xdaaa
		},
		{
		0x7433,
		0xb559
		},
		{
		0x7434,
		0xb55e
		},
		{
		0x7435,
		0xb55c
		},
		{
		0x7436,
		0xb55d
		},
		{
		0x743a,
		0xb557
		},
		{
		0x743f,
		0xb7e9
		},
		{
		0x7440,
		0xdeb7
		},
		{
		0x7441,
		0xb7e8
		},
		{
		0x7442,
		0xdebb
		},
		{
		0x7444,
		0xdeb1
		},
		{
		0x7446,
		0xdebc
		},
		{
		0x744a,
		0xdeb2
		},
		{
		0x744b,
		0xdeb3
		},
		{
		0x744d,
		0xdebd
		},
		{
		0x744e,
		0xdeba
		},
		{
		0x744f,
		0xdeb8
		},
		{
		0x7450,
		0xdeb9
		},
		{
		0x7451,
		0xdeb5
		},
		{
		0x7452,
		0xdeb4
		},
		{
		0x7454,
		0xdebe
		},
		{
		0x7455,
		0xb7e5
		},
		{
		0x7457,
		0xdeb6
		},
		{
		0x7459,
		0xb7ea
		},
		{
		0x745a,
		0xb7e4
		},
		{
		0x745b,
		0xb7eb
		},
		{
		0x745c,
		0xb7ec
		},
		{
		0x745e,
		0xb7e7
		},
		{
		0x745f,
		0xb7e6
		},
		{
		0x7462,
		0xe2ce
		},
		{
		0x7463,
		0xbabe
		},
		{
		0x7464,
		0xbabd
		},
		{
		0x7467,
		0xe2d3
		},
		{
		0x7469,
		0xbcfc
		},
		{
		0x746a,
		0xbabf
		},
		{
		0x746d,
		0xbac1
		},
		{
		0x746e,
		0xe2d4
		},
		{
		0x746f,
		0xb7e3
		},
		{
		0x7470,
		0xbac0
		},
		{
		0x7471,
		0xe2d0
		},
		{
		0x7472,
		0xe2d2
		},
		{
		0x7473,
		0xe2cf
		},
		{
		0x7475,
		0xe2d1
		},
		{
		0x7479,
		0xe6ab
		},
		{
		0x747c,
		0xe6aa
		},
		{
		0x747d,
		0xe6a7
		},
		{
		0x747e,
		0xbd40
		},
		{
		0x747f,
		0xea62
		},
		{
		0x7480,
		0xbd41
		},
		{
		0x7481,
		0xe6a6
		},
		{
		0x7483,
		0xbcfe
		},
		{
		0x7485,
		0xe6a8
		},
		{
		0x7486,
		0xe6a5
		},
		{
		0x7487,
		0xe6a2
		},
		{
		0x7488,
		0xe6a9
		},
		{
		0x7489,
		0xe6a3
		},
		{
		0x748a,
		0xe6a4
		},
		{
		0x748b,
		0xbcfd
		},
		{
		0x7490,
		0xed69
		},
		{
		0x7492,
		0xea66
		},
		{
		0x7494,
		0xea65
		},
		{
		0x7495,
		0xea67
		},
		{
		0x7497,
		0xed66
		},
		{
		0x7498,
		0xbf5a
		},
		{
		0x749a,
		0xea63
		},
		{
		0x749c,
		0xbf58
		},
		{
		0x749e,
		0xbf5c
		},
		{
		0x749f,
		0xbf5b
		},
		{
		0x74a0,
		0xea64
		},
		{
		0x74a1,
		0xea68
		},
		{
		0x74a3,
		0xbf59
		},
		{
		0x74a5,
		0xed6d
		},
		{
		0x74a6,
		0xc0f5
		},
		{
		0x74a7,
		0xc27a
		},
		{
		0x74a8,
		0xc0f6
		},
		{
		0x74a9,
		0xc0f3
		},
		{
		0x74aa,
		0xed6a
		},
		{
		0x74ab,
		0xed68
		},
		{
		0x74ad,
		0xed6b
		},
		{
		0x74af,
		0xed6e
		},
		{
		0x74b0,
		0xc0f4
		},
		{
		0x74b1,
		0xed6c
		},
		{
		0x74b2,
		0xed67
		},
		{
		0x74b5,
		0xf042
		},
		{
		0x74b6,
		0xf045
		},
		{
		0x74b7,
		0xf275
		},
		{
		0x74b8,
		0xf040
		},
		{
		0x74ba,
		0xf46f
		},
		{
		0x74bb,
		0xf046
		},
		{
		0x74bd,
		0xc3a2
		},
		{
		0x74be,
		0xf044
		},
		{
		0x74bf,
		0xc27b
		},
		{
		0x74c0,
		0xf041
		},
		{
		0x74c1,
		0xf043
		},
		{
		0x74c2,
		0xf047
		},
		{
		0x74c3,
		0xf276
		},
		{
		0x74c5,
		0xf274
		},
		{
		0x74ca,
		0xc3a3
		},
		{
		0x74cb,
		0xf273
		},
		{
		0x74cf,
		0xc46e
		},
		{
		0x74d4,
		0xc4ed
		},
		{
		0x74d5,
		0xf6f1
		},
		{
		0x74d6,
		0xc4ec
		},
		{
		0x74d7,
		0xf6f3
		},
		{
		0x74d8,
		0xf6f0
		},
		{
		0x74d9,
		0xf6f2
		},
		{
		0x74da,
		0xc5d0
		},
		{
		0x74db,
		0xf8b2
		},
		{
		0x74dc,
		0xa5ca
		},
		{
		0x74dd,
		0xcd6e
		},
		{
		0x74de,
		0xd2bc
		},
		{
		0x74df,
		0xd2bd
		},
		{
		0x74e0,
		0xb27d
		},
		{
		0x74e1,
		0xdebf
		},
		{
		0x74e2,
		0xbf5d
		},
		{
		0x74e3,
		0xc3a4
		},
		{
		0x74e4,
		0xc57b
		},
		{
		0x74e5,
		0xf8b3
		},
		{
		0x74e6,
		0xa5cb
		},
		{
		0x74e8,
		0xcd6f
		},
		{
		0x74e9,
		0xa260
		},
		{
		0x74ec,
		0xcfd7
		},
		{
		0x74ee,
		0xcfd8
		},
		{
		0x74f4,
		0xd2be
		},
		{
		0x74f5,
		0xd2bf
		},
		{
		0x74f6,
		0xb27e
		},
		{
		0x74f7,
		0xb2a1
		},
		{
		0x74fb,
		0xdaab
		},
		{
		0x74fd,
		0xdec2
		},
		{
		0x74fe,
		0xdec1
		},
		{
		0x74ff,
		0xdec0
		},
		{
		0x7500,
		0xe2d5
		},
		{
		0x7502,
		0xe2d6
		},
		{
		0x7503,
		0xe2d7
		},
		{
		0x7504,
		0xbac2
		},
		{
		0x7507,
		0xe6ad
		},
		{
		0x7508,
		0xe6ac
		},
		{
		0x750b,
		0xea69
		},
		{
		0x750c,
		0xbf5e
		},
		{
		0x750d,
		0xbf5f
		},
		{
		0x750f,
		0xed72
		},
		{
		0x7510,
		0xed6f
		},
		{
		0x7511,
		0xed70
		},
		{
		0x7512,
		0xed71
		},
		{
		0x7513,
		0xf049
		},
		{
		0x7514,
		0xf048
		},
		{
		0x7515,
		0xc27c
		},
		{
		0x7516,
		0xf277
		},
		{
		0x7517,
		0xf5de
		},
		{
		0x7518,
		0xa5cc
		},
		{
		0x751a,
		0xacc6
		},
		{
		0x751c,
		0xb2a2
		},
		{
		0x751d,
		0xdec3
		},
		{
		0x751f,
		0xa5cd
		},
		{
		0x7521,
		0xd2c0
		},
		{
		0x7522,
		0xb2a3
		},
		{
		0x7525,
		0xb563
		},
		{
		0x7526,
		0xb564
		},
		{
		0x7528,
		0xa5ce
		},
		{
		0x7529,
		0xa5cf
		},
		{
		0x752a,
		0xca46
		},
		{
		0x752b,
		0xa86a
		},
		{
		0x752c,
		0xa869
		},
		{
		0x752d,
		0xacc7
		},
		{
		0x752e,
		0xcfd9
		},
		{
		0x752f,
		0xdaac
		},
		{
		0x7530,
		0xa5d0
		},
		{
		0x7531,
		0xa5d1
		},
		{
		0x7532,
		0xa5d2
		},
		{
		0x7533,
		0xa5d3
		},
		{
		0x7537,
		0xa86b
		},
		{
		0x7538,
		0xa86c
		},
		{
		0x7539,
		0xcb6e
		},
		{
		0x753a,
		0xcb6d
		},
		{
		0x753d,
		0xaab6
		},
		{
		0x753e,
		0xcd72
		},
		{
		0x753f,
		0xcd70
		},
		{
		0x7540,
		0xcd71
		},
		{
		0x7547,
		0xcfda
		},
		{
		0x7548,
		0xcfdb
		},
		{
		0x754b,
		0xaccb
		},
		{
		0x754c,
		0xacc9
		},
		{
		0x754e,
		0xacca
		},
		{
		0x754f,
		0xacc8
		},
		{
		0x7554,
		0xaf60
		},
		{
		0x7559,
		0xaf64
		},
		{
		0x755a,
		0xaf63
		},
		{
		0x755b,
		0xd2c1
		},
		{
		0x755c,
		0xaf62
		},
		{
		0x755d,
		0xaf61
		},
		{
		0x755f,
		0xd2c2
		},
		{
		0x7562,
		0xb2a6
		},
		{
		0x7563,
		0xd67b
		},
		{
		0x7564,
		0xd67a
		},
		{
		0x7565,
		0xb2a4
		},
		{
		0x7566,
		0xb2a5
		},
		{
		0x756a,
		0xb566
		},
		{
		0x756b,
		0xb565
		},
		{
		0x756c,
		0xdaae
		},
		{
		0x756f,
		0xdaad
		},
		{
		0x7570,
		0xb2a7
		},
		{
		0x7576,
		0xb7ed
		},
		{
		0x7577,
		0xdec5
		},
		{
		0x7578,
		0xb7ee
		},
		{
		0x7579,
		0xdec4
		},
		{
		0x757d,
		0xe2d8
		},
		{
		0x757e,
		0xe6ae
		},
		{
		0x757f,
		0xbd42
		},
		{
		0x7580,
		0xea6a
		},
		{
		0x7584,
		0xed73
		},
		{
		0x7586,
		0xc3a6
		},
		{
		0x7587,
		0xc3a5
		},
		{
		0x758a,
		0xc57c
		},
		{
		0x758b,
		0xa5d4
		},
		{
		0x758c,
		0xcd73
		},
		{
		0x758f,
		0xb2a8
		},
		{
		0x7590,
		0xe2d9
		},
		{
		0x7591,
		0xbac3
		},
		{
		0x7594,
		0xcb6f
		},
		{
		0x7595,
		0xcb70
		},
		{
		0x7598,
		0xcd74
		},
		{
		0x7599,
		0xaab8
		},
		{
		0x759a,
		0xaab9
		},
		{
		0x759d,
		0xaab7
		},
		{
		0x75a2,
		0xaccf
		},
		{
		0x75a3,
		0xacd0
		},
		{
		0x75a4,
		0xaccd
		},
		{
		0x75a5,
		0xacce
		},
		{
		0x75a7,
		0xcfdc
		},
		{
		0x75aa,
		0xcfdd
		},
		{
		0x75ab,
		0xaccc
		},
		{
		0x75b0,
		0xd2c3
		},
		{
		0x75b2,
		0xaf68
		},
		{
		0x75b3,
		0xaf69
		},
		{
		0x75b5,
		0xb2ab
		},
		{
		0x75b6,
		0xd2c9
		},
		{
		0x75b8,
		0xaf6e
		},
		{
		0x75b9,
		0xaf6c
		},
		{
		0x75ba,
		0xd2ca
		},
		{
		0x75bb,
		0xd2c5
		},
		{
		0x75bc,
		0xaf6b
		},
		{
		0x75bd,
		0xaf6a
		},
		{
		0x75be,
		0xaf65
		},
		{
		0x75bf,
		0xd2c8
		},
		{
		0x75c0,
		0xd2c7
		},
		{
		0x75c1,
		0xd2c4
		},
		{
		0x75c2,
		0xaf6d
		},
		{
		0x75c4,
		0xd2c6
		},
		{
		0x75c5,
		0xaf66
		},
		{
		0x75c7,
		0xaf67
		},
		{
		0x75ca,
		0xb2ac
		},
		{
		0x75cb,
		0xd6a1
		},
		{
		0x75cc,
		0xd6a2
		},
		{
		0x75cd,
		0xb2ad
		},
		{
		0x75ce,
		0xd67c
		},
		{
		0x75cf,
		0xd67e
		},
		{
		0x75d0,
		0xd6a4
		},
		{
		0x75d1,
		0xd6a3
		},
		{
		0x75d2,
		0xd67d
		},
		{
		0x75d4,
		0xb2a9
		},
		{
		0x75d5,
		0xb2aa
		},
		{
		0x75d7,
		0xdab6
		},
		{
		0x75d8,
		0xb56b
		},
		{
		0x75d9,
		0xb56a
		},
		{
		0x75da,
		0xdab0
		},
		{
		0x75db,
		0xb568
		},
		{
		0x75dd,
		0xdab3
		},
		{
		0x75de,
		0xb56c
		},
		{
		0x75df,
		0xdab4
		},
		{
		0x75e0,
		0xb56d
		},
		{
		0x75e1,
		0xdab1
		},
		{
		0x75e2,
		0xb567
		},
		{
		0x75e3,
		0xb569
		},
		{
		0x75e4,
		0xdab5
		},
		{
		0x75e6,
		0xdab2
		},
		{
		0x75e7,
		0xdaaf
		},
		{
		0x75ed,
		0xded2
		},
		{
		0x75ef,
		0xdec7
		},
		{
		0x75f0,
		0xb7f0
		},
		{
		0x75f1,
		0xb7f3
		},
		{
		0x75f2,
		0xb7f2
		},
		{
		0x75f3,
		0xb7f7
		},
		{
		0x75f4,
		0xb7f6
		},
		{
		0x75f5,
		0xded3
		},
		{
		0x75f6,
		0xded1
		},
		{
		0x75f7,
		0xdeca
		},
		{
		0x75f8,
		0xdece
		},
		{
		0x75f9,
		0xdecd
		},
		{
		0x75fa,
		0xb7f4
		},
		{
		0x75fb,
		0xded0
		},
		{
		0x75fc,
		0xdecc
		},
		{
		0x75fd,
		0xded4
		},
		{
		0x75fe,
		0xdecb
		},
		{
		0x75ff,
		0xb7f5
		},
		{
		0x7600,
		0xb7ef
		},
		{
		0x7601,
		0xb7f1
		},
		{
		0x7603,
		0xdec9
		},
		{
		0x7608,
		0xe2db
		},
		{
		0x7609,
		0xbac7
		},
		{
		0x760a,
		0xe2df
		},
		{
		0x760b,
		0xbac6
		},
		{
		0x760c,
		0xe2dc
		},
		{
		0x760d,
		0xbac5
		},
		{
		0x760f,
		0xdec8
		},
		{
		0x7610,
		0xdecf
		},
		{
		0x7611,
		0xe2de
		},
		{
		0x7613,
		0xbac8
		},
		{
		0x7614,
		0xe2e0
		},
		{
		0x7615,
		0xe2dd
		},
		{
		0x7616,
		0xe2da
		},
		{
		0x7619,
		0xe6b1
		},
		{
		0x761a,
		0xe6b5
		},
		{
		0x761b,
		0xe6b7
		},
		{
		0x761c,
		0xe6b3
		},
		{
		0x761d,
		0xe6b2
		},
		{
		0x761e,
		0xe6b0
		},
		{
		0x761f,
		0xbd45
		},
		{
		0x7620,
		0xbd43
		},
		{
		0x7621,
		0xbd48
		},
		{
		0x7622,
		0xbd49
		},
		{
		0x7623,
		0xe6b4
		},
		{
		0x7624,
		0xbd46
		},
		{
		0x7625,
		0xe6af
		},
		{
		0x7626,
		0xbd47
		},
		{
		0x7627,
		0xbac4
		},
		{
		0x7628,
		0xe6b6
		},
		{
		0x7629,
		0xbd44
		},
		{
		0x762d,
		0xea6c
		},
		{
		0x762f,
		0xea6b
		},
		{
		0x7630,
		0xea73
		},
		{
		0x7631,
		0xea6d
		},
		{
		0x7632,
		0xea72
		},
		{
		0x7633,
		0xea6f
		},
		{
		0x7634,
		0xbf60
		},
		{
		0x7635,
		0xea71
		},
		{
		0x7638,
		0xbf61
		},
		{
		0x763a,
		0xbf62
		},
		{
		0x763c,
		0xea70
		},
		{
		0x763d,
		0xea6e
		},
		{
		0x7642,
		0xc0f8
		},
		{
		0x7643,
		0xed74
		},
		{
		0x7646,
		0xc0f7
		},
		{
		0x7647,
		0xed77
		},
		{
		0x7648,
		0xed75
		},
		{
		0x7649,
		0xed76
		},
		{
		0x764c,
		0xc0f9
		},
		{
		0x7650,
		0xf04d
		},
		{
		0x7652,
		0xc2a1
		},
		{
		0x7653,
		0xf04e
		},
		{
		0x7656,
		0xc27d
		},
		{
		0x7657,
		0xf04f
		},
		{
		0x7658,
		0xc27e
		},
		{
		0x7659,
		0xf04c
		},
		{
		0x765a,
		0xf050
		},
		{
		0x765c,
		0xf04a
		},
		{
		0x765f,
		0xc3a7
		},
		{
		0x7660,
		0xf278
		},
		{
		0x7661,
		0xc3a8
		},
		{
		0x7662,
		0xc46f
		},
		{
		0x7664,
		0xf04b
		},
		{
		0x7665,
		0xc470
		},
		{
		0x7669,
		0xc4ee
		},
		{
		0x766a,
		0xf5df
		},
		{
		0x766c,
		0xc57e
		},
		{
		0x766d,
		0xf6f4
		},
		{
		0x766e,
		0xc57d
		},
		{
		0x7670,
		0xf7ea
		},
		{
		0x7671,
		0xc5f5
		},
		{
		0x7672,
		0xc5f6
		},
		{
		0x7675,
		0xf9cc
		},
		{
		0x7678,
		0xacd1
		},
		{
		0x7679,
		0xcfde
		},
		{
		0x767b,
		0xb56e
		},
		{
		0x767c,
		0xb56f
		},
		{
		0x767d,
		0xa5d5
		},
		{
		0x767e,
		0xa6ca
		},
		{
		0x767f,
		0xca47
		},
		{
		0x7681,
		0xcb71
		},
		{
		0x7682,
		0xa86d
		},
		{
		0x7684,
		0xaaba
		},
		{
		0x7686,
		0xacd2
		},
		{
		0x7687,
		0xacd3
		},
		{
		0x7688,
		0xacd4
		},
		{
		0x7689,
		0xd6a6
		},
		{
		0x768a,
		0xd2cb
		},
		{
		0x768b,
		0xaf6f
		},
		{
		0x768e,
		0xb2ae
		},
		{
		0x768f,
		0xd6a5
		},
		{
		0x7692,
		0xdab8
		},
		{
		0x7693,
		0xb571
		},
		{
		0x7695,
		0xdab7
		},
		{
		0x7696,
		0xb570
		},
		{
		0x7699,
		0xded5
		},
		{
		0x769a,
		0xbd4a
		},
		{
		0x769b,
		0xe6bb
		},
		{
		0x769c,
		0xe6b8
		},
		{
		0x769d,
		0xe6b9
		},
		{
		0x769e,
		0xe6ba
		},
		{
		0x76a4,
		0xed78
		},
		{
		0x76a6,
		0xf051
		},
		{
		0x76aa,
		0xf471
		},
		{
		0x76ab,
		0xf470
		},
		{
		0x76ad,
		0xf6f5
		},
		{
		0x76ae,
		0xa5d6
		},
		{
		0x76af,
		0xcd75
		},
		{
		0x76b0,
		0xaf70
		},
		{
		0x76b4,
		0xb572
		},
		{
		0x76b5,
		0xded6
		},
		{
		0x76b8,
		0xe2e1
		},
		{
		0x76ba,
		0xbd4b
		},
		{
		0x76bb,
		0xea74
		},
		{
		0x76bd,
		0xf052
		},
		{
		0x76be,
		0xf472
		},
		{
		0x76bf,
		0xa5d7
		},
		{
		0x76c2,
		0xaabb
		},
		{
		0x76c3,
		0xacd7
		},
		{
		0x76c4,
		0xcfdf
		},
		{
		0x76c5,
		0xacd8
		},
		{
		0x76c6,
		0xacd6
		},
		{
		0x76c8,
		0xacd5
		},
		{
		0x76c9,
		0xd2cc
		},
		{
		0x76ca,
		0xaf71
		},
		{
		0x76cd,
		0xaf72
		},
		{
		0x76ce,
		0xaf73
		},
		{
		0x76d2,
		0xb2b0
		},
		{
		0x76d3,
		0xd6a7
		},
		{
		0x76d4,
		0xb2af
		},
		{
		0x76da,
		0xdab9
		},
		{
		0x76db,
		0xb2b1
		},
		{
		0x76dc,
		0xb573
		},
		{
		0x76dd,
		0xded7
		},
		{
		0x76de,
		0xb7f8
		},
		{
		0x76df,
		0xb7f9
		},
		{
		0x76e1,
		0xbac9
		},
		{
		0x76e3,
		0xbaca
		},
		{
		0x76e4,
		0xbd4c
		},
		{
		0x76e5,
		0xbf64
		},
		{
		0x76e6,
		0xea75
		},
		{
		0x76e7,
		0xbf63
		},
		{
		0x76e9,
		0xed79
		},
		{
		0x76ea,
		0xc0fa
		},
		{
		0x76ec,
		0xf053
		},
		{
		0x76ed,
		0xf473
		},
		{
		0x76ee,
		0xa5d8
		},
		{
		0x76ef,
		0xa86e
		},
		{
		0x76f0,
		0xcd78
		},
		{
		0x76f1,
		0xcd77
		},
		{
		0x76f2,
		0xaabc
		},
		{
		0x76f3,
		0xcd76
		},
		{
		0x76f4,
		0xaabd
		},
		{
		0x76f5,
		0xcd79
		},
		{
		0x76f7,
		0xcfe5
		},
		{
		0x76f8,
		0xacdb
		},
		{
		0x76f9,
		0xacda
		},
		{
		0x76fa,
		0xcfe7
		},
		{
		0x76fb,
		0xcfe6
		},
		{
		0x76fc,
		0xacdf
		},
		{
		0x76fe,
		0xacde
		},
		{
		0x7701,
		0xacd9
		},
		{
		0x7703,
		0xcfe1
		},
		{
		0x7704,
		0xcfe2
		},
		{
		0x7705,
		0xcfe3
		},
		{
		0x7707,
		0xace0
		},
		{
		0x7708,
		0xcfe0
		},
		{
		0x7709,
		0xacdc
		},
		{
		0x770a,
		0xcfe4
		},
		{
		0x770b,
		0xacdd
		},
		{
		0x7710,
		0xd2cf
		},
		{
		0x7711,
		0xd2d3
		},
		{
		0x7712,
		0xd2d1
		},
		{
		0x7713,
		0xd2d0
		},
		{
		0x7715,
		0xd2d4
		},
		{
		0x7719,
		0xd2d5
		},
		{
		0x771a,
		0xd2d6
		},
		{
		0x771b,
		0xd2ce
		},
		{
		0x771d,
		0xd2cd
		},
		{
		0x771f,
		0xaf75
		},
		{
		0x7720,
		0xaf76
		},
		{
		0x7722,
		0xd2d7
		},
		{
		0x7723,
		0xd2d2
		},
		{
		0x7725,
		0xd6b0
		},
		{
		0x7727,
		0xd2d8
		},
		{
		0x7728,
		0xaf77
		},
		{
		0x7729,
		0xaf74
		},
		{
		0x772d,
		0xd6aa
		},
		{
		0x772f,
		0xd6a9
		},
		{
		0x7731,
		0xd6ab
		},
		{
		0x7732,
		0xd6ac
		},
		{
		0x7733,
		0xd6ae
		},
		{
		0x7734,
		0xd6ad
		},
		{
		0x7735,
		0xd6b2
		},
		{
		0x7736,
		0xb2b5
		},
		{
		0x7737,
		0xb2b2
		},
		{
		0x7738,
		0xb2b6
		},
		{
		0x7739,
		0xd6a8
		},
		{
		0x773a,
		0xb2b7
		},
		{
		0x773b,
		0xd6b1
		},
		{
		0x773c,
		0xb2b4
		},
		{
		0x773d,
		0xd6af
		},
		{
		0x773e,
		0xb2b3
		},
		{
		0x7744,
		0xdabc
		},
		{
		0x7745,
		0xdabe
		},
		{
		0x7746,
		0xdaba
		},
		{
		0x7747,
		0xdabb
		},
		{
		0x774a,
		0xdabf
		},
		{
		0x774b,
		0xdac1
		},
		{
		0x774c,
		0xdac2
		},
		{
		0x774d,
		0xdabd
		},
		{
		0x774e,
		0xdac0
		},
		{
		0x774f,
		0xb574
		},
		{
		0x7752,
		0xdedb
		},
		{
		0x7754,
		0xdee0
		},
		{
		0x7755,
		0xded8
		},
		{
		0x7756,
		0xdedc
		},
		{
		0x7759,
		0xdee1
		},
		{
		0x775a,
		0xdedd
		},
		{
		0x775b,
		0xb7fa
		},
		{
		0x775c,
		0xb843
		},
		{
		0x775e,
		0xb7fd
		},
		{
		0x775f,
		0xded9
		},
		{
		0x7760,
		0xdeda
		},
		{
		0x7761,
		0xbace
		},
		{
		0x7762,
		0xb846
		},
		{
		0x7763,
		0xb7fe
		},
		{
		0x7765,
		0xb844
		},
		{
		0x7766,
		0xb7fc
		},
		{
		0x7767,
		0xdedf
		},
		{
		0x7768,
		0xb845
		},
		{
		0x7769,
		0xdede
		},
		{
		0x776a,
		0xb841
		},
		{
		0x776b,
		0xb7fb
		},
		{
		0x776c,
		0xb842
		},
		{
		0x776d,
		0xdee2
		},
		{
		0x776e,
		0xe2e6
		},
		{
		0x776f,
		0xe2e8
		},
		{
		0x7779,
		0xb840
		},
		{
		0x777c,
		0xe2e3
		},
		{
		0x777d,
		0xbacc
		},
		{
		0x777e,
		0xe2e9
		},
		{
		0x777f,
		0xbacd
		},
		{
		0x7780,
		0xe2e7
		},
		{
		0x7781,
		0xe2e2
		},
		{
		0x7782,
		0xe2e5
		},
		{
		0x7783,
		0xe2ea
		},
		{
		0x7784,
		0xbacb
		},
		{
		0x7785,
		0xe2e4
		},
		{
		0x7787,
		0xbd4e
		},
		{
		0x7788,
		0xe6bf
		},
		{
		0x7789,
		0xe6be
		},
		{
		0x778b,
		0xbd51
		},
		{
		0x778c,
		0xbd4f
		},
		{
		0x778d,
		0xe6bc
		},
		{
		0x778e,
		0xbd4d
		},
		{
		0x778f,
		0xe6bd
		},
		{
		0x7791,
		0xbd50
		},
		{
		0x7795,
		0xea7d
		},
		{
		0x7797,
		0xeaa1
		},
		{
		0x7799,
		0xea7e
		},
		{
		0x779a,
		0xea76
		},
		{
		0x779b,
		0xea7a
		},
		{
		0x779c,
		0xea79
		},
		{
		0x779d,
		0xea77
		},
		{
		0x779e,
		0xbf66
		},
		{
		0x779f,
		0xbf67
		},
		{
		0x77a0,
		0xbf65
		},
		{
		0x77a1,
		0xea78
		},
		{
		0x77a2,
		0xea7b
		},
		{
		0x77a3,
		0xea7c
		},
		{
		0x77a5,
		0xbf68
		},
		{
		0x77a7,
		0xc140
		},
		{
		0x77a8,
		0xeda3
		},
		{
		0x77aa,
		0xc0fc
		},
		{
		0x77ab,
		0xed7b
		},
		{
		0x77ac,
		0xc0fe
		},
		{
		0x77ad,
		0xc141
		},
		{
		0x77b0,
		0xc0fd
		},
		{
		0x77b1,
		0xeda2
		},
		{
		0x77b2,
		0xed7c
		},
		{
		0x77b3,
		0xc0fb
		},
		{
		0x77b4,
		0xeda1
		},
		{
		0x77b5,
		0xed7a
		},
		{
		0x77b6,
		0xed7e
		},
		{
		0x77b7,
		0xed7d
		},
		{
		0x77ba,
		0xf055
		},
		{
		0x77bb,
		0xc2a4
		},
		{
		0x77bc,
		0xc2a5
		},
		{
		0x77bd,
		0xc2a2
		},
		{
		0x77bf,
		0xc2a3
		},
		{
		0x77c2,
		0xf054
		},
		{
		0x77c4,
		0xf27b
		},
		{
		0x77c7,
		0xc3a9
		},
		{
		0x77c9,
		0xf279
		},
		{
		0x77ca,
		0xf27a
		},
		{
		0x77cc,
		0xf474
		},
		{
		0x77cd,
		0xf477
		},
		{
		0x77ce,
		0xf475
		},
		{
		0x77cf,
		0xf476
		},
		{
		0x77d0,
		0xf5e0
		},
		{
		0x77d3,
		0xc4ef
		},
		{
		0x77d4,
		0xf7eb
		},
		{
		0x77d5,
		0xf8b4
		},
		{
		0x77d7,
		0xc5f7
		},
		{
		0x77d8,
		0xf8f8
		},
		{
		0x77d9,
		0xf8f9
		},
		{
		0x77da,
		0xc666
		},
		{
		0x77db,
		0xa5d9
		},
		{
		0x77dc,
		0xace1
		},
		{
		0x77de,
		0xdac3
		},
		{
		0x77e0,
		0xdee3
		},
		{
		0x77e2,
		0xa5da
		},
		{
		0x77e3,
		0xa86f
		},
		{
		0x77e5,
		0xaabe
		},
		{
		0x77e7,
		0xcfe8
		},
		{
		0x77e8,
		0xcfe9
		},
		{
		0x77e9,
		0xaf78
		},
		{
		0x77ec,
		0xdac4
		},
		{
		0x77ed,
		0xb575
		},
		{
		0x77ee,
		0xb847
		},
		{
		0x77ef,
		0xc142
		},
		{
		0x77f0,
		0xeda4
		},
		{
		0x77f1,
		0xf27c
		},
		{
		0x77f2,
		0xf478
		},
		{
		0x77f3,
		0xa5db
		},
		{
		0x77f7,
		0xcda1
		},
		{
		0x77f8,
		0xcd7a
		},
		{
		0x77f9,
		0xcd7c
		},
		{
		0x77fa,
		0xcd7e
		},
		{
		0x77fb,
		0xcd7d
		},
		{
		0x77fc,
		0xcd7b
		},
		{
		0x77fd,
		0xaabf
		},
		{
		0x7802,
		0xace2
		},
		{
		0x7803,
		0xcff2
		},
		{
		0x7805,
		0xcfed
		},
		{
		0x7806,
		0xcfea
		},
		{
		0x7809,
		0xcff1
		},
		{
		0x780c,
		0xace4
		},
		{
		0x780d,
		0xace5
		},
		{
		0x780e,
		0xcff0
		},
		{
		0x780f,
		0xcfef
		},
		{
		0x7810,
		0xcfee
		},
		{
		0x7811,
		0xcfeb
		},
		{
		0x7812,
		0xcfec
		},
		{
		0x7813,
		0xcff3
		},
		{
		0x7814,
		0xace3
		},
		{
		0x781d,
		0xaf7c
		},
		{
		0x781f,
		0xafa4
		},
		{
		0x7820,
		0xafa3
		},
		{
		0x7821,
		0xd2e1
		},
		{
		0x7822,
		0xd2db
		},
		{
		0x7823,
		0xd2d9
		},
		{
		0x7825,
		0xafa1
		},
		{
		0x7826,
		0xd6b9
		},
		{
		0x7827,
		0xaf7a
		},
		{
		0x7828,
		0xd2de
		},
		{
		0x7829,
		0xd2e2
		},
		{
		0x782a,
		0xd2e4
		},
		{
		0x782b,
		0xd2e0
		},
		{
		0x782c,
		0xd2da
		},
		{
		0x782d,
		0xafa2
		},
		{
		0x782e,
		0xd2df
		},
		{
		0x782f,
		0xd2dd
		},
		{
		0x7830,
		0xaf79
		},
		{
		0x7831,
		0xd2e5
		},
		{
		0x7832,
		0xafa5
		},
		{
		0x7833,
		0xd2e3
		},
		{
		0x7834,
		0xaf7d
		},
		{
		0x7835,
		0xd2dc
		},
		{
		0x7837,
		0xaf7e
		},
		{
		0x7838,
		0xaf7b
		},
		{
		0x7843,
		0xb2b9
		},
		{
		0x7845,
		0xd6ba
		},
		{
		0x7848,
		0xd6b3
		},
		{
		0x7849,
		0xd6b5
		},
		{
		0x784a,
		0xd6b7
		},
		{
		0x784c,
		0xd6b8
		},
		{
		0x784d,
		0xd6b6
		},
		{
		0x784e,
		0xb2ba
		},
		{
		0x7850,
		0xd6bb
		},
		{
		0x7852,
		0xd6b4
		},
		{
		0x785c,
		0xdac8
		},
		{
		0x785d,
		0xb576
		},
		{
		0x785e,
		0xdad0
		},
		{
		0x7860,
		0xdac5
		},
		{
		0x7862,
		0xdad1
		},
		{
		0x7864,
		0xdac6
		},
		{
		0x7865,
		0xdac7
		},
		{
		0x7868,
		0xdacf
		},
		{
		0x7869,
		0xdace
		},
		{
		0x786a,
		0xdacb
		},
		{
		0x786b,
		0xb2b8
		},
		{
		0x786c,
		0xb577
		},
		{
		0x786d,
		0xdac9
		},
		{
		0x786e,
		0xdacc
		},
		{
		0x786f,
		0xb578
		},
		{
		0x7870,
		0xdacd
		},
		{
		0x7871,
		0xdaca
		},
		{
		0x7879,
		0xdeee
		},
		{
		0x787b,
		0xdef2
		},
		{
		0x787c,
		0xb84e
		},
		{
		0x787e,
		0xe2f0
		},
		{
		0x787f,
		0xb851
		},
		{
		0x7880,
		0xdef0
		},
		{
		0x7883,
		0xdeed
		},
		{
		0x7884,
		0xdee8
		},
		{
		0x7885,
		0xdeea
		},
		{
		0x7886,
		0xdeeb
		},
		{
		0x7887,
		0xdee4
		},
		{
		0x7889,
		0xb84d
		},
		{
		0x788c,
		0xb84c
		},
		{
		0x788e,
		0xb848
		},
		{
		0x788f,
		0xdee7
		},
		{
		0x7891,
		0xb84f
		},
		{
		0x7893,
		0xb850
		},
		{
		0x7894,
		0xdee6
		},
		{
		0x7895,
		0xdee9
		},
		{
		0x7896,
		0xdef1
		},
		{
		0x7897,
		0xb84a
		},
		{
		0x7898,
		0xb84b
		},
		{
		0x7899,
		0xdeef
		},
		{
		0x789a,
		0xdee5
		},
		{
		0x789e,
		0xe2f2
		},
		{
		0x789f,
		0xbad0
		},
		{
		0x78a0,
		0xe2f4
		},
		{
		0x78a1,
		0xdeec
		},
		{
		0x78a2,
		0xe2f6
		},
		{
		0x78a3,
		0xbad4
		},
		{
		0x78a4,
		0xe2f7
		},
		{
		0x78a5,
		0xe2f3
		},
		{
		0x78a7,
		0xbad1
		},
		{
		0x78a8,
		0xe2ef
		},
		{
		0x78a9,
		0xbad3
		},
		{
		0x78aa,
		0xe2ec
		},
		{
		0x78ab,
		0xe2f1
		},
		{
		0x78ac,
		0xe2f5
		},
		{
		0x78ad,
		0xe2ee
		},
		{
		0x78b0,
		0xb849
		},
		{
		0x78b2,
		0xe2eb
		},
		{
		0x78b3,
		0xbad2
		},
		{
		0x78b4,
		0xe2ed
		},
		{
		0x78ba,
		0xbd54
		},
		{
		0x78bb,
		0xe6c1
		},
		{
		0x78bc,
		0xbd58
		},
		{
		0x78be,
		0xbd56
		},
		{
		0x78c1,
		0xbacf
		},
		{
		0x78c3,
		0xe6c8
		},
		{
		0x78c4,
		0xe6c9
		},
		{
		0x78c5,
		0xbd53
		},
		{
		0x78c8,
		0xe6c7
		},
		{
		0x78c9,
		0xe6ca
		},
		{
		0x78ca,
		0xbd55
		},
		{
		0x78cb,
		0xbd52
		},
		{
		0x78cc,
		0xe6c3
		},
		{
		0x78cd,
		0xe6c0
		},
		{
		0x78ce,
		0xe6c5
		},
		{
		0x78cf,
		0xe6c2
		},
		{
		0x78d0,
		0xbd59
		},
		{
		0x78d1,
		0xe6c4
		},
		{
		0x78d4,
		0xe6c6
		},
		{
		0x78d5,
		0xbd57
		},
		{
		0x78da,
		0xbf6a
		},
		{
		0x78db,
		0xeaa8
		},
		{
		0x78dd,
		0xeaa2
		},
		{
		0x78de,
		0xeaa6
		},
		{
		0x78df,
		0xeaac
		},
		{
		0x78e0,
		0xeaad
		},
		{
		0x78e1,
		0xeaa9
		},
		{
		0x78e2,
		0xeaaa
		},
		{
		0x78e3,
		0xeaa7
		},
		{
		0x78e5,
		0xeaa4
		},
		{
		0x78e7,
		0xbf6c
		},
		{
		0x78e8,
		0xbf69
		},
		{
		0x78e9,
		0xeaa3
		},
		{
		0x78ea,
		0xeaa5
		},
		{
		0x78ec,
		0xbf6b
		},
		{
		0x78ed,
		0xeaab
		},
		{
		0x78ef,
		0xc146
		},
		{
		0x78f2,
		0xedaa
		},
		{
		0x78f3,
		0xeda5
		},
		{
		0x78f4,
		0xc145
		},
		{
		0x78f7,
		0xc143
		},
		{
		0x78f9,
		0xedac
		},
		{
		0x78fa,
		0xc144
		},
		{
		0x78fb,
		0xeda8
		},
		{
		0x78fc,
		0xeda9
		},
		{
		0x78fd,
		0xeda6
		},
		{
		0x78fe,
		0xedad
		},
		{
		0x78ff,
		0xf056
		},
		{
		0x7901,
		0xc147
		},
		{
		0x7902,
		0xeda7
		},
		{
		0x7904,
		0xedae
		},
		{
		0x7905,
		0xedab
		},
		{
		0x7909,
		0xf05a
		},
		{
		0x790c,
		0xf057
		},
		{
		0x790e,
		0xc2a6
		},
		{
		0x7910,
		0xf05b
		},
		{
		0x7911,
		0xf05d
		},
		{
		0x7912,
		0xf05c
		},
		{
		0x7913,
		0xf058
		},
		{
		0x7914,
		0xf059
		},
		{
		0x7917,
		0xf2a3
		},
		{
		0x7919,
		0xc3aa
		},
		{
		0x791b,
		0xf27e
		},
		{
		0x791c,
		0xf2a2
		},
		{
		0x791d,
		0xf27d
		},
		{
		0x791e,
		0xf2a4
		},
		{
		0x7921,
		0xf2a1
		},
		{
		0x7923,
		0xf47a
		},
		{
		0x7924,
		0xf47d
		},
		{
		0x7925,
		0xf479
		},
		{
		0x7926,
		0xc471
		},
		{
		0x7927,
		0xf47b
		},
		{
		0x7928,
		0xf47c
		},
		{
		0x7929,
		0xf47e
		},
		{
		0x792a,
		0xc472
		},
		{
		0x792b,
		0xc474
		},
		{
		0x792c,
		0xc473
		},
		{
		0x792d,
		0xf5e1
		},
		{
		0x792f,
		0xf5e3
		},
		{
		0x7931,
		0xf5e2
		},
		{
		0x7935,
		0xf6f6
		},
		{
		0x7938,
		0xf8b5
		},
		{
		0x7939,
		0xf8fa
		},
		{
		0x793a,
		0xa5dc
		},
		{
		0x793d,
		0xcb72
		},
		{
		0x793e,
		0xaac0
		},
		{
		0x793f,
		0xcda3
		},
		{
		0x7940,
		0xaac1
		},
		{
		0x7941,
		0xaac2
		},
		{
		0x7942,
		0xcda2
		},
		{
		0x7944,
		0xcff8
		},
		{
		0x7945,
		0xcff7
		},
		{
		0x7946,
		0xace6
		},
		{
		0x7947,
		0xace9
		},
		{
		0x7948,
		0xace8
		},
		{
		0x7949,
		0xace7
		},
		{
		0x794a,
		0xcff4
		},
		{
		0x794b,
		0xcff6
		},
		{
		0x794c,
		0xcff5
		},
		{
		0x794f,
		0xd2e8
		},
		{
		0x7950,
		0xafa7
		},
		{
		0x7951,
		0xd2ec
		},
		{
		0x7952,
		0xd2eb
		},
		{
		0x7953,
		0xd2ea
		},
		{
		0x7954,
		0xd2e6
		},
		{
		0x7955,
		0xafa6
		},
		{
		0x7956,
		0xafaa
		},
		{
		0x7957,
		0xafad
		},
		{
		0x795a,
		0xafae
		},
		{
		0x795b,
		0xd2e7
		},
		{
		0x795c,
		0xd2e9
		},
		{
		0x795d,
		0xafac
		},
		{
		0x795e,
		0xafab
		},
		{
		0x795f,
		0xafa9
		},
		{
		0x7960,
		0xafa8
		},
		{
		0x7961,
		0xd6c2
		},
		{
		0x7963,
		0xd6c0
		},
		{
		0x7964,
		0xd6bc
		},
		{
		0x7965,
		0xb2bb
		},
		{
		0x7967,
		0xd6bd
		},
		{
		0x7968,
		0xb2bc
		},
		{
		0x7969,
		0xd6be
		},
		{
		0x796a,
		0xd6bf
		},
		{
		0x796b,
		0xd6c1
		},
		{
		0x796d,
		0xb2bd
		},
		{
		0x7970,
		0xdad5
		},
		{
		0x7972,
		0xdad4
		},
		{
		0x7973,
		0xdad3
		},
		{
		0x7974,
		0xdad2
		},
		{
		0x7979,
		0xdef6
		},
		{
		0x797a,
		0xb852
		},
		{
		0x797c,
		0xdef3
		},
		{
		0x797d,
		0xdef5
		},
		{
		0x797f,
		0xb853
		},
		{
		0x7981,
		0xb854
		},
		{
		0x7982,
		0xdef4
		},
		{
		0x7988,
		0xe341
		},
		{
		0x798a,
		0xe2f9
		},
		{
		0x798b,
		0xe2fa
		},
		{
		0x798d,
		0xbad7
		},
		{
		0x798e,
		0xbad5
		},
		{
		0x798f,
		0xbad6
		},
		{
		0x7990,
		0xe343
		},
		{
		0x7992,
		0xe342
		},
		{
		0x7993,
		0xe2fe
		},
		{
		0x7994,
		0xe2fd
		},
		{
		0x7995,
		0xe2fc
		},
		{
		0x7996,
		0xe2fb
		},
		{
		0x7997,
		0xe340
		},
		{
		0x7998,
		0xe2f8
		},
		{
		0x799a,
		0xe6cb
		},
		{
		0x799b,
		0xe6d0
		},
		{
		0x799c,
		0xe6ce
		},
		{
		0x79a0,
		0xe6cd
		},
		{
		0x79a1,
		0xe6cc
		},
		{
		0x79a2,
		0xe6cf
		},
		{
		0x79a4,
		0xeaae
		},
		{
		0x79a6,
		0xbf6d
		},
		{
		0x79a7,
		0xc148
		},
		{
		0x79a8,
		0xedb0
		},
		{
		0x79aa,
		0xc149
		},
		{
		0x79ab,
		0xedaf
		},
		{
		0x79ac,
		0xf05f
		},
		{
		0x79ad,
		0xf05e
		},
		{
		0x79ae,
		0xc2a7
		},
		{
		0x79b0,
		0xf2a5
		},
		{
		0x79b1,
		0xc3ab
		},
		{
		0x79b2,
		0xf4a1
		},
		{
		0x79b3,
		0xc5a1
		},
		{
		0x79b4,
		0xf6f7
		},
		{
		0x79b6,
		0xf8b7
		},
		{
		0x79b7,
		0xf8b6
		},
		{
		0x79b8,
		0xc9a8
		},
		{
		0x79b9,
		0xacea
		},
		{
		0x79ba,
		0xaceb
		},
		{
		0x79bb,
		0xd6c3
		},
		{
		0x79bd,
		0xb856
		},
		{
		0x79be,
		0xa5dd
		},
		{
		0x79bf,
		0xa872
		},
		{
		0x79c0,
		0xa871
		},
		{
		0x79c1,
		0xa870
		},
		{
		0x79c5,
		0xcda4
		},
		{
		0x79c8,
		0xaac4
		},
		{
		0x79c9,
		0xaac3
		},
		{
		0x79cb,
		0xacee
		},
		{
		0x79cd,
		0xcffa
		},
		{
		0x79ce,
		0xcffd
		},
		{
		0x79cf,
		0xcffb
		},
		{
		0x79d1,
		0xacec
		},
		{
		0x79d2,
		0xaced
		},
		{
		0x79d5,
		0xcff9
		},
		{
		0x79d6,
		0xcffc
		},
		{
		0x79d8,
		0xafb5
		},
		{
		0x79dc,
		0xd2f3
		},
		{
		0x79dd,
		0xd2f5
		},
		{
		0x79de,
		0xd2f4
		},
		{
		0x79df,
		0xafb2
		},
		{
		0x79e0,
		0xd2ef
		},
		{
		0x79e3,
		0xafb0
		},
		{
		0x79e4,
		0xafaf
		},
		{
		0x79e6,
		0xafb3
		},
		{
		0x79e7,
		0xafb1
		},
		{
		0x79e9,
		0xafb4
		},
		{
		0x79ea,
		0xd2f2
		},
		{
		0x79eb,
		0xd2ed
		},
		{
		0x79ec,
		0xd2ee
		},
		{
		0x79ed,
		0xd2f1
		},
		{
		0x79ee,
		0xd2f0
		},
		{
		0x79f6,
		0xd6c6
		},
		{
		0x79f7,
		0xd6c7
		},
		{
		0x79f8,
		0xd6c5
		},
		{
		0x79fa,
		0xd6c4
		},
		{
		0x79fb,
		0xb2be
		},
		{
		0x7a00,
		0xb57d
		},
		{
		0x7a02,
		0xdad6
		},
		{
		0x7a03,
		0xdad8
		},
		{
		0x7a04,
		0xdada
		},
		{
		0x7a05,
		0xb57c
		},
		{
		0x7a08,
		0xb57a
		},
		{
		0x7a0a,
		0xdad7
		},
		{
		0x7a0b,
		0xb57b
		},
		{
		0x7a0c,
		0xdad9
		},
		{
		0x7a0d,
		0xb579
		},
		{
		0x7a10,
		0xdf41
		},
		{
		0x7a11,
		0xdef7
		},
		{
		0x7a12,
		0xdefa
		},
		{
		0x7a13,
		0xdefe
		},
		{
		0x7a14,
		0xb85a
		},
		{
		0x7a15,
		0xdefc
		},
		{
		0x7a17,
		0xdefb
		},
		{
		0x7a18,
		0xdef8
		},
		{
		0x7a19,
		0xdef9
		},
		{
		0x7a1a,
		0xb858
		},
		{
		0x7a1b,
		0xdf40
		},
		{
		0x7a1c,
		0xb857
		},
		{
		0x7a1e,
		0xb85c
		},
		{
		0x7a1f,
		0xb85b
		},
		{
		0x7a20,
		0xb859
		},
		{
		0x7a22,
		0xdefd
		},
		{
		0x7a26,
		0xe349
		},
		{
		0x7a28,
		0xe348
		},
		{
		0x7a2b,
		0xe344
		},
		{
		0x7a2e,
		0xbad8
		},
		{
		0x7a2f,
		0xe347
		},
		{
		0x7a30,
		0xe346
		},
		{
		0x7a31,
		0xbad9
		},
		{
		0x7a37,
		0xbd5e
		},
		{
		0x7a39,
		0xe6d2
		},
		{
		0x7a3b,
		0xbd5f
		},
		{
		0x7a3c,
		0xbd5b
		},
		{
		0x7a3d,
		0xbd5d
		},
		{
		0x7a3f,
		0xbd5a
		},
		{
		0x7a40,
		0xbd5c
		},
		{
		0x7a44,
		0xeaaf
		},
		{
		0x7a46,
		0xbf70
		},
		{
		0x7a47,
		0xeab1
		},
		{
		0x7a48,
		0xeab0
		},
		{
		0x7a4a,
		0xe345
		},
		{
		0x7a4b,
		0xbf72
		},
		{
		0x7a4c,
		0xbf71
		},
		{
		0x7a4d,
		0xbf6e
		},
		{
		0x7a4e,
		0xbf6f
		},
		{
		0x7a54,
		0xedb5
		},
		{
		0x7a56,
		0xedb3
		},
		{
		0x7a57,
		0xc14a
		},
		{
		0x7a58,
		0xedb4
		},
		{
		0x7a5a,
		0xedb6
		},
		{
		0x7a5b,
		0xedb2
		},
		{
		0x7a5c,
		0xedb1
		},
		{
		0x7a5f,
		0xf060
		},
		{
		0x7a60,
		0xc2aa
		},
		{
		0x7a61,
		0xc2a8
		},
		{
		0x7a62,
		0xc2a9
		},
		{
		0x7a67,
		0xf2a6
		},
		{
		0x7a68,
		0xf2a7
		},
		{
		0x7a69,
		0xc3ad
		},
		{
		0x7a6b,
		0xc3ac
		},
		{
		0x7a6c,
		0xf4a3
		},
		{
		0x7a6d,
		0xf4a4
		},
		{
		0x7a6e,
		0xf4a2
		},
		{
		0x7a70,
		0xf6f8
		},
		{
		0x7a71,
		0xf6f9
		},
		{
		0x7a74,
		0xa5de
		},
		{
		0x7a75,
		0xca48
		},
		{
		0x7a76,
		0xa873
		},
		{
		0x7a78,
		0xcda5
		},
		{
		0x7a79,
		0xaac6
		},
		{
		0x7a7a,
		0xaac5
		},
		{
		0x7a7b,
		0xcda6
		},
		{
		0x7a7e,
		0xd040
		},
		{
		0x7a7f,
		0xacef
		},
		{
		0x7a80,
		0xcffe
		},
		{
		0x7a81,
		0xacf0
		},
		{
		0x7a84,
		0xafb6
		},
		{
		0x7a85,
		0xd2f8
		},
		{
		0x7a86,
		0xd2f6
		},
		{
		0x7a87,
		0xd2fc
		},
		{
		0x7a88,
		0xafb7
		},
		{
		0x7a89,
		0xd2f7
		},
		{
		0x7a8a,
		0xd2fb
		},
		{
		0x7a8b,
		0xd2f9
		},
		{
		0x7a8c,
		0xd2fa
		},
		{
		0x7a8f,
		0xd6c8
		},
		{
		0x7a90,
		0xd6ca
		},
		{
		0x7a92,
		0xb2bf
		},
		{
		0x7a94,
		0xd6c9
		},
		{
		0x7a95,
		0xb2c0
		},
		{
		0x7a96,
		0xb5a2
		},
		{
		0x7a97,
		0xb5a1
		},
		{
		0x7a98,
		0xb57e
		},
		{
		0x7a99,
		0xdadb
		},
		{
		0x7a9e,
		0xdf44
		},
		{
		0x7a9f,
		0xb85d
		},
		{
		0x7aa0,
		0xb85e
		},
		{
		0x7aa2,
		0xdf43
		},
		{
		0x7aa3,
		0xdf42
		},
		{
		0x7aa8,
		0xe34a
		},
		{
		0x7aa9,
		0xbadb
		},
		{
		0x7aaa,
		0xbada
		},
		{
		0x7aab,
		0xe34b
		},
		{
		0x7aac,
		0xe34c
		},
		{
		0x7aae,
		0xbd61
		},
		{
		0x7aaf,
		0xbd60
		},
		{
		0x7ab1,
		0xeab5
		},
		{
		0x7ab2,
		0xe6d3
		},
		{
		0x7ab3,
		0xe6d5
		},
		{
		0x7ab4,
		0xe6d4
		},
		{
		0x7ab5,
		0xeab4
		},
		{
		0x7ab6,
		0xeab2
		},
		{
		0x7ab7,
		0xeab6
		},
		{
		0x7ab8,
		0xeab3
		},
		{
		0x7aba,
		0xbf73
		},
		{
		0x7abe,
		0xedb7
		},
		{
		0x7abf,
		0xc14b
		},
		{
		0x7ac0,
		0xedb8
		},
		{
		0x7ac1,
		0xedb9
		},
		{
		0x7ac4,
		0xc2ab
		},
		{
		0x7ac5,
		0xc2ac
		},
		{
		0x7ac7,
		0xc475
		},
		{
		0x7aca,
		0xc5d1
		},
		{
		0x7acb,
		0xa5df
		},
		{
		0x7ad1,
		0xd041
		},
		{
		0x7ad8,
		0xd2fd
		},
		{
		0x7ad9,
		0xafb8
		},
		{
		0x7adf,
		0xb3ba
		},
		{
		0x7ae0,
		0xb3b9
		},
		{
		0x7ae3,
		0xb5a4
		},
		{
		0x7ae4,
		0xdadd
		},
		{
		0x7ae5,
		0xb5a3
		},
		{
		0x7ae6,
		0xdadc
		},
		{
		0x7aeb,
		0xdf45
		},
		{
		0x7aed,
		0xbadc
		},
		{
		0x7aee,
		0xe34d
		},
		{
		0x7aef,
		0xbadd
		},
		{
		0x7af6,
		0xc476
		},
		{
		0x7af7,
		0xf4a5
		},
		{
		0x7af9,
		0xa6cb
		},
		{
		0x7afa,
		0xaac7
		},
		{
		0x7afb,
		0xcda7
		},
		{
		0x7afd,
		0xacf2
		},
		{
		0x7aff,
		0xacf1
		},
		{
		0x7b00,
		0xd042
		},
		{
		0x7b01,
		0xd043
		},
		{
		0x7b04,
		0xd340
		},
		{
		0x7b05,
		0xd342
		},
		{
		0x7b06,
		0xafb9
		},
		{
		0x7b08,
		0xd344
		},
		{
		0x7b09,
		0xd347
		},
		{
		0x7b0a,
		0xd345
		},
		{
		0x7b0e,
		0xd346
		},
		{
		0x7b0f,
		0xd343
		},
		{
		0x7b10,
		0xd2fe
		},
		{
		0x7b11,
		0xafba
		},
		{
		0x7b12,
		0xd348
		},
		{
		0x7b13,
		0xd341
		},
		{
		0x7b18,
		0xd6d3
		},
		{
		0x7b19,
		0xb2c6
		},
		{
		0x7b1a,
		0xd6dc
		},
		{
		0x7b1b,
		0xb2c3
		},
		{
		0x7b1d,
		0xd6d5
		},
		{
		0x7b1e,
		0xb2c7
		},
		{
		0x7b20,
		0xb2c1
		},
		{
		0x7b22,
		0xd6d0
		},
		{
		0x7b23,
		0xd6dd
		},
		{
		0x7b24,
		0xd6d1
		},
		{
		0x7b25,
		0xd6ce
		},
		{
		0x7b26,
		0xb2c5
		},
		{
		0x7b28,
		0xb2c2
		},
		{
		0x7b2a,
		0xd6d4
		},
		{
		0x7b2b,
		0xd6d7
		},
		{
		0x7b2c,
		0xb2c4
		},
		{
		0x7b2d,
		0xd6d8
		},
		{
		0x7b2e,
		0xb2c8
		},
		{
		0x7b2f,
		0xd6d9
		},
		{
		0x7b30,
		0xd6cf
		},
		{
		0x7b31,
		0xd6d6
		},
		{
		0x7b32,
		0xd6da
		},
		{
		0x7b33,
		0xd6d2
		},
		{
		0x7b34,
		0xd6cd
		},
		{
		0x7b35,
		0xd6cb
		},
		{
		0x7b38,
		0xd6db
		},
		{
		0x7b3b,
		0xdadf
		},
		{
		0x7b40,
		0xdae4
		},
		{
		0x7b44,
		0xdae0
		},
		{
		0x7b45,
		0xdae6
		},
		{
		0x7b46,
		0xb5a7
		},
		{
		0x7b47,
		0xd6cc
		},
		{
		0x7b48,
		0xdae1
		},
		{
		0x7b49,
		0xb5a5
		},
		{
		0x7b4a,
		0xdade
		},
		{
		0x7b4b,
		0xb5ac
		},
		{
		0x7b4c,
		0xdae2
		},
		{
		0x7b4d,
		0xb5ab
		},
		{
		0x7b4e,
		0xdae3
		},
		{
		0x7b4f,
		0xb5ad
		},
		{
		0x7b50,
		0xb5a8
		},
		{
		0x7b51,
		0xb5ae
		},
		{
		0x7b52,
		0xb5a9
		},
		{
		0x7b54,
		0xb5aa
		},
		{
		0x7b56,
		0xb5a6
		},
		{
		0x7b58,
		0xdae5
		},
		{
		0x7b60,
		0xb861
		},
		{
		0x7b61,
		0xdf50
		},
		{
		0x7b63,
		0xdf53
		},
		{
		0x7b64,
		0xdf47
		},
		{
		0x7b65,
		0xdf4c
		},
		{
		0x7b66,
		0xdf46
		},
		{
		0x7b67,
		0xb863
		},
		{
		0x7b69,
		0xdf4a
		},
		{
		0x7b6d,
		0xdf48
		},
		{
		0x7b6e,
		0xb862
		},
		{
		0x7b70,
		0xdf4f
		},
		{
		0x7b71,
		0xdf4e
		},
		{
		0x7b72,
		0xdf4b
		},
		{
		0x7b73,
		0xdf4d
		},
		{
		0x7b74,
		0xdf49
		},
		{
		0x7b75,
		0xbae1
		},
		{
		0x7b76,
		0xdf52
		},
		{
		0x7b77,
		0xb85f
		},
		{
		0x7b78,
		0xdf51
		},
		{
		0x7b82,
		0xe35d
		},
		{
		0x7b84,
		0xbae8
		},
		{
		0x7b85,
		0xe358
		},
		{
		0x7b87,
		0xbae7
		},
		{
		0x7b88,
		0xe34e
		},
		{
		0x7b8a,
		0xe350
		},
		{
		0x7b8b,
		0xbae0
		},
		{
		0x7b8c,
		0xe355
		},
		{
		0x7b8d,
		0xe354
		},
		{
		0x7b8e,
		0xe357
		},
		{
		0x7b8f,
		0xbae5
		},
		{
		0x7b90,
		0xe352
		},
		{
		0x7b91,
		0xe351
		},
		{
		0x7b94,
		0xbae4
		},
		{
		0x7b95,
		0xbadf
		},
		{
		0x7b96,
		0xe353
		},
		{
		0x7b97,
		0xbae2
		},
		{
		0x7b98,
		0xe359
		},
		{
		0x7b99,
		0xe35b
		},
		{
		0x7b9b,
		0xe356
		},
		{
		0x7b9c,
		0xe34f
		},
		{
		0x7b9d,
		0xbae3
		},
		{
		0x7ba0,
		0xbd69
		},
		{
		0x7ba1,
		0xbade
		},
		{
		0x7ba4,
		0xe35c
		},
		{
		0x7bac,
		0xe6d9
		},
		{
		0x7bad,
		0xbd62
		},
		{
		0x7baf,
		0xe6db
		},
		{
		0x7bb1,
		0xbd63
		},
		{
		0x7bb4,
		0xbd65
		},
		{
		0x7bb5,
		0xe6de
		},
		{
		0x7bb7,
		0xe6d6
		},
		{
		0x7bb8,
		0xbae6
		},
		{
		0x7bb9,
		0xe6dc
		},
		{
		0x7bbe,
		0xe6d8
		},
		{
		0x7bc0,
		0xb860
		},
		{
		0x7bc1,
		0xbd68
		},
		{
		0x7bc4,
		0xbd64
		},
		{
		0x7bc6,
		0xbd66
		},
		{
		0x7bc7,
		0xbd67
		},
		{
		0x7bc9,
		0xbf76
		},
		{
		0x7bca,
		0xe6dd
		},
		{
		0x7bcb,
		0xe6d7
		},
		{
		0x7bcc,
		0xbd6a
		},
		{
		0x7bce,
		0xe6da
		},
		{
		0x7bd4,
		0xeac0
		},
		{
		0x7bd5,
		0xeabb
		},
		{
		0x7bd8,
		0xeac5
		},
		{
		0x7bd9,
		0xbf74
		},
		{
		0x7bda,
		0xeabd
		},
		{
		0x7bdb,
		0xbf78
		},
		{
		0x7bdc,
		0xeac3
		},
		{
		0x7bdd,
		0xeaba
		},
		{
		0x7bde,
		0xeab7
		},
		{
		0x7bdf,
		0xeac6
		},
		{
		0x7be0,
		0xc151
		},
		{
		0x7be1,
		0xbf79
		},
		{
		0x7be2,
		0xeac2
		},
		{
		0x7be3,
		0xeab8
		},
		{
		0x7be4,
		0xbf77
		},
		{
		0x7be5,
		0xeabc
		},
		{
		0x7be6,
		0xbf7b
		},
		{
		0x7be7,
		0xeab9
		},
		{
		0x7be8,
		0xeabe
		},
		{
		0x7be9,
		0xbf7a
		},
		{
		0x7bea,
		0xeac1
		},
		{
		0x7beb,
		0xeac4
		},
		{
		0x7bf0,
		0xedcb
		},
		{
		0x7bf1,
		0xedcc
		},
		{
		0x7bf2,
		0xedbc
		},
		{
		0x7bf3,
		0xedc3
		},
		{
		0x7bf4,
		0xedc1
		},
		{
		0x7bf7,
		0xc14f
		},
		{
		0x7bf8,
		0xedc8
		},
		{
		0x7bf9,
		0xeabf
		},
		{
		0x7bfb,
		0xedbf
		},
		{
		0x7bfd,
		0xedc9
		},
		{
		0x7bfe,
		0xc14e
		},
		{
		0x7bff,
		0xedbe
		},
		{
		0x7c00,
		0xedbd
		},
		{
		0x7c01,
		0xedc7
		},
		{
		0x7c02,
		0xedc4
		},
		{
		0x7c03,
		0xedc6
		},
		{
		0x7c05,
		0xedba
		},
		{
		0x7c06,
		0xedca
		},
		{
		0x7c07,
		0xc14c
		},
		{
		0x7c09,
		0xedc5
		},
		{
		0x7c0a,
		0xedce
		},
		{
		0x7c0b,
		0xedc2
		},
		{
		0x7c0c,
		0xc150
		},
		{
		0x7c0d,
		0xc14d
		},
		{
		0x7c0e,
		0xedc0
		},
		{
		0x7c0f,
		0xedbb
		},
		{
		0x7c10,
		0xedcd
		},
		{
		0x7c11,
		0xbf75
		},
		{
		0x7c19,
		0xf063
		},
		{
		0x7c1c,
		0xf061
		},
		{
		0x7c1d,
		0xf067
		},
		{
		0x7c1e,
		0xc2b0
		},
		{
		0x7c1f,
		0xf065
		},
		{
		0x7c20,
		0xf064
		},
		{
		0x7c21,
		0xc2b2
		},
		{
		0x7c22,
		0xf06a
		},
		{
		0x7c23,
		0xc2b1
		},
		{
		0x7c25,
		0xf06b
		},
		{
		0x7c26,
		0xf068
		},
		{
		0x7c27,
		0xc2ae
		},
		{
		0x7c28,
		0xf069
		},
		{
		0x7c29,
		0xf062
		},
		{
		0x7c2a,
		0xc2af
		},
		{
		0x7c2b,
		0xc2ad
		},
		{
		0x7c2c,
		0xf2ab
		},
		{
		0x7c2d,
		0xf066
		},
		{
		0x7c30,
		0xf06c
		},
		{
		0x7c33,
		0xf2a8
		},
		{
		0x7c37,
		0xc3b2
		},
		{
		0x7c38,
		0xc3b0
		},
		{
		0x7c39,
		0xf2aa
		},
		{
		0x7c3b,
		0xf2ac
		},
		{
		0x7c3c,
		0xf2a9
		},
		{
		0x7c3d,
		0xc3b1
		},
		{
		0x7c3e,
		0xc3ae
		},
		{
		0x7c3f,
		0xc3af
		},
		{
		0x7c40,
		0xc3b3
		},
		{
		0x7c43,
		0xc478
		},
		{
		0x7c45,
		0xf4aa
		},
		{
		0x7c47,
		0xf4a9
		},
		{
		0x7c48,
		0xf4a7
		},
		{
		0x7c49,
		0xf4a6
		},
		{
		0x7c4a,
		0xf4a8
		},
		{
		0x7c4c,
		0xc477
		},
		{
		0x7c4d,
		0xc479
		},
		{
		0x7c50,
		0xc4f0
		},
		{
		0x7c53,
		0xf5e5
		},
		{
		0x7c54,
		0xf5e4
		},
		{
		0x7c57,
		0xf6fa
		},
		{
		0x7c59,
		0xf6fc
		},
		{
		0x7c5a,
		0xf6fe
		},
		{
		0x7c5b,
		0xf6fd
		},
		{
		0x7c5c,
		0xf6fb
		},
		{
		0x7c5f,
		0xc5a3
		},
		{
		0x7c60,
		0xc5a2
		},
		{
		0x7c63,
		0xc5d3
		},
		{
		0x7c64,
		0xc5d2
		},
		{
		0x7c65,
		0xc5d4
		},
		{
		0x7c66,
		0xf7ed
		},
		{
		0x7c67,
		0xf7ec
		},
		{
		0x7c69,
		0xf8fb
		},
		{
		0x7c6a,
		0xf8b8
		},
		{
		0x7c6b,
		0xf8fc
		},
		{
		0x7c6c,
		0xc658
		},
		{
		0x7c6e,
		0xc659
		},
		{
		0x7c6f,
		0xf96d
		},
		{
		0x7c72,
		0xc67e
		},
		{
		0x7c73,
		0xa6cc
		},
		{
		0x7c75,
		0xcda8
		},
		{
		0x7c78,
		0xd045
		},
		{
		0x7c79,
		0xd046
		},
		{
		0x7c7a,
		0xd044
		},
		{
		0x7c7d,
		0xacf3
		},
		{
		0x7c7f,
		0xd047
		},
		{
		0x7c80,
		0xd048
		},
		{
		0x7c81,
		0xd049
		},
		{
		0x7c84,
		0xd349
		},
		{
		0x7c85,
		0xd34f
		},
		{
		0x7c88,
		0xd34d
		},
		{
		0x7c89,
		0xafbb
		},
		{
		0x7c8a,
		0xd34b
		},
		{
		0x7c8c,
		0xd34c
		},
		{
		0x7c8d,
		0xd34e
		},
		{
		0x7c91,
		0xd34a
		},
		{
		0x7c92,
		0xb2c9
		},
		{
		0x7c94,
		0xd6de
		},
		{
		0x7c95,
		0xb2cb
		},
		{
		0x7c96,
		0xd6e0
		},
		{
		0x7c97,
		0xb2ca
		},
		{
		0x7c98,
		0xd6df
		},
		{
		0x7c9e,
		0xdae8
		},
		{
		0x7c9f,
		0xb5af
		},
		{
		0x7ca1,
		0xdaea
		},
		{
		0x7ca2,
		0xdae7
		},
		{
		0x7ca3,
		0xd6e1
		},
		{
		0x7ca5,
		0xb5b0
		},
		{
		0x7ca8,
		0xdae9
		},
		{
		0x7caf,
		0xdf56
		},
		{
		0x7cb1,
		0xb864
		},
		{
		0x7cb2,
		0xdf54
		},
		{
		0x7cb3,
		0xb865
		},
		{
		0x7cb4,
		0xdf55
		},
		{
		0x7cb5,
		0xb866
		},
		{
		0x7cb9,
		0xbae9
		},
		{
		0x7cba,
		0xe361
		},
		{
		0x7cbb,
		0xe35e
		},
		{
		0x7cbc,
		0xe360
		},
		{
		0x7cbd,
		0xbaea
		},
		{
		0x7cbe,
		0xbaeb
		},
		{
		0x7cbf,
		0xe35f
		},
		{
		0x7cc5,
		0xe6df
		},
		{
		0x7cc8,
		0xe6e0
		},
		{
		0x7cca,
		0xbd6b
		},
		{
		0x7ccb,
		0xe6e2
		},
		{
		0x7ccc,
		0xe6e1
		},
		{
		0x7cce,
		0xa261
		},
		{
		0x7cd0,
		0xeaca
		},
		{
		0x7cd1,
		0xeacb
		},
		{
		0x7cd2,
		0xeac7
		},
		{
		0x7cd4,
		0xeac8
		},
		{
		0x7cd5,
		0xbf7c
		},
		{
		0x7cd6,
		0xbf7d
		},
		{
		0x7cd7,
		0xeac9
		},
		{
		0x7cd9,
		0xc157
		},
		{
		0x7cdc,
		0xc153
		},
		{
		0x7cdd,
		0xc158
		},
		{
		0x7cde,
		0xc154
		},
		{
		0x7cdf,
		0xc156
		},
		{
		0x7ce0,
		0xc152
		},
		{
		0x7ce2,
		0xc155
		},
		{
		0x7ce7,
		0xc2b3
		},
		{
		0x7ce8,
		0xedcf
		},
		{
		0x7cea,
		0xf2ae
		},
		{
		0x7cec,
		0xf2ad
		},
		{
		0x7cee,
		0xf4ab
		},
		{
		0x7cef,
		0xc47a
		},
		{
		0x7cf0,
		0xc47b
		},
		{
		0x7cf1,
		0xf741
		},
		{
		0x7cf2,
		0xf5e6
		},
		{
		0x7cf4,
		0xf740
		},
		{
		0x7cf6,
		0xf8fd
		},
		{
		0x7cf7,
		0xf9a4
		},
		{
		0x7cf8,
		0xa6cd
		},
		{
		0x7cfb,
		0xa874
		},
		{
		0x7cfd,
		0xcda9
		},
		{
		0x7cfe,
		0xaac8
		},
		{
		0x7d00,
		0xacf6
		},
		{
		0x7d01,
		0xd04c
		},
		{
		0x7d02,
		0xacf4
		},
		{
		0x7d03,
		0xd04a
		},
		{
		0x7d04,
		0xacf9
		},
		{
		0x7d05,
		0xacf5
		},
		{
		0x7d06,
		0xacfa
		},
		{
		0x7d07,
		0xacf8
		},
		{
		0x7d08,
		0xd04b
		},
		{
		0x7d09,
		0xacf7
		},
		{
		0x7d0a,
		0xafbf
		},
		{
		0x7d0b,
		0xafbe
		},
		{
		0x7d0c,
		0xd35a
		},
		{
		0x7d0d,
		0xafc7
		},
		{
		0x7d0e,
		0xd353
		},
		{
		0x7d0f,
		0xd359
		},
		{
		0x7d10,
		0xafc3
		},
		{
		0x7d11,
		0xd352
		},
		{
		0x7d12,
		0xd358
		},
		{
		0x7d13,
		0xd356
		},
		{
		0x7d14,
		0xafc2
		},
		{
		0x7d15,
		0xafc4
		},
		{
		0x7d16,
		0xd355
		},
		{
		0x7d17,
		0xafbd
		},
		{
		0x7d18,
		0xd354
		},
		{
		0x7d19,
		0xafc8
		},
		{
		0x7d1a,
		0xafc5
		},
		{
		0x7d1b,
		0xafc9
		},
		{
		0x7d1c,
		0xafc6
		},
		{
		0x7d1d,
		0xd351
		},
		{
		0x7d1e,
		0xd350
		},
		{
		0x7d1f,
		0xd357
		},
		{
		0x7d20,
		0xafc0
		},
		{
		0x7d21,
		0xafbc
		},
		{
		0x7d22,
		0xafc1
		},
		{
		0x7d28,
		0xd6f0
		},
		{
		0x7d29,
		0xd6e9
		},
		{
		0x7d2b,
		0xb5b5
		},
		{
		0x7d2c,
		0xd6e8
		},
		{
		0x7d2e,
		0xb2cf
		},
		{
		0x7d2f,
		0xb2d6
		},
		{
		0x7d30,
		0xb2d3
		},
		{
		0x7d31,
		0xb2d9
		},
		{
		0x7d32,
		0xb2d8
		},
		{
		0x7d33,
		0xb2d4
		},
		{
		0x7d35,
		0xd6e2
		},
		{
		0x7d36,
		0xd6e5
		},
		{
		0x7d38,
		0xd6e4
		},
		{
		0x7d39,
		0xb2d0
		},
		{
		0x7d3a,
		0xd6e6
		},
		{
		0x7d3b,
		0xd6ef
		},
		{
		0x7d3c,
		0xb2d1
		},
		{
		0x7d3d,
		0xd6e3
		},
		{
		0x7d3e,
		0xd6ec
		},
		{
		0x7d3f,
		0xd6ed
		},
		{
		0x7d40,
		0xb2d2
		},
		{
		0x7d41,
		0xd6ea
		},
		{
		0x7d42,
		0xb2d7
		},
		{
		0x7d43,
		0xb2cd
		},
		{
		0x7d44,
		0xb2d5
		},
		{
		0x7d45,
		0xd6e7
		},
		{
		0x7d46,
		0xb2cc
		},
		{
		0x7d47,
		0xd6eb
		},
		{
		0x7d4a,
		0xd6ee
		},
		{
		0x7d4e,
		0xdafb
		},
		{
		0x7d4f,
		0xdaf2
		},
		{
		0x7d50,
		0xb5b2
		},
		{
		0x7d51,
		0xdaf9
		},
		{
		0x7d52,
		0xdaf6
		},
		{
		0x7d53,
		0xdaee
		},
		{
		0x7d54,
		0xdaf7
		},
		{
		0x7d55,
		0xb5b4
		},
		{
		0x7d56,
		0xdaef
		},
		{
		0x7d58,
		0xdaeb
		},
		{
		0x7d5b,
		0xb86c
		},
		{
		0x7d5c,
		0xdaf4
		},
		{
		0x7d5e,
		0xb5b1
		},
		{
		0x7d5f,
		0xdafa
		},
		{
		0x7d61,
		0xb5b8
		},
		{
		0x7d62,
		0xb5ba
		},
		{
		0x7d63,
		0xdaed
		},
		{
		0x7d66,
		0xb5b9
		},
		{
		0x7d67,
		0xdaf0
		},
		{
		0x7d68,
		0xb5b3
		},
		{
		0x7d69,
		0xdaf8
		},
		{
		0x7d6a,
		0xdaf1
		},
		{
		0x7d6b,
		0xdaf5
		},
		{
		0x7d6d,
		0xdaf3
		},
		{
		0x7d6e,
		0xb5b6
		},
		{
		0x7d6f,
		0xdaec
		},
		{
		0x7d70,
		0xb5bb
		},
		{
		0x7d71,
		0xb2ce
		},
		{
		0x7d72,
		0xb5b7
		},
		{
		0x7d73,
		0xb5bc
		},
		{
		0x7d79,
		0xb868
		},
		{
		0x7d7a,
		0xdf5d
		},
		{
		0x7d7b,
		0xdf5f
		},
		{
		0x7d7c,
		0xdf61
		},
		{
		0x7d7d,
		0xdf65
		},
		{
		0x7d7f,
		0xdf5b
		},
		{
		0x7d80,
		0xdf59
		},
		{
		0x7d81,
		0xb86a
		},
		{
		0x7d83,
		0xdf60
		},
		{
		0x7d84,
		0xdf64
		},
		{
		0x7d85,
		0xdf5c
		},
		{
		0x7d86,
		0xdf58
		},
		{
		0x7d88,
		0xdf57
		},
		{
		0x7d8c,
		0xdf62
		},
		{
		0x7d8d,
		0xdf5a
		},
		{
		0x7d8e,
		0xdf5e
		},
		{
		0x7d8f,
		0xb86b
		},
		{
		0x7d91,
		0xb869
		},
		{
		0x7d92,
		0xdf66
		},
		{
		0x7d93,
		0xb867
		},
		{
		0x7d94,
		0xdf63
		},
		{
		0x7d96,
		0xe372
		},
		{
		0x7d9c,
		0xbaee
		},
		{
		0x7d9d,
		0xe36a
		},
		{
		0x7d9e,
		0xbd78
		},
		{
		0x7d9f,
		0xe374
		},
		{
		0x7da0,
		0xbaf1
		},
		{
		0x7da1,
		0xe378
		},
		{
		0x7da2,
		0xbaf7
		},
		{
		0x7da3,
		0xe365
		},
		{
		0x7da6,
		0xe375
		},
		{
		0x7da7,
		0xe362
		},
		{
		0x7da9,
		0xe377
		},
		{
		0x7daa,
		0xe366
		},
		{
		0x7dac,
		0xbafe
		},
		{
		0x7dad,
		0xbafb
		},
		{
		0x7dae,
		0xe376
		},
		{
		0x7daf,
		0xe370
		},
		{
		0x7db0,
		0xbaed
		},
		{
		0x7db1,
		0xbaf5
		},
		{
		0x7db2,
		0xbaf4
		},
		{
		0x7db4,
		0xbaf3
		},
		{
		0x7db5,
		0xbaf9
		},
		{
		0x7db7,
		0xe363
		},
		{
		0x7db8,
		0xbafa
		},
		{
		0x7db9,
		0xe371
		},
		{
		0x7dba,
		0xbaf6
		},
		{
		0x7dbb,
		0xbaec
		},
		{
		0x7dbc,
		0xe373
		},
		{
		0x7dbd,
		0xbaef
		},
		{
		0x7dbe,
		0xbaf0
		},
		{
		0x7dbf,
		0xbaf8
		},
		{
		0x7dc0,
		0xe368
		},
		{
		0x7dc1,
		0xe367
		},
		{
		0x7dc2,
		0xe364
		},
		{
		0x7dc4,
		0xe36c
		},
		{
		0x7dc5,
		0xe369
		},
		{
		0x7dc6,
		0xe36d
		},
		{
		0x7dc7,
		0xbafd
		},
		{
		0x7dc9,
		0xe379
		},
		{
		0x7dca,
		0xbaf2
		},
		{
		0x7dcb,
		0xe36e
		},
		{
		0x7dcc,
		0xe36f
		},
		{
		0x7dce,
		0xe36b
		},
		{
		0x7dd2,
		0xbafc
		},
		{
		0x7dd7,
		0xe6e7
		},
		{
		0x7dd8,
		0xbd70
		},
		{
		0x7dd9,
		0xbd79
		},
		{
		0x7dda,
		0xbd75
		},
		{
		0x7ddb,
		0xe6e4
		},
		{
		0x7ddd,
		0xbd72
		},
		{
		0x7dde,
		0xbd76
		},
		{
		0x7ddf,
		0xe6f0
		},
		{
		0x7de0,
		0xbd6c
		},
		{
		0x7de1,
		0xe6e8
		},
		{
		0x7de3,
		0xbd74
		},
		{
		0x7de6,
		0xe6eb
		},
		{
		0x7de7,
		0xe6e6
		},
		{
		0x7de8,
		0xbd73
		},
		{
		0x7de9,
		0xbd77
		},
		{
		0x7dea,
		0xe6e5
		},
		{
		0x7dec,
		0xbd71
		},
		{
		0x7dee,
		0xe6ef
		},
		{
		0x7def,
		0xbd6e
		},
		{
		0x7df0,
		0xe6ee
		},
		{
		0x7df1,
		0xe6ed
		},
		{
		0x7df2,
		0xbd7a
		},
		{
		0x7df3,
		0xe572
		},
		{
		0x7df4,
		0xbd6d
		},
		{
		0x7df6,
		0xe6ec
		},
		{
		0x7df7,
		0xe6e3
		},
		{
		0x7df9,
		0xbd7b
		},
		{
		0x7dfa,
		0xe6ea
		},
		{
		0x7dfb,
		0xbd6f
		},
		{
		0x7e03,
		0xe6e9
		},
		{
		0x7e08,
		0xbfa2
		},
		{
		0x7e09,
		0xbfa7
		},
		{
		0x7e0a,
		0xbf7e
		},
		{
		0x7e0b,
		0xead8
		},
		{
		0x7e0c,
		0xeacf
		},
		{
		0x7e0d,
		0xeadb
		},
		{
		0x7e0e,
		0xead3
		},
		{
		0x7e0f,
		0xead9
		},
		{
		0x7e10,
		0xbfa8
		},
		{
		0x7e11,
		0xbfa1
		},
		{
		0x7e12,
		0xeacc
		},
		{
		0x7e13,
		0xead2
		},
		{
		0x7e14,
		0xeadc
		},
		{
		0x7e15,
		0xead5
		},
		{
		0x7e16,
		0xeada
		},
		{
		0x7e17,
		0xeace
		},
		{
		0x7e1a,
		0xead6
		},
		{
		0x7e1b,
		0xbfa3
		},
		{
		0x7e1c,
		0xead4
		},
		{
		0x7e1d,
		0xbfa6
		},
		{
		0x7e1e,
		0xbfa5
		},
		{
		0x7e1f,
		0xead0
		},
		{
		0x7e20,
		0xead1
		},
		{
		0x7e21,
		0xeacd
		},
		{
		0x7e22,
		0xead7
		},
		{
		0x7e23,
		0xbfa4
		},
		{
		0x7e24,
		0xeade
		},
		{
		0x7e25,
		0xeadd
		},
		{
		0x7e29,
		0xedda
		},
		{
		0x7e2a,
		0xedd6
		},
		{
		0x7e2b,
		0xc15f
		},
		{
		0x7e2d,
		0xedd0
		},
		{
		0x7e2e,
		0xc159
		},
		{
		0x7e2f,
		0xc169
		},
		{
		0x7e30,
		0xeddc
		},
		{
		0x7e31,
		0xc161
		},
		{
		0x7e32,
		0xc15d
		},
		{
		0x7e33,
		0xedd3
		},
		{
		0x7e34,
		0xc164
		},
		{
		0x7e35,
		0xc167
		},
		{
		0x7e36,
		0xedde
		},
		{
		0x7e37,
		0xc15c
		},
		{
		0x7e38,
		0xedd5
		},
		{
		0x7e39,
		0xc165
		},
		{
		0x7e3a,
		0xede0
		},
		{
		0x7e3b,
		0xeddd
		},
		{
		0x7e3c,
		0xedd1
		},
		{
		0x7e3d,
		0xc160
		},
		{
		0x7e3e,
		0xc15a
		},
		{
		0x7e3f,
		0xc168
		},
		{
		0x7e40,
		0xedd8
		},
		{
		0x7e41,
		0xc163
		},
		{
		0x7e42,
		0xedd2
		},
		{
		0x7e43,
		0xc15e
		},
		{
		0x7e44,
		0xeddf
		},
		{
		0x7e45,
		0xc162
		},
		{
		0x7e46,
		0xc15b
		},
		{
		0x7e47,
		0xedd9
		},
		{
		0x7e48,
		0xc166
		},
		{
		0x7e49,
		0xedd7
		},
		{
		0x7e4c,
		0xeddb
		},
		{
		0x7e50,
		0xf06e
		},
		{
		0x7e51,
		0xf074
		},
		{
		0x7e52,
		0xc2b9
		},
		{
		0x7e53,
		0xf077
		},
		{
		0x7e54,
		0xc2b4
		},
		{
		0x7e55,
		0xc2b5
		},
		{
		0x7e56,
		0xf06f
		},
		{
		0x7e57,
		0xf076
		},
		{
		0x7e58,
		0xf071
		},
		{
		0x7e59,
		0xc2ba
		},
		{
		0x7e5a,
		0xc2b7
		},
		{
		0x7e5c,
		0xf06d
		},
		{
		0x7e5e,
		0xc2b6
		},
		{
		0x7e5f,
		0xf073
		},
		{
		0x7e60,
		0xf075
		},
		{
		0x7e61,
		0xc2b8
		},
		{
		0x7e62,
		0xf072
		},
		{
		0x7e63,
		0xf070
		},
		{
		0x7e68,
		0xf2b8
		},
		{
		0x7e69,
		0xc3b7
		},
		{
		0x7e6a,
		0xc3b8
		},
		{
		0x7e6b,
		0xc3b4
		},
		{
		0x7e6d,
		0xc3b5
		},
		{
		0x7e6f,
		0xf2b4
		},
		{
		0x7e70,
		0xf2b2
		},
		{
		0x7e72,
		0xf2b6
		},
		{
		0x7e73,
		0xc3ba
		},
		{
		0x7e74,
		0xf2b7
		},
		{
		0x7e75,
		0xf2b0
		},
		{
		0x7e76,
		0xf2af
		},
		{
		0x7e77,
		0xf2b3
		},
		{
		0x7e78,
		0xf2b1
		},
		{
		0x7e79,
		0xc3b6
		},
		{
		0x7e7a,
		0xf2b5
		},
		{
		0x7e7b,
		0xf4ac
		},
		{
		0x7e7c,
		0xc47e
		},
		{
		0x7e7d,
		0xc47d
		},
		{
		0x7e7e,
		0xf4ad
		},
		{
		0x7e80,
		0xf4af
		},
		{
		0x7e81,
		0xf4ae
		},
		{
		0x7e82,
		0xc4a1
		},
		{
		0x7e86,
		0xf5eb
		},
		{
		0x7e87,
		0xf5e8
		},
		{
		0x7e88,
		0xf5e9
		},
		{
		0x7e8a,
		0xf5e7
		},
		{
		0x7e8b,
		0xf5ea
		},
		{
		0x7e8c,
		0xc4f2
		},
		{
		0x7e8d,
		0xf5ec
		},
		{
		0x7e8f,
		0xc4f1
		},
		{
		0x7e91,
		0xf742
		},
		{
		0x7e93,
		0xc5d5
		},
		{
		0x7e94,
		0xc5d7
		},
		{
		0x7e95,
		0xf7ee
		},
		{
		0x7e96,
		0xc5d6
		},
		{
		0x7e97,
		0xf8b9
		},
		{
		0x7e98,
		0xf940
		},
		{
		0x7e99,
		0xf942
		},
		{
		0x7e9a,
		0xf8fe
		},
		{
		0x7e9b,
		0xf941
		},
		{
		0x7e9c,
		0xc66c
		},
		{
		0x7f36,
		0xa6ce
		},
		{
		0x7f38,
		0xacfb
		},
		{
		0x7f39,
		0xd26f
		},
		{
		0x7f3a,
		0xafca
		},
		{
		0x7f3d,
		0xb2da
		},
		{
		0x7f3e,
		0xdafc
		},
		{
		0x7f3f,
		0xdafd
		},
		{
		0x7f43,
		0xeadf
		},
		{
		0x7f44,
		0xc16a
		},
		{
		0x7f45,
		0xede1
		},
		{
		0x7f48,
		0xc2bb
		},
		{
		0x7f4a,
		0xf2ba
		},
		{
		0x7f4b,
		0xf2b9
		},
		{
		0x7f4c,
		0xc4a2
		},
		{
		0x7f4d,
		0xf5ed
		},
		{
		0x7f4f,
		0xf743
		},
		{
		0x7f50,
		0xc5f8
		},
		{
		0x7f51,
		0xca49
		},
		{
		0x7f54,
		0xaac9
		},
		{
		0x7f55,
		0xa875
		},
		{
		0x7f58,
		0xd04d
		},
		{
		0x7f5b,
		0xd360
		},
		{
		0x7f5c,
		0xd35b
		},
		{
		0x7f5d,
		0xd35f
		},
		{
		0x7f5e,
		0xd35d
		},
		{
		0x7f5f,
		0xafcb
		},
		{
		0x7f60,
		0xd35e
		},
		{
		0x7f61,
		0xd35c
		},
		{
		0x7f63,
		0xd6f1
		},
		{
		0x7f65,
		0xdafe
		},
		{
		0x7f66,
		0xdb40
		},
		{
		0x7f67,
		0xdf69
		},
		{
		0x7f68,
		0xdf6a
		},
		{
		0x7f69,
		0xb86e
		},
		{
		0x7f6a,
		0xb86f
		},
		{
		0x7f6b,
		0xdf68
		},
		{
		0x7f6c,
		0xdf6b
		},
		{
		0x7f6d,
		0xdf67
		},
		{
		0x7f6e,
		0xb86d
		},
		{
		0x7f70,
		0xbb40
		},
		{
		0x7f72,
		0xb870
		},
		{
		0x7f73,
		0xe37a
		},
		{
		0x7f75,
		0xbd7c
		},
		{
		0x7f76,
		0xe6f1
		},
		{
		0x7f77,
		0xbd7d
		},
		{
		0x7f79,
		0xbfa9
		},
		{
		0x7f7a,
		0xeae2
		},
		{
		0x7f7b,
		0xeae0
		},
		{
		0x7f7c,
		0xeae1
		},
		{
		0x7f7d,
		0xede4
		},
		{
		0x7f7e,
		0xede3
		},
		{
		0x7f7f,
		0xede2
		},
		{
		0x7f83,
		0xf2bb
		},
		{
		0x7f85,
		0xc3b9
		},
		{
		0x7f86,
		0xf2bc
		},
		{
		0x7f87,
		0xf744
		},
		{
		0x7f88,
		0xc5f9
		},
		{
		0x7f89,
		0xf8ba
		},
		{
		0x7f8a,
		0xa6cf
		},
		{
		0x7f8b,
		0xaacb
		},
		{
		0x7f8c,
		0xaaca
		},
		{
		0x7f8d,
		0xd04f
		},
		{
		0x7f8e,
		0xacfc
		},
		{
		0x7f91,
		0xd04e
		},
		{
		0x7f92,
		0xd362
		},
		{
		0x7f94,
		0xafcc
		},
		{
		0x7f95,
		0xd6f2
		},
		{
		0x7f96,
		0xd361
		},
		{
		0x7f9a,
		0xb2dc
		},
		{
		0x7f9b,
		0xd6f5
		},
		{
		0x7f9c,
		0xd6f3
		},
		{
		0x7f9d,
		0xd6f4
		},
		{
		0x7f9e,
		0xb2db
		},
		{
		0x7fa0,
		0xdb42
		},
		{
		0x7fa1,
		0xdb43
		},
		{
		0x7fa2,
		0xdb41
		},
		{
		0x7fa4,
		0xb873
		},
		{
		0x7fa5,
		0xdf6d
		},
		{
		0x7fa6,
		0xdf6c
		},
		{
		0x7fa7,
		0xdf6e
		},
		{
		0x7fa8,
		0xb872
		},
		{
		0x7fa9,
		0xb871
		},
		{
		0x7fac,
		0xe6f2
		},
		{
		0x7fad,
		0xe6f4
		},
		{
		0x7faf,
		0xbd7e
		},
		{
		0x7fb0,
		0xe6f3
		},
		{
		0x7fb1,
		0xeae3
		},
		{
		0x7fb2,
		0xbfaa
		},
		{
		0x7fb3,
		0xf079
		},
		{
		0x7fb5,
		0xf078
		},
		{
		0x7fb6,
		0xc3bb
		},
		{
		0x7fb7,
		0xf2bd
		},
		{
		0x7fb8,
		0xc3bd
		},
		{
		0x7fb9,
		0xc3bc
		},
		{
		0x7fba,
		0xf4b0
		},
		{
		0x7fbb,
		0xf5ee
		},
		{
		0x7fbc,
		0xc4f3
		},
		{
		0x7fbd,
		0xa6d0
		},
		{
		0x7fbe,
		0xd050
		},
		{
		0x7fbf,
		0xacfd
		},
		{
		0x7fc0,
		0xd365
		},
		{
		0x7fc1,
		0xafce
		},
		{
		0x7fc2,
		0xd364
		},
		{
		0x7fc3,
		0xd363
		},
		{
		0x7fc5,
		0xafcd
		},
		{
		0x7fc7,
		0xd6fb
		},
		{
		0x7fc9,
		0xd6fd
		},
		{
		0x7fca,
		0xd6f6
		},
		{
		0x7fcb,
		0xd6f7
		},
		{
		0x7fcc,
		0xb2dd
		},
		{
		0x7fcd,
		0xd6f8
		},
		{
		0x7fce,
		0xb2de
		},
		{
		0x7fcf,
		0xd6fc
		},
		{
		0x7fd0,
		0xd6f9
		},
		{
		0x7fd1,
		0xd6fa
		},
		{
		0x7fd2,
		0xb2df
		},
		{
		0x7fd4,
		0xb5be
		},
		{
		0x7fd5,
		0xb5bf
		},
		{
		0x7fd7,
		0xdb44
		},
		{
		0x7fdb,
		0xdf6f
		},
		{
		0x7fdc,
		0xdf70
		},
		{
		0x7fde,
		0xe37e
		},
		{
		0x7fdf,
		0xbb43
		},
		{
		0x7fe0,
		0xbb41
		},
		{
		0x7fe1,
		0xbb42
		},
		{
		0x7fe2,
		0xe37b
		},
		{
		0x7fe3,
		0xe37c
		},
		{
		0x7fe5,
		0xe37d
		},
		{
		0x7fe6,
		0xe6f9
		},
		{
		0x7fe8,
		0xe6fa
		},
		{
		0x7fe9,
		0xbda1
		},
		{
		0x7fea,
		0xe6f7
		},
		{
		0x7feb,
		0xe6f6
		},
		{
		0x7fec,
		0xe6f8
		},
		{
		0x7fed,
		0xe6f5
		},
		{
		0x7fee,
		0xbfad
		},
		{
		0x7fef,
		0xeae4
		},
		{
		0x7ff0,
		0xbfab
		},
		{
		0x7ff1,
		0xbfac
		},
		{
		0x7ff2,
		0xede6
		},
		{
		0x7ff3,
		0xc16b
		},
		{
		0x7ff4,
		0xede5
		},
		{
		0x7ff5,
		0xefa8
		},
		{
		0x7ff7,
		0xf07a
		},
		{
		0x7ff8,
		0xf07b
		},
		{
		0x7ff9,
		0xc2bc
		},
		{
		0x7ffb,
		0xc2bd
		},
		{
		0x7ffc,
		0xc16c
		},
		{
		0x7ffd,
		0xf2be
		},
		{
		0x7ffe,
		0xf2bf
		},
		{
		0x7fff,
		0xf4b1
		},
		{
		0x8000,
		0xc4a3
		},
		{
		0x8001,
		0xa6d1
		},
		{
		0x8003,
		0xa6d2
		},
		{
		0x8004,
		0xacfe
		},
		{
		0x8005,
		0xaacc
		},
		{
		0x8006,
		0xafcf
		},
		{
		0x8007,
		0xd051
		},
		{
		0x800b,
		0xb5c0
		},
		{
		0x800c,
		0xa6d3
		},
		{
		0x800d,
		0xad41
		},
		{
		0x800e,
		0xd052
		},
		{
		0x800f,
		0xd053
		},
		{
		0x8010,
		0xad40
		},
		{
		0x8011,
		0xad42
		},
		{
		0x8012,
		0xa6d4
		},
		{
		0x8014,
		0xd054
		},
		{
		0x8015,
		0xafd1
		},
		{
		0x8016,
		0xd366
		},
		{
		0x8017,
		0xafd3
		},
		{
		0x8018,
		0xafd0
		},
		{
		0x8019,
		0xafd2
		},
		{
		0x801b,
		0xd741
		},
		{
		0x801c,
		0xb2e0
		},
		{
		0x801e,
		0xd740
		},
		{
		0x801f,
		0xd6fe
		},
		{
		0x8021,
		0xdf71
		},
		{
		0x8024,
		0xe3a1
		},
		{
		0x8026,
		0xbda2
		},
		{
		0x8028,
		0xbfae
		},
		{
		0x8029,
		0xeae6
		},
		{
		0x802a,
		0xeae5
		},
		{
		0x802c,
		0xede7
		},
		{
		0x8030,
		0xf5ef
		},
		{
		0x8033,
		0xa6d5
		},
		{
		0x8034,
		0xcb73
		},
		{
		0x8035,
		0xcdaa
		},
		{
		0x8036,
		0xad43
		},
		{
		0x8037,
		0xd055
		},
		{
		0x8039,
		0xd368
		},
		{
		0x803d,
		0xafd4
		},
		{
		0x803e,
		0xd367
		},
		{
		0x803f,
		0xafd5
		},
		{
		0x8043,
		0xd743
		},
		{
		0x8046,
		0xb2e2
		},
		{
		0x8047,
		0xd742
		},
		{
		0x8048,
		0xd744
		},
		{
		0x804a,
		0xb2e1
		},
		{
		0x804f,
		0xdb46
		},
		{
		0x8050,
		0xdb47
		},
		{
		0x8051,
		0xdb45
		},
		{
		0x8052,
		0xb5c1
		},
		{
		0x8056,
		0xb874
		},
		{
		0x8058,
		0xb875
		},
		{
		0x805a,
		0xbb45
		},
		{
		0x805c,
		0xe3a3
		},
		{
		0x805d,
		0xe3a2
		},
		{
		0x805e,
		0xbb44
		},
		{
		0x8064,
		0xe6fb
		},
		{
		0x8067,
		0xe6fc
		},
		{
		0x806c,
		0xeae7
		},
		{
		0x806f,
		0xc170
		},
		{
		0x8070,
		0xc16f
		},
		{
		0x8071,
		0xc16d
		},
		{
		0x8072,
		0xc16e
		},
		{
		0x8073,
		0xc171
		},
		{
		0x8075,
		0xf07c
		},
		{
		0x8076,
		0xc2bf
		},
		{
		0x8077,
		0xc2be
		},
		{
		0x8078,
		0xf2c0
		},
		{
		0x8079,
		0xf4b2
		},
		{
		0x807d,
		0xc5a5
		},
		{
		0x807e,
		0xc5a4
		},
		{
		0x807f,
		0xa6d6
		},
		{
		0x8082,
		0xd1fb
		},
		{
		0x8084,
		0xb877
		},
		{
		0x8085,
		0xb5c2
		},
		{
		0x8086,
		0xb876
		},
		{
		0x8087,
		0xbb46
		},
		{
		0x8089,
		0xa6d7
		},
		{
		0x808a,
		0xc9a9
		},
		{
		0x808b,
		0xa6d8
		},
		{
		0x808c,
		0xa6d9
		},
		{
		0x808f,
		0xcdab
		},
		{
		0x8090,
		0xcb76
		},
		{
		0x8092,
		0xcb77
		},
		{
		0x8093,
		0xa877
		},
		{
		0x8095,
		0xcb74
		},
		{
		0x8096,
		0xa876
		},
		{
		0x8098,
		0xa879
		},
		{
		0x8099,
		0xcb75
		},
		{
		0x809a,
		0xa87b
		},
		{
		0x809b,
		0xa87a
		},
		{
		0x809c,
		0xcb78
		},
		{
		0x809d,
		0xa878
		},
		{
		0x80a1,
		0xaad1
		},
		{
		0x80a2,
		0xaacf
		},
		{
		0x80a3,
		0xcdad
		},
		{
		0x80a5,
		0xaace
		},
		{
		0x80a9,
		0xaad3
		},
		{
		0x80aa,
		0xaad5
		},
		{
		0x80ab,
		0xaad2
		},
		{
		0x80ad,
		0xcdb0
		},
		{
		0x80ae,
		0xcdac
		},
		{
		0x80af,
		0xaad6
		},
		{
		0x80b1,
		0xaad0
		},
		{
		0x80b2,
		0xa87c
		},
		{
		0x80b4,
		0xaad4
		},
		{
		0x80b5,
		0xcdaf
		},
		{
		0x80b8,
		0xcdae
		},
		{
		0x80ba,
		0xaacd
		},
		{
		0x80c2,
		0xd05b
		},
		{
		0x80c3,
		0xad47
		},
		{
		0x80c4,
		0xad48
		},
		{
		0x80c5,
		0xd05d
		},
		{
		0x80c7,
		0xd057
		},
		{
		0x80c8,
		0xd05a
		},
		{
		0x80c9,
		0xd063
		},
		{
		0x80ca,
		0xd061
		},
		{
		0x80cc,
		0xad49
		},
		{
		0x80cd,
		0xd067
		},
		{
		0x80ce,
		0xad4c
		},
		{
		0x80cf,
		0xd064
		},
		{
		0x80d0,
		0xd05c
		},
		{
		0x80d1,
		0xd059
		},
		{
		0x80d4,
		0xdb49
		},
		{
		0x80d5,
		0xd062
		},
		{
		0x80d6,
		0xad44
		},
		{
		0x80d7,
		0xd065
		},
		{
		0x80d8,
		0xd056
		},
		{
		0x80d9,
		0xd05f
		},
		{
		0x80da,
		0xad46
		},
		{
		0x80db,
		0xad4b
		},
		{
		0x80dc,
		0xd060
		},
		{
		0x80dd,
		0xad4f
		},
		{
		0x80de,
		0xad4d
		},
		{
		0x80e0,
		0xd058
		},
		{
		0x80e1,
		0xad4a
		},
		{
		0x80e3,
		0xd05e
		},
		{
		0x80e4,
		0xad4e
		},
		{
		0x80e5,
		0xad45
		},
		{
		0x80e6,
		0xd066
		},
		{
		0x80ed,
		0xafda
		},
		{
		0x80ef,
		0xafe3
		},
		{
		0x80f0,
		0xafd8
		},
		{
		0x80f1,
		0xafd6
		},
		{
		0x80f2,
		0xd36a
		},
		{
		0x80f3,
		0xafde
		},
		{
		0x80f4,
		0xafdb
		},
		{
		0x80f5,
		0xd36c
		},
		{
		0x80f8,
		0xafdd
		},
		{
		0x80f9,
		0xd36b
		},
		{
		0x80fa,
		0xd369
		},
		{
		0x80fb,
		0xd36e
		},
		{
		0x80fc,
		0xafe2
		},
		{
		0x80fd,
		0xafe0
		},
		{
		0x80fe,
		0xdb48
		},
		{
		0x8100,
		0xd36f
		},
		{
		0x8101,
		0xd36d
		},
		{
		0x8102,
		0xafd7
		},
		{
		0x8105,
		0xafd9
		},
		{
		0x8106,
		0xafdc
		},
		{
		0x8108,
		0xafdf
		},
		{
		0x810a,
		0xafe1
		},
		{
		0x8115,
		0xd74e
		},
		{
		0x8116,
		0xb2e4
		},
		{
		0x8118,
		0xd745
		},
		{
		0x8119,
		0xd747
		},
		{
		0x811b,
		0xd748
		},
		{
		0x811d,
		0xd750
		},
		{
		0x811e,
		0xd74c
		},
		{
		0x811f,
		0xd74a
		},
		{
		0x8121,
		0xd74d
		},
		{
		0x8122,
		0xd751
		},
		{
		0x8123,
		0xb2e5
		},
		{
		0x8124,
		0xb2e9
		},
		{
		0x8125,
		0xd746
		},
		{
		0x8127,
		0xd74f
		},
		{
		0x8129,
		0xb2e7
		},
		{
		0x812b,
		0xb2e6
		},
		{
		0x812c,
		0xd74b
		},
		{
		0x812d,
		0xd749
		},
		{
		0x812f,
		0xb2e3
		},
		{
		0x8130,
		0xb2e8
		},
		{
		0x8139,
		0xb5c8
		},
		{
		0x813a,
		0xdb51
		},
		{
		0x813d,
		0xdb4f
		},
		{
		0x813e,
		0xb5ca
		},
		{
		0x8143,
		0xdb4a
		},
		{
		0x8144,
		0xdfa1
		},
		{
		0x8146,
		0xb5c9
		},
		{
		0x8147,
		0xdb4e
		},
		{
		0x814a,
		0xdb4b
		},
		{
		0x814b,
		0xb5c5
		},
		{
		0x814c,
		0xb5cb
		},
		{
		0x814d,
		0xdb50
		},
		{
		0x814e,
		0xb5c7
		},
		{
		0x814f,
		0xdb4d
		},
		{
		0x8150,
		0xbb47
		},
		{
		0x8151,
		0xb5c6
		},
		{
		0x8152,
		0xdb4c
		},
		{
		0x8153,
		0xb5cc
		},
		{
		0x8154,
		0xb5c4
		},
		{
		0x8155,
		0xb5c3
		},
		{
		0x815b,
		0xdf77
		},
		{
		0x815c,
		0xdf75
		},
		{
		0x815e,
		0xdf7b
		},
		{
		0x8160,
		0xdf73
		},
		{
		0x8161,
		0xdfa2
		},
		{
		0x8162,
		0xdf78
		},
		{
		0x8164,
		0xdf72
		},
		{
		0x8165,
		0xb87b
		},
		{
		0x8166,
		0xb8a3
		},
		{
		0x8167,
		0xdf7d
		},
		{
		0x8169,
		0xdf76
		},
		{
		0x816b,
		0xb87e
		},
		{
		0x816e,
		0xb87c
		},
		{
		0x816f,
		0xdf7e
		},
		{
		0x8170,
		0xb879
		},
		{
		0x8171,
		0xb878
		},
		{
		0x8172,
		0xdf79
		},
		{
		0x8173,
		0xb87d
		},
		{
		0x8174,
		0xb5cd
		},
		{
		0x8176,
		0xdf7c
		},
		{
		0x8177,
		0xdf74
		},
		{
		0x8178,
		0xb87a
		},
		{
		0x8179,
		0xb8a1
		},
		{
		0x817a,
		0xb8a2
		},
		{
		0x817f,
		0xbb4c
		},
		{
		0x8180,
		0xbb48
		},
		{
		0x8182,
		0xbb4d
		},
		{
		0x8183,
		0xe3a6
		},
		{
		0x8186,
		0xe3a5
		},
		{
		0x8187,
		0xe3a7
		},
		{
		0x8188,
		0xbb4a
		},
		{
		0x8189,
		0xe3a4
		},
		{
		0x818a,
		0xbb4b
		},
		{
		0x818b,
		0xe3aa
		},
		{
		0x818c,
		0xe3a9
		},
		{
		0x818d,
		0xe3a8
		},
		{
		0x818f,
		0xbb49
		},
		{
		0x8195,
		0xe741
		},
		{
		0x8197,
		0xe744
		},
		{
		0x8198,
		0xbda8
		},
		{
		0x8199,
		0xe743
		},
		{
		0x819a,
		0xbda7
		},
		{
		0x819b,
		0xbda3
		},
		{
		0x819c,
		0xbda4
		},
		{
		0x819d,
		0xbda5
		},
		{
		0x819e,
		0xe740
		},
		{
		0x819f,
		0xe6fe
		},
		{
		0x81a0,
		0xbda6
		},
		{
		0x81a2,
		0xe742
		},
		{
		0x81a3,
		0xe6fd
		},
		{
		0x81a6,
		0xeae9
		},
		{
		0x81a7,
		0xeaf3
		},
		{
		0x81a8,
		0xbfb1
		},
		{
		0x81a9,
		0xbfb0
		},
		{
		0x81ab,
		0xeaed
		},
		{
		0x81ac,
		0xeaef
		},
		{
		0x81ae,
		0xeaea
		},
		{
		0x81b0,
		0xeaee
		},
		{
		0x81b1,
		0xeae8
		},
		{
		0x81b2,
		0xeaf1
		},
		{
		0x81b3,
		0xbfaf
		},
		{
		0x81b4,
		0xeaf0
		},
		{
		0x81b5,
		0xeaec
		},
		{
		0x81b7,
		0xeaf2
		},
		{
		0x81b9,
		0xeaeb
		},
		{
		0x81ba,
		0xc174
		},
		{
		0x81bb,
		0xede8
		},
		{
		0x81bc,
		0xedee
		},
		{
		0x81bd,
		0xc178
		},
		{
		0x81be,
		0xc17a
		},
		{
		0x81bf,
		0xc177
		},
		{
		0x81c0,
		0xc176
		},
		{
		0x81c2,
		0xc175
		},
		{
		0x81c3,
		0xc173
		},
		{
		0x81c4,
		0xede9
		},
		{
		0x81c5,
		0xedec
		},
		{
		0x81c6,
		0xc172
		},
		{
		0x81c7,
		0xeded
		},
		{
		0x81c9,
		0xc179
		},
		{
		0x81ca,
		0xedeb
		},
		{
		0x81cc,
		0xedea
		},
		{
		0x81cd,
		0xc2c0
		},
		{
		0x81cf,
		0xc2c1
		},
		{
		0x81d0,
		0xf0a1
		},
		{
		0x81d1,
		0xf07d
		},
		{
		0x81d2,
		0xf07e
		},
		{
		0x81d5,
		0xf2c2
		},
		{
		0x81d7,
		0xf2c1
		},
		{
		0x81d8,
		0xc3be
		},
		{
		0x81d9,
		0xf4b4
		},
		{
		0x81da,
		0xc4a4
		},
		{
		0x81db,
		0xf4b3
		},
		{
		0x81dd,
		0xf5f0
		},
		{
		0x81de,
		0xf745
		},
		{
		0x81df,
		0xc5a6
		},
		{
		0x81e0,
		0xf943
		},
		{
		0x81e1,
		0xf944
		},
		{
		0x81e2,
		0xc5d8
		},
		{
		0x81e3,
		0xa6da
		},
		{
		0x81e5,
		0xaad7
		},
		{
		0x81e6,
		0xdb52
		},
		{
		0x81e7,
		0xbb4e
		},
		{
		0x81e8,
		0xc17b
		},
		{
		0x81e9,
		0xedef
		},
		{
		0x81ea,
		0xa6db
		},
		{
		0x81ec,
		0xafe5
		},
		{
		0x81ed,
		0xafe4
		},
		{
		0x81ee,
		0xdb53
		},
		{
		0x81f2,
		0xeaf4
		},
		{
		0x81f3,
		0xa6dc
		},
		{
		0x81f4,
		0xad50
		},
		{
		0x81f7,
		0xdb54
		},
		{
		0x81f8,
		0xdb55
		},
		{
		0x81f9,
		0xdb56
		},
		{
		0x81fa,
		0xbb4f
		},
		{
		0x81fb,
		0xbfb2
		},
		{
		0x81fc,
		0xa6dd
		},
		{
		0x81fe,
		0xaad8
		},
		{
		0x81ff,
		0xd068
		},
		{
		0x8200,
		0xafe6
		},
		{
		0x8201,
		0xd370
		},
		{
		0x8202,
		0xb2ea
		},
		{
		0x8204,
		0xdb57
		},
		{
		0x8205,
		0xb8a4
		},
		{
		0x8207,
		0xbb50
		},
		{
		0x8208,
		0xbfb3
		},
		{
		0x8209,
		0xc17c
		},
		{
		0x820a,
		0xc2c2
		},
		{
		0x820b,
		0xf4b5
		},
		{
		0x820c,
		0xa6de
		},
		{
		0x820d,
		0xaad9
		},
		{
		0x8210,
		0xafe7
		},
		{
		0x8211,
		0xd752
		},
		{
		0x8212,
		0xb5ce
		},
		{
		0x8214,
		0xbb51
		},
		{
		0x8215,
		0xe3ab
		},
		{
		0x8216,
		0xe745
		},
		{
		0x821b,
		0xa6df
		},
		{
		0x821c,
		0xb5cf
		},
		{
		0x821d,
		0xdfa3
		},
		{
		0x821e,
		0xbb52
		},
		{
		0x821f,
		0xa6e0
		},
		{
		0x8220,
		0xcdb1
		},
		{
		0x8221,
		0xd069
		},
		{
		0x8222,
		0xad51
		},
		{
		0x8225,
		0xd372
		},
		{
		0x8228,
		0xafea
		},
		{
		0x822a,
		0xafe8
		},
		{
		0x822b,
		0xafe9
		},
		{
		0x822c,
		0xafeb
		},
		{
		0x822f,
		0xd371
		},
		{
		0x8232,
		0xd757
		},
		{
		0x8233,
		0xd754
		},
		{
		0x8234,
		0xd756
		},
		{
		0x8235,
		0xb2eb
		},
		{
		0x8236,
		0xb2ed
		},
		{
		0x8237,
		0xb2ec
		},
		{
		0x8238,
		0xd753
		},
		{
		0x8239,
		0xb2ee
		},
		{
		0x823a,
		0xd755
		},
		{
		0x823c,
		0xdb58
		},
		{
		0x823d,
		0xdb59
		},
		{
		0x823f,
		0xdb5a
		},
		{
		0x8240,
		0xdfa6
		},
		{
		0x8242,
		0xdfa7
		},
		{
		0x8244,
		0xdfa5
		},
		{
		0x8245,
		0xdfa8
		},
		{
		0x8247,
		0xb8a5
		},
		{
		0x8249,
		0xdfa4
		},
		{
		0x824b,
		0xbb53
		},
		{
		0x824e,
		0xe74a
		},
		{
		0x824f,
		0xe746
		},
		{
		0x8250,
		0xe749
		},
		{
		0x8251,
		0xe74b
		},
		{
		0x8252,
		0xe748
		},
		{
		0x8253,
		0xe747
		},
		{
		0x8255,
		0xeaf5
		},
		{
		0x8256,
		0xeaf6
		},
		{
		0x8257,
		0xeaf7
		},
		{
		0x8258,
		0xbfb4
		},
		{
		0x8259,
		0xbfb5
		},
		{
		0x825a,
		0xedf1
		},
		{
		0x825b,
		0xedf0
		},
		{
		0x825c,
		0xedf2
		},
		{
		0x825e,
		0xf0a3
		},
		{
		0x825f,
		0xf0a2
		},
		{
		0x8261,
		0xf2c4
		},
		{
		0x8263,
		0xf2c5
		},
		{
		0x8264,
		0xf2c3
		},
		{
		0x8266,
		0xc4a5
		},
		{
		0x8268,
		0xf4b6
		},
		{
		0x8269,
		0xf4b7
		},
		{
		0x826b,
		0xf746
		},
		{
		0x826c,
		0xf7ef
		},
		{
		0x826d,
		0xf8bb
		},
		{
		0x826e,
		0xa6e1
		},
		{
		0x826f,
		0xa87d
		},
		{
		0x8271,
		0xc17d
		},
		{
		0x8272,
		0xa6e2
		},
		{
		0x8274,
		0xd758
		},
		{
		0x8275,
		0xdb5b
		},
		{
		0x8277,
		0xc641
		},
		{
		0x8278,
		0xca4a
		},
		{
		0x827c,
		0xca4b
		},
		{
		0x827d,
		0xca4d
		},
		{
		0x827e,
		0xa6e3
		},
		{
		0x827f,
		0xca4e
		},
		{
		0x8280,
		0xca4c
		},
		{
		0x8283,
		0xcba2
		},
		{
		0x8284,
		0xcba3
		},
		{
		0x8285,
		0xcb7b
		},
		{
		0x828a,
		0xcba1
		},
		{
		0x828b,
		0xa8a1
		},
		{
		0x828d,
		0xa8a2
		},
		{
		0x828e,
		0xcb7c
		},
		{
		0x828f,
		0xcb7a
		},
		{
		0x8290,
		0xcb79
		},
		{
		0x8291,
		0xcb7d
		},
		{
		0x8292,
		0xa87e
		},
		{
		0x8293,
		0xcb7e
		},
		{
		0x8294,
		0xd06a
		},
		{
		0x8298,
		0xcdb6
		},
		{
		0x8299,
		0xaadc
		},
		{
		0x829a,
		0xcdb5
		},
		{
		0x829b,
		0xcdb7
		},
		{
		0x829d,
		0xaadb
		},
		{
		0x829e,
		0xcdbc
		},
		{
		0x829f,
		0xaadf
		},
		{
		0x82a0,
		0xcdb2
		},
		{
		0x82a1,
		0xcdc0
		},
		{
		0x82a2,
		0xcdc6
		},
		{
		0x82a3,
		0xaae6
		},
		{
		0x82a4,
		0xcdc3
		},
		{
		0x82a5,
		0xaae3
		},
		{
		0x82a7,
		0xcdb9
		},
		{
		0x82a8,
		0xcdbf
		},
		{
		0x82a9,
		0xcdc1
		},
		{
		0x82ab,
		0xcdb4
		},
		{
		0x82ac,
		0xaae2
		},
		{
		0x82ad,
		0xaadd
		},
		{
		0x82ae,
		0xcdba
		},
		{
		0x82af,
		0xaae4
		},
		{
		0x82b0,
		0xaae7
		},
		{
		0x82b1,
		0xaae1
		},
		{
		0x82b3,
		0xaada
		},
		{
		0x82b4,
		0xcdbe
		},
		{
		0x82b5,
		0xcdb8
		},
		{
		0x82b6,
		0xcdc5
		},
		{
		0x82b7,
		0xaae9
		},
		{
		0x82b8,
		0xaae5
		},
		{
		0x82b9,
		0xaae0
		},
		{
		0x82ba,
		0xcdbd
		},
		{
		0x82bb,
		0xafec
		},
		{
		0x82bc,
		0xcdbb
		},
		{
		0x82bd,
		0xaade
		},
		{
		0x82be,
		0xaae8
		},
		{
		0x82c0,
		0xcdb3
		},
		{
		0x82c2,
		0xcdc2
		},
		{
		0x82c3,
		0xcdc4
		},
		{
		0x82d1,
		0xad62
		},
		{
		0x82d2,
		0xad5c
		},
		{
		0x82d3,
		0xad64
		},
		{
		0x82d4,
		0xad61
		},
		{
		0x82d5,
		0xd071
		},
		{
		0x82d6,
		0xd074
		},
		{
		0x82d7,
		0xad5d
		},
		{
		0x82d9,
		0xd06b
		},
		{
		0x82db,
		0xad56
		},
		{
		0x82dc,
		0xad60
		},
		{
		0x82de,
		0xad63
		},
		{
		0x82df,
		0xad65
		},
		{
		0x82e0,
		0xd0a2
		},
		{
		0x82e1,
		0xd077
		},
		{
		0x82e3,
		0xad55
		},
		{
		0x82e4,
		0xd0a1
		},
		{
		0x82e5,
		0xad59
		},
		{
		0x82e6,
		0xad57
		},
		{
		0x82e7,
		0xad52
		},
		{
		0x82e8,
		0xd06f
		},
		{
		0x82ea,
		0xd07e
		},
		{
		0x82eb,
		0xd073
		},
		{
		0x82ec,
		0xd076
		},
		{
		0x82ed,
		0xd0a5
		},
		{
		0x82ef,
		0xad66
		},
		{
		0x82f0,
		0xd07d
		},
		{
		0x82f1,
		0xad5e
		},
		{
		0x82f2,
		0xd078
		},
		{
		0x82f3,
		0xd0a4
		},
		{
		0x82f4,
		0xd075
		},
		{
		0x82f5,
		0xd079
		},
		{
		0x82f6,
		0xd07c
		},
		{
		0x82f9,
		0xd06d
		},
		{
		0x82fa,
		0xd0a3
		},
		{
		0x82fb,
		0xd07b
		},
		{
		0x82fe,
		0xd06c
		},
		{
		0x8300,
		0xd070
		},
		{
		0x8301,
		0xad5f
		},
		{
		0x8302,
		0xad5a
		},
		{
		0x8303,
		0xad53
		},
		{
		0x8304,
		0xad58
		},
		{
		0x8305,
		0xad54
		},
		{
		0x8306,
		0xad67
		},
		{
		0x8307,
		0xd06e
		},
		{
		0x8308,
		0xd3a5
		},
		{
		0x8309,
		0xad5b
		},
		{
		0x830c,
		0xd07a
		},
		{
		0x830d,
		0xce41
		},
		{
		0x8316,
		0xd3a8
		},
		{
		0x8317,
		0xaffa
		},
		{
		0x8319,
		0xd376
		},
		{
		0x831b,
		0xd3a3
		},
		{
		0x831c,
		0xd37d
		},
		{
		0x831e,
		0xd3b2
		},
		{
		0x8320,
		0xd3aa
		},
		{
		0x8322,
		0xd37e
		},
		{
		0x8324,
		0xd3a9
		},
		{
		0x8325,
		0xd378
		},
		{
		0x8326,
		0xd37c
		},
		{
		0x8327,
		0xd3b5
		},
		{
		0x8328,
		0xaffd
		},
		{
		0x8329,
		0xd3ad
		},
		{
		0x832a,
		0xd3a4
		},
		{
		0x832b,
		0xafed
		},
		{
		0x832c,
		0xd3b3
		},
		{
		0x832d,
		0xd374
		},
		{
		0x832f,
		0xd3ac
		},
		{
		0x8331,
		0xaffc
		},
		{
		0x8332,
		0xaff7
		},
		{
		0x8333,
		0xd373
		},
		{
		0x8334,
		0xaff5
		},
		{
		0x8335,
		0xaff4
		},
		{
		0x8336,
		0xaff9
		},
		{
		0x8337,
		0xd3ab
		},
		{
		0x8338,
		0xaff1
		},
		{
		0x8339,
		0xaff8
		},
		{
		0x833a,
		0xd072
		},
		{
		0x833b,
		0xdb5c
		},
		{
		0x833c,
		0xd3a6
		},
		{
		0x833f,
		0xd37a
		},
		{
		0x8340,
		0xaffb
		},
		{
		0x8341,
		0xd37b
		},
		{
		0x8342,
		0xd3a1
		},
		{
		0x8343,
		0xaffe
		},
		{
		0x8344,
		0xd375
		},
		{
		0x8345,
		0xd3af
		},
		{
		0x8347,
		0xd3ae
		},
		{
		0x8348,
		0xd3b6
		},
		{
		0x8349,
		0xaff3
		},
		{
		0x834a,
		0xaff0
		},
		{
		0x834b,
		0xd3b4
		},
		{
		0x834c,
		0xd3b0
		},
		{
		0x834d,
		0xd3a7
		},
		{
		0x834e,
		0xd3a2
		},
		{
		0x834f,
		0xaff6
		},
		{
		0x8350,
		0xaff2
		},
		{
		0x8351,
		0xd377
		},
		{
		0x8352,
		0xafee
		},
		{
		0x8353,
		0xd3b1
		},
		{
		0x8354,
		0xafef
		},
		{
		0x8356,
		0xd379
		},
		{
		0x8373,
		0xd75e
		},
		{
		0x8374,
		0xd760
		},
		{
		0x8375,
		0xd765
		},
		{
		0x8376,
		0xd779
		},
		{
		0x8377,
		0xb2fc
		},
		{
		0x8378,
		0xb2f2
		},
		{
		0x837a,
		0xd75d
		},
		{
		0x837b,
		0xb2fd
		},
		{
		0x837c,
		0xb2fe
		},
		{
		0x837d,
		0xd768
		},
		{
		0x837e,
		0xd76f
		},
		{
		0x837f,
		0xd775
		},
		{
		0x8381,
		0xd762
		},
		{
		0x8383,
		0xd769
		},
		{
		0x8386,
		0xb340
		},
		{
		0x8387,
		0xd777
		},
		{
		0x8388,
		0xd772
		},
		{
		0x8389,
		0xb2fa
		},
		{
		0x838a,
		0xb2f8
		},
		{
		0x838b,
		0xd76e
		},
		{
		0x838c,
		0xd76a
		},
		{
		0x838d,
		0xd75c
		},
		{
		0x838e,
		0xb2ef
		},
		{
		0x838f,
		0xd761
		},
		{
		0x8390,
		0xd759
		},
		{
		0x8392,
		0xb2f7
		},
		{
		0x8393,
		0xb2f9
		},
		{
		0x8394,
		0xd766
		},
		{
		0x8395,
		0xd763
		},
		{
		0x8396,
		0xb2f4
		},
		{
		0x8397,
		0xd773
		},
		{
		0x8398,
		0xb2f1
		},
		{
		0x8399,
		0xd764
		},
		{
		0x839a,
		0xd77a
		},
		{
		0x839b,
		0xd76c
		},
		{
		0x839d,
		0xd76b
		},
		{
		0x839e,
		0xb2f0
		},
		{
		0x83a0,
		0xb2fb
		},
		{
		0x83a2,
		0xb2f3
		},
		{
		0x83a3,
		0xd75a
		},
		{
		0x83a4,
		0xd75f
		},
		{
		0x83a5,
		0xd770
		},
		{
		0x83a6,
		0xd776
		},
		{
		0x83a7,
		0xb341
		},
		{
		0x83a8,
		0xd75b
		},
		{
		0x83a9,
		0xd767
		},
		{
		0x83aa,
		0xd76d
		},
		{
		0x83ab,
		0xb2f6
		},
		{
		0x83ae,
		0xd778
		},
		{
		0x83af,
		0xd771
		},
		{
		0x83b0,
		0xd774
		},
		{
		0x83bd,
		0xb2f5
		},
		{
		0x83bf,
		0xdb6c
		},
		{
		0x83c0,
		0xdb60
		},
		{
		0x83c1,
		0xb5d7
		},
		{
		0x83c2,
		0xdb7d
		},
		{
		0x83c3,
		0xdba7
		},
		{
		0x83c4,
		0xdbaa
		},
		{
		0x83c5,
		0xb5d5
		},
		{
		0x83c6,
		0xdb68
		},
		{
		0x83c7,
		0xdba3
		},
		{
		0x83c8,
		0xdb69
		},
		{
		0x83c9,
		0xdb77
		},
		{
		0x83ca,
		0xb5e2
		},
		{
		0x83cb,
		0xdb73
		},
		{
		0x83cc,
		0xb5df
		},
		{
		0x83ce,
		0xdb74
		},
		{
		0x83cf,
		0xdb5d
		},
		{
		0x83d1,
		0xdba4
		},
		{
		0x83d4,
		0xb5e8
		},
		{
		0x83d5,
		0xdba1
		},
		{
		0x83d6,
		0xdb75
		},
		{
		0x83d7,
		0xdbac
		},
		{
		0x83d8,
		0xdb70
		},
		{
		0x83d9,
		0xdfc8
		},
		{
		0x83db,
		0xdbaf
		},
		{
		0x83dc,
		0xb5e6
		},
		{
		0x83dd,
		0xdb6e
		},
		{
		0x83de,
		0xdb7a
		},
		{
		0x83df,
		0xb5e9
		},
		{
		0x83e0,
		0xb5d4
		},
		{
		0x83e1,
		0xdb72
		},
		{
		0x83e2,
		0xdbad
		},
		{
		0x83e3,
		0xdb6b
		},
		{
		0x83e4,
		0xdb64
		},
		{
		0x83e5,
		0xdb6f
		},
		{
		0x83e7,
		0xdb63
		},
		{
		0x83e8,
		0xdb61
		},
		{
		0x83e9,
		0xb5d0
		},
		{
		0x83ea,
		0xdba5
		},
		{
		0x83eb,
		0xdb6a
		},
		{
		0x83ec,
		0xdba8
		},
		{
		0x83ee,
		0xdba9
		},
		{
		0x83ef,
		0xb5d8
		},
		{
		0x83f0,
		0xb5dd
		},
		{
		0x83f1,
		0xb5d9
		},
		{
		0x83f2,
		0xb5e1
		},
		{
		0x83f3,
		0xdb7e
		},
		{
		0x83f4,
		0xb5da
		},
		{
		0x83f5,
		0xdb76
		},
		{
		0x83f6,
		0xdb66
		},
		{
		0x83f8,
		0xb5d2
		},
		{
		0x83f9,
		0xdb5e
		},
		{
		0x83fa,
		0xdba2
		},
		{
		0x83fb,
		0xdbab
		},
		{
		0x83fc,
		0xdb65
		},
		{
		0x83fd,
		0xb5e0
		},
		{
		0x83fe,
		0xdbb0
		},
		{
		0x83ff,
		0xdb71
		},
		{
		0x8401,
		0xdb6d
		},
		{
		0x8403,
		0xb5d1
		},
		{
		0x8404,
		0xb5e5
		},
		{
		0x8406,
		0xdb7c
		},
		{
		0x8407,
		0xb5e7
		},
		{
		0x8409,
		0xdb78
		},
		{
		0x840a,
		0xb5dc
		},
		{
		0x840b,
		0xb5d6
		},
		{
		0x840c,
		0xb5de
		},
		{
		0x840d,
		0xb5d3
		},
		{
		0x840e,
		0xb5e4
		},
		{
		0x840f,
		0xdb79
		},
		{
		0x8410,
		0xdb67
		},
		{
		0x8411,
		0xdb7b
		},
		{
		0x8412,
		0xdb62
		},
		{
		0x8413,
		0xdba6
		},
		{
		0x841b,
		0xdbae
		},
		{
		0x8423,
		0xdb5f
		},
		{
		0x8429,
		0xdfc7
		},
		{
		0x842b,
		0xdfdd
		},
		{
		0x842c,
		0xb855
		},
		{
		0x842d,
		0xdfcc
		},
		{
		0x842f,
		0xdfca
		},
		{
		0x8430,
		0xdfb5
		},
		{
		0x8431,
		0xb8a9
		},
		{
		0x8432,
		0xdfc5
		},
		{
		0x8433,
		0xdfd9
		},
		{
		0x8434,
		0xdfc1
		},
		{
		0x8435,
		0xb8b1
		},
		{
		0x8436,
		0xdfd8
		},
		{
		0x8437,
		0xdfbf
		},
		{
		0x8438,
		0xb5e3
		},
		{
		0x8439,
		0xdfcf
		},
		{
		0x843a,
		0xdfc0
		},
		{
		0x843b,
		0xdfd6
		},
		{
		0x843c,
		0xb8b0
		},
		{
		0x843d,
		0xb8a8
		},
		{
		0x843f,
		0xdfaa
		},
		{
		0x8440,
		0xdfb2
		},
		{
		0x8442,
		0xdfcb
		},
		{
		0x8443,
		0xdfc3
		},
		{
		0x8444,
		0xdfdc
		},
		{
		0x8445,
		0xdfc6
		},
		{
		0x8446,
		0xb8b6
		},
		{
		0x8447,
		0xdfd7
		},
		{
		0x8449,
		0xb8ad
		},
		{
		0x844b,
		0xdfc9
		},
		{
		0x844c,
		0xdfd1
		},
		{
		0x844d,
		0xdfb6
		},
		{
		0x844e,
		0xdfd0
		},
		{
		0x8450,
		0xdfe1
		},
		{
		0x8451,
		0xdfb1
		},
		{
		0x8452,
		0xdfd2
		},
		{
		0x8454,
		0xdfdf
		},
		{
		0x8456,
		0xdfab
		},
		{
		0x8457,
		0xb5db
		},
		{
		0x8459,
		0xdfb9
		},
		{
		0x845a,
		0xdfb8
		},
		{
		0x845b,
		0xb8af
		},
		{
		0x845d,
		0xdfbc
		},
		{
		0x845e,
		0xdfbe
		},
		{
		0x845f,
		0xdfcd
		},
		{
		0x8460,
		0xdfde
		},
		{
		0x8461,
		0xb8b2
		},
		{
		0x8463,
		0xb8b3
		},
		{
		0x8465,
		0xdfb0
		},
		{
		0x8466,
		0xb8ab
		},
		{
		0x8467,
		0xdfb4
		},
		{
		0x8468,
		0xdfda
		},
		{
		0x8469,
		0xb8b4
		},
		{
		0x846b,
		0xb8ac
		},
		{
		0x846c,
		0xb8ae
		},
		{
		0x846d,
		0xb8b5
		},
		{
		0x846e,
		0xdfe0
		},
		{
		0x846f,
		0xdfd3
		},
		{
		0x8470,
		0xdfce
		},
		{
		0x8473,
		0xdfbb
		},
		{
		0x8474,
		0xdfba
		},
		{
		0x8475,
		0xb8aa
		},
		{
		0x8476,
		0xdfac
		},
		{
		0x8477,
		0xb8a7
		},
		{
		0x8478,
		0xdfc4
		},
		{
		0x8479,
		0xdfad
		},
		{
		0x847a,
		0xdfc2
		},
		{
		0x847d,
		0xdfb7
		},
		{
		0x847e,
		0xdfdb
		},
		{
		0x8482,
		0xb8a6
		},
		{
		0x8486,
		0xdfb3
		},
		{
		0x848d,
		0xdfaf
		},
		{
		0x848e,
		0xdfd5
		},
		{
		0x848f,
		0xdfae
		},
		{
		0x8490,
		0xbb60
		},
		{
		0x8491,
		0xe3d3
		},
		{
		0x8494,
		0xe3c2
		},
		{
		0x8497,
		0xe3ac
		},
		{
		0x8498,
		0xe3ca
		},
		{
		0x8499,
		0xbb58
		},
		{
		0x849a,
		0xe3bb
		},
		{
		0x849b,
		0xe3c5
		},
		{
		0x849c,
		0xbb5b
		},
		{
		0x849d,
		0xe3be
		},
		{
		0x849e,
		0xbb59
		},
		{
		0x849f,
		0xe3af
		},
		{
		0x84a0,
		0xe3cd
		},
		{
		0x84a1,
		0xe3ae
		},
		{
		0x84a2,
		0xe3c1
		},
		{
		0x84a4,
		0xe3ad
		},
		{
		0x84a7,
		0xe3bf
		},
		{
		0x84a8,
		0xe3c8
		},
		{
		0x84a9,
		0xe3c6
		},
		{
		0x84aa,
		0xe3ba
		},
		{
		0x84ab,
		0xe3b5
		},
		{
		0x84ac,
		0xe3b3
		},
		{
		0x84ae,
		0xe3b4
		},
		{
		0x84af,
		0xe3c7
		},
		{
		0x84b0,
		0xe3d2
		},
		{
		0x84b1,
		0xe3bc
		},
		{
		0x84b2,
		0xbb5a
		},
		{
		0x84b4,
		0xe3b7
		},
		{
		0x84b6,
		0xe3cb
		},
		{
		0x84b8,
		0xbb5d
		},
		{
		0x84b9,
		0xe3b6
		},
		{
		0x84ba,
		0xe3b0
		},
		{
		0x84bb,
		0xe3c0
		},
		{
		0x84bc,
		0xbb61
		},
		{
		0x84bf,
		0xbb55
		},
		{
		0x84c0,
		0xbb5e
		},
		{
		0x84c1,
		0xe3b8
		},
		{
		0x84c2,
		0xe3b2
		},
		{
		0x84c4,
		0xbb57
		},
		{
		0x84c5,
		0xdfd4
		},
		{
		0x84c6,
		0xbb56
		},
		{
		0x84c7,
		0xe3c3
		},
		{
		0x84c9,
		0xbb54
		},
		{
		0x84ca,
		0xbb63
		},
		{
		0x84cb,
		0xbb5c
		},
		{
		0x84cc,
		0xe3c4
		},
		{
		0x84cd,
		0xe3b9
		},
		{
		0x84ce,
		0xe3b1
		},
		{
		0x84cf,
		0xe3cc
		},
		{
		0x84d0,
		0xe3bd
		},
		{
		0x84d1,
		0xbb62
		},
		{
		0x84d2,
		0xe3d0
		},
		{
		0x84d3,
		0xbb5f
		},
		{
		0x84d4,
		0xe3cf
		},
		{
		0x84d6,
		0xe3c9
		},
		{
		0x84d7,
		0xe3ce
		},
		{
		0x84db,
		0xe3d1
		},
		{
		0x84e7,
		0xe773
		},
		{
		0x84e8,
		0xe774
		},
		{
		0x84e9,
		0xe767
		},
		{
		0x84ea,
		0xe766
		},
		{
		0x84eb,
		0xe762
		},
		{
		0x84ec,
		0xbdb4
		},
		{
		0x84ee,
		0xbdac
		},
		{
		0x84ef,
		0xe776
		},
		{
		0x84f0,
		0xe775
		},
		{
		0x84f1,
		0xdfa9
		},
		{
		0x84f2,
		0xe75f
		},
		{
		0x84f3,
		0xe763
		},
		{
		0x84f4,
		0xe75d
		},
		{
		0x84f6,
		0xe770
		},
		{
		0x84f7,
		0xe761
		},
		{
		0x84f9,
		0xe777
		},
		{
		0x84fa,
		0xe75a
		},
		{
		0x84fb,
		0xe758
		},
		{
		0x84fc,
		0xe764
		},
		{
		0x84fd,
		0xe76e
		},
		{
		0x84fe,
		0xe769
		},
		{
		0x84ff,
		0xbdb6
		},
		{
		0x8500,
		0xe74f
		},
		{
		0x8502,
		0xe76d
		},
		{
		0x8506,
		0xbdb7
		},
		{
		0x8507,
		0xdfbd
		},
		{
		0x8508,
		0xe75b
		},
		{
		0x8509,
		0xe752
		},
		{
		0x850a,
		0xe755
		},
		{
		0x850b,
		0xe77b
		},
		{
		0x850c,
		0xe75c
		},
		{
		0x850d,
		0xe753
		},
		{
		0x850e,
		0xe751
		},
		{
		0x850f,
		0xe74e
		},
		{
		0x8511,
		0xbdb0
		},
		{
		0x8512,
		0xe765
		},
		{
		0x8513,
		0xbdaf
		},
		{
		0x8514,
		0xbdb3
		},
		{
		0x8515,
		0xe760
		},
		{
		0x8516,
		0xe768
		},
		{
		0x8517,
		0xbda9
		},
		{
		0x8518,
		0xe778
		},
		{
		0x8519,
		0xe77c
		},
		{
		0x851a,
		0xbdab
		},
		{
		0x851c,
		0xe757
		},
		{
		0x851d,
		0xe76b
		},
		{
		0x851e,
		0xe76f
		},
		{
		0x851f,
		0xe754
		},
		{
		0x8520,
		0xe779
		},
		{
		0x8521,
		0xbdb2
		},
		{
		0x8523,
		0xbdb1
		},
		{
		0x8524,
		0xe74c
		},
		{
		0x8525,
		0xbdb5
		},
		{
		0x8526,
		0xe772
		},
		{
		0x8527,
		0xe756
		},
		{
		0x8528,
		0xe76a
		},
		{
		0x8529,
		0xe750
		},
		{
		0x852a,
		0xe75e
		},
		{
		0x852b,
		0xe759
		},
		{
		0x852c,
		0xbdad
		},
		{
		0x852d,
		0xbdae
		},
		{
		0x852e,
		0xe76c
		},
		{
		0x852f,
		0xe77d
		},
		{
		0x8530,
		0xe77a
		},
		{
		0x8531,
		0xe771
		},
		{
		0x853b,
		0xe74d
		},
		{
		0x853d,
		0xbdaa
		},
		{
		0x853e,
		0xeb49
		},
		{
		0x8540,
		0xeb40
		},
		{
		0x8541,
		0xeb43
		},
		{
		0x8543,
		0xbfbb
		},
		{
		0x8544,
		0xeb45
		},
		{
		0x8545,
		0xeaf9
		},
		{
		0x8546,
		0xeb41
		},
		{
		0x8547,
		0xeb47
		},
		{
		0x8548,
		0xbfb8
		},
		{
		0x8549,
		0xbfbc
		},
		{
		0x854a,
		0xbfb6
		},
		{
		0x854d,
		0xeafb
		},
		{
		0x854e,
		0xeb4c
		},
		{
		0x8551,
		0xeb46
		},
		{
		0x8553,
		0xeafc
		},
		{
		0x8554,
		0xeb55
		},
		{
		0x8555,
		0xeb4f
		},
		{
		0x8556,
		0xeaf8
		},
		{
		0x8557,
		0xee46
		},
		{
		0x8558,
		0xeafe
		},
		{
		0x8559,
		0xbfb7
		},
		{
		0x855b,
		0xeb4a
		},
		{
		0x855d,
		0xeb54
		},
		{
		0x855e,
		0xbfbf
		},
		{
		0x8560,
		0xeb51
		},
		{
		0x8561,
		0xeafd
		},
		{
		0x8562,
		0xeb44
		},
		{
		0x8563,
		0xeb48
		},
		{
		0x8564,
		0xeb42
		},
		{
		0x8565,
		0xeb56
		},
		{
		0x8566,
		0xeb53
		},
		{
		0x8567,
		0xeb50
		},
		{
		0x8568,
		0xbfb9
		},
		{
		0x8569,
		0xbfba
		},
		{
		0x856a,
		0xbfbe
		},
		{
		0x856b,
		0xeafa
		},
		{
		0x856c,
		0xeb57
		},
		{
		0x856d,
		0xbfbd
		},
		{
		0x856e,
		0xeb4d
		},
		{
		0x8571,
		0xeb4b
		},
		{
		0x8575,
		0xeb4e
		},
		{
		0x8576,
		0xee53
		},
		{
		0x8577,
		0xee40
		},
		{
		0x8578,
		0xee45
		},
		{
		0x8579,
		0xee52
		},
		{
		0x857a,
		0xee44
		},
		{
		0x857b,
		0xedfb
		},
		{
		0x857c,
		0xee41
		},
		{
		0x857e,
		0xc1a2
		},
		{
		0x8580,
		0xedf4
		},
		{
		0x8581,
		0xee4d
		},
		{
		0x8582,
		0xee4f
		},
		{
		0x8583,
		0xedf3
		},
		{
		0x8584,
		0xc1a1
		},
		{
		0x8585,
		0xee51
		},
		{
		0x8586,
		0xee49
		},
		{
		0x8587,
		0xc1a8
		},
		{
		0x8588,
		0xee50
		},
		{
		0x8589,
		0xee42
		},
		{
		0x858a,
		0xc1aa
		},
		{
		0x858b,
		0xedf9
		},
		{
		0x858c,
		0xeb52
		},
		{
		0x858d,
		0xee4a
		},
		{
		0x858e,
		0xee47
		},
		{
		0x858f,
		0xedf5
		},
		{
		0x8590,
		0xee55
		},
		{
		0x8591,
		0xc1a4
		},
		{
		0x8594,
		0xc1a5
		},
		{
		0x8595,
		0xedf7
		},
		{
		0x8596,
		0xee48
		},
		{
		0x8598,
		0xee54
		},
		{
		0x8599,
		0xee4b
		},
		{
		0x859a,
		0xedfd
		},
		{
		0x859b,
		0xc1a7
		},
		{
		0x859c,
		0xc1a3
		},
		{
		0x859d,
		0xee4c
		},
		{
		0x859e,
		0xedfe
		},
		{
		0x859f,
		0xee56
		},
		{
		0x85a0,
		0xedf8
		},
		{
		0x85a1,
		0xee43
		},
		{
		0x85a2,
		0xee4e
		},
		{
		0x85a3,
		0xedfa
		},
		{
		0x85a4,
		0xedfc
		},
		{
		0x85a6,
		0xc2cb
		},
		{
		0x85a7,
		0xedf6
		},
		{
		0x85a8,
		0xc1a9
		},
		{
		0x85a9,
		0xc2c4
		},
		{
		0x85aa,
		0xc17e
		},
		{
		0x85af,
		0xc1a6
		},
		{
		0x85b0,
		0xc2c8
		},
		{
		0x85b1,
		0xf0b3
		},
		{
		0x85b3,
		0xf0a9
		},
		{
		0x85b4,
		0xf0a4
		},
		{
		0x85b5,
		0xf0aa
		},
		{
		0x85b6,
		0xf0b4
		},
		{
		0x85b7,
		0xf0b8
		},
		{
		0x85b8,
		0xf0b7
		},
		{
		0x85b9,
		0xc2ca
		},
		{
		0x85ba,
		0xc2c9
		},
		{
		0x85bd,
		0xf0ab
		},
		{
		0x85be,
		0xf0b9
		},
		{
		0x85bf,
		0xf0ae
		},
		{
		0x85c0,
		0xf0a6
		},
		{
		0x85c2,
		0xf0a8
		},
		{
		0x85c3,
		0xf0a7
		},
		{
		0x85c4,
		0xf0ad
		},
		{
		0x85c5,
		0xf0b2
		},
		{
		0x85c6,
		0xf0a5
		},
		{
		0x85c7,
		0xf0ac
		},
		{
		0x85c8,
		0xf0b1
		},
		{
		0x85c9,
		0xc2c7
		},
		{
		0x85cb,
		0xf0af
		},
		{
		0x85cd,
		0xc2c5
		},
		{
		0x85ce,
		0xf0b0
		},
		{
		0x85cf,
		0xc2c3
		},
		{
		0x85d0,
		0xc2c6
		},
		{
		0x85d1,
		0xf2d5
		},
		{
		0x85d2,
		0xf0b5
		},
		{
		0x85d5,
		0xc3c2
		},
		{
		0x85d7,
		0xf2cd
		},
		{
		0x85d8,
		0xf2d1
		},
		{
		0x85d9,
		0xf2c9
		},
		{
		0x85da,
		0xf2cc
		},
		{
		0x85dc,
		0xf2d4
		},
		{
		0x85dd,
		0xc3c0
		},
		{
		0x85de,
		0xf2d9
		},
		{
		0x85df,
		0xf2d2
		},
		{
		0x85e1,
		0xf2ca
		},
		{
		0x85e2,
		0xf2da
		},
		{
		0x85e3,
		0xf2d3
		},
		{
		0x85e4,
		0xc3c3
		},
		{
		0x85e5,
		0xc3c4
		},
		{
		0x85e6,
		0xf2d7
		},
		{
		0x85e8,
		0xf2cb
		},
		{
		0x85e9,
		0xc3bf
		},
		{
		0x85ea,
		0xc3c1
		},
		{
		0x85eb,
		0xf2c6
		},
		{
		0x85ec,
		0xf2ce
		},
		{
		0x85ed,
		0xf2c8
		},
		{
		0x85ef,
		0xf2d8
		},
		{
		0x85f0,
		0xf2d6
		},
		{
		0x85f1,
		0xf2c7
		},
		{
		0x85f2,
		0xf2cf
		},
		{
		0x85f6,
		0xf4be
		},
		{
		0x85f7,
		0xc3c5
		},
		{
		0x85f8,
		0xf2d0
		},
		{
		0x85f9,
		0xc4a7
		},
		{
		0x85fa,
		0xc4a9
		},
		{
		0x85fb,
		0xc4a6
		},
		{
		0x85fd,
		0xf4c3
		},
		{
		0x85fe,
		0xf4bb
		},
		{
		0x85ff,
		0xf4b9
		},
		{
		0x8600,
		0xf4bd
		},
		{
		0x8601,
		0xf4ba
		},
		{
		0x8604,
		0xf4bf
		},
		{
		0x8605,
		0xf4c1
		},
		{
		0x8606,
		0xc4aa
		},
		{
		0x8607,
		0xc4ac
		},
		{
		0x8609,
		0xf4c0
		},
		{
		0x860a,
		0xc4ad
		},
		{
		0x860b,
		0xc4ab
		},
		{
		0x860c,
		0xf4c2
		},
		{
		0x8611,
		0xc4a8
		},
		{
		0x8617,
		0xc4f4
		},
		{
		0x8618,
		0xf5f1
		},
		{
		0x8619,
		0xf5f7
		},
		{
		0x861a,
		0xc4f6
		},
		{
		0x861b,
		0xf4bc
		},
		{
		0x861c,
		0xf5f6
		},
		{
		0x861e,
		0xf5fd
		},
		{
		0x861f,
		0xf5f4
		},
		{
		0x8620,
		0xf5fb
		},
		{
		0x8621,
		0xf5fa
		},
		{
		0x8622,
		0xf4b8
		},
		{
		0x8623,
		0xf5f5
		},
		{
		0x8624,
		0xf0b6
		},
		{
		0x8625,
		0xf5fe
		},
		{
		0x8626,
		0xf5f3
		},
		{
		0x8627,
		0xf5f8
		},
		{
		0x8629,
		0xf5fc
		},
		{
		0x862a,
		0xf5f2
		},
		{
		0x862c,
		0xf74a
		},
		{
		0x862d,
		0xc4f5
		},
		{
		0x862e,
		0xf5f9
		},
		{
		0x8631,
		0xf7f4
		},
		{
		0x8632,
		0xf74b
		},
		{
		0x8633,
		0xf749
		},
		{
		0x8634,
		0xf747
		},
		{
		0x8635,
		0xf748
		},
		{
		0x8636,
		0xf74c
		},
		{
		0x8638,
		0xc5d9
		},
		{
		0x8639,
		0xf7f2
		},
		{
		0x863a,
		0xf7f0
		},
		{
		0x863b,
		0xf7f5
		},
		{
		0x863c,
		0xf7f3
		},
		{
		0x863e,
		0xf7f6
		},
		{
		0x863f,
		0xc5da
		},
		{
		0x8640,
		0xf7f1
		},
		{
		0x8643,
		0xf8bc
		},
		{
		0x8646,
		0xf945
		},
		{
		0x8647,
		0xf946
		},
		{
		0x8648,
		0xf947
		},
		{
		0x864b,
		0xf9c7
		},
		{
		0x864c,
		0xf9bd
		},
		{
		0x864d,
		0xca4f
		},
		{
		0x864e,
		0xaaea
		},
		{
		0x8650,
		0xad68
		},
		{
		0x8652,
		0xd3b8
		},
		{
		0x8653,
		0xd3b7
		},
		{
		0x8654,
		0xb040
		},
		{
		0x8655,
		0xb342
		},
		{
		0x8656,
		0xd77c
		},
		{
		0x8659,
		0xd77b
		},
		{
		0x865b,
		0xb5ea
		},
		{
		0x865c,
		0xb8b8
		},
		{
		0x865e,
		0xb8b7
		},
		{
		0x865f,
		0xb8b9
		},
		{
		0x8661,
		0xe3d4
		},
		{
		0x8662,
		0xe77e
		},
		{
		0x8663,
		0xeb58
		},
		{
		0x8664,
		0xeb5a
		},
		{
		0x8665,
		0xeb59
		},
		{
		0x8667,
		0xc1ab
		},
		{
		0x8668,
		0xee57
		},
		{
		0x8669,
		0xf0ba
		},
		{
		0x866a,
		0xf9a5
		},
		{
		0x866b,
		0xa6e4
		},
		{
		0x866d,
		0xcdc9
		},
		{
		0x866e,
		0xcdca
		},
		{
		0x866f,
		0xcdc8
		},
		{
		0x8670,
		0xcdc7
		},
		{
		0x8671,
		0xaaeb
		},
		{
		0x8673,
		0xd0a9
		},
		{
		0x8674,
		0xd0a7
		},
		{
		0x8677,
		0xd0a6
		},
		{
		0x8679,
		0xad69
		},
		{
		0x867a,
		0xad6b
		},
		{
		0x867b,
		0xad6a
		},
		{
		0x867c,
		0xd0a8
		},
		{
		0x8685,
		0xd3c4
		},
		{
		0x8686,
		0xd3c1
		},
		{
		0x8687,
		0xd3bf
		},
		{
		0x868a,
		0xb041
		},
		{
		0x868b,
		0xd3c2
		},
		{
		0x868c,
		0xb046
		},
		{
		0x868d,
		0xd3bc
		},
		{
		0x868e,
		0xd3cb
		},
		{
		0x8690,
		0xd3cd
		},
		{
		0x8691,
		0xd3bd
		},
		{
		0x8693,
		0xb043
		},
		{
		0x8694,
		0xd3ce
		},
		{
		0x8695,
		0xd3c9
		},
		{
		0x8696,
		0xd3bb
		},
		{
		0x8697,
		0xd3c0
		},
		{
		0x8698,
		0xd3ca
		},
		{
		0x8699,
		0xd3c6
		},
		{
		0x869a,
		0xd3c3
		},
		{
		0x869c,
		0xb048
		},
		{
		0x869d,
		0xd3cc
		},
		{
		0x869e,
		0xd3be
		},
		{
		0x86a1,
		0xd3c7
		},
		{
		0x86a2,
		0xd3b9
		},
		{
		0x86a3,
		0xb047
		},
		{
		0x86a4,
		0xb044
		},
		{
		0x86a5,
		0xd3c5
		},
		{
		0x86a7,
		0xd3c8
		},
		{
		0x86a8,
		0xd3ba
		},
		{
		0x86a9,
		0xb045
		},
		{
		0x86aa,
		0xb042
		},
		{
		0x86af,
		0xb34c
		},
		{
		0x86b0,
		0xd7a5
		},
		{
		0x86b1,
		0xb34b
		},
		{
		0x86b3,
		0xd7a8
		},
		{
		0x86b4,
		0xd7ab
		},
		{
		0x86b5,
		0xb348
		},
		{
		0x86b6,
		0xb346
		},
		{
		0x86b7,
		0xd77e
		},
		{
		0x86b8,
		0xd7a9
		},
		{
		0x86b9,
		0xd7a7
		},
		{
		0x86ba,
		0xd7a4
		},
		{
		0x86bb,
		0xd7ac
		},
		{
		0x86bc,
		0xd7ad
		},
		{
		0x86bd,
		0xd7af
		},
		{
		0x86be,
		0xd7b0
		},
		{
		0x86bf,
		0xd77d
		},
		{
		0x86c0,
		0xb345
		},
		{
		0x86c1,
		0xd7a2
		},
		{
		0x86c2,
		0xd7a1
		},
		{
		0x86c3,
		0xd7ae
		},
		{
		0x86c4,
		0xb347
		},
		{
		0x86c5,
		0xd7a3
		},
		{
		0x86c6,
		0xb349
		},
		{
		0x86c7,
		0xb344
		},
		{
		0x86c8,
		0xd7a6
		},
		{
		0x86c9,
		0xb34d
		},
		{
		0x86cb,
		0xb34a
		},
		{
		0x86cc,
		0xd7aa
		},
		{
		0x86d0,
		0xb5f1
		},
		{
		0x86d1,
		0xdbbf
		},
		{
		0x86d3,
		0xdbb4
		},
		{
		0x86d4,
		0xb5ee
		},
		{
		0x86d6,
		0xdfe7
		},
		{
		0x86d7,
		0xdbbd
		},
		{
		0x86d8,
		0xdbb1
		},
		{
		0x86d9,
		0xb5ec
		},
		{
		0x86da,
		0xdbb6
		},
		{
		0x86db,
		0xb5ef
		},
		{
		0x86dc,
		0xdbba
		},
		{
		0x86dd,
		0xdbb8
		},
		{
		0x86de,
		0xb5f2
		},
		{
		0x86df,
		0xb5eb
		},
		{
		0x86e2,
		0xdbb2
		},
		{
		0x86e3,
		0xdbb5
		},
		{
		0x86e4,
		0xb5f0
		},
		{
		0x86e6,
		0xdbb3
		},
		{
		0x86e8,
		0xdbbe
		},
		{
		0x86e9,
		0xdbbc
		},
		{
		0x86ea,
		0xdbb7
		},
		{
		0x86eb,
		0xdbb9
		},
		{
		0x86ec,
		0xdbbb
		},
		{
		0x86ed,
		0xb5ed
		},
		{
		0x86f5,
		0xdfe8
		},
		{
		0x86f6,
		0xdfee
		},
		{
		0x86f7,
		0xdfe4
		},
		{
		0x86f8,
		0xdfea
		},
		{
		0x86f9,
		0xb8ba
		},
		{
		0x86fa,
		0xdfe6
		},
		{
		0x86fb,
		0xb8c0
		},
		{
		0x86fe,
		0xb8bf
		},
		{
		0x8700,
		0xb8be
		},
		{
		0x8701,
		0xdfed
		},
		{
		0x8702,
		0xb8c1
		},
		{
		0x8703,
		0xb8c2
		},
		{
		0x8704,
		0xdfe3
		},
		{
		0x8705,
		0xdff0
		},
		{
		0x8706,
		0xb8c3
		},
		{
		0x8707,
		0xb8bd
		},
		{
		0x8708,
		0xb8bc
		},
		{
		0x8709,
		0xdfec
		},
		{
		0x870a,
		0xb8c4
		},
		{
		0x870b,
		0xdfe2
		},
		{
		0x870c,
		0xdfe5
		},
		{
		0x870d,
		0xdfef
		},
		{
		0x870e,
		0xdfeb
		},
		{
		0x8711,
		0xe3f4
		},
		{
		0x8712,
		0xe3e9
		},
		{
		0x8713,
		0xb8bb
		},
		{
		0x8718,
		0xbb6a
		},
		{
		0x8719,
		0xe3dd
		},
		{
		0x871a,
		0xe3f2
		},
		{
		0x871b,
		0xe3de
		},
		{
		0x871c,
		0xbb65
		},
		{
		0x871e,
		0xe3db
		},
		{
		0x8720,
		0xe3e4
		},
		{
		0x8721,
		0xe3dc
		},
		{
		0x8722,
		0xbb67
		},
		{
		0x8723,
		0xe3d6
		},
		{
		0x8724,
		0xe3f1
		},
		{
		0x8725,
		0xbb68
		},
		{
		0x8726,
		0xe3ee
		},
		{
		0x8727,
		0xe3ef
		},
		{
		0x8728,
		0xe3d7
		},
		{
		0x8729,
		0xbb6d
		},
		{
		0x872a,
		0xe3e6
		},
		{
		0x872c,
		0xe3e0
		},
		{
		0x872d,
		0xe3e7
		},
		{
		0x872e,
		0xe3da
		},
		{
		0x8730,
		0xe3f3
		},
		{
		0x8731,
		0xe3eb
		},
		{
		0x8732,
		0xe3e5
		},
		{
		0x8733,
		0xe3d5
		},
		{
		0x8734,
		0xbb69
		},
		{
		0x8735,
		0xe3ec
		},
		{
		0x8737,
		0xbb6c
		},
		{
		0x8738,
		0xe3f0
		},
		{
		0x873a,
		0xe3ea
		},
		{
		0x873b,
		0xbb66
		},
		{
		0x873c,
		0xe3e8
		},
		{
		0x873e,
		0xe3e2
		},
		{
		0x873f,
		0xbb64
		},
		{
		0x8740,
		0xe3d9
		},
		{
		0x8741,
		0xe3e1
		},
		{
		0x8742,
		0xe3ed
		},
		{
		0x8743,
		0xe3df
		},
		{
		0x8746,
		0xe3e3
		},
		{
		0x874c,
		0xbdc1
		},
		{
		0x874d,
		0xdfe9
		},
		{
		0x874e,
		0xe7b2
		},
		{
		0x874f,
		0xe7bb
		},
		{
		0x8750,
		0xe7b1
		},
		{
		0x8751,
		0xe7ad
		},
		{
		0x8752,
		0xe7aa
		},
		{
		0x8753,
		0xbdc2
		},
		{
		0x8754,
		0xe7a8
		},
		{
		0x8755,
		0xbb6b
		},
		{
		0x8756,
		0xe7a1
		},
		{
		0x8757,
		0xbdc0
		},
		{
		0x8758,
		0xe7a7
		},
		{
		0x8759,
		0xbdbf
		},
		{
		0x875a,
		0xe7ac
		},
		{
		0x875b,
		0xe7a9
		},
		{
		0x875c,
		0xe7b9
		},
		{
		0x875d,
		0xe7b4
		},
		{
		0x875e,
		0xe7ae
		},
		{
		0x875f,
		0xe7b3
		},
		{
		0x8760,
		0xbdbb
		},
		{
		0x8761,
		0xe7ab
		},
		{
		0x8762,
		0xe7be
		},
		{
		0x8763,
		0xe7a2
		},
		{
		0x8764,
		0xe7a3
		},
		{
		0x8765,
		0xe7ba
		},
		{
		0x8766,
		0xbdbc
		},
		{
		0x8767,
		0xe7bf
		},
		{
		0x8768,
		0xbdbe
		},
		{
		0x8769,
		0xe7c0
		},
		{
		0x876a,
		0xe7b0
		},
		{
		0x876b,
		0xe3d8
		},
		{
		0x876c,
		0xe7b6
		},
		{
		0x876d,
		0xe7af
		},
		{
		0x876e,
		0xe7b8
		},
		{
		0x876f,
		0xe7b5
		},
		{
		0x8773,
		0xe7a6
		},
		{
		0x8774,
		0xbdb9
		},
		{
		0x8775,
		0xe7bd
		},
		{
		0x8776,
		0xbdba
		},
		{
		0x8777,
		0xe7a4
		},
		{
		0x8778,
		0xbdbd
		},
		{
		0x8779,
		0xeb64
		},
		{
		0x877a,
		0xe7b7
		},
		{
		0x877b,
		0xe7bc
		},
		{
		0x8781,
		0xeb61
		},
		{
		0x8782,
		0xbdb8
		},
		{
		0x8783,
		0xbfc0
		},
		{
		0x8784,
		0xeb6b
		},
		{
		0x8785,
		0xeb67
		},
		{
		0x8787,
		0xeb65
		},
		{
		0x8788,
		0xeb60
		},
		{
		0x8789,
		0xeb6f
		},
		{
		0x878d,
		0xbfc4
		},
		{
		0x878f,
		0xeb5c
		},
		{
		0x8790,
		0xeb68
		},
		{
		0x8791,
		0xeb69
		},
		{
		0x8792,
		0xeb5f
		},
		{
		0x8793,
		0xeb5e
		},
		{
		0x8794,
		0xeb6c
		},
		{
		0x8796,
		0xeb62
		},
		{
		0x8797,
		0xeb5d
		},
		{
		0x8798,
		0xeb63
		},
		{
		0x879a,
		0xeb6e
		},
		{
		0x879b,
		0xeb5b
		},
		{
		0x879c,
		0xeb6d
		},
		{
		0x879d,
		0xeb6a
		},
		{
		0x879e,
		0xbfc2
		},
		{
		0x879f,
		0xbfc1
		},
		{
		0x87a2,
		0xbfc3
		},
		{
		0x87a3,
		0xeb66
		},
		{
		0x87a4,
		0xf0cb
		},
		{
		0x87aa,
		0xee59
		},
		{
		0x87ab,
		0xc1b1
		},
		{
		0x87ac,
		0xee5d
		},
		{
		0x87ad,
		0xee5a
		},
		{
		0x87ae,
		0xee61
		},
		{
		0x87af,
		0xee67
		},
		{
		0x87b0,
		0xee5c
		},
		{
		0x87b2,
		0xee70
		},
		{
		0x87b3,
		0xc1ae
		},
		{
		0x87b4,
		0xee6a
		},
		{
		0x87b5,
		0xee5f
		},
		{
		0x87b6,
		0xee6b
		},
		{
		0x87b7,
		0xee66
		},
		{
		0x87b8,
		0xee6d
		},
		{
		0x87b9,
		0xee5e
		},
		{
		0x87ba,
		0xc1b3
		},
		{
		0x87bb,
		0xc1b2
		},
		{
		0x87bc,
		0xee60
		},
		{
		0x87bd,
		0xee6e
		},
		{
		0x87be,
		0xee58
		},
		{
		0x87bf,
		0xee6c
		},
		{
		0x87c0,
		0xc1ac
		},
		{
		0x87c2,
		0xee64
		},
		{
		0x87c3,
		0xee63
		},
		{
		0x87c4,
		0xee68
		},
		{
		0x87c5,
		0xee5b
		},
		{
		0x87c6,
		0xc1b0
		},
		{
		0x87c8,
		0xc1b4
		},
		{
		0x87c9,
		0xee62
		},
		{
		0x87ca,
		0xee69
		},
		{
		0x87cb,
		0xc1b5
		},
		{
		0x87cc,
		0xee65
		},
		{
		0x87d1,
		0xc1ad
		},
		{
		0x87d2,
		0xc1af
		},
		{
		0x87d3,
		0xf0c7
		},
		{
		0x87d4,
		0xf0c5
		},
		{
		0x87d7,
		0xf0cc
		},
		{
		0x87d8,
		0xf0c9
		},
		{
		0x87d9,
		0xf0cd
		},
		{
		0x87db,
		0xf0be
		},
		{
		0x87dc,
		0xf0c6
		},
		{
		0x87dd,
		0xf0d1
		},
		{
		0x87de,
		0xee6f
		},
		{
		0x87df,
		0xf0c2
		},
		{
		0x87e0,
		0xc2cf
		},
		{
		0x87e1,
		0xe7a5
		},
		{
		0x87e2,
		0xf0bd
		},
		{
		0x87e3,
		0xf0ca
		},
		{
		0x87e4,
		0xf0c4
		},
		{
		0x87e5,
		0xf0c1
		},
		{
		0x87e6,
		0xf0bc
		},
		{
		0x87e7,
		0xf0bb
		},
		{
		0x87e8,
		0xf0d0
		},
		{
		0x87ea,
		0xf0c0
		},
		{
		0x87eb,
		0xf0bf
		},
		{
		0x87ec,
		0xc2cd
		},
		{
		0x87ed,
		0xf0c8
		},
		{
		0x87ef,
		0xc2cc
		},
		{
		0x87f2,
		0xc2ce
		},
		{
		0x87f3,
		0xf0c3
		},
		{
		0x87f4,
		0xf0cf
		},
		{
		0x87f6,
		0xf2de
		},
		{
		0x87f7,
		0xf2df
		},
		{
		0x87f9,
		0xc3c9
		},
		{
		0x87fa,
		0xf2dc
		},
		{
		0x87fb,
		0xc3c6
		},
		{
		0x87fc,
		0xf2e4
		},
		{
		0x87fe,
		0xc3ca
		},
		{
		0x87ff,
		0xf2e6
		},
		{
		0x8800,
		0xf2db
		},
		{
		0x8801,
		0xf0ce
		},
		{
		0x8802,
		0xf2e8
		},
		{
		0x8803,
		0xf2dd
		},
		{
		0x8805,
		0xc3c7
		},
		{
		0x8806,
		0xf2e3
		},
		{
		0x8808,
		0xf2e5
		},
		{
		0x8809,
		0xf2e0
		},
		{
		0x880a,
		0xf2e7
		},
		{
		0x880b,
		0xf2e2
		},
		{
		0x880c,
		0xf2e1
		},
		{
		0x880d,
		0xc3c8
		},
		{
		0x8810,
		0xf4c5
		},
		{
		0x8811,
		0xf4c6
		},
		{
		0x8813,
		0xf4c8
		},
		{
		0x8814,
		0xc4ae
		},
		{
		0x8815,
		0xc4af
		},
		{
		0x8816,
		0xf4c9
		},
		{
		0x8817,
		0xf4c7
		},
		{
		0x8819,
		0xf4c4
		},
		{
		0x881b,
		0xf642
		},
		{
		0x881c,
		0xf645
		},
		{
		0x881d,
		0xf641
		},
		{
		0x881f,
		0xc4fa
		},
		{
		0x8820,
		0xf643
		},
		{
		0x8821,
		0xc4f9
		},
		{
		0x8822,
		0xc4f8
		},
		{
		0x8823,
		0xc4f7
		},
		{
		0x8824,
		0xf644
		},
		{
		0x8825,
		0xf751
		},
		{
		0x8826,
		0xf74f
		},
		{
		0x8828,
		0xf74e
		},
		{
		0x8829,
		0xf640
		},
		{
		0x882a,
		0xf750
		},
		{
		0x882b,
		0xf646
		},
		{
		0x882c,
		0xf74d
		},
		{
		0x882e,
		0xf7f9
		},
		{
		0x882f,
		0xf7d7
		},
		{
		0x8830,
		0xf7f7
		},
		{
		0x8831,
		0xc5db
		},
		{
		0x8832,
		0xf7f8
		},
		{
		0x8833,
		0xf7fa
		},
		{
		0x8835,
		0xf8bf
		},
		{
		0x8836,
		0xc5fa
		},
		{
		0x8837,
		0xf8be
		},
		{
		0x8838,
		0xf8bd
		},
		{
		0x8839,
		0xc5fb
		},
		{
		0x883b,
		0xc65a
		},
		{
		0x883c,
		0xf96e
		},
		{
		0x883d,
		0xf9a7
		},
		{
		0x883e,
		0xf9a6
		},
		{
		0x883f,
		0xf9a8
		},
		{
		0x8840,
		0xa6e5
		},
		{
		0x8841,
		0xd0aa
		},
		{
		0x8843,
		0xd3cf
		},
		{
		0x8844,
		0xd3d0
		},
		{
		0x8848,
		0xdbc0
		},
		{
		0x884a,
		0xf647
		},
		{
		0x884b,
		0xf8c0
		},
		{
		0x884c,
		0xa6e6
		},
		{
		0x884d,
		0xad6c
		},
		{
		0x884e,
		0xd0ab
		},
		{
		0x8852,
		0xd7b1
		},
		{
		0x8853,
		0xb34e
		},
		{
		0x8855,
		0xdbc2
		},
		{
		0x8856,
		0xdbc1
		},
		{
		0x8857,
		0xb5f3
		},
		{
		0x8859,
		0xb8c5
		},
		{
		0x885a,
		0xe7c1
		},
		{
		0x885b,
		0xbdc3
		},
		{
		0x885d,
		0xbdc4
		},
		{
		0x8861,
		0xbfc5
		},
		{
		0x8862,
		0xc5fc
		},
		{
		0x8863,
		0xa6e7
		},
		{
		0x8867,
		0xd0ac
		},
		{
		0x8868,
		0xaaed
		},
		{
		0x8869,
		0xd0ae
		},
		{
		0x886a,
		0xd0ad
		},
		{
		0x886b,
		0xad6d
		},
		{
		0x886d,
		0xd3d1
		},
		{
		0x886f,
		0xd3d8
		},
		{
		0x8870,
		0xb049
		},
		{
		0x8871,
		0xd3d6
		},
		{
		0x8872,
		0xd3d4
		},
		{
		0x8874,
		0xd3db
		},
		{
		0x8875,
		0xd3d2
		},
		{
		0x8876,
		0xd3d3
		},
		{
		0x8877,
		0xb04a
		},
		{
		0x8879,
		0xb04e
		},
		{
		0x887c,
		0xd3dc
		},
		{
		0x887d,
		0xb04d
		},
		{
		0x887e,
		0xd3da
		},
		{
		0x887f,
		0xd3d7
		},
		{
		0x8880,
		0xd3d5
		},
		{
		0x8881,
		0xb04b
		},
		{
		0x8882,
		0xb04c
		},
		{
		0x8883,
		0xd3d9
		},
		{
		0x8888,
		0xb350
		},
		{
		0x8889,
		0xd7b2
		},
		{
		0x888b,
		0xb355
		},
		{
		0x888c,
		0xd7c2
		},
		{
		0x888d,
		0xb354
		},
		{
		0x888e,
		0xd7c4
		},
		{
		0x8891,
		0xd7b8
		},
		{
		0x8892,
		0xb352
		},
		{
		0x8893,
		0xd7c3
		},
		{
		0x8895,
		0xd7b3
		},
		{
		0x8896,
		0xb353
		},
		{
		0x8897,
		0xd7bf
		},
		{
		0x8898,
		0xd7bb
		},
		{
		0x8899,
		0xd7bd
		},
		{
		0x889a,
		0xd7b7
		},
		{
		0x889b,
		0xd7be
		},
		{
		0x889e,
		0xb34f
		},
		{
		0x889f,
		0xd7ba
		},
		{
		0x88a1,
		0xd7b9
		},
		{
		0x88a2,
		0xd7b5
		},
		{
		0x88a4,
		0xd7c0
		},
		{
		0x88a7,
		0xd7bc
		},
		{
		0x88a8,
		0xd7b4
		},
		{
		0x88aa,
		0xd7b6
		},
		{
		0x88ab,
		0xb351
		},
		{
		0x88ac,
		0xd7c1
		},
		{
		0x88b1,
		0xb5f6
		},
		{
		0x88b2,
		0xdbcd
		},
		{
		0x88b6,
		0xdbc9
		},
		{
		0x88b7,
		0xdbcb
		},
		{
		0x88b8,
		0xdbc6
		},
		{
		0x88b9,
		0xdbc5
		},
		{
		0x88ba,
		0xdbc3
		},
		{
		0x88bc,
		0xdbca
		},
		{
		0x88bd,
		0xdbcc
		},
		{
		0x88be,
		0xdbc8
		},
		{
		0x88c0,
		0xdbc7
		},
		{
		0x88c1,
		0xb5f4
		},
		{
		0x88c2,
		0xb5f5
		},
		{
		0x88c9,
		0xdbcf
		},
		{
		0x88ca,
		0xb8cd
		},
		{
		0x88cb,
		0xdff2
		},
		{
		0x88cc,
		0xdff8
		},
		{
		0x88cd,
		0xdff3
		},
		{
		0x88ce,
		0xdff4
		},
		{
		0x88d0,
		0xdff9
		},
		{
		0x88d2,
		0xb8cf
		},
		{
		0x88d4,
		0xb8c7
		},
		{
		0x88d5,
		0xb8ce
		},
		{
		0x88d6,
		0xdff1
		},
		{
		0x88d7,
		0xdbc4
		},
		{
		0x88d8,
		0xb8ca
		},
		{
		0x88d9,
		0xb8c8
		},
		{
		0x88da,
		0xdff7
		},
		{
		0x88db,
		0xdff6
		},
		{
		0x88dc,
		0xb8c9
		},
		{
		0x88dd,
		0xb8cb
		},
		{
		0x88de,
		0xdff5
		},
		{
		0x88df,
		0xb8c6
		},
		{
		0x88e1,
		0xb8cc
		},
		{
		0x88e7,
		0xe3f6
		},
		{
		0x88e8,
		0xbb74
		},
		{
		0x88eb,
		0xe442
		},
		{
		0x88ec,
		0xe441
		},
		{
		0x88ee,
		0xe3fb
		},
		{
		0x88ef,
		0xbb76
		},
		{
		0x88f0,
		0xe440
		},
		{
		0x88f1,
		0xe3f7
		},
		{
		0x88f2,
		0xe3f8
		},
		{
		0x88f3,
		0xbb6e
		},
		{
		0x88f4,
		0xbb70
		},
		{
		0x88f6,
		0xe3fd
		},
		{
		0x88f7,
		0xe3f5
		},
		{
		0x88f8,
		0xbb72
		},
		{
		0x88f9,
		0xbb71
		},
		{
		0x88fa,
		0xe3f9
		},
		{
		0x88fb,
		0xe3fe
		},
		{
		0x88fc,
		0xe3fc
		},
		{
		0x88fd,
		0xbb73
		},
		{
		0x88fe,
		0xe3fa
		},
		{
		0x8901,
		0xdbce
		},
		{
		0x8902,
		0xbb6f
		},
		{
		0x8905,
		0xe7c2
		},
		{
		0x8906,
		0xe7c9
		},
		{
		0x8907,
		0xbdc6
		},
		{
		0x8909,
		0xe7cd
		},
		{
		0x890a,
		0xbdca
		},
		{
		0x890b,
		0xe7c5
		},
		{
		0x890c,
		0xe7c3
		},
		{
		0x890e,
		0xe7cc
		},
		{
		0x8910,
		0xbdc5
		},
		{
		0x8911,
		0xe7cb
		},
		{
		0x8912,
		0xbdc7
		},
		{
		0x8913,
		0xbdc8
		},
		{
		0x8914,
		0xe7c4
		},
		{
		0x8915,
		0xbdc9
		},
		{
		0x8916,
		0xe7ca
		},
		{
		0x8917,
		0xe7c6
		},
		{
		0x8918,
		0xe7c7
		},
		{
		0x8919,
		0xe7c8
		},
		{
		0x891a,
		0xbb75
		},
		{
		0x891e,
		0xeb70
		},
		{
		0x891f,
		0xeb7c
		},
		{
		0x8921,
		0xbfca
		},
		{
		0x8922,
		0xeb77
		},
		{
		0x8923,
		0xeb79
		},
		{
		0x8925,
		0xbfc8
		},
		{
		0x8926,
		0xeb71
		},
		{
		0x8927,
		0xeb75
		},
		{
		0x8929,
		0xeb78
		},
		{
		0x892a,
		0xbfc6
		},
		{
		0x892b,
		0xbfc9
		},
		{
		0x892c,
		0xeb7b
		},
		{
		0x892d,
		0xeb73
		},
		{
		0x892e,
		0xeb74
		},
		{
		0x892f,
		0xeb7a
		},
		{
		0x8930,
		0xeb72
		},
		{
		0x8931,
		0xeb76
		},
		{
		0x8932,
		0xbfc7
		},
		{
		0x8933,
		0xee72
		},
		{
		0x8935,
		0xee71
		},
		{
		0x8936,
		0xc1b7
		},
		{
		0x8937,
		0xee77
		},
		{
		0x8938,
		0xc1b9
		},
		{
		0x893b,
		0xc1b6
		},
		{
		0x893c,
		0xee73
		},
		{
		0x893d,
		0xc1ba
		},
		{
		0x893e,
		0xee74
		},
		{
		0x8941,
		0xee75
		},
		{
		0x8942,
		0xee78
		},
		{
		0x8944,
		0xc1b8
		},
		{
		0x8946,
		0xf0d6
		},
		{
		0x8949,
		0xf0d9
		},
		{
		0x894b,
		0xf0d3
		},
		{
		0x894c,
		0xf0d5
		},
		{
		0x894f,
		0xf0d4
		},
		{
		0x8950,
		0xf0d7
		},
		{
		0x8951,
		0xf0d8
		},
		{
		0x8952,
		0xee76
		},
		{
		0x8953,
		0xf0d2
		},
		{
		0x8956,
		0xc3cd
		},
		{
		0x8957,
		0xf2ec
		},
		{
		0x8958,
		0xf2ef
		},
		{
		0x8959,
		0xf2f1
		},
		{
		0x895a,
		0xf2ea
		},
		{
		0x895b,
		0xf2eb
		},
		{
		0x895c,
		0xf2ee
		},
		{
		0x895d,
		0xf2f0
		},
		{
		0x895e,
		0xc3ce
		},
		{
		0x895f,
		0xc3cc
		},
		{
		0x8960,
		0xc3cb
		},
		{
		0x8961,
		0xf2ed
		},
		{
		0x8962,
		0xf2e9
		},
		{
		0x8963,
		0xf4ca
		},
		{
		0x8964,
		0xc4b0
		},
		{
		0x8966,
		0xf4cb
		},
		{
		0x8969,
		0xf649
		},
		{
		0x896a,
		0xc4fb
		},
		{
		0x896b,
		0xf64b
		},
		{
		0x896c,
		0xc4fc
		},
		{
		0x896d,
		0xf648
		},
		{
		0x896e,
		0xf64a
		},
		{
		0x896f,
		0xc5a8
		},
		{
		0x8971,
		0xf752
		},
		{
		0x8972,
		0xc5a7
		},
		{
		0x8973,
		0xf7fd
		},
		{
		0x8974,
		0xf7fc
		},
		{
		0x8976,
		0xf7fb
		},
		{
		0x8979,
		0xf948
		},
		{
		0x897a,
		0xf949
		},
		{
		0x897b,
		0xf94b
		},
		{
		0x897c,
		0xf94a
		},
		{
		0x897e,
		0xca50
		},
		{
		0x897f,
		0xa6e8
		},
		{
		0x8981,
		0xad6e
		},
		{
		0x8982,
		0xd7c5
		},
		{
		0x8983,
		0xb5f7
		},
		{
		0x8985,
		0xdffa
		},
		{
		0x8986,
		0xc2d0
		},
		{
		0x8988,
		0xf2f2
		},
		{
		0x898b,
		0xa8a3
		},
		{
		0x898f,
		0xb357
		},
		{
		0x8993,
		0xb356
		},
		{
		0x8995,
		0xdbd0
		},
		{
		0x8996,
		0xb5f8
		},
		{
		0x8997,
		0xdbd2
		},
		{
		0x8998,
		0xdbd1
		},
		{
		0x899b,
		0xdffb
		},
		{
		0x899c,
		0xb8d0
		},
		{
		0x899d,
		0xe443
		},
		{
		0x899e,
		0xe446
		},
		{
		0x899f,
		0xe445
		},
		{
		0x89a1,
		0xe444
		},
		{
		0x89a2,
		0xe7ce
		},
		{
		0x89a3,
		0xe7d0
		},
		{
		0x89a4,
		0xe7cf
		},
		{
		0x89a6,
		0xbfcc
		},
		{
		0x89aa,
		0xbfcb
		},
		{
		0x89ac,
		0xc1bb
		},
		{
		0x89ad,
		0xee79
		},
		{
		0x89ae,
		0xee7b
		},
		{
		0x89af,
		0xee7a
		},
		{
		0x89b2,
		0xc2d1
		},
		{
		0x89b6,
		0xf2f4
		},
		{
		0x89b7,
		0xf2f3
		},
		{
		0x89b9,
		0xf4cc
		},
		{
		0x89ba,
		0xc4b1
		},
		{
		0x89bd,
		0xc4fd
		},
		{
		0x89be,
		0xf754
		},
		{
		0x89bf,
		0xf753
		},
		{
		0x89c0,
		0xc65b
		},
		{
		0x89d2,
		0xa8a4
		},
		{
		0x89d3,
		0xd0af
		},
		{
		0x89d4,
		0xad6f
		},
		{
		0x89d5,
		0xd7c8
		},
		{
		0x89d6,
		0xd7c6
		},
		{
		0x89d9,
		0xd7c7
		},
		{
		0x89da,
		0xdbd4
		},
		{
		0x89db,
		0xdbd5
		},
		{
		0x89dc,
		0xe043
		},
		{
		0x89dd,
		0xdbd3
		},
		{
		0x89df,
		0xdffc
		},
		{
		0x89e0,
		0xe041
		},
		{
		0x89e1,
		0xe040
		},
		{
		0x89e2,
		0xe042
		},
		{
		0x89e3,
		0xb8d1
		},
		{
		0x89e4,
		0xdffe
		},
		{
		0x89e5,
		0xdffd
		},
		{
		0x89e6,
		0xe044
		},
		{
		0x89e8,
		0xe449
		},
		{
		0x89e9,
		0xe447
		},
		{
		0x89eb,
		0xe448
		},
		{
		0x89ec,
		0xe7d3
		},
		{
		0x89ed,
		0xe7d1
		},
		{
		0x89f0,
		0xe7d2
		},
		{
		0x89f1,
		0xeb7d
		},
		{
		0x89f2,
		0xee7c
		},
		{
		0x89f3,
		0xee7d
		},
		{
		0x89f4,
		0xc2d2
		},
		{
		0x89f6,
		0xf2f5
		},
		{
		0x89f7,
		0xf4cd
		},
		{
		0x89f8,
		0xc4b2
		},
		{
		0x89fa,
		0xf64c
		},
		{
		0x89fb,
		0xf755
		},
		{
		0x89fc,
		0xc5a9
		},
		{
		0x89fe,
		0xf7fe
		},
		{
		0x89ff,
		0xf94c
		},
		{
		0x8a00,
		0xa8a5
		},
		{
		0x8a02,
		0xad71
		},
		{
		0x8a03,
		0xad72
		},
		{
		0x8a04,
		0xd0b0
		},
		{
		0x8a07,
		0xd0b1
		},
		{
		0x8a08,
		0xad70
		},
		{
		0x8a0a,
		0xb054
		},
		{
		0x8a0c,
		0xb052
		},
		{
		0x8a0e,
		0xb051
		},
		{
		0x8a0f,
		0xb058
		},
		{
		0x8a10,
		0xb050
		},
		{
		0x8a11,
		0xb059
		},
		{
		0x8a12,
		0xd3dd
		},
		{
		0x8a13,
		0xb056
		},
		{
		0x8a15,
		0xb053
		},
		{
		0x8a16,
		0xb057
		},
		{
		0x8a17,
		0xb055
		},
		{
		0x8a18,
		0xb04f
		},
		{
		0x8a1b,
		0xb35f
		},
		{
		0x8a1d,
		0xb359
		},
		{
		0x8a1e,
		0xd7cc
		},
		{
		0x8a1f,
		0xb35e
		},
		{
		0x8a22,
		0xb360
		},
		{
		0x8a23,
		0xb35a
		},
		{
		0x8a25,
		0xb35b
		},
		{
		0x8a27,
		0xd7ca
		},
		{
		0x8a2a,
		0xb358
		},
		{
		0x8a2c,
		0xd7cb
		},
		{
		0x8a2d,
		0xb35d
		},
		{
		0x8a30,
		0xd7c9
		},
		{
		0x8a31,
		0xb35c
		},
		{
		0x8a34,
		0xb644
		},
		{
		0x8a36,
		0xb646
		},
		{
		0x8a39,
		0xdbd8
		},
		{
		0x8a3a,
		0xb645
		},
		{
		0x8a3b,
		0xb5f9
		},
		{
		0x8a3c,
		0xb5fd
		},
		{
		0x8a3e,
		0xb8e4
		},
		{
		0x8a3f,
		0xe049
		},
		{
		0x8a40,
		0xdbda
		},
		{
		0x8a41,
		0xb5fe
		},
		{
		0x8a44,
		0xdbdd
		},
		{
		0x8a45,
		0xdbde
		},
		{
		0x8a46,
		0xb643
		},
		{
		0x8a48,
		0xdbe0
		},
		{
		0x8a4a,
		0xdbe2
		},
		{
		0x8a4c,
		0xdbe3
		},
		{
		0x8a4d,
		0xdbd7
		},
		{
		0x8a4e,
		0xdbd6
		},
		{
		0x8a4f,
		0xdbe4
		},
		{
		0x8a50,
		0xb642
		},
		{
		0x8a51,
		0xdbe1
		},
		{
		0x8a52,
		0xdbdf
		},
		{
		0x8a54,
		0xb640
		},
		{
		0x8a55,
		0xb5fb
		},
		{
		0x8a56,
		0xb647
		},
		{
		0x8a57,
		0xdbdb
		},
		{
		0x8a58,
		0xdbdc
		},
		{
		0x8a59,
		0xdbd9
		},
		{
		0x8a5b,
		0xb641
		},
		{
		0x8a5e,
		0xb5fc
		},
		{
		0x8a60,
		0xb5fa
		},
		{
		0x8a61,
		0xe048
		},
		{
		0x8a62,
		0xb8df
		},
		{
		0x8a63,
		0xb8da
		},
		{
		0x8a66,
		0xb8d5
		},
		{
		0x8a68,
		0xb8e5
		},
		{
		0x8a69,
		0xb8d6
		},
		{
		0x8a6b,
		0xb8d2
		},
		{
		0x8a6c,
		0xb8e1
		},
		{
		0x8a6d,
		0xb8de
		},
		{
		0x8a6e,
		0xb8e0
		},
		{
		0x8a70,
		0xb8d7
		},
		{
		0x8a71,
		0xb8dc
		},
		{
		0x8a72,
		0xb8d3
		},
		{
		0x8a73,
		0xb8d4
		},
		{
		0x8a74,
		0xe050
		},
		{
		0x8a75,
		0xe04d
		},
		{
		0x8a76,
		0xe045
		},
		{
		0x8a77,
		0xe04a
		},
		{
		0x8a79,
		0xb8e2
		},
		{
		0x8a7a,
		0xe051
		},
		{
		0x8a7b,
		0xb8e3
		},
		{
		0x8a7c,
		0xb8d9
		},
		{
		0x8a7f,
		0xe047
		},
		{
		0x8a81,
		0xe04f
		},
		{
		0x8a82,
		0xe04b
		},
		{
		0x8a83,
		0xe04e
		},
		{
		0x8a84,
		0xe04c
		},
		{
		0x8a85,
		0xb8dd
		},
		{
		0x8a86,
		0xe046
		},
		{
		0x8a87,
		0xb8d8
		},
		{
		0x8a8b,
		0xe44c
		},
		{
		0x8a8c,
		0xbb78
		},
		{
		0x8a8d,
		0xbb7b
		},
		{
		0x8a8f,
		0xe44e
		},
		{
		0x8a91,
		0xbba5
		},
		{
		0x8a92,
		0xe44d
		},
		{
		0x8a93,
		0xbb7d
		},
		{
		0x8a95,
		0xbdcf
		},
		{
		0x8a96,
		0xe44f
		},
		{
		0x8a98,
		0xbba4
		},
		{
		0x8a99,
		0xe44b
		},
		{
		0x8a9a,
		0xbba6
		},
		{
		0x8a9e,
		0xbb79
		},
		{
		0x8aa0,
		0xb8db
		},
		{
		0x8aa1,
		0xbb7c
		},
		{
		0x8aa3,
		0xbb7a
		},
		{
		0x8aa4,
		0xbb7e
		},
		{
		0x8aa5,
		0xbba2
		},
		{
		0x8aa6,
		0xbb77
		},
		{
		0x8aa7,
		0xbba7
		},
		{
		0x8aa8,
		0xbba3
		},
		{
		0x8aaa,
		0xbba1
		},
		{
		0x8aab,
		0xe44a
		},
		{
		0x8ab0,
		0xbdd6
		},
		{
		0x8ab2,
		0xbdd2
		},
		{
		0x8ab6,
		0xbdd9
		},
		{
		0x8ab8,
		0xe7d6
		},
		{
		0x8ab9,
		0xbdda
		},
		{
		0x8aba,
		0xe7e2
		},
		{
		0x8abb,
		0xe7db
		},
		{
		0x8abc,
		0xbdcb
		},
		{
		0x8abd,
		0xe7e3
		},
		{
		0x8abe,
		0xe7dd
		},
		{
		0x8abf,
		0xbdd5
		},
		{
		0x8ac0,
		0xe7de
		},
		{
		0x8ac2,
		0xbdd4
		},
		{
		0x8ac3,
		0xe7e1
		},
		{
		0x8ac4,
		0xbdce
		},
		{
		0x8ac5,
		0xe7df
		},
		{
		0x8ac6,
		0xe7d5
		},
		{
		0x8ac7,
		0xbdcd
		},
		{
		0x8ac8,
		0xebaa
		},
		{
		0x8ac9,
		0xbdd3
		},
		{
		0x8acb,
		0xbdd0
		},
		{
		0x8acd,
		0xbdd8
		},
		{
		0x8acf,
		0xe7d4
		},
		{
		0x8ad1,
		0xe7d8
		},
		{
		0x8ad2,
		0xbdcc
		},
		{
		0x8ad3,
		0xe7d7
		},
		{
		0x8ad4,
		0xe7d9
		},
		{
		0x8ad5,
		0xe7da
		},
		{
		0x8ad6,
		0xbdd7
		},
		{
		0x8ad7,
		0xe7dc
		},
		{
		0x8ad8,
		0xe7e0
		},
		{
		0x8ad9,
		0xe7e4
		},
		{
		0x8adb,
		0xbddb
		},
		{
		0x8adc,
		0xbfd2
		},
		{
		0x8add,
		0xeba5
		},
		{
		0x8ade,
		0xebab
		},
		{
		0x8adf,
		0xeba8
		},
		{
		0x8ae0,
		0xeb7e
		},
		{
		0x8ae1,
		0xebac
		},
		{
		0x8ae2,
		0xeba1
		},
		{
		0x8ae4,
		0xeba7
		},
		{
		0x8ae6,
		0xbfcd
		},
		{
		0x8ae7,
		0xbfd3
		},
		{
		0x8ae8,
		0xebad
		},
		{
		0x8aeb,
		0xbfcf
		},
		{
		0x8aed,
		0xbfd9
		},
		{
		0x8aee,
		0xbfd4
		},
		{
		0x8aef,
		0xebaf
		},
		{
		0x8af0,
		0xeba9
		},
		{
		0x8af1,
		0xbfd0
		},
		{
		0x8af2,
		0xeba2
		},
		{
		0x8af3,
		0xbfda
		},
		{
		0x8af4,
		0xeba3
		},
		{
		0x8af5,
		0xeba4
		},
		{
		0x8af6,
		0xbfdb
		},
		{
		0x8af7,
		0xbfd8
		},
		{
		0x8af8,
		0xbdd1
		},
		{
		0x8afa,
		0xbfce
		},
		{
		0x8afb,
		0xebb0
		},
		{
		0x8afc,
		0xbfdc
		},
		{
		0x8afe,
		0xbfd5
		},
		{
		0x8aff,
		0xebae
		},
		{
		0x8b00,
		0xbfd1
		},
		{
		0x8b01,
		0xbfd6
		},
		{
		0x8b02,
		0xbfd7
		},
		{
		0x8b04,
		0xc1c3
		},
		{
		0x8b05,
		0xeea4
		},
		{
		0x8b06,
		0xeead
		},
		{
		0x8b07,
		0xeeaa
		},
		{
		0x8b08,
		0xeeac
		},
		{
		0x8b0a,
		0xc1c0
		},
		{
		0x8b0b,
		0xeea5
		},
		{
		0x8b0d,
		0xeeab
		},
		{
		0x8b0e,
		0xc1bc
		},
		{
		0x8b0f,
		0xeea7
		},
		{
		0x8b10,
		0xc1c4
		},
		{
		0x8b11,
		0xeea3
		},
		{
		0x8b12,
		0xeea8
		},
		{
		0x8b13,
		0xeeaf
		},
		{
		0x8b14,
		0xeba6
		},
		{
		0x8b15,
		0xeea9
		},
		{
		0x8b16,
		0xeea2
		},
		{
		0x8b17,
		0xc1bd
		},
		{
		0x8b18,
		0xeea1
		},
		{
		0x8b19,
		0xc1be
		},
		{
		0x8b1a,
		0xeeb0
		},
		{
		0x8b1b,
		0xc1bf
		},
		{
		0x8b1c,
		0xeeae
		},
		{
		0x8b1d,
		0xc1c2
		},
		{
		0x8b1e,
		0xee7e
		},
		{
		0x8b20,
		0xc1c1
		},
		{
		0x8b22,
		0xeea6
		},
		{
		0x8b23,
		0xf0dc
		},
		{
		0x8b24,
		0xf0ea
		},
		{
		0x8b25,
		0xf0e5
		},
		{
		0x8b26,
		0xf0e7
		},
		{
		0x8b27,
		0xf0db
		},
		{
		0x8b28,
		0xc2d3
		},
		{
		0x8b2a,
		0xf0da
		},
		{
		0x8b2b,
		0xc2d6
		},
		{
		0x8b2c,
		0xc2d5
		},
		{
		0x8b2e,
		0xf0e9
		},
		{
		0x8b2f,
		0xf0e1
		},
		{
		0x8b30,
		0xf0de
		},
		{
		0x8b31,
		0xf0e4
		},
		{
		0x8b33,
		0xf0dd
		},
		{
		0x8b35,
		0xf0df
		},
		{
		0x8b36,
		0xf0e8
		},
		{
		0x8b37,
		0xf0e6
		},
		{
		0x8b39,
		0xc2d4
		},
		{
		0x8b3a,
		0xf0ed
		},
		{
		0x8b3b,
		0xf0eb
		},
		{
		0x8b3c,
		0xf0e2
		},
		{
		0x8b3d,
		0xf0ec
		},
		{
		0x8b3e,
		0xf0e3
		},
		{
		0x8b40,
		0xf2f9
		},
		{
		0x8b41,
		0xc3cf
		},
		{
		0x8b42,
		0xf341
		},
		{
		0x8b45,
		0xf64f
		},
		{
		0x8b46,
		0xc3d6
		},
		{
		0x8b47,
		0xf0e0
		},
		{
		0x8b48,
		0xf2f7
		},
		{
		0x8b49,
		0xc3d2
		},
		{
		0x8b4a,
		0xf2f8
		},
		{
		0x8b4b,
		0xf2fd
		},
		{
		0x8b4e,
		0xc3d4
		},
		{
		0x8b4f,
		0xc3d5
		},
		{
		0x8b50,
		0xf2f6
		},
		{
		0x8b51,
		0xf340
		},
		{
		0x8b52,
		0xf342
		},
		{
		0x8b53,
		0xf2fa
		},
		{
		0x8b54,
		0xf2fc
		},
		{
		0x8b55,
		0xf2fe
		},
		{
		0x8b56,
		0xf2fb
		},
		{
		0x8b57,
		0xf343
		},
		{
		0x8b58,
		0xc3d1
		},
		{
		0x8b59,
		0xc3d7
		},
		{
		0x8b5a,
		0xc3d3
		},
		{
		0x8b5c,
		0xc3d0
		},
		{
		0x8b5d,
		0xf4d0
		},
		{
		0x8b5f,
		0xc4b7
		},
		{
		0x8b60,
		0xf4ce
		},
		{
		0x8b63,
		0xf4d2
		},
		{
		0x8b65,
		0xf4d3
		},
		{
		0x8b66,
		0xc4b5
		},
		{
		0x8b67,
		0xf4d4
		},
		{
		0x8b68,
		0xf4d1
		},
		{
		0x8b6a,
		0xf4cf
		},
		{
		0x8b6b,
		0xc4b8
		},
		{
		0x8b6c,
		0xc4b4
		},
		{
		0x8b6d,
		0xf4d5
		},
		{
		0x8b6f,
		0xc4b6
		},
		{
		0x8b70,
		0xc4b3
		},
		{
		0x8b74,
		0xc4fe
		},
		{
		0x8b77,
		0xc540
		},
		{
		0x8b78,
		0xf64e
		},
		{
		0x8b79,
		0xf64d
		},
		{
		0x8b7a,
		0xf650
		},
		{
		0x8b7b,
		0xf651
		},
		{
		0x8b7d,
		0xc541
		},
		{
		0x8b7e,
		0xf756
		},
		{
		0x8b7f,
		0xf75b
		},
		{
		0x8b80,
		0xc5aa
		},
		{
		0x8b82,
		0xf758
		},
		{
		0x8b84,
		0xf757
		},
		{
		0x8b85,
		0xf75a
		},
		{
		0x8b86,
		0xf759
		},
		{
		0x8b88,
		0xf843
		},
		{
		0x8b8a,
		0xc5dc
		},
		{
		0x8b8b,
		0xf842
		},
		{
		0x8b8c,
		0xf840
		},
		{
		0x8b8e,
		0xf841
		},
		{
		0x8b92,
		0xc5fe
		},
		{
		0x8b93,
		0xc5fd
		},
		{
		0x8b94,
		0xf8c1
		},
		{
		0x8b95,
		0xf8c2
		},
		{
		0x8b96,
		0xc640
		},
		{
		0x8b98,
		0xf94d
		},
		{
		0x8b99,
		0xf94e
		},
		{
		0x8b9a,
		0xc667
		},
		{
		0x8b9c,
		0xc66d
		},
		{
		0x8b9e,
		0xf9a9
		},
		{
		0x8b9f,
		0xf9c8
		},
		{
		0x8c37,
		0xa8a6
		},
		{
		0x8c39,
		0xd7cd
		},
		{
		0x8c3b,
		0xd7ce
		},
		{
		0x8c3c,
		0xe052
		},
		{
		0x8c3d,
		0xe450
		},
		{
		0x8c3e,
		0xe7e5
		},
		{
		0x8c3f,
		0xc1c6
		},
		{
		0x8c41,
		0xc1c5
		},
		{
		0x8c42,
		0xf0ee
		},
		{
		0x8c43,
		0xf344
		},
		{
		0x8c45,
		0xf844
		},
		{
		0x8c46,
		0xa8a7
		},
		{
		0x8c47,
		0xd3de
		},
		{
		0x8c48,
		0xb05a
		},
		{
		0x8c49,
		0xb361
		},
		{
		0x8c4a,
		0xe054
		},
		{
		0x8c4b,
		0xe053
		},
		{
		0x8c4c,
		0xbddc
		},
		{
		0x8c4d,
		0xe7e6
		},
		{
		0x8c4e,
		0xbddd
		},
		{
		0x8c4f,
		0xeeb1
		},
		{
		0x8c50,
		0xc2d7
		},
		{
		0x8c54,
		0xc676
		},
		{
		0x8c55,
		0xa8a8
		},
		{
		0x8c56,
		0xcdcb
		},
		{
		0x8c57,
		0xd3df
		},
		{
		0x8c5a,
		0xb362
		},
		{
		0x8c5c,
		0xd7cf
		},
		{
		0x8c5d,
		0xd7d0
		},
		{
		0x8c5f,
		0xdbe5
		},
		{
		0x8c61,
		0xb648
		},
		{
		0x8c62,
		0xb8e6
		},
		{
		0x8c64,
		0xe056
		},
		{
		0x8c65,
		0xe055
		},
		{
		0x8c66,
		0xe057
		},
		{
		0x8c68,
		0xe451
		},
		{
		0x8c69,
		0xe452
		},
		{
		0x8c6a,
		0xbba8
		},
		{
		0x8c6b,
		0xbfdd
		},
		{
		0x8c6c,
		0xbdde
		},
		{
		0x8c6d,
		0xbfde
		},
		{
		0x8c6f,
		0xeeb5
		},
		{
		0x8c70,
		0xeeb2
		},
		{
		0x8c71,
		0xeeb4
		},
		{
		0x8c72,
		0xeeb3
		},
		{
		0x8c73,
		0xc1c7
		},
		{
		0x8c75,
		0xf0ef
		},
		{
		0x8c76,
		0xf346
		},
		{
		0x8c77,
		0xf345
		},
		{
		0x8c78,
		0xcba4
		},
		{
		0x8c79,
		0xb05c
		},
		{
		0x8c7a,
		0xb05b
		},
		{
		0x8c7b,
		0xd3e0
		},
		{
		0x8c7d,
		0xd7d1
		},
		{
		0x8c80,
		0xdbe7
		},
		{
		0x8c81,
		0xdbe6
		},
		{
		0x8c82,
		0xb649
		},
		{
		0x8c84,
		0xe059
		},
		{
		0x8c85,
		0xe05a
		},
		{
		0x8c86,
		0xe058
		},
		{
		0x8c89,
		0xb8e8
		},
		{
		0x8c8a,
		0xb8e7
		},
		{
		0x8c8c,
		0xbbaa
		},
		{
		0x8c8d,
		0xbba9
		},
		{
		0x8c8f,
		0xe7e7
		},
		{
		0x8c90,
		0xebb3
		},
		{
		0x8c91,
		0xebb1
		},
		{
		0x8c92,
		0xebb2
		},
		{
		0x8c93,
		0xbfdf
		},
		{
		0x8c94,
		0xeeb7
		},
		{
		0x8c95,
		0xeeb6
		},
		{
		0x8c97,
		0xf0f2
		},
		{
		0x8c98,
		0xf0f1
		},
		{
		0x8c99,
		0xf0f0
		},
		{
		0x8c9a,
		0xf347
		},
		{
		0x8c9c,
		0xf9aa
		},
		{
		0x8c9d,
		0xa8a9
		},
		{
		0x8c9e,
		0xad73
		},
		{
		0x8ca0,
		0xad74
		},
		{
		0x8ca1,
		0xb05d
		},
		{
		0x8ca2,
		0xb05e
		},
		{
		0x8ca3,
		0xd3e2
		},
		{
		0x8ca4,
		0xd3e1
		},
		{
		0x8ca5,
		0xd7d2
		},
		{
		0x8ca7,
		0xb368
		},
		{
		0x8ca8,
		0xb366
		},
		{
		0x8ca9,
		0xb363
		},
		{
		0x8caa,
		0xb367
		},
		{
		0x8cab,
		0xb365
		},
		{
		0x8cac,
		0xb364
		},
		{
		0x8caf,
		0xb64a
		},
		{
		0x8cb0,
		0xdbea
		},
		{
		0x8cb2,
		0xb8ed
		},
		{
		0x8cb3,
		0xb64c
		},
		{
		0x8cb4,
		0xb651
		},
		{
		0x8cb5,
		0xdbec
		},
		{
		0x8cb6,
		0xb653
		},
		{
		0x8cb7,
		0xb652
		},
		{
		0x8cb8,
		0xb655
		},
		{
		0x8cb9,
		0xdbeb
		},
		{
		0x8cba,
		0xdbe8
		},
		{
		0x8cbb,
		0xb64f
		},
		{
		0x8cbc,
		0xb64b
		},
		{
		0x8cbd,
		0xb64d
		},
		{
		0x8cbe,
		0xdbe9
		},
		{
		0x8cbf,
		0xb654
		},
		{
		0x8cc0,
		0xb650
		},
		{
		0x8cc1,
		0xb64e
		},
		{
		0x8cc2,
		0xb8ef
		},
		{
		0x8cc3,
		0xb8ee
		},
		{
		0x8cc4,
		0xb8ec
		},
		{
		0x8cc5,
		0xb8f0
		},
		{
		0x8cc7,
		0xb8ea
		},
		{
		0x8cc8,
		0xb8eb
		},
		{
		0x8cca,
		0xb8e9
		},
		{
		0x8ccc,
		0xe05b
		},
		{
		0x8ccf,
		0xe454
		},
		{
		0x8cd1,
		0xbbac
		},
		{
		0x8cd2,
		0xbbad
		},
		{
		0x8cd3,
		0xbbab
		},
		{
		0x8cd5,
		0xe453
		},
		{
		0x8cd7,
		0xe455
		},
		{
		0x8cd9,
		0xe7ea
		},
		{
		0x8cda,
		0xe7ec
		},
		{
		0x8cdc,
		0xbde7
		},
		{
		0x8cdd,
		0xe7ed
		},
		{
		0x8cde,
		0xbde0
		},
		{
		0x8cdf,
		0xe7e9
		},
		{
		0x8ce0,
		0xbddf
		},
		{
		0x8ce1,
		0xbde9
		},
		{
		0x8ce2,
		0xbde5
		},
		{
		0x8ce3,
		0xbde6
		},
		{
		0x8ce4,
		0xbde2
		},
		{
		0x8ce5,
		0xe7e8
		},
		{
		0x8ce6,
		0xbde1
		},
		{
		0x8ce7,
		0xe7ee
		},
		{
		0x8ce8,
		0xe7eb
		},
		{
		0x8cea,
		0xbde8
		},
		{
		0x8cec,
		0xbde3
		},
		{
		0x8ced,
		0xbde4
		},
		{
		0x8cee,
		0xebb5
		},
		{
		0x8cf0,
		0xebb7
		},
		{
		0x8cf1,
		0xebb6
		},
		{
		0x8cf3,
		0xebb8
		},
		{
		0x8cf4,
		0xbfe0
		},
		{
		0x8cf5,
		0xebb4
		},
		{
		0x8cf8,
		0xc1cb
		},
		{
		0x8cf9,
		0xeeb8
		},
		{
		0x8cfa,
		0xc1c8
		},
		{
		0x8cfb,
		0xc1cc
		},
		{
		0x8cfc,
		0xc1ca
		},
		{
		0x8cfd,
		0xc1c9
		},
		{
		0x8cfe,
		0xf0f3
		},
		{
		0x8d00,
		0xf0f6
		},
		{
		0x8d02,
		0xf0f5
		},
		{
		0x8d04,
		0xf0f4
		},
		{
		0x8d05,
		0xc2d8
		},
		{
		0x8d06,
		0xf348
		},
		{
		0x8d07,
		0xf349
		},
		{
		0x8d08,
		0xc3d8
		},
		{
		0x8d09,
		0xf34a
		},
		{
		0x8d0a,
		0xc3d9
		},
		{
		0x8d0d,
		0xc4ba
		},
		{
		0x8d0f,
		0xc4b9
		},
		{
		0x8d10,
		0xf652
		},
		{
		0x8d13,
		0xc542
		},
		{
		0x8d14,
		0xf653
		},
		{
		0x8d15,
		0xf75c
		},
		{
		0x8d16,
		0xc5ab
		},
		{
		0x8d17,
		0xc5ac
		},
		{
		0x8d19,
		0xf845
		},
		{
		0x8d1b,
		0xc642
		},
		{
		0x8d64,
		0xa8aa
		},
		{
		0x8d66,
		0xb36a
		},
		{
		0x8d67,
		0xb369
		},
		{
		0x8d68,
		0xe05c
		},
		{
		0x8d69,
		0xe05d
		},
		{
		0x8d6b,
		0xbbae
		},
		{
		0x8d6c,
		0xebb9
		},
		{
		0x8d6d,
		0xbdea
		},
		{
		0x8d6e,
		0xebba
		},
		{
		0x8d6f,
		0xeeb9
		},
		{
		0x8d70,
		0xa8ab
		},
		{
		0x8d72,
		0xd0b2
		},
		{
		0x8d73,
		0xad76
		},
		{
		0x8d74,
		0xad75
		},
		{
		0x8d76,
		0xd3e3
		},
		{
		0x8d77,
		0xb05f
		},
		{
		0x8d78,
		0xd3e4
		},
		{
		0x8d79,
		0xd7d5
		},
		{
		0x8d7b,
		0xd7d4
		},
		{
		0x8d7d,
		0xd7d3
		},
		{
		0x8d80,
		0xdbee
		},
		{
		0x8d81,
		0xb658
		},
		{
		0x8d84,
		0xdbed
		},
		{
		0x8d85,
		0xb657
		},
		{
		0x8d89,
		0xdbef
		},
		{
		0x8d8a,
		0xb656
		},
		{
		0x8d8c,
		0xe05f
		},
		{
		0x8d8d,
		0xe062
		},
		{
		0x8d8e,
		0xe060
		},
		{
		0x8d8f,
		0xe061
		},
		{
		0x8d90,
		0xe065
		},
		{
		0x8d91,
		0xe05e
		},
		{
		0x8d92,
		0xe066
		},
		{
		0x8d93,
		0xe063
		},
		{
		0x8d94,
		0xe064
		},
		{
		0x8d95,
		0xbbb0
		},
		{
		0x8d96,
		0xe456
		},
		{
		0x8d99,
		0xbbaf
		},
		{
		0x8d9b,
		0xe7f2
		},
		{
		0x8d9c,
		0xe7f0
		},
		{
		0x8d9f,
		0xbdeb
		},
		{
		0x8da0,
		0xe7ef
		},
		{
		0x8da1,
		0xe7f1
		},
		{
		0x8da3,
		0xbdec
		},
		{
		0x8da5,
		0xebbb
		},
		{
		0x8da7,
		0xebbc
		},
		{
		0x8da8,
		0xc1cd
		},
		{
		0x8daa,
		0xf34c
		},
		{
		0x8dab,
		0xf34e
		},
		{
		0x8dac,
		0xf34b
		},
		{
		0x8dad,
		0xf34d
		},
		{
		0x8dae,
		0xf4d6
		},
		{
		0x8daf,
		0xf654
		},
		{
		0x8db2,
		0xf96f
		},
		{
		0x8db3,
		0xa8ac
		},
		{
		0x8db4,
		0xad77
		},
		{
		0x8db5,
		0xd3e5
		},
		{
		0x8db6,
		0xd3e7
		},
		{
		0x8db7,
		0xd3e6
		},
		{
		0x8db9,
		0xd7d8
		},
		{
		0x8dba,
		0xb36c
		},
		{
		0x8dbc,
		0xd7d6
		},
		{
		0x8dbe,
		0xb36b
		},
		{
		0x8dbf,
		0xd7d9
		},
		{
		0x8dc1,
		0xd7da
		},
		{
		0x8dc2,
		0xd7d7
		},
		{
		0x8dc5,
		0xdbfb
		},
		{
		0x8dc6,
		0xb660
		},
		{
		0x8dc7,
		0xdbf3
		},
		{
		0x8dc8,
		0xdbf9
		},
		{
		0x8dcb,
		0xb65b
		},
		{
		0x8dcc,
		0xb65e
		},
		{
		0x8dcd,
		0xdbf2
		},
		{
		0x8dce,
		0xb659
		},
		{
		0x8dcf,
		0xdbf6
		},
		{
		0x8dd0,
		0xe06c
		},
		{
		0x8dd1,
		0xb65d
		},
		{
		0x8dd3,
		0xdbf1
		},
		{
		0x8dd5,
		0xdbf7
		},
		{
		0x8dd6,
		0xdbf4
		},
		{
		0x8dd7,
		0xdbfa
		},
		{
		0x8dd8,
		0xdbf0
		},
		{
		0x8dd9,
		0xdbf8
		},
		{
		0x8dda,
		0xb65c
		},
		{
		0x8ddb,
		0xb65f
		},
		{
		0x8ddc,
		0xdbf5
		},
		{
		0x8ddd,
		0xb65a
		},
		{
		0x8ddf,
		0xb8f2
		},
		{
		0x8de0,
		0xe068
		},
		{
		0x8de1,
		0xb8f1
		},
		{
		0x8de2,
		0xe06f
		},
		{
		0x8de3,
		0xe06e
		},
		{
		0x8de4,
		0xb8f8
		},
		{
		0x8de6,
		0xb8f9
		},
		{
		0x8de7,
		0xe070
		},
		{
		0x8de8,
		0xb8f3
		},
		{
		0x8de9,
		0xe06d
		},
		{
		0x8dea,
		0xb8f7
		},
		{
		0x8deb,
		0xe072
		},
		{
		0x8dec,
		0xe069
		},
		{
		0x8dee,
		0xe06b
		},
		{
		0x8def,
		0xb8f4
		},
		{
		0x8df0,
		0xe067
		},
		{
		0x8df1,
		0xe06a
		},
		{
		0x8df2,
		0xe071
		},
		{
		0x8df3,
		0xb8f5
		},
		{
		0x8df4,
		0xe073
		},
		{
		0x8dfa,
		0xb8f6
		},
		{
		0x8dfc,
		0xbbb1
		},
		{
		0x8dfd,
		0xe45b
		},
		{
		0x8dfe,
		0xe461
		},
		{
		0x8dff,
		0xe459
		},
		{
		0x8e00,
		0xe462
		},
		{
		0x8e02,
		0xe458
		},
		{
		0x8e03,
		0xe45d
		},
		{
		0x8e04,
		0xe463
		},
		{
		0x8e05,
		0xe460
		},
		{
		0x8e06,
		0xe45f
		},
		{
		0x8e07,
		0xe45e
		},
		{
		0x8e09,
		0xe457
		},
		{
		0x8e0a,
		0xe45c
		},
		{
		0x8e0d,
		0xe45a
		},
		{
		0x8e0f,
		0xbdf1
		},
		{
		0x8e10,
		0xbdee
		},
		{
		0x8e11,
		0xe7fb
		},
		{
		0x8e12,
		0xe841
		},
		{
		0x8e13,
		0xe843
		},
		{
		0x8e14,
		0xe840
		},
		{
		0x8e15,
		0xe7f8
		},
		{
		0x8e16,
		0xe7fa
		},
		{
		0x8e17,
		0xe845
		},
		{
		0x8e18,
		0xe842
		},
		{
		0x8e19,
		0xe7fc
		},
		{
		0x8e1a,
		0xe846
		},
		{
		0x8e1b,
		0xe7f9
		},
		{
		0x8e1c,
		0xe844
		},
		{
		0x8e1d,
		0xbdef
		},
		{
		0x8e1e,
		0xbdf5
		},
		{
		0x8e1f,
		0xbdf3
		},
		{
		0x8e20,
		0xe7f3
		},
		{
		0x8e21,
		0xbdf4
		},
		{
		0x8e22,
		0xbdf0
		},
		{
		0x8e23,
		0xe7f4
		},
		{
		0x8e24,
		0xe7f6
		},
		{
		0x8e25,
		0xe7f5
		},
		{
		0x8e26,
		0xe7fd
		},
		{
		0x8e27,
		0xe7fe
		},
		{
		0x8e29,
		0xbdf2
		},
		{
		0x8e2b,
		0xbded
		},
		{
		0x8e2e,
		0xe7f7
		},
		{
		0x8e30,
		0xebc6
		},
		{
		0x8e31,
		0xbfe2
		},
		{
		0x8e33,
		0xebbd
		},
		{
		0x8e34,
		0xbfe3
		},
		{
		0x8e35,
		0xbfe6
		},
		{
		0x8e36,
		0xebc2
		},
		{
		0x8e38,
		0xebbf
		},
		{
		0x8e39,
		0xbfe5
		},
		{
		0x8e3c,
		0xebc3
		},
		{
		0x8e3d,
		0xebc4
		},
		{
		0x8e3e,
		0xebbe
		},
		{
		0x8e3f,
		0xebc7
		},
		{
		0x8e40,
		0xebc0
		},
		{
		0x8e41,
		0xebc5
		},
		{
		0x8e42,
		0xbfe4
		},
		{
		0x8e44,
		0xbfe1
		},
		{
		0x8e45,
		0xebc1
		},
		{
		0x8e47,
		0xeebf
		},
		{
		0x8e48,
		0xc1d0
		},
		{
		0x8e49,
		0xc1ce
		},
		{
		0x8e4a,
		0xc1d1
		},
		{
		0x8e4b,
		0xc1cf
		},
		{
		0x8e4c,
		0xeebe
		},
		{
		0x8e4d,
		0xeebb
		},
		{
		0x8e4e,
		0xeeba
		},
		{
		0x8e50,
		0xeebd
		},
		{
		0x8e53,
		0xeebc
		},
		{
		0x8e54,
		0xf145
		},
		{
		0x8e55,
		0xc2de
		},
		{
		0x8e56,
		0xf0fb
		},
		{
		0x8e57,
		0xf0fa
		},
		{
		0x8e59,
		0xc2d9
		},
		{
		0x8e5a,
		0xf141
		},
		{
		0x8e5b,
		0xf140
		},
		{
		0x8e5c,
		0xf0f7
		},
		{
		0x8e5d,
		0xf143
		},
		{
		0x8e5e,
		0xf0fc
		},
		{
		0x8e5f,
		0xc2dd
		},
		{
		0x8e60,
		0xf0f9
		},
		{
		0x8e61,
		0xf142
		},
		{
		0x8e62,
		0xf0f8
		},
		{
		0x8e63,
		0xc2da
		},
		{
		0x8e64,
		0xc2dc
		},
		{
		0x8e65,
		0xf0fd
		},
		{
		0x8e66,
		0xc2db
		},
		{
		0x8e67,
		0xf0fe
		},
		{
		0x8e69,
		0xf144
		},
		{
		0x8e6a,
		0xf352
		},
		{
		0x8e6c,
		0xc3de
		},
		{
		0x8e6d,
		0xf34f
		},
		{
		0x8e6f,
		0xf353
		},
		{
		0x8e72,
		0xc3db
		},
		{
		0x8e73,
		0xf351
		},
		{
		0x8e74,
		0xc3e0
		},
		{
		0x8e76,
		0xc3dd
		},
		{
		0x8e78,
		0xf350
		},
		{
		0x8e7a,
		0xc3df
		},
		{
		0x8e7b,
		0xf354
		},
		{
		0x8e7c,
		0xc3da
		},
		{
		0x8e81,
		0xc4bc
		},
		{
		0x8e82,
		0xc4be
		},
		{
		0x8e84,
		0xf4d9
		},
		{
		0x8e85,
		0xc4bd
		},
		{
		0x8e86,
		0xf4d7
		},
		{
		0x8e87,
		0xc3dc
		},
		{
		0x8e88,
		0xf4d8
		},
		{
		0x8e89,
		0xc4bb
		},
		{
		0x8e8a,
		0xc543
		},
		{
		0x8e8b,
		0xc545
		},
		{
		0x8e8c,
		0xf656
		},
		{
		0x8e8d,
		0xc544
		},
		{
		0x8e8e,
		0xf655
		},
		{
		0x8e90,
		0xf761
		},
		{
		0x8e91,
		0xc5ad
		},
		{
		0x8e92,
		0xf760
		},
		{
		0x8e93,
		0xc5ae
		},
		{
		0x8e94,
		0xf75e
		},
		{
		0x8e95,
		0xf75d
		},
		{
		0x8e96,
		0xf762
		},
		{
		0x8e97,
		0xf763
		},
		{
		0x8e98,
		0xf846
		},
		{
		0x8e9a,
		0xf75f
		},
		{
		0x8e9d,
		0xf8c6
		},
		{
		0x8e9e,
		0xf8c3
		},
		{
		0x8e9f,
		0xf8c4
		},
		{
		0x8ea0,
		0xf8c5
		},
		{
		0x8ea1,
		0xc65c
		},
		{
		0x8ea3,
		0xf951
		},
		{
		0x8ea4,
		0xf950
		},
		{
		0x8ea5,
		0xf94f
		},
		{
		0x8ea6,
		0xf970
		},
		{
		0x8ea8,
		0xf9be
		},
		{
		0x8ea9,
		0xf9ab
		},
		{
		0x8eaa,
		0xc66e
		},
		{
		0x8eab,
		0xa8ad
		},
		{
		0x8eac,
		0xb060
		},
		{
		0x8eb2,
		0xb8fa
		},
		{
		0x8eba,
		0xbdf6
		},
		{
		0x8ebd,
		0xebc8
		},
		{
		0x8ec0,
		0xc2df
		},
		{
		0x8ec2,
		0xf355
		},
		{
		0x8ec9,
		0xf9ac
		},
		{
		0x8eca,
		0xa8ae
		},
		{
		0x8ecb,
		0xaaee
		},
		{
		0x8ecc,
		0xad79
		},
		{
		0x8ecd,
		0xad78
		},
		{
		0x8ecf,
		0xb063
		},
		{
		0x8ed1,
		0xd3e8
		},
		{
		0x8ed2,
		0xb061
		},
		{
		0x8ed3,
		0xd3e9
		},
		{
		0x8ed4,
		0xb062
		},
		{
		0x8ed7,
		0xd7df
		},
		{
		0x8ed8,
		0xd7db
		},
		{
		0x8edb,
		0xb36d
		},
		{
		0x8edc,
		0xd7de
		},
		{
		0x8edd,
		0xd7dd
		},
		{
		0x8ede,
		0xd7dc
		},
		{
		0x8edf,
		0xb36e
		},
		{
		0x8ee0,
		0xd7e0
		},
		{
		0x8ee1,
		0xd7e1
		},
		{
		0x8ee5,
		0xdc43
		},
		{
		0x8ee6,
		0xdc41
		},
		{
		0x8ee7,
		0xdc45
		},
		{
		0x8ee8,
		0xdc46
		},
		{
		0x8ee9,
		0xdc4c
		},
		{
		0x8eeb,
		0xdc48
		},
		{
		0x8eec,
		0xdc4a
		},
		{
		0x8eee,
		0xdc42
		},
		{
		0x8eef,
		0xdbfc
		},
		{
		0x8ef1,
		0xdc49
		},
		{
		0x8ef4,
		0xdc4b
		},
		{
		0x8ef5,
		0xdc44
		},
		{
		0x8ef6,
		0xdc47
		},
		{
		0x8ef7,
		0xdbfd
		},
		{
		0x8ef8,
		0xb662
		},
		{
		0x8ef9,
		0xdc40
		},
		{
		0x8efa,
		0xdbfe
		},
		{
		0x8efb,
		0xb661
		},
		{
		0x8efc,
		0xb663
		},
		{
		0x8efe,
		0xb8fd
		},
		{
		0x8eff,
		0xe075
		},
		{
		0x8f00,
		0xe077
		},
		{
		0x8f01,
		0xe076
		},
		{
		0x8f02,
		0xe07b
		},
		{
		0x8f03,
		0xb8fb
		},
		{
		0x8f05,
		0xe078
		},
		{
		0x8f06,
		0xe074
		},
		{
		0x8f07,
		0xe079
		},
		{
		0x8f08,
		0xe07a
		},
		{
		0x8f09,
		0xb8fc
		},
		{
		0x8f0a,
		0xb8fe
		},
		{
		0x8f0b,
		0xe07c
		},
		{
		0x8f0d,
		0xe467
		},
		{
		0x8f0e,
		0xe466
		},
		{
		0x8f10,
		0xe464
		},
		{
		0x8f11,
		0xe465
		},
		{
		0x8f12,
		0xbbb3
		},
		{
		0x8f13,
		0xbbb5
		},
		{
		0x8f14,
		0xbbb2
		},
		{
		0x8f15,
		0xbbb4
		},
		{
		0x8f16,
		0xe84d
		},
		{
		0x8f17,
		0xe84e
		},
		{
		0x8f18,
		0xe849
		},
		{
		0x8f1a,
		0xe84a
		},
		{
		0x8f1b,
		0xbdf8
		},
		{
		0x8f1c,
		0xbdfd
		},
		{
		0x8f1d,
		0xbdf7
		},
		{
		0x8f1e,
		0xbdfe
		},
		{
		0x8f1f,
		0xbdf9
		},
		{
		0x8f20,
		0xe84b
		},
		{
		0x8f23,
		0xe84c
		},
		{
		0x8f24,
		0xe848
		},
		{
		0x8f25,
		0xbe40
		},
		{
		0x8f26,
		0xbdfb
		},
		{
		0x8f29,
		0xbdfa
		},
		{
		0x8f2a,
		0xbdfc
		},
		{
		0x8f2c,
		0xe847
		},
		{
		0x8f2e,
		0xebca
		},
		{
		0x8f2f,
		0xbfe8
		},
		{
		0x8f32,
		0xebcc
		},
		{
		0x8f33,
		0xbfea
		},
		{
		0x8f34,
		0xebcf
		},
		{
		0x8f35,
		0xebcb
		},
		{
		0x8f36,
		0xebc9
		},
		{
		0x8f37,
		0xebce
		},
		{
		0x8f38,
		0xbfe9
		},
		{
		0x8f39,
		0xebcd
		},
		{
		0x8f3b,
		0xbfe7
		},
		{
		0x8f3e,
		0xc1d3
		},
		{
		0x8f3f,
		0xc1d6
		},
		{
		0x8f40,
		0xeec1
		},
		{
		0x8f42,
		0xc1d4
		},
		{
		0x8f43,
		0xeec0
		},
		{
		0x8f44,
		0xc1d2
		},
		{
		0x8f45,
		0xc1d5
		},
		{
		0x8f46,
		0xf146
		},
		{
		0x8f47,
		0xf147
		},
		{
		0x8f48,
		0xf148
		},
		{
		0x8f49,
		0xc2e0
		},
		{
		0x8f4b,
		0xf149
		},
		{
		0x8f4d,
		0xc2e1
		},
		{
		0x8f4e,
		0xc3e2
		},
		{
		0x8f4f,
		0xf358
		},
		{
		0x8f50,
		0xf359
		},
		{
		0x8f51,
		0xf357
		},
		{
		0x8f52,
		0xf356
		},
		{
		0x8f53,
		0xf35a
		},
		{
		0x8f54,
		0xc3e1
		},
		{
		0x8f55,
		0xf4dd
		},
		{
		0x8f56,
		0xf4db
		},
		{
		0x8f57,
		0xf4dc
		},
		{
		0x8f58,
		0xf4de
		},
		{
		0x8f59,
		0xf4da
		},
		{
		0x8f5a,
		0xf4df
		},
		{
		0x8f5b,
		0xf658
		},
		{
		0x8f5d,
		0xf659
		},
		{
		0x8f5e,
		0xf657
		},
		{
		0x8f5f,
		0xc546
		},
		{
		0x8f60,
		0xf764
		},
		{
		0x8f61,
		0xc5af
		},
		{
		0x8f62,
		0xf765
		},
		{
		0x8f63,
		0xf848
		},
		{
		0x8f64,
		0xf847
		},
		{
		0x8f9b,
		0xa8af
		},
		{
		0x8f9c,
		0xb664
		},
		{
		0x8f9f,
		0xb940
		},
		{
		0x8fa3,
		0xbbb6
		},
		{
		0x8fa6,
		0xbfec
		},
		{
		0x8fa8,
		0xbfeb
		},
		{
		0x8fad,
		0xc3e3
		},
		{
		0x8fae,
		0xc47c
		},
		{
		0x8faf,
		0xc547
		},
		{
		0x8fb0,
		0xa8b0
		},
		{
		0x8fb1,
		0xb064
		},
		{
		0x8fb2,
		0xb941
		},
		{
		0x8fb4,
		0xf35b
		},
		{
		0x8fbf,
		0xcba6
		},
		{
		0x8fc2,
		0xa8b1
		},
		{
		0x8fc4,
		0xa8b4
		},
		{
		0x8fc5,
		0xa8b3
		},
		{
		0x8fc6,
		0xa8b2
		},
		{
		0x8fc9,
		0xcba5
		},
		{
		0x8fcb,
		0xcdcd
		},
		{
		0x8fcd,
		0xcdcf
		},
		{
		0x8fce,
		0xaaef
		},
		{
		0x8fd1,
		0xaaf1
		},
		{
		0x8fd2,
		0xcdcc
		},
		{
		0x8fd3,
		0xcdce
		},
		{
		0x8fd4,
		0xaaf0
		},
		{
		0x8fd5,
		0xcdd1
		},
		{
		0x8fd6,
		0xcdd0
		},
		{
		0x8fd7,
		0xcdd2
		},
		{
		0x8fe0,
		0xd0b6
		},
		{
		0x8fe1,
		0xd0b4
		},
		{
		0x8fe2,
		0xad7c
		},
		{
		0x8fe3,
		0xd0b3
		},
		{
		0x8fe4,
		0xada3
		},
		{
		0x8fe5,
		0xad7e
		},
		{
		0x8fe6,
		0xad7b
		},
		{
		0x8fe8,
		0xada4
		},
		{
		0x8fea,
		0xad7d
		},
		{
		0x8feb,
		0xada2
		},
		{
		0x8fed,
		0xada1
		},
		{
		0x8fee,
		0xd0b5
		},
		{
		0x8ff0,
		0xad7a
		},
		{
		0x8ff4,
		0xb06a
		},
		{
		0x8ff5,
		0xd3eb
		},
		{
		0x8ff6,
		0xd3f1
		},
		{
		0x8ff7,
		0xb067
		},
		{
		0x8ff8,
		0xb06e
		},
		{
		0x8ffa,
		0xb069
		},
		{
		0x8ffb,
		0xd3ee
		},
		{
		0x8ffc,
		0xd3f0
		},
		{
		0x8ffd,
		0xb06c
		},
		{
		0x8ffe,
		0xd3ea
		},
		{
		0x8fff,
		0xd3ed
		},
		{
		0x9000,
		0xb068
		},
		{
		0x9001,
		0xb065
		},
		{
		0x9002,
		0xd3ec
		},
		{
		0x9003,
		0xb06b
		},
		{
		0x9004,
		0xd3ef
		},
		{
		0x9005,
		0xb06d
		},
		{
		0x9006,
		0xb066
		},
		{
		0x900b,
		0xd7e3
		},
		{
		0x900c,
		0xd7e6
		},
		{
		0x900d,
		0xb370
		},
		{
		0x900f,
		0xb37a
		},
		{
		0x9010,
		0xb376
		},
		{
		0x9011,
		0xd7e4
		},
		{
		0x9014,
		0xb37e
		},
		{
		0x9015,
		0xb377
		},
		{
		0x9016,
		0xb37c
		},
		{
		0x9017,
		0xb372
		},
		{
		0x9019,
		0xb36f
		},
		{
		0x901a,
		0xb371
		},
		{
		0x901b,
		0xb37d
		},
		{
		0x901c,
		0xd7e5
		},
		{
		0x901d,
		0xb375
		},
		{
		0x901e,
		0xb378
		},
		{
		0x901f,
		0xb374
		},
		{
		0x9020,
		0xb379
		},
		{
		0x9021,
		0xd7e7
		},
		{
		0x9022,
		0xb37b
		},
		{
		0x9023,
		0xb373
		},
		{
		0x9024,
		0xd7e2
		},
		{
		0x902d,
		0xdc4d
		},
		{
		0x902e,
		0xb665
		},
		{
		0x902f,
		0xdc4f
		},
		{
		0x9031,
		0xb667
		},
		{
		0x9032,
		0xb669
		},
		{
		0x9034,
		0xdc4e
		},
		{
		0x9035,
		0xb666
		},
		{
		0x9036,
		0xb66a
		},
		{
		0x9038,
		0xb668
		},
		{
		0x903c,
		0xb947
		},
		{
		0x903d,
		0xe0a3
		},
		{
		0x903e,
		0xb94f
		},
		{
		0x903f,
		0xe07e
		},
		{
		0x9041,
		0xb950
		},
		{
		0x9042,
		0xb945
		},
		{
		0x9044,
		0xe0a1
		},
		{
		0x9047,
		0xb94a
		},
		{
		0x9049,
		0xe0a2
		},
		{
		0x904a,
		0xb943
		},
		{
		0x904b,
		0xb942
		},
		{
		0x904d,
		0xb94d
		},
		{
		0x904e,
		0xb94c
		},
		{
		0x904f,
		0xb94b
		},
		{
		0x9050,
		0xb949
		},
		{
		0x9051,
		0xb94e
		},
		{
		0x9052,
		0xe07d
		},
		{
		0x9053,
		0xb944
		},
		{
		0x9054,
		0xb946
		},
		{
		0x9055,
		0xb948
		},
		{
		0x9058,
		0xbbb8
		},
		{
		0x9059,
		0xbbbb
		},
		{
		0x905b,
		0xbbbf
		},
		{
		0x905c,
		0xbbb9
		},
		{
		0x905d,
		0xbbbe
		},
		{
		0x905e,
		0xbbbc
		},
		{
		0x9060,
		0xbbb7
		},
		{
		0x9062,
		0xbbbd
		},
		{
		0x9063,
		0xbbba
		},
		{
		0x9067,
		0xe852
		},
		{
		0x9068,
		0xbe43
		},
		{
		0x9069,
		0xbe41
		},
		{
		0x906b,
		0xe853
		},
		{
		0x906d,
		0xbe44
		},
		{
		0x906e,
		0xbe42
		},
		{
		0x906f,
		0xe851
		},
		{
		0x9070,
		0xe850
		},
		{
		0x9072,
		0xbff0
		},
		{
		0x9073,
		0xe84f
		},
		{
		0x9074,
		0xbfee
		},
		{
		0x9075,
		0xbfed
		},
		{
		0x9076,
		0xebd0
		},
		{
		0x9077,
		0xbe45
		},
		{
		0x9078,
		0xbfef
		},
		{
		0x9079,
		0xebd1
		},
		{
		0x907a,
		0xbff2
		},
		{
		0x907b,
		0xebd2
		},
		{
		0x907c,
		0xbff1
		},
		{
		0x907d,
		0xc1d8
		},
		{
		0x907e,
		0xeec3
		},
		{
		0x907f,
		0xc1d7
		},
		{
		0x9080,
		0xc1dc
		},
		{
		0x9081,
		0xc1da
		},
		{
		0x9082,
		0xc1db
		},
		{
		0x9083,
		0xc2e3
		},
		{
		0x9084,
		0xc1d9
		},
		{
		0x9085,
		0xeec2
		},
		{
		0x9086,
		0xebd3
		},
		{
		0x9087,
		0xc2e2
		},
		{
		0x9088,
		0xc2e4
		},
		{
		0x908a,
		0xc3e4
		},
		{
		0x908b,
		0xc3e5
		},
		{
		0x908d,
		0xf4e0
		},
		{
		0x908f,
		0xc5de
		},
		{
		0x9090,
		0xc5dd
		},
		{
		0x9091,
		0xa8b6
		},
		{
		0x9094,
		0xca55
		},
		{
		0x9095,
		0xb06f
		},
		{
		0x9097,
		0xca52
		},
		{
		0x9098,
		0xca53
		},
		{
		0x9099,
		0xca51
		},
		{
		0x909b,
		0xca54
		},
		{
		0x909e,
		0xcbaa
		},
		{
		0x909f,
		0xcba7
		},
		{
		0x90a0,
		0xcbac
		},
		{
		0x90a1,
		0xcba8
		},
		{
		0x90a2,
		0xa8b7
		},
		{
		0x90a3,
		0xa8ba
		},
		{
		0x90a5,
		0xcba9
		},
		{
		0x90a6,
		0xa8b9
		},
		{
		0x90a7,
		0xcbab
		},
		{
		0x90aa,
		0xa8b8
		},
		{
		0x90af,
		0xcdd5
		},
		{
		0x90b0,
		0xcdd7
		},
		{
		0x90b1,
		0xaaf4
		},
		{
		0x90b2,
		0xcdd3
		},
		{
		0x90b3,
		0xcdd6
		},
		{
		0x90b4,
		0xcdd4
		},
		{
		0x90b5,
		0xaaf2
		},
		{
		0x90b6,
		0xaaf5
		},
		{
		0x90b8,
		0xaaf3
		},
		{
		0x90bd,
		0xd0b8
		},
		{
		0x90be,
		0xd0bc
		},
		{
		0x90bf,
		0xd0b9
		},
		{
		0x90c1,
		0xada7
		},
		{
		0x90c3,
		0xada8
		},
		{
		0x90c5,
		0xd0bb
		},
		{
		0x90c7,
		0xd0bd
		},
		{
		0x90c8,
		0xd0bf
		},
		{
		0x90ca,
		0xada5
		},
		{
		0x90cb,
		0xd0be
		},
		{
		0x90ce,
		0xada6
		},
		{
		0x90d4,
		0xd7ee
		},
		{
		0x90d5,
		0xd0ba
		},
		{
		0x90d6,
		0xd3f2
		},
		{
		0x90d7,
		0xd3fb
		},
		{
		0x90d8,
		0xd3f9
		},
		{
		0x90d9,
		0xd3f4
		},
		{
		0x90da,
		0xd3f5
		},
		{
		0x90db,
		0xd3fa
		},
		{
		0x90dc,
		0xd3fc
		},
		{
		0x90dd,
		0xb071
		},
		{
		0x90df,
		0xd3f7
		},
		{
		0x90e0,
		0xd3f3
		},
		{
		0x90e1,
		0xb070
		},
		{
		0x90e2,
		0xb072
		},
		{
		0x90e3,
		0xd3f6
		},
		{
		0x90e4,
		0xd3fd
		},
		{
		0x90e5,
		0xd3f8
		},
		{
		0x90e8,
		0xb3a1
		},
		{
		0x90e9,
		0xd7f1
		},
		{
		0x90ea,
		0xd7e9
		},
		{
		0x90eb,
		0xd7ef
		},
		{
		0x90ec,
		0xd7f0
		},
		{
		0x90ed,
		0xb3a2
		},
		{
		0x90ef,
		0xd7e8
		},
		{
		0x90f0,
		0xd7ea
		},
		{
		0x90f1,
		0xd0b7
		},
		{
		0x90f2,
		0xd7ec
		},
		{
		0x90f3,
		0xd7ed
		},
		{
		0x90f4,
		0xd7eb
		},
		{
		0x90f5,
		0xb66c
		},
		{
		0x90f9,
		0xdc56
		},
		{
		0x90fa,
		0xebd4
		},
		{
		0x90fb,
		0xdc57
		},
		{
		0x90fc,
		0xdc54
		},
		{
		0x90fd,
		0xb3a3
		},
		{
		0x90fe,
		0xb66e
		},
		{
		0x90ff,
		0xdc53
		},
		{
		0x9100,
		0xdc59
		},
		{
		0x9101,
		0xdc58
		},
		{
		0x9102,
		0xb66b
		},
		{
		0x9103,
		0xdc5c
		},
		{
		0x9104,
		0xdc52
		},
		{
		0x9105,
		0xdc5b
		},
		{
		0x9106,
		0xdc50
		},
		{
		0x9107,
		0xdc5a
		},
		{
		0x9108,
		0xdc55
		},
		{
		0x9109,
		0xb66d
		},
		{
		0x910b,
		0xe0aa
		},
		{
		0x910d,
		0xe0a5
		},
		{
		0x910e,
		0xe0ab
		},
		{
		0x910f,
		0xe0a6
		},
		{
		0x9110,
		0xe0a4
		},
		{
		0x9111,
		0xe0a7
		},
		{
		0x9112,
		0xb951
		},
		{
		0x9114,
		0xe0a9
		},
		{
		0x9116,
		0xe0a8
		},
		{
		0x9117,
		0xb952
		},
		{
		0x9118,
		0xbbc1
		},
		{
		0x9119,
		0xbbc0
		},
		{
		0x911a,
		0xe46e
		},
		{
		0x911b,
		0xe471
		},
		{
		0x911c,
		0xe469
		},
		{
		0x911d,
		0xe46d
		},
		{
		0x911e,
		0xbbc2
		},
		{
		0x911f,
		0xe46c
		},
		{
		0x9120,
		0xe46a
		},
		{
		0x9121,
		0xe470
		},
		{
		0x9122,
		0xe46b
		},
		{
		0x9123,
		0xe468
		},
		{
		0x9124,
		0xe46f
		},
		{
		0x9126,
		0xe859
		},
		{
		0x9127,
		0xbe48
		},
		{
		0x9128,
		0xf14a
		},
		{
		0x9129,
		0xe856
		},
		{
		0x912a,
		0xe857
		},
		{
		0x912b,
		0xe855
		},
		{
		0x912c,
		0xdc51
		},
		{
		0x912d,
		0xbe47
		},
		{
		0x912e,
		0xe85a
		},
		{
		0x912f,
		0xe854
		},
		{
		0x9130,
		0xbe46
		},
		{
		0x9131,
		0xbe49
		},
		{
		0x9132,
		0xe858
		},
		{
		0x9133,
		0xebd5
		},
		{
		0x9134,
		0xbff3
		},
		{
		0x9135,
		0xebd6
		},
		{
		0x9136,
		0xebd7
		},
		{
		0x9138,
		0xeec4
		},
		{
		0x9139,
		0xc1dd
		},
		{
		0x913a,
		0xf14b
		},
		{
		0x913b,
		0xf14c
		},
		{
		0x913e,
		0xf14d
		},
		{
		0x913f,
		0xf35d
		},
		{
		0x9140,
		0xf35c
		},
		{
		0x9141,
		0xf4e2
		},
		{
		0x9143,
		0xf4e1
		},
		{
		0x9144,
		0xf65b
		},
		{
		0x9145,
		0xf65c
		},
		{
		0x9146,
		0xf65a
		},
		{
		0x9147,
		0xf766
		},
		{
		0x9148,
		0xc5b0
		},
		{
		0x9149,
		0xa8bb
		},
		{
		0x914a,
		0xadaa
		},
		{
		0x914b,
		0xada9
		},
		{
		0x914c,
		0xb075
		},
		{
		0x914d,
		0xb074
		},
		{
		0x914e,
		0xd440
		},
		{
		0x914f,
		0xd441
		},
		{
		0x9150,
		0xd3fe
		},
		{
		0x9152,
		0xb073
		},
		{
		0x9153,
		0xd7f5
		},
		{
		0x9155,
		0xd7f6
		},
		{
		0x9156,
		0xd7f2
		},
		{
		0x9157,
		0xb3a4
		},
		{
		0x9158,
		0xd7f3
		},
		{
		0x915a,
		0xd7f4
		},
		{
		0x915f,
		0xdc5f
		},
		{
		0x9160,
		0xdc61
		},
		{
		0x9161,
		0xdc5d
		},
		{
		0x9162,
		0xdc60
		},
		{
		0x9163,
		0xb66f
		},
		{
		0x9164,
		0xdc5e
		},
		{
		0x9165,
		0xb670
		},
		{
		0x9168,
		0xdd73
		},
		{
		0x9169,
		0xb955
		},
		{
		0x916a,
		0xb954
		},
		{
		0x916c,
		0xb953
		},
		{
		0x916e,
		0xe0ac
		},
		{
		0x916f,
		0xe0ad
		},
		{
		0x9172,
		0xe473
		},
		{
		0x9173,
		0xe475
		},
		{
		0x9174,
		0xbbc6
		},
		{
		0x9175,
		0xbbc3
		},
		{
		0x9177,
		0xbbc5
		},
		{
		0x9178,
		0xbbc4
		},
		{
		0x9179,
		0xe474
		},
		{
		0x917a,
		0xe472
		},
		{
		0x9180,
		0xe861
		},
		{
		0x9181,
		0xe85e
		},
		{
		0x9182,
		0xe85f
		},
		{
		0x9183,
		0xbe4d
		},
		{
		0x9184,
		0xe860
		},
		{
		0x9185,
		0xe85b
		},
		{
		0x9186,
		0xe85c
		},
		{
		0x9187,
		0xbe4a
		},
		{
		0x9189,
		0xbe4b
		},
		{
		0x918a,
		0xe85d
		},
		{
		0x918b,
		0xbe4c
		},
		{
		0x918d,
		0xebdb
		},
		{
		0x918f,
		0xebdc
		},
		{
		0x9190,
		0xebd9
		},
		{
		0x9191,
		0xebda
		},
		{
		0x9192,
		0xbff4
		},
		{
		0x9193,
		0xebd8
		},
		{
		0x9199,
		0xeec8
		},
		{
		0x919a,
		0xeec5
		},
		{
		0x919b,
		0xeec7
		},
		{
		0x919c,
		0xc1e0
		},
		{
		0x919d,
		0xeecb
		},
		{
		0x919e,
		0xc1df
		},
		{
		0x919f,
		0xeec9
		},
		{
		0x91a0,
		0xeecc
		},
		{
		0x91a1,
		0xeeca
		},
		{
		0x91a2,
		0xeec6
		},
		{
		0x91a3,
		0xc1de
		},
		{
		0x91a5,
		0xf14f
		},
		{
		0x91a7,
		0xf150
		},
		{
		0x91a8,
		0xf14e
		},
		{
		0x91aa,
		0xf152
		},
		{
		0x91ab,
		0xc2e5
		},
		{
		0x91ac,
		0xc2e6
		},
		{
		0x91ad,
		0xf35f
		},
		{
		0x91ae,
		0xc3e7
		},
		{
		0x91af,
		0xf151
		},
		{
		0x91b0,
		0xf35e
		},
		{
		0x91b1,
		0xc3e6
		},
		{
		0x91b2,
		0xf4e5
		},
		{
		0x91b3,
		0xf4e6
		},
		{
		0x91b4,
		0xc4bf
		},
		{
		0x91b5,
		0xf4e4
		},
		{
		0x91b7,
		0xf4e3
		},
		{
		0x91b9,
		0xf65d
		},
		{
		0x91ba,
		0xc548
		},
		{
		0x91bc,
		0xf849
		},
		{
		0x91bd,
		0xf8c8
		},
		{
		0x91be,
		0xf8c7
		},
		{
		0x91c0,
		0xc643
		},
		{
		0x91c1,
		0xc65d
		},
		{
		0x91c2,
		0xf8c9
		},
		{
		0x91c3,
		0xf971
		},
		{
		0x91c5,
		0xc66f
		},
		{
		0x91c6,
		0xa8bc
		},
		{
		0x91c7,
		0xaaf6
		},
		{
		0x91c9,
		0xb956
		},
		{
		0x91cb,
		0xc4c0
		},
		{
		0x91cc,
		0xa8bd
		},
		{
		0x91cd,
		0xadab
		},
		{
		0x91ce,
		0xb3a5
		},
		{
		0x91cf,
		0xb671
		},
		{
		0x91d0,
		0xc2e7
		},
		{
		0x91d1,
		0xaaf7
		},
		{
		0x91d3,
		0xd0c1
		},
		{
		0x91d4,
		0xd0c0
		},
		{
		0x91d5,
		0xd442
		},
		{
		0x91d7,
		0xb078
		},
		{
		0x91d8,
		0xb076
		},
		{
		0x91d9,
		0xb07a
		},
		{
		0x91da,
		0xd444
		},
		{
		0x91dc,
		0xb079
		},
		{
		0x91dd,
		0xb077
		},
		{
		0x91e2,
		0xd443
		},
		{
		0x91e3,
		0xb3a8
		},
		{
		0x91e4,
		0xd7fc
		},
		{
		0x91e6,
		0xb3a7
		},
		{
		0x91e7,
		0xb3a9
		},
		{
		0x91e8,
		0xd842
		},
		{
		0x91e9,
		0xb3ab
		},
		{
		0x91ea,
		0xd7fe
		},
		{
		0x91eb,
		0xd840
		},
		{
		0x91ec,
		0xd7f7
		},
		{
		0x91ed,
		0xb3aa
		},
		{
		0x91ee,
		0xd843
		},
		{
		0x91f1,
		0xd7f9
		},
		{
		0x91f3,
		0xd7fa
		},
		{
		0x91f4,
		0xd7f8
		},
		{
		0x91f5,
		0xb3a6
		},
		{
		0x91f7,
		0xd841
		},
		{
		0x91f8,
		0xd7fb
		},
		{
		0x91f9,
		0xd7fd
		},
		{
		0x91fd,
		0xdc6d
		},
		{
		0x91ff,
		0xdc6c
		},
		{
		0x9200,
		0xdc6a
		},
		{
		0x9201,
		0xdc62
		},
		{
		0x9202,
		0xdc71
		},
		{
		0x9203,
		0xdc65
		},
		{
		0x9204,
		0xdc6f
		},
		{
		0x9205,
		0xdc76
		},
		{
		0x9206,
		0xdc6e
		},
		{
		0x9207,
		0xb679
		},
		{
		0x9209,
		0xb675
		},
		{
		0x920a,
		0xdc63
		},
		{
		0x920c,
		0xdc69
		},
		{
		0x920d,
		0xb677
		},
		{
		0x920f,
		0xdc68
		},
		{
		0x9210,
		0xb678
		},
		{
		0x9211,
		0xb67a
		},
		{
		0x9212,
		0xdc6b
		},
		{
		0x9214,
		0xb672
		},
		{
		0x9215,
		0xb673
		},
		{
		0x9216,
		0xdc77
		},
		{
		0x9217,
		0xdc75
		},
		{
		0x9219,
		0xdc74
		},
		{
		0x921a,
		0xdc66
		},
		{
		0x921c,
		0xdc72
		},
		{
		0x921e,
		0xb676
		},
		{
		0x9223,
		0xb674
		},
		{
		0x9224,
		0xdc73
		},
		{
		0x9225,
		0xdc64
		},
		{
		0x9226,
		0xdc67
		},
		{
		0x9227,
		0xdc70
		},
		{
		0x922d,
		0xe4ba
		},
		{
		0x922e,
		0xe0b7
		},
		{
		0x9230,
		0xe0b0
		},
		{
		0x9231,
		0xe0c3
		},
		{
		0x9232,
		0xe0cc
		},
		{
		0x9233,
		0xe0b3
		},
		{
		0x9234,
		0xb961
		},
		{
		0x9236,
		0xe0c0
		},
		{
		0x9237,
		0xb957
		},
		{
		0x9238,
		0xb959
		},
		{
		0x9239,
		0xb965
		},
		{
		0x923a,
		0xe0b1
		},
		{
		0x923d,
		0xb95a
		},
		{
		0x923e,
		0xb95c
		},
		{
		0x923f,
		0xb966
		},
		{
		0x9240,
		0xb95b
		},
		{
		0x9245,
		0xb964
		},
		{
		0x9246,
		0xe0b9
		},
		{
		0x9248,
		0xe0ae
		},
		{
		0x9249,
		0xb962
		},
		{
		0x924a,
		0xe0b8
		},
		{
		0x924b,
		0xb95e
		},
		{
		0x924c,
		0xe0ca
		},
		{
		0x924d,
		0xb963
		},
		{
		0x924e,
		0xe0c8
		},
		{
		0x924f,
		0xe0bc
		},
		{
		0x9250,
		0xe0c6
		},
		{
		0x9251,
		0xb960
		},
		{
		0x9252,
		0xe0af
		},
		{
		0x9253,
		0xe0c9
		},
		{
		0x9254,
		0xe0c4
		},
		{
		0x9256,
		0xe0cb
		},
		{
		0x9257,
		0xb958
		},
		{
		0x925a,
		0xb967
		},
		{
		0x925b,
		0xb95d
		},
		{
		0x925e,
		0xe0b5
		},
		{
		0x9260,
		0xe0bd
		},
		{
		0x9261,
		0xe0c1
		},
		{
		0x9263,
		0xe0c5
		},
		{
		0x9264,
		0xb95f
		},
		{
		0x9265,
		0xe0b4
		},
		{
		0x9266,
		0xe0b2
		},
		{
		0x9267,
		0xe0be
		},
		{
		0x926c,
		0xe0bb
		},
		{
		0x926d,
		0xe0ba
		},
		{
		0x926f,
		0xe0bf
		},
		{
		0x9270,
		0xe0c2
		},
		{
		0x9272,
		0xe0c7
		},
		{
		0x9276,
		0xe478
		},
		{
		0x9278,
		0xbbc7
		},
		{
		0x9279,
		0xe4a4
		},
		{
		0x927a,
		0xe47a
		},
		{
		0x927b,
		0xbbcc
		},
		{
		0x927c,
		0xbbd0
		},
		{
		0x927d,
		0xe4ad
		},
		{
		0x927e,
		0xe4b5
		},
		{
		0x927f,
		0xe4a6
		},
		{
		0x9280,
		0xbbc8
		},
		{
		0x9282,
		0xe4aa
		},
		{
		0x9283,
		0xe0b6
		},
		{
		0x9285,
		0xbbc9
		},
		{
		0x9286,
		0xe4b1
		},
		{
		0x9287,
		0xe4b6
		},
		{
		0x9288,
		0xe4ae
		},
		{
		0x928a,
		0xe4b0
		},
		{
		0x928b,
		0xe4b9
		},
		{
		0x928c,
		0xe4b2
		},
		{
		0x928d,
		0xe47e
		},
		{
		0x928e,
		0xe4a9
		},
		{
		0x9291,
		0xbbd1
		},
		{
		0x9293,
		0xbbcd
		},
		{
		0x9294,
		0xe47c
		},
		{
		0x9295,
		0xe4ab
		},
		{
		0x9296,
		0xbbcb
		},
		{
		0x9297,
		0xe4a5
		},
		{
		0x9298,
		0xbbca
		},
		{
		0x9299,
		0xe4b3
		},
		{
		0x929a,
		0xe4a2
		},
		{
		0x929b,
		0xe479
		},
		{
		0x929c,
		0xbbce
		},
		{
		0x929d,
		0xe4b8
		},
		{
		0x92a0,
		0xe47b
		},
		{
		0x92a1,
		0xe4af
		},
		{
		0x92a2,
		0xe4ac
		},
		{
		0x92a3,
		0xe4a7
		},
		{
		0x92a4,
		0xe477
		},
		{
		0x92a5,
		0xe476
		},
		{
		0x92a6,
		0xe4a1
		},
		{
		0x92a7,
		0xe4b4
		},
		{
		0x92a8,
		0xbbcf
		},
		{
		0x92a9,
		0xe4b7
		},
		{
		0x92aa,
		0xe47d
		},
		{
		0x92ab,
		0xe4a3
		},
		{
		0x92ac,
		0xbe52
		},
		{
		0x92b2,
		0xbe5a
		},
		{
		0x92b3,
		0xbe55
		},
		{
		0x92b4,
		0xe8a4
		},
		{
		0x92b5,
		0xe8a1
		},
		{
		0x92b6,
		0xe867
		},
		{
		0x92b7,
		0xbe50
		},
		{
		0x92bb,
		0xbe4f
		},
		{
		0x92bc,
		0xbe56
		},
		{
		0x92c0,
		0xe865
		},
		{
		0x92c1,
		0xbe54
		},
		{
		0x92c2,
		0xe871
		},
		{
		0x92c3,
		0xe863
		},
		{
		0x92c4,
		0xe864
		},
		{
		0x92c5,
		0xbe4e
		},
		{
		0x92c6,
		0xe8a3
		},
		{
		0x92c7,
		0xbe58
		},
		{
		0x92c8,
		0xe874
		},
		{
		0x92c9,
		0xe879
		},
		{
		0x92ca,
		0xe873
		},
		{
		0x92cb,
		0xebee
		},
		{
		0x92cc,
		0xe86f
		},
		{
		0x92cd,
		0xe877
		},
		{
		0x92ce,
		0xe875
		},
		{
		0x92cf,
		0xe868
		},
		{
		0x92d0,
		0xe862
		},
		{
		0x92d1,
		0xe87d
		},
		{
		0x92d2,
		0xbe57
		},
		{
		0x92d3,
		0xe87e
		},
		{
		0x92d5,
		0xe878
		},
		{
		0x92d7,
		0xe86d
		},
		{
		0x92d8,
		0xe86b
		},
		{
		0x92d9,
		0xe866
		},
		{
		0x92dd,
		0xe86e
		},
		{
		0x92de,
		0xe87b
		},
		{
		0x92df,
		0xe86a
		},
		{
		0x92e0,
		0xe87a
		},
		{
		0x92e1,
		0xe8a2
		},
		{
		0x92e4,
		0xbe53
		},
		{
		0x92e6,
		0xe876
		},
		{
		0x92e7,
		0xe87c
		},
		{
		0x92e8,
		0xe872
		},
		{
		0x92e9,
		0xe86c
		},
		{
		0x92ea,
		0xbe51
		},
		{
		0x92ee,
		0xe4a8
		},
		{
		0x92ef,
		0xe870
		},
		{
		0x92f0,
		0xbe59
		},
		{
		0x92f1,
		0xe869
		},
		{
		0x92f7,
		0xebf4
		},
		{
		0x92f8,
		0xbff7
		},
		{
		0x92f9,
		0xebf3
		},
		{
		0x92fa,
		0xebf0
		},
		{
		0x92fb,
		0xec44
		},
		{
		0x92fc,
		0xbffb
		},
		{
		0x92fe,
		0xec41
		},
		{
		0x92ff,
		0xebf8
		},
		{
		0x9300,
		0xec43
		},
		{
		0x9301,
		0xebe9
		},
		{
		0x9302,
		0xebf6
		},
		{
		0x9304,
		0xbffd
		},
		{
		0x9306,
		0xebe1
		},
		{
		0x9308,
		0xebdf
		},
		{
		0x9309,
		0xec42
		},
		{
		0x930b,
		0xec40
		},
		{
		0x930c,
		0xebfe
		},
		{
		0x930d,
		0xebed
		},
		{
		0x930e,
		0xebec
		},
		{
		0x930f,
		0xebe2
		},
		{
		0x9310,
		0xc040
		},
		{
		0x9312,
		0xebe8
		},
		{
		0x9313,
		0xebf2
		},
		{
		0x9314,
		0xebfd
		},
		{
		0x9315,
		0xc043
		},
		{
		0x9316,
		0xec45
		},
		{
		0x9318,
		0xc1e8
		},
		{
		0x9319,
		0xc045
		},
		{
		0x931a,
		0xbffe
		},
		{
		0x931b,
		0xebe6
		},
		{
		0x931d,
		0xebef
		},
		{
		0x931e,
		0xebde
		},
		{
		0x931f,
		0xebe0
		},
		{
		0x9320,
		0xbff5
		},
		{
		0x9321,
		0xc042
		},
		{
		0x9322,
		0xbffa
		},
		{
		0x9323,
		0xebe7
		},
		{
		0x9324,
		0xebf7
		},
		{
		0x9325,
		0xebf1
		},
		{
		0x9326,
		0xc041
		},
		{
		0x9327,
		0xebdd
		},
		{
		0x9328,
		0xc1e3
		},
		{
		0x9329,
		0xebf9
		},
		{
		0x932a,
		0xebfc
		},
		{
		0x932b,
		0xbffc
		},
		{
		0x932d,
		0xebeb
		},
		{
		0x932e,
		0xc044
		},
		{
		0x932f,
		0xbff9
		},
		{
		0x9333,
		0xbff8
		},
		{
		0x9334,
		0xebf5
		},
		{
		0x9335,
		0xebfb
		},
		{
		0x9336,
		0xbff6
		},
		{
		0x9338,
		0xebe4
		},
		{
		0x9339,
		0xebfa
		},
		{
		0x933c,
		0xebe5
		},
		{
		0x9346,
		0xebea
		},
		{
		0x9347,
		0xeed2
		},
		{
		0x9349,
		0xeed7
		},
		{
		0x934a,
		0xc1e5
		},
		{
		0x934b,
		0xc1e7
		},
		{
		0x934c,
		0xeedd
		},
		{
		0x934d,
		0xc1e1
		},
		{
		0x934e,
		0xeeec
		},
		{
		0x934f,
		0xeee3
		},
		{
		0x9350,
		0xeed8
		},
		{
		0x9351,
		0xeed9
		},
		{
		0x9352,
		0xeee2
		},
		{
		0x9354,
		0xc1ee
		},
		{
		0x9355,
		0xeee1
		},
		{
		0x9356,
		0xeed1
		},
		{
		0x9357,
		0xeee0
		},
		{
		0x9358,
		0xeed4
		},
		{
		0x9359,
		0xeeed
		},
		{
		0x935a,
		0xc1ed
		},
		{
		0x935b,
		0xc1eb
		},
		{
		0x935c,
		0xeed5
		},
		{
		0x935e,
		0xeee8
		},
		{
		0x9360,
		0xeeda
		},
		{
		0x9361,
		0xeee7
		},
		{
		0x9363,
		0xeee9
		},
		{
		0x9364,
		0xeed0
		},
		{
		0x9365,
		0xc1e6
		},
		{
		0x9367,
		0xeeea
		},
		{
		0x936a,
		0xeede
		},
		{
		0x936c,
		0xc1ea
		},
		{
		0x936d,
		0xeedb
		},
		{
		0x9370,
		0xc1ec
		},
		{
		0x9371,
		0xeee4
		},
		{
		0x9375,
		0xc1e4
		},
		{
		0x9376,
		0xeed6
		},
		{
		0x9377,
		0xeee5
		},
		{
		0x9379,
		0xeedf
		},
		{
		0x937a,
		0xebe3
		},
		{
		0x937b,
		0xeee6
		},
		{
		0x937c,
		0xeed3
		},
		{
		0x937e,
		0xc1e9
		},
		{
		0x9380,
		0xeeeb
		},
		{
		0x9382,
		0xc1e2
		},
		{
		0x9383,
		0xeece
		},
		{
		0x9388,
		0xf160
		},
		{
		0x9389,
		0xf159
		},
		{
		0x938a,
		0xc2e9
		},
		{
		0x938c,
		0xf154
		},
		{
		0x938d,
		0xf163
		},
		{
		0x938e,
		0xf15b
		},
		{
		0x938f,
		0xeedc
		},
		{
		0x9391,
		0xf165
		},
		{
		0x9392,
		0xf155
		},
		{
		0x9394,
		0xc2e8
		},
		{
		0x9395,
		0xf15f
		},
		{
		0x9396,
		0xc2ea
		},
		{
		0x9397,
		0xc2f2
		},
		{
		0x9398,
		0xc2f0
		},
		{
		0x9399,
		0xf161
		},
		{
		0x939a,
		0xc2f1
		},
		{
		0x939b,
		0xf157
		},
		{
		0x939d,
		0xf158
		},
		{
		0x939e,
		0xf15d
		},
		{
		0x939f,
		0xf162
		},
		{
		0x93a1,
		0xeecd
		},
		{
		0x93a2,
		0xc2eb
		},
		{
		0x93a3,
		0xf16a
		},
		{
		0x93a4,
		0xf167
		},
		{
		0x93a5,
		0xf16b
		},
		{
		0x93a6,
		0xf15e
		},
		{
		0x93a7,
		0xf15a
		},
		{
		0x93a8,
		0xf168
		},
		{
		0x93a9,
		0xf36a
		},
		{
		0x93aa,
		0xf15c
		},
		{
		0x93ac,
		0xc2ee
		},
		{
		0x93ae,
		0xc2ed
		},
		{
		0x93af,
		0xeecf
		},
		{
		0x93b0,
		0xc2ef
		},
		{
		0x93b1,
		0xf164
		},
		{
		0x93b2,
		0xf166
		},
		{
		0x93b3,
		0xc2ec
		},
		{
		0x93b4,
		0xf169
		},
		{
		0x93b5,
		0xf153
		},
		{
		0x93b7,
		0xf156
		},
		{
		0x93c0,
		0xf373
		},
		{
		0x93c2,
		0xf363
		},
		{
		0x93c3,
		0xc3eb
		},
		{
		0x93c4,
		0xf371
		},
		{
		0x93c7,
		0xf361
		},
		{
		0x93c8,
		0xc3ec
		},
		{
		0x93ca,
		0xf36c
		},
		{
		0x93cc,
		0xf368
		},
		{
		0x93cd,
		0xc3f1
		},
		{
		0x93ce,
		0xf372
		},
		{
		0x93cf,
		0xf362
		},
		{
		0x93d0,
		0xf365
		},
		{
		0x93d1,
		0xc3e9
		},
		{
		0x93d2,
		0xf374
		},
		{
		0x93d4,
		0xf36d
		},
		{
		0x93d5,
		0xf370
		},
		{
		0x93d6,
		0xc3ef
		},
		{
		0x93d7,
		0xc3f4
		},
		{
		0x93d8,
		0xc3f2
		},
		{
		0x93d9,
		0xf369
		},
		{
		0x93da,
		0xf364
		},
		{
		0x93dc,
		0xc3ed
		},
		{
		0x93dd,
		0xc3ee
		},
		{
		0x93de,
		0xf360
		},
		{
		0x93df,
		0xc3ea
		},
		{
		0x93e1,
		0xc3e8
		},
		{
		0x93e2,
		0xc3f0
		},
		{
		0x93e3,
		0xf36f
		},
		{
		0x93e4,
		0xc3f3
		},
		{
		0x93e6,
		0xf36b
		},
		{
		0x93e7,
		0xf375
		},
		{
		0x93e8,
		0xc3f5
		},
		{
		0x93ec,
		0xf367
		},
		{
		0x93ee,
		0xf36e
		},
		{
		0x93f5,
		0xf4f3
		},
		{
		0x93f6,
		0xf542
		},
		{
		0x93f7,
		0xf4f5
		},
		{
		0x93f8,
		0xf4fc
		},
		{
		0x93f9,
		0xf366
		},
		{
		0x93fa,
		0xf4fa
		},
		{
		0x93fb,
		0xf4e9
		},
		{
		0x93fc,
		0xf540
		},
		{
		0x93fd,
		0xc4c3
		},
		{
		0x93fe,
		0xf4ed
		},
		{
		0x93ff,
		0xf4fe
		},
		{
		0x9400,
		0xf4f4
		},
		{
		0x9403,
		0xc4c2
		},
		{
		0x9406,
		0xf544
		},
		{
		0x9407,
		0xf4f6
		},
		{
		0x9409,
		0xf4fb
		},
		{
		0x940a,
		0xf4fd
		},
		{
		0x940b,
		0xf4e7
		},
		{
		0x940c,
		0xf541
		},
		{
		0x940d,
		0xf4f2
		},
		{
		0x940e,
		0xf4f7
		},
		{
		0x940f,
		0xf4eb
		},
		{
		0x9410,
		0xf4ef
		},
		{
		0x9411,
		0xf543
		},
		{
		0x9412,
		0xf4f9
		},
		{
		0x9413,
		0xf4e8
		},
		{
		0x9414,
		0xf4ec
		},
		{
		0x9415,
		0xf4ee
		},
		{
		0x9416,
		0xf4f8
		},
		{
		0x9418,
		0xc4c1
		},
		{
		0x9419,
		0xf4f1
		},
		{
		0x9420,
		0xf4ea
		},
		{
		0x9428,
		0xf4f0
		},
		{
		0x9429,
		0xf661
		},
		{
		0x942a,
		0xf666
		},
		{
		0x942b,
		0xc54f
		},
		{
		0x942c,
		0xf668
		},
		{
		0x942e,
		0xc549
		},
		{
		0x9430,
		0xf664
		},
		{
		0x9431,
		0xf66a
		},
		{
		0x9432,
		0xc54e
		},
		{
		0x9433,
		0xc54a
		},
		{
		0x9435,
		0xc54b
		},
		{
		0x9436,
		0xf660
		},
		{
		0x9437,
		0xf667
		},
		{
		0x9438,
		0xc54d
		},
		{
		0x9439,
		0xf665
		},
		{
		0x943a,
		0xc54c
		},
		{
		0x943b,
		0xf65f
		},
		{
		0x943c,
		0xf663
		},
		{
		0x943d,
		0xf662
		},
		{
		0x943f,
		0xf65e
		},
		{
		0x9440,
		0xf669
		},
		{
		0x9444,
		0xc5b1
		},
		{
		0x9445,
		0xf76d
		},
		{
		0x9446,
		0xf770
		},
		{
		0x9447,
		0xf76c
		},
		{
		0x9448,
		0xf76e
		},
		{
		0x9449,
		0xf76f
		},
		{
		0x944a,
		0xf769
		},
		{
		0x944b,
		0xf76a
		},
		{
		0x944c,
		0xf767
		},
		{
		0x944f,
		0xf76b
		},
		{
		0x9450,
		0xf768
		},
		{
		0x9451,
		0xc5b2
		},
		{
		0x9452,
		0xc5b3
		},
		{
		0x9455,
		0xf84b
		},
		{
		0x9457,
		0xf84d
		},
		{
		0x945d,
		0xf84c
		},
		{
		0x945e,
		0xf84e
		},
		{
		0x9460,
		0xc5e0
		},
		{
		0x9462,
		0xf84a
		},
		{
		0x9463,
		0xc5df
		},
		{
		0x9464,
		0xc5e1
		},
		{
		0x9468,
		0xf8cb
		},
		{
		0x9469,
		0xf8cc
		},
		{
		0x946a,
		0xc644
		},
		{
		0x946b,
		0xf8ca
		},
		{
		0x946d,
		0xf953
		},
		{
		0x946e,
		0xf952
		},
		{
		0x946f,
		0xf954
		},
		{
		0x9470,
		0xc65f
		},
		{
		0x9471,
		0xf955
		},
		{
		0x9472,
		0xc65e
		},
		{
		0x9473,
		0xf956
		},
		{
		0x9474,
		0xf972
		},
		{
		0x9475,
		0xf975
		},
		{
		0x9476,
		0xf974
		},
		{
		0x9477,
		0xc668
		},
		{
		0x9478,
		0xf973
		},
		{
		0x947c,
		0xc672
		},
		{
		0x947d,
		0xc670
		},
		{
		0x947e,
		0xc671
		},
		{
		0x947f,
		0xc677
		},
		{
		0x9480,
		0xf9c0
		},
		{
		0x9481,
		0xf9c1
		},
		{
		0x9482,
		0xf9bf
		},
		{
		0x9483,
		0xf9c9
		},
		{
		0x9577,
		0xaaf8
		},
		{
		0x957a,
		0xd844
		},
		{
		0x957b,
		0xdc78
		},
		{
		0x957c,
		0xe8a5
		},
		{
		0x957d,
		0xf376
		},
		{
		0x9580,
		0xaaf9
		},
		{
		0x9582,
		0xadac
		},
		{
		0x9583,
		0xb07b
		},
		{
		0x9586,
		0xd845
		},
		{
		0x9588,
		0xd846
		},
		{
		0x9589,
		0xb3ac
		},
		{
		0x958b,
		0xb67d
		},
		{
		0x958c,
		0xdc7a
		},
		{
		0x958d,
		0xdc79
		},
		{
		0x958e,
		0xb6a3
		},
		{
		0x958f,
		0xb67c
		},
		{
		0x9590,
		0xdc7b
		},
		{
		0x9591,
		0xb67e
		},
		{
		0x9592,
		0xb6a2
		},
		{
		0x9593,
		0xb6a1
		},
		{
		0x9594,
		0xb67b
		},
		{
		0x9598,
		0xb968
		},
		{
		0x959b,
		0xe0d0
		},
		{
		0x959c,
		0xe0ce
		},
		{
		0x959e,
		0xe0cf
		},
		{
		0x959f,
		0xe0cd
		},
		{
		0x95a1,
		0xbbd2
		},
		{
		0x95a3,
		0xbbd5
		},
		{
		0x95a4,
		0xbbd7
		},
		{
		0x95a5,
		0xbbd6
		},
		{
		0x95a8,
		0xbbd3
		},
		{
		0x95a9,
		0xbbd4
		},
		{
		0x95ab,
		0xe8a7
		},
		{
		0x95ac,
		0xe8a6
		},
		{
		0x95ad,
		0xbe5b
		},
		{
		0x95ae,
		0xe8a8
		},
		{
		0x95b0,
		0xe8a9
		},
		{
		0x95b1,
		0xbe5c
		},
		{
		0x95b5,
		0xec4d
		},
		{
		0x95b6,
		0xec4b
		},
		{
		0x95b7,
		0xeef3
		},
		{
		0x95b9,
		0xec49
		},
		{
		0x95ba,
		0xec4a
		},
		{
		0x95bb,
		0xc046
		},
		{
		0x95bc,
		0xec46
		},
		{
		0x95bd,
		0xec4e
		},
		{
		0x95be,
		0xec48
		},
		{
		0x95bf,
		0xec4c
		},
		{
		0x95c0,
		0xeeef
		},
		{
		0x95c3,
		0xeef1
		},
		{
		0x95c5,
		0xeef2
		},
		{
		0x95c6,
		0xc1f3
		},
		{
		0x95c7,
		0xeeee
		},
		{
		0x95c8,
		0xc1f2
		},
		{
		0x95c9,
		0xeef0
		},
		{
		0x95ca,
		0xc1ef
		},
		{
		0x95cb,
		0xc1f0
		},
		{
		0x95cc,
		0xc1f1
		},
		{
		0x95cd,
		0xec47
		},
		{
		0x95d0,
		0xc2f5
		},
		{
		0x95d1,
		0xf16e
		},
		{
		0x95d2,
		0xf16c
		},
		{
		0x95d3,
		0xf16d
		},
		{
		0x95d4,
		0xc2f3
		},
		{
		0x95d5,
		0xc2f6
		},
		{
		0x95d6,
		0xc2f4
		},
		{
		0x95da,
		0xf377
		},
		{
		0x95db,
		0xf378
		},
		{
		0x95dc,
		0xc3f6
		},
		{
		0x95de,
		0xf545
		},
		{
		0x95df,
		0xf547
		},
		{
		0x95e0,
		0xf546
		},
		{
		0x95e1,
		0xc4c4
		},
		{
		0x95e2,
		0xc550
		},
		{
		0x95e3,
		0xf66d
		},
		{
		0x95e4,
		0xf66c
		},
		{
		0x95e5,
		0xf66b
		},
		{
		0x961c,
		0xaafa
		},
		{
		0x961e,
		0xc9aa
		},
		{
		0x9620,
		0xca58
		},
		{
		0x9621,
		0xa6e9
		},
		{
		0x9622,
		0xca56
		},
		{
		0x9623,
		0xca59
		},
		{
		0x9624,
		0xca57
		},
		{
		0x9628,
		0xcbae
		},
		{
		0x962a,
		0xa8c1
		},
		{
		0x962c,
		0xa8c2
		},
		{
		0x962d,
		0xcbb0
		},
		{
		0x962e,
		0xa8bf
		},
		{
		0x962f,
		0xcbaf
		},
		{
		0x9630,
		0xcbad
		},
		{
		0x9631,
		0xa8c0
		},
		{
		0x9632,
		0xa8be
		},
		{
		0x9639,
		0xcdd8
		},
		{
		0x963a,
		0xcddb
		},
		{
		0x963b,
		0xaafd
		},
		{
		0x963c,
		0xcdda
		},
		{
		0x963d,
		0xcdd9
		},
		{
		0x963f,
		0xaafc
		},
		{
		0x9640,
		0xaafb
		},
		{
		0x9642,
		0xab40
		},
		{
		0x9643,
		0xcddc
		},
		{
		0x9644,
		0xaafe
		},
		{
		0x964a,
		0xd0c6
		},
		{
		0x964b,
		0xadae
		},
		{
		0x964c,
		0xadaf
		},
		{
		0x964d,
		0xadb0
		},
		{
		0x964e,
		0xd0c7
		},
		{
		0x964f,
		0xd0c3
		},
		{
		0x9650,
		0xadad
		},
		{
		0x9651,
		0xd0c4
		},
		{
		0x9653,
		0xd0c5
		},
		{
		0x9654,
		0xd0c2
		},
		{
		0x9658,
		0xb0a4
		},
		{
		0x965b,
		0xb0a1
		},
		{
		0x965c,
		0xd445
		},
		{
		0x965d,
		0xb0a2
		},
		{
		0x965e,
		0xb0a5
		},
		{
		0x965f,
		0xd446
		},
		{
		0x9661,
		0xb07e
		},
		{
		0x9662,
		0xb07c
		},
		{
		0x9663,
		0xb07d
		},
		{
		0x9664,
		0xb0a3
		},
		{
		0x966a,
		0xb3ad
		},
		{
		0x966b,
		0xd849
		},
		{
		0x966c,
		0xb3b5
		},
		{
		0x966d,
		0xd848
		},
		{
		0x966f,
		0xd84b
		},
		{
		0x9670,
		0xb3b1
		},
		{
		0x9671,
		0xd84a
		},
		{
		0x9672,
		0xb6ab
		},
		{
		0x9673,
		0xb3af
		},
		{
		0x9674,
		0xb3b2
		},
		{
		0x9675,
		0xb3ae
		},
		{
		0x9676,
		0xb3b3
		},
		{
		0x9677,
		0xb3b4
		},
		{
		0x9678,
		0xb3b0
		},
		{
		0x967c,
		0xd847
		},
		{
		0x967d,
		0xb6a7
		},
		{
		0x967e,
		0xdc7d
		},
		{
		0x9680,
		0xdca3
		},
		{
		0x9683,
		0xdca2
		},
		{
		0x9684,
		0xb6ac
		},
		{
		0x9685,
		0xb6a8
		},
		{
		0x9686,
		0xb6a9
		},
		{
		0x9687,
		0xdc7c
		},
		{
		0x9688,
		0xdc7e
		},
		{
		0x9689,
		0xdca1
		},
		{
		0x968a,
		0xb6a4
		},
		{
		0x968b,
		0xb6a6
		},
		{
		0x968d,
		0xb6aa
		},
		{
		0x968e,
		0xb6a5
		},
		{
		0x9691,
		0xe0d3
		},
		{
		0x9692,
		0xe0d1
		},
		{
		0x9693,
		0xe0d2
		},
		{
		0x9694,
		0xb96a
		},
		{
		0x9695,
		0xb96b
		},
		{
		0x9697,
		0xe0d4
		},
		{
		0x9698,
		0xb969
		},
		{
		0x9699,
		0xbbd8
		},
		{
		0x969b,
		0xbbda
		},
		{
		0x969c,
		0xbbd9
		},
		{
		0x969e,
		0xe4bb
		},
		{
		0x96a1,
		0xe4bc
		},
		{
		0x96a2,
		0xe8ab
		},
		{
		0x96a4,
		0xe8aa
		},
		{
		0x96a7,
		0xc047
		},
		{
		0x96a8,
		0xc048
		},
		{
		0x96a9,
		0xec4f
		},
		{
		0x96aa,
		0xc049
		},
		{
		0x96ac,
		0xeef6
		},
		{
		0x96ae,
		0xeef4
		},
		{
		0x96b0,
		0xeef5
		},
		{
		0x96b1,
		0xc1f4
		},
		{
		0x96b3,
		0xf16f
		},
		{
		0x96b4,
		0xc3f7
		},
		{
		0x96b8,
		0xc1f5
		},
		{
		0x96b9,
		0xab41
		},
		{
		0x96bb,
		0xb0a6
		},
		{
		0x96bc,
		0xd447
		},
		{
		0x96bf,
		0xd84c
		},
		{
		0x96c0,
		0xb3b6
		},
		{
		0x96c1,
		0xb6ad
		},
		{
		0x96c2,
		0xdca4
		},
		{
		0x96c3,
		0xdca6
		},
		{
		0x96c4,
		0xb6af
		},
		{
		0x96c5,
		0xb6ae
		},
		{
		0x96c6,
		0xb6b0
		},
		{
		0x96c7,
		0xb6b1
		},
		{
		0x96c8,
		0xdca5
		},
		{
		0x96c9,
		0xb96e
		},
		{
		0x96ca,
		0xb96f
		},
		{
		0x96cb,
		0xb96d
		},
		{
		0x96cc,
		0xbbdb
		},
		{
		0x96cd,
		0xb96c
		},
		{
		0x96ce,
		0xe0d5
		},
		{
		0x96d2,
		0xbbdc
		},
		{
		0x96d3,
		0xe8ac
		},
		{
		0x96d4,
		0xec50
		},
		{
		0x96d5,
		0xc04a
		},
		{
		0x96d6,
		0xc1f6
		},
		{
		0x96d7,
		0xf170
		},
		{
		0x96d8,
		0xf174
		},
		{
		0x96d9,
		0xc2f9
		},
		{
		0x96da,
		0xf171
		},
		{
		0x96db,
		0xc2fa
		},
		{
		0x96dc,
		0xc2f8
		},
		{
		0x96dd,
		0xf175
		},
		{
		0x96de,
		0xc2fb
		},
		{
		0x96df,
		0xf173
		},
		{
		0x96e1,
		0xf379
		},
		{
		0x96e2,
		0xc2f7
		},
		{
		0x96e3,
		0xc3f8
		},
		{
		0x96e5,
		0xf8cd
		},
		{
		0x96e8,
		0xab42
		},
		{
		0x96e9,
		0xb3b8
		},
		{
		0x96ea,
		0xb3b7
		},
		{
		0x96ef,
		0xb6b2
		},
		{
		0x96f0,
		0xdca8
		},
		{
		0x96f1,
		0xdca7
		},
		{
		0x96f2,
		0xb6b3
		},
		{
		0x96f5,
		0xe0d9
		},
		{
		0x96f6,
		0xb973
		},
		{
		0x96f7,
		0xb970
		},
		{
		0x96f8,
		0xe0d8
		},
		{
		0x96f9,
		0xb972
		},
		{
		0x96fa,
		0xe0d6
		},
		{
		0x96fb,
		0xb971
		},
		{
		0x96fd,
		0xe0d7
		},
		{
		0x96ff,
		0xe4bd
		},
		{
		0x9700,
		0xbbdd
		},
		{
		0x9702,
		0xe8af
		},
		{
		0x9704,
		0xbe5d
		},
		{
		0x9705,
		0xe8ad
		},
		{
		0x9706,
		0xbe5e
		},
		{
		0x9707,
		0xbe5f
		},
		{
		0x9708,
		0xe8ae
		},
		{
		0x9709,
		0xbe60
		},
		{
		0x970b,
		0xec51
		},
		{
		0x970d,
		0xc04e
		},
		{
		0x970e,
		0xc04b
		},
		{
		0x970f,
		0xc050
		},
		{
		0x9710,
		0xec53
		},
		{
		0x9711,
		0xc04c
		},
		{
		0x9712,
		0xec52
		},
		{
		0x9713,
		0xc04f
		},
		{
		0x9716,
		0xc04d
		},
		{
		0x9718,
		0xeef9
		},
		{
		0x9719,
		0xeefb
		},
		{
		0x971c,
		0xc1f7
		},
		{
		0x971d,
		0xeefa
		},
		{
		0x971e,
		0xc1f8
		},
		{
		0x971f,
		0xeef8
		},
		{
		0x9720,
		0xeef7
		},
		{
		0x9722,
		0xf177
		},
		{
		0x9723,
		0xf176
		},
		{
		0x9724,
		0xc2fc
		},
		{
		0x9725,
		0xf178
		},
		{
		0x9726,
		0xf37e
		},
		{
		0x9727,
		0xc3fa
		},
		{
		0x9728,
		0xf37d
		},
		{
		0x9729,
		0xf37a
		},
		{
		0x972a,
		0xc3f9
		},
		{
		0x972b,
		0xf37b
		},
		{
		0x972c,
		0xf37c
		},
		{
		0x972e,
		0xf548
		},
		{
		0x972f,
		0xf549
		},
		{
		0x9730,
		0xc4c5
		},
		{
		0x9732,
		0xc553
		},
		{
		0x9735,
		0xf66e
		},
		{
		0x9738,
		0xc551
		},
		{
		0x9739,
		0xc552
		},
		{
		0x973a,
		0xf66f
		},
		{
		0x973d,
		0xc5b4
		},
		{
		0x973e,
		0xc5b5
		},
		{
		0x973f,
		0xf771
		},
		{
		0x9742,
		0xc645
		},
		{
		0x9743,
		0xf8cf
		},
		{
		0x9744,
		0xc647
		},
		{
		0x9746,
		0xf8ce
		},
		{
		0x9747,
		0xf8d0
		},
		{
		0x9748,
		0xc646
		},
		{
		0x9749,
		0xf957
		},
		{
		0x974b,
		0xf9ad
		},
		{
		0x9752,
		0xab43
		},
		{
		0x9756,
		0xb974
		},
		{
		0x9758,
		0xe4be
		},
		{
		0x975a,
		0xe8b0
		},
		{
		0x975b,
		0xc051
		},
		{
		0x975c,
		0xc052
		},
		{
		0x975e,
		0xab44
		},
		{
		0x9760,
		0xbe61
		},
		{
		0x9761,
		0xc3fb
		},
		{
		0x9762,
		0xadb1
		},
		{
		0x9766,
		0xc053
		},
		{
		0x9768,
		0xc5e2
		},
		{
		0x9769,
		0xadb2
		},
		{
		0x976a,
		0xd84d
		},
		{
		0x976c,
		0xdca9
		},
		{
		0x976e,
		0xdcab
		},
		{
		0x9770,
		0xdcaa
		},
		{
		0x9772,
		0xe0dd
		},
		{
		0x9773,
		0xe0da
		},
		{
		0x9774,
		0xb975
		},
		{
		0x9776,
		0xb976
		},
		{
		0x9777,
		0xe0db
		},
		{
		0x9778,
		0xe0dc
		},
		{
		0x977a,
		0xe4c0
		},
		{
		0x977b,
		0xe4c5
		},
		{
		0x977c,
		0xbbde
		},
		{
		0x977d,
		0xe4bf
		},
		{
		0x977e,
		0xe4c1
		},
		{
		0x977f,
		0xe4c8
		},
		{
		0x9780,
		0xe4c3
		},
		{
		0x9781,
		0xe4c7
		},
		{
		0x9782,
		0xe4c4
		},
		{
		0x9783,
		0xe4c2
		},
		{
		0x9784,
		0xe4c6
		},
		{
		0x9785,
		0xbbdf
		},
		{
		0x9788,
		0xe8b3
		},
		{
		0x978a,
		0xe8b1
		},
		{
		0x978b,
		0xbe63
		},
		{
		0x978d,
		0xbe62
		},
		{
		0x978e,
		0xe8b2
		},
		{
		0x978f,
		0xbe64
		},
		{
		0x9794,
		0xec56
		},
		{
		0x9797,
		0xec55
		},
		{
		0x9798,
		0xc054
		},
		{
		0x9799,
		0xec54
		},
		{
		0x979a,
		0xeefc
		},
		{
		0x979c,
		0xeefe
		},
		{
		0x979d,
		0xef41
		},
		{
		0x979e,
		0xef40
		},
		{
		0x97a0,
		0xc1f9
		},
		{
		0x97a1,
		0xeefd
		},
		{
		0x97a2,
		0xf1a1
		},
		{
		0x97a3,
		0xc2fd
		},
		{
		0x97a4,
		0xf17d
		},
		{
		0x97a5,
		0xf1a2
		},
		{
		0x97a6,
		0xc2fe
		},
		{
		0x97a8,
		0xf17b
		},
		{
		0x97aa,
		0xf17e
		},
		{
		0x97ab,
		0xf17c
		},
		{
		0x97ac,
		0xf179
		},
		{
		0x97ad,
		0xc340
		},
		{
		0x97ae,
		0xf17a
		},
		{
		0x97b3,
		0xf3a1
		},
		{
		0x97b6,
		0xf3a3
		},
		{
		0x97b7,
		0xf3a2
		},
		{
		0x97b9,
		0xf54a
		},
		{
		0x97bb,
		0xf54b
		},
		{
		0x97bf,
		0xf670
		},
		{
		0x97c1,
		0xc5b7
		},
		{
		0x97c3,
		0xc5b6
		},
		{
		0x97c4,
		0xf84f
		},
		{
		0x97c5,
		0xf850
		},
		{
		0x97c6,
		0xc648
		},
		{
		0x97c7,
		0xf8d1
		},
		{
		0x97c9,
		0xc669
		},
		{
		0x97cb,
		0xadb3
		},
		{
		0x97cc,
		0xb6b4
		},
		{
		0x97cd,
		0xe4ca
		},
		{
		0x97ce,
		0xe4c9
		},
		{
		0x97cf,
		0xe8b5
		},
		{
		0x97d0,
		0xe8b4
		},
		{
		0x97d3,
		0xc1fa
		},
		{
		0x97d4,
		0xef43
		},
		{
		0x97d5,
		0xef42
		},
		{
		0x97d6,
		0xf1a5
		},
		{
		0x97d7,
		0xf1a3
		},
		{
		0x97d8,
		0xf1a6
		},
		{
		0x97d9,
		0xf1a4
		},
		{
		0x97dc,
		0xc3fc
		},
		{
		0x97dd,
		0xf3a4
		},
		{
		0x97de,
		0xf3a5
		},
		{
		0x97df,
		0xf3a6
		},
		{
		0x97e1,
		0xf671
		},
		{
		0x97e3,
		0xf772
		},
		{
		0x97e5,
		0xf8d2
		},
		{
		0x97ed,
		0xadb4
		},
		{
		0x97f0,
		0xec57
		},
		{
		0x97f1,
		0xef44
		},
		{
		0x97f3,
		0xadb5
		},
		{
		0x97f6,
		0xbbe0
		},
		{
		0x97f8,
		0xec58
		},
		{
		0x97f9,
		0xc341
		},
		{
		0x97fa,
		0xf1a7
		},
		{
		0x97fb,
		0xc3fd
		},
		{
		0x97fd,
		0xf54c
		},
		{
		0x97fe,
		0xf54d
		},
		{
		0x97ff,
		0xc554
		},
		{
		0x9800,
		0xf851
		},
		{
		0x9801,
		0xadb6
		},
		{
		0x9802,
		0xb3bb
		},
		{
		0x9803,
		0xb3bc
		},
		{
		0x9804,
		0xd84e
		},
		{
		0x9805,
		0xb6b5
		},
		{
		0x9806,
		0xb6b6
		},
		{
		0x9807,
		0xdcac
		},
		{
		0x9808,
		0xb6b7
		},
		{
		0x980a,
		0xb97a
		},
		{
		0x980c,
		0xb97c
		},
		{
		0x980d,
		0xe0df
		},
		{
		0x980e,
		0xe0e0
		},
		{
		0x980f,
		0xe0de
		},
		{
		0x9810,
		0xb977
		},
		{
		0x9811,
		0xb978
		},
		{
		0x9812,
		0xb97b
		},
		{
		0x9813,
		0xb979
		},
		{
		0x9816,
		0xe4cb
		},
		{
		0x9817,
		0xbbe1
		},
		{
		0x9818,
		0xbbe2
		},
		{
		0x981b,
		0xe8bc
		},
		{
		0x981c,
		0xbe67
		},
		{
		0x981d,
		0xe8b7
		},
		{
		0x981e,
		0xe8b6
		},
		{
		0x9820,
		0xe8bb
		},
		{
		0x9821,
		0xbe65
		},
		{
		0x9824,
		0xc05b
		},
		{
		0x9826,
		0xe8b8
		},
		{
		0x9827,
		0xe8bd
		},
		{
		0x9828,
		0xe8ba
		},
		{
		0x9829,
		0xe8b9
		},
		{
		0x982b,
		0xbe66
		},
		{
		0x982d,
		0xc059
		},
		{
		0x982f,
		0xec5a
		},
		{
		0x9830,
		0xc055
		},
		{
		0x9832,
		0xec5b
		},
		{
		0x9835,
		0xec59
		},
		{
		0x9837,
		0xc058
		},
		{
		0x9838,
		0xc056
		},
		{
		0x9839,
		0xc05a
		},
		{
		0x983b,
		0xc057
		},
		{
		0x9841,
		0xef45
		},
		{
		0x9843,
		0xef4a
		},
		{
		0x9844,
		0xef46
		},
		{
		0x9845,
		0xef49
		},
		{
		0x9846,
		0xc1fb
		},
		{
		0x9848,
		0xedd4
		},
		{
		0x9849,
		0xef48
		},
		{
		0x984a,
		0xef47
		},
		{
		0x984c,
		0xc344
		},
		{
		0x984d,
		0xc342
		},
		{
		0x984e,
		0xc345
		},
		{
		0x984f,
		0xc343
		},
		{
		0x9850,
		0xf1a8
		},
		{
		0x9851,
		0xf1a9
		},
		{
		0x9852,
		0xf1aa
		},
		{
		0x9853,
		0xc346
		},
		{
		0x9857,
		0xf3aa
		},
		{
		0x9858,
		0xc440
		},
		{
		0x9859,
		0xf3a8
		},
		{
		0x985b,
		0xc441
		},
		{
		0x985c,
		0xf3a7
		},
		{
		0x985d,
		0xf3a9
		},
		{
		0x985e,
		0xc3fe
		},
		{
		0x985f,
		0xf551
		},
		{
		0x9860,
		0xf54e
		},
		{
		0x9862,
		0xf54f
		},
		{
		0x9863,
		0xf550
		},
		{
		0x9864,
		0xf672
		},
		{
		0x9865,
		0xc556
		},
		{
		0x9867,
		0xc555
		},
		{
		0x9869,
		0xf774
		},
		{
		0x986a,
		0xf773
		},
		{
		0x986b,
		0xc5b8
		},
		{
		0x986f,
		0xc5e3
		},
		{
		0x9870,
		0xc649
		},
		{
		0x9871,
		0xc660
		},
		{
		0x9872,
		0xf958
		},
		{
		0x9873,
		0xf9ae
		},
		{
		0x9874,
		0xf9af
		},
		{
		0x98a8,
		0xadb7
		},
		{
		0x98a9,
		0xdcad
		},
		{
		0x98ac,
		0xe0e1
		},
		{
		0x98ad,
		0xe4cc
		},
		{
		0x98ae,
		0xe4cd
		},
		{
		0x98af,
		0xbbe3
		},
		{
		0x98b1,
		0xbbe4
		},
		{
		0x98b2,
		0xe8be
		},
		{
		0x98b3,
		0xbe68
		},
		{
		0x98b6,
		0xc1fc
		},
		{
		0x98b8,
		0xf1ab
		},
		{
		0x98ba,
		0xc347
		},
		{
		0x98bb,
		0xf3ad
		},
		{
		0x98bc,
		0xc442
		},
		{
		0x98bd,
		0xf3ac
		},
		{
		0x98be,
		0xf3ae
		},
		{
		0x98bf,
		0xf3ab
		},
		{
		0x98c0,
		0xf675
		},
		{
		0x98c1,
		0xf552
		},
		{
		0x98c2,
		0xf553
		},
		{
		0x98c4,
		0xc4c6
		},
		{
		0x98c6,
		0xf674
		},
		{
		0x98c9,
		0xf673
		},
		{
		0x98cb,
		0xf775
		},
		{
		0x98cc,
		0xf9b0
		},
		{
		0x98db,
		0xadb8
		},
		{
		0x98df,
		0xadb9
		},
		{
		0x98e2,
		0xb0a7
		},
		{
		0x98e3,
		0xd448
		},
		{
		0x98e5,
		0xd84f
		},
		{
		0x98e7,
		0xb6b8
		},
		{
		0x98e9,
		0xb6bb
		},
		{
		0x98ea,
		0xb6b9
		},
		{
		0x98eb,
		0xdcae
		},
		{
		0x98ed,
		0xb6bd
		},
		{
		0x98ef,
		0xb6ba
		},
		{
		0x98f2,
		0xb6bc
		},
		{
		0x98f4,
		0xb97e
		},
		{
		0x98f6,
		0xe0e2
		},
		{
		0x98f9,
		0xe0e3
		},
		{
		0x98fa,
		0xe8c0
		},
		{
		0x98fc,
		0xb97d
		},
		{
		0x98fd,
		0xb9a1
		},
		{
		0x98fe,
		0xb9a2
		},
		{
		0x9900,
		0xe4cf
		},
		{
		0x9902,
		0xe4ce
		},
		{
		0x9903,
		0xbbe5
		},
		{
		0x9905,
		0xbbe6
		},
		{
		0x9907,
		0xe4d0
		},
		{
		0x9908,
		0xe8bf
		},
		{
		0x9909,
		0xbbe8
		},
		{
		0x990a,
		0xbe69
		},
		{
		0x990c,
		0xbbe7
		},
		{
		0x9910,
		0xc05c
		},
		{
		0x9911,
		0xe8c1
		},
		{
		0x9912,
		0xbe6b
		},
		{
		0x9913,
		0xbe6a
		},
		{
		0x9914,
		0xe8c2
		},
		{
		0x9915,
		0xe8c5
		},
		{
		0x9916,
		0xe8c3
		},
		{
		0x9917,
		0xe8c4
		},
		{
		0x9918,
		0xbe6c
		},
		{
		0x991a,
		0xc061
		},
		{
		0x991b,
		0xc05f
		},
		{
		0x991e,
		0xc05e
		},
		{
		0x991f,
		0xec5d
		},
		{
		0x9921,
		0xc060
		},
		{
		0x9924,
		0xec5c
		},
		{
		0x9925,
		0xef4b
		},
		{
		0x9927,
		0xec5e
		},
		{
		0x9928,
		0xc05d
		},
		{
		0x9929,
		0xec5f
		},
		{
		0x992a,
		0xef4e
		},
		{
		0x992b,
		0xef4c
		},
		{
		0x992c,
		0xef4d
		},
		{
		0x992d,
		0xef52
		},
		{
		0x992e,
		0xc34b
		},
		{
		0x992f,
		0xef51
		},
		{
		0x9930,
		0xef54
		},
		{
		0x9931,
		0xef53
		},
		{
		0x9932,
		0xef50
		},
		{
		0x9933,
		0xef4f
		},
		{
		0x9935,
		0xc1fd
		},
		{
		0x993a,
		0xf1ae
		},
		{
		0x993c,
		0xf1ad
		},
		{
		0x993d,
		0xc34a
		},
		{
		0x993e,
		0xc348
		},
		{
		0x993f,
		0xc349
		},
		{
		0x9941,
		0xf1ac
		},
		{
		0x9943,
		0xf3b1
		},
		{
		0x9945,
		0xc443
		},
		{
		0x9947,
		0xf3b0
		},
		{
		0x9948,
		0xf3af
		},
		{
		0x9949,
		0xc444
		},
		{
		0x994b,
		0xf558
		},
		{
		0x994c,
		0xf557
		},
		{
		0x994e,
		0xf555
		},
		{
		0x9950,
		0xf554
		},
		{
		0x9951,
		0xc4c8
		},
		{
		0x9952,
		0xc4c7
		},
		{
		0x9953,
		0xf559
		},
		{
		0x9954,
		0xf776
		},
		{
		0x9955,
		0xc5b9
		},
		{
		0x9956,
		0xf677
		},
		{
		0x9957,
		0xc557
		},
		{
		0x9958,
		0xf676
		},
		{
		0x9959,
		0xf556
		},
		{
		0x995b,
		0xf777
		},
		{
		0x995c,
		0xc5e4
		},
		{
		0x995e,
		0xc661
		},
		{
		0x995f,
		0xf959
		},
		{
		0x9961,
		0xf9b1
		},
		{
		0x9996,
		0xadba
		},
		{
		0x9997,
		0xd850
		},
		{
		0x9998,
		0xef55
		},
		{
		0x9999,
		0xadbb
		},
		{
		0x999c,
		0xe4d2
		},
		{
		0x999d,
		0xe4d1
		},
		{
		0x999e,
		0xec60
		},
		{
		0x99a1,
		0xef57
		},
		{
		0x99a3,
		0xef56
		},
		{
		0x99a5,
		0xc34c
		},
		{
		0x99a6,
		0xf3b2
		},
		{
		0x99a7,
		0xf3b3
		},
		{
		0x99a8,
		0xc4c9
		},
		{
		0x99ab,
		0xf9b2
		},
		{
		0x99ac,
		0xb0a8
		},
		{
		0x99ad,
		0xb6bf
		},
		{
		0x99ae,
		0xb6be
		},
		{
		0x99af,
		0xe0e4
		},
		{
		0x99b0,
		0xe0e6
		},
		{
		0x99b1,
		0xb9a4
		},
		{
		0x99b2,
		0xe0e5
		},
		{
		0x99b3,
		0xb9a3
		},
		{
		0x99b4,
		0xb9a5
		},
		{
		0x99b5,
		0xe0e7
		},
		{
		0x99b9,
		0xe4d4
		},
		{
		0x99ba,
		0xe4d6
		},
		{
		0x99bb,
		0xe4d5
		},
		{
		0x99bd,
		0xe4d8
		},
		{
		0x99c1,
		0xbbe9
		},
		{
		0x99c2,
		0xe4d7
		},
		{
		0x99c3,
		0xe4d3
		},
		{
		0x99c7,
		0xe4d9
		},
		{
		0x99c9,
		0xe8cc
		},
		{
		0x99cb,
		0xe8cf
		},
		{
		0x99cc,
		0xe8d1
		},
		{
		0x99cd,
		0xe8c7
		},
		{
		0x99ce,
		0xe8cb
		},
		{
		0x99cf,
		0xe8c8
		},
		{
		0x99d0,
		0xbe6e
		},
		{
		0x99d1,
		0xbe71
		},
		{
		0x99d2,
		0xbe73
		},
		{
		0x99d3,
		0xe8c9
		},
		{
		0x99d4,
		0xe8ca
		},
		{
		0x99d5,
		0xbe72
		},
		{
		0x99d6,
		0xe8cd
		},
		{
		0x99d7,
		0xe8d0
		},
		{
		0x99d8,
		0xe8ce
		},
		{
		0x99d9,
		0xbe74
		},
		{
		0x99db,
		0xbe70
		},
		{
		0x99dc,
		0xe8c6
		},
		{
		0x99dd,
		0xbe6d
		},
		{
		0x99df,
		0xbe6f
		},
		{
		0x99e2,
		0xc063
		},
		{
		0x99e3,
		0xec66
		},
		{
		0x99e4,
		0xec64
		},
		{
		0x99e5,
		0xec63
		},
		{
		0x99e7,
		0xec69
		},
		{
		0x99e9,
		0xec68
		},
		{
		0x99ea,
		0xec67
		},
		{
		0x99ec,
		0xec62
		},
		{
		0x99ed,
		0xc062
		},
		{
		0x99ee,
		0xec61
		},
		{
		0x99f0,
		0xec65
		},
		{
		0x99f1,
		0xc064
		},
		{
		0x99f4,
		0xef5a
		},
		{
		0x99f6,
		0xef5e
		},
		{
		0x99f7,
		0xef5b
		},
		{
		0x99f8,
		0xef5d
		},
		{
		0x99f9,
		0xef5c
		},
		{
		0x99fa,
		0xef59
		},
		{
		0x99fb,
		0xef5f
		},
		{
		0x99fc,
		0xef62
		},
		{
		0x99fd,
		0xef60
		},
		{
		0x99fe,
		0xef61
		},
		{
		0x99ff,
		0xc240
		},
		{
		0x9a01,
		0xc1fe
		},
		{
		0x9a02,
		0xef58
		},
		{
		0x9a03,
		0xef63
		},
		{
		0x9a04,
		0xf1b3
		},
		{
		0x9a05,
		0xf1b6
		},
		{
		0x9a06,
		0xf1b8
		},
		{
		0x9a07,
		0xf1b7
		},
		{
		0x9a09,
		0xf1b1
		},
		{
		0x9a0a,
		0xf1b5
		},
		{
		0x9a0b,
		0xf1b0
		},
		{
		0x9a0d,
		0xf1b2
		},
		{
		0x9a0e,
		0xc34d
		},
		{
		0x9a0f,
		0xf1af
		},
		{
		0x9a11,
		0xf1b4
		},
		{
		0x9a14,
		0xf3c0
		},
		{
		0x9a15,
		0xf3b5
		},
		{
		0x9a16,
		0xc445
		},
		{
		0x9a19,
		0xc446
		},
		{
		0x9a1a,
		0xf3b4
		},
		{
		0x9a1b,
		0xf3b9
		},
		{
		0x9a1c,
		0xf3bf
		},
		{
		0x9a1d,
		0xf3b7
		},
		{
		0x9a1e,
		0xf3be
		},
		{
		0x9a20,
		0xf3bb
		},
		{
		0x9a22,
		0xf3ba
		},
		{
		0x9a23,
		0xf3bd
		},
		{
		0x9a24,
		0xf3b8
		},
		{
		0x9a25,
		0xf3b6
		},
		{
		0x9a27,
		0xf3bc
		},
		{
		0x9a29,
		0xf560
		},
		{
		0x9a2a,
		0xf55e
		},
		{
		0x9a2b,
		0xc4ca
		},
		{
		0x9a2c,
		0xf55d
		},
		{
		0x9a2d,
		0xf563
		},
		{
		0x9a2e,
		0xf561
		},
		{
		0x9a30,
		0xc4cb
		},
		{
		0x9a31,
		0xf55c
		},
		{
		0x9a32,
		0xf55a
		},
		{
		0x9a34,
		0xf55b
		},
		{
		0x9a35,
		0xc4cd
		},
		{
		0x9a36,
		0xf55f
		},
		{
		0x9a37,
		0xc4cc
		},
		{
		0x9a38,
		0xf562
		},
		{
		0x9a39,
		0xf678
		},
		{
		0x9a3a,
		0xf67e
		},
		{
		0x9a3d,
		0xf679
		},
		{
		0x9a3e,
		0xc55b
		},
		{
		0x9a3f,
		0xf6a1
		},
		{
		0x9a40,
		0xc55a
		},
		{
		0x9a41,
		0xf67d
		},
		{
		0x9a42,
		0xf67c
		},
		{
		0x9a43,
		0xc559
		},
		{
		0x9a44,
		0xf67b
		},
		{
		0x9a45,
		0xc558
		},
		{
		0x9a46,
		0xf67a
		},
		{
		0x9a48,
		0xf77d
		},
		{
		0x9a49,
		0xf7a1
		},
		{
		0x9a4a,
		0xf77e
		},
		{
		0x9a4c,
		0xf77b
		},
		{
		0x9a4d,
		0xc5bb
		},
		{
		0x9a4e,
		0xf778
		},
		{
		0x9a4f,
		0xf77c
		},
		{
		0x9a50,
		0xf7a3
		},
		{
		0x9a52,
		0xf7a2
		},
		{
		0x9a53,
		0xf779
		},
		{
		0x9a54,
		0xf77a
		},
		{
		0x9a55,
		0xc5ba
		},
		{
		0x9a56,
		0xf852
		},
		{
		0x9a57,
		0xc5e7
		},
		{
		0x9a59,
		0xf853
		},
		{
		0x9a5a,
		0xc5e5
		},
		{
		0x9a5b,
		0xc5e6
		},
		{
		0x9a5e,
		0xf8d3
		},
		{
		0x9a5f,
		0xc64a
		},
		{
		0x9a60,
		0xf976
		},
		{
		0x9a62,
		0xc66a
		},
		{
		0x9a64,
		0xf9b3
		},
		{
		0x9a65,
		0xc66b
		},
		{
		0x9a66,
		0xf9b4
		},
		{
		0x9a67,
		0xf9b5
		},
		{
		0x9a68,
		0xf9c3
		},
		{
		0x9a69,
		0xf9c2
		},
		{
		0x9a6a,
		0xc67a
		},
		{
		0x9a6b,
		0xf9cd
		},
		{
		0x9aa8,
		0xb0a9
		},
		{
		0x9aab,
		0xe0e9
		},
		{
		0x9aad,
		0xe0e8
		},
		{
		0x9aaf,
		0xbbea
		},
		{
		0x9ab0,
		0xbbeb
		},
		{
		0x9ab1,
		0xe4da
		},
		{
		0x9ab3,
		0xe8d2
		},
		{
		0x9ab4,
		0xec6c
		},
		{
		0x9ab7,
		0xbe75
		},
		{
		0x9ab8,
		0xc065
		},
		{
		0x9ab9,
		0xec6a
		},
		{
		0x9abb,
		0xec6d
		},
		{
		0x9abc,
		0xc066
		},
		{
		0x9abe,
		0xef64
		},
		{
		0x9abf,
		0xec6b
		},
		{
		0x9ac0,
		0xf1b9
		},
		{
		0x9ac1,
		0xc34e
		},
		{
		0x9ac2,
		0xf3c1
		},
		{
		0x9ac6,
		0xf566
		},
		{
		0x9ac7,
		0xf564
		},
		{
		0x9aca,
		0xf565
		},
		{
		0x9acd,
		0xf6a2
		},
		{
		0x9acf,
		0xc55c
		},
		{
		0x9ad0,
		0xf7a4
		},
		{
		0x9ad1,
		0xc5ea
		},
		{
		0x9ad2,
		0xc5bc
		},
		{
		0x9ad3,
		0xc5e8
		},
		{
		0x9ad4,
		0xc5e9
		},
		{
		0x9ad5,
		0xf8d4
		},
		{
		0x9ad6,
		0xc662
		},
		{
		0x9ad8,
		0xb0aa
		},
		{
		0x9adc,
		0xf1ba
		},
		{
		0x9adf,
		0xd449
		},
		{
		0x9ae1,
		0xb9a6
		},
		{
		0x9ae3,
		0xe4db
		},
		{
		0x9ae6,
		0xbbec
		},
		{
		0x9ae7,
		0xe4dc
		},
		{
		0x9aeb,
		0xe8d4
		},
		{
		0x9aec,
		0xe8d3
		},
		{
		0x9aed,
		0xc068
		},
		{
		0x9aee,
		0xbe76
		},
		{
		0x9aef,
		0xbe77
		},
		{
		0x9af1,
		0xe8d7
		},
		{
		0x9af2,
		0xe8d6
		},
		{
		0x9af3,
		0xe8d5
		},
		{
		0x9af6,
		0xec6e
		},
		{
		0x9af7,
		0xec71
		},
		{
		0x9af9,
		0xec70
		},
		{
		0x9afa,
		0xec6f
		},
		{
		0x9afb,
		0xc067
		},
		{
		0x9afc,
		0xef68
		},
		{
		0x9afd,
		0xef66
		},
		{
		0x9afe,
		0xef65
		},
		{
		0x9b01,
		0xef67
		},
		{
		0x9b03,
		0xc34f
		},
		{
		0x9b04,
		0xf1bc
		},
		{
		0x9b05,
		0xf1bd
		},
		{
		0x9b06,
		0xc350
		},
		{
		0x9b08,
		0xf1bb
		},
		{
		0x9b0a,
		0xf3c3
		},
		{
		0x9b0b,
		0xf3c2
		},
		{
		0x9b0c,
		0xf3c5
		},
		{
		0x9b0d,
		0xc447
		},
		{
		0x9b0e,
		0xf3c4
		},
		{
		0x9b10,
		0xf567
		},
		{
		0x9b11,
		0xf569
		},
		{
		0x9b12,
		0xf568
		},
		{
		0x9b15,
		0xf6a3
		},
		{
		0x9b16,
		0xf6a6
		},
		{
		0x9b17,
		0xf6a4
		},
		{
		0x9b18,
		0xf6a5
		},
		{
		0x9b19,
		0xf7a5
		},
		{
		0x9b1a,
		0xc5bd
		},
		{
		0x9b1e,
		0xf854
		},
		{
		0x9b1f,
		0xf855
		},
		{
		0x9b20,
		0xf856
		},
		{
		0x9b22,
		0xc64b
		},
		{
		0x9b23,
		0xc663
		},
		{
		0x9b24,
		0xf9b6
		},
		{
		0x9b25,
		0xb0ab
		},
		{
		0x9b27,
		0xbe78
		},
		{
		0x9b28,
		0xc069
		},
		{
		0x9b29,
		0xf1be
		},
		{
		0x9b2b,
		0xf7a6
		},
		{
		0x9b2e,
		0xf9c4
		},
		{
		0x9b2f,
		0xd44a
		},
		{
		0x9b31,
		0xc67b
		},
		{
		0x9b32,
		0xb0ac
		},
		{
		0x9b33,
		0xec72
		},
		{
		0x9b35,
		0xf1bf
		},
		{
		0x9b37,
		0xf3c6
		},
		{
		0x9b3a,
		0xf6a7
		},
		{
		0x9b3b,
		0xf7a7
		},
		{
		0x9b3c,
		0xb0ad
		},
		{
		0x9b3e,
		0xe4dd
		},
		{
		0x9b3f,
		0xe4de
		},
		{
		0x9b41,
		0xbbed
		},
		{
		0x9b42,
		0xbbee
		},
		{
		0x9b43,
		0xe8d9
		},
		{
		0x9b44,
		0xbe7a
		},
		{
		0x9b45,
		0xbe79
		},
		{
		0x9b46,
		0xe8d8
		},
		{
		0x9b48,
		0xef69
		},
		{
		0x9b4a,
		0xf1c0
		},
		{
		0x9b4b,
		0xf1c2
		},
		{
		0x9b4c,
		0xf1c1
		},
		{
		0x9b4d,
		0xc353
		},
		{
		0x9b4e,
		0xc352
		},
		{
		0x9b4f,
		0xc351
		},
		{
		0x9b51,
		0xc55e
		},
		{
		0x9b52,
		0xf6a8
		},
		{
		0x9b54,
		0xc55d
		},
		{
		0x9b55,
		0xf7a9
		},
		{
		0x9b56,
		0xf7a8
		},
		{
		0x9b58,
		0xc64c
		},
		{
		0x9b59,
		0xf8d5
		},
		{
		0x9b5a,
		0xb3bd
		},
		{
		0x9b5b,
		0xe0ea
		},
		{
		0x9b5f,
		0xe4e1
		},
		{
		0x9b60,
		0xe4df
		},
		{
		0x9b61,
		0xe4e0
		},
		{
		0x9b64,
		0xe8e2
		},
		{
		0x9b66,
		0xe8dd
		},
		{
		0x9b67,
		0xe8da
		},
		{
		0x9b68,
		0xe8e1
		},
		{
		0x9b6c,
		0xe8e3
		},
		{
		0x9b6f,
		0xbe7c
		},
		{
		0x9b70,
		0xe8e0
		},
		{
		0x9b71,
		0xe8dc
		},
		{
		0x9b74,
		0xe8db
		},
		{
		0x9b75,
		0xe8df
		},
		{
		0x9b76,
		0xe8de
		},
		{
		0x9b77,
		0xbe7b
		},
		{
		0x9b7a,
		0xec7d
		},
		{
		0x9b7b,
		0xec78
		},
		{
		0x9b7c,
		0xec76
		},
		{
		0x9b7d,
		0xeca1
		},
		{
		0x9b7e,
		0xec77
		},
		{
		0x9b80,
		0xec73
		},
		{
		0x9b82,
		0xec79
		},
		{
		0x9b85,
		0xec74
		},
		{
		0x9b86,
		0xef72
		},
		{
		0x9b87,
		0xec75
		},
		{
		0x9b88,
		0xeca2
		},
		{
		0x9b90,
		0xec7c
		},
		{
		0x9b91,
		0xc06a
		},
		{
		0x9b92,
		0xec7b
		},
		{
		0x9b93,
		0xec7a
		},
		{
		0x9b95,
		0xec7e
		},
		{
		0x9b9a,
		0xef6a
		},
		{
		0x9b9b,
		0xef6d
		},
		{
		0x9b9e,
		0xef6c
		},
		{
		0x9ba0,
		0xef74
		},
		{
		0x9ba1,
		0xef6f
		},
		{
		0x9ba2,
		0xef73
		},
		{
		0x9ba4,
		0xef71
		},
		{
		0x9ba5,
		0xef70
		},
		{
		0x9ba6,
		0xef6e
		},
		{
		0x9ba8,
		0xef6b
		},
		{
		0x9baa,
		0xc243
		},
		{
		0x9bab,
		0xc242
		},
		{
		0x9bad,
		0xc244
		},
		{
		0x9bae,
		0xc241
		},
		{
		0x9baf,
		0xef75
		},
		{
		0x9bb5,
		0xf1c8
		},
		{
		0x9bb6,
		0xf1cb
		},
		{
		0x9bb8,
		0xf1c9
		},
		{
		0x9bb9,
		0xf1cd
		},
		{
		0x9bbd,
		0xf1ce
		},
		{
		0x9bbf,
		0xf1c6
		},
		{
		0x9bc0,
		0xc358
		},
		{
		0x9bc1,
		0xf1c7
		},
		{
		0x9bc3,
		0xf1c5
		},
		{
		0x9bc4,
		0xf1cc
		},
		{
		0x9bc6,
		0xf1c4
		},
		{
		0x9bc7,
		0xf1c3
		},
		{
		0x9bc8,
		0xc357
		},
		{
		0x9bc9,
		0xc355
		},
		{
		0x9bca,
		0xc354
		},
		{
		0x9bd3,
		0xf1ca
		},
		{
		0x9bd4,
		0xf3cf
		},
		{
		0x9bd5,
		0xf3d5
		},
		{
		0x9bd6,
		0xc44a
		},
		{
		0x9bd7,
		0xf3d0
		},
		{
		0x9bd9,
		0xf3d3
		},
		{
		0x9bda,
		0xf3d7
		},
		{
		0x9bdb,
		0xc44b
		},
		{
		0x9bdc,
		0xf3d2
		},
		{
		0x9bde,
		0xf3ca
		},
		{
		0x9be0,
		0xf3c9
		},
		{
		0x9be1,
		0xf3d6
		},
		{
		0x9be2,
		0xf3cd
		},
		{
		0x9be4,
		0xf3cb
		},
		{
		0x9be5,
		0xf3d4
		},
		{
		0x9be6,
		0xf3cc
		},
		{
		0x9be7,
		0xc449
		},
		{
		0x9be8,
		0xc448
		},
		{
		0x9bea,
		0xf3c7
		},
		{
		0x9beb,
		0xf3c8
		},
		{
		0x9bec,
		0xf3d1
		},
		{
		0x9bf0,
		0xf3ce
		},
		{
		0x9bf7,
		0xf56c
		},
		{
		0x9bf8,
		0xf56f
		},
		{
		0x9bfd,
		0xc356
		},
		{
		0x9c05,
		0xf56d
		},
		{
		0x9c06,
		0xf573
		},
		{
		0x9c07,
		0xf571
		},
		{
		0x9c08,
		0xf56b
		},
		{
		0x9c09,
		0xf576
		},
		{
		0x9c0b,
		0xf56a
		},
		{
		0x9c0d,
		0xc4cf
		},
		{
		0x9c0e,
		0xf572
		},
		{
		0x9c12,
		0xf56e
		},
		{
		0x9c13,
		0xc4ce
		},
		{
		0x9c14,
		0xf575
		},
		{
		0x9c17,
		0xf574
		},
		{
		0x9c1c,
		0xf6ab
		},
		{
		0x9c1d,
		0xf6aa
		},
		{
		0x9c21,
		0xf6b1
		},
		{
		0x9c23,
		0xf6ad
		},
		{
		0x9c24,
		0xf6b0
		},
		{
		0x9c25,
		0xc560
		},
		{
		0x9c28,
		0xf6ae
		},
		{
		0x9c29,
		0xf6af
		},
		{
		0x9c2b,
		0xf6a9
		},
		{
		0x9c2c,
		0xf6ac
		},
		{
		0x9c2d,
		0xc55f
		},
		{
		0x9c31,
		0xc5bf
		},
		{
		0x9c32,
		0xf7b4
		},
		{
		0x9c33,
		0xf7af
		},
		{
		0x9c34,
		0xf7b3
		},
		{
		0x9c36,
		0xf7b6
		},
		{
		0x9c37,
		0xf7b2
		},
		{
		0x9c39,
		0xf7ae
		},
		{
		0x9c3b,
		0xc5c1
		},
		{
		0x9c3c,
		0xf7b1
		},
		{
		0x9c3d,
		0xf7b5
		},
		{
		0x9c3e,
		0xc5c0
		},
		{
		0x9c3f,
		0xf7ac
		},
		{
		0x9c40,
		0xf570
		},
		{
		0x9c41,
		0xf7b0
		},
		{
		0x9c44,
		0xf7ad
		},
		{
		0x9c46,
		0xf7aa
		},
		{
		0x9c48,
		0xf7ab
		},
		{
		0x9c49,
		0xc5be
		},
		{
		0x9c4a,
		0xf85a
		},
		{
		0x9c4b,
		0xf85c
		},
		{
		0x9c4c,
		0xf85f
		},
		{
		0x9c4d,
		0xf85b
		},
		{
		0x9c4e,
		0xf860
		},
		{
		0x9c50,
		0xf859
		},
		{
		0x9c52,
		0xf857
		},
		{
		0x9c54,
		0xc5eb
		},
		{
		0x9c55,
		0xf85d
		},
		{
		0x9c56,
		0xc5ed
		},
		{
		0x9c57,
		0xc5ec
		},
		{
		0x9c58,
		0xf858
		},
		{
		0x9c59,
		0xf85e
		},
		{
		0x9c5e,
		0xf8da
		},
		{
		0x9c5f,
		0xc64d
		},
		{
		0x9c60,
		0xf8db
		},
		{
		0x9c62,
		0xf8d9
		},
		{
		0x9c63,
		0xf8d6
		},
		{
		0x9c66,
		0xf8d8
		},
		{
		0x9c67,
		0xf8d7
		},
		{
		0x9c68,
		0xf95a
		},
		{
		0x9c6d,
		0xf95c
		},
		{
		0x9c6e,
		0xf95b
		},
		{
		0x9c71,
		0xf979
		},
		{
		0x9c73,
		0xf978
		},
		{
		0x9c74,
		0xf977
		},
		{
		0x9c75,
		0xf97a
		},
		{
		0x9c77,
		0xc673
		},
		{
		0x9c78,
		0xc674
		},
		{
		0x9c79,
		0xf9ca
		},
		{
		0x9c7a,
		0xf9ce
		},
		{
		0x9ce5,
		0xb3be
		},
		{
		0x9ce6,
		0xdcaf
		},
		{
		0x9ce7,
		0xe0ed
		},
		{
		0x9ce9,
		0xb9a7
		},
		{
		0x9cea,
		0xe0eb
		},
		{
		0x9ced,
		0xe0ec
		},
		{
		0x9cf1,
		0xe4e2
		},
		{
		0x9cf2,
		0xe4e3
		},
		{
		0x9cf3,
		0xbbf1
		},
		{
		0x9cf4,
		0xbbef
		},
		{
		0x9cf5,
		0xe4e4
		},
		{
		0x9cf6,
		0xbbf0
		},
		{
		0x9cf7,
		0xe8e8
		},
		{
		0x9cf9,
		0xe8eb
		},
		{
		0x9cfa,
		0xe8e5
		},
		{
		0x9cfb,
		0xe8ec
		},
		{
		0x9cfc,
		0xe8e4
		},
		{
		0x9cfd,
		0xe8e6
		},
		{
		0x9cff,
		0xe8e7
		},
		{
		0x9d00,
		0xe8ea
		},
		{
		0x9d03,
		0xbea1
		},
		{
		0x9d04,
		0xe8ef
		},
		{
		0x9d05,
		0xe8ee
		},
		{
		0x9d06,
		0xbe7d
		},
		{
		0x9d07,
		0xe8e9
		},
		{
		0x9d08,
		0xe8ed
		},
		{
		0x9d09,
		0xbe7e
		},
		{
		0x9d10,
		0xecac
		},
		{
		0x9d12,
		0xc06f
		},
		{
		0x9d14,
		0xeca7
		},
		{
		0x9d15,
		0xc06b
		},
		{
		0x9d17,
		0xeca4
		},
		{
		0x9d18,
		0xecaa
		},
		{
		0x9d19,
		0xecad
		},
		{
		0x9d1b,
		0xc070
		},
		{
		0x9d1d,
		0xeca9
		},
		{
		0x9d1e,
		0xeca6
		},
		{
		0x9d1f,
		0xecae
		},
		{
		0x9d20,
		0xeca5
		},
		{
		0x9d22,
		0xecab
		},
		{
		0x9d23,
		0xc06c
		},
		{
		0x9d25,
		0xeca3
		},
		{
		0x9d26,
		0xc06d
		},
		{
		0x9d28,
		0xc06e
		},
		{
		0x9d29,
		0xeca8
		},
		{
		0x9d2d,
		0xefa9
		},
		{
		0x9d2e,
		0xef7a
		},
		{
		0x9d2f,
		0xef7b
		},
		{
		0x9d30,
		0xef7e
		},
		{
		0x9d31,
		0xef7c
		},
		{
		0x9d33,
		0xef76
		},
		{
		0x9d36,
		0xef79
		},
		{
		0x9d37,
		0xefa5
		},
		{
		0x9d38,
		0xef7d
		},
		{
		0x9d3b,
		0xc245
		},
		{
		0x9d3d,
		0xefa7
		},
		{
		0x9d3e,
		0xefa4
		},
		{
		0x9d3f,
		0xc246
		},
		{
		0x9d40,
		0xefa6
		},
		{
		0x9d41,
		0xef77
		},
		{
		0x9d42,
		0xefa2
		},
		{
		0x9d43,
		0xefa3
		},
		{
		0x9d45,
		0xefa1
		},
		{
		0x9d4a,
		0xf1d2
		},
		{
		0x9d4b,
		0xf1d4
		},
		{
		0x9d4c,
		0xf1d7
		},
		{
		0x9d4f,
		0xf1d1
		},
		{
		0x9d51,
		0xc359
		},
		{
		0x9d52,
		0xf1d9
		},
		{
		0x9d53,
		0xf1d0
		},
		{
		0x9d54,
		0xf1da
		},
		{
		0x9d56,
		0xf1d6
		},
		{
		0x9d57,
		0xf1d8
		},
		{
		0x9d58,
		0xf1dc
		},
		{
		0x9d59,
		0xf1d5
		},
		{
		0x9d5a,
		0xf1dd
		},
		{
		0x9d5b,
		0xf1d3
		},
		{
		0x9d5c,
		0xf1cf
		},
		{
		0x9d5d,
		0xc35a
		},
		{
		0x9d5f,
		0xf1db
		},
		{
		0x9d60,
		0xc35b
		},
		{
		0x9d61,
		0xc44d
		},
		{
		0x9d67,
		0xef78
		},
		{
		0x9d68,
		0xf3f1
		},
		{
		0x9d69,
		0xf3e8
		},
		{
		0x9d6a,
		0xc44f
		},
		{
		0x9d6b,
		0xf3e4
		},
		{
		0x9d6c,
		0xc450
		},
		{
		0x9d6f,
		0xf3ed
		},
		{
		0x9d70,
		0xf3e7
		},
		{
		0x9d71,
		0xf3dd
		},
		{
		0x9d72,
		0xc44e
		},
		{
		0x9d73,
		0xf3ea
		},
		{
		0x9d74,
		0xf3e5
		},
		{
		0x9d75,
		0xf3e6
		},
		{
		0x9d77,
		0xf3d8
		},
		{
		0x9d78,
		0xf3df
		},
		{
		0x9d79,
		0xf3ee
		},
		{
		0x9d7b,
		0xf3eb
		},
		{
		0x9d7d,
		0xf3e3
		},
		{
		0x9d7f,
		0xf3ef
		},
		{
		0x9d80,
		0xf3de
		},
		{
		0x9d81,
		0xf3d9
		},
		{
		0x9d82,
		0xf3ec
		},
		{
		0x9d84,
		0xf3db
		},
		{
		0x9d85,
		0xf3e9
		},
		{
		0x9d86,
		0xf3e0
		},
		{
		0x9d87,
		0xf3f0
		},
		{
		0x9d88,
		0xf3dc
		},
		{
		0x9d89,
		0xc44c
		},
		{
		0x9d8a,
		0xf3da
		},
		{
		0x9d8b,
		0xf3e1
		},
		{
		0x9d8c,
		0xf3e2
		},
		{
		0x9d90,
		0xf57d
		},
		{
		0x9d92,
		0xf57b
		},
		{
		0x9d94,
		0xf5a2
		},
		{
		0x9d96,
		0xf5ae
		},
		{
		0x9d97,
		0xf5a5
		},
		{
		0x9d98,
		0xf57c
		},
		{
		0x9d99,
		0xf578
		},
		{
		0x9d9a,
		0xf5a7
		},
		{
		0x9d9b,
		0xf57e
		},
		{
		0x9d9c,
		0xf5a3
		},
		{
		0x9d9d,
		0xf57a
		},
		{
		0x9d9e,
		0xf5aa
		},
		{
		0x9d9f,
		0xf577
		},
		{
		0x9da0,
		0xf5a1
		},
		{
		0x9da1,
		0xf5a6
		},
		{
		0x9da2,
		0xf5a8
		},
		{
		0x9da3,
		0xf5ab
		},
		{
		0x9da4,
		0xf579
		},
		{
		0x9da6,
		0xf5af
		},
		{
		0x9da7,
		0xf5b0
		},
		{
		0x9da8,
		0xf5a9
		},
		{
		0x9da9,
		0xf5ad
		},
		{
		0x9daa,
		0xf5a4
		},
		{
		0x9dac,
		0xf6c1
		},
		{
		0x9dad,
		0xf6c4
		},
		{
		0x9daf,
		0xc561
		},
		{
		0x9db1,
		0xf6c3
		},
		{
		0x9db2,
		0xf6c8
		},
		{
		0x9db3,
		0xf6c6
		},
		{
		0x9db4,
		0xc562
		},
		{
		0x9db5,
		0xf6bd
		},
		{
		0x9db6,
		0xf6b3
		},
		{
		0x9db7,
		0xf6b2
		},
		{
		0x9db8,
		0xc564
		},
		{
		0x9db9,
		0xf6bf
		},
		{
		0x9dba,
		0xf6c0
		},
		{
		0x9dbb,
		0xf6bc
		},
		{
		0x9dbc,
		0xf6b4
		},
		{
		0x9dbe,
		0xf6b9
		},
		{
		0x9dbf,
		0xf5ac
		},
		{
		0x9dc1,
		0xf6b5
		},
		{
		0x9dc2,
		0xc563
		},
		{
		0x9dc3,
		0xf6bb
		},
		{
		0x9dc5,
		0xf6ba
		},
		{
		0x9dc7,
		0xf6b6
		},
		{
		0x9dc8,
		0xf6c2
		},
		{
		0x9dca,
		0xf6b7
		},
		{
		0x9dcb,
		0xf7bb
		},
		{
		0x9dcc,
		0xf6c5
		},
		{
		0x9dcd,
		0xf6c7
		},
		{
		0x9dce,
		0xf6be
		},
		{
		0x9dcf,
		0xf6b8
		},
		{
		0x9dd0,
		0xf7bc
		},
		{
		0x9dd1,
		0xf7be
		},
		{
		0x9dd2,
		0xf7b8
		},
		{
		0x9dd3,
		0xc5c2
		},
		{
		0x9dd5,
		0xf7c5
		},
		{
		0x9dd6,
		0xf7c3
		},
		{
		0x9dd7,
		0xc5c3
		},
		{
		0x9dd8,
		0xf7c2
		},
		{
		0x9dd9,
		0xf7c1
		},
		{
		0x9dda,
		0xf7ba
		},
		{
		0x9ddb,
		0xf7b7
		},
		{
		0x9ddc,
		0xf7bd
		},
		{
		0x9ddd,
		0xf7c6
		},
		{
		0x9dde,
		0xf7b9
		},
		{
		0x9ddf,
		0xf7bf
		},
		{
		0x9de1,
		0xf869
		},
		{
		0x9de2,
		0xf86e
		},
		{
		0x9de3,
		0xf864
		},
		{
		0x9de4,
		0xf867
		},
		{
		0x9de5,
		0xc5ee
		},
		{
		0x9de6,
		0xf86b
		},
		{
		0x9de8,
		0xf872
		},
		{
		0x9de9,
		0xf7c0
		},
		{
		0x9deb,
		0xf865
		},
		{
		0x9dec,
		0xf86f
		},
		{
		0x9ded,
		0xf873
		},
		{
		0x9dee,
		0xf86a
		},
		{
		0x9def,
		0xf863
		},
		{
		0x9df0,
		0xf86d
		},
		{
		0x9df2,
		0xf86c
		},
		{
		0x9df3,
		0xf871
		},
		{
		0x9df4,
		0xf870
		},
		{
		0x9df5,
		0xf7c4
		},
		{
		0x9df6,
		0xf868
		},
		{
		0x9df7,
		0xf862
		},
		{
		0x9df8,
		0xf866
		},
		{
		0x9df9,
		0xc64e
		},
		{
		0x9dfa,
		0xc64f
		},
		{
		0x9dfb,
		0xf861
		},
		{
		0x9dfd,
		0xf8e6
		},
		{
		0x9dfe,
		0xf8dd
		},
		{
		0x9dff,
		0xf8e5
		},
		{
		0x9e00,
		0xf8e2
		},
		{
		0x9e01,
		0xf8e3
		},
		{
		0x9e02,
		0xf8dc
		},
		{
		0x9e03,
		0xf8df
		},
		{
		0x9e04,
		0xf8e7
		},
		{
		0x9e05,
		0xf8e1
		},
		{
		0x9e06,
		0xf8e0
		},
		{
		0x9e07,
		0xf8de
		},
		{
		0x9e09,
		0xf8e4
		},
		{
		0x9e0b,
		0xf95d
		},
		{
		0x9e0d,
		0xf95e
		},
		{
		0x9e0f,
		0xf960
		},
		{
		0x9e10,
		0xf95f
		},
		{
		0x9e11,
		0xf962
		},
		{
		0x9e12,
		0xf961
		},
		{
		0x9e13,
		0xf97c
		},
		{
		0x9e14,
		0xf97b
		},
		{
		0x9e15,
		0xf9b7
		},
		{
		0x9e17,
		0xf9b8
		},
		{
		0x9e19,
		0xf9c5
		},
		{
		0x9e1a,
		0xc678
		},
		{
		0x9e1b,
		0xc67c
		},
		{
		0x9e1d,
		0xf9cf
		},
		{
		0x9e1e,
		0xc67d
		},
		{
		0x9e75,
		0xb3bf
		},
		{
		0x9e79,
		0xc4d0
		},
		{
		0x9e7a,
		0xf6c9
		},
		{
		0x9e7c,
		0xc650
		},
		{
		0x9e7d,
		0xc651
		},
		{
		0x9e7f,
		0xb3c0
		},
		{
		0x9e80,
		0xe0ee
		},
		{
		0x9e82,
		0xb9a8
		},
		{
		0x9e83,
		0xe8f0
		},
		{
		0x9e86,
		0xecb0
		},
		{
		0x9e87,
		0xecb1
		},
		{
		0x9e88,
		0xecaf
		},
		{
		0x9e89,
		0xefab
		},
		{
		0x9e8a,
		0xefaa
		},
		{
		0x9e8b,
		0xc247
		},
		{
		0x9e8c,
		0xf1df
		},
		{
		0x9e8d,
		0xefac
		},
		{
		0x9e8e,
		0xf1de
		},
		{
		0x9e91,
		0xf3f3
		},
		{
		0x9e92,
		0xc451
		},
		{
		0x9e93,
		0xc453
		},
		{
		0x9e94,
		0xf3f2
		},
		{
		0x9e97,
		0xc452
		},
		{
		0x9e99,
		0xf5b1
		},
		{
		0x9e9a,
		0xf5b3
		},
		{
		0x9e9b,
		0xf5b2
		},
		{
		0x9e9c,
		0xf6ca
		},
		{
		0x9e9d,
		0xc565
		},
		{
		0x9e9f,
		0xc5ef
		},
		{
		0x9ea0,
		0xf8e8
		},
		{
		0x9ea1,
		0xf963
		},
		{
		0x9ea4,
		0xf9d2
		},
		{
		0x9ea5,
		0xb3c1
		},
		{
		0x9ea7,
		0xe4e5
		},
		{
		0x9ea9,
		0xbea2
		},
		{
		0x9ead,
		0xecb3
		},
		{
		0x9eae,
		0xecb2
		},
		{
		0x9eb0,
		0xefad
		},
		{
		0x9eb4,
		0xc454
		},
		{
		0x9eb5,
		0xc4d1
		},
		{
		0x9eb6,
		0xf7c7
		},
		{
		0x9eb7,
		0xf9cb
		},
		{
		0x9ebb,
		0xb3c2
		},
		{
		0x9ebc,
		0xbbf2
		},
		{
		0x9ebe,
		0xbea3
		},
		{
		0x9ec0,
		0xf3f4
		},
		{
		0x9ec2,
		0xf874
		},
		{
		0x9ec3,
		0xb6c0
		},
		{
		0x9ec8,
		0xefae
		},
		{
		0x9ecc,
		0xc664
		},
		{
		0x9ecd,
		0xb6c1
		},
		{
		0x9ece,
		0xbea4
		},
		{
		0x9ecf,
		0xc248
		},
		{
		0x9ed0,
		0xf875
		},
		{
		0x9ed1,
		0xb6c2
		},
		{
		0x9ed3,
		0xe8f1
		},
		{
		0x9ed4,
		0xc072
		},
		{
		0x9ed5,
		0xecb4
		},
		{
		0x9ed6,
		0xecb5
		},
		{
		0x9ed8,
		0xc071
		},
		{
		0x9eda,
		0xefaf
		},
		{
		0x9edb,
		0xc24c
		},
		{
		0x9edc,
		0xc24a
		},
		{
		0x9edd,
		0xc24b
		},
		{
		0x9ede,
		0xc249
		},
		{
		0x9edf,
		0xf1e0
		},
		{
		0x9ee0,
		0xc35c
		},
		{
		0x9ee4,
		0xf5b5
		},
		{
		0x9ee5,
		0xf5b4
		},
		{
		0x9ee6,
		0xf5b7
		},
		{
		0x9ee7,
		0xf5b6
		},
		{
		0x9ee8,
		0xc4d2
		},
		{
		0x9eeb,
		0xf6cb
		},
		{
		0x9eed,
		0xf6cd
		},
		{
		0x9eee,
		0xf6cc
		},
		{
		0x9eef,
		0xc566
		},
		{
		0x9ef0,
		0xf7c8
		},
		{
		0x9ef2,
		0xf876
		},
		{
		0x9ef3,
		0xf877
		},
		{
		0x9ef4,
		0xc5f0
		},
		{
		0x9ef5,
		0xf964
		},
		{
		0x9ef6,
		0xf97d
		},
		{
		0x9ef7,
		0xc675
		},
		{
		0x9ef9,
		0xdcb0
		},
		{
		0x9efa,
		0xecb6
		},
		{
		0x9efb,
		0xefb0
		},
		{
		0x9efc,
		0xf3f5
		},
		{
		0x9efd,
		0xe0ef
		},
		{
		0x9eff,
		0xefb1
		},
		{
		0x9f00,
		0xf1e2
		},
		{
		0x9f01,
		0xf1e1
		},
		{
		0x9f06,
		0xf878
		},
		{
		0x9f07,
		0xc652
		},
		{
		0x9f09,
		0xf965
		},
		{
		0x9f0a,
		0xf97e
		},
		{
		0x9f0e,
		0xb9a9
		},
		{
		0x9f0f,
		0xe8f2
		},
		{
		0x9f10,
		0xe8f3
		},
		{
		0x9f12,
		0xecb7
		},
		{
		0x9f13,
		0xb9aa
		},
		{
		0x9f15,
		0xc35d
		},
		{
		0x9f16,
		0xf1e3
		},
		{
		0x9f18,
		0xf6cf
		},
		{
		0x9f19,
		0xc567
		},
		{
		0x9f1a,
		0xf6d0
		},
		{
		0x9f1b,
		0xf6ce
		},
		{
		0x9f1c,
		0xf879
		},
		{
		0x9f1e,
		0xf8e9
		},
		{
		0x9f20,
		0xb9ab
		},
		{
		0x9f22,
		0xefb4
		},
		{
		0x9f23,
		0xefb3
		},
		{
		0x9f24,
		0xefb2
		},
		{
		0x9f25,
		0xf1e4
		},
		{
		0x9f28,
		0xf1e8
		},
		{
		0x9f29,
		0xf1e7
		},
		{
		0x9f2a,
		0xf1e6
		},
		{
		0x9f2b,
		0xf1e5
		},
		{
		0x9f2c,
		0xc35e
		},
		{
		0x9f2d,
		0xf3f6
		},
		{
		0x9f2e,
		0xf5b9
		},
		{
		0x9f2f,
		0xc4d3
		},
		{
		0x9f30,
		0xf5b8
		},
		{
		0x9f31,
		0xf6d1
		},
		{
		0x9f32,
		0xf7cb
		},
		{
		0x9f33,
		0xf7ca
		},
		{
		0x9f34,
		0xc5c4
		},
		{
		0x9f35,
		0xf7c9
		},
		{
		0x9f36,
		0xf87c
		},
		{
		0x9f37,
		0xf87b
		},
		{
		0x9f38,
		0xf87a
		},
		{
		0x9f3b,
		0xbbf3
		},
		{
		0x9f3d,
		0xecb8
		},
		{
		0x9f3e,
		0xc24d
		},
		{
		0x9f40,
		0xf3f7
		},
		{
		0x9f41,
		0xf3f8
		},
		{
		0x9f42,
		0xf7cc
		},
		{
		0x9f43,
		0xf87d
		},
		{
		0x9f46,
		0xf8ea
		},
		{
		0x9f47,
		0xf966
		},
		{
		0x9f48,
		0xf9b9
		},
		{
		0x9f49,
		0xf9d4
		},
		{
		0x9f4a,
		0xbbf4
		},
		{
		0x9f4b,
		0xc24e
		},
		{
		0x9f4c,
		0xf1e9
		},
		{
		0x9f4d,
		0xf3f9
		},
		{
		0x9f4e,
		0xf6d2
		},
		{
		0x9f4f,
		0xf87e
		},
		{
		0x9f52,
		0xbea6
		},
		{
		0x9f54,
		0xefb5
		},
		{
		0x9f55,
		0xf1ea
		},
		{
		0x9f56,
		0xf3fa
		},
		{
		0x9f57,
		0xf3fb
		},
		{
		0x9f58,
		0xf3fc
		},
		{
		0x9f59,
		0xf5be
		},
		{
		0x9f5b,
		0xf5ba
		},
		{
		0x9f5c,
		0xc568
		},
		{
		0x9f5d,
		0xf5bd
		},
		{
		0x9f5e,
		0xf5bc
		},
		{
		0x9f5f,
		0xc4d4
		},
		{
		0x9f60,
		0xf5bb
		},
		{
		0x9f61,
		0xc4d6
		},
		{
		0x9f63,
		0xc4d5
		},
		{
		0x9f64,
		0xf6d4
		},
		{
		0x9f65,
		0xf6d3
		},
		{
		0x9f66,
		0xc569
		},
		{
		0x9f67,
		0xc56a
		},
		{
		0x9f6a,
		0xc5c6
		},
		{
		0x9f6b,
		0xf7cd
		},
		{
		0x9f6c,
		0xc5c5
		},
		{
		0x9f6e,
		0xf8a3
		},
		{
		0x9f6f,
		0xf8a4
		},
		{
		0x9f70,
		0xf8a2
		},
		{
		0x9f71,
		0xf8a1
		},
		{
		0x9f72,
		0xc654
		},
		{
		0x9f74,
		0xf8eb
		},
		{
		0x9f75,
		0xf8ec
		},
		{
		0x9f76,
		0xf8ed
		},
		{
		0x9f77,
		0xc653
		},
		{
		0x9f78,
		0xf967
		},
		{
		0x9f79,
		0xf96a
		},
		{
		0x9f7a,
		0xf969
		},
		{
		0x9f7b,
		0xf968
		},
		{
		0x9f7e,
		0xf9d3
		},
		{
		0x9f8d,
		0xc073
		},
		{
		0x9f90,
		0xc365
		},
		{
		0x9f91,
		0xf5bf
		},
		{
		0x9f92,
		0xf6d5
		},
		{
		0x9f94,
		0xc5c7
		},
		{
		0x9f95,
		0xf7ce
		},
		{
		0x9f98,
		0xf9d5
		},
		{
		0x9f9c,
		0xc074
		},
		{
		0x9fa0,
		0xefb6
		},
		{
		0x9fa2,
		0xf7cf
		},
		{
		0x9fa4,
		0xf9a1
		},
		{
		0xfa0c,
		0xc94a
		},
		{
		0xfa0d,
		0xddfc
		},
		{
		0xfe30,
		0xa14a
		},
		{
		0xfe31,
		0xa157
		},
		{
		0xfe33,
		0xa159
		},
		{
		0xfe34,
		0xa15b
		},
		{
		0xfe35,
		0xa15f
		},
		{
		0xfe36,
		0xa160
		},
		{
		0xfe37,
		0xa163
		},
		{
		0xfe38,
		0xa164
		},
		{
		0xfe39,
		0xa167
		},
		{
		0xfe3a,
		0xa168
		},
		{
		0xfe3b,
		0xa16b
		},
		{
		0xfe3c,
		0xa16c
		},
		{
		0xfe3d,
		0xa16f
		},
		{
		0xfe3e,
		0xa170
		},
		{
		0xfe3f,
		0xa173
		},
		{
		0xfe40,
		0xa174
		},
		{
		0xfe41,
		0xa177
		},
		{
		0xfe42,
		0xa178
		},
		{
		0xfe43,
		0xa17b
		},
		{
		0xfe44,
		0xa17c
		},
		{
		0xfe49,
		0xa1c6
		},
		{
		0xfe4a,
		0xa1c7
		},
		{
		0xfe4b,
		0xa1ca
		},
		{
		0xfe4c,
		0xa1cb
		},
		{
		0xfe4d,
		0xa1c8
		},
		{
		0xfe4e,
		0xa1c9
		},
		{
		0xfe4f,
		0xa15c
		},
		{
		0xfe50,
		0xa14d
		},
		{
		0xfe52,
		0xa14f
		},
		{
		0xfe54,
		0xa151
		},
		{
		0xfe55,
		0xa152
		},
		{
		0xfe56,
		0xa153
		},
		{
		0xfe57,
		0xa154
		},
		{
		0xfe59,
		0xa17d
		},
		{
		0xfe5a,
		0xa17e
		},
		{
		0xfe5b,
		0xa1a1
		},
		{
		0xfe5c,
		0xa1a2
		},
		{
		0xfe5d,
		0xa1a3
		},
		{
		0xfe5e,
		0xa1a4
		},
		{
		0xfe5f,
		0xa1cc
		},
		{
		0xfe60,
		0xa1cd
		},
		{
		0xfe61,
		0xa1ce
		},
		{
		0xfe62,
		0xa1de
		},
		{
		0xfe63,
		0xa1df
		},
		{
		0xfe64,
		0xa1e0
		},
		{
		0xfe65,
		0xa1e1
		},
		{
		0xfe66,
		0xa1e2
		},
		{
		0xfe69,
		0xa24c
		},
		{
		0xfe6a,
		0xa24d
		},
		{
		0xfe6b,
		0xa24e
		},
		{
		0xff01,
		0xa149
		},
		{
		0xff03,
		0xa1ad
		},
		{
		0xff04,
		0xa243
		},
		{
		0xff05,
		0xa248
		},
		{
		0xff06,
		0xa1ae
		},
		{
		0xff08,
		0xa15d
		},
		{
		0xff09,
		0xa15e
		},
		{
		0xff0a,
		0xa1af
		},
		{
		0xff0b,
		0xa1cf
		},
		{
		0xff0c,
		0xa141
		},
		{
		0xff0d,
		0xa1d0
		},
		{
		0xff0e,
		0xa144
		},
		{
		0xff0f,
		0xa241
		},
		{
		0xff1a,
		0xa147
		},
		{
		0xff1b,
		0xa146
		},
		{
		0xff1c,
		0xa1d5
		},
		{
		0xff1d,
		0xa1d7
		},
		{
		0xff1e,
		0xa1d6
		},
		{
		0xff1f,
		0xa148
		},
		{
		0xff20,
		0xa249
		},
		{
		0xff3c,
		0xa242
		},
		{
		0xff3f,
		0xa1c4
		},
		{
		0xff57,
		0xa340
		},
		{
		0xff58,
		0xa341
		},
		{
		0xff59,
		0xa342
		},
		{
		0xff5a,
		0xa343
		},
		{
		0xff5b,
		0xa161
		},
		{
		0xff5c,
		0xa155
		},
		{
		0xff5d,
		0xa162
		},
		{
		0xff64,
		0xa14e
		}
	};

LOCAL_D const SCnvConversionData::SVariableByteData::SRange foreignVariableByteDataRanges[]=
	{
		{
		0x00,
		0x7f,
		0,
		0
		},
		{
		0x80,
		0xff,
		1,
		0
		}
	};

LOCAL_D const SCnvConversionData::SOneDirectionData::SRange foreignToUnicodeDataRanges[]=
	{
		{
		0x00,
		0x7f,
		SCnvConversionData::SOneDirectionData::SRange::EDirect,
		0,
		0,
			{
			0
			}
		},
		{
		0xa2af,
		0xa2b8,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, 23649)
			}
		},
		{
		0xa2b9,
		0xa2c2,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -33113)
			}
		},
		{
		0xa2c3,
		0xa2cb,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -29346)
			}
		},
		{
		0xa2cf,
		0xa2e8,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, 23634)
			}
		},
		{
		0xa2e9,
		0xa2fe,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, 23640)
			}
		},
		{
		0xa344,
		0xa354,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -40883)
			}
		},
		{
		0xa355,
		0xa35b,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -40882)
			}
		},
		{
		0xa35c,
		0xa36c,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -40875)
			}
		},
		{
		0xa36d,
		0xa373,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -40874)
			}
		},
		{
		0xa374,
		0xa37e,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -29295)
			}
		},
		{
		0xa3a1,
		0xa3ba,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -29329)
			}
		},
		{
		0xc6a5,
		0xc6f7,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -38500)
			}
		},
		{
		0xc6f8,
		0xc6fe,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -38487)
			}
		},
		{
		0xc740,
		0xc77e,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -38552)
			}
		},
		{
		0xc7a1,
		0xc7b0,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -38586)
			}
		},
		{
		0xc7b4,
		0xc7ba,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -50078)
			}
		},
		{
		0xc7bb,
		0xc7cd,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -50072)
			}
		},
		{
		0xc7cf,
		0xc7e8,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -50073)
			}
		},
		{
		0xc7e9,
		0xc7f2,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -41865)
			}
		},
		{
		0xc7f3,
		0xc7fc,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -41855)
			}
		},
		{
		0xa140,
		0xf9d5,
		SCnvConversionData::SOneDirectionData::SRange::EKeyedTable16OfIndexedTables16,
		0,
		0,
			{
			UData_SKeyedTable16OfIndexedTables16(keyedTables16OfIndexedTables16_keyedEntries_foreignToUnicode_1)
			}
		},
		{
		0xa1c4,
		0xc7ce,
		SCnvConversionData::SOneDirectionData::SRange::EKeyedTable1616,
		0,
		0,
			{
			UData_SKeyedTable1616(keyedTable1616_foreignToUnicode_1)
			}
		}
	};

LOCAL_D const SCnvConversionData::SOneDirectionData::SRange unicodeToForeignDataRanges[]=
	{
		{
		0x0000,
		0x007f,
		SCnvConversionData::SOneDirectionData::SRange::EDirect,
		1,
		0,
			{
			0
			}
		},
		{
		0x0391,
		0x03a1,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 40883)
			}
		},
		{
		0x03a3,
		0x03a9,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 40882)
			}
		},
		{
		0x03b1,
		0x03c1,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 40875)
			}
		},
		{
		0x03c3,
		0x03c9,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 40874)
			}
		},
		{
		0x0416,
		0x041c,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 50078)
			}
		},
		{
		0x0423,
		0x0435,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 50072)
			}
		},
		{
		0x0436,
		0x044f,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 50073)
			}
		},
		{
		0x2160,
		0x2169,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 33113)
			}
		},
		{
		0x2460,
		0x2469,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 41865)
			}
		},
		{
		0x2474,
		0x247d,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 41855)
			}
		},
		{
		0x2581,
		0x2588,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 31969)
			}
		},
		{
		0x3021,
		0x3029,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 29346)
			}
		},
		{
		0x3041,
		0x3093,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 38500)
			}
		},
		{
		0x30a1,
		0x30a7,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 38487)
			}
		},
		{
		0x30a8,
		0x30e6,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 38552)
			}
		},
		{
		0x30e7,
		0x30f6,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 38586)
			}
		},
		{
		0x3105,
		0x310f,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 29295)
			}
		},
		{
		0x3110,
		0x3129,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 29329)
			}
		},
		{
		0xff10,
		0xff19,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, -23649)
			}
		},
		{
		0xff21,
		0xff3a,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, -23634)
			}
		},
		{
		0xff41,
		0xff56,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, -23640)
			}
		},
		{
		0x00a2,
		0xff64,
		SCnvConversionData::SOneDirectionData::SRange::EKeyedTable1616,
		2,
		0,
			{
			UData_SKeyedTable1616(keyedTable1616_unicodeToForeign_1)
			}
		}
	};

GLDEF_D const SCnvConversionData conversionData=
	{
	SCnvConversionData::EFixedBigEndian,
		{
		ARRAY_LENGTH(foreignVariableByteDataRanges),
		foreignVariableByteDataRanges
		},
		{
		ARRAY_LENGTH(foreignToUnicodeDataRanges),
		foreignToUnicodeDataRanges
		},
		{
		ARRAY_LENGTH(unicodeToForeignDataRanges),
		unicodeToForeignDataRanges
		},
	NULL,
	NULL
	};

