/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/


#include <e32std.h>
#include <convdata.h>
#include <convgeneratedcpp.h>

#define ARRAY_LENGTH(aArray) (sizeof(aArray)/sizeof((aArray)[0]))

#pragma warning (disable: 4049) // compiler limit : terminating line number emission

_LIT8(KLit8ReplacementForUnconvertibleUnicodeCharacters, "\xa3\xbf");

GLDEF_C const TDesC8& ReplacementForUnconvertibleUnicodeCharacters_internal()
	{
	return KLit8ReplacementForUnconvertibleUnicodeCharacters;
	}

LOCAL_D const SCnvConversionData::SOneDirectionData::SRange::UData::SKeyedTable1616::SEntry keyedTable1616_foreignToUnicode_1[]=
	{
		{
		0xa3a1,
		0xff01
		},
		{
		0xa3a2,
		0xff02
		},
		{
		0xa3a3,
		0xff03
		},
		{
		0xa3a4,
		0xffe5
		},
		{
		0xa3fe,
		0xffe3
		},
		{
		0xa7a7,
		0x0401
		},
		{
		0xa7d7,
		0x0451
		}
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_1[]=
	{
	0x3000,
	0x3001,
	0x3002,
	0x00b7,
	0x02c9,
	0x02c7,
	0x00a8,
	0x3003,
	0x3005,
	0x2015,
	0xff5e,
	0x2016,
	0x2026,
	0x2018,
	0x2019,
	0x201c,
	0x201d,
	0x3014,
	0x3015,
	0x3008,
	0x3009,
	0x300a,
	0x300b,
	0x300c,
	0x300d,
	0x300e,
	0x300f,
	0x3016,
	0x3017,
	0x3010,
	0x3011,
	0x00b1,
	0x00d7,
	0x00f7,
	0x2236,
	0x2227,
	0x2228,
	0x2211,
	0x220f,
	0x222a,
	0x2229,
	0x2208,
	0x2237,
	0x221a,
	0x22a5,
	0x2225,
	0x2220,
	0x2312,
	0x2299,
	0x222b,
	0x222e,
	0x2261,
	0x224c,
	0x2248,
	0x223d,
	0x221d,
	0x2260,
	0x226e,
	0x226f,
	0x2264,
	0x2265,
	0x221e,
	0x2235,
	0x2234,
	0x2642,
	0x2640,
	0x00b0,
	0x2032,
	0x2033,
	0x2103,
	0xff04,
	0x00a4,
	0xffe0,
	0xffe1,
	0x2030,
	0x00a7,
	0x2116,
	0x2606,
	0x2605,
	0x25cb,
	0x25cf,
	0x25ce,
	0x25c7,
	0x25c6,
	0x25a1,
	0x25a0,
	0x25b3,
	0x25b2,
	0x203b,
	0x2192,
	0x2190,
	0x2191,
	0x2193,
	0x3013
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_2[]=
	{
	0x0101,
	0x00e1,
	0x01ce,
	0x00e0,
	0x0113,
	0x00e9,
	0x011b,
	0x00e8,
	0x012b,
	0x00ed,
	0x01d0,
	0x00ec,
	0x014d,
	0x00f3,
	0x01d2,
	0x00f2,
	0x016b,
	0x00fa,
	0x01d4,
	0x00f9,
	0x01d6,
	0x01d8,
	0x01da,
	0x01dc,
	0x00fc,
	0x00ea
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_3[]=
	{
	0x554a,
	0x963f,
	0x57c3,
	0x6328,
	0x54ce,
	0x5509,
	0x54c0,
	0x769a,
	0x764c,
	0x85f9,
	0x77ee,
	0x827e,
	0x7919,
	0x611b,
	0x9698,
	0x978d,
	0x6c28,
	0x5b89,
	0x4ffa,
	0x6309,
	0x6697,
	0x5cb8,
	0x80fa,
	0x6848,
	0x9aaf,
	0x6602,
	0x76ce,
	0x51f9,
	0x6556,
	0x71ac,
	0x7ff1,
	0x8956,
	0x50b2,
	0x5965,
	0x61ca,
	0x6fb3,
	0x82ad,
	0x634c,
	0x6252,
	0x53ed,
	0x5427,
	0x7b06,
	0x516b,
	0x75a4,
	0x5df4,
	0x62d4,
	0x8dcb,
	0x9776,
	0x628a,
	0x8019,
	0x58e9,
	0x9738,
	0x7f77,
	0x7238,
	0x767d,
	0x67cf,
	0x767e,
	0x64fa,
	0x4f70,
	0x6557,
	0x62dc,
	0x7a17,
	0x6591,
	0x73ed,
	0x642c,
	0x6273,
	0x822c,
	0x9812,
	0x677f,
	0x7248,
	0x626e,
	0x62cc,
	0x4f34,
	0x74e3,
	0x534a,
	0x8fa6,
	0x7d46,
	0x90a6,
	0x5e6b,
	0x6886,
	0x699c,
	0x8180,
	0x7d81,
	0x68d2,
	0x78c5,
	0x868c,
	0x938a,
	0x508d,
	0x8b17,
	0x82de,
	0x80de,
	0x5305,
	0x8912,
	0x5265
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_4[]=
	{
	0x8584,
	0x96f9,
	0x4fdd,
	0x5821,
	0x98fd,
	0x5bf6,
	0x62b1,
	0x5831,
	0x66b4,
	0x8c79,
	0x9b91,
	0x7206,
	0x676f,
	0x7891,
	0x60b2,
	0x5351,
	0x5317,
	0x8f29,
	0x80cc,
	0x8c9d,
	0x92c7,
	0x500d,
	0x72fd,
	0x5099,
	0x618a,
	0x7119,
	0x88ab,
	0x5954,
	0x82ef,
	0x672c,
	0x7b28,
	0x5d29,
	0x7db3,
	0x752d,
	0x6cf5,
	0x8e66,
	0x8ff8,
	0x903c,
	0x9f3b,
	0x6bd4,
	0x9119,
	0x7b46,
	0x5f7c,
	0x78a7,
	0x84d6,
	0x853d,
	0x7562,
	0x6583,
	0x6bd6,
	0x5e63,
	0x5e87,
	0x75f9,
	0x9589,
	0x655d,
	0x5f0a,
	0x5fc5,
	0x8f9f,
	0x58c1,
	0x81c2,
	0x907f,
	0x965b,
	0x97ad,
	0x908a,
	0x7de8,
	0x8cb6,
	0x6241,
	0x4fbf,
	0x8b8a,
	0x535e,
	0x8fa8,
	0x8faf,
	0x8fae,
	0x904d,
	0x6a19,
	0x5f6a,
	0x8198,
	0x8868,
	0x9c49,
	0x618b,
	0x522b,
	0x765f,
	0x5f6c,
	0x658c,
	0x7015,
	0x6ff1,
	0x8cd3,
	0x64ef,
	0x5175,
	0x51b0,
	0x67c4,
	0x4e19,
	0x79c9,
	0x9905,
	0x70b3
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_5[]=
	{
	0x75c5,
	0x5e76,
	0x73bb,
	0x83e0,
	0x64ad,
	0x64a5,
	0x9262,
	0x6ce2,
	0x535a,
	0x52c3,
	0x640f,
	0x9251,
	0x7b94,
	0x4f2f,
	0x5e1b,
	0x8236,
	0x8116,
	0x818a,
	0x6e24,
	0x6cca,
	0x99c1,
	0x6355,
	0x535c,
	0x54fa,
	0x88dc,
	0x57e0,
	0x4e0d,
	0x5e03,
	0x6b65,
	0x7c3f,
	0x90e8,
	0x6016,
	0x64e6,
	0x731c,
	0x88c1,
	0x6750,
	0x624d,
	0x8ca1,
	0x776c,
	0x8e29,
	0x91c7,
	0x5f69,
	0x83dc,
	0x8521,
	0x9910,
	0x53c3,
	0x8836,
	0x6b98,
	0x615a,
	0x6158,
	0x71e6,
	0x84bc,
	0x8259,
	0x5009,
	0x6ec4,
	0x85cf,
	0x64cd,
	0x7cd9,
	0x69fd,
	0x66f9,
	0x8349,
	0x53a0,
	0x7b56,
	0x5074,
	0x518c,
	0x6e2c,
	0x5c64,
	0x8e6d,
	0x63d2,
	0x53c9,
	0x832c,
	0x8336,
	0x67e5,
	0x78b4,
	0x643d,
	0x5bdf,
	0x5c94,
	0x5dee,
	0x8a6b,
	0x62c6,
	0x67f4,
	0x8c7a,
	0x6519,
	0x647b,
	0x87ec,
	0x995e,
	0x8b92,
	0x7e8f,
	0x93df,
	0x7523,
	0x95e1,
	0x986b,
	0x660c,
	0x7316
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_6[]=
	{
	0x5834,
	0x5617,
	0x5e38,
	0x9577,
	0x511f,
	0x8178,
	0x5ee0,
	0x655e,
	0x66a2,
	0x5531,
	0x5021,
	0x8d85,
	0x6284,
	0x9214,
	0x671d,
	0x5632,
	0x6f6e,
	0x5de2,
	0x5435,
	0x7092,
	0x8eca,
	0x626f,
	0x64a4,
	0x63a3,
	0x5fb9,
	0x6f88,
	0x90f4,
	0x81e3,
	0x8fb0,
	0x5875,
	0x6668,
	0x5ff1,
	0x6c89,
	0x9673,
	0x8d81,
	0x896f,
	0x6491,
	0x7a31,
	0x57ce,
	0x6a59,
	0x6210,
	0x5448,
	0x4e58,
	0x7a0b,
	0x61f2,
	0x6f84,
	0x8aa0,
	0x627f,
	0x901e,
	0x9a01,
	0x79e4,
	0x5403,
	0x75f4,
	0x6301,
	0x5319,
	0x6c60,
	0x9072,
	0x5f1b,
	0x99b3,
	0x803b,
	0x9f52,
	0x4f88,
	0x5c3a,
	0x8d64,
	0x7fc5,
	0x65a5,
	0x71be,
	0x5145,
	0x885d,
	0x87f2,
	0x5d07,
	0x5bf5,
	0x62bd,
	0x916c,
	0x7587,
	0x8e8a,
	0x7a20,
	0x6101,
	0x7c4c,
	0x4ec7,
	0x7da2,
	0x7785,
	0x919c,
	0x81ed,
	0x521d,
	0x51fa,
	0x6a71,
	0x53a8,
	0x8e87,
	0x92e4,
	0x96db,
	0x6ec1,
	0x9664,
	0x695a
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_7[]=
	{
	0x790e,
	0x5132,
	0x77d7,
	0x6410,
	0x89f8,
	0x8655,
	0x63e3,
	0x5ddd,
	0x7a7f,
	0x693d,
	0x50b3,
	0x8239,
	0x5598,
	0x4e32,
	0x7621,
	0x7a97,
	0x5e62,
	0x5e8a,
	0x95d6,
	0x5275,
	0x5439,
	0x708a,
	0x6376,
	0x9318,
	0x5782,
	0x6625,
	0x693f,
	0x9187,
	0x5507,
	0x6df3,
	0x7d14,
	0x8822,
	0x6233,
	0x7dbd,
	0x75b5,
	0x8328,
	0x78c1,
	0x96cc,
	0x8fad,
	0x6148,
	0x74f7,
	0x8a5e,
	0x6b64,
	0x523a,
	0x8cdc,
	0x6b21,
	0x8070,
	0x8471,
	0x56f1,
	0x5306,
	0x5f9e,
	0x53e2,
	0x51d1,
	0x7c97,
	0x918b,
	0x7c07,
	0x4fc3,
	0x8ea5,
	0x7be1,
	0x7ac4,
	0x6467,
	0x5d14,
	0x50ac,
	0x8106,
	0x7601,
	0x7cb9,
	0x6dec,
	0x7fe0,
	0x6751,
	0x5b58,
	0x5bf8,
	0x78cb,
	0x64ae,
	0x6413,
	0x63aa,
	0x632b,
	0x932f,
	0x642d,
	0x9054,
	0x7b54,
	0x7629,
	0x6253,
	0x5927,
	0x5446,
	0x6b79,
	0x50a3,
	0x6234,
	0x5e36,
	0x6b86,
	0x4ee3,
	0x8cb8,
	0x888b,
	0x5f85,
	0x902e
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_8[]=
	{
	0x6020,
	0x803d,
	0x64d4,
	0x4e39,
	0x55ae,
	0x9132,
	0x64a3,
	0x81bd,
	0x65e6,
	0x6c2e,
	0x4f46,
	0x619a,
	0x6de1,
	0x8a95,
	0x5f48,
	0x86cb,
	0x7576,
	0x64cb,
	0x9ee8,
	0x8569,
	0x6a94,
	0x5200,
	0x6417,
	0x8e48,
	0x5012,
	0x5cf6,
	0x79b1,
	0x5c0e,
	0x5230,
	0x7a3b,
	0x60bc,
	0x9053,
	0x76d7,
	0x5fb7,
	0x5f97,
	0x7684,
	0x8e6c,
	0x71c8,
	0x767b,
	0x7b49,
	0x77aa,
	0x51f3,
	0x9127,
	0x5824,
	0x4f4e,
	0x6ef4,
	0x8fea,
	0x6575,
	0x7b1b,
	0x72c4,
	0x6ecc,
	0x7fdf,
	0x5ae1,
	0x62b5,
	0x5e95,
	0x5730,
	0x8482,
	0x7b2c,
	0x5e1d,
	0x5f1f,
	0x905e,
	0x7de0,
	0x985b,
	0x6382,
	0x6ec7,
	0x7898,
	0x9ede,
	0x5178,
	0x975b,
	0x588a,
	0x96fb,
	0x4f43,
	0x7538,
	0x5e97,
	0x60e6,
	0x5960,
	0x6fb1,
	0x6bbf,
	0x7889,
	0x53fc,
	0x96d5,
	0x51cb,
	0x5201,
	0x6389,
	0x540a,
	0x91e3,
	0x8abf,
	0x8dcc,
	0x7239,
	0x789f,
	0x8776,
	0x8fed,
	0x8adc,
	0x758a
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_9[]=
	{
	0x4e01,
	0x76ef,
	0x53ee,
	0x91d8,
	0x9802,
	0x9f0e,
	0x9320,
	0x5b9a,
	0x8a02,
	0x4e22,
	0x6771,
	0x51ac,
	0x8463,
	0x61c2,
	0x52d5,
	0x68df,
	0x4f97,
	0x606b,
	0x51cd,
	0x6d1e,
	0x515c,
	0x6296,
	0x9b25,
	0x9661,
	0x8c46,
	0x9017,
	0x75d8,
	0x90fd,
	0x7763,
	0x6bd2,
	0x72a2,
	0x7368,
	0x8b80,
	0x5835,
	0x7779,
	0x8ced,
	0x675c,
	0x934d,
	0x809a,
	0x5ea6,
	0x6e21,
	0x5992,
	0x7aef,
	0x77ed,
	0x935b,
	0x6bb5,
	0x65b7,
	0x7dde,
	0x5806,
	0x5151,
	0x968a,
	0x5c0d,
	0x58a9,
	0x5678,
	0x8e72,
	0x6566,
	0x9813,
	0x56e4,
	0x920d,
	0x76fe,
	0x9041,
	0x6387,
	0x54c6,
	0x591a,
	0x596a,
	0x579b,
	0x8eb2,
	0x6735,
	0x8dfa,
	0x8235,
	0x5241,
	0x60f0,
	0x58ae,
	0x86fe,
	0x5ce8,
	0x9d5d,
	0x4fc4,
	0x984d,
	0x8a1b,
	0x5a25,
	0x60e1,
	0x5384,
	0x627c,
	0x904f,
	0x9102,
	0x9913,
	0x6069,
	0x800c,
	0x5152,
	0x8033,
	0x723e,
	0x990c,
	0x6d31,
	0x4e8c
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_10[]=
	{
	0x8cb3,
	0x767c,
	0x7f70,
	0x7b4f,
	0x4f10,
	0x4e4f,
	0x95a5,
	0x6cd5,
	0x73d0,
	0x85e9,
	0x5e06,
	0x756a,
	0x7ffb,
	0x6a0a,
	0x792c,
	0x91e9,
	0x7e41,
	0x51e1,
	0x7169,
	0x53cd,
	0x8fd4,
	0x7bc4,
	0x8ca9,
	0x72af,
	0x98ef,
	0x6cdb,
	0x574a,
	0x82b3,
	0x65b9,
	0x80aa,
	0x623f,
	0x9632,
	0x59a8,
	0x4eff,
	0x8a2a,
	0x7d21,
	0x653e,
	0x83f2,
	0x975e,
	0x5561,
	0x98db,
	0x80a5,
	0x532a,
	0x8ab9,
	0x5420,
	0x80ba,
	0x5ee2,
	0x6cb8,
	0x8cbb,
	0x82ac,
	0x915a,
	0x5429,
	0x6c1b,
	0x5206,
	0x7d1b,
	0x58b3,
	0x711a,
	0x6c7e,
	0x7c89,
	0x596e,
	0x4efd,
	0x5fff,
	0x61a4,
	0x7cde,
	0x8c50,
	0x5c01,
	0x6953,
	0x8702,
	0x5cf0,
	0x92d2,
	0x98a8,
	0x760b,
	0x70fd,
	0x9022,
	0x99ae,
	0x7e2b,
	0x8af7,
	0x5949,
	0x9cf3,
	0x4f5b,
	0x5426,
	0x592b,
	0x6577,
	0x819a,
	0x5b75,
	0x6276,
	0x62c2,
	0x8f3b,
	0x5e45,
	0x6c1f,
	0x7b26,
	0x4f0f,
	0x4fd8,
	0x670d
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_11[]=
	{
	0x6d6e,
	0x6daa,
	0x798f,
	0x88b1,
	0x5f17,
	0x752b,
	0x64ab,
	0x8f14,
	0x4fef,
	0x91dc,
	0x65a7,
	0x812f,
	0x8151,
	0x5e9c,
	0x8150,
	0x8d74,
	0x526f,
	0x8986,
	0x8ce6,
	0x5fa9,
	0x5085,
	0x4ed8,
	0x961c,
	0x7236,
	0x8179,
	0x8ca0,
	0x5bcc,
	0x8a03,
	0x9644,
	0x5a66,
	0x7e1b,
	0x5490,
	0x5676,
	0x560e,
	0x8a72,
	0x6539,
	0x6982,
	0x9223,
	0x84cb,
	0x6e89,
	0x5e79,
	0x7518,
	0x6746,
	0x67d1,
	0x7aff,
	0x809d,
	0x8d95,
	0x611f,
	0x79c6,
	0x6562,
	0x8d1b,
	0x5ca1,
	0x525b,
	0x92fc,
	0x7f38,
	0x809b,
	0x7db1,
	0x5d17,
	0x6e2f,
	0x6760,
	0x7bd9,
	0x768b,
	0x9ad8,
	0x818f,
	0x7f94,
	0x7cd5,
	0x641e,
	0x93ac,
	0x7a3f,
	0x544a,
	0x54e5,
	0x6b4c,
	0x64f1,
	0x6208,
	0x9d3f,
	0x80f3,
	0x7599,
	0x5272,
	0x9769,
	0x845b,
	0x683c,
	0x86e4,
	0x95a3,
	0x9694,
	0x927b,
	0x500b,
	0x5404,
	0x7d66,
	0x6839,
	0x8ddf,
	0x8015,
	0x66f4,
	0x5e9a,
	0x7fb9
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_12[]=
	{
	0x57c2,
	0x803f,
	0x6897,
	0x5de5,
	0x653b,
	0x529f,
	0x606d,
	0x9f94,
	0x4f9b,
	0x8eac,
	0x516c,
	0x5bab,
	0x5f13,
	0x978f,
	0x6c5e,
	0x62f1,
	0x8ca2,
	0x5171,
	0x920e,
	0x52fe,
	0x6e9d,
	0x82df,
	0x72d7,
	0x57a2,
	0x69cb,
	0x8cfc,
	0x591f,
	0x8f9c,
	0x83c7,
	0x5495,
	0x7b8d,
	0x4f30,
	0x6cbd,
	0x5b64,
	0x59d1,
	0x9f13,
	0x53e4,
	0x8831,
	0x9aa8,
	0x8c37,
	0x80a1,
	0x6545,
	0x9867,
	0x56fa,
	0x96c7,
	0x522e,
	0x74dc,
	0x526e,
	0x5be1,
	0x6302,
	0x8902,
	0x4e56,
	0x62d0,
	0x602a,
	0x68fa,
	0x95dc,
	0x5b98,
	0x51a0,
	0x89c0,
	0x7ba1,
	0x9928,
	0x7f50,
	0x6163,
	0x704c,
	0x8cab,
	0x5149,
	0x5ee3,
	0x901b,
	0x7470,
	0x898f,
	0x572d,
	0x7845,
	0x6b78,
	0x9f9c,
	0x95a8,
	0x8ecc,
	0x9b3c,
	0x8a6d,
	0x7678,
	0x6842,
	0x6ac3,
	0x8dea,
	0x8cb4,
	0x528a,
	0x8f25,
	0x6eda,
	0x68cd,
	0x934b,
	0x90ed,
	0x570b,
	0x679c,
	0x88f9,
	0x904e,
	0x54c8
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_13[]=
	{
	0x9ab8,
	0x5b69,
	0x6d77,
	0x6c26,
	0x4ea5,
	0x5bb3,
	0x99ed,
	0x9163,
	0x61a8,
	0x90af,
	0x97d3,
	0x542b,
	0x6db5,
	0x5bd2,
	0x51fd,
	0x558a,
	0x7f55,
	0x7ff0,
	0x64bc,
	0x634d,
	0x65f1,
	0x61be,
	0x608d,
	0x710a,
	0x6c57,
	0x6f22,
	0x592f,
	0x676d,
	0x822a,
	0x58d5,
	0x568e,
	0x8c6a,
	0x6beb,
	0x90dd,
	0x597d,
	0x8017,
	0x865f,
	0x6d69,
	0x5475,
	0x559d,
	0x8377,
	0x83cf,
	0x6838,
	0x79be,
	0x548c,
	0x4f55,
	0x5408,
	0x76d2,
	0x8c89,
	0x95a1,
	0x6cb3,
	0x6db8,
	0x8d6b,
	0x8910,
	0x9db4,
	0x8cc0,
	0x563f,
	0x9ed1,
	0x75d5,
	0x5f88,
	0x72e0,
	0x6068,
	0x54fc,
	0x4ea8,
	0x6a2a,
	0x8861,
	0x6052,
	0x8f5f,
	0x54c4,
	0x70d8,
	0x8679,
	0x9d3b,
	0x6d2a,
	0x5b8f,
	0x5f18,
	0x7d05,
	0x5589,
	0x4faf,
	0x7334,
	0x543c,
	0x539a,
	0x5019,
	0x5f8c,
	0x547c,
	0x4e4e,
	0x5ffd,
	0x745a,
	0x58fa,
	0x846b,
	0x80e1,
	0x8774,
	0x72d0,
	0x7cca,
	0x6e56
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_14[]=
	{
	0x5f27,
	0x864e,
	0x552c,
	0x8b77,
	0x4e92,
	0x6eec,
	0x6237,
	0x82b1,
	0x5629,
	0x83ef,
	0x733e,
	0x6ed1,
	0x756b,
	0x5283,
	0x5316,
	0x8a71,
	0x69d0,
	0x5f8a,
	0x61f7,
	0x6dee,
	0x58de,
	0x6b61,
	0x74b0,
	0x6853,
	0x9084,
	0x7de9,
	0x63db,
	0x60a3,
	0x559a,
	0x7613,
	0x8c62,
	0x7165,
	0x6e19,
	0x5ba6,
	0x5e7b,
	0x8352,
	0x614c,
	0x9ec4,
	0x78fa,
	0x8757,
	0x7c27,
	0x7687,
	0x51f0,
	0x60f6,
	0x714c,
	0x6643,
	0x5e4c,
	0x604d,
	0x8b0a,
	0x7070,
	0x63ee,
	0x8f1d,
	0x5fbd,
	0x6062,
	0x86d4,
	0x56de,
	0x6bc1,
	0x6094,
	0x6167,
	0x5349,
	0x60e0,
	0x6666,
	0x8cc4,
	0x7a62,
	0x6703,
	0x71f4,
	0x532f,
	0x8af1,
	0x8aa8,
	0x7e6a,
	0x8477,
	0x660f,
	0x5a5a,
	0x9b42,
	0x6e3e,
	0x6df7,
	0x8c41,
	0x6d3b,
	0x4f19,
	0x706b,
	0x7372,
	0x6216,
	0x60d1,
	0x970d,
	0x8ca8,
	0x798d,
	0x64ca,
	0x573e,
	0x57fa,
	0x6a5f,
	0x7578,
	0x7a3d,
	0x7a4d,
	0x7b95
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_15[]=
	{
	0x808c,
	0x9951,
	0x8ff9,
	0x6fc0,
	0x8b4f,
	0x9dc4,
	0x59ec,
	0x7e3e,
	0x7ddd,
	0x5409,
	0x6975,
	0x68d8,
	0x8f2f,
	0x7c4d,
	0x96c6,
	0x53ca,
	0x6025,
	0x75be,
	0x6c72,
	0x5373,
	0x5ac9,
	0x7d1a,
	0x64e0,
	0x5e7e,
	0x810a,
	0x5df1,
	0x858a,
	0x6280,
	0x5180,
	0x5b63,
	0x4f0e,
	0x796d,
	0x5291,
	0x60b8,
	0x6fdf,
	0x5bc4,
	0x5bc2,
	0x8a08,
	0x8a18,
	0x65e2,
	0x5fcc,
	0x969b,
	0x5993,
	0x7e7c,
	0x7d00,
	0x5609,
	0x67b7,
	0x593e,
	0x4f73,
	0x5bb6,
	0x52a0,
	0x83a2,
	0x9830,
	0x8cc8,
	0x7532,
	0x9240,
	0x5047,
	0x7a3c,
	0x50f9,
	0x67b6,
	0x99d5,
	0x5ac1,
	0x6bb2,
	0x76e3,
	0x5805,
	0x5c16,
	0x7b8b,
	0x9593,
	0x714e,
	0x517c,
	0x80a9,
	0x8271,
	0x5978,
	0x7dd8,
	0x7e6d,
	0x6aa2,
	0x67ec,
	0x78b1,
	0x9e7c,
	0x63c0,
	0x64bf,
	0x7c21,
	0x5109,
	0x526a,
	0x51cf,
	0x85a6,
	0x6abb,
	0x9452,
	0x8e10,
	0x8ce4,
	0x898b,
	0x9375,
	0x7bad,
	0x4ef6
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_16[]=
	{
	0x5065,
	0x8266,
	0x528d,
	0x991e,
	0x6f38,
	0x6ffa,
	0x6f97,
	0x5efa,
	0x50f5,
	0x59dc,
	0x5c07,
	0x6f3f,
	0x6c5f,
	0x7586,
	0x8523,
	0x69f3,
	0x596c,
	0x8b1b,
	0x5320,
	0x91ac,
	0x964d,
	0x8549,
	0x6912,
	0x7901,
	0x7126,
	0x81a0,
	0x4ea4,
	0x90ca,
	0x6f86,
	0x9a55,
	0x5b0c,
	0x56bc,
	0x652a,
	0x9278,
	0x77ef,
	0x50e5,
	0x811a,
	0x72e1,
	0x89d2,
	0x9903,
	0x7e73,
	0x7d5e,
	0x527f,
	0x6559,
	0x9175,
	0x8f4e,
	0x8f03,
	0x53eb,
	0x7a96,
	0x63ed,
	0x63a5,
	0x7686,
	0x79f8,
	0x8857,
	0x968e,
	0x622a,
	0x52ab,
	0x7bc0,
	0x6854,
	0x6770,
	0x6377,
	0x776b,
	0x7aed,
	0x6f54,
	0x7d50,
	0x89e3,
	0x59d0,
	0x6212,
	0x85c9,
	0x82a5,
	0x754c,
	0x501f,
	0x4ecb,
	0x75a5,
	0x8aa1,
	0x5c4a,
	0x5dfe,
	0x7b4b,
	0x65a4,
	0x91d1,
	0x4eca,
	0x6d25,
	0x895f,
	0x7dca,
	0x9326,
	0x50c5,
	0x8b39,
	0x9032,
	0x9773,
	0x6649,
	0x7981,
	0x8fd1,
	0x71fc,
	0x6d78
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_17[]=
	{
	0x76e1,
	0x52c1,
	0x8346,
	0x5162,
	0x8396,
	0x775b,
	0x6676,
	0x9be8,
	0x4eac,
	0x9a5a,
	0x7cbe,
	0x7cb3,
	0x7d93,
	0x4e95,
	0x8b66,
	0x666f,
	0x9838,
	0x975c,
	0x5883,
	0x656c,
	0x93e1,
	0x5f91,
	0x75d9,
	0x9756,
	0x7adf,
	0x7af6,
	0x51c8,
	0x70af,
	0x7a98,
	0x63ea,
	0x7a76,
	0x7cfe,
	0x7396,
	0x97ed,
	0x4e45,
	0x7078,
	0x4e5d,
	0x9152,
	0x53a9,
	0x6551,
	0x820a,
	0x81fc,
	0x8205,
	0x548e,
	0x5c31,
	0x759a,
	0x97a0,
	0x62d8,
	0x72d9,
	0x75bd,
	0x5c45,
	0x99d2,
	0x83ca,
	0x5c40,
	0x5480,
	0x77e9,
	0x8209,
	0x6cae,
	0x805a,
	0x62d2,
	0x64da,
	0x5de8,
	0x5177,
	0x8ddd,
	0x8e1e,
	0x92f8,
	0x4ff1,
	0x53e5,
	0x61fc,
	0x70ac,
	0x5287,
	0x6350,
	0x9d51,
	0x5a1f,
	0x5026,
	0x7737,
	0x5377,
	0x7d79,
	0x6485,
	0x652b,
	0x6289,
	0x6398,
	0x5014,
	0x7235,
	0x89ba,
	0x51b3,
	0x8a23,
	0x7d76,
	0x5747,
	0x83cc,
	0x921e,
	0x8ecd,
	0x541b,
	0x5cfb
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_18[]=
	{
	0x4fca,
	0x7ae3,
	0x6d5a,
	0x90e1,
	0x99ff,
	0x5580,
	0x5496,
	0x5361,
	0x54af,
	0x958b,
	0x63e9,
	0x6977,
	0x51f1,
	0x6168,
	0x520a,
	0x582a,
	0x52d8,
	0x574e,
	0x780d,
	0x770b,
	0x5eb7,
	0x6177,
	0x7ce0,
	0x625b,
	0x6297,
	0x4ea2,
	0x7095,
	0x8003,
	0x62f7,
	0x70e4,
	0x9760,
	0x5777,
	0x82db,
	0x67ef,
	0x68f5,
	0x78d5,
	0x9846,
	0x79d1,
	0x6bbb,
	0x54b3,
	0x53ef,
	0x6e34,
	0x514b,
	0x523b,
	0x5ba2,
	0x8ab2,
	0x80af,
	0x5543,
	0x58be,
	0x61c7,
	0x5751,
	0x542d,
	0x7a7a,
	0x6050,
	0x5b54,
	0x63a7,
	0x6473,
	0x53e3,
	0x6263,
	0x5bc7,
	0x67af,
	0x54ed,
	0x7a9f,
	0x82e6,
	0x9177,
	0x5eab,
	0x8932,
	0x8a87,
	0x57ae,
	0x630e,
	0x8de8,
	0x80ef,
	0x584a,
	0x7b77,
	0x5108,
	0x5feb,
	0x5bec,
	0x6b3e,
	0x5321,
	0x7b50,
	0x72c2,
	0x6846,
	0x7926,
	0x7736,
	0x66e0,
	0x51b5,
	0x8667,
	0x76d4,
	0x5dcb,
	0x7aba,
	0x8475,
	0x594e,
	0x9b41,
	0x5080
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_19[]=
	{
	0x994b,
	0x6127,
	0x6f70,
	0x5764,
	0x6606,
	0x6346,
	0x56f0,
	0x62ec,
	0x64f4,
	0x5ed3,
	0x95ca,
	0x5783,
	0x62c9,
	0x5587,
	0x881f,
	0x81d8,
	0x8fa3,
	0x5566,
	0x840a,
	0x4f86,
	0x8cf4,
	0x85cd,
	0x5a6a,
	0x6b04,
	0x6514,
	0x7c43,
	0x95cc,
	0x862d,
	0x703e,
	0x8b95,
	0x652c,
	0x89bd,
	0x61f6,
	0x7e9c,
	0x721b,
	0x6feb,
	0x7405,
	0x6994,
	0x72fc,
	0x5eca,
	0x90ce,
	0x6717,
	0x6d6a,
	0x6488,
	0x52de,
	0x7262,
	0x8001,
	0x4f6c,
	0x59e5,
	0x916a,
	0x70d9,
	0x6f87,
	0x52d2,
	0x6a02,
	0x96f7,
	0x9433,
	0x857e,
	0x78ca,
	0x7d2f,
	0x5121,
	0x58d8,
	0x64c2,
	0x808b,
	0x985e,
	0x6cea,
	0x68f1,
	0x695e,
	0x51b7,
	0x5398,
	0x68a8,
	0x7281,
	0x9ece,
	0x7c6c,
	0x72f8,
	0x96e2,
	0x7055,
	0x7406,
	0x674e,
	0x88cf,
	0x9bc9,
	0x79ae,
	0x8389,
	0x8354,
	0x540f,
	0x6817,
	0x9e97,
	0x53b2,
	0x52f5,
	0x792b,
	0x6b77,
	0x5229,
	0x5088,
	0x4f8b,
	0x4fd0
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_20[]=
	{
	0x75e2,
	0x7acb,
	0x7c92,
	0x701d,
	0x96b8,
	0x529b,
	0x7483,
	0x54e9,
	0x5006,
	0x806f,
	0x84ee,
	0x9023,
	0x942e,
	0x5ec9,
	0x6190,
	0x6f23,
	0x7c3e,
	0x6582,
	0x81c9,
	0x93c8,
	0x6200,
	0x7149,
	0x7df4,
	0x7ce7,
	0x51c9,
	0x6881,
	0x7cb1,
	0x826f,
	0x5169,
	0x8f1b,
	0x91cf,
	0x667e,
	0x4eae,
	0x8ad2,
	0x64a9,
	0x804a,
	0x50da,
	0x7642,
	0x71ce,
	0x5be5,
	0x907c,
	0x6f66,
	0x4e86,
	0x6482,
	0x9410,
	0x5ed6,
	0x6599,
	0x5217,
	0x88c2,
	0x70c8,
	0x52a3,
	0x7375,
	0x7433,
	0x6797,
	0x78f7,
	0x9716,
	0x81e8,
	0x9130,
	0x9c57,
	0x6dcb,
	0x51db,
	0x8cc3,
	0x541d,
	0x62ce,
	0x73b2,
	0x83f1,
	0x96f6,
	0x9f61,
	0x9234,
	0x4f36,
	0x7f9a,
	0x51cc,
	0x9748,
	0x9675,
	0x5dba,
	0x9818,
	0x53e6,
	0x4ee4,
	0x6e9c,
	0x7409,
	0x69b4,
	0x786b,
	0x993e,
	0x7559,
	0x5289,
	0x7624,
	0x6d41,
	0x67f3,
	0x516d,
	0x9f8d,
	0x807e,
	0x56a8,
	0x7c60,
	0x7abf
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_21[]=
	{
	0x9686,
	0x58df,
	0x650f,
	0x96b4,
	0x6a13,
	0x5a41,
	0x645f,
	0x7c0d,
	0x6f0f,
	0x964b,
	0x8606,
	0x76e7,
	0x9871,
	0x5eec,
	0x7210,
	0x64c4,
	0x6ef7,
	0x865c,
	0x9b6f,
	0x9e93,
	0x788c,
	0x9732,
	0x8def,
	0x8cc2,
	0x9e7f,
	0x6f5e,
	0x7984,
	0x9332,
	0x9678,
	0x622e,
	0x9a62,
	0x5415,
	0x92c1,
	0x4fa3,
	0x65c5,
	0x5c65,
	0x5c62,
	0x7e37,
	0x616e,
	0x6c2f,
	0x5f8b,
	0x7387,
	0x6ffe,
	0x7dd1,
	0x5dd2,
	0x6523,
	0x5b7f,
	0x7064,
	0x5375,
	0x4e82,
	0x63a0,
	0x7565,
	0x6384,
	0x8f2a,
	0x502b,
	0x4f96,
	0x6dea,
	0x7db8,
	0x8ad6,
	0x863f,
	0x87ba,
	0x7f85,
	0x908f,
	0x947c,
	0x7c6e,
	0x9a3e,
	0x88f8,
	0x843d,
	0x6d1b,
	0x99f1,
	0x7d61,
	0x5abd,
	0x9ebb,
	0x746a,
	0x78bc,
	0x879e,
	0x99ac,
	0x99e1,
	0x561b,
	0x55ce,
	0x57cb,
	0x8cb7,
	0x9ea5,
	0x8ce3,
	0x9081,
	0x8109,
	0x779e,
	0x9945,
	0x883b,
	0x6eff,
	0x8513,
	0x66fc,
	0x6162,
	0x6f2b
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_22[]=
	{
	0x8b3e,
	0x8292,
	0x832b,
	0x76f2,
	0x6c13,
	0x5fd9,
	0x83bd,
	0x732b,
	0x8305,
	0x9328,
	0x6bdb,
	0x77db,
	0x925a,
	0x536f,
	0x8302,
	0x5192,
	0x5e3d,
	0x8c8c,
	0x8cbf,
	0x9ebd,
	0x73ab,
	0x679a,
	0x6885,
	0x9176,
	0x9709,
	0x7164,
	0x6ca1,
	0x7709,
	0x5a92,
	0x9382,
	0x6bcf,
	0x7f8e,
	0x6627,
	0x5bd0,
	0x59b9,
	0x5a9a,
	0x9580,
	0x60b6,
	0x5011,
	0x840c,
	0x8499,
	0x6aac,
	0x76df,
	0x9333,
	0x731b,
	0x5922,
	0x5b5f,
	0x772f,
	0x919a,
	0x9761,
	0x7cdc,
	0x8ff7,
	0x8b0e,
	0x5f4c,
	0x7c73,
	0x79d8,
	0x8993,
	0x6ccc,
	0x871c,
	0x5bc6,
	0x5e42,
	0x68c9,
	0x7720,
	0x7dbf,
	0x5195,
	0x514d,
	0x52c9,
	0x5a29,
	0x7dec,
	0x9762,
	0x82d7,
	0x63cf,
	0x7784,
	0x85d0,
	0x79d2,
	0x6e3a,
	0x5edf,
	0x5999,
	0x8511,
	0x6ec5,
	0x6c11,
	0x62bf,
	0x76bf,
	0x654f,
	0x61ab,
	0x95a9,
	0x660e,
	0x879f,
	0x9cf4,
	0x9298,
	0x540d,
	0x547d,
	0x8b2c,
	0x6478
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_23[]=
	{
	0x6479,
	0x8611,
	0x6a21,
	0x819c,
	0x78e8,
	0x6469,
	0x9b54,
	0x62b9,
	0x672b,
	0x83ab,
	0x58a8,
	0x9ed8,
	0x6cab,
	0x6f20,
	0x5bde,
	0x964c,
	0x8b00,
	0x725f,
	0x67d0,
	0x62c7,
	0x7261,
	0x755d,
	0x59c6,
	0x6bcd,
	0x5893,
	0x66ae,
	0x5e55,
	0x52df,
	0x6155,
	0x6728,
	0x76ee,
	0x7766,
	0x7267,
	0x7a46,
	0x62ff,
	0x54ea,
	0x5450,
	0x9209,
	0x90a3,
	0x5a1c,
	0x7d0d,
	0x6c16,
	0x4e43,
	0x5976,
	0x8010,
	0x5948,
	0x5357,
	0x7537,
	0x96e3,
	0x56ca,
	0x6493,
	0x8166,
	0x60f1,
	0x9b27,
	0x6dd6,
	0x5462,
	0x9912,
	0x5185,
	0x5ae9,
	0x80fd,
	0x59ae,
	0x9713,
	0x502a,
	0x6ce5,
	0x5c3c,
	0x64ec,
	0x4f60,
	0x533f,
	0x81a9,
	0x9006,
	0x6eba,
	0x852b,
	0x62c8,
	0x5e74,
	0x78be,
	0x6506,
	0x637b,
	0x5ff5,
	0x5a18,
	0x91c0,
	0x9ce5,
	0x5c3f,
	0x634f,
	0x8076,
	0x5b7d,
	0x5699,
	0x9477,
	0x93b3,
	0x6d85,
	0x60a8,
	0x6ab8,
	0x7370,
	0x51dd,
	0x5be7
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_24[]=
	{
	0x64f0,
	0x6fd8,
	0x725b,
	0x626d,
	0x9215,
	0x7d10,
	0x81bf,
	0x6fc3,
	0x8fb2,
	0x5f04,
	0x5974,
	0x52aa,
	0x6012,
	0x5973,
	0x6696,
	0x8650,
	0x7627,
	0x632a,
	0x61e6,
	0x7cef,
	0x8afe,
	0x54e6,
	0x6b50,
	0x9dd7,
	0x6bc6,
	0x85d5,
	0x5614,
	0x5076,
	0x6f1a,
	0x556a,
	0x8db4,
	0x722c,
	0x5e15,
	0x6015,
	0x7436,
	0x62cd,
	0x6392,
	0x724c,
	0x5f98,
	0x6e43,
	0x6d3e,
	0x6500,
	0x6f58,
	0x76e4,
	0x78d0,
	0x76fc,
	0x7554,
	0x5224,
	0x53db,
	0x4e53,
	0x9f90,
	0x65c1,
	0x802a,
	0x80d6,
	0x629b,
	0x5486,
	0x5228,
	0x70ae,
	0x888d,
	0x8dd1,
	0x6ce1,
	0x5478,
	0x80da,
	0x57f9,
	0x88f4,
	0x8ce0,
	0x966a,
	0x914d,
	0x4f69,
	0x6c9b,
	0x5674,
	0x76c6,
	0x7830,
	0x62a8,
	0x70f9,
	0x6f8e,
	0x5f6d,
	0x84ec,
	0x68da,
	0x787c,
	0x7bf7,
	0x81a8,
	0x670b,
	0x9d6c,
	0x6367,
	0x78b0,
	0x576f,
	0x7812,
	0x9739,
	0x6279,
	0x62ab,
	0x5288,
	0x7435,
	0x6bd7
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_25[]=
	{
	0x5564,
	0x813e,
	0x75b2,
	0x76ae,
	0x5339,
	0x75de,
	0x50fb,
	0x5c41,
	0x8b6c,
	0x7bc7,
	0x504f,
	0x7247,
	0x9a19,
	0x98c4,
	0x6f02,
	0x74e2,
	0x7968,
	0x6487,
	0x77a5,
	0x62fc,
	0x983b,
	0x8ca7,
	0x54c1,
	0x8058,
	0x4e52,
	0x576a,
	0x860b,
	0x840d,
	0x5e73,
	0x6191,
	0x74f6,
	0x8a55,
	0x5c4f,
	0x5761,
	0x6f51,
	0x9817,
	0x5a46,
	0x7834,
	0x9b44,
	0x8feb,
	0x7c95,
	0x5256,
	0x64b2,
	0x92ea,
	0x50d5,
	0x8386,
	0x8461,
	0x83e9,
	0x84b2,
	0x57d4,
	0x6a38,
	0x5703,
	0x666e,
	0x6d66,
	0x8b5c,
	0x66dd,
	0x7011,
	0x671f,
	0x6b3a,
	0x68f2,
	0x621a,
	0x59bb,
	0x4e03,
	0x51c4,
	0x6f06,
	0x67d2,
	0x6c8f,
	0x5176,
	0x68cb,
	0x5947,
	0x6b67,
	0x7566,
	0x5d0e,
	0x81cd,
	0x9f4a,
	0x65d7,
	0x7948,
	0x7941,
	0x9a0e,
	0x8d77,
	0x8c48,
	0x4e5e,
	0x4f01,
	0x5553,
	0x5951,
	0x780c,
	0x5668,
	0x6c23,
	0x8fc4,
	0x68c4,
	0x6c7d,
	0x6ce3,
	0x8a16,
	0x6390
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_26[]=
	{
	0x6070,
	0x6d3d,
	0x727d,
	0x6266,
	0x91fa,
	0x925b,
	0x5343,
	0x9077,
	0x7c3d,
	0x4edf,
	0x8b19,
	0x4e7e,
	0x9ed4,
	0x9322,
	0x9257,
	0x524d,
	0x6f5b,
	0x9063,
	0x6dfa,
	0x8b74,
	0x5879,
	0x5d4c,
	0x6b20,
	0x6b49,
	0x69cd,
	0x55c6,
	0x8154,
	0x7f8c,
	0x58bb,
	0x8594,
	0x5f3a,
	0x6436,
	0x6a47,
	0x936c,
	0x6572,
	0x6084,
	0x6a4b,
	0x77a7,
	0x55ac,
	0x50d1,
	0x5de7,
	0x9798,
	0x64ac,
	0x7ff9,
	0x5ced,
	0x4fcf,
	0x7ac5,
	0x5207,
	0x8304,
	0x4e14,
	0x602f,
	0x7aca,
	0x6b3d,
	0x4fb5,
	0x89aa,
	0x79e6,
	0x7434,
	0x52e4,
	0x82b9,
	0x64d2,
	0x79bd,
	0x5be2,
	0x6c81,
	0x9752,
	0x8f15,
	0x6c2b,
	0x50be,
	0x537f,
	0x6e05,
	0x64ce,
	0x6674,
	0x6c30,
	0x60c5,
	0x9803,
	0x8acb,
	0x6176,
	0x74ca,
	0x7aae,
	0x79cb,
	0x4e18,
	0x90b1,
	0x7403,
	0x6c42,
	0x56da,
	0x914b,
	0x6cc5,
	0x8da8,
	0x5340,
	0x86c6,
	0x66f2,
	0x8ec0,
	0x5c48,
	0x9a45,
	0x6e20
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_27[]=
	{
	0x53d6,
	0x5a36,
	0x9f72,
	0x8da3,
	0x53bb,
	0x5708,
	0x9874,
	0x6b0a,
	0x919b,
	0x6cc9,
	0x5168,
	0x75ca,
	0x62f3,
	0x72ac,
	0x5238,
	0x52f8,
	0x7f3a,
	0x7094,
	0x7638,
	0x5374,
	0x9d72,
	0x69b7,
	0x78ba,
	0x96c0,
	0x88d9,
	0x7fa4,
	0x7136,
	0x71c3,
	0x5189,
	0x67d3,
	0x74e4,
	0x58e4,
	0x6518,
	0x56b7,
	0x8b93,
	0x9952,
	0x64fe,
	0x7e5e,
	0x60f9,
	0x71b1,
	0x58ec,
	0x4ec1,
	0x4eba,
	0x5fcd,
	0x97cc,
	0x4efb,
	0x8a8d,
	0x5203,
	0x598a,
	0x7d09,
	0x6254,
	0x4ecd,
	0x65e5,
	0x620e,
	0x8338,
	0x84c9,
	0x69ae,
	0x878d,
	0x7194,
	0x6eb6,
	0x5bb9,
	0x7d68,
	0x5197,
	0x63c9,
	0x67d4,
	0x8089,
	0x8339,
	0x8815,
	0x5112,
	0x5b7a,
	0x5982,
	0x8fb1,
	0x4e73,
	0x6c5d,
	0x5165,
	0x8925,
	0x8edf,
	0x962e,
	0x854a,
	0x745e,
	0x92ed,
	0x958f,
	0x6f64,
	0x82e5,
	0x5f31,
	0x6492,
	0x7051,
	0x85a9,
	0x816e,
	0x9c13,
	0x585e,
	0x8cfd,
	0x4e09,
	0x53c1
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_28[]=
	{
	0x5098,
	0x6563,
	0x6851,
	0x55d3,
	0x55aa,
	0x6414,
	0x9a37,
	0x6383,
	0x5ac2,
	0x745f,
	0x8272,
	0x6f80,
	0x68ee,
	0x50e7,
	0x838e,
	0x7802,
	0x6bba,
	0x5239,
	0x6c99,
	0x7d17,
	0x50bb,
	0x5565,
	0x715e,
	0x7be9,
	0x66ec,
	0x73ca,
	0x82eb,
	0x6749,
	0x5c71,
	0x5220,
	0x717d,
	0x886b,
	0x9583,
	0x965d,
	0x64c5,
	0x8d0d,
	0x81b3,
	0x5584,
	0x6c55,
	0x6247,
	0x7e55,
	0x5892,
	0x50b7,
	0x5546,
	0x8cde,
	0x664c,
	0x4e0a,
	0x5c1a,
	0x88f3,
	0x68a2,
	0x634e,
	0x7a0d,
	0x71d2,
	0x828d,
	0x52fa,
	0x97f6,
	0x5c11,
	0x54e8,
	0x90b5,
	0x7d39,
	0x5962,
	0x8cd2,
	0x86c7,
	0x820c,
	0x6368,
	0x8d66,
	0x651d,
	0x5c04,
	0x61fe,
	0x6d89,
	0x793e,
	0x8a2d,
	0x7837,
	0x7533,
	0x547b,
	0x4f38,
	0x8eab,
	0x6df1,
	0x5a20,
	0x7d33,
	0x795e,
	0x6c88,
	0x5be9,
	0x5b38,
	0x751a,
	0x814e,
	0x614e,
	0x6ef2,
	0x8072,
	0x751f,
	0x7525,
	0x7272,
	0x5347,
	0x7e69
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_29[]=
	{
	0x7701,
	0x76db,
	0x5269,
	0x52dd,
	0x8056,
	0x5e2b,
	0x5931,
	0x7345,
	0x65bd,
	0x6fd5,
	0x8a69,
	0x5c38,
	0x8671,
	0x5341,
	0x77f3,
	0x62fe,
	0x6642,
	0x4ec0,
	0x98df,
	0x8755,
	0x5be6,
	0x8b58,
	0x53f2,
	0x77e2,
	0x4f7f,
	0x5c4e,
	0x99db,
	0x59cb,
	0x5f0f,
	0x793a,
	0x58eb,
	0x4e16,
	0x67ff,
	0x4e8b,
	0x62ed,
	0x8a93,
	0x901d,
	0x52e2,
	0x662f,
	0x55dc,
	0x566c,
	0x9069,
	0x4ed5,
	0x4f8d,
	0x91cb,
	0x98fe,
	0x6c0f,
	0x5e02,
	0x6043,
	0x5ba4,
	0x8996,
	0x8a66,
	0x6536,
	0x624b,
	0x9996,
	0x5b88,
	0x58fd,
	0x6388,
	0x552e,
	0x53d7,
	0x7626,
	0x7378,
	0x852c,
	0x6a1e,
	0x68b3,
	0x6b8a,
	0x6292,
	0x8f38,
	0x53d4,
	0x8212,
	0x6dd1,
	0x758f,
	0x66f8,
	0x8d16,
	0x5b70,
	0x719f,
	0x85af,
	0x6691,
	0x66d9,
	0x7f72,
	0x8700,
	0x9ecd,
	0x9f20,
	0x5c6c,
	0x8853,
	0x8ff0,
	0x6a39,
	0x675f,
	0x620d,
	0x7aea,
	0x5885,
	0x5eb6,
	0x6578,
	0x6f31
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_30[]=
	{
	0x6055,
	0x5237,
	0x800d,
	0x6454,
	0x8870,
	0x7529,
	0x5e25,
	0x6813,
	0x62f4,
	0x971c,
	0x96d9,
	0x723d,
	0x8ab0,
	0x6c34,
	0x7761,
	0x7a0e,
	0x542e,
	0x77ac,
	0x9806,
	0x821c,
	0x8aac,
	0x78a9,
	0x6714,
	0x720d,
	0x65af,
	0x6495,
	0x5636,
	0x601d,
	0x79c1,
	0x53f8,
	0x7d72,
	0x6b7b,
	0x8086,
	0x5bfa,
	0x55e3,
	0x56db,
	0x4f3a,
	0x4f3c,
	0x98fc,
	0x5df3,
	0x9b06,
	0x8073,
	0x616b,
	0x980c,
	0x9001,
	0x5b8b,
	0x8a1f,
	0x8aa6,
	0x641c,
	0x8258,
	0x64fb,
	0x55fd,
	0x8607,
	0x9165,
	0x4fd7,
	0x7d20,
	0x901f,
	0x7c9f,
	0x50f3,
	0x5851,
	0x6eaf,
	0x5bbf,
	0x8a34,
	0x8085,
	0x9178,
	0x849c,
	0x7b97,
	0x96d6,
	0x968b,
	0x96a8,
	0x7d8f,
	0x9ad3,
	0x788e,
	0x6b72,
	0x7a57,
	0x9042,
	0x96a7,
	0x795f,
	0x5b6b,
	0x640d,
	0x7b0b,
	0x84d1,
	0x68ad,
	0x5506,
	0x7e2e,
	0x7463,
	0x7d22,
	0x9396,
	0x6240,
	0x584c,
	0x4ed6,
	0x5b83,
	0x5979,
	0x5854
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_31[]=
	{
	0x737a,
	0x64bb,
	0x8e4b,
	0x8e0f,
	0x80ce,
	0x82d4,
	0x62ac,
	0x81fa,
	0x6cf0,
	0x915e,
	0x592a,
	0x614b,
	0x6c70,
	0x574d,
	0x6524,
	0x8caa,
	0x7671,
	0x7058,
	0x58c7,
	0x6a80,
	0x75f0,
	0x6f6d,
	0x8b5a,
	0x8ac7,
	0x5766,
	0x6bef,
	0x8892,
	0x78b3,
	0x63a2,
	0x5606,
	0x70ad,
	0x6e6f,
	0x5858,
	0x642a,
	0x5802,
	0x68e0,
	0x819b,
	0x5510,
	0x7cd6,
	0x5018,
	0x8eba,
	0x6dcc,
	0x8d9f,
	0x71d9,
	0x638f,
	0x6fe4,
	0x6ed4,
	0x7e27,
	0x8404,
	0x6843,
	0x9003,
	0x6dd8,
	0x9676,
	0x8a0e,
	0x5957,
	0x7279,
	0x85e4,
	0x9a30,
	0x75bc,
	0x8b04,
	0x68af,
	0x5254,
	0x8e22,
	0x92bb,
	0x63d0,
	0x984c,
	0x8e44,
	0x557c,
	0x9ad4,
	0x66ff,
	0x568f,
	0x60d5,
	0x6d95,
	0x5243,
	0x5c49,
	0x5929,
	0x6dfb,
	0x586b,
	0x7530,
	0x751c,
	0x606c,
	0x8214,
	0x8146,
	0x6311,
	0x689d,
	0x8fe2,
	0x773a,
	0x8df3,
	0x8cbc,
	0x9435,
	0x5e16,
	0x5ef3,
	0x807d,
	0x70f4
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_32[]=
	{
	0x6c40,
	0x5ef7,
	0x505c,
	0x4ead,
	0x5ead,
	0x633a,
	0x8247,
	0x901a,
	0x6850,
	0x916e,
	0x77b3,
	0x540c,
	0x9285,
	0x5f64,
	0x7ae5,
	0x6876,
	0x6345,
	0x7b52,
	0x7d71,
	0x75db,
	0x5077,
	0x6295,
	0x982d,
	0x900f,
	0x51f8,
	0x79c3,
	0x7a81,
	0x5716,
	0x5f92,
	0x9014,
	0x5857,
	0x5c60,
	0x571f,
	0x5410,
	0x5154,
	0x6e4d,
	0x5718,
	0x63a8,
	0x983d,
	0x817f,
	0x8715,
	0x892a,
	0x9000,
	0x541e,
	0x5c6f,
	0x81c0,
	0x62d6,
	0x6258,
	0x8131,
	0x9d15,
	0x9640,
	0x99b1,
	0x99dd,
	0x6a62,
	0x59a5,
	0x62d3,
	0x553e,
	0x6316,
	0x54c7,
	0x86d9,
	0x7aaa,
	0x5a03,
	0x74e6,
	0x896a,
	0x6b6a,
	0x5916,
	0x8c4c,
	0x5f4e,
	0x7063,
	0x73a9,
	0x9811,
	0x4e38,
	0x70f7,
	0x5b8c,
	0x7897,
	0x633d,
	0x665a,
	0x7696,
	0x60cb,
	0x5b9b,
	0x5a49,
	0x842c,
	0x8155,
	0x6c6a,
	0x738b,
	0x4ea1,
	0x6789,
	0x7db2,
	0x5f80,
	0x65fa,
	0x671b,
	0x5fd8,
	0x5984,
	0x5a01
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_33[]=
	{
	0x5dcd,
	0x5fae,
	0x5371,
	0x97cb,
	0x9055,
	0x6845,
	0x570d,
	0x552f,
	0x60df,
	0x7232,
	0x6ff0,
	0x7dad,
	0x8466,
	0x840e,
	0x59d4,
	0x5049,
	0x50de,
	0x5c3e,
	0x7def,
	0x672a,
	0x851a,
	0x5473,
	0x754f,
	0x80c3,
	0x5582,
	0x9b4f,
	0x4f4d,
	0x6e2d,
	0x8b02,
	0x5c09,
	0x6170,
	0x885b,
	0x761f,
	0x6e29,
	0x868a,
	0x6587,
	0x805e,
	0x7d0b,
	0x543b,
	0x7a69,
	0x7d0a,
	0x554f,
	0x55e1,
	0x7fc1,
	0x74ee,
	0x64be,
	0x8778,
	0x6e26,
	0x7aa9,
	0x6211,
	0x65a1,
	0x5367,
	0x63e1,
	0x6c83,
	0x5deb,
	0x55da,
	0x93a2,
	0x70cf,
	0x6c61,
	0x8aa3,
	0x5c4b,
	0x7121,
	0x856a,
	0x68a7,
	0x543e,
	0x5434,
	0x6bcb,
	0x6b66,
	0x4e94,
	0x6342,
	0x5348,
	0x821e,
	0x4f0d,
	0x4fae,
	0x5862,
	0x620a,
	0x9727,
	0x6664,
	0x7269,
	0x52ff,
	0x52d9,
	0x609f,
	0x8aa4,
	0x6614,
	0x7199,
	0x6790,
	0x897f,
	0x7852,
	0x77fd,
	0x6670,
	0x563b,
	0x5438,
	0x932b,
	0x72a7
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_34[]=
	{
	0x7a00,
	0x606f,
	0x5e0c,
	0x6089,
	0x819d,
	0x5915,
	0x60dc,
	0x7184,
	0x70ef,
	0x6eaa,
	0x6c50,
	0x7280,
	0x6a84,
	0x8972,
	0x5e2d,
	0x7fd2,
	0x5ab3,
	0x559c,
	0x9291,
	0x6d17,
	0x7cfb,
	0x9699,
	0x6232,
	0x7d30,
	0x778e,
	0x8766,
	0x5323,
	0x971e,
	0x8f44,
	0x6687,
	0x5cfd,
	0x4fe0,
	0x72f9,
	0x4e0b,
	0x53a6,
	0x590f,
	0x5687,
	0x6380,
	0x9341,
	0x5148,
	0x4ed9,
	0x9bae,
	0x7e96,
	0x54b8,
	0x8ce2,
	0x929c,
	0x8237,
	0x9591,
	0x6d8e,
	0x5f26,
	0x5acc,
	0x986f,
	0x96aa,
	0x73fe,
	0x737b,
	0x7e23,
	0x817a,
	0x9921,
	0x7fa1,
	0x61b2,
	0x9677,
	0x9650,
	0x7dab,
	0x76f8,
	0x53a2,
	0x9472,
	0x9999,
	0x7bb1,
	0x8944,
	0x6e58,
	0x9109,
	0x7fd4,
	0x7965,
	0x8a73,
	0x60f3,
	0x97ff,
	0x4eab,
	0x9805,
	0x5df7,
	0x6a61,
	0x50cf,
	0x5411,
	0x8c61,
	0x856d,
	0x785d,
	0x9704,
	0x524a,
	0x54ee,
	0x56c2,
	0x92b7,
	0x6d88,
	0x5bb5,
	0x6dc6,
	0x66c9
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_35[]=
	{
	0x5c0f,
	0x5b5d,
	0x6821,
	0x8096,
	0x562f,
	0x7b11,
	0x6548,
	0x6954,
	0x4e9b,
	0x6b47,
	0x874e,
	0x978b,
	0x5354,
	0x633e,
	0x643a,
	0x90aa,
	0x659c,
	0x8105,
	0x8ae7,
	0x5beb,
	0x68b0,
	0x5378,
	0x87f9,
	0x61c8,
	0x6cc4,
	0x7009,
	0x8b1d,
	0x5c51,
	0x85aa,
	0x82af,
	0x92c5,
	0x6b23,
	0x8f9b,
	0x65b0,
	0x5ffb,
	0x5fc3,
	0x4fe1,
	0x91c1,
	0x661f,
	0x8165,
	0x7329,
	0x60fa,
	0x8208,
	0x5211,
	0x578b,
	0x5f62,
	0x90a2,
	0x884c,
	0x9192,
	0x5e78,
	0x674f,
	0x6027,
	0x59d3,
	0x5144,
	0x51f6,
	0x80f8,
	0x5308,
	0x6c79,
	0x96c4,
	0x718a,
	0x4f11,
	0x4fee,
	0x7f9e,
	0x673d,
	0x55c5,
	0x92b9,
	0x79c0,
	0x8896,
	0x7d89,
	0x589f,
	0x620c,
	0x9700,
	0x865a,
	0x5618,
	0x9808,
	0x5f90,
	0x8a31,
	0x84c4,
	0x9157,
	0x53d9,
	0x65ed,
	0x5e8f,
	0x755c,
	0x6064,
	0x7d6e,
	0x5a7f,
	0x7dd2,
	0x7e8c,
	0x8ed2,
	0x55a7,
	0x5ba3,
	0x61f8,
	0x65cb,
	0x7384
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_36[]=
	{
	0x9078,
	0x766c,
	0x7729,
	0x7d62,
	0x9774,
	0x859b,
	0x5b78,
	0x7a74,
	0x96ea,
	0x8840,
	0x52db,
	0x718f,
	0x5faa,
	0x65ec,
	0x8a62,
	0x5c0b,
	0x99b4,
	0x5de1,
	0x6b89,
	0x6c5b,
	0x8a13,
	0x8a0a,
	0x905c,
	0x8fc5,
	0x58d3,
	0x62bc,
	0x9d09,
	0x9d28,
	0x5440,
	0x4e2b,
	0x82bd,
	0x7259,
	0x869c,
	0x5d16,
	0x8859,
	0x6daf,
	0x96c5,
	0x555e,
	0x4e9e,
	0x8a1d,
	0x7109,
	0x54bd,
	0x95b9,
	0x70df,
	0x6df9,
	0x9e7d,
	0x56b4,
	0x7814,
	0x8712,
	0x5ca9,
	0x5ef6,
	0x8a00,
	0x9854,
	0x95bb,
	0x708e,
	0x6cbf,
	0x5944,
	0x63a9,
	0x773c,
	0x884d,
	0x6f14,
	0x8277,
	0x5830,
	0x71d5,
	0x53ad,
	0x786f,
	0x96c1,
	0x5501,
	0x5f66,
	0x7130,
	0x5bb4,
	0x8afa,
	0x9a57,
	0x6b83,
	0x592e,
	0x9d26,
	0x79e7,
	0x694a,
	0x63da,
	0x4f6f,
	0x760d,
	0x7f8a,
	0x6d0b,
	0x967d,
	0x6c27,
	0x4ef0,
	0x7662,
	0x990a,
	0x6a23,
	0x6f3e,
	0x9080,
	0x8170,
	0x5996,
	0x7476
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_37[]=
	{
	0x6447,
	0x582f,
	0x9065,
	0x7a91,
	0x8b21,
	0x59da,
	0x54ac,
	0x8200,
	0x85e5,
	0x8981,
	0x8000,
	0x6930,
	0x564e,
	0x8036,
	0x723a,
	0x91ce,
	0x51b6,
	0x4e5f,
	0x9801,
	0x6396,
	0x696d,
	0x8449,
	0x66f3,
	0x814b,
	0x591c,
	0x6db2,
	0x4e00,
	0x58f9,
	0x91ab,
	0x63d6,
	0x92a5,
	0x4f9d,
	0x4f0a,
	0x8863,
	0x9824,
	0x5937,
	0x907a,
	0x79fb,
	0x5100,
	0x80f0,
	0x7591,
	0x6c82,
	0x5b9c,
	0x59e8,
	0x5f5d,
	0x6905,
	0x87fb,
	0x501a,
	0x5df2,
	0x4e59,
	0x77e3,
	0x4ee5,
	0x85dd,
	0x6291,
	0x6613,
	0x9091,
	0x5c79,
	0x5104,
	0x5f79,
	0x81c6,
	0x9038,
	0x8084,
	0x75ab,
	0x4ea6,
	0x88d4,
	0x610f,
	0x6bc5,
	0x61b6,
	0x7fa9,
	0x76ca,
	0x6ea2,
	0x8a63,
	0x8b70,
	0x8abc,
	0x8b6f,
	0x5f02,
	0x7ffc,
	0x7fcc,
	0x7e79,
	0x8335,
	0x852d,
	0x56e0,
	0x6bb7,
	0x97f3,
	0x9670,
	0x59fb,
	0x541f,
	0x9280,
	0x6deb,
	0x5bc5,
	0x98f2,
	0x5c39,
	0x5f15,
	0x96b1
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_38[]=
	{
	0x5370,
	0x82f1,
	0x6afb,
	0x5b30,
	0x9df9,
	0x61c9,
	0x7e93,
	0x7469,
	0x87a2,
	0x71df,
	0x7192,
	0x8805,
	0x8fce,
	0x8d0f,
	0x76c8,
	0x5f71,
	0x7a4e,
	0x786c,
	0x6620,
	0x55b2,
	0x64c1,
	0x50ad,
	0x81c3,
	0x7670,
	0x5eb8,
	0x96cd,
	0x8e34,
	0x86f9,
	0x548f,
	0x6cf3,
	0x6d8c,
	0x6c38,
	0x607f,
	0x52c7,
	0x7528,
	0x5e7d,
	0x512a,
	0x60a0,
	0x6182,
	0x5c24,
	0x7531,
	0x90f5,
	0x923e,
	0x7336,
	0x6cb9,
	0x6e38,
	0x9149,
	0x6709,
	0x53cb,
	0x53f3,
	0x4f51,
	0x91c9,
	0x8a98,
	0x53c8,
	0x5e7c,
	0x8fc2,
	0x6de4,
	0x4e8e,
	0x76c2,
	0x6986,
	0x865e,
	0x611a,
	0x8f3f,
	0x9918,
	0x4fde,
	0x903e,
	0x9b5a,
	0x6109,
	0x6e1d,
	0x6f01,
	0x9685,
	0x4e88,
	0x5a31,
	0x96e8,
	0x8207,
	0x5dbc,
	0x79b9,
	0x5b87,
	0x8a9e,
	0x7fbd,
	0x7389,
	0x57df,
	0x828b,
	0x9b31,
	0x5401,
	0x9047,
	0x55bb,
	0x5cea,
	0x5fa1,
	0x6108,
	0x6b32,
	0x7344,
	0x80b2,
	0x8b7d
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_39[]=
	{
	0x6d74,
	0x5bd3,
	0x88d5,
	0x9810,
	0x8c6b,
	0x99ad,
	0x9d1b,
	0x6df5,
	0x51a4,
	0x5143,
	0x57a3,
	0x8881,
	0x539f,
	0x63f4,
	0x8f45,
	0x5712,
	0x54e1,
	0x5713,
	0x733f,
	0x6e90,
	0x7de3,
	0x9060,
	0x82d1,
	0x9858,
	0x6028,
	0x9662,
	0x66f0,
	0x7d04,
	0x8d8a,
	0x8e8d,
	0x9470,
	0x5cb3,
	0x7ca4,
	0x6708,
	0x60a6,
	0x95b2,
	0x8018,
	0x96f2,
	0x9116,
	0x5300,
	0x9695,
	0x5141,
	0x904b,
	0x85f4,
	0x9196,
	0x6688,
	0x97f5,
	0x5b55,
	0x531d,
	0x7838,
	0x96dc,
	0x683d,
	0x54c9,
	0x707e,
	0x5bb0,
	0x8f09,
	0x518d,
	0x5728,
	0x54b1,
	0x6522,
	0x66ab,
	0x8d0a,
	0x8d1c,
	0x81df,
	0x846c,
	0x906d,
	0x7cdf,
	0x947f,
	0x85fb,
	0x68d7,
	0x65e9,
	0x6fa1,
	0x86a4,
	0x8e81,
	0x566a,
	0x9020,
	0x7682,
	0x7ac8,
	0x71e5,
	0x8cac,
	0x64c7,
	0x5247,
	0x6fa4,
	0x8cca,
	0x600e,
	0x589e,
	0x618e,
	0x66fe,
	0x8d08,
	0x624e,
	0x55b3,
	0x6e23,
	0x672d,
	0x8ecb
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_40[]=
	{
	0x9358,
	0x9598,
	0x7728,
	0x6805,
	0x69a8,
	0x548b,
	0x4e4d,
	0x70b8,
	0x8a50,
	0x6458,
	0x9f4b,
	0x5b85,
	0x7a84,
	0x50b5,
	0x5be8,
	0x77bb,
	0x6c08,
	0x8a79,
	0x7c98,
	0x6cbe,
	0x76de,
	0x65ac,
	0x8f3e,
	0x5d84,
	0x5c55,
	0x8638,
	0x68e7,
	0x5360,
	0x6230,
	0x7ad9,
	0x6e5b,
	0x7dbb,
	0x6a1f,
	0x7ae0,
	0x5f70,
	0x6f33,
	0x5f35,
	0x638c,
	0x6f32,
	0x6756,
	0x4e08,
	0x5e33,
	0x8cec,
	0x4ed7,
	0x8139,
	0x7634,
	0x969c,
	0x62db,
	0x662d,
	0x627e,
	0x6cbc,
	0x8d99,
	0x7167,
	0x7f69,
	0x5146,
	0x8087,
	0x53ec,
	0x906e,
	0x6298,
	0x54f2,
	0x87c4,
	0x8f4d,
	0x8005,
	0x937a,
	0x8517,
	0x9019,
	0x6d59,
	0x73cd,
	0x659f,
	0x771f,
	0x7504,
	0x7827,
	0x81fb,
	0x8c9e,
	0x91dd,
	0x5075,
	0x6795,
	0x75b9,
	0x8a3a,
	0x9707,
	0x632f,
	0x93ae,
	0x9663,
	0x84b8,
	0x6399,
	0x775c,
	0x5f81,
	0x7319,
	0x722d,
	0x6014,
	0x6574,
	0x62ef,
	0x6b63,
	0x653f
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_41[]=
	{
	0x5e40,
	0x7665,
	0x912d,
	0x8b49,
	0x829d,
	0x679d,
	0x652f,
	0x5431,
	0x8718,
	0x77e5,
	0x80a2,
	0x8102,
	0x6c41,
	0x4e4b,
	0x7e54,
	0x8077,
	0x76f4,
	0x690d,
	0x6b96,
	0x57f7,
	0x503c,
	0x4f84,
	0x5740,
	0x6307,
	0x6b62,
	0x8dbe,
	0x8879,
	0x65e8,
	0x7d19,
	0x5fd7,
	0x646f,
	0x64f2,
	0x81f3,
	0x81f4,
	0x7f6e,
	0x5e5f,
	0x5cd9,
	0x5236,
	0x667a,
	0x79e9,
	0x7a1a,
	0x8cea,
	0x7099,
	0x75d4,
	0x6eef,
	0x6cbb,
	0x7a92,
	0x4e2d,
	0x76c5,
	0x5fe0,
	0x9418,
	0x8877,
	0x7d42,
	0x7a2e,
	0x816b,
	0x91cd,
	0x4ef2,
	0x8846,
	0x821f,
	0x5468,
	0x5dde,
	0x6d32,
	0x8b05,
	0x7ca5,
	0x8ef8,
	0x8098,
	0x5e1a,
	0x5492,
	0x76ba,
	0x5b99,
	0x665d,
	0x9a5f,
	0x73e0,
	0x682a,
	0x86db,
	0x6731,
	0x732a,
	0x8af8,
	0x8a85,
	0x9010,
	0x7af9,
	0x71ed,
	0x716e,
	0x62c4,
	0x77da,
	0x56d1,
	0x4e3b,
	0x8457,
	0x67f1,
	0x52a9,
	0x86c0,
	0x8caf,
	0x9444,
	0x7bc9
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_42[]=
	{
	0x4f4f,
	0x6ce8,
	0x795d,
	0x99d0,
	0x6293,
	0x722a,
	0x62fd,
	0x5c08,
	0x78da,
	0x8f49,
	0x64b0,
	0x8cfa,
	0x7bc6,
	0x6a01,
	0x838a,
	0x88dd,
	0x599d,
	0x649e,
	0x58ef,
	0x72c0,
	0x690e,
	0x9310,
	0x8ffd,
	0x8d05,
	0x589c,
	0x7db4,
	0x8ac4,
	0x6e96,
	0x6349,
	0x62d9,
	0x5353,
	0x684c,
	0x7422,
	0x8301,
	0x914c,
	0x5544,
	0x7740,
	0x707c,
	0x6fc1,
	0x5179,
	0x54a8,
	0x8cc7,
	0x59ff,
	0x6ecb,
	0x6dc4,
	0x5b5c,
	0x7d2b,
	0x4ed4,
	0x7c7d,
	0x6ed3,
	0x5b50,
	0x81ea,
	0x6f2c,
	0x5b57,
	0x9b03,
	0x68d5,
	0x8e2a,
	0x5b97,
	0x7d9c,
	0x7e3d,
	0x7e31,
	0x9112,
	0x8d70,
	0x594f,
	0x63cd,
	0x79df,
	0x8db3,
	0x5352,
	0x65cf,
	0x7956,
	0x8a5b,
	0x963b,
	0x7d44,
	0x947d,
	0x7e82,
	0x5634,
	0x9189,
	0x6700,
	0x7f6a,
	0x5c0a,
	0x9075,
	0x6628,
	0x5de6,
	0x4f50,
	0x67de,
	0x505a,
	0x4f5c,
	0x5750,
	0x5ea7
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_43[]=
	{
	0x4e8d,
	0x4e0c,
	0x5140,
	0x4e10,
	0x5eff,
	0x5345,
	0x4e15,
	0x4e98,
	0x4e1e,
	0x9b32,
	0x5b6c,
	0x5669,
	0x4e28,
	0x79ba,
	0x4e3f,
	0x5315,
	0x4e47,
	0x592d,
	0x723b,
	0x536e,
	0x6c10,
	0x56df,
	0x80e4,
	0x9997,
	0x6bd3,
	0x777e,
	0x9f17,
	0x4e36,
	0x4e9f,
	0x9f10,
	0x4e5c,
	0x4e69,
	0x4e93,
	0x8288,
	0x5b5b,
	0x55c7,
	0x560f,
	0x4ec4,
	0x5399,
	0x539d,
	0x53b4,
	0x53a5,
	0x53ae,
	0x9768,
	0x8d0b,
	0x531a,
	0x53f5,
	0x532d,
	0x5331,
	0x533e,
	0x8cfe,
	0x5366,
	0x5363,
	0x5202,
	0x5208,
	0x520e,
	0x5244,
	0x5233,
	0x528c,
	0x5274,
	0x524c,
	0x525e,
	0x5261,
	0x525c,
	0x84af,
	0x527d,
	0x5282,
	0x5281,
	0x5290,
	0x5293,
	0x5182,
	0x7f54,
	0x4ebb,
	0x4ec3,
	0x4ec9,
	0x4ec2,
	0x4ee8,
	0x4ee1,
	0x4eeb,
	0x4ede,
	0x50b4,
	0x4ef3,
	0x4f22,
	0x4f64,
	0x4ef5,
	0x5000,
	0x5096,
	0x4f09,
	0x4f47,
	0x4f5e,
	0x4f67,
	0x6538,
	0x4f5a,
	0x4f5d
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_44[]=
	{
	0x4f5f,
	0x4f57,
	0x4f32,
	0x4f3d,
	0x4f76,
	0x4f74,
	0x4f91,
	0x4f89,
	0x4f83,
	0x4f8f,
	0x4f7e,
	0x4f7b,
	0x5115,
	0x4f7c,
	0x5102,
	0x4f94,
	0x5114,
	0x513c,
	0x5137,
	0x4fc5,
	0x4fda,
	0x4fe3,
	0x4fdc,
	0x4fd1,
	0x4fdf,
	0x4ff8,
	0x5029,
	0x504c,
	0x4ff3,
	0x502c,
	0x500f,
	0x502e,
	0x502d,
	0x4ffe,
	0x501c,
	0x500c,
	0x5025,
	0x5028,
	0x50e8,
	0x5043,
	0x5055,
	0x5048,
	0x504e,
	0x506c,
	0x50c2,
	0x513b,
	0x5110,
	0x513a,
	0x50ba,
	0x50d6,
	0x5106,
	0x50ed,
	0x50ec,
	0x50e6,
	0x50ee,
	0x5107,
	0x510b,
	0x4edd,
	0x6c3d,
	0x4f58,
	0x50c9,
	0x4fce,
	0x9fa0,
	0x6c46,
	0x7cf4,
	0x516e,
	0x5dfd,
	0x9ecc,
	0x9998,
	0x56c5,
	0x5914,
	0x52f9,
	0x530d,
	0x8a07,
	0x5310,
	0x9cec,
	0x5919,
	0x5155,
	0x4ea0,
	0x5156,
	0x4eb3,
	0x886e,
	0x88a4,
	0x893b,
	0x81e0,
	0x88d2,
	0x7980,
	0x5b34,
	0x8803,
	0x7fb8,
	0x51ab,
	0x51b1,
	0x51bd,
	0x51bc
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_45[]=
	{
	0x51c7,
	0x5196,
	0x51a2,
	0x51a5,
	0x8a01,
	0x8a10,
	0x8a0c,
	0x8a15,
	0x8b33,
	0x8a4e,
	0x8a25,
	0x8a41,
	0x8a36,
	0x8a46,
	0x8a54,
	0x8a58,
	0x8a52,
	0x8a86,
	0x8a84,
	0x8a7f,
	0x8a70,
	0x8a7c,
	0x8a75,
	0x8a6c,
	0x8a6e,
	0x8acd,
	0x8ae2,
	0x8a61,
	0x8a9a,
	0x8aa5,
	0x8a91,
	0x8a92,
	0x8acf,
	0x8ad1,
	0x8ac9,
	0x8adb,
	0x8ad7,
	0x8ac2,
	0x8ab6,
	0x8af6,
	0x8aeb,
	0x8b14,
	0x8b01,
	0x8ae4,
	0x8aed,
	0x8afc,
	0x8af3,
	0x8ae6,
	0x8aee,
	0x8ade,
	0x8b28,
	0x8b9c,
	0x8b16,
	0x8b1a,
	0x8b10,
	0x8b2b,
	0x8b2d,
	0x8b56,
	0x8b59,
	0x8b4e,
	0x8b9e,
	0x8b6b,
	0x8b96,
	0x5369,
	0x537a,
	0x961d,
	0x9622,
	0x9621,
	0x9631,
	0x962a,
	0x963d,
	0x963c,
	0x9642,
	0x9658,
	0x9654,
	0x965f,
	0x9689,
	0x966c,
	0x9672,
	0x9674,
	0x9688,
	0x968d,
	0x9697,
	0x96b0,
	0x9097,
	0x909b,
	0x913a,
	0x9099,
	0x9114,
	0x90a1,
	0x90b4,
	0x90b3,
	0x90b6,
	0x9134
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_46[]=
	{
	0x90b8,
	0x90b0,
	0x90df,
	0x90c5,
	0x90be,
	0x9136,
	0x90c4,
	0x90c7,
	0x9106,
	0x9148,
	0x90e2,
	0x90dc,
	0x90d7,
	0x90db,
	0x90eb,
	0x90ef,
	0x90fe,
	0x9104,
	0x9122,
	0x911e,
	0x9123,
	0x9131,
	0x912f,
	0x9139,
	0x9143,
	0x9146,
	0x82bb,
	0x5950,
	0x52f1,
	0x52ac,
	0x52ad,
	0x52be,
	0x54ff,
	0x52d0,
	0x52d6,
	0x52f0,
	0x53df,
	0x71ee,
	0x77cd,
	0x5ef4,
	0x51f5,
	0x51fc,
	0x9b2f,
	0x53b6,
	0x5f01,
	0x755a,
	0x5df0,
	0x574c,
	0x580a,
	0x57a1,
	0x587e,
	0x58bc,
	0x58c5,
	0x58d1,
	0x5729,
	0x572c,
	0x572a,
	0x5733,
	0x58d9,
	0x572e,
	0x572f,
	0x58e2,
	0x573b,
	0x5742,
	0x5769,
	0x58e0,
	0x576b,
	0x58da,
	0x577c,
	0x577b,
	0x5768,
	0x576d,
	0x5776,
	0x5773,
	0x57e1,
	0x57a4,
	0x578c,
	0x584f,
	0x57cf,
	0x57a7,
	0x5816,
	0x5793,
	0x57a0,
	0x57d5,
	0x5852,
	0x581d,
	0x5864,
	0x57d2,
	0x57b8,
	0x57f4,
	0x57ef,
	0x57f8,
	0x57e4,
	0x57dd
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_47[]=
	{
	0x580b,
	0x580d,
	0x57fd,
	0x57ed,
	0x5800,
	0x581e,
	0x5819,
	0x5844,
	0x5820,
	0x5865,
	0x586c,
	0x5881,
	0x5889,
	0x589a,
	0x5880,
	0x99a8,
	0x9f19,
	0x61ff,
	0x8279,
	0x827d,
	0x827f,
	0x828f,
	0x828a,
	0x82a8,
	0x8284,
	0x828e,
	0x8291,
	0x858c,
	0x8299,
	0x82ab,
	0x8553,
	0x82be,
	0x82b0,
	0x85f6,
	0x82ca,
	0x82e3,
	0x8298,
	0x82b7,
	0x82ae,
	0x83a7,
	0x8407,
	0x84ef,
	0x82a9,
	0x82b4,
	0x82a1,
	0x82aa,
	0x829f,
	0x82c4,
	0x82e7,
	0x82a4,
	0x82e1,
	0x8309,
	0x82f7,
	0x82e4,
	0x8622,
	0x8307,
	0x82dc,
	0x82f4,
	0x82d2,
	0x82d8,
	0x830c,
	0x82fb,
	0x82d3,
	0x8526,
	0x831a,
	0x8306,
	0x584b,
	0x7162,
	0x82e0,
	0x82d5,
	0x831c,
	0x8351,
	0x8558,
	0x84fd,
	0x8308,
	0x8392,
	0x833c,
	0x8334,
	0x8331,
	0x839b,
	0x854e,
	0x832f,
	0x834f,
	0x8347,
	0x8343,
	0x8588,
	0x8340,
	0x8317,
	0x85ba,
	0x832d,
	0x833a,
	0x8333,
	0x7296,
	0x6ece
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_48[]=
	{
	0x8541,
	0x831b,
	0x85ce,
	0x8552,
	0x84c0,
	0x8452,
	0x8464,
	0x83b0,
	0x8378,
	0x8494,
	0x8435,
	0x83a0,
	0x83aa,
	0x8393,
	0x839c,
	0x8385,
	0x837c,
	0x859f,
	0x83a9,
	0x837d,
	0x8555,
	0x837b,
	0x8398,
	0x839e,
	0x83a8,
	0x9daf,
	0x8493,
	0x83c1,
	0x8401,
	0x83e5,
	0x83d8,
	0x5807,
	0x8418,
	0x840b,
	0x83dd,
	0x83fd,
	0x83d6,
	0x841c,
	0x8438,
	0x8411,
	0x8406,
	0x83d4,
	0x83df,
	0x840f,
	0x8403,
	0x83f8,
	0x83f9,
	0x83ea,
	0x83c5,
	0x83c0,
	0x7e08,
	0x83f0,
	0x83e1,
	0x845c,
	0x8451,
	0x845a,
	0x8459,
	0x8473,
	0x8546,
	0x8488,
	0x847a,
	0x8562,
	0x8478,
	0x843c,
	0x8446,
	0x8469,
	0x8476,
	0x851e,
	0x848e,
	0x8431,
	0x846d,
	0x84c1,
	0x84cd,
	0x84d0,
	0x9a40,
	0x84bd,
	0x84d3,
	0x84ca,
	0x84bf,
	0x84ba,
	0x863a,
	0x84a1,
	0x84b9,
	0x84b4,
	0x8497,
	0x93a3,
	0x8577,
	0x850c,
	0x750d,
	0x8538,
	0x84f0,
	0x861e,
	0x851f,
	0x85fa
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_49[]=
	{
	0x8556,
	0x853b,
	0x84ff,
	0x84fc,
	0x8559,
	0x8548,
	0x8568,
	0x8564,
	0x855e,
	0x857a,
	0x77a2,
	0x8543,
	0x8604,
	0x857b,
	0x85a4,
	0x85a8,
	0x8587,
	0x858f,
	0x8579,
	0x85ea,
	0x859c,
	0x8585,
	0x85b9,
	0x85b7,
	0x85b0,
	0x861a,
	0x85c1,
	0x85dc,
	0x85ff,
	0x8627,
	0x8605,
	0x8629,
	0x8616,
	0x863c,
	0x5efe,
	0x5f08,
	0x593c,
	0x5969,
	0x8037,
	0x5955,
	0x595a,
	0x5958,
	0x530f,
	0x5c22,
	0x5c25,
	0x5c2c,
	0x5c37,
	0x624c,
	0x636b,
	0x6476,
	0x62bb,
	0x62ca,
	0x62da,
	0x62d7,
	0x62ee,
	0x649f,
	0x62f6,
	0x6339,
	0x634b,
	0x6343,
	0x63ad,
	0x63f6,
	0x6371,
	0x637a,
	0x638e,
	0x6451,
	0x636d,
	0x63ac,
	0x638a,
	0x6369,
	0x63ae,
	0x645c,
	0x63f2,
	0x63f8,
	0x63e0,
	0x64b3,
	0x63c4,
	0x63de,
	0x63ce,
	0x6452,
	0x63c6,
	0x63be,
	0x6504,
	0x6441,
	0x640b,
	0x641b,
	0x6420,
	0x640c,
	0x6426,
	0x6421,
	0x645e,
	0x6516,
	0x646d,
	0x6496
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_50[]=
	{
	0x647a,
	0x64f7,
	0x64fc,
	0x6499,
	0x651b,
	0x64c0,
	0x64d0,
	0x64d7,
	0x64e4,
	0x64e2,
	0x6509,
	0x6525,
	0x652e,
	0x5f0b,
	0x5fd2,
	0x7519,
	0x5f11,
	0x535f,
	0x53f1,
	0x5630,
	0x53e9,
	0x53e8,
	0x53fb,
	0x5412,
	0x5416,
	0x5406,
	0x544b,
	0x5638,
	0x56c8,
	0x5454,
	0x56a6,
	0x5443,
	0x5421,
	0x5504,
	0x54bc,
	0x5423,
	0x5432,
	0x5482,
	0x5494,
	0x5477,
	0x5471,
	0x5464,
	0x549a,
	0x5680,
	0x5484,
	0x5476,
	0x5466,
	0x565d,
	0x54d0,
	0x54ad,
	0x54c2,
	0x54b4,
	0x5660,
	0x54a7,
	0x54a6,
	0x5635,
	0x55f6,
	0x5472,
	0x54a3,
	0x5666,
	0x54bb,
	0x54bf,
	0x54cc,
	0x5672,
	0x54da,
	0x568c,
	0x54a9,
	0x54aa,
	0x54a4,
	0x5665,
	0x54cf,
	0x54de,
	0x561c,
	0x54e7,
	0x562e,
	0x54fd,
	0x5514,
	0x54f3,
	0x55e9,
	0x5523,
	0x550f,
	0x5511,
	0x5527,
	0x552a,
	0x5616,
	0x558f,
	0x55b5,
	0x5549,
	0x56c0,
	0x5541,
	0x5555,
	0x553f,
	0x5550,
	0x553c
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_51[]=
	{
	0x5537,
	0x5556,
	0x5575,
	0x5576,
	0x5577,
	0x5533,
	0x5530,
	0x555c,
	0x558b,
	0x55d2,
	0x5583,
	0x55b1,
	0x55b9,
	0x5588,
	0x5581,
	0x559f,
	0x557e,
	0x55d6,
	0x5591,
	0x557b,
	0x55df,
	0x560d,
	0x56b3,
	0x5594,
	0x5599,
	0x55ea,
	0x55f7,
	0x55c9,
	0x561f,
	0x55d1,
	0x56c1,
	0x55ec,
	0x55d4,
	0x55e6,
	0x55dd,
	0x55c4,
	0x55ef,
	0x55e5,
	0x55f2,
	0x566f,
	0x55cc,
	0x55cd,
	0x55e8,
	0x55f5,
	0x55e4,
	0x8f61,
	0x561e,
	0x5608,
	0x560c,
	0x5601,
	0x56b6,
	0x5623,
	0x55fe,
	0x5600,
	0x5627,
	0x562d,
	0x5658,
	0x5639,
	0x5657,
	0x562c,
	0x564d,
	0x5662,
	0x5659,
	0x5695,
	0x564c,
	0x5654,
	0x5686,
	0x5664,
	0x5671,
	0x566b,
	0x567b,
	0x567c,
	0x5685,
	0x5693,
	0x56af,
	0x56d4,
	0x56d7,
	0x56dd,
	0x56e1,
	0x5707,
	0x56eb,
	0x56f9,
	0x56ff,
	0x5704,
	0x570a,
	0x5709,
	0x571c,
	0x5e43,
	0x5e19,
	0x5e14,
	0x5e11,
	0x5e6c,
	0x5e58,
	0x5e57
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_52[]=
	{
	0x5e37,
	0x5e44,
	0x5e54,
	0x5e5b,
	0x5e5e,
	0x5e61,
	0x5c8c,
	0x5c7a,
	0x5c8d,
	0x5c90,
	0x5d87,
	0x5c88,
	0x5cf4,
	0x5c99,
	0x5c91,
	0x5d50,
	0x5c9c,
	0x5cb5,
	0x5ca2,
	0x5d2c,
	0x5cac,
	0x5cab,
	0x5cb1,
	0x5ca3,
	0x5cc1,
	0x5cb7,
	0x5da7,
	0x5cd2,
	0x5da0,
	0x5ccb,
	0x5d22,
	0x5d97,
	0x5d0d,
	0x5d27,
	0x5d26,
	0x5d2e,
	0x5d24,
	0x5d1e,
	0x5d06,
	0x5d1b,
	0x5db8,
	0x5d3e,
	0x5d34,
	0x5d3d,
	0x5d6c,
	0x5d5b,
	0x5d6f,
	0x5d81,
	0x5d6b,
	0x5d4b,
	0x5d4a,
	0x5d69,
	0x5d74,
	0x5d82,
	0x5d99,
	0x5d9d,
	0x8c73,
	0x5db7,
	0x5dd4,
	0x5f73,
	0x5f77,
	0x5f82,
	0x5f87,
	0x5f89,
	0x540e,
	0x5fa0,
	0x5f99,
	0x5f9c,
	0x5fa8,
	0x5fad,
	0x5fb5,
	0x5fbc,
	0x8862,
	0x5f61,
	0x72ad,
	0x72b0,
	0x72b4,
	0x7377,
	0x7341,
	0x72c3,
	0x72c1,
	0x72ce,
	0x72cd,
	0x72d2,
	0x72e8,
	0x736a,
	0x72e9,
	0x733b,
	0x72f4,
	0x72f7,
	0x7301,
	0x72f3,
	0x736b,
	0x72fa
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_53[]=
	{
	0x72fb,
	0x7317,
	0x7313,
	0x7380,
	0x730a,
	0x731e,
	0x731d,
	0x737c,
	0x7322,
	0x7339,
	0x7325,
	0x732c,
	0x7338,
	0x7331,
	0x7350,
	0x734d,
	0x7357,
	0x7360,
	0x736c,
	0x736f,
	0x737e,
	0x821b,
	0x5925,
	0x98e7,
	0x5924,
	0x5902,
	0x98e0,
	0x9933,
	0x98e9,
	0x993c,
	0x98ea,
	0x98eb,
	0x98ed,
	0x98f4,
	0x9909,
	0x9911,
	0x4f59,
	0x991b,
	0x9937,
	0x993f,
	0x9943,
	0x9948,
	0x9949,
	0x994a,
	0x994c,
	0x9962,
	0x5e80,
	0x5ee1,
	0x5e8b,
	0x5e96,
	0x5ea5,
	0x5ea0,
	0x5eb9,
	0x5eb5,
	0x5ebe,
	0x5eb3,
	0x8ce1,
	0x5ed2,
	0x5ed1,
	0x5edb,
	0x5ee8,
	0x5eea,
	0x81ba,
	0x5fc4,
	0x5fc9,
	0x5fd6,
	0x61fa,
	0x61ae,
	0x5fee,
	0x616a,
	0x5fe1,
	0x5fe4,
	0x613e,
	0x60b5,
	0x6134,
	0x5fea,
	0x5fed,
	0x5ff8,
	0x6019,
	0x6035,
	0x6026,
	0x601b,
	0x600f,
	0x600d,
	0x6029,
	0x602b,
	0x600a,
	0x61cc,
	0x6021,
	0x615f,
	0x61e8,
	0x60fb,
	0x6137,
	0x6042
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_54[]=
	{
	0x606a,
	0x60f2,
	0x6096,
	0x609a,
	0x6173,
	0x609d,
	0x6083,
	0x6092,
	0x608c,
	0x609b,
	0x611c,
	0x60bb,
	0x60b1,
	0x60dd,
	0x60d8,
	0x60c6,
	0x60da,
	0x60b4,
	0x6120,
	0x6192,
	0x6115,
	0x6123,
	0x60f4,
	0x6100,
	0x610e,
	0x612b,
	0x614a,
	0x6175,
	0x61ac,
	0x6194,
	0x61a7,
	0x61b7,
	0x61d4,
	0x61f5,
	0x5fdd,
	0x96b3,
	0x9582,
	0x9586,
	0x95c8,
	0x958e,
	0x9594,
	0x958c,
	0x95e5,
	0x95ad,
	0x95ab,
	0x9b2e,
	0x95ac,
	0x95be,
	0x95b6,
	0x9b29,
	0x95bf,
	0x95bd,
	0x95bc,
	0x95c3,
	0x95cb,
	0x95d4,
	0x95d0,
	0x95d5,
	0x95de,
	0x4e2c,
	0x723f,
	0x6215,
	0x6c35,
	0x6c54,
	0x6c5c,
	0x6c4a,
	0x7043,
	0x6c85,
	0x6c90,
	0x6c94,
	0x6c8c,
	0x6c68,
	0x6c69,
	0x6c74,
	0x6c76,
	0x6c86,
	0x6f59,
	0x6cd0,
	0x6cd4,
	0x6cad,
	0x7027,
	0x7018,
	0x6cf1,
	0x6cd7,
	0x6cb2,
	0x6ce0,
	0x6cd6,
	0x6ffc,
	0x6ceb,
	0x6cee,
	0x6cb1,
	0x6cd3,
	0x6cef,
	0x6d87
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_55[]=
	{
	0x6d39,
	0x6d27,
	0x6d0c,
	0x6d79,
	0x6e5e,
	0x6d07,
	0x6d04,
	0x6d19,
	0x6d0e,
	0x6d2b,
	0x6fae,
	0x6d2e,
	0x6d35,
	0x6d1a,
	0x700f,
	0x6ef8,
	0x6f6f,
	0x6d33,
	0x6d91,
	0x6d6f,
	0x6df6,
	0x6f7f,
	0x6d5e,
	0x6d93,
	0x6d94,
	0x6d5c,
	0x6d60,
	0x6d7c,
	0x6d63,
	0x6e1a,
	0x6dc7,
	0x6dc5,
	0x6dde,
	0x7006,
	0x6dbf,
	0x6de0,
	0x6fa0,
	0x6de6,
	0x6ddd,
	0x6dd9,
	0x700b,
	0x6dab,
	0x6e0c,
	0x6dae,
	0x6e2b,
	0x6e6e,
	0x6e4e,
	0x6e6b,
	0x6eb2,
	0x6e5f,
	0x6e86,
	0x6e53,
	0x6e54,
	0x6e32,
	0x6e25,
	0x6e44,
	0x7067,
	0x6eb1,
	0x6e98,
	0x7044,
	0x6f2d,
	0x7005,
	0x6ea5,
	0x6ea7,
	0x6ebd,
	0x6ebb,
	0x6eb7,
	0x6f77,
	0x6eb4,
	0x6ecf,
	0x6e8f,
	0x6ec2,
	0x6e9f,
	0x6f62,
	0x7020,
	0x701f,
	0x6f24,
	0x6f15,
	0x6ef9,
	0x6f2f,
	0x6f36,
	0x7032,
	0x6f74,
	0x6f2a,
	0x6f09,
	0x6f29,
	0x6f89,
	0x6f8d,
	0x6f8c,
	0x6f78,
	0x6f72,
	0x6f7c,
	0x6f7a,
	0x7028
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_56[]=
	{
	0x6fc9,
	0x6fa7,
	0x6fb9,
	0x6fb6,
	0x6fc2,
	0x6fe1,
	0x6fee,
	0x6fde,
	0x6fe0,
	0x6fef,
	0x701a,
	0x7023,
	0x701b,
	0x7039,
	0x7035,
	0x705d,
	0x705e,
	0x5b80,
	0x5b84,
	0x5b95,
	0x5b93,
	0x5ba5,
	0x5bb8,
	0x752f,
	0x9a2b,
	0x6434,
	0x5be4,
	0x5bee,
	0x8930,
	0x5bf0,
	0x8e47,
	0x8b07,
	0x8fb6,
	0x8fd3,
	0x8fd5,
	0x8fe5,
	0x8fee,
	0x8fe4,
	0x9087,
	0x8fe6,
	0x9015,
	0x8fe8,
	0x9005,
	0x9004,
	0x900b,
	0x9090,
	0x9011,
	0x900d,
	0x9016,
	0x9021,
	0x9035,
	0x9036,
	0x902d,
	0x902f,
	0x9044,
	0x9051,
	0x9052,
	0x9050,
	0x9068,
	0x9058,
	0x9062,
	0x905b,
	0x66b9,
	0x9074,
	0x907d,
	0x9082,
	0x9088,
	0x9083,
	0x908b,
	0x5f50,
	0x5f57,
	0x5f56,
	0x5f58,
	0x5c3b,
	0x54ab,
	0x5c50,
	0x5c59,
	0x5b71,
	0x5c63,
	0x5c68,
	0x7fbc,
	0x5f33,
	0x5f29,
	0x5f2d,
	0x8274,
	0x5f3c,
	0x9b3b,
	0x5c6e,
	0x5981,
	0x5983,
	0x598d,
	0x5af5,
	0x5ad7,
	0x59a3
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_57[]=
	{
	0x5997,
	0x59ca,
	0x5b00,
	0x599e,
	0x59a4,
	0x59d2,
	0x59b2,
	0x59af,
	0x59d7,
	0x59be,
	0x5a6d,
	0x5b08,
	0x59dd,
	0x5b4c,
	0x59e3,
	0x59d8,
	0x59f9,
	0x5a0c,
	0x5a09,
	0x5aa7,
	0x5afb,
	0x5a11,
	0x5a23,
	0x5a13,
	0x5a40,
	0x5a67,
	0x5a4a,
	0x5a55,
	0x5a3c,
	0x5a62,
	0x5b0b,
	0x80ec,
	0x5aaa,
	0x5a9b,
	0x5a77,
	0x5a7a,
	0x5abe,
	0x5aeb,
	0x5ab2,
	0x5b21,
	0x5b2a,
	0x5ab8,
	0x5ae0,
	0x5ae3,
	0x5b19,
	0x5ad6,
	0x5ae6,
	0x5ad8,
	0x5adc,
	0x5b09,
	0x5b17,
	0x5b16,
	0x5b32,
	0x5b37,
	0x5b40,
	0x5c15,
	0x5c1c,
	0x5b5a,
	0x5b65,
	0x5b73,
	0x5b51,
	0x5b53,
	0x5b62,
	0x99d4,
	0x99df,
	0x99d9,
	0x9a36,
	0x9a5b,
	0x99d1,
	0x99d8,
	0x9a4d,
	0x9a4a,
	0x99e2,
	0x9a6a,
	0x9a0f,
	0x9a0d,
	0x9a05,
	0x9a42,
	0x9a2d,
	0x9a16,
	0x9a41,
	0x9a2e,
	0x9a38,
	0x9a43,
	0x9a44,
	0x9a4f,
	0x9a65,
	0x9a64,
	0x7cf9,
	0x7d06,
	0x7d02,
	0x7d07,
	0x7d08,
	0x7e8a
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_58[]=
	{
	0x7d1c,
	0x7d15,
	0x7d13,
	0x7d3a,
	0x7d32,
	0x7d31,
	0x7e10,
	0x7d3c,
	0x7d40,
	0x7d3f,
	0x7d5d,
	0x7d4e,
	0x7d73,
	0x7d86,
	0x7d83,
	0x7d88,
	0x7dbe,
	0x7dba,
	0x7dcb,
	0x7dd4,
	0x7dc4,
	0x7d9e,
	0x7dac,
	0x7db9,
	0x7da3,
	0x7db0,
	0x7dc7,
	0x7dd9,
	0x7dd7,
	0x7df9,
	0x7df2,
	0x7e62,
	0x7de6,
	0x7df6,
	0x7df1,
	0x7e0b,
	0x7de1,
	0x7e09,
	0x7e1d,
	0x7e1f,
	0x7e1e,
	0x7e2d,
	0x7e0a,
	0x7e11,
	0x7e7d,
	0x7e39,
	0x7e35,
	0x7e32,
	0x7e46,
	0x7e45,
	0x7e88,
	0x7e5a,
	0x7e52,
	0x7e6e,
	0x7e7e,
	0x7e70,
	0x7e6f,
	0x7e98,
	0x5e7a,
	0x757f,
	0x5ddb,
	0x753e,
	0x9095,
	0x738e,
	0x74a3,
	0x744b,
	0x73a2,
	0x739f,
	0x73cf,
	0x73c2,
	0x74cf,
	0x73b7,
	0x73b3,
	0x73c0,
	0x73c9,
	0x73c8,
	0x73e5,
	0x73d9,
	0x980a,
	0x740a,
	0x73e9,
	0x73e7,
	0x73de,
	0x74bd,
	0x743f,
	0x7489,
	0x742a,
	0x745b,
	0x7426,
	0x7425,
	0x7428,
	0x7430,
	0x742e,
	0x742c
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_59[]=
	{
	0x741b,
	0x741a,
	0x7441,
	0x745c,
	0x7457,
	0x7455,
	0x7459,
	0x74a6,
	0x746d,
	0x747e,
	0x749c,
	0x74d4,
	0x7480,
	0x7481,
	0x7487,
	0x748b,
	0x749e,
	0x74a8,
	0x74a9,
	0x7490,
	0x74a7,
	0x74da,
	0x74ba,
	0x97d9,
	0x97de,
	0x97dc,
	0x674c,
	0x6753,
	0x675e,
	0x6748,
	0x69aa,
	0x6aea,
	0x6787,
	0x676a,
	0x6773,
	0x6798,
	0x6898,
	0x6775,
	0x68d6,
	0x6a05,
	0x689f,
	0x678b,
	0x6777,
	0x677c,
	0x67f0,
	0x6adb,
	0x67d8,
	0x6af3,
	0x67e9,
	0x67b0,
	0x6ae8,
	0x67d9,
	0x67b5,
	0x67da,
	0x67b3,
	0x67dd,
	0x6800,
	0x67c3,
	0x67b8,
	0x67e2,
	0x6adf,
	0x67c1,
	0x6a89,
	0x6832,
	0x6833,
	0x690f,
	0x6a48,
	0x684e,
	0x6968,
	0x6844,
	0x69bf,
	0x6883,
	0x681d,
	0x6855,
	0x6a3a,
	0x6841,
	0x6a9c,
	0x6840,
	0x6b12,
	0x684a,
	0x6849,
	0x6829,
	0x68b5,
	0x688f,
	0x6874,
	0x6877,
	0x6893,
	0x686b,
	0x6b1e,
	0x696e,
	0x68fc,
	0x6add,
	0x69e7,
	0x68f9
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_60[]=
	{
	0x6b0f,
	0x68f0,
	0x690b,
	0x6901,
	0x6957,
	0x68e3,
	0x6910,
	0x6971,
	0x6939,
	0x6960,
	0x6942,
	0x695d,
	0x6b16,
	0x696b,
	0x6980,
	0x6998,
	0x6978,
	0x6934,
	0x69cc,
	0x6aec,
	0x6ada,
	0x69ce,
	0x6af8,
	0x6966,
	0x6963,
	0x6979,
	0x699b,
	0x69a7,
	0x69bb,
	0x69ab,
	0x69ad,
	0x69d4,
	0x69b1,
	0x69c1,
	0x69ca,
	0x6ab3,
	0x6995,
	0x6ae7,
	0x698d,
	0x69ff,
	0x6aa3,
	0x69ed,
	0x6a17,
	0x6a18,
	0x6a65,
	0x69f2,
	0x6a44,
	0x6a3e,
	0x6aa0,
	0x6a50,
	0x6a5b,
	0x6a35,
	0x6a8e,
	0x6ad3,
	0x6a3d,
	0x6a28,
	0x6a58,
	0x6ade,
	0x6a91,
	0x6a90,
	0x6aa9,
	0x6a97,
	0x6aab,
	0x7337,
	0x7352,
	0x6b81,
	0x6b82,
	0x6ba4,
	0x6b84,
	0x6b9e,
	0x6bae,
	0x6b8d,
	0x6bab,
	0x6b9b,
	0x6baf,
	0x6baa,
	0x8ed4,
	0x8edb,
	0x8ef2,
	0x8efb,
	0x8f64,
	0x8ef9,
	0x8efc,
	0x8eeb,
	0x8ee4,
	0x8f62,
	0x8efa,
	0x8efe,
	0x8f0a,
	0x8f07,
	0x8f05,
	0x8f12,
	0x8f26,
	0x8f1e
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_61[]=
	{
	0x8f1f,
	0x8f1c,
	0x8f33,
	0x8f46,
	0x8f54,
	0x8ece,
	0x6214,
	0x6227,
	0x621b,
	0x621f,
	0x6222,
	0x6221,
	0x6225,
	0x6224,
	0x6229,
	0x81e7,
	0x750c,
	0x74f4,
	0x74ff,
	0x750f,
	0x7511,
	0x7513,
	0x6534,
	0x65ee,
	0x65ef,
	0x65f0,
	0x660a,
	0x66c7,
	0x6772,
	0x6603,
	0x6615,
	0x6600,
	0x7085,
	0x66f7,
	0x661d,
	0x6634,
	0x6631,
	0x6636,
	0x6635,
	0x8006,
	0x665f,
	0x66c4,
	0x6641,
	0x664f,
	0x6689,
	0x6661,
	0x6657,
	0x6677,
	0x6684,
	0x668c,
	0x66d6,
	0x669d,
	0x66be,
	0x66db,
	0x66dc,
	0x66e6,
	0x66e9,
	0x8cc1,
	0x8cb0,
	0x8cba,
	0x8cbd,
	0x8d04,
	0x8cb2,
	0x8cc5,
	0x8d10,
	0x8cd1,
	0x8cda,
	0x8cd5,
	0x8ceb,
	0x8ce7,
	0x8cfb,
	0x8998,
	0x89ac,
	0x89a1,
	0x89bf,
	0x89a6,
	0x89af,
	0x89b2,
	0x89b7,
	0x726e,
	0x729f,
	0x725d,
	0x7266,
	0x726f,
	0x727e,
	0x727f,
	0x7284,
	0x728b,
	0x728d,
	0x728f,
	0x7292,
	0x6308,
	0x6332,
	0x63b0
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_62[]=
	{
	0x643f,
	0x64d8,
	0x8004,
	0x6bea,
	0x6bf3,
	0x6bfd,
	0x6bff,
	0x6bf9,
	0x6c05,
	0x6c0c,
	0x6c06,
	0x6c0d,
	0x6c15,
	0x6c18,
	0x6c19,
	0x6c1a,
	0x6c21,
	0x6c2c,
	0x6c24,
	0x6c2a,
	0x6c32,
	0x6535,
	0x6555,
	0x656b,
	0x7258,
	0x7252,
	0x7256,
	0x7230,
	0x8662,
	0x5216,
	0x809f,
	0x809c,
	0x8093,
	0x80bc,
	0x670a,
	0x80bd,
	0x80b1,
	0x80ab,
	0x80ad,
	0x80b4,
	0x80b7,
	0x6727,
	0x8156,
	0x80e9,
	0x81da,
	0x80db,
	0x80c2,
	0x80c4,
	0x80d9,
	0x80cd,
	0x80d7,
	0x6710,
	0x80dd,
	0x811b,
	0x80f1,
	0x80f4,
	0x80ed,
	0x81be,
	0x810e,
	0x80f2,
	0x80fc,
	0x6715,
	0x8112,
	0x8c5a,
	0x8161,
	0x811e,
	0x812c,
	0x8118,
	0x8132,
	0x8148,
	0x814c,
	0x8153,
	0x8174,
	0x8159,
	0x815a,
	0x8171,
	0x8160,
	0x8169,
	0x817c,
	0x817d,
	0x816d,
	0x8167,
	0x584d,
	0x5ab5,
	0x8188,
	0x8182,
	0x81cf,
	0x6ed5,
	0x81a3,
	0x81aa,
	0x81cc,
	0x6726,
	0x81ca,
	0x81bb
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_63[]=
	{
	0x81c1,
	0x81a6,
	0x6b5f,
	0x6b37,
	0x6b39,
	0x6b43,
	0x6b46,
	0x6b59,
	0x98ae,
	0x98af,
	0x98b6,
	0x98bc,
	0x98c6,
	0x98c8,
	0x6bb3,
	0x5f40,
	0x8f42,
	0x89f3,
	0x6590,
	0x9f4f,
	0x6595,
	0x65bc,
	0x65c6,
	0x65c4,
	0x65c3,
	0x65cc,
	0x65ce,
	0x65d2,
	0x65d6,
	0x716c,
	0x7152,
	0x7096,
	0x7197,
	0x70bb,
	0x70c0,
	0x70b7,
	0x70ab,
	0x70b1,
	0x71c1,
	0x70ca,
	0x7110,
	0x7113,
	0x71dc,
	0x712f,
	0x7131,
	0x7173,
	0x715c,
	0x7168,
	0x7145,
	0x7172,
	0x714a,
	0x7178,
	0x717a,
	0x7198,
	0x71b3,
	0x71b5,
	0x71a8,
	0x71a0,
	0x71e0,
	0x71d4,
	0x71e7,
	0x71f9,
	0x721d,
	0x7228,
	0x706c,
	0x71fe,
	0x7166,
	0x71b9,
	0x623e,
	0x623d,
	0x6243,
	0x6248,
	0x6249,
	0x793b,
	0x7940,
	0x7946,
	0x7949,
	0x795b,
	0x795c,
	0x7953,
	0x795a,
	0x79b0,
	0x7957,
	0x7960,
	0x798e,
	0x7967,
	0x797a,
	0x79aa,
	0x798a,
	0x799a,
	0x79a7,
	0x79b3,
	0x5fd1,
	0x5fd0
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_64[]=
	{
	0x61df,
	0x605d,
	0x605a,
	0x6067,
	0x6041,
	0x6059,
	0x6063,
	0x6164,
	0x6106,
	0x610d,
	0x615d,
	0x61a9,
	0x619d,
	0x61cb,
	0x61e3,
	0x6207,
	0x8080,
	0x807f,
	0x6c93,
	0x6fa9,
	0x6dfc,
	0x78ef,
	0x77f8,
	0x78ad,
	0x7809,
	0x7868,
	0x7818,
	0x7811,
	0x65ab,
	0x782d,
	0x78b8,
	0x781d,
	0x7839,
	0x792a,
	0x7931,
	0x781f,
	0x783c,
	0x7825,
	0x782c,
	0x7823,
	0x7829,
	0x784e,
	0x786d,
	0x7864,
	0x78fd,
	0x7826,
	0x7850,
	0x7847,
	0x784c,
	0x786a,
	0x78e7,
	0x7893,
	0x789a,
	0x7887,
	0x78e3,
	0x78a1,
	0x78a3,
	0x78b2,
	0x78b9,
	0x78a5,
	0x78d4,
	0x78d9,
	0x78c9,
	0x78ec,
	0x78f2,
	0x7905,
	0x78f4,
	0x7913,
	0x7924,
	0x791e,
	0x7934,
	0x9f95,
	0x9ef9,
	0x9efb,
	0x9efc,
	0x76f1,
	0x7704,
	0x7798,
	0x76f9,
	0x7707,
	0x7708,
	0x771a,
	0x7722,
	0x7719,
	0x772d,
	0x7726,
	0x7735,
	0x7738,
	0x775e,
	0x77bc,
	0x7747,
	0x7743,
	0x775a,
	0x7768
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_65[]=
	{
	0x7762,
	0x7765,
	0x777f,
	0x778d,
	0x777d,
	0x7780,
	0x778c,
	0x7791,
	0x779f,
	0x77a0,
	0x77b0,
	0x77b5,
	0x77bd,
	0x753a,
	0x7540,
	0x754e,
	0x754b,
	0x7548,
	0x755b,
	0x7572,
	0x7579,
	0x7583,
	0x7f58,
	0x7f61,
	0x7f5f,
	0x8a48,
	0x7f68,
	0x7f86,
	0x7f71,
	0x7f79,
	0x7f88,
	0x7f7e,
	0x76cd,
	0x76e5,
	0x8832,
	0x91d2,
	0x91d3,
	0x91d4,
	0x91d9,
	0x91d7,
	0x91d5,
	0x91f7,
	0x91e7,
	0x91e4,
	0x9346,
	0x91f5,
	0x91f9,
	0x9208,
	0x9226,
	0x9245,
	0x9211,
	0x9210,
	0x9201,
	0x9227,
	0x9204,
	0x9225,
	0x9200,
	0x923a,
	0x9266,
	0x9237,
	0x9233,
	0x9255,
	0x923d,
	0x9238,
	0x925e,
	0x926c,
	0x926d,
	0x923f,
	0x9460,
	0x9230,
	0x9249,
	0x9248,
	0x924d,
	0x922e,
	0x9239,
	0x9438,
	0x92ac,
	0x92a0,
	0x927a,
	0x92aa,
	0x92ee,
	0x92cf,
	0x9403,
	0x92e3,
	0x943a,
	0x92b1,
	0x92a6,
	0x93a7,
	0x9296,
	0x92cc,
	0x92a9,
	0x93f5,
	0x9293,
	0x927f
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_66[]=
	{
	0x93a9,
	0x929a,
	0x931a,
	0x92ab,
	0x9283,
	0x940b,
	0x92a8,
	0x92a3,
	0x9412,
	0x9338,
	0x92f1,
	0x93d7,
	0x92e5,
	0x92f0,
	0x92ef,
	0x92e8,
	0x92bc,
	0x92dd,
	0x92f6,
	0x9426,
	0x9427,
	0x92c3,
	0x92df,
	0x92e6,
	0x9312,
	0x9306,
	0x9369,
	0x931b,
	0x9340,
	0x9301,
	0x9315,
	0x932e,
	0x9343,
	0x9307,
	0x9308,
	0x931f,
	0x9319,
	0x9365,
	0x9347,
	0x9376,
	0x9354,
	0x9364,
	0x93aa,
	0x9370,
	0x9384,
	0x93e4,
	0x93d8,
	0x9428,
	0x9387,
	0x93cc,
	0x9398,
	0x93b8,
	0x93bf,
	0x93a6,
	0x93b0,
	0x93b5,
	0x944c,
	0x93e2,
	0x93dc,
	0x93dd,
	0x93cd,
	0x93de,
	0x93c3,
	0x93c7,
	0x93d1,
	0x9414,
	0x941d,
	0x93f7,
	0x9465,
	0x9413,
	0x946d,
	0x9420,
	0x9479,
	0x93f9,
	0x9419,
	0x944a,
	0x9432,
	0x943f,
	0x9454,
	0x9463,
	0x937e,
	0x77e7,
	0x77ec,
	0x96c9,
	0x79d5,
	0x79ed,
	0x79e3,
	0x79eb,
	0x7a06,
	0x5d47,
	0x7a03,
	0x7a02,
	0x7a1e,
	0x7a14
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_67[]=
	{
	0x7a39,
	0x7a37,
	0x7a61,
	0x9ecf,
	0x99a5,
	0x7a70,
	0x7688,
	0x768e,
	0x7693,
	0x7699,
	0x76a4,
	0x74de,
	0x74e0,
	0x752c,
	0x9ce9,
	0x9cf6,
	0x9d07,
	0x9d06,
	0x9d23,
	0x9d87,
	0x9e15,
	0x9d1d,
	0x9d1f,
	0x9de5,
	0x9d2f,
	0x9dd9,
	0x9d30,
	0x9d42,
	0x9e1e,
	0x9d53,
	0x9e1d,
	0x9d60,
	0x9d52,
	0x9df3,
	0x9d5c,
	0x9d61,
	0x9d93,
	0x9d6a,
	0x9d6f,
	0x9d89,
	0x9d98,
	0x9d9a,
	0x9dc0,
	0x9da5,
	0x9da9,
	0x9dc2,
	0x9dbc,
	0x9e1a,
	0x9dd3,
	0x9dda,
	0x9def,
	0x9de6,
	0x9df2,
	0x9df8,
	0x9e0c,
	0x9dfa,
	0x9e1b,
	0x7592,
	0x7594,
	0x7664,
	0x7658,
	0x759d,
	0x7667,
	0x75a3,
	0x75b3,
	0x75b4,
	0x75b8,
	0x75c4,
	0x75b1,
	0x75b0,
	0x75c3,
	0x75c2,
	0x7602,
	0x75cd,
	0x75e3,
	0x7646,
	0x75e6,
	0x75e4,
	0x7647,
	0x75e7,
	0x7603,
	0x75f1,
	0x75fc,
	0x75ff,
	0x7610,
	0x7600,
	0x7649,
	0x760c,
	0x761e,
	0x760a,
	0x7625,
	0x763b,
	0x7615,
	0x7619
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_68[]=
	{
	0x761b,
	0x763c,
	0x7622,
	0x7620,
	0x7640,
	0x762d,
	0x7630,
	0x766d,
	0x7635,
	0x7643,
	0x766e,
	0x7633,
	0x764d,
	0x7669,
	0x7654,
	0x765c,
	0x7656,
	0x7672,
	0x766f,
	0x7fca,
	0x7ae6,
	0x7a78,
	0x7a79,
	0x7a80,
	0x7a86,
	0x7a88,
	0x7a95,
	0x7ac7,
	0x7aa0,
	0x7aac,
	0x7aa8,
	0x7ab6,
	0x7ab3,
	0x8864,
	0x8869,
	0x8872,
	0x887d,
	0x887f,
	0x8882,
	0x88a2,
	0x8960,
	0x88b7,
	0x88bc,
	0x88c9,
	0x8933,
	0x88ce,
	0x895d,
	0x8947,
	0x88f1,
	0x891a,
	0x88fc,
	0x88e8,
	0x88fe,
	0x88f0,
	0x8921,
	0x8919,
	0x8913,
	0x8938,
	0x890a,
	0x8964,
	0x892b,
	0x8936,
	0x8941,
	0x8966,
	0x897b,
	0x758b,
	0x80e5,
	0x76b8,
	0x76b4,
	0x77dc,
	0x8012,
	0x8014,
	0x8016,
	0x801c,
	0x8020,
	0x802e,
	0x8025,
	0x8026,
	0x802c,
	0x8029,
	0x8028,
	0x8031,
	0x800b,
	0x8035,
	0x8043,
	0x8046,
	0x8079,
	0x8052,
	0x8075,
	0x8071,
	0x8983,
	0x9807,
	0x980e,
	0x980f
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_69[]=
	{
	0x9821,
	0x981c,
	0x6f41,
	0x9826,
	0x9837,
	0x984e,
	0x9853,
	0x9873,
	0x9862,
	0x9859,
	0x9865,
	0x986c,
	0x9870,
	0x864d,
	0x8654,
	0x866c,
	0x87e3,
	0x8806,
	0x867a,
	0x867c,
	0x867b,
	0x86a8,
	0x868d,
	0x868b,
	0x8706,
	0x869d,
	0x86a7,
	0x86a3,
	0x86aa,
	0x8693,
	0x86a9,
	0x86b6,
	0x86c4,
	0x86b5,
	0x8823,
	0x86b0,
	0x86ba,
	0x86b1,
	0x86af,
	0x86c9,
	0x87f6,
	0x86b4,
	0x86e9,
	0x86fa,
	0x87ef,
	0x86ed,
	0x8784,
	0x86d0,
	0x8713,
	0x86de,
	0x8810,
	0x86df,
	0x86d8,
	0x86d1,
	0x8703,
	0x8707,
	0x86f8,
	0x8708,
	0x870a,
	0x870d,
	0x8709,
	0x8723,
	0x873b,
	0x871e,
	0x8725,
	0x872e,
	0x871a,
	0x873e,
	0x87c8,
	0x8734,
	0x8731,
	0x8729,
	0x8737,
	0x873f,
	0x8782,
	0x8722,
	0x877d,
	0x8811,
	0x877b,
	0x8760,
	0x8770,
	0x874c,
	0x876e,
	0x878b,
	0x8753,
	0x8763,
	0x87bb,
	0x8764,
	0x8759,
	0x8765,
	0x8793,
	0x87af,
	0x87ce,
	0x87d2
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_70[]=
	{
	0x87c6,
	0x8788,
	0x8785,
	0x87ad,
	0x8797,
	0x8783,
	0x87ab,
	0x87e5,
	0x87ac,
	0x87b5,
	0x87b3,
	0x87cb,
	0x87d3,
	0x87bd,
	0x87d1,
	0x87c0,
	0x87ca,
	0x87db,
	0x87ea,
	0x87e0,
	0x87ee,
	0x8816,
	0x8813,
	0x87fe,
	0x880a,
	0x881b,
	0x8821,
	0x8839,
	0x883c,
	0x7f36,
	0x7f4c,
	0x7f44,
	0x7f45,
	0x8210,
	0x7afa,
	0x7afd,
	0x7b08,
	0x7be4,
	0x7b04,
	0x7b67,
	0x7b0a,
	0x7b2b,
	0x7b0f,
	0x7b47,
	0x7b38,
	0x7b2a,
	0x7b19,
	0x7b2e,
	0x7b31,
	0x7b20,
	0x7b25,
	0x7b24,
	0x7b33,
	0x7c69,
	0x7b1e,
	0x7b58,
	0x7bf3,
	0x7b45,
	0x7b75,
	0x7b4c,
	0x7b8f,
	0x7b60,
	0x7b6e,
	0x7b7b,
	0x7b62,
	0x7b72,
	0x7b71,
	0x7b90,
	0x7c00,
	0x7bcb,
	0x7bb8,
	0x7bac,
	0x7b9d,
	0x7c5c,
	0x7b85,
	0x7c1e,
	0x7b9c,
	0x7ba2,
	0x7c2b,
	0x7bb4,
	0x7c23,
	0x7bc1,
	0x7bcc,
	0x7bdd,
	0x7bda,
	0x7be5,
	0x7be6,
	0x7bea,
	0x7c0c,
	0x7bfe,
	0x7bfc,
	0x7c0f,
	0x7c6a,
	0x7c0b
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_71[]=
	{
	0x7c1f,
	0x7c2a,
	0x7c26,
	0x7c38,
	0x7c5f,
	0x7c40,
	0x81fe,
	0x8201,
	0x8202,
	0x8204,
	0x81ec,
	0x8844,
	0x8221,
	0x8222,
	0x8264,
	0x822d,
	0x822f,
	0x8228,
	0x822b,
	0x8238,
	0x826b,
	0x8233,
	0x8234,
	0x823e,
	0x8244,
	0x8249,
	0x824b,
	0x824f,
	0x825a,
	0x825f,
	0x8268,
	0x887e,
	0x88ca,
	0x8888,
	0x88d8,
	0x88df,
	0x895e,
	0x7f9d,
	0x7fa5,
	0x7fa7,
	0x7faf,
	0x7fb0,
	0x7fb2,
	0x7c7c,
	0x6549,
	0x7c91,
	0x7cf2,
	0x7cf6,
	0x7c9e,
	0x7ca2,
	0x7cb2,
	0x7cbc,
	0x7cbd,
	0x7cdd,
	0x7cc7,
	0x7ccc,
	0x7ccd,
	0x7cc8,
	0x7cc5,
	0x7cd7,
	0x7ce8,
	0x826e,
	0x66a8,
	0x7fbf,
	0x7fce,
	0x7fd5,
	0x7fe5,
	0x7fe1,
	0x7fe6,
	0x7fe9,
	0x7fee,
	0x7ff3,
	0x7cf8,
	0x7e36,
	0x7da6,
	0x7dae,
	0x7e47,
	0x7e9b,
	0x9ea9,
	0x9eb4,
	0x8d73,
	0x8d84,
	0x8d94,
	0x8d91,
	0x8db2,
	0x8d67,
	0x8d6d,
	0x8c47,
	0x8c49,
	0x914a,
	0x9150,
	0x914e,
	0x914f,
	0x9164
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_72[]=
	{
	0x9162,
	0x9161,
	0x9170,
	0x9169,
	0x916f,
	0x91c5,
	0x91c3,
	0x9172,
	0x9174,
	0x9179,
	0x918c,
	0x9185,
	0x9190,
	0x918d,
	0x9191,
	0x91a2,
	0x91a3,
	0x91aa,
	0x91ad,
	0x91ae,
	0x91af,
	0x91b5,
	0x91b4,
	0x91ba,
	0x8c55,
	0x9e7a,
	0x8e89,
	0x8deb,
	0x8e05,
	0x8e59,
	0x8e69,
	0x8db5,
	0x8dbf,
	0x8dbc,
	0x8dba,
	0x8e4c,
	0x8dd6,
	0x8dd7,
	0x8dda,
	0x8e92,
	0x8dce,
	0x8dcf,
	0x8ddb,
	0x8dc6,
	0x8dec,
	0x8e7a,
	0x8e55,
	0x8de3,
	0x8e9a,
	0x8e8b,
	0x8de4,
	0x8e09,
	0x8dfd,
	0x8e14,
	0x8e1d,
	0x8e1f,
	0x8e93,
	0x8e2e,
	0x8e23,
	0x8e91,
	0x8e3a,
	0x8e40,
	0x8e39,
	0x8e35,
	0x8e3d,
	0x8e31,
	0x8e49,
	0x8e41,
	0x8e42,
	0x8ea1,
	0x8e63,
	0x8e4a,
	0x8e70,
	0x8e76,
	0x8e7c,
	0x8e6f,
	0x8e74,
	0x8e85,
	0x8eaa,
	0x8e94,
	0x8e90,
	0x8ea6,
	0x8e9e,
	0x8c78,
	0x8c82,
	0x8c8a,
	0x8c85,
	0x8c98,
	0x8c94,
	0x659b,
	0x89d6,
	0x89f4,
	0x89da,
	0x89dc
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_73[]=
	{
	0x89e5,
	0x89eb,
	0x89f6,
	0x8a3e,
	0x8b26,
	0x975a,
	0x96e9,
	0x9742,
	0x96ef,
	0x9706,
	0x973d,
	0x9708,
	0x970f,
	0x970e,
	0x972a,
	0x9744,
	0x9730,
	0x973e,
	0x9f54,
	0x9f5f,
	0x9f59,
	0x9f60,
	0x9f5c,
	0x9f66,
	0x9f6c,
	0x9f6a,
	0x9f77,
	0x9efd,
	0x9eff,
	0x9f09,
	0x96b9,
	0x96bc,
	0x96bd,
	0x96ce,
	0x96d2,
	0x77bf,
	0x8b8e,
	0x928e,
	0x947e,
	0x92c8,
	0x93e8,
	0x936a,
	0x93ca,
	0x938f,
	0x943e,
	0x946b,
	0x9b77,
	0x9b74,
	0x9b81,
	0x9b83,
	0x9b8e,
	0x9c78,
	0x7a4c,
	0x9b92,
	0x9c5f,
	0x9b90,
	0x9bad,
	0x9b9a,
	0x9baa,
	0x9b9e,
	0x9c6d,
	0x9bab,
	0x9b9d,
	0x9c58,
	0x9bc1,
	0x9c7a,
	0x9c31,
	0x9c39,
	0x9c23,
	0x9c37,
	0x9bc0,
	0x9bca,
	0x9bc7,
	0x9bfd,
	0x9bd6,
	0x9bea,
	0x9beb,
	0x9be1,
	0x9be4,
	0x9be7,
	0x9bdd,
	0x9be2,
	0x9bf0,
	0x9bdb,
	0x9bf4,
	0x9bd4,
	0x9c5d,
	0x9c08,
	0x9c10,
	0x9c0d,
	0x9c12,
	0x9c09,
	0x9bff,
	0x9c20
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_74[]=
	{
	0x9c32,
	0x9c2d,
	0x9c28,
	0x9c25,
	0x9c29,
	0x9c33,
	0x9c3e,
	0x9c48,
	0x9c3b,
	0x9c35,
	0x9c45,
	0x9c56,
	0x9c54,
	0x9c52,
	0x9c67,
	0x977c,
	0x9785,
	0x97c3,
	0x97bd,
	0x9794,
	0x97c9,
	0x97ab,
	0x97a3,
	0x97b2,
	0x97b4,
	0x9ab1,
	0x9ab0,
	0x9ab7,
	0x9dbb,
	0x9ab6,
	0x9aba,
	0x9abc,
	0x9ac1,
	0x9ac0,
	0x9acf,
	0x9ac2,
	0x9ad6,
	0x9ad5,
	0x9ad1,
	0x9b45,
	0x9b43,
	0x9b58,
	0x9b4e,
	0x9b48,
	0x9b4d,
	0x9b51,
	0x9957,
	0x995c,
	0x992e,
	0x9955,
	0x9954,
	0x9adf,
	0x9ae1,
	0x9ae6,
	0x9aef,
	0x9aeb,
	0x9afb,
	0x9aed,
	0x9af9,
	0x9b08,
	0x9b0f,
	0x9b22,
	0x9b1f,
	0x9b23,
	0x4e48,
	0x9ebe,
	0x7e3b,
	0x9e82,
	0x9e87,
	0x9e88,
	0x9e8b,
	0x9e92,
	0x93d6,
	0x9e9d,
	0x9e9f,
	0x9edb,
	0x9edc,
	0x9edd,
	0x9ee0,
	0x9edf,
	0x9ee2,
	0x9ef7,
	0x9ee7,
	0x9ee5,
	0x9ef2,
	0x9eef,
	0x9f22,
	0x9f2c,
	0x9f2f,
	0x9f39,
	0x9f37,
	0x9f3d,
	0x9f3e,
	0x9f44
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_75[]=
	{
	0x896c,
	0x95c6,
	0x9336,
	0x5f46,
	0x8514,
	0x7e94,
	0x5382,
	0x51b2,
	0x4e11,
	0x9f63,
	0x5679,
	0x515a,
	0x6dc0,
	0x9f15,
	0x6597,
	0x5641,
	0x9aee,
	0x8303,
	0x4e30,
	0x8907,
	0x5e72,
	0x7a40,
	0x98b3,
	0x5e7f,
	0x95a4,
	0x9b0d,
	0x5212,
	0x8ff4,
	0x5f59,
	0x7a6b,
	0x98e2,
	0x51e0,
	0x50a2,
	0x4ef7,
	0x8350,
	0x8591,
	0x5118,
	0x636e,
	0x6372,
	0x524b,
	0x5938,
	0x774f,
	0x8721,
	0x814a,
	0x7e8d,
	0x91cc,
	0x66c6,
	0x5e18,
	0x77ad,
	0x9e75,
	0x56c9,
	0x9ef4,
	0x6fdb,
	0x61de,
	0x77c7,
	0x7030,
	0x9eb5,
	0x884a,
	0x95e2,
	0x82f9,
	0x51ed,
	0x6251,
	0x4ec6,
	0x6734,
	0x97c6,
	0x7c64,
	0x7e34,
	0x97a6,
	0x9eaf,
	0x786e,
	0x820d,
	0x672f,
	0x677e,
	0x56cc,
	0x53f0,
	0x98b1,
	0x6aaf,
	0x7f4e,
	0x6d82,
	0x7cf0,
	0x4e07,
	0x4fc2,
	0x7e6b,
	0x9e79,
	0x56ae,
	0x9b1a,
	0x846f,
	0x53f6,
	0x90c1,
	0x79a6,
	0x7c72,
	0x613f,
	0x4e91,
	0x9ad2
	};

LOCAL_D const TUint16 keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_76[]=
	{
	0x75c7,
	0x96bb,
	0x53ea,
	0x7dfb,
	0x88fd,
	0x79cd,
	0x7843,
	0x7b51,
	0x51c6
	};

LOCAL_D const SCnvConversionData::SOneDirectionData::SRange::UData::SKeyedTable16OfIndexedTables16::SKeyedEntry keyedTables16OfIndexedTables16_keyedEntries_foreignToUnicode_1[]=
	{
		{
		0xa1a1,
		0xa1fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_1
		},
		{
		0xa8a1,
		0xa8ba,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_2
		},
		{
		0xb0a1,
		0xb0fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_3
		},
		{
		0xb1a1,
		0xb1fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_4
		},
		{
		0xb2a1,
		0xb2fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_5
		},
		{
		0xb3a1,
		0xb3fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_6
		},
		{
		0xb4a1,
		0xb4fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_7
		},
		{
		0xb5a1,
		0xb5fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_8
		},
		{
		0xb6a1,
		0xb6fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_9
		},
		{
		0xb7a1,
		0xb7fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_10
		},
		{
		0xb8a1,
		0xb8fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_11
		},
		{
		0xb9a1,
		0xb9fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_12
		},
		{
		0xbaa1,
		0xbafe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_13
		},
		{
		0xbba1,
		0xbbfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_14
		},
		{
		0xbca1,
		0xbcfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_15
		},
		{
		0xbda1,
		0xbdfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_16
		},
		{
		0xbea1,
		0xbefe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_17
		},
		{
		0xbfa1,
		0xbffe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_18
		},
		{
		0xc0a1,
		0xc0fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_19
		},
		{
		0xc1a1,
		0xc1fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_20
		},
		{
		0xc2a1,
		0xc2fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_21
		},
		{
		0xc3a1,
		0xc3fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_22
		},
		{
		0xc4a1,
		0xc4fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_23
		},
		{
		0xc5a1,
		0xc5fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_24
		},
		{
		0xc6a1,
		0xc6fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_25
		},
		{
		0xc7a1,
		0xc7fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_26
		},
		{
		0xc8a1,
		0xc8fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_27
		},
		{
		0xc9a1,
		0xc9fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_28
		},
		{
		0xcaa1,
		0xcafe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_29
		},
		{
		0xcba1,
		0xcbfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_30
		},
		{
		0xcca1,
		0xccfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_31
		},
		{
		0xcda1,
		0xcdfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_32
		},
		{
		0xcea1,
		0xcefe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_33
		},
		{
		0xcfa1,
		0xcffe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_34
		},
		{
		0xd0a1,
		0xd0fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_35
		},
		{
		0xd1a1,
		0xd1fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_36
		},
		{
		0xd2a1,
		0xd2fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_37
		},
		{
		0xd3a1,
		0xd3fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_38
		},
		{
		0xd4a1,
		0xd4fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_39
		},
		{
		0xd5a1,
		0xd5fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_40
		},
		{
		0xd6a1,
		0xd6fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_41
		},
		{
		0xd7a1,
		0xd7f9,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_42
		},
		{
		0xd8a1,
		0xd8fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_43
		},
		{
		0xd9a1,
		0xd9fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_44
		},
		{
		0xdaa1,
		0xdafe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_45
		},
		{
		0xdba1,
		0xdbfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_46
		},
		{
		0xdca1,
		0xdcfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_47
		},
		{
		0xdda1,
		0xddfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_48
		},
		{
		0xdea1,
		0xdefe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_49
		},
		{
		0xdfa1,
		0xdffe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_50
		},
		{
		0xe0a1,
		0xe0fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_51
		},
		{
		0xe1a1,
		0xe1fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_52
		},
		{
		0xe2a1,
		0xe2fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_53
		},
		{
		0xe3a1,
		0xe3fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_54
		},
		{
		0xe4a1,
		0xe4fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_55
		},
		{
		0xe5a1,
		0xe5fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_56
		},
		{
		0xe6a1,
		0xe6fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_57
		},
		{
		0xe7a1,
		0xe7fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_58
		},
		{
		0xe8a1,
		0xe8fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_59
		},
		{
		0xe9a1,
		0xe9fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_60
		},
		{
		0xeaa1,
		0xeafe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_61
		},
		{
		0xeba1,
		0xebfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_62
		},
		{
		0xeca1,
		0xecfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_63
		},
		{
		0xeda1,
		0xedfe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_64
		},
		{
		0xeea1,
		0xeefe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_65
		},
		{
		0xefa1,
		0xeffe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_66
		},
		{
		0xf0a1,
		0xf0fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_67
		},
		{
		0xf1a1,
		0xf1fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_68
		},
		{
		0xf2a1,
		0xf2fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_69
		},
		{
		0xf3a1,
		0xf3fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_70
		},
		{
		0xf4a1,
		0xf4fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_71
		},
		{
		0xf5a1,
		0xf5fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_72
		},
		{
		0xf6a1,
		0xf6fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_73
		},
		{
		0xf7a1,
		0xf7fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_74
		},
		{
		0xf8a1,
		0xf8fe,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_75
		},
		{
		0xf9a1,
		0xf9a9,
		keyedTables16OfIndexedTables16_indexedEntries_foreignToUnicode_76
		}
	};

LOCAL_D const SCnvConversionData::SOneDirectionData::SRange::UData::SKeyedTable1616::SEntry keyedTable1616_unicodeToForeign_1[]=
	{
		{
		0x00a4,
		0xa1e8
		},
		{
		0x00a7,
		0xa1ec
		},
		{
		0x00a8,
		0xa1a7
		},
		{
		0x00b0,
		0xa1e3
		},
		{
		0x00b1,
		0xa1c0
		},
		{
		0x00b7,
		0xa1a4
		},
		{
		0x00d7,
		0xa1c1
		},
		{
		0x00e0,
		0xa8a4
		},
		{
		0x00e1,
		0xa8a2
		},
		{
		0x00e8,
		0xa8a8
		},
		{
		0x00e9,
		0xa8a6
		},
		{
		0x00ea,
		0xa8ba
		},
		{
		0x00ec,
		0xa8ac
		},
		{
		0x00ed,
		0xa8aa
		},
		{
		0x00f2,
		0xa8b0
		},
		{
		0x00f3,
		0xa8ae
		},
		{
		0x00f7,
		0xa1c2
		},
		{
		0x00f9,
		0xa8b4
		},
		{
		0x00fa,
		0xa8b2
		},
		{
		0x00fc,
		0xa8b9
		},
		{
		0x0101,
		0xa8a1
		},
		{
		0x0113,
		0xa8a5
		},
		{
		0x011b,
		0xa8a7
		},
		{
		0x012b,
		0xa8a9
		},
		{
		0x014d,
		0xa8ad
		},
		{
		0x016b,
		0xa8b1
		},
		{
		0x01ce,
		0xa8a3
		},
		{
		0x01d0,
		0xa8ab
		},
		{
		0x01d2,
		0xa8af
		},
		{
		0x01d4,
		0xa8b3
		},
		{
		0x01d6,
		0xa8b5
		},
		{
		0x01d8,
		0xa8b6
		},
		{
		0x01da,
		0xa8b7
		},
		{
		0x01dc,
		0xa8b8
		},
		{
		0x02c7,
		0xa1a6
		},
		{
		0x02c9,
		0xa1a5
		},
		{
		0x0401,
		0xa7a7
		},
		{
		0x0451,
		0xa7d7
		},
		{
		0x2014,
		0xa1aa
		},
		{
		0x2015,
		0xa1aa
		},
		{
		0x2016,
		0xa1ac
		},
		{
		0x2018,
		0xa1ae
		},
		{
		0x2019,
		0xa1af
		},
		{
		0x201c,
		0xa1b0
		},
		{
		0x201d,
		0xa1b1
		},
		{
		0x2026,
		0xa1ad
		},
		{
		0x2030,
		0xa1eb
		},
		{
		0x2032,
		0xa1e4
		},
		{
		0x2033,
		0xa1e5
		},
		{
		0x203b,
		0xa1f9
		},
		{
		0x2103,
		0xa1e6
		},
		{
		0x2116,
		0xa1ed
		},
		{
		0x2190,
		0xa1fb
		},
		{
		0x2191,
		0xa1fc
		},
		{
		0x2192,
		0xa1fa
		},
		{
		0x2193,
		0xa1fd
		},
		{
		0x2208,
		0xa1ca
		},
		{
		0x220f,
		0xa1c7
		},
		{
		0x2211,
		0xa1c6
		},
		{
		0x221a,
		0xa1cc
		},
		{
		0x221d,
		0xa1d8
		},
		{
		0x221e,
		0xa1de
		},
		{
		0x2220,
		0xa1cf
		},
		{
		0x2225,
		0xa1ce
		},
		{
		0x2227,
		0xa1c4
		},
		{
		0x2228,
		0xa1c5
		},
		{
		0x2229,
		0xa1c9
		},
		{
		0x222a,
		0xa1c8
		},
		{
		0x222b,
		0xa1d2
		},
		{
		0x222e,
		0xa1d3
		},
		{
		0x2234,
		0xa1e0
		},
		{
		0x2235,
		0xa1df
		},
		{
		0x2236,
		0xa1c3
		},
		{
		0x2237,
		0xa1cb
		},
		{
		0x223d,
		0xa1d7
		},
		{
		0x2248,
		0xa1d6
		},
		{
		0x224c,
		0xa1d5
		},
		{
		0x2260,
		0xa1d9
		},
		{
		0x2261,
		0xa1d4
		},
		{
		0x2264,
		0xa1dc
		},
		{
		0x2265,
		0xa1dd
		},
		{
		0x226e,
		0xa1da
		},
		{
		0x226f,
		0xa1db
		},
		{
		0x2299,
		0xa1d1
		},
		{
		0x22a5,
		0xa1cd
		},
		{
		0x2312,
		0xa1d0
		},
		{
		0x25a0,
		0xa1f6
		},
		{
		0x25a1,
		0xa1f5
		},
		{
		0x25b2,
		0xa1f8
		},
		{
		0x25b3,
		0xa1f7
		},
		{
		0x25c6,
		0xa1f4
		},
		{
		0x25c7,
		0xa1f3
		},
		{
		0x25cb,
		0xa1f0
		},
		{
		0x25ce,
		0xa1f2
		},
		{
		0x25cf,
		0xa1f1
		},
		{
		0x2605,
		0xa1ef
		},
		{
		0x2606,
		0xa1ee
		},
		{
		0x2640,
		0xa1e2
		},
		{
		0x2642,
		0xa1e1
		},
		{
		0x3000,
		0xa1a1
		},
		{
		0x3001,
		0xa1a2
		},
		{
		0x3002,
		0xa1a3
		},
		{
		0x3003,
		0xa1a8
		},
		{
		0x3005,
		0xa1a9
		},
		{
		0x3010,
		0xa1be
		},
		{
		0x3011,
		0xa1bf
		},
		{
		0x3013,
		0xa1fe
		},
		{
		0x3014,
		0xa1b2
		},
		{
		0x3015,
		0xa1b3
		},
		{
		0x3016,
		0xa1bc
		},
		{
		0x3017,
		0xa1bd
		},
		{
		0x30fb,
		0xa1a4
		},
		{
		0x4e00,
		0xd2bb
		},
		{
		0x4e01,
		0xb6a1
		},
		{
		0x4e03,
		0xc6df
		},
		{
		0x4e07,
		0xf8f1
		},
		{
		0x4e08,
		0xd5c9
		},
		{
		0x4e09,
		0xc8fd
		},
		{
		0x4e0a,
		0xc9cf
		},
		{
		0x4e0b,
		0xcfc2
		},
		{
		0x4e0c,
		0xd8a2
		},
		{
		0x4e0d,
		0xb2bb
		},
		{
		0x4e10,
		0xd8a4
		},
		{
		0x4e11,
		0xf8a9
		},
		{
		0x4e14,
		0xc7d2
		},
		{
		0x4e15,
		0xd8a7
		},
		{
		0x4e16,
		0xcac0
		},
		{
		0x4e18,
		0xc7f0
		},
		{
		0x4e19,
		0xb1fb
		},
		{
		0x4e1e,
		0xd8a9
		},
		{
		0x4e22,
		0xb6aa
		},
		{
		0x4e28,
		0xd8ad
		},
		{
		0x4e2b,
		0xd1be
		},
		{
		0x4e2c,
		0xe3dc
		},
		{
		0x4e2d,
		0xd6d0
		},
		{
		0x4e30,
		0xf8b3
		},
		{
		0x4e32,
		0xb4ae
		},
		{
		0x4e36,
		0xd8bc
		},
		{
		0x4e38,
		0xcde8
		},
		{
		0x4e39,
		0xb5a4
		},
		{
		0x4e3b,
		0xd6f7
		},
		{
		0x4e3f,
		0xd8af
		},
		{
		0x4e43,
		0xc4cb
		},
		{
		0x4e45,
		0xbec3
		},
		{
		0x4e47,
		0xd8b1
		},
		{
		0x4e48,
		0xf7e1
		},
		{
		0x4e4b,
		0xd6ae
		},
		{
		0x4e4d,
		0xd5a7
		},
		{
		0x4e4e,
		0xbaf5
		},
		{
		0x4e4f,
		0xb7a6
		},
		{
		0x4e52,
		0xc6b9
		},
		{
		0x4e53,
		0xc5d2
		},
		{
		0x4e56,
		0xb9d4
		},
		{
		0x4e58,
		0xb3cb
		},
		{
		0x4e59,
		0xd2d2
		},
		{
		0x4e5c,
		0xd8bf
		},
		{
		0x4e5d,
		0xbec5
		},
		{
		0x4e5e,
		0xc6f2
		},
		{
		0x4e5f,
		0xd2b2
		},
		{
		0x4e69,
		0xd8c0
		},
		{
		0x4e73,
		0xc8e9
		},
		{
		0x4e7e,
		0xc7ac
		},
		{
		0x4e82,
		0xc2d2
		},
		{
		0x4e86,
		0xc1cb
		},
		{
		0x4e88,
		0xd3e8
		},
		{
		0x4e8b,
		0xcac2
		},
		{
		0x4e8c,
		0xb6fe
		},
		{
		0x4e8d,
		0xd8a1
		},
		{
		0x4e8e,
		0xd3da
		},
		{
		0x4e91,
		0xf8fd
		},
		{
		0x4e92,
		0xbba5
		},
		{
		0x4e93,
		0xd8c1
		},
		{
		0x4e94,
		0xcee5
		},
		{
		0x4e95,
		0xbeae
		},
		{
		0x4e98,
		0xd8a8
		},
		{
		0x4e9b,
		0xd0a9
		},
		{
		0x4e9e,
		0xd1c7
		},
		{
		0x4e9f,
		0xd8bd
		},
		{
		0x4ea0,
		0xd9ef
		},
		{
		0x4ea1,
		0xcdf6
		},
		{
		0x4ea2,
		0xbfba
		},
		{
		0x4ea4,
		0xbdbb
		},
		{
		0x4ea5,
		0xbaa5
		},
		{
		0x4ea6,
		0xd2e0
		},
		{
		0x4ea8,
		0xbae0
		},
		{
		0x4eab,
		0xcfed
		},
		{
		0x4eac,
		0xbea9
		},
		{
		0x4ead,
		0xcda4
		},
		{
		0x4eae,
		0xc1c1
		},
		{
		0x4eb3,
		0xd9f1
		},
		{
		0x4eba,
		0xc8cb
		},
		{
		0x4ebb,
		0xd8e9
		},
		{
		0x4ec0,
		0xcab2
		},
		{
		0x4ec1,
		0xc8ca
		},
		{
		0x4ec2,
		0xd8ec
		},
		{
		0x4ec3,
		0xd8ea
		},
		{
		0x4ec4,
		0xd8c6
		},
		{
		0x4ec6,
		0xf8df
		},
		{
		0x4ec7,
		0xb3f0
		},
		{
		0x4ec9,
		0xd8eb
		},
		{
		0x4eca,
		0xbdf1
		},
		{
		0x4ecb,
		0xbde9
		},
		{
		0x4ecd,
		0xc8d4
		},
		{
		0x4ed4,
		0xd7d0
		},
		{
		0x4ed5,
		0xcacb
		},
		{
		0x4ed6,
		0xcbfb
		},
		{
		0x4ed7,
		0xd5cc
		},
		{
		0x4ed8,
		0xb8b6
		},
		{
		0x4ed9,
		0xcfc9
		},
		{
		0x4edd,
		0xd9da
		},
		{
		0x4ede,
		0xd8f0
		},
		{
		0x4edf,
		0xc7aa
		},
		{
		0x4ee1,
		0xd8ee
		},
		{
		0x4ee3,
		0xb4fa
		},
		{
		0x4ee4,
		0xc1ee
		},
		{
		0x4ee5,
		0xd2d4
		},
		{
		0x4ee8,
		0xd8ed
		},
		{
		0x4eeb,
		0xd8ef
		},
		{
		0x4ef0,
		0xd1f6
		},
		{
		0x4ef2,
		0xd6d9
		},
		{
		0x4ef3,
		0xd8f2
		},
		{
		0x4ef5,
		0xd8f5
		},
		{
		0x4ef6,
		0xbcfe
		},
		{
		0x4ef7,
		0xf8c2
		},
		{
		0x4efb,
		0xc8ce
		},
		{
		0x4efd,
		0xb7dd
		},
		{
		0x4eff,
		0xb7c2
		},
		{
		0x4f01,
		0xc6f3
		},
		{
		0x4f09,
		0xd8f8
		},
		{
		0x4f0a,
		0xd2c1
		},
		{
		0x4f0d,
		0xcee9
		},
		{
		0x4f0e,
		0xbcbf
		},
		{
		0x4f0f,
		0xb7fc
		},
		{
		0x4f10,
		0xb7a5
		},
		{
		0x4f11,
		0xd0dd
		},
		{
		0x4f19,
		0xbbef
		},
		{
		0x4f22,
		0xd8f3
		},
		{
		0x4f2f,
		0xb2ae
		},
		{
		0x4f30,
		0xb9c0
		},
		{
		0x4f32,
		0xd9a3
		},
		{
		0x4f34,
		0xb0e9
		},
		{
		0x4f36,
		0xc1e6
		},
		{
		0x4f38,
		0xc9ec
		},
		{
		0x4f3a,
		0xcbc5
		},
		{
		0x4f3c,
		0xcbc6
		},
		{
		0x4f3d,
		0xd9a4
		},
		{
		0x4f43,
		0xb5e8
		},
		{
		0x4f46,
		0xb5ab
		},
		{
		0x4f47,
		0xd8f9
		},
		{
		0x4f4d,
		0xcebb
		},
		{
		0x4f4e,
		0xb5cd
		},
		{
		0x4f4f,
		0xd7a1
		},
		{
		0x4f50,
		0xd7f4
		},
		{
		0x4f51,
		0xd3d3
		},
		{
		0x4f55,
		0xbace
		},
		{
		0x4f57,
		0xd9a2
		},
		{
		0x4f58,
		0xd9dc
		},
		{
		0x4f59,
		0xe2c5
		},
		{
		0x4f5a,
		0xd8fd
		},
		{
		0x4f5b,
		0xb7f0
		},
		{
		0x4f5c,
		0xd7f7
		},
		{
		0x4f5d,
		0xd8fe
		},
		{
		0x4f5e,
		0xd8fa
		},
		{
		0x4f5f,
		0xd9a1
		},
		{
		0x4f60,
		0xc4e3
		},
		{
		0x4f64,
		0xd8f4
		},
		{
		0x4f67,
		0xd8fb
		},
		{
		0x4f69,
		0xc5e5
		},
		{
		0x4f6c,
		0xc0d0
		},
		{
		0x4f6f,
		0xd1f0
		},
		{
		0x4f70,
		0xb0db
		},
		{
		0x4f73,
		0xbcd1
		},
		{
		0x4f74,
		0xd9a6
		},
		{
		0x4f76,
		0xd9a5
		},
		{
		0x4f7b,
		0xd9ac
		},
		{
		0x4f7c,
		0xd9ae
		},
		{
		0x4f7e,
		0xd9ab
		},
		{
		0x4f7f,
		0xcab9
		},
		{
		0x4f83,
		0xd9a9
		},
		{
		0x4f84,
		0xd6b6
		},
		{
		0x4f86,
		0xc0b4
		},
		{
		0x4f88,
		0xb3de
		},
		{
		0x4f89,
		0xd9a8
		},
		{
		0x4f8b,
		0xc0fd
		},
		{
		0x4f8d,
		0xcacc
		},
		{
		0x4f8f,
		0xd9aa
		},
		{
		0x4f91,
		0xd9a7
		},
		{
		0x4f94,
		0xd9b0
		},
		{
		0x4f96,
		0xc2d8
		},
		{
		0x4f97,
		0xb6b1
		},
		{
		0x4f9b,
		0xb9a9
		},
		{
		0x4f9d,
		0xd2c0
		},
		{
		0x4fa3,
		0xc2c2
		},
		{
		0x4fae,
		0xceea
		},
		{
		0x4faf,
		0xbaee
		},
		{
		0x4fb5,
		0xc7d6
		},
		{
		0x4fbf,
		0xb1e3
		},
		{
		0x4fc2,
		0xf8f2
		},
		{
		0x4fc3,
		0xb4d9
		},
		{
		0x4fc4,
		0xb6ed
		},
		{
		0x4fc5,
		0xd9b4
		},
		{
		0x4fca,
		0xbfa1
		},
		{
		0x4fce,
		0xd9de
		},
		{
		0x4fcf,
		0xc7ce
		},
		{
		0x4fd0,
		0xc0fe
		},
		{
		0x4fd1,
		0xd9b8
		},
		{
		0x4fd7,
		0xcbd7
		},
		{
		0x4fd8,
		0xb7fd
		},
		{
		0x4fda,
		0xd9b5
		},
		{
		0x4fdc,
		0xd9b7
		},
		{
		0x4fdd,
		0xb1a3
		},
		{
		0x4fde,
		0xd3e1
		},
		{
		0x4fdf,
		0xd9b9
		},
		{
		0x4fe0,
		0xcfc0
		},
		{
		0x4fe1,
		0xd0c5
		},
		{
		0x4fe3,
		0xd9b6
		},
		{
		0x4fee,
		0xd0de
		},
		{
		0x4fef,
		0xb8a9
		},
		{
		0x4ff1,
		0xbee3
		},
		{
		0x4ff3,
		0xd9bd
		},
		{
		0x4ff8,
		0xd9ba
		},
		{
		0x4ffa,
		0xb0b3
		},
		{
		0x4ffe,
		0xd9c2
		},
		{
		0x5000,
		0xd8f6
		},
		{
		0x5006,
		0xc1a9
		},
		{
		0x5009,
		0xb2d6
		},
		{
		0x500b,
		0xb8f6
		},
		{
		0x500c,
		0xd9c4
		},
		{
		0x500d,
		0xb1b6
		},
		{
		0x500f,
		0xd9bf
		},
		{
		0x5011,
		0xc3c7
		},
		{
		0x5012,
		0xb5b9
		},
		{
		0x5014,
		0xbef3
		},
		{
		0x5018,
		0xccc8
		},
		{
		0x5019,
		0xbaf2
		},
		{
		0x501a,
		0xd2d0
		},
		{
		0x501c,
		0xd9c3
		},
		{
		0x501f,
		0xbde8
		},
		{
		0x5021,
		0xb3ab
		},
		{
		0x5025,
		0xd9c5
		},
		{
		0x5026,
		0xbeeb
		},
		{
		0x5028,
		0xd9c6
		},
		{
		0x5029,
		0xd9bb
		},
		{
		0x502a,
		0xc4df
		},
		{
		0x502b,
		0xc2d7
		},
		{
		0x502c,
		0xd9be
		},
		{
		0x502d,
		0xd9c1
		},
		{
		0x502e,
		0xd9c0
		},
		{
		0x503c,
		0xd6b5
		},
		{
		0x5043,
		0xd9c8
		},
		{
		0x5047,
		0xbcd9
		},
		{
		0x5048,
		0xd9ca
		},
		{
		0x5049,
		0xceb0
		},
		{
		0x504c,
		0xd9bc
		},
		{
		0x504e,
		0xd9cb
		},
		{
		0x504f,
		0xc6ab
		},
		{
		0x5055,
		0xd9c9
		},
		{
		0x505a,
		0xd7f6
		},
		{
		0x505c,
		0xcda3
		},
		{
		0x5065,
		0xbda1
		},
		{
		0x506c,
		0xd9cc
		},
		{
		0x5074,
		0xb2e0
		},
		{
		0x5075,
		0xd5ec
		},
		{
		0x5076,
		0xc5bc
		},
		{
		0x5077,
		0xcdb5
		},
		{
		0x5080,
		0xbffe
		},
		{
		0x5085,
		0xb8b5
		},
		{
		0x5088,
		0xc0fc
		},
		{
		0x508d,
		0xb0f8
		},
		{
		0x5096,
		0xd8f7
		},
		{
		0x5098,
		0xc9a1
		},
		{
		0x5099,
		0xb1b8
		},
		{
		0x50a2,
		0xf8c1
		},
		{
		0x50a3,
		0xb4f6
		},
		{
		0x50ac,
		0xb4df
		},
		{
		0x50ad,
		0xd3b6
		},
		{
		0x50b2,
		0xb0c1
		},
		{
		0x50b3,
		0xb4ab
		},
		{
		0x50b4,
		0xd8f1
		},
		{
		0x50b5,
		0xd5ae
		},
		{
		0x50b7,
		0xc9cb
		},
		{
		0x50ba,
		0xd9d1
		},
		{
		0x50bb,
		0xc9b5
		},
		{
		0x50be,
		0xc7e3
		},
		{
		0x50c2,
		0xd9cd
		},
		{
		0x50c5,
		0xbdf6
		},
		{
		0x50c9,
		0xd9dd
		},
		{
		0x50cf,
		0xcff1
		},
		{
		0x50d1,
		0xc7c8
		},
		{
		0x50d5,
		0xc6cd
		},
		{
		0x50d6,
		0xd9d2
		},
		{
		0x50da,
		0xc1c5
		},
		{
		0x50de,
		0xceb1
		},
		{
		0x50e5,
		0xbdc4
		},
		{
		0x50e6,
		0xd9d6
		},
		{
		0x50e7,
		0xc9ae
		},
		{
		0x50e8,
		0xd9c7
		},
		{
		0x50ec,
		0xd9d5
		},
		{
		0x50ed,
		0xd9d4
		},
		{
		0x50ee,
		0xd9d7
		},
		{
		0x50f3,
		0xcbdb
		},
		{
		0x50f5,
		0xbda9
		},
		{
		0x50f9,
		0xbcdb
		},
		{
		0x50fb,
		0xc6a7
		},
		{
		0x5100,
		0xd2c7
		},
		{
		0x5102,
		0xd9af
		},
		{
		0x5104,
		0xd2da
		},
		{
		0x5106,
		0xd9d3
		},
		{
		0x5107,
		0xd9d8
		},
		{
		0x5108,
		0xbfeb
		},
		{
		0x5109,
		0xbcf3
		},
		{
		0x510b,
		0xd9d9
		},
		{
		0x5110,
		0xd9cf
		},
		{
		0x5112,
		0xc8e5
		},
		{
		0x5114,
		0xd9b1
		},
		{
		0x5115,
		0xd9ad
		},
		{
		0x5118,
		0xf8c5
		},
		{
		0x511f,
		0xb3a5
		},
		{
		0x5121,
		0xc0dc
		},
		{
		0x512a,
		0xd3c5
		},
		{
		0x5132,
		0xb4a2
		},
		{
		0x5137,
		0xd9b3
		},
		{
		0x513a,
		0xd9d0
		},
		{
		0x513b,
		0xd9ce
		},
		{
		0x513c,
		0xd9b2
		},
		{
		0x5140,
		0xd8a3
		},
		{
		0x5141,
		0xd4ca
		},
		{
		0x5143,
		0xd4aa
		},
		{
		0x5144,
		0xd0d6
		},
		{
		0x5145,
		0xb3e4
		},
		{
		0x5146,
		0xd5d7
		},
		{
		0x5148,
		0xcfc8
		},
		{
		0x5149,
		0xb9e2
		},
		{
		0x514b,
		0xbfcb
		},
		{
		0x514d,
		0xc3e2
		},
		{
		0x5151,
		0xb6d2
		},
		{
		0x5152,
		0xb6f9
		},
		{
		0x5154,
		0xcdc3
		},
		{
		0x5155,
		0xd9ee
		},
		{
		0x5156,
		0xd9f0
		},
		{
		0x515a,
		0xf8ac
		},
		{
		0x515c,
		0xb6b5
		},
		{
		0x5162,
		0xbea4
		},
		{
		0x5165,
		0xc8eb
		},
		{
		0x5168,
		0xc8ab
		},
		{
		0x5169,
		0xc1bd
		},
		{
		0x516b,
		0xb0cb
		},
		{
		0x516c,
		0xb9ab
		},
		{
		0x516d,
		0xc1f9
		},
		{
		0x516e,
		0xd9e2
		},
		{
		0x5171,
		0xb9b2
		},
		{
		0x5175,
		0xb1f8
		},
		{
		0x5176,
		0xc6e4
		},
		{
		0x5177,
		0xbedf
		},
		{
		0x5178,
		0xb5e4
		},
		{
		0x5179,
		0xd7c8
		},
		{
		0x517c,
		0xbce6
		},
		{
		0x5180,
		0xbcbd
		},
		{
		0x5182,
		0xd8e7
		},
		{
		0x5185,
		0xc4da
		},
		{
		0x5189,
		0xc8bd
		},
		{
		0x518c,
		0xb2e1
		},
		{
		0x518d,
		0xd4d9
		},
		{
		0x5192,
		0xc3b0
		},
		{
		0x5195,
		0xc3e1
		},
		{
		0x5196,
		0xdaa2
		},
		{
		0x5197,
		0xc8df
		},
		{
		0x51a0,
		0xb9da
		},
		{
		0x51a2,
		0xdaa3
		},
		{
		0x51a4,
		0xd4a9
		},
		{
		0x51a5,
		0xdaa4
		},
		{
		0x51ab,
		0xd9fb
		},
		{
		0x51ac,
		0xb6ac
		},
		{
		0x51b0,
		0xb1f9
		},
		{
		0x51b1,
		0xd9fc
		},
		{
		0x51b2,
		0xf8a8
		},
		{
		0x51b3,
		0xbef6
		},
		{
		0x51b5,
		0xbff6
		},
		{
		0x51b6,
		0xd2b1
		},
		{
		0x51b7,
		0xc0e4
		},
		{
		0x51bc,
		0xd9fe
		},
		{
		0x51bd,
		0xd9fd
		},
		{
		0x51c4,
		0xc6e0
		},
		{
		0x51c6,
		0xf9a9
		},
		{
		0x51c7,
		0xdaa1
		},
		{
		0x51c8,
		0xbebb
		},
		{
		0x51c9,
		0xc1b9
		},
		{
		0x51cb,
		0xb5f2
		},
		{
		0x51cc,
		0xc1e8
		},
		{
		0x51cd,
		0xb6b3
		},
		{
		0x51cf,
		0xbcf5
		},
		{
		0x51d1,
		0xb4d5
		},
		{
		0x51db,
		0xc1dd
		},
		{
		0x51dd,
		0xc4fd
		},
		{
		0x51e0,
		0xf8c0
		},
		{
		0x51e1,
		0xb7b2
		},
		{
		0x51ed,
		0xf8dd
		},
		{
		0x51f0,
		0xbbcb
		},
		{
		0x51f1,
		0xbfad
		},
		{
		0x51f3,
		0xb5ca
		},
		{
		0x51f5,
		0xdbc9
		},
		{
		0x51f6,
		0xd0d7
		},
		{
		0x51f8,
		0xcdb9
		},
		{
		0x51f9,
		0xb0bc
		},
		{
		0x51fa,
		0xb3f6
		},
		{
		0x51fc,
		0xdbca
		},
		{
		0x51fd,
		0xbaaf
		},
		{
		0x5200,
		0xb5b6
		},
		{
		0x5201,
		0xb5f3
		},
		{
		0x5202,
		0xd8d6
		},
		{
		0x5203,
		0xc8d0
		},
		{
		0x5206,
		0xb7d6
		},
		{
		0x5207,
		0xc7d0
		},
		{
		0x5208,
		0xd8d7
		},
		{
		0x520a,
		0xbfaf
		},
		{
		0x520e,
		0xd8d8
		},
		{
		0x5211,
		0xd0cc
		},
		{
		0x5212,
		0xf8bb
		},
		{
		0x5216,
		0xebbe
		},
		{
		0x5217,
		0xc1d0
		},
		{
		0x521d,
		0xb3f5
		},
		{
		0x5220,
		0xc9be
		},
		{
		0x5224,
		0xc5d0
		},
		{
		0x5228,
		0xc5d9
		},
		{
		0x5229,
		0xc0fb
		},
		{
		0x522b,
		0xb1f0
		},
		{
		0x522e,
		0xb9ce
		},
		{
		0x5230,
		0xb5bd
		},
		{
		0x5233,
		0xd8da
		},
		{
		0x5236,
		0xd6c6
		},
		{
		0x5237,
		0xcba2
		},
		{
		0x5238,
		0xc8af
		},
		{
		0x5239,
		0xc9b2
		},
		{
		0x523a,
		0xb4cc
		},
		{
		0x523b,
		0xbfcc
		},
		{
		0x5241,
		0xb6e7
		},
		{
		0x5243,
		0xccea
		},
		{
		0x5244,
		0xd8d9
		},
		{
		0x5247,
		0xd4f2
		},
		{
		0x524a,
		0xcff7
		},
		{
		0x524b,
		0xf8c8
		},
		{
		0x524c,
		0xd8dd
		},
		{
		0x524d,
		0xc7b0
		},
		{
		0x5254,
		0xccde
		},
		{
		0x5256,
		0xc6ca
		},
		{
		0x525b,
		0xb8d5
		},
		{
		0x525c,
		0xd8e0
		},
		{
		0x525e,
		0xd8de
		},
		{
		0x5261,
		0xd8df
		},
		{
		0x5265,
		0xb0fe
		},
		{
		0x5269,
		0xcaa3
		},
		{
		0x526a,
		0xbcf4
		},
		{
		0x526e,
		0xb9d0
		},
		{
		0x526f,
		0xb8b1
		},
		{
		0x5272,
		0xb8ee
		},
		{
		0x5274,
		0xd8dc
		},
		{
		0x5275,
		0xb4b4
		},
		{
		0x527d,
		0xd8e2
		},
		{
		0x527f,
		0xbdcb
		},
		{
		0x5281,
		0xd8e4
		},
		{
		0x5282,
		0xd8e3
		},
		{
		0x5283,
		0xbbae
		},
		{
		0x5287,
		0xbee7
		},
		{
		0x5288,
		0xc5fc
		},
		{
		0x5289,
		0xc1f5
		},
		{
		0x528a,
		0xb9f4
		},
		{
		0x528c,
		0xd8db
		},
		{
		0x528d,
		0xbda3
		},
		{
		0x5290,
		0xd8e5
		},
		{
		0x5291,
		0xbcc1
		},
		{
		0x5293,
		0xd8e6
		},
		{
		0x529b,
		0xc1a6
		},
		{
		0x529f,
		0xb9a6
		},
		{
		0x52a0,
		0xbcd3
		},
		{
		0x52a3,
		0xc1d3
		},
		{
		0x52a9,
		0xd6fa
		},
		{
		0x52aa,
		0xc5ac
		},
		{
		0x52ab,
		0xbdd9
		},
		{
		0x52ac,
		0xdbbe
		},
		{
		0x52ad,
		0xdbbf
		},
		{
		0x52be,
		0xdbc0
		},
		{
		0x52c1,
		0xbea2
		},
		{
		0x52c3,
		0xb2aa
		},
		{
		0x52c7,
		0xd3c2
		},
		{
		0x52c9,
		0xc3e3
		},
		{
		0x52d0,
		0xdbc2
		},
		{
		0x52d2,
		0xc0d5
		},
		{
		0x52d5,
		0xb6af
		},
		{
		0x52d6,
		0xdbc3
		},
		{
		0x52d8,
		0xbfb1
		},
		{
		0x52d9,
		0xcef1
		},
		{
		0x52db,
		0xd1ab
		},
		{
		0x52dd,
		0xcaa4
		},
		{
		0x52de,
		0xc0cd
		},
		{
		0x52df,
		0xc4bc
		},
		{
		0x52e2,
		0xcac6
		},
		{
		0x52e4,
		0xc7da
		},
		{
		0x52f0,
		0xdbc4
		},
		{
		0x52f1,
		0xdbbd
		},
		{
		0x52f5,
		0xc0f8
		},
		{
		0x52f8,
		0xc8b0
		},
		{
		0x52f9,
		0xd9e8
		},
		{
		0x52fa,
		0xc9d7
		},
		{
		0x52fe,
		0xb9b4
		},
		{
		0x52ff,
		0xcef0
		},
		{
		0x5300,
		0xd4c8
		},
		{
		0x5305,
		0xb0fc
		},
		{
		0x5306,
		0xb4d2
		},
		{
		0x5308,
		0xd0d9
		},
		{
		0x530d,
		0xd9e9
		},
		{
		0x530f,
		0xdecb
		},
		{
		0x5310,
		0xd9eb
		},
		{
		0x5315,
		0xd8b0
		},
		{
		0x5316,
		0xbbaf
		},
		{
		0x5317,
		0xb1b1
		},
		{
		0x5319,
		0xb3d7
		},
		{
		0x531a,
		0xd8ce
		},
		{
		0x531d,
		0xd4d1
		},
		{
		0x5320,
		0xbdb3
		},
		{
		0x5321,
		0xbfef
		},
		{
		0x5323,
		0xcfbb
		},
		{
		0x532a,
		0xb7cb
		},
		{
		0x532d,
		0xd8d0
		},
		{
		0x532f,
		0xbbe3
		},
		{
		0x5331,
		0xd8d1
		},
		{
		0x5339,
		0xc6a5
		},
		{
		0x533e,
		0xd8d2
		},
		{
		0x533f,
		0xc4e4
		},
		{
		0x5340,
		0xc7f8
		},
		{
		0x5341,
		0xcaae
		},
		{
		0x5343,
		0xc7a7
		},
		{
		0x5345,
		0xd8a6
		},
		{
		0x5347,
		0xc9fd
		},
		{
		0x5348,
		0xcee7
		},
		{
		0x5349,
		0xbbdc
		},
		{
		0x534a,
		0xb0eb
		},
		{
		0x5351,
		0xb1b0
		},
		{
		0x5352,
		0xd7e4
		},
		{
		0x5353,
		0xd7bf
		},
		{
		0x5354,
		0xd0ad
		},
		{
		0x5357,
		0xc4cf
		},
		{
		0x535a,
		0xb2a9
		},
		{
		0x535c,
		0xb2b7
		},
		{
		0x535e,
		0xb1e5
		},
		{
		0x535f,
		0xdfb2
		},
		{
		0x5360,
		0xd5bc
		},
		{
		0x5361,
		0xbfa8
		},
		{
		0x5363,
		0xd8d5
		},
		{
		0x5366,
		0xd8d4
		},
		{
		0x5367,
		0xced4
		},
		{
		0x5369,
		0xdae0
		},
		{
		0x536e,
		0xd8b4
		},
		{
		0x536f,
		0xc3ae
		},
		{
		0x5370,
		0xd3a1
		},
		{
		0x5371,
		0xcea3
		},
		{
		0x5373,
		0xbcb4
		},
		{
		0x5374,
		0xc8b4
		},
		{
		0x5375,
		0xc2d1
		},
		{
		0x5377,
		0xbeed
		},
		{
		0x5378,
		0xd0b6
		},
		{
		0x537a,
		0xdae1
		},
		{
		0x537f,
		0xc7e4
		},
		{
		0x5382,
		0xf8a7
		},
		{
		0x5384,
		0xb6f2
		},
		{
		0x5398,
		0xc0e5
		},
		{
		0x5399,
		0xd8c7
		},
		{
		0x539a,
		0xbaf1
		},
		{
		0x539d,
		0xd8c8
		},
		{
		0x539f,
		0xd4ad
		},
		{
		0x53a0,
		0xb2de
		},
		{
		0x53a2,
		0xcfe1
		},
		{
		0x53a5,
		0xd8ca
		},
		{
		0x53a6,
		0xcfc3
		},
		{
		0x53a8,
		0xb3f8
		},
		{
		0x53a9,
		0xbec7
		},
		{
		0x53ad,
		0xd1e1
		},
		{
		0x53ae,
		0xd8cb
		},
		{
		0x53b2,
		0xc0f7
		},
		{
		0x53b4,
		0xd8c9
		},
		{
		0x53b6,
		0xdbcc
		},
		{
		0x53bb,
		0xc8a5
		},
		{
		0x53c1,
		0xc8fe
		},
		{
		0x53c3,
		0xb2ce
		},
		{
		0x53c8,
		0xd3d6
		},
		{
		0x53c9,
		0xb2e6
		},
		{
		0x53ca,
		0xbcb0
		},
		{
		0x53cb,
		0xd3d1
		},
		{
		0x53cd,
		0xb7b4
		},
		{
		0x53d4,
		0xcae5
		},
		{
		0x53d6,
		0xc8a1
		},
		{
		0x53d7,
		0xcadc
		},
		{
		0x53d9,
		0xd0f0
		},
		{
		0x53db,
		0xc5d1
		},
		{
		0x53df,
		0xdbc5
		},
		{
		0x53e2,
		0xb4d4
		},
		{
		0x53e3,
		0xbfda
		},
		{
		0x53e4,
		0xb9c5
		},
		{
		0x53e5,
		0xbee4
		},
		{
		0x53e6,
		0xc1ed
		},
		{
		0x53e8,
		0xdfb6
		},
		{
		0x53e9,
		0xdfb5
		},
		{
		0x53ea,
		0xf9a3
		},
		{
		0x53eb,
		0xbdd0
		},
		{
		0x53ec,
		0xd5d9
		},
		{
		0x53ed,
		0xb0c8
		},
		{
		0x53ee,
		0xb6a3
		},
		{
		0x53ef,
		0xbfc9
		},
		{
		0x53f0,
		0xf8eb
		},
		{
		0x53f1,
		0xdfb3
		},
		{
		0x53f2,
		0xcab7
		},
		{
		0x53f3,
		0xd3d2
		},
		{
		0x53f5,
		0xd8cf
		},
		{
		0x53f6,
		0xf8f8
		},
		{
		0x53f8,
		0xcbbe
		},
		{
		0x53fb,
		0xdfb7
		},
		{
		0x53fc,
		0xb5f0
		},
		{
		0x5401,
		0xd3f5
		},
		{
		0x5403,
		0xb3d4
		},
		{
		0x5404,
		0xb8f7
		},
		{
		0x5406,
		0xdfba
		},
		{
		0x5408,
		0xbacf
		},
		{
		0x5409,
		0xbcaa
		},
		{
		0x540a,
		0xb5f5
		},
		{
		0x540c,
		0xcdac
		},
		{
		0x540d,
		0xc3fb
		},
		{
		0x540e,
		0xe1e1
		},
		{
		0x540f,
		0xc0f4
		},
		{
		0x5410,
		0xcdc2
		},
		{
		0x5411,
		0xcff2
		},
		{
		0x5412,
		0xdfb8
		},
		{
		0x5415,
		0xc2c0
		},
		{
		0x5416,
		0xdfb9
		},
		{
		0x541b,
		0xbefd
		},
		{
		0x541d,
		0xc1df
		},
		{
		0x541e,
		0xcdcc
		},
		{
		0x541f,
		0xd2f7
		},
		{
		0x5420,
		0xb7cd
		},
		{
		0x5421,
		0xdfc1
		},
		{
		0x5423,
		0xdfc4
		},
		{
		0x5426,
		0xb7f1
		},
		{
		0x5427,
		0xb0c9
		},
		{
		0x5429,
		0xb7d4
		},
		{
		0x542b,
		0xbaac
		},
		{
		0x542d,
		0xbfd4
		},
		{
		0x542e,
		0xcbb1
		},
		{
		0x5431,
		0xd6a8
		},
		{
		0x5432,
		0xdfc5
		},
		{
		0x5434,
		0xcee2
		},
		{
		0x5435,
		0xb3b3
		},
		{
		0x5438,
		0xcefc
		},
		{
		0x5439,
		0xb4b5
		},
		{
		0x543b,
		0xcec7
		},
		{
		0x543c,
		0xbaf0
		},
		{
		0x543e,
		0xcee1
		},
		{
		0x5440,
		0xd1bd
		},
		{
		0x5443,
		0xdfc0
		},
		{
		0x5446,
		0xb4f4
		},
		{
		0x5448,
		0xb3ca
		},
		{
		0x544a,
		0xb8e6
		},
		{
		0x544b,
		0xdfbb
		},
		{
		0x5450,
		0xc4c5
		},
		{
		0x5454,
		0xdfbe
		},
		{
		0x5462,
		0xc4d8
		},
		{
		0x5464,
		0xdfca
		},
		{
		0x5466,
		0xdfcf
		},
		{
		0x5468,
		0xd6dc
		},
		{
		0x5471,
		0xdfc9
		},
		{
		0x5472,
		0xdfda
		},
		{
		0x5473,
		0xceb6
		},
		{
		0x5475,
		0xbac7
		},
		{
		0x5476,
		0xdfce
		},
		{
		0x5477,
		0xdfc8
		},
		{
		0x5478,
		0xc5de
		},
		{
		0x547b,
		0xc9eb
		},
		{
		0x547c,
		0xbaf4
		},
		{
		0x547d,
		0xc3fc
		},
		{
		0x5480,
		0xbed7
		},
		{
		0x5482,
		0xdfc6
		},
		{
		0x5484,
		0xdfcd
		},
		{
		0x5486,
		0xc5d8
		},
		{
		0x548b,
		0xd5a6
		},
		{
		0x548c,
		0xbacd
		},
		{
		0x548e,
		0xbecc
		},
		{
		0x548f,
		0xd3bd
		},
		{
		0x5490,
		0xb8c0
		},
		{
		0x5492,
		0xd6e4
		},
		{
		0x5494,
		0xdfc7
		},
		{
		0x5495,
		0xb9be
		},
		{
		0x5496,
		0xbfa7
		},
		{
		0x549a,
		0xdfcb
		},
		{
		0x54a3,
		0xdfdb
		},
		{
		0x54a4,
		0xdfe5
		},
		{
		0x54a6,
		0xdfd7
		},
		{
		0x54a7,
		0xdfd6
		},
		{
		0x54a8,
		0xd7c9
		},
		{
		0x54a9,
		0xdfe3
		},
		{
		0x54aa,
		0xdfe4
		},
		{
		0x54ab,
		0xe5eb
		},
		{
		0x54ac,
		0xd2a7
		},
		{
		0x54ad,
		0xdfd2
		},
		{
		0x54af,
		0xbfa9
		},
		{
		0x54b1,
		0xd4db
		},
		{
		0x54b3,
		0xbfc8
		},
		{
		0x54b4,
		0xdfd4
		},
		{
		0x54b8,
		0xcfcc
		},
		{
		0x54bb,
		0xdfdd
		},
		{
		0x54bc,
		0xdfc3
		},
		{
		0x54bd,
		0xd1ca
		},
		{
		0x54bf,
		0xdfde
		},
		{
		0x54c0,
		0xb0a7
		},
		{
		0x54c1,
		0xc6b7
		},
		{
		0x54c2,
		0xdfd3
		},
		{
		0x54c4,
		0xbae5
		},
		{
		0x54c6,
		0xb6df
		},
		{
		0x54c7,
		0xcddb
		},
		{
		0x54c8,
		0xb9fe
		},
		{
		0x54c9,
		0xd4d5
		},
		{
		0x54cc,
		0xdfdf
		},
		{
		0x54ce,
		0xb0a5
		},
		{
		0x54cf,
		0xdfe7
		},
		{
		0x54d0,
		0xdfd1
		},
		{
		0x54da,
		0xdfe1
		},
		{
		0x54de,
		0xdfe8
		},
		{
		0x54e1,
		0xd4b1
		},
		{
		0x54e5,
		0xb8e7
		},
		{
		0x54e6,
		0xc5b6
		},
		{
		0x54e7,
		0xdfea
		},
		{
		0x54e8,
		0xc9da
		},
		{
		0x54e9,
		0xc1a8
		},
		{
		0x54ea,
		0xc4c4
		},
		{
		0x54ed,
		0xbfde
		},
		{
		0x54ee,
		0xcff8
		},
		{
		0x54f2,
		0xd5dc
		},
		{
		0x54f3,
		0xdfee
		},
		{
		0x54fa,
		0xb2b8
		},
		{
		0x54fc,
		0xbadf
		},
		{
		0x54fd,
		0xdfec
		},
		{
		0x54ff,
		0xdbc1
		},
		{
		0x5501,
		0xd1e4
		},
		{
		0x5504,
		0xdfc2
		},
		{
		0x5506,
		0xcbf4
		},
		{
		0x5507,
		0xb4bd
		},
		{
		0x5509,
		0xb0a6
		},
		{
		0x550f,
		0xdff1
		},
		{
		0x5510,
		0xccc6
		},
		{
		0x5511,
		0xdff2
		},
		{
		0x5514,
		0xdfed
		},
		{
		0x5523,
		0xdff0
		},
		{
		0x5527,
		0xdff3
		},
		{
		0x552a,
		0xdff4
		},
		{
		0x552c,
		0xbba3
		},
		{
		0x552e,
		0xcadb
		},
		{
		0x552f,
		0xcea8
		},
		{
		0x5530,
		0xe0a7
		},
		{
		0x5531,
		0xb3aa
		},
		{
		0x5533,
		0xe0a6
		},
		{
		0x5537,
		0xe0a1
		},
		{
		0x553c,
		0xdffe
		},
		{
		0x553e,
		0xcdd9
		},
		{
		0x553f,
		0xdffc
		},
		{
		0x5541,
		0xdffa
		},
		{
		0x5543,
		0xbfd0
		},
		{
		0x5544,
		0xd7c4
		},
		{
		0x5546,
		0xc9cc
		},
		{
		0x5549,
		0xdff8
		},
		{
		0x554a,
		0xb0a1
		},
		{
		0x554f,
		0xceca
		},
		{
		0x5550,
		0xdffd
		},
		{
		0x5553,
		0xc6f4
		},
		{
		0x5555,
		0xdffb
		},
		{
		0x5556,
		0xe0a2
		},
		{
		0x555c,
		0xe0a8
		},
		{
		0x555e,
		0xd1c6
		},
		{
		0x5561,
		0xb7c8
		},
		{
		0x5564,
		0xc6a1
		},
		{
		0x5565,
		0xc9b6
		},
		{
		0x5566,
		0xc0b2
		},
		{
		0x556a,
		0xc5be
		},
		{
		0x5575,
		0xe0a3
		},
		{
		0x5576,
		0xe0a4
		},
		{
		0x5577,
		0xe0a5
		},
		{
		0x557b,
		0xe0b4
		},
		{
		0x557c,
		0xcce4
		},
		{
		0x557e,
		0xe0b1
		},
		{
		0x5580,
		0xbfa6
		},
		{
		0x5581,
		0xe0af
		},
		{
		0x5582,
		0xceb9
		},
		{
		0x5583,
		0xe0ab
		},
		{
		0x5584,
		0xc9c6
		},
		{
		0x5587,
		0xc0ae
		},
		{
		0x5588,
		0xe0ae
		},
		{
		0x5589,
		0xbaed
		},
		{
		0x558a,
		0xbab0
		},
		{
		0x558b,
		0xe0a9
		},
		{
		0x558f,
		0xdff6
		},
		{
		0x5591,
		0xe0b3
		},
		{
		0x5594,
		0xe0b8
		},
		{
		0x5598,
		0xb4ad
		},
		{
		0x5599,
		0xe0b9
		},
		{
		0x559a,
		0xbbbd
		},
		{
		0x559c,
		0xcfb2
		},
		{
		0x559d,
		0xbac8
		},
		{
		0x559f,
		0xe0b0
		},
		{
		0x55a7,
		0xd0fa
		},
		{
		0x55aa,
		0xc9a5
		},
		{
		0x55ac,
		0xc7c7
		},
		{
		0x55ae,
		0xb5a5
		},
		{
		0x55b1,
		0xe0ac
		},
		{
		0x55b2,
		0xd3b4
		},
		{
		0x55b3,
		0xd4fb
		},
		{
		0x55b5,
		0xdff7
		},
		{
		0x55b9,
		0xe0ad
		},
		{
		0x55bb,
		0xd3f7
		},
		{
		0x55c4,
		0xe0c4
		},
		{
		0x55c5,
		0xd0e1
		},
		{
		0x55c6,
		0xc7ba
		},
		{
		0x55c7,
		0xd8c4
		},
		{
		0x55c9,
		0xe0bc
		},
		{
		0x55cc,
		0xe0c9
		},
		{
		0x55cd,
		0xe0ca
		},
		{
		0x55ce,
		0xc2f0
		},
		{
		0x55d1,
		0xe0be
		},
		{
		0x55d2,
		0xe0aa
		},
		{
		0x55d3,
		0xc9a4
		},
		{
		0x55d4,
		0xe0c1
		},
		{
		0x55d6,
		0xe0b2
		},
		{
		0x55da,
		0xced8
		},
		{
		0x55dc,
		0xcac8
		},
		{
		0x55dd,
		0xe0c3
		},
		{
		0x55df,
		0xe0b5
		},
		{
		0x55e1,
		0xcecb
		},
		{
		0x55e3,
		0xcbc3
		},
		{
		0x55e4,
		0xe0cd
		},
		{
		0x55e5,
		0xe0c6
		},
		{
		0x55e6,
		0xe0c2
		},
		{
		0x55e8,
		0xe0cb
		},
		{
		0x55e9,
		0xdfef
		},
		{
		0x55ea,
		0xe0ba
		},
		{
		0x55ec,
		0xe0c0
		},
		{
		0x55ef,
		0xe0c5
		},
		{
		0x55f2,
		0xe0c7
		},
		{
		0x55f5,
		0xe0cc
		},
		{
		0x55f6,
		0xdfd9
		},
		{
		0x55f7,
		0xe0bb
		},
		{
		0x55fd,
		0xcbd4
		},
		{
		0x55fe,
		0xe0d5
		},
		{
		0x5600,
		0xe0d6
		},
		{
		0x5601,
		0xe0d2
		},
		{
		0x5606,
		0xccbe
		},
		{
		0x5608,
		0xe0d0
		},
		{
		0x5609,
		0xbcce
		},
		{
		0x560c,
		0xe0d1
		},
		{
		0x560d,
		0xe0b6
		},
		{
		0x560e,
		0xb8c2
		},
		{
		0x560f,
		0xd8c5
		},
		{
		0x5614,
		0xc5bb
		},
		{
		0x5616,
		0xdff5
		},
		{
		0x5617,
		0xb3a2
		},
		{
		0x5618,
		0xd0ea
		},
		{
		0x561b,
		0xc2ef
		},
		{
		0x561c,
		0xdfe9
		},
		{
		0x561e,
		0xe0cf
		},
		{
		0x561f,
		0xe0bd
		},
		{
		0x5623,
		0xe0d4
		},
		{
		0x5627,
		0xe0d7
		},
		{
		0x5629,
		0xbba9
		},
		{
		0x562c,
		0xe0dc
		},
		{
		0x562d,
		0xe0d8
		},
		{
		0x562e,
		0xdfeb
		},
		{
		0x562f,
		0xd0a5
		},
		{
		0x5630,
		0xdfb4
		},
		{
		0x5632,
		0xb3b0
		},
		{
		0x5634,
		0xd7ec
		},
		{
		0x5635,
		0xdfd8
		},
		{
		0x5636,
		0xcbbb
		},
		{
		0x5638,
		0xdfbc
		},
		{
		0x5639,
		0xe0da
		},
		{
		0x563b,
		0xcefb
		},
		{
		0x563f,
		0xbad9
		},
		{
		0x5641,
		0xf8b0
		},
		{
		0x564c,
		0xe0e1
		},
		{
		0x564d,
		0xe0dd
		},
		{
		0x564e,
		0xd2ad
		},
		{
		0x5654,
		0xe0e2
		},
		{
		0x5657,
		0xe0db
		},
		{
		0x5658,
		0xe0d9
		},
		{
		0x5659,
		0xe0df
		},
		{
		0x565d,
		0xdfd0
		},
		{
		0x5660,
		0xdfd5
		},
		{
		0x5662,
		0xe0de
		},
		{
		0x5664,
		0xe0e4
		},
		{
		0x5665,
		0xdfe6
		},
		{
		0x5666,
		0xdfdc
		},
		{
		0x5668,
		0xc6f7
		},
		{
		0x5669,
		0xd8ac
		},
		{
		0x566a,
		0xd4eb
		},
		{
		0x566b,
		0xe0e6
		},
		{
		0x566c,
		0xcac9
		},
		{
		0x566f,
		0xe0c8
		},
		{
		0x5671,
		0xe0e5
		},
		{
		0x5672,
		0xdfe0
		},
		{
		0x5674,
		0xc5e7
		},
		{
		0x5676,
		0xb8c1
		},
		{
		0x5678,
		0xb6d6
		},
		{
		0x5679,
		0xf8ab
		},
		{
		0x567b,
		0xe0e7
		},
		{
		0x567c,
		0xe0e8
		},
		{
		0x5680,
		0xdfcc
		},
		{
		0x5685,
		0xe0e9
		},
		{
		0x5686,
		0xe0e3
		},
		{
		0x5687,
		0xcfc5
		},
		{
		0x568c,
		0xdfe2
		},
		{
		0x568e,
		0xbabf
		},
		{
		0x568f,
		0xcce7
		},
		{
		0x5693,
		0xe0ea
		},
		{
		0x5695,
		0xe0e0
		},
		{
		0x5699,
		0xc4f6
		},
		{
		0x56a6,
		0xdfbf
		},
		{
		0x56a8,
		0xc1fc
		},
		{
		0x56ae,
		0xf8f5
		},
		{
		0x56af,
		0xe0eb
		},
		{
		0x56b3,
		0xe0b7
		},
		{
		0x56b4,
		0xd1cf
		},
		{
		0x56b6,
		0xe0d3
		},
		{
		0x56b7,
		0xc8c2
		},
		{
		0x56bc,
		0xbdc0
		},
		{
		0x56c0,
		0xdff9
		},
		{
		0x56c1,
		0xe0bf
		},
		{
		0x56c2,
		0xcff9
		},
		{
		0x56c5,
		0xd9e6
		},
		{
		0x56c8,
		0xdfbd
		},
		{
		0x56c9,
		0xf8d3
		},
		{
		0x56ca,
		0xc4d2
		},
		{
		0x56cc,
		0xf8ea
		},
		{
		0x56d1,
		0xd6f6
		},
		{
		0x56d4,
		0xe0ec
		},
		{
		0x56d7,
		0xe0ed
		},
		{
		0x56da,
		0xc7f4
		},
		{
		0x56db,
		0xcbc4
		},
		{
		0x56dd,
		0xe0ee
		},
		{
		0x56de,
		0xbbd8
		},
		{
		0x56df,
		0xd8b6
		},
		{
		0x56e0,
		0xd2f2
		},
		{
		0x56e1,
		0xe0ef
		},
		{
		0x56e4,
		0xb6da
		},
		{
		0x56eb,
		0xe0f1
		},
		{
		0x56f0,
		0xc0a7
		},
		{
		0x56f1,
		0xb4d1
		},
		{
		0x56f9,
		0xe0f2
		},
		{
		0x56fa,
		0xb9cc
		},
		{
		0x56ff,
		0xe0f3
		},
		{
		0x5703,
		0xc6d4
		},
		{
		0x5704,
		0xe0f4
		},
		{
		0x5707,
		0xe0f0
		},
		{
		0x5708,
		0xc8a6
		},
		{
		0x5709,
		0xe0f6
		},
		{
		0x570a,
		0xe0f5
		},
		{
		0x570b,
		0xb9fa
		},
		{
		0x570d,
		0xcea7
		},
		{
		0x5712,
		0xd4b0
		},
		{
		0x5713,
		0xd4b2
		},
		{
		0x5716,
		0xcdbc
		},
		{
		0x5718,
		0xcdc5
		},
		{
		0x571c,
		0xe0f7
		},
		{
		0x571f,
		0xcdc1
		},
		{
		0x5728,
		0xd4da
		},
		{
		0x5729,
		0xdbd7
		},
		{
		0x572a,
		0xdbd9
		},
		{
		0x572c,
		0xdbd8
		},
		{
		0x572d,
		0xb9e7
		},
		{
		0x572e,
		0xdbdc
		},
		{
		0x572f,
		0xdbdd
		},
		{
		0x5730,
		0xb5d8
		},
		{
		0x5733,
		0xdbda
		},
		{
		0x573b,
		0xdbdf
		},
		{
		0x573e,
		0xbbf8
		},
		{
		0x5740,
		0xd6b7
		},
		{
		0x5742,
		0xdbe0
		},
		{
		0x5747,
		0xbef9
		},
		{
		0x574a,
		0xb7bb
		},
		{
		0x574c,
		0xdbd0
		},
		{
		0x574d,
		0xccae
		},
		{
		0x574e,
		0xbfb2
		},
		{
		0x5750,
		0xd7f8
		},
		{
		0x5751,
		0xbfd3
		},
		{
		0x5761,
		0xc6c2
		},
		{
		0x5764,
		0xc0a4
		},
		{
		0x5766,
		0xccb9
		},
		{
		0x5768,
		0xdbe7
		},
		{
		0x5769,
		0xdbe1
		},
		{
		0x576a,
		0xc6ba
		},
		{
		0x576b,
		0xdbe3
		},
		{
		0x576d,
		0xdbe8
		},
		{
		0x576f,
		0xc5f7
		},
		{
		0x5773,
		0xdbea
		},
		{
		0x5776,
		0xdbe9
		},
		{
		0x5777,
		0xbfc0
		},
		{
		0x577b,
		0xdbe6
		},
		{
		0x577c,
		0xdbe5
		},
		{
		0x5782,
		0xb4b9
		},
		{
		0x5783,
		0xc0ac
		},
		{
		0x578b,
		0xd0cd
		},
		{
		0x578c,
		0xdbed
		},
		{
		0x5793,
		0xdbf2
		},
		{
		0x579b,
		0xb6e2
		},
		{
		0x57a0,
		0xdbf3
		},
		{
		0x57a1,
		0xdbd2
		},
		{
		0x57a2,
		0xb9b8
		},
		{
		0x57a3,
		0xd4ab
		},
		{
		0x57a4,
		0xdbec
		},
		{
		0x57a7,
		0xdbf0
		},
		{
		0x57ae,
		0xbfe5
		},
		{
		0x57b8,
		0xdbf9
		},
		{
		0x57c2,
		0xb9a1
		},
		{
		0x57c3,
		0xb0a3
		},
		{
		0x57cb,
		0xc2f1
		},
		{
		0x57ce,
		0xb3c7
		},
		{
		0x57cf,
		0xdbef
		},
		{
		0x57d2,
		0xdbf8
		},
		{
		0x57d4,
		0xc6d2
		},
		{
		0x57d5,
		0xdbf4
		},
		{
		0x57dd,
		0xdbfe
		},
		{
		0x57df,
		0xd3f2
		},
		{
		0x57e0,
		0xb2ba
		},
		{
		0x57e1,
		0xdbeb
		},
		{
		0x57e4,
		0xdbfd
		},
		{
		0x57ed,
		0xdca4
		},
		{
		0x57ef,
		0xdbfb
		},
		{
		0x57f4,
		0xdbfa
		},
		{
		0x57f7,
		0xd6b4
		},
		{
		0x57f8,
		0xdbfc
		},
		{
		0x57f9,
		0xc5e0
		},
		{
		0x57fa,
		0xbbf9
		},
		{
		0x57fd,
		0xdca3
		},
		{
		0x5800,
		0xdca5
		},
		{
		0x5802,
		0xccc3
		},
		{
		0x5805,
		0xbce1
		},
		{
		0x5806,
		0xb6d1
		},
		{
		0x5807,
		0xddc0
		},
		{
		0x580a,
		0xdbd1
		},
		{
		0x580b,
		0xdca1
		},
		{
		0x580d,
		0xdca2
		},
		{
		0x5816,
		0xdbf1
		},
		{
		0x5819,
		0xdca7
		},
		{
		0x581d,
		0xdbf6
		},
		{
		0x581e,
		0xdca6
		},
		{
		0x5820,
		0xdca9
		},
		{
		0x5821,
		0xb1a4
		},
		{
		0x5824,
		0xb5cc
		},
		{
		0x582a,
		0xbfb0
		},
		{
		0x582f,
		0xd2a2
		},
		{
		0x5830,
		0xd1df
		},
		{
		0x5831,
		0xb1a8
		},
		{
		0x5834,
		0xb3a1
		},
		{
		0x5835,
		0xb6c2
		},
		{
		0x5844,
		0xdca8
		},
		{
		0x584a,
		0xbfe9
		},
		{
		0x584b,
		0xdce3
		},
		{
		0x584c,
		0xcbfa
		},
		{
		0x584d,
		0xebf3
		},
		{
		0x584f,
		0xdbee
		},
		{
		0x5851,
		0xcbdc
		},
		{
		0x5852,
		0xdbf5
		},
		{
		0x5854,
		0xcbfe
		},
		{
		0x5857,
		0xcdbf
		},
		{
		0x5858,
		0xccc1
		},
		{
		0x585e,
		0xc8fb
		},
		{
		0x5862,
		0xceeb
		},
		{
		0x5864,
		0xdbf7
		},
		{
		0x5865,
		0xdcaa
		},
		{
		0x586b,
		0xccee
		},
		{
		0x586c,
		0xdcab
		},
		{
		0x5875,
		0xb3be
		},
		{
		0x5879,
		0xc7b5
		},
		{
		0x587e,
		0xdbd3
		},
		{
		0x5880,
		0xdcaf
		},
		{
		0x5881,
		0xdcac
		},
		{
		0x5883,
		0xbeb3
		},
		{
		0x5885,
		0xcafb
		},
		{
		0x5889,
		0xdcad
		},
		{
		0x588a,
		0xb5e6
		},
		{
		0x5892,
		0xc9ca
		},
		{
		0x5893,
		0xc4b9
		},
		{
		0x589a,
		0xdcae
		},
		{
		0x589c,
		0xd7b9
		},
		{
		0x589e,
		0xd4f6
		},
		{
		0x589f,
		0xd0e6
		},
		{
		0x58a8,
		0xc4ab
		},
		{
		0x58a9,
		0xb6d5
		},
		{
		0x58ae,
		0xb6e9
		},
		{
		0x58b3,
		0xb7d8
		},
		{
		0x58bb,
		0xc7bd
		},
		{
		0x58bc,
		0xdbd4
		},
		{
		0x58be,
		0xbfd1
		},
		{
		0x58c1,
		0xb1da
		},
		{
		0x58c5,
		0xdbd5
		},
		{
		0x58c7,
		0xccb3
		},
		{
		0x58d1,
		0xdbd6
		},
		{
		0x58d3,
		0xd1b9
		},
		{
		0x58d5,
		0xbabe
		},
		{
		0x58d8,
		0xc0dd
		},
		{
		0x58d9,
		0xdbdb
		},
		{
		0x58da,
		0xdbe4
		},
		{
		0x58de,
		0xbbb5
		},
		{
		0x58df,
		0xc2a2
		},
		{
		0x58e0,
		0xdbe2
		},
		{
		0x58e2,
		0xdbde
		},
		{
		0x58e4,
		0xc8c0
		},
		{
		0x58e9,
		0xb0d3
		},
		{
		0x58eb,
		0xcabf
		},
		{
		0x58ec,
		0xc8c9
		},
		{
		0x58ef,
		0xd7b3
		},
		{
		0x58f9,
		0xd2bc
		},
		{
		0x58fa,
		0xbaf8
		},
		{
		0x58fd,
		0xcad9
		},
		{
		0x5902,
		0xe2ba
		},
		{
		0x590f,
		0xcfc4
		},
		{
		0x5914,
		0xd9e7
		},
		{
		0x5915,
		0xcfa6
		},
		{
		0x5916,
		0xcde2
		},
		{
		0x5919,
		0xd9ed
		},
		{
		0x591a,
		0xb6e0
		},
		{
		0x591c,
		0xd2b9
		},
		{
		0x591f,
		0xb9bb
		},
		{
		0x5922,
		0xc3ce
		},
		{
		0x5924,
		0xe2b9
		},
		{
		0x5925,
		0xe2b7
		},
		{
		0x5927,
		0xb4f3
		},
		{
		0x5929,
		0xccec
		},
		{
		0x592a,
		0xccab
		},
		{
		0x592b,
		0xb7f2
		},
		{
		0x592d,
		0xd8b2
		},
		{
		0x592e,
		0xd1eb
		},
		{
		0x592f,
		0xbabb
		},
		{
		0x5931,
		0xcaa7
		},
		{
		0x5937,
		0xd2c4
		},
		{
		0x5938,
		0xf8c9
		},
		{
		0x593c,
		0xdec5
		},
		{
		0x593e,
		0xbcd0
		},
		{
		0x5944,
		0xd1d9
		},
		{
		0x5947,
		0xc6e6
		},
		{
		0x5948,
		0xc4ce
		},
		{
		0x5949,
		0xb7ee
		},
		{
		0x594e,
		0xbffc
		},
		{
		0x594f,
		0xd7e0
		},
		{
		0x5950,
		0xdbbc
		},
		{
		0x5951,
		0xc6f5
		},
		{
		0x5954,
		0xb1bc
		},
		{
		0x5955,
		0xdec8
		},
		{
		0x5957,
		0xccd7
		},
		{
		0x5958,
		0xdeca
		},
		{
		0x595a,
		0xdec9
		},
		{
		0x5960,
		0xb5ec
		},
		{
		0x5962,
		0xc9dd
		},
		{
		0x5965,
		0xb0c2
		},
		{
		0x5969,
		0xdec6
		},
		{
		0x596a,
		0xb6e1
		},
		{
		0x596c,
		0xbdb1
		},
		{
		0x596e,
		0xb7dc
		},
		{
		0x5973,
		0xc5ae
		},
		{
		0x5974,
		0xc5ab
		},
		{
		0x5976,
		0xc4cc
		},
		{
		0x5978,
		0xbce9
		},
		{
		0x5979,
		0xcbfd
		},
		{
		0x597d,
		0xbac3
		},
		{
		0x5981,
		0xe5f9
		},
		{
		0x5982,
		0xc8e7
		},
		{
		0x5983,
		0xe5fa
		},
		{
		0x5984,
		0xcdfd
		},
		{
		0x598a,
		0xc8d1
		},
		{
		0x598d,
		0xe5fb
		},
		{
		0x5992,
		0xb6ca
		},
		{
		0x5993,
		0xbccb
		},
		{
		0x5996,
		0xd1fd
		},
		{
		0x5997,
		0xe6a1
		},
		{
		0x5999,
		0xc3ee
		},
		{
		0x599d,
		0xd7b1
		},
		{
		0x599e,
		0xe6a4
		},
		{
		0x59a3,
		0xe5fe
		},
		{
		0x59a4,
		0xe6a5
		},
		{
		0x59a5,
		0xcdd7
		},
		{
		0x59a8,
		0xb7c1
		},
		{
		0x59ae,
		0xc4dd
		},
		{
		0x59af,
		0xe6a8
		},
		{
		0x59b2,
		0xe6a7
		},
		{
		0x59b9,
		0xc3c3
		},
		{
		0x59bb,
		0xc6de
		},
		{
		0x59be,
		0xe6aa
		},
		{
		0x59c6,
		0xc4b7
		},
		{
		0x59ca,
		0xe6a2
		},
		{
		0x59cb,
		0xcabc
		},
		{
		0x59d0,
		0xbde3
		},
		{
		0x59d1,
		0xb9c3
		},
		{
		0x59d2,
		0xe6a6
		},
		{
		0x59d3,
		0xd0d5
		},
		{
		0x59d4,
		0xceaf
		},
		{
		0x59d7,
		0xe6a9
		},
		{
		0x59d8,
		0xe6b0
		},
		{
		0x59da,
		0xd2a6
		},
		{
		0x59dc,
		0xbdaa
		},
		{
		0x59dd,
		0xe6ad
		},
		{
		0x59e3,
		0xe6af
		},
		{
		0x59e5,
		0xc0d1
		},
		{
		0x59e8,
		0xd2cc
		},
		{
		0x59ec,
		0xbca7
		},
		{
		0x59f9,
		0xe6b1
		},
		{
		0x59fb,
		0xd2f6
		},
		{
		0x59ff,
		0xd7cb
		},
		{
		0x5a01,
		0xcdfe
		},
		{
		0x5a03,
		0xcdde
		},
		{
		0x5a09,
		0xe6b3
		},
		{
		0x5a0c,
		0xe6b2
		},
		{
		0x5a11,
		0xe6b6
		},
		{
		0x5a13,
		0xe6b8
		},
		{
		0x5a18,
		0xc4ef
		},
		{
		0x5a1c,
		0xc4c8
		},
		{
		0x5a1f,
		0xbeea
		},
		{
		0x5a20,
		0xc9ef
		},
		{
		0x5a23,
		0xe6b7
		},
		{
		0x5a25,
		0xb6f0
		},
		{
		0x5a29,
		0xc3e4
		},
		{
		0x5a31,
		0xd3e9
		},
		{
		0x5a36,
		0xc8a2
		},
		{
		0x5a3c,
		0xe6bd
		},
		{
		0x5a40,
		0xe6b9
		},
		{
		0x5a41,
		0xc2a6
		},
		{
		0x5a46,
		0xc6c5
		},
		{
		0x5a49,
		0xcdf1
		},
		{
		0x5a4a,
		0xe6bb
		},
		{
		0x5a55,
		0xe6bc
		},
		{
		0x5a5a,
		0xbbe9
		},
		{
		0x5a62,
		0xe6be
		},
		{
		0x5a66,
		0xb8be
		},
		{
		0x5a67,
		0xe6ba
		},
		{
		0x5a6a,
		0xc0b7
		},
		{
		0x5a6d,
		0xe6ab
		},
		{
		0x5a77,
		0xe6c3
		},
		{
		0x5a7a,
		0xe6c4
		},
		{
		0x5a7f,
		0xd0f6
		},
		{
		0x5a92,
		0xc3bd
		},
		{
		0x5a9a,
		0xc3c4
		},
		{
		0x5a9b,
		0xe6c2
		},
		{
		0x5aa7,
		0xe6b4
		},
		{
		0x5aaa,
		0xe6c1
		},
		{
		0x5ab2,
		0xe6c7
		},
		{
		0x5ab3,
		0xcfb1
		},
		{
		0x5ab5,
		0xebf4
		},
		{
		0x5ab8,
		0xe6ca
		},
		{
		0x5abd,
		0xc2e8
		},
		{
		0x5abe,
		0xe6c5
		},
		{
		0x5ac1,
		0xbcde
		},
		{
		0x5ac2,
		0xc9a9
		},
		{
		0x5ac9,
		0xbcb5
		},
		{
		0x5acc,
		0xcfd3
		},
		{
		0x5ad6,
		0xe6ce
		},
		{
		0x5ad7,
		0xe5fd
		},
		{
		0x5ad8,
		0xe6d0
		},
		{
		0x5adc,
		0xe6d1
		},
		{
		0x5ae0,
		0xe6cb
		},
		{
		0x5ae1,
		0xb5d5
		},
		{
		0x5ae3,
		0xe6cc
		},
		{
		0x5ae6,
		0xe6cf
		},
		{
		0x5ae9,
		0xc4db
		},
		{
		0x5aeb,
		0xe6c6
		},
		{
		0x5af5,
		0xe5fc
		},
		{
		0x5afb,
		0xe6b5
		},
		{
		0x5b00,
		0xe6a3
		},
		{
		0x5b08,
		0xe6ac
		},
		{
		0x5b09,
		0xe6d2
		},
		{
		0x5b0b,
		0xe6bf
		},
		{
		0x5b0c,
		0xbdbf
		},
		{
		0x5b16,
		0xe6d4
		},
		{
		0x5b17,
		0xe6d3
		},
		{
		0x5b19,
		0xe6cd
		},
		{
		0x5b21,
		0xe6c8
		},
		{
		0x5b2a,
		0xe6c9
		},
		{
		0x5b30,
		0xd3a4
		},
		{
		0x5b32,
		0xe6d5
		},
		{
		0x5b34,
		0xd9f8
		},
		{
		0x5b37,
		0xe6d6
		},
		{
		0x5b38,
		0xc9f4
		},
		{
		0x5b40,
		0xe6d7
		},
		{
		0x5b4c,
		0xe6ae
		},
		{
		0x5b50,
		0xd7d3
		},
		{
		0x5b51,
		0xe6dd
		},
		{
		0x5b53,
		0xe6de
		},
		{
		0x5b54,
		0xbfd7
		},
		{
		0x5b55,
		0xd4d0
		},
		{
		0x5b57,
		0xd7d6
		},
		{
		0x5b58,
		0xb4e6
		},
		{
		0x5b5a,
		0xe6da
		},
		{
		0x5b5b,
		0xd8c3
		},
		{
		0x5b5c,
		0xd7ce
		},
		{
		0x5b5d,
		0xd0a2
		},
		{
		0x5b5f,
		0xc3cf
		},
		{
		0x5b62,
		0xe6df
		},
		{
		0x5b63,
		0xbcbe
		},
		{
		0x5b64,
		0xb9c2
		},
		{
		0x5b65,
		0xe6db
		},
		{
		0x5b69,
		0xbaa2
		},
		{
		0x5b6b,
		0xcbef
		},
		{
		0x5b6c,
		0xd8ab
		},
		{
		0x5b70,
		0xcaeb
		},
		{
		0x5b71,
		0xe5ee
		},
		{
		0x5b73,
		0xe6dc
		},
		{
		0x5b75,
		0xb7f5
		},
		{
		0x5b78,
		0xd1a7
		},
		{
		0x5b7a,
		0xc8e6
		},
		{
		0x5b7d,
		0xc4f5
		},
		{
		0x5b7f,
		0xc2cf
		},
		{
		0x5b80,
		0xe5b2
		},
		{
		0x5b83,
		0xcbfc
		},
		{
		0x5b84,
		0xe5b3
		},
		{
		0x5b85,
		0xd5ac
		},
		{
		0x5b87,
		0xd3ee
		},
		{
		0x5b88,
		0xcad8
		},
		{
		0x5b89,
		0xb0b2
		},
		{
		0x5b8b,
		0xcbce
		},
		{
		0x5b8c,
		0xcdea
		},
		{
		0x5b8f,
		0xbaea
		},
		{
		0x5b93,
		0xe5b5
		},
		{
		0x5b95,
		0xe5b4
		},
		{
		0x5b97,
		0xd7da
		},
		{
		0x5b98,
		0xb9d9
		},
		{
		0x5b99,
		0xd6e6
		},
		{
		0x5b9a,
		0xb6a8
		},
		{
		0x5b9b,
		0xcdf0
		},
		{
		0x5b9c,
		0xd2cb
		},
		{
		0x5ba2,
		0xbfcd
		},
		{
		0x5ba3,
		0xd0fb
		},
		{
		0x5ba4,
		0xcad2
		},
		{
		0x5ba5,
		0xe5b6
		},
		{
		0x5ba6,
		0xbbc2
		},
		{
		0x5bab,
		0xb9ac
		},
		{
		0x5bb0,
		0xd4d7
		},
		{
		0x5bb3,
		0xbaa6
		},
		{
		0x5bb4,
		0xd1e7
		},
		{
		0x5bb5,
		0xcffc
		},
		{
		0x5bb6,
		0xbcd2
		},
		{
		0x5bb8,
		0xe5b7
		},
		{
		0x5bb9,
		0xc8dd
		},
		{
		0x5bbf,
		0xcbde
		},
		{
		0x5bc2,
		0xbcc5
		},
		{
		0x5bc4,
		0xbcc4
		},
		{
		0x5bc5,
		0xd2fa
		},
		{
		0x5bc6,
		0xc3dc
		},
		{
		0x5bc7,
		0xbfdc
		},
		{
		0x5bcc,
		0xb8bb
		},
		{
		0x5bd0,
		0xc3c2
		},
		{
		0x5bd2,
		0xbaae
		},
		{
		0x5bd3,
		0xd4a2
		},
		{
		0x5bde,
		0xc4af
		},
		{
		0x5bdf,
		0xb2ec
		},
		{
		0x5be1,
		0xb9d1
		},
		{
		0x5be2,
		0xc7de
		},
		{
		0x5be4,
		0xe5bb
		},
		{
		0x5be5,
		0xc1c8
		},
		{
		0x5be6,
		0xcab5
		},
		{
		0x5be7,
		0xc4fe
		},
		{
		0x5be8,
		0xd5af
		},
		{
		0x5be9,
		0xc9f3
		},
		{
		0x5beb,
		0xd0b4
		},
		{
		0x5bec,
		0xbfed
		},
		{
		0x5bee,
		0xe5bc
		},
		{
		0x5bf0,
		0xe5be
		},
		{
		0x5bf5,
		0xb3e8
		},
		{
		0x5bf6,
		0xb1a6
		},
		{
		0x5bf8,
		0xb4e7
		},
		{
		0x5bfa,
		0xcbc2
		},
		{
		0x5c01,
		0xb7e2
		},
		{
		0x5c04,
		0xc9e4
		},
		{
		0x5c07,
		0xbdab
		},
		{
		0x5c08,
		0xd7a8
		},
		{
		0x5c09,
		0xcebe
		},
		{
		0x5c0a,
		0xd7f0
		},
		{
		0x5c0b,
		0xd1b0
		},
		{
		0x5c0d,
		0xb6d4
		},
		{
		0x5c0e,
		0xb5bc
		},
		{
		0x5c0f,
		0xd0a1
		},
		{
		0x5c11,
		0xc9d9
		},
		{
		0x5c15,
		0xe6d8
		},
		{
		0x5c16,
		0xbce2
		},
		{
		0x5c1a,
		0xc9d0
		},
		{
		0x5c1c,
		0xe6d9
		},
		{
		0x5c22,
		0xdecc
		},
		{
		0x5c24,
		0xd3c8
		},
		{
		0x5c25,
		0xdecd
		},
		{
		0x5c2c,
		0xdece
		},
		{
		0x5c31,
		0xbecd
		},
		{
		0x5c37,
		0xdecf
		},
		{
		0x5c38,
		0xcaac
		},
		{
		0x5c39,
		0xd2fc
		},
		{
		0x5c3a,
		0xb3df
		},
		{
		0x5c3b,
		0xe5ea
		},
		{
		0x5c3c,
		0xc4e1
		},
		{
		0x5c3e,
		0xceb2
		},
		{
		0x5c3f,
		0xc4f2
		},
		{
		0x5c40,
		0xbed6
		},
		{
		0x5c41,
		0xc6a8
		},
		{
		0x5c45,
		0xbed3
		},
		{
		0x5c48,
		0xc7fc
		},
		{
		0x5c49,
		0xcceb
		},
		{
		0x5c4a,
		0xbdec
		},
		{
		0x5c4b,
		0xcedd
		},
		{
		0x5c4e,
		0xcaba
		},
		{
		0x5c4f,
		0xc6c1
		},
		{
		0x5c50,
		0xe5ec
		},
		{
		0x5c51,
		0xd0bc
		},
		{
		0x5c55,
		0xd5b9
		},
		{
		0x5c59,
		0xe5ed
		},
		{
		0x5c60,
		0xcdc0
		},
		{
		0x5c62,
		0xc2c5
		},
		{
		0x5c63,
		0xe5ef
		},
		{
		0x5c64,
		0xb2e3
		},
		{
		0x5c65,
		0xc2c4
		},
		{
		0x5c68,
		0xe5f0
		},
		{
		0x5c6c,
		0xcaf4
		},
		{
		0x5c6e,
		0xe5f8
		},
		{
		0x5c6f,
		0xcdcd
		},
		{
		0x5c71,
		0xc9bd
		},
		{
		0x5c79,
		0xd2d9
		},
		{
		0x5c7a,
		0xe1a8
		},
		{
		0x5c88,
		0xe1ac
		},
		{
		0x5c8c,
		0xe1a7
		},
		{
		0x5c8d,
		0xe1a9
		},
		{
		0x5c90,
		0xe1aa
		},
		{
		0x5c91,
		0xe1af
		},
		{
		0x5c94,
		0xb2ed
		},
		{
		0x5c99,
		0xe1ae
		},
		{
		0x5c9c,
		0xe1b1
		},
		{
		0x5ca1,
		0xb8d4
		},
		{
		0x5ca2,
		0xe1b3
		},
		{
		0x5ca3,
		0xe1b8
		},
		{
		0x5ca9,
		0xd1d2
		},
		{
		0x5cab,
		0xe1b6
		},
		{
		0x5cac,
		0xe1b5
		},
		{
		0x5cb1,
		0xe1b7
		},
		{
		0x5cb3,
		0xd4c0
		},
		{
		0x5cb5,
		0xe1b2
		},
		{
		0x5cb7,
		0xe1ba
		},
		{
		0x5cb8,
		0xb0b6
		},
		{
		0x5cc1,
		0xe1b9
		},
		{
		0x5ccb,
		0xe1be
		},
		{
		0x5cd2,
		0xe1bc
		},
		{
		0x5cd9,
		0xd6c5
		},
		{
		0x5ce8,
		0xb6eb
		},
		{
		0x5cea,
		0xd3f8
		},
		{
		0x5ced,
		0xc7cd
		},
		{
		0x5cf0,
		0xb7e5
		},
		{
		0x5cf4,
		0xe1ad
		},
		{
		0x5cf6,
		0xb5ba
		},
		{
		0x5cfb,
		0xbefe
		},
		{
		0x5cfd,
		0xcfbf
		},
		{
		0x5d06,
		0xe1c7
		},
		{
		0x5d07,
		0xb3e7
		},
		{
		0x5d0d,
		0xe1c1
		},
		{
		0x5d0e,
		0xc6e9
		},
		{
		0x5d14,
		0xb4de
		},
		{
		0x5d16,
		0xd1c2
		},
		{
		0x5d17,
		0xb8da
		},
		{
		0x5d1b,
		0xe1c8
		},
		{
		0x5d1e,
		0xe1c6
		},
		{
		0x5d22,
		0xe1bf
		},
		{
		0x5d24,
		0xe1c5
		},
		{
		0x5d26,
		0xe1c3
		},
		{
		0x5d27,
		0xe1c2
		},
		{
		0x5d29,
		0xb1c0
		},
		{
		0x5d2c,
		0xe1b4
		},
		{
		0x5d2e,
		0xe1c4
		},
		{
		0x5d34,
		0xe1cb
		},
		{
		0x5d3d,
		0xe1cc
		},
		{
		0x5d3e,
		0xe1ca
		},
		{
		0x5d47,
		0xeffa
		},
		{
		0x5d4a,
		0xe1d3
		},
		{
		0x5d4b,
		0xe1d2
		},
		{
		0x5d4c,
		0xc7b6
		},
		{
		0x5d50,
		0xe1b0
		},
		{
		0x5d5b,
		0xe1ce
		},
		{
		0x5d69,
		0xe1d4
		},
		{
		0x5d6b,
		0xe1d1
		},
		{
		0x5d6c,
		0xe1cd
		},
		{
		0x5d6f,
		0xe1cf
		},
		{
		0x5d74,
		0xe1d5
		},
		{
		0x5d81,
		0xe1d0
		},
		{
		0x5d82,
		0xe1d6
		},
		{
		0x5d84,
		0xd5b8
		},
		{
		0x5d87,
		0xe1ab
		},
		{
		0x5d97,
		0xe1c0
		},
		{
		0x5d99,
		0xe1d7
		},
		{
		0x5d9d,
		0xe1d8
		},
		{
		0x5da0,
		0xe1bd
		},
		{
		0x5da7,
		0xe1bb
		},
		{
		0x5db7,
		0xe1da
		},
		{
		0x5db8,
		0xe1c9
		},
		{
		0x5dba,
		0xc1eb
		},
		{
		0x5dbc,
		0xd3ec
		},
		{
		0x5dcb,
		0xbff9
		},
		{
		0x5dcd,
		0xcea1
		},
		{
		0x5dd2,
		0xc2cd
		},
		{
		0x5dd4,
		0xe1db
		},
		{
		0x5ddb,
		0xe7dd
		},
		{
		0x5ddd,
		0xb4a8
		},
		{
		0x5dde,
		0xd6dd
		},
		{
		0x5de1,
		0xd1b2
		},
		{
		0x5de2,
		0xb3b2
		},
		{
		0x5de5,
		0xb9a4
		},
		{
		0x5de6,
		0xd7f3
		},
		{
		0x5de7,
		0xc7c9
		},
		{
		0x5de8,
		0xbede
		},
		{
		0x5deb,
		0xced7
		},
		{
		0x5dee,
		0xb2ee
		},
		{
		0x5df0,
		0xdbcf
		},
		{
		0x5df1,
		0xbcba
		},
		{
		0x5df2,
		0xd2d1
		},
		{
		0x5df3,
		0xcbc8
		},
		{
		0x5df4,
		0xb0cd
		},
		{
		0x5df7,
		0xcfef
		},
		{
		0x5dfd,
		0xd9e3
		},
		{
		0x5dfe,
		0xbded
		},
		{
		0x5e02,
		0xcad0
		},
		{
		0x5e03,
		0xb2bc
		},
		{
		0x5e06,
		0xb7ab
		},
		{
		0x5e0c,
		0xcfa3
		},
		{
		0x5e11,
		0xe0fb
		},
		{
		0x5e14,
		0xe0fa
		},
		{
		0x5e15,
		0xc5c1
		},
		{
		0x5e16,
		0xccfb
		},
		{
		0x5e18,
		0xf8d0
		},
		{
		0x5e19,
		0xe0f9
		},
		{
		0x5e1a,
		0xd6e3
		},
		{
		0x5e1b,
		0xb2af
		},
		{
		0x5e1d,
		0xb5db
		},
		{
		0x5e25,
		0xcba7
		},
		{
		0x5e2b,
		0xcaa6
		},
		{
		0x5e2d,
		0xcfaf
		},
		{
		0x5e33,
		0xd5ca
		},
		{
		0x5e36,
		0xb4f8
		},
		{
		0x5e37,
		0xe1a1
		},
		{
		0x5e38,
		0xb3a3
		},
		{
		0x5e3d,
		0xc3b1
		},
		{
		0x5e40,
		0xd6a1
		},
		{
		0x5e42,
		0xc3dd
		},
		{
		0x5e43,
		0xe0f8
		},
		{
		0x5e44,
		0xe1a2
		},
		{
		0x5e45,
		0xb7f9
		},
		{
		0x5e4c,
		0xbbcf
		},
		{
		0x5e54,
		0xe1a3
		},
		{
		0x5e55,
		0xc4bb
		},
		{
		0x5e57,
		0xe0fe
		},
		{
		0x5e58,
		0xe0fd
		},
		{
		0x5e5b,
		0xe1a4
		},
		{
		0x5e5e,
		0xe1a5
		},
		{
		0x5e5f,
		0xd6c4
		},
		{
		0x5e61,
		0xe1a6
		},
		{
		0x5e62,
		0xb4b1
		},
		{
		0x5e63,
		0xb1d2
		},
		{
		0x5e6b,
		0xb0ef
		},
		{
		0x5e6c,
		0xe0fc
		},
		{
		0x5e72,
		0xf8b5
		},
		{
		0x5e73,
		0xc6bd
		},
		{
		0x5e74,
		0xc4ea
		},
		{
		0x5e76,
		0xb2a2
		},
		{
		0x5e78,
		0xd0d2
		},
		{
		0x5e79,
		0xb8c9
		},
		{
		0x5e7a,
		0xe7db
		},
		{
		0x5e7b,
		0xbbc3
		},
		{
		0x5e7c,
		0xd3d7
		},
		{
		0x5e7d,
		0xd3c4
		},
		{
		0x5e7e,
		0xbcb8
		},
		{
		0x5e7f,
		0xf8b8
		},
		{
		0x5e80,
		0xe2cf
		},
		{
		0x5e87,
		0xb1d3
		},
		{
		0x5e8a,
		0xb4b2
		},
		{
		0x5e8b,
		0xe2d1
		},
		{
		0x5e8f,
		0xd0f2
		},
		{
		0x5e95,
		0xb5d7
		},
		{
		0x5e96,
		0xe2d2
		},
		{
		0x5e97,
		0xb5ea
		},
		{
		0x5e9a,
		0xb8fd
		},
		{
		0x5e9c,
		0xb8ae
		},
		{
		0x5ea0,
		0xe2d4
		},
		{
		0x5ea5,
		0xe2d3
		},
		{
		0x5ea6,
		0xb6c8
		},
		{
		0x5ea7,
		0xd7f9
		},
		{
		0x5eab,
		0xbfe2
		},
		{
		0x5ead,
		0xcda5
		},
		{
		0x5eb3,
		0xe2d8
		},
		{
		0x5eb5,
		0xe2d6
		},
		{
		0x5eb6,
		0xcafc
		},
		{
		0x5eb7,
		0xbfb5
		},
		{
		0x5eb8,
		0xd3b9
		},
		{
		0x5eb9,
		0xe2d5
		},
		{
		0x5ebe,
		0xe2d7
		},
		{
		0x5ec9,
		0xc1ae
		},
		{
		0x5eca,
		0xc0c8
		},
		{
		0x5ed1,
		0xe2db
		},
		{
		0x5ed2,
		0xe2da
		},
		{
		0x5ed3,
		0xc0aa
		},
		{
		0x5ed6,
		0xc1ce
		},
		{
		0x5edb,
		0xe2dc
		},
		{
		0x5edf,
		0xc3ed
		},
		{
		0x5ee0,
		0xb3a7
		},
		{
		0x5ee1,
		0xe2d0
		},
		{
		0x5ee2,
		0xb7cf
		},
		{
		0x5ee3,
		0xb9e3
		},
		{
		0x5ee8,
		0xe2dd
		},
		{
		0x5eea,
		0xe2de
		},
		{
		0x5eec,
		0xc2ae
		},
		{
		0x5ef3,
		0xccfc
		},
		{
		0x5ef4,
		0xdbc8
		},
		{
		0x5ef6,
		0xd1d3
		},
		{
		0x5ef7,
		0xcda2
		},
		{
		0x5efa,
		0xbda8
		},
		{
		0x5efe,
		0xdec3
		},
		{
		0x5eff,
		0xd8a5
		},
		{
		0x5f01,
		0xdbcd
		},
		{
		0x5f02,
		0xd2ec
		},
		{
		0x5f04,
		0xc5aa
		},
		{
		0x5f08,
		0xdec4
		},
		{
		0x5f0a,
		0xb1d7
		},
		{
		0x5f0b,
		0xdfae
		},
		{
		0x5f0f,
		0xcabd
		},
		{
		0x5f11,
		0xdfb1
		},
		{
		0x5f13,
		0xb9ad
		},
		{
		0x5f15,
		0xd2fd
		},
		{
		0x5f17,
		0xb8a5
		},
		{
		0x5f18,
		0xbaeb
		},
		{
		0x5f1b,
		0xb3da
		},
		{
		0x5f1f,
		0xb5dc
		},
		{
		0x5f26,
		0xcfd2
		},
		{
		0x5f27,
		0xbba1
		},
		{
		0x5f29,
		0xe5f3
		},
		{
		0x5f2d,
		0xe5f4
		},
		{
		0x5f31,
		0xc8f5
		},
		{
		0x5f33,
		0xe5f2
		},
		{
		0x5f35,
		0xd5c5
		},
		{
		0x5f3a,
		0xc7bf
		},
		{
		0x5f3c,
		0xe5f6
		},
		{
		0x5f40,
		0xecb0
		},
		{
		0x5f46,
		0xf8a4
		},
		{
		0x5f48,
		0xb5af
		},
		{
		0x5f4c,
		0xc3d6
		},
		{
		0x5f4e,
		0xcde4
		},
		{
		0x5f50,
		0xe5e6
		},
		{
		0x5f56,
		0xe5e8
		},
		{
		0x5f57,
		0xe5e7
		},
		{
		0x5f58,
		0xe5e9
		},
		{
		0x5f59,
		0xf8bd
		},
		{
		0x5f5d,
		0xd2cd
		},
		{
		0x5f61,
		0xe1ea
		},
		{
		0x5f62,
		0xd0ce
		},
		{
		0x5f64,
		0xcdae
		},
		{
		0x5f66,
		0xd1e5
		},
		{
		0x5f69,
		0xb2ca
		},
		{
		0x5f6a,
		0xb1eb
		},
		{
		0x5f6c,
		0xb1f2
		},
		{
		0x5f6d,
		0xc5ed
		},
		{
		0x5f70,
		0xd5c3
		},
		{
		0x5f71,
		0xd3b0
		},
		{
		0x5f73,
		0xe1dc
		},
		{
		0x5f77,
		0xe1dd
		},
		{
		0x5f79,
		0xd2db
		},
		{
		0x5f7c,
		0xb1cb
		},
		{
		0x5f80,
		0xcdf9
		},
		{
		0x5f81,
		0xd5f7
		},
		{
		0x5f82,
		0xe1de
		},
		{
		0x5f85,
		0xb4fd
		},
		{
		0x5f87,
		0xe1df
		},
		{
		0x5f88,
		0xbadc
		},
		{
		0x5f89,
		0xe1e0
		},
		{
		0x5f8a,
		0xbbb2
		},
		{
		0x5f8b,
		0xc2c9
		},
		{
		0x5f8c,
		0xbaf3
		},
		{
		0x5f90,
		0xd0ec
		},
		{
		0x5f91,
		0xbeb6
		},
		{
		0x5f92,
		0xcdbd
		},
		{
		0x5f97,
		0xb5c3
		},
		{
		0x5f98,
		0xc5c7
		},
		{
		0x5f99,
		0xe1e3
		},
		{
		0x5f9c,
		0xe1e4
		},
		{
		0x5f9e,
		0xb4d3
		},
		{
		0x5fa0,
		0xe1e2
		},
		{
		0x5fa1,
		0xd3f9
		},
		{
		0x5fa8,
		0xe1e5
		},
		{
		0x5fa9,
		0xb8b4
		},
		{
		0x5faa,
		0xd1ad
		},
		{
		0x5fad,
		0xe1e6
		},
		{
		0x5fae,
		0xcea2
		},
		{
		0x5fb5,
		0xe1e7
		},
		{
		0x5fb7,
		0xb5c2
		},
		{
		0x5fb9,
		0xb3b9
		},
		{
		0x5fbc,
		0xe1e8
		},
		{
		0x5fbd,
		0xbbd5
		},
		{
		0x5fc3,
		0xd0c4
		},
		{
		0x5fc4,
		0xe2e0
		},
		{
		0x5fc5,
		0xb1d8
		},
		{
		0x5fc9,
		0xe2e1
		},
		{
		0x5fcc,
		0xbcc9
		},
		{
		0x5fcd,
		0xc8cc
		},
		{
		0x5fd0,
		0xecfe
		},
		{
		0x5fd1,
		0xecfd
		},
		{
		0x5fd2,
		0xdfaf
		},
		{
		0x5fd6,
		0xe2e2
		},
		{
		0x5fd7,
		0xd6be
		},
		{
		0x5fd8,
		0xcdfc
		},
		{
		0x5fd9,
		0xc3a6
		},
		{
		0x5fdd,
		0xe3c3
		},
		{
		0x5fe0,
		0xd6d2
		},
		{
		0x5fe1,
		0xe2e7
		},
		{
		0x5fe4,
		0xe2e8
		},
		{
		0x5fea,
		0xe2ec
		},
		{
		0x5feb,
		0xbfec
		},
		{
		0x5fed,
		0xe2ed
		},
		{
		0x5fee,
		0xe2e5
		},
		{
		0x5ff1,
		0xb3c0
		},
		{
		0x5ff5,
		0xc4ee
		},
		{
		0x5ff8,
		0xe2ee
		},
		{
		0x5ffb,
		0xd0c3
		},
		{
		0x5ffd,
		0xbaf6
		},
		{
		0x5fff,
		0xb7de
		},
		{
		0x600a,
		0xe2f7
		},
		{
		0x600d,
		0xe2f4
		},
		{
		0x600e,
		0xd4f5
		},
		{
		0x600f,
		0xe2f3
		},
		{
		0x6012,
		0xc5ad
		},
		{
		0x6014,
		0xd5fa
		},
		{
		0x6015,
		0xc5c2
		},
		{
		0x6016,
		0xb2c0
		},
		{
		0x6019,
		0xe2ef
		},
		{
		0x601b,
		0xe2f2
		},
		{
		0x601d,
		0xcbbc
		},
		{
		0x6020,
		0xb5a1
		},
		{
		0x6021,
		0xe2f9
		},
		{
		0x6025,
		0xbcb1
		},
		{
		0x6026,
		0xe2f1
		},
		{
		0x6027,
		0xd0d4
		},
		{
		0x6028,
		0xd4b9
		},
		{
		0x6029,
		0xe2f5
		},
		{
		0x602a,
		0xb9d6
		},
		{
		0x602b,
		0xe2f6
		},
		{
		0x602f,
		0xc7d3
		},
		{
		0x6035,
		0xe2f0
		},
		{
		0x6041,
		0xeda5
		},
		{
		0x6042,
		0xe2fe
		},
		{
		0x6043,
		0xcad1
		},
		{
		0x604d,
		0xbbd0
		},
		{
		0x6050,
		0xbfd6
		},
		{
		0x6052,
		0xbae3
		},
		{
		0x6055,
		0xcba1
		},
		{
		0x6059,
		0xeda6
		},
		{
		0x605a,
		0xeda3
		},
		{
		0x605d,
		0xeda2
		},
		{
		0x6062,
		0xbbd6
		},
		{
		0x6063,
		0xeda7
		},
		{
		0x6064,
		0xd0f4
		},
		{
		0x6067,
		0xeda4
		},
		{
		0x6068,
		0xbade
		},
		{
		0x6069,
		0xb6f7
		},
		{
		0x606a,
		0xe3a1
		},
		{
		0x606b,
		0xb6b2
		},
		{
		0x606c,
		0xccf1
		},
		{
		0x606d,
		0xb9a7
		},
		{
		0x606f,
		0xcfa2
		},
		{
		0x6070,
		0xc7a1
		},
		{
		0x607f,
		0xd3c1
		},
		{
		0x6083,
		0xe3a7
		},
		{
		0x6084,
		0xc7c4
		},
		{
		0x6089,
		0xcfa4
		},
		{
		0x608c,
		0xe3a9
		},
		{
		0x608d,
		0xbab7
		},
		{
		0x6092,
		0xe3a8
		},
		{
		0x6094,
		0xbbda
		},
		{
		0x6096,
		0xe3a3
		},
		{
		0x609a,
		0xe3a4
		},
		{
		0x609b,
		0xe3aa
		},
		{
		0x609d,
		0xe3a6
		},
		{
		0x609f,
		0xcef2
		},
		{
		0x60a0,
		0xd3c6
		},
		{
		0x60a3,
		0xbbbc
		},
		{
		0x60a6,
		0xd4c3
		},
		{
		0x60a8,
		0xc4fa
		},
		{
		0x60b1,
		0xe3ad
		},
		{
		0x60b2,
		0xb1af
		},
		{
		0x60b4,
		0xe3b2
		},
		{
		0x60b5,
		0xe2ea
		},
		{
		0x60b6,
		0xc3c6
		},
		{
		0x60b8,
		0xbcc2
		},
		{
		0x60bb,
		0xe3ac
		},
		{
		0x60bc,
		0xb5bf
		},
		{
		0x60c5,
		0xc7e9
		},
		{
		0x60c6,
		0xe3b0
		},
		{
		0x60cb,
		0xcdef
		},
		{
		0x60d1,
		0xbbf3
		},
		{
		0x60d5,
		0xcce8
		},
		{
		0x60d8,
		0xe3af
		},
		{
		0x60da,
		0xe3b1
		},
		{
		0x60dc,
		0xcfa7
		},
		{
		0x60dd,
		0xe3ae
		},
		{
		0x60df,
		0xcea9
		},
		{
		0x60e0,
		0xbbdd
		},
		{
		0x60e1,
		0xb6f1
		},
		{
		0x60e6,
		0xb5eb
		},
		{
		0x60f0,
		0xb6e8
		},
		{
		0x60f1,
		0xc4d5
		},
		{
		0x60f2,
		0xe3a2
		},
		{
		0x60f3,
		0xcfeb
		},
		{
		0x60f4,
		0xe3b7
		},
		{
		0x60f6,
		0xbbcc
		},
		{
		0x60f9,
		0xc8c7
		},
		{
		0x60fa,
		0xd0ca
		},
		{
		0x60fb,
		0xe2fc
		},
		{
		0x6100,
		0xe3b8
		},
		{
		0x6101,
		0xb3ee
		},
		{
		0x6106,
		0xeda9
		},
		{
		0x6108,
		0xd3fa
		},
		{
		0x6109,
		0xd3e4
		},
		{
		0x610d,
		0xedaa
		},
		{
		0x610e,
		0xe3b9
		},
		{
		0x610f,
		0xd2e2
		},
		{
		0x6115,
		0xe3b5
		},
		{
		0x611a,
		0xd3de
		},
		{
		0x611b,
		0xb0ae
		},
		{
		0x611c,
		0xe3ab
		},
		{
		0x611f,
		0xb8d0
		},
		{
		0x6120,
		0xe3b3
		},
		{
		0x6123,
		0xe3b6
		},
		{
		0x6127,
		0xc0a2
		},
		{
		0x612b,
		0xe3ba
		},
		{
		0x6134,
		0xe2eb
		},
		{
		0x6137,
		0xe2fd
		},
		{
		0x613e,
		0xe2e9
		},
		{
		0x613f,
		0xf8fc
		},
		{
		0x6148,
		0xb4c8
		},
		{
		0x614a,
		0xe3bb
		},
		{
		0x614b,
		0xccac
		},
		{
		0x614c,
		0xbbc5
		},
		{
		0x614e,
		0xc9f7
		},
		{
		0x6155,
		0xc4bd
		},
		{
		0x6158,
		0xb2d2
		},
		{
		0x615a,
		0xb2d1
		},
		{
		0x615d,
		0xedab
		},
		{
		0x615f,
		0xe2fa
		},
		{
		0x6162,
		0xc2fd
		},
		{
		0x6163,
		0xb9df
		},
		{
		0x6164,
		0xeda8
		},
		{
		0x6167,
		0xbbdb
		},
		{
		0x6168,
		0xbfae
		},
		{
		0x616a,
		0xe2e6
		},
		{
		0x616b,
		0xcbcb
		},
		{
		0x616e,
		0xc2c7
		},
		{
		0x6170,
		0xcebf
		},
		{
		0x6173,
		0xe3a5
		},
		{
		0x6175,
		0xe3bc
		},
		{
		0x6176,
		0xc7ec
		},
		{
		0x6177,
		0xbfb6
		},
		{
		0x6182,
		0xd3c7
		},
		{
		0x618a,
		0xb1b9
		},
		{
		0x618b,
		0xb1ef
		},
		{
		0x618e,
		0xd4f7
		},
		{
		0x6190,
		0xc1af
		},
		{
		0x6191,
		0xc6be
		},
		{
		0x6192,
		0xe3b4
		},
		{
		0x6194,
		0xe3be
		},
		{
		0x619a,
		0xb5ac
		},
		{
		0x619d,
		0xedad
		},
		{
		0x61a4,
		0xb7df
		},
		{
		0x61a7,
		0xe3bf
		},
		{
		0x61a8,
		0xbaa9
		},
		{
		0x61a9,
		0xedac
		},
		{
		0x61ab,
		0xc3f5
		},
		{
		0x61ac,
		0xe3bd
		},
		{
		0x61ae,
		0xe2e4
		},
		{
		0x61b2,
		0xcfdc
		},
		{
		0x61b6,
		0xd2e4
		},
		{
		0x61b7,
		0xe3c0
		},
		{
		0x61be,
		0xbab6
		},
		{
		0x61c2,
		0xb6ae
		},
		{
		0x61c7,
		0xbfd2
		},
		{
		0x61c8,
		0xd0b8
		},
		{
		0x61c9,
		0xd3a6
		},
		{
		0x61ca,
		0xb0c3
		},
		{
		0x61cb,
		0xedae
		},
		{
		0x61cc,
		0xe2f8
		},
		{
		0x61d4,
		0xe3c1
		},
		{
		0x61de,
		0xf8d6
		},
		{
		0x61df,
		0xeda1
		},
		{
		0x61e3,
		0xedaf
		},
		{
		0x61e6,
		0xc5b3
		},
		{
		0x61e8,
		0xe2fb
		},
		{
		0x61f2,
		0xb3cd
		},
		{
		0x61f5,
		0xe3c2
		},
		{
		0x61f6,
		0xc0c1
		},
		{
		0x61f7,
		0xbbb3
		},
		{
		0x61f8,
		0xd0fc
		},
		{
		0x61fa,
		0xe2e3
		},
		{
		0x61fc,
		0xbee5
		},
		{
		0x61fe,
		0xc9e5
		},
		{
		0x61ff,
		0xdcb2
		},
		{
		0x6200,
		0xc1b5
		},
		{
		0x6207,
		0xedb0
		},
		{
		0x6208,
		0xb8ea
		},
		{
		0x620a,
		0xceec
		},
		{
		0x620c,
		0xd0e7
		},
		{
		0x620d,
		0xcaf9
		},
		{
		0x620e,
		0xc8d6
		},
		{
		0x6210,
		0xb3c9
		},
		{
		0x6211,
		0xced2
		},
		{
		0x6212,
		0xbde4
		},
		{
		0x6214,
		0xeaa7
		},
		{
		0x6215,
		0xe3de
		},
		{
		0x6216,
		0xbbf2
		},
		{
		0x621a,
		0xc6dd
		},
		{
		0x621b,
		0xeaa9
		},
		{
		0x621f,
		0xeaaa
		},
		{
		0x6221,
		0xeaac
		},
		{
		0x6222,
		0xeaab
		},
		{
		0x6224,
		0xeaae
		},
		{
		0x6225,
		0xeaad
		},
		{
		0x6227,
		0xeaa8
		},
		{
		0x6229,
		0xeaaf
		},
		{
		0x622a,
		0xbdd8
		},
		{
		0x622e,
		0xc2be
		},
		{
		0x6230,
		0xd5bd
		},
		{
		0x6232,
		0xcfb7
		},
		{
		0x6233,
		0xb4c1
		},
		{
		0x6234,
		0xb4f7
		},
		{
		0x6237,
		0xbba7
		},
		{
		0x623d,
		0xece6
		},
		{
		0x623e,
		0xece5
		},
		{
		0x623f,
		0xb7bf
		},
		{
		0x6240,
		0xcbf9
		},
		{
		0x6241,
		0xb1e2
		},
		{
		0x6243,
		0xece7
		},
		{
		0x6247,
		0xc9c8
		},
		{
		0x6248,
		0xece8
		},
		{
		0x6249,
		0xece9
		},
		{
		0x624b,
		0xcad6
		},
		{
		0x624c,
		0xded0
		},
		{
		0x624d,
		0xb2c5
		},
		{
		0x624e,
		0xd4fa
		},
		{
		0x6251,
		0xf8de
		},
		{
		0x6252,
		0xb0c7
		},
		{
		0x6253,
		0xb4f2
		},
		{
		0x6254,
		0xc8d3
		},
		{
		0x6258,
		0xcdd0
		},
		{
		0x625b,
		0xbfb8
		},
		{
		0x6263,
		0xbfdb
		},
		{
		0x6266,
		0xc7a4
		},
		{
		0x626d,
		0xc5a4
		},
		{
		0x626e,
		0xb0e7
		},
		{
		0x626f,
		0xb3b6
		},
		{
		0x6273,
		0xb0e2
		},
		{
		0x6276,
		0xb7f6
		},
		{
		0x6279,
		0xc5fa
		},
		{
		0x627c,
		0xb6f3
		},
		{
		0x627e,
		0xd5d2
		},
		{
		0x627f,
		0xb3d0
		},
		{
		0x6280,
		0xbcbc
		},
		{
		0x6284,
		0xb3ad
		},
		{
		0x6289,
		0xbef1
		},
		{
		0x628a,
		0xb0d1
		},
		{
		0x6291,
		0xd2d6
		},
		{
		0x6292,
		0xcae3
		},
		{
		0x6293,
		0xd7a5
		},
		{
		0x6295,
		0xcdb6
		},
		{
		0x6296,
		0xb6b6
		},
		{
		0x6297,
		0xbfb9
		},
		{
		0x6298,
		0xd5db
		},
		{
		0x629b,
		0xc5d7
		},
		{
		0x62a8,
		0xc5ea
		},
		{
		0x62ab,
		0xc5fb
		},
		{
		0x62ac,
		0xcca7
		},
		{
		0x62b1,
		0xb1a7
		},
		{
		0x62b5,
		0xb5d6
		},
		{
		0x62b9,
		0xc4a8
		},
		{
		0x62bb,
		0xded3
		},
		{
		0x62bc,
		0xd1ba
		},
		{
		0x62bd,
		0xb3e9
		},
		{
		0x62bf,
		0xc3f2
		},
		{
		0x62c2,
		0xb7f7
		},
		{
		0x62c4,
		0xd6f4
		},
		{
		0x62c6,
		0xb2f0
		},
		{
		0x62c7,
		0xc4b4
		},
		{
		0x62c8,
		0xc4e9
		},
		{
		0x62c9,
		0xc0ad
		},
		{
		0x62ca,
		0xded4
		},
		{
		0x62cc,
		0xb0e8
		},
		{
		0x62cd,
		0xc5c4
		},
		{
		0x62ce,
		0xc1e0
		},
		{
		0x62d0,
		0xb9d5
		},
		{
		0x62d2,
		0xbedc
		},
		{
		0x62d3,
		0xcdd8
		},
		{
		0x62d4,
		0xb0ce
		},
		{
		0x62d6,
		0xcdcf
		},
		{
		0x62d7,
		0xded6
		},
		{
		0x62d8,
		0xbed0
		},
		{
		0x62d9,
		0xd7be
		},
		{
		0x62da,
		0xded5
		},
		{
		0x62db,
		0xd5d0
		},
		{
		0x62dc,
		0xb0dd
		},
		{
		0x62ec,
		0xc0a8
		},
		{
		0x62ed,
		0xcac3
		},
		{
		0x62ee,
		0xded7
		},
		{
		0x62ef,
		0xd5fc
		},
		{
		0x62f1,
		0xb9b0
		},
		{
		0x62f3,
		0xc8ad
		},
		{
		0x62f4,
		0xcba9
		},
		{
		0x62f6,
		0xded9
		},
		{
		0x62f7,
		0xbfbd
		},
		{
		0x62fc,
		0xc6b4
		},
		{
		0x62fd,
		0xd7a7
		},
		{
		0x62fe,
		0xcab0
		},
		{
		0x62ff,
		0xc4c3
		},
		{
		0x6301,
		0xb3d6
		},
		{
		0x6302,
		0xb9d2
		},
		{
		0x6307,
		0xd6b8
		},
		{
		0x6308,
		0xeafc
		},
		{
		0x6309,
		0xb0b4
		},
		{
		0x630e,
		0xbfe6
		},
		{
		0x6311,
		0xccf4
		},
		{
		0x6316,
		0xcdda
		},
		{
		0x6328,
		0xb0a4
		},
		{
		0x632a,
		0xc5b2
		},
		{
		0x632b,
		0xb4ec
		},
		{
		0x632f,
		0xd5f1
		},
		{
		0x6332,
		0xeafd
		},
		{
		0x6339,
		0xdeda
		},
		{
		0x633a,
		0xcda6
		},
		{
		0x633d,
		0xcdec
		},
		{
		0x633e,
		0xd0ae
		},
		{
		0x6342,
		0xcee6
		},
		{
		0x6343,
		0xdedc
		},
		{
		0x6345,
		0xcdb1
		},
		{
		0x6346,
		0xc0a6
		},
		{
		0x6349,
		0xd7bd
		},
		{
		0x634b,
		0xdedb
		},
		{
		0x634c,
		0xb0c6
		},
		{
		0x634d,
		0xbab4
		},
		{
		0x634e,
		0xc9d3
		},
		{
		0x634f,
		0xc4f3
		},
		{
		0x6350,
		0xbee8
		},
		{
		0x6355,
		0xb2b6
		},
		{
		0x6367,
		0xc5f5
		},
		{
		0x6368,
		0xc9e1
		},
		{
		0x6369,
		0xdee6
		},
		{
		0x636b,
		0xded1
		},
		{
		0x636d,
		0xdee3
		},
		{
		0x636e,
		0xf8c6
		},
		{
		0x6371,
		0xdedf
		},
		{
		0x6372,
		0xf8c7
		},
		{
		0x6376,
		0xb4b7
		},
		{
		0x6377,
		0xbddd
		},
		{
		0x637a,
		0xdee0
		},
		{
		0x637b,
		0xc4ed
		},
		{
		0x6380,
		0xcfc6
		},
		{
		0x6382,
		0xb5e0
		},
		{
		0x6383,
		0xc9a8
		},
		{
		0x6384,
		0xc2d5
		},
		{
		0x6387,
		0xb6de
		},
		{
		0x6388,
		0xcada
		},
		{
		0x6389,
		0xb5f4
		},
		{
		0x638a,
		0xdee5
		},
		{
		0x638c,
		0xd5c6
		},
		{
		0x638e,
		0xdee1
		},
		{
		0x638f,
		0xcccd
		},
		{
		0x6390,
		0xc6fe
		},
		{
		0x6392,
		0xc5c5
		},
		{
		0x6396,
		0xd2b4
		},
		{
		0x6398,
		0xbef2
		},
		{
		0x6399,
		0xd5f5
		},
		{
		0x63a0,
		0xc2d3
		},
		{
		0x63a2,
		0xccbd
		},
		{
		0x63a3,
		0xb3b8
		},
		{
		0x63a5,
		0xbdd3
		},
		{
		0x63a7,
		0xbfd8
		},
		{
		0x63a8,
		0xcdc6
		},
		{
		0x63a9,
		0xd1da
		},
		{
		0x63aa,
		0xb4eb
		},
		{
		0x63ac,
		0xdee4
		},
		{
		0x63ad,
		0xdedd
		},
		{
		0x63ae,
		0xdee7
		},
		{
		0x63b0,
		0xeafe
		},
		{
		0x63be,
		0xdef2
		},
		{
		0x63c0,
		0xbcf0
		},
		{
		0x63c4,
		0xdeed
		},
		{
		0x63c6,
		0xdef1
		},
		{
		0x63c9,
		0xc8e0
		},
		{
		0x63cd,
		0xd7e1
		},
		{
		0x63ce,
		0xdeef
		},
		{
		0x63cf,
		0xc3e8
		},
		{
		0x63d0,
		0xcce1
		},
		{
		0x63d2,
		0xb2e5
		},
		{
		0x63d6,
		0xd2be
		},
		{
		0x63da,
		0xd1ef
		},
		{
		0x63db,
		0xbbbb
		},
		{
		0x63de,
		0xdeee
		},
		{
		0x63e0,
		0xdeeb
		},
		{
		0x63e1,
		0xced5
		},
		{
		0x63e3,
		0xb4a7
		},
		{
		0x63e9,
		0xbfab
		},
		{
		0x63ea,
		0xbebe
		},
		{
		0x63ed,
		0xbdd2
		},
		{
		0x63ee,
		0xbbd3
		},
		{
		0x63f2,
		0xdee9
		},
		{
		0x63f4,
		0xd4ae
		},
		{
		0x63f6,
		0xdede
		},
		{
		0x63f8,
		0xdeea
		},
		{
		0x640b,
		0xdef5
		},
		{
		0x640c,
		0xdef8
		},
		{
		0x640d,
		0xcbf0
		},
		{
		0x640f,
		0xb2ab
		},
		{
		0x6410,
		0xb4a4
		},
		{
		0x6413,
		0xb4ea
		},
		{
		0x6414,
		0xc9a6
		},
		{
		0x6417,
		0xb5b7
		},
		{
		0x641b,
		0xdef6
		},
		{
		0x641c,
		0xcbd1
		},
		{
		0x641e,
		0xb8e3
		},
		{
		0x6420,
		0xdef7
		},
		{
		0x6421,
		0xdefa
		},
		{
		0x6426,
		0xdef9
		},
		{
		0x642a,
		0xccc2
		},
		{
		0x642c,
		0xb0e1
		},
		{
		0x642d,
		0xb4ee
		},
		{
		0x6434,
		0xe5ba
		},
		{
		0x6436,
		0xc7c0
		},
		{
		0x643a,
		0xd0af
		},
		{
		0x643d,
		0xb2eb
		},
		{
		0x643f,
		0xeba1
		},
		{
		0x6441,
		0xdef4
		},
		{
		0x6447,
		0xd2a1
		},
		{
		0x6451,
		0xdee2
		},
		{
		0x6452,
		0xdef0
		},
		{
		0x6454,
		0xcba4
		},
		{
		0x6458,
		0xd5aa
		},
		{
		0x645c,
		0xdee8
		},
		{
		0x645e,
		0xdefb
		},
		{
		0x645f,
		0xc2a7
		},
		{
		0x6467,
		0xb4dd
		},
		{
		0x6469,
		0xc4a6
		},
		{
		0x646d,
		0xdefd
		},
		{
		0x646f,
		0xd6bf
		},
		{
		0x6473,
		0xbfd9
		},
		{
		0x6476,
		0xded2
		},
		{
		0x6478,
		0xc3fe
		},
		{
		0x6479,
		0xc4a1
		},
		{
		0x647a,
		0xdfa1
		},
		{
		0x647b,
		0xb2f4
		},
		{
		0x6482,
		0xc1cc
		},
		{
		0x6485,
		0xbeef
		},
		{
		0x6487,
		0xc6b2
		},
		{
		0x6488,
		0xc0cc
		},
		{
		0x6491,
		0xb3c5
		},
		{
		0x6492,
		0xc8f6
		},
		{
		0x6493,
		0xc4d3
		},
		{
		0x6495,
		0xcbba
		},
		{
		0x6496,
		0xdefe
		},
		{
		0x6499,
		0xdfa4
		},
		{
		0x649e,
		0xd7b2
		},
		{
		0x649f,
		0xded8
		},
		{
		0x64a3,
		0xb5a7
		},
		{
		0x64a4,
		0xb3b7
		},
		{
		0x64a5,
		0xb2a6
		},
		{
		0x64a9,
		0xc1c3
		},
		{
		0x64ab,
		0xb8a7
		},
		{
		0x64ac,
		0xc7cb
		},
		{
		0x64ad,
		0xb2a5
		},
		{
		0x64ae,
		0xb4e9
		},
		{
		0x64b0,
		0xd7ab
		},
		{
		0x64b2,
		0xc6cb
		},
		{
		0x64b3,
		0xdeec
		},
		{
		0x64bb,
		0xcca2
		},
		{
		0x64bc,
		0xbab3
		},
		{
		0x64be,
		0xcece
		},
		{
		0x64bf,
		0xbcf1
		},
		{
		0x64c0,
		0xdfa6
		},
		{
		0x64c1,
		0xd3b5
		},
		{
		0x64c2,
		0xc0de
		},
		{
		0x64c4,
		0xc2b0
		},
		{
		0x64c5,
		0xc9c3
		},
		{
		0x64c7,
		0xd4f1
		},
		{
		0x64ca,
		0xbbf7
		},
		{
		0x64cb,
		0xb5b2
		},
		{
		0x64cd,
		0xb2d9
		},
		{
		0x64ce,
		0xc7e6
		},
		{
		0x64d0,
		0xdfa7
		},
		{
		0x64d2,
		0xc7dc
		},
		{
		0x64d4,
		0xb5a3
		},
		{
		0x64d7,
		0xdfa8
		},
		{
		0x64d8,
		0xeba2
		},
		{
		0x64da,
		0xbedd
		},
		{
		0x64e0,
		0xbcb7
		},
		{
		0x64e2,
		0xdfaa
		},
		{
		0x64e4,
		0xdfa9
		},
		{
		0x64e6,
		0xb2c1
		},
		{
		0x64ec,
		0xc4e2
		},
		{
		0x64ef,
		0xb1f7
		},
		{
		0x64f0,
		0xc5a1
		},
		{
		0x64f1,
		0xb8e9
		},
		{
		0x64f2,
		0xd6c0
		},
		{
		0x64f4,
		0xc0a9
		},
		{
		0x64f7,
		0xdfa2
		},
		{
		0x64fa,
		0xb0da
		},
		{
		0x64fb,
		0xcbd3
		},
		{
		0x64fc,
		0xdfa3
		},
		{
		0x64fe,
		0xc8c5
		},
		{
		0x6500,
		0xc5ca
		},
		{
		0x6504,
		0xdef3
		},
		{
		0x6506,
		0xc4ec
		},
		{
		0x6509,
		0xdfab
		},
		{
		0x650f,
		0xc2a3
		},
		{
		0x6514,
		0xc0b9
		},
		{
		0x6516,
		0xdefc
		},
		{
		0x6518,
		0xc8c1
		},
		{
		0x6519,
		0xb2f3
		},
		{
		0x651b,
		0xdfa5
		},
		{
		0x651d,
		0xc9e3
		},
		{
		0x6522,
		0xd4dc
		},
		{
		0x6523,
		0xc2ce
		},
		{
		0x6524,
		0xccaf
		},
		{
		0x6525,
		0xdfac
		},
		{
		0x652a,
		0xbdc1
		},
		{
		0x652b,
		0xbef0
		},
		{
		0x652c,
		0xc0bf
		},
		{
		0x652e,
		0xdfad
		},
		{
		0x652f,
		0xd6a7
		},
		{
		0x6534,
		0xeab7
		},
		{
		0x6535,
		0xebb6
		},
		{
		0x6536,
		0xcad5
		},
		{
		0x6538,
		0xd8fc
		},
		{
		0x6539,
		0xb8c4
		},
		{
		0x653b,
		0xb9a5
		},
		{
		0x653e,
		0xb7c5
		},
		{
		0x653f,
		0xd5fe
		},
		{
		0x6545,
		0xb9ca
		},
		{
		0x6548,
		0xd0a7
		},
		{
		0x6549,
		0xf4cd
		},
		{
		0x654f,
		0xc3f4
		},
		{
		0x6551,
		0xbec8
		},
		{
		0x6555,
		0xebb7
		},
		{
		0x6556,
		0xb0bd
		},
		{
		0x6557,
		0xb0dc
		},
		{
		0x6559,
		0xbdcc
		},
		{
		0x655d,
		0xb1d6
		},
		{
		0x655e,
		0xb3a8
		},
		{
		0x6562,
		0xb8d2
		},
		{
		0x6563,
		0xc9a2
		},
		{
		0x6566,
		0xb6d8
		},
		{
		0x656b,
		0xebb8
		},
		{
		0x656c,
		0xbeb4
		},
		{
		0x6572,
		0xc7c3
		},
		{
		0x6574,
		0xd5fb
		},
		{
		0x6575,
		0xb5d0
		},
		{
		0x6577,
		0xb7f3
		},
		{
		0x6578,
		0xcafd
		},
		{
		0x6582,
		0xc1b2
		},
		{
		0x6583,
		0xb1d0
		},
		{
		0x6587,
		0xcec4
		},
		{
		0x658c,
		0xb1f3
		},
		{
		0x6590,
		0xecb3
		},
		{
		0x6591,
		0xb0df
		},
		{
		0x6595,
		0xecb5
		},
		{
		0x6597,
		0xf8af
		},
		{
		0x6599,
		0xc1cf
		},
		{
		0x659b,
		0xf5fa
		},
		{
		0x659c,
		0xd0b1
		},
		{
		0x659f,
		0xd5e5
		},
		{
		0x65a1,
		0xced3
		},
		{
		0x65a4,
		0xbdef
		},
		{
		0x65a5,
		0xb3e2
		},
		{
		0x65a7,
		0xb8ab
		},
		{
		0x65ab,
		0xedbd
		},
		{
		0x65ac,
		0xd5b6
		},
		{
		0x65af,
		0xcbb9
		},
		{
		0x65b0,
		0xd0c2
		},
		{
		0x65b7,
		0xb6cf
		},
		{
		0x65b9,
		0xb7bd
		},
		{
		0x65bc,
		0xecb6
		},
		{
		0x65bd,
		0xcaa9
		},
		{
		0x65c1,
		0xc5d4
		},
		{
		0x65c3,
		0xecb9
		},
		{
		0x65c4,
		0xecb8
		},
		{
		0x65c5,
		0xc2c3
		},
		{
		0x65c6,
		0xecb7
		},
		{
		0x65cb,
		0xd0fd
		},
		{
		0x65cc,
		0xecba
		},
		{
		0x65ce,
		0xecbb
		},
		{
		0x65cf,
		0xd7e5
		},
		{
		0x65d2,
		0xecbc
		},
		{
		0x65d6,
		0xecbd
		},
		{
		0x65d7,
		0xc6ec
		},
		{
		0x65e2,
		0xbcc8
		},
		{
		0x65e5,
		0xc8d5
		},
		{
		0x65e6,
		0xb5a9
		},
		{
		0x65e8,
		0xd6bc
		},
		{
		0x65e9,
		0xd4e7
		},
		{
		0x65ec,
		0xd1ae
		},
		{
		0x65ed,
		0xd0f1
		},
		{
		0x65ee,
		0xeab8
		},
		{
		0x65ef,
		0xeab9
		},
		{
		0x65f0,
		0xeaba
		},
		{
		0x65f1,
		0xbab5
		},
		{
		0x65fa,
		0xcdfa
		},
		{
		0x6600,
		0xeac0
		},
		{
		0x6602,
		0xb0ba
		},
		{
		0x6603,
		0xeabe
		},
		{
		0x6606,
		0xc0a5
		},
		{
		0x660a,
		0xeabb
		},
		{
		0x660c,
		0xb2fd
		},
		{
		0x660e,
		0xc3f7
		},
		{
		0x660f,
		0xbbe8
		},
		{
		0x6613,
		0xd2d7
		},
		{
		0x6614,
		0xcef4
		},
		{
		0x6615,
		0xeabf
		},
		{
		0x661d,
		0xeac3
		},
		{
		0x661f,
		0xd0c7
		},
		{
		0x6620,
		0xd3b3
		},
		{
		0x6625,
		0xb4ba
		},
		{
		0x6627,
		0xc3c1
		},
		{
		0x6628,
		0xd7f2
		},
		{
		0x662d,
		0xd5d1
		},
		{
		0x662f,
		0xcac7
		},
		{
		0x6631,
		0xeac5
		},
		{
		0x6634,
		0xeac4
		},
		{
		0x6635,
		0xeac7
		},
		{
		0x6636,
		0xeac6
		},
		{
		0x6641,
		0xeacb
		},
		{
		0x6642,
		0xcab1
		},
		{
		0x6643,
		0xbbce
		},
		{
		0x6649,
		0xbdfa
		},
		{
		0x664c,
		0xc9ce
		},
		{
		0x664f,
		0xeacc
		},
		{
		0x6657,
		0xeacf
		},
		{
		0x665a,
		0xcded
		},
		{
		0x665d,
		0xd6e7
		},
		{
		0x665f,
		0xeac9
		},
		{
		0x6661,
		0xeace
		},
		{
		0x6664,
		0xceee
		},
		{
		0x6666,
		0xbbde
		},
		{
		0x6668,
		0xb3bf
		},
		{
		0x666e,
		0xc6d5
		},
		{
		0x666f,
		0xbeb0
		},
		{
		0x6670,
		0xcefa
		},
		{
		0x6674,
		0xc7e7
		},
		{
		0x6676,
		0xbea7
		},
		{
		0x6677,
		0xead0
		},
		{
		0x667a,
		0xd6c7
		},
		{
		0x667e,
		0xc1c0
		},
		{
		0x6684,
		0xead1
		},
		{
		0x6687,
		0xcfbe
		},
		{
		0x6688,
		0xd4ce
		},
		{
		0x6689,
		0xeacd
		},
		{
		0x668c,
		0xead2
		},
		{
		0x6691,
		0xcaee
		},
		{
		0x6696,
		0xc5af
		},
		{
		0x6697,
		0xb0b5
		},
		{
		0x669d,
		0xead4
		},
		{
		0x66a2,
		0xb3a9
		},
		{
		0x66a8,
		0xf4df
		},
		{
		0x66ab,
		0xd4dd
		},
		{
		0x66ae,
		0xc4ba
		},
		{
		0x66b4,
		0xb1a9
		},
		{
		0x66b9,
		0xe5df
		},
		{
		0x66be,
		0xead5
		},
		{
		0x66c4,
		0xeaca
		},
		{
		0x66c6,
		0xf8cf
		},
		{
		0x66c7,
		0xeabc
		},
		{
		0x66c9,
		0xcffe
		},
		{
		0x66d6,
		0xead3
		},
		{
		0x66d9,
		0xcaef
		},
		{
		0x66db,
		0xead6
		},
		{
		0x66dc,
		0xead7
		},
		{
		0x66dd,
		0xc6d8
		},
		{
		0x66e0,
		0xbff5
		},
		{
		0x66e6,
		0xead8
		},
		{
		0x66e9,
		0xead9
		},
		{
		0x66ec,
		0xc9b9
		},
		{
		0x66f0,
		0xd4bb
		},
		{
		0x66f2,
		0xc7fa
		},
		{
		0x66f3,
		0xd2b7
		},
		{
		0x66f4,
		0xb8fc
		},
		{
		0x66f7,
		0xeac2
		},
		{
		0x66f8,
		0xcae9
		},
		{
		0x66f9,
		0xb2dc
		},
		{
		0x66fc,
		0xc2fc
		},
		{
		0x66fe,
		0xd4f8
		},
		{
		0x66ff,
		0xcce6
		},
		{
		0x6700,
		0xd7ee
		},
		{
		0x6703,
		0xbbe1
		},
		{
		0x6708,
		0xd4c2
		},
		{
		0x6709,
		0xd3d0
		},
		{
		0x670a,
		0xebc3
		},
		{
		0x670b,
		0xc5f3
		},
		{
		0x670d,
		0xb7fe
		},
		{
		0x6710,
		0xebd4
		},
		{
		0x6714,
		0xcbb7
		},
		{
		0x6715,
		0xebde
		},
		{
		0x6717,
		0xc0ca
		},
		{
		0x671b,
		0xcdfb
		},
		{
		0x671d,
		0xb3af
		},
		{
		0x671f,
		0xc6da
		},
		{
		0x6726,
		0xebfc
		},
		{
		0x6727,
		0xebca
		},
		{
		0x6728,
		0xc4be
		},
		{
		0x672a,
		0xceb4
		},
		{
		0x672b,
		0xc4a9
		},
		{
		0x672c,
		0xb1be
		},
		{
		0x672d,
		0xd4fd
		},
		{
		0x672f,
		0xf8e8
		},
		{
		0x6731,
		0xd6ec
		},
		{
		0x6734,
		0xf8e0
		},
		{
		0x6735,
		0xb6e4
		},
		{
		0x673d,
		0xd0e0
		},
		{
		0x6746,
		0xb8cb
		},
		{
		0x6748,
		0xe8be
		},
		{
		0x6749,
		0xc9bc
		},
		{
		0x674c,
		0xe8bb
		},
		{
		0x674e,
		0xc0ee
		},
		{
		0x674f,
		0xd0d3
		},
		{
		0x6750,
		0xb2c4
		},
		{
		0x6751,
		0xb4e5
		},
		{
		0x6753,
		0xe8bc
		},
		{
		0x6756,
		0xd5c8
		},
		{
		0x675c,
		0xb6c5
		},
		{
		0x675e,
		0xe8bd
		},
		{
		0x675f,
		0xcaf8
		},
		{
		0x6760,
		0xb8dc
		},
		{
		0x676a,
		0xe8c2
		},
		{
		0x676d,
		0xbabc
		},
		{
		0x676f,
		0xb1ad
		},
		{
		0x6770,
		0xbddc
		},
		{
		0x6771,
		0xb6ab
		},
		{
		0x6772,
		0xeabd
		},
		{
		0x6773,
		0xe8c3
		},
		{
		0x6775,
		0xe8c6
		},
		{
		0x6777,
		0xe8cb
		},
		{
		0x677c,
		0xe8cc
		},
		{
		0x677e,
		0xf8e9
		},
		{
		0x677f,
		0xb0e5
		},
		{
		0x6787,
		0xe8c1
		},
		{
		0x6789,
		0xcdf7
		},
		{
		0x678b,
		0xe8ca
		},
		{
		0x6790,
		0xcef6
		},
		{
		0x6795,
		0xd5ed
		},
		{
		0x6797,
		0xc1d6
		},
		{
		0x6798,
		0xe8c4
		},
		{
		0x679a,
		0xc3b6
		},
		{
		0x679c,
		0xb9fb
		},
		{
		0x679d,
		0xd6a6
		},
		{
		0x67af,
		0xbfdd
		},
		{
		0x67b0,
		0xe8d2
		},
		{
		0x67b3,
		0xe8d7
		},
		{
		0x67b5,
		0xe8d5
		},
		{
		0x67b6,
		0xbcdc
		},
		{
		0x67b7,
		0xbccf
		},
		{
		0x67b8,
		0xe8db
		},
		{
		0x67c1,
		0xe8de
		},
		{
		0x67c3,
		0xe8da
		},
		{
		0x67c4,
		0xb1fa
		},
		{
		0x67cf,
		0xb0d8
		},
		{
		0x67d0,
		0xc4b3
		},
		{
		0x67d1,
		0xb8cc
		},
		{
		0x67d2,
		0xc6e2
		},
		{
		0x67d3,
		0xc8be
		},
		{
		0x67d4,
		0xc8e1
		},
		{
		0x67d8,
		0xe8cf
		},
		{
		0x67d9,
		0xe8d4
		},
		{
		0x67da,
		0xe8d6
		},
		{
		0x67dd,
		0xe8d8
		},
		{
		0x67de,
		0xd7f5
		},
		{
		0x67e2,
		0xe8dc
		},
		{
		0x67e5,
		0xb2e9
		},
		{
		0x67e9,
		0xe8d1
		},
		{
		0x67ec,
		0xbced
		},
		{
		0x67ef,
		0xbfc2
		},
		{
		0x67f0,
		0xe8cd
		},
		{
		0x67f1,
		0xd6f9
		},
		{
		0x67f3,
		0xc1f8
		},
		{
		0x67f4,
		0xb2f1
		},
		{
		0x67ff,
		0xcac1
		},
		{
		0x6800,
		0xe8d9
		},
		{
		0x6805,
		0xd5a4
		},
		{
		0x6813,
		0xcba8
		},
		{
		0x6817,
		0xc0f5
		},
		{
		0x681d,
		0xe8e9
		},
		{
		0x6821,
		0xd0a3
		},
		{
		0x6829,
		0xe8f2
		},
		{
		0x682a,
		0xd6ea
		},
		{
		0x6832,
		0xe8e0
		},
		{
		0x6833,
		0xe8e1
		},
		{
		0x6838,
		0xbacb
		},
		{
		0x6839,
		0xb8f9
		},
		{
		0x683c,
		0xb8f1
		},
		{
		0x683d,
		0xd4d4
		},
		{
		0x6840,
		0xe8ee
		},
		{
		0x6841,
		0xe8ec
		},
		{
		0x6842,
		0xb9f0
		},
		{
		0x6843,
		0xccd2
		},
		{
		0x6844,
		0xe8e6
		},
		{
		0x6845,
		0xcea6
		},
		{
		0x6846,
		0xbff2
		},
		{
		0x6848,
		0xb0b8
		},
		{
		0x6849,
		0xe8f1
		},
		{
		0x684a,
		0xe8f0
		},
		{
		0x684c,
		0xd7c0
		},
		{
		0x684e,
		0xe8e4
		},
		{
		0x6850,
		0xcda9
		},
		{
		0x6851,
		0xc9a3
		},
		{
		0x6853,
		0xbbb8
		},
		{
		0x6854,
		0xbddb
		},
		{
		0x6855,
		0xe8ea
		},
		{
		0x686b,
		0xe8f8
		},
		{
		0x6874,
		0xe8f5
		},
		{
		0x6876,
		0xcdb0
		},
		{
		0x6877,
		0xe8f6
		},
		{
		0x6881,
		0xc1ba
		},
		{
		0x6883,
		0xe8e8
		},
		{
		0x6885,
		0xc3b7
		},
		{
		0x6886,
		0xb0f0
		},
		{
		0x688f,
		0xe8f4
		},
		{
		0x6893,
		0xe8f7
		},
		{
		0x6897,
		0xb9a3
		},
		{
		0x6898,
		0xe8c5
		},
		{
		0x689d,
		0xccf5
		},
		{
		0x689f,
		0xe8c9
		},
		{
		0x68a2,
		0xc9d2
		},
		{
		0x68a7,
		0xcee0
		},
		{
		0x68a8,
		0xc0e6
		},
		{
		0x68ad,
		0xcbf3
		},
		{
		0x68af,
		0xccdd
		},
		{
		0x68b0,
		0xd0b5
		},
		{
		0x68b3,
		0xcae1
		},
		{
		0x68b5,
		0xe8f3
		},
		{
		0x68c4,
		0xc6fa
		},
		{
		0x68c9,
		0xc3de
		},
		{
		0x68cb,
		0xc6e5
		},
		{
		0x68cd,
		0xb9f7
		},
		{
		0x68d2,
		0xb0f4
		},
		{
		0x68d5,
		0xd7d8
		},
		{
		0x68d6,
		0xe8c7
		},
		{
		0x68d7,
		0xd4e6
		},
		{
		0x68d8,
		0xbcac
		},
		{
		0x68da,
		0xc5ef
		},
		{
		0x68df,
		0xb6b0
		},
		{
		0x68e0,
		0xccc4
		},
		{
		0x68e3,
		0xe9a6
		},
		{
		0x68e7,
		0xd5bb
		},
		{
		0x68ee,
		0xc9ad
		},
		{
		0x68f0,
		0xe9a2
		},
		{
		0x68f1,
		0xc0e2
		},
		{
		0x68f2,
		0xc6dc
		},
		{
		0x68f5,
		0xbfc3
		},
		{
		0x68f9,
		0xe8fe
		},
		{
		0x68fa,
		0xb9d7
		},
		{
		0x68fc,
		0xe8fb
		},
		{
		0x6901,
		0xe9a4
		},
		{
		0x6905,
		0xd2ce
		},
		{
		0x690b,
		0xe9a3
		},
		{
		0x690d,
		0xd6b2
		},
		{
		0x690e,
		0xd7b5
		},
		{
		0x690f,
		0xe8e2
		},
		{
		0x6910,
		0xe9a7
		},
		{
		0x6912,
		0xbdb7
		},
		{
		0x6930,
		0xd2ac
		},
		{
		0x6934,
		0xe9b2
		},
		{
		0x6939,
		0xe9a9
		},
		{
		0x693d,
		0xb4aa
		},
		{
		0x693f,
		0xb4bb
		},
		{
		0x6942,
		0xe9ab
		},
		{
		0x694a,
		0xd1ee
		},
		{
		0x6953,
		0xb7e3
		},
		{
		0x6954,
		0xd0a8
		},
		{
		0x6957,
		0xe9a5
		},
		{
		0x695a,
		0xb3fe
		},
		{
		0x695d,
		0xe9ac
		},
		{
		0x695e,
		0xc0e3
		},
		{
		0x6960,
		0xe9aa
		},
		{
		0x6963,
		0xe9b9
		},
		{
		0x6966,
		0xe9b8
		},
		{
		0x6968,
		0xe8e5
		},
		{
		0x696b,
		0xe9ae
		},
		{
		0x696d,
		0xd2b5
		},
		{
		0x696e,
		0xe8fa
		},
		{
		0x6971,
		0xe9a8
		},
		{
		0x6975,
		0xbcab
		},
		{
		0x6977,
		0xbfac
		},
		{
		0x6978,
		0xe9b1
		},
		{
		0x6979,
		0xe9ba
		},
		{
		0x6980,
		0xe9af
		},
		{
		0x6982,
		0xb8c5
		},
		{
		0x6986,
		0xd3dc
		},
		{
		0x698d,
		0xe9c7
		},
		{
		0x6994,
		0xc0c6
		},
		{
		0x6995,
		0xe9c5
		},
		{
		0x6998,
		0xe9b0
		},
		{
		0x699b,
		0xe9bb
		},
		{
		0x699c,
		0xb0f1
		},
		{
		0x69a7,
		0xe9bc
		},
		{
		0x69a8,
		0xd5a5
		},
		{
		0x69aa,
		0xe8bf
		},
		{
		0x69ab,
		0xe9be
		},
		{
		0x69ad,
		0xe9bf
		},
		{
		0x69ae,
		0xc8d9
		},
		{
		0x69b1,
		0xe9c1
		},
		{
		0x69b4,
		0xc1f1
		},
		{
		0x69b7,
		0xc8b6
		},
		{
		0x69bb,
		0xe9bd
		},
		{
		0x69bf,
		0xe8e7
		},
		{
		0x69c1,
		0xe9c2
		},
		{
		0x69ca,
		0xe9c3
		},
		{
		0x69cb,
		0xb9b9
		},
		{
		0x69cc,
		0xe9b3
		},
		{
		0x69cd,
		0xc7b9
		},
		{
		0x69ce,
		0xe9b6
		},
		{
		0x69d0,
		0xbbb1
		},
		{
		0x69d4,
		0xe9c0
		},
		{
		0x69e7,
		0xe8fd
		},
		{
		0x69ed,
		0xe9ca
		},
		{
		0x69f2,
		0xe9ce
		},
		{
		0x69f3,
		0xbdb0
		},
		{
		0x69fd,
		0xb2db
		},
		{
		0x69ff,
		0xe9c8
		},
		{
		0x6a01,
		0xd7ae
		},
		{
		0x6a02,
		0xc0d6
		},
		{
		0x6a05,
		0xe8c8
		},
		{
		0x6a0a,
		0xb7ae
		},
		{
		0x6a13,
		0xc2a5
		},
		{
		0x6a17,
		0xe9cb
		},
		{
		0x6a18,
		0xe9cc
		},
		{
		0x6a19,
		0xb1ea
		},
		{
		0x6a1e,
		0xcae0
		},
		{
		0x6a1f,
		0xd5c1
		},
		{
		0x6a21,
		0xc4a3
		},
		{
		0x6a23,
		0xd1f9
		},
		{
		0x6a28,
		0xe9d8
		},
		{
		0x6a2a,
		0xbae1
		},
		{
		0x6a35,
		0xe9d4
		},
		{
		0x6a38,
		0xc6d3
		},
		{
		0x6a39,
		0xcaf7
		},
		{
		0x6a3a,
		0xe8eb
		},
		{
		0x6a3d,
		0xe9d7
		},
		{
		0x6a3e,
		0xe9d0
		},
		{
		0x6a44,
		0xe9cf
		},
		{
		0x6a47,
		0xc7c1
		},
		{
		0x6a48,
		0xe8e3
		},
		{
		0x6a4b,
		0xc7c5
		},
		{
		0x6a50,
		0xe9d2
		},
		{
		0x6a58,
		0xe9d9
		},
		{
		0x6a59,
		0xb3c8
		},
		{
		0x6a5b,
		0xe9d3
		},
		{
		0x6a5f,
		0xbbfa
		},
		{
		0x6a61,
		0xcff0
		},
		{
		0x6a62,
		0xcdd6
		},
		{
		0x6a65,
		0xe9cd
		},
		{
		0x6a71,
		0xb3f7
		},
		{
		0x6a80,
		0xccb4
		},
		{
		0x6a84,
		0xcfad
		},
		{
		0x6a89,
		0xe8df
		},
		{
		0x6a8e,
		0xe9d5
		},
		{
		0x6a90,
		0xe9dc
		},
		{
		0x6a91,
		0xe9db
		},
		{
		0x6a94,
		0xb5b5
		},
		{
		0x6a97,
		0xe9de
		},
		{
		0x6a9c,
		0xe8ed
		},
		{
		0x6aa0,
		0xe9d1
		},
		{
		0x6aa2,
		0xbcec
		},
		{
		0x6aa3,
		0xe9c9
		},
		{
		0x6aa9,
		0xe9dd
		},
		{
		0x6aab,
		0xe9df
		},
		{
		0x6aac,
		0xc3ca
		},
		{
		0x6aaf,
		0xf8ed
		},
		{
		0x6ab3,
		0xe9c4
		},
		{
		0x6ab8,
		0xc4fb
		},
		{
		0x6abb,
		0xbcf7
		},
		{
		0x6ac3,
		0xb9f1
		},
		{
		0x6ad3,
		0xe9d6
		},
		{
		0x6ada,
		0xe9b5
		},
		{
		0x6adb,
		0xe8ce
		},
		{
		0x6add,
		0xe8fc
		},
		{
		0x6ade,
		0xe9da
		},
		{
		0x6adf,
		0xe8dd
		},
		{
		0x6ae7,
		0xe9c6
		},
		{
		0x6ae8,
		0xe8d3
		},
		{
		0x6aea,
		0xe8c0
		},
		{
		0x6aec,
		0xe9b4
		},
		{
		0x6af3,
		0xe8d0
		},
		{
		0x6af8,
		0xe9b7
		},
		{
		0x6afb,
		0xd3a3
		},
		{
		0x6b04,
		0xc0b8
		},
		{
		0x6b0a,
		0xc8a8
		},
		{
		0x6b0f,
		0xe9a1
		},
		{
		0x6b12,
		0xe8ef
		},
		{
		0x6b16,
		0xe9ad
		},
		{
		0x6b1e,
		0xe8f9
		},
		{
		0x6b20,
		0xc7b7
		},
		{
		0x6b21,
		0xb4ce
		},
		{
		0x6b23,
		0xd0c0
		},
		{
		0x6b32,
		0xd3fb
		},
		{
		0x6b37,
		0xeca4
		},
		{
		0x6b39,
		0xeca5
		},
		{
		0x6b3a,
		0xc6db
		},
		{
		0x6b3d,
		0xc7d5
		},
		{
		0x6b3e,
		0xbfee
		},
		{
		0x6b43,
		0xeca6
		},
		{
		0x6b46,
		0xeca7
		},
		{
		0x6b47,
		0xd0aa
		},
		{
		0x6b49,
		0xc7b8
		},
		{
		0x6b4c,
		0xb8e8
		},
		{
		0x6b50,
		0xc5b7
		},
		{
		0x6b59,
		0xeca8
		},
		{
		0x6b5f,
		0xeca3
		},
		{
		0x6b61,
		0xbbb6
		},
		{
		0x6b62,
		0xd6b9
		},
		{
		0x6b63,
		0xd5fd
		},
		{
		0x6b64,
		0xb4cb
		},
		{
		0x6b65,
		0xb2bd
		},
		{
		0x6b66,
		0xcee4
		},
		{
		0x6b67,
		0xc6e7
		},
		{
		0x6b6a,
		0xcde1
		},
		{
		0x6b72,
		0xcbea
		},
		{
		0x6b77,
		0xc0fa
		},
		{
		0x6b78,
		0xb9e9
		},
		{
		0x6b79,
		0xb4f5
		},
		{
		0x6b7b,
		0xcbc0
		},
		{
		0x6b81,
		0xe9e2
		},
		{
		0x6b82,
		0xe9e3
		},
		{
		0x6b83,
		0xd1ea
		},
		{
		0x6b84,
		0xe9e5
		},
		{
		0x6b86,
		0xb4f9
		},
		{
		0x6b89,
		0xd1b3
		},
		{
		0x6b8a,
		0xcae2
		},
		{
		0x6b8d,
		0xe9e8
		},
		{
		0x6b96,
		0xd6b3
		},
		{
		0x6b98,
		0xb2d0
		},
		{
		0x6b9b,
		0xe9ea
		},
		{
		0x6b9e,
		0xe9e6
		},
		{
		0x6ba4,
		0xe9e4
		},
		{
		0x6baa,
		0xe9ec
		},
		{
		0x6bab,
		0xe9e9
		},
		{
		0x6bae,
		0xe9e7
		},
		{
		0x6baf,
		0xe9eb
		},
		{
		0x6bb2,
		0xbcdf
		},
		{
		0x6bb3,
		0xecaf
		},
		{
		0x6bb5,
		0xb6ce
		},
		{
		0x6bb7,
		0xd2f3
		},
		{
		0x6bba,
		0xc9b1
		},
		{
		0x6bbb,
		0xbfc7
		},
		{
		0x6bbf,
		0xb5ee
		},
		{
		0x6bc1,
		0xbbd9
		},
		{
		0x6bc5,
		0xd2e3
		},
		{
		0x6bc6,
		0xc5b9
		},
		{
		0x6bcb,
		0xcee3
		},
		{
		0x6bcd,
		0xc4b8
		},
		{
		0x6bcf,
		0xc3bf
		},
		{
		0x6bd2,
		0xb6be
		},
		{
		0x6bd3,
		0xd8b9
		},
		{
		0x6bd4,
		0xb1c8
		},
		{
		0x6bd6,
		0xb1d1
		},
		{
		0x6bd7,
		0xc5fe
		},
		{
		0x6bdb,
		0xc3ab
		},
		{
		0x6bea,
		0xeba4
		},
		{
		0x6beb,
		0xbac1
		},
		{
		0x6bef,
		0xccba
		},
		{
		0x6bf3,
		0xeba5
		},
		{
		0x6bf9,
		0xeba8
		},
		{
		0x6bfd,
		0xeba6
		},
		{
		0x6bff,
		0xeba7
		},
		{
		0x6c05,
		0xeba9
		},
		{
		0x6c06,
		0xebab
		},
		{
		0x6c08,
		0xd5b1
		},
		{
		0x6c0c,
		0xebaa
		},
		{
		0x6c0d,
		0xebac
		},
		{
		0x6c0f,
		0xcacf
		},
		{
		0x6c10,
		0xd8b5
		},
		{
		0x6c11,
		0xc3f1
		},
		{
		0x6c13,
		0xc3a5
		},
		{
		0x6c15,
		0xebad
		},
		{
		0x6c16,
		0xc4ca
		},
		{
		0x6c18,
		0xebae
		},
		{
		0x6c19,
		0xebaf
		},
		{
		0x6c1a,
		0xebb0
		},
		{
		0x6c1b,
		0xb7d5
		},
		{
		0x6c1f,
		0xb7fa
		},
		{
		0x6c21,
		0xebb1
		},
		{
		0x6c23,
		0xc6f8
		},
		{
		0x6c24,
		0xebb3
		},
		{
		0x6c26,
		0xbaa4
		},
		{
		0x6c27,
		0xd1f5
		},
		{
		0x6c28,
		0xb0b1
		},
		{
		0x6c2a,
		0xebb4
		},
		{
		0x6c2b,
		0xc7e2
		},
		{
		0x6c2c,
		0xebb2
		},
		{
		0x6c2e,
		0xb5aa
		},
		{
		0x6c2f,
		0xc2c8
		},
		{
		0x6c30,
		0xc7e8
		},
		{
		0x6c32,
		0xebb5
		},
		{
		0x6c34,
		0xcbae
		},
		{
		0x6c35,
		0xe3df
		},
		{
		0x6c38,
		0xd3c0
		},
		{
		0x6c3d,
		0xd9db
		},
		{
		0x6c40,
		0xcda1
		},
		{
		0x6c41,
		0xd6ad
		},
		{
		0x6c42,
		0xc7f3
		},
		{
		0x6c46,
		0xd9e0
		},
		{
		0x6c4a,
		0xe3e2
		},
		{
		0x6c50,
		0xcfab
		},
		{
		0x6c54,
		0xe3e0
		},
		{
		0x6c55,
		0xc9c7
		},
		{
		0x6c57,
		0xbab9
		},
		{
		0x6c5b,
		0xd1b4
		},
		{
		0x6c5c,
		0xe3e1
		},
		{
		0x6c5d,
		0xc8ea
		},
		{
		0x6c5e,
		0xb9af
		},
		{
		0x6c5f,
		0xbdad
		},
		{
		0x6c60,
		0xb3d8
		},
		{
		0x6c61,
		0xcedb
		},
		{
		0x6c68,
		0xe3e8
		},
		{
		0x6c69,
		0xe3e9
		},
		{
		0x6c6a,
		0xcdf4
		},
		{
		0x6c70,
		0xccad
		},
		{
		0x6c72,
		0xbcb3
		},
		{
		0x6c74,
		0xe3ea
		},
		{
		0x6c76,
		0xe3eb
		},
		{
		0x6c79,
		0xd0da
		},
		{
		0x6c7d,
		0xc6fb
		},
		{
		0x6c7e,
		0xb7da
		},
		{
		0x6c81,
		0xc7df
		},
		{
		0x6c82,
		0xd2ca
		},
		{
		0x6c83,
		0xced6
		},
		{
		0x6c85,
		0xe3e4
		},
		{
		0x6c86,
		0xe3ec
		},
		{
		0x6c88,
		0xc9f2
		},
		{
		0x6c89,
		0xb3c1
		},
		{
		0x6c8c,
		0xe3e7
		},
		{
		0x6c8f,
		0xc6e3
		},
		{
		0x6c90,
		0xe3e5
		},
		{
		0x6c93,
		0xedb3
		},
		{
		0x6c94,
		0xe3e6
		},
		{
		0x6c99,
		0xc9b3
		},
		{
		0x6c9b,
		0xc5e6
		},
		{
		0x6ca1,
		0xc3bb
		},
		{
		0x6cab,
		0xc4ad
		},
		{
		0x6cad,
		0xe3f0
		},
		{
		0x6cae,
		0xbeda
		},
		{
		0x6cb1,
		0xe3fb
		},
		{
		0x6cb2,
		0xe3f5
		},
		{
		0x6cb3,
		0xbad3
		},
		{
		0x6cb8,
		0xb7d0
		},
		{
		0x6cb9,
		0xd3cd
		},
		{
		0x6cbb,
		0xd6ce
		},
		{
		0x6cbc,
		0xd5d3
		},
		{
		0x6cbd,
		0xb9c1
		},
		{
		0x6cbe,
		0xd5b4
		},
		{
		0x6cbf,
		0xd1d8
		},
		{
		0x6cc4,
		0xd0b9
		},
		{
		0x6cc5,
		0xc7f6
		},
		{
		0x6cc9,
		0xc8aa
		},
		{
		0x6cca,
		0xb2b4
		},
		{
		0x6ccc,
		0xc3da
		},
		{
		0x6cd0,
		0xe3ee
		},
		{
		0x6cd3,
		0xe3fc
		},
		{
		0x6cd4,
		0xe3ef
		},
		{
		0x6cd5,
		0xb7a8
		},
		{
		0x6cd6,
		0xe3f7
		},
		{
		0x6cd7,
		0xe3f4
		},
		{
		0x6cdb,
		0xb7ba
		},
		{
		0x6ce0,
		0xe3f6
		},
		{
		0x6ce1,
		0xc5dd
		},
		{
		0x6ce2,
		0xb2a8
		},
		{
		0x6ce3,
		0xc6fc
		},
		{
		0x6ce5,
		0xc4e0
		},
		{
		0x6ce8,
		0xd7a2
		},
		{
		0x6cea,
		0xc0e1
		},
		{
		0x6ceb,
		0xe3f9
		},
		{
		0x6cee,
		0xe3fa
		},
		{
		0x6cef,
		0xe3fd
		},
		{
		0x6cf0,
		0xcca9
		},
		{
		0x6cf1,
		0xe3f3
		},
		{
		0x6cf3,
		0xd3be
		},
		{
		0x6cf5,
		0xb1c3
		},
		{
		0x6d04,
		0xe4a7
		},
		{
		0x6d07,
		0xe4a6
		},
		{
		0x6d0b,
		0xd1f3
		},
		{
		0x6d0c,
		0xe4a3
		},
		{
		0x6d0e,
		0xe4a9
		},
		{
		0x6d17,
		0xcfb4
		},
		{
		0x6d19,
		0xe4a8
		},
		{
		0x6d1a,
		0xe4ae
		},
		{
		0x6d1b,
		0xc2e5
		},
		{
		0x6d1e,
		0xb6b4
		},
		{
		0x6d25,
		0xbdf2
		},
		{
		0x6d27,
		0xe4a2
		},
		{
		0x6d2a,
		0xbae9
		},
		{
		0x6d2b,
		0xe4aa
		},
		{
		0x6d2e,
		0xe4ac
		},
		{
		0x6d31,
		0xb6fd
		},
		{
		0x6d32,
		0xd6de
		},
		{
		0x6d33,
		0xe4b2
		},
		{
		0x6d35,
		0xe4ad
		},
		{
		0x6d39,
		0xe4a1
		},
		{
		0x6d3b,
		0xbbee
		},
		{
		0x6d3d,
		0xc7a2
		},
		{
		0x6d3e,
		0xc5c9
		},
		{
		0x6d41,
		0xc1f7
		},
		{
		0x6d59,
		0xd5e3
		},
		{
		0x6d5a,
		0xbfa3
		},
		{
		0x6d5c,
		0xe4ba
		},
		{
		0x6d5e,
		0xe4b7
		},
		{
		0x6d60,
		0xe4bb
		},
		{
		0x6d63,
		0xe4bd
		},
		{
		0x6d66,
		0xc6d6
		},
		{
		0x6d69,
		0xbac6
		},
		{
		0x6d6a,
		0xc0cb
		},
		{
		0x6d6e,
		0xb8a1
		},
		{
		0x6d6f,
		0xe4b4
		},
		{
		0x6d74,
		0xd4a1
		},
		{
		0x6d77,
		0xbaa3
		},
		{
		0x6d78,
		0xbdfe
		},
		{
		0x6d79,
		0xe4a4
		},
		{
		0x6d7c,
		0xe4bc
		},
		{
		0x6d82,
		0xf8ef
		},
		{
		0x6d85,
		0xc4f9
		},
		{
		0x6d87,
		0xe3fe
		},
		{
		0x6d88,
		0xcffb
		},
		{
		0x6d89,
		0xc9e6
		},
		{
		0x6d8c,
		0xd3bf
		},
		{
		0x6d8e,
		0xcfd1
		},
		{
		0x6d91,
		0xe4b3
		},
		{
		0x6d93,
		0xe4b8
		},
		{
		0x6d94,
		0xe4b9
		},
		{
		0x6d95,
		0xcce9
		},
		{
		0x6daa,
		0xb8a2
		},
		{
		0x6dab,
		0xe4ca
		},
		{
		0x6dae,
		0xe4cc
		},
		{
		0x6daf,
		0xd1c4
		},
		{
		0x6db2,
		0xd2ba
		},
		{
		0x6db5,
		0xbaad
		},
		{
		0x6db8,
		0xbad4
		},
		{
		0x6dbf,
		0xe4c3
		},
		{
		0x6dc0,
		0xf8ad
		},
		{
		0x6dc4,
		0xd7cd
		},
		{
		0x6dc5,
		0xe4c0
		},
		{
		0x6dc6,
		0xcffd
		},
		{
		0x6dc7,
		0xe4bf
		},
		{
		0x6dcb,
		0xc1dc
		},
		{
		0x6dcc,
		0xccca
		},
		{
		0x6dd1,
		0xcae7
		},
		{
		0x6dd6,
		0xc4d7
		},
		{
		0x6dd8,
		0xccd4
		},
		{
		0x6dd9,
		0xe4c8
		},
		{
		0x6ddd,
		0xe4c7
		},
		{
		0x6dde,
		0xe4c1
		},
		{
		0x6de0,
		0xe4c4
		},
		{
		0x6de1,
		0xb5ad
		},
		{
		0x6de4,
		0xd3d9
		},
		{
		0x6de6,
		0xe4c6
		},
		{
		0x6dea,
		0xc2d9
		},
		{
		0x6deb,
		0xd2f9
		},
		{
		0x6dec,
		0xb4e3
		},
		{
		0x6dee,
		0xbbb4
		},
		{
		0x6df1,
		0xc9ee
		},
		{
		0x6df3,
		0xb4be
		},
		{
		0x6df5,
		0xd4a8
		},
		{
		0x6df6,
		0xe4b5
		},
		{
		0x6df7,
		0xbbec
		},
		{
		0x6df9,
		0xd1cd
		},
		{
		0x6dfa,
		0xc7b3
		},
		{
		0x6dfb,
		0xcced
		},
		{
		0x6dfc,
		0xedb5
		},
		{
		0x6e05,
		0xc7e5
		},
		{
		0x6e0c,
		0xe4cb
		},
		{
		0x6e19,
		0xbbc1
		},
		{
		0x6e1a,
		0xe4be
		},
		{
		0x6e1d,
		0xd3e5
		},
		{
		0x6e20,
		0xc7fe
		},
		{
		0x6e21,
		0xb6c9
		},
		{
		0x6e23,
		0xd4fc
		},
		{
		0x6e24,
		0xb2b3
		},
		{
		0x6e25,
		0xe4d7
		},
		{
		0x6e26,
		0xced0
		},
		{
		0x6e29,
		0xcec2
		},
		{
		0x6e2b,
		0xe4cd
		},
		{
		0x6e2c,
		0xb2e2
		},
		{
		0x6e2d,
		0xcebc
		},
		{
		0x6e2f,
		0xb8db
		},
		{
		0x6e32,
		0xe4d6
		},
		{
		0x6e34,
		0xbfca
		},
		{
		0x6e38,
		0xd3ce
		},
		{
		0x6e3a,
		0xc3ec
		},
		{
		0x6e3e,
		0xbbeb
		},
		{
		0x6e43,
		0xc5c8
		},
		{
		0x6e44,
		0xe4d8
		},
		{
		0x6e4d,
		0xcdc4
		},
		{
		0x6e4e,
		0xe4cf
		},
		{
		0x6e53,
		0xe4d4
		},
		{
		0x6e54,
		0xe4d5
		},
		{
		0x6e56,
		0xbafe
		},
		{
		0x6e58,
		0xcfe6
		},
		{
		0x6e5b,
		0xd5bf
		},
		{
		0x6e5e,
		0xe4a5
		},
		{
		0x6e5f,
		0xe4d2
		},
		{
		0x6e6b,
		0xe4d0
		},
		{
		0x6e6e,
		0xe4ce
		},
		{
		0x6e6f,
		0xccc0
		},
		{
		0x6e86,
		0xe4d3
		},
		{
		0x6e89,
		0xb8c8
		},
		{
		0x6e8f,
		0xe4e7
		},
		{
		0x6e90,
		0xd4b4
		},
		{
		0x6e96,
		0xd7bc
		},
		{
		0x6e98,
		0xe4db
		},
		{
		0x6e9c,
		0xc1ef
		},
		{
		0x6e9d,
		0xb9b5
		},
		{
		0x6e9f,
		0xe4e9
		},
		{
		0x6ea2,
		0xd2e7
		},
		{
		0x6ea5,
		0xe4df
		},
		{
		0x6ea7,
		0xe4e0
		},
		{
		0x6eaa,
		0xcfaa
		},
		{
		0x6eaf,
		0xcbdd
		},
		{
		0x6eb1,
		0xe4da
		},
		{
		0x6eb2,
		0xe4d1
		},
		{
		0x6eb4,
		0xe4e5
		},
		{
		0x6eb6,
		0xc8dc
		},
		{
		0x6eb7,
		0xe4e3
		},
		{
		0x6eba,
		0xc4e7
		},
		{
		0x6ebb,
		0xe4e2
		},
		{
		0x6ebd,
		0xe4e1
		},
		{
		0x6ec1,
		0xb3fc
		},
		{
		0x6ec2,
		0xe4e8
		},
		{
		0x6ec4,
		0xb2d7
		},
		{
		0x6ec5,
		0xc3f0
		},
		{
		0x6ec7,
		0xb5e1
		},
		{
		0x6ecb,
		0xd7cc
		},
		{
		0x6ecc,
		0xb5d3
		},
		{
		0x6ece,
		0xdcfe
		},
		{
		0x6ecf,
		0xe4e6
		},
		{
		0x6ed1,
		0xbbac
		},
		{
		0x6ed3,
		0xd7d2
		},
		{
		0x6ed4,
		0xcccf
		},
		{
		0x6ed5,
		0xebf8
		},
		{
		0x6eda,
		0xb9f6
		},
		{
		0x6eec,
		0xbba6
		},
		{
		0x6eef,
		0xd6cd
		},
		{
		0x6ef2,
		0xc9f8
		},
		{
		0x6ef4,
		0xb5ce
		},
		{
		0x6ef7,
		0xc2b1
		},
		{
		0x6ef8,
		0xe4b0
		},
		{
		0x6ef9,
		0xe4ef
		},
		{
		0x6eff,
		0xc2fa
		},
		{
		0x6f01,
		0xd3e6
		},
		{
		0x6f02,
		0xc6af
		},
		{
		0x6f06,
		0xc6e1
		},
		{
		0x6f09,
		0xe4f5
		},
		{
		0x6f0f,
		0xc2a9
		},
		{
		0x6f14,
		0xd1dd
		},
		{
		0x6f15,
		0xe4ee
		},
		{
		0x6f1a,
		0xc5bd
		},
		{
		0x6f20,
		0xc4ae
		},
		{
		0x6f22,
		0xbaba
		},
		{
		0x6f23,
		0xc1b0
		},
		{
		0x6f24,
		0xe4ed
		},
		{
		0x6f29,
		0xe4f6
		},
		{
		0x6f2a,
		0xe4f4
		},
		{
		0x6f2b,
		0xc2fe
		},
		{
		0x6f2c,
		0xd7d5
		},
		{
		0x6f2d,
		0xe4dd
		},
		{
		0x6f2f,
		0xe4f0
		},
		{
		0x6f31,
		0xcafe
		},
		{
		0x6f32,
		0xd5c7
		},
		{
		0x6f33,
		0xd5c4
		},
		{
		0x6f36,
		0xe4f1
		},
		{
		0x6f38,
		0xbda5
		},
		{
		0x6f3e,
		0xd1fa
		},
		{
		0x6f3f,
		0xbdac
		},
		{
		0x6f41,
		0xf2a3
		},
		{
		0x6f51,
		0xc6c3
		},
		{
		0x6f54,
		0xbde0
		},
		{
		0x6f58,
		0xc5cb
		},
		{
		0x6f59,
		0xe3ed
		},
		{
		0x6f5b,
		0xc7b1
		},
		{
		0x6f5e,
		0xc2ba
		},
		{
		0x6f62,
		0xe4ea
		},
		{
		0x6f64,
		0xc8f3
		},
		{
		0x6f66,
		0xc1ca
		},
		{
		0x6f6d,
		0xccb6
		},
		{
		0x6f6e,
		0xb3b1
		},
		{
		0x6f6f,
		0xe4b1
		},
		{
		0x6f70,
		0xc0a3
		},
		{
		0x6f72,
		0xe4fb
		},
		{
		0x6f74,
		0xe4f3
		},
		{
		0x6f77,
		0xe4e4
		},
		{
		0x6f78,
		0xe4fa
		},
		{
		0x6f7a,
		0xe4fd
		},
		{
		0x6f7c,
		0xe4fc
		},
		{
		0x6f7f,
		0xe4b6
		},
		{
		0x6f80,
		0xc9ac
		},
		{
		0x6f84,
		0xb3ce
		},
		{
		0x6f86,
		0xbdbd
		},
		{
		0x6f87,
		0xc0d4
		},
		{
		0x6f88,
		0xb3ba
		},
		{
		0x6f89,
		0xe4f7
		},
		{
		0x6f8c,
		0xe4f9
		},
		{
		0x6f8d,
		0xe4f8
		},
		{
		0x6f8e,
		0xc5ec
		},
		{
		0x6f97,
		0xbda7
		},
		{
		0x6fa0,
		0xe4c5
		},
		{
		0x6fa1,
		0xd4e8
		},
		{
		0x6fa4,
		0xd4f3
		},
		{
		0x6fa7,
		0xe5a2
		},
		{
		0x6fa9,
		0xedb4
		},
		{
		0x6fae,
		0xe4ab
		},
		{
		0x6fb1,
		0xb5ed
		},
		{
		0x6fb3,
		0xb0c4
		},
		{
		0x6fb6,
		0xe5a4
		},
		{
		0x6fb9,
		0xe5a3
		},
		{
		0x6fc0,
		0xbca4
		},
		{
		0x6fc1,
		0xd7c7
		},
		{
		0x6fc2,
		0xe5a5
		},
		{
		0x6fc3,
		0xc5a8
		},
		{
		0x6fc9,
		0xe5a1
		},
		{
		0x6fd5,
		0xcaaa
		},
		{
		0x6fd8,
		0xc5a2
		},
		{
		0x6fdb,
		0xf8d5
		},
		{
		0x6fde,
		0xe5a8
		},
		{
		0x6fdf,
		0xbcc3
		},
		{
		0x6fe0,
		0xe5a9
		},
		{
		0x6fe1,
		0xe5a6
		},
		{
		0x6fe4,
		0xccce
		},
		{
		0x6feb,
		0xc0c4
		},
		{
		0x6fee,
		0xe5a7
		},
		{
		0x6fef,
		0xe5aa
		},
		{
		0x6ff0,
		0xceab
		},
		{
		0x6ff1,
		0xb1f5
		},
		{
		0x6ffa,
		0xbda6
		},
		{
		0x6ffc,
		0xe3f8
		},
		{
		0x6ffe,
		0xc2cb
		},
		{
		0x7005,
		0xe4de
		},
		{
		0x7006,
		0xe4c2
		},
		{
		0x7009,
		0xd0ba
		},
		{
		0x700b,
		0xe4c9
		},
		{
		0x700f,
		0xe4af
		},
		{
		0x7011,
		0xc6d9
		},
		{
		0x7015,
		0xb1f4
		},
		{
		0x7018,
		0xe3f2
		},
		{
		0x701a,
		0xe5ab
		},
		{
		0x701b,
		0xe5ad
		},
		{
		0x701d,
		0xc1a4
		},
		{
		0x701f,
		0xe4ec
		},
		{
		0x7020,
		0xe4eb
		},
		{
		0x7023,
		0xe5ac
		},
		{
		0x7027,
		0xe3f1
		},
		{
		0x7028,
		0xe4fe
		},
		{
		0x7030,
		0xf8d8
		},
		{
		0x7032,
		0xe4f2
		},
		{
		0x7035,
		0xe5af
		},
		{
		0x7039,
		0xe5ae
		},
		{
		0x703e,
		0xc0bd
		},
		{
		0x7043,
		0xe3e3
		},
		{
		0x7044,
		0xe4dc
		},
		{
		0x704c,
		0xb9e0
		},
		{
		0x7051,
		0xc8f7
		},
		{
		0x7055,
		0xc0ec
		},
		{
		0x7058,
		0xccb2
		},
		{
		0x705d,
		0xe5b0
		},
		{
		0x705e,
		0xe5b1
		},
		{
		0x7063,
		0xcde5
		},
		{
		0x7064,
		0xc2d0
		},
		{
		0x7067,
		0xe4d9
		},
		{
		0x706b,
		0xbbf0
		},
		{
		0x706c,
		0xece1
		},
		{
		0x7070,
		0xbbd2
		},
		{
		0x7078,
		0xbec4
		},
		{
		0x707c,
		0xd7c6
		},
		{
		0x707e,
		0xd4d6
		},
		{
		0x7085,
		0xeac1
		},
		{
		0x708a,
		0xb4b6
		},
		{
		0x708e,
		0xd1d7
		},
		{
		0x7092,
		0xb3b4
		},
		{
		0x7094,
		0xc8b2
		},
		{
		0x7095,
		0xbfbb
		},
		{
		0x7096,
		0xecc0
		},
		{
		0x7099,
		0xd6cb
		},
		{
		0x70ab,
		0xecc5
		},
		{
		0x70ac,
		0xbee6
		},
		{
		0x70ad,
		0xccbf
		},
		{
		0x70ae,
		0xc5da
		},
		{
		0x70af,
		0xbebc
		},
		{
		0x70b1,
		0xecc6
		},
		{
		0x70b3,
		0xb1fe
		},
		{
		0x70b7,
		0xecc4
		},
		{
		0x70b8,
		0xd5a8
		},
		{
		0x70bb,
		0xecc2
		},
		{
		0x70c0,
		0xecc3
		},
		{
		0x70c8,
		0xc1d2
		},
		{
		0x70ca,
		0xecc8
		},
		{
		0x70cf,
		0xceda
		},
		{
		0x70d8,
		0xbae6
		},
		{
		0x70d9,
		0xc0d3
		},
		{
		0x70df,
		0xd1cc
		},
		{
		0x70e4,
		0xbfbe
		},
		{
		0x70ef,
		0xcfa9
		},
		{
		0x70f4,
		0xccfe
		},
		{
		0x70f7,
		0xcde9
		},
		{
		0x70f9,
		0xc5eb
		},
		{
		0x70fd,
		0xb7e9
		},
		{
		0x7109,
		0xd1c9
		},
		{
		0x710a,
		0xbab8
		},
		{
		0x7110,
		0xecc9
		},
		{
		0x7113,
		0xecca
		},
		{
		0x7119,
		0xb1ba
		},
		{
		0x711a,
		0xb7d9
		},
		{
		0x7121,
		0xcede
		},
		{
		0x7126,
		0xbdb9
		},
		{
		0x712f,
		0xeccc
		},
		{
		0x7130,
		0xd1e6
		},
		{
		0x7131,
		0xeccd
		},
		{
		0x7136,
		0xc8bb
		},
		{
		0x7145,
		0xecd1
		},
		{
		0x7149,
		0xc1b6
		},
		{
		0x714a,
		0xecd3
		},
		{
		0x714c,
		0xbbcd
		},
		{
		0x714e,
		0xbce5
		},
		{
		0x7152,
		0xecbf
		},
		{
		0x715c,
		0xeccf
		},
		{
		0x715e,
		0xc9b7
		},
		{
		0x7162,
		0xdce4
		},
		{
		0x7164,
		0xc3ba
		},
		{
		0x7165,
		0xbbc0
		},
		{
		0x7166,
		0xece3
		},
		{
		0x7167,
		0xd5d5
		},
		{
		0x7168,
		0xecd0
		},
		{
		0x7169,
		0xb7b3
		},
		{
		0x716c,
		0xecbe
		},
		{
		0x716e,
		0xd6f3
		},
		{
		0x7172,
		0xecd2
		},
		{
		0x7173,
		0xecce
		},
		{
		0x7178,
		0xecd4
		},
		{
		0x717a,
		0xecd5
		},
		{
		0x717d,
		0xc9bf
		},
		{
		0x7184,
		0xcfa8
		},
		{
		0x718a,
		0xd0dc
		},
		{
		0x718f,
		0xd1ac
		},
		{
		0x7192,
		0xd3ab
		},
		{
		0x7194,
		0xc8db
		},
		{
		0x7197,
		0xecc1
		},
		{
		0x7198,
		0xecd6
		},
		{
		0x7199,
		0xcef5
		},
		{
		0x719f,
		0xcaec
		},
		{
		0x71a0,
		0xecda
		},
		{
		0x71a8,
		0xecd9
		},
		{
		0x71ac,
		0xb0be
		},
		{
		0x71b1,
		0xc8c8
		},
		{
		0x71b3,
		0xecd7
		},
		{
		0x71b5,
		0xecd8
		},
		{
		0x71b9,
		0xece4
		},
		{
		0x71be,
		0xb3e3
		},
		{
		0x71c1,
		0xecc7
		},
		{
		0x71c3,
		0xc8bc
		},
		{
		0x71c8,
		0xb5c6
		},
		{
		0x71ce,
		0xc1c7
		},
		{
		0x71d2,
		0xc9d5
		},
		{
		0x71d4,
		0xecdc
		},
		{
		0x71d5,
		0xd1e0
		},
		{
		0x71d9,
		0xcccc
		},
		{
		0x71dc,
		0xeccb
		},
		{
		0x71df,
		0xd3aa
		},
		{
		0x71e0,
		0xecdb
		},
		{
		0x71e5,
		0xd4ef
		},
		{
		0x71e6,
		0xb2d3
		},
		{
		0x71e7,
		0xecdd
		},
		{
		0x71ed,
		0xd6f2
		},
		{
		0x71ee,
		0xdbc6
		},
		{
		0x71f4,
		0xbbe2
		},
		{
		0x71f9,
		0xecde
		},
		{
		0x71fc,
		0xbdfd
		},
		{
		0x71fe,
		0xece2
		},
		{
		0x7206,
		0xb1ac
		},
		{
		0x720d,
		0xcbb8
		},
		{
		0x7210,
		0xc2af
		},
		{
		0x721b,
		0xc0c3
		},
		{
		0x721d,
		0xecdf
		},
		{
		0x7228,
		0xece0
		},
		{
		0x722a,
		0xd7a6
		},
		{
		0x722c,
		0xc5c0
		},
		{
		0x722d,
		0xd5f9
		},
		{
		0x7230,
		0xebbc
		},
		{
		0x7232,
		0xceaa
		},
		{
		0x7235,
		0xbef4
		},
		{
		0x7236,
		0xb8b8
		},
		{
		0x7238,
		0xb0d6
		},
		{
		0x7239,
		0xb5f9
		},
		{
		0x723a,
		0xd2af
		},
		{
		0x723b,
		0xd8b3
		},
		{
		0x723d,
		0xcbac
		},
		{
		0x723e,
		0xb6fb
		},
		{
		0x723f,
		0xe3dd
		},
		{
		0x7247,
		0xc6ac
		},
		{
		0x7248,
		0xb0e6
		},
		{
		0x724c,
		0xc5c6
		},
		{
		0x7252,
		0xebba
		},
		{
		0x7256,
		0xebbb
		},
		{
		0x7258,
		0xebb9
		},
		{
		0x7259,
		0xd1c0
		},
		{
		0x725b,
		0xc5a3
		},
		{
		0x725d,
		0xeaf2
		},
		{
		0x725f,
		0xc4b2
		},
		{
		0x7261,
		0xc4b5
		},
		{
		0x7262,
		0xc0ce
		},
		{
		0x7266,
		0xeaf3
		},
		{
		0x7267,
		0xc4c1
		},
		{
		0x7269,
		0xceef
		},
		{
		0x726e,
		0xeaf0
		},
		{
		0x726f,
		0xeaf4
		},
		{
		0x7272,
		0xc9fc
		},
		{
		0x7279,
		0xccd8
		},
		{
		0x727d,
		0xc7a3
		},
		{
		0x727e,
		0xeaf5
		},
		{
		0x727f,
		0xeaf6
		},
		{
		0x7280,
		0xcfac
		},
		{
		0x7281,
		0xc0e7
		},
		{
		0x7284,
		0xeaf7
		},
		{
		0x728b,
		0xeaf8
		},
		{
		0x728d,
		0xeaf9
		},
		{
		0x728f,
		0xeafa
		},
		{
		0x7292,
		0xeafb
		},
		{
		0x7296,
		0xdcfd
		},
		{
		0x729f,
		0xeaf1
		},
		{
		0x72a2,
		0xb6bf
		},
		{
		0x72a7,
		0xcefe
		},
		{
		0x72ac,
		0xc8ae
		},
		{
		0x72ad,
		0xe1eb
		},
		{
		0x72af,
		0xb7b8
		},
		{
		0x72b0,
		0xe1ec
		},
		{
		0x72b4,
		0xe1ed
		},
		{
		0x72c0,
		0xd7b4
		},
		{
		0x72c1,
		0xe1f1
		},
		{
		0x72c2,
		0xbff1
		},
		{
		0x72c3,
		0xe1f0
		},
		{
		0x72c4,
		0xb5d2
		},
		{
		0x72cd,
		0xe1f3
		},
		{
		0x72ce,
		0xe1f2
		},
		{
		0x72d0,
		0xbafc
		},
		{
		0x72d2,
		0xe1f4
		},
		{
		0x72d7,
		0xb9b7
		},
		{
		0x72d9,
		0xbed1
		},
		{
		0x72e0,
		0xbadd
		},
		{
		0x72e1,
		0xbdc6
		},
		{
		0x72e8,
		0xe1f5
		},
		{
		0x72e9,
		0xe1f7
		},
		{
		0x72f3,
		0xe1fc
		},
		{
		0x72f4,
		0xe1f9
		},
		{
		0x72f7,
		0xe1fa
		},
		{
		0x72f8,
		0xc0ea
		},
		{
		0x72f9,
		0xcfc1
		},
		{
		0x72fa,
		0xe1fe
		},
		{
		0x72fb,
		0xe2a1
		},
		{
		0x72fc,
		0xc0c7
		},
		{
		0x72fd,
		0xb1b7
		},
		{
		0x7301,
		0xe1fb
		},
		{
		0x730a,
		0xe2a5
		},
		{
		0x7313,
		0xe2a3
		},
		{
		0x7316,
		0xb2fe
		},
		{
		0x7317,
		0xe2a2
		},
		{
		0x7319,
		0xd5f8
		},
		{
		0x731b,
		0xc3cd
		},
		{
		0x731c,
		0xb2c2
		},
		{
		0x731d,
		0xe2a7
		},
		{
		0x731e,
		0xe2a6
		},
		{
		0x7322,
		0xe2a9
		},
		{
		0x7325,
		0xe2ab
		},
		{
		0x7329,
		0xd0c9
		},
		{
		0x732a,
		0xd6ed
		},
		{
		0x732b,
		0xc3a8
		},
		{
		0x732c,
		0xe2ac
		},
		{
		0x7331,
		0xe2ae
		},
		{
		0x7334,
		0xbaef
		},
		{
		0x7336,
		0xd3cc
		},
		{
		0x7337,
		0xe9e0
		},
		{
		0x7338,
		0xe2ad
		},
		{
		0x7339,
		0xe2aa
		},
		{
		0x733b,
		0xe1f8
		},
		{
		0x733e,
		0xbbab
		},
		{
		0x733f,
		0xd4b3
		},
		{
		0x7341,
		0xe1ef
		},
		{
		0x7344,
		0xd3fc
		},
		{
		0x7345,
		0xcaa8
		},
		{
		0x734d,
		0xe2b0
		},
		{
		0x7350,
		0xe2af
		},
		{
		0x7352,
		0xe9e1
		},
		{
		0x7357,
		0xe2b1
		},
		{
		0x7360,
		0xe2b2
		},
		{
		0x7368,
		0xb6c0
		},
		{
		0x736a,
		0xe1f6
		},
		{
		0x736b,
		0xe1fd
		},
		{
		0x736c,
		0xe2b3
		},
		{
		0x736f,
		0xe2b4
		},
		{
		0x7370,
		0xc4fc
		},
		{
		0x7372,
		0xbbf1
		},
		{
		0x7375,
		0xc1d4
		},
		{
		0x7377,
		0xe1ee
		},
		{
		0x7378,
		0xcade
		},
		{
		0x737a,
		0xcca1
		},
		{
		0x737b,
		0xcfd7
		},
		{
		0x737c,
		0xe2a8
		},
		{
		0x737e,
		0xe2b5
		},
		{
		0x7380,
		0xe2a4
		},
		{
		0x7384,
		0xd0fe
		},
		{
		0x7387,
		0xc2ca
		},
		{
		0x7389,
		0xd3f1
		},
		{
		0x738b,
		0xcdf5
		},
		{
		0x738e,
		0xe7e0
		},
		{
		0x7396,
		0xbec1
		},
		{
		0x739f,
		0xe7e4
		},
		{
		0x73a2,
		0xe7e3
		},
		{
		0x73a9,
		0xcde6
		},
		{
		0x73ab,
		0xc3b5
		},
		{
		0x73b2,
		0xc1e1
		},
		{
		0x73b3,
		0xe7e9
		},
		{
		0x73b7,
		0xe7e8
		},
		{
		0x73bb,
		0xb2a3
		},
		{
		0x73c0,
		0xe7ea
		},
		{
		0x73c2,
		0xe7e6
		},
		{
		0x73c8,
		0xe7ec
		},
		{
		0x73c9,
		0xe7eb
		},
		{
		0x73ca,
		0xc9ba
		},
		{
		0x73cd,
		0xd5e4
		},
		{
		0x73cf,
		0xe7e5
		},
		{
		0x73d0,
		0xb7a9
		},
		{
		0x73d9,
		0xe7ee
		},
		{
		0x73de,
		0xe7f3
		},
		{
		0x73e0,
		0xd6e9
		},
		{
		0x73e5,
		0xe7ed
		},
		{
		0x73e7,
		0xe7f2
		},
		{
		0x73e9,
		0xe7f1
		},
		{
		0x73ed,
		0xb0e0
		},
		{
		0x73fe,
		0xcfd6
		},
		{
		0x7403,
		0xc7f2
		},
		{
		0x7405,
		0xc0c5
		},
		{
		0x7406,
		0xc0ed
		},
		{
		0x7409,
		0xc1f0
		},
		{
		0x740a,
		0xe7f0
		},
		{
		0x741a,
		0xe8a2
		},
		{
		0x741b,
		0xe8a1
		},
		{
		0x7422,
		0xd7c1
		},
		{
		0x7425,
		0xe7fa
		},
		{
		0x7426,
		0xe7f9
		},
		{
		0x7428,
		0xe7fb
		},
		{
		0x742a,
		0xe7f7
		},
		{
		0x742c,
		0xe7fe
		},
		{
		0x742e,
		0xe7fd
		},
		{
		0x7430,
		0xe7fc
		},
		{
		0x7433,
		0xc1d5
		},
		{
		0x7434,
		0xc7d9
		},
		{
		0x7435,
		0xc5fd
		},
		{
		0x7436,
		0xc5c3
		},
		{
		0x743f,
		0xe7f5
		},
		{
		0x7441,
		0xe8a3
		},
		{
		0x744b,
		0xe7e2
		},
		{
		0x7455,
		0xe8a6
		},
		{
		0x7457,
		0xe8a5
		},
		{
		0x7459,
		0xe8a7
		},
		{
		0x745a,
		0xbaf7
		},
		{
		0x745b,
		0xe7f8
		},
		{
		0x745c,
		0xe8a4
		},
		{
		0x745e,
		0xc8f0
		},
		{
		0x745f,
		0xc9aa
		},
		{
		0x7463,
		0xcbf6
		},
		{
		0x7469,
		0xd3a8
		},
		{
		0x746a,
		0xc2ea
		},
		{
		0x746d,
		0xe8a9
		},
		{
		0x7470,
		0xb9e5
		},
		{
		0x7476,
		0xd1fe
		},
		{
		0x747e,
		0xe8aa
		},
		{
		0x7480,
		0xe8ad
		},
		{
		0x7481,
		0xe8ae
		},
		{
		0x7483,
		0xc1a7
		},
		{
		0x7487,
		0xe8af
		},
		{
		0x7489,
		0xe7f6
		},
		{
		0x748b,
		0xe8b0
		},
		{
		0x7490,
		0xe8b4
		},
		{
		0x749c,
		0xe8ab
		},
		{
		0x749e,
		0xe8b1
		},
		{
		0x74a3,
		0xe7e1
		},
		{
		0x74a6,
		0xe8a8
		},
		{
		0x74a7,
		0xe8b5
		},
		{
		0x74a8,
		0xe8b2
		},
		{
		0x74a9,
		0xe8b3
		},
		{
		0x74b0,
		0xbbb7
		},
		{
		0x74ba,
		0xe8b7
		},
		{
		0x74bd,
		0xe7f4
		},
		{
		0x74ca,
		0xc7ed
		},
		{
		0x74cf,
		0xe7e7
		},
		{
		0x74d4,
		0xe8ac
		},
		{
		0x74da,
		0xe8b6
		},
		{
		0x74dc,
		0xb9cf
		},
		{
		0x74de,
		0xf0ac
		},
		{
		0x74e0,
		0xf0ad
		},
		{
		0x74e2,
		0xc6b0
		},
		{
		0x74e3,
		0xb0ea
		},
		{
		0x74e4,
		0xc8bf
		},
		{
		0x74e6,
		0xcddf
		},
		{
		0x74ee,
		0xcecd
		},
		{
		0x74f4,
		0xeab2
		},
		{
		0x74f6,
		0xc6bf
		},
		{
		0x74f7,
		0xb4c9
		},
		{
		0x74ff,
		0xeab3
		},
		{
		0x7504,
		0xd5e7
		},
		{
		0x750c,
		0xeab1
		},
		{
		0x750d,
		0xddf9
		},
		{
		0x750f,
		0xeab4
		},
		{
		0x7511,
		0xeab5
		},
		{
		0x7513,
		0xeab6
		},
		{
		0x7518,
		0xb8ca
		},
		{
		0x7519,
		0xdfb0
		},
		{
		0x751a,
		0xc9f5
		},
		{
		0x751c,
		0xccf0
		},
		{
		0x751f,
		0xc9fa
		},
		{
		0x7523,
		0xb2fa
		},
		{
		0x7525,
		0xc9fb
		},
		{
		0x7528,
		0xd3c3
		},
		{
		0x7529,
		0xcba6
		},
		{
		0x752b,
		0xb8a6
		},
		{
		0x752c,
		0xf0ae
		},
		{
		0x752d,
		0xb1c2
		},
		{
		0x752f,
		0xe5b8
		},
		{
		0x7530,
		0xccef
		},
		{
		0x7531,
		0xd3c9
		},
		{
		0x7532,
		0xbcd7
		},
		{
		0x7533,
		0xc9ea
		},
		{
		0x7537,
		0xc4d0
		},
		{
		0x7538,
		0xb5e9
		},
		{
		0x753a,
		0xeeae
		},
		{
		0x753e,
		0xe7de
		},
		{
		0x7540,
		0xeeaf
		},
		{
		0x7548,
		0xeeb2
		},
		{
		0x754b,
		0xeeb1
		},
		{
		0x754c,
		0xbde7
		},
		{
		0x754e,
		0xeeb0
		},
		{
		0x754f,
		0xceb7
		},
		{
		0x7554,
		0xc5cf
		},
		{
		0x7559,
		0xc1f4
		},
		{
		0x755a,
		0xdbce
		},
		{
		0x755b,
		0xeeb3
		},
		{
		0x755c,
		0xd0f3
		},
		{
		0x755d,
		0xc4b6
		},
		{
		0x7562,
		0xb1cf
		},
		{
		0x7565,
		0xc2d4
		},
		{
		0x7566,
		0xc6e8
		},
		{
		0x756a,
		0xb7ac
		},
		{
		0x756b,
		0xbbad
		},
		{
		0x7572,
		0xeeb4
		},
		{
		0x7576,
		0xb5b1
		},
		{
		0x7578,
		0xbbfb
		},
		{
		0x7579,
		0xeeb5
		},
		{
		0x757f,
		0xe7dc
		},
		{
		0x7583,
		0xeeb6
		},
		{
		0x7586,
		0xbdae
		},
		{
		0x7587,
		0xb3eb
		},
		{
		0x758a,
		0xb5fe
		},
		{
		0x758b,
		0xf1e2
		},
		{
		0x758f,
		0xcae8
		},
		{
		0x7591,
		0xd2c9
		},
		{
		0x7592,
		0xf0da
		},
		{
		0x7594,
		0xf0db
		},
		{
		0x7599,
		0xb8ed
		},
		{
		0x759a,
		0xbece
		},
		{
		0x759d,
		0xf0de
		},
		{
		0x75a3,
		0xf0e0
		},
		{
		0x75a4,
		0xb0cc
		},
		{
		0x75a5,
		0xbdea
		},
		{
		0x75ab,
		0xd2df
		},
		{
		0x75b0,
		0xf0e6
		},
		{
		0x75b1,
		0xf0e5
		},
		{
		0x75b2,
		0xc6a3
		},
		{
		0x75b3,
		0xf0e1
		},
		{
		0x75b4,
		0xf0e2
		},
		{
		0x75b5,
		0xb4c3
		},
		{
		0x75b8,
		0xf0e3
		},
		{
		0x75b9,
		0xd5ee
		},
		{
		0x75bc,
		0xccdb
		},
		{
		0x75bd,
		0xbed2
		},
		{
		0x75be,
		0xbcb2
		},
		{
		0x75c2,
		0xf0e8
		},
		{
		0x75c3,
		0xf0e7
		},
		{
		0x75c4,
		0xf0e4
		},
		{
		0x75c5,
		0xb2a1
		},
		{
		0x75c7,
		0xf9a1
		},
		{
		0x75ca,
		0xc8ac
		},
		{
		0x75cd,
		0xf0ea
		},
		{
		0x75d4,
		0xd6cc
		},
		{
		0x75d5,
		0xbadb
		},
		{
		0x75d8,
		0xb6bb
		},
		{
		0x75d9,
		0xbeb7
		},
		{
		0x75db,
		0xcdb4
		},
		{
		0x75de,
		0xc6a6
		},
		{
		0x75e2,
		0xc1a1
		},
		{
		0x75e3,
		0xf0eb
		},
		{
		0x75e4,
		0xf0ee
		},
		{
		0x75e6,
		0xf0ed
		},
		{
		0x75e7,
		0xf0f0
		},
		{
		0x75f0,
		0xccb5
		},
		{
		0x75f1,
		0xf0f2
		},
		{
		0x75f4,
		0xb3d5
		},
		{
		0x75f9,
		0xb1d4
		},
		{
		0x75fc,
		0xf0f3
		},
		{
		0x75ff,
		0xf0f4
		},
		{
		0x7600,
		0xf0f6
		},
		{
		0x7601,
		0xb4e1
		},
		{
		0x7602,
		0xf0e9
		},
		{
		0x7603,
		0xf0f1
		},
		{
		0x760a,
		0xf0fa
		},
		{
		0x760b,
		0xb7e8
		},
		{
		0x760c,
		0xf0f8
		},
		{
		0x760d,
		0xd1f1
		},
		{
		0x7610,
		0xf0f5
		},
		{
		0x7613,
		0xbbbe
		},
		{
		0x7615,
		0xf0fd
		},
		{
		0x7619,
		0xf0fe
		},
		{
		0x761b,
		0xf1a1
		},
		{
		0x761e,
		0xf0f9
		},
		{
		0x761f,
		0xcec1
		},
		{
		0x7620,
		0xf1a4
		},
		{
		0x7621,
		0xb4af
		},
		{
		0x7622,
		0xf1a3
		},
		{
		0x7624,
		0xc1f6
		},
		{
		0x7625,
		0xf0fb
		},
		{
		0x7626,
		0xcadd
		},
		{
		0x7627,
		0xc5b1
		},
		{
		0x7629,
		0xb4f1
		},
		{
		0x762d,
		0xf1a6
		},
		{
		0x7630,
		0xf1a7
		},
		{
		0x7633,
		0xf1ac
		},
		{
		0x7634,
		0xd5ce
		},
		{
		0x7635,
		0xf1a9
		},
		{
		0x7638,
		0xc8b3
		},
		{
		0x763b,
		0xf0fc
		},
		{
		0x763c,
		0xf1a2
		},
		{
		0x7640,
		0xf1a5
		},
		{
		0x7642,
		0xc1c6
		},
		{
		0x7643,
		0xf1aa
		},
		{
		0x7646,
		0xf0ec
		},
		{
		0x7647,
		0xf0ef
		},
		{
		0x7649,
		0xf0f7
		},
		{
		0x764c,
		0xb0a9
		},
		{
		0x764d,
		0xf1ad
		},
		{
		0x7654,
		0xf1af
		},
		{
		0x7656,
		0xf1b1
		},
		{
		0x7658,
		0xf0dd
		},
		{
		0x765c,
		0xf1b0
		},
		{
		0x765f,
		0xb1f1
		},
		{
		0x7662,
		0xd1f7
		},
		{
		0x7664,
		0xf0dc
		},
		{
		0x7665,
		0xd6a2
		},
		{
		0x7667,
		0xf0df
		},
		{
		0x7669,
		0xf1ae
		},
		{
		0x766c,
		0xd1a2
		},
		{
		0x766d,
		0xf1a8
		},
		{
		0x766e,
		0xf1ab
		},
		{
		0x766f,
		0xf1b3
		},
		{
		0x7670,
		0xd3b8
		},
		{
		0x7671,
		0xccb1
		},
		{
		0x7672,
		0xf1b2
		},
		{
		0x7678,
		0xb9ef
		},
		{
		0x767b,
		0xb5c7
		},
		{
		0x767c,
		0xb7a2
		},
		{
		0x767d,
		0xb0d7
		},
		{
		0x767e,
		0xb0d9
		},
		{
		0x7682,
		0xd4ed
		},
		{
		0x7684,
		0xb5c4
		},
		{
		0x7686,
		0xbdd4
		},
		{
		0x7687,
		0xbbca
		},
		{
		0x7688,
		0xf0a7
		},
		{
		0x768b,
		0xb8de
		},
		{
		0x768e,
		0xf0a8
		},
		{
		0x7693,
		0xf0a9
		},
		{
		0x7696,
		0xcdee
		},
		{
		0x7699,
		0xf0aa
		},
		{
		0x769a,
		0xb0a8
		},
		{
		0x76a4,
		0xf0ab
		},
		{
		0x76ae,
		0xc6a4
		},
		{
		0x76b4,
		0xf1e5
		},
		{
		0x76b8,
		0xf1e4
		},
		{
		0x76ba,
		0xd6e5
		},
		{
		0x76bf,
		0xc3f3
		},
		{
		0x76c2,
		0xd3db
		},
		{
		0x76c5,
		0xd6d1
		},
		{
		0x76c6,
		0xc5e8
		},
		{
		0x76c8,
		0xd3af
		},
		{
		0x76ca,
		0xd2e6
		},
		{
		0x76cd,
		0xeec1
		},
		{
		0x76ce,
		0xb0bb
		},
		{
		0x76d2,
		0xbad0
		},
		{
		0x76d4,
		0xbff8
		},
		{
		0x76d7,
		0xb5c1
		},
		{
		0x76db,
		0xcaa2
		},
		{
		0x76de,
		0xd5b5
		},
		{
		0x76df,
		0xc3cb
		},
		{
		0x76e1,
		0xbea1
		},
		{
		0x76e3,
		0xbce0
		},
		{
		0x76e4,
		0xc5cc
		},
		{
		0x76e5,
		0xeec2
		},
		{
		0x76e7,
		0xc2ac
		},
		{
		0x76ee,
		0xc4bf
		},
		{
		0x76ef,
		0xb6a2
		},
		{
		0x76f1,
		0xedec
		},
		{
		0x76f2,
		0xc3a4
		},
		{
		0x76f4,
		0xd6b1
		},
		{
		0x76f8,
		0xcfe0
		},
		{
		0x76f9,
		0xedef
		},
		{
		0x76fc,
		0xc5ce
		},
		{
		0x76fe,
		0xb6dc
		},
		{
		0x7701,
		0xcaa1
		},
		{
		0x7704,
		0xeded
		},
		{
		0x7707,
		0xedf0
		},
		{
		0x7708,
		0xedf1
		},
		{
		0x7709,
		0xc3bc
		},
		{
		0x770b,
		0xbfb4
		},
		{
		0x7719,
		0xedf4
		},
		{
		0x771a,
		0xedf2
		},
		{
		0x771f,
		0xd5e6
		},
		{
		0x7720,
		0xc3df
		},
		{
		0x7722,
		0xedf3
		},
		{
		0x7726,
		0xedf6
		},
		{
		0x7728,
		0xd5a3
		},
		{
		0x7729,
		0xd1a3
		},
		{
		0x772d,
		0xedf5
		},
		{
		0x772f,
		0xc3d0
		},
		{
		0x7735,
		0xedf7
		},
		{
		0x7736,
		0xbff4
		},
		{
		0x7737,
		0xbeec
		},
		{
		0x7738,
		0xedf8
		},
		{
		0x773a,
		0xccf7
		},
		{
		0x773c,
		0xd1db
		},
		{
		0x7740,
		0xd7c5
		},
		{
		0x7743,
		0xedfc
		},
		{
		0x7747,
		0xedfb
		},
		{
		0x774f,
		0xf8ca
		},
		{
		0x775a,
		0xedfd
		},
		{
		0x775b,
		0xbea6
		},
		{
		0x775c,
		0xd5f6
		},
		{
		0x775e,
		0xedf9
		},
		{
		0x7761,
		0xcbaf
		},
		{
		0x7762,
		0xeea1
		},
		{
		0x7763,
		0xb6bd
		},
		{
		0x7765,
		0xeea2
		},
		{
		0x7766,
		0xc4c0
		},
		{
		0x7768,
		0xedfe
		},
		{
		0x776b,
		0xbdde
		},
		{
		0x776c,
		0xb2c7
		},
		{
		0x7779,
		0xb6c3
		},
		{
		0x777d,
		0xeea5
		},
		{
		0x777e,
		0xd8ba
		},
		{
		0x777f,
		0xeea3
		},
		{
		0x7780,
		0xeea6
		},
		{
		0x7784,
		0xc3e9
		},
		{
		0x7785,
		0xb3f2
		},
		{
		0x778c,
		0xeea7
		},
		{
		0x778d,
		0xeea4
		},
		{
		0x778e,
		0xcfb9
		},
		{
		0x7791,
		0xeea8
		},
		{
		0x7798,
		0xedee
		},
		{
		0x779e,
		0xc2f7
		},
		{
		0x779f,
		0xeea9
		},
		{
		0x77a0,
		0xeeaa
		},
		{
		0x77a2,
		0xdeab
		},
		{
		0x77a5,
		0xc6b3
		},
		{
		0x77a7,
		0xc7c6
		},
		{
		0x77aa,
		0xb5c9
		},
		{
		0x77ac,
		0xcbb2
		},
		{
		0x77ad,
		0xf8d1
		},
		{
		0x77b0,
		0xeeab
		},
		{
		0x77b3,
		0xcdab
		},
		{
		0x77b5,
		0xeeac
		},
		{
		0x77bb,
		0xd5b0
		},
		{
		0x77bc,
		0xedfa
		},
		{
		0x77bd,
		0xeead
		},
		{
		0x77bf,
		0xf6c4
		},
		{
		0x77c7,
		0xf8d7
		},
		{
		0x77cd,
		0xdbc7
		},
		{
		0x77d7,
		0xb4a3
		},
		{
		0x77da,
		0xd6f5
		},
		{
		0x77db,
		0xc3ac
		},
		{
		0x77dc,
		0xf1e6
		},
		{
		0x77e2,
		0xcab8
		},
		{
		0x77e3,
		0xd2d3
		},
		{
		0x77e5,
		0xd6aa
		},
		{
		0x77e7,
		0xeff2
		},
		{
		0x77e9,
		0xbed8
		},
		{
		0x77ec,
		0xeff3
		},
		{
		0x77ed,
		0xb6cc
		},
		{
		0x77ee,
		0xb0ab
		},
		{
		0x77ef,
		0xbdc3
		},
		{
		0x77f3,
		0xcaaf
		},
		{
		0x77f8,
		0xedb7
		},
		{
		0x77fd,
		0xcef9
		},
		{
		0x7802,
		0xc9b0
		},
		{
		0x7809,
		0xedb9
		},
		{
		0x780c,
		0xc6f6
		},
		{
		0x780d,
		0xbfb3
		},
		{
		0x7811,
		0xedbc
		},
		{
		0x7812,
		0xc5f8
		},
		{
		0x7814,
		0xd1d0
		},
		{
		0x7818,
		0xedbb
		},
		{
		0x781d,
		0xedc0
		},
		{
		0x781f,
		0xedc4
		},
		{
		0x7823,
		0xedc8
		},
		{
		0x7825,
		0xedc6
		},
		{
		0x7826,
		0xedce
		},
		{
		0x7827,
		0xd5e8
		},
		{
		0x7829,
		0xedc9
		},
		{
		0x782c,
		0xedc7
		},
		{
		0x782d,
		0xedbe
		},
		{
		0x7830,
		0xc5e9
		},
		{
		0x7834,
		0xc6c6
		},
		{
		0x7837,
		0xc9e9
		},
		{
		0x7838,
		0xd4d2
		},
		{
		0x7839,
		0xedc1
		},
		{
		0x783c,
		0xedc5
		},
		{
		0x7843,
		0xf9a7
		},
		{
		0x7845,
		0xb9e8
		},
		{
		0x7847,
		0xedd0
		},
		{
		0x784c,
		0xedd1
		},
		{
		0x784e,
		0xedca
		},
		{
		0x7850,
		0xedcf
		},
		{
		0x7852,
		0xcef8
		},
		{
		0x785d,
		0xcff5
		},
		{
		0x7864,
		0xedcc
		},
		{
		0x7868,
		0xedba
		},
		{
		0x786a,
		0xedd2
		},
		{
		0x786b,
		0xc1f2
		},
		{
		0x786c,
		0xd3b2
		},
		{
		0x786d,
		0xedcb
		},
		{
		0x786e,
		0xf8e6
		},
		{
		0x786f,
		0xd1e2
		},
		{
		0x787c,
		0xc5f0
		},
		{
		0x7887,
		0xedd6
		},
		{
		0x7889,
		0xb5ef
		},
		{
		0x788c,
		0xc2b5
		},
		{
		0x788e,
		0xcbe9
		},
		{
		0x7891,
		0xb1ae
		},
		{
		0x7893,
		0xedd4
		},
		{
		0x7897,
		0xcdeb
		},
		{
		0x7898,
		0xb5e2
		},
		{
		0x789a,
		0xedd5
		},
		{
		0x789f,
		0xb5fa
		},
		{
		0x78a1,
		0xedd8
		},
		{
		0x78a3,
		0xedd9
		},
		{
		0x78a5,
		0xeddc
		},
		{
		0x78a7,
		0xb1cc
		},
		{
		0x78a9,
		0xcbb6
		},
		{
		0x78ad,
		0xedb8
		},
		{
		0x78b0,
		0xc5f6
		},
		{
		0x78b1,
		0xbcee
		},
		{
		0x78b2,
		0xedda
		},
		{
		0x78b3,
		0xccbc
		},
		{
		0x78b4,
		0xb2ea
		},
		{
		0x78b8,
		0xedbf
		},
		{
		0x78b9,
		0xeddb
		},
		{
		0x78ba,
		0xc8b7
		},
		{
		0x78bc,
		0xc2eb
		},
		{
		0x78be,
		0xc4eb
		},
		{
		0x78c1,
		0xb4c5
		},
		{
		0x78c5,
		0xb0f5
		},
		{
		0x78c9,
		0xeddf
		},
		{
		0x78ca,
		0xc0da
		},
		{
		0x78cb,
		0xb4e8
		},
		{
		0x78d0,
		0xc5cd
		},
		{
		0x78d4,
		0xeddd
		},
		{
		0x78d5,
		0xbfc4
		},
		{
		0x78d9,
		0xedde
		},
		{
		0x78da,
		0xd7a9
		},
		{
		0x78e3,
		0xedd7
		},
		{
		0x78e7,
		0xedd3
		},
		{
		0x78e8,
		0xc4a5
		},
		{
		0x78ec,
		0xede0
		},
		{
		0x78ef,
		0xedb6
		},
		{
		0x78f2,
		0xede1
		},
		{
		0x78f4,
		0xede3
		},
		{
		0x78f7,
		0xc1d7
		},
		{
		0x78fa,
		0xbbc7
		},
		{
		0x78fd,
		0xedcd
		},
		{
		0x7901,
		0xbdb8
		},
		{
		0x7905,
		0xede2
		},
		{
		0x790e,
		0xb4a1
		},
		{
		0x7913,
		0xede4
		},
		{
		0x7919,
		0xb0ad
		},
		{
		0x791e,
		0xede6
		},
		{
		0x7924,
		0xede5
		},
		{
		0x7926,
		0xbff3
		},
		{
		0x792a,
		0xedc2
		},
		{
		0x792b,
		0xc0f9
		},
		{
		0x792c,
		0xb7af
		},
		{
		0x7931,
		0xedc3
		},
		{
		0x7934,
		0xede7
		},
		{
		0x793a,
		0xcabe
		},
		{
		0x793b,
		0xecea
		},
		{
		0x793e,
		0xc9e7
		},
		{
		0x7940,
		0xeceb
		},
		{
		0x7941,
		0xc6ee
		},
		{
		0x7946,
		0xecec
		},
		{
		0x7948,
		0xc6ed
		},
		{
		0x7949,
		0xeced
		},
		{
		0x7953,
		0xecf0
		},
		{
		0x7956,
		0xd7e6
		},
		{
		0x7957,
		0xecf3
		},
		{
		0x795a,
		0xecf1
		},
		{
		0x795b,
		0xecee
		},
		{
		0x795c,
		0xecef
		},
		{
		0x795d,
		0xd7a3
		},
		{
		0x795e,
		0xc9f1
		},
		{
		0x795f,
		0xcbee
		},
		{
		0x7960,
		0xecf4
		},
		{
		0x7965,
		0xcfe9
		},
		{
		0x7967,
		0xecf6
		},
		{
		0x7968,
		0xc6b1
		},
		{
		0x796d,
		0xbcc0
		},
		{
		0x797a,
		0xecf7
		},
		{
		0x7980,
		0xd9f7
		},
		{
		0x7981,
		0xbdfb
		},
		{
		0x7984,
		0xc2bb
		},
		{
		0x798a,
		0xecf9
		},
		{
		0x798d,
		0xbbf6
		},
		{
		0x798e,
		0xecf5
		},
		{
		0x798f,
		0xb8a3
		},
		{
		0x799a,
		0xecfa
		},
		{
		0x79a6,
		0xf8fa
		},
		{
		0x79a7,
		0xecfb
		},
		{
		0x79aa,
		0xecf8
		},
		{
		0x79ae,
		0xc0f1
		},
		{
		0x79b0,
		0xecf2
		},
		{
		0x79b1,
		0xb5bb
		},
		{
		0x79b3,
		0xecfc
		},
		{
		0x79b9,
		0xd3ed
		},
		{
		0x79ba,
		0xd8ae
		},
		{
		0x79bd,
		0xc7dd
		},
		{
		0x79be,
		0xbacc
		},
		{
		0x79c0,
		0xd0e3
		},
		{
		0x79c1,
		0xcbbd
		},
		{
		0x79c3,
		0xcdba
		},
		{
		0x79c6,
		0xb8d1
		},
		{
		0x79c9,
		0xb1fc
		},
		{
		0x79cb,
		0xc7ef
		},
		{
		0x79cd,
		0xf9a6
		},
		{
		0x79d1,
		0xbfc6
		},
		{
		0x79d2,
		0xc3eb
		},
		{
		0x79d5,
		0xeff5
		},
		{
		0x79d8,
		0xc3d8
		},
		{
		0x79df,
		0xd7e2
		},
		{
		0x79e3,
		0xeff7
		},
		{
		0x79e4,
		0xb3d3
		},
		{
		0x79e6,
		0xc7d8
		},
		{
		0x79e7,
		0xd1ed
		},
		{
		0x79e9,
		0xd6c8
		},
		{
		0x79eb,
		0xeff8
		},
		{
		0x79ed,
		0xeff6
		},
		{
		0x79f8,
		0xbdd5
		},
		{
		0x79fb,
		0xd2c6
		},
		{
		0x7a00,
		0xcfa1
		},
		{
		0x7a02,
		0xeffc
		},
		{
		0x7a03,
		0xeffb
		},
		{
		0x7a06,
		0xeff9
		},
		{
		0x7a0b,
		0xb3cc
		},
		{
		0x7a0d,
		0xc9d4
		},
		{
		0x7a0e,
		0xcbb0
		},
		{
		0x7a14,
		0xeffe
		},
		{
		0x7a17,
		0xb0de
		},
		{
		0x7a1a,
		0xd6c9
		},
		{
		0x7a1e,
		0xeffd
		},
		{
		0x7a20,
		0xb3ed
		},
		{
		0x7a2e,
		0xd6d6
		},
		{
		0x7a31,
		0xb3c6
		},
		{
		0x7a37,
		0xf0a2
		},
		{
		0x7a39,
		0xf0a1
		},
		{
		0x7a3b,
		0xb5be
		},
		{
		0x7a3c,
		0xbcda
		},
		{
		0x7a3d,
		0xbbfc
		},
		{
		0x7a3f,
		0xb8e5
		},
		{
		0x7a40,
		0xf8b6
		},
		{
		0x7a46,
		0xc4c2
		},
		{
		0x7a4c,
		0xf6d5
		},
		{
		0x7a4d,
		0xbbfd
		},
		{
		0x7a4e,
		0xd3b1
		},
		{
		0x7a57,
		0xcbeb
		},
		{
		0x7a61,
		0xf0a3
		},
		{
		0x7a62,
		0xbbe0
		},
		{
		0x7a69,
		0xcec8
		},
		{
		0x7a6b,
		0xf8be
		},
		{
		0x7a70,
		0xf0a6
		},
		{
		0x7a74,
		0xd1a8
		},
		{
		0x7a76,
		0xbebf
		},
		{
		0x7a78,
		0xf1b6
		},
		{
		0x7a79,
		0xf1b7
		},
		{
		0x7a7a,
		0xbfd5
		},
		{
		0x7a7f,
		0xb4a9
		},
		{
		0x7a80,
		0xf1b8
		},
		{
		0x7a81,
		0xcdbb
		},
		{
		0x7a84,
		0xd5ad
		},
		{
		0x7a86,
		0xf1b9
		},
		{
		0x7a88,
		0xf1ba
		},
		{
		0x7a91,
		0xd2a4
		},
		{
		0x7a92,
		0xd6cf
		},
		{
		0x7a95,
		0xf1bb
		},
		{
		0x7a96,
		0xbdd1
		},
		{
		0x7a97,
		0xb4b0
		},
		{
		0x7a98,
		0xbebd
		},
		{
		0x7a9f,
		0xbfdf
		},
		{
		0x7aa0,
		0xf1bd
		},
		{
		0x7aa8,
		0xf1bf
		},
		{
		0x7aa9,
		0xced1
		},
		{
		0x7aaa,
		0xcddd
		},
		{
		0x7aac,
		0xf1be
		},
		{
		0x7aae,
		0xc7ee
		},
		{
		0x7ab3,
		0xf1c1
		},
		{
		0x7ab6,
		0xf1c0
		},
		{
		0x7aba,
		0xbffa
		},
		{
		0x7abf,
		0xc1fe
		},
		{
		0x7ac4,
		0xb4dc
		},
		{
		0x7ac5,
		0xc7cf
		},
		{
		0x7ac7,
		0xf1bc
		},
		{
		0x7ac8,
		0xd4ee
		},
		{
		0x7aca,
		0xc7d4
		},
		{
		0x7acb,
		0xc1a2
		},
		{
		0x7ad9,
		0xd5be
		},
		{
		0x7adf,
		0xbeb9
		},
		{
		0x7ae0,
		0xd5c2
		},
		{
		0x7ae3,
		0xbfa2
		},
		{
		0x7ae5,
		0xcdaf
		},
		{
		0x7ae6,
		0xf1b5
		},
		{
		0x7aea,
		0xcafa
		},
		{
		0x7aed,
		0xbddf
		},
		{
		0x7aef,
		0xb6cb
		},
		{
		0x7af6,
		0xbeba
		},
		{
		0x7af9,
		0xd6f1
		},
		{
		0x7afa,
		0xf3c3
		},
		{
		0x7afd,
		0xf3c4
		},
		{
		0x7aff,
		0xb8cd
		},
		{
		0x7b04,
		0xf3c7
		},
		{
		0x7b06,
		0xb0ca
		},
		{
		0x7b08,
		0xf3c5
		},
		{
		0x7b0a,
		0xf3c9
		},
		{
		0x7b0b,
		0xcbf1
		},
		{
		0x7b0f,
		0xf3cb
		},
		{
		0x7b11,
		0xd0a6
		},
		{
		0x7b19,
		0xf3cf
		},
		{
		0x7b1b,
		0xb5d1
		},
		{
		0x7b1e,
		0xf3d7
		},
		{
		0x7b20,
		0xf3d2
		},
		{
		0x7b24,
		0xf3d4
		},
		{
		0x7b25,
		0xf3d3
		},
		{
		0x7b26,
		0xb7fb
		},
		{
		0x7b28,
		0xb1bf
		},
		{
		0x7b2a,
		0xf3ce
		},
		{
		0x7b2b,
		0xf3ca
		},
		{
		0x7b2c,
		0xb5da
		},
		{
		0x7b2e,
		0xf3d0
		},
		{
		0x7b31,
		0xf3d1
		},
		{
		0x7b33,
		0xf3d5
		},
		{
		0x7b38,
		0xf3cd
		},
		{
		0x7b45,
		0xf3da
		},
		{
		0x7b46,
		0xb1ca
		},
		{
		0x7b47,
		0xf3cc
		},
		{
		0x7b49,
		0xb5c8
		},
		{
		0x7b4b,
		0xbdee
		},
		{
		0x7b4c,
		0xf3dc
		},
		{
		0x7b4f,
		0xb7a4
		},
		{
		0x7b50,
		0xbff0
		},
		{
		0x7b51,
		0xf9a8
		},
		{
		0x7b52,
		0xcdb2
		},
		{
		0x7b54,
		0xb4f0
		},
		{
		0x7b56,
		0xb2df
		},
		{
		0x7b58,
		0xf3d8
		},
		{
		0x7b60,
		0xf3de
		},
		{
		0x7b62,
		0xf3e1
		},
		{
		0x7b67,
		0xf3c8
		},
		{
		0x7b6e,
		0xf3df
		},
		{
		0x7b71,
		0xf3e3
		},
		{
		0x7b72,
		0xf3e2
		},
		{
		0x7b75,
		0xf3db
		},
		{
		0x7b77,
		0xbfea
		},
		{
		0x7b7b,
		0xf3e0
		},
		{
		0x7b85,
		0xf3eb
		},
		{
		0x7b8b,
		0xbce3
		},
		{
		0x7b8d,
		0xb9bf
		},
		{
		0x7b8f,
		0xf3dd
		},
		{
		0x7b90,
		0xf3e4
		},
		{
		0x7b94,
		0xb2ad
		},
		{
		0x7b95,
		0xbbfe
		},
		{
		0x7b97,
		0xcbe3
		},
		{
		0x7b9c,
		0xf3ed
		},
		{
		0x7b9d,
		0xf3e9
		},
		{
		0x7ba1,
		0xb9dc
		},
		{
		0x7ba2,
		0xf3ee
		},
		{
		0x7bac,
		0xf3e8
		},
		{
		0x7bad,
		0xbcfd
		},
		{
		0x7bb1,
		0xcfe4
		},
		{
		0x7bb4,
		0xf3f0
		},
		{
		0x7bb8,
		0xf3e7
		},
		{
		0x7bc0,
		0xbdda
		},
		{
		0x7bc1,
		0xf3f2
		},
		{
		0x7bc4,
		0xb7b6
		},
		{
		0x7bc6,
		0xd7ad
		},
		{
		0x7bc7,
		0xc6aa
		},
		{
		0x7bc9,
		0xd6fe
		},
		{
		0x7bcb,
		0xf3e6
		},
		{
		0x7bcc,
		0xf3f3
		},
		{
		0x7bd9,
		0xb8dd
		},
		{
		0x7bda,
		0xf3f5
		},
		{
		0x7bdd,
		0xf3f4
		},
		{
		0x7be1,
		0xb4db
		},
		{
		0x7be4,
		0xf3c6
		},
		{
		0x7be5,
		0xf3f6
		},
		{
		0x7be6,
		0xf3f7
		},
		{
		0x7be9,
		0xc9b8
		},
		{
		0x7bea,
		0xf3f8
		},
		{
		0x7bf3,
		0xf3d9
		},
		{
		0x7bf7,
		0xc5f1
		},
		{
		0x7bfc,
		0xf3fb
		},
		{
		0x7bfe,
		0xf3fa
		},
		{
		0x7c00,
		0xf3e5
		},
		{
		0x7c07,
		0xb4d8
		},
		{
		0x7c0b,
		0xf3fe
		},
		{
		0x7c0c,
		0xf3f9
		},
		{
		0x7c0d,
		0xc2a8
		},
		{
		0x7c0f,
		0xf3fc
		},
		{
		0x7c1e,
		0xf3ec
		},
		{
		0x7c1f,
		0xf4a1
		},
		{
		0x7c21,
		0xbcf2
		},
		{
		0x7c23,
		0xf3f1
		},
		{
		0x7c26,
		0xf4a3
		},
		{
		0x7c27,
		0xbbc9
		},
		{
		0x7c2a,
		0xf4a2
		},
		{
		0x7c2b,
		0xf3ef
		},
		{
		0x7c38,
		0xf4a4
		},
		{
		0x7c3d,
		0xc7a9
		},
		{
		0x7c3e,
		0xc1b1
		},
		{
		0x7c3f,
		0xb2be
		},
		{
		0x7c40,
		0xf4a6
		},
		{
		0x7c43,
		0xc0ba
		},
		{
		0x7c4c,
		0xb3ef
		},
		{
		0x7c4d,
		0xbcae
		},
		{
		0x7c5c,
		0xf3ea
		},
		{
		0x7c5f,
		0xf4a5
		},
		{
		0x7c60,
		0xc1fd
		},
		{
		0x7c64,
		0xf8e2
		},
		{
		0x7c69,
		0xf3d6
		},
		{
		0x7c6a,
		0xf3fd
		},
		{
		0x7c6c,
		0xc0e9
		},
		{
		0x7c6e,
		0xc2e1
		},
		{
		0x7c72,
		0xf8fb
		},
		{
		0x7c73,
		0xc3d7
		},
		{
		0x7c7c,
		0xf4cc
		},
		{
		0x7c7d,
		0xd7d1
		},
		{
		0x7c89,
		0xb7db
		},
		{
		0x7c91,
		0xf4ce
		},
		{
		0x7c92,
		0xc1a3
		},
		{
		0x7c95,
		0xc6c9
		},
		{
		0x7c97,
		0xb4d6
		},
		{
		0x7c98,
		0xd5b3
		},
		{
		0x7c9e,
		0xf4d1
		},
		{
		0x7c9f,
		0xcbda
		},
		{
		0x7ca2,
		0xf4d2
		},
		{
		0x7ca4,
		0xd4c1
		},
		{
		0x7ca5,
		0xd6e0
		},
		{
		0x7cb1,
		0xc1bb
		},
		{
		0x7cb2,
		0xf4d3
		},
		{
		0x7cb3,
		0xbeac
		},
		{
		0x7cb9,
		0xb4e2
		},
		{
		0x7cbc,
		0xf4d4
		},
		{
		0x7cbd,
		0xf4d5
		},
		{
		0x7cbe,
		0xbeab
		},
		{
		0x7cc5,
		0xf4db
		},
		{
		0x7cc7,
		0xf4d7
		},
		{
		0x7cc8,
		0xf4da
		},
		{
		0x7cca,
		0xbafd
		},
		{
		0x7ccc,
		0xf4d8
		},
		{
		0x7ccd,
		0xf4d9
		},
		{
		0x7cd5,
		0xb8e2
		},
		{
		0x7cd6,
		0xccc7
		},
		{
		0x7cd7,
		0xf4dc
		},
		{
		0x7cd9,
		0xb2da
		},
		{
		0x7cdc,
		0xc3d3
		},
		{
		0x7cdd,
		0xf4d6
		},
		{
		0x7cde,
		0xb7e0
		},
		{
		0x7cdf,
		0xd4e3
		},
		{
		0x7ce0,
		0xbfb7
		},
		{
		0x7ce7,
		0xc1b8
		},
		{
		0x7ce8,
		0xf4dd
		},
		{
		0x7cef,
		0xc5b4
		},
		{
		0x7cf0,
		0xf8f0
		},
		{
		0x7cf2,
		0xf4cf
		},
		{
		0x7cf4,
		0xd9e1
		},
		{
		0x7cf6,
		0xf4d0
		},
		{
		0x7cf8,
		0xf4e9
		},
		{
		0x7cf9,
		0xe6f9
		},
		{
		0x7cfb,
		0xcfb5
		},
		{
		0x7cfe,
		0xbec0
		},
		{
		0x7d00,
		0xbccd
		},
		{
		0x7d02,
		0xe6fb
		},
		{
		0x7d04,
		0xd4bc
		},
		{
		0x7d05,
		0xbaec
		},
		{
		0x7d06,
		0xe6fa
		},
		{
		0x7d07,
		0xe6fc
		},
		{
		0x7d08,
		0xe6fd
		},
		{
		0x7d09,
		0xc8d2
		},
		{
		0x7d0a,
		0xcec9
		},
		{
		0x7d0b,
		0xcec6
		},
		{
		0x7d0d,
		0xc4c9
		},
		{
		0x7d10,
		0xc5a6
		},
		{
		0x7d13,
		0xe7a3
		},
		{
		0x7d14,
		0xb4bf
		},
		{
		0x7d15,
		0xe7a2
		},
		{
		0x7d17,
		0xc9b4
		},
		{
		0x7d19,
		0xd6bd
		},
		{
		0x7d1a,
		0xbcb6
		},
		{
		0x7d1b,
		0xb7d7
		},
		{
		0x7d1c,
		0xe7a1
		},
		{
		0x7d20,
		0xcbd8
		},
		{
		0x7d21,
		0xb7c4
		},
		{
		0x7d22,
		0xcbf7
		},
		{
		0x7d2b,
		0xd7cf
		},
		{
		0x7d2f,
		0xc0db
		},
		{
		0x7d30,
		0xcfb8
		},
		{
		0x7d31,
		0xe7a6
		},
		{
		0x7d32,
		0xe7a5
		},
		{
		0x7d33,
		0xc9f0
		},
		{
		0x7d39,
		0xc9dc
		},
		{
		0x7d3a,
		0xe7a4
		},
		{
		0x7d3c,
		0xe7a8
		},
		{
		0x7d3f,
		0xe7aa
		},
		{
		0x7d40,
		0xe7a9
		},
		{
		0x7d42,
		0xd6d5
		},
		{
		0x7d44,
		0xd7e9
		},
		{
		0x7d46,
		0xb0ed
		},
		{
		0x7d4e,
		0xe7ac
		},
		{
		0x7d50,
		0xbde1
		},
		{
		0x7d5d,
		0xe7ab
		},
		{
		0x7d5e,
		0xbdca
		},
		{
		0x7d61,
		0xc2e7
		},
		{
		0x7d62,
		0xd1a4
		},
		{
		0x7d66,
		0xb8f8
		},
		{
		0x7d68,
		0xc8de
		},
		{
		0x7d6e,
		0xd0f5
		},
		{
		0x7d71,
		0xcdb3
		},
		{
		0x7d72,
		0xcbbf
		},
		{
		0x7d73,
		0xe7ad
		},
		{
		0x7d76,
		0xbef8
		},
		{
		0x7d79,
		0xbeee
		},
		{
		0x7d81,
		0xb0f3
		},
		{
		0x7d83,
		0xe7af
		},
		{
		0x7d86,
		0xe7ae
		},
		{
		0x7d88,
		0xe7b0
		},
		{
		0x7d89,
		0xd0e5
		},
		{
		0x7d8f,
		0xcbe7
		},
		{
		0x7d93,
		0xbead
		},
		{
		0x7d9c,
		0xd7db
		},
		{
		0x7d9e,
		0xe7b6
		},
		{
		0x7da2,
		0xb3f1
		},
		{
		0x7da3,
		0xe7b9
		},
		{
		0x7da6,
		0xf4eb
		},
		{
		0x7dab,
		0xcfdf
		},
		{
		0x7dac,
		0xe7b7
		},
		{
		0x7dad,
		0xceac
		},
		{
		0x7dae,
		0xf4ec
		},
		{
		0x7db0,
		0xe7ba
		},
		{
		0x7db1,
		0xb8d9
		},
		{
		0x7db2,
		0xcdf8
		},
		{
		0x7db3,
		0xb1c1
		},
		{
		0x7db4,
		0xd7ba
		},
		{
		0x7db8,
		0xc2da
		},
		{
		0x7db9,
		0xe7b8
		},
		{
		0x7dba,
		0xe7b2
		},
		{
		0x7dbb,
		0xd5c0
		},
		{
		0x7dbd,
		0xb4c2
		},
		{
		0x7dbe,
		0xe7b1
		},
		{
		0x7dbf,
		0xc3e0
		},
		{
		0x7dc4,
		0xe7b5
		},
		{
		0x7dc7,
		0xe7bb
		},
		{
		0x7dca,
		0xbdf4
		},
		{
		0x7dcb,
		0xe7b3
		},
		{
		0x7dd1,
		0xc2cc
		},
		{
		0x7dd2,
		0xd0f7
		},
		{
		0x7dd4,
		0xe7b4
		},
		{
		0x7dd7,
		0xe7bd
		},
		{
		0x7dd8,
		0xbcea
		},
		{
		0x7dd9,
		0xe7bc
		},
		{
		0x7ddd,
		0xbca9
		},
		{
		0x7dde,
		0xb6d0
		},
		{
		0x7de0,
		0xb5de
		},
		{
		0x7de1,
		0xe7c5
		},
		{
		0x7de3,
		0xd4b5
		},
		{
		0x7de6,
		0xe7c1
		},
		{
		0x7de8,
		0xb1e0
		},
		{
		0x7de9,
		0xbbba
		},
		{
		0x7dec,
		0xc3e5
		},
		{
		0x7def,
		0xceb3
		},
		{
		0x7df1,
		0xe7c3
		},
		{
		0x7df2,
		0xe7bf
		},
		{
		0x7df4,
		0xc1b7
		},
		{
		0x7df6,
		0xe7c2
		},
		{
		0x7df9,
		0xe7be
		},
		{
		0x7dfb,
		0xf9a4
		},
		{
		0x7e08,
		0xddd3
		},
		{
		0x7e09,
		0xe7c6
		},
		{
		0x7e0a,
		0xe7cb
		},
		{
		0x7e0b,
		0xe7c4
		},
		{
		0x7e10,
		0xe7a7
		},
		{
		0x7e11,
		0xe7cc
		},
		{
		0x7e1b,
		0xb8bf
		},
		{
		0x7e1d,
		0xe7c7
		},
		{
		0x7e1e,
		0xe7c9
		},
		{
		0x7e1f,
		0xe7c8
		},
		{
		0x7e23,
		0xcfd8
		},
		{
		0x7e27,
		0xccd0
		},
		{
		0x7e2b,
		0xb7ec
		},
		{
		0x7e2d,
		0xe7ca
		},
		{
		0x7e2e,
		0xcbf5
		},
		{
		0x7e31,
		0xd7dd
		},
		{
		0x7e32,
		0xe7d0
		},
		{
		0x7e34,
		0xf8e3
		},
		{
		0x7e35,
		0xe7cf
		},
		{
		0x7e36,
		0xf4ea
		},
		{
		0x7e37,
		0xc2c6
		},
		{
		0x7e39,
		0xe7ce
		},
		{
		0x7e3b,
		0xf7e3
		},
		{
		0x7e3d,
		0xd7dc
		},
		{
		0x7e3e,
		0xbca8
		},
		{
		0x7e41,
		0xb7b1
		},
		{
		0x7e45,
		0xe7d2
		},
		{
		0x7e46,
		0xe7d1
		},
		{
		0x7e47,
		0xf4ed
		},
		{
		0x7e52,
		0xe7d5
		},
		{
		0x7e54,
		0xd6af
		},
		{
		0x7e55,
		0xc9c9
		},
		{
		0x7e5a,
		0xe7d4
		},
		{
		0x7e5e,
		0xc8c6
		},
		{
		0x7e62,
		0xe7c0
		},
		{
		0x7e69,
		0xc9fe
		},
		{
		0x7e6a,
		0xbbe6
		},
		{
		0x7e6b,
		0xf8f3
		},
		{
		0x7e6d,
		0xbceb
		},
		{
		0x7e6e,
		0xe7d6
		},
		{
		0x7e6f,
		0xe7d9
		},
		{
		0x7e70,
		0xe7d8
		},
		{
		0x7e73,
		0xbdc9
		},
		{
		0x7e79,
		0xd2ef
		},
		{
		0x7e7c,
		0xbccc
		},
		{
		0x7e7d,
		0xe7cd
		},
		{
		0x7e7e,
		0xe7d7
		},
		{
		0x7e82,
		0xd7eb
		},
		{
		0x7e88,
		0xe7d3
		},
		{
		0x7e8a,
		0xe6fe
		},
		{
		0x7e8c,
		0xd0f8
		},
		{
		0x7e8d,
		0xf8cd
		},
		{
		0x7e8f,
		0xb2f8
		},
		{
		0x7e93,
		0xd3a7
		},
		{
		0x7e94,
		0xf8a6
		},
		{
		0x7e96,
		0xcfcb
		},
		{
		0x7e98,
		0xe7da
		},
		{
		0x7e9b,
		0xf4ee
		},
		{
		0x7e9c,
		0xc0c2
		},
		{
		0x7f36,
		0xf3be
		},
		{
		0x7f38,
		0xb8d7
		},
		{
		0x7f3a,
		0xc8b1
		},
		{
		0x7f44,
		0xf3c0
		},
		{
		0x7f45,
		0xf3c1
		},
		{
		0x7f4c,
		0xf3bf
		},
		{
		0x7f4e,
		0xf8ee
		},
		{
		0x7f50,
		0xb9de
		},
		{
		0x7f54,
		0xd8e8
		},
		{
		0x7f55,
		0xbab1
		},
		{
		0x7f58,
		0xeeb7
		},
		{
		0x7f5f,
		0xeeb9
		},
		{
		0x7f61,
		0xeeb8
		},
		{
		0x7f68,
		0xeebb
		},
		{
		0x7f69,
		0xd5d6
		},
		{
		0x7f6a,
		0xd7ef
		},
		{
		0x7f6e,
		0xd6c3
		},
		{
		0x7f70,
		0xb7a3
		},
		{
		0x7f71,
		0xeebd
		},
		{
		0x7f72,
		0xcaf0
		},
		{
		0x7f77,
		0xb0d5
		},
		{
		0x7f79,
		0xeebe
		},
		{
		0x7f7e,
		0xeec0
		},
		{
		0x7f85,
		0xc2de
		},
		{
		0x7f86,
		0xeebc
		},
		{
		0x7f88,
		0xeebf
		},
		{
		0x7f8a,
		0xd1f2
		},
		{
		0x7f8c,
		0xc7bc
		},
		{
		0x7f8e,
		0xc3c0
		},
		{
		0x7f94,
		0xb8e1
		},
		{
		0x7f9a,
		0xc1e7
		},
		{
		0x7f9d,
		0xf4c6
		},
		{
		0x7f9e,
		0xd0df
		},
		{
		0x7fa1,
		0xcfdb
		},
		{
		0x7fa4,
		0xc8ba
		},
		{
		0x7fa5,
		0xf4c7
		},
		{
		0x7fa7,
		0xf4c8
		},
		{
		0x7fa9,
		0xd2e5
		},
		{
		0x7faf,
		0xf4c9
		},
		{
		0x7fb0,
		0xf4ca
		},
		{
		0x7fb2,
		0xf4cb
		},
		{
		0x7fb8,
		0xd9fa
		},
		{
		0x7fb9,
		0xb8fe
		},
		{
		0x7fbc,
		0xe5f1
		},
		{
		0x7fbd,
		0xd3f0
		},
		{
		0x7fbf,
		0xf4e0
		},
		{
		0x7fc1,
		0xcecc
		},
		{
		0x7fc5,
		0xb3e1
		},
		{
		0x7fca,
		0xf1b4
		},
		{
		0x7fcc,
		0xd2ee
		},
		{
		0x7fce,
		0xf4e1
		},
		{
		0x7fd2,
		0xcfb0
		},
		{
		0x7fd4,
		0xcfe8
		},
		{
		0x7fd5,
		0xf4e2
		},
		{
		0x7fdf,
		0xb5d4
		},
		{
		0x7fe0,
		0xb4e4
		},
		{
		0x7fe1,
		0xf4e4
		},
		{
		0x7fe5,
		0xf4e3
		},
		{
		0x7fe6,
		0xf4e5
		},
		{
		0x7fe9,
		0xf4e6
		},
		{
		0x7fee,
		0xf4e7
		},
		{
		0x7ff0,
		0xbab2
		},
		{
		0x7ff1,
		0xb0bf
		},
		{
		0x7ff3,
		0xf4e8
		},
		{
		0x7ff9,
		0xc7cc
		},
		{
		0x7ffb,
		0xb7ad
		},
		{
		0x7ffc,
		0xd2ed
		},
		{
		0x8000,
		0xd2ab
		},
		{
		0x8001,
		0xc0cf
		},
		{
		0x8003,
		0xbfbc
		},
		{
		0x8004,
		0xeba3
		},
		{
		0x8005,
		0xd5df
		},
		{
		0x8006,
		0xeac8
		},
		{
		0x800b,
		0xf1f3
		},
		{
		0x800c,
		0xb6f8
		},
		{
		0x800d,
		0xcba3
		},
		{
		0x8010,
		0xc4cd
		},
		{
		0x8012,
		0xf1e7
		},
		{
		0x8014,
		0xf1e8
		},
		{
		0x8015,
		0xb8fb
		},
		{
		0x8016,
		0xf1e9
		},
		{
		0x8017,
		0xbac4
		},
		{
		0x8018,
		0xd4c5
		},
		{
		0x8019,
		0xb0d2
		},
		{
		0x801c,
		0xf1ea
		},
		{
		0x8020,
		0xf1eb
		},
		{
		0x8025,
		0xf1ed
		},
		{
		0x8026,
		0xf1ee
		},
		{
		0x8028,
		0xf1f1
		},
		{
		0x8029,
		0xf1f0
		},
		{
		0x802a,
		0xc5d5
		},
		{
		0x802c,
		0xf1ef
		},
		{
		0x802e,
		0xf1ec
		},
		{
		0x8031,
		0xf1f2
		},
		{
		0x8033,
		0xb6fa
		},
		{
		0x8035,
		0xf1f4
		},
		{
		0x8036,
		0xd2ae
		},
		{
		0x8037,
		0xdec7
		},
		{
		0x803b,
		0xb3dc
		},
		{
		0x803d,
		0xb5a2
		},
		{
		0x803f,
		0xb9a2
		},
		{
		0x8043,
		0xf1f5
		},
		{
		0x8046,
		0xf1f6
		},
		{
		0x804a,
		0xc1c4
		},
		{
		0x8052,
		0xf1f8
		},
		{
		0x8056,
		0xcaa5
		},
		{
		0x8058,
		0xc6b8
		},
		{
		0x805a,
		0xbedb
		},
		{
		0x805e,
		0xcec5
		},
		{
		0x806f,
		0xc1aa
		},
		{
		0x8070,
		0xb4cf
		},
		{
		0x8071,
		0xf1fa
		},
		{
		0x8072,
		0xc9f9
		},
		{
		0x8073,
		0xcbca
		},
		{
		0x8075,
		0xf1f9
		},
		{
		0x8076,
		0xc4f4
		},
		{
		0x8077,
		0xd6b0
		},
		{
		0x8079,
		0xf1f7
		},
		{
		0x807d,
		0xccfd
		},
		{
		0x807e,
		0xc1fb
		},
		{
		0x807f,
		0xedb2
		},
		{
		0x8080,
		0xedb1
		},
		{
		0x8084,
		0xd2de
		},
		{
		0x8085,
		0xcbe0
		},
		{
		0x8086,
		0xcbc1
		},
		{
		0x8087,
		0xd5d8
		},
		{
		0x8089,
		0xc8e2
		},
		{
		0x808b,
		0xc0df
		},
		{
		0x808c,
		0xbca1
		},
		{
		0x8093,
		0xebc1
		},
		{
		0x8096,
		0xd0a4
		},
		{
		0x8098,
		0xd6e2
		},
		{
		0x809a,
		0xb6c7
		},
		{
		0x809b,
		0xb8d8
		},
		{
		0x809c,
		0xebc0
		},
		{
		0x809d,
		0xb8ce
		},
		{
		0x809f,
		0xebbf
		},
		{
		0x80a1,
		0xb9c9
		},
		{
		0x80a2,
		0xd6ab
		},
		{
		0x80a5,
		0xb7ca
		},
		{
		0x80a9,
		0xbce7
		},
		{
		0x80aa,
		0xb7be
		},
		{
		0x80ab,
		0xebc6
		},
		{
		0x80ad,
		0xebc7
		},
		{
		0x80af,
		0xbfcf
		},
		{
		0x80b1,
		0xebc5
		},
		{
		0x80b2,
		0xd3fd
		},
		{
		0x80b4,
		0xebc8
		},
		{
		0x80b7,
		0xebc9
		},
		{
		0x80ba,
		0xb7ce
		},
		{
		0x80bc,
		0xebc2
		},
		{
		0x80bd,
		0xebc4
		},
		{
		0x80c2,
		0xebcf
		},
		{
		0x80c3,
		0xceb8
		},
		{
		0x80c4,
		0xebd0
		},
		{
		0x80cc,
		0xb1b3
		},
		{
		0x80cd,
		0xebd2
		},
		{
		0x80ce,
		0xcca5
		},
		{
		0x80d6,
		0xc5d6
		},
		{
		0x80d7,
		0xebd3
		},
		{
		0x80d9,
		0xebd1
		},
		{
		0x80da,
		0xc5df
		},
		{
		0x80db,
		0xebce
		},
		{
		0x80dd,
		0xebd5
		},
		{
		0x80de,
		0xb0fb
		},
		{
		0x80e1,
		0xbafa
		},
		{
		0x80e4,
		0xd8b7
		},
		{
		0x80e5,
		0xf1e3
		},
		{
		0x80e9,
		0xebcc
		},
		{
		0x80ec,
		0xe6c0
		},
		{
		0x80ed,
		0xebd9
		},
		{
		0x80ef,
		0xbfe8
		},
		{
		0x80f0,
		0xd2c8
		},
		{
		0x80f1,
		0xebd7
		},
		{
		0x80f2,
		0xebdc
		},
		{
		0x80f3,
		0xb8ec
		},
		{
		0x80f4,
		0xebd8
		},
		{
		0x80f8,
		0xd0d8
		},
		{
		0x80fa,
		0xb0b7
		},
		{
		0x80fc,
		0xebdd
		},
		{
		0x80fd,
		0xc4dc
		},
		{
		0x8102,
		0xd6ac
		},
		{
		0x8105,
		0xd0b2
		},
		{
		0x8106,
		0xb4e0
		},
		{
		0x8109,
		0xc2f6
		},
		{
		0x810a,
		0xbcb9
		},
		{
		0x810e,
		0xebdb
		},
		{
		0x8112,
		0xebdf
		},
		{
		0x8116,
		0xb2b1
		},
		{
		0x8118,
		0xebe4
		},
		{
		0x811a,
		0xbdc5
		},
		{
		0x811b,
		0xebd6
		},
		{
		0x811e,
		0xebe2
		},
		{
		0x812c,
		0xebe3
		},
		{
		0x812f,
		0xb8ac
		},
		{
		0x8131,
		0xcdd1
		},
		{
		0x8132,
		0xebe5
		},
		{
		0x8139,
		0xd5cd
		},
		{
		0x813e,
		0xc6a2
		},
		{
		0x8146,
		0xccf3
		},
		{
		0x8148,
		0xebe6
		},
		{
		0x814a,
		0xf8cc
		},
		{
		0x814b,
		0xd2b8
		},
		{
		0x814c,
		0xebe7
		},
		{
		0x814e,
		0xc9f6
		},
		{
		0x8150,
		0xb8af
		},
		{
		0x8151,
		0xb8ad
		},
		{
		0x8153,
		0xebe8
		},
		{
		0x8154,
		0xc7bb
		},
		{
		0x8155,
		0xcdf3
		},
		{
		0x8156,
		0xebcb
		},
		{
		0x8159,
		0xebea
		},
		{
		0x815a,
		0xebeb
		},
		{
		0x8160,
		0xebed
		},
		{
		0x8161,
		0xebe1
		},
		{
		0x8165,
		0xd0c8
		},
		{
		0x8166,
		0xc4d4
		},
		{
		0x8167,
		0xebf2
		},
		{
		0x8169,
		0xebee
		},
		{
		0x816b,
		0xd6d7
		},
		{
		0x816d,
		0xebf1
		},
		{
		0x816e,
		0xc8f9
		},
		{
		0x8170,
		0xd1fc
		},
		{
		0x8171,
		0xebec
		},
		{
		0x8174,
		0xebe9
		},
		{
		0x8178,
		0xb3a6
		},
		{
		0x8179,
		0xb8b9
		},
		{
		0x817a,
		0xcfd9
		},
		{
		0x817c,
		0xebef
		},
		{
		0x817d,
		0xebf0
		},
		{
		0x817f,
		0xcdc8
		},
		{
		0x8180,
		0xb0f2
		},
		{
		0x8182,
		0xebf6
		},
		{
		0x8188,
		0xebf5
		},
		{
		0x818a,
		0xb2b2
		},
		{
		0x818f,
		0xb8e0
		},
		{
		0x8198,
		0xb1ec
		},
		{
		0x819a,
		0xb7f4
		},
		{
		0x819b,
		0xccc5
		},
		{
		0x819c,
		0xc4a4
		},
		{
		0x819d,
		0xcfa5
		},
		{
		0x81a0,
		0xbdba
		},
		{
		0x81a3,
		0xebf9
		},
		{
		0x81a6,
		0xeca2
		},
		{
		0x81a8,
		0xc5f2
		},
		{
		0x81a9,
		0xc4e5
		},
		{
		0x81aa,
		0xebfa
		},
		{
		0x81b3,
		0xc9c5
		},
		{
		0x81ba,
		0xe2df
		},
		{
		0x81bb,
		0xebfe
		},
		{
		0x81bd,
		0xb5a8
		},
		{
		0x81be,
		0xebda
		},
		{
		0x81bf,
		0xc5a7
		},
		{
		0x81c0,
		0xcdce
		},
		{
		0x81c1,
		0xeca1
		},
		{
		0x81c2,
		0xb1db
		},
		{
		0x81c3,
		0xd3b7
		},
		{
		0x81c6,
		0xd2dc
		},
		{
		0x81c9,
		0xc1b3
		},
		{
		0x81ca,
		0xebfd
		},
		{
		0x81cc,
		0xebfb
		},
		{
		0x81cd,
		0xc6ea
		},
		{
		0x81cf,
		0xebf7
		},
		{
		0x81d8,
		0xc0b0
		},
		{
		0x81da,
		0xebcd
		},
		{
		0x81df,
		0xd4e0
		},
		{
		0x81e0,
		0xd9f5
		},
		{
		0x81e3,
		0xb3bc
		},
		{
		0x81e7,
		0xeab0
		},
		{
		0x81e8,
		0xc1d9
		},
		{
		0x81ea,
		0xd7d4
		},
		{
		0x81ec,
		0xf4ab
		},
		{
		0x81ed,
		0xb3f4
		},
		{
		0x81f3,
		0xd6c1
		},
		{
		0x81f4,
		0xd6c2
		},
		{
		0x81fa,
		0xcca8
		},
		{
		0x81fb,
		0xd5e9
		},
		{
		0x81fc,
		0xbeca
		},
		{
		0x81fe,
		0xf4a7
		},
		{
		0x8200,
		0xd2a8
		},
		{
		0x8201,
		0xf4a8
		},
		{
		0x8202,
		0xf4a9
		},
		{
		0x8204,
		0xf4aa
		},
		{
		0x8205,
		0xbecb
		},
		{
		0x8207,
		0xd3eb
		},
		{
		0x8208,
		0xd0cb
		},
		{
		0x8209,
		0xbed9
		},
		{
		0x820a,
		0xbec9
		},
		{
		0x820c,
		0xc9e0
		},
		{
		0x820d,
		0xf8e7
		},
		{
		0x8210,
		0xf3c2
		},
		{
		0x8212,
		0xcae6
		},
		{
		0x8214,
		0xccf2
		},
		{
		0x821b,
		0xe2b6
		},
		{
		0x821c,
		0xcbb4
		},
		{
		0x821e,
		0xcee8
		},
		{
		0x821f,
		0xd6db
		},
		{
		0x8221,
		0xf4ad
		},
		{
		0x8222,
		0xf4ae
		},
		{
		0x8228,
		0xf4b2
		},
		{
		0x822a,
		0xbabd
		},
		{
		0x822b,
		0xf4b3
		},
		{
		0x822c,
		0xb0e3
		},
		{
		0x822d,
		0xf4b0
		},
		{
		0x822f,
		0xf4b1
		},
		{
		0x8233,
		0xf4b6
		},
		{
		0x8234,
		0xf4b7
		},
		{
		0x8235,
		0xb6e6
		},
		{
		0x8236,
		0xb2b0
		},
		{
		0x8237,
		0xcfcf
		},
		{
		0x8238,
		0xf4b4
		},
		{
		0x8239,
		0xb4ac
		},
		{
		0x823e,
		0xf4b8
		},
		{
		0x8244,
		0xf4b9
		},
		{
		0x8247,
		0xcda7
		},
		{
		0x8249,
		0xf4ba
		},
		{
		0x824b,
		0xf4bb
		},
		{
		0x824f,
		0xf4bc
		},
		{
		0x8258,
		0xcbd2
		},
		{
		0x8259,
		0xb2d5
		},
		{
		0x825a,
		0xf4bd
		},
		{
		0x825f,
		0xf4be
		},
		{
		0x8264,
		0xf4af
		},
		{
		0x8266,
		0xbda2
		},
		{
		0x8268,
		0xf4bf
		},
		{
		0x826b,
		0xf4b5
		},
		{
		0x826e,
		0xf4de
		},
		{
		0x826f,
		0xc1bc
		},
		{
		0x8271,
		0xbce8
		},
		{
		0x8272,
		0xc9ab
		},
		{
		0x8274,
		0xe5f5
		},
		{
		0x8277,
		0xd1de
		},
		{
		0x8279,
		0xdcb3
		},
		{
		0x827d,
		0xdcb4
		},
		{
		0x827e,
		0xb0ac
		},
		{
		0x827f,
		0xdcb5
		},
		{
		0x8284,
		0xdcb9
		},
		{
		0x8288,
		0xd8c2
		},
		{
		0x828a,
		0xdcb7
		},
		{
		0x828b,
		0xd3f3
		},
		{
		0x828d,
		0xc9d6
		},
		{
		0x828e,
		0xdcba
		},
		{
		0x828f,
		0xdcb6
		},
		{
		0x8291,
		0xdcbb
		},
		{
		0x8292,
		0xc3a2
		},
		{
		0x8298,
		0xdcc5
		},
		{
		0x8299,
		0xdcbd
		},
		{
		0x829d,
		0xd6a5
		},
		{
		0x829f,
		0xdccf
		},
		{
		0x82a1,
		0xdccd
		},
		{
		0x82a4,
		0xdcd2
		},
		{
		0x82a5,
		0xbde6
		},
		{
		0x82a8,
		0xdcb8
		},
		{
		0x82a9,
		0xdccb
		},
		{
		0x82aa,
		0xdcce
		},
		{
		0x82ab,
		0xdcbe
		},
		{
		0x82ac,
		0xb7d2
		},
		{
		0x82ad,
		0xb0c5
		},
		{
		0x82ae,
		0xdcc7
		},
		{
		0x82af,
		0xd0be
		},
		{
		0x82b0,
		0xdcc1
		},
		{
		0x82b1,
		0xbba8
		},
		{
		0x82b3,
		0xb7bc
		},
		{
		0x82b4,
		0xdccc
		},
		{
		0x82b7,
		0xdcc6
		},
		{
		0x82b9,
		0xc7db
		},
		{
		0x82bb,
		0xdbbb
		},
		{
		0x82bd,
		0xd1bf
		},
		{
		0x82be,
		0xdcc0
		},
		{
		0x82c4,
		0xdcd0
		},
		{
		0x82ca,
		0xdcc3
		},
		{
		0x82d1,
		0xd4b7
		},
		{
		0x82d2,
		0xdcdb
		},
		{
		0x82d3,
		0xdcdf
		},
		{
		0x82d4,
		0xcca6
		},
		{
		0x82d5,
		0xdce6
		},
		{
		0x82d7,
		0xc3e7
		},
		{
		0x82d8,
		0xdcdc
		},
		{
		0x82db,
		0xbfc1
		},
		{
		0x82dc,
		0xdcd9
		},
		{
		0x82de,
		0xb0fa
		},
		{
		0x82df,
		0xb9b6
		},
		{
		0x82e0,
		0xdce5
		},
		{
		0x82e1,
		0xdcd3
		},
		{
		0x82e3,
		0xdcc4
		},
		{
		0x82e4,
		0xdcd6
		},
		{
		0x82e5,
		0xc8f4
		},
		{
		0x82e6,
		0xbfe0
		},
		{
		0x82e7,
		0xdcd1
		},
		{
		0x82eb,
		0xc9bb
		},
		{
		0x82ef,
		0xb1bd
		},
		{
		0x82f1,
		0xd3a2
		},
		{
		0x82f4,
		0xdcda
		},
		{
		0x82f7,
		0xdcd5
		},
		{
		0x82f9,
		0xf8dc
		},
		{
		0x82fb,
		0xdcde
		},
		{
		0x8301,
		0xd7c2
		},
		{
		0x8302,
		0xc3af
		},
		{
		0x8303,
		0xf8b2
		},
		{
		0x8304,
		0xc7d1
		},
		{
		0x8305,
		0xc3a9
		},
		{
		0x8306,
		0xdce2
		},
		{
		0x8307,
		0xdcd8
		},
		{
		0x8308,
		0xdceb
		},
		{
		0x8309,
		0xdcd4
		},
		{
		0x830c,
		0xdcdd
		},
		{
		0x8317,
		0xdcf8
		},
		{
		0x831a,
		0xdce1
		},
		{
		0x831b,
		0xdda2
		},
		{
		0x831c,
		0xdce7
		},
		{
		0x8328,
		0xb4c4
		},
		{
		0x832b,
		0xc3a3
		},
		{
		0x832c,
		0xb2e7
		},
		{
		0x832d,
		0xdcfa
		},
		{
		0x832f,
		0xdcf2
		},
		{
		0x8331,
		0xdcef
		},
		{
		0x8333,
		0xdcfc
		},
		{
		0x8334,
		0xdcee
		},
		{
		0x8335,
		0xd2f0
		},
		{
		0x8336,
		0xb2e8
		},
		{
		0x8338,
		0xc8d7
		},
		{
		0x8339,
		0xc8e3
		},
		{
		0x833a,
		0xdcfb
		},
		{
		0x833c,
		0xdced
		},
		{
		0x8340,
		0xdcf7
		},
		{
		0x8343,
		0xdcf5
		},
		{
		0x8346,
		0xbea3
		},
		{
		0x8347,
		0xdcf4
		},
		{
		0x8349,
		0xb2dd
		},
		{
		0x834f,
		0xdcf3
		},
		{
		0x8350,
		0xf8c3
		},
		{
		0x8351,
		0xdce8
		},
		{
		0x8352,
		0xbbc4
		},
		{
		0x8354,
		0xc0f3
		},
		{
		0x8377,
		0xbac9
		},
		{
		0x8378,
		0xdda9
		},
		{
		0x837b,
		0xddb6
		},
		{
		0x837c,
		0xddb1
		},
		{
		0x837d,
		0xddb4
		},
		{
		0x8385,
		0xddb0
		},
		{
		0x8386,
		0xc6ce
		},
		{
		0x8389,
		0xc0f2
		},
		{
		0x838a,
		0xd7af
		},
		{
		0x838e,
		0xc9af
		},
		{
		0x8392,
		0xdcec
		},
		{
		0x8393,
		0xddae
		},
		{
		0x8396,
		0xbea5
		},
		{
		0x8398,
		0xddb7
		},
		{
		0x839b,
		0xdcf0
		},
		{
		0x839c,
		0xddaf
		},
		{
		0x839e,
		0xddb8
		},
		{
		0x83a0,
		0xddac
		},
		{
		0x83a2,
		0xbcd4
		},
		{
		0x83a7,
		0xdcc8
		},
		{
		0x83a8,
		0xddb9
		},
		{
		0x83a9,
		0xddb3
		},
		{
		0x83aa,
		0xddad
		},
		{
		0x83ab,
		0xc4aa
		},
		{
		0x83b0,
		0xdda8
		},
		{
		0x83bd,
		0xc3a7
		},
		{
		0x83c0,
		0xddd2
		},
		{
		0x83c1,
		0xddbc
		},
		{
		0x83c5,
		0xddd1
		},
		{
		0x83c7,
		0xb9bd
		},
		{
		0x83ca,
		0xbed5
		},
		{
		0x83cc,
		0xbefa
		},
		{
		0x83cf,
		0xbaca
		},
		{
		0x83d4,
		0xddca
		},
		{
		0x83d6,
		0xddc5
		},
		{
		0x83d8,
		0xddbf
		},
		{
		0x83dc,
		0xb2cb
		},
		{
		0x83dd,
		0xddc3
		},
		{
		0x83df,
		0xddcb
		},
		{
		0x83e0,
		0xb2a4
		},
		{
		0x83e1,
		0xddd5
		},
		{
		0x83e5,
		0xddbe
		},
		{
		0x83e9,
		0xc6d0
		},
		{
		0x83ea,
		0xddd0
		},
		{
		0x83ef,
		0xbbaa
		},
		{
		0x83f0,
		0xddd4
		},
		{
		0x83f1,
		0xc1e2
		},
		{
		0x83f2,
		0xb7c6
		},
		{
		0x83f8,
		0xddce
		},
		{
		0x83f9,
		0xddcf
		},
		{
		0x83fd,
		0xddc4
		},
		{
		0x8401,
		0xddbd
		},
		{
		0x8403,
		0xddcd
		},
		{
		0x8404,
		0xccd1
		},
		{
		0x8406,
		0xddc9
		},
		{
		0x8407,
		0xdcc9
		},
		{
		0x840a,
		0xc0b3
		},
		{
		0x840b,
		0xddc2
		},
		{
		0x840c,
		0xc3c8
		},
		{
		0x840d,
		0xc6bc
		},
		{
		0x840e,
		0xceae
		},
		{
		0x840f,
		0xddcc
		},
		{
		0x8411,
		0xddc8
		},
		{
		0x8418,
		0xddc1
		},
		{
		0x841c,
		0xddc6
		},
		{
		0x842c,
		0xcdf2
		},
		{
		0x8431,
		0xdde6
		},
		{
		0x8435,
		0xddab
		},
		{
		0x8438,
		0xddc7
		},
		{
		0x843c,
		0xdde0
		},
		{
		0x843d,
		0xc2e4
		},
		{
		0x8446,
		0xdde1
		},
		{
		0x8449,
		0xd2b6
		},
		{
		0x8451,
		0xddd7
		},
		{
		0x8452,
		0xdda6
		},
		{
		0x8457,
		0xd6f8
		},
		{
		0x8459,
		0xddd9
		},
		{
		0x845a,
		0xddd8
		},
		{
		0x845b,
		0xb8f0
		},
		{
		0x845c,
		0xddd6
		},
		{
		0x8461,
		0xc6cf
		},
		{
		0x8463,
		0xb6ad
		},
		{
		0x8464,
		0xdda7
		},
		{
		0x8466,
		0xcead
		},
		{
		0x8469,
		0xdde2
		},
		{
		0x846b,
		0xbaf9
		},
		{
		0x846c,
		0xd4e1
		},
		{
		0x846d,
		0xdde7
		},
		{
		0x846f,
		0xf8f7
		},
		{
		0x8471,
		0xb4d0
		},
		{
		0x8473,
		0xddda
		},
		{
		0x8475,
		0xbffb
		},
		{
		0x8476,
		0xdde3
		},
		{
		0x8477,
		0xbbe7
		},
		{
		0x8478,
		0xdddf
		},
		{
		0x847a,
		0xdddd
		},
		{
		0x8482,
		0xb5d9
		},
		{
		0x8488,
		0xdddc
		},
		{
		0x848e,
		0xdde5
		},
		{
		0x8493,
		0xddbb
		},
		{
		0x8494,
		0xddaa
		},
		{
		0x8497,
		0xddf5
		},
		{
		0x8499,
		0xc3c9
		},
		{
		0x849c,
		0xcbe2
		},
		{
		0x84a1,
		0xddf2
		},
		{
		0x84af,
		0xd8e1
		},
		{
		0x84b2,
		0xc6d1
		},
		{
		0x84b4,
		0xddf4
		},
		{
		0x84b8,
		0xd5f4
		},
		{
		0x84b9,
		0xddf3
		},
		{
		0x84ba,
		0xddf0
		},
		{
		0x84bc,
		0xb2d4
		},
		{
		0x84bd,
		0xddec
		},
		{
		0x84bf,
		0xddef
		},
		{
		0x84c0,
		0xdda5
		},
		{
		0x84c1,
		0xdde8
		},
		{
		0x84c4,
		0xd0ee
		},
		{
		0x84c9,
		0xc8d8
		},
		{
		0x84ca,
		0xddee
		},
		{
		0x84cb,
		0xb8c7
		},
		{
		0x84cd,
		0xdde9
		},
		{
		0x84d0,
		0xddea
		},
		{
		0x84d1,
		0xcbf2
		},
		{
		0x84d3,
		0xdded
		},
		{
		0x84d6,
		0xb1cd
		},
		{
		0x84ec,
		0xc5ee
		},
		{
		0x84ee,
		0xc1ab
		},
		{
		0x84ef,
		0xdcca
		},
		{
		0x84f0,
		0xddfb
		},
		{
		0x84fc,
		0xdea4
		},
		{
		0x84fd,
		0xdcea
		},
		{
		0x84ff,
		0xdea3
		},
		{
		0x850c,
		0xddf8
		},
		{
		0x8511,
		0xc3ef
		},
		{
		0x8513,
		0xc2fb
		},
		{
		0x8514,
		0xf8a5
		},
		{
		0x8517,
		0xd5e1
		},
		{
		0x851a,
		0xceb5
		},
		{
		0x851e,
		0xdde4
		},
		{
		0x851f,
		0xddfd
		},
		{
		0x8521,
		0xb2cc
		},
		{
		0x8523,
		0xbdaf
		},
		{
		0x8526,
		0xdce0
		},
		{
		0x852b,
		0xc4e8
		},
		{
		0x852c,
		0xcadf
		},
		{
		0x852d,
		0xd2f1
		},
		{
		0x8538,
		0xddfa
		},
		{
		0x853b,
		0xdea2
		},
		{
		0x853d,
		0xb1ce
		},
		{
		0x8541,
		0xdda1
		},
		{
		0x8543,
		0xdeac
		},
		{
		0x8546,
		0xdddb
		},
		{
		0x8548,
		0xdea6
		},
		{
		0x8549,
		0xbdb6
		},
		{
		0x854a,
		0xc8ef
		},
		{
		0x854e,
		0xdcf1
		},
		{
		0x8552,
		0xdda4
		},
		{
		0x8553,
		0xdcbf
		},
		{
		0x8555,
		0xddb5
		},
		{
		0x8556,
		0xdea1
		},
		{
		0x8558,
		0xdce9
		},
		{
		0x8559,
		0xdea5
		},
		{
		0x855e,
		0xdea9
		},
		{
		0x8562,
		0xddde
		},
		{
		0x8564,
		0xdea8
		},
		{
		0x8568,
		0xdea7
		},
		{
		0x8569,
		0xb5b4
		},
		{
		0x856a,
		0xcedf
		},
		{
		0x856d,
		0xcff4
		},
		{
		0x8577,
		0xddf7
		},
		{
		0x8579,
		0xdeb3
		},
		{
		0x857a,
		0xdeaa
		},
		{
		0x857b,
		0xdeae
		},
		{
		0x857e,
		0xc0d9
		},
		{
		0x8584,
		0xb1a1
		},
		{
		0x8585,
		0xdeb6
		},
		{
		0x8587,
		0xdeb1
		},
		{
		0x8588,
		0xdcf6
		},
		{
		0x858a,
		0xbcbb
		},
		{
		0x858c,
		0xdcbc
		},
		{
		0x858f,
		0xdeb2
		},
		{
		0x8591,
		0xf8c4
		},
		{
		0x8594,
		0xc7be
		},
		{
		0x859b,
		0xd1a6
		},
		{
		0x859c,
		0xdeb5
		},
		{
		0x859f,
		0xddb2
		},
		{
		0x85a4,
		0xdeaf
		},
		{
		0x85a6,
		0xbcf6
		},
		{
		0x85a8,
		0xdeb0
		},
		{
		0x85a9,
		0xc8f8
		},
		{
		0x85aa,
		0xd0bd
		},
		{
		0x85af,
		0xcaed
		},
		{
		0x85b0,
		0xdeb9
		},
		{
		0x85b7,
		0xdeb8
		},
		{
		0x85b9,
		0xdeb7
		},
		{
		0x85ba,
		0xdcf9
		},
		{
		0x85c1,
		0xdebb
		},
		{
		0x85c9,
		0xbde5
		},
		{
		0x85cd,
		0xc0b6
		},
		{
		0x85ce,
		0xdda3
		},
		{
		0x85cf,
		0xb2d8
		},
		{
		0x85d0,
		0xc3ea
		},
		{
		0x85d5,
		0xc5ba
		},
		{
		0x85dc,
		0xdebc
		},
		{
		0x85dd,
		0xd2d5
		},
		{
		0x85e4,
		0xccd9
		},
		{
		0x85e5,
		0xd2a9
		},
		{
		0x85e9,
		0xb7aa
		},
		{
		0x85ea,
		0xdeb4
		},
		{
		0x85f4,
		0xd4cc
		},
		{
		0x85f6,
		0xdcc2
		},
		{
		0x85f9,
		0xb0aa
		},
		{
		0x85fa,
		0xddfe
		},
		{
		0x85fb,
		0xd4e5
		},
		{
		0x85ff,
		0xdebd
		},
		{
		0x8604,
		0xdead
		},
		{
		0x8605,
		0xdebf
		},
		{
		0x8606,
		0xc2ab
		},
		{
		0x8607,
		0xcbd5
		},
		{
		0x860b,
		0xc6bb
		},
		{
		0x8611,
		0xc4a2
		},
		{
		0x8616,
		0xdec1
		},
		{
		0x861a,
		0xdeba
		},
		{
		0x861e,
		0xddfc
		},
		{
		0x8622,
		0xdcd7
		},
		{
		0x8627,
		0xdebe
		},
		{
		0x8629,
		0xdec0
		},
		{
		0x862d,
		0xc0bc
		},
		{
		0x8638,
		0xd5ba
		},
		{
		0x863a,
		0xddf1
		},
		{
		0x863c,
		0xdec2
		},
		{
		0x863f,
		0xc2dc
		},
		{
		0x864d,
		0xf2ae
		},
		{
		0x864e,
		0xbba2
		},
		{
		0x8650,
		0xc5b0
		},
		{
		0x8654,
		0xf2af
		},
		{
		0x8655,
		0xb4a6
		},
		{
		0x865a,
		0xd0e9
		},
		{
		0x865c,
		0xc2b2
		},
		{
		0x865e,
		0xd3dd
		},
		{
		0x865f,
		0xbac5
		},
		{
		0x8662,
		0xebbd
		},
		{
		0x8667,
		0xbff7
		},
		{
		0x866c,
		0xf2b0
		},
		{
		0x8671,
		0xcaad
		},
		{
		0x8679,
		0xbae7
		},
		{
		0x867a,
		0xf2b3
		},
		{
		0x867b,
		0xf2b5
		},
		{
		0x867c,
		0xf2b4
		},
		{
		0x868a,
		0xcec3
		},
		{
		0x868b,
		0xf2b8
		},
		{
		0x868c,
		0xb0f6
		},
		{
		0x868d,
		0xf2b7
		},
		{
		0x8693,
		0xf2be
		},
		{
		0x869c,
		0xd1c1
		},
		{
		0x869d,
		0xf2ba
		},
		{
		0x86a3,
		0xf2bc
		},
		{
		0x86a4,
		0xd4e9
		},
		{
		0x86a7,
		0xf2bb
		},
		{
		0x86a8,
		0xf2b6
		},
		{
		0x86a9,
		0xf2bf
		},
		{
		0x86aa,
		0xf2bd
		},
		{
		0x86af,
		0xf2c7
		},
		{
		0x86b0,
		0xf2c4
		},
		{
		0x86b1,
		0xf2c6
		},
		{
		0x86b4,
		0xf2ca
		},
		{
		0x86b5,
		0xf2c2
		},
		{
		0x86b6,
		0xf2c0
		},
		{
		0x86ba,
		0xf2c5
		},
		{
		0x86c0,
		0xd6fb
		},
		{
		0x86c4,
		0xf2c1
		},
		{
		0x86c6,
		0xc7f9
		},
		{
		0x86c7,
		0xc9df
		},
		{
		0x86c9,
		0xf2c8
		},
		{
		0x86cb,
		0xb5b0
		},
		{
		0x86d0,
		0xf2d0
		},
		{
		0x86d1,
		0xf2d6
		},
		{
		0x86d4,
		0xbbd7
		},
		{
		0x86d8,
		0xf2d5
		},
		{
		0x86d9,
		0xcddc
		},
		{
		0x86db,
		0xd6eb
		},
		{
		0x86de,
		0xf2d2
		},
		{
		0x86df,
		0xf2d4
		},
		{
		0x86e4,
		0xb8f2
		},
		{
		0x86e9,
		0xf2cb
		},
		{
		0x86ed,
		0xf2ce
		},
		{
		0x86f8,
		0xf2d9
		},
		{
		0x86f9,
		0xd3bc
		},
		{
		0x86fa,
		0xf2cc
		},
		{
		0x86fe,
		0xb6ea
		},
		{
		0x8700,
		0xcaf1
		},
		{
		0x8702,
		0xb7e4
		},
		{
		0x8703,
		0xf2d7
		},
		{
		0x8706,
		0xf2b9
		},
		{
		0x8707,
		0xf2d8
		},
		{
		0x8708,
		0xf2da
		},
		{
		0x8709,
		0xf2dd
		},
		{
		0x870a,
		0xf2db
		},
		{
		0x870d,
		0xf2dc
		},
		{
		0x8712,
		0xd1d1
		},
		{
		0x8713,
		0xf2d1
		},
		{
		0x8715,
		0xcdc9
		},
		{
		0x8718,
		0xd6a9
		},
		{
		0x871a,
		0xf2e3
		},
		{
		0x871c,
		0xc3db
		},
		{
		0x871e,
		0xf2e0
		},
		{
		0x8721,
		0xf8cb
		},
		{
		0x8722,
		0xf2ec
		},
		{
		0x8723,
		0xf2de
		},
		{
		0x8725,
		0xf2e1
		},
		{
		0x8729,
		0xf2e8
		},
		{
		0x872e,
		0xf2e2
		},
		{
		0x8731,
		0xf2e7
		},
		{
		0x8734,
		0xf2e6
		},
		{
		0x8737,
		0xf2e9
		},
		{
		0x873b,
		0xf2df
		},
		{
		0x873e,
		0xf2e4
		},
		{
		0x873f,
		0xf2ea
		},
		{
		0x874c,
		0xf2f2
		},
		{
		0x874e,
		0xd0ab
		},
		{
		0x8753,
		0xf2f5
		},
		{
		0x8755,
		0xcab4
		},
		{
		0x8757,
		0xbbc8
		},
		{
		0x8759,
		0xf2f9
		},
		{
		0x8760,
		0xf2f0
		},
		{
		0x8763,
		0xf2f6
		},
		{
		0x8764,
		0xf2f8
		},
		{
		0x8765,
		0xf2fa
		},
		{
		0x8766,
		0xcfba
		},
		{
		0x876e,
		0xf2f3
		},
		{
		0x8770,
		0xf2f1
		},
		{
		0x8774,
		0xbafb
		},
		{
		0x8776,
		0xb5fb
		},
		{
		0x8778,
		0xcecf
		},
		{
		0x877b,
		0xf2ef
		},
		{
		0x877d,
		0xf2ed
		},
		{
		0x8782,
		0xf2eb
		},
		{
		0x8783,
		0xf3a6
		},
		{
		0x8784,
		0xf2cf
		},
		{
		0x8785,
		0xf3a3
		},
		{
		0x8788,
		0xf3a2
		},
		{
		0x878b,
		0xf2f4
		},
		{
		0x878d,
		0xc8da
		},
		{
		0x8793,
		0xf2fb
		},
		{
		0x8797,
		0xf3a5
		},
		{
		0x879e,
		0xc2ec
		},
		{
		0x879f,
		0xc3f8
		},
		{
		0x87a2,
		0xd3a9
		},
		{
		0x87ab,
		0xf3a7
		},
		{
		0x87ac,
		0xf3a9
		},
		{
		0x87ad,
		0xf3a4
		},
		{
		0x87af,
		0xf2fc
		},
		{
		0x87b3,
		0xf3ab
		},
		{
		0x87b5,
		0xf3aa
		},
		{
		0x87ba,
		0xc2dd
		},
		{
		0x87bb,
		0xf2f7
		},
		{
		0x87bd,
		0xf3ae
		},
		{
		0x87c0,
		0xf3b0
		},
		{
		0x87c4,
		0xd5dd
		},
		{
		0x87c6,
		0xf3a1
		},
		{
		0x87c8,
		0xf2e5
		},
		{
		0x87ca,
		0xf3b1
		},
		{
		0x87cb,
		0xf3ac
		},
		{
		0x87ce,
		0xf2fd
		},
		{
		0x87d1,
		0xf3af
		},
		{
		0x87d2,
		0xf2fe
		},
		{
		0x87d3,
		0xf3ad
		},
		{
		0x87db,
		0xf3b2
		},
		{
		0x87e0,
		0xf3b4
		},
		{
		0x87e3,
		0xf2b1
		},
		{
		0x87e5,
		0xf3a8
		},
		{
		0x87ea,
		0xf3b3
		},
		{
		0x87ec,
		0xb2f5
		},
		{
		0x87ee,
		0xf3b5
		},
		{
		0x87ef,
		0xf2cd
		},
		{
		0x87f2,
		0xb3e6
		},
		{
		0x87f6,
		0xf2c9
		},
		{
		0x87f9,
		0xd0b7
		},
		{
		0x87fb,
		0xd2cf
		},
		{
		0x87fe,
		0xf3b8
		},
		{
		0x8803,
		0xd9f9
		},
		{
		0x8805,
		0xd3ac
		},
		{
		0x8806,
		0xf2b2
		},
		{
		0x880a,
		0xf3b9
		},
		{
		0x8810,
		0xf2d3
		},
		{
		0x8811,
		0xf2ee
		},
		{
		0x8813,
		0xf3b7
		},
		{
		0x8815,
		0xc8e4
		},
		{
		0x8816,
		0xf3b6
		},
		{
		0x881b,
		0xf3ba
		},
		{
		0x881f,
		0xc0af
		},
		{
		0x8821,
		0xf3bb
		},
		{
		0x8822,
		0xb4c0
		},
		{
		0x8823,
		0xf2c3
		},
		{
		0x8831,
		0xb9c6
		},
		{
		0x8832,
		0xeec3
		},
		{
		0x8836,
		0xb2cf
		},
		{
		0x8839,
		0xf3bc
		},
		{
		0x883b,
		0xc2f9
		},
		{
		0x883c,
		0xf3bd
		},
		{
		0x8840,
		0xd1aa
		},
		{
		0x8844,
		0xf4ac
		},
		{
		0x8846,
		0xd6da
		},
		{
		0x884a,
		0xf8da
		},
		{
		0x884c,
		0xd0d0
		},
		{
		0x884d,
		0xd1dc
		},
		{
		0x8853,
		0xcaf5
		},
		{
		0x8857,
		0xbdd6
		},
		{
		0x8859,
		0xd1c3
		},
		{
		0x885b,
		0xcec0
		},
		{
		0x885d,
		0xb3e5
		},
		{
		0x8861,
		0xbae2
		},
		{
		0x8862,
		0xe1e9
		},
		{
		0x8863,
		0xd2c2
		},
		{
		0x8864,
		0xf1c2
		},
		{
		0x8868,
		0xb1ed
		},
		{
		0x8869,
		0xf1c3
		},
		{
		0x886b,
		0xc9c0
		},
		{
		0x886e,
		0xd9f2
		},
		{
		0x8870,
		0xcba5
		},
		{
		0x8872,
		0xf1c4
		},
		{
		0x8877,
		0xd6d4
		},
		{
		0x8879,
		0xd6bb
		},
		{
		0x887d,
		0xf1c5
		},
		{
		0x887e,
		0xf4c0
		},
		{
		0x887f,
		0xf1c6
		},
		{
		0x8881,
		0xd4ac
		},
		{
		0x8882,
		0xf1c7
		},
		{
		0x8888,
		0xf4c2
		},
		{
		0x888b,
		0xb4fc
		},
		{
		0x888d,
		0xc5db
		},
		{
		0x8892,
		0xccbb
		},
		{
		0x8896,
		0xd0e4
		},
		{
		0x88a2,
		0xf1c8
		},
		{
		0x88a4,
		0xd9f3
		},
		{
		0x88ab,
		0xb1bb
		},
		{
		0x88b1,
		0xb8a4
		},
		{
		0x88b7,
		0xf1ca
		},
		{
		0x88bc,
		0xf1cb
		},
		{
		0x88c1,
		0xb2c3
		},
		{
		0x88c2,
		0xc1d1
		},
		{
		0x88c9,
		0xf1cc
		},
		{
		0x88ca,
		0xf4c1
		},
		{
		0x88ce,
		0xf1ce
		},
		{
		0x88cf,
		0xc0ef
		},
		{
		0x88d2,
		0xd9f6
		},
		{
		0x88d4,
		0xd2e1
		},
		{
		0x88d5,
		0xd4a3
		},
		{
		0x88d8,
		0xf4c3
		},
		{
		0x88d9,
		0xc8b9
		},
		{
		0x88dc,
		0xb2b9
		},
		{
		0x88dd,
		0xd7b0
		},
		{
		0x88df,
		0xf4c4
		},
		{
		0x88e8,
		0xf1d4
		},
		{
		0x88f0,
		0xf1d6
		},
		{
		0x88f1,
		0xf1d1
		},
		{
		0x88f3,
		0xc9d1
		},
		{
		0x88f4,
		0xc5e1
		},
		{
		0x88f8,
		0xc2e3
		},
		{
		0x88f9,
		0xb9fc
		},
		{
		0x88fc,
		0xf1d3
		},
		{
		0x88fd,
		0xf9a5
		},
		{
		0x88fe,
		0xf1d5
		},
		{
		0x8902,
		0xb9d3
		},
		{
		0x8907,
		0xf8b4
		},
		{
		0x890a,
		0xf1db
		},
		{
		0x8910,
		0xbad6
		},
		{
		0x8912,
		0xb0fd
		},
		{
		0x8913,
		0xf1d9
		},
		{
		0x8919,
		0xf1d8
		},
		{
		0x891a,
		0xf1d2
		},
		{
		0x8921,
		0xf1d7
		},
		{
		0x8925,
		0xc8ec
		},
		{
		0x892a,
		0xcdca
		},
		{
		0x892b,
		0xf1dd
		},
		{
		0x8930,
		0xe5bd
		},
		{
		0x8932,
		0xbfe3
		},
		{
		0x8933,
		0xf1cd
		},
		{
		0x8936,
		0xf1de
		},
		{
		0x8938,
		0xf1da
		},
		{
		0x893b,
		0xd9f4
		},
		{
		0x8941,
		0xf1df
		},
		{
		0x8944,
		0xcfe5
		},
		{
		0x8947,
		0xf1d0
		},
		{
		0x8956,
		0xb0c0
		},
		{
		0x895d,
		0xf1cf
		},
		{
		0x895e,
		0xf4c5
		},
		{
		0x895f,
		0xbdf3
		},
		{
		0x8960,
		0xf1c9
		},
		{
		0x8964,
		0xf1dc
		},
		{
		0x8966,
		0xf1e0
		},
		{
		0x896a,
		0xcde0
		},
		{
		0x896c,
		0xf8a1
		},
		{
		0x896f,
		0xb3c4
		},
		{
		0x8972,
		0xcfae
		},
		{
		0x897b,
		0xf1e1
		},
		{
		0x897f,
		0xcef7
		},
		{
		0x8981,
		0xd2aa
		},
		{
		0x8983,
		0xf1fb
		},
		{
		0x8986,
		0xb8b2
		},
		{
		0x898b,
		0xbcfb
		},
		{
		0x898f,
		0xb9e6
		},
		{
		0x8993,
		0xc3d9
		},
		{
		0x8996,
		0xcad3
		},
		{
		0x8998,
		0xeae8
		},
		{
		0x89a1,
		0xeaea
		},
		{
		0x89a6,
		0xeaec
		},
		{
		0x89aa,
		0xc7d7
		},
		{
		0x89ac,
		0xeae9
		},
		{
		0x89af,
		0xeaed
		},
		{
		0x89b2,
		0xeaee
		},
		{
		0x89b7,
		0xeaef
		},
		{
		0x89ba,
		0xbef5
		},
		{
		0x89bd,
		0xc0c0
		},
		{
		0x89bf,
		0xeaeb
		},
		{
		0x89c0,
		0xb9db
		},
		{
		0x89d2,
		0xbdc7
		},
		{
		0x89d6,
		0xf5fb
		},
		{
		0x89da,
		0xf5fd
		},
		{
		0x89dc,
		0xf5fe
		},
		{
		0x89e3,
		0xbde2
		},
		{
		0x89e5,
		0xf6a1
		},
		{
		0x89eb,
		0xf6a2
		},
		{
		0x89f3,
		0xecb2
		},
		{
		0x89f4,
		0xf5fc
		},
		{
		0x89f6,
		0xf6a3
		},
		{
		0x89f8,
		0xb4a5
		},
		{
		0x8a00,
		0xd1d4
		},
		{
		0x8a01,
		0xdaa5
		},
		{
		0x8a02,
		0xb6a9
		},
		{
		0x8a03,
		0xb8bc
		},
		{
		0x8a07,
		0xd9ea
		},
		{
		0x8a08,
		0xbcc6
		},
		{
		0x8a0a,
		0xd1b6
		},
		{
		0x8a0c,
		0xdaa7
		},
		{
		0x8a0e,
		0xccd6
		},
		{
		0x8a10,
		0xdaa6
		},
		{
		0x8a13,
		0xd1b5
		},
		{
		0x8a15,
		0xdaa8
		},
		{
		0x8a16,
		0xc6fd
		},
		{
		0x8a18,
		0xbcc7
		},
		{
		0x8a1b,
		0xb6ef
		},
		{
		0x8a1d,
		0xd1c8
		},
		{
		0x8a1f,
		0xcbcf
		},
		{
		0x8a23,
		0xbef7
		},
		{
		0x8a25,
		0xdaab
		},
		{
		0x8a2a,
		0xb7c3
		},
		{
		0x8a2d,
		0xc9e8
		},
		{
		0x8a31,
		0xd0ed
		},
		{
		0x8a34,
		0xcbdf
		},
		{
		0x8a36,
		0xdaad
		},
		{
		0x8a3a,
		0xd5ef
		},
		{
		0x8a3e,
		0xf6a4
		},
		{
		0x8a41,
		0xdaac
		},
		{
		0x8a46,
		0xdaae
		},
		{
		0x8a48,
		0xeeba
		},
		{
		0x8a4e,
		0xdaaa
		},
		{
		0x8a50,
		0xd5a9
		},
		{
		0x8a52,
		0xdab1
		},
		{
		0x8a54,
		0xdaaf
		},
		{
		0x8a55,
		0xc6c0
		},
		{
		0x8a58,
		0xdab0
		},
		{
		0x8a5b,
		0xd7e7
		},
		{
		0x8a5e,
		0xb4ca
		},
		{
		0x8a61,
		0xdabc
		},
		{
		0x8a62,
		0xd1af
		},
		{
		0x8a63,
		0xd2e8
		},
		{
		0x8a66,
		0xcad4
		},
		{
		0x8a69,
		0xcaab
		},
		{
		0x8a6b,
		0xb2ef
		},
		{
		0x8a6c,
		0xdab8
		},
		{
		0x8a6d,
		0xb9ee
		},
		{
		0x8a6e,
		0xdab9
		},
		{
		0x8a70,
		0xdab5
		},
		{
		0x8a71,
		0xbbb0
		},
		{
		0x8a72,
		0xb8c3
		},
		{
		0x8a73,
		0xcfea
		},
		{
		0x8a75,
		0xdab7
		},
		{
		0x8a79,
		0xd5b2
		},
		{
		0x8a7c,
		0xdab6
		},
		{
		0x8a7f,
		0xdab4
		},
		{
		0x8a84,
		0xdab3
		},
		{
		0x8a85,
		0xd6ef
		},
		{
		0x8a86,
		0xdab2
		},
		{
		0x8a87,
		0xbfe4
		},
		{
		0x8a8d,
		0xc8cf
		},
		{
		0x8a91,
		0xdabf
		},
		{
		0x8a92,
		0xdac0
		},
		{
		0x8a93,
		0xcac4
		},
		{
		0x8a95,
		0xb5ae
		},
		{
		0x8a98,
		0xd3d5
		},
		{
		0x8a9a,
		0xdabd
		},
		{
		0x8a9e,
		0xd3ef
		},
		{
		0x8aa0,
		0xb3cf
		},
		{
		0x8aa1,
		0xbdeb
		},
		{
		0x8aa3,
		0xcedc
		},
		{
		0x8aa4,
		0xcef3
		},
		{
		0x8aa5,
		0xdabe
		},
		{
		0x8aa6,
		0xcbd0
		},
		{
		0x8aa8,
		0xbbe5
		},
		{
		0x8aac,
		0xcbb5
		},
		{
		0x8ab0,
		0xcbad
		},
		{
		0x8ab2,
		0xbfce
		},
		{
		0x8ab6,
		0xdac7
		},
		{
		0x8ab9,
		0xb7cc
		},
		{
		0x8abc,
		0xd2ea
		},
		{
		0x8abf,
		0xb5f7
		},
		{
		0x8ac2,
		0xdac6
		},
		{
		0x8ac4,
		0xd7bb
		},
		{
		0x8ac7,
		0xccb8
		},
		{
		0x8ac9,
		0xdac3
		},
		{
		0x8acb,
		0xc7eb
		},
		{
		0x8acd,
		0xdaba
		},
		{
		0x8acf,
		0xdac1
		},
		{
		0x8ad1,
		0xdac2
		},
		{
		0x8ad2,
		0xc1c2
		},
		{
		0x8ad6,
		0xc2db
		},
		{
		0x8ad7,
		0xdac5
		},
		{
		0x8adb,
		0xdac4
		},
		{
		0x8adc,
		0xb5fd
		},
		{
		0x8ade,
		0xdad2
		},
		{
		0x8ae2,
		0xdabb
		},
		{
		0x8ae4,
		0xdacc
		},
		{
		0x8ae6,
		0xdad0
		},
		{
		0x8ae7,
		0xd0b3
		},
		{
		0x8aeb,
		0xdac9
		},
		{
		0x8aed,
		0xdacd
		},
		{
		0x8aee,
		0xdad1
		},
		{
		0x8af1,
		0xbbe4
		},
		{
		0x8af3,
		0xdacf
		},
		{
		0x8af6,
		0xdac8
		},
		{
		0x8af7,
		0xb7ed
		},
		{
		0x8af8,
		0xd6ee
		},
		{
		0x8afa,
		0xd1e8
		},
		{
		0x8afc,
		0xdace
		},
		{
		0x8afe,
		0xc5b5
		},
		{
		0x8b00,
		0xc4b1
		},
		{
		0x8b01,
		0xdacb
		},
		{
		0x8b02,
		0xcebd
		},
		{
		0x8b04,
		0xccdc
		},
		{
		0x8b05,
		0xd6df
		},
		{
		0x8b07,
		0xe5c0
		},
		{
		0x8b0a,
		0xbbd1
		},
		{
		0x8b0e,
		0xc3d5
		},
		{
		0x8b10,
		0xdad7
		},
		{
		0x8b14,
		0xdaca
		},
		{
		0x8b16,
		0xdad5
		},
		{
		0x8b17,
		0xb0f9
		},
		{
		0x8b19,
		0xc7ab
		},
		{
		0x8b1a,
		0xdad6
		},
		{
		0x8b1b,
		0xbdb2
		},
		{
		0x8b1d,
		0xd0bb
		},
		{
		0x8b21,
		0xd2a5
		},
		{
		0x8b26,
		0xf6a5
		},
		{
		0x8b28,
		0xdad3
		},
		{
		0x8b2b,
		0xdad8
		},
		{
		0x8b2c,
		0xc3fd
		},
		{
		0x8b2d,
		0xdad9
		},
		{
		0x8b33,
		0xdaa9
		},
		{
		0x8b39,
		0xbdf7
		},
		{
		0x8b3e,
		0xc3a1
		},
		{
		0x8b49,
		0xd6a4
		},
		{
		0x8b4e,
		0xdadc
		},
		{
		0x8b4f,
		0xbca5
		},
		{
		0x8b56,
		0xdada
		},
		{
		0x8b58,
		0xcab6
		},
		{
		0x8b59,
		0xdadb
		},
		{
		0x8b5a,
		0xccb7
		},
		{
		0x8b5c,
		0xc6d7
		},
		{
		0x8b66,
		0xbeaf
		},
		{
		0x8b6b,
		0xdade
		},
		{
		0x8b6c,
		0xc6a9
		},
		{
		0x8b6f,
		0xd2eb
		},
		{
		0x8b70,
		0xd2e9
		},
		{
		0x8b74,
		0xc7b4
		},
		{
		0x8b77,
		0xbba4
		},
		{
		0x8b7d,
		0xd3fe
		},
		{
		0x8b80,
		0xb6c1
		},
		{
		0x8b8a,
		0xb1e4
		},
		{
		0x8b8e,
		0xf6c5
		},
		{
		0x8b92,
		0xb2f7
		},
		{
		0x8b93,
		0xc8c3
		},
		{
		0x8b95,
		0xc0be
		},
		{
		0x8b96,
		0xdadf
		},
		{
		0x8b9c,
		0xdad4
		},
		{
		0x8b9e,
		0xdadd
		},
		{
		0x8c37,
		0xb9c8
		},
		{
		0x8c41,
		0xbbed
		},
		{
		0x8c46,
		0xb6b9
		},
		{
		0x8c47,
		0xf4f8
		},
		{
		0x8c48,
		0xc6f1
		},
		{
		0x8c49,
		0xf4f9
		},
		{
		0x8c4c,
		0xcde3
		},
		{
		0x8c50,
		0xb7e1
		},
		{
		0x8c55,
		0xf5b9
		},
		{
		0x8c5a,
		0xebe0
		},
		{
		0x8c61,
		0xcff3
		},
		{
		0x8c62,
		0xbbbf
		},
		{
		0x8c6a,
		0xbac0
		},
		{
		0x8c6b,
		0xd4a5
		},
		{
		0x8c73,
		0xe1d9
		},
		{
		0x8c78,
		0xf5f4
		},
		{
		0x8c79,
		0xb1aa
		},
		{
		0x8c7a,
		0xb2f2
		},
		{
		0x8c82,
		0xf5f5
		},
		{
		0x8c85,
		0xf5f7
		},
		{
		0x8c89,
		0xbad1
		},
		{
		0x8c8a,
		0xf5f6
		},
		{
		0x8c8c,
		0xc3b2
		},
		{
		0x8c94,
		0xf5f9
		},
		{
		0x8c98,
		0xf5f8
		},
		{
		0x8c9d,
		0xb1b4
		},
		{
		0x8c9e,
		0xd5ea
		},
		{
		0x8ca0,
		0xb8ba
		},
		{
		0x8ca1,
		0xb2c6
		},
		{
		0x8ca2,
		0xb9b1
		},
		{
		0x8ca7,
		0xc6b6
		},
		{
		0x8ca8,
		0xbbf5
		},
		{
		0x8ca9,
		0xb7b7
		},
		{
		0x8caa,
		0xccb0
		},
		{
		0x8cab,
		0xb9e1
		},
		{
		0x8cac,
		0xd4f0
		},
		{
		0x8caf,
		0xd6fc
		},
		{
		0x8cb0,
		0xeadb
		},
		{
		0x8cb2,
		0xeadf
		},
		{
		0x8cb3,
		0xb7a1
		},
		{
		0x8cb4,
		0xb9f3
		},
		{
		0x8cb6,
		0xb1e1
		},
		{
		0x8cb7,
		0xc2f2
		},
		{
		0x8cb8,
		0xb4fb
		},
		{
		0x8cba,
		0xeadc
		},
		{
		0x8cbb,
		0xb7d1
		},
		{
		0x8cbc,
		0xccf9
		},
		{
		0x8cbd,
		0xeadd
		},
		{
		0x8cbf,
		0xc3b3
		},
		{
		0x8cc0,
		0xbad8
		},
		{
		0x8cc1,
		0xeada
		},
		{
		0x8cc2,
		0xc2b8
		},
		{
		0x8cc3,
		0xc1de
		},
		{
		0x8cc4,
		0xbbdf
		},
		{
		0x8cc5,
		0xeae0
		},
		{
		0x8cc7,
		0xd7ca
		},
		{
		0x8cc8,
		0xbcd6
		},
		{
		0x8cca,
		0xd4f4
		},
		{
		0x8cd1,
		0xeae2
		},
		{
		0x8cd2,
		0xc9de
		},
		{
		0x8cd3,
		0xb1f6
		},
		{
		0x8cd5,
		0xeae4
		},
		{
		0x8cda,
		0xeae3
		},
		{
		0x8cdc,
		0xb4cd
		},
		{
		0x8cde,
		0xc9cd
		},
		{
		0x8ce0,
		0xc5e2
		},
		{
		0x8ce1,
		0xe2d9
		},
		{
		0x8ce2,
		0xcfcd
		},
		{
		0x8ce3,
		0xc2f4
		},
		{
		0x8ce4,
		0xbcfa
		},
		{
		0x8ce6,
		0xb8b3
		},
		{
		0x8ce7,
		0xeae6
		},
		{
		0x8cea,
		0xd6ca
		},
		{
		0x8ceb,
		0xeae5
		},
		{
		0x8cec,
		0xd5cb
		},
		{
		0x8ced,
		0xb6c4
		},
		{
		0x8cf4,
		0xc0b5
		},
		{
		0x8cfa,
		0xd7ac
		},
		{
		0x8cfb,
		0xeae7
		},
		{
		0x8cfc,
		0xb9ba
		},
		{
		0x8cfd,
		0xc8fc
		},
		{
		0x8cfe,
		0xd8d3
		},
		{
		0x8d04,
		0xeade
		},
		{
		0x8d05,
		0xd7b8
		},
		{
		0x8d08,
		0xd4f9
		},
		{
		0x8d0a,
		0xd4de
		},
		{
		0x8d0b,
		0xd8cd
		},
		{
		0x8d0d,
		0xc9c4
		},
		{
		0x8d0f,
		0xd3ae
		},
		{
		0x8d10,
		0xeae1
		},
		{
		0x8d16,
		0xcaea
		},
		{
		0x8d1b,
		0xb8d3
		},
		{
		0x8d1c,
		0xd4df
		},
		{
		0x8d64,
		0xb3e0
		},
		{
		0x8d66,
		0xc9e2
		},
		{
		0x8d67,
		0xf4f6
		},
		{
		0x8d6b,
		0xbad5
		},
		{
		0x8d6d,
		0xf4f7
		},
		{
		0x8d70,
		0xd7df
		},
		{
		0x8d73,
		0xf4f1
		},
		{
		0x8d74,
		0xb8b0
		},
		{
		0x8d77,
		0xc6f0
		},
		{
		0x8d81,
		0xb3c3
		},
		{
		0x8d84,
		0xf4f2
		},
		{
		0x8d85,
		0xb3ac
		},
		{
		0x8d8a,
		0xd4bd
		},
		{
		0x8d91,
		0xf4f4
		},
		{
		0x8d94,
		0xf4f3
		},
		{
		0x8d95,
		0xb8cf
		},
		{
		0x8d99,
		0xd5d4
		},
		{
		0x8d9f,
		0xcccb
		},
		{
		0x8da3,
		0xc8a4
		},
		{
		0x8da8,
		0xc7f7
		},
		{
		0x8db2,
		0xf4f5
		},
		{
		0x8db3,
		0xd7e3
		},
		{
		0x8db4,
		0xc5bf
		},
		{
		0x8db5,
		0xf5c0
		},
		{
		0x8dba,
		0xf5c3
		},
		{
		0x8dbc,
		0xf5c2
		},
		{
		0x8dbe,
		0xd6ba
		},
		{
		0x8dbf,
		0xf5c1
		},
		{
		0x8dc6,
		0xf5cc
		},
		{
		0x8dcb,
		0xb0cf
		},
		{
		0x8dcc,
		0xb5f8
		},
		{
		0x8dce,
		0xf5c9
		},
		{
		0x8dcf,
		0xf5ca
		},
		{
		0x8dd1,
		0xc5dc
		},
		{
		0x8dd6,
		0xf5c5
		},
		{
		0x8dd7,
		0xf5c6
		},
		{
		0x8dda,
		0xf5c7
		},
		{
		0x8ddb,
		0xf5cb
		},
		{
		0x8ddd,
		0xbee0
		},
		{
		0x8ddf,
		0xb8fa
		},
		{
		0x8de3,
		0xf5d0
		},
		{
		0x8de4,
		0xf5d3
		},
		{
		0x8de8,
		0xbfe7
		},
		{
		0x8dea,
		0xb9f2
		},
		{
		0x8deb,
		0xf5bc
		},
		{
		0x8dec,
		0xf5cd
		},
		{
		0x8def,
		0xc2b7
		},
		{
		0x8df3,
		0xccf8
		},
		{
		0x8dfa,
		0xb6e5
		},
		{
		0x8dfd,
		0xf5d5
		},
		{
		0x8e05,
		0xf5bd
		},
		{
		0x8e09,
		0xf5d4
		},
		{
		0x8e0f,
		0xcca4
		},
		{
		0x8e10,
		0xbcf9
		},
		{
		0x8e14,
		0xf5d6
		},
		{
		0x8e1d,
		0xf5d7
		},
		{
		0x8e1e,
		0xbee1
		},
		{
		0x8e1f,
		0xf5d8
		},
		{
		0x8e22,
		0xccdf
		},
		{
		0x8e23,
		0xf5db
		},
		{
		0x8e29,
		0xb2c8
		},
		{
		0x8e2a,
		0xd7d9
		},
		{
		0x8e2e,
		0xf5da
		},
		{
		0x8e31,
		0xf5e2
		},
		{
		0x8e34,
		0xd3bb
		},
		{
		0x8e35,
		0xf5e0
		},
		{
		0x8e39,
		0xf5df
		},
		{
		0x8e3a,
		0xf5dd
		},
		{
		0x8e3d,
		0xf5e1
		},
		{
		0x8e40,
		0xf5de
		},
		{
		0x8e41,
		0xf5e4
		},
		{
		0x8e42,
		0xf5e5
		},
		{
		0x8e44,
		0xcce3
		},
		{
		0x8e47,
		0xe5bf
		},
		{
		0x8e48,
		0xb5b8
		},
		{
		0x8e49,
		0xf5e3
		},
		{
		0x8e4a,
		0xf5e8
		},
		{
		0x8e4b,
		0xcca3
		},
		{
		0x8e4c,
		0xf5c4
		},
		{
		0x8e55,
		0xf5cf
		},
		{
		0x8e59,
		0xf5be
		},
		{
		0x8e63,
		0xf5e7
		},
		{
		0x8e66,
		0xb1c4
		},
		{
		0x8e69,
		0xf5bf
		},
		{
		0x8e6c,
		0xb5c5
		},
		{
		0x8e6d,
		0xb2e4
		},
		{
		0x8e6f,
		0xf5ec
		},
		{
		0x8e70,
		0xf5e9
		},
		{
		0x8e72,
		0xb6d7
		},
		{
		0x8e74,
		0xf5ed
		},
		{
		0x8e76,
		0xf5ea
		},
		{
		0x8e7a,
		0xf5ce
		},
		{
		0x8e7c,
		0xf5eb
		},
		{
		0x8e81,
		0xd4ea
		},
		{
		0x8e85,
		0xf5ee
		},
		{
		0x8e87,
		0xb3f9
		},
		{
		0x8e89,
		0xf5bb
		},
		{
		0x8e8a,
		0xb3ec
		},
		{
		0x8e8b,
		0xf5d2
		},
		{
		0x8e8d,
		0xd4be
		},
		{
		0x8e90,
		0xf5f1
		},
		{
		0x8e91,
		0xf5dc
		},
		{
		0x8e92,
		0xf5c8
		},
		{
		0x8e93,
		0xf5d9
		},
		{
		0x8e94,
		0xf5f0
		},
		{
		0x8e9a,
		0xf5d1
		},
		{
		0x8e9e,
		0xf5f3
		},
		{
		0x8ea1,
		0xf5e6
		},
		{
		0x8ea5,
		0xb4da
		},
		{
		0x8ea6,
		0xf5f2
		},
		{
		0x8eaa,
		0xf5ef
		},
		{
		0x8eab,
		0xc9ed
		},
		{
		0x8eac,
		0xb9aa
		},
		{
		0x8eb2,
		0xb6e3
		},
		{
		0x8eba,
		0xccc9
		},
		{
		0x8ec0,
		0xc7fb
		},
		{
		0x8eca,
		0xb3b5
		},
		{
		0x8ecb,
		0xd4fe
		},
		{
		0x8ecc,
		0xb9ec
		},
		{
		0x8ecd,
		0xbefc
		},
		{
		0x8ece,
		0xeaa6
		},
		{
		0x8ed2,
		0xd0f9
		},
		{
		0x8ed4,
		0xe9ed
		},
		{
		0x8edb,
		0xe9ee
		},
		{
		0x8edf,
		0xc8ed
		},
		{
		0x8ee4,
		0xe9f5
		},
		{
		0x8eeb,
		0xe9f4
		},
		{
		0x8ef2,
		0xe9ef
		},
		{
		0x8ef8,
		0xd6e1
		},
		{
		0x8ef9,
		0xe9f2
		},
		{
		0x8efa,
		0xe9f7
		},
		{
		0x8efb,
		0xe9f0
		},
		{
		0x8efc,
		0xe9f3
		},
		{
		0x8efe,
		0xe9f8
		},
		{
		0x8f03,
		0xbdcf
		},
		{
		0x8f05,
		0xe9fb
		},
		{
		0x8f07,
		0xe9fa
		},
		{
		0x8f09,
		0xd4d8
		},
		{
		0x8f0a,
		0xe9f9
		},
		{
		0x8f12,
		0xe9fc
		},
		{
		0x8f14,
		0xb8a8
		},
		{
		0x8f15,
		0xc7e1
		},
		{
		0x8f1b,
		0xc1be
		},
		{
		0x8f1c,
		0xeaa2
		},
		{
		0x8f1d,
		0xbbd4
		},
		{
		0x8f1e,
		0xe9fe
		},
		{
		0x8f1f,
		0xeaa1
		},
		{
		0x8f25,
		0xb9f5
		},
		{
		0x8f26,
		0xe9fd
		},
		{
		0x8f29,
		0xb1b2
		},
		{
		0x8f2a,
		0xc2d6
		},
		{
		0x8f2f,
		0xbcad
		},
		{
		0x8f33,
		0xeaa3
		},
		{
		0x8f38,
		0xcae4
		},
		{
		0x8f3b,
		0xb7f8
		},
		{
		0x8f3e,
		0xd5b7
		},
		{
		0x8f3f,
		0xd3df
		},
		{
		0x8f42,
		0xecb1
		},
		{
		0x8f44,
		0xcfbd
		},
		{
		0x8f45,
		0xd4af
		},
		{
		0x8f46,
		0xeaa4
		},
		{
		0x8f49,
		0xd7aa
		},
		{
		0x8f4d,
		0xd5de
		},
		{
		0x8f4e,
		0xbdce
		},
		{
		0x8f54,
		0xeaa5
		},
		{
		0x8f5f,
		0xbae4
		},
		{
		0x8f61,
		0xe0ce
		},
		{
		0x8f62,
		0xe9f6
		},
		{
		0x8f64,
		0xe9f1
		},
		{
		0x8f9b,
		0xd0c1
		},
		{
		0x8f9c,
		0xb9bc
		},
		{
		0x8f9f,
		0xb1d9
		},
		{
		0x8fa3,
		0xc0b1
		},
		{
		0x8fa6,
		0xb0ec
		},
		{
		0x8fa8,
		0xb1e6
		},
		{
		0x8fad,
		0xb4c7
		},
		{
		0x8fae,
		0xb1e8
		},
		{
		0x8faf,
		0xb1e7
		},
		{
		0x8fb0,
		0xb3bd
		},
		{
		0x8fb1,
		0xc8e8
		},
		{
		0x8fb2,
		0xc5a9
		},
		{
		0x8fb6,
		0xe5c1
		},
		{
		0x8fc2,
		0xd3d8
		},
		{
		0x8fc4,
		0xc6f9
		},
		{
		0x8fc5,
		0xd1b8
		},
		{
		0x8fce,
		0xd3ad
		},
		{
		0x8fd1,
		0xbdfc
		},
		{
		0x8fd3,
		0xe5c2
		},
		{
		0x8fd4,
		0xb7b5
		},
		{
		0x8fd5,
		0xe5c3
		},
		{
		0x8fe2,
		0xccf6
		},
		{
		0x8fe4,
		0xe5c6
		},
		{
		0x8fe5,
		0xe5c4
		},
		{
		0x8fe6,
		0xe5c8
		},
		{
		0x8fe8,
		0xe5ca
		},
		{
		0x8fea,
		0xb5cf
		},
		{
		0x8feb,
		0xc6c8
		},
		{
		0x8fed,
		0xb5fc
		},
		{
		0x8fee,
		0xe5c5
		},
		{
		0x8ff0,
		0xcaf6
		},
		{
		0x8ff4,
		0xf8bc
		},
		{
		0x8ff7,
		0xc3d4
		},
		{
		0x8ff8,
		0xb1c5
		},
		{
		0x8ff9,
		0xbca3
		},
		{
		0x8ffd,
		0xd7b7
		},
		{
		0x9000,
		0xcdcb
		},
		{
		0x9001,
		0xcbcd
		},
		{
		0x9003,
		0xccd3
		},
		{
		0x9004,
		0xe5cc
		},
		{
		0x9005,
		0xe5cb
		},
		{
		0x9006,
		0xc4e6
		},
		{
		0x900b,
		0xe5cd
		},
		{
		0x900d,
		0xe5d0
		},
		{
		0x900f,
		0xcdb8
		},
		{
		0x9010,
		0xd6f0
		},
		{
		0x9011,
		0xe5cf
		},
		{
		0x9014,
		0xcdbe
		},
		{
		0x9015,
		0xe5c9
		},
		{
		0x9016,
		0xe5d1
		},
		{
		0x9017,
		0xb6ba
		},
		{
		0x9019,
		0xd5e2
		},
		{
		0x901a,
		0xcda8
		},
		{
		0x901b,
		0xb9e4
		},
		{
		0x901d,
		0xcac5
		},
		{
		0x901e,
		0xb3d1
		},
		{
		0x901f,
		0xcbd9
		},
		{
		0x9020,
		0xd4ec
		},
		{
		0x9021,
		0xe5d2
		},
		{
		0x9022,
		0xb7ea
		},
		{
		0x9023,
		0xc1ac
		},
		{
		0x902d,
		0xe5d5
		},
		{
		0x902e,
		0xb4fe
		},
		{
		0x902f,
		0xe5d6
		},
		{
		0x9032,
		0xbdf8
		},
		{
		0x9035,
		0xe5d3
		},
		{
		0x9036,
		0xe5d4
		},
		{
		0x9038,
		0xd2dd
		},
		{
		0x903c,
		0xb1c6
		},
		{
		0x903e,
		0xd3e2
		},
		{
		0x9041,
		0xb6dd
		},
		{
		0x9042,
		0xcbec
		},
		{
		0x9044,
		0xe5d7
		},
		{
		0x9047,
		0xd3f6
		},
		{
		0x904b,
		0xd4cb
		},
		{
		0x904d,
		0xb1e9
		},
		{
		0x904e,
		0xb9fd
		},
		{
		0x904f,
		0xb6f4
		},
		{
		0x9050,
		0xe5da
		},
		{
		0x9051,
		0xe5d8
		},
		{
		0x9052,
		0xe5d9
		},
		{
		0x9053,
		0xb5c0
		},
		{
		0x9054,
		0xb4ef
		},
		{
		0x9055,
		0xcea5
		},
		{
		0x9058,
		0xe5dc
		},
		{
		0x905b,
		0xe5de
		},
		{
		0x905c,
		0xd1b7
		},
		{
		0x905e,
		0xb5dd
		},
		{
		0x9060,
		0xd4b6
		},
		{
		0x9062,
		0xe5dd
		},
		{
		0x9063,
		0xc7b2
		},
		{
		0x9065,
		0xd2a3
		},
		{
		0x9068,
		0xe5db
		},
		{
		0x9069,
		0xcaca
		},
		{
		0x906d,
		0xd4e2
		},
		{
		0x906e,
		0xd5da
		},
		{
		0x9072,
		0xb3d9
		},
		{
		0x9074,
		0xe5e0
		},
		{
		0x9075,
		0xd7f1
		},
		{
		0x9077,
		0xc7a8
		},
		{
		0x9078,
		0xd1a1
		},
		{
		0x907a,
		0xd2c5
		},
		{
		0x907c,
		0xc1c9
		},
		{
		0x907d,
		0xe5e1
		},
		{
		0x907f,
		0xb1dc
		},
		{
		0x9080,
		0xd1fb
		},
		{
		0x9081,
		0xc2f5
		},
		{
		0x9082,
		0xe5e2
		},
		{
		0x9083,
		0xe5e4
		},
		{
		0x9084,
		0xbbb9
		},
		{
		0x9087,
		0xe5c7
		},
		{
		0x9088,
		0xe5e3
		},
		{
		0x908a,
		0xb1df
		},
		{
		0x908b,
		0xe5e5
		},
		{
		0x908f,
		0xc2df
		},
		{
		0x9090,
		0xe5ce
		},
		{
		0x9091,
		0xd2d8
		},
		{
		0x9095,
		0xe7df
		},
		{
		0x9097,
		0xdaf5
		},
		{
		0x9099,
		0xdaf8
		},
		{
		0x909b,
		0xdaf6
		},
		{
		0x90a1,
		0xdafa
		},
		{
		0x90a2,
		0xd0cf
		},
		{
		0x90a3,
		0xc4c7
		},
		{
		0x90a6,
		0xb0ee
		},
		{
		0x90aa,
		0xd0b0
		},
		{
		0x90af,
		0xbaaa
		},
		{
		0x90b0,
		0xdba2
		},
		{
		0x90b1,
		0xc7f1
		},
		{
		0x90b3,
		0xdafc
		},
		{
		0x90b4,
		0xdafb
		},
		{
		0x90b5,
		0xc9db
		},
		{
		0x90b6,
		0xdafd
		},
		{
		0x90b8,
		0xdba1
		},
		{
		0x90be,
		0xdba5
		},
		{
		0x90c1,
		0xf8f9
		},
		{
		0x90c4,
		0xdba7
		},
		{
		0x90c5,
		0xdba4
		},
		{
		0x90c7,
		0xdba8
		},
		{
		0x90ca,
		0xbdbc
		},
		{
		0x90ce,
		0xc0c9
		},
		{
		0x90d7,
		0xdbad
		},
		{
		0x90db,
		0xdbae
		},
		{
		0x90dc,
		0xdbac
		},
		{
		0x90dd,
		0xbac2
		},
		{
		0x90df,
		0xdba3
		},
		{
		0x90e1,
		0xbfa4
		},
		{
		0x90e2,
		0xdbab
		},
		{
		0x90e8,
		0xb2bf
		},
		{
		0x90eb,
		0xdbaf
		},
		{
		0x90ed,
		0xb9f9
		},
		{
		0x90ef,
		0xdbb0
		},
		{
		0x90f4,
		0xb3bb
		},
		{
		0x90f5,
		0xd3ca
		},
		{
		0x90fd,
		0xb6bc
		},
		{
		0x90fe,
		0xdbb1
		},
		{
		0x9102,
		0xb6f5
		},
		{
		0x9104,
		0xdbb2
		},
		{
		0x9106,
		0xdba9
		},
		{
		0x9109,
		0xcfe7
		},
		{
		0x9112,
		0xd7de
		},
		{
		0x9114,
		0xdaf9
		},
		{
		0x9116,
		0xd4c7
		},
		{
		0x9119,
		0xb1c9
		},
		{
		0x911e,
		0xdbb4
		},
		{
		0x9122,
		0xdbb3
		},
		{
		0x9123,
		0xdbb5
		},
		{
		0x9127,
		0xb5cb
		},
		{
		0x912d,
		0xd6a3
		},
		{
		0x912f,
		0xdbb7
		},
		{
		0x9130,
		0xc1da
		},
		{
		0x9131,
		0xdbb6
		},
		{
		0x9132,
		0xb5a6
		},
		{
		0x9134,
		0xdafe
		},
		{
		0x9136,
		0xdba6
		},
		{
		0x9139,
		0xdbb8
		},
		{
		0x913a,
		0xdaf7
		},
		{
		0x9143,
		0xdbb9
		},
		{
		0x9146,
		0xdbba
		},
		{
		0x9148,
		0xdbaa
		},
		{
		0x9149,
		0xd3cf
		},
		{
		0x914a,
		0xf4fa
		},
		{
		0x914b,
		0xc7f5
		},
		{
		0x914c,
		0xd7c3
		},
		{
		0x914d,
		0xc5e4
		},
		{
		0x914e,
		0xf4fc
		},
		{
		0x914f,
		0xf4fd
		},
		{
		0x9150,
		0xf4fb
		},
		{
		0x9152,
		0xbec6
		},
		{
		0x9157,
		0xd0ef
		},
		{
		0x915a,
		0xb7d3
		},
		{
		0x915e,
		0xccaa
		},
		{
		0x9161,
		0xf5a2
		},
		{
		0x9162,
		0xf5a1
		},
		{
		0x9163,
		0xbaa8
		},
		{
		0x9164,
		0xf4fe
		},
		{
		0x9165,
		0xcbd6
		},
		{
		0x9169,
		0xf5a4
		},
		{
		0x916a,
		0xc0d2
		},
		{
		0x916c,
		0xb3ea
		},
		{
		0x916e,
		0xcdaa
		},
		{
		0x916f,
		0xf5a5
		},
		{
		0x9170,
		0xf5a3
		},
		{
		0x9172,
		0xf5a8
		},
		{
		0x9174,
		0xf5a9
		},
		{
		0x9175,
		0xbdcd
		},
		{
		0x9176,
		0xc3b8
		},
		{
		0x9177,
		0xbfe1
		},
		{
		0x9178,
		0xcbe1
		},
		{
		0x9179,
		0xf5aa
		},
		{
		0x9185,
		0xf5ac
		},
		{
		0x9187,
		0xb4bc
		},
		{
		0x9189,
		0xd7ed
		},
		{
		0x918b,
		0xb4d7
		},
		{
		0x918c,
		0xf5ab
		},
		{
		0x918d,
		0xf5ae
		},
		{
		0x9190,
		0xf5ad
		},
		{
		0x9191,
		0xf5af
		},
		{
		0x9192,
		0xd0d1
		},
		{
		0x9196,
		0xd4cd
		},
		{
		0x919a,
		0xc3d1
		},
		{
		0x919b,
		0xc8a9
		},
		{
		0x919c,
		0xb3f3
		},
		{
		0x91a2,
		0xf5b0
		},
		{
		0x91a3,
		0xf5b1
		},
		{
		0x91aa,
		0xf5b2
		},
		{
		0x91ab,
		0xd2bd
		},
		{
		0x91ac,
		0xbdb4
		},
		{
		0x91ad,
		0xf5b3
		},
		{
		0x91ae,
		0xf5b4
		},
		{
		0x91af,
		0xf5b5
		},
		{
		0x91b4,
		0xf5b7
		},
		{
		0x91b5,
		0xf5b6
		},
		{
		0x91ba,
		0xf5b8
		},
		{
		0x91c0,
		0xc4f0
		},
		{
		0x91c1,
		0xd0c6
		},
		{
		0x91c3,
		0xf5a7
		},
		{
		0x91c5,
		0xf5a6
		},
		{
		0x91c7,
		0xb2c9
		},
		{
		0x91c9,
		0xd3d4
		},
		{
		0x91cb,
		0xcacd
		},
		{
		0x91cc,
		0xf8ce
		},
		{
		0x91cd,
		0xd6d8
		},
		{
		0x91ce,
		0xd2b0
		},
		{
		0x91cf,
		0xc1bf
		},
		{
		0x91d1,
		0xbdf0
		},
		{
		0x91d2,
		0xeec4
		},
		{
		0x91d3,
		0xeec5
		},
		{
		0x91d4,
		0xeec6
		},
		{
		0x91d5,
		0xeec9
		},
		{
		0x91d7,
		0xeec8
		},
		{
		0x91d8,
		0xb6a4
		},
		{
		0x91d9,
		0xeec7
		},
		{
		0x91dc,
		0xb8aa
		},
		{
		0x91dd,
		0xd5eb
		},
		{
		0x91e3,
		0xb5f6
		},
		{
		0x91e4,
		0xeecc
		},
		{
		0x91e7,
		0xeecb
		},
		{
		0x91e9,
		0xb7b0
		},
		{
		0x91f5,
		0xeece
		},
		{
		0x91f7,
		0xeeca
		},
		{
		0x91f9,
		0xeecf
		},
		{
		0x91fa,
		0xc7a5
		},
		{
		0x9200,
		0xeed9
		},
		{
		0x9201,
		0xeed5
		},
		{
		0x9204,
		0xeed7
		},
		{
		0x9208,
		0xeed0
		},
		{
		0x9209,
		0xc4c6
		},
		{
		0x920d,
		0xb6db
		},
		{
		0x920e,
		0xb9b3
		},
		{
		0x9210,
		0xeed4
		},
		{
		0x9211,
		0xeed3
		},
		{
		0x9214,
		0xb3ae
		},
		{
		0x9215,
		0xc5a5
		},
		{
		0x921e,
		0xbefb
		},
		{
		0x9223,
		0xb8c6
		},
		{
		0x9225,
		0xeed8
		},
		{
		0x9226,
		0xeed1
		},
		{
		0x9227,
		0xeed6
		},
		{
		0x922e,
		0xeeea
		},
		{
		0x9230,
		0xeee6
		},
		{
		0x9233,
		0xeedd
		},
		{
		0x9234,
		0xc1e5
		},
		{
		0x9237,
		0xeedc
		},
		{
		0x9238,
		0xeee0
		},
		{
		0x9239,
		0xeeeb
		},
		{
		0x923a,
		0xeeda
		},
		{
		0x923d,
		0xeedf
		},
		{
		0x923e,
		0xd3cb
		},
		{
		0x923f,
		0xeee4
		},
		{
		0x9240,
		0xbcd8
		},
		{
		0x9245,
		0xeed2
		},
		{
		0x9248,
		0xeee8
		},
		{
		0x9249,
		0xeee7
		},
		{
		0x924d,
		0xeee9
		},
		{
		0x9251,
		0xb2ac
		},
		{
		0x9255,
		0xeede
		},
		{
		0x9257,
		0xc7af
		},
		{
		0x925a,
		0xc3ad
		},
		{
		0x925b,
		0xc7a6
		},
		{
		0x925e,
		0xeee1
		},
		{
		0x9262,
		0xb2a7
		},
		{
		0x9266,
		0xeedb
		},
		{
		0x926c,
		0xeee2
		},
		{
		0x926d,
		0xeee3
		},
		{
		0x9278,
		0xbdc2
		},
		{
		0x927a,
		0xeeef
		},
		{
		0x927b,
		0xb8f5
		},
		{
		0x927f,
		0xeefe
		},
		{
		0x9280,
		0xd2f8
		},
		{
		0x9283,
		0xefa5
		},
		{
		0x9285,
		0xcdad
		},
		{
		0x928e,
		0xf6c6
		},
		{
		0x9291,
		0xcfb3
		},
		{
		0x9293,
		0xeefd
		},
		{
		0x9296,
		0xeef9
		},
		{
		0x9298,
		0xc3fa
		},
		{
		0x929a,
		0xefa2
		},
		{
		0x929c,
		0xcfce
		},
		{
		0x92a0,
		0xeeee
		},
		{
		0x92a3,
		0xefa8
		},
		{
		0x92a5,
		0xd2bf
		},
		{
		0x92a6,
		0xeef7
		},
		{
		0x92a8,
		0xefa7
		},
		{
		0x92a9,
		0xeefb
		},
		{
		0x92aa,
		0xeef0
		},
		{
		0x92ab,
		0xefa4
		},
		{
		0x92ac,
		0xeeed
		},
		{
		0x92b1,
		0xeef6
		},
		{
		0x92b7,
		0xcffa
		},
		{
		0x92b9,
		0xd0e2
		},
		{
		0x92bb,
		0xcce0
		},
		{
		0x92bc,
		0xefb1
		},
		{
		0x92c1,
		0xc2c1
		},
		{
		0x92c3,
		0xefb6
		},
		{
		0x92c5,
		0xd0bf
		},
		{
		0x92c7,
		0xb1b5
		},
		{
		0x92c8,
		0xf6c8
		},
		{
		0x92cc,
		0xeefa
		},
		{
		0x92cf,
		0xeef2
		},
		{
		0x92d2,
		0xb7e6
		},
		{
		0x92dd,
		0xefb2
		},
		{
		0x92df,
		0xefb7
		},
		{
		0x92e3,
		0xeef4
		},
		{
		0x92e4,
		0xb3fa
		},
		{
		0x92e5,
		0xefad
		},
		{
		0x92e6,
		0xefb8
		},
		{
		0x92e8,
		0xefb0
		},
		{
		0x92ea,
		0xc6cc
		},
		{
		0x92ed,
		0xc8f1
		},
		{
		0x92ee,
		0xeef1
		},
		{
		0x92ef,
		0xefaf
		},
		{
		0x92f0,
		0xefae
		},
		{
		0x92f1,
		0xefab
		},
		{
		0x92f6,
		0xefb3
		},
		{
		0x92f8,
		0xbee2
		},
		{
		0x92fc,
		0xb8d6
		},
		{
		0x9301,
		0xefbe
		},
		{
		0x9306,
		0xefba
		},
		{
		0x9307,
		0xefc2
		},
		{
		0x9308,
		0xefc3
		},
		{
		0x9310,
		0xd7b6
		},
		{
		0x9312,
		0xefb9
		},
		{
		0x9315,
		0xefbf
		},
		{
		0x9318,
		0xb4b8
		},
		{
		0x9319,
		0xefc5
		},
		{
		0x931a,
		0xefa3
		},
		{
		0x931b,
		0xefbc
		},
		{
		0x931f,
		0xefc4
		},
		{
		0x9320,
		0xb6a7
		},
		{
		0x9322,
		0xc7ae
		},
		{
		0x9326,
		0xbdf5
		},
		{
		0x9328,
		0xc3aa
		},
		{
		0x932b,
		0xcefd
		},
		{
		0x932e,
		0xefc0
		},
		{
		0x932f,
		0xb4ed
		},
		{
		0x9332,
		0xc2bc
		},
		{
		0x9333,
		0xc3cc
		},
		{
		0x9336,
		0xf8a3
		},
		{
		0x9338,
		0xefaa
		},
		{
		0x9340,
		0xefbd
		},
		{
		0x9341,
		0xcfc7
		},
		{
		0x9343,
		0xefc1
		},
		{
		0x9346,
		0xeecd
		},
		{
		0x9347,
		0xefc7
		},
		{
		0x934b,
		0xb9f8
		},
		{
		0x934d,
		0xb6c6
		},
		{
		0x9354,
		0xefc9
		},
		{
		0x9358,
		0xd5a1
		},
		{
		0x935b,
		0xb6cd
		},
		{
		0x9364,
		0xefca
		},
		{
		0x9365,
		0xefc6
		},
		{
		0x9369,
		0xefbb
		},
		{
		0x936a,
		0xf6ca
		},
		{
		0x936c,
		0xc7c2
		},
		{
		0x9370,
		0xefcc
		},
		{
		0x9375,
		0xbcfc
		},
		{
		0x9376,
		0xefc8
		},
		{
		0x937a,
		0xd5e0
		},
		{
		0x937e,
		0xeff1
		},
		{
		0x9382,
		0xc3be
		},
		{
		0x9384,
		0xefcd
		},
		{
		0x9387,
		0xefd1
		},
		{
		0x938a,
		0xb0f7
		},
		{
		0x938f,
		0xf6cc
		},
		{
		0x9396,
		0xcbf8
		},
		{
		0x9398,
		0xefd3
		},
		{
		0x93a2,
		0xced9
		},
		{
		0x93a3,
		0xddf6
		},
		{
		0x93a6,
		0xefd6
		},
		{
		0x93a7,
		0xeef8
		},
		{
		0x93a9,
		0xefa1
		},
		{
		0x93aa,
		0xefcb
		},
		{
		0x93ac,
		0xb8e4
		},
		{
		0x93ae,
		0xd5f2
		},
		{
		0x93b0,
		0xefd7
		},
		{
		0x93b3,
		0xc4f8
		},
		{
		0x93b5,
		0xefd8
		},
		{
		0x93b8,
		0xefd4
		},
		{
		0x93bf,
		0xefd5
		},
		{
		0x93c3,
		0xefdf
		},
		{
		0x93c7,
		0xefe0
		},
		{
		0x93c8,
		0xc1b4
		},
		{
		0x93ca,
		0xf6cb
		},
		{
		0x93cc,
		0xefd2
		},
		{
		0x93cd,
		0xefdd
		},
		{
		0x93d1,
		0xefe1
		},
		{
		0x93d6,
		0xf7e9
		},
		{
		0x93d7,
		0xefac
		},
		{
		0x93d8,
		0xefcf
		},
		{
		0x93dc,
		0xefdb
		},
		{
		0x93dd,
		0xefdc
		},
		{
		0x93de,
		0xefde
		},
		{
		0x93df,
		0xb2f9
		},
		{
		0x93e1,
		0xbeb5
		},
		{
		0x93e2,
		0xefda
		},
		{
		0x93e4,
		0xefce
		},
		{
		0x93e8,
		0xf6c9
		},
		{
		0x93f5,
		0xeefc
		},
		{
		0x93f7,
		0xefe4
		},
		{
		0x93f9,
		0xefea
		},
		{
		0x9403,
		0xeef3
		},
		{
		0x940b,
		0xefa6
		},
		{
		0x9410,
		0xc1cd
		},
		{
		0x9412,
		0xefa9
		},
		{
		0x9413,
		0xefe6
		},
		{
		0x9414,
		0xefe2
		},
		{
		0x9418,
		0xd6d3
		},
		{
		0x9419,
		0xefeb
		},
		{
		0x941d,
		0xefe3
		},
		{
		0x9420,
		0xefe8
		},
		{
		0x9426,
		0xefb4
		},
		{
		0x9427,
		0xefb5
		},
		{
		0x9428,
		0xefd0
		},
		{
		0x942e,
		0xc1ad
		},
		{
		0x9432,
		0xefed
		},
		{
		0x9433,
		0xc0d8
		},
		{
		0x9435,
		0xccfa
		},
		{
		0x9438,
		0xeeec
		},
		{
		0x943a,
		0xeef5
		},
		{
		0x943e,
		0xf6cd
		},
		{
		0x943f,
		0xefee
		},
		{
		0x9444,
		0xd6fd
		},
		{
		0x944a,
		0xefec
		},
		{
		0x944c,
		0xefd9
		},
		{
		0x9452,
		0xbcf8
		},
		{
		0x9454,
		0xefef
		},
		{
		0x9460,
		0xeee5
		},
		{
		0x9463,
		0xeff0
		},
		{
		0x9465,
		0xefe5
		},
		{
		0x946b,
		0xf6ce
		},
		{
		0x946d,
		0xefe7
		},
		{
		0x9470,
		0xd4bf
		},
		{
		0x9472,
		0xcfe2
		},
		{
		0x9477,
		0xc4f7
		},
		{
		0x9479,
		0xefe9
		},
		{
		0x947c,
		0xc2e0
		},
		{
		0x947d,
		0xd7ea
		},
		{
		0x947e,
		0xf6c7
		},
		{
		0x947f,
		0xd4e4
		},
		{
		0x9577,
		0xb3a4
		},
		{
		0x9580,
		0xc3c5
		},
		{
		0x9582,
		0xe3c5
		},
		{
		0x9583,
		0xc9c1
		},
		{
		0x9586,
		0xe3c6
		},
		{
		0x9589,
		0xb1d5
		},
		{
		0x958b,
		0xbfaa
		},
		{
		0x958c,
		0xe3ca
		},
		{
		0x958e,
		0xe3c8
		},
		{
		0x958f,
		0xc8f2
		},
		{
		0x9591,
		0xcfd0
		},
		{
		0x9593,
		0xbce4
		},
		{
		0x9594,
		0xe3c9
		},
		{
		0x9598,
		0xd5a2
		},
		{
		0x95a1,
		0xbad2
		},
		{
		0x95a3,
		0xb8f3
		},
		{
		0x95a4,
		0xf8b9
		},
		{
		0x95a5,
		0xb7a7
		},
		{
		0x95a8,
		0xb9eb
		},
		{
		0x95a9,
		0xc3f6
		},
		{
		0x95ab,
		0xe3cd
		},
		{
		0x95ac,
		0xe3cf
		},
		{
		0x95ad,
		0xe3cc
		},
		{
		0x95b2,
		0xd4c4
		},
		{
		0x95b6,
		0xe3d1
		},
		{
		0x95b9,
		0xd1cb
		},
		{
		0x95bb,
		0xd1d6
		},
		{
		0x95bc,
		0xe3d5
		},
		{
		0x95bd,
		0xe3d4
		},
		{
		0x95be,
		0xe3d0
		},
		{
		0x95bf,
		0xe3d3
		},
		{
		0x95c3,
		0xe3d6
		},
		{
		0x95c6,
		0xf8a2
		},
		{
		0x95c8,
		0xe3c7
		},
		{
		0x95ca,
		0xc0ab
		},
		{
		0x95cb,
		0xe3d7
		},
		{
		0x95cc,
		0xc0bb
		},
		{
		0x95d0,
		0xe3d9
		},
		{
		0x95d4,
		0xe3d8
		},
		{
		0x95d5,
		0xe3da
		},
		{
		0x95d6,
		0xb4b3
		},
		{
		0x95dc,
		0xb9d8
		},
		{
		0x95de,
		0xe3db
		},
		{
		0x95e1,
		0xb2fb
		},
		{
		0x95e2,
		0xf8db
		},
		{
		0x95e5,
		0xe3cb
		},
		{
		0x961c,
		0xb8b7
		},
		{
		0x961d,
		0xdae2
		},
		{
		0x9621,
		0xdae4
		},
		{
		0x9622,
		0xdae3
		},
		{
		0x962a,
		0xdae6
		},
		{
		0x962e,
		0xc8ee
		},
		{
		0x9631,
		0xdae5
		},
		{
		0x9632,
		0xb7c0
		},
		{
		0x963b,
		0xd7e8
		},
		{
		0x963c,
		0xdae8
		},
		{
		0x963d,
		0xdae7
		},
		{
		0x963f,
		0xb0a2
		},
		{
		0x9640,
		0xcdd3
		},
		{
		0x9642,
		0xdae9
		},
		{
		0x9644,
		0xb8bd
		},
		{
		0x964b,
		0xc2aa
		},
		{
		0x964c,
		0xc4b0
		},
		{
		0x964d,
		0xbdb5
		},
		{
		0x9650,
		0xcfde
		},
		{
		0x9654,
		0xdaeb
		},
		{
		0x9658,
		0xdaea
		},
		{
		0x965b,
		0xb1dd
		},
		{
		0x965d,
		0xc9c2
		},
		{
		0x965f,
		0xdaec
		},
		{
		0x9661,
		0xb6b8
		},
		{
		0x9662,
		0xd4ba
		},
		{
		0x9663,
		0xd5f3
		},
		{
		0x9664,
		0xb3fd
		},
		{
		0x966a,
		0xc5e3
		},
		{
		0x966c,
		0xdaee
		},
		{
		0x9670,
		0xd2f5
		},
		{
		0x9672,
		0xdaef
		},
		{
		0x9673,
		0xb3c2
		},
		{
		0x9674,
		0xdaf0
		},
		{
		0x9675,
		0xc1ea
		},
		{
		0x9676,
		0xccd5
		},
		{
		0x9677,
		0xcfdd
		},
		{
		0x9678,
		0xc2bd
		},
		{
		0x967d,
		0xd1f4
		},
		{
		0x9685,
		0xd3e7
		},
		{
		0x9686,
		0xc2a1
		},
		{
		0x9688,
		0xdaf1
		},
		{
		0x9689,
		0xdaed
		},
		{
		0x968a,
		0xb6d3
		},
		{
		0x968b,
		0xcbe5
		},
		{
		0x968d,
		0xdaf2
		},
		{
		0x968e,
		0xbdd7
		},
		{
		0x9694,
		0xb8f4
		},
		{
		0x9695,
		0xd4c9
		},
		{
		0x9697,
		0xdaf3
		},
		{
		0x9698,
		0xb0af
		},
		{
		0x9699,
		0xcfb6
		},
		{
		0x969b,
		0xbcca
		},
		{
		0x969c,
		0xd5cf
		},
		{
		0x96a7,
		0xcbed
		},
		{
		0x96a8,
		0xcbe6
		},
		{
		0x96aa,
		0xcfd5
		},
		{
		0x96b0,
		0xdaf4
		},
		{
		0x96b1,
		0xd2fe
		},
		{
		0x96b3,
		0xe3c4
		},
		{
		0x96b4,
		0xc2a4
		},
		{
		0x96b8,
		0xc1a5
		},
		{
		0x96b9,
		0xf6bf
		},
		{
		0x96bb,
		0xf9a2
		},
		{
		0x96bc,
		0xf6c0
		},
		{
		0x96bd,
		0xf6c1
		},
		{
		0x96c0,
		0xc8b8
		},
		{
		0x96c1,
		0xd1e3
		},
		{
		0x96c4,
		0xd0db
		},
		{
		0x96c5,
		0xd1c5
		},
		{
		0x96c6,
		0xbcaf
		},
		{
		0x96c7,
		0xb9cd
		},
		{
		0x96c9,
		0xeff4
		},
		{
		0x96cc,
		0xb4c6
		},
		{
		0x96cd,
		0xd3ba
		},
		{
		0x96ce,
		0xf6c2
		},
		{
		0x96d2,
		0xf6c3
		},
		{
		0x96d5,
		0xb5f1
		},
		{
		0x96d6,
		0xcbe4
		},
		{
		0x96d9,
		0xcbab
		},
		{
		0x96db,
		0xb3fb
		},
		{
		0x96dc,
		0xd4d3
		},
		{
		0x96e2,
		0xc0eb
		},
		{
		0x96e3,
		0xc4d1
		},
		{
		0x96e8,
		0xd3ea
		},
		{
		0x96e9,
		0xf6a7
		},
		{
		0x96ea,
		0xd1a9
		},
		{
		0x96ef,
		0xf6a9
		},
		{
		0x96f2,
		0xd4c6
		},
		{
		0x96f6,
		0xc1e3
		},
		{
		0x96f7,
		0xc0d7
		},
		{
		0x96f9,
		0xb1a2
		},
		{
		0x96fb,
		0xb5e7
		},
		{
		0x9700,
		0xd0e8
		},
		{
		0x9704,
		0xcff6
		},
		{
		0x9706,
		0xf6aa
		},
		{
		0x9707,
		0xd5f0
		},
		{
		0x9708,
		0xf6ac
		},
		{
		0x9709,
		0xc3b9
		},
		{
		0x970d,
		0xbbf4
		},
		{
		0x970e,
		0xf6ae
		},
		{
		0x970f,
		0xf6ad
		},
		{
		0x9713,
		0xc4de
		},
		{
		0x9716,
		0xc1d8
		},
		{
		0x971c,
		0xcbaa
		},
		{
		0x971e,
		0xcfbc
		},
		{
		0x9727,
		0xceed
		},
		{
		0x972a,
		0xf6af
		},
		{
		0x9730,
		0xf6b1
		},
		{
		0x9732,
		0xc2b6
		},
		{
		0x9738,
		0xb0d4
		},
		{
		0x9739,
		0xc5f9
		},
		{
		0x973d,
		0xf6ab
		},
		{
		0x973e,
		0xf6b2
		},
		{
		0x9742,
		0xf6a8
		},
		{
		0x9744,
		0xf6b0
		},
		{
		0x9748,
		0xc1e9
		},
		{
		0x9752,
		0xc7e0
		},
		{
		0x9756,
		0xbeb8
		},
		{
		0x975a,
		0xf6a6
		},
		{
		0x975b,
		0xb5e5
		},
		{
		0x975c,
		0xbeb2
		},
		{
		0x975e,
		0xb7c7
		},
		{
		0x9760,
		0xbfbf
		},
		{
		0x9761,
		0xc3d2
		},
		{
		0x9762,
		0xc3e6
		},
		{
		0x9768,
		0xd8cc
		},
		{
		0x9769,
		0xb8ef
		},
		{
		0x9773,
		0xbdf9
		},
		{
		0x9774,
		0xd1a5
		},
		{
		0x9776,
		0xb0d0
		},
		{
		0x977c,
		0xf7b0
		},
		{
		0x9785,
		0xf7b1
		},
		{
		0x978b,
		0xd0ac
		},
		{
		0x978d,
		0xb0b0
		},
		{
		0x978f,
		0xb9ae
		},
		{
		0x9794,
		0xf7b4
		},
		{
		0x9798,
		0xc7ca
		},
		{
		0x97a0,
		0xbecf
		},
		{
		0x97a3,
		0xf7b7
		},
		{
		0x97a6,
		0xf8e4
		},
		{
		0x97ab,
		0xf7b6
		},
		{
		0x97ad,
		0xb1de
		},
		{
		0x97b2,
		0xf7b8
		},
		{
		0x97b4,
		0xf7b9
		},
		{
		0x97bd,
		0xf7b3
		},
		{
		0x97c3,
		0xf7b2
		},
		{
		0x97c6,
		0xf8e1
		},
		{
		0x97c9,
		0xf7b5
		},
		{
		0x97cb,
		0xcea4
		},
		{
		0x97cc,
		0xc8cd
		},
		{
		0x97d3,
		0xbaab
		},
		{
		0x97d9,
		0xe8b8
		},
		{
		0x97dc,
		0xe8ba
		},
		{
		0x97de,
		0xe8b9
		},
		{
		0x97ed,
		0xbec2
		},
		{
		0x97f3,
		0xd2f4
		},
		{
		0x97f5,
		0xd4cf
		},
		{
		0x97f6,
		0xc9d8
		},
		{
		0x97ff,
		0xcfec
		},
		{
		0x9801,
		0xd2b3
		},
		{
		0x9802,
		0xb6a5
		},
		{
		0x9803,
		0xc7ea
		},
		{
		0x9805,
		0xcfee
		},
		{
		0x9806,
		0xcbb3
		},
		{
		0x9807,
		0xf1fc
		},
		{
		0x9808,
		0xd0eb
		},
		{
		0x980a,
		0xe7ef
		},
		{
		0x980c,
		0xcbcc
		},
		{
		0x980e,
		0xf1fd
		},
		{
		0x980f,
		0xf1fe
		},
		{
		0x9810,
		0xd4a4
		},
		{
		0x9811,
		0xcde7
		},
		{
		0x9812,
		0xb0e4
		},
		{
		0x9813,
		0xb6d9
		},
		{
		0x9817,
		0xc6c4
		},
		{
		0x9818,
		0xc1ec
		},
		{
		0x981c,
		0xf2a2
		},
		{
		0x9821,
		0xf2a1
		},
		{
		0x9824,
		0xd2c3
		},
		{
		0x9826,
		0xf2a4
		},
		{
		0x982d,
		0xcdb7
		},
		{
		0x9830,
		0xbcd5
		},
		{
		0x9837,
		0xf2a5
		},
		{
		0x9838,
		0xbeb1
		},
		{
		0x983b,
		0xc6b5
		},
		{
		0x983d,
		0xcdc7
		},
		{
		0x9846,
		0xbfc5
		},
		{
		0x984c,
		0xcce2
		},
		{
		0x984d,
		0xb6ee
		},
		{
		0x984e,
		0xf2a6
		},
		{
		0x9853,
		0xf2a7
		},
		{
		0x9854,
		0xd1d5
		},
		{
		0x9858,
		0xd4b8
		},
		{
		0x9859,
		0xf2aa
		},
		{
		0x985b,
		0xb5df
		},
		{
		0x985e,
		0xc0e0
		},
		{
		0x9862,
		0xf2a9
		},
		{
		0x9865,
		0xf2ab
		},
		{
		0x9867,
		0xb9cb
		},
		{
		0x986b,
		0xb2fc
		},
		{
		0x986c,
		0xf2ac
		},
		{
		0x986f,
		0xcfd4
		},
		{
		0x9870,
		0xf2ad
		},
		{
		0x9871,
		0xc2ad
		},
		{
		0x9873,
		0xf2a8
		},
		{
		0x9874,
		0xc8a7
		},
		{
		0x98a8,
		0xb7e7
		},
		{
		0x98ae,
		0xeca9
		},
		{
		0x98af,
		0xecaa
		},
		{
		0x98b1,
		0xf8ec
		},
		{
		0x98b3,
		0xf8b7
		},
		{
		0x98b6,
		0xecab
		},
		{
		0x98bc,
		0xecac
		},
		{
		0x98c4,
		0xc6ae
		},
		{
		0x98c6,
		0xecad
		},
		{
		0x98c8,
		0xecae
		},
		{
		0x98db,
		0xb7c9
		},
		{
		0x98df,
		0xcab3
		},
		{
		0x98e0,
		0xe2bb
		},
		{
		0x98e2,
		0xf8bf
		},
		{
		0x98e7,
		0xe2b8
		},
		{
		0x98e9,
		0xe2bd
		},
		{
		0x98ea,
		0xe2bf
		},
		{
		0x98eb,
		0xe2c0
		},
		{
		0x98ed,
		0xe2c1
		},
		{
		0x98ef,
		0xb7b9
		},
		{
		0x98f2,
		0xd2fb
		},
		{
		0x98f4,
		0xe2c2
		},
		{
		0x98fc,
		0xcbc7
		},
		{
		0x98fd,
		0xb1a5
		},
		{
		0x98fe,
		0xcace
		},
		{
		0x9903,
		0xbdc8
		},
		{
		0x9905,
		0xb1fd
		},
		{
		0x9909,
		0xe2c3
		},
		{
		0x990a,
		0xd1f8
		},
		{
		0x990c,
		0xb6fc
		},
		{
		0x9910,
		0xb2cd
		},
		{
		0x9911,
		0xe2c4
		},
		{
		0x9912,
		0xc4d9
		},
		{
		0x9913,
		0xb6f6
		},
		{
		0x9918,
		0xd3e0
		},
		{
		0x991b,
		0xe2c6
		},
		{
		0x991e,
		0xbda4
		},
		{
		0x9921,
		0xcfda
		},
		{
		0x9928,
		0xb9dd
		},
		{
		0x992e,
		0xf7d1
		},
		{
		0x9933,
		0xe2bc
		},
		{
		0x9937,
		0xe2c7
		},
		{
		0x993c,
		0xe2be
		},
		{
		0x993e,
		0xc1f3
		},
		{
		0x993f,
		0xe2c8
		},
		{
		0x9943,
		0xe2c9
		},
		{
		0x9945,
		0xc2f8
		},
		{
		0x9948,
		0xe2ca
		},
		{
		0x9949,
		0xe2cb
		},
		{
		0x994a,
		0xe2cc
		},
		{
		0x994b,
		0xc0a1
		},
		{
		0x994c,
		0xe2cd
		},
		{
		0x9951,
		0xbca2
		},
		{
		0x9952,
		0xc8c4
		},
		{
		0x9954,
		0xf7d3
		},
		{
		0x9955,
		0xf7d2
		},
		{
		0x9957,
		0xf7cf
		},
		{
		0x995c,
		0xf7d0
		},
		{
		0x995e,
		0xb2f6
		},
		{
		0x9962,
		0xe2ce
		},
		{
		0x9996,
		0xcad7
		},
		{
		0x9997,
		0xd8b8
		},
		{
		0x9998,
		0xd9e5
		},
		{
		0x9999,
		0xcfe3
		},
		{
		0x99a5,
		0xf0a5
		},
		{
		0x99a8,
		0xdcb0
		},
		{
		0x99ac,
		0xc2ed
		},
		{
		0x99ad,
		0xd4a6
		},
		{
		0x99ae,
		0xb7eb
		},
		{
		0x99b1,
		0xcdd4
		},
		{
		0x99b3,
		0xb3db
		},
		{
		0x99b4,
		0xd1b1
		},
		{
		0x99c1,
		0xb2b5
		},
		{
		0x99d0,
		0xd7a4
		},
		{
		0x99d1,
		0xe6e5
		},
		{
		0x99d2,
		0xbed4
		},
		{
		0x99d4,
		0xe6e0
		},
		{
		0x99d5,
		0xbcdd
		},
		{
		0x99d8,
		0xe6e6
		},
		{
		0x99d9,
		0xe6e2
		},
		{
		0x99db,
		0xcabb
		},
		{
		0x99dd,
		0xcdd5
		},
		{
		0x99df,
		0xe6e1
		},
		{
		0x99e1,
		0xc2ee
		},
		{
		0x99e2,
		0xe6e9
		},
		{
		0x99ed,
		0xbaa7
		},
		{
		0x99f1,
		0xc2e6
		},
		{
		0x99ff,
		0xbfa5
		},
		{
		0x9a01,
		0xb3d2
		},
		{
		0x9a05,
		0xe6ed
		},
		{
		0x9a0d,
		0xe6ec
		},
		{
		0x9a0e,
		0xc6ef
		},
		{
		0x9a0f,
		0xe6eb
		},
		{
		0x9a16,
		0xe6f0
		},
		{
		0x9a19,
		0xc6ad
		},
		{
		0x9a2b,
		0xe5b9
		},
		{
		0x9a2d,
		0xe6ef
		},
		{
		0x9a2e,
		0xe6f2
		},
		{
		0x9a30,
		0xccda
		},
		{
		0x9a36,
		0xe6e3
		},
		{
		0x9a37,
		0xc9a7
		},
		{
		0x9a38,
		0xe6f3
		},
		{
		0x9a3e,
		0xc2e2
		},
		{
		0x9a40,
		0xddeb
		},
		{
		0x9a41,
		0xe6f1
		},
		{
		0x9a42,
		0xe6ee
		},
		{
		0x9a43,
		0xe6f4
		},
		{
		0x9a44,
		0xe6f5
		},
		{
		0x9a45,
		0xc7fd
		},
		{
		0x9a4a,
		0xe6e8
		},
		{
		0x9a4d,
		0xe6e7
		},
		{
		0x9a4f,
		0xe6f6
		},
		{
		0x9a55,
		0xbdbe
		},
		{
		0x9a57,
		0xd1e9
		},
		{
		0x9a5a,
		0xbeaa
		},
		{
		0x9a5b,
		0xe6e4
		},
		{
		0x9a5f,
		0xd6e8
		},
		{
		0x9a62,
		0xc2bf
		},
		{
		0x9a64,
		0xe6f8
		},
		{
		0x9a65,
		0xe6f7
		},
		{
		0x9a6a,
		0xe6ea
		},
		{
		0x9aa8,
		0xb9c7
		},
		{
		0x9aaf,
		0xb0b9
		},
		{
		0x9ab0,
		0xf7bb
		},
		{
		0x9ab1,
		0xf7ba
		},
		{
		0x9ab6,
		0xf7be
		},
		{
		0x9ab7,
		0xf7bc
		},
		{
		0x9ab8,
		0xbaa1
		},
		{
		0x9aba,
		0xf7bf
		},
		{
		0x9abc,
		0xf7c0
		},
		{
		0x9ac0,
		0xf7c2
		},
		{
		0x9ac1,
		0xf7c1
		},
		{
		0x9ac2,
		0xf7c4
		},
		{
		0x9acf,
		0xf7c3
		},
		{
		0x9ad1,
		0xf7c7
		},
		{
		0x9ad2,
		0xf8fe
		},
		{
		0x9ad3,
		0xcbe8
		},
		{
		0x9ad4,
		0xcce5
		},
		{
		0x9ad5,
		0xf7c6
		},
		{
		0x9ad6,
		0xf7c5
		},
		{
		0x9ad8,
		0xb8df
		},
		{
		0x9adf,
		0xf7d4
		},
		{
		0x9ae1,
		0xf7d5
		},
		{
		0x9ae6,
		0xf7d6
		},
		{
		0x9aeb,
		0xf7d8
		},
		{
		0x9aed,
		0xf7da
		},
		{
		0x9aee,
		0xf8b1
		},
		{
		0x9aef,
		0xf7d7
		},
		{
		0x9af9,
		0xf7db
		},
		{
		0x9afb,
		0xf7d9
		},
		{
		0x9b03,
		0xd7d7
		},
		{
		0x9b06,
		0xcbc9
		},
		{
		0x9b08,
		0xf7dc
		},
		{
		0x9b0d,
		0xf8ba
		},
		{
		0x9b0f,
		0xf7dd
		},
		{
		0x9b1a,
		0xf8f6
		},
		{
		0x9b1f,
		0xf7df
		},
		{
		0x9b22,
		0xf7de
		},
		{
		0x9b23,
		0xf7e0
		},
		{
		0x9b25,
		0xb6b7
		},
		{
		0x9b27,
		0xc4d6
		},
		{
		0x9b29,
		0xe3d2
		},
		{
		0x9b2e,
		0xe3ce
		},
		{
		0x9b2f,
		0xdbcb
		},
		{
		0x9b31,
		0xd3f4
		},
		{
		0x9b32,
		0xd8aa
		},
		{
		0x9b3b,
		0xe5f7
		},
		{
		0x9b3c,
		0xb9ed
		},
		{
		0x9b41,
		0xbffd
		},
		{
		0x9b42,
		0xbbea
		},
		{
		0x9b43,
		0xf7c9
		},
		{
		0x9b44,
		0xc6c7
		},
		{
		0x9b45,
		0xf7c8
		},
		{
		0x9b48,
		0xf7cc
		},
		{
		0x9b4d,
		0xf7cd
		},
		{
		0x9b4e,
		0xf7cb
		},
		{
		0x9b4f,
		0xceba
		},
		{
		0x9b51,
		0xf7ce
		},
		{
		0x9b54,
		0xc4a7
		},
		{
		0x9b58,
		0xf7ca
		},
		{
		0x9b5a,
		0xd3e3
		},
		{
		0x9b6f,
		0xc2b3
		},
		{
		0x9b74,
		0xf6d0
		},
		{
		0x9b77,
		0xf6cf
		},
		{
		0x9b81,
		0xf6d1
		},
		{
		0x9b83,
		0xf6d2
		},
		{
		0x9b8e,
		0xf6d3
		},
		{
		0x9b90,
		0xf6d8
		},
		{
		0x9b91,
		0xb1ab
		},
		{
		0x9b92,
		0xf6d6
		},
		{
		0x9b9a,
		0xf6da
		},
		{
		0x9b9d,
		0xf6df
		},
		{
		0x9b9e,
		0xf6dc
		},
		{
		0x9baa,
		0xf6db
		},
		{
		0x9bab,
		0xf6de
		},
		{
		0x9bad,
		0xf6d9
		},
		{
		0x9bae,
		0xcfca
		},
		{
		0x9bc0,
		0xf6e7
		},
		{
		0x9bc1,
		0xf6e1
		},
		{
		0x9bc7,
		0xf6e9
		},
		{
		0x9bc9,
		0xc0f0
		},
		{
		0x9bca,
		0xf6e8
		},
		{
		0x9bd4,
		0xf6f6
		},
		{
		0x9bd6,
		0xf6eb
		},
		{
		0x9bdb,
		0xf6f4
		},
		{
		0x9bdd,
		0xf6f1
		},
		{
		0x9be1,
		0xf6ee
		},
		{
		0x9be2,
		0xf6f2
		},
		{
		0x9be4,
		0xf6ef
		},
		{
		0x9be7,
		0xf6f0
		},
		{
		0x9be8,
		0xbea8
		},
		{
		0x9bea,
		0xf6ec
		},
		{
		0x9beb,
		0xf6ed
		},
		{
		0x9bf0,
		0xf6f3
		},
		{
		0x9bf4,
		0xf6f5
		},
		{
		0x9bfd,
		0xf6ea
		},
		{
		0x9bff,
		0xf6fd
		},
		{
		0x9c08,
		0xf6f8
		},
		{
		0x9c09,
		0xf6fc
		},
		{
		0x9c0d,
		0xf6fa
		},
		{
		0x9c10,
		0xf6f9
		},
		{
		0x9c12,
		0xf6fb
		},
		{
		0x9c13,
		0xc8fa
		},
		{
		0x9c20,
		0xf6fe
		},
		{
		0x9c23,
		0xf6e5
		},
		{
		0x9c25,
		0xf7a4
		},
		{
		0x9c28,
		0xf7a3
		},
		{
		0x9c29,
		0xf7a5
		},
		{
		0x9c2d,
		0xf7a2
		},
		{
		0x9c31,
		0xf6e3
		},
		{
		0x9c32,
		0xf7a1
		},
		{
		0x9c33,
		0xf7a6
		},
		{
		0x9c35,
		0xf7aa
		},
		{
		0x9c37,
		0xf6e6
		},
		{
		0x9c39,
		0xf6e4
		},
		{
		0x9c3b,
		0xf7a9
		},
		{
		0x9c3e,
		0xf7a7
		},
		{
		0x9c45,
		0xf7ab
		},
		{
		0x9c48,
		0xf7a8
		},
		{
		0x9c49,
		0xb1ee
		},
		{
		0x9c52,
		0xf7ae
		},
		{
		0x9c54,
		0xf7ad
		},
		{
		0x9c56,
		0xf7ac
		},
		{
		0x9c57,
		0xc1db
		},
		{
		0x9c58,
		0xf6e0
		},
		{
		0x9c5d,
		0xf6f7
		},
		{
		0x9c5f,
		0xf6d7
		},
		{
		0x9c67,
		0xf7af
		},
		{
		0x9c6d,
		0xf6dd
		},
		{
		0x9c78,
		0xf6d4
		},
		{
		0x9c7a,
		0xf6e2
		},
		{
		0x9ce5,
		0xc4f1
		},
		{
		0x9ce9,
		0xf0af
		},
		{
		0x9cec,
		0xd9ec
		},
		{
		0x9cf3,
		0xb7ef
		},
		{
		0x9cf4,
		0xc3f9
		},
		{
		0x9cf6,
		0xf0b0
		},
		{
		0x9d06,
		0xf0b2
		},
		{
		0x9d07,
		0xf0b1
		},
		{
		0x9d09,
		0xd1bb
		},
		{
		0x9d15,
		0xcdd2
		},
		{
		0x9d1b,
		0xd4a7
		},
		{
		0x9d1d,
		0xf0b6
		},
		{
		0x9d1f,
		0xf0b7
		},
		{
		0x9d23,
		0xf0b3
		},
		{
		0x9d26,
		0xd1ec
		},
		{
		0x9d28,
		0xd1bc
		},
		{
		0x9d2f,
		0xf0b9
		},
		{
		0x9d30,
		0xf0bb
		},
		{
		0x9d3b,
		0xbae8
		},
		{
		0x9d3f,
		0xb8eb
		},
		{
		0x9d42,
		0xf0bc
		},
		{
		0x9d51,
		0xbee9
		},
		{
		0x9d52,
		0xf0c1
		},
		{
		0x9d53,
		0xf0be
		},
		{
		0x9d5c,
		0xf0c3
		},
		{
		0x9d5d,
		0xb6ec
		},
		{
		0x9d60,
		0xf0c0
		},
		{
		0x9d61,
		0xf0c4
		},
		{
		0x9d6a,
		0xf0c6
		},
		{
		0x9d6c,
		0xc5f4
		},
		{
		0x9d6f,
		0xf0c7
		},
		{
		0x9d72,
		0xc8b5
		},
		{
		0x9d87,
		0xf0b4
		},
		{
		0x9d89,
		0xf0c8
		},
		{
		0x9d93,
		0xf0c5
		},
		{
		0x9d98,
		0xf0c9
		},
		{
		0x9d9a,
		0xf0ca
		},
		{
		0x9da5,
		0xf0cc
		},
		{
		0x9da9,
		0xf0cd
		},
		{
		0x9daf,
		0xddba
		},
		{
		0x9db4,
		0xbad7
		},
		{
		0x9dbb,
		0xf7bd
		},
		{
		0x9dbc,
		0xf0cf
		},
		{
		0x9dc0,
		0xf0cb
		},
		{
		0x9dc2,
		0xf0ce
		},
		{
		0x9dc4,
		0xbca6
		},
		{
		0x9dd3,
		0xf0d1
		},
		{
		0x9dd7,
		0xc5b8
		},
		{
		0x9dd9,
		0xf0ba
		},
		{
		0x9dda,
		0xf0d2
		},
		{
		0x9de5,
		0xf0b8
		},
		{
		0x9de6,
		0xf0d4
		},
		{
		0x9def,
		0xf0d3
		},
		{
		0x9df2,
		0xf0d5
		},
		{
		0x9df3,
		0xf0c2
		},
		{
		0x9df8,
		0xf0d6
		},
		{
		0x9df9,
		0xd3a5
		},
		{
		0x9dfa,
		0xf0d8
		},
		{
		0x9e0c,
		0xf0d7
		},
		{
		0x9e15,
		0xf0b5
		},
		{
		0x9e1a,
		0xf0d0
		},
		{
		0x9e1b,
		0xf0d9
		},
		{
		0x9e1d,
		0xf0bf
		},
		{
		0x9e1e,
		0xf0bd
		},
		{
		0x9e75,
		0xf8d2
		},
		{
		0x9e79,
		0xf8f4
		},
		{
		0x9e7a,
		0xf5ba
		},
		{
		0x9e7c,
		0xbcef
		},
		{
		0x9e7d,
		0xd1ce
		},
		{
		0x9e7f,
		0xc2b9
		},
		{
		0x9e82,
		0xf7e4
		},
		{
		0x9e87,
		0xf7e5
		},
		{
		0x9e88,
		0xf7e6
		},
		{
		0x9e8b,
		0xf7e7
		},
		{
		0x9e92,
		0xf7e8
		},
		{
		0x9e93,
		0xc2b4
		},
		{
		0x9e97,
		0xc0f6
		},
		{
		0x9e9d,
		0xf7ea
		},
		{
		0x9e9f,
		0xf7eb
		},
		{
		0x9ea5,
		0xc2f3
		},
		{
		0x9ea9,
		0xf4ef
		},
		{
		0x9eaf,
		0xf8e5
		},
		{
		0x9eb4,
		0xf4f0
		},
		{
		0x9eb5,
		0xf8d9
		},
		{
		0x9ebb,
		0xc2e9
		},
		{
		0x9ebd,
		0xc3b4
		},
		{
		0x9ebe,
		0xf7e2
		},
		{
		0x9ec4,
		0xbbc6
		},
		{
		0x9ecc,
		0xd9e4
		},
		{
		0x9ecd,
		0xcaf2
		},
		{
		0x9ece,
		0xc0e8
		},
		{
		0x9ecf,
		0xf0a4
		},
		{
		0x9ed1,
		0xbada
		},
		{
		0x9ed4,
		0xc7ad
		},
		{
		0x9ed8,
		0xc4ac
		},
		{
		0x9edb,
		0xf7ec
		},
		{
		0x9edc,
		0xf7ed
		},
		{
		0x9edd,
		0xf7ee
		},
		{
		0x9ede,
		0xb5e3
		},
		{
		0x9edf,
		0xf7f0
		},
		{
		0x9ee0,
		0xf7ef
		},
		{
		0x9ee2,
		0xf7f1
		},
		{
		0x9ee5,
		0xf7f4
		},
		{
		0x9ee7,
		0xf7f3
		},
		{
		0x9ee8,
		0xb5b3
		},
		{
		0x9eef,
		0xf7f6
		},
		{
		0x9ef2,
		0xf7f5
		},
		{
		0x9ef4,
		0xf8d4
		},
		{
		0x9ef7,
		0xf7f2
		},
		{
		0x9ef9,
		0xede9
		},
		{
		0x9efb,
		0xedea
		},
		{
		0x9efc,
		0xedeb
		},
		{
		0x9efd,
		0xf6bc
		},
		{
		0x9eff,
		0xf6bd
		},
		{
		0x9f09,
		0xf6be
		},
		{
		0x9f0e,
		0xb6a6
		},
		{
		0x9f10,
		0xd8be
		},
		{
		0x9f13,
		0xb9c4
		},
		{
		0x9f15,
		0xf8ae
		},
		{
		0x9f17,
		0xd8bb
		},
		{
		0x9f19,
		0xdcb1
		},
		{
		0x9f20,
		0xcaf3
		},
		{
		0x9f22,
		0xf7f7
		},
		{
		0x9f2c,
		0xf7f8
		},
		{
		0x9f2f,
		0xf7f9
		},
		{
		0x9f37,
		0xf7fb
		},
		{
		0x9f39,
		0xf7fa
		},
		{
		0x9f3b,
		0xb1c7
		},
		{
		0x9f3d,
		0xf7fc
		},
		{
		0x9f3e,
		0xf7fd
		},
		{
		0x9f44,
		0xf7fe
		},
		{
		0x9f4a,
		0xc6eb
		},
		{
		0x9f4b,
		0xd5ab
		},
		{
		0x9f4f,
		0xecb4
		},
		{
		0x9f52,
		0xb3dd
		},
		{
		0x9f54,
		0xf6b3
		},
		{
		0x9f59,
		0xf6b5
		},
		{
		0x9f5c,
		0xf6b7
		},
		{
		0x9f5f,
		0xf6b4
		},
		{
		0x9f60,
		0xf6b6
		},
		{
		0x9f61,
		0xc1e4
		},
		{
		0x9f63,
		0xf8aa
		},
		{
		0x9f66,
		0xf6b8
		},
		{
		0x9f6a,
		0xf6ba
		},
		{
		0x9f6c,
		0xf6b9
		},
		{
		0x9f72,
		0xc8a3
		},
		{
		0x9f77,
		0xf6bb
		},
		{
		0x9f8d,
		0xc1fa
		},
		{
		0x9f90,
		0xc5d3
		},
		{
		0x9f94,
		0xb9a8
		},
		{
		0x9f95,
		0xede8
		},
		{
		0x9f9c,
		0xb9ea
		},
		{
		0x9fa0,
		0xd9df
		},
		{
		0xff01,
		0xa3a1
		},
		{
		0xff02,
		0xa3a2
		},
		{
		0xff03,
		0xa3a3
		},
		{
		0xff04,
		0xa1e7
		},
		{
		0xff5e,
		0xa1ab
		},
		{
		0xffe0,
		0xa1e9
		},
		{
		0xffe1,
		0xa1ea
		},
		{
		0xffe3,
		0xa3fe
		},
		{
		0xffe5,
		0xa3a4
		}
	};

LOCAL_D const SCnvConversionData::SVariableByteData::SRange foreignVariableByteDataRanges[]=
	{
		{
		0x00,
		0x7f,
		0,
		0
		},
		{
		0x80,
		0xff,
		1,
		0
		}
	};

LOCAL_D const SCnvConversionData::SOneDirectionData::SRange foreignToUnicodeDataRanges[]=
	{
		{
		0x00,
		0x7f,
		SCnvConversionData::SOneDirectionData::SRange::EDirect,
		0,
		0,
			{
			0
			}
		},
		{
		0xa2b1,
		0xa2c4,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -32297)
			}
		},
		{
		0xa2c5,
		0xa2d8,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -32337)
			}
		},
		{
		0xa2d9,
		0xa2e2,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -32377)
			}
		},
		{
		0xa2e5,
		0xa2ee,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -28869)
			}
		},
		{
		0xa2f1,
		0xa2fc,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -33169)
			}
		},
		{
		0xa3a5,
		0xa3fd,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, 23392)
			}
		},
		{
		0xa4a1,
		0xa4f3,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -29792)
			}
		},
		{
		0xa5a1,
		0xa5f6,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -29952)
			}
		},
		{
		0xa6a1,
		0xa6b1,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -41744)
			}
		},
		{
		0xa6b2,
		0xa6b8,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -41743)
			}
		},
		{
		0xa6c1,
		0xa6d1,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -41744)
			}
		},
		{
		0xa6d2,
		0xa6d8,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -41743)
			}
		},
		{
		0xa7a1,
		0xa7a6,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -41873)
			}
		},
		{
		0xa7a8,
		0xa7c1,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -41874)
			}
		},
		{
		0xa7d1,
		0xa7d6,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -41889)
			}
		},
		{
		0xa7d8,
		0xa7f1,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -41890)
			}
		},
		{
		0xa8c5,
		0xa8e9,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -30656)
			}
		},
		{
		0xa9a4,
		0xa9ef,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, -33956)
			}
		},
		{
		0xa1a1,
		0xf9a9,
		SCnvConversionData::SOneDirectionData::SRange::EKeyedTable16OfIndexedTables16,
		0,
		0,
			{
			UData_SKeyedTable16OfIndexedTables16(keyedTables16OfIndexedTables16_keyedEntries_foreignToUnicode_1)
			}
		},
		{
		0xa3a1,
		0xa7d7,
		SCnvConversionData::SOneDirectionData::SRange::EKeyedTable1616,
		0,
		0,
			{
			UData_SKeyedTable1616(keyedTable1616_foreignToUnicode_1)
			}
		}
	};

LOCAL_D const SCnvConversionData::SOneDirectionData::SRange unicodeToForeignDataRanges[]=
	{
		{
		0x0000,
		0x007f,
		SCnvConversionData::SOneDirectionData::SRange::EDirect,
		1,
		0,
			{
			0
			}
		},
		{
		0x0391,
		0x03a1,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 41744)
			}
		},
		{
		0x03a3,
		0x03a9,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 41743)
			}
		},
		{
		0x03b1,
		0x03c1,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 41744)
			}
		},
		{
		0x03c3,
		0x03c9,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 41743)
			}
		},
		{
		0x0410,
		0x0415,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 41873)
			}
		},
		{
		0x0416,
		0x042f,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 41874)
			}
		},
		{
		0x0430,
		0x0435,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 41889)
			}
		},
		{
		0x0436,
		0x044f,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 41890)
			}
		},
		{
		0x2160,
		0x216b,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 33169)
			}
		},
		{
		0x2460,
		0x2469,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 32377)
			}
		},
		{
		0x2474,
		0x2487,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 32337)
			}
		},
		{
		0x2488,
		0x249b,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 32297)
			}
		},
		{
		0x2500,
		0x254b,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 33956)
			}
		},
		{
		0x3008,
		0x300f,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 29100)
			}
		},
		{
		0x3041,
		0x3093,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 29792)
			}
		},
		{
		0x30a1,
		0x30f6,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 29952)
			}
		},
		{
		0x3105,
		0x3129,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 30656)
			}
		},
		{
		0x3220,
		0x3229,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, 28869)
			}
		},
		{
		0xff05,
		0xff5d,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		2,
		0,
			{
			STATIC_CAST(TUint, -23392)
			}
		},
		{
		0x00a4,
		0xffe5,
		SCnvConversionData::SOneDirectionData::SRange::EKeyedTable1616,
		2,
		0,
			{
			UData_SKeyedTable1616(keyedTable1616_unicodeToForeign_1)
			}
		}
	};

GLDEF_D const SCnvConversionData conversionData=
	{
	SCnvConversionData::EFixedBigEndian,
		{
		ARRAY_LENGTH(foreignVariableByteDataRanges),
		foreignVariableByteDataRanges
		},
		{
		ARRAY_LENGTH(foreignToUnicodeDataRanges),
		foreignToUnicodeDataRanges
		},
		{
		ARRAY_LENGTH(unicodeToForeignDataRanges),
		unicodeToForeignDataRanges
		},
	NULL,
	NULL
	};

