/*
* Copyright (c) 1256 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  
*
*/




#include <e32std.h>
#include <convdata.h>
#include <convgeneratedcpp.h>

#define ARRAY_LENGTH(aArray) (sizeof(aArray)/sizeof((aArray)[0]))

#pragma warning (disable: 4049) // compiler limit : terminating line number emission

_LIT8(KLit8ReplacementForUnconvertibleUnicodeCharacters, "\x1a");

GLDEF_C const TDesC8& ReplacementForUnconvertibleUnicodeCharacters_internal()
	{
	return KLit8ReplacementForUnconvertibleUnicodeCharacters;
	}

LOCAL_D const SCnvConversionData::SOneDirectionData::SRange::UData::SKeyedTable1616::SEntry keyedTable1616_foreignToUnicode_1[]=
	{
		{
		0x80,
		0x20ac
		},
		{
		0x81,
		0x067e
		},
		{
		0x82,
		0x201a
		},
		{
		0x83,
		0x0192
		},
		{
		0x84,
		0x201e
		},
		{
		0x85,
		0x2026
		},
		{
		0x86,
		0x2020
		},
		{
		0x87,
		0x2021
		},
		{
		0x88,
		0x02c6
		},
		{
		0x89,
		0x2030
		},
		{
		0x8a,
		0x0679
		},
		{
		0x8b,
		0x2039
		},
		{
		0x8c,
		0x0152
		},
		{
		0x8d,
		0x0686
		},
		{
		0x8e,
		0x0698
		},
		{
		0x8f,
		0x0688
		},
		{
		0x90,
		0x06af
		},
		{
		0x91,
		0x2018
		},
		{
		0x92,
		0x2019
		},
		{
		0x93,
		0x201c
		},
		{
		0x94,
		0x201d
		},
		{
		0x95,
		0x2022
		},
		{
		0x96,
		0x2013
		},
		{
		0x97,
		0x2014
		},
		{
		0x98,
		0x06a9
		},
		{
		0x99,
		0x2122
		},
		{
		0x9a,
		0x0691
		},
		{
		0x9b,
		0x203a
		},
		{
		0x9c,
		0x0153
		},
		{
		0x9d,
		0x200c
		},
		{
		0x9e,
		0x200d
		},
		{
		0x9f,
		0x06ba
		},
		{
		0xa0,
		0x00a0
		},
		{
		0xa1,
		0x060c
		},
		{
		0xa2,
		0x00a2
		},
		{
		0xa3,
		0x00a3
		},
		{
		0xa4,
		0x00a4
		},
		{
		0xa5,
		0x00a5
		},
		{
		0xa6,
		0x00a6
		},
		{
		0xa7,
		0x00a7
		},
		{
		0xa8,
		0x00a8
		},
		{
		0xa9,
		0x00a9
		},
		{
		0xaa,
		0x06be
		},
		{
		0xba,
		0x061b
		},
		{
		0xbb,
		0x00bb
		},
		{
		0xbc,
		0x00bc
		},
		{
		0xbd,
		0x00bd
		},
		{
		0xbe,
		0x00be
		},
		{
		0xbf,
		0x061f
		},
		{
		0xc0,
		0x06c1
		},
		{
		0xd7,
		0x00d7
		},
		{
		0xd8,
		0x0637
		},
		{
		0xd9,
		0x0638
		},
		{
		0xda,
		0x0639
		},
		{
		0xdb,
		0x063a
		},
		{
		0xdc,
		0x0640
		},
		{
		0xdd,
		0x0641
		},
		{
		0xde,
		0x0642
		},
		{
		0xdf,
		0x0643
		},
		{
		0xe0,
		0x00e0
		},
		{
		0xe1,
		0x0644
		},
		{
		0xe2,
		0x00e2
		},
		{
		0xe3,
		0x0645
		},
		{
		0xe4,
		0x0646
		},
		{
		0xe5,
		0x0647
		},
		{
		0xe6,
		0x0648
		},
		{
		0xe7,
		0x00e7
		},
		{
		0xe8,
		0x00e8
		},
		{
		0xe9,
		0x00e9
		},
		{
		0xea,
		0x00ea
		},
		{
		0xeb,
		0x00eb
		},
		{
		0xec,
		0x0649
		},
		{
		0xed,
		0x064a
		},
		{
		0xee,
		0x00ee
		},
		{
		0xef,
		0x00ef
		},
		{
		0xf0,
		0x064b
		},
		{
		0xf1,
		0x064c
		},
		{
		0xf2,
		0x064d
		},
		{
		0xf3,
		0x064e
		},
		{
		0xf4,
		0x00f4
		},
		{
		0xf5,
		0x064f
		},
		{
		0xf6,
		0x0650
		},
		{
		0xf7,
		0x00f7
		},
		{
		0xf8,
		0x0651
		},
		{
		0xf9,
		0x00f9
		},
		{
		0xfa,
		0x0652
		},
		{
		0xfb,
		0x00fb
		},
		{
		0xfc,
		0x00fc
		},
		{
		0xfd,
		0x200e
		},
		{
		0xfe,
		0x200f
		},
		{
		0xff,
		0x06d2
		}
	};

LOCAL_D const SCnvConversionData::SOneDirectionData::SRange::UData::SKeyedTable1616::SEntry keyedTable1616_unicodeToForeign_1[]=
	{
		{
		0x00a0,
		0xa0
		},
		{
		0x00bb,
		0xbb
		},
		{
		0x00bc,
		0xbc
		},
		{
		0x00bd,
		0xbd
		},
		{
		0x00be,
		0xbe
		},
		{
		0x00d7,
		0xd7
		},
		{
		0x00e0,
		0xe0
		},
		{
		0x00e2,
		0xe2
		},
		{
		0x00e7,
		0xe7
		},
		{
		0x00e8,
		0xe8
		},
		{
		0x00e9,
		0xe9
		},
		{
		0x00ea,
		0xea
		},
		{
		0x00eb,
		0xeb
		},
		{
		0x00ee,
		0xee
		},
		{
		0x00ef,
		0xef
		},
		{
		0x00f4,
		0xf4
		},
		{
		0x00f7,
		0xf7
		},
		{
		0x00f9,
		0xf9
		},
		{
		0x00fb,
		0xfb
		},
		{
		0x00fc,
		0xfc
		},
		{
		0x0152,
		0x8c
		},
		{
		0x0153,
		0x9c
		},
		{
		0x0192,
		0x83
		},
		{
		0x02c6,
		0x88
		},
		{
		0x060c,
		0xa1
		},
		{
		0x061b,
		0xba
		},
		{
		0x061f,
		0xbf
		},
		{
		0x0637,
		0xd8
		},
		{
		0x0638,
		0xd9
		},
		{
		0x0639,
		0xda
		},
		{
		0x063a,
		0xdb
		},
		{
		0x0640,
		0xdc
		},
		{
		0x0641,
		0xdd
		},
		{
		0x0642,
		0xde
		},
		{
		0x0643,
		0xdf
		},
		{
		0x0644,
		0xe1
		},
		{
		0x0645,
		0xe3
		},
		{
		0x0646,
		0xe4
		},
		{
		0x0647,
		0xe5
		},
		{
		0x0648,
		0xe6
		},
		{
		0x0649,
		0xec
		},
		{
		0x064a,
		0xed
		},
		{
		0x064b,
		0xf0
		},
		{
		0x064c,
		0xf1
		},
		{
		0x064d,
		0xf2
		},
		{
		0x064e,
		0xf3
		},
		{
		0x064f,
		0xf5
		},
		{
		0x0650,
		0xf6
		},
		{
		0x0651,
		0xf8
		},
		{
		0x0652,
		0xfa
		},
		{
		0x0679,
		0x8a
		},
		{
		0x067e,
		0x81
		},
		{
		0x0686,
		0x8d
		},
		{
		0x0688,
		0x8f
		},
		{
		0x0691,
		0x9a
		},
		{
		0x0698,
		0x8e
		},
		{
		0x06a9,
		0x98
		},
		{
		0x06af,
		0x90
		},
		{
		0x06ba,
		0x9f
		},
		{
		0x06be,
		0xaa
		},
		{
		0x06c1,
		0xc0
		},
		{
		0x06d2,
		0xff
		},
		{
		0x200c,
		0x9d
		},
		{
		0x200d,
		0x9e
		},
		{
		0x200e,
		0xfd
		},
		{
		0x200f,
		0xfe
		},
		{
		0x2013,
		0x96
		},
		{
		0x2014,
		0x97
		},
		{
		0x2018,
		0x91
		},
		{
		0x2019,
		0x92
		},
		{
		0x201a,
		0x82
		},
		{
		0x201c,
		0x93
		},
		{
		0x201d,
		0x94
		},
		{
		0x201e,
		0x84
		},
		{
		0x2020,
		0x86
		},
		{
		0x2021,
		0x87
		},
		{
		0x2022,
		0x95
		},
		{
		0x2026,
		0x85
		},
		{
		0x2030,
		0x89
		},
		{
		0x2039,
		0x8b
		},
		{
		0x203a,
		0x9b
		},
		{
		0x20ac,
		0x80
		},
		{
		0x2122,
		0x99
		}
	};

LOCAL_D const SCnvConversionData::SVariableByteData::SRange foreignVariableByteDataRanges[]=
	{
		{
		0x00,
		0xff,
		0,
		0
		}
	};

LOCAL_D const SCnvConversionData::SOneDirectionData::SRange foreignToUnicodeDataRanges[]=
	{
		{
		0x00,
		0x7f,
		SCnvConversionData::SOneDirectionData::SRange::EDirect,
		0,
		0,
			{
			0,
			0
			}
		},
		{
		0xab,
		0xb9,
		SCnvConversionData::SOneDirectionData::SRange::EDirect,
		0,
		0,
			{
			0,
			0
			}
		},
		{
		0xc1,
		0xd6,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		0,
		0,
			{
			STATIC_CAST(TUint, 1376),
			0
			}
		},
		{
		0x80,
		0xff,
		SCnvConversionData::SOneDirectionData::SRange::EKeyedTable1616,
		0,
		0,
			{
			STATIC_CAST(TUint, ARRAY_LENGTH(keyedTable1616_foreignToUnicode_1)),
			REINTERPRET_CAST(TUint, CONST_CAST( SCnvConversionData::SOneDirectionData::SRange::UData::SKeyedTable1616::SEntry*, keyedTable1616_foreignToUnicode_1))
			}
		}
	};

LOCAL_D const SCnvConversionData::SOneDirectionData::SRange unicodeToForeignDataRanges[]=
	{
		{
		0x0000,
		0x007f,
		SCnvConversionData::SOneDirectionData::SRange::EDirect,
		1,
		0,
			{
			0,
			0
			}
		},
		{
		0x00a2,
		0x00a9,
		SCnvConversionData::SOneDirectionData::SRange::EDirect,
		1,
		0,
			{
			0,
			0
			}
		},
		{
		0x00ab,
		0x00b9,
		SCnvConversionData::SOneDirectionData::SRange::EDirect,
		1,
		0,
			{
			0,
			0
			}
		},
		{
		0x0621,
		0x0636,
		SCnvConversionData::SOneDirectionData::SRange::EOffset,
		1,
		0,
			{
			STATIC_CAST(TUint, -1376),
			0
			}
		},
		{
		0x00a0,
		0x2122,
		SCnvConversionData::SOneDirectionData::SRange::EKeyedTable1616,
		1,
		0,
			{
			STATIC_CAST(TUint, ARRAY_LENGTH(keyedTable1616_unicodeToForeign_1)),
			REINTERPRET_CAST(TUint, CONST_CAST( SCnvConversionData::SOneDirectionData::SRange::UData::SKeyedTable1616::SEntry*, keyedTable1616_unicodeToForeign_1))
			}
		}
	};

GLDEF_D const SCnvConversionData conversionData=
	{
	SCnvConversionData::EFixedBigEndian,
		{
		ARRAY_LENGTH(foreignVariableByteDataRanges),
		foreignVariableByteDataRanges
		},
		{
		ARRAY_LENGTH(foreignToUnicodeDataRanges),
		foreignToUnicodeDataRanges
		},
		{
		ARRAY_LENGTH(unicodeToForeignDataRanges),
		unicodeToForeignDataRanges
		},
	NULL,
	NULL
	};

