/*
 * Summary: Unicode character range checking
 * Description: this module exports interfaces for the character
 *       range validation APIs
 *
 * This file is automatically generated from the cvs source
 * definition files using the genChRanges.py Python script
 *
 * Generation date: Tue Nov 18 08:14:21 2003
 * Sources: chvalid.def
 * Author: William Brack <wbrack@mmm.com.hk>
 * 
 * See Copyright for the status of this software.
 * Portion Copyright  2009 Nokia Corporation and/or its subsidiary(-ies). All rights reserved. 
 */

/** @file
@publishedAll
@released
*/

#ifndef XML_CHVALID_H
#define XML_CHVALID_H

#pragma warning(disable: 4127 4132 4510 4512 4610)

#include "libxml2_xmlstring.h"

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Define our typedefs and structures
 *
 */

// XMLENGINE: xmlChSRangePtr declared as const now
typedef struct _xmlChSRange xmlChSRange;
typedef const xmlChSRange* xmlChSRangePtr;
struct _xmlChSRange {
    const unsigned short    low;
    const unsigned short    high;
};

typedef struct _xmlChLRange xmlChLRange;
typedef const xmlChLRange* xmlChLRangePtr;
struct _xmlChLRange {
    const unsigned int  low;
    const unsigned int  high;
};

typedef struct _xmlChRangeGroup xmlChRangeGroup;
typedef const xmlChRangeGroup *xmlChRangeGroupPtr;
struct _xmlChRangeGroup {
    const int            nbShortRange;
    const int            nbLongRange;
    const xmlChSRangePtr shortRange;    /* points to an array of ranges */
    const xmlChLRangePtr longRange;
};

/**
 * Range checking routine
 */
XMLPUBFUN int XMLCALL
        xmlCharInRange(unsigned int val, const xmlChRangeGroupPtr group);


/**
 * xmlIsBaseChar_ch:
 * @c: char to validate
 *
 * Automatically generated by genChRanges.py
 */
#define xmlIsBaseChar_ch(c) (((0x41 <= (c)) && ((c) <= 0x5a)) || \
                 ((0x61 <= (c)) && ((c) <= 0x7a)) || \
                 ((0xc0 <= (c)) && ((c) <= 0xd6)) || \
                 ((0xd8 <= (c)) && ((c) <= 0xf6)) || \
                  (0xf8 <= (c)))
#ifndef UNDEF_IMPORT_C_IN_DATA
XMLPUBVAR const xmlChSRange  xmlIsBaseChar_srng[197];
#endif
/**
 * xmlIsBaseCharQ:
 * @c: char to validate
 *
 * Automatically generated by genChRanges.py
 */
#define xmlIsBaseCharQ(c)   (((c) < 0x100) ? \
                 xmlIsBaseChar_ch((c)) : \
                 xmlCharInRange((c), &xmlIsBaseCharGroup))
#ifndef UNDEF_IMPORT_C_IN_DATA
XMLPUBVAR const xmlChRangeGroup xmlIsBaseCharGroup;
#endif
/**
 * xmlIsBlank_ch:
 * @c: char to validate
 *
 * Automatically generated by genChRanges.py
 *
 * OOM: never
 */ 
#define xmlIsBlank_ch(c)    (((c) == 0x20) || \
                 ((0x9 <= (c)) && ((c) <= 0xa)) || \
                 ((c) == 0xd))

/**
 * xmlIsBlankQ:
 * @c: char to validate
 *
 * Automatically generated by genChRanges.py
 */
#define xmlIsBlankQ(c)      (((c) < 0x100) ? \
                 xmlIsBlank_ch((c)) : 0)


/**
 * xmlIsChar_ch:
 * @c: char to validate
 *
 * Automatically generated by genChRanges.py
 */
#define xmlIsChar_ch(c)     (((0x9 <= (c)) && ((c) <= 0xa)) || \
                 ((c) == 0xd) || \
                  (0x20 <= (c)))

/**
 * xmlIsCharQ:
 * @c: char to validate
 *
 * Automatically generated by genChRanges.py
 */
#define xmlIsCharQ(c)       (((c) < 0x100) ? \
                 xmlIsChar_ch((c)) :\
                (((0x100 <= (c)) && ((c) <= 0xd7ff)) || \
                 ((0xe000 <= (c)) && ((c) <= 0xfffd)) || \
                 ((0x10000 <= (c)) && ((c) <= 0x10ffff))))

//XMLPUBVAR const xmlChRangeGroup xmlIsCharGroup;

/**
 * xmlIsCombiningQ:
 * @c: char to validate
 *
 * Automatically generated by genChRanges.py
 */
#define xmlIsCombiningQ(c)  (((c) < 0x100) ? \
                 0 : \
                 xmlCharInRange((c), &xmlIsCombiningGroup))
#ifndef UNDEF_IMPORT_C_IN_DATA
XMLPUBVAR const xmlChSRange xmlIsCombining_srng[];
XMLPUBVAR const xmlChRangeGroup xmlIsCombiningGroup;
#endif
/**
 * xmlIsDigit_ch:
 * @c: char to validate
 *
 * Automatically generated by genChRanges.py
 */
#define xmlIsDigit_ch(c)    (((0x30 <= (c)) && ((c) <= 0x39)))

/**
 * xmlIsDigitQ:
 * @c: char to validate
 *
 * Automatically generated by genChRanges.py
 */
#define xmlIsDigitQ(c)      (((c) < 0x100) ? \
                 xmlIsDigit_ch((c)) : \
                 xmlCharInRange((c), &xmlIsDigitGroup))
#ifndef UNDEF_IMPORT_C_IN_DATA
XMLPUBVAR const xmlChRangeGroup xmlIsDigitGroup;
XMLPUBVAR const xmlChSRange xmlIsDigit_srng[];
#endif
/**
 * xmlIsExtender_ch:
 * @c: char to validate
 *
 * Automatically generated by genChRanges.py
 */
#define xmlIsExtender_ch(c) (((c) == 0xb7))

/**
 * xmlIsExtenderQ:
 * @c: char to validate
 *
 * Automatically generated by genChRanges.py
 */
#define xmlIsExtenderQ(c)   (((c) < 0x100) ?                \
                 xmlIsExtender_ch((c)) :                    \
                 xmlCharInRange((c), &xmlIsExtenderGroup))
#ifndef UNDEF_IMPORT_C_IN_DATA
XMLPUBVAR const xmlChSRange xmlIsExtender_srng[];
XMLPUBVAR const xmlChRangeGroup xmlIsExtenderGroup;
#endif
/**
 * xmlIsIdeographicQ:
 * @c: char to validate
 *
 * Automatically generated by genChRanges.py
 */
#define xmlIsIdeographicQ(c)    (((c) < 0x100) ?  0 :       \
                (((0x4e00 <= (c)) && ((c) <= 0x9fa5)) ||    \
                 ((c) == 0x3007) ||                         \
                 ((0x3021 <= (c)) && ((c) <= 0x3029))))

/**
 * xmlIsPubidChar_ch:
 * @c: char to validate
 *
 * Automatically generated by genChRanges.py
 */
#define xmlIsPubidChar_ch(c)    (xmlIsPubidChar_tab[(c)])

/*
 * The initial tables ({func_name}_tab) are used to validate whether a
 * single-byte character is within the specified group.  Each table
 * contains 256 bytes, with each byte representing one of the 256
 * possible characters.  If the table byte is set, the character is
 * allowed.
 *
 */
#ifndef UNDEF_IMPORT_C_IN_DATA
XMLPUBVAR const unsigned char xmlIsPubidChar_tab[256];
#endif
/**
 * xmlIsPubidCharQ:
 * @c: char to validate
 *
 * Automatically generated by genChRanges.py
 */
#define xmlIsPubidCharQ(c)  (((c) < 0x100) ? xmlIsPubidChar_ch((c)) : 0)

#ifndef XMLENGINE_EXCLUDE_UNUSED
// these are deprecated and replaced by macroses (for performance reasons)
XMLPUBFUN int XMLCALL   xmlIsBaseChar   (unsigned int ch);
XMLPUBFUN int XMLCALL   xmlIsBlank      (unsigned int ch);
XMLPUBFUN int XMLCALL   xmlIsChar       (unsigned int ch);
XMLPUBFUN int XMLCALL   xmlIsCombining  (unsigned int ch);
XMLPUBFUN int XMLCALL   xmlIsDigit      (unsigned int ch);
XMLPUBFUN int XMLCALL   xmlIsExtender   (unsigned int ch);
XMLPUBFUN int XMLCALL   xmlIsIdeographic(unsigned int ch);
XMLPUBFUN int XMLCALL   xmlIsPubidChar  (unsigned int ch);
#endif /* ifndef XMLENGINE_EXCLUDE_UNUSED */


#ifdef __cplusplus
}
#endif
#endif /* XML_CHVALID_H */

