/*
* Copyright (c) 2008 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/

/** @file
@publishedAll
@released
*/

#ifndef XMLENGDOMERRORS_H
#define XMLENGDOMERRORS_H

#include <e32def.h> 

/**	
DOM parsing error.

All errors returned by the DOM parser (positive values) are propagated from the
open-source library.  They can be found in the documentation for Libxml2
(version 2.6.10). See http://xmlsoft.org.  

@see xmlParserErrors
@see libxml2_xmlerror.h

These errors are generated by DOM APIs and may occur as a Leave or as a return
code.
*/
const TInt KXmlEngErrParsing = -32397;

/**	DOM save error */
const TInt KXmlEngErrNegativeOutputSize = -32383;

/**	Encoding not understood*/
const TInt KXmlEngErrWrongEncoding = -32382;

/** KXmlEngErrNullNode error */
const TInt KXmlEngErrNullNode = -32380;

/** KXmlEngErrWrongUseOfAPI error */
const TInt KXmlEngErrWrongUseOfAPI = -32381;

#endif // XMLENGDOMERRORS_H

