/*
 * Summary: interface for all global variables of the library
 * Description: all the global variables and thread handling for
 *              those variables is handled by this module.
 *
 * The bottom of this file is automatically generated by build_glob.py
 * based on the description file global.data
 *
 * Copy: See Copyright for the status of this software.
 *
 * Author: Gary Pennington <Gary.Pennington@uk.sun.com>, Daniel Veillard
 * Portion Copyright  2009 Nokia Corporation and/or its subsidiary(-ies). All rights reserved. 
 */

/** @file
@publishedAll
@released
*/

#ifndef XML_GLOBALS_H
#define XML_GLOBALS_H

#ifdef XE_ENABLE_GS_CACHING
/* This feature is enabled/disabled by defining/removing XE_ENABLE_GS_CACHING macro in libxml2 mmp file.
   When enabled, it allows to use cached GS (global state) pointer from xmlDoc and xmlParserCtxt objects
   in libxml2. This improves the overall performance (depending on usecase, dom parsing is improved sigificantly)
   since it avoids most of Dll::Tls() calls for accessing each member in GS data structure.

   NOTE: When GS pointer caching is enabled, always ensure that GS proxy variable is initialized
   before first access to any GS member. We should ensure more safety in debug builds, like non initialized or NULL
   GS proxy variable. 
*/
#define XE_GS_PROXY_VAR             __xe_gs
#define DEFINE_GS_PROXY             xmlGlobalStatePtr XE_GS_PROXY_VAR;
#define SET_GS_PROXY(addr)          XE_GS_PROXY_VAR = addr;
#define DEFINE_GS_PROXY_AS(addr)    xmlGlobalStatePtr XE_GS_PROXY_VAR = addr;
#define ASSIGN_GS_DIRECT            XE_GS_PROXY_VAR = (xmlGlobalStatePtr)xmlGetGlobalState()
#define ASSIGN_GS(var)              XE_GS_PROXY_VAR = (xmlGlobalStatePtr)(var->cachedGs)
#define LOAD_GS_DIRECT              DEFINE_GS_PROXY_AS((xmlGlobalStatePtr)xmlGetGlobalState())
#define LOAD_GS(src)                DEFINE_GS_PROXY_AS((xmlGlobalStatePtr)(src->cachedGs))

#define LOAD_GS_SAFE_CTXT(ctxt) \
                DEFINE_GS_PROXY \
                if(ctxt)    \
                {ASSIGN_GS(ctxt);} else {ASSIGN_GS_DIRECT;}

#define LOAD_GS_SAFE_DOC(doc) \
                DEFINE_GS_PROXY \
                if(doc && (doc->type == XML_DOCUMENT_NODE))    \
                   {ASSIGN_GS(doc);} else {ASSIGN_GS_DIRECT;}

#define LOAD_GS_SAFE_NODE(node) \
                DEFINE_GS_PROXY \
                if(node && (node->doc) && (node->doc->type == XML_DOCUMENT_NODE)) \
                   {ASSIGN_GS(node->doc);} else {ASSIGN_GS_DIRECT;}

#define LOAD_GS_SAFE_DTD(dtd) \
                DEFINE_GS_PROXY \
                if(dtd && (dtd->doc) && (dtd->doc->type == XML_DOCUMENT_NODE))    \
                   {ASSIGN_GS(dtd->doc);} else {ASSIGN_GS_DIRECT;}

#define LOAD_GS_SAFE_ATTR(attr) \
                DEFINE_GS_PROXY \
                if(attr && (attr->doc) && (attr->doc->type == XML_DOCUMENT_NODE))    \
                   {ASSIGN_GS(attr->doc);} else {ASSIGN_GS_DIRECT;}

#define LOAD_GS_SAFE_ENT(ent) \
                DEFINE_GS_PROXY \
                if(ent && (ent->doc) && (ent->doc->type == XML_DOCUMENT_NODE))    \
                   {ASSIGN_GS(ent->doc);} else {ASSIGN_GS_DIRECT;}

#define LOAD_GS_SAFE_XPATH_PARSER_CTXT(ctxtp) \
                DEFINE_GS_PROXY \
                if(ctxtp && (ctxtp->context) && (ctxtp->context->doc) && (ctxtp->context->doc->type == XML_DOCUMENT_NODE))    \
                   {ASSIGN_GS(ctxtp->context->doc);} else {ASSIGN_GS_DIRECT;}

#define LOAD_GS_SAFE_XPATH_CTXT(ctx) \
                DEFINE_GS_PROXY \
                if(ctx && (ctx->doc) && (ctx->doc->type == XML_DOCUMENT_NODE))    \
                   {ASSIGN_GS(ctx->doc);} else {ASSIGN_GS_DIRECT;}

#else // Feature is disabled
#define XE_GS_PROXY_VAR xmlGetGlobalState()
#define DEFINE_GS_PROXY
#define SET_GS_PROXY(addr)
#define LOAD_GS_DIRECT
#define LOAD_GS(src)
#define ASSIGN_GS_DIRECT
#define ASSIGN_GS(var)
#define LOAD_GS_SAFE_CTXT(ctxt)
#define LOAD_GS_SAFE_DOC(doc)
#define LOAD_GS_SAFE_NODE(node)
#define LOAD_GS_SAFE_DTD(dtd)
#define LOAD_GS_SAFE_ATTR(attr)
#define LOAD_GS_SAFE_ENT(ent)
#define LOAD_GS_SAFE_XPATH_PARSER_CTXT(ctxtp)
#define LOAD_GS_SAFE_XPATH_CTXT(ctx)
#endif //XE_ENABLE_GS_CACHING

typedef struct _xmlGlobalState xmlGlobalState;
typedef xmlGlobalState *xmlGlobalStatePtr;

#include <stdapis/libxml2/libxml2_xmlmemory.h>
#include <stdapis/libxml2/libxml2_sax.h>
#include <stdapis/libxml2/libxml2_sax2.h>
#include <stdapis/libxml2/libxml2_chvalid.h>

#ifdef XMLENGINE_XSLT
#if defined(XSLT_WIN32_PERFORMANCE_COUNTER) || defined(HAVE_GETTIMEOFDAY)
#defined XSLT_PROFILING_ENABLED
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef unsigned int xmlLinAddress;

XMLPUBFUN int  XMLCALL xmlOOMFlag();

XMLPUBFUN void* XMLCALL malloc_impl(size_t size);

XMLPUBFUN void* XMLCALL realloc_impl(void *ptr, size_t size);

#ifdef LIBXML_XPATH_ENABLED
#include <stdapis/libxml2/xmlengtriodef.h>
#include <stdapis/libxml2/xmlengtrionan.h>
#include <stdapis/libxml2/libxml2_xpathinternals.h>
#endif

#ifdef LIBXML_CATALOG_ENABLED
#include "libxml/libxml2_catalog.h"
#endif


#ifdef XMLENGINE_XMLSCHEMA_DATATYPES
#include <stdapis/libxml2/libxml2_xmlschemasglobals.h>
#endif


typedef struct _xmlCharEncodingAlias xmlCharEncodingAlias;
typedef xmlCharEncodingAlias *xmlCharEncodingAliasPtr;
struct _xmlCharEncodingAlias {
    const char *name;
    const char *alias;
};

typedef struct _xmlInputCallback {
    xmlInputMatchCallback matchcallback;
    xmlInputOpenCallback opencallback;
    xmlInputReadCallback readcallback;
    xmlInputCloseCallback closecallback;
} xmlInputCallback;
#define MAX_INPUT_CALLBACK 15

#ifdef LIBXML_OUTPUT_ENABLED
typedef struct _xmlOutputCallback {
    xmlOutputMatchCallback matchcallback;
    xmlOutputOpenCallback opencallback;
    xmlOutputWriteCallback writecallback;
    xmlOutputCloseCallback closecallback;
} xmlOutputCallback;
#define MAX_OUTPUT_CALLBACK 15
#endif /* LIBXML_OUTPUT_ENABLED */

#define xmlThrDefMutex NULL
#define xmlInitGlobals()
#define xmlCleanupGlobals()


/*
 * Externally global symbols which need to be protected for backwards
 * compatibility support.
 */

#undef  docbDefaultSAXHandler
#undef  htmlDefaultSAXHandler
#undef  xmlBufferAllocScheme
#undef  xmlDefaultBufferSize
#undef  xmlDefaultSAXHandler
#undef  xmlDefaultSAXLocator
#undef  xmlDoValidityCheckingDefaultValue
#undef  xmlFree
#undef  xmlGenericError
#undef  xmlStructuredError
#undef  xmlGenericErrorContext
#undef  xmlGetWarningsDefaultValue
#undef  xmlIndentTreeOutput
#undef  xmlTreeIndentString
#undef  xmlKeepBlanksDefaultValue
#undef  xmlLineNumbersDefaultValue
#undef  xmlLoadExtDtdDefaultValue
#undef  xmlMalloc
#undef  xmlMallocAtomic
#undef  xmlMemStrdup
#undef  xmlParserDebugEntities
#undef  xmlPedanticParserDefaultValue
#undef  xmlRealloc
#undef  xmlSaveNoEmptyTags
#undef  xmlSubstituteEntitiesDefaultValue
#undef  xmlRegisterNodeDefaultValue
#undef  xmlDeregisterNodeDefaultValue
#undef  xmlLastError
#undef  xmlOOM
#undef  xeUserCount

#undef  htmlStartCloseIndex
#undef  htmlStartCloseIndexinitialized

/* XMLENGINE_XSLT
#undef g_calibration
#undef default_token
#undef xsltExtensionsHash
#undef xsltFunctionsHash
#undef xsltElementsHash
#undef xsltTopLevelsHash
#undef xsltDebuggerCurrentCallbacks
*/
#undef xsltGlobalsCleanupFunc

typedef void (*xmlRegisterNodeFunc) (xmlNodePtr node);
typedef void (*xmlDeregisterNodeFunc) (xmlNodePtr node);


struct _xmlGlobalState
{
    // NOTE: structure fields were reordered comparatively to the original libxml2 source
    //       Most used fields should be in the first 256 bytes of the structure (64 fields)
    //       because on ARM an extra operation is needed for addressing the fields with
    //       larger offset.
    //  Doing this has made size of the DLL 4 KB smaller ! (and faster!)

    int xmlOOM;
    int xeUserCount;
    xmlError xmlLastError;

    DOMStringConverterData xeStringArgs;

    /* Memory */
/* Not used in Symbian: xmlMalloc is malloc_impl(), xmlFree is standard free() now
    xmlFreeFunc xmlFreeFn;
    xmlMallocFunc xmlMallocFn;
    xmlStrdupFunc xmlMemStrdupFn;
    xmlReallocFunc xmlReallocFn;
    xmlMallocFunc xmlMallocAtomicFn;
*/

    xmlGenericErrorFunc xmlGenericError;
    xmlStructuredErrorFunc xmlStructuredError;
    void *xmlGenericErrorContext;

    /* Deafault settings and configuration values */
    xmlBufferAllocationScheme xmlBufferAllocScheme;
    int xmlDefaultBufferSize;
    int xmlSubstituteEntitiesDefaultValue;
    int xmlDoValidityCheckingDefaultValue;
    int xmlGetWarningsDefaultValue;
    int xmlKeepBlanksDefaultValue;
    int xmlLoadExtDtdDefaultValue;
    int xmlParserDebugEntities;
    int xmlPedanticParserDefaultValue;
#ifdef LIBXML_ENABLE_NODE_LINEINFO
    int xmlLineNumbersDefaultValue;
#endif // LIBXML_ENABLE_NODE_LINEINFO
    int xmlSaveNoEmptyTags;
    int xmlIndentTreeOutput;
    //const
    char *xmlTreeIndentString; 
    xmlExternalEntityLoader xmlCurrentExternalEntityLoader;

    xmlRegisterNodeFunc xmlRegisterNodeDefaultValue;
    xmlDeregisterNodeFunc xmlDeregisterNodeDefaultValue;

    /* parser */
    unsigned int xmlParserMaxDepth;

    int __xmlRegisterCallbacks;
    int xmlCompressMode;
    int xmlCheckDTD;

    /* xpath */
    double xmlXPathNAN;
    double xmlXPathPINF;
    double xmlXPathNINF;
    double xmlXPathNZERO;
    int xmlXPathInitialized;
#ifndef LIBXML_THREAD_ENABLED
    int xmlXPathDisableOptimizer;
#endif
    int xmlXPathDefineExtensionFunctionsGlobally;
    xmlHashTablePtr xmlXPathDefaultFunctionsHash;
    xmlHashTablePtr xmlXPathIntermediaryExtensionFunctionsHash;

    /* encoding */
    xmlCharEncodingHandlerPtr   xmlUTF16LEHandler;
    xmlCharEncodingHandlerPtr   xmlUTF16BEHandler;
    xmlCharEncodingAliasPtr     xmlCharEncodingAliases;
    int     xmlCharEncodingAliasesNb;
    int     xmlCharEncodingAliasesMax;
    int     xmlLittleEndian;

    xmlCharEncodingHandlerPtr *handlers;
    int     nbCharEncodingHandler;
    xmlCharEncodingHandlerPtr xmlDefaultCharEncodingHandler;

    /* error */
    int had_info; /* internal */

    /* parserInternals */
    int xmlInputStreamId; /* internal: renamed from "id" to prevent namespace collisions */

    /* parser */
    const char *xmlW3CPIs [2];
    int xmlParserInitialized;
    unsigned int xeStackLimit;

    /* SAX2 */
    int xmlSAX2DefaultVersionValue;

    /* xmlio */
    xmlInputCallback xmlInputCallbackTable[MAX_INPUT_CALLBACK];
    int xmlInputCallbackNr;
    int xmlInputCallbackInitialized;
#ifdef LIBXML_OUTPUT_ENABLED
    xmlOutputCallback xmlOutputCallbackTable[MAX_OUTPUT_CALLBACK];
    int xmlOutputCallbackNr;
    int xmlOutputCallbackInitialized;
#endif /* LIBXML_OUTPUT_ENABLED */

#ifdef LIBXML_HTML_ENABLED
    /*HTML parser*/
    const char** htmlStartCloseIndex[100];
    int htmlStartCloseIndexinitialized;
#endif


    /* SAX: old SAX1, and others */
    xmlSAXLocator   xmlDefaultSAXLocator;
    xmlSAXHandlerV1 xmlDefaultSAXHandler;
    xmlSAXHandlerV1 docbDefaultSAXHandler;
    xmlSAXHandlerV1 htmlDefaultSAXHandler;

#ifdef LIBXML_XPTR_ENABLED
    xlinkHandlerPtr xlinkDefaultHandler;
    xlinkNodeDetectFunc xlinkDefaultDetect;
#endif /* LIBXML_XPTR_ENABLED */

#ifdef XMLENGINE_XMLSCHEMA_DATATYPES
    xmlSchemaTypesGlobalDataPtr xmlSchemaTypesGlobals;
    int xmlSchemaTypesInitialized;
#endif

#ifdef XMLENGINE_XSLT
#ifdef XSLT_PROFILING_ENABLED
    long g_calibration; // DONE: renamed from 'calibration'
#endif
    void*           xsltGlobalsCleanupFunc;
    xmlHashTablePtr xsltTopLevelsHash;
#ifdef XSLT_EXTENSION
    xmlHashTablePtr xsltExtensionsHash;
    xmlHashTablePtr xsltFunctionsHash;
    xmlHashTablePtr xsltElementsHash;
    //xsltFormatToken default_token;
#endif

#ifdef XSLT_DEBUG_CALLBACK
    xsltDebuggerCallbacks xsltDebuggerCurrentCallbacks;
#endif
#endif /*end of XMLENGINE_XSLT*/

#ifdef LIBXML_CATALOG_ENABLED
    int xmlDebugCatalogs;
    xmlCatalogAllow xmlCatalogDefaultAllow;
    xmlCatalogPrefer xmlCatalogDefaultPrefer;
    xmlHashTablePtr xmlCatalogXMLFiles;
    xmlCatalogPtr xmlDefaultCatalog;
//  xmlRMutexPtr xmlCatalogMutex;
    int xmlCatalogInitialized;
#endif

    /* xmlmemory */
    int xmlMemInitialized;
    unsigned long  debugMemSize;
    unsigned long  debugMaxMemSize;
//  xmlMutexPtr xmlMemMutex;
    unsigned int g_block;
    unsigned int xmlMemStopAtBlock;
    void *xmlMemTraceBlockAt;

#ifdef XMLENGINE_MEM_DEBUG
    int allocCount;
    int reallocCount;
    int deallocCount;
    int allocTotal;
    int deallocTotal;
    void* memSizeFunc;
    int allocMemSize;
    int allocMemSizeMax;
#endif

    int reserved;
}; // end of struct _xmlGlobalState

#ifdef XMLENGINE_MEM_DEBUG
typedef void (*MemSizeFunc)(void*, void*, void*);
#endif

#ifdef __cplusplus
}
#endif

#include <stdapis/libxml2/libxml2_threads.h>

#ifdef __cplusplus
extern "C" {
#endif
#ifndef UNDEF_IMPORT_C_IN_DATA
XMLPUBVAR const char* const xmlTreeIndentString;
XMLPUBVAR const char* const xmlParserVersion;
#endif

XMLPUBFUN void                  XMLCALL xmlInitializeGlobalState(xmlGlobalStatePtr gs);
XMLPUBFUN xmlRegisterNodeFunc   XMLCALL xmlRegisterNodeDefault  (xmlRegisterNodeFunc func);
XMLPUBFUN xmlDeregisterNodeFunc XMLCALL xmlDeregisterNodeDefault(xmlDeregisterNodeFunc func);

// NOTE: We can actually use fixed values for memory allocation routines!

// Boost the performance! This has saved 2 KB of the code and made it faster
#define xmlFree         free
#define xmlMalloc       malloc_impl
#define xmlMallocAtomic malloc_impl
#define xmlRealloc      realloc_impl
#define xmlMemStrdup(p) ((char*)xmlStrdup((const xmlChar*)(p)))

#define xmlLastError (XE_GS_PROXY_VAR->xmlLastError)
#define xmlBufferAllocScheme (XE_GS_PROXY_VAR->xmlBufferAllocScheme)
#define xmlDefaultBufferSize (XE_GS_PROXY_VAR->xmlDefaultBufferSize)

#ifdef LIBXML_SAX1_ENABLED
#define xmlDefaultSAXHandler (XE_GS_PROXY_VAR->xmlDefaultSAXHandler)
#endif /* LIBXML_SAX1_ENABLED */

#define xmlDefaultSAXLocator (XE_GS_PROXY_VAR->xmlDefaultSAXLocator)

#define xmlDoValidityCheckingDefaultValue (XE_GS_PROXY_VAR->xmlDoValidityCheckingDefaultValue)
#define xmlGenericError (xmlGetGlobalState()->xmlGenericError)
#define xmlStructuredError (XE_GS_PROXY_VAR->xmlStructuredError)
#define xmlGenericErrorContext (xmlGetGlobalState()->xmlGenericErrorContext)
#define xmlGetWarningsDefaultValue (XE_GS_PROXY_VAR->xmlGetWarningsDefaultValue)
#define xmlIndentTreeOutput (XE_GS_PROXY_VAR->xmlIndentTreeOutput)
#define xmlKeepBlanksDefaultValue (XE_GS_PROXY_VAR->xmlKeepBlanksDefaultValue)
#define xmlLineNumbersDefaultValue (XE_GS_PROXY_VAR->xmlLineNumbersDefaultValue)
#define xmlLoadExtDtdDefaultValue (XE_GS_PROXY_VAR->xmlLoadExtDtdDefaultValue)
#define xmlParserDebugEntities (XE_GS_PROXY_VAR->xmlParserDebugEntities)
#define xmlPedanticParserDefaultValue (XE_GS_PROXY_VAR->xmlPedanticParserDefaultValue)
#define xmlSaveNoEmptyTags (XE_GS_PROXY_VAR->xmlSaveNoEmptyTags)
#define xmlSubstituteEntitiesDefaultValue (XE_GS_PROXY_VAR->xmlSubstituteEntitiesDefaultValue)
#define xmlRegisterNodeDefaultValue (XE_GS_PROXY_VAR->xmlRegisterNodeDefaultValue)
#define xmlDeregisterNodeDefaultValue (XE_GS_PROXY_VAR->xmlDeregisterNodeDefaultValue)

/* Static Globals */
#define xmlLibraryLock NULL

#define had_info (XE_GS_PROXY_VAR->had_info)
#define xmlInputStreamId (XE_GS_PROXY_VAR->xmlInputStreamId)

#define xmlUTF16LEHandler (XE_GS_PROXY_VAR->xmlUTF16LEHandler)
#define xmlUTF16BEHandler (XE_GS_PROXY_VAR->xmlUTF16BEHandler)
#define xmlCharEncodingAliases (XE_GS_PROXY_VAR->xmlCharEncodingAliases)
#define xmlCharEncodingAliasesNb (XE_GS_PROXY_VAR->xmlCharEncodingAliasesNb)
#define xmlCharEncodingAliasesMax (XE_GS_PROXY_VAR->xmlCharEncodingAliasesMax)
#define xmlLittleEndian (XE_GS_PROXY_VAR->xmlLittleEndian)
#define handlers (XE_GS_PROXY_VAR->handlers)
#define nbCharEncodingHandler (XE_GS_PROXY_VAR->nbCharEncodingHandler)
#define xmlDefaultCharEncodingHandler (XE_GS_PROXY_VAR->xmlDefaultCharEncodingHandler)

#define xmlParserMaxDepth (XE_GS_PROXY_VAR->xmlParserMaxDepth)
#define xmlW3CPIs (XE_GS_PROXY_VAR->xmlW3CPIs)
#define xmlParserInitialized (XE_GS_PROXY_VAR->xmlParserInitialized)
#define xeStackLimit (XE_GS_PROXY_VAR->xeStackLimit)

#define xmlSAX2DefaultVersionValue (XE_GS_PROXY_VAR->xmlSAX2DefaultVersionValue)

#define xmlInputCallbackTable (XE_GS_PROXY_VAR->xmlInputCallbackTable)
#define xmlInputCallbackNr (XE_GS_PROXY_VAR->xmlInputCallbackNr)
#define xmlInputCallbackInitialized (XE_GS_PROXY_VAR->xmlInputCallbackInitialized)
#define xmlOutputCallbackTable (XE_GS_PROXY_VAR->xmlOutputCallbackTable)
#define xmlOutputCallbackNr (XE_GS_PROXY_VAR->xmlOutputCallbackNr)
#define xmlOutputCallbackInitialized (XE_GS_PROXY_VAR->xmlOutputCallbackInitialized)
#define xmlCurrentExternalEntityLoader (XE_GS_PROXY_VAR->xmlCurrentExternalEntityLoader)

#define xmlMemInitialized (XE_GS_PROXY_VAR->xmlMemInitialized)
#define debugMemSize (XE_GS_PROXY_VAR->debugMemSize)
#define debugMaxMemSize (XE_GS_PROXY_VAR->debugMaxMemSize)
#define xmlMemMutex NULL
#define g_block (XE_GS_PROXY_VAR->g_block)
#define xmlMemStopAtBlock (XE_GS_PROXY_VAR->xmlMemStopAtBlock)
#define xmlMemTraceBlockAt (XE_GS_PROXY_VAR->xmlMemTraceBlockAt)

#define __xmlRegisterCallbacks (XE_GS_PROXY_VAR->__xmlRegisterCallbacks)

#ifdef LIBXML_TREE_ENABLED
#   define xmlCompressMode (XE_GS_PROXY_VAR->xmlCompressMode)
#   define xmlCheckDTD (XE_GS_PROXY_VAR->xmlCheckDTD)
#endif

#ifdef LIBXML_CATALOG_ENABLED
#   define xmlDebugCatalogs (XE_GS_PROXY_VAR->xmlDebugCatalogs)
#   define  xmlCatalogDefaultAllow (XE_GS_PROXY_VAR->xmlCatalogDefaultAllow)
#   define xmlCatalogDefaultPrefer (XE_GS_PROXY_VAR->xmlCatalogDefaultPrefer)
#   define  xmlCatalogXMLFiles (XE_GS_PROXY_VAR->xmlCatalogXMLFiles)
#   define  xmlDefaultCatalog (XE_GS_PROXY_VAR->xmlDefaultCatalog)
#   define  xmlCatalogMutex NULL
#   define  xmlCatalogInitialized (XE_GS_PROXY_VAR->xmlCatalogInitialized)
#endif

#ifdef LIBXML_HTML_ENABLED
#   define htmlStartCloseIndex (XE_GS_PROXY_VAR->htmlStartCloseIndex)
#   define htmlStartCloseIndexinitialized (XE_GS_PROXY_VAR->htmlStartCloseIndexinitialized)
#   define htmlDefaultSAXHandler (XE_GS_PROXY_VAR->htmlDefaultSAXHandler)
#endif

#ifdef LIBXML_XPATH_ENABLED
#   define xmlXPathNAN (XE_GS_PROXY_VAR->xmlXPathNAN)
#   define xmlXPathPINF (XE_GS_PROXY_VAR->xmlXPathPINF)
#   define xmlXPathNINF (XE_GS_PROXY_VAR->xmlXPathNINF)
#   define xmlXPathNZERO (XE_GS_PROXY_VAR->xmlXPathNZERO)
#   define xmlXPathInitialized (XE_GS_PROXY_VAR->xmlXPathInitialized)
#   define xmlXPathDefineExtensionFunctionsGlobally (XE_GS_PROXY_VAR->xmlXPathDefineExtensionFunctionsGlobally)
#   define xmlXPathDefaultFunctionsHash (XE_GS_PROXY_VAR->xmlXPathDefaultFunctionsHash)
#   define xmlXPathIntermediaryExtensionFunctionsHash (XE_GS_PROXY_VAR->xmlXPathIntermediaryExtensionFunctionsHash)
#   ifndef LIBXML_THREAD_ENABLED
#       define xmlXPathDisableOptimizer (XE_GS_PROXY_VAR->xmlXPathDisableOptimizer)
#   endif
#endif

#ifdef LIBXML_XPTR_ENABLED
#   define xlinkDefaultHandler (XE_GS_PROXY_VAR->xlinkDefaultHandler)
#   define xlinkDefaultDetect (XE_GS_PROXY_VAR->xlinkDefaultDetect)
#endif

#define xsltGlobalsCleanupFunc (XE_GS_PROXY_VAR->xsltGlobalsCleanupFunc)

#define xmlOOM      (XE_GS_PROXY_VAR->xmlOOM)
#define xeUserCount (XE_GS_PROXY_VAR->xeUserCount)

#ifdef XMLENGINE_XMLSCHEMA_DATATYPES
#   define xmlSchemaTypesGlobals (XE_GS_PROXY_VAR->xmlSchemaTypesGlobals)
#   define xmlSchemaTypesInitialized (XE_GS_PROXY_VAR->xmlSchemaTypesInitialized)
#endif

#ifdef __cplusplus
}
#endif

#endif /* XML_GLOBALS_H */
