/*
 * Copyright (c) 2007-2010 Nokia Corporation and/or its subsidiary(-ies). 
 * All rights reserved.
 * This component and the accompanying materials are made available
 * under the terms of "Eclipse Public License v1.0"
 * which accompanies this distribution, and is available
 * at the URL "http://www.eclipse.org/legal/epl-v10.html".
 *
 * Initial Contributors:
 * Nokia Corporation - initial contribution.
 *
 * Contributors:
 *
 * Description:
 *
 * IDs for context sensitive help
 *
 */
package com.nokia.traceviewer;

/**
 * IDs for context sensitive help
 * 
 */
public class TraceViewerHelpContextIDs {

	/**
	 * The plug-in ID. Copied here to avoid runtime dependency to help project
	 */
	public static final String PROJECT_PLUGIN_ID = "com.nokia.traceviewer.help"; //$NON-NLS-1$

	/**
	 * Main view help context ID
	 */
	public static final String MAIN_VIEW = PROJECT_PLUGIN_ID
			+ ".TRACEVIEWER_HELP_MAIN_VIEW"; //$NON-NLS-1$

	/**
	 * Property view help context ID
	 */
	public static final String PROPERTY_VIEW = PROJECT_PLUGIN_ID
			+ ".TRACEVIEWER_HELP_PROPERTY_VIEW"; //$NON-NLS-1$

	/**
	 * Actions help context ID
	 */
	public static final String ACTIONS = PROJECT_PLUGIN_ID
			+ ".TRACEVIEWER_HELP_ACTIONS"; //$NON-NLS-1$

	/**
	 * General Preferences help context ID
	 */
	public static final String GENERAL_PREFERENCES = PROJECT_PLUGIN_ID
			+ ".TRACEVIEWER_HELP_GENERAL_PREFERENCES"; //$NON-NLS-1$

	/**
	 * Advanced Preferences help context ID
	 */
	public static final String ADVANCED_PREFERENCES = PROJECT_PLUGIN_ID
			+ ".TRACEVIEWER_HELP_ADVANCED_PREFERENCES"; //$NON-NLS-1$

	/**
	 * Connection Preferences help context ID
	 */
	public static final String CONNECTION_PREFERENCES = PROJECT_PLUGIN_ID
			+ ".TRACEVIEWER_HELP_CONNECTION_PREFERENCES"; //$NON-NLS-1$

	/**
	 * Plugins Preferences help context ID
	 */
	public static final String PLUGINS_PREFERENCES = PROJECT_PLUGIN_ID
			+ ".TRACEVIEWER_HELP_PLUGINS_PREFERENCES"; //$NON-NLS-1$

	/**
	 * Trace information dialog help context ID
	 */
	public static final String TRACE_INFO_DIALOG = PROJECT_PLUGIN_ID
			+ ".TRACEVIEWER_HELP_TRACE_INFO_DIALOG"; //$NON-NLS-1$

	/**
	 * Logging help context ID
	 */
	public static final String LOGGING = PROJECT_PLUGIN_ID
			+ ".TRACEVIEWER_HELP_LOGGING"; //$NON-NLS-1$

	/**
	 * Variable tracing history help context ID
	 */
	public static final String VARIABLE_TRACING_HISTORY = PROJECT_PLUGIN_ID
			+ ".TRACEVIEWER_HELP_VARIABLE_TRACING_HISTORY"; //$NON-NLS-1$

	/**
	 * Triggering help context ID
	 */
	public static final String TRIGGERING = PROJECT_PLUGIN_ID
			+ ".TRACEVIEWER_HELP_TRIGGERING"; //$NON-NLS-1$

	/**
	 * Searching help context ID
	 */
	public static final String SEARCHING = PROJECT_PLUGIN_ID
			+ ".TRACEVIEWER_HELP_SEARCHING"; //$NON-NLS-1$

	/**
	 * Activation configuration context ID
	 */
	public static final String ACTIVATION_CONFIGURATIONS = PROJECT_PLUGIN_ID
			+ ".TRACEVIEWER_HELP_ACTIVATION_CONFIGURATIONS"; //$NON-NLS-1$

	/**
	 * Activation dialog context ID
	 */
	public static final String ACTIVATION_DIALOG = PROJECT_PLUGIN_ID
			+ ".TRACEVIEWER_HELP_ACTIVATION_DIALOG"; //$NON-NLS-1$

}
