/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/

﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using SymbianUtils;
using SymbianUtils.Range;
using SymbianUtils.Tracer;
using SymbianStructuresLib.CodeSegments;
using SymbianStructuresLib.Debug.Symbols;
using SymbianDebugLib.Engine;
using SymbianDebugLib.Entity;
using SymbianDebugLib.PluginAPI;
using SymbianDebugLib.PluginAPI.Types;
using SymbianDebugLib.PluginAPI.Types.Symbols;


namespace SymbianSymbolLibTest
{
    class TSymLookupEntry
    {
        #region Constructors
        public TSymLookupEntry( uint aAddress, int aCount, string aSymbol, string aCollection )
        {
            iAddress = aAddress;
            iCount = aCount;
            iSymbol = aSymbol;
            iCollection = aCollection;
        }
        #endregion

        #region Constants
        public static readonly TSymLookupEntry[] KHeapSymbols = new TSymLookupEntry[]
            {
            new TSymLookupEntry( 0x00000000, 04068, "", "" ),
            new TSymLookupEntry( 0x00000001, 02667, "", "" ),
            new TSymLookupEntry( 0x00000002, 00602, "", "" ),
            new TSymLookupEntry( 0x00000003, 00134, "", "" ),
            new TSymLookupEntry( 0x00000004, 00095, "", "" ),
            new TSymLookupEntry( 0x00000005, 00043, "", "" ),
            new TSymLookupEntry( 0x00000006, 00028, "", "" ),
            new TSymLookupEntry( 0x00000007, 00048, "", "" ),
            new TSymLookupEntry( 0x00000008, 00029, "", "" ),
            new TSymLookupEntry( 0x00000009, 00036, "", "" ),
            new TSymLookupEntry( 0x0000000a, 00066, "", "" ),
            new TSymLookupEntry( 0x0000000b, 00019, "", "" ),
            new TSymLookupEntry( 0x0000000c, 00023, "", "" ),
            new TSymLookupEntry( 0x0000000d, 00015, "", "" ),
            new TSymLookupEntry( 0x0000000e, 00022, "", "" ),
            new TSymLookupEntry( 0x0000000f, 00300, "", "" ),
            new TSymLookupEntry( 0x00000010, 00011, "", "" ),
            new TSymLookupEntry( 0x00000011, 00008, "", "" ),
            new TSymLookupEntry( 0x00000012, 00013, "", "" ),
            new TSymLookupEntry( 0x00000013, 00012, "", "" ),
            new TSymLookupEntry( 0x00000014, 00008, "", "" ),
            new TSymLookupEntry( 0x00000015, 00009, "", "" ),
            new TSymLookupEntry( 0x00000016, 00013, "", "" ),
            new TSymLookupEntry( 0x00000017, 00021, "", "" ),
            new TSymLookupEntry( 0x00000018, 00010, "", "" ),
            new TSymLookupEntry( 0x00000019, 00008, "", "" ),
            new TSymLookupEntry( 0x0000001a, 00005, "", "" ),
            new TSymLookupEntry( 0x0000001b, 00011, "", "" ),
            new TSymLookupEntry( 0x0000001c, 00015, "", "" ),
            new TSymLookupEntry( 0x0000001d, 00011, "", "" ),
            new TSymLookupEntry( 0x0000001e, 00011, "", "" ),
            new TSymLookupEntry( 0x0000001f, 00038, "", "" ),
            new TSymLookupEntry( 0x00000020, 00024, "", "" ),
            new TSymLookupEntry( 0x00000021, 00011, "", "" ),
            new TSymLookupEntry( 0x00000022, 00015, "", "" ),
            new TSymLookupEntry( 0x00000023, 00009, "", "" ),
            new TSymLookupEntry( 0x00000024, 00005, "", "" ),
            new TSymLookupEntry( 0x00000025, 00004, "", "" ),
            new TSymLookupEntry( 0x00000026, 00008, "", "" ),
            new TSymLookupEntry( 0x00000027, 00009, "", "" ),
            new TSymLookupEntry( 0x00000028, 00008, "", "" ),
            new TSymLookupEntry( 0x00000029, 00013, "", "" ),
            new TSymLookupEntry( 0x0000002a, 00013, "", "" ),
            new TSymLookupEntry( 0x0000002b, 00010, "", "" ),
            new TSymLookupEntry( 0x0000002c, 00019, "", "" ),
            new TSymLookupEntry( 0x0000002d, 00005, "", "" ),
            new TSymLookupEntry( 0x0000002e, 00011, "", "" ),
            new TSymLookupEntry( 0x0000002f, 00020, "", "" ),
            new TSymLookupEntry( 0x00000030, 00007, "", "" ),
            new TSymLookupEntry( 0x00000031, 00009, "", "" ),
            new TSymLookupEntry( 0x00000032, 00003, "", "" ),
            new TSymLookupEntry( 0x00000033, 00019, "", "" ),
            new TSymLookupEntry( 0x00000034, 00004, "", "" ),
            new TSymLookupEntry( 0x00000035, 00003, "", "" ),
            new TSymLookupEntry( 0x00000036, 00006, "", "" ),
            new TSymLookupEntry( 0x00000037, 00006, "", "" ),
            new TSymLookupEntry( 0x00000038, 00005, "", "" ),
            new TSymLookupEntry( 0x00000039, 00003, "", "" ),
            new TSymLookupEntry( 0x0000003a, 00006, "", "" ),
            new TSymLookupEntry( 0x0000003b, 00003, "", "" ),
            new TSymLookupEntry( 0x0000003c, 00003, "", "" ),
            new TSymLookupEntry( 0x0000003d, 00010, "", "" ),
            new TSymLookupEntry( 0x0000003e, 00005, "", "" ),
            new TSymLookupEntry( 0x0000003f, 00008, "", "" ),
            new TSymLookupEntry( 0x00000040, 00004, "", "" ),
            new TSymLookupEntry( 0x00000041, 00005, "", "" ),
            new TSymLookupEntry( 0x00000042, 00003, "", "" ),
            new TSymLookupEntry( 0x00000043, 00004, "", "" ),
            new TSymLookupEntry( 0x00000044, 00003, "", "" ),
            new TSymLookupEntry( 0x00000045, 00003, "", "" ),
            new TSymLookupEntry( 0x00000046, 00004, "", "" ),
            new TSymLookupEntry( 0x00000047, 00005, "", "" ),
            new TSymLookupEntry( 0x00000048, 00004, "", "" ),
            new TSymLookupEntry( 0x00000049, 00003, "", "" ),
            new TSymLookupEntry( 0x0000004a, 00003, "", "" ),
            new TSymLookupEntry( 0x0000004b, 00003, "", "" ),
            new TSymLookupEntry( 0x0000004c, 00003, "", "" ),
            new TSymLookupEntry( 0x0000004d, 00003, "", "" ),
            new TSymLookupEntry( 0x0000004e, 00003, "", "" ),
            new TSymLookupEntry( 0x0000004f, 00003, "", "" ),
            new TSymLookupEntry( 0x00000050, 00005, "", "" ),
            new TSymLookupEntry( 0x00000051, 00003, "", "" ),
            new TSymLookupEntry( 0x00000052, 00019, "", "" ),
            new TSymLookupEntry( 0x00000053, 00003, "", "" ),
            new TSymLookupEntry( 0x00000054, 00006, "", "" ),
            new TSymLookupEntry( 0x00000055, 00003, "", "" ),
            new TSymLookupEntry( 0x00000056, 00003, "", "" ),
            new TSymLookupEntry( 0x00000057, 00004, "", "" ),
            new TSymLookupEntry( 0x00000058, 00003, "", "" ),
            new TSymLookupEntry( 0x00000059, 00003, "", "" ),
            new TSymLookupEntry( 0x0000005a, 00004, "", "" ),
            new TSymLookupEntry( 0x0000005b, 00003, "", "" ),
            new TSymLookupEntry( 0x0000005c, 00003, "", "" ),
            new TSymLookupEntry( 0x0000005d, 00003, "", "" ),
            new TSymLookupEntry( 0x0000005e, 00003, "", "" ),
            new TSymLookupEntry( 0x0000005f, 00003, "", "" ),
            new TSymLookupEntry( 0x00000060, 00003, "", "" ),
            new TSymLookupEntry( 0x00000061, 00005, "", "" ),
            new TSymLookupEntry( 0x00000062, 00003, "", "" ),
            new TSymLookupEntry( 0x00000063, 00005, "", "" ),
            new TSymLookupEntry( 0x00000064, 00003, "", "" ),
            new TSymLookupEntry( 0x00000065, 00005, "", "" ),
            new TSymLookupEntry( 0x00000066, 00004, "", "" ),
            new TSymLookupEntry( 0x00000067, 00008, "", "" ),
            new TSymLookupEntry( 0x00000068, 00003, "", "" ),
            new TSymLookupEntry( 0x00000069, 00015, "", "" ),
            new TSymLookupEntry( 0x0000006a, 00005, "", "" ),
            new TSymLookupEntry( 0x0000006b, 00003, "", "" ),
            new TSymLookupEntry( 0x0000006c, 00005, "", "" ),
            new TSymLookupEntry( 0x0000006d, 00004, "", "" ),
            new TSymLookupEntry( 0x0000006e, 00005, "", "" ),
            new TSymLookupEntry( 0x0000006f, 00004, "", "" ),
            new TSymLookupEntry( 0x00000070, 00005, "", "" ),
            new TSymLookupEntry( 0x00000071, 00006, "", "" ),
            new TSymLookupEntry( 0x00000072, 00005, "", "" ),
            new TSymLookupEntry( 0x00000073, 00005, "", "" ),
            new TSymLookupEntry( 0x00000074, 00004, "", "" ),
            new TSymLookupEntry( 0x00000075, 00004, "", "" ),
            new TSymLookupEntry( 0x00000076, 00003, "", "" ),
            new TSymLookupEntry( 0x00000077, 00003, "", "" ),
            new TSymLookupEntry( 0x00000078, 00004, "", "" ),
            new TSymLookupEntry( 0x00000079, 00004, "", "" ),
            new TSymLookupEntry( 0x0000007a, 00004, "", "" ),
            new TSymLookupEntry( 0x0000007b, 00003, "", "" ),
            new TSymLookupEntry( 0x0000007c, 00003, "", "" ),
            new TSymLookupEntry( 0x0000007d, 00003, "", "" ),
            new TSymLookupEntry( 0x0000007e, 00006, "", "" ),
            new TSymLookupEntry( 0x0000007f, 00007, "", "" ),
            new TSymLookupEntry( 0x00000080, 00005, "", "" ),
            new TSymLookupEntry( 0x00000081, 00003, "", "" ),
            new TSymLookupEntry( 0x00000082, 00004, "", "" ),
            new TSymLookupEntry( 0x00000083, 00003, "", "" ),
            new TSymLookupEntry( 0x00000084, 00003, "", "" ),
            new TSymLookupEntry( 0x00000085, 00003, "", "" ),
            new TSymLookupEntry( 0x00000086, 00003, "", "" ),
            new TSymLookupEntry( 0x00000087, 00003, "", "" ),
            new TSymLookupEntry( 0x00000088, 00003, "", "" ),
            new TSymLookupEntry( 0x00000089, 00004, "", "" ),
            new TSymLookupEntry( 0x0000008a, 00003, "", "" ),
            new TSymLookupEntry( 0x0000008b, 00003, "", "" ),
            new TSymLookupEntry( 0x0000008c, 00003, "", "" ),
            new TSymLookupEntry( 0x0000008d, 00003, "", "" ),
            new TSymLookupEntry( 0x0000008e, 00003, "", "" ),
            new TSymLookupEntry( 0x0000008f, 00003, "", "" ),
            new TSymLookupEntry( 0x00000090, 00002, "", "" ),
            new TSymLookupEntry( 0x00000091, 00002, "", "" ),
            new TSymLookupEntry( 0x00000092, 00002, "", "" ),
            new TSymLookupEntry( 0x00000093, 00002, "", "" ),
            new TSymLookupEntry( 0x00000094, 00002, "", "" ),
            new TSymLookupEntry( 0x00000095, 00002, "", "" ),
            new TSymLookupEntry( 0x00000096, 00002, "", "" ),
            new TSymLookupEntry( 0x00000097, 00002, "", "" ),
            new TSymLookupEntry( 0x00000098, 00003, "", "" ),
            new TSymLookupEntry( 0x00000099, 00002, "", "" ),
            new TSymLookupEntry( 0x0000009a, 00002, "", "" ),
            new TSymLookupEntry( 0x0000009b, 00002, "", "" ),
            new TSymLookupEntry( 0x0000009c, 00003, "", "" ),
            new TSymLookupEntry( 0x0000009d, 00002, "", "" ),
            new TSymLookupEntry( 0x0000009e, 00002, "", "" ),
            new TSymLookupEntry( 0x0000009f, 00002, "", "" ),
            new TSymLookupEntry( 0x000000a0, 00005, "", "" ),
            new TSymLookupEntry( 0x000000a1, 00002, "", "" ),
            new TSymLookupEntry( 0x000000a2, 00002, "", "" ),
            new TSymLookupEntry( 0x000000a3, 00002, "", "" ),
            new TSymLookupEntry( 0x000000a4, 00002, "", "" ),
            new TSymLookupEntry( 0x000000a5, 00002, "", "" ),
            new TSymLookupEntry( 0x000000a6, 00002, "", "" ),
            new TSymLookupEntry( 0x000000a7, 00002, "", "" ),
            new TSymLookupEntry( 0x000000a8, 00002, "", "" ),
            new TSymLookupEntry( 0x000000a9, 00002, "", "" ),
            new TSymLookupEntry( 0x000000aa, 00002, "", "" ),
            new TSymLookupEntry( 0x000000ab, 00003, "", "" ),
            new TSymLookupEntry( 0x000000ac, 00002, "", "" ),
            new TSymLookupEntry( 0x000000ad, 00002, "", "" ),
            new TSymLookupEntry( 0x000000ae, 00002, "", "" ),
            new TSymLookupEntry( 0x000000af, 00003, "", "" ),
            new TSymLookupEntry( 0x000000b0, 00002, "", "" ),
            new TSymLookupEntry( 0x000000b1, 00002, "", "" ),
            new TSymLookupEntry( 0x000000b2, 00002, "", "" ),
            new TSymLookupEntry( 0x000000b3, 00002, "", "" ),
            new TSymLookupEntry( 0x000000b4, 00002, "", "" ),
            new TSymLookupEntry( 0x000000b5, 00002, "", "" ),
            new TSymLookupEntry( 0x000000b6, 00002, "", "" ),
            new TSymLookupEntry( 0x000000b7, 00003, "", "" ),
            new TSymLookupEntry( 0x000000b8, 00003, "", "" ),
            new TSymLookupEntry( 0x000000b9, 00002, "", "" ),
            new TSymLookupEntry( 0x000000ba, 00002, "", "" ),
            new TSymLookupEntry( 0x000000bb, 00002, "", "" ),
            new TSymLookupEntry( 0x000000bc, 00002, "", "" ),
            new TSymLookupEntry( 0x000000bd, 00002, "", "" ),
            new TSymLookupEntry( 0x000000be, 00002, "", "" ),
            new TSymLookupEntry( 0x000000bf, 00002, "", "" ),
            new TSymLookupEntry( 0x000000c0, 00002, "", "" ),
            new TSymLookupEntry( 0x000000c1, 00002, "", "" ),
            new TSymLookupEntry( 0x000000c7, 00001, "", "" ),
            new TSymLookupEntry( 0x000000c9, 00001, "", "" ),
            new TSymLookupEntry( 0x000000ff, 00002, "", "" ),
            new TSymLookupEntry( 0x00000100, 00014, "", "" ),
            new TSymLookupEntry( 0x00000104, 00057, "", "" ),
            new TSymLookupEntry( 0x0000012a, 00002, "", "" ),
            new TSymLookupEntry( 0x0000014c, 00001, "", "" ),
            new TSymLookupEntry( 0x0000015a, 00002, "", "" ),
            new TSymLookupEntry( 0x00000160, 00001, "", "" ),
            new TSymLookupEntry( 0x00000176, 00001, "", "" ),
            new TSymLookupEntry( 0x000001b8, 00001, "", "" ),
            new TSymLookupEntry( 0x00000200, 00001, "", "" ),
            new TSymLookupEntry( 0x00000209, 00001, "", "" ),
            new TSymLookupEntry( 0x00000213, 00001, "", "" ),
            new TSymLookupEntry( 0x0000023b, 00001, "", "" ),
            new TSymLookupEntry( 0x00000256, 00001, "", "" ),
            new TSymLookupEntry( 0x0000025a, 00001, "", "" ),
            new TSymLookupEntry( 0x00000286, 00001, "", "" ),
            new TSymLookupEntry( 0x00000378, 00001, "", "" ),
            new TSymLookupEntry( 0x00000bb8, 00001, "", "" ),
            new TSymLookupEntry( 0x00000bb9, 00001, "", "" ),
            new TSymLookupEntry( 0x00004030, 00001, "", "" ),
            new TSymLookupEntry( 0x00004038, 00001, "", "" ),
            new TSymLookupEntry( 0x00004106, 00002, "", "" ),
            new TSymLookupEntry( 0x00004428, 00001, "", "" ),
            new TSymLookupEntry( 0x0000442a, 00001, "", "" ),
            new TSymLookupEntry( 0x0000442c, 00001, "", "" ),
            new TSymLookupEntry( 0x0000442e, 00001, "", "" ),
            new TSymLookupEntry( 0x000044ee, 00001, "", "" ),
            new TSymLookupEntry( 0x00010000, 00012, "", "" ),
            new TSymLookupEntry( 0x00010001, 00013, "", "" ),
            new TSymLookupEntry( 0x00010002, 00006, "", "" ),
            new TSymLookupEntry( 0x00010003, 00003, "", "" ),
            new TSymLookupEntry( 0x0001ffff, 00007, "", "" ),
            new TSymLookupEntry( 0x00020003, 00001, "", "" ),
            new TSymLookupEntry( 0x00030002, 00002, "", "" ),
            new TSymLookupEntry( 0x00038002, 00016, "", "" ),
            new TSymLookupEntry( 0x00060005, 00001, "", "" ),
            new TSymLookupEntry( 0x00088001, 00001, "", "" ),
            new TSymLookupEntry( 0x00090008, 00001, "", "" ),
            new TSymLookupEntry( 0x0009000a, 00023, "", "" ),
            new TSymLookupEntry( 0x000a0009, 00001, "", "" ),
            new TSymLookupEntry( 0x000a000a, 00020, "", "" ),
            new TSymLookupEntry( 0x000a003a, 00002, "", "" ),
            new TSymLookupEntry( 0x000b000a, 00001, "", "" ),
            new TSymLookupEntry( 0x000c000b, 00001, "", "" ),
            new TSymLookupEntry( 0x000d000c, 00001, "", "" ),
            new TSymLookupEntry( 0x000e000d, 00001, "", "" ),
            new TSymLookupEntry( 0x000f000e, 00001, "", "" ),
            new TSymLookupEntry( 0x0010000f, 00001, "", "" ),
            new TSymLookupEntry( 0x00100023, 00001, "", "" ),
            new TSymLookupEntry( 0x00100027, 00001, "", "" ),
            new TSymLookupEntry( 0x00110010, 00001, "", "" ),
            new TSymLookupEntry( 0x00116bba, 00001, "", "" ),
            new TSymLookupEntry( 0x00120011, 00001, "", "" ),
            new TSymLookupEntry( 0x00130012, 00001, "", "" ),
            new TSymLookupEntry( 0x00140013, 00001, "", "" ),
            new TSymLookupEntry( 0x00160015, 00001, "", "" ),
            new TSymLookupEntry( 0x00170016, 00002, "", "" ),
            new TSymLookupEntry( 0x00190018, 00001, "", "" ),
            new TSymLookupEntry( 0x001a0019, 00001, "", "" ),
            new TSymLookupEntry( 0x0020000a, 00129, "", "" ),
            new TSymLookupEntry( 0x00200022, 00003, "", "" ),
            new TSymLookupEntry( 0x0020002c, 00001, "", "" ),
            new TSymLookupEntry( 0x00200030, 00001, "", "" ),
            new TSymLookupEntry( 0x00200031, 00009, "", "" ),
            new TSymLookupEntry( 0x00200033, 00004, "", "" ),
            new TSymLookupEntry( 0x00200034, 00008, "", "" ),
            new TSymLookupEntry( 0x00200035, 00009, "", "" ),
            new TSymLookupEntry( 0x00200036, 00004, "", "" ),
            new TSymLookupEntry( 0x00200037, 00002, "", "" ),
            new TSymLookupEntry( 0x00200039, 00002, "", "" ),
            new TSymLookupEntry( 0x00200049, 00004, "", "" ),
            new TSymLookupEntry( 0x00200050, 00002, "", "" ),
            new TSymLookupEntry( 0x0020005d, 00001, "", "" ),
            new TSymLookupEntry( 0x002000bb, 00002, "", "" ),
            new TSymLookupEntry( 0x0024002d, 00001, "", "" ),
            new TSymLookupEntry( 0x0024005f, 00001, "", "" ),
            new TSymLookupEntry( 0x0025001d, 00001, "", "" ),
            new TSymLookupEntry( 0x0026001e, 00001, "", "" ),
            new TSymLookupEntry( 0x0028002d, 00001, "", "" ),
            new TSymLookupEntry( 0x0028005e, 00013, "", "" ),
            new TSymLookupEntry( 0x00290027, 00003, "", "" ),
            new TSymLookupEntry( 0x0029002a, 00001, "", "" ),
            new TSymLookupEntry( 0x0029002b, 00004, "", "" ),
            new TSymLookupEntry( 0x002a003e, 00001, "", "" ),
            new TSymLookupEntry( 0x002b002e, 00001, "", "" ),
            new TSymLookupEntry( 0x002c0027, 00002, "", "" ),
            new TSymLookupEntry( 0x002d0020, 00027, "", "" ),
            new TSymLookupEntry( 0x002d0028, 00001, "", "" ),
            new TSymLookupEntry( 0x002d0058, 00002, "", "" ),
            new TSymLookupEntry( 0x002d005c, 00001, "", "" ),
            new TSymLookupEntry( 0x002d007a, 00001, "", "" ),
            new TSymLookupEntry( 0x002e002e, 00002, "", "" ),
            new TSymLookupEntry( 0x002e0031, 00003, "", "" ),
            new TSymLookupEntry( 0x002e005e, 00001, "", "" ),
            new TSymLookupEntry( 0x002f0020, 00001, "", "" ),
            new TSymLookupEntry( 0x002f002a, 00001, "", "" ),
            new TSymLookupEntry( 0x002f002d, 00001, "", "" ),
            new TSymLookupEntry( 0x002f003c, 00099, "", "" ),
            new TSymLookupEntry( 0x00300024, 00001, "", "" ),
            new TSymLookupEntry( 0x00300030, 00001, "", "" ),
            new TSymLookupEntry( 0x00300031, 00001, "", "" ),
            new TSymLookupEntry( 0x00300032, 00021, "", "" ),
            new TSymLookupEntry( 0x00300033, 00001, "", "" ),
            new TSymLookupEntry( 0x00300035, 00001, "", "" ),
            new TSymLookupEntry( 0x00310024, 00004, "", "" ),
            new TSymLookupEntry( 0x00310030, 00002, "", "" ),
            new TSymLookupEntry( 0x00310059, 00001, "", "" ),
            new TSymLookupEntry( 0x0031005b, 00001, "", "" ),
            new TSymLookupEntry( 0x00310063, 00001, "", "" ),
            new TSymLookupEntry( 0x00310068, 00001, "", "" ),
            new TSymLookupEntry( 0x00320024, 00001, "", "" ),
            new TSymLookupEntry( 0x00320025, 00006, "", "" ),
            new TSymLookupEntry( 0x00320031, 00003, "", "" ),
            new TSymLookupEntry( 0x00320033, 00001, "", "" ),
            new TSymLookupEntry( 0x00320063, 00001, "", "" ),
            new TSymLookupEntry( 0x00320068, 00001, "", "" ),
            new TSymLookupEntry( 0x00330063, 00001, "", "" ),
            new TSymLookupEntry( 0x00330068, 00001, "", "" ),
            new TSymLookupEntry( 0x00340031, 00003, "", "" ),
            new TSymLookupEntry( 0x00340063, 00001, "", "" ),
            new TSymLookupEntry( 0x00340068, 00001, "", "" ),
            new TSymLookupEntry( 0x00350031, 00002, "", "" ),
            new TSymLookupEntry( 0x00350032, 00001, "", "" ),
            new TSymLookupEntry( 0x00350068, 00001, "", "" ),
            new TSymLookupEntry( 0x00360053, 00001, "", "" ),
            new TSymLookupEntry( 0x00360062, 00003, "", "" ),
            new TSymLookupEntry( 0x00360068, 00001, "", "" ),
            new TSymLookupEntry( 0x00380054, 00001, "", "" ),
            new TSymLookupEntry( 0x00390035, 00002, "", "" ),
            new TSymLookupEntry( 0x00390061, 00001, "", "" ),
            new TSymLookupEntry( 0x003a0063, 00004, "", "" ),
            new TSymLookupEntry( 0x003b0029, 00002, "", "" ),
            new TSymLookupEntry( 0x003c0028, 00001, "", "" ),
            new TSymLookupEntry( 0x003c003e, 00001, "", "" ),
            new TSymLookupEntry( 0x003c005e, 00001, "", "" ),
            new TSymLookupEntry( 0x003d0021, 00001, "", "" ),
            new TSymLookupEntry( 0x003d0024, 00001, "", "" ),
            new TSymLookupEntry( 0x003d002a, 00001, "", "" ),
            new TSymLookupEntry( 0x003d002d, 00001, "", "" ),
            new TSymLookupEntry( 0x003d003d, 00001, "", "" ),
            new TSymLookupEntry( 0x003d005e, 00001, "", "" ),
            new TSymLookupEntry( 0x003d005f, 00001, "", "" ),
            new TSymLookupEntry( 0x003d007e, 00001, "", "" ),
            new TSymLookupEntry( 0x003e0022, 00001, "", "" ),
            new TSymLookupEntry( 0x003e005e, 00002, "", "" ),
            new TSymLookupEntry( 0x003f0028, 00002, "", "" ),
            new TSymLookupEntry( 0x003f003d, 00002, "", "" ),
            new TSymLookupEntry( 0x003f005c, 00003, "", "" ),
            new TSymLookupEntry( 0x00400020, 00015, "", "" ),
            new TSymLookupEntry( 0x0040005b, 00001, "", "" ),
            new TSymLookupEntry( 0x0041004d, 00001, "", "" ),
            new TSymLookupEntry( 0x00420022, 00003, "", "" ),
            new TSymLookupEntry( 0x00420041, 00002, "", "" ),
            new TSymLookupEntry( 0x00420042, 00001, "", "" ),
            new TSymLookupEntry( 0x0043003c, 00001, "", "" ),
            new TSymLookupEntry( 0x00440041, 00002, "", "" ),
            new TSymLookupEntry( 0x0044005c, 00001, "", "" ),
            new TSymLookupEntry( 0x00450047, 00012, "", "" ),
            new TSymLookupEntry( 0x00460049, 00001, "", "" ),
            new TSymLookupEntry( 0x00490050, 00001, "", "" ),
            new TSymLookupEntry( 0x00490054, 00001, "", "" ),
            new TSymLookupEntry( 0x004b004f, 00016, "", "" ),
            new TSymLookupEntry( 0x004d0058, 00003, "", "" ),
            new TSymLookupEntry( 0x004f0044, 00012, "", "" ),
            new TSymLookupEntry( 0x004f004e, 00003, "", "" ),
            new TSymLookupEntry( 0x004f0050, 00002, "", "" ),
            new TSymLookupEntry( 0x00510066, 00001, "", "" ),
            new TSymLookupEntry( 0x0051006a, 00003, "", "" ),
            new TSymLookupEntry( 0x00520047, 00002, "", "" ),
            new TSymLookupEntry( 0x00520055, 00002, "", "" ),
            new TSymLookupEntry( 0x00520063, 00001, "", "" ),
            new TSymLookupEntry( 0x00530043, 00002, "", "" ),
            new TSymLookupEntry( 0x00530049, 00002, "", "" ),
            new TSymLookupEntry( 0x0053004a, 00001, "", "" ),
            new TSymLookupEntry( 0x00540055, 00001, "", "" ),
            new TSymLookupEntry( 0x005b0028, 00001, "", "" ),
            new TSymLookupEntry( 0x005b005b, 00024, "", "" ),
            new TSymLookupEntry( 0x005b005e, 00003, "", "" ),
            new TSymLookupEntry( 0x005c0028, 00002, "", "" ),
            new TSymLookupEntry( 0x005c003d, 00001, "", "" ),
            new TSymLookupEntry( 0x005c005c, 00002, "", "" ),
            new TSymLookupEntry( 0x005c005e, 00007, "", "" ),
            new TSymLookupEntry( 0x005c0068, 00001, "", "" ),
            new TSymLookupEntry( 0x005d0022, 00001, "", "" ),
            new TSymLookupEntry( 0x005e005b, 00001, "", "" ),
            new TSymLookupEntry( 0x005f005f, 00005, "", "" ),
            new TSymLookupEntry( 0x006001d0, 00001, "", "" ),
            new TSymLookupEntry( 0x00600284, 00001, "", "" ),
            new TSymLookupEntry( 0x00600800, 00001, "", "" ),
            new TSymLookupEntry( 0x00600bb0, 00001, "", "" ),
            new TSymLookupEntry( 0x00600c78, 00001, "", "" ),
            new TSymLookupEntry( 0x00600fc8, 00001, "", "" ),
            new TSymLookupEntry( 0x006010a8, 00001, "", "" ),
            new TSymLookupEntry( 0x006010f8, 00001, "", "" ),
            new TSymLookupEntry( 0x00601604, 00001, "", "" ),
            new TSymLookupEntry( 0x0060195c, 00001, "", "" ),
            new TSymLookupEntry( 0x00601a30, 00001, "", "" ),
            new TSymLookupEntry( 0x00601ec8, 00001, "", "" ),
            new TSymLookupEntry( 0x00602140, 00001, "", "" ),
            new TSymLookupEntry( 0x00602168, 00001, "", "" ),
            new TSymLookupEntry( 0x006021f0, 00001, "", "" ),
            new TSymLookupEntry( 0x00602510, 00001, "", "" ),
            new TSymLookupEntry( 0x00602548, 00001, "", "" ),
            new TSymLookupEntry( 0x00602668, 00001, "", "" ),
            new TSymLookupEntry( 0x00602690, 00001, "", "" ),
            new TSymLookupEntry( 0x00602740, 00001, "", "" ),
            new TSymLookupEntry( 0x006027d8, 00001, "", "" ),
            new TSymLookupEntry( 0x00602978, 00001, "", "" ),
            new TSymLookupEntry( 0x00602a00, 00001, "", "" ),
            new TSymLookupEntry( 0x00602b60, 00001, "", "" ),
            new TSymLookupEntry( 0x00602be8, 00001, "", "" ),
            new TSymLookupEntry( 0x00602c70, 00001, "", "" ),
            new TSymLookupEntry( 0x00602cf8, 00001, "", "" ),
            new TSymLookupEntry( 0x00602d80, 00001, "", "" ),
            new TSymLookupEntry( 0x00602e90, 00001, "", "" ),
            new TSymLookupEntry( 0x00602f0c, 00001, "", "" ),
            new TSymLookupEntry( 0x0060368c, 00001, "", "" ),
            new TSymLookupEntry( 0x006036f4, 00001, "", "" ),
            new TSymLookupEntry( 0x006039f8, 00001, "", "" ),
            new TSymLookupEntry( 0x00603ce0, 00001, "", "" ),
            new TSymLookupEntry( 0x00603dbc, 00001, "", "" ),
            new TSymLookupEntry( 0x00603df4, 00001, "", "" ),
            new TSymLookupEntry( 0x00603fdc, 00001, "", "" ),
            new TSymLookupEntry( 0x00604140, 00001, "", "" ),
            new TSymLookupEntry( 0x006044c8, 00001, "", "" ),
            new TSymLookupEntry( 0x00604cbc, 00001, "", "" ),
            new TSymLookupEntry( 0x0060539c, 00001, "", "" ),
            new TSymLookupEntry( 0x00605ba8, 00002, "", "" ),
            new TSymLookupEntry( 0x006060b0, 00001, "", "" ),
            new TSymLookupEntry( 0x00606218, 00001, "", "" ),
            new TSymLookupEntry( 0x00606308, 00001, "", "" ),
            new TSymLookupEntry( 0x00606808, 00001, "", "" ),
            new TSymLookupEntry( 0x00606980, 00001, "", "" ),
            new TSymLookupEntry( 0x00606a08, 00002, "", "" ),
            new TSymLookupEntry( 0x00606aa0, 00001, "", "" ),
            new TSymLookupEntry( 0x00607260, 00005, "", "" ),
            new TSymLookupEntry( 0x006074f0, 00001, "", "" ),
            new TSymLookupEntry( 0x00607788, 00001, "", "" ),
            new TSymLookupEntry( 0x00607850, 00001, "", "" ),
            new TSymLookupEntry( 0x00607a00, 00001, "", "" ),
            new TSymLookupEntry( 0x00607ac8, 00001, "", "" ),
            new TSymLookupEntry( 0x00607b30, 00001, "", "" ),
            new TSymLookupEntry( 0x006080a0, 00001, "", "" ),
            new TSymLookupEntry( 0x00608138, 00001, "", "" ),
            new TSymLookupEntry( 0x00608610, 00001, "", "" ),
            new TSymLookupEntry( 0x00608758, 00001, "", "" ),
            new TSymLookupEntry( 0x00608f70, 00001, "", "" ),
            new TSymLookupEntry( 0x00609080, 00001, "", "" ),
            new TSymLookupEntry( 0x00609178, 00001, "", "" ),
            new TSymLookupEntry( 0x006092b0, 00006, "", "" ),
            new TSymLookupEntry( 0x0060c0ec, 00001, "", "" ),
            new TSymLookupEntry( 0x0060c1b0, 00002, "", "" ),
            new TSymLookupEntry( 0x0060c1e8, 00001, "", "" ),
            new TSymLookupEntry( 0x0060c468, 00001, "", "" ),
            new TSymLookupEntry( 0x0060cb78, 00001, "", "" ),
            new TSymLookupEntry( 0x0060ce48, 00001, "", "" ),
            new TSymLookupEntry( 0x0060d290, 00001, "", "" ),
            new TSymLookupEntry( 0x0060d538, 00001, "", "" ),
            new TSymLookupEntry( 0x0060d980, 00001, "", "" ),
            new TSymLookupEntry( 0x0060dcd8, 00001, "", "" ),
            new TSymLookupEntry( 0x0060df88, 00001, "", "" ),
            new TSymLookupEntry( 0x0060dfc8, 00001, "", "" ),
            new TSymLookupEntry( 0x0060e030, 00001, "", "" ),
            new TSymLookupEntry( 0x0060e3cc, 00001, "", "" ),
            new TSymLookupEntry( 0x0060ee98, 00001, "", "" ),
            new TSymLookupEntry( 0x0060f038, 00001, "", "" ),
            new TSymLookupEntry( 0x0060f0b0, 00002, "", "" ),
            new TSymLookupEntry( 0x0060f178, 00001, "", "" ),
            new TSymLookupEntry( 0x0060f268, 00002, "", "" ),
            new TSymLookupEntry( 0x0060f63c, 00001, "", "" ),
            new TSymLookupEntry( 0x0060f6b0, 00001, "", "" ),
            new TSymLookupEntry( 0x0060f70c, 00001, "", "" ),
            new TSymLookupEntry( 0x0060f778, 00001, "", "" ),
            new TSymLookupEntry( 0x0060f868, 00002, "", "" ),
            new TSymLookupEntry( 0x0060fa30, 00001, "", "" ),
            new TSymLookupEntry( 0x0060fc10, 00001, "", "" ),
            new TSymLookupEntry( 0x0060fde0, 00001, "", "" ),
            new TSymLookupEntry( 0x00610020, 00001, "", "" ),
            new TSymLookupEntry( 0x00610026, 00001, "", "" ),
            new TSymLookupEntry( 0x0061003c, 00002, "", "" ),
            new TSymLookupEntry( 0x00610043, 00003, "", "" ),
            new TSymLookupEntry( 0x00610044, 00002, "", "" ),
            new TSymLookupEntry( 0x0061004a, 00003, "", "" ),
            new TSymLookupEntry( 0x0061004c, 00004, "", "" ),
            new TSymLookupEntry( 0x0061004d, 00008, "", "" ),
            new TSymLookupEntry( 0x0061004e, 00003, "", "" ),
            new TSymLookupEntry( 0x00610050, 00001, "", "" ),
            new TSymLookupEntry( 0x00610052, 00003, "", "" ),
            new TSymLookupEntry( 0x00610053, 00006, "", "" ),
            new TSymLookupEntry( 0x00610054, 00001, "", "" ),
            new TSymLookupEntry( 0x00610061, 00002, "", "" ),
            new TSymLookupEntry( 0x00610062, 00013, "", "" ),
            new TSymLookupEntry( 0x00610063, 00011, "", "" ),
            new TSymLookupEntry( 0x00610064, 00009, "", "" ),
            new TSymLookupEntry( 0x00610065, 00004, "", "" ),
            new TSymLookupEntry( 0x00610066, 00008, "", "" ),
            new TSymLookupEntry( 0x00610067, 00001, "", "" ),
            new TSymLookupEntry( 0x00610068, 00016, "", "" ),
            new TSymLookupEntry( 0x0061006a, 00011, "", "" ),
            new TSymLookupEntry( 0x0061006c, 00017, "", "" ),
            new TSymLookupEntry( 0x0061006d, 00040, "", "" ),
            new TSymLookupEntry( 0x0061006e, 00015, "", "" ),
            new TSymLookupEntry( 0x00610070, 00039, "", "" ),
            new TSymLookupEntry( 0x00610072, 00014, "", "" ),
            new TSymLookupEntry( 0x00610073, 00006, "", "" ),
            new TSymLookupEntry( 0x00610074, 00014, "", "" ),
            new TSymLookupEntry( 0x00610076, 00008, "", "" ),
            new TSymLookupEntry( 0x00610077, 00003, "", "" ),
            new TSymLookupEntry( 0x0061007b, 00002, "", "" ),
            new TSymLookupEntry( 0x00610350, 00001, "", "" ),
            new TSymLookupEntry( 0x006103a0, 00001, "", "" ),
            new TSymLookupEntry( 0x006107d8, 00001, "", "" ),
            new TSymLookupEntry( 0x00610818, 00001, "", "" ),
            new TSymLookupEntry( 0x00611f08, 00001, "", "" ),
            new TSymLookupEntry( 0x006130b4, 00001, "", "" ),
            new TSymLookupEntry( 0x006137d0, 00001, "", "" ),
            new TSymLookupEntry( 0x00613c30, 00001, "", "" ),
            new TSymLookupEntry( 0x0061533c, 00001, "", "" ),
            new TSymLookupEntry( 0x00615520, 00002, "", "" ),
            new TSymLookupEntry( 0x00615570, 00001, "", "" ),
            new TSymLookupEntry( 0x006155d8, 00003, "", "" ),
            new TSymLookupEntry( 0x00615730, 00001, "", "" ),
            new TSymLookupEntry( 0x00615768, 00002, "", "" ),
            new TSymLookupEntry( 0x00615c38, 00001, "", "" ),
            new TSymLookupEntry( 0x00615f4c, 00001, "", "" ),
            new TSymLookupEntry( 0x006160a0, 00001, "", "" ),
            new TSymLookupEntry( 0x006160fc, 00001, "", "" ),
            new TSymLookupEntry( 0x00616648, 00001, "", "" ),
            new TSymLookupEntry( 0x00616718, 00002, "", "" ),
            new TSymLookupEntry( 0x00616888, 00001, "", "" ),
            new TSymLookupEntry( 0x00616950, 00001, "", "" ),
            new TSymLookupEntry( 0x00616df0, 00001, "", "" ),
            new TSymLookupEntry( 0x00617058, 00001, "", "" ),
            new TSymLookupEntry( 0x00617098, 00001, "", "" ),
            new TSymLookupEntry( 0x00617560, 00001, "", "" ),
            new TSymLookupEntry( 0x006175d8, 00001, "", "" ),
            new TSymLookupEntry( 0x00617628, 00001, "", "" ),
            new TSymLookupEntry( 0x00617a84, 00001, "", "" ),
            new TSymLookupEntry( 0x00617f60, 00001, "", "" ),
            new TSymLookupEntry( 0x006181ac, 00001, "", "" ),
            new TSymLookupEntry( 0x00618bc4, 00001, "", "" ),
            new TSymLookupEntry( 0x00619030, 00001, "", "" ),
            new TSymLookupEntry( 0x00619c40, 00001, "", "" ),
            new TSymLookupEntry( 0x0061b858, 00001, "", "" ),
            new TSymLookupEntry( 0x0061b980, 00007, "", "" ),
            new TSymLookupEntry( 0x0061bac0, 00001, "", "" ),
            new TSymLookupEntry( 0x0061bad0, 00001, "", "" ),
            new TSymLookupEntry( 0x0061bbb8, 00001, "", "" ),
            new TSymLookupEntry( 0x0061bda0, 00001, "", "" ),
            new TSymLookupEntry( 0x0061be20, 00001, "", "" ),
            new TSymLookupEntry( 0x0061c0f8, 00001, "", "" ),
            new TSymLookupEntry( 0x0061c178, 00001, "", "" ),
            new TSymLookupEntry( 0x0061c1d0, 00001, "", "" ),
            new TSymLookupEntry( 0x0061c228, 00001, "", "" ),
            new TSymLookupEntry( 0x0061c2a8, 00001, "", "" ),
            new TSymLookupEntry( 0x0061c300, 00001, "", "" ),
            new TSymLookupEntry( 0x0061c388, 00001, "", "" ),
            new TSymLookupEntry( 0x0061c3e0, 00001, "", "" ),
            new TSymLookupEntry( 0x0061c440, 00001, "", "" ),
            new TSymLookupEntry( 0x0061c468, 00001, "", "" ),
            new TSymLookupEntry( 0x0061c490, 00001, "", "" ),
            new TSymLookupEntry( 0x0061c548, 00001, "", "" ),
            new TSymLookupEntry( 0x0061c5a0, 00001, "", "" ),
            new TSymLookupEntry( 0x0061c5f8, 00001, "", "" ),
            new TSymLookupEntry( 0x0061c6b0, 00001, "", "" ),
            new TSymLookupEntry( 0x0061c710, 00001, "", "" ),
            new TSymLookupEntry( 0x0061c768, 00001, "", "" ),
            new TSymLookupEntry( 0x0061c7c8, 00001, "", "" ),
            new TSymLookupEntry( 0x0061c820, 00001, "", "" ),
            new TSymLookupEntry( 0x0061c870, 00001, "", "" ),
            new TSymLookupEntry( 0x0061c8f0, 00001, "", "" ),
            new TSymLookupEntry( 0x0061c988, 00001, "", "" ),
            new TSymLookupEntry( 0x0061c9f0, 00001, "", "" ),
            new TSymLookupEntry( 0x0061ca78, 00001, "", "" ),
            new TSymLookupEntry( 0x0061cad8, 00001, "", "" ),
            new TSymLookupEntry( 0x0061cb78, 00001, "", "" ),
            new TSymLookupEntry( 0x0061cbd0, 00001, "", "" ),
            new TSymLookupEntry( 0x0061cc20, 00001, "", "" ),
            new TSymLookupEntry( 0x0061cc78, 00001, "", "" ),
            new TSymLookupEntry( 0x0061cd00, 00001, "", "" ),
            new TSymLookupEntry( 0x0061cd50, 00001, "", "" ),
            new TSymLookupEntry( 0x0061cda0, 00001, "", "" ),
            new TSymLookupEntry( 0x0061cdf8, 00001, "", "" ),
            new TSymLookupEntry( 0x0061ce50, 00001, "", "" ),
            new TSymLookupEntry( 0x0061cea8, 00001, "", "" ),
            new TSymLookupEntry( 0x0061d128, 00001, "", "" ),
            new TSymLookupEntry( 0x0061d488, 00001, "", "" ),
            new TSymLookupEntry( 0x0061d7e0, 00001, "", "" ),
            new TSymLookupEntry( 0x0061d808, 00001, "", "" ),
            new TSymLookupEntry( 0x0061e2d0, 00030, "", "" ),
            new TSymLookupEntry( 0x0061e508, 00001, "", "" ),
            new TSymLookupEntry( 0x0061e578, 00001, "", "" ),
            new TSymLookupEntry( 0x0061ea10, 00006, "", "" ),
            new TSymLookupEntry( 0x0061eb00, 00007, "", "" ),
            new TSymLookupEntry( 0x0061ec08, 00002, "", "" ),
            new TSymLookupEntry( 0x0061ec58, 00006, "", "" ),
            new TSymLookupEntry( 0x0061ece8, 00001, "", "" ),
            new TSymLookupEntry( 0x0061ee38, 00001, "", "" ),
            new TSymLookupEntry( 0x0061f078, 00001, "", "" ),
            new TSymLookupEntry( 0x0061fa68, 00001, "", "" ),
            new TSymLookupEntry( 0x0061fad8, 00001, "", "" ),
            new TSymLookupEntry( 0x0061fc20, 00001, "", "" ),
            new TSymLookupEntry( 0x0061fc48, 00001, "", "" ),
            new TSymLookupEntry( 0x0061fcc1, 00001, "", "" ),
            new TSymLookupEntry( 0x0061fce0, 00001, "", "" ),
            new TSymLookupEntry( 0x0061ffa8, 00001, "", "" ),
            new TSymLookupEntry( 0x0062002e, 00005, "", "" ),
            new TSymLookupEntry( 0x0062003c, 00002, "", "" ),
            new TSymLookupEntry( 0x00620041, 00001, "", "" ),
            new TSymLookupEntry( 0x0062004f, 00001, "", "" ),
            new TSymLookupEntry( 0x0062005e, 00004, "", "" ),
            new TSymLookupEntry( 0x00620061, 00010, "", "" ),
            new TSymLookupEntry( 0x00620064, 00001, "", "" ),
            new TSymLookupEntry( 0x00620069, 00001, "", "" ),
            new TSymLookupEntry( 0x0062006b, 00001, "", "" ),
            new TSymLookupEntry( 0x0062006f, 00011, "", "" ),
            new TSymLookupEntry( 0x00620070, 00001, "", "" ),
            new TSymLookupEntry( 0x00620074, 00005, "", "" ),
            new TSymLookupEntry( 0x00620077, 00001, "", "" ),
            new TSymLookupEntry( 0x00620158, 00002, "", "" ),
            new TSymLookupEntry( 0x00620198, 00001, "", "" ),
            new TSymLookupEntry( 0x00620208, 00001, "", "" ),
            new TSymLookupEntry( 0x006203b9, 00001, "", "" ),
            new TSymLookupEntry( 0x006203d0, 00001, "", "" ),
            new TSymLookupEntry( 0x00620450, 00001, "", "" ),
            new TSymLookupEntry( 0x006204c0, 00001, "", "" ),
            new TSymLookupEntry( 0x00620538, 00001, "", "" ),
            new TSymLookupEntry( 0x00620630, 00001, "", "" ),
            new TSymLookupEntry( 0x00620658, 00001, "", "" ),
            new TSymLookupEntry( 0x00620711, 00001, "", "" ),
            new TSymLookupEntry( 0x00620738, 00001, "", "" ),
            new TSymLookupEntry( 0x00620760, 00001, "", "" ),
            new TSymLookupEntry( 0x00620801, 00001, "", "" ),
            new TSymLookupEntry( 0x00620828, 00001, "", "" ),
            new TSymLookupEntry( 0x00620fd0, 00010, "", "" ),
            new TSymLookupEntry( 0x00621138, 00001, "", "" ),
            new TSymLookupEntry( 0x006213a0, 00001, "", "" ),
            new TSymLookupEntry( 0x00621440, 00001, "", "" ),
            new TSymLookupEntry( 0x006215c8, 00001, "", "" ),
            new TSymLookupEntry( 0x00621641, 00001, "", "" ),
            new TSymLookupEntry( 0x00621668, 00001, "", "" ),
            new TSymLookupEntry( 0x00621bb1, 00001, "", "" ),
            new TSymLookupEntry( 0x00621c31, 00001, "", "" ),
            new TSymLookupEntry( 0x00621cd6, 00001, "", "" ),
            new TSymLookupEntry( 0x00621ce8, 00001, "", "" ),
            new TSymLookupEntry( 0x00622080, 00001, "", "" ),
            new TSymLookupEntry( 0x006224b8, 00003, "", "" ),
            new TSymLookupEntry( 0x00622f28, 00001, "", "" ),
            new TSymLookupEntry( 0x00625fb0, 00017, "", "" ),
            new TSymLookupEntry( 0x00626398, 00003, "", "" ),
            new TSymLookupEntry( 0x006268e8, 00001, "", "" ),
            new TSymLookupEntry( 0x00627718, 00001, "", "" ),
            new TSymLookupEntry( 0x00627990, 00001, "", "" ),
            new TSymLookupEntry( 0x00627b30, 00001, "", "" ),
            new TSymLookupEntry( 0x00627bf0, 00001, "", "" ),
            new TSymLookupEntry( 0x00627c20, 00001, "", "" ),
            new TSymLookupEntry( 0x00627ca0, 00056, "", "" ),
            new TSymLookupEntry( 0x00627fd0, 00001, "", "" ),
            new TSymLookupEntry( 0x006281a8, 00001, "", "" ),
            new TSymLookupEntry( 0x00628378, 00001, "", "" ),
            new TSymLookupEntry( 0x00629668, 00001, "", "" ),
            new TSymLookupEntry( 0x0062b830, 00001, "", "" ),
            new TSymLookupEntry( 0x0062be00, 00001, "", "" ),
            new TSymLookupEntry( 0x0062c060, 00001, "", "" ),
            new TSymLookupEntry( 0x0062d101, 00001, "", "" ),
            new TSymLookupEntry( 0x0062d3d8, 00001, "", "" ),
            new TSymLookupEntry( 0x0062d640, 00001, "", "" ),
            new TSymLookupEntry( 0x0062d7d0, 00001, "", "" ),
            new TSymLookupEntry( 0x0062dba0, 00001, "", "" ),
            new TSymLookupEntry( 0x0062dcb0, 00001, "", "" ),
            new TSymLookupEntry( 0x0062dd28, 00001, "", "" ),
            new TSymLookupEntry( 0x0062dd78, 00001, "", "" ),
            new TSymLookupEntry( 0x0062ddf0, 00001, "", "" ),
            new TSymLookupEntry( 0x0062de40, 00001, "", "" ),
            new TSymLookupEntry( 0x0062de90, 00001, "", "" ),
            new TSymLookupEntry( 0x0062df08, 00001, "", "" ),
            new TSymLookupEntry( 0x0062df58, 00001, "", "" ),
            new TSymLookupEntry( 0x0062dfa8, 00001, "", "" ),
            new TSymLookupEntry( 0x0062dff8, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e048, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e098, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e0e8, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e138, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e188, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e1d8, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e228, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e278, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e2c8, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e318, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e408, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e458, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e4a8, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e4f8, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e548, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e598, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e5e8, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e638, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e688, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e6d8, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e728, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e7a0, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e7f0, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e840, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e890, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e8e0, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e930, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e980, 00001, "", "" ),
            new TSymLookupEntry( 0x0062e9f8, 00001, "", "" ),
            new TSymLookupEntry( 0x0062ea48, 00001, "", "" ),
            new TSymLookupEntry( 0x0062ea98, 00001, "", "" ),
            new TSymLookupEntry( 0x0062eae8, 00001, "", "" ),
            new TSymLookupEntry( 0x0062eb38, 00001, "", "" ),
            new TSymLookupEntry( 0x0062eb88, 00001, "", "" ),
            new TSymLookupEntry( 0x0062ebd8, 00001, "", "" ),
            new TSymLookupEntry( 0x0062ec28, 00001, "", "" ),
            new TSymLookupEntry( 0x0062ec78, 00001, "", "" ),
            new TSymLookupEntry( 0x0062ecc8, 00001, "", "" ),
            new TSymLookupEntry( 0x0062ed18, 00001, "", "" ),
            new TSymLookupEntry( 0x0062ed60, 00001, "", "" ),
            new TSymLookupEntry( 0x0062edb0, 00001, "", "" ),
            new TSymLookupEntry( 0x0062ee00, 00001, "", "" ),
            new TSymLookupEntry( 0x0062ef40, 00001, "", "" ),
            new TSymLookupEntry( 0x0062ef90, 00001, "", "" ),
            new TSymLookupEntry( 0x0062efe0, 00001, "", "" ),
            new TSymLookupEntry( 0x0062f0d0, 00001, "", "" ),
            new TSymLookupEntry( 0x0062f120, 00001, "", "" ),
            new TSymLookupEntry( 0x0062f170, 00001, "", "" ),
            new TSymLookupEntry( 0x0062f1c0, 00001, "", "" ),
            new TSymLookupEntry( 0x0062f210, 00001, "", "" ),
            new TSymLookupEntry( 0x0062f260, 00001, "", "" ),
            new TSymLookupEntry( 0x0062f2b0, 00001, "", "" ),
            new TSymLookupEntry( 0x0062f300, 00001, "", "" ),
            new TSymLookupEntry( 0x0062f350, 00001, "", "" ),
            new TSymLookupEntry( 0x0062f3c8, 00001, "", "" ),
            new TSymLookupEntry( 0x0062f9e0, 00001, "", "" ),
            new TSymLookupEntry( 0x0062fa30, 00001, "", "" ),
            new TSymLookupEntry( 0x0062fc10, 00001, "", "" ),
            new TSymLookupEntry( 0x0062fc60, 00001, "", "" ),
            new TSymLookupEntry( 0x0062fe68, 00001, "", "" ),
            new TSymLookupEntry( 0x0062feb8, 00001, "", "" ),
            new TSymLookupEntry( 0x0062ff08, 00001, "", "" ),
            new TSymLookupEntry( 0x0062ff58, 00001, "", "" ),
            new TSymLookupEntry( 0x0062ffa8, 00001, "", "" ),
            new TSymLookupEntry( 0x0062fff8, 00001, "", "" ),
            new TSymLookupEntry( 0x00630022, 00001, "", "" ),
            new TSymLookupEntry( 0x00630023, 00001, "", "" ),
            new TSymLookupEntry( 0x00630026, 00002, "", "" ),
            new TSymLookupEntry( 0x00630027, 00001, "", "" ),
            new TSymLookupEntry( 0x00630028, 00001, "", "" ),
            new TSymLookupEntry( 0x0063002d, 00010, "", "" ),
            new TSymLookupEntry( 0x0063002f, 00003, "", "" ),
            new TSymLookupEntry( 0x0063003c, 00001, "", "" ),
            new TSymLookupEntry( 0x00630041, 00004, "", "" ),
            new TSymLookupEntry( 0x00630048, 00001, "", "" ),
            new TSymLookupEntry( 0x00630061, 00010, "", "" ),
            new TSymLookupEntry( 0x00630065, 00002, "", "" ),
            new TSymLookupEntry( 0x00630069, 00001, "", "" ),
            new TSymLookupEntry( 0x0063006d, 00001, "", "" ),
            new TSymLookupEntry( 0x00630073, 00034, "", "" ),
            new TSymLookupEntry( 0x0063007b, 00002, "", "" ),
            new TSymLookupEntry( 0x006308a0, 00001, "", "" ),
            new TSymLookupEntry( 0x006308f0, 00001, "", "" ),
            new TSymLookupEntry( 0x00630940, 00001, "", "" ),
            new TSymLookupEntry( 0x00630990, 00001, "", "" ),
            new TSymLookupEntry( 0x006309e0, 00001, "", "" ),
            new TSymLookupEntry( 0x00630d78, 00001, "", "" ),
            new TSymLookupEntry( 0x00630e90, 00001, "", "" ),
            new TSymLookupEntry( 0x00630ee0, 00001, "", "" ),
            new TSymLookupEntry( 0x00630f30, 00001, "", "" ),
            new TSymLookupEntry( 0x00630fa8, 00001, "", "" ),
            new TSymLookupEntry( 0x00630ff8, 00001, "", "" ),
            new TSymLookupEntry( 0x00631048, 00001, "", "" ),
            new TSymLookupEntry( 0x006310e8, 00001, "", "" ),
            new TSymLookupEntry( 0x00631160, 00001, "", "" ),
            new TSymLookupEntry( 0x006311b0, 00001, "", "" ),
            new TSymLookupEntry( 0x00631228, 00001, "", "" ),
            new TSymLookupEntry( 0x00631278, 00001, "", "" ),
            new TSymLookupEntry( 0x006312c8, 00001, "", "" ),
            new TSymLookupEntry( 0x00631340, 00001, "", "" ),
            new TSymLookupEntry( 0x00631390, 00001, "", "" ),
            new TSymLookupEntry( 0x006313e0, 00001, "", "" ),
            new TSymLookupEntry( 0x00631430, 00001, "", "" ),
            new TSymLookupEntry( 0x00631480, 00001, "", "" ),
            new TSymLookupEntry( 0x006314d0, 00001, "", "" ),
            new TSymLookupEntry( 0x00631520, 00001, "", "" ),
            new TSymLookupEntry( 0x00631570, 00001, "", "" ),
            new TSymLookupEntry( 0x006315c0, 00001, "", "" ),
            new TSymLookupEntry( 0x00631610, 00001, "", "" ),
            new TSymLookupEntry( 0x00631660, 00001, "", "" ),
            new TSymLookupEntry( 0x006316b0, 00001, "", "" ),
            new TSymLookupEntry( 0x00631700, 00001, "", "" ),
            new TSymLookupEntry( 0x00631750, 00001, "", "" ),
            new TSymLookupEntry( 0x00631840, 00001, "", "" ),
            new TSymLookupEntry( 0x00631890, 00001, "", "" ),
            new TSymLookupEntry( 0x006318e0, 00001, "", "" ),
            new TSymLookupEntry( 0x00631930, 00001, "", "" ),
            new TSymLookupEntry( 0x00631980, 00001, "", "" ),
            new TSymLookupEntry( 0x006319d0, 00001, "", "" ),
            new TSymLookupEntry( 0x00631a20, 00001, "", "" ),
            new TSymLookupEntry( 0x00631a70, 00001, "", "" ),
            new TSymLookupEntry( 0x00631ac0, 00001, "", "" ),
            new TSymLookupEntry( 0x00631b10, 00001, "", "" ),
            new TSymLookupEntry( 0x00631b60, 00001, "", "" ),
            new TSymLookupEntry( 0x00631bd8, 00001, "", "" ),
            new TSymLookupEntry( 0x00631c28, 00001, "", "" ),
            new TSymLookupEntry( 0x00631c78, 00001, "", "" ),
            new TSymLookupEntry( 0x00631cc8, 00001, "", "" ),
            new TSymLookupEntry( 0x00631d18, 00001, "", "" ),
            new TSymLookupEntry( 0x00631d68, 00001, "", "" ),
            new TSymLookupEntry( 0x00631db8, 00001, "", "" ),
            new TSymLookupEntry( 0x00631e30, 00001, "", "" ),
            new TSymLookupEntry( 0x00631e80, 00001, "", "" ),
            new TSymLookupEntry( 0x00631ed0, 00001, "", "" ),
            new TSymLookupEntry( 0x00631f20, 00001, "", "" ),
            new TSymLookupEntry( 0x00631f70, 00001, "", "" ),
            new TSymLookupEntry( 0x00631fc0, 00001, "", "" ),
            new TSymLookupEntry( 0x00632010, 00001, "", "" ),
            new TSymLookupEntry( 0x00632060, 00001, "", "" ),
            new TSymLookupEntry( 0x006320b0, 00001, "", "" ),
            new TSymLookupEntry( 0x00632100, 00001, "", "" ),
            new TSymLookupEntry( 0x00632150, 00001, "", "" ),
            new TSymLookupEntry( 0x00632198, 00001, "", "" ),
            new TSymLookupEntry( 0x006321e8, 00001, "", "" ),
            new TSymLookupEntry( 0x00632238, 00001, "", "" ),
            new TSymLookupEntry( 0x00632378, 00001, "", "" ),
            new TSymLookupEntry( 0x006323c8, 00001, "", "" ),
            new TSymLookupEntry( 0x00632418, 00001, "", "" ),
            new TSymLookupEntry( 0x00632508, 00001, "", "" ),
            new TSymLookupEntry( 0x00632558, 00001, "", "" ),
            new TSymLookupEntry( 0x006325a8, 00001, "", "" ),
            new TSymLookupEntry( 0x006325f8, 00001, "", "" ),
            new TSymLookupEntry( 0x00632648, 00001, "", "" ),
            new TSymLookupEntry( 0x00632698, 00001, "", "" ),
            new TSymLookupEntry( 0x006326e8, 00001, "", "" ),
            new TSymLookupEntry( 0x00632738, 00001, "", "" ),
            new TSymLookupEntry( 0x00632788, 00001, "", "" ),
            new TSymLookupEntry( 0x00632800, 00001, "", "" ),
            new TSymLookupEntry( 0x00632e18, 00001, "", "" ),
            new TSymLookupEntry( 0x00632e68, 00001, "", "" ),
            new TSymLookupEntry( 0x00633048, 00001, "", "" ),
            new TSymLookupEntry( 0x00633098, 00001, "", "" ),
            new TSymLookupEntry( 0x006332a0, 00001, "", "" ),
            new TSymLookupEntry( 0x006332f0, 00001, "", "" ),
            new TSymLookupEntry( 0x00633340, 00001, "", "" ),
            new TSymLookupEntry( 0x00633390, 00001, "", "" ),
            new TSymLookupEntry( 0x006333e0, 00001, "", "" ),
            new TSymLookupEntry( 0x00633430, 00001, "", "" ),
            new TSymLookupEntry( 0x00633480, 00001, "", "" ),
            new TSymLookupEntry( 0x00633cd8, 00001, "", "" ),
            new TSymLookupEntry( 0x00633d28, 00001, "", "" ),
            new TSymLookupEntry( 0x00633d78, 00001, "", "" ),
            new TSymLookupEntry( 0x00633dc8, 00001, "", "" ),
            new TSymLookupEntry( 0x00633e18, 00001, "", "" ),
            new TSymLookupEntry( 0x006341b0, 00001, "", "" ),
            new TSymLookupEntry( 0x006342c8, 00001, "", "" ),
            new TSymLookupEntry( 0x00634318, 00001, "", "" ),
            new TSymLookupEntry( 0x00634368, 00001, "", "" ),
            new TSymLookupEntry( 0x006343e0, 00001, "", "" ),
            new TSymLookupEntry( 0x00634430, 00001, "", "" ),
            new TSymLookupEntry( 0x00634480, 00001, "", "" ),
            new TSymLookupEntry( 0x00634568, 00001, "", "" ),
            new TSymLookupEntry( 0x006347e8, 00001, "", "" ),
            new TSymLookupEntry( 0x00634838, 00001, "", "" ),
            new TSymLookupEntry( 0x00634888, 00001, "", "" ),
            new TSymLookupEntry( 0x00634920, 00001, "", "" ),
            new TSymLookupEntry( 0x00634970, 00001, "", "" ),
            new TSymLookupEntry( 0x006349f8, 00001, "", "" ),
            new TSymLookupEntry( 0x00634a48, 00001, "", "" ),
            new TSymLookupEntry( 0x00634a98, 00001, "", "" ),
            new TSymLookupEntry( 0x00634bf8, 00001, "", "" ),
            new TSymLookupEntry( 0x00634c88, 00001, "", "" ),
            new TSymLookupEntry( 0x00634de0, 00001, "", "" ),
            new TSymLookupEntry( 0x00634e98, 00001, "", "" ),
            new TSymLookupEntry( 0x006351b0, 00001, "", "" ),
            new TSymLookupEntry( 0x006351d8, 00001, "", "" ),
            new TSymLookupEntry( 0x00635200, 00001, "", "" ),
            new TSymLookupEntry( 0x00635228, 00001, "", "" ),
            new TSymLookupEntry( 0x00635250, 00001, "", "" ),
            new TSymLookupEntry( 0x00635278, 00001, "", "" ),
            new TSymLookupEntry( 0x006352a0, 00001, "", "" ),
            new TSymLookupEntry( 0x00635578, 00001, "", "" ),
            new TSymLookupEntry( 0x006355a0, 00001, "", "" ),
            new TSymLookupEntry( 0x006355c8, 00001, "", "" ),
            new TSymLookupEntry( 0x00635690, 00001, "", "" ),
            new TSymLookupEntry( 0x006356b8, 00001, "", "" ),
            new TSymLookupEntry( 0x006356e0, 00001, "", "" ),
            new TSymLookupEntry( 0x00635708, 00001, "", "" ),
            new TSymLookupEntry( 0x00635730, 00001, "", "" ),
            new TSymLookupEntry( 0x00635758, 00001, "", "" ),
            new TSymLookupEntry( 0x00635780, 00001, "", "" ),
            new TSymLookupEntry( 0x00635878, 00001, "", "" ),
            new TSymLookupEntry( 0x006359d8, 00002, "", "" ),
            new TSymLookupEntry( 0x00635af0, 00001, "", "" ),
            new TSymLookupEntry( 0x00635b88, 00001, "", "" ),
            new TSymLookupEntry( 0x00635bb0, 00001, "", "" ),
            new TSymLookupEntry( 0x00635c50, 00001, "", "" ),
            new TSymLookupEntry( 0x00635c78, 00001, "", "" ),
            new TSymLookupEntry( 0x00635ca0, 00001, "", "" ),
            new TSymLookupEntry( 0x00635cc8, 00001, "", "" ),
            new TSymLookupEntry( 0x00635d18, 00003, "", "" ),
            new TSymLookupEntry( 0x00635de0, 00001, "", "" ),
            new TSymLookupEntry( 0x00635e08, 00001, "", "" ),
            new TSymLookupEntry( 0x00635e30, 00001, "", "" ),
            new TSymLookupEntry( 0x00635e58, 00001, "", "" ),
            new TSymLookupEntry( 0x00635e80, 00001, "", "" ),
            new TSymLookupEntry( 0x00635ea8, 00001, "", "" ),
            new TSymLookupEntry( 0x00635ed0, 00001, "", "" ),
            new TSymLookupEntry( 0x00636068, 00001, "", "" ),
            new TSymLookupEntry( 0x006360b8, 00001, "", "" ),
            new TSymLookupEntry( 0x00636108, 00001, "", "" ),
            new TSymLookupEntry( 0x00636400, 00001, "", "" ),
            new TSymLookupEntry( 0x00636d98, 00001, "", "" ),
            new TSymLookupEntry( 0x00636dc0, 00001, "", "" ),
            new TSymLookupEntry( 0x00636de8, 00001, "", "" ),
            new TSymLookupEntry( 0x00636e10, 00001, "", "" ),
            new TSymLookupEntry( 0x00636ed8, 00001, "", "" ),
            new TSymLookupEntry( 0x00636f00, 00001, "", "" ),
            new TSymLookupEntry( 0x00636f28, 00001, "", "" ),
            new TSymLookupEntry( 0x00636f50, 00001, "", "" ),
            new TSymLookupEntry( 0x00637078, 00001, "", "" ),
            new TSymLookupEntry( 0x00637328, 00001, "", "" ),
            new TSymLookupEntry( 0x00637350, 00001, "", "" ),
            new TSymLookupEntry( 0x006374b8, 00001, "", "" ),
            new TSymLookupEntry( 0x006374e0, 00001, "", "" ),
            new TSymLookupEntry( 0x00637508, 00001, "", "" ),
            new TSymLookupEntry( 0x00637530, 00001, "", "" ),
            new TSymLookupEntry( 0x00637768, 00003, "", "" ),
            new TSymLookupEntry( 0x006377b8, 00030, "", "" ),
            new TSymLookupEntry( 0x00637808, 00002, "", "" ),
            new TSymLookupEntry( 0x00637858, 00003, "", "" ),
            new TSymLookupEntry( 0x006378a8, 00001, "", "" ),
            new TSymLookupEntry( 0x006378f8, 00006, "", "" ),
            new TSymLookupEntry( 0x00637bd8, 00031, "", "" ),
            new TSymLookupEntry( 0x00637cc8, 00001, "", "" ),
            new TSymLookupEntry( 0x00637d68, 00001, "", "" ),
            new TSymLookupEntry( 0x00637dd0, 00001, "", "" ),
            new TSymLookupEntry( 0x00637e30, 00001, "", "" ),
            new TSymLookupEntry( 0x00637ea0, 00001, "", "" ),
            new TSymLookupEntry( 0x00637f58, 00001, "", "" ),
            new TSymLookupEntry( 0x006380f0, 00001, "", "" ),
            new TSymLookupEntry( 0x006381c0, 00001, "", "" ),
            new TSymLookupEntry( 0x006383d0, 00001, "", "" ),
            new TSymLookupEntry( 0x00638578, 00001, "", "" ),
            new TSymLookupEntry( 0x006388e8, 00001, "", "" ),
            new TSymLookupEntry( 0x00638910, 00001, "", "" ),
            new TSymLookupEntry( 0x006389d8, 00001, "", "" ),
            new TSymLookupEntry( 0x00638be0, 00001, "", "" ),
            new TSymLookupEntry( 0x00638c08, 00001, "", "" ),
            new TSymLookupEntry( 0x00638c30, 00001, "", "" ),
            new TSymLookupEntry( 0x00638c58, 00001, "", "" ),
            new TSymLookupEntry( 0x00638c80, 00001, "", "" ),
            new TSymLookupEntry( 0x00638ca8, 00001, "", "" ),
            new TSymLookupEntry( 0x00638ee8, 00001, "", "" ),
            new TSymLookupEntry( 0x00638f10, 00001, "", "" ),
            new TSymLookupEntry( 0x00638f38, 00001, "", "" ),
            new TSymLookupEntry( 0x00638f60, 00001, "", "" ),
            new TSymLookupEntry( 0x00638f88, 00001, "", "" ),
            new TSymLookupEntry( 0x00638fb0, 00001, "", "" ),
            new TSymLookupEntry( 0x00639078, 00001, "", "" ),
            new TSymLookupEntry( 0x006390a0, 00001, "", "" ),
            new TSymLookupEntry( 0x006390c8, 00001, "", "" ),
            new TSymLookupEntry( 0x006390f0, 00001, "", "" ),
            new TSymLookupEntry( 0x00639118, 00001, "", "" ),
            new TSymLookupEntry( 0x00639140, 00001, "", "" ),
            new TSymLookupEntry( 0x00639350, 00001, "", "" ),
            new TSymLookupEntry( 0x00639378, 00001, "", "" ),
            new TSymLookupEntry( 0x006393a0, 00001, "", "" ),
            new TSymLookupEntry( 0x006393c8, 00001, "", "" ),
            new TSymLookupEntry( 0x006393f0, 00001, "", "" ),
            new TSymLookupEntry( 0x00639418, 00001, "", "" ),
            new TSymLookupEntry( 0x00639628, 00001, "", "" ),
            new TSymLookupEntry( 0x00639650, 00001, "", "" ),
            new TSymLookupEntry( 0x00639678, 00001, "", "" ),
            new TSymLookupEntry( 0x006396a0, 00001, "", "" ),
            new TSymLookupEntry( 0x006396c8, 00001, "", "" ),
            new TSymLookupEntry( 0x006396f0, 00001, "", "" ),
            new TSymLookupEntry( 0x00639900, 00001, "", "" ),
            new TSymLookupEntry( 0x00639928, 00001, "", "" ),
            new TSymLookupEntry( 0x00639950, 00001, "", "" ),
            new TSymLookupEntry( 0x00639978, 00001, "", "" ),
            new TSymLookupEntry( 0x006399a0, 00001, "", "" ),
            new TSymLookupEntry( 0x00639bc8, 00001, "", "" ),
            new TSymLookupEntry( 0x00639bf0, 00001, "", "" ),
            new TSymLookupEntry( 0x00639c18, 00001, "", "" ),
            new TSymLookupEntry( 0x00639c40, 00001, "", "" ),
            new TSymLookupEntry( 0x00639c68, 00001, "", "" ),
            new TSymLookupEntry( 0x00639e10, 00001, "", "" ),
            new TSymLookupEntry( 0x00639f68, 00001, "", "" ),
            new TSymLookupEntry( 0x00639f90, 00001, "", "" ),
            new TSymLookupEntry( 0x00639fb8, 00001, "", "" ),
            new TSymLookupEntry( 0x00639fe0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063a008, 00001, "", "" ),
            new TSymLookupEntry( 0x0063a030, 00001, "", "" ),
            new TSymLookupEntry( 0x0063a1a0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063a1c8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063a1f0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063a218, 00001, "", "" ),
            new TSymLookupEntry( 0x0063a240, 00001, "", "" ),
            new TSymLookupEntry( 0x0063a268, 00001, "", "" ),
            new TSymLookupEntry( 0x0063a290, 00001, "", "" ),
            new TSymLookupEntry( 0x0063a400, 00001, "", "" ),
            new TSymLookupEntry( 0x0063a4c8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063a4f0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063a700, 00001, "", "" ),
            new TSymLookupEntry( 0x0063a728, 00001, "", "" ),
            new TSymLookupEntry( 0x0063a7f0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063a818, 00001, "", "" ),
            new TSymLookupEntry( 0x0063ad98, 00001, "", "" ),
            new TSymLookupEntry( 0x0063adc0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063ae88, 00001, "", "" ),
            new TSymLookupEntry( 0x0063b0c8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063b3e0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063b408, 00001, "", "" ),
            new TSymLookupEntry( 0x0063b430, 00001, "", "" ),
            new TSymLookupEntry( 0x0063b458, 00001, "", "" ),
            new TSymLookupEntry( 0x0063b480, 00001, "", "" ),
            new TSymLookupEntry( 0x0063b4a8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063b618, 00001, "", "" ),
            new TSymLookupEntry( 0x0063b640, 00001, "", "" ),
            new TSymLookupEntry( 0x0063b668, 00001, "", "" ),
            new TSymLookupEntry( 0x0063b690, 00001, "", "" ),
            new TSymLookupEntry( 0x0063b6b8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063b6e0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063bcb8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063be00, 00001, "", "" ),
            new TSymLookupEntry( 0x0063bfd0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063bff8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063c020, 00001, "", "" ),
            new TSymLookupEntry( 0x0063c048, 00001, "", "" ),
            new TSymLookupEntry( 0x0063c348, 00001, "", "" ),
            new TSymLookupEntry( 0x0063c558, 00001, "", "" ),
            new TSymLookupEntry( 0x0063c580, 00001, "", "" ),
            new TSymLookupEntry( 0x0063c5a8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063c5d0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063c7b8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063c7e0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063c808, 00001, "", "" ),
            new TSymLookupEntry( 0x0063c830, 00001, "", "" ),
            new TSymLookupEntry( 0x0063c858, 00001, "", "" ),
            new TSymLookupEntry( 0x0063c880, 00001, "", "" ),
            new TSymLookupEntry( 0x0063c8a8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063cb30, 00001, "", "" ),
            new TSymLookupEntry( 0x0063cbf8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063cc20, 00001, "", "" ),
            new TSymLookupEntry( 0x0063cc48, 00001, "", "" ),
            new TSymLookupEntry( 0x0063cc70, 00001, "", "" ),
            new TSymLookupEntry( 0x0063cc98, 00001, "", "" ),
            new TSymLookupEntry( 0x0063ccc0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063cce8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063cf98, 00002, "", "" ),
            new TSymLookupEntry( 0x0063d050, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d078, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d0a0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d0c8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d0f0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d118, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d140, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d168, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d190, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d1b8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d1e0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d280, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d2a8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d2d0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d2f8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d320, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d4d8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d500, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d528, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d550, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d578, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d5a0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d5c8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d710, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d738, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d760, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d788, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d7b0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d7d8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d9a8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d9d0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063d9f8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063da20, 00001, "", "" ),
            new TSymLookupEntry( 0x0063da48, 00001, "", "" ),
            new TSymLookupEntry( 0x0063da70, 00001, "", "" ),
            new TSymLookupEntry( 0x0063da98, 00001, "", "" ),
            new TSymLookupEntry( 0x0063db68, 00001, "", "" ),
            new TSymLookupEntry( 0x0063ddc0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063dde8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063de10, 00001, "", "" ),
            new TSymLookupEntry( 0x0063de38, 00001, "", "" ),
            new TSymLookupEntry( 0x0063de60, 00001, "", "" ),
            new TSymLookupEntry( 0x0063de88, 00001, "", "" ),
            new TSymLookupEntry( 0x0063deb0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063ded8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063df00, 00001, "", "" ),
            new TSymLookupEntry( 0x0063df28, 00001, "", "" ),
            new TSymLookupEntry( 0x0063e2f0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063e318, 00001, "", "" ),
            new TSymLookupEntry( 0x0063e340, 00001, "", "" ),
            new TSymLookupEntry( 0x0063e368, 00001, "", "" ),
            new TSymLookupEntry( 0x0063e390, 00001, "", "" ),
            new TSymLookupEntry( 0x0063e3b8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063e3e0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063e618, 00009, "", "" ),
            new TSymLookupEntry( 0x0063e820, 00001, "", "" ),
            new TSymLookupEntry( 0x0063e848, 00001, "", "" ),
            new TSymLookupEntry( 0x0063e870, 00001, "", "" ),
            new TSymLookupEntry( 0x0063e898, 00001, "", "" ),
            new TSymLookupEntry( 0x0063e8c0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063e8e8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063e910, 00001, "", "" ),
            new TSymLookupEntry( 0x0063e938, 00001, "", "" ),
            new TSymLookupEntry( 0x0063ea00, 00001, "", "" ),
            new TSymLookupEntry( 0x0063ea28, 00001, "", "" ),
            new TSymLookupEntry( 0x0063ea50, 00001, "", "" ),
            new TSymLookupEntry( 0x0063ec10, 00001, "", "" ),
            new TSymLookupEntry( 0x0063ec88, 00003, "", "" ),
            new TSymLookupEntry( 0x0063ed00, 00003, "", "" ),
            new TSymLookupEntry( 0x0063ef20, 00001, "", "" ),
            new TSymLookupEntry( 0x0063f0c8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063f140, 00001, "", "" ),
            new TSymLookupEntry( 0x0063f408, 00001, "", "" ),
            new TSymLookupEntry( 0x0063f430, 00001, "", "" ),
            new TSymLookupEntry( 0x0063f458, 00001, "", "" ),
            new TSymLookupEntry( 0x0063f480, 00001, "", "" ),
            new TSymLookupEntry( 0x0063f4a8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063f4d0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063f4f8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063f5a0, 00002, "", "" ),
            new TSymLookupEntry( 0x0063f988, 00001, "", "" ),
            new TSymLookupEntry( 0x0063f9b0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063f9d8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063fa28, 00001, "", "" ),
            new TSymLookupEntry( 0x0063fa78, 00001, "", "" ),
            new TSymLookupEntry( 0x0063faa0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063fac8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063faf0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063fb18, 00001, "", "" ),
            new TSymLookupEntry( 0x0063fb40, 00001, "", "" ),
            new TSymLookupEntry( 0x0063fb68, 00001, "", "" ),
            new TSymLookupEntry( 0x0063fb90, 00001, "", "" ),
            new TSymLookupEntry( 0x0063fbb8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063fbe0, 00001, "", "" ),
            new TSymLookupEntry( 0x0063fc08, 00001, "", "" ),
            new TSymLookupEntry( 0x0063fc30, 00001, "", "" ),
            new TSymLookupEntry( 0x0063fc58, 00001, "", "" ),
            new TSymLookupEntry( 0x0063fc80, 00001, "", "" ),
            new TSymLookupEntry( 0x0063fca8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063fcf8, 00001, "", "" ),
            new TSymLookupEntry( 0x0063fe38, 00001, "", "" ),
            new TSymLookupEntry( 0x00640020, 00002, "", "" ),
            new TSymLookupEntry( 0x00640023, 00001, "", "" ),
            new TSymLookupEntry( 0x00640030, 00001, "", "" ),
            new TSymLookupEntry( 0x00640031, 00001, "", "" ),
            new TSymLookupEntry( 0x0064003c, 00230, "", "" ),
            new TSymLookupEntry( 0x0064005f, 00001, "", "" ),
            new TSymLookupEntry( 0x00640061, 00007, "", "" ),
            new TSymLookupEntry( 0x00640062, 00001, "", "" ),
            new TSymLookupEntry( 0x00640064, 00002, "", "" ),
            new TSymLookupEntry( 0x00640069, 00004, "", "" ),
            new TSymLookupEntry( 0x0064006f, 00002, "", "" ),
            new TSymLookupEntry( 0x00640074, 00001, "", "" ),
            new TSymLookupEntry( 0x00640268, 00001, "", "" ),
            new TSymLookupEntry( 0x00640290, 00001, "", "" ),
            new TSymLookupEntry( 0x006402b8, 00001, "", "" ),
            new TSymLookupEntry( 0x00640608, 00001, "", "" ),
            new TSymLookupEntry( 0x00640630, 00001, "", "" ),
            new TSymLookupEntry( 0x00640658, 00001, "", "" ),
            new TSymLookupEntry( 0x00640890, 00001, "", "" ),
            new TSymLookupEntry( 0x00640a78, 00001, "", "" ),
            new TSymLookupEntry( 0x00640b40, 00001, "", "" ),
            new TSymLookupEntry( 0x00640b68, 00001, "", "" ),
            new TSymLookupEntry( 0x00640b90, 00001, "", "" ),
            new TSymLookupEntry( 0x00640bb8, 00001, "", "" ),
            new TSymLookupEntry( 0x00640be0, 00001, "", "" ),
            new TSymLookupEntry( 0x00640c08, 00001, "", "" ),
            new TSymLookupEntry( 0x00640c30, 00001, "", "" ),
            new TSymLookupEntry( 0x00640e40, 00001, "", "" ),
            new TSymLookupEntry( 0x00640f08, 00001, "", "" ),
            new TSymLookupEntry( 0x006410c8, 00001, "", "" ),
            new TSymLookupEntry( 0x006410f0, 00001, "", "" ),
            new TSymLookupEntry( 0x00641118, 00001, "", "" ),
            new TSymLookupEntry( 0x00641140, 00001, "", "" ),
            new TSymLookupEntry( 0x00641168, 00001, "", "" ),
            new TSymLookupEntry( 0x00641190, 00001, "", "" ),
            new TSymLookupEntry( 0x006411b8, 00001, "", "" ),
            new TSymLookupEntry( 0x006411e0, 00001, "", "" ),
            new TSymLookupEntry( 0x00641208, 00001, "", "" ),
            new TSymLookupEntry( 0x006412d0, 00001, "", "" ),
            new TSymLookupEntry( 0x006412f8, 00001, "", "" ),
            new TSymLookupEntry( 0x00641320, 00001, "", "" ),
            new TSymLookupEntry( 0x00641348, 00001, "", "" ),
            new TSymLookupEntry( 0x00641370, 00001, "", "" ),
            new TSymLookupEntry( 0x00641398, 00001, "", "" ),
            new TSymLookupEntry( 0x006413c0, 00001, "", "" ),
            new TSymLookupEntry( 0x00641580, 00001, "", "" ),
            new TSymLookupEntry( 0x006415a8, 00001, "", "" ),
            new TSymLookupEntry( 0x006415d0, 00001, "", "" ),
            new TSymLookupEntry( 0x006415f8, 00001, "", "" ),
            new TSymLookupEntry( 0x00641620, 00001, "", "" ),
            new TSymLookupEntry( 0x00641648, 00001, "", "" ),
            new TSymLookupEntry( 0x00641670, 00001, "", "" ),
            new TSymLookupEntry( 0x00641698, 00001, "", "" ),
            new TSymLookupEntry( 0x00641760, 00001, "", "" ),
            new TSymLookupEntry( 0x00641788, 00001, "", "" ),
            new TSymLookupEntry( 0x006417b0, 00001, "", "" ),
            new TSymLookupEntry( 0x006417d8, 00001, "", "" ),
            new TSymLookupEntry( 0x00641800, 00001, "", "" ),
            new TSymLookupEntry( 0x00641828, 00001, "", "" ),
            new TSymLookupEntry( 0x00641850, 00001, "", "" ),
            new TSymLookupEntry( 0x006419c0, 00001, "", "" ),
            new TSymLookupEntry( 0x006419e8, 00001, "", "" ),
            new TSymLookupEntry( 0x00641a10, 00001, "", "" ),
            new TSymLookupEntry( 0x00641a38, 00001, "", "" ),
            new TSymLookupEntry( 0x00641f08, 00001, "", "" ),
            new TSymLookupEntry( 0x00642050, 00001, "", "" ),
            new TSymLookupEntry( 0x00642078, 00001, "", "" ),
            new TSymLookupEntry( 0x006420a0, 00001, "", "" ),
            new TSymLookupEntry( 0x006420c8, 00001, "", "" ),
            new TSymLookupEntry( 0x006420f0, 00001, "", "" ),
            new TSymLookupEntry( 0x00642118, 00001, "", "" ),
            new TSymLookupEntry( 0x00642140, 00001, "", "" ),
            new TSymLookupEntry( 0x00642168, 00001, "", "" ),
            new TSymLookupEntry( 0x006423e8, 00001, "", "" ),
            new TSymLookupEntry( 0x00642410, 00001, "", "" ),
            new TSymLookupEntry( 0x00642438, 00001, "", "" ),
            new TSymLookupEntry( 0x00642460, 00001, "", "" ),
            new TSymLookupEntry( 0x00642488, 00001, "", "" ),
            new TSymLookupEntry( 0x006424b0, 00001, "", "" ),
            new TSymLookupEntry( 0x00642830, 00001, "", "" ),
            new TSymLookupEntry( 0x006429a0, 00001, "", "" ),
            new TSymLookupEntry( 0x006429c8, 00001, "", "" ),
            new TSymLookupEntry( 0x00642b20, 00001, "", "" ),
            new TSymLookupEntry( 0x00642d28, 00001, "", "" ),
            new TSymLookupEntry( 0x00642d50, 00001, "", "" ),
            new TSymLookupEntry( 0x00643280, 00001, "", "" ),
            new TSymLookupEntry( 0x006432a8, 00001, "", "" ),
            new TSymLookupEntry( 0x006432d0, 00001, "", "" ),
            new TSymLookupEntry( 0x00643548, 00001, "", "" ),
            new TSymLookupEntry( 0x00643570, 00001, "", "" ),
            new TSymLookupEntry( 0x00643598, 00001, "", "" ),
            new TSymLookupEntry( 0x006435c0, 00001, "", "" ),
            new TSymLookupEntry( 0x006436b8, 00001, "", "" ),
            new TSymLookupEntry( 0x006437d0, 00001, "", "" ),
            new TSymLookupEntry( 0x00643a00, 00001, "", "" ),
            new TSymLookupEntry( 0x00643a28, 00001, "", "" ),
            new TSymLookupEntry( 0x00643a50, 00001, "", "" ),
            new TSymLookupEntry( 0x00643b98, 00001, "", "" ),
            new TSymLookupEntry( 0x00643cb0, 00001, "", "" ),
            new TSymLookupEntry( 0x00643ee0, 00001, "", "" ),
            new TSymLookupEntry( 0x00643f08, 00001, "", "" ),
            new TSymLookupEntry( 0x00643f30, 00001, "", "" ),
            new TSymLookupEntry( 0x00644378, 00001, "", "" ),
            new TSymLookupEntry( 0x006443a0, 00001, "", "" ),
            new TSymLookupEntry( 0x006443f0, 00001, "", "" ),
            new TSymLookupEntry( 0x00644538, 00001, "", "" ),
            new TSymLookupEntry( 0x00644560, 00001, "", "" ),
            new TSymLookupEntry( 0x00644588, 00001, "", "" ),
            new TSymLookupEntry( 0x00644718, 00001, "", "" ),
            new TSymLookupEntry( 0x00644740, 00001, "", "" ),
            new TSymLookupEntry( 0x00644768, 00001, "", "" ),
            new TSymLookupEntry( 0x00644790, 00001, "", "" ),
            new TSymLookupEntry( 0x006447b8, 00001, "", "" ),
            new TSymLookupEntry( 0x00644888, 00001, "", "" ),
            new TSymLookupEntry( 0x00644f28, 00001, "", "" ),
            new TSymLookupEntry( 0x00644f78, 00001, "", "" ),
            new TSymLookupEntry( 0x00645018, 00001, "", "" ),
            new TSymLookupEntry( 0x00645068, 00001, "", "" ),
            new TSymLookupEntry( 0x006450b8, 00001, "", "" ),
            new TSymLookupEntry( 0x00645108, 00001, "", "" ),
            new TSymLookupEntry( 0x00645158, 00001, "", "" ),
            new TSymLookupEntry( 0x006451a8, 00001, "", "" ),
            new TSymLookupEntry( 0x006451f8, 00001, "", "" ),
            new TSymLookupEntry( 0x00645248, 00001, "", "" ),
            new TSymLookupEntry( 0x006453a4, 00001, "", "" ),
            new TSymLookupEntry( 0x00646150, 00004, "", "" ),
            new TSymLookupEntry( 0x006467f8, 00001, "", "" ),
            new TSymLookupEntry( 0x00646a58, 00001, "", "" ),
            new TSymLookupEntry( 0x00646bf0, 00001, "", "" ),
            new TSymLookupEntry( 0x00646c70, 00001, "", "" ),
            new TSymLookupEntry( 0x00646d20, 00001, "", "" ),
            new TSymLookupEntry( 0x00646d48, 00001, "", "" ),
            new TSymLookupEntry( 0x00646dc0, 00001, "", "" ),
            new TSymLookupEntry( 0x00646eb8, 00001, "", "" ),
            new TSymLookupEntry( 0x006470a0, 00001, "", "" ),
            new TSymLookupEntry( 0x00647168, 00001, "", "" ),
            new TSymLookupEntry( 0x00647190, 00001, "", "" ),
            new TSymLookupEntry( 0x006471b8, 00001, "", "" ),
            new TSymLookupEntry( 0x00647208, 00001, "", "" ),
            new TSymLookupEntry( 0x00647350, 00001, "", "" ),
            new TSymLookupEntry( 0x00647478, 00001, "", "" ),
            new TSymLookupEntry( 0x00647658, 00003, "", "" ),
            new TSymLookupEntry( 0x006476e0, 00001, "", "" ),
            new TSymLookupEntry( 0x00647a18, 00001, "", "" ),
            new TSymLookupEntry( 0x00647b10, 00001, "", "" ),
            new TSymLookupEntry( 0x00647bf8, 00001, "", "" ),
            new TSymLookupEntry( 0x00647d18, 00001, "", "" ),
            new TSymLookupEntry( 0x00647e40, 00001, "", "" ),
            new TSymLookupEntry( 0x00647f68, 00001, "", "" ),
            new TSymLookupEntry( 0x00648048, 00001, "", "" ),
            new TSymLookupEntry( 0x00648070, 00001, "", "" ),
            new TSymLookupEntry( 0x00648098, 00001, "", "" ),
            new TSymLookupEntry( 0x006480c0, 00001, "", "" ),
            new TSymLookupEntry( 0x006480e8, 00001, "", "" ),
            new TSymLookupEntry( 0x00648110, 00001, "", "" ),
            new TSymLookupEntry( 0x00648138, 00001, "", "" ),
            new TSymLookupEntry( 0x00648250, 00001, "", "" ),
            new TSymLookupEntry( 0x006483b8, 00001, "", "" ),
            new TSymLookupEntry( 0x00648488, 00001, "", "" ),
            new TSymLookupEntry( 0x00648540, 00001, "", "" ),
            new TSymLookupEntry( 0x00648748, 00001, "", "" ),
            new TSymLookupEntry( 0x00648770, 00001, "", "" ),
            new TSymLookupEntry( 0x00648798, 00001, "", "" ),
            new TSymLookupEntry( 0x006487c0, 00001, "", "" ),
            new TSymLookupEntry( 0x006487e8, 00001, "", "" ),
            new TSymLookupEntry( 0x00648810, 00001, "", "" ),
            new TSymLookupEntry( 0x00648838, 00001, "", "" ),
            new TSymLookupEntry( 0x00648860, 00001, "", "" ),
            new TSymLookupEntry( 0x00648888, 00001, "", "" ),
            new TSymLookupEntry( 0x006488b0, 00001, "", "" ),
            new TSymLookupEntry( 0x00648950, 00001, "", "" ),
            new TSymLookupEntry( 0x00648978, 00001, "", "" ),
            new TSymLookupEntry( 0x006489a0, 00001, "", "" ),
            new TSymLookupEntry( 0x006489c8, 00001, "", "" ),
            new TSymLookupEntry( 0x006489f0, 00001, "", "" ),
            new TSymLookupEntry( 0x00648a18, 00001, "", "" ),
            new TSymLookupEntry( 0x00648a40, 00001, "", "" ),
            new TSymLookupEntry( 0x00648a68, 00001, "", "" ),
            new TSymLookupEntry( 0x00648a90, 00001, "", "" ),
            new TSymLookupEntry( 0x00648ab8, 00001, "", "" ),
            new TSymLookupEntry( 0x00648ae0, 00001, "", "" ),
            new TSymLookupEntry( 0x00648b08, 00001, "", "" ),
            new TSymLookupEntry( 0x00648ca8, 00001, "", "" ),
            new TSymLookupEntry( 0x00648cd0, 00001, "", "" ),
            new TSymLookupEntry( 0x00648cf8, 00001, "", "" ),
            new TSymLookupEntry( 0x00648d20, 00001, "", "" ),
            new TSymLookupEntry( 0x00648d48, 00001, "", "" ),
            new TSymLookupEntry( 0x00648d70, 00001, "", "" ),
            new TSymLookupEntry( 0x00648d98, 00001, "", "" ),
            new TSymLookupEntry( 0x00648dc0, 00001, "", "" ),
            new TSymLookupEntry( 0x00648de8, 00001, "", "" ),
            new TSymLookupEntry( 0x00648e10, 00001, "", "" ),
            new TSymLookupEntry( 0x00648e38, 00001, "", "" ),
            new TSymLookupEntry( 0x00648e60, 00001, "", "" ),
            new TSymLookupEntry( 0x00648ed8, 00001, "", "" ),
            new TSymLookupEntry( 0x00648f78, 00001, "", "" ),
            new TSymLookupEntry( 0x006490c0, 00001, "", "" ),
            new TSymLookupEntry( 0x006490e8, 00001, "", "" ),
            new TSymLookupEntry( 0x00649110, 00001, "", "" ),
            new TSymLookupEntry( 0x00649138, 00001, "", "" ),
            new TSymLookupEntry( 0x00649160, 00001, "", "" ),
            new TSymLookupEntry( 0x0064944c, 00001, "", "" ),
            new TSymLookupEntry( 0x0064bcf0, 00001, "", "" ),
            new TSymLookupEntry( 0x0064bd90, 00001, "", "" ),
            new TSymLookupEntry( 0x00650044, 00001, "", "" ),
            new TSymLookupEntry( 0x00650048, 00003, "", "" ),
            new TSymLookupEntry( 0x0065004c, 00004, "", "" ),
            new TSymLookupEntry( 0x0065004d, 00001, "", "" ),
            new TSymLookupEntry( 0x00650050, 00004, "", "" ),
            new TSymLookupEntry( 0x00650052, 00005, "", "" ),
            new TSymLookupEntry( 0x00650053, 00003, "", "" ),
            new TSymLookupEntry( 0x00650056, 00001, "", "" ),
            new TSymLookupEntry( 0x00650057, 00001, "", "" ),
            new TSymLookupEntry( 0x00650059, 00003, "", "" ),
            new TSymLookupEntry( 0x00650062, 00009, "", "" ),
            new TSymLookupEntry( 0x00650063, 00008, "", "" ),
            new TSymLookupEntry( 0x00650064, 00016, "", "" ),
            new TSymLookupEntry( 0x00650067, 00025, "", "" ),
            new TSymLookupEntry( 0x00650068, 00020, "", "" ),
            new TSymLookupEntry( 0x0065006b, 00008, "", "" ),
            new TSymLookupEntry( 0x0065006c, 00008, "", "" ),
            new TSymLookupEntry( 0x0065006d, 00009, "", "" ),
            new TSymLookupEntry( 0x0065006e, 00007, "", "" ),
            new TSymLookupEntry( 0x00650070, 00001, "", "" ),
            new TSymLookupEntry( 0x00650072, 00059, "", "" ),
            new TSymLookupEntry( 0x00650073, 00036, "", "" ),
            new TSymLookupEntry( 0x00650074, 00035, "", "" ),
            new TSymLookupEntry( 0x00650076, 00002, "", "" ),
            new TSymLookupEntry( 0x00650077, 00020, "", "" ),
            new TSymLookupEntry( 0x00650079, 00002, "", "" ),
            new TSymLookupEntry( 0x00654fe8, 00001, "", "" ),
            new TSymLookupEntry( 0x0065bee0, 00001, "", "" ),
            new TSymLookupEntry( 0x0065bf80, 00001, "", "" ),
            new TSymLookupEntry( 0x0065c0b0, 00001, "", "" ),
            new TSymLookupEntry( 0x0065c538, 00001, "", "" ),
            new TSymLookupEntry( 0x0065c5e8, 00006, "", "" ),
            new TSymLookupEntry( 0x0065c8a8, 00001, "", "" ),
            new TSymLookupEntry( 0x0065cb00, 00001, "", "" ),
            new TSymLookupEntry( 0x0065cb80, 00001, "", "" ),
            new TSymLookupEntry( 0x0065cd18, 00001, "", "" ),
            new TSymLookupEntry( 0x0065cda0, 00001, "", "" ),
            new TSymLookupEntry( 0x0065ce20, 00001, "", "" ),
            new TSymLookupEntry( 0x0065cea0, 00001, "", "" ),
            new TSymLookupEntry( 0x0065cf20, 00001, "", "" ),
            new TSymLookupEntry( 0x0065cfa0, 00001, "", "" ),
            new TSymLookupEntry( 0x0065d028, 00001, "", "" ),
            new TSymLookupEntry( 0x0065d4f0, 00001, "", "" ),
            new TSymLookupEntry( 0x0065d570, 00001, "", "" ),
            new TSymLookupEntry( 0x0065e9c8, 00001, "", "" ),
            new TSymLookupEntry( 0x0065ed88, 00001, "", "" ),
            new TSymLookupEntry( 0x0065ee08, 00001, "", "" ),
            new TSymLookupEntry( 0x0065fdac, 00001, "", "" ),
            new TSymLookupEntry( 0x0066003c, 00002, "", "" ),
            new TSymLookupEntry( 0x0066003f, 00001, "", "" ),
            new TSymLookupEntry( 0x00660041, 00002, "", "" ),
            new TSymLookupEntry( 0x00660049, 00001, "", "" ),
            new TSymLookupEntry( 0x0066004f, 00001, "", "" ),
            new TSymLookupEntry( 0x00660050, 00001, "", "" ),
            new TSymLookupEntry( 0x00660061, 00003, "", "" ),
            new TSymLookupEntry( 0x00660064, 00001, "", "" ),
            new TSymLookupEntry( 0x00660069, 00003, "", "" ),
            new TSymLookupEntry( 0x0066006d, 00001, "", "" ),
            new TSymLookupEntry( 0x0066006e, 00001, "", "" ),
            new TSymLookupEntry( 0x0066006f, 00011, "", "" ),
            new TSymLookupEntry( 0x00660072, 00001, "", "" ),
            new TSymLookupEntry( 0x00660074, 00001, "", "" ),
            new TSymLookupEntry( 0x00660d50, 00001, "", "" ),
            new TSymLookupEntry( 0x00661480, 00001, "", "" ),
            new TSymLookupEntry( 0x006614b8, 00001, "", "" ),
            new TSymLookupEntry( 0x00661530, 00001, "", "" ),
            new TSymLookupEntry( 0x006615e0, 00001, "", "" ),
            new TSymLookupEntry( 0x00661960, 00001, "", "" ),
            new TSymLookupEntry( 0x00661a40, 00001, "", "" ),
            new TSymLookupEntry( 0x00661a90, 00001, "", "" ),
            new TSymLookupEntry( 0x00661c68, 00001, "", "" ),
            new TSymLookupEntry( 0x00661c90, 00002, "", "" ),
            new TSymLookupEntry( 0x00662770, 00001, "", "" ),
            new TSymLookupEntry( 0x00662e58, 00001, "", "" ),
            new TSymLookupEntry( 0x00662ecc, 00001, "", "" ),
            new TSymLookupEntry( 0x00663360, 00001, "", "" ),
            new TSymLookupEntry( 0x0066397c, 00001, "", "" ),
            new TSymLookupEntry( 0x00663b5c, 00001, "", "" ),
            new TSymLookupEntry( 0x00666340, 00001, "", "" ),
            new TSymLookupEntry( 0x006663e0, 00001, "", "" ),
            new TSymLookupEntry( 0x00666498, 00001, "", "" ),
            new TSymLookupEntry( 0x00666510, 00001, "", "" ),
            new TSymLookupEntry( 0x00666630, 00001, "", "" ),
            new TSymLookupEntry( 0x00666970, 00007, "", "" ),
            new TSymLookupEntry( 0x00666fd8, 00001, "", "" ),
            new TSymLookupEntry( 0x00667000, 00003, "", "" ),
            new TSymLookupEntry( 0x00667078, 00001, "", "" ),
            new TSymLookupEntry( 0x00669cd8, 00001, "", "" ),
            new TSymLookupEntry( 0x00669f58, 00001, "", "" ),
            new TSymLookupEntry( 0x0066a4a8, 00001, "", "" ),
            new TSymLookupEntry( 0x0066a5fc, 00001, "", "" ),
            new TSymLookupEntry( 0x0066a9f8, 00001, "", "" ),
            new TSymLookupEntry( 0x0066aac8, 00003, "", "" ),
            new TSymLookupEntry( 0x0066b318, 00001, "", "" ),
            new TSymLookupEntry( 0x0066c1e0, 00001, "", "" ),
            new TSymLookupEntry( 0x0066de28, 00001, "", "" ),
            new TSymLookupEntry( 0x0066e148, 00001, "", "" ),
            new TSymLookupEntry( 0x0066e8f0, 00001, "", "" ),
            new TSymLookupEntry( 0x0066eb70, 00001, "", "" ),
            new TSymLookupEntry( 0x0066f4a0, 00001, "", "" ),
            new TSymLookupEntry( 0x0066f4f0, 00001, "", "" ),
            new TSymLookupEntry( 0x0066f540, 00001, "", "" ),
            new TSymLookupEntry( 0x0066f600, 00001, "", "" ),
            new TSymLookupEntry( 0x0066f6b8, 00001, "", "" ),
            new TSymLookupEntry( 0x0066f700, 00001, "", "" ),
            new TSymLookupEntry( 0x0066f778, 00001, "", "" ),
            new TSymLookupEntry( 0x0066f7d8, 00001, "", "" ),
            new TSymLookupEntry( 0x00670024, 00001, "", "" ),
            new TSymLookupEntry( 0x00670062, 00003, "", "" ),
            new TSymLookupEntry( 0x00670068, 00001, "", "" ),
            new TSymLookupEntry( 0x00670069, 00003, "", "" ),
            new TSymLookupEntry( 0x006703e0, 00001, "", "" ),
            new TSymLookupEntry( 0x00670440, 00010, "", "" ),
            new TSymLookupEntry( 0x00670570, 00001, "", "" ),
            new TSymLookupEntry( 0x00670858, 00001, "", "" ),
            new TSymLookupEntry( 0x00670d00, 00007, "", "" ),
            new TSymLookupEntry( 0x00671f08, 00001, "", "" ),
            new TSymLookupEntry( 0x00671fd0, 00001, "", "" ),
            new TSymLookupEntry( 0x00672140, 00007, "", "" ),
            new TSymLookupEntry( 0x00672190, 00001, "", "" ),
            new TSymLookupEntry( 0x006721e0, 00001, "", "" ),
            new TSymLookupEntry( 0x00672208, 00003, "", "" ),
            new TSymLookupEntry( 0x00672280, 00001, "", "" ),
            new TSymLookupEntry( 0x00672a08, 00001, "", "" ),
            new TSymLookupEntry( 0x00672a58, 00001, "", "" ),
            new TSymLookupEntry( 0x00672aa8, 00001, "", "" ),
            new TSymLookupEntry( 0x00672af8, 00001, "", "" ),
            new TSymLookupEntry( 0x00672b48, 00001, "", "" ),
            new TSymLookupEntry( 0x00672b98, 00001, "", "" ),
            new TSymLookupEntry( 0x00672bc8, 00001, "", "" ),
            new TSymLookupEntry( 0x00672d80, 00001, "", "" ),
            new TSymLookupEntry( 0x006732e0, 00001, "", "" ),
            new TSymLookupEntry( 0x00673e78, 00001, "", "" ),
            new TSymLookupEntry( 0x00673ef8, 00001, "", "" ),
            new TSymLookupEntry( 0x00673ff8, 00001, "", "" ),
            new TSymLookupEntry( 0x00674058, 00001, "", "" ),
            new TSymLookupEntry( 0x006740f8, 00001, "", "" ),
            new TSymLookupEntry( 0x006742d8, 00001, "", "" ),
            new TSymLookupEntry( 0x00674328, 00001, "", "" ),
            new TSymLookupEntry( 0x00674378, 00001, "", "" ),
            new TSymLookupEntry( 0x006743c8, 00001, "", "" ),
            new TSymLookupEntry( 0x00674418, 00001, "", "" ),
            new TSymLookupEntry( 0x00674468, 00001, "", "" ),
            new TSymLookupEntry( 0x006744b8, 00001, "", "" ),
            new TSymLookupEntry( 0x00674508, 00001, "", "" ),
            new TSymLookupEntry( 0x00674558, 00001, "", "" ),
            new TSymLookupEntry( 0x006745a8, 00001, "", "" ),
            new TSymLookupEntry( 0x006745f8, 00001, "", "" ),
            new TSymLookupEntry( 0x00674648, 00001, "", "" ),
            new TSymLookupEntry( 0x006746c0, 00001, "", "" ),
            new TSymLookupEntry( 0x00674710, 00001, "", "" ),
            new TSymLookupEntry( 0x00674760, 00001, "", "" ),
            new TSymLookupEntry( 0x00674800, 00001, "", "" ),
            new TSymLookupEntry( 0x00674868, 00001, "", "" ),
            new TSymLookupEntry( 0x00676b40, 00002, "", "" ),
            new TSymLookupEntry( 0x0067bf20, 00001, "", "" ),
            new TSymLookupEntry( 0x0067bf70, 00001, "", "" ),
            new TSymLookupEntry( 0x0067bfc0, 00001, "", "" ),
            new TSymLookupEntry( 0x0067c010, 00001, "", "" ),
            new TSymLookupEntry( 0x0067c060, 00001, "", "" ),
            new TSymLookupEntry( 0x0067c0b0, 00001, "", "" ),
            new TSymLookupEntry( 0x0067c128, 00001, "", "" ),
            new TSymLookupEntry( 0x0067c1a0, 00001, "", "" ),
            new TSymLookupEntry( 0x0067c218, 00001, "", "" ),
            new TSymLookupEntry( 0x0067c298, 00001, "", "" ),
            new TSymLookupEntry( 0x0067c310, 00001, "", "" ),
            new TSymLookupEntry( 0x0067c808, 00001, "", "" ),
            new TSymLookupEntry( 0x0067c858, 00001, "", "" ),
            new TSymLookupEntry( 0x0067c920, 00001, "", "" ),
            new TSymLookupEntry( 0x0067c970, 00001, "", "" ),
            new TSymLookupEntry( 0x0067c9c0, 00001, "", "" ),
            new TSymLookupEntry( 0x0067cad8, 00001, "", "" ),
            new TSymLookupEntry( 0x0067cd08, 00001, "", "" ),
            new TSymLookupEntry( 0x0067ce18, 00003, "", "" ),
            new TSymLookupEntry( 0x0067ceb8, 00001, "", "" ),
            new TSymLookupEntry( 0x0067cf08, 00002, "", "" ),
            new TSymLookupEntry( 0x0067cf30, 00001, "", "" ),
            new TSymLookupEntry( 0x0067d030, 00001, "", "" ),
            new TSymLookupEntry( 0x0067d0c8, 00001, "", "" ),
            new TSymLookupEntry( 0x0067d208, 00010, "", "" ),
            new TSymLookupEntry( 0x0067d3e0, 00002, "", "" ),
            new TSymLookupEntry( 0x0067d488, 00001, "", "" ),
            new TSymLookupEntry( 0x0067d738, 00001, "", "" ),
            new TSymLookupEntry( 0x0067d788, 00039, "", "" ),
            new TSymLookupEntry( 0x0067d8a0, 00003, "", "" ),
            new TSymLookupEntry( 0x0067d948, 00002, "", "" ),
            new TSymLookupEntry( 0x0067daf8, 00001, "", "" ),
            new TSymLookupEntry( 0x0067db40, 00002, "", "" ),
            new TSymLookupEntry( 0x0067dc98, 00001, "", "" ),
            new TSymLookupEntry( 0x0067de80, 00001, "", "" ),
            new TSymLookupEntry( 0x0067e018, 00001, "", "" ),
            new TSymLookupEntry( 0x0067e130, 00001, "", "" ),
            new TSymLookupEntry( 0x0067e760, 00005, "", "" ),
            new TSymLookupEntry( 0x0067e8d8, 00001, "", "" ),
            new TSymLookupEntry( 0x0067ebc8, 00005, "", "" ),
            new TSymLookupEntry( 0x0067ee20, 00015, "", "" ),
            new TSymLookupEntry( 0x0067f098, 00001, "", "" ),
            new TSymLookupEntry( 0x0067f6a0, 00001, "", "" ),
            new TSymLookupEntry( 0x00680031, 00001, "", "" ),
            new TSymLookupEntry( 0x0068003a, 00003, "", "" ),
            new TSymLookupEntry( 0x0068003c, 00001, "", "" ),
            new TSymLookupEntry( 0x00680043, 00009, "", "" ),
            new TSymLookupEntry( 0x00680054, 00001, "", "" ),
            new TSymLookupEntry( 0x00680063, 00032, "", "" ),
            new TSymLookupEntry( 0x00680067, 00001, "", "" ),
            new TSymLookupEntry( 0x00680068, 00001, "", "" ),
            new TSymLookupEntry( 0x00680069, 00001, "", "" ),
            new TSymLookupEntry( 0x0068006d, 00001, "", "" ),
            new TSymLookupEntry( 0x0068006f, 00001, "", "" ),
            new TSymLookupEntry( 0x00680073, 00022, "", "" ),
            new TSymLookupEntry( 0x00680074, 00003, "", "" ),
            new TSymLookupEntry( 0x00680077, 00001, "", "" ),
            new TSymLookupEntry( 0x00680078, 00002, "", "" ),
            new TSymLookupEntry( 0x006806c8, 00001, "", "" ),
            new TSymLookupEntry( 0x00680788, 00001, "", "" ),
            new TSymLookupEntry( 0x00680810, 00001, "", "" ),
            new TSymLookupEntry( 0x006808d8, 00001, "", "" ),
            new TSymLookupEntry( 0x00680a38, 00002, "", "" ),
            new TSymLookupEntry( 0x00685f70, 00001, "", "" ),
            new TSymLookupEntry( 0x00686030, 00001, "", "" ),
            new TSymLookupEntry( 0x00686058, 00001, "", "" ),
            new TSymLookupEntry( 0x00686350, 00001, "", "" ),
            new TSymLookupEntry( 0x00686378, 00001, "", "" ),
            new TSymLookupEntry( 0x006865b0, 00001, "", "" ),
            new TSymLookupEntry( 0x006865d8, 00001, "", "" ),
            new TSymLookupEntry( 0x00686600, 00001, "", "" ),
            new TSymLookupEntry( 0x00686628, 00001, "", "" ),
            new TSymLookupEntry( 0x00686650, 00001, "", "" ),
            new TSymLookupEntry( 0x00686678, 00001, "", "" ),
            new TSymLookupEntry( 0x006866a0, 00001, "", "" ),
            new TSymLookupEntry( 0x00686888, 00001, "", "" ),
            new TSymLookupEntry( 0x006868b0, 00001, "", "" ),
            new TSymLookupEntry( 0x006868d8, 00001, "", "" ),
            new TSymLookupEntry( 0x00686900, 00001, "", "" ),
            new TSymLookupEntry( 0x00686928, 00001, "", "" ),
            new TSymLookupEntry( 0x00686ae8, 00001, "", "" ),
            new TSymLookupEntry( 0x00686b10, 00001, "", "" ),
            new TSymLookupEntry( 0x00686b38, 00001, "", "" ),
            new TSymLookupEntry( 0x00686b60, 00001, "", "" ),
            new TSymLookupEntry( 0x00686b88, 00001, "", "" ),
            new TSymLookupEntry( 0x00686bb0, 00001, "", "" ),
            new TSymLookupEntry( 0x00686bd8, 00001, "", "" ),
            new TSymLookupEntry( 0x00686f38, 00001, "", "" ),
            new TSymLookupEntry( 0x00686f60, 00001, "", "" ),
            new TSymLookupEntry( 0x00686f88, 00001, "", "" ),
            new TSymLookupEntry( 0x00687050, 00001, "", "" ),
            new TSymLookupEntry( 0x00687078, 00001, "", "" ),
            new TSymLookupEntry( 0x006871e0, 00001, "", "" ),
            new TSymLookupEntry( 0x00687208, 00001, "", "" ),
            new TSymLookupEntry( 0x00687230, 00001, "", "" ),
            new TSymLookupEntry( 0x00687258, 00001, "", "" ),
            new TSymLookupEntry( 0x00687280, 00001, "", "" ),
            new TSymLookupEntry( 0x006872a8, 00001, "", "" ),
            new TSymLookupEntry( 0x006872d0, 00001, "", "" ),
            new TSymLookupEntry( 0x00687558, 00001, "", "" ),
            new TSymLookupEntry( 0x00687580, 00001, "", "" ),
            new TSymLookupEntry( 0x006875a8, 00001, "", "" ),
            new TSymLookupEntry( 0x006875d0, 00001, "", "" ),
            new TSymLookupEntry( 0x00687698, 00001, "", "" ),
            new TSymLookupEntry( 0x006876c0, 00001, "", "" ),
            new TSymLookupEntry( 0x006876e8, 00001, "", "" ),
            new TSymLookupEntry( 0x00687710, 00001, "", "" ),
            new TSymLookupEntry( 0x00687738, 00001, "", "" ),
            new TSymLookupEntry( 0x00687760, 00001, "", "" ),
            new TSymLookupEntry( 0x00687788, 00001, "", "" ),
            new TSymLookupEntry( 0x00687a88, 00001, "", "" ),
            new TSymLookupEntry( 0x00687ae8, 00001, "", "" ),
            new TSymLookupEntry( 0x00687b28, 00001, "", "" ),
            new TSymLookupEntry( 0x00687b50, 00001, "", "" ),
            new TSymLookupEntry( 0x00687b78, 00001, "", "" ),
            new TSymLookupEntry( 0x00687ba0, 00001, "", "" ),
            new TSymLookupEntry( 0x00687bc8, 00001, "", "" ),
            new TSymLookupEntry( 0x00687bf0, 00001, "", "" ),
            new TSymLookupEntry( 0x00687c18, 00001, "", "" ),
            new TSymLookupEntry( 0x00687c40, 00001, "", "" ),
            new TSymLookupEntry( 0x00687c68, 00001, "", "" ),
            new TSymLookupEntry( 0x00687d30, 00001, "", "" ),
            new TSymLookupEntry( 0x00687ef8, 00001, "", "" ),
            new TSymLookupEntry( 0x00688088, 00001, "", "" ),
            new TSymLookupEntry( 0x00688218, 00001, "", "" ),
            new TSymLookupEntry( 0x00688240, 00001, "", "" ),
            new TSymLookupEntry( 0x00688268, 00001, "", "" ),
            new TSymLookupEntry( 0x006884c8, 00001, "", "" ),
            new TSymLookupEntry( 0x006884f0, 00001, "", "" ),
            new TSymLookupEntry( 0x00688518, 00001, "", "" ),
            new TSymLookupEntry( 0x00688540, 00001, "", "" ),
            new TSymLookupEntry( 0x006887d8, 00001, "", "" ),
            new TSymLookupEntry( 0x00688800, 00001, "", "" ),
            new TSymLookupEntry( 0x00688c48, 00001, "", "" ),
            new TSymLookupEntry( 0x00688c70, 00001, "", "" ),
            new TSymLookupEntry( 0x00688fc0, 00001, "", "" ),
            new TSymLookupEntry( 0x00688fe8, 00001, "", "" ),
            new TSymLookupEntry( 0x00689408, 00001, "", "" ),
            new TSymLookupEntry( 0x00689430, 00001, "", "" ),
            new TSymLookupEntry( 0x00689458, 00001, "", "" ),
            new TSymLookupEntry( 0x006895c8, 00001, "", "" ),
            new TSymLookupEntry( 0x00689630, 00001, "", "" ),
            new TSymLookupEntry( 0x00689658, 00001, "", "" ),
            new TSymLookupEntry( 0x00689680, 00001, "", "" ),
            new TSymLookupEntry( 0x006896a8, 00001, "", "" ),
            new TSymLookupEntry( 0x006896d0, 00001, "", "" ),
            new TSymLookupEntry( 0x00689b48, 00001, "", "" ),
            new TSymLookupEntry( 0x00689b70, 00001, "", "" ),
            new TSymLookupEntry( 0x00689b98, 00001, "", "" ),
            new TSymLookupEntry( 0x00689bc0, 00001, "", "" ),
            new TSymLookupEntry( 0x00689d08, 00001, "", "" ),
            new TSymLookupEntry( 0x00689d30, 00001, "", "" ),
            new TSymLookupEntry( 0x00689df8, 00001, "", "" ),
            new TSymLookupEntry( 0x00689e20, 00001, "", "" ),
            new TSymLookupEntry( 0x00689e48, 00001, "", "" ),
            new TSymLookupEntry( 0x00689e70, 00001, "", "" ),
            new TSymLookupEntry( 0x00689e98, 00001, "", "" ),
            new TSymLookupEntry( 0x00689ec0, 00001, "", "" ),
            new TSymLookupEntry( 0x00689ee8, 00001, "", "" ),
            new TSymLookupEntry( 0x00689f10, 00001, "", "" ),
            new TSymLookupEntry( 0x00689f38, 00001, "", "" ),
            new TSymLookupEntry( 0x00689f60, 00001, "", "" ),
            new TSymLookupEntry( 0x00689f88, 00001, "", "" ),
            new TSymLookupEntry( 0x00689fb0, 00001, "", "" ),
            new TSymLookupEntry( 0x00689fd8, 00001, "", "" ),
            new TSymLookupEntry( 0x0068a000, 00001, "", "" ),
            new TSymLookupEntry( 0x0068a028, 00001, "", "" ),
            new TSymLookupEntry( 0x0068a050, 00001, "", "" ),
            new TSymLookupEntry( 0x0068a078, 00001, "", "" ),
            new TSymLookupEntry( 0x0068a140, 00001, "", "" ),
            new TSymLookupEntry( 0x0068a168, 00001, "", "" ),
            new TSymLookupEntry( 0x0068a190, 00001, "", "" ),
            new TSymLookupEntry( 0x0068a1b8, 00001, "", "" ),
            new TSymLookupEntry( 0x0068a1e0, 00001, "", "" ),
            new TSymLookupEntry( 0x0068a208, 00001, "", "" ),
            new TSymLookupEntry( 0x0068a230, 00001, "", "" ),
            new TSymLookupEntry( 0x0068a588, 00001, "", "" ),
            new TSymLookupEntry( 0x0068a5b0, 00001, "", "" ),
            new TSymLookupEntry( 0x0068a5d8, 00001, "", "" ),
            new TSymLookupEntry( 0x0068a600, 00001, "", "" ),
            new TSymLookupEntry( 0x0068a6c8, 00001, "", "" ),
            new TSymLookupEntry( 0x0068a790, 00001, "", "" ),
            new TSymLookupEntry( 0x0068a7b8, 00001, "", "" ),
            new TSymLookupEntry( 0x0068a7e0, 00001, "", "" ),
            new TSymLookupEntry( 0x0068a808, 00001, "", "" ),
            new TSymLookupEntry( 0x0068a830, 00001, "", "" ),
            new TSymLookupEntry( 0x0068a858, 00001, "", "" ),
            new TSymLookupEntry( 0x0068a880, 00001, "", "" ),
            new TSymLookupEntry( 0x0068ab38, 00001, "", "" ),
            new TSymLookupEntry( 0x0068ab60, 00001, "", "" ),
            new TSymLookupEntry( 0x0068ab88, 00001, "", "" ),
            new TSymLookupEntry( 0x0068aea0, 00013, "", "" ),
            new TSymLookupEntry( 0x0068b078, 00002, "", "" ),
            new TSymLookupEntry( 0x0068b2e0, 00001, "", "" ),
            new TSymLookupEntry( 0x0068b608, 00001, "", "" ),
            new TSymLookupEntry( 0x0068b820, 00001, "", "" ),
            new TSymLookupEntry( 0x0068bc58, 00005, "", "" ),
            new TSymLookupEntry( 0x0068bec8, 00004, "", "" ),
            new TSymLookupEntry( 0x0068c000, 00003, "", "" ),
            new TSymLookupEntry( 0x0068c0a0, 00001, "", "" ),
            new TSymLookupEntry( 0x0068c258, 00001, "", "" ),
            new TSymLookupEntry( 0x0068c468, 00001, "", "" ),
            new TSymLookupEntry( 0x0068c650, 00001, "", "" ),
            new TSymLookupEntry( 0x0068c678, 00001, "", "" ),
            new TSymLookupEntry( 0x0068ca30, 00001, "", "" ),
            new TSymLookupEntry( 0x0068cc90, 00002, "", "" ),
            new TSymLookupEntry( 0x0068cd38, 00001, "", "" ),
            new TSymLookupEntry( 0x0068cde0, 00001, "", "" ),
            new TSymLookupEntry( 0x0068ce78, 00003, "", "" ),
            new TSymLookupEntry( 0x0068cf90, 00002, "", "" ),
            new TSymLookupEntry( 0x0068d050, 00001, "", "" ),
            new TSymLookupEntry( 0x0068d118, 00001, "", "" ),
            new TSymLookupEntry( 0x0068d300, 00001, "", "" ),
            new TSymLookupEntry( 0x0068d4f8, 00001, "", "" ),
            new TSymLookupEntry( 0x0068d620, 00001, "", "" ),
            new TSymLookupEntry( 0x0068d760, 00001, "", "" ),
            new TSymLookupEntry( 0x0068d850, 00001, "", "" ),
            new TSymLookupEntry( 0x0068d8f8, 00001, "", "" ),
            new TSymLookupEntry( 0x0068d9b8, 00001, "", "" ),
            new TSymLookupEntry( 0x0068da18, 00001, "", "" ),
            new TSymLookupEntry( 0x0068dc20, 00001, "", "" ),
            new TSymLookupEntry( 0x0068dca8, 00001, "", "" ),
            new TSymLookupEntry( 0x0068dd20, 00004, "", "" ),
            new TSymLookupEntry( 0x0068ddc8, 00008, "", "" ),
            new TSymLookupEntry( 0x0068e200, 00001, "", "" ),
            new TSymLookupEntry( 0x0068e270, 00001, "", "" ),
            new TSymLookupEntry( 0x0068e2e8, 00001, "", "" ),
            new TSymLookupEntry( 0x0068e338, 00013, "", "" ),
            new TSymLookupEntry( 0x0068e880, 00001, "", "" ),
            new TSymLookupEntry( 0x0068f0c0, 00004, "", "" ),
            new TSymLookupEntry( 0x0068f4d0, 00001, "", "" ),
            new TSymLookupEntry( 0x0068f658, 00001, "", "" ),
            new TSymLookupEntry( 0x0068fb10, 00009, "", "" ),
            new TSymLookupEntry( 0x0068fcc0, 00001, "", "" ),
            new TSymLookupEntry( 0x0069002a, 00002, "", "" ),
            new TSymLookupEntry( 0x0069002e, 00004, "", "" ),
            new TSymLookupEntry( 0x0069003c, 00001, "", "" ),
            new TSymLookupEntry( 0x00690046, 00002, "", "" ),
            new TSymLookupEntry( 0x00690048, 00002, "", "" ),
            new TSymLookupEntry( 0x0069004d, 00001, "", "" ),
            new TSymLookupEntry( 0x00690052, 00002, "", "" ),
            new TSymLookupEntry( 0x00690053, 00002, "", "" ),
            new TSymLookupEntry( 0x00690056, 00003, "", "" ),
            new TSymLookupEntry( 0x00690057, 00007, "", "" ),
            new TSymLookupEntry( 0x0069005e, 00001, "", "" ),
            new TSymLookupEntry( 0x00690062, 00008, "", "" ),
            new TSymLookupEntry( 0x00690063, 00001, "", "" ),
            new TSymLookupEntry( 0x00690064, 00033, "", "" ),
            new TSymLookupEntry( 0x00690066, 00109, "", "" ),
            new TSymLookupEntry( 0x00690068, 00020, "", "" ),
            new TSymLookupEntry( 0x0069006c, 00013, "", "" ),
            new TSymLookupEntry( 0x0069006d, 00019, "", "" ),
            new TSymLookupEntry( 0x0069006e, 00001, "", "" ),
            new TSymLookupEntry( 0x0069006f, 00001, "", "" ),
            new TSymLookupEntry( 0x00690070, 00001, "", "" ),
            new TSymLookupEntry( 0x00690072, 00001, "", "" ),
            new TSymLookupEntry( 0x00690073, 00004, "", "" ),
            new TSymLookupEntry( 0x00690074, 00015, "", "" ),
            new TSymLookupEntry( 0x00690076, 00011, "", "" ),
            new TSymLookupEntry( 0x00690077, 00015, "", "" ),
            new TSymLookupEntry( 0x00690078, 00002, "", "" ),
            new TSymLookupEntry( 0x00690079, 00001, "", "" ),
            new TSymLookupEntry( 0x0069007a, 00001, "", "" ),
            new TSymLookupEntry( 0x006904f0, 00001, "", "" ),
            new TSymLookupEntry( 0x006906f8, 00001, "", "" ),
            new TSymLookupEntry( 0x00690ba0, 00025, "", "" ),
            new TSymLookupEntry( 0x00691260, 00004, "", "" ),
            new TSymLookupEntry( 0x00691810, 00004, "", "" ),
            new TSymLookupEntry( 0x00692048, 00001, "", "" ),
            new TSymLookupEntry( 0x00692110, 00003, "", "" ),
            new TSymLookupEntry( 0x006922d8, 00001, "", "" ),
            new TSymLookupEntry( 0x00692478, 00004, "", "" ),
            new TSymLookupEntry( 0x00692b40, 00007, "", "" ),
            new TSymLookupEntry( 0x00692e30, 00003, "", "" ),
            new TSymLookupEntry( 0x00693510, 00001, "", "" ),
            new TSymLookupEntry( 0x00693710, 00004, "", "" ),
            new TSymLookupEntry( 0x006937d8, 00004, "", "" ),
            new TSymLookupEntry( 0x00693be0, 00004, "", "" ),
            new TSymLookupEntry( 0x00693ca8, 00004, "", "" ),
            new TSymLookupEntry( 0x00693da0, 00001, "", "" ),
            new TSymLookupEntry( 0x006947b8, 00001, "", "" ),
            new TSymLookupEntry( 0x006947e0, 00001, "", "" ),
            new TSymLookupEntry( 0x00694808, 00001, "", "" ),
            new TSymLookupEntry( 0x00694830, 00001, "", "" ),
            new TSymLookupEntry( 0x00694858, 00001, "", "" ),
            new TSymLookupEntry( 0x00694880, 00001, "", "" ),
            new TSymLookupEntry( 0x006948a8, 00001, "", "" ),
            new TSymLookupEntry( 0x006948d0, 00001, "", "" ),
            new TSymLookupEntry( 0x00694a70, 00001, "", "" ),
            new TSymLookupEntry( 0x00695448, 00001, "", "" ),
            new TSymLookupEntry( 0x00695c08, 00001, "", "" ),
            new TSymLookupEntry( 0x006960f0, 00001, "", "" ),
            new TSymLookupEntry( 0x006962d0, 00001, "", "" ),
            new TSymLookupEntry( 0x006968e0, 00001, "", "" ),
            new TSymLookupEntry( 0x00697110, 00002, "", "" ),
            new TSymLookupEntry( 0x00697768, 00001, "", "" ),
            new TSymLookupEntry( 0x00697790, 00001, "", "" ),
            new TSymLookupEntry( 0x006977b8, 00001, "", "" ),
            new TSymLookupEntry( 0x006977e0, 00001, "", "" ),
            new TSymLookupEntry( 0x00697830, 00001, "", "" ),
            new TSymLookupEntry( 0x006978a8, 00001, "", "" ),
            new TSymLookupEntry( 0x006978f8, 00001, "", "" ),
            new TSymLookupEntry( 0x00697ae8, 00001, "", "" ),
            new TSymLookupEntry( 0x0069a130, 00001, "", "" ),
            new TSymLookupEntry( 0x0069a1d0, 00001, "", "" ),
            new TSymLookupEntry( 0x0069a580, 00003, "", "" ),
            new TSymLookupEntry( 0x0069a888, 00001, "", "" ),
            new TSymLookupEntry( 0x0069aa70, 00015, "", "" ),
            new TSymLookupEntry( 0x0069aac8, 00001, "", "" ),
            new TSymLookupEntry( 0x0069cb28, 00001, "", "" ),
            new TSymLookupEntry( 0x0069cc78, 00001, "", "" ),
            new TSymLookupEntry( 0x0069cca0, 00001, "", "" ),
            new TSymLookupEntry( 0x0069ccc8, 00001, "", "" ),
            new TSymLookupEntry( 0x0069ccf0, 00001, "", "" ),
            new TSymLookupEntry( 0x0069cd18, 00001, "", "" ),
            new TSymLookupEntry( 0x0069cd40, 00001, "", "" ),
            new TSymLookupEntry( 0x0069cd68, 00001, "", "" ),
            new TSymLookupEntry( 0x0069ce88, 00001, "", "" ),
            new TSymLookupEntry( 0x0069ceb0, 00001, "", "" ),
            new TSymLookupEntry( 0x0069ced8, 00001, "", "" ),
            new TSymLookupEntry( 0x0069cf00, 00001, "", "" ),
            new TSymLookupEntry( 0x0069cf28, 00001, "", "" ),
            new TSymLookupEntry( 0x0069cf50, 00001, "", "" ),
            new TSymLookupEntry( 0x0069cf78, 00001, "", "" ),
            new TSymLookupEntry( 0x0069cfa0, 00001, "", "" ),
            new TSymLookupEntry( 0x0069d2b8, 00001, "", "" ),
            new TSymLookupEntry( 0x0069d380, 00001, "", "" ),
            new TSymLookupEntry( 0x0069d568, 00001, "", "" ),
            new TSymLookupEntry( 0x0069d630, 00001, "", "" ),
            new TSymLookupEntry( 0x0069d818, 00001, "", "" ),
            new TSymLookupEntry( 0x0069d8e0, 00001, "", "" ),
            new TSymLookupEntry( 0x0069d908, 00001, "", "" ),
            new TSymLookupEntry( 0x0069d930, 00001, "", "" ),
            new TSymLookupEntry( 0x0069d958, 00001, "", "" ),
            new TSymLookupEntry( 0x0069d980, 00001, "", "" ),
            new TSymLookupEntry( 0x0069d9a8, 00001, "", "" ),
            new TSymLookupEntry( 0x0069d9d0, 00001, "", "" ),
            new TSymLookupEntry( 0x0069de60, 00001, "", "" ),
            new TSymLookupEntry( 0x0069de88, 00001, "", "" ),
            new TSymLookupEntry( 0x0069deb0, 00001, "", "" ),
            new TSymLookupEntry( 0x0069ded8, 00001, "", "" ),
            new TSymLookupEntry( 0x0069df00, 00001, "", "" ),
            new TSymLookupEntry( 0x0069df28, 00001, "", "" ),
            new TSymLookupEntry( 0x0069df50, 00001, "", "" ),
            new TSymLookupEntry( 0x0069df78, 00001, "", "" ),
            new TSymLookupEntry( 0x0069dfa0, 00001, "", "" ),
            new TSymLookupEntry( 0x0069dfc8, 00001, "", "" ),
            new TSymLookupEntry( 0x0069e000, 00001, "", "" ),
            new TSymLookupEntry( 0x0069e028, 00001, "", "" ),
            new TSymLookupEntry( 0x0069e050, 00001, "", "" ),
            new TSymLookupEntry( 0x0069e0f0, 00001, "", "" ),
            new TSymLookupEntry( 0x0069e118, 00001, "", "" ),
            new TSymLookupEntry( 0x0069e140, 00001, "", "" ),
            new TSymLookupEntry( 0x0069e2d8, 00001, "", "" ),
            new TSymLookupEntry( 0x0069e300, 00001, "", "" ),
            new TSymLookupEntry( 0x0069e328, 00001, "", "" ),
            new TSymLookupEntry( 0x0069e350, 00001, "", "" ),
            new TSymLookupEntry( 0x0069e378, 00001, "", "" ),
            new TSymLookupEntry( 0x0069e3a0, 00001, "", "" ),
            new TSymLookupEntry( 0x0069e3c8, 00001, "", "" ),
            new TSymLookupEntry( 0x0069e690, 00001, "", "" ),
            new TSymLookupEntry( 0x0069e6b8, 00001, "", "" ),
            new TSymLookupEntry( 0x0069e6e0, 00001, "", "" ),
            new TSymLookupEntry( 0x0069e7d0, 00001, "", "" ),
            new TSymLookupEntry( 0x0069e7f8, 00001, "", "" ),
            new TSymLookupEntry( 0x0069e8c0, 00001, "", "" ),
            new TSymLookupEntry( 0x0069e8e8, 00001, "", "" ),
            new TSymLookupEntry( 0x0069eb70, 00001, "", "" ),
            new TSymLookupEntry( 0x0069eb98, 00001, "", "" ),
            new TSymLookupEntry( 0x0069ebc0, 00001, "", "" ),
            new TSymLookupEntry( 0x0069ebe8, 00001, "", "" ),
            new TSymLookupEntry( 0x0069ee98, 00001, "", "" ),
            new TSymLookupEntry( 0x0069eec0, 00001, "", "" ),
            new TSymLookupEntry( 0x0069eee8, 00001, "", "" ),
            new TSymLookupEntry( 0x0069f188, 00001, "", "" ),
            new TSymLookupEntry( 0x0069f1b0, 00001, "", "" ),
            new TSymLookupEntry( 0x0069f1d8, 00001, "", "" ),
            new TSymLookupEntry( 0x0069f200, 00001, "", "" ),
            new TSymLookupEntry( 0x0069f438, 00001, "", "" ),
            new TSymLookupEntry( 0x0069f460, 00001, "", "" ),
            new TSymLookupEntry( 0x0069f488, 00001, "", "" ),
            new TSymLookupEntry( 0x0069f4b0, 00001, "", "" ),
            new TSymLookupEntry( 0x0069f670, 00001, "", "" ),
            new TSymLookupEntry( 0x0069f698, 00001, "", "" ),
            new TSymLookupEntry( 0x0069f6c0, 00001, "", "" ),
            new TSymLookupEntry( 0x0069f6e8, 00001, "", "" ),
            new TSymLookupEntry( 0x0069f710, 00001, "", "" ),
            new TSymLookupEntry( 0x0069f738, 00001, "", "" ),
            new TSymLookupEntry( 0x0069f760, 00001, "", "" ),
            new TSymLookupEntry( 0x0069f7e0, 00001, "", "" ),
            new TSymLookupEntry( 0x0069fa60, 00001, "", "" ),
            new TSymLookupEntry( 0x0069fa88, 00001, "", "" ),
            new TSymLookupEntry( 0x0069fab0, 00001, "", "" ),
            new TSymLookupEntry( 0x0069fad8, 00001, "", "" ),
            new TSymLookupEntry( 0x0069fe90, 00001, "", "" ),
            new TSymLookupEntry( 0x0069ff58, 00001, "", "" ),
            new TSymLookupEntry( 0x0069ff80, 00001, "", "" ),
            new TSymLookupEntry( 0x0069ffa8, 00001, "", "" ),
            new TSymLookupEntry( 0x0069ffd0, 00001, "", "" ),
            new TSymLookupEntry( 0x0069fff8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0001, 00004, "", "" ),
            new TSymLookupEntry( 0x006a0020, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0048, 00001, "", "" ),
            new TSymLookupEntry( 0x006a005f, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0061, 00013, "", "" ),
            new TSymLookupEntry( 0x006a0470, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0498, 00001, "", "" ),
            new TSymLookupEntry( 0x006a04e8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0510, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0538, 00001, "", "" ),
            new TSymLookupEntry( 0x006a06b0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a06d8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0700, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0728, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0750, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0778, 00001, "", "" ),
            new TSymLookupEntry( 0x006a07a0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a09d8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0a00, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0a50, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0a78, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0c18, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0c40, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0c68, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0c90, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0cb8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0ce0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0da8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0dd0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0df8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0e20, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0e48, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0e70, 00001, "", "" ),
            new TSymLookupEntry( 0x006a0e98, 00001, "", "" ),
            new TSymLookupEntry( 0x006a11b8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a11e0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a1208, 00001, "", "" ),
            new TSymLookupEntry( 0x006a1388, 00001, "", "" ),
            new TSymLookupEntry( 0x006a13b0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a13d8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a1400, 00001, "", "" ),
            new TSymLookupEntry( 0x006a1428, 00001, "", "" ),
            new TSymLookupEntry( 0x006a1450, 00001, "", "" ),
            new TSymLookupEntry( 0x006a1478, 00001, "", "" ),
            new TSymLookupEntry( 0x006a1700, 00001, "", "" ),
            new TSymLookupEntry( 0x006a1728, 00001, "", "" ),
            new TSymLookupEntry( 0x006a1750, 00001, "", "" ),
            new TSymLookupEntry( 0x006a1830, 00001, "", "" ),
            new TSymLookupEntry( 0x006a18f8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a1920, 00001, "", "" ),
            new TSymLookupEntry( 0x006a1948, 00001, "", "" ),
            new TSymLookupEntry( 0x006a1970, 00001, "", "" ),
            new TSymLookupEntry( 0x006a1998, 00001, "", "" ),
            new TSymLookupEntry( 0x006a19c0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a19e8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a1c70, 00001, "", "" ),
            new TSymLookupEntry( 0x006a1c98, 00001, "", "" ),
            new TSymLookupEntry( 0x006a1cc0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a1da0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a1e68, 00001, "", "" ),
            new TSymLookupEntry( 0x006a1e90, 00001, "", "" ),
            new TSymLookupEntry( 0x006a1eb8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a1ee0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a1f08, 00001, "", "" ),
            new TSymLookupEntry( 0x006a1f30, 00001, "", "" ),
            new TSymLookupEntry( 0x006a2050, 00001, "", "" ),
            new TSymLookupEntry( 0x006a2078, 00001, "", "" ),
            new TSymLookupEntry( 0x006a20a0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a20c8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a20f0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a2118, 00001, "", "" ),
            new TSymLookupEntry( 0x006a2140, 00001, "", "" ),
            new TSymLookupEntry( 0x006a2468, 00001, "", "" ),
            new TSymLookupEntry( 0x006a2490, 00001, "", "" ),
            new TSymLookupEntry( 0x006a24b8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a2638, 00001, "", "" ),
            new TSymLookupEntry( 0x006a29d8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a2a00, 00001, "", "" ),
            new TSymLookupEntry( 0x006a2a28, 00001, "", "" ),
            new TSymLookupEntry( 0x006a2b08, 00001, "", "" ),
            new TSymLookupEntry( 0x006a2b30, 00001, "", "" ),
            new TSymLookupEntry( 0x006a2b58, 00001, "", "" ),
            new TSymLookupEntry( 0x006a2d80, 00001, "", "" ),
            new TSymLookupEntry( 0x006a2da8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a2dd0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a2df8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a2e20, 00001, "", "" ),
            new TSymLookupEntry( 0x006a2e48, 00001, "", "" ),
            new TSymLookupEntry( 0x006a2e70, 00001, "", "" ),
            new TSymLookupEntry( 0x006a2ff0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a3018, 00001, "", "" ),
            new TSymLookupEntry( 0x006a30f8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a3120, 00001, "", "" ),
            new TSymLookupEntry( 0x006a31e8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a3210, 00001, "", "" ),
            new TSymLookupEntry( 0x006a3498, 00001, "", "" ),
            new TSymLookupEntry( 0x006a34c0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a34e8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a3510, 00001, "", "" ),
            new TSymLookupEntry( 0x006a3538, 00001, "", "" ),
            new TSymLookupEntry( 0x006a3560, 00001, "", "" ),
            new TSymLookupEntry( 0x006a36d0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a36f8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a3720, 00001, "", "" ),
            new TSymLookupEntry( 0x006a3748, 00001, "", "" ),
            new TSymLookupEntry( 0x006a3770, 00001, "", "" ),
            new TSymLookupEntry( 0x006a3798, 00001, "", "" ),
            new TSymLookupEntry( 0x006a37c0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a3b70, 00001, "", "" ),
            new TSymLookupEntry( 0x006a3b98, 00001, "", "" ),
            new TSymLookupEntry( 0x006a3be8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a3c10, 00001, "", "" ),
            new TSymLookupEntry( 0x006a3c38, 00001, "", "" ),
            new TSymLookupEntry( 0x006a3db0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a3dd8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a3e00, 00001, "", "" ),
            new TSymLookupEntry( 0x006a3e28, 00001, "", "" ),
            new TSymLookupEntry( 0x006a3e50, 00001, "", "" ),
            new TSymLookupEntry( 0x006a3e78, 00001, "", "" ),
            new TSymLookupEntry( 0x006a3ea0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a4330, 00001, "", "" ),
            new TSymLookupEntry( 0x006a4358, 00001, "", "" ),
            new TSymLookupEntry( 0x006a43c0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a43e8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a4410, 00001, "", "" ),
            new TSymLookupEntry( 0x006a4588, 00001, "", "" ),
            new TSymLookupEntry( 0x006a45b0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a45d8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a4600, 00001, "", "" ),
            new TSymLookupEntry( 0x006a4628, 00001, "", "" ),
            new TSymLookupEntry( 0x006a4650, 00001, "", "" ),
            new TSymLookupEntry( 0x006a4678, 00001, "", "" ),
            new TSymLookupEntry( 0x006a49c8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a49f0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a4a18, 00001, "", "" ),
            new TSymLookupEntry( 0x006a4a40, 00001, "", "" ),
            new TSymLookupEntry( 0x006a4a68, 00001, "", "" ),
            new TSymLookupEntry( 0x006a4a90, 00001, "", "" ),
            new TSymLookupEntry( 0x006a4ab8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a4d50, 00001, "", "" ),
            new TSymLookupEntry( 0x006a4d78, 00001, "", "" ),
            new TSymLookupEntry( 0x006a4dc8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a4f90, 00001, "", "" ),
            new TSymLookupEntry( 0x006a4fb8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a4fe0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a5008, 00001, "", "" ),
            new TSymLookupEntry( 0x006a5030, 00001, "", "" ),
            new TSymLookupEntry( 0x006a5058, 00001, "", "" ),
            new TSymLookupEntry( 0x006a5080, 00001, "", "" ),
            new TSymLookupEntry( 0x006a5528, 00001, "", "" ),
            new TSymLookupEntry( 0x006a5590, 00001, "", "" ),
            new TSymLookupEntry( 0x006a55b8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a55e0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a5608, 00001, "", "" ),
            new TSymLookupEntry( 0x006a5780, 00001, "", "" ),
            new TSymLookupEntry( 0x006a6b30, 00001, "", "" ),
            new TSymLookupEntry( 0x006a6b58, 00001, "", "" ),
            new TSymLookupEntry( 0x006a6b80, 00001, "", "" ),
            new TSymLookupEntry( 0x006a6ba8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a6bd0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a6bf8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a6c20, 00001, "", "" ),
            new TSymLookupEntry( 0x006a6d40, 00001, "", "" ),
            new TSymLookupEntry( 0x006a6d68, 00001, "", "" ),
            new TSymLookupEntry( 0x006a6dc0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a6de8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a6f88, 00001, "", "" ),
            new TSymLookupEntry( 0x006a6fb0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a6fd8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a7000, 00001, "", "" ),
            new TSymLookupEntry( 0x006a7028, 00001, "", "" ),
            new TSymLookupEntry( 0x006a7050, 00001, "", "" ),
            new TSymLookupEntry( 0x006a7078, 00001, "", "" ),
            new TSymLookupEntry( 0x006a74d0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a74f8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a7550, 00001, "", "" ),
            new TSymLookupEntry( 0x006a7578, 00001, "", "" ),
            new TSymLookupEntry( 0x006a7718, 00001, "", "" ),
            new TSymLookupEntry( 0x006a7740, 00001, "", "" ),
            new TSymLookupEntry( 0x006a7768, 00001, "", "" ),
            new TSymLookupEntry( 0x006a7790, 00001, "", "" ),
            new TSymLookupEntry( 0x006a77b8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a77e0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a7b48, 00001, "", "" ),
            new TSymLookupEntry( 0x006a7b70, 00001, "", "" ),
            new TSymLookupEntry( 0x006a7b98, 00001, "", "" ),
            new TSymLookupEntry( 0x006a7bc0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a7be8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a7c10, 00001, "", "" ),
            new TSymLookupEntry( 0x006a7c38, 00001, "", "" ),
            new TSymLookupEntry( 0x006a7e98, 00001, "", "" ),
            new TSymLookupEntry( 0x006a7ec0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a7f10, 00001, "", "" ),
            new TSymLookupEntry( 0x006a8000, 00001, "", "" ),
            new TSymLookupEntry( 0x006a80d8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a8100, 00001, "", "" ),
            new TSymLookupEntry( 0x006a8128, 00001, "", "" ),
            new TSymLookupEntry( 0x006a8150, 00001, "", "" ),
            new TSymLookupEntry( 0x006a8178, 00001, "", "" ),
            new TSymLookupEntry( 0x006a81a0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a81c8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a8670, 00001, "", "" ),
            new TSymLookupEntry( 0x006a86d8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a8700, 00001, "", "" ),
            new TSymLookupEntry( 0x006a8728, 00001, "", "" ),
            new TSymLookupEntry( 0x006a8750, 00001, "", "" ),
            new TSymLookupEntry( 0x006a88c8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a88f0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a8918, 00001, "", "" ),
            new TSymLookupEntry( 0x006a8940, 00001, "", "" ),
            new TSymLookupEntry( 0x006a8968, 00001, "", "" ),
            new TSymLookupEntry( 0x006a8990, 00001, "", "" ),
            new TSymLookupEntry( 0x006a89b8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a8e48, 00001, "", "" ),
            new TSymLookupEntry( 0x006a8e70, 00001, "", "" ),
            new TSymLookupEntry( 0x006a8ed8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a8f00, 00001, "", "" ),
            new TSymLookupEntry( 0x006a8f28, 00001, "", "" ),
            new TSymLookupEntry( 0x006a9118, 00001, "", "" ),
            new TSymLookupEntry( 0x006a9140, 00001, "", "" ),
            new TSymLookupEntry( 0x006a9168, 00001, "", "" ),
            new TSymLookupEntry( 0x006a9190, 00001, "", "" ),
            new TSymLookupEntry( 0x006a91b8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a91e0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a9208, 00001, "", "" ),
            new TSymLookupEntry( 0x006a9a50, 00001, "", "" ),
            new TSymLookupEntry( 0x006a9a78, 00001, "", "" ),
            new TSymLookupEntry( 0x006a9aa0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a9ac8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a9af0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a9b18, 00001, "", "" ),
            new TSymLookupEntry( 0x006a9b40, 00001, "", "" ),
            new TSymLookupEntry( 0x006a9b68, 00001, "", "" ),
            new TSymLookupEntry( 0x006a9b90, 00001, "", "" ),
            new TSymLookupEntry( 0x006a9bb8, 00001, "", "" ),
            new TSymLookupEntry( 0x006a9be0, 00001, "", "" ),
            new TSymLookupEntry( 0x006a9c08, 00001, "", "" ),
            new TSymLookupEntry( 0x006aa100, 00001, "", "" ),
            new TSymLookupEntry( 0x006aa340, 00001, "", "" ),
            new TSymLookupEntry( 0x006ac388, 00001, "", "" ),
            new TSymLookupEntry( 0x006aced0, 00001, "", "" ),
            new TSymLookupEntry( 0x006ad040, 00001, "", "" ),
            new TSymLookupEntry( 0x006ad1b0, 00001, "", "" ),
            new TSymLookupEntry( 0x006ad998, 00001, "", "" ),
            new TSymLookupEntry( 0x006ae610, 00001, "", "" ),
            new TSymLookupEntry( 0x006aefb0, 00001, "", "" ),
            new TSymLookupEntry( 0x006af230, 00001, "", "" ),
            new TSymLookupEntry( 0x006af9e0, 00001, "", "" ),
            new TSymLookupEntry( 0x006aff50, 00001, "", "" ),
            new TSymLookupEntry( 0x006b002d, 00001, "", "" ),
            new TSymLookupEntry( 0x006b0062, 00001, "", "" ),
            new TSymLookupEntry( 0x006b006b, 00001, "", "" ),
            new TSymLookupEntry( 0x006b0075, 00001, "", "" ),
            new TSymLookupEntry( 0x006b0076, 00001, "", "" ),
            new TSymLookupEntry( 0x006b0078, 00002, "", "" ),
            new TSymLookupEntry( 0x006b0b48, 00001, "", "" ),
            new TSymLookupEntry( 0x006b1030, 00001, "", "" ),
            new TSymLookupEntry( 0x006b1430, 00001, "", "" ),
            new TSymLookupEntry( 0x006b2030, 00001, "", "" ),
            new TSymLookupEntry( 0x006b2f68, 00001, "", "" ),
            new TSymLookupEntry( 0x006b4090, 00001, "", "" ),
            new TSymLookupEntry( 0x006b4788, 00001, "", "" ),
            new TSymLookupEntry( 0x006b4c40, 00001, "", "" ),
            new TSymLookupEntry( 0x006b55e0, 00001, "", "" ),
            new TSymLookupEntry( 0x006b5e50, 00001, "", "" ),
            new TSymLookupEntry( 0x006b6558, 00001, "", "" ),
            new TSymLookupEntry( 0x006b7120, 00001, "", "" ),
            new TSymLookupEntry( 0x006b7398, 00001, "", "" ),
            new TSymLookupEntry( 0x006b81d8, 00001, "", "" ),
            new TSymLookupEntry( 0x006b8d18, 00001, "", "" ),
            new TSymLookupEntry( 0x006b8d68, 00001, "", "" ),
            new TSymLookupEntry( 0x006b9758, 00001, "", "" ),
            new TSymLookupEntry( 0x006b9e90, 00001, "", "" ),
            new TSymLookupEntry( 0x006bae90, 00001, "", "" ),
            new TSymLookupEntry( 0x006bc438, 00001, "", "" ),
            new TSymLookupEntry( 0x006bcd20, 00001, "", "" ),
            new TSymLookupEntry( 0x006bd0c0, 00001, "", "" ),
            new TSymLookupEntry( 0x006bdf98, 00001, "", "" ),
            new TSymLookupEntry( 0x006be940, 00001, "", "" ),
            new TSymLookupEntry( 0x006c0026, 00001, "", "" ),
            new TSymLookupEntry( 0x006c0031, 00001, "", "" ),
            new TSymLookupEntry( 0x006c0032, 00001, "", "" ),
            new TSymLookupEntry( 0x006c0033, 00001, "", "" ),
            new TSymLookupEntry( 0x006c0034, 00001, "", "" ),
            new TSymLookupEntry( 0x006c0035, 00001, "", "" ),
            new TSymLookupEntry( 0x006c003c, 00001, "", "" ),
            new TSymLookupEntry( 0x006c0041, 00002, "", "" ),
            new TSymLookupEntry( 0x006c0042, 00003, "", "" ),
            new TSymLookupEntry( 0x006c0050, 00002, "", "" ),
            new TSymLookupEntry( 0x006c005f, 00001, "", "" ),
            new TSymLookupEntry( 0x006c0061, 00008, "", "" ),
            new TSymLookupEntry( 0x006c0062, 00010, "", "" ),
            new TSymLookupEntry( 0x006c0063, 00034, "", "" ),
            new TSymLookupEntry( 0x006c0064, 00001, "", "" ),
            new TSymLookupEntry( 0x006c0065, 00004, "", "" ),
            new TSymLookupEntry( 0x006c0066, 00005, "", "" ),
            new TSymLookupEntry( 0x006c0067, 00002, "", "" ),
            new TSymLookupEntry( 0x006c006f, 00008, "", "" ),
            new TSymLookupEntry( 0x006c0070, 00007, "", "" ),
            new TSymLookupEntry( 0x006c0072, 00001, "", "" ),
            new TSymLookupEntry( 0x006c0073, 00005, "", "" ),
            new TSymLookupEntry( 0x006c0074, 00001, "", "" ),
            new TSymLookupEntry( 0x006c0075, 00001, "", "" ),
            new TSymLookupEntry( 0x006c0076, 00001, "", "" ),
            new TSymLookupEntry( 0x006c00b8, 00001, "", "" ),
            new TSymLookupEntry( 0x006c0778, 00001, "", "" ),
            new TSymLookupEntry( 0x006c0830, 00001, "", "" ),
            new TSymLookupEntry( 0x006c0a18, 00001, "", "" ),
            new TSymLookupEntry( 0x006c0af0, 00001, "", "" ),
            new TSymLookupEntry( 0x006c0e58, 00001, "", "" ),
            new TSymLookupEntry( 0x006c1468, 00001, "", "" ),
            new TSymLookupEntry( 0x006c14f4, 00001, "", "" ),
            new TSymLookupEntry( 0x006c1760, 00001, "", "" ),
            new TSymLookupEntry( 0x006c18d0, 00001, "", "" ),
            new TSymLookupEntry( 0x006c1a18, 00001, "", "" ),
            new TSymLookupEntry( 0x006c1b60, 00001, "", "" ),
            new TSymLookupEntry( 0x006c1d08, 00001, "", "" ),
            new TSymLookupEntry( 0x006c1e78, 00001, "", "" ),
            new TSymLookupEntry( 0x006c1fc0, 00001, "", "" ),
            new TSymLookupEntry( 0x006c2108, 00001, "", "" ),
            new TSymLookupEntry( 0x006c2278, 00001, "", "" ),
            new TSymLookupEntry( 0x006c2478, 00001, "", "" ),
            new TSymLookupEntry( 0x006c2660, 00001, "", "" ),
            new TSymLookupEntry( 0x006c27a8, 00001, "", "" ),
            new TSymLookupEntry( 0x006c2968, 00001, "", "" ),
            new TSymLookupEntry( 0x006c2c68, 00001, "", "" ),
            new TSymLookupEntry( 0x006c2e08, 00001, "", "" ),
            new TSymLookupEntry( 0x006c2e80, 00001, "", "" ),
            new TSymLookupEntry( 0x006c3110, 00001, "", "" ),
            new TSymLookupEntry( 0x006c32e0, 00001, "", "" ),
            new TSymLookupEntry( 0x006c3428, 00001, "", "" ),
            new TSymLookupEntry( 0x006c3570, 00001, "", "" ),
            new TSymLookupEntry( 0x006c3718, 00001, "", "" ),
            new TSymLookupEntry( 0x006c3900, 00001, "", "" ),
            new TSymLookupEntry( 0x006c3a88, 00001, "", "" ),
            new TSymLookupEntry( 0x006c3c20, 00001, "", "" ),
            new TSymLookupEntry( 0x006c3ea8, 00001, "", "" ),
            new TSymLookupEntry( 0x006c4040, 00001, "", "" ),
            new TSymLookupEntry( 0x006c4328, 00001, "", "" ),
            new TSymLookupEntry( 0x006c4560, 00001, "", "" ),
            new TSymLookupEntry( 0x006c4798, 00001, "", "" ),
            new TSymLookupEntry( 0x006c49f8, 00001, "", "" ),
            new TSymLookupEntry( 0x006c4be0, 00001, "", "" ),
            new TSymLookupEntry( 0x006c4f58, 00001, "", "" ),
            new TSymLookupEntry( 0x006c50f8, 00001, "", "" ),
            new TSymLookupEntry( 0x006c5358, 00001, "", "" ),
            new TSymLookupEntry( 0x006c55b8, 00001, "", "" ),
            new TSymLookupEntry( 0x006c5980, 00001, "", "" ),
            new TSymLookupEntry( 0x006c5af0, 00001, "", "" ),
            new TSymLookupEntry( 0x006c5c38, 00001, "", "" ),
            new TSymLookupEntry( 0x006c5d80, 00001, "", "" ),
            new TSymLookupEntry( 0x006c5fd8, 00001, "", "" ),
            new TSymLookupEntry( 0x006c6208, 00001, "", "" ),
            new TSymLookupEntry( 0x006c6378, 00001, "", "" ),
            new TSymLookupEntry( 0x006c6508, 00001, "", "" ),
            new TSymLookupEntry( 0x006c6650, 00001, "", "" ),
            new TSymLookupEntry( 0x006c67f8, 00001, "", "" ),
            new TSymLookupEntry( 0x006c6968, 00001, "", "" ),
            new TSymLookupEntry( 0x006c6ab0, 00001, "", "" ),
            new TSymLookupEntry( 0x006c6c50, 00001, "", "" ),
            new TSymLookupEntry( 0x006c6e48, 00001, "", "" ),
            new TSymLookupEntry( 0x006c6ff0, 00001, "", "" ),
            new TSymLookupEntry( 0x006c7173, 00002, "", "" ),
            new TSymLookupEntry( 0x006c71e8, 00001, "", "" ),
            new TSymLookupEntry( 0x006c7275, 00002, "", "" ),
            new TSymLookupEntry( 0x006c7570, 00001, "", "" ),
            new TSymLookupEntry( 0x006c76e0, 00001, "", "" ),
            new TSymLookupEntry( 0x006c7ab8, 00001, "", "" ),
            new TSymLookupEntry( 0x006c7dd0, 00001, "", "" ),
            new TSymLookupEntry( 0x006c8580, 00001, "", "" ),
            new TSymLookupEntry( 0x006c8bf0, 00001, "", "" ),
            new TSymLookupEntry( 0x006c8e70, 00001, "", "" ),
            new TSymLookupEntry( 0x006c9258, 00004, "", "" ),
            new TSymLookupEntry( 0x006c9288, 00001, "", "" ),
            new TSymLookupEntry( 0x006c9d98, 00001, "", "" ),
            new TSymLookupEntry( 0x006caa28, 00001, "", "" ),
            new TSymLookupEntry( 0x006cc158, 00001, "", "" ),
            new TSymLookupEntry( 0x006ccb38, 00001, "", "" ),
            new TSymLookupEntry( 0x006ccfa0, 00001, "", "" ),
            new TSymLookupEntry( 0x006ce190, 00001, "", "" ),
            new TSymLookupEntry( 0x006ceca0, 00001, "", "" ),
            new TSymLookupEntry( 0x006cf3d8, 00001, "", "" ),
            new TSymLookupEntry( 0x006cf8c8, 00003, "", "" ),
            new TSymLookupEntry( 0x006d0023, 00004, "", "" ),
            new TSymLookupEntry( 0x006d0026, 00001, "", "" ),
            new TSymLookupEntry( 0x006d0041, 00001, "", "" ),
            new TSymLookupEntry( 0x006d0065, 00005, "", "" ),
            new TSymLookupEntry( 0x006d0069, 00077, "", "" ),
            new TSymLookupEntry( 0x006d006d, 00001, "", "" ),
            new TSymLookupEntry( 0x006d0073, 00002, "", "" ),
            new TSymLookupEntry( 0x006d0074, 00001, "", "" ),
            new TSymLookupEntry( 0x006d0077, 00001, "", "" ),
            new TSymLookupEntry( 0x006d0078, 00006, "", "" ),
            new TSymLookupEntry( 0x006d0360, 00001, "", "" ),
            new TSymLookupEntry( 0x006d1018, 00001, "", "" ),
            new TSymLookupEntry( 0x006d2d48, 00001, "", "" ),
            new TSymLookupEntry( 0x006d30c0, 00002, "", "" ),
            new TSymLookupEntry( 0x006d3a50, 00001, "", "" ),
            new TSymLookupEntry( 0x006d3e98, 00001, "", "" ),
            new TSymLookupEntry( 0x006d4538, 00001, "", "" ),
            new TSymLookupEntry( 0x006d4950, 00001, "", "" ),
            new TSymLookupEntry( 0x006d4f20, 00001, "", "" ),
            new TSymLookupEntry( 0x006d51d0, 00002, "", "" ),
            new TSymLookupEntry( 0x006d5368, 00001, "", "" ),
            new TSymLookupEntry( 0x006d5b40, 00006, "", "" ),
            new TSymLookupEntry( 0x006d61e0, 00001, "", "" ),
            new TSymLookupEntry( 0x006d6af8, 00001, "", "" ),
            new TSymLookupEntry( 0x006d6e90, 00001, "", "" ),
            new TSymLookupEntry( 0x006d7578, 00001, "", "" ),
            new TSymLookupEntry( 0x006d8000, 00001, "", "" ),
            new TSymLookupEntry( 0x006d8c90, 00001, "", "" ),
            new TSymLookupEntry( 0x006d8e78, 00001, "", "" ),
            new TSymLookupEntry( 0x006d9a08, 00001, "", "" ),
            new TSymLookupEntry( 0x006da410, 00001, "", "" ),
            new TSymLookupEntry( 0x006db0b8, 00001, "", "" ),
            new TSymLookupEntry( 0x006db938, 00001, "", "" ),
            new TSymLookupEntry( 0x006dc420, 00001, "", "" ),
            new TSymLookupEntry( 0x006dd2d8, 00001, "", "" ),
            new TSymLookupEntry( 0x006de120, 00001, "", "" ),
            new TSymLookupEntry( 0x006df7e8, 00001, "", "" ),
            new TSymLookupEntry( 0x006dfd60, 00001, "", "" ),
            new TSymLookupEntry( 0x006dff40, 00002, "", "" ),
            new TSymLookupEntry( 0x006e000a, 00001, "", "" ),
            new TSymLookupEntry( 0x006e0023, 00002, "", "" ),
            new TSymLookupEntry( 0x006e0026, 00001, "", "" ),
            new TSymLookupEntry( 0x006e002e, 00002, "", "" ),
            new TSymLookupEntry( 0x006e002f, 00003, "", "" ),
            new TSymLookupEntry( 0x006e0030, 00001, "", "" ),
            new TSymLookupEntry( 0x006e0032, 00003, "", "" ),
            new TSymLookupEntry( 0x006e003d, 00001, "", "" ),
            new TSymLookupEntry( 0x006e0041, 00002, "", "" ),
            new TSymLookupEntry( 0x006e0049, 00001, "", "" ),
            new TSymLookupEntry( 0x006e0055, 00001, "", "" ),
            new TSymLookupEntry( 0x006e005c, 00001, "", "" ),
            new TSymLookupEntry( 0x006e0061, 00006, "", "" ),
            new TSymLookupEntry( 0x006e0062, 00001, "", "" ),
            new TSymLookupEntry( 0x006e0063, 00001, "", "" ),
            new TSymLookupEntry( 0x006e0064, 00001, "", "" ),
            new TSymLookupEntry( 0x006e0065, 00008, "", "" ),
            new TSymLookupEntry( 0x006e0066, 00004, "", "" ),
            new TSymLookupEntry( 0x006e0069, 00024, "", "" ),
            new TSymLookupEntry( 0x006e006d, 00002, "", "" ),
            new TSymLookupEntry( 0x006e006f, 00061, "", "" ),
            new TSymLookupEntry( 0x006e0075, 00011, "", "" ),
            new TSymLookupEntry( 0x006e0079, 00001, "", "" ),
            new TSymLookupEntry( 0x006e007b, 00001, "", "" ),
            new TSymLookupEntry( 0x006e0610, 00001, "", "" ),
            new TSymLookupEntry( 0x006e0a28, 00001, "", "" ),
            new TSymLookupEntry( 0x006e1408, 00001, "", "" ),
            new TSymLookupEntry( 0x006e2130, 00001, "", "" ),
            new TSymLookupEntry( 0x006e35d8, 00001, "", "" ),
            new TSymLookupEntry( 0x006e54b8, 00001, "", "" ),
            new TSymLookupEntry( 0x006e60b0, 00005, "", "" ),
            new TSymLookupEntry( 0x006e8000, 00001, "", "" ),
            new TSymLookupEntry( 0x006e9050, 00001, "", "" ),
            new TSymLookupEntry( 0x006e9e00, 00001, "", "" ),
            new TSymLookupEntry( 0x006ea8fc, 00001, "", "" ),
            new TSymLookupEntry( 0x006eaa78, 00001, "", "" ),
            new TSymLookupEntry( 0x006eae58, 00001, "", "" ),
            new TSymLookupEntry( 0x006eb2c8, 00001, "", "" ),
            new TSymLookupEntry( 0x006ec210, 00001, "", "" ),
            new TSymLookupEntry( 0x006ec488, 00001, "", "" ),
            new TSymLookupEntry( 0x006ed8e0, 00001, "", "" ),
            new TSymLookupEntry( 0x006ee0d8, 00001, "", "" ),
            new TSymLookupEntry( 0x006ee338, 00001, "", "" ),
            new TSymLookupEntry( 0x006ee6d0, 00001, "", "" ),
            new TSymLookupEntry( 0x006ee720, 00001, "", "" ),
            new TSymLookupEntry( 0x006ef9f8, 00001, "", "" ),
            new TSymLookupEntry( 0x006efa98, 00007, "", "" ),
            new TSymLookupEntry( 0x006f0000, 00001, "", "" ),
            new TSymLookupEntry( 0x006f0021, 00001, "", "" ),
            new TSymLookupEntry( 0x006f0032, 00001, "", "" ),
            new TSymLookupEntry( 0x006f003c, 00003, "", "" ),
            new TSymLookupEntry( 0x006f0042, 00003, "", "" ),
            new TSymLookupEntry( 0x006f0043, 00020, "", "" ),
            new TSymLookupEntry( 0x006f0044, 00004, "", "" ),
            new TSymLookupEntry( 0x006f0048, 00002, "", "" ),
            new TSymLookupEntry( 0x006f004a, 00002, "", "" ),
            new TSymLookupEntry( 0x006f004b, 00001, "", "" ),
            new TSymLookupEntry( 0x006f004c, 00002, "", "" ),
            new TSymLookupEntry( 0x006f004d, 00006, "", "" ),
            new TSymLookupEntry( 0x006f004e, 00015, "", "" ),
            new TSymLookupEntry( 0x006f0050, 00027, "", "" ),
            new TSymLookupEntry( 0x006f0052, 00001, "", "" ),
            new TSymLookupEntry( 0x006f0053, 00008, "", "" ),
            new TSymLookupEntry( 0x006f0054, 00011, "", "" ),
            new TSymLookupEntry( 0x006f0057, 00002, "", "" ),
            new TSymLookupEntry( 0x006f0062, 00045, "", "" ),
            new TSymLookupEntry( 0x006f0063, 00057, "", "" ),
            new TSymLookupEntry( 0x006f0064, 00007, "", "" ),
            new TSymLookupEntry( 0x006f0066, 00012, "", "" ),
            new TSymLookupEntry( 0x006f0067, 00003, "", "" ),
            new TSymLookupEntry( 0x006f0068, 00007, "", "" ),
            new TSymLookupEntry( 0x006f006a, 00003, "", "" ),
            new TSymLookupEntry( 0x006f006c, 00027, "", "" ),
            new TSymLookupEntry( 0x006f006d, 00026, "", "" ),
            new TSymLookupEntry( 0x006f006e, 00263, "", "" ),
            new TSymLookupEntry( 0x006f0070, 00039, "", "" ),
            new TSymLookupEntry( 0x006f0072, 00007, "", "" ),
            new TSymLookupEntry( 0x006f0073, 00005, "", "" ),
            new TSymLookupEntry( 0x006f0074, 00028, "", "" ),
            new TSymLookupEntry( 0x006f0076, 00001, "", "" ),
            new TSymLookupEntry( 0x006f007a, 00002, "", "" ),
            new TSymLookupEntry( 0x006f19a8, 00001, "", "" ),
            new TSymLookupEntry( 0x006f31f0, 00001, "", "" ),
            new TSymLookupEntry( 0x006f3c50, 00001, "", "" ),
            new TSymLookupEntry( 0x006f83b8, 00001, "", "" ),
            new TSymLookupEntry( 0x006fa690, 00001, "", "" ),
            new TSymLookupEntry( 0x006fba98, 00001, "", "" ),
            new TSymLookupEntry( 0x006fc190, 00001, "", "" ),
            new TSymLookupEntry( 0x006fc3a0, 00002, "", "" ),
            new TSymLookupEntry( 0x006fc448, 00001, "", "" ),
            new TSymLookupEntry( 0x006fd038, 00002, "", "" ),
            new TSymLookupEntry( 0x006fd200, 00001, "", "" ),
            new TSymLookupEntry( 0x006fd2a8, 00001, "", "" ),
            new TSymLookupEntry( 0x006fdbd0, 00001, "", "" ),
            new TSymLookupEntry( 0x006fe060, 00001, "", "" ),
            new TSymLookupEntry( 0x006fe130, 00001, "", "" ),
            new TSymLookupEntry( 0x006fe6d8, 00001, "", "" ),
            new TSymLookupEntry( 0x006ff0f8, 00001, "", "" ),
            new TSymLookupEntry( 0x006ff288, 00001, "", "" ),
            new TSymLookupEntry( 0x00700000, 00001, "", "" ),
            new TSymLookupEntry( 0x00700023, 00001, "", "" ),
            new TSymLookupEntry( 0x00700026, 00002, "", "" ),
            new TSymLookupEntry( 0x0070002d, 00011, "", "" ),
            new TSymLookupEntry( 0x0070002e, 00001, "", "" ),
            new TSymLookupEntry( 0x0070002f, 00003, "", "" ),
            new TSymLookupEntry( 0x00700030, 00002, "", "" ),
            new TSymLookupEntry( 0x00700031, 00001, "", "" ),
            new TSymLookupEntry( 0x0070003a, 00001, "", "" ),
            new TSymLookupEntry( 0x0070004f, 00004, "", "" ),
            new TSymLookupEntry( 0x0070005a, 00001, "", "" ),
            new TSymLookupEntry( 0x00700061, 00059, "", "" ),
            new TSymLookupEntry( 0x00700067, 00001, "", "" ),
            new TSymLookupEntry( 0x00700069, 00001, "", "" ),
            new TSymLookupEntry( 0x0070006f, 00020, "", "" ),
            new TSymLookupEntry( 0x00700073, 00008, "", "" ),
            new TSymLookupEntry( 0x00700074, 00006, "", "" ),
            new TSymLookupEntry( 0x00700075, 00002, "", "" ),
            new TSymLookupEntry( 0x0070007b, 00001, "", "" ),
            new TSymLookupEntry( 0x00700164, 00001, "", "" ),
            new TSymLookupEntry( 0x00700390, 00001, "", "" ),
            new TSymLookupEntry( 0x007003b8, 00001, "", "" ),
            new TSymLookupEntry( 0x00700c38, 00001, "", "" ),
            new TSymLookupEntry( 0x00701b80, 00002, "", "" ),
            new TSymLookupEntry( 0x007038c0, 00001, "", "" ),
            new TSymLookupEntry( 0x007039d8, 00001, "", "" ),
            new TSymLookupEntry( 0x00703a28, 00001, "", "" ),
            new TSymLookupEntry( 0x00704158, 00002, "", "" ),
            new TSymLookupEntry( 0x007043d8, 00001, "", "" ),
            new TSymLookupEntry( 0x007046f8, 00001, "", "" ),
            new TSymLookupEntry( 0x007047e8, 00001, "", "" ),
            new TSymLookupEntry( 0x00704a30, 00001, "", "" ),
            new TSymLookupEntry( 0x00704b20, 00001, "", "" ),
            new TSymLookupEntry( 0x00704da0, 00001, "", "" ),
            new TSymLookupEntry( 0x007050c0, 00001, "", "" ),
            new TSymLookupEntry( 0x00705ae8, 00001, "", "" ),
            new TSymLookupEntry( 0x00707054, 00001, "", "" ),
            new TSymLookupEntry( 0x00707098, 00001, "", "" ),
            new TSymLookupEntry( 0x00707bd4, 00001, "", "" ),
            new TSymLookupEntry( 0x00707cb0, 00001, "", "" ),
            new TSymLookupEntry( 0x00707ef8, 00001, "", "" ),
            new TSymLookupEntry( 0x007081b0, 00001, "", "" ),
            new TSymLookupEntry( 0x007086a0, 00001, "", "" ),
            new TSymLookupEntry( 0x00708d50, 00001, "", "" ),
            new TSymLookupEntry( 0x00708f70, 00001, "", "" ),
            new TSymLookupEntry( 0x00709118, 00001, "", "" ),
            new TSymLookupEntry( 0x007091c0, 00001, "", "" ),
            new TSymLookupEntry( 0x00709348, 00001, "", "" ),
            new TSymLookupEntry( 0x00709420, 00001, "", "" ),
            new TSymLookupEntry( 0x0070aeb8, 00001, "", "" ),
            new TSymLookupEntry( 0x0070c248, 00001, "", "" ),
            new TSymLookupEntry( 0x0070d2bc, 00001, "", "" ),
            new TSymLookupEntry( 0x0070d898, 00001, "", "" ),
            new TSymLookupEntry( 0x0070ee80, 00001, "", "" ),
            new TSymLookupEntry( 0x0070f6c8, 00001, "", "" ),
            new TSymLookupEntry( 0x0070fab0, 00001, "", "" ),
            new TSymLookupEntry( 0x00710020, 00002, "", "" ),
            new TSymLookupEntry( 0x00710021, 00001, "", "" ),
            new TSymLookupEntry( 0x00710027, 00001, "", "" ),
            new TSymLookupEntry( 0x00710028, 00001, "", "" ),
            new TSymLookupEntry( 0x00710029, 00001, "", "" ),
            new TSymLookupEntry( 0x0071002a, 00001, "", "" ),
            new TSymLookupEntry( 0x0071002c, 00002, "", "" ),
            new TSymLookupEntry( 0x0071002d, 00002, "", "" ),
            new TSymLookupEntry( 0x0071002e, 00002, "", "" ),
            new TSymLookupEntry( 0x00710030, 00004, "", "" ),
            new TSymLookupEntry( 0x00710033, 00001, "", "" ),
            new TSymLookupEntry( 0x0071003a, 00001, "", "" ),
            new TSymLookupEntry( 0x0071003d, 00001, "", "" ),
            new TSymLookupEntry( 0x0071003f, 00002, "", "" ),
            new TSymLookupEntry( 0x00710054, 00001, "", "" ),
            new TSymLookupEntry( 0x00710065, 00001, "", "" ),
            new TSymLookupEntry( 0x00710067, 00003, "", "" ),
            new TSymLookupEntry( 0x0071006a, 00002, "", "" ),
            new TSymLookupEntry( 0x0071006d, 00001, "", "" ),
            new TSymLookupEntry( 0x00710530, 00003, "", "" ),
            new TSymLookupEntry( 0x00711108, 00001, "", "" ),
            new TSymLookupEntry( 0x007112b0, 00001, "", "" ),
            new TSymLookupEntry( 0x007117f0, 00001, "", "" ),
            new TSymLookupEntry( 0x00712130, 00001, "", "" ),
            new TSymLookupEntry( 0x007127a8, 00001, "", "" ),
            new TSymLookupEntry( 0x00712cf0, 00001, "", "" ),
            new TSymLookupEntry( 0x00712df8, 00001, "", "" ),
            new TSymLookupEntry( 0x00712f00, 00001, "", "" ),
            new TSymLookupEntry( 0x007141b8, 00001, "", "" ),
            new TSymLookupEntry( 0x007142bc, 00001, "", "" ),
            new TSymLookupEntry( 0x00714950, 00001, "", "" ),
            new TSymLookupEntry( 0x00715440, 00001, "", "" ),
            new TSymLookupEntry( 0x007163a8, 00001, "", "" ),
            new TSymLookupEntry( 0x00716573, 00001, "", "" ),
            new TSymLookupEntry( 0x00716950, 00001, "", "" ),
            new TSymLookupEntry( 0x00716e98, 00001, "", "" ),
            new TSymLookupEntry( 0x00717104, 00001, "", "" ),
            new TSymLookupEntry( 0x00717828, 00001, "", "" ),
            new TSymLookupEntry( 0x00718230, 00002, "", "" ),
            new TSymLookupEntry( 0x007182d8, 00001, "", "" ),
            new TSymLookupEntry( 0x00719954, 00001, "", "" ),
            new TSymLookupEntry( 0x00719bc8, 00001, "", "" ),
            new TSymLookupEntry( 0x0071cb88, 00001, "", "" ),
            new TSymLookupEntry( 0x0071d550, 00001, "", "" ),
            new TSymLookupEntry( 0x0071f9d0, 00001, "", "" ),
            new TSymLookupEntry( 0x0071fe98, 00001, "", "" ),
            new TSymLookupEntry( 0x00720026, 00002, "", "" ),
            new TSymLookupEntry( 0x00720041, 00003, "", "" ),
            new TSymLookupEntry( 0x00720045, 00002, "", "" ),
            new TSymLookupEntry( 0x00720046, 00004, "", "" ),
            new TSymLookupEntry( 0x00720047, 00001, "", "" ),
            new TSymLookupEntry( 0x0072004e, 00001, "", "" ),
            new TSymLookupEntry( 0x0072005c, 00001, "", "" ),
            new TSymLookupEntry( 0x00720061, 00005, "", "" ),
            new TSymLookupEntry( 0x00720062, 00004, "", "" ),
            new TSymLookupEntry( 0x00720063, 00003, "", "" ),
            new TSymLookupEntry( 0x00720064, 00007, "", "" ),
            new TSymLookupEntry( 0x00720065, 00003, "", "" ),
            new TSymLookupEntry( 0x00720066, 00012, "", "" ),
            new TSymLookupEntry( 0x00720067, 00003, "", "" ),
            new TSymLookupEntry( 0x00720068, 00006, "", "" ),
            new TSymLookupEntry( 0x0072006f, 00003, "", "" ),
            new TSymLookupEntry( 0x00720070, 00029, "", "" ),
            new TSymLookupEntry( 0x00720073, 00005, "", "" ),
            new TSymLookupEntry( 0x00720074, 00010, "", "" ),
            new TSymLookupEntry( 0x00720075, 00002, "", "" ),
            new TSymLookupEntry( 0x00720077, 00005, "", "" ),
            new TSymLookupEntry( 0x00720380, 00001, "", "" ),
            new TSymLookupEntry( 0x00720d28, 00002, "", "" ),
            new TSymLookupEntry( 0x00721318, 00001, "", "" ),
            new TSymLookupEntry( 0x00721938, 00001, "", "" ),
            new TSymLookupEntry( 0x00722800, 00001, "", "" ),
            new TSymLookupEntry( 0x00722990, 00001, "", "" ),
            new TSymLookupEntry( 0x00722d30, 00001, "", "" ),
            new TSymLookupEntry( 0x00723708, 00001, "", "" ),
            new TSymLookupEntry( 0x00724d40, 00008, "", "" ),
            new TSymLookupEntry( 0x007253a8, 00001, "", "" ),
            new TSymLookupEntry( 0x00725590, 00001, "", "" ),
            new TSymLookupEntry( 0x007256f8, 00001, "", "" ),
            new TSymLookupEntry( 0x00725a60, 00001, "", "" ),
            new TSymLookupEntry( 0x00725fd8, 00001, "", "" ),
            new TSymLookupEntry( 0x00726770, 00001, "", "" ),
            new TSymLookupEntry( 0x00726dd0, 00001, "", "" ),
            new TSymLookupEntry( 0x00726f38, 00001, "", "" ),
            new TSymLookupEntry( 0x00727348, 00001, "", "" ),
            new TSymLookupEntry( 0x00727580, 00001, "", "" ),
            new TSymLookupEntry( 0x00728990, 00001, "", "" ),
            new TSymLookupEntry( 0x00728c68, 00001, "", "" ),
            new TSymLookupEntry( 0x00728ee8, 00001, "", "" ),
            new TSymLookupEntry( 0x00729dd0, 00001, "", "" ),
            new TSymLookupEntry( 0x0072c210, 00001, "", "" ),
            new TSymLookupEntry( 0x0072fd38, 00001, "", "" ),
            new TSymLookupEntry( 0x0073003c, 00083, "", "" ),
            new TSymLookupEntry( 0x00730055, 00003, "", "" ),
            new TSymLookupEntry( 0x0073005c, 00005, "", "" ),
            new TSymLookupEntry( 0x00730061, 00002, "", "" ),
            new TSymLookupEntry( 0x00730063, 00004, "", "" ),
            new TSymLookupEntry( 0x00730065, 00001, "", "" ),
            new TSymLookupEntry( 0x00730067, 00001, "", "" ),
            new TSymLookupEntry( 0x00730068, 00001, "", "" ),
            new TSymLookupEntry( 0x00730069, 00015, "", "" ),
            new TSymLookupEntry( 0x0073006a, 00012, "", "" ),
            new TSymLookupEntry( 0x0073006c, 00001, "", "" ),
            new TSymLookupEntry( 0x0073006d, 00003, "", "" ),
            new TSymLookupEntry( 0x0073006e, 00001, "", "" ),
            new TSymLookupEntry( 0x00730072, 00001, "", "" ),
            new TSymLookupEntry( 0x00730073, 00001, "", "" ),
            new TSymLookupEntry( 0x00730074, 00001, "", "" ),
            new TSymLookupEntry( 0x00730075, 00013, "", "" ),
            new TSymLookupEntry( 0x00730076, 00001, "", "" ),
            new TSymLookupEntry( 0x00730280, 00001, "", "" ),
            new TSymLookupEntry( 0x00730dec, 00001, "", "" ),
            new TSymLookupEntry( 0x00731104, 00001, "", "" ),
            new TSymLookupEntry( 0x00731384, 00001, "", "" ),
            new TSymLookupEntry( 0x00731c50, 00001, "", "" ),
            new TSymLookupEntry( 0x00732160, 00001, "", "" ),
            new TSymLookupEntry( 0x007322ac, 00001, "", "" ),
            new TSymLookupEntry( 0x00732790, 00001, "", "" ),
            new TSymLookupEntry( 0x007328d8, 00003, "", "" ),
            new TSymLookupEntry( 0x00732cdc, 00001, "", "" ),
            new TSymLookupEntry( 0x007330fc, 00001, "", "" ),
            new TSymLookupEntry( 0x00733d84, 00001, "", "" ),
            new TSymLookupEntry( 0x00733f1c, 00001, "", "" ),
            new TSymLookupEntry( 0x00734994, 00001, "", "" ),
            new TSymLookupEntry( 0x00735794, 00001, "", "" ),
            new TSymLookupEntry( 0x00735fa4, 00001, "", "" ),
            new TSymLookupEntry( 0x00736324, 00001, "", "" ),
            new TSymLookupEntry( 0x007364b4, 00001, "", "" ),
            new TSymLookupEntry( 0x007368f4, 00001, "", "" ),
            new TSymLookupEntry( 0x00736b74, 00001, "", "" ),
            new TSymLookupEntry( 0x007371b8, 00001, "", "" ),
            new TSymLookupEntry( 0x00737354, 00001, "", "" ),
            new TSymLookupEntry( 0x0073779c, 00001, "", "" ),
            new TSymLookupEntry( 0x00737d08, 00001, "", "" ),
            new TSymLookupEntry( 0x00737e80, 00001, "", "" ),
            new TSymLookupEntry( 0x00738184, 00001, "", "" ),
            new TSymLookupEntry( 0x007384c4, 00001, "", "" ),
            new TSymLookupEntry( 0x00739104, 00001, "", "" ),
            new TSymLookupEntry( 0x007397cc, 00001, "", "" ),
            new TSymLookupEntry( 0x00739b60, 00036, "", "" ),
            new TSymLookupEntry( 0x00739f5c, 00001, "", "" ),
            new TSymLookupEntry( 0x0073a018, 00001, "", "" ),
            new TSymLookupEntry( 0x0073a61c, 00001, "", "" ),
            new TSymLookupEntry( 0x0073a8e8, 00001, "", "" ),
            new TSymLookupEntry( 0x0073aebc, 00001, "", "" ),
            new TSymLookupEntry( 0x0073b494, 00001, "", "" ),
            new TSymLookupEntry( 0x0073b5f8, 00001, "", "" ),
            new TSymLookupEntry( 0x0073b790, 00001, "", "" ),
            new TSymLookupEntry( 0x0073b7e0, 00001, "", "" ),
            new TSymLookupEntry( 0x0073bf0c, 00001, "", "" ),
            new TSymLookupEntry( 0x0073c930, 00001, "", "" ),
            new TSymLookupEntry( 0x0073c9b0, 00001, "", "" ),
            new TSymLookupEntry( 0x0073ca00, 00001, "", "" ),
            new TSymLookupEntry( 0x0073cd30, 00001, "", "" ),
            new TSymLookupEntry( 0x0073cdd0, 00001, "", "" ),
            new TSymLookupEntry( 0x0073d388, 00001, "", "" ),
            new TSymLookupEntry( 0x0073d9c4, 00001, "", "" ),
            new TSymLookupEntry( 0x0073e21c, 00001, "", "" ),
            new TSymLookupEntry( 0x0073e850, 00001, "", "" ),
            new TSymLookupEntry( 0x0073ea08, 00001, "", "" ),
            new TSymLookupEntry( 0x0073eaf8, 00001, "", "" ),
            new TSymLookupEntry( 0x0073eea0, 00001, "", "" ),
            new TSymLookupEntry( 0x0073eef0, 00001, "", "" ),
            new TSymLookupEntry( 0x0073ef40, 00001, "", "" ),
            new TSymLookupEntry( 0x0073f1ec, 00001, "", "" ),
            new TSymLookupEntry( 0x0073f370, 00001, "", "" ),
            new TSymLookupEntry( 0x0073f3c0, 00001, "", "" ),
            new TSymLookupEntry( 0x0073f488, 00001, "", "" ),
            new TSymLookupEntry( 0x0073f800, 00001, "", "" ),
            new TSymLookupEntry( 0x0073f850, 00001, "", "" ),
            new TSymLookupEntry( 0x0073f970, 00001, "", "" ),
            new TSymLookupEntry( 0x0073fba8, 00001, "", "" ),
            new TSymLookupEntry( 0x0073fdb0, 00001, "", "" ),
            new TSymLookupEntry( 0x0073fef0, 00001, "", "" ),
            new TSymLookupEntry( 0x00740020, 00001, "", "" ),
            new TSymLookupEntry( 0x00740023, 00001, "", "" ),
            new TSymLookupEntry( 0x00740028, 00001, "", "" ),
            new TSymLookupEntry( 0x0074002f, 00002, "", "" ),
            new TSymLookupEntry( 0x0074003c, 00012, "", "" ),
            new TSymLookupEntry( 0x00740053, 00005, "", "" ),
            new TSymLookupEntry( 0x0074005e, 00001, "", "" ),
            new TSymLookupEntry( 0x0074005f, 00001, "", "" ),
            new TSymLookupEntry( 0x00740061, 00004, "", "" ),
            new TSymLookupEntry( 0x00740063, 00003, "", "" ),
            new TSymLookupEntry( 0x00740064, 00001, "", "" ),
            new TSymLookupEntry( 0x00740067, 00002, "", "" ),
            new TSymLookupEntry( 0x00740068, 00169, "", "" ),
            new TSymLookupEntry( 0x00740069, 00014, "", "" ),
            new TSymLookupEntry( 0x0074006c, 00001, "", "" ),
            new TSymLookupEntry( 0x0074006d, 00001, "", "" ),
            new TSymLookupEntry( 0x0074006e, 00002, "", "" ),
            new TSymLookupEntry( 0x0074006f, 00001, "", "" ),
            new TSymLookupEntry( 0x00740073, 00039, "", "" ),
            new TSymLookupEntry( 0x00740074, 00001, "", "" ),
            new TSymLookupEntry( 0x00740075, 00002, "", "" ),
            new TSymLookupEntry( 0x00740168, 00001, "", "" ),
            new TSymLookupEntry( 0x007405ac, 00001, "", "" ),
            new TSymLookupEntry( 0x00740f68, 00001, "", "" ),
            new TSymLookupEntry( 0x007411c8, 00001, "", "" ),
            new TSymLookupEntry( 0x00741308, 00001, "", "" ),
            new TSymLookupEntry( 0x007416b0, 00001, "", "" ),
            new TSymLookupEntry( 0x00741ecc, 00001, "", "" ),
            new TSymLookupEntry( 0x007420d0, 00001, "", "" ),
            new TSymLookupEntry( 0x00742218, 00001, "", "" ),
            new TSymLookupEntry( 0x00742310, 00001, "", "" ),
            new TSymLookupEntry( 0x00742478, 00001, "", "" ),
            new TSymLookupEntry( 0x007424c8, 00001, "", "" ),
            new TSymLookupEntry( 0x007426f8, 00001, "", "" ),
            new TSymLookupEntry( 0x00742b50, 00001, "", "" ),
            new TSymLookupEntry( 0x00743108, 00001, "", "" ),
            new TSymLookupEntry( 0x007431d8, 00001, "", "" ),
            new TSymLookupEntry( 0x00743370, 00001, "", "" ),
            new TSymLookupEntry( 0x00743578, 00001, "", "" ),
            new TSymLookupEntry( 0x00743688, 00001, "", "" ),
            new TSymLookupEntry( 0x00743818, 00001, "", "" ),
            new TSymLookupEntry( 0x00743980, 00001, "", "" ),
            new TSymLookupEntry( 0x00743b38, 00001, "", "" ),
            new TSymLookupEntry( 0x00743cc8, 00001, "", "" ),
            new TSymLookupEntry( 0x00743de0, 00001, "", "" ),
            new TSymLookupEntry( 0x00744310, 00001, "", "" ),
            new TSymLookupEntry( 0x00744698, 00001, "", "" ),
            new TSymLookupEntry( 0x00744768, 00001, "", "" ),
            new TSymLookupEntry( 0x007447e0, 00001, "", "" ),
            new TSymLookupEntry( 0x00744b38, 00001, "", "" ),
            new TSymLookupEntry( 0x007452e0, 00001, "", "" ),
            new TSymLookupEntry( 0x00745428, 00001, "", "" ),
            new TSymLookupEntry( 0x00745598, 00001, "", "" ),
            new TSymLookupEntry( 0x00745780, 00001, "", "" ),
            new TSymLookupEntry( 0x00745c68, 00001, "", "" ),
            new TSymLookupEntry( 0x00745e00, 00001, "", "" ),
            new TSymLookupEntry( 0x00745e50, 00001, "", "" ),
            new TSymLookupEntry( 0x00746218, 00001, "", "" ),
            new TSymLookupEntry( 0x007465e0, 00001, "", "" ),
            new TSymLookupEntry( 0x00746630, 00001, "", "" ),
            new TSymLookupEntry( 0x007467e8, 00001, "", "" ),
            new TSymLookupEntry( 0x007468d8, 00001, "", "" ),
            new TSymLookupEntry( 0x00746950, 00001, "", "" ),
            new TSymLookupEntry( 0x007469f0, 00001, "", "" ),
            new TSymLookupEntry( 0x00746c50, 00001, "", "" ),
            new TSymLookupEntry( 0x00746fa0, 00001, "", "" ),
            new TSymLookupEntry( 0x00747250, 00001, "", "" ),
            new TSymLookupEntry( 0x007474a8, 00001, "", "" ),
            new TSymLookupEntry( 0x007475e8, 00001, "", "" ),
            new TSymLookupEntry( 0x00747660, 00001, "", "" ),
            new TSymLookupEntry( 0x00747898, 00001, "", "" ),
            new TSymLookupEntry( 0x00747c70, 00001, "", "" ),
            new TSymLookupEntry( 0x00747e78, 00001, "", "" ),
            new TSymLookupEntry( 0x00747f18, 00001, "", "" ),
            new TSymLookupEntry( 0x00748000, 00001, "", "" ),
            new TSymLookupEntry( 0x00748170, 00001, "", "" ),
            new TSymLookupEntry( 0x0074a878, 00001, "", "" ),
            new TSymLookupEntry( 0x0074cac0, 00001, "", "" ),
            new TSymLookupEntry( 0x0074cb60, 00001, "", "" ),
            new TSymLookupEntry( 0x0074ce90, 00001, "", "" ),
            new TSymLookupEntry( 0x0074d078, 00001, "", "" ),
            new TSymLookupEntry( 0x0074d320, 00001, "", "" ),
            new TSymLookupEntry( 0x0074d460, 00001, "", "" ),
            new TSymLookupEntry( 0x0074d928, 00001, "", "" ),
            new TSymLookupEntry( 0x0074d978, 00001, "", "" ),
            new TSymLookupEntry( 0x0074dda0, 00001, "", "" ),
            new TSymLookupEntry( 0x0074e028, 00001, "", "" ),
            new TSymLookupEntry( 0x0074e3f0, 00001, "", "" ),
            new TSymLookupEntry( 0x0074e5d0, 00001, "", "" ),
            new TSymLookupEntry( 0x0074e790, 00001, "", "" ),
            new TSymLookupEntry( 0x0074e9c8, 00001, "", "" ),
            new TSymLookupEntry( 0x0074eb58, 00001, "", "" ),
            new TSymLookupEntry( 0x0074eef8, 00001, "", "" ),
            new TSymLookupEntry( 0x0074f210, 00001, "", "" ),
            new TSymLookupEntry( 0x0074f698, 00001, "", "" ),
            new TSymLookupEntry( 0x0074f830, 00001, "", "" ),
            new TSymLookupEntry( 0x0074f950, 00001, "", "" ),
            new TSymLookupEntry( 0x0074fb08, 00001, "", "" ),
            new TSymLookupEntry( 0x0074fed0, 00001, "", "" ),
            new TSymLookupEntry( 0x00750026, 00001, "", "" ),
            new TSymLookupEntry( 0x0075002f, 00005, "", "" ),
            new TSymLookupEntry( 0x00750043, 00004, "", "" ),
            new TSymLookupEntry( 0x00750046, 00001, "", "" ),
            new TSymLookupEntry( 0x0075004b, 00001, "", "" ),
            new TSymLookupEntry( 0x0075004c, 00001, "", "" ),
            new TSymLookupEntry( 0x0075004e, 00002, "", "" ),
            new TSymLookupEntry( 0x00750050, 00005, "", "" ),
            new TSymLookupEntry( 0x00750052, 00005, "", "" ),
            new TSymLookupEntry( 0x00750053, 00001, "", "" ),
            new TSymLookupEntry( 0x00750054, 00031, "", "" ),
            new TSymLookupEntry( 0x00750061, 00003, "", "" ),
            new TSymLookupEntry( 0x00750062, 00025, "", "" ),
            new TSymLookupEntry( 0x00750063, 00012, "", "" ),
            new TSymLookupEntry( 0x00750064, 00001, "", "" ),
            new TSymLookupEntry( 0x00750066, 00006, "", "" ),
            new TSymLookupEntry( 0x00750067, 00001, "", "" ),
            new TSymLookupEntry( 0x0075006a, 00004, "", "" ),
            new TSymLookupEntry( 0x0075006d, 00005, "", "" ),
            new TSymLookupEntry( 0x0075006e, 00005, "", "" ),
            new TSymLookupEntry( 0x0075006f, 00005, "", "" ),
            new TSymLookupEntry( 0x00750070, 00025, "", "" ),
            new TSymLookupEntry( 0x00750071, 00008, "", "" ),
            new TSymLookupEntry( 0x00750072, 00003, "", "" ),
            new TSymLookupEntry( 0x00750073, 00015, "", "" ),
            new TSymLookupEntry( 0x00750075, 00001, "", "" ),
            new TSymLookupEntry( 0x00750077, 00001, "", "" ),
            new TSymLookupEntry( 0x0075007b, 00001, "", "" ),
            new TSymLookupEntry( 0x00750120, 00001, "", "" ),
            new TSymLookupEntry( 0x00750ac0, 00001, "", "" ),
            new TSymLookupEntry( 0x00750f08, 00001, "", "" ),
            new TSymLookupEntry( 0x00751230, 00001, "", "" ),
            new TSymLookupEntry( 0x007518d0, 00001, "", "" ),
            new TSymLookupEntry( 0x00751b28, 00001, "", "" ),
            new TSymLookupEntry( 0x00751b78, 00002, "", "" ),
            new TSymLookupEntry( 0x00751bd0, 00001, "", "" ),
            new TSymLookupEntry( 0x00751ce8, 00001, "", "" ),
            new TSymLookupEntry( 0x00751f68, 00001, "", "" ),
            new TSymLookupEntry( 0x00752098, 00001, "", "" ),
            new TSymLookupEntry( 0x007521b8, 00001, "", "" ),
            new TSymLookupEntry( 0x00752410, 00001, "", "" ),
            new TSymLookupEntry( 0x00752d20, 00001, "", "" ),
            new TSymLookupEntry( 0x00752d98, 00001, "", "" ),
            new TSymLookupEntry( 0x00753138, 00001, "", "" ),
            new TSymLookupEntry( 0x00755028, 00001, "", "" ),
            new TSymLookupEntry( 0x00757b38, 00001, "", "" ),
            new TSymLookupEntry( 0x00759ab8, 00001, "", "" ),
            new TSymLookupEntry( 0x0075ab98, 00001, "", "" ),
            new TSymLookupEntry( 0x0075af60, 00001, "", "" ),
            new TSymLookupEntry( 0x0075b078, 00001, "", "" ),
            new TSymLookupEntry( 0x0075b118, 00001, "", "" ),
            new TSymLookupEntry( 0x0075b900, 00001, "", "" ),
            new TSymLookupEntry( 0x0075bae8, 00001, "", "" ),
            new TSymLookupEntry( 0x0075bcf0, 00001, "", "" ),
            new TSymLookupEntry( 0x0075bd40, 00001, "", "" ),
            new TSymLookupEntry( 0x0075bd90, 00001, "", "" ),
            new TSymLookupEntry( 0x0075bea8, 00001, "", "" ),
            new TSymLookupEntry( 0x0075c120, 00001, "", "" ),
            new TSymLookupEntry( 0x0075c1c8, 00001, "", "" ),
            new TSymLookupEntry( 0x0075c290, 00001, "", "" ),
            new TSymLookupEntry( 0x0075c5b0, 00001, "", "" ),
            new TSymLookupEntry( 0x0075c600, 00001, "", "" ),
            new TSymLookupEntry( 0x0075c650, 00001, "", "" ),
            new TSymLookupEntry( 0x0075c6f0, 00001, "", "" ),
            new TSymLookupEntry( 0x0075cd00, 00001, "", "" ),
            new TSymLookupEntry( 0x0075cda0, 00001, "", "" ),
            new TSymLookupEntry( 0x0075d818, 00001, "", "" ),
            new TSymLookupEntry( 0x0075dde8, 00001, "", "" ),
            new TSymLookupEntry( 0x0075de88, 00001, "", "" ),
            new TSymLookupEntry( 0x0075e320, 00001, "", "" ),
            new TSymLookupEntry( 0x0075e3c0, 00001, "", "" ),
            new TSymLookupEntry( 0x0075e5a0, 00001, "", "" ),
            new TSymLookupEntry( 0x0075ed88, 00001, "", "" ),
            new TSymLookupEntry( 0x0075f230, 00001, "", "" ),
            new TSymLookupEntry( 0x0075f378, 00001, "", "" ),
            new TSymLookupEntry( 0x0075fbf8, 00001, "", "" ),
            new TSymLookupEntry( 0x0075fc98, 00001, "", "" ),
            new TSymLookupEntry( 0x0075fd10, 00001, "", "" ),
            new TSymLookupEntry( 0x0075fd88, 00001, "", "" ),
            new TSymLookupEntry( 0x00760026, 00001, "", "" ),
            new TSymLookupEntry( 0x0076002a, 00001, "", "" ),
            new TSymLookupEntry( 0x0076003a, 00002, "", "" ),
            new TSymLookupEntry( 0x0076003c, 00001, "", "" ),
            new TSymLookupEntry( 0x00760045, 00002, "", "" ),
            new TSymLookupEntry( 0x0076005b, 00002, "", "" ),
            new TSymLookupEntry( 0x0076005d, 00001, "", "" ),
            new TSymLookupEntry( 0x00760061, 00004, "", "" ),
            new TSymLookupEntry( 0x00760065, 00015, "", "" ),
            new TSymLookupEntry( 0x00760067, 00001, "", "" ),
            new TSymLookupEntry( 0x00760069, 00003, "", "" ),
            new TSymLookupEntry( 0x0076006a, 00001, "", "" ),
            new TSymLookupEntry( 0x0076006d, 00003, "", "" ),
            new TSymLookupEntry( 0x0076006e, 00001, "", "" ),
            new TSymLookupEntry( 0x0076006f, 00005, "", "" ),
            new TSymLookupEntry( 0x00760270, 00001, "", "" ),
            new TSymLookupEntry( 0x007602c0, 00001, "", "" ),
            new TSymLookupEntry( 0x00760590, 00001, "", "" ),
            new TSymLookupEntry( 0x007605e0, 00002, "", "" ),
            new TSymLookupEntry( 0x00760a00, 00001, "", "" ),
            new TSymLookupEntry( 0x00760b90, 00001, "", "" ),
            new TSymLookupEntry( 0x00760be0, 00001, "", "" ),
            new TSymLookupEntry( 0x00760e68, 00001, "", "" ),
            new TSymLookupEntry( 0x00760ee0, 00001, "", "" ),
            new TSymLookupEntry( 0x00760f30, 00001, "", "" ),
            new TSymLookupEntry( 0x007618a8, 00001, "", "" ),
            new TSymLookupEntry( 0x007618f8, 00001, "", "" ),
            new TSymLookupEntry( 0x00761998, 00001, "", "" ),
            new TSymLookupEntry( 0x00761a88, 00001, "", "" ),
            new TSymLookupEntry( 0x00762210, 00001, "", "" ),
            new TSymLookupEntry( 0x00762418, 00001, "", "" ),
            new TSymLookupEntry( 0x00762490, 00001, "", "" ),
            new TSymLookupEntry( 0x00762620, 00001, "", "" ),
            new TSymLookupEntry( 0x007626c0, 00001, "", "" ),
            new TSymLookupEntry( 0x00762808, 00001, "", "" ),
            new TSymLookupEntry( 0x00762970, 00001, "", "" ),
            new TSymLookupEntry( 0x00762a10, 00001, "", "" ),
            new TSymLookupEntry( 0x00762db8, 00001, "", "" ),
            new TSymLookupEntry( 0x00762f50, 00001, "", "" ),
            new TSymLookupEntry( 0x00763000, 00001, "", "" ),
            new TSymLookupEntry( 0x007630a8, 00001, "", "" ),
            new TSymLookupEntry( 0x007631e8, 00001, "", "" ),
            new TSymLookupEntry( 0x007633a0, 00001, "", "" ),
            new TSymLookupEntry( 0x007636f8, 00001, "", "" ),
            new TSymLookupEntry( 0x007638b0, 00001, "", "" ),
            new TSymLookupEntry( 0x00763958, 00001, "", "" ),
            new TSymLookupEntry( 0x007639a8, 00001, "", "" ),
            new TSymLookupEntry( 0x00763a50, 00001, "", "" ),
            new TSymLookupEntry( 0x00763aa0, 00001, "", "" ),
            new TSymLookupEntry( 0x00763b18, 00001, "", "" ),
            new TSymLookupEntry( 0x00763c30, 00001, "", "" ),
            new TSymLookupEntry( 0x00763cb0, 00001, "", "" ),
            new TSymLookupEntry( 0x00763fc0, 00001, "", "" ),
            new TSymLookupEntry( 0x00764450, 00001, "", "" ),
            new TSymLookupEntry( 0x007644a0, 00001, "", "" ),
            new TSymLookupEntry( 0x007644f0, 00001, "", "" ),
            new TSymLookupEntry( 0x00764950, 00001, "", "" ),
            new TSymLookupEntry( 0x007650d0, 00001, "", "" ),
            new TSymLookupEntry( 0x00765700, 00001, "", "" ),
            new TSymLookupEntry( 0x00765ab0, 00001, "", "" ),
            new TSymLookupEntry( 0x00765bf8, 00001, "", "" ),
            new TSymLookupEntry( 0x007662b0, 00001, "", "" ),
            new TSymLookupEntry( 0x00767120, 00001, "", "" ),
            new TSymLookupEntry( 0x00768b90, 00001, "", "" ),
            new TSymLookupEntry( 0x00769218, 00001, "", "" ),
            new TSymLookupEntry( 0x00769400, 00001, "", "" ),
            new TSymLookupEntry( 0x00769478, 00001, "", "" ),
            new TSymLookupEntry( 0x00769dd0, 00001, "", "" ),
            new TSymLookupEntry( 0x0076ab28, 00001, "", "" ),
            new TSymLookupEntry( 0x0076b540, 00001, "", "" ),
            new TSymLookupEntry( 0x0076bd38, 00009, "", "" ),
            new TSymLookupEntry( 0x0076bf80, 00001, "", "" ),
            new TSymLookupEntry( 0x0076e430, 00001, "", "" ),
            new TSymLookupEntry( 0x0076e690, 00001, "", "" ),
            new TSymLookupEntry( 0x0076fcb0, 00002, "", "" ),
            new TSymLookupEntry( 0x00770023, 00001, "", "" ),
            new TSymLookupEntry( 0x0077002d, 00012, "", "" ),
            new TSymLookupEntry( 0x00770030, 00001, "", "" ),
            new TSymLookupEntry( 0x00770067, 00001, "", "" ),
            new TSymLookupEntry( 0x0077006d, 00001, "", "" ),
            new TSymLookupEntry( 0x0077006e, 00002, "", "" ),
            new TSymLookupEntry( 0x0077006f, 00001, "", "" ),
            new TSymLookupEntry( 0x00770073, 00003, "", "" ),
            new TSymLookupEntry( 0x00770a88, 00001, "", "" ),
            new TSymLookupEntry( 0x007740c8, 00001, "", "" ),
            new TSymLookupEntry( 0x00774f08, 00001, "", "" ),
            new TSymLookupEntry( 0x007752d0, 00001, "", "" ),
            new TSymLookupEntry( 0x00775710, 00004, "", "" ),
            new TSymLookupEntry( 0x00776990, 00001, "", "" ),
            new TSymLookupEntry( 0x00776a58, 00001, "", "" ),
            new TSymLookupEntry( 0x00776be8, 00001, "", "" ),
            new TSymLookupEntry( 0x007772e0, 00001, "", "" ),
            new TSymLookupEntry( 0x007783c0, 00001, "", "" ),
            new TSymLookupEntry( 0x00778ad0, 00001, "", "" ),
            new TSymLookupEntry( 0x00779950, 00001, "", "" ),
            new TSymLookupEntry( 0x007799d0, 00001, "", "" ),
            new TSymLookupEntry( 0x00779d00, 00001, "", "" ),
            new TSymLookupEntry( 0x0077a410, 00001, "", "" ),
            new TSymLookupEntry( 0x0077a530, 00001, "", "" ),
            new TSymLookupEntry( 0x0077a648, 00002, "", "" ),
            new TSymLookupEntry( 0x0077a6c0, 00001, "", "" ),
            new TSymLookupEntry( 0x0077add0, 00001, "", "" ),
            new TSymLookupEntry( 0x0077b0a0, 00001, "", "" ),
            new TSymLookupEntry( 0x0077b708, 00001, "", "" ),
            new TSymLookupEntry( 0x0077b758, 00001, "", "" ),
            new TSymLookupEntry( 0x0077c308, 00001, "", "" ),
            new TSymLookupEntry( 0x0077e930, 00001, "", "" ),
            new TSymLookupEntry( 0x0077ea70, 00001, "", "" ),
            new TSymLookupEntry( 0x0077ede0, 00001, "", "" ),
            new TSymLookupEntry( 0x0077ef98, 00001, "", "" ),
            new TSymLookupEntry( 0x0077f298, 00001, "", "" ),
            new TSymLookupEntry( 0x0077fc60, 00001, "", "" ),
            new TSymLookupEntry( 0x00780023, 00001, "", "" ),
            new TSymLookupEntry( 0x0078002e, 00001, "", "" ),
            new TSymLookupEntry( 0x0078003a, 00001, "", "" ),
            new TSymLookupEntry( 0x00780045, 00002, "", "" ),
            new TSymLookupEntry( 0x0078005b, 00001, "", "" ),
            new TSymLookupEntry( 0x00780061, 00002, "", "" ),
            new TSymLookupEntry( 0x00780065, 00009, "", "" ),
            new TSymLookupEntry( 0x00780066, 00004, "", "" ),
            new TSymLookupEntry( 0x00780067, 00001, "", "" ),
            new TSymLookupEntry( 0x00780070, 00009, "", "" ),
            new TSymLookupEntry( 0x007806f0, 00002, "", "" ),
            new TSymLookupEntry( 0x007814e0, 00001, "", "" ),
            new TSymLookupEntry( 0x00782418, 00001, "", "" ),
            new TSymLookupEntry( 0x00783f00, 00001, "", "" ),
            new TSymLookupEntry( 0x00784320, 00001, "", "" ),
            new TSymLookupEntry( 0x007844d8, 00001, "", "" ),
            new TSymLookupEntry( 0x00784730, 00002, "", "" ),
            new TSymLookupEntry( 0x00784878, 00001, "", "" ),
            new TSymLookupEntry( 0x00784940, 00001, "", "" ),
            new TSymLookupEntry( 0x00784e30, 00001, "", "" ),
            new TSymLookupEntry( 0x00785498, 00001, "", "" ),
            new TSymLookupEntry( 0x00785a90, 00001, "", "" ),
            new TSymLookupEntry( 0x00785f48, 00001, "", "" ),
            new TSymLookupEntry( 0x00785fc0, 00001, "", "" ),
            new TSymLookupEntry( 0x007864c0, 00001, "", "" ),
            new TSymLookupEntry( 0x00786858, 00001, "", "" ),
            new TSymLookupEntry( 0x00787080, 00001, "", "" ),
            new TSymLookupEntry( 0x00789bf8, 00001, "", "" ),
            new TSymLookupEntry( 0x0078a960, 00001, "", "" ),
            new TSymLookupEntry( 0x0078b840, 00001, "", "" ),
            new TSymLookupEntry( 0x0078bc28, 00001, "", "" ),
            new TSymLookupEntry( 0x0078c690, 00001, "", "" ),
            new TSymLookupEntry( 0x0078d3f8, 00001, "", "" ),
            new TSymLookupEntry( 0x0078d6c8, 00001, "", "" ),
            new TSymLookupEntry( 0x0078d7c0, 00001, "", "" ),
            new TSymLookupEntry( 0x0078ddb0, 00001, "", "" ),
            new TSymLookupEntry( 0x0078dfe0, 00001, "", "" ),
            new TSymLookupEntry( 0x0078e5a8, 00001, "", "" ),
            new TSymLookupEntry( 0x0078e990, 00001, "", "" ),
            new TSymLookupEntry( 0x0078eee8, 00001, "", "" ),
            new TSymLookupEntry( 0x0078f3c0, 00001, "", "" ),
            new TSymLookupEntry( 0x0078f6b8, 00001, "", "" ),
            new TSymLookupEntry( 0x0078f910, 00001, "", "" ),
            new TSymLookupEntry( 0x00790021, 00001, "", "" ),
            new TSymLookupEntry( 0x0079002a, 00001, "", "" ),
            new TSymLookupEntry( 0x00790030, 00002, "", "" ),
            new TSymLookupEntry( 0x00790053, 00002, "", "" ),
            new TSymLookupEntry( 0x00790054, 00002, "", "" ),
            new TSymLookupEntry( 0x00790063, 00001, "", "" ),
            new TSymLookupEntry( 0x00790074, 00005, "", "" ),
            new TSymLookupEntry( 0x00790079, 00001, "", "" ),
            new TSymLookupEntry( 0x007901b8, 00001, "", "" ),
            new TSymLookupEntry( 0x00791d50, 00001, "", "" ),
            new TSymLookupEntry( 0x00791da0, 00001, "", "" ),
            new TSymLookupEntry( 0x00791f38, 00001, "", "" ),
            new TSymLookupEntry( 0x00791f88, 00001, "", "" ),
            new TSymLookupEntry( 0x00792140, 00001, "", "" ),
            new TSymLookupEntry( 0x00793790, 00001, "", "" ),
            new TSymLookupEntry( 0x00793d88, 00001, "", "" ),
            new TSymLookupEntry( 0x007948a8, 00001, "", "" ),
            new TSymLookupEntry( 0x00794b30, 00001, "", "" ),
            new TSymLookupEntry( 0x00794c80, 00001, "", "" ),
            new TSymLookupEntry( 0x00794ff8, 00001, "", "" ),
            new TSymLookupEntry( 0x00795080, 00001, "", "" ),
            new TSymLookupEntry( 0x00795210, 00001, "", "" ),
            new TSymLookupEntry( 0x00795420, 00001, "", "" ),
            new TSymLookupEntry( 0x00795868, 00001, "", "" ),
            new TSymLookupEntry( 0x00795b40, 00001, "", "" ),
            new TSymLookupEntry( 0x00795c30, 00001, "", "" ),
            new TSymLookupEntry( 0x00796148, 00001, "", "" ),
            new TSymLookupEntry( 0x0079656b, 00001, "", "" ),
            new TSymLookupEntry( 0x00796650, 00001, "", "" ),
            new TSymLookupEntry( 0x007968f8, 00001, "", "" ),
            new TSymLookupEntry( 0x00796a10, 00001, "", "" ),
            new TSymLookupEntry( 0x00796ba0, 00001, "", "" ),
            new TSymLookupEntry( 0x00796e70, 00001, "", "" ),
            new TSymLookupEntry( 0x007973a0, 00001, "", "" ),
            new TSymLookupEntry( 0x00798288, 00001, "", "" ),
            new TSymLookupEntry( 0x00798468, 00001, "", "" ),
            new TSymLookupEntry( 0x00798828, 00001, "", "" ),
            new TSymLookupEntry( 0x00798ce8, 00001, "", "" ),
            new TSymLookupEntry( 0x007995a8, 00001, "", "" ),
            new TSymLookupEntry( 0x00799698, 00001, "", "" ),
            new TSymLookupEntry( 0x007999f0, 00001, "", "" ),
            new TSymLookupEntry( 0x0079a438, 00001, "", "" ),
            new TSymLookupEntry( 0x0079a680, 00001, "", "" ),
            new TSymLookupEntry( 0x0079ab08, 00001, "", "" ),
            new TSymLookupEntry( 0x0079ad90, 00001, "", "" ),
            new TSymLookupEntry( 0x0079b080, 00001, "", "" ),
            new TSymLookupEntry( 0x0079b560, 00001, "", "" ),
            new TSymLookupEntry( 0x0079bb00, 00001, "", "" ),
            new TSymLookupEntry( 0x0079bd08, 00001, "", "" ),
            new TSymLookupEntry( 0x0079c238, 00001, "", "" ),
            new TSymLookupEntry( 0x0079c3f0, 00001, "", "" ),
            new TSymLookupEntry( 0x0079c6e8, 00001, "", "" ),
            new TSymLookupEntry( 0x0079d050, 00001, "", "" ),
            new TSymLookupEntry( 0x0079d258, 00001, "", "" ),
            new TSymLookupEntry( 0x0079d2a8, 00002, "", "" ),
            new TSymLookupEntry( 0x0079d640, 00001, "", "" ),
            new TSymLookupEntry( 0x0079dd20, 00001, "", "" ),
            new TSymLookupEntry( 0x0079dd70, 00001, "", "" ),
            new TSymLookupEntry( 0x0079e508, 00001, "", "" ),
            new TSymLookupEntry( 0x0079e800, 00001, "", "" ),
            new TSymLookupEntry( 0x0079eba0, 00001, "", "" ),
            new TSymLookupEntry( 0x0079ec68, 00001, "", "" ),
            new TSymLookupEntry( 0x0079edb0, 00001, "", "" ),
            new TSymLookupEntry( 0x0079f058, 00001, "", "" ),
            new TSymLookupEntry( 0x0079f160, 00001, "", "" ),
            new TSymLookupEntry( 0x0079f468, 00001, "", "" ),
            new TSymLookupEntry( 0x0079f7b8, 00001, "", "" ),
            new TSymLookupEntry( 0x0079f858, 00001, "", "" ),
            new TSymLookupEntry( 0x0079f9f0, 00001, "", "" ),
            new TSymLookupEntry( 0x0079fb38, 00001, "", "" ),
            new TSymLookupEntry( 0x0079fb88, 00001, "", "" ),
            new TSymLookupEntry( 0x0079fcd8, 00001, "", "" ),
            new TSymLookupEntry( 0x0079fef0, 00001, "", "" ),
            new TSymLookupEntry( 0x0079ffe0, 00002, "", "" ),
            new TSymLookupEntry( 0x007a0020, 00001, "", "" ),
            new TSymLookupEntry( 0x007a0030, 00001, "", "" ),
            new TSymLookupEntry( 0x007a06a0, 00001, "", "" ),
            new TSymLookupEntry( 0x007a09e8, 00001, "", "" ),
            new TSymLookupEntry( 0x007a0a60, 00001, "", "" ),
            new TSymLookupEntry( 0x007a1080, 00001, "", "" ),
            new TSymLookupEntry( 0x007a14a0, 00001, "", "" ),
            new TSymLookupEntry( 0x007a1eb8, 00001, "", "" ),
            new TSymLookupEntry( 0x007a2168, 00001, "", "" ),
            new TSymLookupEntry( 0x007a26a8, 00001, "", "" ),
            new TSymLookupEntry( 0x007a2928, 00001, "", "" ),
            new TSymLookupEntry( 0x007a3448, 00001, "", "" ),
            new TSymLookupEntry( 0x007a45c8, 00001, "", "" ),
            new TSymLookupEntry( 0x007a4970, 00001, "", "" ),
            new TSymLookupEntry( 0x007a4ad8, 00001, "", "" ),
            new TSymLookupEntry( 0x007a4e80, 00001, "", "" ),
            new TSymLookupEntry( 0x007a53a0, 00001, "", "" ),
            new TSymLookupEntry( 0x007a54e0, 00001, "", "" ),
            new TSymLookupEntry( 0x007a5710, 00001, "", "" ),
            new TSymLookupEntry( 0x007a5b58, 00001, "", "" ),
            new TSymLookupEntry( 0x007a5e08, 00001, "", "" ),
            new TSymLookupEntry( 0x007a6148, 00001, "", "" ),
            new TSymLookupEntry( 0x007a6530, 00001, "", "" ),
            new TSymLookupEntry( 0x007a6b88, 00001, "", "" ),
            new TSymLookupEntry( 0x007a732c, 00001, "", "" ),
            new TSymLookupEntry( 0x007a7b38, 00001, "", "" ),
            new TSymLookupEntry( 0x007a7c08, 00001, "", "" ),
            new TSymLookupEntry( 0x007a7de8, 00001, "", "" ),
            new TSymLookupEntry( 0x007a7e38, 00001, "", "" ),
            new TSymLookupEntry( 0x007a7f78, 00001, "", "" ),
            new TSymLookupEntry( 0x007a87a8, 00001, "", "" ),
            new TSymLookupEntry( 0x007a89d8, 00001, "", "" ),
            new TSymLookupEntry( 0x007a9470, 00001, "", "" ),
            new TSymLookupEntry( 0x007a9728, 00001, "", "" ),
            new TSymLookupEntry( 0x007a9778, 00001, "", "" ),
            new TSymLookupEntry( 0x007a9868, 00001, "", "" ),
            new TSymLookupEntry( 0x007a9aa0, 00001, "", "" ),
            new TSymLookupEntry( 0x007a9b90, 00001, "", "" ),
            new TSymLookupEntry( 0x007a9d70, 00001, "", "" ),
            new TSymLookupEntry( 0x007a9fd8, 00001, "", "" ),
            new TSymLookupEntry( 0x007aa300, 00001, "", "" ),
            new TSymLookupEntry( 0x007aa510, 00001, "", "" ),
            new TSymLookupEntry( 0x007aa7c0, 00001, "", "" ),
            new TSymLookupEntry( 0x007aabd8, 00001, "", "" ),
            new TSymLookupEntry( 0x007ab358, 00001, "", "" ),
            new TSymLookupEntry( 0x007ab448, 00001, "", "" ),
            new TSymLookupEntry( 0x007ab748, 00001, "", "" ),
            new TSymLookupEntry( 0x007abac0, 00001, "", "" ),
            new TSymLookupEntry( 0x007ac690, 00001, "", "" ),
            new TSymLookupEntry( 0x007ad618, 00001, "", "" ),
            new TSymLookupEntry( 0x007adc80, 00001, "", "" ),
            new TSymLookupEntry( 0x007adde8, 00001, "", "" ),
            new TSymLookupEntry( 0x007ae260, 00001, "", "" ),
            new TSymLookupEntry( 0x007ae8a8, 00001, "", "" ),
            new TSymLookupEntry( 0x007aea60, 00001, "", "" ),
            new TSymLookupEntry( 0x007aeda8, 00001, "", "" ),
            new TSymLookupEntry( 0x007af1e0, 00001, "", "" ),
            new TSymLookupEntry( 0x007af990, 00001, "", "" ),
            new TSymLookupEntry( 0x007afc10, 00001, "", "" ),
            new TSymLookupEntry( 0x007b0030, 00002, "", "" ),
            new TSymLookupEntry( 0x007b0067, 00001, "", "" ),
            new TSymLookupEntry( 0x007b0069, 00002, "", "" ),
            new TSymLookupEntry( 0x007b0120, 00001, "", "" ),
            new TSymLookupEntry( 0x007b0b50, 00001, "", "" ),
            new TSymLookupEntry( 0x007b0f7c, 00001, "", "" ),
            new TSymLookupEntry( 0x007b0f80, 00001, "", "" ),
            new TSymLookupEntry( 0x007b22e8, 00001, "", "" ),
            new TSymLookupEntry( 0x007b26c0, 00001, "", "" ),
            new TSymLookupEntry( 0x007b3078, 00001, "", "" ),
            new TSymLookupEntry( 0x007b30c8, 00001, "", "" ),
            new TSymLookupEntry( 0x007b31b8, 00001, "", "" ),
            new TSymLookupEntry( 0x007b3258, 00001, "", "" ),
            new TSymLookupEntry( 0x007b35a8, 00001, "", "" ),
            new TSymLookupEntry( 0x007b3bf0, 00001, "", "" ),
            new TSymLookupEntry( 0x007b3f48, 00001, "", "" ),
            new TSymLookupEntry( 0x007b42d8, 00001, "", "" ),
            new TSymLookupEntry( 0x007b46c8, 00001, "", "" ),
            new TSymLookupEntry( 0x007b5000, 00001, "", "" ),
            new TSymLookupEntry( 0x007b5958, 00001, "", "" ),
            new TSymLookupEntry( 0x007b5a20, 00001, "", "" ),
            new TSymLookupEntry( 0x007b5ce8, 00001, "", "" ),
            new TSymLookupEntry( 0x007b5d38, 00001, "", "" ),
            new TSymLookupEntry( 0x007b5ef0, 00001, "", "" ),
            new TSymLookupEntry( 0x007b60f0, 00001, "", "" ),
            new TSymLookupEntry( 0x007b6580, 00001, "", "" ),
            new TSymLookupEntry( 0x007b6838, 00001, "", "" ),
            new TSymLookupEntry( 0x007b6df8, 00001, "", "" ),
            new TSymLookupEntry( 0x007b6fb0, 00001, "", "" ),
            new TSymLookupEntry( 0x007b70f0, 00001, "", "" ),
            new TSymLookupEntry( 0x007b7848, 00001, "", "" ),
            new TSymLookupEntry( 0x007b7a28, 00001, "", "" ),
            new TSymLookupEntry( 0x007b9370, 00001, "", "" ),
            new TSymLookupEntry( 0x007b9b28, 00001, "", "" ),
            new TSymLookupEntry( 0x007ba2e0, 00001, "", "" ),
            new TSymLookupEntry( 0x007ba7e8, 00001, "", "" ),
            new TSymLookupEntry( 0x007bae50, 00001, "", "" ),
            new TSymLookupEntry( 0x007bb928, 00001, "", "" ),
            new TSymLookupEntry( 0x007bc9a8, 00001, "", "" ),
            new TSymLookupEntry( 0x007bcca0, 00001, "", "" ),
            new TSymLookupEntry( 0x007bce60, 00001, "", "" ),
            new TSymLookupEntry( 0x007bd108, 00001, "", "" ),
            new TSymLookupEntry( 0x007bd758, 00001, "", "" ),
            new TSymLookupEntry( 0x007bd848, 00001, "", "" ),
            new TSymLookupEntry( 0x007bda00, 00001, "", "" ),
            new TSymLookupEntry( 0x007bdf08, 00001, "", "" ),
            new TSymLookupEntry( 0x007be648, 00001, "", "" ),
            new TSymLookupEntry( 0x007bedd0, 00001, "", "" ),
            new TSymLookupEntry( 0x007bf000, 00001, "", "" ),
            new TSymLookupEntry( 0x007bf5d0, 00001, "", "" ),
            new TSymLookupEntry( 0x007bf948, 00001, "", "" ),
            new TSymLookupEntry( 0x007bfbc8, 00001, "", "" ),
            new TSymLookupEntry( 0x007bfd10, 00001, "", "" ),
            new TSymLookupEntry( 0x007bfe78, 00001, "", "" ),
            new TSymLookupEntry( 0x007c0026, 00002, "", "" ),
            new TSymLookupEntry( 0x007c003f, 00002, "", "" ),
            new TSymLookupEntry( 0x007c0210, 00001, "", "" ),
            new TSymLookupEntry( 0x007c0830, 00001, "", "" ),
            new TSymLookupEntry( 0x007c0cf8, 00001, "", "" ),
            new TSymLookupEntry( 0x007c0f30, 00001, "", "" ),
            new TSymLookupEntry( 0x007c1208, 00001, "", "" ),
            new TSymLookupEntry( 0x007c1580, 00001, "", "" ),
            new TSymLookupEntry( 0x007c1be0, 00001, "", "" ),
            new TSymLookupEntry( 0x007c23f0, 00001, "", "" ),
            new TSymLookupEntry( 0x007c26d8, 00001, "", "" ),
            new TSymLookupEntry( 0x007c2928, 00001, "", "" ),
            new TSymLookupEntry( 0x007c2978, 00001, "", "" ),
            new TSymLookupEntry( 0x007c2c60, 00001, "", "" ),
            new TSymLookupEntry( 0x007c2cb0, 00001, "", "" ),
            new TSymLookupEntry( 0x007c3050, 00001, "", "" ),
            new TSymLookupEntry( 0x007c3210, 00005, "", "" ),
            new TSymLookupEntry( 0x007c33a8, 00001, "", "" ),
            new TSymLookupEntry( 0x007c3628, 00001, "", "" ),
            new TSymLookupEntry( 0x007c3b58, 00001, "", "" ),
            new TSymLookupEntry( 0x007c3c48, 00001, "", "" ),
            new TSymLookupEntry( 0x007c3ea0, 00001, "", "" ),
            new TSymLookupEntry( 0x007c4050, 00001, "", "" ),
            new TSymLookupEntry( 0x007c4d28, 00001, "", "" ),
            new TSymLookupEntry( 0x007c5050, 00001, "", "" ),
            new TSymLookupEntry( 0x007c52d0, 00001, "", "" ),
            new TSymLookupEntry( 0x007c5620, 00001, "", "" ),
            new TSymLookupEntry( 0x007c5bac, 00001, "", "" ),
            new TSymLookupEntry( 0x007c5dc0, 00001, "", "" ),
            new TSymLookupEntry( 0x007c6cf0, 00001, "", "" ),
            new TSymLookupEntry( 0x007c7148, 00001, "", "" ),
            new TSymLookupEntry( 0x007c73c8, 00001, "", "" ),
            new TSymLookupEntry( 0x007c7710, 00001, "", "" ),
            new TSymLookupEntry( 0x007c8230, 00001, "", "" ),
            new TSymLookupEntry( 0x007c8470, 00001, "", "" ),
            new TSymLookupEntry( 0x007c88f8, 00001, "", "" ),
            new TSymLookupEntry( 0x007c9200, 00001, "", "" ),
            new TSymLookupEntry( 0x007c92a0, 00001, "", "" ),
            new TSymLookupEntry( 0x007c9ba8, 00001, "", "" ),
            new TSymLookupEntry( 0x007cb5d0, 00001, "", "" ),
            new TSymLookupEntry( 0x007cbce8, 00001, "", "" ),
            new TSymLookupEntry( 0x007cbd48, 00001, "", "" ),
            new TSymLookupEntry( 0x007cf338, 00001, "", "" ),
            new TSymLookupEntry( 0x007cf848, 00001, "", "" ),
            new TSymLookupEntry( 0x007cfa58, 00001, "", "" ),
            new TSymLookupEntry( 0x007d0031, 00001, "", "" ),
            new TSymLookupEntry( 0x007d003b, 00001, "", "" ),
            new TSymLookupEntry( 0x007d0210, 00001, "", "" ),
            new TSymLookupEntry( 0x007d06f0, 00003, "", "" ),
            new TSymLookupEntry( 0x007d0868, 00001, "", "" ),
            new TSymLookupEntry( 0x007d0c60, 00001, "", "" ),
            new TSymLookupEntry( 0x007d0f60, 00001, "", "" ),
            new TSymLookupEntry( 0x007d1280, 00001, "", "" ),
            new TSymLookupEntry( 0x007d1978, 00001, "", "" ),
            new TSymLookupEntry( 0x007d1bdc, 00001, "", "" ),
            new TSymLookupEntry( 0x007d2514, 00001, "", "" ),
            new TSymLookupEntry( 0x007d29f0, 00001, "", "" ),
            new TSymLookupEntry( 0x007d2a98, 00001, "", "" ),
            new TSymLookupEntry( 0x007d2d40, 00001, "", "" ),
            new TSymLookupEntry( 0x007d2d90, 00001, "", "" ),
            new TSymLookupEntry( 0x007d3168, 00001, "", "" ),
            new TSymLookupEntry( 0x007d3648, 00001, "", "" ),
            new TSymLookupEntry( 0x007d38d0, 00001, "", "" ),
            new TSymLookupEntry( 0x007d3e88, 00001, "", "" ),
            new TSymLookupEntry( 0x007d4120, 00001, "", "" ),
            new TSymLookupEntry( 0x007d44f0, 00001, "", "" ),
            new TSymLookupEntry( 0x007d4cc0, 00001, "", "" ),
            new TSymLookupEntry( 0x007d5900, 00001, "", "" ),
            new TSymLookupEntry( 0x007d5a68, 00001, "", "" ),
            new TSymLookupEntry( 0x007d5ab8, 00001, "", "" ),
            new TSymLookupEntry( 0x007d5c28, 00001, "", "" ),
            new TSymLookupEntry( 0x007d5d68, 00001, "", "" ),
            new TSymLookupEntry( 0x007d61f0, 00001, "", "" ),
            new TSymLookupEntry( 0x007d64c0, 00001, "", "" ),
            new TSymLookupEntry( 0x007d6950, 00001, "", "" ),
            new TSymLookupEntry( 0x007d6cc8, 00001, "", "" ),
            new TSymLookupEntry( 0x007d6de0, 00001, "", "" ),
            new TSymLookupEntry( 0x007d7450, 00001, "", "" ),
            new TSymLookupEntry( 0x007d7658, 00001, "", "" ),
            new TSymLookupEntry( 0x007d8bd8, 00001, "", "" ),
            new TSymLookupEntry( 0x007d8ec8, 00001, "", "" ),
            new TSymLookupEntry( 0x007d8f20, 00001, "", "" ),
            new TSymLookupEntry( 0x007d8f70, 00002, "", "" ),
            new TSymLookupEntry( 0x007d9360, 00001, "", "" ),
            new TSymLookupEntry( 0x007d9428, 00001, "", "" ),
            new TSymLookupEntry( 0x007d97c0, 00001, "", "" ),
            new TSymLookupEntry( 0x007d9cd8, 00001, "", "" ),
            new TSymLookupEntry( 0x007da500, 00001, "", "" ),
            new TSymLookupEntry( 0x007da740, 00001, "", "" ),
            new TSymLookupEntry( 0x007daa48, 00001, "", "" ),
            new TSymLookupEntry( 0x007dac28, 00001, "", "" ),
            new TSymLookupEntry( 0x007dae80, 00001, "", "" ),
            new TSymLookupEntry( 0x007db280, 00001, "", "" ),
            new TSymLookupEntry( 0x007db3a0, 00001, "", "" ),
            new TSymLookupEntry( 0x007dbc58, 00001, "", "" ),
            new TSymLookupEntry( 0x007dbed8, 00001, "", "" ),
            new TSymLookupEntry( 0x007dc418, 00001, "", "" ),
            new TSymLookupEntry( 0x007dc838, 00001, "", "" ),
            new TSymLookupEntry( 0x007dc980, 00001, "", "" ),
            new TSymLookupEntry( 0x007dd0a0, 00001, "", "" ),
            new TSymLookupEntry( 0x007ddbf0, 00001, "", "" ),
            new TSymLookupEntry( 0x007de260, 00001, "", "" ),
            new TSymLookupEntry( 0x007de768, 00001, "", "" ),
            new TSymLookupEntry( 0x007df1b8, 00001, "", "" ),
            new TSymLookupEntry( 0x007e0026, 00001, "", "" ),
            new TSymLookupEntry( 0x007e002b, 00001, "", "" ),
            new TSymLookupEntry( 0x007e0030, 00001, "", "" ),
            new TSymLookupEntry( 0x007e0067, 00001, "", "" ),
            new TSymLookupEntry( 0x007e2910, 00001, "", "" ),
            new TSymLookupEntry( 0x007e38e0, 00001, "", "" ),
            new TSymLookupEntry( 0x007e3bbc, 00001, "", "" ),
            new TSymLookupEntry( 0x007e3f08, 00001, "", "" ),
            new TSymLookupEntry( 0x007e5670, 00001, "", "" ),
            new TSymLookupEntry( 0x007e69a8, 00001, "", "" ),
            new TSymLookupEntry( 0x007e6a20, 00001, "", "" ),
            new TSymLookupEntry( 0x007e70a0, 00001, "", "" ),
            new TSymLookupEntry( 0x007e7538, 00001, "", "" ),
            new TSymLookupEntry( 0x007e7680, 00001, "", "" ),
            new TSymLookupEntry( 0x007e7fa0, 00001, "", "" ),
            new TSymLookupEntry( 0x007e8240, 00001, "", "" ),
            new TSymLookupEntry( 0x007e9358, 00001, "", "" ),
            new TSymLookupEntry( 0x007e9408, 00001, "", "" ),
            new TSymLookupEntry( 0x007e97d0, 00001, "", "" ),
            new TSymLookupEntry( 0x007e9878, 00001, "", "" ),
            new TSymLookupEntry( 0x007e9b28, 00001, "", "" ),
            new TSymLookupEntry( 0x007e9ba0, 00001, "", "" ),
            new TSymLookupEntry( 0x007ea120, 00001, "", "" ),
            new TSymLookupEntry( 0x007ea448, 00001, "", "" ),
            new TSymLookupEntry( 0x007ea978, 00001, "", "" ),
            new TSymLookupEntry( 0x007eac30, 00001, "", "" ),
            new TSymLookupEntry( 0x007ead20, 00001, "", "" ),
            new TSymLookupEntry( 0x007eb000, 00001, "", "" ),
            new TSymLookupEntry( 0x007eb148, 00001, "", "" ),
            new TSymLookupEntry( 0x007eb6a8, 00001, "", "" ),
            new TSymLookupEntry( 0x007eb870, 00001, "", "" ),
            new TSymLookupEntry( 0x007ebb20, 00001, "", "" ),
            new TSymLookupEntry( 0x007ec190, 00001, "", "" ),
            new TSymLookupEntry( 0x007ec808, 00001, "", "" ),
            new TSymLookupEntry( 0x007ed5b8, 00001, "", "" ),
            new TSymLookupEntry( 0x007ed928, 00001, "", "" ),
            new TSymLookupEntry( 0x007ed978, 00004, "", "" ),
            new TSymLookupEntry( 0x007eda48, 00001, "", "" ),
            new TSymLookupEntry( 0x007ede48, 00001, "", "" ),
            new TSymLookupEntry( 0x007edfb8, 00001, "", "" ),
            new TSymLookupEntry( 0x007ee648, 00001, "", "" ),
            new TSymLookupEntry( 0x007ee698, 00001, "", "" ),
            new TSymLookupEntry( 0x007ee8f0, 00001, "", "" ),
            new TSymLookupEntry( 0x007eeb78, 00001, "", "" ),
            new TSymLookupEntry( 0x007eeea8, 00001, "", "" ),
            new TSymLookupEntry( 0x007ef268, 00001, "", "" ),
            new TSymLookupEntry( 0x007ef588, 00001, "", "" ),
            new TSymLookupEntry( 0x007efac8, 00001, "", "" ),
            new TSymLookupEntry( 0x007efe68, 00001, "", "" ),
            new TSymLookupEntry( 0x007f0030, 00001, "", "" ),
            new TSymLookupEntry( 0x007f0031, 00001, "", "" ),
            new TSymLookupEntry( 0x007f0250, 00001, "", "" ),
            new TSymLookupEntry( 0x007f0be4, 00001, "", "" ),
            new TSymLookupEntry( 0x007f1758, 00001, "", "" ),
            new TSymLookupEntry( 0x007f1c30, 00001, "", "" ),
            new TSymLookupEntry( 0x007f1de8, 00001, "", "" ),
            new TSymLookupEntry( 0x007f1f08, 00001, "", "" ),
            new TSymLookupEntry( 0x007f21b8, 00001, "", "" ),
            new TSymLookupEntry( 0x007f28e8, 00001, "", "" ),
            new TSymLookupEntry( 0x007f2a78, 00001, "", "" ),
            new TSymLookupEntry( 0x007f36e8, 00001, "", "" ),
            new TSymLookupEntry( 0x007f39c8, 00001, "", "" ),
            new TSymLookupEntry( 0x007f3a18, 00001, "", "" ),
            new TSymLookupEntry( 0x007f3e80, 00001, "", "" ),
            new TSymLookupEntry( 0x007f3ed0, 00001, "", "" ),
            new TSymLookupEntry( 0x007f4528, 00001, "", "" ),
            new TSymLookupEntry( 0x007f4ad0, 00001, "", "" ),
            new TSymLookupEntry( 0x007f50f0, 00001, "", "" ),
            new TSymLookupEntry( 0x007f5348, 00001, "", "" ),
            new TSymLookupEntry( 0x007f5398, 00001, "", "" ),
            new TSymLookupEntry( 0x007f5528, 00001, "", "" ),
            new TSymLookupEntry( 0x007f5690, 00001, "", "" ),
            new TSymLookupEntry( 0x007f5b98, 00001, "", "" ),
            new TSymLookupEntry( 0x007f5cd8, 00001, "", "" ),
            new TSymLookupEntry( 0x007f6078, 00001, "", "" ),
            new TSymLookupEntry( 0x007f6258, 00001, "", "" ),
            new TSymLookupEntry( 0x007f67e0, 00001, "", "" ),
            new TSymLookupEntry( 0x007f7598, 00001, "", "" ),
            new TSymLookupEntry( 0x007f78c0, 00001, "", "" ),
            new TSymLookupEntry( 0x007f79b0, 00001, "", "" ),
            new TSymLookupEntry( 0x007f7da8, 00001, "", "" ),
            new TSymLookupEntry( 0x007f82d8, 00001, "", "" ),
            new TSymLookupEntry( 0x007f8788, 00001, "", "" ),
            new TSymLookupEntry( 0x007f8ba0, 00001, "", "" ),
            new TSymLookupEntry( 0x007f9050, 00001, "", "" ),
            new TSymLookupEntry( 0x007f9370, 00001, "", "" ),
            new TSymLookupEntry( 0x007f9668, 00001, "", "" ),
            new TSymLookupEntry( 0x007f9bb0, 00001, "", "" ),
            new TSymLookupEntry( 0x007fa140, 00001, "", "" ),
            new TSymLookupEntry( 0x007fa320, 00001, "", "" ),
            new TSymLookupEntry( 0x007fa8ec, 00001, "", "" ),
            new TSymLookupEntry( 0x007fac80, 00001, "", "" ),
            new TSymLookupEntry( 0x007fc0c8, 00001, "", "" ),
            new TSymLookupEntry( 0x007fc118, 00001, "", "" ),
            new TSymLookupEntry( 0x007fc208, 00001, "", "" ),
            new TSymLookupEntry( 0x007fc438, 00001, "", "" ),
            new TSymLookupEntry( 0x007fc500, 00001, "", "" ),
            new TSymLookupEntry( 0x007fcaa0, 00001, "", "" ),
            new TSymLookupEntry( 0x007fd190, 00001, "", "" ),
            new TSymLookupEntry( 0x007fd2d0, 00001, "", "" ),
            new TSymLookupEntry( 0x007fda78, 00001, "", "" ),
            new TSymLookupEntry( 0x007fdce0, 00001, "", "" ),
            new TSymLookupEntry( 0x007fe5d0, 00001, "", "" ),
            new TSymLookupEntry( 0x007febc8, 00001, "", "" ),
            new TSymLookupEntry( 0x007feda8, 00001, "", "" ),
            new TSymLookupEntry( 0x007feec0, 00001, "", "" ),
            new TSymLookupEntry( 0x007fef38, 00001, "", "" ),
            new TSymLookupEntry( 0x007ff460, 00001, "", "" ),
            new TSymLookupEntry( 0x007ff578, 00001, "", "" ),
            new TSymLookupEntry( 0x007ff8d8, 00001, "", "" ),
            new TSymLookupEntry( 0x007ffde0, 00001, "", "" ),
            new TSymLookupEntry( 0x007ffe30, 00001, "", "" ),
            new TSymLookupEntry( 0x00800020, 00001, "", "" ),
            new TSymLookupEntry( 0x00800030, 00001, "", "" ),
            new TSymLookupEntry( 0x00800069, 00001, "", "" ),
            new TSymLookupEntry( 0x00800110, 00001, "", "" ),
            new TSymLookupEntry( 0x008008e8, 00001, "", "" ),
            new TSymLookupEntry( 0x00800aa8, 00001, "", "" ),
            new TSymLookupEntry( 0x00800c20, 00001, "", "" ),
            new TSymLookupEntry( 0x00801078, 00001, "", "" ),
            new TSymLookupEntry( 0x00801798, 00001, "", "" ),
            new TSymLookupEntry( 0x00801c08, 00001, "", "" ),
            new TSymLookupEntry( 0x00802618, 00001, "", "" ),
            new TSymLookupEntry( 0x00803bd8, 00001, "", "" ),
            new TSymLookupEntry( 0x00803c78, 00001, "", "" ),
            new TSymLookupEntry( 0x00803db8, 00001, "", "" ),
            new TSymLookupEntry( 0x00804320, 00001, "", "" ),
            new TSymLookupEntry( 0x00804670, 00001, "", "" ),
            new TSymLookupEntry( 0x00804830, 00001, "", "" ),
            new TSymLookupEntry( 0x00804d18, 00001, "", "" ),
            new TSymLookupEntry( 0x008054f8, 00001, "", "" ),
            new TSymLookupEntry( 0x00805590, 00001, "", "" ),
            new TSymLookupEntry( 0x008059c8, 00001, "", "" ),
            new TSymLookupEntry( 0x00805e28, 00001, "", "" ),
            new TSymLookupEntry( 0x008062a8, 00001, "", "" ),
            new TSymLookupEntry( 0x00806644, 00001, "", "" ),
            new TSymLookupEntry( 0x00806e64, 00001, "", "" ),
            new TSymLookupEntry( 0x00808ec0, 00001, "", "" ),
            new TSymLookupEntry( 0x00808f10, 00001, "", "" ),
            new TSymLookupEntry( 0x008092b0, 00001, "", "" ),
            new TSymLookupEntry( 0x008094e8, 00001, "", "" ),
            new TSymLookupEntry( 0x00809d48, 00001, "", "" ),
            new TSymLookupEntry( 0x0080a028, 00001, "", "" ),
            new TSymLookupEntry( 0x0080a230, 00001, "", "" ),
            new TSymLookupEntry( 0x0080a618, 00001, "", "" ),
            new TSymLookupEntry( 0x0080b000, 00001, "", "" ),
            new TSymLookupEntry( 0x0080b628, 00001, "", "" ),
            new TSymLookupEntry( 0x0080c810, 00001, "", "" ),
            new TSymLookupEntry( 0x0080cba8, 00001, "", "" ),
            new TSymLookupEntry( 0x0080cce8, 00001, "", "" ),
            new TSymLookupEntry( 0x0080d2d8, 00001, "", "" ),
            new TSymLookupEntry( 0x0080d470, 00001, "", "" ),
            new TSymLookupEntry( 0x0080d860, 00001, "", "" ),
            new TSymLookupEntry( 0x0080d9c8, 00001, "", "" ),
            new TSymLookupEntry( 0x0080db08, 00001, "", "" ),
            new TSymLookupEntry( 0x0080e308, 00001, "", "" ),
            new TSymLookupEntry( 0x0080e420, 00001, "", "" ),
            new TSymLookupEntry( 0x0080eb18, 00001, "", "" ),
            new TSymLookupEntry( 0x0080edf8, 00001, "", "" ),
            new TSymLookupEntry( 0x0080f118, 00001, "", "" ),
            new TSymLookupEntry( 0x00813ea8, 00001, "", "" ),
            new TSymLookupEntry( 0x0081fdd0, 00001, "", "" ),
            new TSymLookupEntry( 0x00820260, 00006, "", "" ),
            new TSymLookupEntry( 0x008203dc, 00001, "", "" ),
            new TSymLookupEntry( 0x008205ec, 00001, "", "" ),
            new TSymLookupEntry( 0x00820b3c, 00001, "", "" ),
            new TSymLookupEntry( 0x00820e14, 00001, "", "" ),
            new TSymLookupEntry( 0x00821a18, 00001, "", "" ),
            new TSymLookupEntry( 0x00822f88, 00001, "", "" ),
            new TSymLookupEntry( 0x00823708, 00001, "", "" ),
            new TSymLookupEntry( 0x00823d14, 00001, "", "" ),
            new TSymLookupEntry( 0x00823fa0, 00001, "", "" ),
            new TSymLookupEntry( 0x008242dc, 00001, "", "" ),
            new TSymLookupEntry( 0x00824aa8, 00001, "", "" ),
            new TSymLookupEntry( 0x00824fb4, 00001, "", "" ),
            new TSymLookupEntry( 0x008259c0, 00001, "", "" ),
            new TSymLookupEntry( 0x00826124, 00001, "", "" ),
            new TSymLookupEntry( 0x00826730, 00001, "", "" ),
            new TSymLookupEntry( 0x00827190, 00001, "", "" ),
            new TSymLookupEntry( 0x008276a0, 00001, "", "" ),
            new TSymLookupEntry( 0x008279dc, 00001, "", "" ),
            new TSymLookupEntry( 0x00827c00, 00001, "", "" ),
            new TSymLookupEntry( 0x008280dc, 00001, "", "" ),
            new TSymLookupEntry( 0x008286e4, 00001, "", "" ),
            new TSymLookupEntry( 0x008292f4, 00001, "", "" ),
            new TSymLookupEntry( 0x0082aae8, 00001, "", "" ),
            new TSymLookupEntry( 0x0082b950, 00001, "", "" ),
            new TSymLookupEntry( 0x0082c984, 00001, "", "" ),
            new TSymLookupEntry( 0x0082daa0, 00001, "", "" ),
            new TSymLookupEntry( 0x0082dbec, 00001, "", "" ),
            new TSymLookupEntry( 0x0082f40c, 00001, "", "" ),
            new TSymLookupEntry( 0x00830001, 00001, "", "" ),
            new TSymLookupEntry( 0x00830010, 00001, "", "" ),
            new TSymLookupEntry( 0x00830c2c, 00001, "", "" ),
            new TSymLookupEntry( 0x00833f1c, 00003, "", "" ),
            new TSymLookupEntry( 0x00833f20, 00001, "", "" ),
            new TSymLookupEntry( 0x0083ea04, 00001, "", "" ),
            new TSymLookupEntry( 0x00840001, 00001, "", "" ),
            new TSymLookupEntry( 0x008403e0, 00001, "", "" ),
            new TSymLookupEntry( 0x00840fa0, 00001, "", "" ),
            new TSymLookupEntry( 0x008414e4, 00002, "", "" ),
            new TSymLookupEntry( 0x00841834, 00001, "", "" ),
            new TSymLookupEntry( 0x008422e0, 00001, "", "" ),
            new TSymLookupEntry( 0x008439f4, 00001, "", "" ),
            new TSymLookupEntry( 0x00843eec, 00001, "", "" ),
            new TSymLookupEntry( 0x00844ab4, 00001, "", "" ),
            new TSymLookupEntry( 0x00846218, 00001, "", "" ),
            new TSymLookupEntry( 0x00846498, 00001, "", "" ),
            new TSymLookupEntry( 0x008465ec, 00001, "", "" ),
            new TSymLookupEntry( 0x008574ec, 00001, "", "" ),
            new TSymLookupEntry( 0x00857e1c, 00001, "", "" ),
            new TSymLookupEntry( 0x0085a398, 00001, "", "" ),
            new TSymLookupEntry( 0x0085a440, 00001, "", "" ),
            new TSymLookupEntry( 0x0085a4d4, 00001, "", "" ),
            new TSymLookupEntry( 0x0085a7d0, 00001, "", "" ),
            new TSymLookupEntry( 0x0085bf34, 00001, "", "" ),
            new TSymLookupEntry( 0x0085c058, 00001, "", "" ),
            new TSymLookupEntry( 0x0085d14c, 00001, "", "" ),
            new TSymLookupEntry( 0x0085d658, 00001, "", "" ),
            new TSymLookupEntry( 0x0085de78, 00001, "", "" ),
            new TSymLookupEntry( 0x0085f778, 00001, "", "" ),
            new TSymLookupEntry( 0x0085f988, 00001, "", "" ),
            new TSymLookupEntry( 0x008606ac, 00001, "", "" ),
            new TSymLookupEntry( 0x00860f88, 00001, "", "" ),
            new TSymLookupEntry( 0x008614d0, 00001, "", "" ),
            new TSymLookupEntry( 0x00861b68, 00001, "", "" ),
            new TSymLookupEntry( 0x00862f74, 00001, "", "" ),
            new TSymLookupEntry( 0x00863c58, 00016, "", "" ),
            new TSymLookupEntry( 0x00864a18, 00001, "", "" ),
            new TSymLookupEntry( 0x0086513c, 00001, "", "" ),
            new TSymLookupEntry( 0x00865ef8, 00001, "", "" ),
            new TSymLookupEntry( 0x008682e8, 00001, "", "" ),
            new TSymLookupEntry( 0x008685b0, 00001, "", "" ),
            new TSymLookupEntry( 0x00868630, 00001, "", "" ),
            new TSymLookupEntry( 0x00868800, 00002, "", "" ),
            new TSymLookupEntry( 0x008688e8, 00001, "", "" ),
            new TSymLookupEntry( 0x008694b8, 00001, "", "" ),
            new TSymLookupEntry( 0x00869910, 00001, "", "" ),
            new TSymLookupEntry( 0x0086a518, 00001, "", "" ),
            new TSymLookupEntry( 0x0086aab8, 00001, "", "" ),
            new TSymLookupEntry( 0x0086b318, 00001, "", "" ),
            new TSymLookupEntry( 0x0086c268, 00001, "", "" ),
            new TSymLookupEntry( 0x0086c3c0, 00001, "", "" ),
            new TSymLookupEntry( 0x0086c6b0, 00001, "", "" ),
            new TSymLookupEntry( 0x0086c868, 00001, "", "" ),
            new TSymLookupEntry( 0x0086eff0, 00001, "", "" ),
            new TSymLookupEntry( 0x0086f4e0, 00001, "", "" ),
            new TSymLookupEntry( 0x0086fab8, 00001, "", "" ),
            new TSymLookupEntry( 0x00870e80, 00001, "", "" ),
            new TSymLookupEntry( 0x00872a78, 00001, "", "" ),
            new TSymLookupEntry( 0x00873b34, 00001, "", "" ),
            new TSymLookupEntry( 0x00873fd0, 00001, "", "" ),
            new TSymLookupEntry( 0x00874548, 00001, "", "" ),
            new TSymLookupEntry( 0x008745f0, 00001, "", "" ),
            new TSymLookupEntry( 0x00879290, 00001, "", "" ),
            new TSymLookupEntry( 0x008794ac, 00001, "", "" ),
            new TSymLookupEntry( 0x00879750, 00001, "", "" ),
            new TSymLookupEntry( 0x00879a70, 00001, "", "" ),
            new TSymLookupEntry( 0x00879cdc, 00001, "", "" ),
            new TSymLookupEntry( 0x0087a178, 00001, "", "" ),
            new TSymLookupEntry( 0x0087b478, 00001, "", "" ),
            new TSymLookupEntry( 0x0087b9d0, 00001, "", "" ),
            new TSymLookupEntry( 0x0087c308, 00001, "", "" ),
            new TSymLookupEntry( 0x0087ce10, 00001, "", "" ),
            new TSymLookupEntry( 0x0087d828, 00001, "", "" ),
            new TSymLookupEntry( 0x0087de40, 00001, "", "" ),
            new TSymLookupEntry( 0x00880030, 00003, "", "" ),
            new TSymLookupEntry( 0x008832f8, 00001, "", "" ),
            new TSymLookupEntry( 0x00883c48, 00001, "", "" ),
            new TSymLookupEntry( 0x00885e68, 00001, "", "" ),
            new TSymLookupEntry( 0x00886568, 00001, "", "" ),
            new TSymLookupEntry( 0x00890010, 00001, "", "" ),
            new TSymLookupEntry( 0x00895c10, 00001, "", "" ),
            new TSymLookupEntry( 0x0089cd40, 00001, "", "" ),
            new TSymLookupEntry( 0x0089d3b0, 00001, "", "" ),
            new TSymLookupEntry( 0x0089ef68, 00001, "", "" ),
            new TSymLookupEntry( 0x0089fb20, 00001, "", "" ),
            new TSymLookupEntry( 0x008a1d08, 00001, "", "" ),
            new TSymLookupEntry( 0x008a1e10, 00001, "", "" ),
            new TSymLookupEntry( 0x008a2370, 00001, "", "" ),
            new TSymLookupEntry( 0x008a4440, 00001, "", "" ),
            new TSymLookupEntry( 0x008a4a18, 00001, "", "" ),
            new TSymLookupEntry( 0x008a6ae8, 00001, "", "" ),
            new TSymLookupEntry( 0x008a7460, 00001, "", "" ),
            new TSymLookupEntry( 0x008a80a4, 00001, "", "" ),
            new TSymLookupEntry( 0x008a8a38, 00001, "", "" ),
            new TSymLookupEntry( 0x008a99c8, 00001, "", "" ),
            new TSymLookupEntry( 0x008bc000, 00001, "", "" ),
            new TSymLookupEntry( 0x008bd3d0, 00001, "", "" ),
            new TSymLookupEntry( 0x008bd420, 00001, "", "" ),
            new TSymLookupEntry( 0x008bd448, 00001, "", "" ),
            new TSymLookupEntry( 0x008bd58c, 00001, "", "" ),
            new TSymLookupEntry( 0x008be188, 00001, "", "" ),
            new TSymLookupEntry( 0x008be6f8, 00001, "", "" ),
            new TSymLookupEntry( 0x008be770, 00001, "", "" ),
            new TSymLookupEntry( 0x008bec8c, 00001, "", "" ),
            new TSymLookupEntry( 0x008bf870, 00001, "", "" ),
            new TSymLookupEntry( 0x008bf9b4, 00001, "", "" ),
            new TSymLookupEntry( 0x008c0000, 00002, "", "" ),
            new TSymLookupEntry( 0x008c05b0, 00001, "", "" ),
            new TSymLookupEntry( 0x008c0700, 00001, "", "" ),
            new TSymLookupEntry( 0x008c12f0, 00001, "", "" ),
            new TSymLookupEntry( 0x008c1474, 00001, "", "" ),
            new TSymLookupEntry( 0x008c2058, 00001, "", "" ),
            new TSymLookupEntry( 0x008c226c, 00001, "", "" ),
            new TSymLookupEntry( 0x008c2e68, 00001, "", "" ),
            new TSymLookupEntry( 0x008c2fc0, 00001, "", "" ),
            new TSymLookupEntry( 0x008c2fe8, 00001, "", "" ),
            new TSymLookupEntry( 0x008c3010, 00001, "", "" ),
            new TSymLookupEntry( 0x008c3060, 00001, "", "" ),
            new TSymLookupEntry( 0x008c3088, 00001, "", "" ),
            new TSymLookupEntry( 0x008c30d8, 00001, "", "" ),
            new TSymLookupEntry( 0x008c3150, 00001, "", "" ),
            new TSymLookupEntry( 0x008c41bc, 00001, "", "" ),
            new TSymLookupEntry( 0x008c4da0, 00001, "", "" ),
            new TSymLookupEntry( 0x008c4ee4, 00001, "", "" ),
            new TSymLookupEntry( 0x008c5ae0, 00001, "", "" ),
            new TSymLookupEntry( 0x008c5c30, 00001, "", "" ),
            new TSymLookupEntry( 0x008c6820, 00001, "", "" ),
            new TSymLookupEntry( 0x008c69a4, 00001, "", "" ),
            new TSymLookupEntry( 0x008c7588, 00001, "", "" ),
            new TSymLookupEntry( 0x008c76f4, 00001, "", "" ),
            new TSymLookupEntry( 0x008c82f0, 00001, "", "" ),
            new TSymLookupEntry( 0x008c8448, 00001, "", "" ),
            new TSymLookupEntry( 0x008c8470, 00001, "", "" ),
            new TSymLookupEntry( 0x008c8498, 00001, "", "" ),
            new TSymLookupEntry( 0x008c84e8, 00001, "", "" ),
            new TSymLookupEntry( 0x008c8510, 00001, "", "" ),
            new TSymLookupEntry( 0x008c8560, 00001, "", "" ),
            new TSymLookupEntry( 0x008c862c, 00001, "", "" ),
            new TSymLookupEntry( 0x008c9210, 00001, "", "" ),
            new TSymLookupEntry( 0x008c9354, 00001, "", "" ),
            new TSymLookupEntry( 0x008c9f50, 00001, "", "" ),
            new TSymLookupEntry( 0x008ca0a0, 00001, "", "" ),
            new TSymLookupEntry( 0x008cac90, 00001, "", "" ),
            new TSymLookupEntry( 0x008cae14, 00001, "", "" ),
            new TSymLookupEntry( 0x008cb9f8, 00001, "", "" ),
            new TSymLookupEntry( 0x008cbb64, 00001, "", "" ),
            new TSymLookupEntry( 0x008cc760, 00001, "", "" ),
            new TSymLookupEntry( 0x008cc8b8, 00001, "", "" ),
            new TSymLookupEntry( 0x008cc8e0, 00001, "", "" ),
            new TSymLookupEntry( 0x008cc908, 00001, "", "" ),
            new TSymLookupEntry( 0x008cc958, 00001, "", "" ),
            new TSymLookupEntry( 0x008cc980, 00001, "", "" ),
            new TSymLookupEntry( 0x008cc9d0, 00001, "", "" ),
            new TSymLookupEntry( 0x008cca9c, 00001, "", "" ),
            new TSymLookupEntry( 0x008cd680, 00001, "", "" ),
            new TSymLookupEntry( 0x008cd7c4, 00001, "", "" ),
            new TSymLookupEntry( 0x008ce3c0, 00001, "", "" ),
            new TSymLookupEntry( 0x008ce510, 00001, "", "" ),
            new TSymLookupEntry( 0x008cf3a8, 00001, "", "" ),
            new TSymLookupEntry( 0x008cf470, 00001, "", "" ),
            new TSymLookupEntry( 0x008cf500, 00001, "", "" ),
            new TSymLookupEntry( 0x008cf578, 00001, "", "" ),
            new TSymLookupEntry( 0x008cf690, 00001, "", "" ),
            new TSymLookupEntry( 0x008cf808, 00001, "", "" ),
            new TSymLookupEntry( 0x008cf8c8, 00001, "", "" ),
            new TSymLookupEntry( 0x008cf988, 00001, "", "" ),
            new TSymLookupEntry( 0x008cfb68, 00001, "", "" ),
            new TSymLookupEntry( 0x008cfc78, 00001, "", "" ),
            new TSymLookupEntry( 0x008cfd60, 00001, "", "" ),
            new TSymLookupEntry( 0x008cfe28, 00001, "", "" ),
            new TSymLookupEntry( 0x008cff48, 00001, "", "" ),
            new TSymLookupEntry( 0x008d0030, 00001, "", "" ),
            new TSymLookupEntry( 0x008d0034, 00001, "", "" ),
            new TSymLookupEntry( 0x008d0128, 00001, "", "" ),
            new TSymLookupEntry( 0x008d0150, 00001, "", "" ),
            new TSymLookupEntry( 0x008d0210, 00001, "", "" ),
            new TSymLookupEntry( 0x008d0238, 00001, "", "" ),
            new TSymLookupEntry( 0x008d0440, 00001, "", "" ),
            new TSymLookupEntry( 0x008d0500, 00001, "", "" ),
            new TSymLookupEntry( 0x008d0878, 00001, "", "" ),
            new TSymLookupEntry( 0x008d08f0, 00001, "", "" ),
            new TSymLookupEntry( 0x008d0918, 00001, "", "" ),
            new TSymLookupEntry( 0x008d09d8, 00001, "", "" ),
            new TSymLookupEntry( 0x008d0a00, 00001, "", "" ),
            new TSymLookupEntry( 0x008d0ac0, 00001, "", "" ),
            new TSymLookupEntry( 0x008d0b80, 00001, "", "" ),
            new TSymLookupEntry( 0x008d0c68, 00001, "", "" ),
            new TSymLookupEntry( 0x008d0d98, 00001, "", "" ),
            new TSymLookupEntry( 0x008d0dc0, 00001, "", "" ),
            new TSymLookupEntry( 0x008d0e80, 00001, "", "" ),
            new TSymLookupEntry( 0x008d0f40, 00001, "", "" ),
            new TSymLookupEntry( 0x008d11c8, 00001, "", "" ),
            new TSymLookupEntry( 0x008d1288, 00001, "", "" ),
            new TSymLookupEntry( 0x008d1348, 00001, "", "" ),
            new TSymLookupEntry( 0x008d14d0, 00001, "", "" ),
            new TSymLookupEntry( 0x008d1698, 00001, "", "" ),
            new TSymLookupEntry( 0x008d1a70, 00001, "", "" ),
            new TSymLookupEntry( 0x008d1b38, 00001, "", "" ),
            new TSymLookupEntry( 0x008d1bc8, 00001, "", "" ),
            new TSymLookupEntry( 0x008d1c40, 00001, "", "" ),
            new TSymLookupEntry( 0x008d1d58, 00001, "", "" ),
            new TSymLookupEntry( 0x008d1ed0, 00001, "", "" ),
            new TSymLookupEntry( 0x008d1f90, 00001, "", "" ),
            new TSymLookupEntry( 0x008d2070, 00001, "", "" ),
            new TSymLookupEntry( 0x008d2250, 00001, "", "" ),
            new TSymLookupEntry( 0x008d2360, 00001, "", "" ),
            new TSymLookupEntry( 0x008d2538, 00001, "", "" ),
            new TSymLookupEntry( 0x008d2600, 00001, "", "" ),
            new TSymLookupEntry( 0x008d2e40, 00001, "", "" ),
            new TSymLookupEntry( 0x008d3020, 00001, "", "" ),
            new TSymLookupEntry( 0x008d3048, 00001, "", "" ),
            new TSymLookupEntry( 0x008d3108, 00001, "", "" ),
            new TSymLookupEntry( 0x008d3130, 00001, "", "" ),
            new TSymLookupEntry( 0x008d31f0, 00001, "", "" ),
            new TSymLookupEntry( 0x008d3968, 00001, "", "" ),
            new TSymLookupEntry( 0x008d3a28, 00001, "", "" ),
            new TSymLookupEntry( 0x008d4be8, 00001, "", "" ),
            new TSymLookupEntry( 0x008d4c60, 00001, "", "" ),
            new TSymLookupEntry( 0x008d4c88, 00001, "", "" ),
            new TSymLookupEntry( 0x008d4d48, 00001, "", "" ),
            new TSymLookupEntry( 0x008d4d70, 00001, "", "" ),
            new TSymLookupEntry( 0x008d4e30, 00001, "", "" ),
            new TSymLookupEntry( 0x008d4ef0, 00001, "", "" ),
            new TSymLookupEntry( 0x008d4fd8, 00001, "", "" ),
            new TSymLookupEntry( 0x008d5108, 00001, "", "" ),
            new TSymLookupEntry( 0x008d5130, 00001, "", "" ),
            new TSymLookupEntry( 0x008d51f0, 00001, "", "" ),
            new TSymLookupEntry( 0x008d52b0, 00001, "", "" ),
            new TSymLookupEntry( 0x008d55c8, 00001, "", "" ),
            new TSymLookupEntry( 0x008d5688, 00001, "", "" ),
            new TSymLookupEntry( 0x008d5748, 00001, "", "" ),
            new TSymLookupEntry( 0x008d58d0, 00001, "", "" ),
            new TSymLookupEntry( 0x008d5a98, 00001, "", "" ),
            new TSymLookupEntry( 0x008d5e70, 00001, "", "" ),
            new TSymLookupEntry( 0x008d5f38, 00001, "", "" ),
            new TSymLookupEntry( 0x008d5fc8, 00001, "", "" ),
            new TSymLookupEntry( 0x008d6040, 00001, "", "" ),
            new TSymLookupEntry( 0x008d6158, 00001, "", "" ),
            new TSymLookupEntry( 0x008d62d0, 00001, "", "" ),
            new TSymLookupEntry( 0x008d6390, 00001, "", "" ),
            new TSymLookupEntry( 0x008d6450, 00001, "", "" ),
            new TSymLookupEntry( 0x008d6630, 00001, "", "" ),
            new TSymLookupEntry( 0x008d6740, 00001, "", "" ),
            new TSymLookupEntry( 0x008d6828, 00001, "", "" ),
            new TSymLookupEntry( 0x008d68f0, 00001, "", "" ),
            new TSymLookupEntry( 0x008d6a10, 00001, "", "" ),
            new TSymLookupEntry( 0x008d6bf0, 00001, "", "" ),
            new TSymLookupEntry( 0x008d6c18, 00001, "", "" ),
            new TSymLookupEntry( 0x008d6cd8, 00001, "", "" ),
            new TSymLookupEntry( 0x008d6d00, 00001, "", "" ),
            new TSymLookupEntry( 0x008d6dc0, 00001, "", "" ),
            new TSymLookupEntry( 0x008d7070, 00001, "", "" ),
            new TSymLookupEntry( 0x008d7130, 00001, "", "" ),
            new TSymLookupEntry( 0x008d74a8, 00001, "", "" ),
            new TSymLookupEntry( 0x008d7520, 00001, "", "" ),
            new TSymLookupEntry( 0x008d7548, 00001, "", "" ),
            new TSymLookupEntry( 0x008d7608, 00001, "", "" ),
            new TSymLookupEntry( 0x008d7630, 00001, "", "" ),
            new TSymLookupEntry( 0x008d76f0, 00001, "", "" ),
            new TSymLookupEntry( 0x008d77b0, 00001, "", "" ),
            new TSymLookupEntry( 0x008d7898, 00001, "", "" ),
            new TSymLookupEntry( 0x008d79c8, 00001, "", "" ),
            new TSymLookupEntry( 0x008d79f0, 00001, "", "" ),
            new TSymLookupEntry( 0x008d7ab0, 00001, "", "" ),
            new TSymLookupEntry( 0x008d7b70, 00001, "", "" ),
            new TSymLookupEntry( 0x008d7e10, 00001, "", "" ),
            new TSymLookupEntry( 0x008d7ed0, 00001, "", "" ),
            new TSymLookupEntry( 0x008d7f90, 00001, "", "" ),
            new TSymLookupEntry( 0x008d8138, 00001, "", "" ),
            new TSymLookupEntry( 0x008d8300, 00001, "", "" ),
            new TSymLookupEntry( 0x008d86d8, 00001, "", "" ),
            new TSymLookupEntry( 0x008d87a0, 00001, "", "" ),
            new TSymLookupEntry( 0x008d8830, 00001, "", "" ),
            new TSymLookupEntry( 0x008d88a8, 00001, "", "" ),
            new TSymLookupEntry( 0x008d89c0, 00001, "", "" ),
            new TSymLookupEntry( 0x008d8b38, 00001, "", "" ),
            new TSymLookupEntry( 0x008d8bf8, 00001, "", "" ),
            new TSymLookupEntry( 0x008d8cb8, 00001, "", "" ),
            new TSymLookupEntry( 0x008d8e98, 00001, "", "" ),
            new TSymLookupEntry( 0x008d8fa8, 00001, "", "" ),
            new TSymLookupEntry( 0x008d9188, 00001, "", "" ),
            new TSymLookupEntry( 0x008d9250, 00001, "", "" ),
            new TSymLookupEntry( 0x008d9a90, 00001, "", "" ),
            new TSymLookupEntry( 0x008d9c70, 00001, "", "" ),
            new TSymLookupEntry( 0x008d9c98, 00001, "", "" ),
            new TSymLookupEntry( 0x008d9d58, 00001, "", "" ),
            new TSymLookupEntry( 0x008d9d80, 00001, "", "" ),
            new TSymLookupEntry( 0x008d9e40, 00001, "", "" ),
            new TSymLookupEntry( 0x008da5b8, 00001, "", "" ),
            new TSymLookupEntry( 0x008da678, 00001, "", "" ),
            new TSymLookupEntry( 0x008db298, 00001, "", "" ),
            new TSymLookupEntry( 0x008db838, 00001, "", "" ),
            new TSymLookupEntry( 0x008db8b0, 00001, "", "" ),
            new TSymLookupEntry( 0x008db8d8, 00001, "", "" ),
            new TSymLookupEntry( 0x008db998, 00001, "", "" ),
            new TSymLookupEntry( 0x008db9c0, 00001, "", "" ),
            new TSymLookupEntry( 0x008dba80, 00001, "", "" ),
            new TSymLookupEntry( 0x008dbb40, 00001, "", "" ),
            new TSymLookupEntry( 0x008dbc28, 00001, "", "" ),
            new TSymLookupEntry( 0x008dbd58, 00001, "", "" ),
            new TSymLookupEntry( 0x008dbd80, 00001, "", "" ),
            new TSymLookupEntry( 0x008dbe40, 00001, "", "" ),
            new TSymLookupEntry( 0x008dbf00, 00001, "", "" ),
            new TSymLookupEntry( 0x008dc138, 00001, "", "" ),
            new TSymLookupEntry( 0x008dc1f8, 00001, "", "" ),
            new TSymLookupEntry( 0x008dc2b8, 00001, "", "" ),
            new TSymLookupEntry( 0x008dc440, 00001, "", "" ),
            new TSymLookupEntry( 0x008dc608, 00001, "", "" ),
            new TSymLookupEntry( 0x008dc9e0, 00001, "", "" ),
            new TSymLookupEntry( 0x008dcaa8, 00001, "", "" ),
            new TSymLookupEntry( 0x008dcb38, 00001, "", "" ),
            new TSymLookupEntry( 0x008dcbb0, 00001, "", "" ),
            new TSymLookupEntry( 0x008dccc8, 00001, "", "" ),
            new TSymLookupEntry( 0x008dce40, 00001, "", "" ),
            new TSymLookupEntry( 0x008dcf00, 00001, "", "" ),
            new TSymLookupEntry( 0x008dcfc0, 00001, "", "" ),
            new TSymLookupEntry( 0x008dd1b8, 00001, "", "" ),
            new TSymLookupEntry( 0x008dd2c8, 00001, "", "" ),
            new TSymLookupEntry( 0x008dd3b0, 00001, "", "" ),
            new TSymLookupEntry( 0x008dd478, 00001, "", "" ),
            new TSymLookupEntry( 0x008dd598, 00001, "", "" ),
            new TSymLookupEntry( 0x008dd778, 00001, "", "" ),
            new TSymLookupEntry( 0x008dd7a0, 00001, "", "" ),
            new TSymLookupEntry( 0x008dd860, 00001, "", "" ),
            new TSymLookupEntry( 0x008dd888, 00001, "", "" ),
            new TSymLookupEntry( 0x008dda90, 00001, "", "" ),
            new TSymLookupEntry( 0x008ddb50, 00001, "", "" ),
            new TSymLookupEntry( 0x008ddec8, 00001, "", "" ),
            new TSymLookupEntry( 0x008ddf40, 00001, "", "" ),
            new TSymLookupEntry( 0x008ddf68, 00001, "", "" ),
            new TSymLookupEntry( 0x008de048, 00001, "", "" ),
            new TSymLookupEntry( 0x008de070, 00001, "", "" ),
            new TSymLookupEntry( 0x008de130, 00001, "", "" ),
            new TSymLookupEntry( 0x008de1f0, 00001, "", "" ),
            new TSymLookupEntry( 0x008de2d8, 00001, "", "" ),
            new TSymLookupEntry( 0x008de408, 00001, "", "" ),
            new TSymLookupEntry( 0x008de430, 00001, "", "" ),
            new TSymLookupEntry( 0x008de4f0, 00001, "", "" ),
            new TSymLookupEntry( 0x008de5b0, 00001, "", "" ),
            new TSymLookupEntry( 0x008de848, 00001, "", "" ),
            new TSymLookupEntry( 0x008de908, 00001, "", "" ),
            new TSymLookupEntry( 0x008de9c8, 00001, "", "" ),
            new TSymLookupEntry( 0x008deb50, 00001, "", "" ),
            new TSymLookupEntry( 0x008ded18, 00001, "", "" ),
            new TSymLookupEntry( 0x008df0f0, 00001, "", "" ),
            new TSymLookupEntry( 0x008df1b8, 00001, "", "" ),
            new TSymLookupEntry( 0x008df248, 00001, "", "" ),
            new TSymLookupEntry( 0x008df2c0, 00001, "", "" ),
            new TSymLookupEntry( 0x008df3d8, 00001, "", "" ),
            new TSymLookupEntry( 0x008df550, 00001, "", "" ),
            new TSymLookupEntry( 0x008df610, 00001, "", "" ),
            new TSymLookupEntry( 0x008df6d0, 00001, "", "" ),
            new TSymLookupEntry( 0x008df8b0, 00001, "", "" ),
            new TSymLookupEntry( 0x008df9c0, 00001, "", "" ),
            new TSymLookupEntry( 0x008dfb98, 00001, "", "" ),
            new TSymLookupEntry( 0x008dfc60, 00001, "", "" ),
            new TSymLookupEntry( 0x008e0030, 00002, "", "" ),
            new TSymLookupEntry( 0x008e0033, 00001, "", "" ),
            new TSymLookupEntry( 0x008e04a0, 00001, "", "" ),
            new TSymLookupEntry( 0x008e0680, 00001, "", "" ),
            new TSymLookupEntry( 0x008e06a8, 00001, "", "" ),
            new TSymLookupEntry( 0x008e0768, 00001, "", "" ),
            new TSymLookupEntry( 0x008e0790, 00001, "", "" ),
            new TSymLookupEntry( 0x008e0850, 00001, "", "" ),
            new TSymLookupEntry( 0x008e0fc8, 00001, "", "" ),
            new TSymLookupEntry( 0x008e1088, 00001, "", "" ),
            new TSymLookupEntry( 0x008e2248, 00001, "", "" ),
            new TSymLookupEntry( 0x008e22c0, 00001, "", "" ),
            new TSymLookupEntry( 0x008e22e8, 00001, "", "" ),
            new TSymLookupEntry( 0x008e23a8, 00001, "", "" ),
            new TSymLookupEntry( 0x008e23d0, 00001, "", "" ),
            new TSymLookupEntry( 0x008e2490, 00001, "", "" ),
            new TSymLookupEntry( 0x008e2550, 00001, "", "" ),
            new TSymLookupEntry( 0x008e2638, 00001, "", "" ),
            new TSymLookupEntry( 0x008e2768, 00001, "", "" ),
            new TSymLookupEntry( 0x008e2790, 00001, "", "" ),
            new TSymLookupEntry( 0x008e2850, 00001, "", "" ),
            new TSymLookupEntry( 0x008e2910, 00001, "", "" ),
            new TSymLookupEntry( 0x008e2b78, 00001, "", "" ),
            new TSymLookupEntry( 0x008e2c38, 00001, "", "" ),
            new TSymLookupEntry( 0x008e2cf8, 00001, "", "" ),
            new TSymLookupEntry( 0x008e2e80, 00001, "", "" ),
            new TSymLookupEntry( 0x008e3068, 00001, "", "" ),
            new TSymLookupEntry( 0x008e3440, 00001, "", "" ),
            new TSymLookupEntry( 0x008e3508, 00001, "", "" ),
            new TSymLookupEntry( 0x008e3598, 00001, "", "" ),
            new TSymLookupEntry( 0x008e3610, 00001, "", "" ),
            new TSymLookupEntry( 0x008e3728, 00001, "", "" ),
            new TSymLookupEntry( 0x008e38a0, 00001, "", "" ),
            new TSymLookupEntry( 0x008e3960, 00001, "", "" ),
            new TSymLookupEntry( 0x008e3a20, 00001, "", "" ),
            new TSymLookupEntry( 0x008e3c00, 00001, "", "" ),
            new TSymLookupEntry( 0x008e3d10, 00001, "", "" ),
            new TSymLookupEntry( 0x008e3ee8, 00001, "", "" ),
            new TSymLookupEntry( 0x008e3fb0, 00001, "", "" ),
            new TSymLookupEntry( 0x008e47f0, 00001, "", "" ),
            new TSymLookupEntry( 0x008e49d0, 00001, "", "" ),
            new TSymLookupEntry( 0x008e49f8, 00001, "", "" ),
            new TSymLookupEntry( 0x008e4ab8, 00001, "", "" ),
            new TSymLookupEntry( 0x008e4ae0, 00001, "", "" ),
            new TSymLookupEntry( 0x008e4ce8, 00001, "", "" ),
            new TSymLookupEntry( 0x008e52a8, 00001, "", "" ),
            new TSymLookupEntry( 0x008e5d90, 00001, "", "" ),
            new TSymLookupEntry( 0x008e5ff8, 00001, "", "" ),
            new TSymLookupEntry( 0x008e6508, 00001, "", "" ),
            new TSymLookupEntry( 0x008e6530, 00001, "", "" ),
            new TSymLookupEntry( 0x008e65f0, 00001, "", "" ),
            new TSymLookupEntry( 0x008e6618, 00001, "", "" ),
            new TSymLookupEntry( 0x008e66d8, 00001, "", "" ),
            new TSymLookupEntry( 0x008e6798, 00001, "", "" ),
            new TSymLookupEntry( 0x008e6880, 00001, "", "" ),
            new TSymLookupEntry( 0x008e69b0, 00001, "", "" ),
            new TSymLookupEntry( 0x008e69d8, 00001, "", "" ),
            new TSymLookupEntry( 0x008e6a98, 00001, "", "" ),
            new TSymLookupEntry( 0x008e6b58, 00001, "", "" ),
            new TSymLookupEntry( 0x008e6e48, 00001, "", "" ),
            new TSymLookupEntry( 0x008e6f08, 00001, "", "" ),
            new TSymLookupEntry( 0x008e6fc8, 00001, "", "" ),
            new TSymLookupEntry( 0x008e7160, 00001, "", "" ),
            new TSymLookupEntry( 0x008e7328, 00001, "", "" ),
            new TSymLookupEntry( 0x008e7700, 00001, "", "" ),
            new TSymLookupEntry( 0x008e77c8, 00001, "", "" ),
            new TSymLookupEntry( 0x008e7858, 00001, "", "" ),
            new TSymLookupEntry( 0x008e78d0, 00001, "", "" ),
            new TSymLookupEntry( 0x008e79e8, 00001, "", "" ),
            new TSymLookupEntry( 0x008e7b60, 00001, "", "" ),
            new TSymLookupEntry( 0x008e7c20, 00001, "", "" ),
            new TSymLookupEntry( 0x008e7ce0, 00001, "", "" ),
            new TSymLookupEntry( 0x008e7ec0, 00001, "", "" ),
            new TSymLookupEntry( 0x008e7fd0, 00001, "", "" ),
            new TSymLookupEntry( 0x008e81b0, 00001, "", "" ),
            new TSymLookupEntry( 0x008e8278, 00001, "", "" ),
            new TSymLookupEntry( 0x008e8ab8, 00001, "", "" ),
            new TSymLookupEntry( 0x008e8c98, 00001, "", "" ),
            new TSymLookupEntry( 0x008e8cc0, 00001, "", "" ),
            new TSymLookupEntry( 0x008e8d80, 00001, "", "" ),
            new TSymLookupEntry( 0x008e8da8, 00001, "", "" ),
            new TSymLookupEntry( 0x008e8e68, 00001, "", "" ),
            new TSymLookupEntry( 0x008e95e0, 00001, "", "" ),
            new TSymLookupEntry( 0x008e96a0, 00001, "", "" ),
            new TSymLookupEntry( 0x008ea138, 00001, "", "" ),
            new TSymLookupEntry( 0x008ea2c0, 00001, "", "" ),
            new TSymLookupEntry( 0x008ea860, 00001, "", "" ),
            new TSymLookupEntry( 0x008ea8d8, 00001, "", "" ),
            new TSymLookupEntry( 0x008ea900, 00001, "", "" ),
            new TSymLookupEntry( 0x008ea9c0, 00001, "", "" ),
            new TSymLookupEntry( 0x008ea9e8, 00001, "", "" ),
            new TSymLookupEntry( 0x008eaaa8, 00001, "", "" ),
            new TSymLookupEntry( 0x008eab68, 00001, "", "" ),
            new TSymLookupEntry( 0x008eac50, 00001, "", "" ),
            new TSymLookupEntry( 0x008ead80, 00001, "", "" ),
            new TSymLookupEntry( 0x008eada8, 00001, "", "" ),
            new TSymLookupEntry( 0x008eae68, 00001, "", "" ),
            new TSymLookupEntry( 0x008eaf28, 00001, "", "" ),
            new TSymLookupEntry( 0x008eb198, 00001, "", "" ),
            new TSymLookupEntry( 0x008eb258, 00001, "", "" ),
            new TSymLookupEntry( 0x008eb318, 00001, "", "" ),
            new TSymLookupEntry( 0x008eb4a0, 00001, "", "" ),
            new TSymLookupEntry( 0x008eb668, 00001, "", "" ),
            new TSymLookupEntry( 0x008eba40, 00001, "", "" ),
            new TSymLookupEntry( 0x008ebb08, 00001, "", "" ),
            new TSymLookupEntry( 0x008ebb98, 00001, "", "" ),
            new TSymLookupEntry( 0x008ebc10, 00001, "", "" ),
            new TSymLookupEntry( 0x008ebd28, 00001, "", "" ),
            new TSymLookupEntry( 0x008ebea0, 00001, "", "" ),
            new TSymLookupEntry( 0x008ebf60, 00001, "", "" ),
            new TSymLookupEntry( 0x008ec020, 00001, "", "" ),
            new TSymLookupEntry( 0x008ec5f0, 00001, "", "" ),
            new TSymLookupEntry( 0x008ee210, 00001, "", "" ),
            new TSymLookupEntry( 0x008eef88, 00001, "", "" ),
            new TSymLookupEntry( 0x008f000a, 00002, "", "" ),
            new TSymLookupEntry( 0x008f12a8, 00001, "", "" ),
            new TSymLookupEntry( 0x008f1c58, 00001, "", "" ),
            new TSymLookupEntry( 0x008f2054, 00001, "", "" ),
            new TSymLookupEntry( 0x008f2be0, 00001, "", "" ),
            new TSymLookupEntry( 0x008f2eb4, 00003, "", "" ),
            new TSymLookupEntry( 0x008f3888, 00001, "", "" ),
            new TSymLookupEntry( 0x008f4308, 00001, "", "" ),
            new TSymLookupEntry( 0x008f4b9c, 00001, "", "" ),
            new TSymLookupEntry( 0x008f4f98, 00001, "", "" ),
            new TSymLookupEntry( 0x008f5e60, 00001, "", "" ),
            new TSymLookupEntry( 0x008f5fe0, 00004, "", "" ),
            new TSymLookupEntry( 0x008f6c2c, 00001, "", "" ),
            new TSymLookupEntry( 0x008f7618, 00001, "", "" ),
            new TSymLookupEntry( 0x008f7fc8, 00001, "", "" ),
            new TSymLookupEntry( 0x008f83c4, 00001, "", "" ),
            new TSymLookupEntry( 0x008f8f50, 00001, "", "" ),
            new TSymLookupEntry( 0x008f9224, 00003, "", "" ),
            new TSymLookupEntry( 0x008f9bf8, 00001, "", "" ),
            new TSymLookupEntry( 0x008fa678, 00001, "", "" ),
            new TSymLookupEntry( 0x008faf0c, 00001, "", "" ),
            new TSymLookupEntry( 0x008fb308, 00001, "", "" ),
            new TSymLookupEntry( 0x008fc718, 00001, "", "" ),
            new TSymLookupEntry( 0x008fc898, 00003, "", "" ),
            new TSymLookupEntry( 0x008fd4e4, 00001, "", "" ),
            new TSymLookupEntry( 0x008fdb78, 00001, "", "" ),
            new TSymLookupEntry( 0x008fea70, 00001, "", "" ),
            new TSymLookupEntry( 0x008ff4e8, 00001, "", "" ),
            new TSymLookupEntry( 0x008ff824, 00001, "", "" ),
            new TSymLookupEntry( 0x008ffcf8, 00003, "", "" ),
            new TSymLookupEntry( 0x00900a40, 00001, "", "" ),
            new TSymLookupEntry( 0x00900ef4, 00001, "", "" ),
            new TSymLookupEntry( 0x00902778, 00001, "", "" ),
            new TSymLookupEntry( 0x00902e38, 00001, "", "" ),
            new TSymLookupEntry( 0x00903234, 00001, "", "" ),
            new TSymLookupEntry( 0x00903f70, 00001, "", "" ),
            new TSymLookupEntry( 0x00903f80, 00003, "", "" ),
            new TSymLookupEntry( 0x00904bcc, 00001, "", "" ),
            new TSymLookupEntry( 0x009056a8, 00001, "", "" ),
            new TSymLookupEntry( 0x009064bc, 00001, "", "" ),
            new TSymLookupEntry( 0x00906f50, 00001, "", "" ),
            new TSymLookupEntry( 0x00907170, 00001, "", "" ),
            new TSymLookupEntry( 0x00907644, 00003, "", "" ),
            new TSymLookupEntry( 0x00908598, 00001, "", "" ),
            new TSymLookupEntry( 0x00908664, 00001, "", "" ),
            new TSymLookupEntry( 0x00909228, 00001, "", "" ),
            new TSymLookupEntry( 0x0090a0d8, 00001, "", "" ),
            new TSymLookupEntry( 0x0090a16c, 00001, "", "" ),
            new TSymLookupEntry( 0x0090a640, 00003, "", "" ),
            new TSymLookupEntry( 0x0090b014, 00001, "", "" ),
            new TSymLookupEntry( 0x0090b828, 00001, "", "" ),
            new TSymLookupEntry( 0x0090c32c, 00001, "", "" ),
            new TSymLookupEntry( 0x0090c728, 00001, "", "" ),
            new TSymLookupEntry( 0x0090d150, 00001, "", "" ),
            new TSymLookupEntry( 0x0090d564, 00003, "", "" ),
            new TSymLookupEntry( 0x0090e0a8, 00001, "", "" ),
            new TSymLookupEntry( 0x0090e720, 00001, "", "" ),
            new TSymLookupEntry( 0x0090f25c, 00001, "", "" ),
            new TSymLookupEntry( 0x0090f658, 00001, "", "" ),
            new TSymLookupEntry( 0x00910150, 00001, "", "" ),
            new TSymLookupEntry( 0x00910564, 00003, "", "" ),
            new TSymLookupEntry( 0x009110a8, 00001, "", "" ),
            new TSymLookupEntry( 0x00911818, 00001, "", "" ),
            new TSymLookupEntry( 0x00912394, 00001, "", "" ),
            new TSymLookupEntry( 0x00912790, 00001, "", "" ),
            new TSymLookupEntry( 0x009132e0, 00001, "", "" ),
            new TSymLookupEntry( 0x009133f8, 00002, "", "" ),
            new TSymLookupEntry( 0x00913468, 00001, "", "" ),
            new TSymLookupEntry( 0x00913558, 00001, "", "" ),
            new TSymLookupEntry( 0x00913710, 00002, "", "" ),
            new TSymLookupEntry( 0x00913760, 00001, "", "" ),
            new TSymLookupEntry( 0x00913850, 00001, "", "" ),
            new TSymLookupEntry( 0x00913a10, 00002, "", "" ),
            new TSymLookupEntry( 0x00913a88, 00001, "", "" ),
            new TSymLookupEntry( 0x00913bf8, 00001, "", "" ),
            new TSymLookupEntry( 0x009140a8, 00001, "", "" ),
            new TSymLookupEntry( 0x00914640, 00002, "", "" ),
            new TSymLookupEntry( 0x00914690, 00001, "", "" ),
            new TSymLookupEntry( 0x00914c28, 00002, "", "" ),
            new TSymLookupEntry( 0x00914c78, 00001, "", "" ),
            new TSymLookupEntry( 0x00914f28, 00002, "", "" ),
            new TSymLookupEntry( 0x00914f78, 00001, "", "" ),
            new TSymLookupEntry( 0x00915208, 00001, "", "" ),
            new TSymLookupEntry( 0x00915278, 00001, "", "" ),
            new TSymLookupEntry( 0x00915df8, 00001, "", "" ),
            new TSymLookupEntry( 0x00916244, 00003, "", "" ),
            new TSymLookupEntry( 0x00916b10, 00001, "", "" ),
            new TSymLookupEntry( 0x009175c0, 00001, "", "" ),
            new TSymLookupEntry( 0x00917eec, 00001, "", "" ),
            new TSymLookupEntry( 0x009182e8, 00001, "", "" ),
            new TSymLookupEntry( 0x00918ef8, 00001, "", "" ),
            new TSymLookupEntry( 0x009190fc, 00003, "", "" ),
            new TSymLookupEntry( 0x00919ad0, 00001, "", "" ),
            new TSymLookupEntry( 0x0091b5b0, 00001, "", "" ),
            new TSymLookupEntry( 0x0091bd88, 00001, "", "" ),
            new TSymLookupEntry( 0x0091c184, 00001, "", "" ),
            new TSymLookupEntry( 0x0091c7a0, 00001, "", "" ),
            new TSymLookupEntry( 0x0091c850, 00003, "", "" ),
            new TSymLookupEntry( 0x0091d224, 00001, "", "" ),
            new TSymLookupEntry( 0x0091e0e0, 00001, "", "" ),
            new TSymLookupEntry( 0x0091e764, 00001, "", "" ),
            new TSymLookupEntry( 0x0091eb60, 00001, "", "" ),
            new TSymLookupEntry( 0x0091f034, 00003, "", "" ),
            new TSymLookupEntry( 0x00920738, 00001, "", "" ),
            new TSymLookupEntry( 0x00921098, 00001, "", "" ),
            new TSymLookupEntry( 0x00921c88, 00001, "", "" ),
            new TSymLookupEntry( 0x009221b8, 00001, "", "" ),
            new TSymLookupEntry( 0x009225b4, 00001, "", "" ),
            new TSymLookupEntry( 0x00922a88, 00003, "", "" ),
            new TSymLookupEntry( 0x00923568, 00001, "", "" ),
            new TSymLookupEntry( 0x00923c64, 00001, "", "" ),
            new TSymLookupEntry( 0x00924e00, 00001, "", "" ),
            new TSymLookupEntry( 0x0092510c, 00001, "", "" ),
            new TSymLookupEntry( 0x00925508, 00001, "", "" ),
            new TSymLookupEntry( 0x009259dc, 00003, "", "" ),
            new TSymLookupEntry( 0x009265c8, 00001, "", "" ),
            new TSymLookupEntry( 0x00926ba0, 00001, "", "" ),
            new TSymLookupEntry( 0x00927f30, 00001, "", "" ),
            new TSymLookupEntry( 0x00928118, 00001, "", "" ),
            new TSymLookupEntry( 0x00928514, 00001, "", "" ),
            new TSymLookupEntry( 0x009289e8, 00003, "", "" ),
            new TSymLookupEntry( 0x00929640, 00001, "", "" ),
            new TSymLookupEntry( 0x009299ec, 00001, "", "" ),
            new TSymLookupEntry( 0x0092a5b0, 00001, "", "" ),
            new TSymLookupEntry( 0x0092b0c0, 00001, "", "" ),
            new TSymLookupEntry( 0x0092b434, 00001, "", "" ),
            new TSymLookupEntry( 0x0092b908, 00003, "", "" ),
            new TSymLookupEntry( 0x0092c000, 00016, "", "" ),
            new TSymLookupEntry( 0x0092c730, 00001, "", "" ),
            new TSymLookupEntry( 0x0092c950, 00001, "", "" ),
            new TSymLookupEntry( 0x0092d514, 00001, "", "" ),
            new TSymLookupEntry( 0x0092e2b0, 00001, "", "" ),
            new TSymLookupEntry( 0x0092e498, 00001, "", "" ),
            new TSymLookupEntry( 0x0092f358, 00001, "", "" ),
            new TSymLookupEntry( 0x0092f48c, 00001, "", "" ),
            new TSymLookupEntry( 0x00930070, 00001, "", "" ),
            new TSymLookupEntry( 0x009301dc, 00001, "", "" ),
            new TSymLookupEntry( 0x00930dd8, 00001, "", "" ),
            new TSymLookupEntry( 0x00930f30, 00001, "", "" ),
            new TSymLookupEntry( 0x00930f58, 00001, "", "" ),
            new TSymLookupEntry( 0x00930f80, 00001, "", "" ),
            new TSymLookupEntry( 0x00930fd0, 00001, "", "" ),
            new TSymLookupEntry( 0x00931000, 00001, "", "" ),
            new TSymLookupEntry( 0x00931050, 00001, "", "" ),
            new TSymLookupEntry( 0x009310c8, 00001, "", "" ),
            new TSymLookupEntry( 0x00932134, 00001, "", "" ),
            new TSymLookupEntry( 0x00932d18, 00001, "", "" ),
            new TSymLookupEntry( 0x00932e5c, 00001, "", "" ),
            new TSymLookupEntry( 0x00933a58, 00001, "", "" ),
            new TSymLookupEntry( 0x00933ba8, 00001, "", "" ),
            new TSymLookupEntry( 0x00934798, 00001, "", "" ),
            new TSymLookupEntry( 0x0093491c, 00001, "", "" ),
            new TSymLookupEntry( 0x00935500, 00001, "", "" ),
            new TSymLookupEntry( 0x0093566c, 00001, "", "" ),
            new TSymLookupEntry( 0x00936268, 00001, "", "" ),
            new TSymLookupEntry( 0x009363c0, 00001, "", "" ),
            new TSymLookupEntry( 0x009363e8, 00001, "", "" ),
            new TSymLookupEntry( 0x00936410, 00001, "", "" ),
            new TSymLookupEntry( 0x00936460, 00001, "", "" ),
            new TSymLookupEntry( 0x00936488, 00001, "", "" ),
            new TSymLookupEntry( 0x009364d8, 00001, "", "" ),
            new TSymLookupEntry( 0x009365a4, 00001, "", "" ),
            new TSymLookupEntry( 0x00937188, 00001, "", "" ),
            new TSymLookupEntry( 0x009372cc, 00001, "", "" ),
            new TSymLookupEntry( 0x00937ec8, 00001, "", "" ),
            new TSymLookupEntry( 0x00938020, 00001, "", "" ),
            new TSymLookupEntry( 0x00938c10, 00001, "", "" ),
            new TSymLookupEntry( 0x00938d94, 00001, "", "" ),
            new TSymLookupEntry( 0x00939978, 00001, "", "" ),
            new TSymLookupEntry( 0x00939ae4, 00001, "", "" ),
            new TSymLookupEntry( 0x0093a6e0, 00001, "", "" ),
            new TSymLookupEntry( 0x0093a838, 00001, "", "" ),
            new TSymLookupEntry( 0x0093a860, 00001, "", "" ),
            new TSymLookupEntry( 0x0093a888, 00001, "", "" ),
            new TSymLookupEntry( 0x0093a8d8, 00001, "", "" ),
            new TSymLookupEntry( 0x0093a900, 00001, "", "" ),
            new TSymLookupEntry( 0x0093a950, 00001, "", "" ),
            new TSymLookupEntry( 0x0093a9c8, 00001, "", "" ),
            new TSymLookupEntry( 0x0093ba34, 00001, "", "" ),
            new TSymLookupEntry( 0x0093c618, 00001, "", "" ),
            new TSymLookupEntry( 0x0093c75c, 00001, "", "" ),
            new TSymLookupEntry( 0x0093d358, 00001, "", "" ),
            new TSymLookupEntry( 0x0093d4a8, 00001, "", "" ),
            new TSymLookupEntry( 0x0093e098, 00001, "", "" ),
            new TSymLookupEntry( 0x0093e21c, 00001, "", "" ),
            new TSymLookupEntry( 0x0093ee00, 00001, "", "" ),
            new TSymLookupEntry( 0x0093ef6c, 00001, "", "" ),
            new TSymLookupEntry( 0x0093fb68, 00001, "", "" ),
            new TSymLookupEntry( 0x0093fcc0, 00001, "", "" ),
            new TSymLookupEntry( 0x0093fce8, 00001, "", "" ),
            new TSymLookupEntry( 0x0093fd10, 00001, "", "" ),
            new TSymLookupEntry( 0x0093fd60, 00001, "", "" ),
            new TSymLookupEntry( 0x0093fd88, 00001, "", "" ),
            new TSymLookupEntry( 0x0093fdd8, 00001, "", "" ),
            new TSymLookupEntry( 0x0093fea4, 00001, "", "" ),
            new TSymLookupEntry( 0x00940a88, 00001, "", "" ),
            new TSymLookupEntry( 0x00940bcc, 00001, "", "" ),
            new TSymLookupEntry( 0x009417c8, 00001, "", "" ),
            new TSymLookupEntry( 0x00941918, 00001, "", "" ),
            new TSymLookupEntry( 0x00942508, 00001, "", "" ),
            new TSymLookupEntry( 0x00942638, 00001, "", "" ),
            new TSymLookupEntry( 0x009436a4, 00001, "", "" ),
            new TSymLookupEntry( 0x00944288, 00001, "", "" ),
            new TSymLookupEntry( 0x009443f4, 00001, "", "" ),
            new TSymLookupEntry( 0x00945000, 00001, "", "" ),
            new TSymLookupEntry( 0x00945158, 00001, "", "" ),
            new TSymLookupEntry( 0x00945180, 00001, "", "" ),
            new TSymLookupEntry( 0x009451a8, 00001, "", "" ),
            new TSymLookupEntry( 0x009451f8, 00001, "", "" ),
            new TSymLookupEntry( 0x00945220, 00001, "", "" ),
            new TSymLookupEntry( 0x00945270, 00001, "", "" ),
            new TSymLookupEntry( 0x0094533c, 00001, "", "" ),
            new TSymLookupEntry( 0x00945f20, 00001, "", "" ),
            new TSymLookupEntry( 0x00946064, 00001, "", "" ),
            new TSymLookupEntry( 0x00946c60, 00001, "", "" ),
            new TSymLookupEntry( 0x00946db0, 00001, "", "" ),
            new TSymLookupEntry( 0x009479a0, 00001, "", "" ),
            new TSymLookupEntry( 0x00947b24, 00001, "", "" ),
            new TSymLookupEntry( 0x00948708, 00001, "", "" ),
            new TSymLookupEntry( 0x00948874, 00001, "", "" ),
            new TSymLookupEntry( 0x00949470, 00001, "", "" ),
            new TSymLookupEntry( 0x009495c8, 00001, "", "" ),
            new TSymLookupEntry( 0x009495f0, 00001, "", "" ),
            new TSymLookupEntry( 0x00949618, 00001, "", "" ),
            new TSymLookupEntry( 0x00949668, 00001, "", "" ),
            new TSymLookupEntry( 0x00949690, 00001, "", "" ),
            new TSymLookupEntry( 0x009496e0, 00001, "", "" ),
            new TSymLookupEntry( 0x009497ac, 00001, "", "" ),
            new TSymLookupEntry( 0x0094a390, 00001, "", "" ),
            new TSymLookupEntry( 0x0094a4d4, 00001, "", "" ),
            new TSymLookupEntry( 0x0094b0d0, 00001, "", "" ),
            new TSymLookupEntry( 0x0094b220, 00001, "", "" ),
            new TSymLookupEntry( 0x0094be10, 00001, "", "" ),
            new TSymLookupEntry( 0x0094bf94, 00001, "", "" ),
            new TSymLookupEntry( 0x0094cb78, 00001, "", "" ),
            new TSymLookupEntry( 0x0094cce4, 00001, "", "" ),
            new TSymLookupEntry( 0x0094d8e0, 00001, "", "" ),
            new TSymLookupEntry( 0x0094da38, 00001, "", "" ),
            new TSymLookupEntry( 0x0094da60, 00001, "", "" ),
            new TSymLookupEntry( 0x0094da88, 00001, "", "" ),
            new TSymLookupEntry( 0x0094dad8, 00001, "", "" ),
            new TSymLookupEntry( 0x0094db00, 00001, "", "" ),
            new TSymLookupEntry( 0x0094db50, 00001, "", "" ),
            new TSymLookupEntry( 0x0094dba0, 00001, "", "" ),
            new TSymLookupEntry( 0x0094ec34, 00001, "", "" ),
            new TSymLookupEntry( 0x0094f818, 00001, "", "" ),
            new TSymLookupEntry( 0x0094f95c, 00001, "", "" ),
            new TSymLookupEntry( 0x00950558, 00001, "", "" ),
            new TSymLookupEntry( 0x009506a8, 00001, "", "" ),
            new TSymLookupEntry( 0x00951298, 00001, "", "" ),
            new TSymLookupEntry( 0x0095141c, 00001, "", "" ),
            new TSymLookupEntry( 0x00952000, 00001, "", "" ),
            new TSymLookupEntry( 0x0095216c, 00001, "", "" ),
            new TSymLookupEntry( 0x00952d68, 00001, "", "" ),
            new TSymLookupEntry( 0x00952ec0, 00001, "", "" ),
            new TSymLookupEntry( 0x00952ee8, 00001, "", "" ),
            new TSymLookupEntry( 0x00952f10, 00001, "", "" ),
            new TSymLookupEntry( 0x00952f60, 00001, "", "" ),
            new TSymLookupEntry( 0x00952f88, 00001, "", "" ),
            new TSymLookupEntry( 0x00952fd8, 00001, "", "" ),
            new TSymLookupEntry( 0x009530a4, 00001, "", "" ),
            new TSymLookupEntry( 0x00953c88, 00001, "", "" ),
            new TSymLookupEntry( 0x00953dcc, 00001, "", "" ),
            new TSymLookupEntry( 0x009549c8, 00001, "", "" ),
            new TSymLookupEntry( 0x00954b18, 00001, "", "" ),
            new TSymLookupEntry( 0x00955708, 00001, "", "" ),
            new TSymLookupEntry( 0x009559bc, 00001, "", "" ),
            new TSymLookupEntry( 0x009565a0, 00001, "", "" ),
            new TSymLookupEntry( 0x0095670c, 00001, "", "" ),
            new TSymLookupEntry( 0x00957308, 00001, "", "" ),
            new TSymLookupEntry( 0x00957460, 00001, "", "" ),
            new TSymLookupEntry( 0x00957488, 00001, "", "" ),
            new TSymLookupEntry( 0x009574b0, 00001, "", "" ),
            new TSymLookupEntry( 0x00957500, 00001, "", "" ),
            new TSymLookupEntry( 0x00957528, 00001, "", "" ),
            new TSymLookupEntry( 0x00957578, 00001, "", "" ),
            new TSymLookupEntry( 0x00957644, 00001, "", "" ),
            new TSymLookupEntry( 0x00958228, 00001, "", "" ),
            new TSymLookupEntry( 0x0095836c, 00001, "", "" ),
            new TSymLookupEntry( 0x00958f68, 00001, "", "" ),
            new TSymLookupEntry( 0x009590b8, 00001, "", "" ),
            new TSymLookupEntry( 0x00959ca8, 00001, "", "" ),
            new TSymLookupEntry( 0x00959e2c, 00001, "", "" ),
            new TSymLookupEntry( 0x0095aa10, 00001, "", "" ),
            new TSymLookupEntry( 0x0095ab7c, 00001, "", "" ),
            new TSymLookupEntry( 0x0095b778, 00001, "", "" ),
            new TSymLookupEntry( 0x0095b8d0, 00001, "", "" ),
            new TSymLookupEntry( 0x0095c8e8, 00001, "", "" ),
            new TSymLookupEntry( 0x0095c910, 00001, "", "" ),
            new TSymLookupEntry( 0x0095c938, 00001, "", "" ),
            new TSymLookupEntry( 0x0095c988, 00001, "", "" ),
            new TSymLookupEntry( 0x0095c9b0, 00001, "", "" ),
            new TSymLookupEntry( 0x0095ca00, 00001, "", "" ),
            new TSymLookupEntry( 0x0095cacc, 00001, "", "" ),
            new TSymLookupEntry( 0x0095d6b0, 00001, "", "" ),
            new TSymLookupEntry( 0x0095d7f4, 00001, "", "" ),
            new TSymLookupEntry( 0x0095e3f0, 00001, "", "" ),
            new TSymLookupEntry( 0x0095e540, 00001, "", "" ),
            new TSymLookupEntry( 0x0095f130, 00001, "", "" ),
            new TSymLookupEntry( 0x0095f2b4, 00001, "", "" ),
            new TSymLookupEntry( 0x0095fe98, 00001, "", "" ),
            new TSymLookupEntry( 0x00960014, 00001, "", "" ),
            new TSymLookupEntry( 0x00960c10, 00001, "", "" ),
            new TSymLookupEntry( 0x00960d68, 00001, "", "" ),
            new TSymLookupEntry( 0x00960d90, 00001, "", "" ),
            new TSymLookupEntry( 0x00960db8, 00001, "", "" ),
            new TSymLookupEntry( 0x00960e08, 00001, "", "" ),
            new TSymLookupEntry( 0x00960e30, 00001, "", "" ),
            new TSymLookupEntry( 0x00960e80, 00001, "", "" ),
            new TSymLookupEntry( 0x00960f4c, 00001, "", "" ),
            new TSymLookupEntry( 0x00961b30, 00001, "", "" ),
            new TSymLookupEntry( 0x00961c74, 00001, "", "" ),
            new TSymLookupEntry( 0x00962870, 00001, "", "" ),
            new TSymLookupEntry( 0x009629c0, 00001, "", "" ),
            new TSymLookupEntry( 0x009635b0, 00001, "", "" ),
            new TSymLookupEntry( 0x00963734, 00001, "", "" ),
            new TSymLookupEntry( 0x00964318, 00001, "", "" ),
            new TSymLookupEntry( 0x00964484, 00001, "", "" ),
            new TSymLookupEntry( 0x00965080, 00001, "", "" ),
            new TSymLookupEntry( 0x009651d8, 00001, "", "" ),
            new TSymLookupEntry( 0x00965200, 00001, "", "" ),
            new TSymLookupEntry( 0x00965228, 00001, "", "" ),
            new TSymLookupEntry( 0x00965278, 00001, "", "" ),
            new TSymLookupEntry( 0x009652a0, 00001, "", "" ),
            new TSymLookupEntry( 0x009652f0, 00001, "", "" ),
            new TSymLookupEntry( 0x009653bc, 00001, "", "" ),
            new TSymLookupEntry( 0x00965fa0, 00001, "", "" ),
            new TSymLookupEntry( 0x009660e4, 00001, "", "" ),
            new TSymLookupEntry( 0x00966ce0, 00001, "", "" ),
            new TSymLookupEntry( 0x00966e30, 00001, "", "" ),
            new TSymLookupEntry( 0x00967a20, 00001, "", "" ),
            new TSymLookupEntry( 0x00967ba4, 00001, "", "" ),
            new TSymLookupEntry( 0x00968788, 00001, "", "" ),
            new TSymLookupEntry( 0x009688f4, 00001, "", "" ),
            new TSymLookupEntry( 0x009694f0, 00001, "", "" ),
            new TSymLookupEntry( 0x00969648, 00001, "", "" ),
            new TSymLookupEntry( 0x00969670, 00001, "", "" ),
            new TSymLookupEntry( 0x00969698, 00001, "", "" ),
            new TSymLookupEntry( 0x009696e8, 00001, "", "" ),
            new TSymLookupEntry( 0x00969710, 00001, "", "" ),
            new TSymLookupEntry( 0x00969760, 00001, "", "" ),
            new TSymLookupEntry( 0x009697b0, 00001, "", "" ),
            new TSymLookupEntry( 0x0096a844, 00001, "", "" ),
            new TSymLookupEntry( 0x0096b428, 00001, "", "" ),
            new TSymLookupEntry( 0x0096b56c, 00001, "", "" ),
            new TSymLookupEntry( 0x0096c168, 00001, "", "" ),
            new TSymLookupEntry( 0x0096c2b8, 00001, "", "" ),
            new TSymLookupEntry( 0x0096cea8, 00001, "", "" ),
            new TSymLookupEntry( 0x0096d014, 00001, "", "" ),
            new TSymLookupEntry( 0x0096d02c, 00001, "", "" ),
            new TSymLookupEntry( 0x0096dc10, 00001, "", "" ),
            new TSymLookupEntry( 0x0096dd7c, 00001, "", "" ),
            new TSymLookupEntry( 0x0096e978, 00001, "", "" ),
            new TSymLookupEntry( 0x0096ead0, 00001, "", "" ),
            new TSymLookupEntry( 0x0096eaf8, 00001, "", "" ),
            new TSymLookupEntry( 0x0096eb20, 00001, "", "" ),
            new TSymLookupEntry( 0x0096eb70, 00001, "", "" ),
            new TSymLookupEntry( 0x0096eb98, 00001, "", "" ),
            new TSymLookupEntry( 0x0096ebe8, 00001, "", "" ),
            new TSymLookupEntry( 0x0096ecb4, 00001, "", "" ),
            new TSymLookupEntry( 0x0096f898, 00001, "", "" ),
            new TSymLookupEntry( 0x0096f9dc, 00001, "", "" ),
            new TSymLookupEntry( 0x009705d8, 00001, "", "" ),
            new TSymLookupEntry( 0x00970728, 00001, "", "" ),
            new TSymLookupEntry( 0x00971318, 00001, "", "" ),
            new TSymLookupEntry( 0x0097149c, 00001, "", "" ),
            new TSymLookupEntry( 0x00972080, 00001, "", "" ),
            new TSymLookupEntry( 0x009721ec, 00001, "", "" ),
            new TSymLookupEntry( 0x00972de8, 00001, "", "" ),
            new TSymLookupEntry( 0x00972f40, 00001, "", "" ),
            new TSymLookupEntry( 0x00972f68, 00001, "", "" ),
            new TSymLookupEntry( 0x00972f90, 00001, "", "" ),
            new TSymLookupEntry( 0x00973000, 00001, "", "" ),
            new TSymLookupEntry( 0x00973028, 00001, "", "" ),
            new TSymLookupEntry( 0x00973078, 00001, "", "" ),
            new TSymLookupEntry( 0x00973144, 00001, "", "" ),
            new TSymLookupEntry( 0x00973d28, 00001, "", "" ),
            new TSymLookupEntry( 0x00973e6c, 00001, "", "" ),
            new TSymLookupEntry( 0x00974a68, 00001, "", "" ),
            new TSymLookupEntry( 0x00974bb8, 00001, "", "" ),
            new TSymLookupEntry( 0x009757a8, 00001, "", "" ),
            new TSymLookupEntry( 0x0097592c, 00001, "", "" ),
            new TSymLookupEntry( 0x00976510, 00001, "", "" ),
            new TSymLookupEntry( 0x0097667c, 00001, "", "" ),
            new TSymLookupEntry( 0x00977278, 00001, "", "" ),
            new TSymLookupEntry( 0x009773d0, 00001, "", "" ),
            new TSymLookupEntry( 0x009773f8, 00001, "", "" ),
            new TSymLookupEntry( 0x00977420, 00001, "", "" ),
            new TSymLookupEntry( 0x00977470, 00001, "", "" ),
            new TSymLookupEntry( 0x00977498, 00001, "", "" ),
            new TSymLookupEntry( 0x009774e8, 00001, "", "" ),
            new TSymLookupEntry( 0x00977560, 00001, "", "" ),
            new TSymLookupEntry( 0x00978000, 00001, "", "" ),
            new TSymLookupEntry( 0x009785cc, 00001, "", "" ),
            new TSymLookupEntry( 0x009791b0, 00001, "", "" ),
            new TSymLookupEntry( 0x009792f4, 00001, "", "" ),
            new TSymLookupEntry( 0x00979ef0, 00001, "", "" ),
            new TSymLookupEntry( 0x0097a048, 00001, "", "" ),
            new TSymLookupEntry( 0x0097ac38, 00001, "", "" ),
            new TSymLookupEntry( 0x0097adbc, 00001, "", "" ),
            new TSymLookupEntry( 0x0097b9a0, 00001, "", "" ),
            new TSymLookupEntry( 0x0097bbe8, 00001, "", "" ),
            new TSymLookupEntry( 0x0097bc68, 00001, "", "" ),
            new TSymLookupEntry( 0x0097c388, 00001, "", "" ),
            new TSymLookupEntry( 0x0097c478, 00001, "", "" ),
            new TSymLookupEntry( 0x0097cb68, 00001, "", "" ),
            new TSymLookupEntry( 0x0097cba0, 00001, "", "" ),
            new TSymLookupEntry( 0x0097d830, 00001, "", "" ),
            new TSymLookupEntry( 0x0098303b, 00001, "", "" ),
            new TSymLookupEntry( 0x00983138, 00001, "", "" ),
            new TSymLookupEntry( 0x009832ac, 00001, "", "" ),
            new TSymLookupEntry( 0x00984960, 00001, "", "" ),
            new TSymLookupEntry( 0x009854d4, 00001, "", "" ),
            new TSymLookupEntry( 0x00986b88, 00001, "", "" ),
            new TSymLookupEntry( 0x00986c74, 00001, "", "" ),
            new TSymLookupEntry( 0x00987110, 00001, "", "" ),
            new TSymLookupEntry( 0x00988e34, 00001, "", "" ),
            new TSymLookupEntry( 0x009892d0, 00001, "", "" ),
            new TSymLookupEntry( 0x0098afa4, 00001, "", "" ),
            new TSymLookupEntry( 0x0098b440, 00001, "", "" ),
            new TSymLookupEntry( 0x0098ba64, 00001, "", "" ),
            new TSymLookupEntry( 0x0098d164, 00001, "", "" ),
            new TSymLookupEntry( 0x0098d1dc, 00001, "", "" ),
            new TSymLookupEntry( 0x0098d678, 00001, "", "" ),
            new TSymLookupEntry( 0x0098dc9c, 00001, "", "" ),
            new TSymLookupEntry( 0x0098f414, 00001, "", "" ),
            new TSymLookupEntry( 0x0098f8b0, 00001, "", "" ),
            new TSymLookupEntry( 0x0098fdb4, 00001, "", "" ),
            new TSymLookupEntry( 0x0098fed4, 00001, "", "" ),
            new TSymLookupEntry( 0x009b08d0, 00001, "", "" ),
            new TSymLookupEntry( 0x009d08e0, 00001, "", "" ),
            new TSymLookupEntry( 0x009f14db, 00001, "", "" ),
            new TSymLookupEntry( 0x009f21ee, 00001, "", "" ),
            new TSymLookupEntry( 0x009f3c19, 00001, "", "" ),
            new TSymLookupEntry( 0x009f6422, 00001, "", "" ),
            new TSymLookupEntry( 0x01010001, 00002, "", "" ),
            new TSymLookupEntry( 0x01010002, 00002, "", "" ),
            new TSymLookupEntry( 0x0101ffff, 00002, "", "" ),
            new TSymLookupEntry( 0x013387e0, 00001, "", "" ),
            new TSymLookupEntry( 0x0169007a, 00001, "", "" ),
            new TSymLookupEntry( 0x01747468, 00001, "", "" ),
            new TSymLookupEntry( 0x03000000, 00001, "", "" ),
            new TSymLookupEntry( 0x04000000, 00002, "", "" ),
            new TSymLookupEntry( 0x04018000, 00002, "", "" ),
            new TSymLookupEntry( 0x04747468, 00002, "", "" ),
            new TSymLookupEntry( 0x048e830c, 00001, "", "" ),
            new TSymLookupEntry( 0x08cc0032, 00001, "", "" ),
            new TSymLookupEntry( 0x0a1a0a0d, 00003, "", "" ),
            new TSymLookupEntry( 0x0ff2ff31, 00003, "", "" ),
            new TSymLookupEntry( 0x0fffffff, 00001, "", "" ),
            new TSymLookupEntry( 0x10000000, 00003, "", "" ),
            new TSymLookupEntry( 0x1000582c, 00001, "", "" ),
            new TSymLookupEntry( 0x100059b9, 00001, "", "" ),
            new TSymLookupEntry( 0x10005a26, 00008, "", "" ),
            new TSymLookupEntry( 0x101f446f, 00001, "", "" ),
            new TSymLookupEntry( 0x101f45c8, 00008, "", "" ),
            new TSymLookupEntry( 0x101f4a6b, 00016, "", "" ),
            new TSymLookupEntry( 0x101f86e3, 00001, "", "" ),
            new TSymLookupEntry( 0x1020384e, 00001, "", "" ),
            new TSymLookupEntry( 0x102071fd, 00001, "", "" ),
            new TSymLookupEntry( 0x1028235b, 00001, "", "" ),
            new TSymLookupEntry( 0x18a92000, 00001, "", "" ),
            new TSymLookupEntry( 0x1fb55e5b, 00001, "", "" ),
            new TSymLookupEntry( 0x1ffffff0, 00005, "", "" ),
            new TSymLookupEntry( 0x20000000, 00006, "", "" ),
            new TSymLookupEntry( 0x20544547, 00001, "", "" ),
            new TSymLookupEntry( 0x215f6fcd, 00001, "", "" ),
            new TSymLookupEntry( 0x2c657554, 00001, "", "" ),
            new TSymLookupEntry( 0x2d305b5e, 00001, "", "" ),
            new TSymLookupEntry( 0x2d6f7369, 00001, "", "" ),
            new TSymLookupEntry( 0x2fffff01, 00002, "", "" ),
            new TSymLookupEntry( 0x30000000, 00002, "", "" ),
            new TSymLookupEntry( 0x30000004, 00001, "", "" ),
            new TSymLookupEntry( 0x3000000f, 00001, "", "" ),
            new TSymLookupEntry( 0x30000040, 00001, "", "" ),
            new TSymLookupEntry( 0x30751891, 00001, "", "" ),
            new TSymLookupEntry( 0x32390000, 00001, "", "" ),
            new TSymLookupEntry( 0x38314b4f, 00001, "", "" ),
            new TSymLookupEntry( 0x38464947, 00001, "", "" ),
            new TSymLookupEntry( 0x39303032, 00001, "", "" ),
            new TSymLookupEntry( 0x3ffc8120, 00002, "", "" ),
            new TSymLookupEntry( 0x3ffdeda8, 00001, "", "" ),
            new TSymLookupEntry( 0x40040001, 00001, "", "" ),
            new TSymLookupEntry( 0x40060001, 00001, "", "" ),
            new TSymLookupEntry( 0x40080003, 00001, "", "" ),
            new TSymLookupEntry( 0x40088003, 00018, "", "" ),
            new TSymLookupEntry( 0x4034001e, 00001, "", "" ),
            new TSymLookupEntry( 0x40390022, 00001, "", "" ),
            new TSymLookupEntry( 0x416d005c, 00001, "", "" ),
            new TSymLookupEntry( 0x424f4c42, 00001, "", "" ),
            new TSymLookupEntry( 0x45544e49, 00004, "", "" ),
            new TSymLookupEntry( 0x474e5089, 00021, "", "" ),
            new TSymLookupEntry( 0x4a1780da, 00001, "", "" ),
            new TSymLookupEntry( 0x50435245, 00034, "", "" ),
            new TSymLookupEntry( 0x509890be, 00001, "", "" ),
            new TSymLookupEntry( 0x53a6befb, 00001, "", "" ),
            new TSymLookupEntry( 0x54584554, 00004, "", "" ),
            new TSymLookupEntry( 0x5f6c6274, 00002, "", "" ),
            new TSymLookupEntry( 0x61746164, 00001, "", "" ),
            new TSymLookupEntry( 0x6176612f, 00003, "", "" ),
            new TSymLookupEntry( 0x65636341, 00001, "", "" ),
            new TSymLookupEntry( 0x65676150, 00001, "", "" ),
            new TSymLookupEntry( 0x656c6966, 00018, "", "" ),
            new TSymLookupEntry( 0x656d616e, 00003, "", "" ),
            new TSymLookupEntry( 0x65707974, 00002, "", "" ),
            new TSymLookupEntry( 0x65746e69, 00002, "", "" ),
            new TSymLookupEntry( 0x65747962, 00001, "", "" ),
            new TSymLookupEntry( 0x67616d69, 00001, "", "" ),
            new TSymLookupEntry( 0x69667657, 00001, "", "" ),
            new TSymLookupEntry( 0x696c7173, 00003, "", "" ),
            new TSymLookupEntry( 0x697a6f4d, 00001, "", "" ),
            new TSymLookupEntry( 0x6d617473, 00001, "", "" ),
            new TSymLookupEntry( 0x6d783f3c, 00002, "", "" ),
            new TSymLookupEntry( 0x6e2f2f3a, 00001, "", "" ),
            new TSymLookupEntry( 0x6e32ddf5, 00001, "", "" ),
            new TSymLookupEntry( 0x6e696d23, 00002, "", "" ),
            new TSymLookupEntry( 0x6e6f6349, 00003, "", "" ),
            new TSymLookupEntry( 0x6e6f6369, 00003, "", "" ),
            new TSymLookupEntry( 0x6f4e2d58, 00001, "", "" ),
            new TSymLookupEntry( 0x70697a67, 00001, "", "" ),
            new TSymLookupEntry( 0x70747468, 00019, "", "" ),
            new TSymLookupEntry( 0x74617473, 00001, "", "" ),
            new TSymLookupEntry( 0x746f6f72, 00002, "", "" ),
            new TSymLookupEntry( 0x74786574, 00008, "", "" ),
            new TSymLookupEntry( 0x756c6176, 00001, "", "" ),
            new TSymLookupEntry( 0x7874cd4c, 00001, "vtable for CEikLafEnv", @"\epoc32\release\ARMV5\urel\eikcore.dll" ),
            new TSymLookupEntry( 0x7874cdd4, 00001, "vtable for CEikProcess", @"\epoc32\release\ARMV5\urel\eikcore.dll" ),
            new TSymLookupEntry( 0x7874ce9c, 00001, "vtable for CEikEnvExtra", @"\epoc32\release\ARMV5\urel\eikcore.dll" ),
            new TSymLookupEntry( 0x7874cef8, 00001, "vtable for CArrayFixFlat<CEikonEnv::TEikAppUiFactory>", @"\epoc32\release\ARMV5\urel\eikcore.dll" ),
            new TSymLookupEntry( 0x7874cf0c, 00001, "vtable for CArrayFixFlat<SEikControlInfo(*)(int)>", @"\epoc32\release\ARMV5\urel\eikcore.dll" ),
            new TSymLookupEntry( 0x7874cf20, 00001, "vtable for CArrayPtrFlat<CFbsBitmap>", @"\epoc32\release\ARMV5\urel\eikcore.dll" ),
            new TSymLookupEntry( 0x7874cf34, 00001, "vtable for CArrayPtrFlat<CEikLibrary>", @"\epoc32\release\ARMV5\urel\eikcore.dll" ),
            new TSymLookupEntry( 0x7874cf48, 00001, "vtable for CArrayPtrFlat<CLafSystemFont>", @"\epoc32\release\ARMV5\urel\eikcore.dll" ),
            new TSymLookupEntry( 0x7874cf5c, 00001, "vtable for CArrayPtrFlat<MEikPictureFactory>", @"\epoc32\release\ARMV5\urel\eikcore.dll" ),
            new TSymLookupEntry( 0x7874cfe8, 00001, "vtable for CEikAppUiExtra", @"\epoc32\release\ARMV5\urel\eikcore.dll" ),
            new TSymLookupEntry( 0x7874d060, 00001, "vtable for CEikErrorIdler", @"\epoc32\release\ARMV5\urel\eikcore.dll" ),
            new TSymLookupEntry( 0x7874d080, 00001, "vtable for CEikInfoMsgWin", @"\epoc32\release\ARMV5\urel\eikcore.dll" ),
            new TSymLookupEntry( 0x7874d1ac, 00001, "vtable for CEikResourceChange", @"\epoc32\release\ARMV5\urel\eikcore.dll" ),
            new TSymLookupEntry( 0x7874d418, 00001, "vtable for CEikLogicalBorderProxy", @"\epoc32\release\ARMV5\urel\eikcore.dll" ),
            new TSymLookupEntry( 0x7874d480, 00001, "vtable for CEikPictureFactoryResolver", @"\epoc32\release\ARMV5\urel\eikcore.dll" ),
            new TSymLookupEntry( 0x7874d5cc, 00001, "vtable for CEikonEnv", @"\epoc32\release\ARMV5\urel\eikcore.dll" ),
            new TSymLookupEntry( 0x78755ff8, 00001, "vtable for CArrayFixFlat<TRgb>", @"\epoc32\release\ARMV5\urel\uiklaf.dll" ),
            new TSymLookupEntry( 0x78756040, 00001, "vtable for CAknInfoMsgWin", @"\epoc32\release\ARMV5\urel\uiklaf.dll" ),
            new TSymLookupEntry( 0x78806348, 00001, "vtable for CExitWatch", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78806fc4, 00001, "vtable for CAknFadeStack", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78807014, 00008, "vtable for CAknIndicator", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78807554, 00001, "vtable for CAknSgcClient", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7880758c, 00001, "vtable for CAknTitlePane", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7880784c, 00003, "vtable for CArrayFixFlat<TPtrC16>", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78807860, 00001, "vtable for CArrayFixFlat<CAknTitlePaneLabel::SAknTitleLableEffect>", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x788078ec, 00001, "vtable for CArrayFixFlat<MAknSyncDrawer*>", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78807900, 00001, "vtable for CArrayFixFlat<MAknFadedComponent*>", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78807928, 00016, "vtable for CArrayPtrFlat<CFbsBitmap>", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7880793c, 00003, "vtable for CArrayPtrFlat<CAknIndicator>", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78807964, 00001, "vtable for CArrayPtrFlat<MAknIntermediateState>", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78807978, 00001, "vtable for CArrayPtrFlat<CAknNavigationDecorator>", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x788079c8, 00001, "vtable for CArrayPtrFlat<CAknView>", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x788079dc, 00001, "vtable for CArrayPtrFlat<CAknViewAppUi::CViewActivationItem>", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x788079f0, 00001, "vtable for CCenRepListen", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78807be4, 00001, "vtable for CAknAppShutter", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78808270, 00001, "vtable for CAknSignalIcon", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78808340, 00001, "vtable for CAknSignalPane", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7880865c, 00010, "vtable for CLafSystemFont", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78808758, 00001, "vtable for CAknBatteryIcon", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78808828, 00001, "vtable for CAknBatteryPane", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x788088f8, 00001, "vtable for CAknContextPane", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78809284, 00001, "vtable for CAknSoundPlayer", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78809298, 00003, "vtable for CAknTextControl", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78809378, 00001, "vtable for CAknViewShutter", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x788098fc, 00001, "vtable for CAknDigitalClock", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x788099d0, 00001, "vtable for CAknEmptyControl", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78809aa4, 00001, "vtable for CAknFontRegistry", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78809f94, 00001, "vtable for CAknLayoutConfig", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78809fa8, 00001, "vtable for CAknPreviewPopUp", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7880a2fc, 00001, "vtable for CAknSettingCache", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7880a8d0, 00003, "vtable for CAknInfoPopupNote", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7880ab50, 00001, "vtable for CAknSgcClientImpl", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7880ab68, 00001, "vtable for CAknViewExtension", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7880ad04, 00001, "vtable for CAknAppUiExtension", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7880ada8, 00001, "vtable for CAknKeySoundSystem", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7880b654, 00001, "vtable for CAknSignalStrength", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7880b724, 00001, "vtable for CAknSkinnableClock", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7880b838, 00001, "vtable for CAknTitlePaneLabel", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7880b948, 00001, "vtable for CAknWsEventMonitor", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7880bb3c, 00001, "vtable for CTransitionManager", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7880bc50, 00001, "vtable for CAknBatteryStrength", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7880c09c, 00001, "vtable for CAknDiallerLauncher", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7880c2a8, 00001, "vtable for CAknIdleContextPane", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7880d864, 00001, "vtable for CAknDrawSynchronizer", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7880da6c, 00010, "vtable for CAknFontIdLayoutFont", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7880ed88, 00001, "vtable for CAknAppUiBaseExtension", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7880f078, 00003, "vtable for CAknIndicatorContainer", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7880f160, 00008, "vtable for CAknIndicatorExtension", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7880ff40, 00001, "vtable for CAknSignalDataObserver", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x788100c0, 00001, "vtable for CAknTitlePaneExtension", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x788100e4, 00001, "vtable for CAknViewAppUiExtension", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x788105c8, 00001, "vtable for CAknBatteryDataObserver", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78811084, 00002, "vtable for CAknNavigationDecorator", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x788119dc, 00001, "vtable for CAknSignalPaneExtension", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78811a9c, 00001, "vtable for CAknContextPaneExtension", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78811cf0, 00001, "vtable for CAknPointerEventModifier", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78812268, 00001, "vtable for CAknIndicatorDataObserver", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78812f00, 00001, "vtable for CAknNaviForegroundObserver", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78813068, 00001, "vtable for CAknPreviewPopUpController", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7881321c, 00001, "vtable for CAknStatuspaneDigitalClock", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7881360c, 00003, "vtable for CAknInfoPopupNoteController", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x788142f8, 00001, "vtable for CAknSignalIndicatorContainer", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x788145f8, 00001, "vtable for CAknStatusPaneDataSubscriber", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78814618, 00001, "vtable for CAknStatusPaneSubscriberData", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78814710, 00001, "vtable for CAknBatteryIndicatorContainer", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x788148b4, 00001, "vtable for CAknDigitalClockChangeHandler", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x7881503c, 00001, "vtable for CAknNavigationControlContainer", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78815810, 00003, "vtable for CAknIndicatorContainerExtension", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x788159d4, 00001, "vtable for CAknSkinnableClockChangeHandler", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78815b00, 00001, "vtable for CAknUniversalIndicatorContainer", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78815dc0, 00002, "vtable for CAknNavigationDecoratorExtension", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78816804, 00001, "vtable for TSgcClientStatusPaneRedrawCoordinator", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78816bdc, 00001, "vtable for CAknNavigationControlContainerExtension", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78817280, 00001, "vtable for CAknEnv", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x788176d0, 00003, "vtable for CAknText", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78817ae4, 00001, "vtable for CAknStatusPaneDataSubscriber::TWsEventObserver", @"\epoc32\release\ARMV5\urel\avkon.dll" ),
            new TSymLookupEntry( 0x78826abc, 00001, "vtable for CAknGlobalNote", @"\epoc32\release\ARMV5\urel\aknnotify.dll" ),
            new TSymLookupEntry( 0x78826b20, 00002, "vtable for CAknSoftNotifier", @"\epoc32\release\ARMV5\urel\aknnotify.dll" ),
            new TSymLookupEntry( 0x78826b84, 00002, "vtable for CAknSoftNotifierExt", @"\epoc32\release\ARMV5\urel\aknnotify.dll" ),
            new TSymLookupEntry( 0x78826be8, 00002, "vtable for CWait", @"\epoc32\release\ARMV5\urel\aknnotify.dll" ),
            new TSymLookupEntry( 0x78828c94, 00001, "vtable for CAknTransitionUtils", @"\epoc32\release\ARMV5\urel\akntransitionutils.dll" ),
            new TSymLookupEntry( 0x788381ac, 00001, "vtable for CCdlEngine", @"\epoc32\release\ARMV5\urel\cdlengine.dll" ),
            new TSymLookupEntry( 0x78838268, 00001, "vtable for CCdlEngineRef", @"\epoc32\release\ARMV5\urel\cdlengine.dll" ),
            new TSymLookupEntry( 0x7883829c, 00001, "vtable for CCdlLibManager", @"\epoc32\release\ARMV5\urel\cdlengine.dll" ),
            new TSymLookupEntry( 0x788382b0, 00013, "vtable for CCdlDllInstance", @"\epoc32\release\ARMV5\urel\cdlengine.dll" ),
            new TSymLookupEntry( 0x788382d4, 00001, "vtable for CCdlChangeMonitor", @"\epoc32\release\ARMV5\urel\cdlengine.dll" ),
            new TSymLookupEntry( 0x788382f4, 00013, "vtable for CCdlInstanceProxy", @"\epoc32\release\ARMV5\urel\cdlengine.dll" ),
            new TSymLookupEntry( 0x78838318, 00001, "vtable for CCdlChangeObserver", @"\epoc32\release\ARMV5\urel\cdlengine.dll" ),
            new TSymLookupEntry( 0x78838358, 00013, "vtable for CCdlCustomisationStack", @"\epoc32\release\ARMV5\urel\cdlengine.dll" ),
            new TSymLookupEntry( 0x788461d7, 00001, "CEikCoCtlLibrary::CreateByTypeL(int)", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x788462d3, 00001, "CEikCoCtlLibrary::CreateButtonGroupByTypeL(int, EikButtonGroupFactory::TCreationData&, int&)", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888a348, 00003, "vtable for CAknButton", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888a428, 00001, "vtable for CAknToolbar", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888a6ac, 00001, "vtable for CEikMenuBar", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888a9e8, 00001, "vtable for CEikMenuPane", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888ac80, 00001, "vtable for CArrayFixFlat<TEikGroupControl>", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888ac94, 00001, "vtable for CArrayFixFlat<CEikMenuBar::SPosition>", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888aca8, 00003, "vtable for CArrayFixFlat<CEikCbaButton::SButtonOptions>", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888acd0, 00001, "vtable for CArrayFixFlat<CEikButtonGroupContainer::TCmdPos>", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888acf8, 00001, "vtable for CArrayFixFlat<MEikButtonGroup*(*)(int, EikButtonGroupFactory::TCreationData&, int&)>", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888ad0c, 00003, "vtable for CArrayPtrFlat<CAknButtonState>", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888ad5c, 00001, "vtable for CArrayPtrFlat<CEikStatusPaneContainer>", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888ad70, 00002, "vtable for CArrayPtrFlat<CEikStatusPaneLayoutTree>", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888ad98, 00001, "vtable for CArrayPtrFlat<CEikStatusPaneModelBase::CIdLayoutPair>", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888ade4, 00003, "vtable for CEikCbaButton", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888af8c, 00001, "vtable for CEikScrollBar", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888b0a0, 00001, "vtable for CAknEdwinState", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888b2f4, 00001, "vtable for CEikStatusPane", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888b450, 00003, "vtable for CAknButtonState", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888b58c, 00003, "vtable for CAknToolbarItem", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888baa0, 00001, "vtable for CEikAppUiFactory", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888bca0, 00001, "vtable for CEikCbaExtension", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888c3b4, 00001, "vtable for CEikStatusPaneTls", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888c630, 00005, "vtable for CEikLabelExtension", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888c7c8, 00003, "vtable for CAknButtonExtension", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888cae0, 00001, "vtable for CRedrawStoreHandler", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888cd44, 00001, "vtable for CEikButtonGroupStack", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888cd60, 00001, "vtable for CEikMenuBarExtension", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888cd8c, 00002, "vtable for CEikStatusPaneLayout", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888cfa0, 00001, "vtable for CEikCbaScrollBarFrame", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888d304, 00001, "vtable for CEikStatusPaneSetInit", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888d47c, 00001, "vtable for CEikAppStatusPaneModel", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888d590, 00001, "vtable for CEikScrollBarExtension", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888d8dc, 00009, "vtable for CEikStatusPaneContainer", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888da9c, 00003, "vtable for CAknButtonStateExtension", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888db98, 00001, "vtable for CEikButtonGroupContainer", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888dc94, 00010, "vtable for CEikStatusPaneLayoutTree", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888dcb8, 00001, "vtable for CEikAppUiFactoryExtension", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888e0a8, 00001, "vtable for CEikButtonGroupFactoryArray", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888e0c4, 00001, "vtable for CEikStatusPaneBaseExtension", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888e500, 00001, "vtable for CEikCba", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888e898, 00003, "vtable for CEikImage", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888e96c, 00004, "vtable for CEikLabel", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888ea5c, 00001, "vtable for CEikMenuBar::CTitleArray", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x7888eae8, 00002, "vtable for CEikStatusPaneModelBase::CIdLayoutPair", @"\epoc32\release\ARMV5\urel\eikcoctl.dll" ),
            new TSymLookupEntry( 0x788a2c84, 00002, "vtable for CAknsEffectCommand", @"\epoc32\release\ARMV5\urel\aknskins.dll" ),
            new TSymLookupEntry( 0x788a2cc0, 00002, "vtable for CAknsBitmapItemData", @"\epoc32\release\ARMV5\urel\aknskins.dll" ),
            new TSymLookupEntry( 0x788a2d70, 00001, "vtable for CAknsAppSkinInstance", @"\epoc32\release\ARMV5\urel\aknskins.dll" ),
            new TSymLookupEntry( 0x788a2e44, 00001, "vtable for CAknsAppUiParameters", @"\epoc32\release\ARMV5\urel\aknskins.dll" ),
            new TSymLookupEntry( 0x788a2ea8, 00004, "vtable for CAknsEffectParameter", @"\epoc32\release\ARMV5\urel\aknskins.dll" ),
            new TSymLookupEntry( 0x788a2ebc, 00009, "vtable for CAknsTemporaryBitmap", @"\epoc32\release\ARMV5\urel\aknskins.dll" ),
            new TSymLookupEntry( 0x788a2fbc, 00003, "vtable for CAknsColorTableItemData", @"\epoc32\release\ARMV5\urel\aknskins.dll" ),
            new TSymLookupEntry( 0x788a2fd0, 00006, "vtable for CAknsImageTableItemData", @"\epoc32\release\ARMV5\urel\aknskins.dll" ),
            new TSymLookupEntry( 0x788a2ff8, 00007, "vtable for CAknsEffectQueueItemData", @"\epoc32\release\ARMV5\urel\aknskins.dll" ),
            new TSymLookupEntry( 0x788a3048, 00066, "vtable for CAknsMaskedBitmapItemData", @"\epoc32\release\ARMV5\urel\aknskins.dll" ),
            new TSymLookupEntry( 0x788a30d8, 00079, "vtable for CAknsAppSkinInstanceCacheEntry", @"\epoc32\release\ARMV5\urel\aknskins.dll" ),
            new TSymLookupEntry( 0x788a30ec, 00002, "vtable for CAknsBasicBackgroundControlContext", @"\epoc32\release\ARMV5\urel\aknskins.dll" ),
            new TSymLookupEntry( 0x788a3130, 00008, "vtable for CAknsFrameBackgroundControlContext", @"\epoc32\release\ARMV5\urel\aknskins.dll" ),
            new TSymLookupEntry( 0x788a3204, 00001, "vtable for CAknsCombinedBackgroundControlContext", @"\epoc32\release\ARMV5\urel\aknskins.dll" ),
            new TSymLookupEntry( 0x788a3248, 00005, "vtable for CAknsMaskedLayerBackgroundControlContext", @"\epoc32\release\ARMV5\urel\aknskins.dll" ),
            new TSymLookupEntry( 0x788ab7cc, 00150, "vtable for CAknBitmap", @"\epoc32\release\ARMV5\urel\AknIcon.dll" ),
            new TSymLookupEntry( 0x788ab7e0, 00001, "vtable for CAknIconLoader", @"\epoc32\release\ARMV5\urel\AknIcon.dll" ),
            new TSymLookupEntry( 0x788ab81c, 00076, "vtable for CAknIconManager", @"\epoc32\release\ARMV5\urel\AknIcon.dll" ),
            new TSymLookupEntry( 0x788ab8a0, 00001, "vtable for CAknIconSrvTlsData", @"\epoc32\release\ARMV5\urel\AknIcon.dll" ),
            new TSymLookupEntry( 0x788ab8c8, 00005, "vtable for CAknIconFileNameItem", @"\epoc32\release\ARMV5\urel\AknIcon.dll" ),
            new TSymLookupEntry( 0x788ab8dc, 00005, "vtable for CAknIconLocationInfo", @"\epoc32\release\ARMV5\urel\AknIcon.dll" ),
            new TSymLookupEntry( 0x788ab9e8, 00001, "vtable for CAknIconFileNameCache", @"\epoc32\release\ARMV5\urel\AknIcon.dll" ),
            new TSymLookupEntry( 0x789ac178, 00001, "vtable for CAknsSrvChunkLookup", @"\epoc32\release\ARMV5\urel\aknskinsrv.dll" ),
            new TSymLookupEntry( 0x789ac2f4, 00001, "vtable for CAknsSkinChangeHandler", @"\epoc32\release\ARMV5\urel\aknskinsrv.dll" ),
            new TSymLookupEntry( 0x789c0638, 00002, "vtable for CTextResolver", @"\epoc32\release\ARMV5\urel\COMMONENGINE.DLL" ),
            new TSymLookupEntry( 0x78a00a08, 00001, "vtable for CAknExtendedInputCapabilities", @"\epoc32\release\ARMV5\urel\eikctl.dll" ),
            new TSymLookupEntry( 0x78a19cf0, 00001, "vtable for CTouchFeedbackImpl", @"\epoc32\release\ARMV5\urel\touchfeedback.dll" ),
            new TSymLookupEntry( 0x78a19d94, 00001, "vtable for CTouchFeedbackClient", @"\epoc32\release\ARMV5\urel\touchfeedback.dll" ),
            new TSymLookupEntry( 0x78a19da8, 00003, "vtable for CTouchFeedbackRegistry", @"\epoc32\release\ARMV5\urel\touchfeedback.dll" ),
            new TSymLookupEntry( 0x78a19dbc, 00001, "vtable for CTouchFeedbackAdaptation", @"\epoc32\release\ARMV5\urel\touchfeedback.dll" ),
            new TSymLookupEntry( 0x78a6e378, 00002, "vtable for CAknsRlScanlines", @"\epoc32\release\ARMV5\urel\aknskinrenderlib.dll" ),
            new TSymLookupEntry( 0x78a6e490, 00001, "vtable for CAknsRlMasterLayout", @"\epoc32\release\ARMV5\urel\aknskinrenderlib.dll" ),
            new TSymLookupEntry( 0x78a6e558, 00001, "vtable for CAknsRlDefaultRenderer", @"\epoc32\release\ARMV5\urel\aknskinrenderlib.dll" ),
            new TSymLookupEntry( 0x78a6e5d0, 00001, "vtable for CAknsRlEffectPluginNoise", @"\epoc32\release\ARMV5\urel\aknskinrenderlib.dll" ),
            new TSymLookupEntry( 0x78a6e62c, 00001, "vtable for CAknsRlEffectPluginInvert", @"\epoc32\release\ARMV5\urel\aknskinrenderlib.dll" ),
            new TSymLookupEntry( 0x78a6e688, 00001, "vtable for CAknsRlInternalEffectPool", @"\epoc32\release\ARMV5\urel\aknskinrenderlib.dll" ),
            new TSymLookupEntry( 0x78a6e6ec, 00001, "vtable for CAknsRlEffectPluginBumpMap", @"\epoc32\release\ARMV5\urel\aknskinrenderlib.dll" ),
            new TSymLookupEntry( 0x78a6e784, 00001, "vtable for CAknsRlEffectPluginApplyGfx", @"\epoc32\release\ARMV5\urel\aknskinrenderlib.dll" ),
            new TSymLookupEntry( 0x78a6e7e0, 00001, "vtable for CAknsRlEffectPluginContrast", @"\epoc32\release\ARMV5\urel\aknskinrenderlib.dll" ),
            new TSymLookupEntry( 0x78a6e83c, 00001, "vtable for CAknsRlEffectPluginSolarize", @"\epoc32\release\ARMV5\urel\aknskinrenderlib.dll" ),
            new TSymLookupEntry( 0x78a6e898, 00001, "vtable for CAknsRlEffectPluginGrayscale", @"\epoc32\release\ARMV5\urel\aknskinrenderlib.dll" ),
            new TSymLookupEntry( 0x78a6e8f4, 00001, "vtable for CAknsRlEffectPluginAlphaBlend", @"\epoc32\release\ARMV5\urel\aknskinrenderlib.dll" ),
            new TSymLookupEntry( 0x78a6e950, 00001, "vtable for CAknsRlEffectPluginApplyColor", @"\epoc32\release\ARMV5\urel\aknskinrenderlib.dll" ),
            new TSymLookupEntry( 0x78a6e9ac, 00001, "vtable for CAknsRlEffectPluginBlackWhite", @"\epoc32\release\ARMV5\urel\aknskinrenderlib.dll" ),
            new TSymLookupEntry( 0x78a6ea08, 00001, "vtable for CAknsRlEffectPluginSaturation", @"\epoc32\release\ARMV5\urel\aknskinrenderlib.dll" ),
            new TSymLookupEntry( 0x78a6ea64, 00001, "vtable for CAknsRlEffectPluginConvolution", @"\epoc32\release\ARMV5\urel\aknskinrenderlib.dll" ),
            new TSymLookupEntry( 0x78a6eac0, 00001, "vtable for CAknsRlEffectPluginChannelBlend", @"\epoc32\release\ARMV5\urel\aknskinrenderlib.dll" ),
            new TSymLookupEntry( 0x78a6eb1c, 00001, "vtable for CAknsRlEffectPluginMovingLayers", @"\epoc32\release\ARMV5\urel\aknskinrenderlib.dll" ),
            new TSymLookupEntry( 0x78a6eb78, 00001, "vtable for CAknsRlEffectPluginAdjustChannels", @"\epoc32\release\ARMV5\urel\aknskinrenderlib.dll" ),
            new TSymLookupEntry( 0x78a93774, 00001, "vtable for CPtiEngine", @"\epoc32\release\ARMV5\urel\ptiengine.dll" ),
            new TSymLookupEntry( 0x78a93800, 00001, "vtable for CArrayPtrFlat<CPtiCoreLanguage>", @"\epoc32\release\ARMV5\urel\ptiengine.dll" ),
            new TSymLookupEntry( 0x78a93814, 00001, "vtable for CArrayPtrFlat<CPtiCore>", @"\epoc32\release\ARMV5\urel\ptiengine.dll" ),
            new TSymLookupEntry( 0x78a93924, 00001, "vtable for CMultiTapTimer", @"\epoc32\release\ARMV5\urel\ptiengine.dll" ),
            new TSymLookupEntry( 0x78a93944, 00001, "vtable for CPtiEngineImpl", @"\epoc32\release\ARMV5\urel\ptiengine.dll" ),
            new TSymLookupEntry( 0x78a93ac0, 00001, "vtable for CPtiDefaultCore", @"\epoc32\release\ARMV5\urel\ptiengine.dll" ),
            new TSymLookupEntry( 0x78a93c4c, 00002, "vtable for CPtiKeyMappings", @"\epoc32\release\ARMV5\urel\ptiengine.dll" ),
            new TSymLookupEntry( 0x78a93cb0, 00006, "vtable for CPtiCoreLanguage", @"\epoc32\release\ARMV5\urel\ptiengine.dll" ),
            new TSymLookupEntry( 0x78a93e40, 00001, "vtable for CPtiQwertyKeyMappings", @"\epoc32\release\ARMV5\urel\ptiengine.dll" ),
            new TSymLookupEntry( 0x78a93ea0, 00001, "vtable for CPtiNumberModeDataImpl", @"\epoc32\release\ARMV5\urel\ptiengine.dll" ),
            new TSymLookupEntry( 0x78a94010, 00001, "vtable for CPtiQwertyKeymappingsExtension", @"\epoc32\release\ARMV5\urel\ptiengine.dll" ),
            new TSymLookupEntry( 0x78b1c6f4, 00002, "vtable for CDocumentHandler", @"\epoc32\release\ARMV5\urel\commonui.dll" ),
            new TSymLookupEntry( 0x78b1ca40, 00002, "vtable for CErrorUI", @"\epoc32\release\ARMV5\urel\commonui.dll" ),
            new TSymLookupEntry( 0x78ca9d30, 00001, "vtable for CActiveApDb", @"\epoc32\release\ARMV5\urel\ApEngine.dll" ),
            new TSymLookupEntry( 0x78ca9d6c, 00001, "vtable for CApItemExtra", @"\epoc32\release\ARMV5\urel\ApEngine.dll" ),
            new TSymLookupEntry( 0x78ca9d80, 00001, "vtable for CVpnApEngine", @"\epoc32\release\ARMV5\urel\ApEngine.dll" ),
            new TSymLookupEntry( 0x78ca9de4, 00001, "vtable for CArrayPtrFlat<MActiveApDbObserver>", @"\epoc32\release\ARMV5\urel\ApEngine.dll" ),
            new TSymLookupEntry( 0x78ca9e0c, 00001, "vtable for CApDataHandler", @"\epoc32\release\ARMV5\urel\ApEngine.dll" ),
            new TSymLookupEntry( 0x78ca9e48, 00001, "vtable for CApItemWlanData", @"\epoc32\release\ARMV5\urel\ApEngine.dll" ),
            new TSymLookupEntry( 0x78ca9e84, 00001, "vtable for CApAccessPointItem", @"\epoc32\release\ARMV5\urel\ApEngine.dll" ),
            new TSymLookupEntry( 0x78ca9ec0, 00001, "vtable for CActiveApDbNotifier", @"\epoc32\release\ARMV5\urel\ApEngine.dll" ),
            new TSymLookupEntry( 0x78ca9ee0, 00001, "vtable for CApUtils", @"\epoc32\release\ARMV5\urel\ApEngine.dll" ),
            new TSymLookupEntry( 0x78cbbe84, 00001, "vtable for CArrayPtrFlat<RHttpDownload>", @"\epoc32\release\ARMV5\urel\DownloadMgr.dll" ),
            new TSymLookupEntry( 0x78cbbe98, 00001, "vtable for CArrayPtrFlat<CDefaultAttrib>", @"\epoc32\release\ARMV5\urel\DownloadMgr.dll" ),
            new TSymLookupEntry( 0x78cbbeac, 00001, "vtable for CArrayPtrFlat<MHttpDownloadMgrObserver>", @"\epoc32\release\ARMV5\urel\DownloadMgr.dll" ),
            new TSymLookupEntry( 0x78cbbec0, 00001, "vtable for CDefaultAttrib", @"\epoc32\release\ARMV5\urel\DownloadMgr.dll" ),
            new TSymLookupEntry( 0x78cbbfc0, 00001, "vtable for CDownloadMgrHandler", @"\epoc32\release\ARMV5\urel\DownloadMgr.dll" ),
            new TSymLookupEntry( 0x78cbc0bc, 00001, "vtable for CRHttpDownloadMgrExtension", @"\epoc32\release\ARMV5\urel\DownloadMgr.dll" ),
            new TSymLookupEntry( 0x78f30e3c, 00004, "vtable for CWidgetPropertyValue", @"\epoc32\release\ARMV5\urel\WidgetRegistryClient.dll" ),
            new TSymLookupEntry( 0x79268568, 00001, "vtable for CAknDllInitializer", @"\epoc32\release\ARMV5\urel\akninit.dll" ),
            new TSymLookupEntry( 0x7926df60, 00001, "vtable for CEikDebugKeys", @"\epoc32\release\ARMV5\urel\eikcdlg.dll" ),
            new TSymLookupEntry( 0x7926e434, 00001, "vtable for CEikAlertNotifier", @"\epoc32\release\ARMV5\urel\eikcdlg.dll" ),
            new TSymLookupEntry( 0x7926e61c, 00001, "vtable for CEikCDlgDialogFactory", @"\epoc32\release\ARMV5\urel\eikcdlg.dll" ),
            new TSymLookupEntry( 0x7932deb0, 00001, "vtable for CAknFepPlugin", @"\epoc32\release\ARMV5\urel\avkonfep.dll" ),
            new TSymLookupEntry( 0x7932def4, 00001, "vtable for CArrayPtrFlat<MAknFepManagerInterface>", @"\epoc32\release\ARMV5\urel\avkonfep.dll" ),
            new TSymLookupEntry( 0x7932df38, 00001, "vtable for CAknFepManager", @"\epoc32\release\ARMV5\urel\avkonfep.dll" ),
            new TSymLookupEntry( 0x7932e3b8, 00001, "vtable for CAknFepKeyCatcher", @"\epoc32\release\ARMV5\urel\avkonfep.dll" ),
            new TSymLookupEntry( 0x7932e4b8, 00001, "vtable for CAknFepCaseManager", @"\epoc32\release\ARMV5\urel\avkonfep.dll" ),
            new TSymLookupEntry( 0x7932e4cc, 00001, "vtable for CAknFepFnKeyManager", @"\epoc32\release\ARMV5\urel\avkonfep.dll" ),
            new TSymLookupEntry( 0x7932e4e0, 00001, "vtable for CAknFepPluginManager", @"\epoc32\release\ARMV5\urel\avkonfep.dll" ),
            new TSymLookupEntry( 0x7932e690, 00001, "vtable for CAknFepHashKeyManager", @"\epoc32\release\ARMV5\urel\avkonfep.dll" ),
            new TSymLookupEntry( 0x7932e6e0, 00001, "vtable for CAknFepLanguageManager", @"\epoc32\release\ARMV5\urel\avkonfep.dll" ),
            new TSymLookupEntry( 0x7932e6f4, 00002, "vtable for CAknFepThaiSCTSelector", @"\epoc32\release\ARMV5\urel\avkonfep.dll" ),
            new TSymLookupEntry( 0x7932e86c, 00001, "vtable for CAknFepUIManagerWestern", @"\epoc32\release\ARMV5\urel\avkonfep.dll" ),
            new TSymLookupEntry( 0x7932ebc4, 00001, "vtable for CAknFepPluginMenuManager", @"\epoc32\release\ARMV5\urel\avkonfep.dll" ),
            new TSymLookupEntry( 0x7932ec04, 00002, "vtable for CAknFepRepositoryWatcher", @"\epoc32\release\ARMV5\urel\avkonfep.dll" ),
            new TSymLookupEntry( 0x7932ef1c, 00001, "vtable for CAknFepInlineTextDecorator", @"\epoc32\release\ARMV5\urel\avkonfep.dll" ),
            new TSymLookupEntry( 0x7932ef30, 00001, "vtable for CAknFepSharedDataInterface", @"\epoc32\release\ARMV5\urel\avkonfep.dll" ),
            new TSymLookupEntry( 0x7932ef80, 00001, "vtable for CAknFepVietnameseToneManager", @"\epoc32\release\ARMV5\urel\avkonfep.dll" ),
            new TSymLookupEntry( 0x79330f64, 00002, "vtable for CAknFepSharedDataInterface::CSubscriber", @"\epoc32\release\ARMV5\urel\avkonfep.dll" ),
            new TSymLookupEntry( 0x7933e000, 00001, "vtable for CPeninputServerObserver", @"\epoc32\release\ARMV5\urel\peninputclient.dll" ),
            new TSymLookupEntry( 0x7933e030, 00001, "vtable for CPenInputSingletonClient", @"\epoc32\release\ARMV5\urel\peninputclient.dll" ),
            new TSymLookupEntry( 0x7934de00, 00001, "vtable for CAknFepUIAvkonImpl", @"\epoc32\release\ARMV5\urel\AknFepUiAvkonPlugin.dll" ),
            new TSymLookupEntry( 0x7934dee4, 00001, "vtable for CAknFepIndicatorAvkon", @"\epoc32\release\ARMV5\urel\AknFepUiAvkonPlugin.dll" ),
            new TSymLookupEntry( 0x7934e7c4, 00001, "vtable for CAknFepExactWordPopupContent", @"\epoc32\release\ARMV5\urel\AknFepUiAvkonPlugin.dll" ),
            new TSymLookupEntry( 0x7937c970, 00001, "vtable for CPtiLangDataImplEnglish", @"\epoc32\release\ARMV5\urel\PtiKeymappings_01.dll" ),
            new TSymLookupEntry( 0x7937ca3c, 00001, "vtable for CPtiVariant01DataFactory", @"\epoc32\release\ARMV5\urel\PtiKeymappings_01.dll" ),
            new TSymLookupEntry( 0x79394ecc, 00001, "vtable for CPtiZiCore", @"\epoc32\release\ARMV5\urel\PtiZiCore.dll" ),
            new TSymLookupEntry( 0x79395088, 00001, "vtable for CPtiZiUserDict", @"\epoc32\release\ARMV5\urel\PtiZiCore.dll" ),
            new TSymLookupEntry( 0x793950f8, 00001, "vtable for CPtiZiAutoSubst", @"\epoc32\release\ARMV5\urel\PtiZiCore.dll" ),
            new TSymLookupEntry( 0x7939510c, 00001, "vtable for CPtiZiSharedDataBlock", @"\epoc32\release\ARMV5\urel\PtiZiCore.dll" ),
            new TSymLookupEntry( 0x793f21e0, 00001, "vtable for CWidgetUiApp", @"\epoc32\release\ARMV5\urel\WidgetUi.exe" ),
            new TSymLookupEntry( 0x793f2230, 00001, "vtable for CCpsPublisher", @"\epoc32\release\ARMV5\urel\WidgetUi.exe" ),
            new TSymLookupEntry( 0x793f2254, 00001, "vtable for CWidgetUiAppUi", @"\epoc32\release\ARMV5\urel\WidgetUi.exe" ),
            new TSymLookupEntry( 0x793f23bc, 00001, "vtable for CWidgetUiWindow", @"\epoc32\release\ARMV5\urel\WidgetUi.exe" ),
            new TSymLookupEntry( 0x793f24b4, 00001, "vtable for CWidgetUiDocument", @"\epoc32\release\ARMV5\urel\WidgetUi.exe" ),
            new TSymLookupEntry( 0x793f2524, 00001, "vtable for CWidgetUiObserver", @"\epoc32\release\ARMV5\urel\WidgetUi.exe" ),
            new TSymLookupEntry( 0x793f25e0, 00001, "vtable for CWidgetUiAsyncExit", @"\epoc32\release\ARMV5\urel\WidgetUi.exe" ),
            new TSymLookupEntry( 0x793f2600, 00001, "vtable for CWidgetUiWindowView", @"\epoc32\release\ARMV5\urel\WidgetUi.exe" ),
            new TSymLookupEntry( 0x793f271c, 00001, "vtable for CWidgetUiWindowManager", @"\epoc32\release\ARMV5\urel\WidgetUi.exe" ),
            new TSymLookupEntry( 0x793f273c, 00001, "vtable for CWidgetUiWindowContainer", @"\epoc32\release\ARMV5\urel\WidgetUi.exe" ),
            new TSymLookupEntry( 0x793f2820, 00001, "vtable for CWidgetUiDialogsProviderProxy", @"\epoc32\release\ARMV5\urel\WidgetUi.exe" ),
            new TSymLookupEntry( 0x795bb97c, 00001, "vtable for CLiwBinding", @"\epoc32\release\ARMV5\urel\Liwservicehandler.dll" ),
            new TSymLookupEntry( 0x795bb990, 00001, "vtable for CLiwTlsData", @"\epoc32\release\ARMV5\urel\Liwservicehandler.dll" ),
            new TSymLookupEntry( 0x795bbac4, 00002, "vtable for CLiwEcomMonitor", @"\epoc32\release\ARMV5\urel\Liwservicehandler.dll" ),
            new TSymLookupEntry( 0x795bbaf8, 00001, "vtable for CLiwServiceData", @"\epoc32\release\ARMV5\urel\Liwservicehandler.dll" ),
            new TSymLookupEntry( 0x795bbb0c, 00001, "vtable for CLiwCriteriaItem", @"\epoc32\release\ARMV5\urel\Liwservicehandler.dll" ),
            new TSymLookupEntry( 0x795bbc3c, 00002, "vtable for CLiwServiceHandler", @"\epoc32\release\ARMV5\urel\Liwservicehandler.dll" ),
            new TSymLookupEntry( 0x795bbc5c, 00004, "vtable for CLiwGenericParamList", @"\epoc32\release\ARMV5\urel\Liwservicehandler.dll" ),
            new TSymLookupEntry( 0x795bbc70, 00002, "vtable for CLiwServiceHandlerImpl", @"\epoc32\release\ARMV5\urel\Liwservicehandler.dll" ),
            new TSymLookupEntry( 0x795ca594, 00001, "vtable for CRTSecMgrScriptSession", @"\epoc32\release\ARMV5\urel\RTSecMgrClient.dll" ),
            new TSymLookupEntry( 0x795ca5c8, 00001, "vtable for CRTSecMgrSubSessionProxy", @"\epoc32\release\ARMV5\urel\RTSecMgrClient.dll" ),
            new TSymLookupEntry( 0x795ccd78, 00003, "vtable for CPermission", @"\epoc32\release\ARMV5\urel\RTSecMgrUtil.dll" ),
            new TSymLookupEntry( 0x795ccd8c, 00001, "vtable for CPermissionSet", @"\epoc32\release\ARMV5\urel\RTSecMgrUtil.dll" ),
            new TSymLookupEntry( 0x795ccdb4, 00001, "vtable for CScript", @"\epoc32\release\ARMV5\urel\RTSecMgrUtil.dll" ),
            new TSymLookupEntry( 0x79655558, 00001, "vtable for CPluginFepManagerItut", @"\epoc32\release\ARMV5\urel\peninputimepluginitut.dll" ),
            new TSymLookupEntry( 0x79655638, 00001, "vtable for CPenInputImePluginItut", @"\epoc32\release\ARMV5\urel\peninputimepluginitut.dll" ),
            new TSymLookupEntry( 0x796a96f4, 00001, "vtable for CCPClientService", @"\epoc32\release\ARMV5\urel\cpclient.dll" ),
            new TSymLookupEntry( 0x796a9714, 00001, "vtable for CCPActiveNotifier", @"\epoc32\release\ARMV5\urel\cpclient.dll" ),
            new TSymLookupEntry( 0x796a975c, 00001, "vtable for CDataSourceInterface", @"\epoc32\release\ARMV5\urel\cpclient.dll" ),
            new TSymLookupEntry( 0x796a97bc, 00001, "vtable for CCPClient", @"\epoc32\release\ARMV5\urel\cpclient.dll" ),
            new TSymLookupEntry( 0x796b0524, 00001, "vtable for CContentMap", @"\epoc32\release\ARMV5\urel\cputils.dll" ),
            new TSymLookupEntry( 0x796c92cc, 00003, "vtable for CBrowserDialogsProvider", @"\epoc32\release\ARMV5\urel\BrowserDialogsProvider.dll" ),
            new TSymLookupEntry( 0x798561ac, 00003, "vtable for RT_GestureHelper::CCallbackTimer", @"\epoc32\release\ARMV5\urel\rt_gesturehelper.dll" ),
            new TSymLookupEntry( 0x798561cc, 00001, "vtable for RT_GestureHelper::CGestureHelper", @"\epoc32\release\ARMV5\urel\rt_gesturehelper.dll" ),
            new TSymLookupEntry( 0x7985623c, 00001, "vtable for RT_GestureHelper::CPointerCapturer", @"\epoc32\release\ARMV5\urel\rt_gesturehelper.dll" ),
            new TSymLookupEntry( 0x79856250, 00001, "vtable for RT_GestureHelper::CGestureHelperImpl", @"\epoc32\release\ARMV5\urel\rt_gesturehelper.dll" ),
            new TSymLookupEntry( 0x79856264, 00001, "vtable for RT_GestureHelper::CGestureEventFilter", @"\epoc32\release\ARMV5\urel\rt_gesturehelper.dll" ),
            new TSymLookupEntry( 0x798562d4, 00002, "vtable for RT_GestureHelper::CGesture", @"\epoc32\release\ARMV5\urel\rt_gesturehelper.dll" ),
            new TSymLookupEntry( 0x79897150, 00002, "vtable for CHttpFilterDigestAuthentication", @"\epoc32\release\ARMV5\urel\httpfilterauthentication.dll" ),
            new TSymLookupEntry( 0x7997d7bc, 00002, "vtable for CUserInteractionsUtils", @"\epoc32\release\ARMV5\urel\DownloadMgrUiLib.dll" ),
            new TSymLookupEntry( 0x7997d7e8, 00002, "vtable for CAsyncEventHandlerArray", @"\epoc32\release\ARMV5\urel\DownloadMgrUiLib.dll" ),
            new TSymLookupEntry( 0x7997d7fc, 00001, "vtable for CDownloadsListExtension", @"\epoc32\release\ARMV5\urel\DownloadMgrUiLib.dll" ),
            new TSymLookupEntry( 0x7997d820, 00001, "vtable for CUiLibRegistryExtension", @"\epoc32\release\ARMV5\urel\DownloadMgrUiLib.dll" ),
            new TSymLookupEntry( 0x7997d840, 00001, "vtable for CDownloadMgrUiLibRegistry", @"\epoc32\release\ARMV5\urel\DownloadMgrUiLib.dll" ),
            new TSymLookupEntry( 0x7997d8ac, 00001, "vtable for CDownloadMgrUiDownloadMenu", @"\epoc32\release\ARMV5\urel\DownloadMgrUiLib.dll" ),
            new TSymLookupEntry( 0x7997d8c0, 00001, "vtable for CUserInteractionsExtension", @"\epoc32\release\ARMV5\urel\DownloadMgrUiLib.dll" ),
            new TSymLookupEntry( 0x7997d8e4, 00001, "vtable for CDownloadMgrUiDownloadsList", @"\epoc32\release\ARMV5\urel\DownloadMgrUiLib.dll" ),
            new TSymLookupEntry( 0x7997d980, 00001, "vtable for CDownloadMgrUiUserInteractions", @"\epoc32\release\ARMV5\urel\DownloadMgrUiLib.dll" ),
            new TSymLookupEntry( 0x79c36d94, 00001, "vtable for CConnManActiveConnector", @"\epoc32\release\ARMV5\urel\ConnectionManager.dll" ),
            new TSymLookupEntry( 0x79c36db4, 00001, "vtable for CInternetConnectionManager", @"\epoc32\release\ARMV5\urel\ConnectionManager.dll" ),
            new TSymLookupEntry( 0x79c36ed0, 00001, "vtable for CActiveConnectorSyncWrapper", @"\epoc32\release\ARMV5\urel\ConnectionManager.dll" ),
            new TSymLookupEntry( 0x79c36ef0, 00001, "vtable for CConnectionStageNotifierWCB", @"\epoc32\release\ARMV5\urel\ConnectionManager.dll" ),
            new TSymLookupEntry( 0x79c4ccb0, 00001, "vtable for CUserAgent", @"\epoc32\release\ARMV5\urel\WEBUTILS.dll" ),
            new TSymLookupEntry( 0x79c51b00, 00001, "vtable for CHTTPFilterDRM", @"\epoc32\release\ARMV5\urel\HTTPFilterDRM.dll" ),
            new TSymLookupEntry( 0x79c54eb8, 00001, "vtable for CHttpFilterProxy", @"\epoc32\release\ARMV5\urel\httpfilterproxy.dll" ),
            new TSymLookupEntry( 0x79c5a3c8, 00001, "vtable for CPnpPaosXml", @"\epoc32\release\ARMV5\urel\PnpPaosFilter.dll" ),
            new TSymLookupEntry( 0x79c5a47c, 00001, "vtable for CPnpPaosFilter", @"\epoc32\release\ARMV5\urel\PnpPaosFilter.dll" ),
            new TSymLookupEntry( 0x79c60edc, 00001, "vtable for CHttpFilterCameseMcInfo", @"\epoc32\release\ARMV5\urel\httpfiltercamese.dll" ),
            new TSymLookupEntry( 0x79c60ef0, 00001, "vtable for CHttpFilterCameseDrmHeader", @"\epoc32\release\ARMV5\urel\httpfiltercamese.dll" ),
            new TSymLookupEntry( 0x79c66c00, 00001, "vtable for CCameseUiCommon", @"\epoc32\release\ARMV5\urel\cameseuicommon.dll" ),
            new TSymLookupEntry( 0x79c66c38, 00001, "vtable for CCameseNoteManager", @"\epoc32\release\ARMV5\urel\cameseuicommon.dll" ),
            new TSymLookupEntry( 0x79c70868, 00001, "vtable for CMusicShopHttpFilterMcInfo", @"\epoc32\release\ARMV5\urel\musicshophttpfilter.dll" ),
            new TSymLookupEntry( 0x79c74cb4, 00001, "vtable for CHttpFilterConnHandler", @"\epoc32\release\ARMV5\urel\httpfilterconnhandler.dll" ),
            new TSymLookupEntry( 0x79c74d00, 00001, "vtable for CHttpFilterConnHandlerObserver", @"\epoc32\release\ARMV5\urel\httpfilterconnhandler.dll" ),
            new TSymLookupEntry( 0x79c80db0, 00001, "vtable for CHttpUAProfFilter", @"\epoc32\release\ARMV5\urel\uaproffilter.dll" ),
            new TSymLookupEntry( 0x79dec340, 00001, "", "" ),
            new TSymLookupEntry( 0x79def6d8, 00001, "vtable for HistoryController", @"\epoc32\release\ARMV5\urel\WebKitUtils.dll" ),
            new TSymLookupEntry( 0x79e1aec8, 00001, "vtable for CStopScheduler", @"\epoc32\release\ARMV5\urel\MemMan.dll" ),
            new TSymLookupEntry( 0x79e1af58, 00001, "vtable for CDefaultMemoryPool", @"\epoc32\release\ARMV5\urel\MemMan.dll" ),
            new TSymLookupEntry( 0x79e1c860, 00001, "vtable for CHttpFilterIop", @"\epoc32\release\ARMV5\urel\httpfilterIop.dll" ),
            new TSymLookupEntry( 0x79e797b0, 00028, "vtable for KJS::NegateNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e797e8, 00588, "vtable for KJS::NumberNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e79820, 00076, "vtable for KJS::RegExpNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e79858, 00314, "vtable for KJS::ReturnNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e79898, 00941, "vtable for KJS::StringNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e798d0, 00001, "vtable for KJS::SwitchNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e79910, 00061, "vtable for KJS::BitOperNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e79948, 00116, "vtable for KJS::BooleanNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e79980, 00004, "vtable for KJS::DoWhileNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e799c0, 00067, "vtable for KJS::ElementNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e79b2c, 00021, "vtable for KJS::NewExprNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e79b64, 00007, "vtable for KJS::ProgramNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e79ba4, 03818, "vtable for KJS::ResolveNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e79bdc, 00462, "vtable for KJS::VarDeclNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e79c14, 00002, "vtable for KJS::ContinueNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e79cd4, 00014, "vtable for KJS::FuncDeclNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e79d14, 00313, "vtable for KJS::FuncExprNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e79d4c, 00329, "vtable for KJS::PropertyNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e79e84, 01216, "vtable for KJS::ArgumentsNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e79f3c, 00274, "vtable for KJS::AssignDotNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e79f74, 00001, "vtable for KJS::CaseBlockNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7a2e8, 00403, "vtable for KJS::ParameterNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7a320, 00001, "vtable for KJS::PrefixDotNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7a420, 00001, "vtable for KJS::UnaryPlusNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7a5d8, 00408, "vtable for KJS::AssignExprNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7a610, 00001, "vtable for KJS::BitwiseNotNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7a648, 00003, "vtable for KJS::CaseClauseNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7a680, 00003, "vtable for KJS::ClauseListNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7a838, 00146, "vtable for KJS::LogicalNotNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7a970, 00005, "vtable for KJS::PostfixDotNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7a9a8, 00095, "vtable for KJS::RelationalNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7ab18, 00128, "vtable for KJS::ConditionalNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7ab88, 01403, "vtable for KJS::DotAccessorNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7b2a8, 00003, "vtable for KJS::TypeOfValueNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7b2e0, 00451, "vtable for KJS::VarDeclListNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7b318, 01647, "vtable for KJS::ArgumentListNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7b4d0, 00414, "vtable for KJS::FunctionBodyNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7b5c8, 00329, "vtable for KJS::PropertyListNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7b600, 00329, "vtable for KJS::PropertyNameNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7b6b8, 00292, "vtable for KJS::VarStatementNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7b6f8, 00068, "vtable for KJS::AssignBracketNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7b730, 00308, "vtable for KJS::AssignResolveNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7b768, 00432, "vtable for KJS::BinaryLogicalNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7b820, 00009, "vtable for KJS::DeleteBracketNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7b890, 00994, "vtable for KJS::ExprStatementNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7ba50, 00103, "vtable for KJS::ObjectLiteralNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7bac0, 00006, "vtable for KJS::PrefixResolveNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7baf8, 00022, "vtable for KJS::TypeOfResolveNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7bb30, 00001, "vtable for KJS::EmptyStatementNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7bbf0, 00001, "vtable for KJS::PostfixBracketNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7bc28, 00047, "vtable for KJS::PostfixResolveNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7bc60, 01836, "vtable for KJS::SourceElementsNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7bca0, 00352, "vtable for KJS::BracketAccessorNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7bd64, 00961, "vtable for KJS::FunctionCallDotNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7bf1c, 00004, "vtable for KJS::FunctionCallValueNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7bfd4, 00016, "vtable for KJS::FunctionCallBracketNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7c00c, 00215, "vtable for KJS::FunctionCallResolveNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7c0ec, 00421, "vtable for KJS::IfNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7c15c, 00386, "vtable for KJS::AddNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7c194, 00044, "vtable for KJS::ForNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7c1d4, 00012, "vtable for KJS::TryNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7c3bc, 00051, "vtable for KJS::MultNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7c3f4, 00058, "vtable for KJS::NullNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7c42c, 00395, "vtable for KJS::ThisNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7c49c, 00001, "vtable for KJS::WithNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7c55c, 00066, "vtable for KJS::ArrayNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7c594, 00280, "vtable for KJS::BlockNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7c5d4, 00019, "vtable for KJS::BreakNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7c64c, 00344, "vtable for KJS::EqualNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7c684, 00019, "vtable for KJS::ForInNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7c6c4, 00182, "vtable for KJS::GroupNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7c7ec, 00045, "vtable for KJS::ShiftNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7c854, 00002, "vtable for KJS::ThrowNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x79e7c894, 00017, "vtable for KJS::WhileNode", @"\epoc32\release\ARMV5\urel\JavascriptCore.dll" ),
            new TSymLookupEntry( 0x7a035f80, 00003, "vtable for CArrayPtrFlat<CHttpCacheEntry>", @"\epoc32\release\ARMV5\urel\BrowserCache.dll" ),
            new TSymLookupEntry( 0x7a035f94, 00003, "vtable for CArrayPtrFlat<CHttpCacheStreamEntry>", @"\epoc32\release\ARMV5\urel\BrowserCache.dll" ),
            new TSymLookupEntry( 0x7a035fa8, 00003, "vtable for CArrayPtrFlat<TSglQue<CHttpCacheEntry>>", @"\epoc32\release\ARMV5\urel\BrowserCache.dll" ),
            new TSymLookupEntry( 0x7a035fbc, 00015, "vtable for CHttpCacheEntry", @"\epoc32\release\ARMV5\urel\BrowserCache.dll" ),
            new TSymLookupEntry( 0x7a035fd0, 00003, "vtable for CHttpCacheHandler", @"\epoc32\release\ARMV5\urel\BrowserCache.dll" ),
            new TSymLookupEntry( 0x7a035fe4, 00001, "vtable for CHttpCacheManager", @"\epoc32\release\ARMV5\urel\BrowserCache.dll" ),
            new TSymLookupEntry( 0x7a03601c, 00003, "vtable for CHttpCacheObserver", @"\epoc32\release\ARMV5\urel\BrowserCache.dll" ),
            new TSymLookupEntry( 0x7a03603c, 00003, "vtable for CHttpCacheLookupTable", @"\epoc32\release\ARMV5\urel\BrowserCache.dll" ),
            new TSymLookupEntry( 0x7a036064, 00003, "vtable for CHttpCacheStreamHandler", @"\epoc32\release\ARMV5\urel\BrowserCache.dll" ),
            new TSymLookupEntry( 0x7a036078, 00003, "vtable for CHttpCacheEvictionHandler", @"\epoc32\release\ARMV5\urel\BrowserCache.dll" ),
            new TSymLookupEntry( 0x7a0c3ae4, 00001, "DefaultHash::Des16(const TDesC16&)", @"\epoc32\release\ARMV5\urel\WidgetEngine.dll" ),
            new TSymLookupEntry( 0x7a0c5150, 00001, "vtable for CMenuClient", @"\epoc32\release\ARMV5\urel\WidgetEngine.dll" ),
            new TSymLookupEntry( 0x7a0c51dc, 00005, "vtable for PrefElement", @"\epoc32\release\ARMV5\urel\WidgetEngine.dll" ),
            new TSymLookupEntry( 0x7a0c51f0, 00001, "vtable for CWidgetClient", @"\epoc32\release\ARMV5\urel\WidgetEngine.dll" ),
            new TSymLookupEntry( 0x7a0c5264, 00001, "vtable for WidgetEngineBridge", @"\epoc32\release\ARMV5\urel\WidgetEngine.dll" ),
            new TSymLookupEntry( 0x7a0c52a4, 00011, "vtable for CMenuItem", @"\epoc32\release\ARMV5\urel\WidgetEngine.dll" ),
            new TSymLookupEntry( 0x7a0c53c8, 00001, "vtable for KJS::MenuPrivate", @"\epoc32\release\ARMV5\urel\WidgetEngine.dll" ),
            new TSymLookupEntry( 0x7a0c54d8, 00001, "vtable for KJS::WidgetPrivate", @"\epoc32\release\ARMV5\urel\WidgetEngine.dll" ),
            new TSymLookupEntry( 0x7a0c5568, 00010, "vtable for KJS::MenuItemPrivate", @"\epoc32\release\ARMV5\urel\WidgetEngine.dll" ),
            new TSymLookupEntry( 0x7a0c5578, 00011, "vtable for KJS::WidgetEventHandler", @"\epoc32\release\ARMV5\urel\WidgetEngine.dll" ),
            new TSymLookupEntry( 0x7a0c571c, 00001, "vtable for KJS::JSWidget", @"\epoc32\release\ARMV5\urel\WidgetEngine.dll" ),
            new TSymLookupEntry( 0x7a15cfdc, 00001, "vtable for TDeviceBridge", @"\epoc32\release\ARMV5\urel\jsdevice.dll" ),
            new TSymLookupEntry( 0x7a15d29c, 00001, "vtable for KJS::CDeviceLiwBinding", @"\epoc32\release\ARMV5\urel\jsdevice.dll" ),
            new TSymLookupEntry( 0x7a20c778, 00001, "vtable for CCookieFilter", @"\epoc32\release\ARMV5\urel\CookieFilter.dll" ),
            new TSymLookupEntry( 0x7a3003ec, 00001, "vtable for CPtiZiLanguage", @"\epoc32\release\ARMV5\urel\Zi8English.dll" ),
            new TSymLookupEntry( 0x7a4bd624, 00001, "vtable for CDeflateFilter", @"\epoc32\release\ARMV5\urel\DeflateFilter.dll" ),
            new TSymLookupEntry( 0x7a6d8790, 00007, "vtable for PluginInfo", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d87a4, 00001, "vtable for PluginSkin", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d88b4, 00001, "vtable for WebSurface", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d896c, 00001, "vtable for HttpDownload", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d8a90, 00001, "vtable for WebFrameView", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d8bc4, 00024, "vtable for CMaskedBitmap", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d8bd8, 00001, "vtable for CookieHandler", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d8c1c, 00001, "vtable for PluginHandler", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d8c30, 00001, "vtable for WebDragClient", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d8cc0, 00001, "vtable for HistoryHandler", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d8db8, 00001, "vtable for WebFrameBridge", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d8e2c, 00001, "vtable for WebCannedImages", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d8e40, 00001, "vtable for WebChromeClient", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d8ef8, 00001, "vtable for WebEditorClient", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d8fc8, 00001, "vtable for WebIconDatabase", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d9034, 00001, "vtable for CWidgetExtension", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d91e8, 00023, "vtable for CAnimationDecoder", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d9208, 00001, "vtable for CWebFepTextEditor", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d93f4, 00001, "vtable for WebDocumentLoader", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d95bc, 00001, "vtable for WebPageZoomHandler", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d95e8, 00001, "vtable for WebScrollbarDrawer", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d96dc, 00001, "vtable for WebContextMenuClient", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d970c, 00001, "vtable for WebFrameLoaderClient", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d98b4, 00001, "vtable for WebPageScrollHandler", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d9920, 00001, "vtable for WebCoreGraphicsContext", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d9934, 00001, "vtable for WebPointerEventHandler", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d9998, 00001, "vtable for HttpRequestHeaderManager", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d99ac, 00001, "vtable for WebPageFullScreenHandler", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d99d0, 00001, "vtable for WebScrollingDeceleratorGH", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d9a1c, 00001, "vtable for CBrCtl", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d9ba4, 00001, "vtable for WebView", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d9cec, 00001, "vtable for WebFrame", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6d9f40, 00001, "vtable for WebCursor", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6da2d4, 00001, "vtable for KJS::DOMWindowTimer", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6da368, 00001, "vtable for KJS::ScriptInterpreter", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6dacb0, 00001, "vtable for WebCore::OOMHandler", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6dbae8, 00001, "vtable for WebCore::AsyncCancel", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6dbb38, 00024, "vtable for WebCore::BitmapImage", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6dbbf4, 00022, "vtable for WebCore::CachedImage", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6dbca0, 00001, "vtable for WebCore::EditingText", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6dbf0c, 00345, "vtable for WebCore::HTMLElement", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6dd0f4, 00001, "vtable for WebCore::ShadowValue", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6dd470, 00237, "vtable for WebCore::CSSStyleRule", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6dd4e0, 00019, "vtable for WebCore::CSSValueList", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6dd7d0, 00001, "vtable for WebCore::DocumentType", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6dd954, 00001, "vtable for WebCore::HTMLDocument", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6df7cc, 00034, "vtable for WebCore::CSSImageValue", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6df86c, 00001, "vtable for WebCore::CSSImportRule", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6df904, 00006, "vtable for WebCore::CSSStyleSheet", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6dfdac, 00023, "vtable for WebCore::HTMLBRElement", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6e14a8, 00001, "vtable for WebCore::SymbianCursor", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6e14fc, 00001, "vtable for WebCore::TypingCommand", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6e1698, 00328, "vtable for WebCore::HTMLDivElement", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6e3ea0, 00001, "vtable for WebCore::XMLHttpRequest", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6e3f24, 00127, "vtable for WebCore::CSSInitialValue", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6e43a4, 00004, "vtable for WebCore::FontFamilyValue", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6e48b4, 00001, "vtable for WebCore::HTMLBodyElement", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6e4d44, 00022, "vtable for WebCore::HTMLFormElement", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6e4f8c, 00001, "vtable for WebCore::HTMLHeadElement", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6e51d4, 00001, "vtable for WebCore::HTMLHtmlElement", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6e5900, 00001, "vtable for WebCore::HTMLMetaElement", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6e5dcc, 00003, "vtable for WebCore::JSEventListener", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6e62f8, 01206, "vtable for WebCore::MappedAttribute", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6e6d0c, 00002, "vtable for WebCore::TextCodecLatin1", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6e719c, 00001, "vtable for WebCore::HTMLEmbedElement", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6e7634, 00023, "vtable for WebCore::HTMLImageElement", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6e787c, 00002, "vtable for WebCore::HTMLInputElement", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6e7af0, 00002, "vtable for WebCore::HTMLLabelElement", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6e8410, 00001, "vtable for WebCore::HTMLStyleElement", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6e88cc, 00001, "vtable for WebCore::HTMLTitleElement", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6e9d10, 00001, "vtable for WebCore::AppendNodeCommand", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6e9db8, 00007, "vtable for WebCore::CSSInheritedValue", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6e9e30, 00748, "vtable for WebCore::CSSPrimitiveValue", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6e9ee0, 00001, "vtable for WebCore::DOMImplementation", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6e9ef0, 00034, "vtable for WebCore::HTMLAnchorElement", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6ea38c, 00022, "vtable for WebCore::HTMLButtonElement", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6eb1b8, 00007, "vtable for WebCore::HTMLOptionElement", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6eb674, 00005, "vtable for WebCore::HTMLScriptElement", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6eb8e4, 00002, "vtable for WebCore::HTMLSelectElement", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6ebb8c, 00014, "vtable for WebCore::InsertTextCommand", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6ec5d0, 00001, "vtable for WebCore::PictographSymbian", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6ec5f4, 00002, "vtable for WebCore::PlatformScrollbar", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6ed91c, 00001, "vtable for WebCore::IconDatabaseClient", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6ee590, 00817, "vtable for WebCore::NamedMappedAttrMap", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6eed14, 00001, "vtable for WebCore::WebInspectorClient", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6eeefc, 00001, "vtable for WebCore::CachedCSSStyleSheet", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6efd24, 00021, "vtable for WebCore::HTMLTextAreaElement", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6f0840, 00060, "vtable for WebCore::JSLazyEventListener", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6f1f7c, 00001, "vtable for WebCore::HTMLOptionsCollection", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6f2aa4, 00001, "vtable for WebCore::CResourceHandleManager", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6f2ab8, 00014, "vtable for WebCore::CSSQuirkPrimitiveValue", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6f2b34, 00013, "vtable for WebCore::DeleteSelectionCommand", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6f3790, 00001, "vtable for WebCore::StaticObjectsContainer", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6f48a4, 00001, "vtable for WebCore::CharBreakIteratorSymbian", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6f510c, 00013, "vtable for WebCore::DeleteFromTextNodeCommand", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6f5380, 00022, "vtable for WebCore::InsertIntoTextNodeCommand", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6f5cfc, 00287, "vtable for WebCore::CSSMutableStyleDeclaration", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6f8864, 00006, "vtable for WebCore::CSSMappedAttributeDeclaration", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6f8900, 00002, "vtable for WebCore::HTMLTextFieldInnerTextElement", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6fcdc8, 00003, "vtable for WebCore::Pair", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6fcde8, 00373, "vtable for WebCore::Text", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6fd01c, 00001, "vtable for WebCore::Frame", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6fd414, 00001, "vtable for WebCore::Widget", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6fe15c, 00001, "vtable for WebCore::DOMWindow", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6fe1e4, 00001, "vtable for WebCore::FrameView", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x7a6fe660, 00002, "vtable for WebCore::MediaList", @"\epoc32\release\ARMV5\urel\BrowserEngine.dll" ),
            new TSymLookupEntry( 0x802d3ba0, 00002, "vtable for CTrapCleanup", @"\epoc32\release\ARMV5\urel\_rapido_euser.dll" ),
            new TSymLookupEntry( 0x802d3c2c, 00019, "vtable for CArrayFixFlat<int>", @"\epoc32\release\ARMV5\urel\_rapido_euser.dll" ),
            new TSymLookupEntry( 0x802d3d20, 00002, "vtable for CAsyncCallBack", @"\epoc32\release\ARMV5\urel\_rapido_euser.dll" ),
            new TSymLookupEntry( 0x802d3e68, 00008, "vtable for CIdle", @"\epoc32\release\ARMV5\urel\_rapido_euser.dll" ),
            new TSymLookupEntry( 0x802d3f08, 00052, "vtable for CBufSeg", @"\epoc32\release\ARMV5\urel\_rapido_euser.dll" ),
            new TSymLookupEntry( 0x802d3f7c, 00102, "vtable for CBufFlat", @"\epoc32\release\ARMV5\urel\_rapido_euser.dll" ),
            new TSymLookupEntry( 0x802d3fa4, 00002, "vtable for CCleanup", @"\epoc32\release\ARMV5\urel\_rapido_euser.dll" ),
            new TSymLookupEntry( 0x802d4004, 00024, "vtable for CPeriodic", @"\epoc32\release\ARMV5\urel\_rapido_euser.dll" ),
            new TSymLookupEntry( 0x803387e0, 00057, "vtable for CFbsBitmap", @"\epoc32\release\ARMV5\urel\fbscli.dll" ),
            new TSymLookupEntry( 0x803387f4, 00001, "vtable for CFbsRalCache", @"\epoc32\release\ARMV5\urel\fbscli.dll" ),
            new TSymLookupEntry( 0x80338830, 00001, "vtable for CFbsSessionHelper", @"\epoc32\release\ARMV5\urel\fbscli.dll" ),
            new TSymLookupEntry( 0x80338850, 00003, "vtable for CFbsTypefaceStore", @"\epoc32\release\ARMV5\urel\fbscli.dll" ),
            new TSymLookupEntry( 0x803388f0, 00013, "vtable for CFbsFont", @"\epoc32\release\ARMV5\urel\fbscli.dll" ),
            new TSymLookupEntry( 0x8034a75c, 00002, "vtable for CFbsBitGcBitmap", @"\epoc32\release\ARMV5\urel\bitgdi.dll" ),
            new TSymLookupEntry( 0x8034a770, 00002, "vtable for CFbsBitmapDevice", @"\epoc32\release\ARMV5\urel\bitgdi.dll" ),
            new TSymLookupEntry( 0x8034a914, 00002, "vtable for CFbsBitGcExtraData", @"\epoc32\release\ARMV5\urel\bitgdi.dll" ),
            new TSymLookupEntry( 0x8034a964, 00002, "vtable for CFbsBitGc", @"\epoc32\release\ARMV5\urel\bitgdi.dll" ),
            new TSymLookupEntry( 0x8034cbcc, 00030, "vtable for CEComEntry", @"\epoc32\release\ARMV5\urel\ECOM.dll" ),
            new TSymLookupEntry( 0x8034cbe0, 00001, "vtable for CGlobalData", @"\epoc32\release\ARMV5\urel\ECOM.dll" ),
            new TSymLookupEntry( 0x8034cbf4, 00001, "vtable for CLoadManager", @"\epoc32\release\ARMV5\urel\ECOM.dll" ),
            new TSymLookupEntry( 0x8034cc08, 00030, "vtable for CUnloadPolicy", @"\epoc32\release\ARMV5\urel\ECOM.dll" ),
            new TSymLookupEntry( 0x8034cc1c, 00008, "vtable for CImplementationInformation", @"\epoc32\release\ARMV5\urel\ECOM.dll" ),
            new TSymLookupEntry( 0x803580c8, 00001, "vtable for CCharsetCnvCache", @"\epoc32\release\ARMV5\urel\CHARCONV.DLL" ),
            new TSymLookupEntry( 0x803580dc, 00001, "vtable for CCnvCharacterSetConverter", @"\epoc32\release\ARMV5\urel\CHARCONV.DLL" ),
            new TSymLookupEntry( 0x80358104, 00001, "vtable for CDeepDestructingArrayOfCharactersSets", @"\epoc32\release\ARMV5\urel\CHARCONV.DLL" ),
            new TSymLookupEntry( 0x80378824, 00003, "vtable for CFontCache", @"\epoc32\release\ARMV5\urel\gdi.dll" ),
            new TSymLookupEntry( 0x803788b4, 00003, "vtable for CArrayFixFlat<CTypefaceStore::TFontAccess>", @"\epoc32\release\ARMV5\urel\gdi.dll" ),
            new TSymLookupEntry( 0x80386168, 00050, "vtable for CArrayFixSeg<RStringTokenEither>", @"\epoc32\release\ARMV5\urel\bafl.dll" ),
            new TSymLookupEntry( 0x80386334, 00032, "vtable for CStringPoolNode", @"\epoc32\release\ARMV5\urel\bafl.dll" ),
            new TSymLookupEntry( 0x80386374, 00006, "vtable for CDesC16ArrayFlat", @"\epoc32\release\ARMV5\urel\bafl.dll" ),
            new TSymLookupEntry( 0x803864c4, 00003, "vtable for CStringPoolImplementation", @"\epoc32\release\ARMV5\urel\bafl.dll" ),
            new TSymLookupEntry( 0x80388940, 00018, "vtable for CClientRepository", @"\epoc32\release\ARMV5\urel\centralrepository.dll" ),
            new TSymLookupEntry( 0x803b1f8c, 00009, "vtable for CImageDecoderStraightRelay", @"\epoc32\release\ARMV5\urel\ImageConversion.dll" ),
            new TSymLookupEntry( 0x80435690, 00002, "vtable for CMD5", @"\epoc32\release\ARMV5\urel\hash.dll" ),
            new TSymLookupEntry( 0x80489aa0, 00003, "vtable for CPtrHolder", @"\epoc32\release\ARMV5\urel\etel.dll" ),
            new TSymLookupEntry( 0x80496698, 00003, "vtable for CMobilePhonePtrHolder", @"\epoc32\release\ARMV5\urel\etelmm.dll" ),
            new TSymLookupEntry( 0x8053ee6c, 00002, "vtable for CLocalSystemInterface", @"\epoc32\release\ARMV5\urel\estlib.dll" ),
            new TSymLookupEntry( 0x8053f098, 00002, "vtable for CTtyDesc", @"\epoc32\release\ARMV5\urel\estlib.dll" ),
            new TSymLookupEntry( 0x8061022c, 00001, "vtable for CWsScreenDevice", @"\epoc32\release\ARMV5\urel\ws32_2.dll" ),
            new TSymLookupEntry( 0x80610324, 00001, "vtable for RAnimDll", @"\epoc32\release\ARMV5\urel\ws32_2.dll" ),
            new TSymLookupEntry( 0x80610338, 00001, "vtable for CWindowGc", @"\epoc32\release\ARMV5\urel\ws32_2.dll" ),
            new TSymLookupEntry( 0x80694d88, 00001, "vtable for CVwsSessionWrapper", @"\epoc32\release\ARMV5\urel\viewcli.dll" ),
            new TSymLookupEntry( 0x80694d9c, 00001, "vtable for CVwsSessionEventHandler", @"\epoc32\release\ARMV5\urel\viewcli.dll" ),
            new TSymLookupEntry( 0x806a2288, 00001, "vtable for CCoeControl", @"\epoc32\release\ARMV5\urel\cone.dll" ),
            new TSymLookupEntry( 0x806a2358, 00001, "vtable for CCoeEnvExtra", @"\epoc32\release\ARMV5\urel\cone.dll" ),
            new TSymLookupEntry( 0x806a236c, 00001, "vtable for CCoeRedrawer", @"\epoc32\release\ARMV5\urel\cone.dll" ),
            new TSymLookupEntry( 0x806a238c, 00001, "vtable for CArrayFixFlat<RResourceFile>", @"\epoc32\release\ARMV5\urel\cone.dll" ),
            new TSymLookupEntry( 0x806a23a0, 00011, "vtable for CArrayFixFlat<SColorOverride>", @"\epoc32\release\ARMV5\urel\cone.dll" ),
            new TSymLookupEntry( 0x806a2460, 00001, "vtable for CCoeScheduler", @"\epoc32\release\ARMV5\urel\cone.dll" ),
            new TSymLookupEntry( 0x806a2490, 00001, "vtable for CCoeFepTracker", @"\epoc32\release\ARMV5\urel\cone.dll" ),
            new TSymLookupEntry( 0x806a2518, 00001, "vtable for CCoeDataStorage", @"\epoc32\release\ARMV5\urel\cone.dll" ),
            new TSymLookupEntry( 0x806a2548, 00001, "vtable for CCoeViewManager", @"\epoc32\release\ARMV5\urel\cone.dll" ),
            new TSymLookupEntry( 0x806a2598, 00001, "vtable for CCoeControlStack", @"\epoc32\release\ARMV5\urel\cone.dll" ),
            new TSymLookupEntry( 0x806a25ac, 00001, "vtable for CCoeFontProvider", @"\epoc32\release\ARMV5\urel\cone.dll" ),
            new TSymLookupEntry( 0x806a2720, 00001, "vtable for CCoePlainTextDrawer", @"\epoc32\release\ARMV5\urel\cone.dll" ),
            new TSymLookupEntry( 0x806a27b0, 00001, "vtable for CCoeTextDrawerBaseExt", @"\epoc32\release\ARMV5\urel\cone.dll" ),
            new TSymLookupEntry( 0x806a27f8, 00001, "vtable for CCoeBrushAndPenContext", @"\epoc32\release\ARMV5\urel\cone.dll" ),
            new TSymLookupEntry( 0x806a28b0, 00001, "vtable for CCoeControlStaticSettings", @"\epoc32\release\ARMV5\urel\cone.dll" ),
            new TSymLookupEntry( 0x806a29a0, 00001, "vtable for CCoeView", @"\epoc32\release\ARMV5\urel\cone.dll" ),
            new TSymLookupEntry( 0x806a2a28, 00001, "vtable for CCoeEnvExtra::CHighPriorityActive", @"\epoc32\release\ARMV5\urel\cone.dll" ),
            new TSymLookupEntry( 0x806a2a48, 00001, "vtable for CCoeDataStorage::COwner", @"\epoc32\release\ARMV5\urel\cone.dll" ),
            new TSymLookupEntry( 0x806a2a64, 00001, "vtable for CCoeAppUi::CExtra", @"\epoc32\release\ARMV5\urel\cone.dll" ),
            new TSymLookupEntry( 0x80745d60, 00001, "vtable for CPolicyHandler", @"\epoc32\release\ARMV5\urel\gfxtrans.dll" ),
            new TSymLookupEntry( 0x80745d74, 00001, "vtable for CGfxTransEffect", @"\epoc32\release\ARMV5\urel\gfxtrans.dll" ),
            new TSymLookupEntry( 0x80745df0, 00001, "vtable for CRegisteredControl", @"\epoc32\release\ARMV5\urel\gfxtrans.dll" ),
            new TSymLookupEntry( 0x80747ed0, 00001, "vtable for CPsObserver", @"\epoc32\release\ARMV5\urel\gfxtransadapter.dll" ),
            new TSymLookupEntry( 0x80747f40, 00001, "vtable for CGfxTransAdapterTfx", @"\epoc32\release\ARMV5\urel\gfxtransadapter.dll" ),
            new TSymLookupEntry( 0x807622e8, 00001, "vtable for CGraphicsAcceleratorEColor64K", @"\epoc32\release\ARMV5\urel\accel2d.dll" ),
            new TSymLookupEntry( 0x80762350, 00001, "vtable for CGraphicsAcceleratorEColor16MU", @"\epoc32\release\ARMV5\urel\accel2d.dll" ),
            new TSymLookupEntry( 0x807623bc, 00002, "vtable for CGenericSoftwareGraphicsAccelerator", @"\epoc32\release\ARMV5\urel\accel2d.dll" ),
            new TSymLookupEntry( 0x807b7b3c, 00001, "vtable for CDrawSixteenBppBitmap", @"\epoc32\release\ARMV5\urel\scdv.9401.dll" ),
            new TSymLookupEntry( 0x807b8754, 00001, "vtable for CDrawUTwentyFourBppBitmap", @"\epoc32\release\ARMV5\urel\scdv.9401.dll" ),
            new TSymLookupEntry( 0x80aa13c4, 00001, "vtable for CCommsDatabase", @"\epoc32\release\ARMV5\urel\commdb.dll" ),
            new TSymLookupEntry( 0x80aa144c, 00001, "vtable for CCommsDatabaseImpl", @"\epoc32\release\ARMV5\urel\commdb.dll" ),
            new TSymLookupEntry( 0x80aba704, 00001, "vtable for CommsDatInternal::CCDNotifier", @"\epoc32\release\ARMV5\urel\commsdat.dll" ),
            new TSymLookupEntry( 0x80aba838, 00001, "vtable for CommsDat::CMDBSession", @"\epoc32\release\ARMV5\urel\commsdat.dll" ),
            new TSymLookupEntry( 0x80abaf4c, 00001, "vtable for CommsDat::CMDBSessionImpl", @"\epoc32\release\ARMV5\urel\commsdat.dll" ),
            new TSymLookupEntry( 0x80b9f114, 00001, "vtable for Xml::CCharSetConverter", @"\epoc32\release\ARMV5\urel\xmlframework.dll" ),
            new TSymLookupEntry( 0x80b9f13c, 00001, "vtable for Xml::CParser", @"\epoc32\release\ARMV5\urel\xmlframework.dll" ),
            new TSymLookupEntry( 0x80ba8e90, 00001, "vtable for CXmlParserPlugin", @"\epoc32\release\ARMV5\urel\xmlparserplugin.dll" ),
            new TSymLookupEntry( 0x80ba8ee4, 00001, "vtable for CExpat", @"\epoc32\release\ARMV5\urel\xmlparserplugin.dll" ),
            new TSymLookupEntry( 0x80c11bc4, 00005, "vtable for CCenRepNotifyHandler", @"\epoc32\release\ARMV5\urel\CENREPNOTIFHANDLER.DLL" ),
            new TSymLookupEntry( 0x80c66480, 00001, "vtable for CFeatMgrTlsData", @"\epoc32\release\ARMV5\urel\FeatMgr.ivalo.DLL" ),
            new TSymLookupEntry( 0x80d40754, 00001, "HTTP::Table", @"\epoc32\release\ARMV5\urel\Http.dll" ),
            new TSymLookupEntry( 0x80d40b88, 00001, "vtable for CHTTPManager", @"\epoc32\release\ARMV5\urel\Http.dll" ),
            new TSymLookupEntry( 0x80d40b9c, 00001, "vtable for CHTTPSession", @"\epoc32\release\ARMV5\urel\Http.dll" ),
            new TSymLookupEntry( 0x80d40d1c, 00001, "vtable for CHeaderFieldPart", @"\epoc32\release\ARMV5\urel\Http.dll" ),
            new TSymLookupEntry( 0x80d40dd4, 00009, "vtable for CHeaderFieldParam", @"\epoc32\release\ARMV5\urel\Http.dll" ),
            new TSymLookupEntry( 0x80d40ea8, 00002, "vtable for CHeaders", @"\epoc32\release\ARMV5\urel\Http.dll" ),
            new TSymLookupEntry( 0x80d453e8, 00003, "vtable for CSocketController", @"\epoc32\release\ARMV5\urel\httptransporthandler.dll" ),
            new TSymLookupEntry( 0x80d45400, 00001, "vtable for CTcpTransportLayer", @"\epoc32\release\ARMV5\urel\httptransporthandler.dll" ),
            new TSymLookupEntry( 0x80d485f4, 00001, "vtable for CRedirectFilter", @"\epoc32\release\ARMV5\urel\tfcorefilters.dll" ),
            new TSymLookupEntry( 0x80d48640, 00001, "vtable for CValidationFilter", @"\epoc32\release\ARMV5\urel\tfcorefilters.dll" ),
            new TSymLookupEntry( 0x80d4aed8, 00001, "vtable for CHttpClientHeaderCodec", @"\epoc32\release\ARMV5\urel\HttpClientCodec.dll" ),
            new TSymLookupEntry( 0x80d4af04, 00001, "vtable for CHttpClientHeaderReader", @"\epoc32\release\ARMV5\urel\HttpClientCodec.dll" ),
            new TSymLookupEntry( 0x80d4af24, 00001, "vtable for CHttpClientHeaderWriter", @"\epoc32\release\ARMV5\urel\HttpClientCodec.dll" ),
            new TSymLookupEntry( 0x80d4af44, 00001, "vtable for CHttpDefaultHeaderCodec", @"\epoc32\release\ARMV5\urel\HttpClientCodec.dll" ),
            new TSymLookupEntry( 0x80d4af70, 00001, "vtable for CHttpGeneralHeaderCodec", @"\epoc32\release\ARMV5\urel\HttpClientCodec.dll" ),
            new TSymLookupEntry( 0x80d4af9c, 00001, "vtable for CHttpDefaultHeaderReader", @"\epoc32\release\ARMV5\urel\HttpClientCodec.dll" ),
            new TSymLookupEntry( 0x80d4afbc, 00001, "vtable for CHttpDefaultHeaderWriter", @"\epoc32\release\ARMV5\urel\HttpClientCodec.dll" ),
            new TSymLookupEntry( 0x80d4afdc, 00001, "vtable for CHttpGeneralHeaderReader", @"\epoc32\release\ARMV5\urel\HttpClientCodec.dll" ),
            new TSymLookupEntry( 0x80d4affc, 00001, "vtable for CHttpGeneralHeaderWriter", @"\epoc32\release\ARMV5\urel\HttpClientCodec.dll" ),
            new TSymLookupEntry( 0x80d51370, 00001, "vtable for CHttpClientFilter", @"\epoc32\release\ARMV5\urel\httpclient.dll" ),
            new TSymLookupEntry( 0x80d513bc, 00001, "vtable for CHttpClientHandler", @"\epoc32\release\ARMV5\urel\httpclient.dll" ),
            new TSymLookupEntry( 0x80d514c4, 00001, "vtable for CHttpConnectFilter", @"\epoc32\release\ARMV5\urel\httpclient.dll" ),
            new TSymLookupEntry( 0x80d51530, 00007, "vtable for CHttpConnectionInfo", @"\epoc32\release\ARMV5\urel\httpclient.dll" ),
            new TSymLookupEntry( 0x80d518d0, 00007, "vtable for CHttpConnectionManager", @"\epoc32\release\ARMV5\urel\httpclient.dll" ),
            new TSymLookupEntry( 0x80d6d60c, 00001, "vtable for CArrayFixFlat<TApaAppHolderInfo>", @"\epoc32\release\ARMV5\urel\apparc.dll" ),
            new TSymLookupEntry( 0x80d6d620, 00001, "vtable for CArrayFixFlat<CApaDocument*>", @"\epoc32\release\ARMV5\urel\apparc.dll" ),
            new TSymLookupEntry( 0x80d6d7fc, 00001, "vtable for CApaExe", @"\epoc32\release\ARMV5\urel\apparc.dll" ),
            new TSymLookupEntry( 0x80d7edf0, 00003, "vtable for RApaLsSession", @"\epoc32\release\ARMV5\urel\apgrfx.dll" ),
            new TSymLookupEntry( 0x80d7ef64, 00001, "vtable for CApaWindowGroupName", @"\epoc32\release\ARMV5\urel\apgrfx.dll" ),
            new TSymLookupEntry( 0x80d8d814, 00001, "vtable for COnStateTracker", @"\epoc32\release\ARMV5\urel\fepbase.dll" ),
            new TSymLookupEntry( 0x80d8d868, 00001, "vtable for CFepSettingsTracker", @"\epoc32\release\ARMV5\urel\fepbase.dll" ),
            new TSymLookupEntry( 0x80d8da54, 00001, "vtable for CCoeFep::CCoeFepExtra", @"\epoc32\release\ARMV5\urel\fepbase.dll" ),
            new TSymLookupEntry( 0x80d8da68, 00001, "vtable for CCoeFep::CLowPriorityActive", @"\epoc32\release\ARMV5\urel\fepbase.dll" ),
            new TSymLookupEntry( 0x80d8daa4, 00001, "vtable for CCoeFep::CHighPriorityActive::CFlagClearer", @"\epoc32\release\ARMV5\urel\fepbase.dll" ),
            new TSymLookupEntry( 0x80d8dac4, 00001, "vtable for CCoeFep::CHighPriorityActive", @"\epoc32\release\ARMV5\urel\fepbase.dll" ),
            new TSymLookupEntry( 0x80e4e44c, 00001, "vtable for RMessageWindow", @"\epoc32\release\ARMV5\urel\clock.dll" ),
            new TSymLookupEntry( 0x80e624c8, 00001, "vtable for CColorList", @"\epoc32\release\ARMV5\urel\Egul.dll" ),
            new TSymLookupEntry( 0xa563da8c, 00001, "", "" ),
            new TSymLookupEntry( 0xb947fb82, 00001, "", "" ),
            new TSymLookupEntry( 0xcc4ded9e, 00001, "", "" ),
            new TSymLookupEntry( 0xfafdfcf9, 00001, "", "" ),
            new TSymLookupEntry( 0xff95734d, 00001, "", "" ),
            new TSymLookupEntry( 0xfff0fff1, 00001, "", "" ),
            new TSymLookupEntry( 0xfffffd61, 00012, "", "" ),
            new TSymLookupEntry( 0xfffffd93, 00005, "", "" ),
            new TSymLookupEntry( 0xfffffddc, 00005, "", "" ),
            new TSymLookupEntry( 0xfffffddd, 00005, "", "" ),
            new TSymLookupEntry( 0xfffffddf, 00005, "", "" ),
            new TSymLookupEntry( 0xfffffde1, 00005, "", "" ),
            new TSymLookupEntry( 0xfffffde4, 00005, "", "" ),
            new TSymLookupEntry( 0xfffffde5, 00005, "", "" ),
            new TSymLookupEntry( 0xfffffe10, 00010, "", "" ),
            new TSymLookupEntry( 0xfffffe38, 00005, "", "" ),
            new TSymLookupEntry( 0xffffff10, 00003, "", "" ),
            new TSymLookupEntry( 0xffffffde, 00076, "", "" ),
            new TSymLookupEntry( 0xffffffe7, 00002, "", "" ),
            new TSymLookupEntry( 0xfffffff0, 00039, "", "" ),
            new TSymLookupEntry( 0xfffffffd, 00001, "", "" ),
            new TSymLookupEntry( 0xffffffff, 00048, "", "" ),
            };
        #endregion

        #region Data members
        public readonly uint iAddress;
        public readonly int iCount;
        public readonly string iSymbol;
        public readonly string iCollection;
        #endregion
    }

}
