/*
* Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:   
* THIS FILE IS AUTOGENERATED. Do not modify the contents of this file directly
* as changes will be lost
* Tue Nov 11 18:52:30 2003
* System Includes
*
*/




#include <assert.h>


/****************************************************************************************
 * 
 * Local Includes
 * 
 ***************************************************************************************/
#include "CSvcMncontroller.h"
#include "CSMncontroller.h"
#include "CComponentManager.h"


/****************************************************************************************
 * 
 * Static Variables
 * 
 ***************************************************************************************/
static CComponentManager<CSMncontroller> *iComponentManager;


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: ss_startuprpcservice
 * 
 ***************************************************************************************/
int *ss_startuprpcservice_5( void *aArgs, CLIENT *aDutout )
{
	static int rv;

	// if the service is already started then return an error
	if( iComponentManager != NULL ) {
		rv = ERR_SERVICE_ALREADY_STARTED;
		return &rv;
	}

	// create the component manager
	iComponentManager = new CComponentManager<CSMncontroller>( INFO_MAXIMUM_OBJECTS );
	if( iComponentManager == NULL ) {
		rv = ERR_FAILED_TO_CREATE_COMPONENT_MANAGER;
		return &rv;
	}

	// call the custom service manager
	rv = CSvcMncontroller::StartRPCService( iComponentManager, aArgs );
	if( rv != ERR_NONE ) {
		delete iComponentManager;
		iComponentManager = NULL;
		return &rv;
	}

	// success
	rv = ERR_NONE;
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: sc_shutdownrpcservice
 * 
 ***************************************************************************************/
int *sc_shutdownrpcservice_5( int *aArgs, CLIENT *aDutout )
{
	static int rv;
	int instance_count;
	int err;

	// check that the service is started
	if( iComponentManager == NULL ) {
		rv = ERR_SERVICE_NOT_RUNNING;
		return &rv;
	}

	// if there are active sessions and the force flag isn't set then return an error
	instance_count = iComponentManager->GetInstanceCount();
	if( (instance_count > 0) && (*aArgs == 0) ) {
		rv = ERR_ACTIVE_USER_SESSIONS;
		return &rv;
	};

	// if the force flag IS set then reset all active connections
	instance_count = iComponentManager->GetInstanceCount();
	if( instance_count > 0 ) {
		err = iComponentManager->DeleteAllInstances();
		if( err != 0 ) {
			rv = ERR_FAILED_TO_REMOVE_ACTIVE_SESSIONS;
			return &rv;
		}
	}

	// call the custom service manager
	rv = CSvcMncontroller::StopRPCService();
	if( rv != ERR_NONE ) {
		return &rv;
	}

	// delete the component manager
	delete iComponentManager;
	iComponentManager = NULL;

	// success
	rv = ERR_NONE;
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: list_devices
 * 
 ***************************************************************************************/
TComponentList *list_devices_5( void *aArgs, CLIENT *aDutout )
{
	static TComponentList rv;
	int i, valid_count, component_instance_count;

	//free any allocated memory
	if( rv.TComponentList_val != NULL ) {
		free( rv.TComponentList_val );
		rv.TComponentList_val = NULL;
		rv.TComponentList_len = 0;
	}

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcMncontroller::SetError( LIST_DEVICES, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcMncontroller::SetError( LIST_DEVICES, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the number of active component instances
	component_instance_count = iComponentManager->GetInstanceCount();

	// if there are one or more instances then allocate the memory
	if( component_instance_count > 0 ) {
		rv.TComponentList_val = (int*)malloc( sizeof(int) * component_instance_count );
		assert( rv.TComponentList_val != NULL );
		rv.TComponentList_len = component_instance_count;
	}

	// store all the currently active IDs in the list
	for( i = 0, valid_count = 0; i < INFO_MAXIMUM_OBJECTS; i++ ) {
		if( iComponentManager->IsValidKey(i) != 0 ) {
			assert( valid_count < component_instance_count );
			(rv.TComponentList_val)[valid_count++] = i;
		}
	}

	// ok return everything
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: cstr_createagent
 * 
 ***************************************************************************************/
TResult *cstr_createagent_5( void *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int result;
	int internal_err;
	int instance_key;
	CSMncontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcMncontroller::SetError( CSTR_CREATEAGENT, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// create a new component instance
	instance_key = iComponentManager->CreateInstance();
	if( instance_key < 0 ) {
		CSvcMncontroller::SetError( CSTR_CREATEAGENT, (void*)&rv, instance_key );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->cstr_createagent();
	result = CSvcMncontroller::GetError( CSTR_CREATEAGENT, (void*)&rv );

	// if the method fails then we cleanup the instance -- otherwise we set the instance key
	// as the return value
	if( result != ERR_NONE ) {
		internal_err = iComponentManager->DeleteInstance( instance_key );
		assert( internal_err == 0 );
	} else { 
		CSvcMncontroller::SetError( CSTR_CREATEAGENT, (void*)&rv, instance_key );
	}

	// done
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: dstr_removeagent
 * 
 ***************************************************************************************/
int *dstr_removeagent_5( int *aArgs, CLIENT *aDutout )
{
	static int rv;
	int result;
	int internal_err;
	int instance_key;
	int should_delete = 1;
	CSMncontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		rv = ERR_SERVICE_NOT_RUNNING;
		return &rv;
	}

	// get the key for the instance from the args
	instance_key = CSvcMncontroller::GetInstanceKeyFromArgs( DSTR_REMOVEAGENT, (void*)aArgs );
	if( instance_key < 0 ) {
		rv = instance_key;
		return &rv;
	}
	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		rv = ERR_INSTANCE_DOES_NOT_EXIST;
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->dstr_removeagent( *aArgs, &should_delete );

	result = rv;

	// it is illegal for the method to succeed but not delete the instance
	assert( (result != ERR_NONE) || (should_delete == 1) );

	// delete the instance if requested
	if( should_delete != 0 ) {
		internal_err = iComponentManager->DeleteInstance( instance_key );
		assert( internal_err == ERR_NONE );
	}

	// done
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: startmobileagent
 * 
 ***************************************************************************************/
TResult *startmobileagent_5( int *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int instance_key;
	CSMncontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcMncontroller::SetError( STARTMOBILEAGENT, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcMncontroller::SetError( STARTMOBILEAGENT, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcMncontroller::GetInstanceKeyFromArgs( STARTMOBILEAGENT, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcMncontroller::SetError( STARTMOBILEAGENT, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->startmobileagent( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: stopmobileagent
 * 
 ***************************************************************************************/
TResult *stopmobileagent_5( int *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int instance_key;
	CSMncontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcMncontroller::SetError( STOPMOBILEAGENT, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcMncontroller::SetError( STOPMOBILEAGENT, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcMncontroller::GetInstanceKeyFromArgs( STOPMOBILEAGENT, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcMncontroller::SetError( STOPMOBILEAGENT, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->stopmobileagent( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: getmobileagentstatus
 * 
 ***************************************************************************************/
TResult *getmobileagentstatus_5( int *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int instance_key;
	CSMncontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcMncontroller::SetError( GETMOBILEAGENTSTATUS, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcMncontroller::SetError( GETMOBILEAGENTSTATUS, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcMncontroller::GetInstanceKeyFromArgs( GETMOBILEAGENTSTATUS, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcMncontroller::SetError( GETMOBILEAGENTSTATUS, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->getmobileagentstatus( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: setsingleoption
 * 
 ***************************************************************************************/
TResult *setsingleoption_5( TOptionDesc *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int instance_key;
	CSMncontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcMncontroller::SetError( SETSINGLEOPTION, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcMncontroller::SetError( SETSINGLEOPTION, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcMncontroller::GetInstanceKeyFromArgs( SETSINGLEOPTION, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcMncontroller::SetError( SETSINGLEOPTION, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->setsingleoption( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: removesingleoption
 * 
 ***************************************************************************************/
TResult *removesingleoption_5( TOptionDesc *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int instance_key;
	CSMncontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcMncontroller::SetError( REMOVESINGLEOPTION, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcMncontroller::SetError( REMOVESINGLEOPTION, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcMncontroller::GetInstanceKeyFromArgs( REMOVESINGLEOPTION, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcMncontroller::SetError( REMOVESINGLEOPTION, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->removesingleoption( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: addlistoption
 * 
 ***************************************************************************************/
TResult *addlistoption_5( TOptionDesc *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int instance_key;
	CSMncontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcMncontroller::SetError( ADDLISTOPTION, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcMncontroller::SetError( ADDLISTOPTION, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcMncontroller::GetInstanceKeyFromArgs( ADDLISTOPTION, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcMncontroller::SetError( ADDLISTOPTION, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->addlistoption( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: removelistoption
 * 
 ***************************************************************************************/
TResult *removelistoption_5( TOptionDesc *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int instance_key;
	CSMncontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcMncontroller::SetError( REMOVELISTOPTION, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcMncontroller::SetError( REMOVELISTOPTION, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcMncontroller::GetInstanceKeyFromArgs( REMOVELISTOPTION, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcMncontroller::SetError( REMOVELISTOPTION, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->removelistoption( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: sethomeaddress
 * 
 ***************************************************************************************/
TResult *sethomeaddress_5( THomeAddressDesc *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int instance_key;
	CSMncontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcMncontroller::SetError( SETHOMEADDRESS, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcMncontroller::SetError( SETHOMEADDRESS, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcMncontroller::GetInstanceKeyFromArgs( SETHOMEADDRESS, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcMncontroller::SetError( SETHOMEADDRESS, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->sethomeaddress( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: getcareofaddress
 * 
 ***************************************************************************************/
TResult *getcareofaddress_5( int *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int instance_key;
	CSMncontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcMncontroller::SetError( GETCAREOFADDRESS, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcMncontroller::SetError( GETCAREOFADDRESS, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcMncontroller::GetInstanceKeyFromArgs( GETCAREOFADDRESS, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcMncontroller::SetError( GETCAREOFADDRESS, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->getcareofaddress( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: connect
 * 
 ***************************************************************************************/
TResult *connect_5( TTunnelingModeDesc *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int instance_key;
	CSMncontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcMncontroller::SetError( CONNECT, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcMncontroller::SetError( CONNECT, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcMncontroller::GetInstanceKeyFromArgs( CONNECT, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcMncontroller::SetError( CONNECT, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->connect( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: disconnect
 * 
 ***************************************************************************************/
TResult *disconnect_5( int *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int instance_key;
	CSMncontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcMncontroller::SetError( DISCONNECT, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcMncontroller::SetError( DISCONNECT, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcMncontroller::GetInstanceKeyFromArgs( DISCONNECT, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcMncontroller::SetError( DISCONNECT, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->disconnect( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: confirm
 * 
 ***************************************************************************************/
TResult *confirm_5( int *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int instance_key;
	CSMncontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcMncontroller::SetError( CONFIRM, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcMncontroller::SetError( CONFIRM, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcMncontroller::GetInstanceKeyFromArgs( CONFIRM, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcMncontroller::SetError( CONFIRM, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->confirm( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: rescaninterfaces
 * 
 ***************************************************************************************/
TResult *rescaninterfaces_5( int *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int instance_key;
	CSMncontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcMncontroller::SetError( RESCANINTERFACES, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcMncontroller::SetError( RESCANINTERFACES, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcMncontroller::GetInstanceKeyFromArgs( RESCANINTERFACES, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcMncontroller::SetError( RESCANINTERFACES, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->rescaninterfaces( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: setfapolicy
 * 
 ***************************************************************************************/
TResult *setfapolicy_5( TPolicyRequest *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int instance_key;
	CSMncontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcMncontroller::SetError( SETFAPOLICY, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcMncontroller::SetError( SETFAPOLICY, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcMncontroller::GetInstanceKeyFromArgs( SETFAPOLICY, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcMncontroller::SetError( SETFAPOLICY, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->setfapolicy( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: getfapolicy
 * 
 ***************************************************************************************/
TResult *getfapolicy_5( int *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int instance_key;
	CSMncontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcMncontroller::SetError( GETFAPOLICY, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcMncontroller::SetError( GETFAPOLICY, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcMncontroller::GetInstanceKeyFromArgs( GETFAPOLICY, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcMncontroller::SetError( GETFAPOLICY, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->getfapolicy( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: getstatus
 * 
 ***************************************************************************************/
TMobileNodeStatus *getstatus_5( int *aArgs, CLIENT *aDutout )
{
	static TMobileNodeStatus rv;
	int instance_key;
	CSMncontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcMncontroller::SetError( GETSTATUS, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcMncontroller::SetError( GETSTATUS, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcMncontroller::GetInstanceKeyFromArgs( GETSTATUS, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcMncontroller::SetError( GETSTATUS, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->getstatus( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: listforeignagents
 * 
 ***************************************************************************************/
TForeignAgentList *listforeignagents_5( int *aArgs, CLIENT *aDutout )
{
	static TForeignAgentList rv;
	int instance_key;
	CSMncontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcMncontroller::SetError( LISTFOREIGNAGENTS, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcMncontroller::SetError( LISTFOREIGNAGENTS, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcMncontroller::GetInstanceKeyFromArgs( LISTFOREIGNAGENTS, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcMncontroller::SetError( LISTFOREIGNAGENTS, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->listforeignagents( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: getforeignagentinfo
 * 
 ***************************************************************************************/
TForeignAgentInfo *getforeignagentinfo_5( TForeignAgentInfoRequest *aArgs, CLIENT *aDutout )
{
	static TForeignAgentInfo rv;
	int instance_key;
	CSMncontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcMncontroller::SetError( GETFOREIGNAGENTINFO, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcMncontroller::SetError( GETFOREIGNAGENTINFO, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcMncontroller::GetInstanceKeyFromArgs( GETFOREIGNAGENTINFO, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcMncontroller::SetError( GETFOREIGNAGENTINFO, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->getforeignagentinfo( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: settimeout
 * 
 ***************************************************************************************/
void *settimeout_5( TTimeoutRequest *aArgs, CLIENT *aDutout )
{
	static int rv;
	int instance_key;
	CSMncontroller *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		rv = ERR_SERVICE_NOT_RUNNING;
		return &rv;
	}

	// set the return value to generic error
	rv = ERR_FAILED_TO_RETRIEVE_KEY;

	// get the key for the instance from the args
	instance_key = CSvcMncontroller::GetInstanceKeyFromArgs( SETTIMEOUT, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		rv = ERR_INSTANCE_DOES_NOT_EXIST;
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = ERR_NONE;
	session->settimeout( *aArgs );
	return &rv;
}
