/*
* Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:   
* THIS FILE IS AUTOGENERATED. Do not modify the contents of this file directly
* as changes will be lost
* Mon Oct 06 10:55:15 2003
* System Includes
*
*/




#include <assert.h>


/****************************************************************************************
 * 
 * Local Includes
 * 
 ***************************************************************************************/
#include "CSvcMobster.h"
#include "CSMobster.h"
#include "CComponentManager.h"


/****************************************************************************************
 * 
 * Static Variables
 * 
 ***************************************************************************************/
static CComponentManager<CSMobster> *iComponentManager;


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: ss_startuprpcservice
 * 
 ***************************************************************************************/
int *ss_startuprpcservice_1( struct TChannelAddress *aArgs, CLIENT *aDutout )
{
	static int rv;

	// if the service is already started then return an error
	if( iComponentManager != NULL ) {
		rv = ERR_SERVICE_ALREADY_STARTED;
		return &rv;
	}

	// create the component manager
	iComponentManager = new CComponentManager<CSMobster>( INFO_MAXIMUM_OBJECTS );
	if( iComponentManager == NULL ) {
		rv = ERR_FAILED_TO_CREATE_COMPONENT_MANAGER;
		return &rv;
	}

	// call the custom service manager
	rv = CSvcMobster::StartRPCService( iComponentManager, aArgs );
	if( rv != ERR_NONE ) {
		delete iComponentManager;
		iComponentManager = NULL;
		return &rv;
	}

	// success
	rv = ERR_NONE;
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: sc_shutdownrpcservice
 * 
 ***************************************************************************************/
int *sc_shutdownrpcservice_1( int *aArgs, CLIENT *aDutout )
{
	static int rv;
	int instance_count;
	int err;

	// check that the service is started
	if( iComponentManager == NULL ) {
		rv = ERR_SERVICE_NOT_RUNNING;
		return &rv;
	}

	// if there are active sessions and the force flag isn't set then return an error
	instance_count = iComponentManager->GetInstanceCount();
	if( (instance_count > 0) && (*aArgs == 0) ) {
		rv = ERR_ACTIVE_USER_SESSIONS;
		return &rv;
	};

	// if the force flag IS set then reset all active connections
	instance_count = iComponentManager->GetInstanceCount();
	if( instance_count > 0 ) {
		err = iComponentManager->DeleteAllInstances();
		if( err != 0 ) {
			rv = ERR_FAILED_TO_REMOVE_ACTIVE_SESSIONS;
			return &rv;
		}
	}

	// call the custom service manager
	rv = CSvcMobster::StopRPCService();
	if( rv != ERR_NONE ) {
		return &rv;
	}

	// delete the component manager
	delete iComponentManager;
	iComponentManager = NULL;

	// success
	rv = ERR_NONE;
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: list_devices
 * 
 ***************************************************************************************/
TComponentList *list_devices_1( void *aArgs, CLIENT *aDutout )
{
	static TComponentList rv;
	int i, valid_count, component_instance_count;

	//free any allocated memory
	if( rv.TComponentList_val != NULL ) {
		free( rv.TComponentList_val );
		rv.TComponentList_val = NULL;
		rv.TComponentList_len = 0;
	}

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcMobster::SetError( LIST_DEVICES, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcMobster::SetError( LIST_DEVICES, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the number of active component instances
	component_instance_count = iComponentManager->GetInstanceCount();

	// if there are one or more instances then allocate the memory
	if( component_instance_count > 0 ) {
		rv.TComponentList_val = (int*)malloc( sizeof(int) * component_instance_count );
		assert( rv.TComponentList_val != NULL );
		rv.TComponentList_len = component_instance_count;
	}

	// store all the currently active IDs in the list
	for( i = 0, valid_count = 0; i < INFO_MAXIMUM_OBJECTS; i++ ) {
		if( iComponentManager->IsValidKey(i) != 0 ) {
			assert( valid_count < component_instance_count );
			(rv.TComponentList_val)[valid_count++] = i;
		}
	}

	// ok return everything
	CSvcMobster::SetError( LIST_DEVICES, (void*)&rv, ERR_NONE );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: cstr_startdevice
 * 
 ***************************************************************************************/
int *cstr_startdevice_1( TDeviceDesc *aArgs, CLIENT *aDutout )
{
	static int rv;
	int result;
	int internal_err;
	int instance_key;
	CSMobster *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		rv = ERR_SERVICE_NOT_RUNNING;
		return &rv;
	}

	// create a new component instance
	instance_key = iComponentManager->CreateInstance();
	if( instance_key < 0 ) {
		rv = instance_key;
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->cstr_startdevice( *aArgs );
	result = rv;

	// if the method fails then we cleanup the instance -- otherwise we set the instance key
	// as the return value
	if( result != ERR_NONE ) {
		internal_err = iComponentManager->DeleteInstance( instance_key );
		assert( internal_err == 0 );
	} else { 
		rv = instance_key;
	}

	// done
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: dstr_removedevice
 * 
 ***************************************************************************************/
int *dstr_removedevice_1( int *aArgs, CLIENT *aDutout )
{
	static int rv;
	int internal_err;
	int instance_key;
	int should_delete = 1;
	CSMobster *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		rv = ERR_SERVICE_NOT_RUNNING;
		return &rv;
	}

	// get the key for the instance from the args
	instance_key = CSvcMobster::GetInstanceKeyFromArgs( DSTR_REMOVEDEVICE, (void*)aArgs );
	if( instance_key < 0 ) {
		rv = instance_key;
		return &rv;
	}
	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		rv = ERR_INSTANCE_DOES_NOT_EXIST;
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->dstr_removedevice( *aArgs, &should_delete );

	// it is illegal for the method to succeed but not delete the instance
	assert( (rv != ERR_NONE) || (should_delete == 1) );

	// delete the instance if requested
	if( should_delete != 0 ) {
		internal_err = iComponentManager->DeleteInstance( instance_key );
		assert( internal_err == ERR_NONE );
	}

	// done
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: getdeviceinfo
 * 
 ***************************************************************************************/
TDeviceDesc *getdeviceinfo_1( int *aArgs, CLIENT *aDutout )
{
	static TDeviceDesc rv;
	int instance_key;
	CSMobster *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcMobster::SetError( GETDEVICEINFO, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcMobster::SetError( GETDEVICEINFO, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcMobster::GetInstanceKeyFromArgs( GETDEVICEINFO, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcMobster::SetError( GETDEVICEINFO, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->getdeviceinfo( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: getdevicelog
 * 
 ***************************************************************************************/
TVarData *getdevicelog_1( int *aArgs, CLIENT *aDutout )
{
	static TVarData rv;
	int instance_key;
	CSMobster *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcMobster::SetError( GETDEVICELOG, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcMobster::SetError( GETDEVICELOG, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcMobster::GetInstanceKeyFromArgs( GETDEVICELOG, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcMobster::SetError( GETDEVICELOG, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->getdevicelog( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: stopdevice
 * 
 ***************************************************************************************/
int *stopdevice_1( int *aArgs, CLIENT *aDutout )
{
	static int rv;
	int instance_key;
	CSMobster *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		rv = ERR_SERVICE_NOT_RUNNING;
		return &rv;
	}

	// set the return value to generic error
	rv = ERR_FAILED_TO_RETRIEVE_KEY;

	// get the key for the instance from the args
	instance_key = CSvcMobster::GetInstanceKeyFromArgs( STOPDEVICE, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		rv = ERR_INSTANCE_DOES_NOT_EXIST;
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->stopdevice( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: setremoteuuaddress
 * 
 ***************************************************************************************/
int *setremoteuuaddress_1( struct TUUAddress *aArgs, CLIENT *aDutout )
{
	static int rv;
	int instance_key;
	CSMobster *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		rv = ERR_SERVICE_NOT_RUNNING;
		return &rv;
	}

	// set the return value to generic error
	rv = ERR_FAILED_TO_RETRIEVE_KEY;

	// get the key for the instance from the args
	instance_key = CSvcMobster::GetInstanceKeyFromArgs( SETREMOTEUUADDRESS, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		rv = ERR_INSTANCE_DOES_NOT_EXIST;
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->setremoteuuaddress( *aArgs );
	return &rv;
}
