/*
* Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:   
* THIS FILE IS AUTOGENERATED. Do not modify the contents of this file directly
* as changes will be lost
* Thu Oct 16 16:55:08 2003
* System Includes
*
*/




#include <assert.h>


/****************************************************************************************
 * 
 * Local Includes
 * 
 ***************************************************************************************/
#include "CSvcHostexecuteasync.h"
#include "CSHostexecuteasync.h"
#include "CComponentManager.h"


/****************************************************************************************
 * 
 * Static Variables
 * 
 ***************************************************************************************/
static CComponentManager<CSHostexecuteasync> *iComponentManager;


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: ss_startuprpcservice
 * 
 ***************************************************************************************/
int *ss_startuprpcservice_9( TStartupInfo *aArgs, CLIENT *aDutout )
{
	static int rv;

	// if the service is already started then return an error
	if( iComponentManager != NULL ) {
		rv = ERR_SERVICE_ALREADY_STARTED;
		return &rv;
	}

	// create the component manager
	iComponentManager = new CComponentManager<CSHostexecuteasync>( INFO_MAXIMUM_OBJECTS );
	if( iComponentManager == NULL ) {
		rv = ERR_FAILED_TO_CREATE_COMPONENT_MANAGER;
		return &rv;
	}

	// call the custom service manager
	rv = CSvcHostexecuteasync::StartRPCService( iComponentManager, aArgs );
	if( rv != ERR_NONE ) {
		delete iComponentManager;
		iComponentManager = NULL;
		return &rv;
	}

	// success
	rv = ERR_NONE;
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: sc_shutdownrpcservice
 * 
 ***************************************************************************************/
int *sc_shutdownrpcservice_9( int *aArgs, CLIENT *aDutout )
{
	static int rv;
	int instance_count;
	int err;

	// check that the service is started
	if( iComponentManager == NULL ) {
		rv = ERR_SERVICE_NOT_RUNNING;
		return &rv;
	}

	// if there are active sessions and the force flag isn't set then return an error
	instance_count = iComponentManager->GetInstanceCount();
	if( (instance_count > 0) && (*aArgs == 0) ) {
		rv = ERR_ACTIVE_USER_SESSIONS;
		return &rv;
	};

	// if the force flag IS set then reset all active connections
	instance_count = iComponentManager->GetInstanceCount();
	if( instance_count > 0 ) {
		err = iComponentManager->DeleteAllInstances();
		if( err != 0 ) {
			rv = ERR_FAILED_TO_REMOVE_ACTIVE_SESSIONS;
			return &rv;
		}
	}

	// call the custom service manager
	rv = CSvcHostexecuteasync::StopRPCService();
	if( rv != ERR_NONE ) {
		return &rv;
	}

	// delete the component manager
	delete iComponentManager;
	iComponentManager = NULL;

	// success
	rv = ERR_NONE;
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: list_devices
 * 
 ***************************************************************************************/
TComponentList *list_devices_9( void *aArgs, CLIENT *aDutout )
{
	static TComponentList rv;
	int i, valid_count, component_instance_count;

	//free any allocated memory
	if( rv.TComponentList_val != NULL ) {
		free( rv.TComponentList_val );
		rv.TComponentList_val = NULL;
		rv.TComponentList_len = 0;
	}

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcHostexecuteasync::SetError( LIST_DEVICES, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcHostexecuteasync::SetError( LIST_DEVICES, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the number of active component instances
	component_instance_count = iComponentManager->GetInstanceCount();

	// if there are one or more instances then allocate the memory
	if( component_instance_count > 0 ) {
		rv.TComponentList_val = (int*)malloc( sizeof(int) * component_instance_count );
		assert( rv.TComponentList_val != NULL );
		rv.TComponentList_len = component_instance_count;
	}

	// store all the currently active IDs in the list
	for( i = 0, valid_count = 0; i < INFO_MAXIMUM_OBJECTS; i++ ) {
		if( iComponentManager->IsValidKey(i) != 0 ) {
			assert( valid_count < component_instance_count );
			(rv.TComponentList_val)[valid_count++] = i;
		}
	}

	// ok return everything
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: cstr_startprocess
 * 
 ***************************************************************************************/
TResult *cstr_startprocess_9( char **aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int result;
	int internal_err;
	int instance_key;
	CSHostexecuteasync *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcHostexecuteasync::SetError( CSTR_STARTPROCESS, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// create a new component instance
	instance_key = iComponentManager->CreateInstance();
	if( instance_key < 0 ) {
		CSvcHostexecuteasync::SetError( CSTR_STARTPROCESS, (void*)&rv, instance_key );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->cstr_startprocess( *aArgs );
	result = CSvcHostexecuteasync::GetError( CSTR_STARTPROCESS, (void*)&rv );

	// if the method fails then we cleanup the instance -- otherwise we set the instance key
	// as the return value
	if( result != ERR_NONE ) {
		internal_err = iComponentManager->DeleteInstance( instance_key );
		assert( internal_err == 0 );
	} else { 
		CSvcHostexecuteasync::SetError( CSTR_STARTPROCESS, (void*)&rv, instance_key );
	}

	// done
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: dstr_removeprocess
 * 
 ***************************************************************************************/
TResult *dstr_removeprocess_9( int *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int result;
	int internal_err;
	int instance_key;
	int should_delete = 1;
	CSHostexecuteasync *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcHostexecuteasync::SetError( DSTR_REMOVEPROCESS, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// get the key for the instance from the args
	instance_key = CSvcHostexecuteasync::GetInstanceKeyFromArgs( DSTR_REMOVEPROCESS, (void*)aArgs );
	if( instance_key < 0 ) {
		CSvcHostexecuteasync::SetError( DSTR_REMOVEPROCESS, (void*)&rv, instance_key );
		return &rv;
	}
	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcHostexecuteasync::SetError( DSTR_REMOVEPROCESS, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->dstr_removeprocess( *aArgs, &should_delete );

	result = CSvcHostexecuteasync::GetError( DSTR_REMOVEPROCESS, (void*)&rv );

	// it is illegal for the method to succeed but not delete the instance
	assert( (result != ERR_NONE) || (should_delete == 1) );

	// delete the instance if requested
	if( should_delete != 0 ) {
		internal_err = iComponentManager->DeleteInstance( instance_key );
		assert( internal_err == ERR_NONE );
	}

	// done
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: killprocess
 * 
 ***************************************************************************************/
TResult *killprocess_9( int *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int instance_key;
	CSHostexecuteasync *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcHostexecuteasync::SetError( KILLPROCESS, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcHostexecuteasync::SetError( KILLPROCESS, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcHostexecuteasync::GetInstanceKeyFromArgs( KILLPROCESS, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcHostexecuteasync::SetError( KILLPROCESS, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->killprocess( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: stopprocess
 * 
 ***************************************************************************************/
TResult *stopprocess_9( int *aArgs, CLIENT *aDutout )
{
	static TResult rv;
	int instance_key;
	CSHostexecuteasync *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcHostexecuteasync::SetError( STOPPROCESS, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcHostexecuteasync::SetError( STOPPROCESS, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcHostexecuteasync::GetInstanceKeyFromArgs( STOPPROCESS, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcHostexecuteasync::SetError( STOPPROCESS, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->stopprocess( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: getprocessinfo
 * 
 ***************************************************************************************/
THostExecuteAsyncProcessInfo *getprocessinfo_9( int *aArgs, CLIENT *aDutout )
{
	static THostExecuteAsyncProcessInfo rv;
	int instance_key;
	CSHostexecuteasync *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcHostexecuteasync::SetError( GETPROCESSINFO, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcHostexecuteasync::SetError( GETPROCESSINFO, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcHostexecuteasync::GetInstanceKeyFromArgs( GETPROCESSINFO, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcHostexecuteasync::SetError( GETPROCESSINFO, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->getprocessinfo( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: getstandardoutput
 * 
 ***************************************************************************************/
TVarData *getstandardoutput_9( int *aArgs, CLIENT *aDutout )
{
	static TVarData rv;
	int instance_key;
	CSHostexecuteasync *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcHostexecuteasync::SetError( GETSTANDARDOUTPUT, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcHostexecuteasync::SetError( GETSTANDARDOUTPUT, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcHostexecuteasync::GetInstanceKeyFromArgs( GETSTANDARDOUTPUT, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcHostexecuteasync::SetError( GETSTANDARDOUTPUT, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->getstandardoutput( *aArgs );
	return &rv;
}


/****************************************************************************************
 * 
 * PUBLIC FUNCTION: getstandarderror
 * 
 ***************************************************************************************/
TVarData *getstandarderror_9( int *aArgs, CLIENT *aDutout )
{
	static TVarData rv;
	int instance_key;
	CSHostexecuteasync *session;

	// check that the service is started
	if( iComponentManager == NULL ) {
		CSvcHostexecuteasync::SetError( GETSTANDARDERROR, (void*)&rv, ERR_SERVICE_NOT_RUNNING );
		return &rv;
	}

	// set the return value to generic error
	CSvcHostexecuteasync::SetError( GETSTANDARDERROR, (void*)&rv, ERR_FAILED_TO_RETRIEVE_KEY );

	// get the key for the instance from the args
	instance_key = CSvcHostexecuteasync::GetInstanceKeyFromArgs( GETSTANDARDERROR, (void*)aArgs );
	if( instance_key < 0 ) {
		return &rv;
	}

	// make sure the key is valid
	if( iComponentManager->IsValidKey(instance_key) == 0 ) {
		CSvcHostexecuteasync::SetError( GETSTANDARDERROR, (void*)&rv, ERR_INSTANCE_DOES_NOT_EXIST );
		return &rv;
	}

	// get the instance
	session = iComponentManager->GetInstance( instance_key );
	assert( session != NULL );

	// call the corresponding method on the instance
	rv = session->getstandarderror( *aArgs );
	return &rv;
}
