/*
* Copyright (c) 2000 - 2005 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  
 *
*/




package com.nokia.epdt.plugins.s60.emulator;

import java.util.Observer;

/**
 * GlobalSettingsJPanel
 *
 * @version 1.0
 */
public class GlobalSettingsJPanel extends javax.swing.JPanel implements Observer {
    private EmulatorModel emulatorModel = EmulatorModel.getInstance();
    private EmulatorPlugin emulatorPlugin = null;
    
    /** Creates new form GlobalSettingsJPanel */
    public GlobalSettingsJPanel(EmulatorPlugin emulatorPlugin) {
        this.emulatorPlugin = emulatorPlugin;
        initComponents();
        emulatorModel.addObserver(this);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        justInTimeButtonGroup = new javax.swing.ButtonGroup();
        panicsButtonGroup = new javax.swing.ButtonGroup();
        debugInfoButtonGroup = new javax.swing.ButtonGroup();
        panicsJPanel = new javax.swing.JPanel();
        enablePanicsJRadioButton = new javax.swing.JRadioButton();
        disablePanicsJRadioButton = new javax.swing.JRadioButton();
        justInTimeJPanel = new javax.swing.JPanel();
        enableJustInTimeJRadioButton = new javax.swing.JRadioButton();
        disableJustInTimeJRadioButton = new javax.swing.JRadioButton();
        debugInfoJPanel = new javax.swing.JPanel();
        enableDebugInfoJRadioButton = new javax.swing.JRadioButton();
        disableDebugInfoJRadioButton = new javax.swing.JRadioButton();

        setLayout(null);

        setMinimumSize(new java.awt.Dimension(0, 0));
        setPreferredSize(new java.awt.Dimension(300, 300));
        panicsJPanel.setLayout(null);

        panicsJPanel.setBorder(new javax.swing.border.TitledBorder("Extended panic code file"));
        panicsJPanel.setMinimumSize(new java.awt.Dimension(0, 0));
        enablePanicsJRadioButton.setText(EmulatorResourceBundle.getInstance().getValue(EmulatorConstants.PANIC_ENABLE_LABEL));
        panicsButtonGroup.add(enablePanicsJRadioButton);
        enablePanicsJRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                enablePanicsJRadioButtonActionPerformed(evt);
            }
        });

        panicsJPanel.add(enablePanicsJRadioButton);
        enablePanicsJRadioButton.setBounds(120, 20, 98, 24);

        disablePanicsJRadioButton.setSelected(true);
        disablePanicsJRadioButton.setText(EmulatorResourceBundle.getInstance().getValue(EmulatorConstants.PANIC_DISABLE_LABEL));
        panicsButtonGroup.add(disablePanicsJRadioButton);
        disablePanicsJRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                disablePanicsJRadioButtonActionPerformed(evt);
            }
        });

        panicsJPanel.add(disablePanicsJRadioButton);
        disablePanicsJRadioButton.setBounds(30, 20, 98, 24);

        add(panicsJPanel);
        panicsJPanel.setBounds(20, 80, 250, 60);

        // jit
        justInTimeJPanel.setLayout(null);

        justInTimeJPanel.setBorder(new javax.swing.border.TitledBorder("Just-in-time debugging"));
        justInTimeJPanel.setMinimumSize(new java.awt.Dimension(0, 0));
        enableJustInTimeJRadioButton.setText(EmulatorResourceBundle.getInstance().getValue(EmulatorConstants.JUST_IN_TIME_ENABLE_LABEL));
        justInTimeButtonGroup.add(enableJustInTimeJRadioButton);
        enableJustInTimeJRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                enableJustInTimeJRadioButtonActionPerformed(evt);
            }
        });

        justInTimeJPanel.add(enableJustInTimeJRadioButton);
        enableJustInTimeJRadioButton.setBounds(120, 20, 98, 24);

        disableJustInTimeJRadioButton.setSelected(true);
        disableJustInTimeJRadioButton.setText(EmulatorResourceBundle.getInstance().getValue(EmulatorConstants.JUST_IN_TIME_DISABLE_LABEL));
        justInTimeButtonGroup.add(disableJustInTimeJRadioButton);
        disableJustInTimeJRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                disableJustInTimeJRadioButtonActionPerformed(evt);
            }
        });

        justInTimeJPanel.add(disableJustInTimeJRadioButton);
        disableJustInTimeJRadioButton.setBounds(30, 20, 98, 24);

        add(justInTimeJPanel);
        justInTimeJPanel.setBounds(20, 10, 250, 60);
        // jit
        
        debugInfoJPanel.setLayout(null);

        debugInfoJPanel.setBorder(new javax.swing.border.TitledBorder("Debugging information file"));
        debugInfoJPanel.setMinimumSize(new java.awt.Dimension(0, 0));
        enableDebugInfoJRadioButton.setText(EmulatorResourceBundle.getInstance().getValue(EmulatorConstants.DEBUG_ENABLE_LABEL));
        debugInfoButtonGroup.add(enableDebugInfoJRadioButton);
        enableDebugInfoJRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                enableDebugInfoJRadioButtonActionPerformed(evt);
            }
        });

        debugInfoJPanel.add(enableDebugInfoJRadioButton);
        enableDebugInfoJRadioButton.setBounds(120, 20, 98, 24);

        disableDebugInfoJRadioButton.setSelected(true);
        disableDebugInfoJRadioButton.setText(EmulatorResourceBundle.getInstance().getValue(EmulatorConstants.DEBUG_DISABLE_LABEL));
        debugInfoButtonGroup.add(disableDebugInfoJRadioButton);
        disableDebugInfoJRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                disableDebugInfoJRadioButtonActionPerformed(evt);
            }
        });

        debugInfoJPanel.add(disableDebugInfoJRadioButton);
        disableDebugInfoJRadioButton.setBounds(30, 20, 98, 24);

        add(debugInfoJPanel);
        debugInfoJPanel.setBounds(20, 150, 250, 60);
    }//GEN-END:initComponents
    
    private void disableDebugInfoJRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_disableDebugInfoJRadioButtonActionPerformed
        // Add your handling code here:
        emulatorModel.setDebugInfo(false);
    }//GEN-LAST:event_disableDebugInfoJRadioButtonActionPerformed
    
    private void enableDebugInfoJRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_enableDebugInfoJRadioButtonActionPerformed
        // Add your handling code here:
        emulatorModel.setDebugInfo(true);
    }//GEN-LAST:event_enableDebugInfoJRadioButtonActionPerformed
    
    private void disableJustInTimeJRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_disableJustInTimeJRadioButtonActionPerformed
        // Add your handling code here:
        emulatorModel.setJustInTime(false);
    }//GEN-LAST:event_disableJustInTimeJRadioButtonActionPerformed
    
    private void enableJustInTimeJRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_enableJustInTimeJRadioButtonActionPerformed
        // Add your handling code here:
        emulatorModel.setJustInTime(true);
    }//GEN-LAST:event_enableJustInTimeJRadioButtonActionPerformed
    
    private void disablePanicsJRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_disablePanicsJRadioButtonActionPerformed
        // Add your handling code here:
        emulatorModel.setPanics(false);
    }//GEN-LAST:event_disablePanicsJRadioButtonActionPerformed
    
    private void enablePanicsJRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_enablePanicsJRadioButtonActionPerformed
        // Add your handling code here:
        emulatorModel.setPanics(true);
    }//GEN-LAST:event_enablePanicsJRadioButtonActionPerformed
    
    /**
     * This method is called whenever the pan model is changed (observed object is changed).
     * An application calls an Observable object's notifyObservers method
     * to have all the object's observers notified of the change.
     * @param o the observable object.
     * @param arg an argument passed to the notifyObservers method.
     */
    public void update(java.util.Observable o, Object arg) {
        emulatorPlugin.pluginModelChangedAction();
        // just in time
        disableJustInTimeJRadioButton.setSelected( emulatorModel.isJustInTime() ? false : true );
        enableJustInTimeJRadioButton.setSelected( emulatorModel.isJustInTime() ? true : false );
        // panics
        disablePanicsJRadioButton.setSelected( emulatorModel.isPanics() ? false : true );
        enablePanicsJRadioButton.setSelected( emulatorModel.isPanics() ? true : false );
        // debug
        disableDebugInfoJRadioButton.setSelected( emulatorModel.isDebugInfo() ? false : true );
        enableDebugInfoJRadioButton.setSelected( emulatorModel.isDebugInfo() ? true : false );
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup debugInfoButtonGroup;
    private javax.swing.JPanel debugInfoJPanel;
    private javax.swing.JRadioButton disableDebugInfoJRadioButton;
    private javax.swing.JRadioButton disableJustInTimeJRadioButton;
    private javax.swing.JRadioButton disablePanicsJRadioButton;
    private javax.swing.JRadioButton enableDebugInfoJRadioButton;
    private javax.swing.JRadioButton enableJustInTimeJRadioButton;
    private javax.swing.JRadioButton enablePanicsJRadioButton;
    private javax.swing.ButtonGroup justInTimeButtonGroup;
    private javax.swing.JPanel justInTimeJPanel;
    private javax.swing.ButtonGroup panicsButtonGroup;
    private javax.swing.JPanel panicsJPanel;
    // End of variables declaration//GEN-END:variables
    
}
