/*
* Copyright (c) 2000 - 2005 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  
 *
*/


package com.nokia.epdt.plugins.s60.general;

import java.awt.BorderLayout;
import java.io.File;
import java.io.IOException;
import java.io.BufferedWriter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.text.NumberFormatter;
import javax.swing.JRadioButton;
import javax.swing.SpringLayout;

import org.apache.log4j.Logger;

import com.nokia.epdt.core.CoreUtils;
import com.nokia.epdt.core.config.epocini.EpocIniConfigurator;
import com.nokia.epdt.core.config.epocini.EpocIniConstants;
import com.nokia.util.gui.GUI;
import com.nokia.util.gui.SpringUtilities;
/**
 * GlobalSettingsJPanel
 *
 * @version 1.0
 */
public class GeneralSettingsJPanel extends javax.swing.JPanel
		implements
			java.awt.event.ActionListener
{
	private static Logger log = Logger.getLogger(GeneralSettingsJPanel.class);
	private static ResourceBundle resourceBundle = ResourceBundle
			.getBundle("com.nokia.epdt.plugins.s60.general.generalsettings");
	private GeneralSettingsPlugin generalSettingsPlugin = null;
	private EpocIniConfigurator configurator = null;
	private Model model;
	//THE VALUE IS S60 RELEASE SPECIFIC
	//IT IS FOUND EMPIRICALLY :(
	private static Integer MAX_MEMORY = new Integer(128);

	// Variables declaration
	private javax.swing.JPanel resolutionPanel;
	private javax.swing.JComboBox resolutionComboBox;
	private javax.swing.JLabel memoryLabel;
	private javax.swing.JPanel memoryPanel;
	private JFormattedTextField memoryTextField;
	private javax.swing.JPanel startListPanel;
	private JRadioButton trimmedListButton;
	private JRadioButton fullListButton;

	private int GAP = 7;

	/** Creates new form GlobalSettingsJPanel */
	public GeneralSettingsJPanel(GeneralSettingsPlugin generalSettingsPlugin)
	{

		this.generalSettingsPlugin = generalSettingsPlugin;
		configurator = generalSettingsPlugin.getConfigurator();
		model = new Model(configurator);
		initComponents();
		memoryTextField.setText(configurator
				.getProperty(EpocIniConstants.MEGABYTES_OF_FREE_MEMORY));

	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	private void initComponents()
	{

		//Memory
		memoryPanel = new javax.swing.JPanel();
		memoryLabel = new javax.swing.JLabel();

		NumberFormatter numberFormatter = new NumberFormatter();
		numberFormatter.setMinimum(new Integer(0));
		numberFormatter.setMaximum(MAX_MEMORY);
		memoryTextField = new JFormattedTextField(numberFormatter);
		memoryTextField.setValue(new Integer(0));
		memoryTextField.setColumns(4);
		memoryTextField.addFocusListener(new java.awt.event.FocusListener()
		{
			public void focusLost(java.awt.event.FocusEvent evt)
			{
				generalSettingsPlugin.pluginModelChangedAction();
				if (!memoryTextField.isEditValid())
				{
					JOptionPane.showMessageDialog(memoryPanel, resourceBundle
							.getString("validation.message.memory")
							+ " " + MAX_MEMORY, resourceBundle
							.getString("remainder.dialog.title"),
							JOptionPane.INFORMATION_MESSAGE);
				}
			}
			public void focusGained(java.awt.event.FocusEvent evt)
			{
			};
		});
		setLayout(null);

		setMinimumSize(new java.awt.Dimension(0, 0));
		setPreferredSize(new java.awt.Dimension(400, 150));

		memoryPanel.setLayout(null);
		memoryPanel.setBorder(new javax.swing.border.TitledBorder(
				resourceBundle.getString("memory.border.title")));
		memoryPanel.setMinimumSize(new java.awt.Dimension(0, 0));

		memoryPanel.add(memoryTextField);
		memoryTextField.setBounds(30, 25, 50, 20);

		memoryLabel.setText("MB");
		memoryPanel.add(memoryLabel);
		memoryLabel.setBounds(90, 25, 18, 16);

		add(memoryPanel);
		memoryPanel.setBounds(20, 10, 250, 70);

		if (log.isDebugEnabled())
		{
			log.debug("Resolutions: " + model.getResolutions().size());
		}
		//Resolution:
		resolutionPanel = new javax.swing.JPanel();
		resolutionComboBox = new javax.swing.JComboBox(model.getResolutions());

		if (model.getResolutions().size() > 0)
		{
			resolutionComboBox.setEnabled(true);
			resolutionComboBox.setSelectedItem(model.getResolutions().get(0));
			resolutionComboBox
					.addItemListener(new java.awt.event.ItemListener()
					{
						public void itemStateChanged(
								java.awt.event.ItemEvent evt)
						{
							generalSettingsPlugin.pluginModelChangedAction();
						}
					});

		} else
		{
			resolutionComboBox.setEnabled(false);
		}

		setLayout(null);
		setMinimumSize(new java.awt.Dimension(0, 0));
		setPreferredSize(new java.awt.Dimension(300, 300));

		resolutionPanel.setLayout(null);
		resolutionPanel.setBorder(new javax.swing.border.TitledBorder(
				resourceBundle.getString("resolution.border.title")));
		resolutionPanel.setMinimumSize(new java.awt.Dimension(0, 0));

		resolutionPanel.add(resolutionComboBox);
		resolutionComboBox.setBounds(30, 25, 200, 25);

		add(resolutionPanel);
		resolutionPanel.setBounds(20, 100, 250, 70);
		//StartList check box
		/*
		 startListCheckBox = new JCheckBox(resourceBundle.getString("startlist.label"));
		 startListCheckBox.addItemListener( new java.awt.event.ItemListener(){
		 public void itemStateChanged(java.awt.event.ItemEvent evt) {
		 generalSettingsPlugin.pluginModelChangedAction(); }
		 });
		 startListCheckBox.setSelected(model.isStartListTrimmed());
		 startListPanel.setLayout(new FlowLayout(FlowLayout.LEADING));
		 startListPanel.setBorder(new TitledBorder(
		 resourceBundle.getString("startlist.border.title")) );
		 startListPanel.setMinimumSize(new java.awt.Dimension(0, 0));
		 startListPanel.setBounds(20, 180, 250, 80);
		 startListPanel.add(startListCheckBox);
		 startListPanel.add(new JLabel(
		 resourceBundle.getString("startlist.description")));
		 add(startListPanel);
		 */
		
		
		
		/*startListPanel = new JPanel();
		startListPanel.setLayout(new SpringLayout());
		startListPanel.setBorder(new TitledBorder(resourceBundle
				.getString("startlist.border.title")));
		startListPanel.setMinimumSize(new java.awt.Dimension(0, 0));
		startListPanel.setBounds(20, 180, 250, 100);
		trimmedListButton = new JRadioButton();
		trimmedListButton.setVerticalAlignment(JRadioButton.TOP);
		trimmedListButton.addActionListener(this);
		trimmedListButton.setSelected(model.isStartListTrimmed());
		fullListButton = new JRadioButton();
		fullListButton.setVerticalAlignment(JRadioButton.TOP);
		fullListButton.addActionListener(this);
		fullListButton.setSelected(!model.isStartListTrimmed());
		JTextArea fullListText = new JTextArea(resourceBundle
				.getString("startlist.full.list.label"));
		JTextArea trimmedListText = new JTextArea(resourceBundle
				.getString("startlist.trimmed.list.label"));
		fullListText.setBackground(getBackground());
		fullListText.setFont(getFont());
		fullListText.setEditable(false);
		trimmedListText.setBackground(getBackground());
		trimmedListText.setFont(getFont());
		trimmedListText.setEditable(false);
		startListPanel.add(trimmedListButton);
		startListPanel.add(trimmedListText);
		startListPanel.add(fullListButton);
		startListPanel.add(fullListText);
		SpringUtilities.makeCompactGrid(startListPanel, 2, 2,//rows cols
				GAP * 2, 0,//left and top margins
				GAP, 0);//gaps between elements
		add(startListPanel);*/
		
		
		
		// Warning panel
		JPanel warning = new JPanel(new BorderLayout(5, 5));
		warning.add(GUI.createTextComponent(resourceBundle
				.getString("remainder.dialog.message")), BorderLayout.CENTER);
		ImageIcon icon = new ImageIcon(ClassLoader
				.getSystemResource("resources/info.gif"));
		if (icon != null)
		{
			JLabel warningIcon = new JLabel(icon);
			warningIcon.setVerticalAlignment(JLabel.TOP);
			warning.add(warningIcon, BorderLayout.WEST);
		}
		add(warning);
		warning.setBounds(10, 200, 340, 370);
	}//GEN-END:initComponents

	public void actionPerformed(java.awt.event.ActionEvent e)
	{
		Object source = e.getSource();
		generalSettingsPlugin.pluginModelChangedAction();
		if (source == fullListButton)
		{
			trimmedListButton.setSelected(false);
		} else if (source == trimmedListButton)
		{
			fullListButton.setSelected(false);
		}
	}

	public void applyChanges()
	{
		if (memoryTextField.isEditValid())
		{
			configurator.setProperty(EpocIniConstants.MEGABYTES_OF_FREE_MEMORY,
					memoryTextField.getText());
		} else
		{
			JOptionPane.showMessageDialog(this, resourceBundle
					.getString("validation.message.memory")
					+ " " + MAX_MEMORY, resourceBundle
					.getString("remainder.dialog.title"),
					JOptionPane.INFORMATION_MESSAGE);
		}
		model.saveSelectedResolution((String) resolutionComboBox
				.getSelectedItem());
		
		//Change for non critical starter mode
		//Pranav: Commented as startup mode setting is not require.
		//TODO: Code cleanup is require.
		//model.saveStartMode(trimmedListButton.isSelected());
		//model.saveStarterNonCriticalMode(trimmedListButton.isSelected());
		configurator.saveSettings();

	}
	private class Model
	{
		EpocIniConfigurator configurator;
		//contains strings like in UI 240x320, 320x240, 777x888 etc.
		private Vector resolutions = new Vector();

		public Model(EpocIniConfigurator aConfigurator)
		{
			configurator = aConfigurator;
			init();
		}
		private void init()
		{
			resolutions = new Vector();
			Vector properties = configurator
					.getProperties(EpocIniConstants.CONFIGURATION);
			for (int i = 0; i < properties.size(); i++)
			{
				EpocIniConfigurator.Property p = (EpocIniConfigurator.Property) properties
						.get(i);
				//Filter _f files
				String resolutionFileName = getResolutionFromFileName(p.value);
				
				if (!resolutionFileName.endsWith("_f")){
					resolutions.add(resolutionFileName);
				}
			}
		}
		public boolean isStartListTrimmed()
		{
			String epocroot = CoreUtils.EpocRoot();
			if (epocroot != "")
			{
				File starterFile = new File(
						epocroot
								+ "epoc32\\RELEASE\\winscw\\udeb\\Z\\resource\\starter.rsc");
				File starterFullFile = new File(
						epocroot
								+ "epoc32\\RELEASE\\winscw\\udeb\\Z\\resource\\starter_full.rsc");
				if (starterFile.exists() && starterFullFile.exists())
				{
					return true;
				}
			}
			return false;
			//return false if there is only starter.rsc file or
			//there is starter.rsc and starter_trimmed.rsc (means starter.rsc is full)
		}
		private String getResolutionFromFileName(String resolutionFileName)
		{
			if (resolutionFileName.startsWith("epoc_"))
			{
				int endIndex;
				if ((endIndex = resolutionFileName.indexOf(".ini")) != -1)
				{
					return resolutionFileName.substring(5, endIndex);
				}
			}
			return "";
		}
		public Vector getResolutions()
		{
			return resolutions;
		}
		public void saveSelectedResolution(String aResolution)
		{
			//form a new vector of resolutions and set it to 
			//configurator
			//Ex, the old vector: resolutions = a,b,c,d,e
			//selected resolution: aResolution = c
			//the new vector should be: resolutions = c,d,e,a,b
			//(in round-robin fashion)
			// Then SAVE SETTINGS configurator.save() ;)
			//Then generate runOnce.cmd to copy ws.ini

			int delta = resolutions.indexOf(aResolution);
			Vector resProps = configurator
					.getProperties(EpocIniConstants.CONFIGURATION);
			//check that we didn't loose resolutions on the way and 
			//we have sensible delta (selected resolution index)
			if (/*resProps.size() != resolutions.size() || */delta <= 0
					|| delta > resProps.size() - 1)
			{
				return;
			}
			//copy in round robin fashion:
			int rSize = resolutions.size();
			for (int i = 0; i < rSize/*resProps.size()*/; i++)
			{
				EpocIniConfigurator.Property property = (EpocIniConfigurator.Property) resProps
						.get(i);
				if (i + delta < rSize)
				{
					property.value = "epoc_"
							+ (String) resolutions.get(i + delta) + ".ini";
				} else
				{
					property.value = "epoc_"
							+ (String) resolutions.get(i - rSize + delta)
							+ ".ini";
				}
			}
			configurator.saveSettings();
			//read updated settings from configurator (epoc.ini) for resolutions
			//to match fresh epoc.ini (for multiple Apply presses)
			init();
			
			/* 
			 The file runOnce.cmd should copy 
			 F:\s16\epoc32\tools\ecmt\resolution\ <240x320>_wsini.ini to 
			 ..\\..\\release\\winscw\\udeb\\z\\system\\data\\wsini.ini
	    	   and to
	    	   "epoc32\\data\\wsini.ini"
	    	 */
	    //delete this part because now request will go to windows server because of symbian changes.check this.
			String epocroot = CoreUtils.EpocRoot();//ends with file separator;
			String sourceName = epocroot + "epoc32\\tools\\ecmt\\resolution\\"
					+ aResolution + "_wsini.ini";
			String destinationName1 = epocroot
					+ "epoc32\\release\\winscw\\udeb\\z\\system\\data\\wsini.ini";
			String destinationName2 = epocroot + "epoc32\\data\\wsini.ini";
			addRunOnceCommand("copy " + sourceName + " " + destinationName1);
			addRunOnceCommand("copy " + sourceName + " " + destinationName2);
		}
		public void saveStartMode(boolean aIsStartListTrimmed)
		{
			String resDir = CoreUtils.EpocRoot()
					+ "epoc32\\RELEASE\\winscw\\udeb\\Z\\resource\\";
			File starterFile = new File(resDir + "starter.rsc");
			File starterFullFile = new File(resDir + "starter_full.rsc");
			File starterTrimmedFile = new File(resDir + "starter_trimmed.rsc");

			if (aIsStartListTrimmed && starterTrimmedFile.exists()
					&& starterFile.exists())
			{
				String cmd1 = "ren " + resDir + "starter.rsc "
						+ "starter_full.rsc";
				String cmd2 = "ren " + resDir + "starter_trimmed.rsc "
						+ "starter.rsc";
				if (checkStartUpCommand(cmd1) && checkStartUpCommand(cmd2))
				{
					addRunOnceCommand(cmd1);
					addRunOnceCommand(cmd2);
				}
			}
			if (!aIsStartListTrimmed && starterFullFile.exists()
					&& starterFile.exists())
			{
				//This routine should be modified according to the default startup mode. As of now this 
				// is applicable for default minimal startup mode
				String epocroot = CoreUtils.EpocRoot();
				String cmd0 = "";
				if (epocroot != "") {
					File startertrimmedFile = new File(epocroot + "epoc32\\RELEASE\\winscw\\udeb\\Z\\resource\\starter_trimmed.rsc");
					if (startertrimmedFile.exists()) {
						cmd0 = "del " + resDir + "starter_trimmed.rsc";
						addRunOnceCommand(cmd0);
					}
				}
				String cmd1 = "ren " + resDir + "starter.rsc "
						+ "starter_trimmed.rsc";
				String cmd2 = "ren " + resDir + "starter_full.rsc "
						+ "starter.rsc";
				if (checkStartUpCommand(cmd1) && checkStartUpCommand(cmd2))
				{
					addRunOnceCommand(cmd1);
					addRunOnceCommand(cmd2);
				}
			}
		}

		// Change for non critical starter mode
		/**
		 *
		 * @param aIsStartListTrimmed
		 */
		public void saveStarterNonCriticalMode(boolean aIsStartListTrimmed)
		{
			String resDir = CoreUtils.EpocRoot()
					+ "epoc32\\RELEASE\\winscw\\udeb\\Z\\resource\\";
			
			final String STARTER_NON_CRIT_FN = "starter_non_critical_1.rsc";
			final String STARTER_NON_CRIT_FULL_FN = "starter_non_critical_1_full.rsc";
			final String STARTER_NON_CRIT_TRIMMED_FN = "starter_non_critical_1_trimmed.rsc";
			
			File starterFile = new File(resDir + STARTER_NON_CRIT_FN);
			File starterFullFile = new File(resDir + STARTER_NON_CRIT_FULL_FN);
			File starterTrimmedFile = new File(resDir + STARTER_NON_CRIT_TRIMMED_FN);

			if (aIsStartListTrimmed && starterTrimmedFile.exists()
					&& starterFile.exists())
			{
				String cmd1 = "ren " + resDir + STARTER_NON_CRIT_FN + " " + STARTER_NON_CRIT_FULL_FN;
				String cmd2 = "ren " + resDir + STARTER_NON_CRIT_TRIMMED_FN + " " + STARTER_NON_CRIT_FN;
				if (checkStartUpCommand(cmd1) && checkStartUpCommand(cmd2))
				{
					addRunOnceCommand(cmd1);
					addRunOnceCommand(cmd2);
				}
			}
			if (!aIsStartListTrimmed && starterFullFile.exists()
					&& starterFile.exists())
			{
				//This routine should be modified according to the default startup mode. As of now this 
				// is applicable for default minimal startup mode
				String epocroot = CoreUtils.EpocRoot();
				String cmd0 = "";
				if (epocroot != "") {
					File startertrimmedFile = new File(epocroot + "epoc32\\RELEASE\\winscw\\udeb\\Z\\resource\\"+STARTER_NON_CRIT_TRIMMED_FN);
					if (startertrimmedFile.exists()) {
						cmd0 = "del " + resDir + STARTER_NON_CRIT_TRIMMED_FN;
						addRunOnceCommand(cmd0);
					}
				}
				
				String cmd1 = "ren " + resDir + STARTER_NON_CRIT_FN +" "
						+ STARTER_NON_CRIT_TRIMMED_FN;
				String cmd2 = "ren " + resDir + STARTER_NON_CRIT_FULL_FN +" "
						+ STARTER_NON_CRIT_FN;
				if (checkStartUpCommand(cmd1) && checkStartUpCommand(cmd2))
				{
					addRunOnceCommand(cmd1);
					addRunOnceCommand(cmd2);
				}
			}
		}
		
		//Check if the command is already present in the runOnce.cmd file
		//if it is - return false - DO NOT ADD it
		private boolean checkStartUpCommand(String aCommand)
		{
			int slashIndex = aCommand.lastIndexOf('\\');
			String commandCore = aCommand;
			if (slashIndex != -1 && slashIndex<aCommand.length()-1)
			{
				commandCore = aCommand.substring(slashIndex+1, aCommand.length());
			}
			try
			{
				if ((new File("runOnce.cmd")).exists())
				{
					BufferedReader runOnceReader = new BufferedReader(
							new FileReader("runOnce.cmd"));
					String s;
					while ((s = runOnceReader.readLine()) != null)
					{
						if (s.indexOf(commandCore) != -1)
						{
							runOnceReader.close();
							return false;
						}
					}
				}
			} catch (IOException ioe)
			{
				log.error("RunOnce command file operation failed: " + ioe);
				return false;
			}
			return true;
		}

		private synchronized void addRunOnceCommand(String aCommand)
		{
			try
			{
				BufferedWriter runOnceWriter = new BufferedWriter(
						new FileWriter("runOnce.cmd", true));
				runOnceWriter.write(aCommand);
				runOnceWriter.newLine();
				runOnceWriter.flush();
			} catch (IOException ioe)
			{
				log.error("RunOnce command file operation failed: " + ioe);
			}
		}

	}
}
