/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.internal.wizards.datatransfer.IFileExporter;

public class ZipFileExporter
implements IFileExporter {
    private ZipOutputStream outputStream;
    private boolean useCompression = true;

    public ZipFileExporter(String filename, boolean compress) throws IOException {
        this.outputStream = new ZipOutputStream(new FileOutputStream(filename));
        this.useCompression = compress;
    }

    public void finished() throws IOException {
        this.outputStream.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void write(ZipEntry entry, IFile contents) throws IOException, CoreException {
        block12: {
            Object var6_6;
            InputStream contentStream;
            byte[] readBuffer = new byte[4096];
            if (!this.useCompression) {
                CRC32 checksumCalculator;
                int length;
                block11: {
                    entry.setMethod(0);
                    contentStream = contents.getContents(false);
                    length = 0;
                    checksumCalculator = new CRC32();
                    try {
                        int n;
                        while ((n = contentStream.read(readBuffer)) > 0) {
                            checksumCalculator.update(readBuffer, 0, n);
                            length += n;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        if (contentStream != null) {
                            contentStream.close();
                        }
                        throw throwable;
                    }
                    {
                        Object var8_11 = null;
                        if (contentStream == null) break block11;
                    }
                    contentStream.close();
                }
                entry.setSize(length);
                entry.setCrc(checksumCalculator.getValue());
            }
            this.outputStream.putNextEntry(entry);
            contentStream = contents.getContents(false);
            try {
                int n;
                while ((n = contentStream.read(readBuffer)) > 0) {
                    this.outputStream.write(readBuffer, 0, n);
                }
            }
            catch (Throwable throwable) {
                var6_6 = null;
                if (contentStream != null) {
                    contentStream.close();
                }
                throw throwable;
            }
            {
                var6_6 = null;
                if (contentStream == null) break block12;
            }
            contentStream.close();
        }
        this.outputStream.closeEntry();
    }

    public void write(IFile resource, String destinationPath) throws IOException, CoreException {
        ZipEntry newEntry = new ZipEntry(destinationPath);
        this.write(newEntry, resource);
    }
}

