/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;

public class ContextFinder
extends ClassLoader
implements PrivilegedAction {
    static ClassLoader finderClassLoader;
    static Finder contextFinder;
    private static ThreadLocal cycleDetector;
    static /* synthetic */ Class class$0;

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.runtime.internal.adaptor.ContextFinder");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                finderClassLoader = clazz.getClassLoader();
                contextFinder = new Finder();
                return null;
            }
        });
        cycleDetector = new ThreadLocal();
    }

    public ContextFinder(ClassLoader contextClassLoader) {
        super(contextClassLoader);
    }

    ArrayList basicFindClassLoaders() {
        Class[] stack = contextFinder.getClassContext();
        ArrayList<ClassLoader> result = new ArrayList<ClassLoader>(1);
        int i = 1;
        while (i < stack.length) {
            ClassLoader tmp = stack[i].getClassLoader();
            Class clazz = stack[i];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.core.runtime.internal.adaptor.ContextFinder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2 && tmp != null && tmp != this) {
                if (this.checkClassLoader(tmp)) {
                    result.add(tmp);
                }
                if (tmp == finderClassLoader || tmp instanceof BundleClassLoader) break;
            }
            ++i;
        }
        return result;
    }

    private boolean checkClassLoader(ClassLoader classloader) {
        if (classloader == null || classloader == this.getParent()) {
            return false;
        }
        ClassLoader parent = classloader.getParent();
        while (parent != null) {
            if (parent == this) {
                return false;
            }
            parent = parent.getParent();
        }
        return true;
    }

    private ArrayList findClassLoaders() {
        if (System.getSecurityManager() == null) {
            return this.basicFindClassLoaders();
        }
        return (ArrayList)AccessController.doPrivileged(this);
    }

    public Object run() {
        return this.basicFindClassLoaders();
    }

    private boolean startLoading(String name) {
        HashSet<String> classesAndResources = (HashSet<String>)cycleDetector.get();
        if (classesAndResources != null && classesAndResources.contains(name)) {
            return false;
        }
        if (classesAndResources == null) {
            classesAndResources = new HashSet<String>(3);
            cycleDetector.set(classesAndResources);
        }
        classesAndResources.add(name);
        return true;
    }

    private void stopLoading(String name) {
        ((Set)cycleDetector.get()).remove(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized Class loadClass(String arg0, boolean arg1) throws ClassNotFoundException {
        if (!this.startLoading(arg0)) {
            throw new ClassNotFoundException(arg0);
        }
        try {
            Iterator loaders;
            block9: {
                Class<?> clazz;
                try {
                    clazz = super.loadClass(arg0, arg1);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ArrayList toConsult = this.findClassLoaders();
                    loaders = toConsult.iterator();
                    break block9;
                }
                Object var5_5 = null;
                this.stopLoading(arg0);
                return clazz;
            }
            while (true) {
                Class<?> clazz;
                if (!loaders.hasNext()) {
                    throw new ClassNotFoundException(arg0);
                }
                try {
                    clazz = ((ClassLoader)loaders.next()).loadClass(arg0);
                }
                catch (ClassNotFoundException classNotFoundException) {}
                Object var5_6 = null;
                this.stopLoading(arg0);
                return clazz;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.stopLoading(arg0);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected URL findResource(String arg0) {
        URL uRL;
        if (!this.startLoading(arg0)) {
            return null;
        }
        try {
            block4: {
                URL result;
                ArrayList toConsult = this.findClassLoaders();
                Iterator loaders = toConsult.iterator();
                do {
                    if (!loaders.hasNext()) break block4;
                } while ((result = ((ClassLoader)loaders.next()).getResource(arg0)) == null);
                URL uRL2 = result;
                Object var5_7 = null;
                this.stopLoading(arg0);
                return uRL2;
            }
            uRL = super.findResource(arg0);
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.stopLoading(arg0);
            throw throwable;
        }
        Object var5_8 = null;
        this.stopLoading(arg0);
        return uRL;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Enumeration findResources(String arg0) throws IOException {
        Enumeration<URL> enumeration;
        if (!this.startLoading(arg0)) {
            return null;
        }
        try {
            block4: {
                Enumeration<URL> result;
                ArrayList toConsult = this.findClassLoaders();
                Iterator loaders = toConsult.iterator();
                do {
                    if (!loaders.hasNext()) break block4;
                } while ((result = ((ClassLoader)loaders.next()).getResources(arg0)) == null || !result.hasMoreElements());
                Enumeration<URL> enumeration2 = result;
                Object var5_7 = null;
                this.stopLoading(arg0);
                return enumeration2;
            }
            enumeration = super.findResources(arg0);
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.stopLoading(arg0);
            throw throwable;
        }
        Object var5_8 = null;
        this.stopLoading(arg0);
        return enumeration;
    }

    private static final class Finder
    extends SecurityManager {
        private Finder() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

