/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;

public class CustomAndExpression
extends Expression {
    protected List fExpressions;

    public CustomAndExpression(IConfigurationElement element) {
        Assert.isNotNull((Object)element);
        IConfigurationElement[] children = element.getChildren();
        if (children.length > 0) {
            this.fExpressions = new ArrayList();
        }
        int i = 0;
        while (i < children.length) {
            try {
                this.fExpressions.add(ElementHandler.getDefault().create(ExpressionConverter.getDefault(), children[i]));
            }
            catch (CoreException ce) {
                NavigatorPlugin.log(4, 0, ce.getMessage(), ce);
            }
            ++i;
        }
    }

    public EvaluationResult evaluate(IEvaluationContext scope) throws CoreException {
        if (this.fExpressions == null) {
            return EvaluationResult.TRUE;
        }
        EvaluationResult result = EvaluationResult.TRUE;
        Iterator iter = this.fExpressions.iterator();
        while (iter.hasNext()) {
            Expression expression = (Expression)iter.next();
            if ((result = result.and(expression.evaluate(scope))) != EvaluationResult.FALSE) continue;
            return result;
        }
        return result;
    }
}

