/*
 * Decompiled with CFR 0.152.
 */
package org.python.posix;

import com.sun.jna.FromNativeContext;
import com.sun.jna.Pointer;
import java.io.FileDescriptor;
import org.python.posix.BaseNativePOSIX;
import org.python.posix.FileStat;
import org.python.posix.LibC;
import org.python.posix.Linux64HeapFileStat;
import org.python.posix.LinuxHeapFileStat;
import org.python.posix.LinuxLibC;
import org.python.posix.LinuxPasswd;
import org.python.posix.POSIX;
import org.python.posix.POSIXHandler;
import org.python.posix.util.Platform;

public final class LinuxPOSIX
extends BaseNativePOSIX {
    private final boolean hasFxstat;
    private final boolean hasLxstat;
    private final boolean hasXstat;
    private final boolean hasFstat;
    private final boolean hasLstat;
    private final boolean hasStat;
    private final int statVersion = Platform.IS_32_BIT ? 3 : 0;
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public Object fromNative(Object arg, FromNativeContext ctx) {
            return arg != null ? new LinuxPasswd((Pointer)arg) : null;
        }
    };

    public LinuxPOSIX(String libraryName, LibC libc, POSIXHandler handler) {
        super(libraryName, libc, handler);
        this.hasFxstat = this.hasMethod("__fxstat64");
        this.hasLxstat = this.hasMethod("__lxstat64");
        this.hasXstat = this.hasMethod("__xstat64");
        this.hasFstat = !this.hasFxstat && this.hasMethod("fstat64");
        this.hasLstat = !this.hasLxstat && this.hasMethod("lstat64");
        this.hasStat = !this.hasXstat && this.hasMethod("stat64");
    }

    public FileStat allocateStat() {
        if (Platform.IS_32_BIT) {
            return new LinuxHeapFileStat(this);
        }
        return new Linux64HeapFileStat(this);
    }

    public FileStat fstat(FileDescriptor fileDescriptor) {
        if (!this.hasFxstat) {
            if (this.hasFstat) {
                return super.fstat(fileDescriptor);
            }
            this.handler.unimplementedError("fstat");
        }
        FileStat stat = this.allocateStat();
        int fd = this.helper.getfd(fileDescriptor);
        if (((LinuxLibC)this.libc).__fxstat64(this.statVersion, fd, stat) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, "" + fd);
        }
        return stat;
    }

    public FileStat lstat(String path) {
        FileStat stat;
        if (!this.hasLxstat) {
            if (this.hasLstat) {
                return super.lstat(path);
            }
            this.handler.unimplementedError("lstat");
        }
        if (((LinuxLibC)this.libc).__lxstat64(this.statVersion, path, stat = this.allocateStat()) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, path);
        }
        return stat;
    }

    public FileStat stat(String path) {
        FileStat stat;
        if (!this.hasXstat) {
            if (this.hasStat) {
                return super.stat(path);
            }
            this.handler.unimplementedError("stat");
        }
        if (((LinuxLibC)this.libc).__xstat64(this.statVersion, path, stat = this.allocateStat()) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, path);
        }
        return stat;
    }
}

