/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.branch.BranchScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.command.edit.EditScmResult;
import org.apache.maven.scm.command.export.ExportScmResult;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.command.unedit.UnEditScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.ScmUrlUtils;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.scm.repository.UnknownRepositoryStructure;

public abstract class AbstractScmManager
implements ScmManager {
    private Map scmProviders = new HashMap();
    private ScmLogger logger;
    private Map userProviderTypes = new HashMap();

    protected void setScmProviders(Map providers) {
        this.scmProviders = providers;
    }

    protected void addScmProvider(String providerType, ScmProvider provider) {
        this.setScmProvider(providerType, provider);
    }

    public void setScmProvider(String providerType, ScmProvider provider) {
        this.scmProviders.put(providerType, provider);
    }

    protected abstract ScmLogger getScmLogger();

    public ScmProvider getProviderByUrl(String scmUrl) throws ScmRepositoryException, NoSuchScmProviderException {
        if (scmUrl == null) {
            throw new NullPointerException("The scm url cannot be null.");
        }
        String providerType = ScmUrlUtils.getProvider(scmUrl);
        return this.getProviderByType(providerType);
    }

    public void setScmProviderImplementation(String providerType, String providerImplementation) {
        this.userProviderTypes.put(providerType, providerImplementation);
    }

    public ScmProvider getProviderByType(String providerType) throws NoSuchScmProviderException {
        ScmProvider scmProvider;
        String usedProviderType;
        if (this.logger == null) {
            this.logger = this.getScmLogger();
            Iterator i = this.scmProviders.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                ScmProvider p = (ScmProvider)this.scmProviders.get(key);
                p.addListener(this.logger);
            }
        }
        if ((usedProviderType = System.getProperty("maven.scm.provider." + providerType + ".implementation")) == null) {
            usedProviderType = this.userProviderTypes.containsKey(providerType) ? (String)this.userProviderTypes.get(providerType) : providerType;
        }
        if ((scmProvider = (ScmProvider)this.scmProviders.get(usedProviderType)) == null) {
            throw new NoSuchScmProviderException(usedProviderType);
        }
        return scmProvider;
    }

    public ScmProvider getProviderByRepository(ScmRepository repository) throws NoSuchScmProviderException {
        return this.getProviderByType(repository.getProvider());
    }

    public ScmRepository makeScmRepository(String scmUrl) throws ScmRepositoryException, NoSuchScmProviderException {
        if (scmUrl == null) {
            throw new NullPointerException("The scm url cannot be null.");
        }
        char delimiter = ScmUrlUtils.getDelimiter(scmUrl).charAt(0);
        String providerType = ScmUrlUtils.getProvider(scmUrl);
        ScmProvider provider = this.getProviderByType(providerType);
        String scmSpecificUrl = this.cleanScmUrl(scmUrl.substring(providerType.length() + 5));
        ScmProviderRepository providerRepository = provider.makeProviderScmRepository(scmSpecificUrl, delimiter);
        return new ScmRepository(providerType, providerRepository);
    }

    protected String cleanScmUrl(String scmUrl) {
        if (scmUrl == null) {
            throw new NullPointerException("The scm url cannot be null.");
        }
        String pathSeparator = "";
        int indexOfDoubleDot = -1;
        if (scmUrl.indexOf("../") > 1) {
            pathSeparator = "/";
            indexOfDoubleDot = scmUrl.indexOf("../");
        }
        if (scmUrl.indexOf("..\\") > 1) {
            pathSeparator = "\\";
            indexOfDoubleDot = scmUrl.indexOf("..\\");
        }
        if (indexOfDoubleDot > 1) {
            int startOfTextToRemove = scmUrl.substring(0, indexOfDoubleDot - 1).lastIndexOf(pathSeparator);
            String beginUrl = "";
            if (startOfTextToRemove >= 0) {
                beginUrl = scmUrl.substring(0, startOfTextToRemove);
            }
            String endUrl = scmUrl.substring(indexOfDoubleDot + 3);
            scmUrl = beginUrl + pathSeparator + endUrl;
            if (scmUrl.indexOf("../") > 1 || scmUrl.indexOf("..\\") > 1) {
                scmUrl = this.cleanScmUrl(scmUrl);
            }
        }
        return scmUrl;
    }

    public ScmRepository makeProviderScmRepository(String providerType, File path) throws ScmRepositoryException, UnknownRepositoryStructure, NoSuchScmProviderException {
        if (providerType == null) {
            throw new NullPointerException("The provider type cannot be null.");
        }
        ScmProvider provider = this.getProviderByType(providerType);
        ScmProviderRepository providerRepository = provider.makeProviderScmRepository(path);
        return new ScmRepository(providerType, providerRepository);
    }

    public List validateScmRepository(String scmUrl) {
        ScmProvider provider;
        ArrayList<String> messages = new ArrayList<String>();
        messages.addAll(ScmUrlUtils.validate(scmUrl));
        String providerType = ScmUrlUtils.getProvider(scmUrl);
        try {
            provider = this.getProviderByType(providerType);
        }
        catch (NoSuchScmProviderException e) {
            messages.add("No such provider installed '" + providerType + "'.");
            return messages;
        }
        String scmSpecificUrl = this.cleanScmUrl(scmUrl.substring(providerType.length() + 5));
        List providerMessages = provider.validateScmUrl(scmSpecificUrl, ScmUrlUtils.getDelimiter(scmUrl).charAt(0));
        if (providerMessages == null) {
            throw new RuntimeException("The SCM provider cannot return null from validateScmUrl().");
        }
        messages.addAll(providerMessages);
        return messages;
    }

    public AddScmResult add(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        return this.getProviderByRepository(repository).add(repository, fileSet);
    }

    public AddScmResult add(ScmRepository repository, ScmFileSet fileSet, String message) throws ScmException {
        return this.getProviderByRepository(repository).add(repository, fileSet, message);
    }

    public BranchScmResult branch(ScmRepository repository, ScmFileSet fileSet, String branchName) throws ScmException {
        return this.getProviderByRepository(repository).branch(repository, fileSet, branchName);
    }

    public BranchScmResult branch(ScmRepository repository, ScmFileSet fileSet, String branchName, String message) throws ScmException {
        return this.getProviderByRepository(repository).branch(repository, fileSet, branchName, message);
    }

    public ChangeLogScmResult changeLog(ScmRepository repository, ScmFileSet fileSet, Date startDate, Date endDate, int numDays, ScmBranch branch) throws ScmException {
        return this.getProviderByRepository(repository).changeLog(repository, fileSet, startDate, endDate, numDays, branch);
    }

    public ChangeLogScmResult changeLog(ScmRepository repository, ScmFileSet fileSet, Date startDate, Date endDate, int numDays, ScmBranch branch, String datePattern) throws ScmException {
        return this.getProviderByRepository(repository).changeLog(repository, fileSet, startDate, endDate, numDays, branch, datePattern);
    }

    public ChangeLogScmResult changeLog(ScmRepository repository, ScmFileSet fileSet, ScmVersion startVersion, ScmVersion endVersion) throws ScmException {
        return this.getProviderByRepository(repository).changeLog(repository, fileSet, startVersion, endVersion);
    }

    public ChangeLogScmResult changeLog(ScmRepository repository, ScmFileSet fileSet, ScmVersion startRevision, ScmVersion endRevision, String datePattern) throws ScmException {
        return this.getProviderByRepository(repository).changeLog(repository, fileSet, startRevision, endRevision, datePattern);
    }

    public CheckInScmResult checkIn(ScmRepository repository, ScmFileSet fileSet, String message) throws ScmException {
        return this.getProviderByRepository(repository).checkIn(repository, fileSet, message);
    }

    public CheckInScmResult checkIn(ScmRepository repository, ScmFileSet fileSet, ScmVersion revision, String message) throws ScmException {
        return this.getProviderByRepository(repository).checkIn(repository, fileSet, revision, message);
    }

    public CheckOutScmResult checkOut(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        return this.getProviderByRepository(repository).checkOut(repository, fileSet);
    }

    public CheckOutScmResult checkOut(ScmRepository repository, ScmFileSet fileSet, ScmVersion version) throws ScmException {
        return this.getProviderByRepository(repository).checkOut(repository, fileSet, version);
    }

    public CheckOutScmResult checkOut(ScmRepository repository, ScmFileSet fileSet, boolean recursive) throws ScmException {
        return this.getProviderByRepository(repository).checkOut(repository, fileSet, recursive);
    }

    public CheckOutScmResult checkOut(ScmRepository repository, ScmFileSet fileSet, ScmVersion version, boolean recursive) throws ScmException {
        return this.getProviderByRepository(repository).checkOut(repository, fileSet, version, recursive);
    }

    public DiffScmResult diff(ScmRepository repository, ScmFileSet fileSet, ScmVersion startVersion, ScmVersion endVersion) throws ScmException {
        return this.getProviderByRepository(repository).diff(repository, fileSet, startVersion, endVersion);
    }

    public EditScmResult edit(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        return this.getProviderByRepository(repository).edit(repository, fileSet);
    }

    public ExportScmResult export(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        return this.getProviderByRepository(repository).export(repository, fileSet);
    }

    public ExportScmResult export(ScmRepository repository, ScmFileSet fileSet, ScmVersion version) throws ScmException {
        return this.getProviderByRepository(repository).export(repository, fileSet, version);
    }

    public ExportScmResult export(ScmRepository repository, ScmFileSet fileSet, String outputDirectory) throws ScmException {
        return this.getProviderByRepository(repository).export(repository, fileSet, (ScmVersion)null, outputDirectory);
    }

    public ExportScmResult export(ScmRepository repository, ScmFileSet fileSet, ScmVersion version, String outputDirectory) throws ScmException {
        return this.getProviderByRepository(repository).export(repository, fileSet, version, outputDirectory);
    }

    public ListScmResult list(ScmRepository repository, ScmFileSet fileSet, boolean recursive, ScmVersion version) throws ScmException {
        return this.getProviderByRepository(repository).list(repository, fileSet, recursive, version);
    }

    public RemoveScmResult remove(ScmRepository repository, ScmFileSet fileSet, String message) throws ScmException {
        return this.getProviderByRepository(repository).remove(repository, fileSet, message);
    }

    public StatusScmResult status(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        return this.getProviderByRepository(repository).status(repository, fileSet);
    }

    public TagScmResult tag(ScmRepository repository, ScmFileSet fileSet, String tagName) throws ScmException {
        return this.getProviderByRepository(repository).tag(repository, fileSet, tagName);
    }

    public TagScmResult tag(ScmRepository repository, ScmFileSet fileSet, String tagName, String message) throws ScmException {
        return this.getProviderByRepository(repository).tag(repository, fileSet, tagName, message);
    }

    public UnEditScmResult unedit(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        return this.getProviderByRepository(repository).unedit(repository, fileSet);
    }

    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        return this.getProviderByRepository(repository).update(repository, fileSet);
    }

    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, ScmVersion version) throws ScmException {
        return this.getProviderByRepository(repository).update(repository, fileSet, version);
    }

    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, boolean runChangelog) throws ScmException {
        return this.getProviderByRepository(repository).update(repository, fileSet, runChangelog);
    }

    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, ScmVersion version, boolean runChangelog) throws ScmException {
        return this.getProviderByRepository(repository).update(repository, fileSet, version, runChangelog);
    }

    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, String datePattern) throws ScmException {
        return this.getProviderByRepository(repository).update(repository, fileSet, (ScmVersion)null, datePattern);
    }

    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, ScmVersion version, String datePattern) throws ScmException {
        return this.getProviderByRepository(repository).update(repository, fileSet, version, datePattern);
    }

    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, Date lastUpdate) throws ScmException {
        return this.getProviderByRepository(repository).update(repository, fileSet, (ScmVersion)null, lastUpdate);
    }

    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, ScmVersion version, Date lastUpdate) throws ScmException {
        return this.getProviderByRepository(repository).update(repository, fileSet, version, lastUpdate);
    }

    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, Date lastUpdate, String datePattern) throws ScmException {
        return this.getProviderByRepository(repository).update(repository, fileSet, (ScmVersion)null, lastUpdate, datePattern);
    }

    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, ScmVersion version, Date lastUpdate, String datePattern) throws ScmException {
        return this.getProviderByRepository(repository).update(repository, fileSet, version, lastUpdate, datePattern);
    }
}

