/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.sbs;

import com.nokia.ant.types.SBSMakeOptions;
import com.nokia.ant.types.Variable;
import com.nokia.ant.types.VariableSet;
import com.nokia.tools.Tool;
import com.nokia.tools.ToolsProcessException;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SBSTool
implements Tool {
    private final String prefix = "--mo=";
    private final String equalSign = "=";
    private Logger log = Logger.getLogger(SBSTool.class);
    private String layers;
    private String config;
    private String skipBuild;
    private String singleJob;
    private String layerOrder;
    private String components;
    private String command;
    private String varName;
    private String sysdefBase;
    private String enableFilter;
    private String checkOption;
    private String whatOption;
    private String retryOption;
    private SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    private Date startTime;
    private Date endTime;

    @Override
    public void execute(VariableSet varSet, Project prj) throws ToolsProcessException {
        this.layers = null;
        this.config = null;
        this.skipBuild = null;
        this.singleJob = null;
        this.layerOrder = null;
        this.components = null;
        this.command = null;
        this.varName = null;
        String value = null;
        this.sysdefBase = null;
        this.enableFilter = null;
        this.checkOption = null;
        this.whatOption = null;
        this.retryOption = null;
        Vector configSet = varSet.getVariables();
        this.log.debug((Object)("SBSTool:configSet.size:" + configSet.size()));
        Enumeration e = configSet.elements();
        while (e.hasMoreElements()) {
            Variable variable = (Variable)((Object)e.nextElement());
            this.varName = variable.getName();
            value = variable.getValue();
            this.log.debug((Object)("SBSTool:varName:" + this.varName));
            this.log.debug((Object)("SBSTool:value:" + value));
            if (this.varName.equals("layers")) {
                this.layers = value;
                continue;
            }
            if (this.varName.equals("config")) {
                this.config = value;
                continue;
            }
            if (this.varName.equals("skipbuild")) {
                this.skipBuild = value;
                continue;
            }
            if (this.varName.equals("singlejob")) {
                this.singleJob = value;
                continue;
            }
            if (this.varName.equals("layer-order")) {
                this.layerOrder = value;
                continue;
            }
            if (this.varName.equals("command")) {
                this.command = value;
                continue;
            }
            if (this.varName.equals("components")) {
                this.components = value;
                continue;
            }
            if (this.varName.equals("sysdef-base")) {
                this.sysdefBase = value;
                continue;
            }
            if (this.varName.equals("enable-filter")) {
                this.enableFilter = value;
                continue;
            }
            if (this.varName.equals("run-check")) {
                this.checkOption = value;
                continue;
            }
            if (this.varName.equals("run-what")) {
                this.whatOption = value;
                continue;
            }
            if (!this.varName.equals("retry-limit")) continue;
            this.retryOption = value;
        }
        this.execTask(prj);
    }

    public void execute(HashMap attributes, Project project) throws ToolsProcessException {
        this.layers = null;
        this.config = null;
        this.skipBuild = null;
        this.singleJob = null;
        this.layerOrder = null;
        this.command = null;
        this.components = null;
        this.sysdefBase = null;
        this.enableFilter = null;
        this.retryOption = null;
        String value = (String)attributes.get("layers");
        if (value != null) {
            this.layers = value;
            System.out.println("layers:" + value);
        }
        if ((value = (String)attributes.get("config")) != null) {
            this.config = value;
            System.out.println("config:" + value);
        }
        if ((value = (String)attributes.get("skipbuild")) != null) {
            this.skipBuild = value;
            System.out.println("skipbuild:" + value);
        }
        if ((value = (String)attributes.get("singlejob")) != null) {
            this.singleJob = value;
            System.out.println("singlejob:" + value);
        }
        if ((value = (String)attributes.get("layer-order")) != null) {
            this.layerOrder = value;
            System.out.println("layer-order:" + value);
        }
        if ((value = (String)attributes.get("command")) != null) {
            this.command = value;
            System.out.println("command:" + value);
        }
        if ((value = (String)attributes.get("components")) != null) {
            this.components = value;
        }
        if ((value = (String)attributes.get("sysdef-base")) != null) {
            this.sysdefBase = value;
        }
        if ((value = (String)attributes.get("enable-filter")) != null) {
            this.enableFilter = value;
        } else if (this.varName.equals("retry")) {
            this.retryOption = value;
        }
        this.execTask(project);
    }

    public void execTask(Project prj) throws ToolsProcessException {
        this.log.info((Object)"SBSTask:executing for SBS task");
        String partialLogPath = prj.getProperty("build.log.dir") + "/" + prj.getProperty("build.id");
        String sysdefConfig = prj.getProperty("sysdef.configuration");
        String sbsLogName = "";
        ExecTask task = new ExecTask();
        task.setTaskName("sbs");
        String osType = System.getProperty("os.name");
        this.log.debug((Object)("SBSTask:ostype:" + osType));
        if (osType.toLowerCase().startsWith("win")) {
            task.setExecutable("sbs.bat");
        } else {
            task.setExecutable("sbs");
        }
        task.setFailonerror(true);
        task.setDir(new File(prj.getProperty("build.drive") + "/"));
        this.log.debug((Object)("SBSTask:root dir:" + prj.getProperty("build.drive") + "/"));
        task.createArg().setValue("-s");
        String sysdefFile = prj.getProperty("build.output.dir") + "/build/canonical_system_definition_" + sysdefConfig + ".xml";
        task.createArg().setValue(sysdefFile);
        if (this.layerOrder != null) {
            task.createArg().setValue("-o");
        }
        task.createArg().setValue("-k");
        sbsLogName = sbsLogName + this.setLayerArgs(task);
        sbsLogName = sbsLogName + this.setConfigArgs(task);
        Object makeOptReference = prj.getReference("sbs.internal.make.options");
        sbsLogName = sbsLogName + this.updateSBSMakeOptions(makeOptReference, prj, task);
        if (this.skipBuild != null) {
            this.log.debug((Object)("SBSTask:makeOptions.skipping build:" + this.skipBuild));
            sbsLogName = sbsLogName + "_nobuild";
            if (this.skipBuild.equals("true")) {
                task.createArg().setValue("-n");
            }
        }
        if (this.command != null) {
            this.log.debug((Object)("SBSTask:command:" + this.command));
            sbsLogName = sbsLogName + this.command;
            task.createArg().setValue(this.command);
        }
        if (this.sysdefBase != null) {
            this.log.debug((Object)("SBSTask:sysdefBase:" + this.sysdefBase));
            task.createArg().setValue("-a");
            task.createArg().setValue(this.sysdefBase);
        }
        String logFileName = partialLogPath + "." + sysdefConfig + "_compile.log";
        sbsLogName = this.convertSpecialCharacters(sbsLogName);
        String tempPath = partialLogPath + "_" + sbsLogName + "_" + sysdefConfig;
        task.createArg().setValue("-m");
        task.createArg().setValue(tempPath + "_Makefile");
        String additionalFilters = "";
        if (this.whatOption != null && this.whatOption.equals("true")) {
            task.createArg().setValue("--what");
        }
        if (this.checkOption != null && this.checkOption.equals("true")) {
            task.createArg().setValue("--check");
        }
        task.createArg().setValue("--filters=FilterMetadataLog" + additionalFilters);
        String sbsStatsFile = partialLogPath + "." + sysdefConfig + "_sbs_info.xml";
        if (this.retryOption != null) {
            this.log.debug((Object)"building with retry:");
            task.createArg().setValue("--tries");
            task.createArg().setValue(this.retryOption);
        }
        task.createArg().setValue("-f");
        task.createArg().setValue(tempPath + "_compile.log");
        String outputFileName = tempPath + ".sbs_ant_output.log";
        this.log.debug((Object)("SBSTask:outputfilename:" + outputFileName));
        this.log.debug((Object)("SBSTask:sbsLogName:" + sbsLogName));
        task.setOutput(new File(outputFileName));
        this.startTime = new Date();
        try {
            task.execute();
        }
        catch (Exception ex) {
            this.log.debug((Object)"Warning: exception during executing sbs task", (Throwable)ex);
        }
        try {
            this.log.debug((Object)("SBSTask:sbs.log.file:" + tempPath + "_compile.log"));
            prj.setProperty("sbs.log.file", tempPath + "_compile.log");
        }
        catch (Exception e) {
            this.log.debug((Object)"SBSTask:sysdefBase:copying the log file with sbs config failed");
        }
        this.endTime = new Date();
        this.updateSBSLogStatistics(sbsStatsFile, tempPath + "_compile.log");
    }

    private String updateSBSMakeOptions(Object makeOptReference, Project prj, ExecTask task) {
        Object makeOptObject;
        String retValue = "";
        if (makeOptReference != null && makeOptReference instanceof SBSMakeOptions && (makeOptObject = ((SBSMakeOptions)((Object)makeOptReference)).getRefid().getReferencedObject()) != null && makeOptObject instanceof SBSMakeOptions) {
            this.log.debug((Object)"SBSTask:makeOptReference: not null");
            SBSMakeOptions sbsMakeOptions = (SBSMakeOptions)((Object)makeOptObject);
            String engine = sbsMakeOptions.getEngine();
            this.log.info((Object)("SBSTask:with engine:" + engine));
            if (engine != null && engine.equals("emake")) {
                this.emake(task, sbsMakeOptions, prj);
            } else if (engine != null && engine.equals("gmake")) {
                retValue = retValue + this.gmake(task, prj);
            }
        }
        return retValue;
    }

    private void updateSBSLogStatistics(String infoFileName, String logFileName) {
        try {
            DocumentBuilderFactory sbsInfo = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = sbsInfo.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element root = doc.createElement("sbsinfo");
            doc.appendChild(root);
            Element child = doc.createElement("logfile");
            child.setAttribute("name", logFileName);
            root.appendChild(child);
            child = doc.createElement("duration");
            child.setAttribute("time", this.timeFormat.format(new Date(this.endTime.getTime() - this.startTime.getTime())));
            root.appendChild(child);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            FileWriter sbsWriter = new FileWriter(infoFileName);
            StreamResult result = new StreamResult(sbsWriter);
            DOMSource sbsSource = new DOMSource(doc);
            transformer.transform(sbsSource, result);
        }
        catch (Exception ex) {
            this.log.debug((Object)"exception while xml writing sbs log info", (Throwable)ex);
        }
    }

    private String setLayerArgs(ExecTask task) {
        String logName = "";
        if (this.layers != null) {
            String[] lList = this.layers.split(",");
            for (int i = 0; i < lList.length; ++i) {
                this.log.debug((Object)("SBSTask:llist:" + lList[i]));
                logName = logName + "_" + lList[i];
                task.createArg().setValue("-l");
                task.createArg().setValue(lList[i]);
            }
        }
        return logName;
    }

    private String setConfigArgs(ExecTask task) {
        String logName = "";
        if (this.config != null) {
            String[] configList = this.config.split(",");
            for (int i = 0; i < configList.length; ++i) {
                logName = logName + "_" + configList[i];
                task.createArg().setValue("-c");
                task.createArg().setValue(configList[i]);
            }
        }
        return logName;
    }

    private String gmake(ExecTask task, Project prj) {
        this.log.info((Object)"SBSTask:normal gmake");
        if (this.singleJob == null) {
            this.log.debug((Object)"SBSTask:building using multiple thread");
            task.createArg().setValue("-j");
            task.createArg().setValue(prj.getProperty("number.of.threads"));
            return "_multiple_thread";
        }
        if (this.singleJob.equals("true")) {
            task.createArg().setValue("-j");
            task.createArg().setValue("1");
            return "_single_thread";
        }
        return "";
    }

    private void emake(ExecTask task, SBSMakeOptions sbsMakeOptions, Project prj) {
        HashMap<String, String> makeOptMap = new HashMap<String, String>();
        Vector makeOptions = sbsMakeOptions.getVariables();
        Enumeration makeOptEnum = makeOptions.elements();
        Variable variable = null;
        while (makeOptEnum.hasMoreElements()) {
            variable = (Variable)((Object)makeOptEnum.nextElement());
            this.log.debug((Object)("SBSTask:makeOptions.variable-name:" + variable.getName()));
            this.log.debug((Object)("SBSTask:makeOptions.variable-name:" + variable.getValue()));
            makeOptMap.put(variable.getName(), variable.getValue());
        }
        this.updatedMakeOptions(sbsMakeOptions.getEngine(), makeOptMap, prj);
        this.log.info((Object)"SBSTask:updating all make options");
        String makeOpt2 = null;
        task.createArg().setValue("-e");
        task.createArg().setValue("emake");
        Set keys = makeOptMap.keySet();
        for (String makeOpt2 : keys) {
            String param = "--mo=" + makeOpt2;
            String paramValue = (String)makeOptMap.get(makeOpt2);
            if (paramValue != null) {
                param = param + "=" + paramValue;
            }
            task.createArg().setValue(param);
            this.log.debug((Object)("SBSTask:makeOptions.variable-name:" + param));
        }
    }

    private void updatedMakeOptions(String engine, HashMap makeOptsMap, Project prj) {
        this.log.info((Object)"Updating default make options along with passed options");
        if (engine.equals("emake")) {
            if (makeOptsMap.get("--emake-root") == null) {
                String emakeRoot = prj.getProperty("env.EMAKE_ROOT") + ";" + prj.getProperty("helium.dir") + ";" + prj.getProperty("build.drive") + "/;" + prj.getProperty("env.SBS_HOME");
                makeOptsMap.put("--emake-root", emakeRoot);
                this.log.debug((Object)("SBSTask:adding --emake-root:" + emakeRoot));
            }
            if (makeOptsMap.get("--emake-annodetail") == null) {
                this.log.debug((Object)"SBSTask:adding --emake-annodetail:");
                makeOptsMap.put("--emake-annodetail", "basic,history,waiting");
            }
            if (makeOptsMap.get("--emake-historyfile") == null) {
                this.log.debug((Object)"SBSTask:adding --emake-historyfile");
                String emakeHistoryDIR = prj.getProperty("build.log.dir") + "/ec_history/";
                File emakeHistoryDIRFile = new File(emakeHistoryDIR);
                if (!emakeHistoryDIRFile.exists()) {
                    boolean successus = emakeHistoryDIRFile.mkdir();
                    this.log.debug((Object)("SBSTask:history dir created status :" + emakeHistoryDIRFile + ":" + successus));
                }
                String emakeHistoryFile = emakeHistoryDIR + "emake_" + prj.getProperty("sysdef.configuration") + ".data";
                makeOptsMap.put("--emake-historyfile", emakeHistoryFile);
                this.log.debug((Object)("SBSTask:adding --emake-historyfile" + emakeHistoryFile));
            }
            if (makeOptsMap.get("--emake-annofile") == null) {
                this.log.debug((Object)"SBSTask:adding --emake-annofile");
                String annofile = prj.getProperty("build.log.dir") + "/" + prj.getProperty("build.id") + ".xml";
                makeOptsMap.put("--emake-annofile", annofile);
                this.log.debug((Object)("SBSTask:adding --emake-annofile" + annofile));
            }
            if (makeOptsMap.get("--emake-emulation") == null) {
                makeOptsMap.put("--emake-emulation", "gmake");
                this.log.debug((Object)"SBSTask:adding --emake-emulation:gmake");
            }
        }
    }

    private String convertSpecialCharacters(String inputFileName) {
        String resultString;
        int colonIndex = 0;
        colonIndex = inputFileName.indexOf(58);
        if (colonIndex != -1 && inputFileName.substring(0, colonIndex + 2).endsWith(":\\")) {
            resultString = inputFileName.substring(0, colonIndex + 2);
            String remainingString = inputFileName.substring(colonIndex + 2);
            remainingString = remainingString.replaceAll(":", "_");
            resultString = resultString + remainingString;
        } else {
            resultString = inputFileName.replaceAll(":", "_");
        }
        return resultString;
    }
}

