/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.metadata.db;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;

public class MetaDataDb {
    private static Logger log = Logger.getLogger(MetaDataDb.class);
    private static final String DRIVER_CLASS_NAME = "org.sqlite.JDBC";
    private static final String URL_PREFIX = "jdbc:sqlite:/";
    private static final int LOG_ENTRY_CACHE_LIMIT = 500;
    private static final String[] INIT_TABLES = new String[]{"CREATE TABLE metadata (priority_id INTEGER, component_id INTEGER, line_number INTEGER, data TEXT, logpath_id INTEGER)", "CREATE TABLE component (id INTEGER PRIMARY KEY,component TEXT, logPath_id INTEGER, UNIQUE (logPath_id,component))", "CREATE TABLE priority (id INTEGER PRIMARY KEY,priority TEXT)", "CREATE TABLE logfiles (id INTEGER PRIMARY KEY, path TEXT)"};
    private static final String INSERT_METADATA_ENTRY = "INSERT INTO metadata VALUES(?, ?, ?, ?, ?)";
    private static final String INSERT_LOGENTRY = "INSERT or IGNORE INTO logfiles VALUES(?, ?)";
    private static final String INSERT_PRIORITYENTRY = "INSERT INTO priority VALUES(?, ?)";
    private static final String INSERT_COMPONENTENTRY = "INSERT or IGNORE INTO component VALUES((SELECT max(id) FROM component)+1, ?, ?) ";
    private String dbPath;
    private String url;
    private boolean statementsInitialized;
    private Connection connection;
    private Connection readConnection;
    private PreparedStatement insertMetaDataEntryStmt;
    private PreparedStatement insertLogEntryStmt;
    private PreparedStatement insertComponentStmt;
    private int entryCacheSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaDataDb(String databasePath) {
        this.dbPath = databasePath;
        this.url = URL_PREFIX + this.dbPath;
        try {
            Class.forName(DRIVER_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)"No JDBC Driver found");
            throw new BuildException("JDBC Driver could not be found");
        }
        Class<MetaDataDb> clazz = MetaDataDb.class;
        synchronized (MetaDataDb.class) {
            boolean initializeDatabase = false;
            if (!new File(this.dbPath).exists()) {
                initializeDatabase = true;
            }
            try {
                this.initializeConnection();
                this.connection.setAutoCommit(false);
                if (initializeDatabase) {
                    Statement statement = this.connection.createStatement();
                    for (int i = 0; i < INIT_TABLES.length; ++i) {
                        statement.addBatch(INIT_TABLES[i]);
                    }
                    Priority[] priorityValues = Priority.values();
                    for (int i = 0; i < priorityValues.length; ++i) {
                        statement.addBatch("INSERT INTO priority (priority) VALUES (\"" + (Object)((Object)priorityValues[i]) + "\")");
                    }
                    statement.addBatch("create unique index logfile_unique_1 on logfiles (path)");
                    int[] returnCodes = statement.executeBatch();
                    this.connection.commit();
                    this.connection.setAutoCommit(false);
                    statement.close();
                    this.finalizeConnection();
                }
            }
            catch (SQLException e) {
                log.debug((Object)"problem initializing database", (Throwable)e);
                throw new BuildException("Problem initializing database");
            }
            return;
        }
    }

    public void initializeConnection() throws SQLException {
        new File(this.dbPath).getParentFile().mkdirs();
        this.connection = DriverManager.getConnection(this.url);
    }

    public void finalizeStatements() throws SQLException {
        if (this.statementsInitialized) {
            if (this.entryCacheSize > 0) {
                this.entryCacheSize = 0;
                this.writeLogDataToDB();
            }
            this.insertLogEntryStmt.close();
            this.insertComponentStmt.close();
            this.insertMetaDataEntryStmt.close();
        }
    }

    private void finalizeConnection() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeDB() {
        try {
            Class<MetaDataDb> clazz = MetaDataDb.class;
            synchronized (MetaDataDb.class) {
                this.finalizeStatements();
                this.finalizeConnection();
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (SQLException ex) {
            log.debug((Object)"exception while finalizing the db", (Throwable)ex);
        }
        {
            return;
        }
    }

    public Map<String, List<String>> getIndexMap(String query) {
        HashMap<String, List<String>> indexMap = new HashMap<String, List<String>>();
        log.debug((Object)("sql query" + query));
        try {
            this.initializeConnection();
            Statement stmt = this.connection.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            int numberOfColumns = rsmd.getColumnCount();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    ArrayList<String> dataList = new ArrayList<String>();
                    String key = null;
                    for (int i = 1; i <= numberOfColumns; ++i) {
                        String data = null;
                        int type = rsmd.getColumnType(i);
                        data = type == 4 ? "" + rs.getInt(i) : rs.getString(i);
                        log.debug((Object)("data:" + data));
                        if (i == 1) {
                            key = data;
                            continue;
                        }
                        dataList.add(data);
                    }
                    indexMap.put(key, dataList);
                }
            }
            stmt.close();
            this.finalizeConnection();
        }
        catch (Exception ex) {
            log.debug((Object)"Warning: Exception while getting the index map", (Throwable)ex);
        }
        return indexMap;
    }

    public List<Map<String, Object>> getRecords(String query) {
        ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>();
        log.debug((Object)("sql query" + query));
        try {
            this.initializeConnection();
            Statement stmt = this.connection.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            int numberOfColumns = rsmd.getColumnCount();
            ArrayList<String> columnNames = new ArrayList<String>();
            for (int i = 1; i <= numberOfColumns; ++i) {
                columnNames.add(rsmd.getColumnName(i));
                log.debug((Object)("columnName:" + rsmd.getColumnName(i)));
            }
            log.debug((Object)("resultSet MetaData column Count=" + numberOfColumns));
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    HashMap<String, Object> recordMap = new HashMap<String, Object>();
                    log.debug((Object)"adding records");
                    for (int i = 1; i <= numberOfColumns; ++i) {
                        Object data;
                        int type = rsmd.getColumnType(i);
                        String columnName = (String)columnNames.get(i - 1);
                        if (type == 4) {
                            data = new Integer(rs.getInt(i));
                            recordMap.put(columnName, data);
                            log.debug((Object)("data:" + data));
                            continue;
                        }
                        data = rs.getString(i);
                        recordMap.put(columnName, data);
                        log.debug((Object)("data:" + (String)data));
                    }
                    rowList.add(recordMap);
                }
            }
            stmt.close();
            this.finalizeConnection();
        }
        catch (Exception ex) {
            log.debug((Object)"Warning: Exception while getting the record details", (Throwable)ex);
        }
        return rowList;
    }

    public List<Map<String, Object>> getRecords(String query, int recordLimit, int offsetValue) {
        String updatedQuery = query + " limit " + recordLimit + " offset " + offsetValue + ";";
        return this.getRecords(updatedQuery);
    }

    private void updateIndexTables(LogEntry entry) throws SQLException {
        this.connection.setAutoCommit(false);
        this.insertLogEntryStmt.setNull(1, 4);
        this.insertLogEntryStmt.setString(2, entry.getLogPath());
        this.insertLogEntryStmt.addBatch();
        this.insertLogEntryStmt.executeBatch();
        this.connection.commit();
        this.readConnection = DriverManager.getConnection(this.url);
        this.readConnection.setAutoCommit(false);
        Statement stmt = this.readConnection.createStatement();
        log.debug((Object)"exiting synchronization---2");
        ResultSet rs = stmt.executeQuery("select id from logfiles where path='" + entry.getLogPath().trim() + "'");
        int logPathId = 0;
        if (rs.next()) {
            logPathId = rs.getInt(1);
        }
        stmt.close();
        this.readConnection.close();
        log.debug((Object)"exiting synchronization---5");
        this.insertComponentStmt.setNull(1, 4);
        this.insertComponentStmt.setString(2, entry.getComponent());
        this.insertComponentStmt.setInt(3, logPathId);
        this.insertComponentStmt.addBatch();
        this.insertComponentStmt.executeBatch();
        this.connection.commit();
        this.insertLogEntryStmt.clearBatch();
        this.insertComponentStmt.clearBatch();
    }

    private void writeLogDataToDB() throws SQLException {
        this.insertMetaDataEntryStmt.executeBatch();
        this.connection.commit();
        this.insertMetaDataEntryStmt.clearBatch();
    }

    public void removeLog(String log) throws Exception {
        this.initializeConnection();
        Statement stmt = this.connection.createStatement();
        stmt.executeUpdate("DELETE FROM metadata WHERE logpath_id IN (SELECT id from metadata, logfiles WHERE logfiles.id=metadata.logpath_id and logfiles.path='" + log + "')");
        stmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogEntry(LogEntry entry) throws Exception {
        Class<MetaDataDb> clazz = MetaDataDb.class;
        synchronized (MetaDataDb.class) {
            try {
                if (!this.statementsInitialized) {
                    log.debug((Object)"initializing statements for JDBC");
                    this.initializeConnection();
                    this.insertMetaDataEntryStmt = this.connection.prepareStatement(INSERT_METADATA_ENTRY);
                    this.insertLogEntryStmt = this.connection.prepareStatement(INSERT_LOGENTRY);
                    this.insertComponentStmt = this.connection.prepareStatement("INSERT or IGNORE INTO component VALUES(?, ?, ?) ");
                    this.statementsInitialized = true;
                }
                log.debug((Object)("MetaDataDB:entry:priority: " + (Object)((Object)entry.getPriority())));
                this.connection.setAutoCommit(false);
                this.updateIndexTables(entry);
                if (entry.getPriority() != Priority.DEFAULT) {
                    this.readConnection = DriverManager.getConnection(this.url);
                    Statement stmt = this.readConnection.createStatement();
                    ResultSet rs = stmt.executeQuery("select id from logfiles where path='" + entry.getLogPath().trim() + "'");
                    int logPathId = 0;
                    if (rs.next()) {
                        logPathId = rs.getInt(1);
                    }
                    rs.close();
                    stmt.close();
                    this.insertMetaDataEntryStmt.setInt(5, logPathId);
                    stmt = this.readConnection.createStatement();
                    rs = stmt.executeQuery("select id from component where component='" + entry.getComponent() + "' and logpath_id='" + logPathId + "'");
                    int componentId = 0;
                    if (rs.next()) {
                        componentId = rs.getInt(1);
                    }
                    rs.close();
                    stmt.close();
                    this.readConnection.close();
                    this.insertMetaDataEntryStmt.setInt(1, entry.getPriority().getValue());
                    this.insertMetaDataEntryStmt.setInt(2, componentId);
                    this.insertMetaDataEntryStmt.setInt(3, entry.getLineNumber());
                    this.insertMetaDataEntryStmt.setString(4, entry.getText());
                    this.insertMetaDataEntryStmt.addBatch();
                    ++this.entryCacheSize;
                    if (this.entryCacheSize >= 500) {
                        log.debug((Object)"writing data to database");
                        this.writeLogDataToDB();
                        this.entryCacheSize = 0;
                    }
                }
            }
            catch (SQLException ex) {
                log.debug((Object)" Exception while writing the record");
                throw ex;
            }
            return;
        }
    }

    public static class LogEntry {
        private String text;
        private Priority priority;
        private String component;
        private int lineNumber;
        private String logPath;

        public LogEntry(String text, Priority priority, String component, String logPath, int lineNumber) {
            this.text = text;
            this.priority = priority;
            this.component = component;
            this.lineNumber = lineNumber;
            this.logPath = logPath;
        }

        public LogEntry(String text, String priorityTxt, String component, String logPath, int lineNumber) throws Exception {
            Priority prty = null;
            String prtyText = priorityTxt.trim().toLowerCase();
            if (prtyText.equals("error")) {
                prty = Priority.ERROR;
            } else if (prtyText.equals("warning")) {
                prty = Priority.WARNING;
            } else if (prtyText.equals("fatal")) {
                prty = Priority.FATAL;
            } else if (prtyText.equals("info")) {
                prty = Priority.INFO;
            } else if (prtyText.equals("remark")) {
                prty = Priority.REMARK;
            } else if (prtyText.equals("default")) {
                prty = Priority.DEFAULT;
            } else {
                log.debug((Object)("Error: priority " + prtyText + " is not acceptable by metadata and set to Error"));
                prty = Priority.ERROR;
            }
            this.logPath = logPath;
            this.text = text;
            this.priority = prty;
            this.component = component;
            this.lineNumber = lineNumber;
        }

        public String getLogPath() {
            return this.logPath;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public Priority getPriority() {
            return this.priority;
        }

        public void setPriority(Priority priority) {
            this.priority = priority;
        }

        public String getComponent() {
            return this.component;
        }

        public void setComponent(String component) {
            this.component = component;
        }
    }

    public static enum Priority {
        FATAL(1),
        ERROR(2),
        WARNING(3),
        INFO(4),
        REMARK(5),
        DEFAULT(6);

        private final int value;

        private Priority(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Priority getPriorityEnum(int i) {
            Priority[] values = Priority.values();
            return i >= 0 && i < values.length ? values[i] : FATAL;
        }
    }
}

